<?php

$suffix = ' per l\'ospite :customer_name, alloggio :tableau_number - :accommodation_name';
$roomReservationSuffix = ' nell\'alloggio :accommodation_name - prenotazione :reservation_booker - :reservation_reference_number';
$reservationSuffix = ' tra gli ospiti da inviare nella prenotazione :reservation_booker - :reservation_reference_number';
$customerReservationSuffix = ' :customer_name - :reservation_reference_number';
$customerEmptyDataSuffix = 'per l\'ospite :customer_name della prenotazione :reservation_reference_number';

return [

    'accommodations' => [
        'errors' => [
            'attachExist' => 'Piano Tariffario esistente',
            'detachNotExist' => 'Piano Tariffario non presente in questo alloggio',
            'detachStandardRateplan' => 'Non puoi eliminare il piano tariffario standard',
            'guestsCnfigurationBase' => 'Non puoi applicare sconti alla tariffa base',
            'virtualRidondanceConflict' => 'Non è possibile collegare questo alloggio. Un collegamento è già stato configurato',
            'parentTreeExist' => 'La stanza principale è già collegata o non puoi superare il ',
            'quantityZero' => 'Non puoi eliminare l\'ultima stanza disponibile',
            'quantityNotValid' => 'Stai inviando una quantità uguale o inferiore a quella esistente',
            'quantitySum' => 'La quantità di un ',
            'quantitySuperior' => 'Non puoi superare il numero di persone nella stanza principale',
            'quantityWithReservation' => 'Ci sono prenotazioni esistenti, non puoi eliminare questo numero di stanza',
            'numberNotAvail' => 'Numeri di stanza non disponibili',
            'guestsConfigurationBase' => 'Non puoi applicare uno sconto alla configurazione di base',
            'tooManyAdults' => 'Il numero di adulti supera il limite',
            'tooManyChildren' => 'Il numero di bambini supera il limite',
            'stillConnected' => 'Stanza ancora collegata a uno o più portali',
            'stillVirtual' => 'Stanza ancora collegata a un\'altra',
            'stillReserved' => 'Ci sono prenotazioni esistenti per questa stanza',
            'notVirtualToSum' => 'I collegamenti per questa stanza non sono sufficienti',
            'notVirtualQty' => 'La quota della stanza deve essere 1',
            'notVirtualChildQty' => 'La quota della stanza collegata deve essere 1',
            'notVirtualSum' => 'Questa non è una stanza di somma',
            'isVirtual' => 'Stanza virtuale, operazione non consentita',
            'isNotVirtual' => 'Stanza non virtuale, operazione non consentita',
            'ruleToBundle' => 'Non puoi eliminare una regola su tariffa pacchetto ancora in corso.',
            'noRateplanExist' => 'Nessun piano tariffario per la struttura',
            'ruleIsLocked' => 'Non puoi modificare una regola su camere All Linked',
            'duplicateLabel' => 'Impossibile utilizzare questo nome perché è già in uso in :accommodationName',
        ],
        'warnings' => [
            'request_confirm_delete_tableau_number' => 'Sono presenti camere collegate, continuare?',
            'accommodation_tableau_not_found' => 'ID Tableau :tableau_number_id non associato o non trovato nella camera con ID :accommodation_id',
            'accommodation_beds_types_combination_not_found' => 'Combinazione con ID :acc_bed_type_combination_id non trovata nella camera con ID: :accommodation_id',
            'confimation_delete_father_and_childs_combinations' => "Stai per eliminare un allestimento padre (ID: :combination_id). Procedendo, verranno automaticamente eliminati anche tutti i suoi allestimenti figli. Confermi di voler continuare?",
            'invalid_facility' => 'Facility non compatibile',
        ],
        'channel' => [
            'single_use_exists' => 'La camera :accommodation_name - :acommodation_ratename risulta essere già associata o già creata',
            'single_use_dont_exists' => 'La camera canale con ID :accommodation_channel_id non è stata trovata',
            'email' => [
                'new_title' => 'Nuove camere aggiunte per il canale :channel_name - Struttura: :property_name - ID Struttura: :property_id',
                'deleted_title' => 'Camere eliminate per il canale :channel_name - Struttura: :property_name - ID Struttura: :property_id',
                'attached_title' => 'Sono state rilevate camere non associate per la struttura: :property_name - ID Struttura: :property_id',
                'conflict_rule' => 'Conflitto di regole per il canale :channel_name - Struttura: :property_name - ID Struttura: :property_id',
            ],
        ],
        'fields' => [
            'model_name' => 'camera',
            'checkin' => 'check-in',
            'checkout' => 'checkout',
            'checkin_hour' => 'orario check-in',
            'checkout_hour' => 'orario check-out',
            'checkin_arrival_preference' => 'preferenza check-in',
        ]
    ],

    'account_renewal' => [
        'email' => [
            'subject' => 'Rinnovo automatico strutture Beddy - :monthAndYear'
        ]
    ],

    'addon' => [
        'price_type' => [
            'xunit' => 'Per unità', // 1
            'xpax' => 'Per persona a notte', // 2
            'xweekxpax' => 'Per persona settimanale', // 3
            'xbookxpax' => 'Per persona una tantum', // 4
            'xnight' => 'A notte', // 5
            'xweek' => 'Settimanale', // 6
            'xbook' => 'Una tantum', // 7
        ],
        'warnings' => [
            'not_available' => 'Non disponibile per il periodo selezionato',
            'min_stay_violated' => 'Il minimo soggiorno richiesto è :min_stay',
            'max_stay_violated' => 'Il massimo soggiorno concesso è :max_stay',
            'release_violated' => 'Il massimo release concesso è :release',
            'rateplan_excluded' => 'Rateplan :rateplan escluso per il servizio extra nel giorno :date',
            'treatment_excluded' => 'Trattamento :treatment escluso per il servizio extra nel giorno :date',
            'weekdays_excluded' => 'Uno o più giorni settimanali esclusi',
        ],
        'errors' => [
            'not_in_stay' => 'Date selezionate fuori dal periodo di soggiorno della camera',
            'not_found' => 'Servizio extra non associato alla camera richiesta',
            'billed_addon' => 'Servizio extra non cancellabile perchè connesso ad addebiti di conti ancora aperti',
        ],
        'logger' => [
            'added' => ':label per :accommodation_name con prezzo :price (:date) #:id',
        ],
    ],

    'admin' => [
        'errors' => [
            'not_demo' => 'La struttura deve essere di tipo DEMO',
            'no_accommodations' => 'La struttura non ha alloggi',
            'no_rateplans' => 'La struttura non ha piani tariffari',
            'channelmanager_module_needed' => 'Il modulo Channel Manager non è attivo',
            'channel_beddy_only' => 'La struttura deve avere esclusivamente il canale Beddy attualmente attivo',
        ]
    ],

    'api_partners' => [
        'contacts_types' => [
            'manager_email' => 'email del responsabile',
            'technical_manager_email' => 'email del responsabile tecnico',
            'customer_service_email' => 'email del servizio clienti',
            'commercial_requests_email' => 'email per richieste commerciali'
        ],
        'errors' => [
            'cannot_delete_has_users' => 'Impossibile cancellare il partner, poichè ha utenti associati',
            'action_not_allowed' => 'Non sei autorizzato al servizio :service.',
            'max_days' => 'L\'intervallo massimo è di :days giorni.',
            'date_filters' => 'Puoi usare solo un tipo di filtro data per richiesta, non più di uno contemporaneamente.',
            'cannot_delete_guest_city_tax' => 'Impossibile eliminare l\'ospite :guestId per la prenotazione :reservationId, perché la tassa di soggiorno è già stata fatturata.',
            'too_many_reservation_ids' => 'Non è possibile passare più di :max reservationIds per chiamata. Attualmente ne hai passati :count.',
            'reservations_not_found' => 'Le seguenti prenotazioni non sono state trovate o non hai accesso: :ids',
            'customer_id_or_customer_required' => 'È necessario fornire almeno uno tra customerId o customer.',
            'customer_id_and_customer_conflict' => 'Non puoi fornire contemporaneamente customerId e customer scegline solo uno.'
        ],
        'services' => [
            'ping' => 'Ping',
            'get_infos' => 'Recupero informazioni',
            'hotel_rateplan' => 'Piano tariffario',
            'push_availabilities' => 'Immissione disponibilità',
            'push_rates' => 'Immissione tariffe',
            'reservations_lookup' => 'Ricerca prenotazioni',
            'reservations_acknowledge' => 'Conferma di ricezione delle prenotazioni',
            'hotel_res_modify_notif' => 'Notifica di modifica delle prenotazioni',
            'reservation_send_message' => 'Invio di messaggi',
            'reservation_message_status' => 'Verifica stato del messaggio',
            'modify_reservation' => 'Modifica Prenotazioni',
            'media' => 'Allegati',
            'modify_media' => 'Modifica allegati',
            'delete_media' => 'Cancella allegati',
            'invoices' => 'Fatture',
            'credit_card' => 'Carta di credito',
            'all_guests' => 'Tutti gli ospiti',
            'get_invoices' => 'Recupera fatture',
            'generic_bol' => 'Generiche sul booking engine',
            'hotel_quote_request' => 'Richiesta preventivi',
            'revenue_data' => 'Recupera dati su occupazione e revenue'
        ],
        'docs' => [
            'errors' => [
                'unsaved_file' => 'Il file non è stato salvato correttamente.'
            ]
        ]
    ],
    'api_partner_detail' => [
        'fields' => [
            'country_id' => 'identificatore del paese',
            'city_id' => 'identificatore della città',
            'state_id' => 'identificatore dello stato',
            'county_id' => 'identificatore della contea',
        ]
    ],
    'auth_verification_methods' => [
        'your_pin' => 'Il tuo pin di accesso per Beddy',
        'error_pin_invalid' => 'Errore. Verifica che il PIN inserito sia corretto',
        'email_authentication' => [
            'get_connection_info_message' => 'Ti abbiamo appena inviato per email il codice pin da inserire per completare l\'autenticazione',
            'pin_invalid' => 'Il codice PIN inserito non è valido',
        ],
        'google_authentication' => [
            'get_connection_info_message' => 'Controlla il tuo google authenticator per prendere il pin da inserire per completare l\'autenticazione',
            'pin_invalid' => 'Il codice PIN inserito non è valido',
        ],
    ],

    'availability' => [
        'errors' => [
            'not_found' => 'Disponibilità per questa camera non trovata',
        ],
        'warnings' => [],
    ],

    'bills' => [
        'ordination_of_date' => 'Comanda del :date',
        'vat_title' => 'P.IVA',
        'accommodation' => 'Alloggio',
        'total' => 'Totale',
        'service' => 'Servizio',
        'quantity_abbreviated' => 'Q.tà',
        'amount' => 'Importo',
        'sign' => 'Firma',
        'account_balance_by_date' => 'Estratto conto per data',
        'account_balance_by_buyer' => 'Estratto conto per pagante',
        'account_balance_by_guest' => 'Estratto conto per ospite',
        'account_balance_by_accommodation' => 'Estratto conto per alloggio',
        'account_balance' => 'Estratto conto',
        'payer' => 'Pagante',
        'quantity' => 'Q.TÀ',
        'date' => 'Data',
        'notes' => 'Notes',
        'scloby' => [
            'ordination_name' => 'Vendita Tilby',
            'ordination_from_sale' => 'Comanda creata da vendita Tilby',
            'confirmation_mode' => 'Modalità di conferma',
            'confirmation_by_phone' => 'numero di telefono',
            'confirmation_by_signature' => 'firma',
        ],
        'log' => [
            'refunds' => 'l\'addebito :bill_label (:bill_common_id) è stato rimborsato di :refunded',
        ]
    ],

    'booking_onboard' => [
        'no_contract_found' => 'Nessun contratto trovato per questa struttura'
    ],

    'bookingengine' => [
        'addons_type' => [
            'xweek' => 'A settimana',
            'xnight' => 'A notte',
            'xpax' => 'A persona per notte',
            'xunit' => 'Ad unità',
            'xbook' => 'A prenotazione',
            'xbookxpax' => 'A persona una tantum',
            'xweekxpax' => 'A persona a settimana',
        ],
        'errors' => [
            'min_expense_coupon' => 'Coupon non applicabile per il valore della attuale prenotazione',
            'min_stay_coupon' => 'Coupon non applicabile per il numero notti della attuale prenotazione',
            'max_stay_coupon' => 'Coupon non applicabile per il numero massimo notti della attuale prenotazione',
            'invalid_days_coupon' => 'Coupon non applicabile per i giorni settimanali della attuale prenotazione',
            'invalid_stay_coupon' => 'Coupon non applicabile per il periodo di osggiorno scelto',
            'invalid_conditions_coupon' => 'Coupon non applicabile per le condizioni di esclusione della attuale prenotazione',
            'invalid_periods_coupon' => 'Coupon non applicabile per le date della attuale prenotazione',
            'invalid_coupon' => 'Coupon non valido o non esistente',
            'already_coupon' => 'Non puoi applicare altri coupon',
            'availability_ended' => 'Terminata disponibilità per le camere selezionate',
            'cart_empty_accommodation' => 'Non ci sono camere nel carrello',
            'date_past_quote_expire' => 'Impossibile aggiungere la camera al preventivo perchè la data di partenza è antecedente a quella della scadenza del preventivo',
            'process_cart_date_past' => 'Impossibile procedere perchè una camera ha la data di partenza antecedente ad oggi',
            'change_expire_date_quote_past' => 'La data di scadenza del preventivo è antecedente a quella di partenza di una o più camere',
            'quote_expired' => 'Il preventivo è scaduto',
            'quote_accepted' => 'Il preventivo è stato già accettato',
            'quote_not_active' => 'Il preventivo non è attivo',
            'quote_just_confirmed' => 'Il preventivo è stato già confermato, impossibile cambiarne lo stato',
            'payment_not_valid' => 'Modalità di pagamento non valida',
            'module_quote_not_active' => 'Il modulo preventivi non è attivo su questa struttura',
            'quote_option_no_availability' => 'Non ci sono più disponibilità per questa opzione',
            'quote_option_no_availability_accommodation' => 'Alcuni alloggi non sono disponibili, verificare il tableau alla conferma del preventivo.',
            'quote_option_no_availability_linked' => 'Alloggio non disponibile e collegato ad altri alloggi, verificare il tableau alla conferma del preventivo.',
            'addon_excluded_from_coupon' => 'Impossibile aggiungere l\'addon ":addon_name" perchè è escluso dal coupon applicato',
            // Sezione sblocco offerte
            'unlock_wrong_accommodation' => 'Camera non corretta.',
            'unlock_wrong_accommodation_to_property' => 'Camera non appartenente alla struttura.',
            'unlock_rateplan_not_unlockable' => 'L\'offerta non è sbloccabile.',
            // estimate addon
            'estimate_addon_failure' => 'Dati di ricerca non corretti',
            // errori generali in step intermedi
            'step_not_complete' => 'Alcuni passaggi sono incompleti',
            'property_different' => 'Hai selezionato camere di strutture diverse',
            'data_sent_not_correct' => 'I dati inviati non sono corretti',
            'no_dns_found' => 'Nessun DNS associato a :subdomain',
            'no_payment_method_available' => 'Nessun metodo di pagamento impostato',
            'session_expired' => 'Sessione scaduta',
            'booking_in_progress' => 'Prenotazione già in elaborazione',
            // alternative search
            'search_not_found' => 'Ricerca non trovata',
            'failed_to_create_reservation' => 'Si è verificato un errore durante la creazione della prenotazione',
            'create_order_already_exist' => 'Order already in processing (cache exists) - SID :sid',
            'create_quote_order_already_exist' => 'Quote Order already in processing (cache exists) - Reference :reference',
        ],
        'persuasive_sentences' => [
            'prepayment' => 'Pagamento anticipato',
            'hotel_payment' => 'Pagamento in struttura. Adesso non paghi',
            'free_cancellation_until' => 'Cancellazione gratuita fino al :date_limit',
            'cancellation_term' => 'Termini e condizioni di prenotazione',
            'cheapest_rate' => 'Questa è la tariffa più conveniente',
        ],
        'payment_method_description' => [
            'transfer' => 'testo no deposito',
            'transfer_deposit' => 'È previsto un pagamento anticipato di :deposit, tale importo sarà rimborsabile se previsto dalle policy di cancellazione di questa tariffa. Riceverai via email gli estremi per effettuare il bonifico. ',
            'cc_a_garanzia' => 'Zero costi aggiuntivi! La carta di credito serve solo per garantire la prenotazione. Non dovrai anticipare nessun deposito. Pagherai direttamente a :property_name il costo totale della prenotazione durante il soggiorno.',
            'cc_pos' => 'Zero costi aggiuntivi! La carta di credito serve solo per garantire la prenotazione. Non dovrai anticipare nessun deposito. Pagherai direttamente a :property_name il costo totale della prenotazione durante il soggiorno.',
            'cc_pos_deposit' => 'È previsto un pagamento anticipato di :deposit, tale importo sarà rimborsabile se previsto dalle policy di cancellazione di questa tariffa.',
            'cc_stripe_deposit' => 'Il pagamento verrà effettuato tramite gateway di pagamento Stripe. È previsto un pagamento anticipato di :deposit, tale importo sarà rimborsabile se previsto dalle policy di cancellazione di questa tariffa.',
            'nexi_deposit' => 'Il pagamento verrà effettuato tramite gateway di pagamento Nexi. È previsto un pagamento anticipato di :deposit, tale importo sarà rimborsabile se previsto dalle policy di cancellazione di questa tariffa. <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Informativa privacy</a> di Nexi.',
            'zpay_deposit' => 'Il pagamento verrà effettuato tramite gateway di pagamento ZPay. È previsto un pagamento anticipato di :deposit, tale importo sarà rimborsabile se previsto dalle policy di cancellazione di questa tariffa.  <a href="https://www.zpay.it/privacy" target="_blank">Informativa privacy</a> di ZPay.',
            'cc_paypal_deposit' => 'Il pagamento verrà effettuato tramite gateway di pagamento Paypal. È previsto un pagamento anticipato di :deposit, tale importo sarà rimborsabile se previsto dalle policy di cancellazione di questa tariffa.',
            'availability_request' => 'A causa del particolare periodo di alta stagione, la presente richiesta non ha valore di prenotazione effettiva, può comunque richiedere informazioni sulle disponibilità compilando il seguente modulo. La richiesta di prenotazione sarà confermata il prima possibile.',
            'cc_paypal_deposit_with_commission' => 'Il pagamento verrà effettuato tramite gateway di pagamento Paypal. È previsto un pagamento anticipato di :deposit + :commission di commissioni, tale importo sarà rimborsabile se previsto dalle policy di cancellazione di questa tariffa.',
        ],
        'automatic_payment_method_description' => [
            'transfer' => 'testo no deposito',
            'transfer_deposit' => ' Riceverai via email gli estremi per effettuare il bonifico. ',
            'cc_a_garanzia' => 'La carta di credito serve per garantire la prenotazione. Nessun addebito previsto adesso, pagherai secondo le modalità descritte nelle Condizioni di Pagamento.',
            'cc_pos' => 'La carta di credito serve per garantire la prenotazione. Nessun addebito previsto adesso, pagherai secondo le modalità descritte nelle Condizioni di Pagamento.',
            'cc_pos_deposit' => 'È previsto un pagamento anticipato di :deposit, tale importo sarà rimborsabile se previsto dalle policy di cancellazione di questa tariffa.',
            'cc_stripe_deposit' => 'Il pagamento verrà effettuato tramite gateway di pagamento Stripe.',
            'nexi_deposit' => 'Il pagamento verrà effettuato tramite gateway di pagamento Nexi. <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Informativa privacy</a> di Nexi.',
            'zpay_deposit' => 'Il pagamento verrà effettuato tramite gateway di pagamento ZPay. <a href="https://www.zpay.it/privacy" target="_blank">Informativa privacy</a> di ZPay.',
            'cc_paypal_deposit' => 'Il pagamento verrà effettuato tramite gateway di pagamento Paypal.',
            'availability_request' => 'La presente richiesta non ha valore di prenotazione effettiva, può comunque richiedere informazioni sulle disponibilità compilando il seguente modulo. La richiesta di prenotazione sarà confermata il prima possibile.',
            'cc_paypal_deposit_with_commission' => 'Il pagamento verrà effettuato tramite gateway di pagamento Paypal.',

        ],
        'validators' => [
            'errors' => [
                'name' => 'Nome ospite non valido.',
                'surname' => 'Cognome ospite non valido.',
                'email' => 'Email ospite non corretta.',
                'credit_card_type_id' => 'Carta di credito non supportata.',
                'credit_card_holder' => 'Intestatario carta non valido.',
                'credit_card_number' => 'Numero carta non valido.',
                'credit_card_expire_date' => 'Data di scadenza carta non valida.',
            ]
        ]
    ],

    'cash_desk_closure' => [
        'title' => 'Chiusura cassa',
        'invoice' => 'Fattura',
        'invoices' => 'Fatture',
        'receipt' => 'Ricevuta',
        'receipt_follows_invoice' => 'Ricevuta segue fattura',
        'receipts' => 'Ricevute',
        'type' => 'Tipo',
        'status' => 'Pagato',
        'deposit' => 'Caparra',
        'recipient_business_name' => 'Destinatario',
        'taxable' => 'Imponibile',
        'vat_quote' => 'IVA',
        'total' => 'Totale',
        'payments' => 'Pagamenti',
        'totals' => 'TOTALI GENERALI',
        'cash_type' => 'Tipo di incasso',
        'reversal_receipt' => 'Storno ricevuta',
        'reversal_receipts' => 'Storno ricevute',
        'to_give' => 'Dare',
        'to_have' => 'Avere',
        'balance' => 'Saldo',
        'documents' => 'Documenti',
        'deposits' => 'Caparre',
        'cash_desk_closure' => 'Sospesi',
        'credit_note' => 'Nota di credito',
        'invoice_received' => 'Fattura ricevuta',
        'credit_notes' => 'Note di credito',
        'suspended' => 'Sospesi',
        'follows_invoice' => 'Segue Fattura',
        'receipts_follows_invoice' => 'Ricevuta segue fattura',
        'suspend' => 'Sospeso',
        'empty_documents' => 'Non sono presenti documenti da visualizzare',
        'sheets_name' => [
            'cash_desk' => 'Cassa',
            'cahs_desk_summary' => 'Riepilogo cassa',
        ],
        'export_fields' => [
            'date' => 'Data inserimento',
            'status' => 'Pagato',
            'document_type' => 'Tipo documento',
            'document_number' => 'Numero documento',
            'customer' => 'Destinatario',
            'taxable' => 'Imponibile',
            'total_tax' => 'IVA',
            'total_to_pay' => 'Totale',
            'payment_type' => 'Tipo di incasso',
            'to_have' => 'Avere',
            'to_give' => 'Dare',
            'balance' => 'Saldo',
            'deposit_document_number' => 'Numero documento caparra',
            'deposit_payment_type' => 'Tipo di incasso caparra'
        ],
    ],

    'cash' => [
        'cash_title' => 'Situazione Cassa',
        'cash_totals_title' => 'Totali',
        'total' => 'Totale',
        'cash_desk' => 'Cassa',
        'export_fields' => [
            'registration_date' => 'Data di inserimento',
            'accountholder' => 'Intestatario',
            'document' => 'Documento',
            'document_date' => 'Data documento',
            'date' => 'Data',
            'in-out' => 'In-out',
            'cash_in' => 'Incasso (entrate)',
            'cash_out' => 'Uscite (pagamenti)',
            'payment_method' => 'Metodo di pagamento',
            'note' => 'Note',
            'type_payment' => 'Tipo di pagamento',
            'stay' => 'Soggiorno',
            'extra' => 'Extra',
            'city_tax' => 'Tassa di soggiorno',
            'pos' => 'POS',
            'property' => 'Struttura',
            'amount' => 'Importo',
            'mode' => 'Modalità',
            'type' => 'Tipo',
            'category' => 'Categorie di spesa',
            'notes' => 'Note',
            'movement_amount' => 'Movimenti',
            'customer_or_company' => 'Cliente o Azienda',
            'label' => 'Etichetta',
        ],
        'document_types' => [
            'invoice' => 'Fattura',
            'receipt' => 'Ricevuta',
            'credit_note' => 'Nota di credito',
        ],
        'payment_types' => [
            'deposit' => 'Caparra',
            'part_payment' => 'Acconto',
        ],
        'total_yesterday' => 'Totale di Ieri',
        'total_today' => 'Totale di Oggi',
        'all_properties' => 'Tutte le strutture',
        'sub_year' => 'Totale dell\'anno',
        'sub_month' => 'Totale del mese',
        'sub_day' => 'Totale del giorno',
        'ins' => 'Incasso (Entrate)',
        'outs' => 'Uscite (Pagamenti)',
        'cash_fund' => 'Fondo cassa',
        'cash_in' => 'Entrate',
        'cash_out' => 'Uscite',
        'cash_balance' => 'Saldo',
        'to_cash_in' => 'Da incassare',
        'wrap_up' => 'Riepilogo per modalità di pagamento',
        'summary' => 'Riepilogo',
        'in_out' => [
            'in' => 'Incasso',
            'out' => 'Uscita',
        ],
        'totals' => [
            'method' => 'Metodo',
            'ins' => 'Incasso',
            'outs' => 'Uscite',
            'diff' => 'Saldo',
        ],
    ],

    'channel' => [
        '1' => [  // indica ID del canale
            'promotions' => [
                'mobile_rate' => [
                    'all' => 'Applicazione e Browser mobile',
                    'app' => 'Applicazione',
                ],
                'geo_rate' => [
                    'algeria_pos' => 'Algeria',
                    'argentina_pos' => 'Argentina',
                    'australia_pos' => 'Australia',
                    'belarus_pos' => 'Bielorussia',
                    'brazil_pos' => 'Brasile',
                    'canada_pos' => 'Canada',
                    'chile_pos' => 'Cile',
                    'colombia_pos' => 'Colombia',
                    'eu_pos' => 'Europa',
                    'hong_kong_pos' => 'Hong Kong',
                    'india_pos' => 'India',
                    'indonesia_pos' => 'Indonesia',
                    'iran_pos' => 'Iran',
                    'israel_pos' => 'Israele',
                    'japan_pos' => 'Giappone',
                    'kazakhstan_pos' => 'Kazakistan',
                    'kuwait_pos' => 'Kuwait',
                    'malaysia_pos' => 'Malesia',
                    'mexico_pos' => 'Messico',
                    'new_zealand_pos' => 'Nuova Zelanda',
                    'oman_pos' => 'Oman',
                    'pakistan_pos' => 'Pakistan',
                    'peru_pos' => 'Perù',
                    'philippines_pos' => 'Filippine',
                    'qatar_pos' => 'Qatar',
                    'russia_pos' => 'Russia',
                    'saudi_arabia_pos' => 'Arabia Saudita',
                    'singapore_pos' => 'Singapore',
                    'south_africa_pos' => 'Sud Africa',
                    'south_korea_pos' => 'Corea del Sud',
                    'switzerland_pos' => 'Svizzera',
                    'taiwan_pos' => 'Taiwan',
                    'thailand_pos' => 'Tailandia',
                    'trinidad_&_tobago_pos' => 'Trinidad e Tobago',
                    'turkey_pos' => 'Turchia',
                    'ukraine_pos' => 'Ukraina',
                    'united_arab_emirates_pos' => 'Emirati Arabi Uniti',
                    'united_states_pos' => 'USA',
                    'vietnam_pos' => 'Vietnam',
                ],
            ],
            'json_request' => [
                'errors' => [
                    'INVALID_ARGUMENT' => 'Uno o più dati non sono validi. (:message)',
                    'MISSING_ARGUMENT' => 'Uno o più dati sono mancanti. (:message)',
                    'OPERATION_NOT_ALLOWED' => 'Operazione non permessa. (:message)',
                    'FORBIDDEN' => 'Operazione vietata (:message)',
                ]
            ]
        ],
        '11' => [
            'availability_model' => 'Gestione disponibilità tipologia camera "Private":',
            'per_room' => 'Per camera (avail*beds)',
            'per_person' => 'Per letti',
        ],
        '14' => [
            'availability_value_greater' => 'You have entered an availability value greater than that accepted.',
        ],
        '39' => [
            'period_not_valid' => 'Rate :rate valido dal :valid_from al :valid_to. Aggiornamento ignorato.',
        ],
        '53' => [
            'warning_update_category' => 'Errore update category room :rate_xml. Regole non settate su Beddy.',
            'empty_response_update' => 'Errore update risposta vuota.',
        ],
        '68' => [
            'used_voucher' => 'VOUCHER USATO',
            'amount_voucher' => 'Importo voucher',
            'used_amount' => 'Importo usato',
            'virtual_rate_option' => 'Gestione tariffe derivate',
            'virtual_rate_option_off' => 'Non gestire (scarica in sola lettura)',
            'virtual_rate_option_on' => 'Attiva gestione tariffe derivate (prezzo non gestibile)',
            'manage_type' => 'Tipologia collegamento',
            'manage_type_complete' => 'Gestione completa',
            'manage_type_reservation' => 'Gestione solo prenotazioni',
            'manage_type_avail_reservation' => 'Gestione prenotazioni e disponibilità',
            'message_only_reservation' => 'Aggiornamenti ignorati (Collegato in gestione solo prenotazioni)',
            'message_avail_reservation' => 'Aggiornamenti prezzi e restrizioni ignorati (Collegato in gestione prenotazioni e disponibilità)',
            'deposit_requested' => 'Deposito richiesto',
            'deposit_payed' => 'Caparra pagata',
            'payed_via' => 'Pagato con',
        ],
        '69' => [
            'manage_type' => 'Tipologia collegamento',
            'manage_type_complete' => 'Gestione completa',
            'manage_type_reservation' => 'Gestione solo prenotazioni',
            'manage_type_avail_reservation' => 'Gestione prenotazioni e disponibilità',
            'manage_type_avail_restriction_reservation' => 'Gestione prenotazioni, disponibilità e restrizioni',
            'message_only_reservation' => 'Aggiornamenti ignorati (Collegato in gestione solo prenotazioni)',
            'message_avail_reservation' => 'Aggiornamenti prezzi e restrizioni ignorati (Collegato in gestione prenotazioni e disponibilità)',
            'message_avail_restriction_reservation' => 'Aggiornamenti prezzi ignorato (Collegato in gestione prenotazioni, disponibilità e restrizioni)',
        ],
        '72' => [
            'manage_type' => 'Tipologia collegamento',
            'manage_type_complete' => 'Gestione completa',
            'manage_type_reservation' => 'Gestione solo prenotazioni',
            'manage_type_avail_reservation' => 'Gestione prenotazioni e disponibilità',
            'manage_type_avail_restriction_reservation' => 'Gestione prenotazioni, disponibilità e restrizioni',
            'message_only_reservation' => 'Aggiornamenti ignorati (Collegato in gestione solo prenotazioni)',
            'message_avail_reservation' => 'Aggiornamenti prezzi e restrizioni ignorati (Collegato in gestione prenotazioni e disponibilità)',
            'message_avail_restriction_reservation' => 'Aggiornamenti prezzi ignorato (Collegato in gestione prenotazioni, disponibilità e restrizioni)',
        ],
        '73' => [
            'pricing_model' => 'Pricing model',
            'per_room' => 'Per camera/tariffa',
            'per_person' => 'Per persona',
            'manage_type' => 'Tipologia collegamento',
            'manage_type_complete' => 'Gestione completa',
            'manage_type_reservation' => 'Gestione solo prenotazioni',
            'manage_type_avail_reservation' => 'Gestione prenotazioni e disponibilità',
            'manage_type_avail_restriction_reservation' => 'Gestione prenotazioni, disponibilità e restrizioni',
            'manage_type_avail_avail_price_reservation' => 'Gestione prenotazioni, disponibilità e prezzi',
            'message_only_reservation' => 'Aggiornamenti ignorati (Collegato in gestione solo prenotazioni)',
            'message_avail_reservation' => 'Aggiornamenti prezzi e restrizioni ignorati (Collegato in gestione prenotazioni e disponibilità)',
            'message_avail_restriction_reservation' => 'Aggiornamenti prezzi ignorato (Collegato in gestione prenotazioni, disponibilità e restrizioni)',
            'manage_avail_price_reservation' => 'Aggiornamenti restrizioni ignorato (Collegato in gestione prenotazioni, disponibilità e prezzi)',
            'payment_info' => 'Info pagamento',
            'payment_amount' => 'Importo pagato',
            'payment_extra_info' => 'Dettagli',
            'payment_transaction' => 'Codice della transazione',
            'payment_full' => 'prepagamento effettuato per l\'intero importo della prenotazione',
            'payment_partial' => 'prepagamento parziale effettuato',
            'payment_none' => 'nessun prepagamento',
            'payment_channel_collect' => 'l\'ospite ha pagato al canale',
            'payment_hotel_collect' => 'l\'ospite deve pagare in albergo (tutto o parzialmente)',
            'payment_gateway' => 'l\'ospite ha pagato mediante gateway bancario',
            'service_inclusive' => 'Incluso nel prezzo',
        ],
        '93' => [
            'reservation_status' => 'Stato prenotazione',
            'booked' => 'Prenotata, in attesa conferma struttura',
            'waiting_payment' => 'In attesa di pagamento caparra',
            'payment_in_progress' => 'Pagamento in gestione e verifica',
            'confirmed' => 'Confermata',
            'canceled' => 'Cancellata',
            'waiting_credit_card_guarantee' => 'In attesa di carta di credito a garanzia',
            'deposit' => 'Deposito',
            'payed' => 'Pagato',
            'not_payed' => 'Non pagato',
            'payment_mothod' => 'Metodo pagamento',
            'option_property_xml_id' => 'Id struttura (lo stesso di Beddy)',
            'option_email' => 'Email',
            'option_apikey' => 'Api key',
        ],
        '95' => [
            'unknown_rate' => 'Rate PMS sconosciuto. ID camera e tariffa ricevuti dal canale: ',
            'error_set_rate' => 'Errore invio configurazione',
            'title_set_rate' => 'Invio configurazione canale :channel_name',
            'message_set_rate' => 'Configurazione rate inviata per il canale :channel_name id struttura :property_id . Effettuato il reset di tutti i rate sul canale (reinviare tutti i dati)',
            'ping_channel' => 'Abilita collegamento al canale',
            'min_age_adult' => 'A partire da quale età gli ospiti vengono considerati adulti',
            'pricing_type' => 'Modello di prezzo',
            'pricing_type_room' => 'Per camera',
            'pricing_type_person' => 'Per persona',
            'accept_children' => 'Accetta bambini',
            'extra_child_min_age' => 'Fascia bambini 1: min',
            'extra_child_max_age' => 'Fascia bambini 1: max',
            'extra_teenager_min_age' => 'Fascia bambini 2: min',
            'extra_teenager_max_age' => 'Fascia bambini 2: max',
            'extra_infant_min_age' => 'Fascia bambini 3: min',
            'extra_infant_max_age' => 'Fascia bambini 3: max',
            'accept_extrabed' => 'Accetta letti extra',
            'ratetreatment' => 'Trattamento tariffa',
            'mealplan_included' => 'Tipo trattamento tariffa',
            'included' => 'Incluso',
            'escluded' => 'Escluso',
            'send_configuration' => 'Invia configurazione al canale al salvataggio (reset di tutti i rate)',
        ],
        '100' => [
            'unknown_rate' => 'Rate PMS sconosciuto. ID camera e tariffa ricevuti dal canale: ',
            'error_set_rate' => 'Errore invio configurazione',
            'title_set_rate' => 'Invio configurazione canale :channel_name',
            'message_set_rate' => 'Configurazione rate inviata per il canale :channel_name id struttura :property_id . Effettuato il reset di tutti i rate sul canale (reinviare tutti i dati)',
            'info_id_rate' => 'Id rate attivi sul canale (separati da virgola)',
            'ping_channel' => 'Abilita collegamento al canale',
            'min_age_adult' => 'A partire da quale età gli ospiti vengono considerati adulti',
            'pricing_type' => 'Modello di prezzo',
            'pricing_type_room' => 'Per camera',
            'pricing_type_person' => 'Per persona',
            'accept_children' => 'Accetta bambini',
            'extra_child_min_age' => 'Fascia bambini 1: min',
            'extra_child_max_age' => 'Fascia bambini 1: max',
            'extra_teenager_min_age' => 'Fascia bambini 2: min',
            'extra_teenager_max_age' => 'Fascia bambini 2: max',
            'extra_infant_min_age' => 'Fascia bambini 3: min',
            'extra_infant_max_age' => 'Fascia bambini 3: max',
            'accept_extrabed' => 'Accetta letti extra',
            'ratetreatment' => 'Trattamento tariffa',
            'mealplan_included' => 'Tipo trattamento tariffa',
            'included' => 'Incluso',
            'escluded' => 'Escluso',
            'send_configuration' => 'Invia configurazione al canale al salvataggio (reset di tutti i rate)',
        ],
        // traduzioni option generali (statiche) canali
        'option_general' => [
            'property_xml_id' => 'Xml id struttura',
            'username' => 'Username',
            'password' => 'Password',
        ],
        'general' => [
            'get_channel_rate_empty' => 'Nessun dato scaricato dal portale',
            'no_data_to_update' => 'Non ci sono dati da inviare.',
            'no_valid_period' => 'Il periodo aggiornato non è valido. Aggiornamento ignorato.',
            'no_valid_response' => 'Risposta ricevuta dal canale non valida (:error_message)',
            'only_min_stay_update' => 'Struttura configurata per aggiornare solo il min stay.',
            'period_not_valid' => 'Rate :rate valido dal :valid_from al :valid_to. Aggiornamento ignorato.',
            'no_valid_response_update' => 'Risposta ricevuta dal canale non valida.',
            'discount' => 'Sconto',
            'unknown' => 'sconosciuto',
            'deposit_payed' => 'Deposito pagato',
            'to_payed' => 'Da pagare',
            'payment_type' => 'Tipo',
            'ota_commission' => 'Commissioni OTA',
            'ota_due' => 'Dovuto da OTA',
            'arrival_time' => 'Orario arrivo',
            'cancellable_until' => 'Cancellabile fino al',
        ],
        'queue_update' => [
            'already_updated' => 'Aggiornamento inviato da operation code: :operation_code',
            'max_retry' => 'Numero massimo di tentativi eseguiti per l\'aggiornamento del canale: :channel_name - Periodo dal: :date_from - al: :date_to. Ultimo messaggio: :message',
            'queue_update_max_retry_strategy_mail' => 'Numero massimo di reinvio canale :channel_name - Struttura: :property_name',
            'queue_update_exception_mail' => 'Eccezione canale :channel_name - Struttura: :property_name',
        ],
        'errors' => [
            'content_api_update_errors_mail_connectivity' => 'Errorre aggiornamento CONTENT-API :channel_name - Struttura: :property_name',
            'property_is_related' => 'La struttura non è una madre ed è già relazionata con un\'altra struttura',
            'accommodation_channel_not_found' => 'La camera con l\'id xml :accommodation_xml_id non è stata trovata',
            'unsupported_min_dvance_res' => 'Questo canale non permette di impostare un valore minimo di anticipo prenotazione.'
        ],
        'queue_past_reservations' => [
            'queue_task_exists' => 'Property #:property_id già in coda di esecuzione',
        ],
    ],

    'checkinonline' => [
        'policy' => [
            'privacy_policy_accept' => 'Il/La Sottoscritto/a in calce identificato/a dichiara di avere ricevuto completa informativa ai sensi degli Artt. 13 e 14 del Regolamento UE 2016/679 e di averne ben compreso i contenuti.',
            'privacy_policy_auth_1' => 'Il Titolare al trattamento dei dati particolari di cui all’art. 9 Regolamento UE 679/2016, al fine di poter fruire di un ottimale livello di ospitalità e per la protezione della propria salute fisica;',
            'privacy_policy_auth_2' => ' Il Titolare a comunicare i dati relativi al mio soggiorno, al fine esclusivo di consentire il ricevimento di eventuali messaggi e telefonate a me indirizzati.',
            'privacy_policy_auth_3' => 'Il Titolare ad inviare ai miei recapiti comunicazioni promozionali.',
            'privacy_policy_authorize' => 'Autorizzo',
            'privacy_policy_eighth_item' => ' 8. I miei dati potrebbero essere trasferiti all’estero?',
            'privacy_policy_eleventh_item' => '  11. Quali sono i tempi per ricevere un riscontro dal Titolare? ',
            'privacy_policy_fifth_item' => '5. Come saranno trattati i dati raccolti?',
            'privacy_policy_first_item' => '1.  Chi determina le finalità e le modalità del trattamento?',
            'privacy_policy_first_paragraph' => "Ai sensi dell'artt. 13 e 14 del regolamento UE n. 2016/679 (di seguito 'GDPR'), relativo alla protezione dei dati personali e alla loro libera circolazione, la :businessName nella qualità di Titolare del trattamento dei dati personali, ha l'obbligo di fornirLe tutte le informazioni relative alle finalità e alle modalità di trattamento dei suoi dati personali, l'indicazione dei soggetti a cui i suoi dati potranno essere comunicati, e tutti i diritti che la legge Le riconosce in relazione alla gestione dei dati personali da parte del titolare.",
            'privacy_policy_fourth_item' => '4. Perché raccogliete i miei dati?',
            'privacy_policy_fourth_item_part_2' => 'Base giuridica del trattamento',
            'privacy_policy_list_eighth_item_1' => 'Altri paesi EU rispetto all’Italia; ',
            'privacy_policy_list_eighth_item_2' => 'Regno Unito; ',
            'privacy_policy_list_eighth_item_3' => 'Irlanda; ',
            'privacy_policy_list_eighth_item_4' => 'Svizzera;',
            'privacy_policy_list_eighth_item_5' => 'USA',
            'privacy_policy_list_fifth_item_1' => 'Attraverso operazioni che consentiranno la raccolta, la registrazione, l’organizzazione, la conservazione, la consultazione, l’elaborazione, la modificazione, la selezione, l’estrazione, l’utilizzo, la comunicazione, la cancellazione e la distruzione dei dati.',
            'privacy_policy_list_fifth_item_2' => ' Attraverso l’impiego di strumenti elettronici o comunque automatizzati che consentano la memorizzazione, la gestione e la trasmissione dei dati, ma sempre configurati, in modo da garantirne la massima riservatezza e la necessaria tutela.',
            'privacy_policy_list_fifth_item_3' => 'Attraverso l’impiego di documenti contenuti su supporto cartaceo con la predisposizione di idonee misure di custodia che ne precludano la conoscenza a soggetti privi di autorizzazione.',
            'privacy_policy_list_fourth_item_1' => 'Gestione clienti;',
            'privacy_policy_list_fourth_item_10' => 'Proteggere e garantire la sicurezza e l’incolumità delle persone;',
            'privacy_policy_list_fourth_item_11' => 'Proteggere l’integrità della proprietà e del patrimonio aziendale;',
            'privacy_policy_list_fourth_item_12' => "Consentire l'uso e garantire la sicurezza dell'infrastruttura ICT.",
            'privacy_policy_list_fourth_item_1_part_2' => 'Manifestazione del consenso; ',
            'privacy_policy_list_fourth_item_2' => 'Sottoscrizione e gestione dei contratti; ',
            'privacy_policy_list_fourth_item_2_part_2' => 'Obblighi precontrattuali e contrattuali; ',
            'privacy_policy_list_fourth_item_3' => 'Gestione amministrativa;',
            'privacy_policy_list_fourth_item_3_part_2' => 'Obblighi di legge;',
            'privacy_policy_list_fourth_item_4' => 'Gestione del contenzioso;',
            'privacy_policy_list_fourth_item_4_part_2' => 'Interesse legittimo del Titolare. ',
            'privacy_policy_list_fourth_item_5' => 'Customer care;',
            'privacy_policy_list_fourth_item_6' => 'Pubbliche relazioni',
            'privacy_policy_list_fourth_item_7' => 'Promozione, marketing e pubblicità;',
            'privacy_policy_list_fourth_item_8' => 'Protezione della salute fisica delle persone;',
            'privacy_policy_list_fourth_item_9' => ' Sicurezza interna;',
            'privacy_policy_list_nineth_item_1' => '10 anni (secondo quanto previsto dagli obblighi civilistici ‐ Art. 2220 Cod. Civ.);',
            'privacy_policy_list_nineth_item_2' => '3 mesi al massimo dalla data di check‐out per i dati delle carte di credito;  ',
            'privacy_policy_list_nineth_item_3' => '3 anni al massimo dall’ultimo check‐out per i dati personali, particolari, relativi al soggiorno, le preferenze personali, documenti identificativi, firma autografa e lo storico degli acquisti e dati per il marketing (Punti da 2.1 a 2.7), salvo diversa indicazione dell’interessato; ',
            'privacy_policy_list_nineth_item_4' => '5 giorni al massimo per le immagini della videosorveglianza;',
            'privacy_policy_list_nineth_item_5' => '90 giorni dal check‐out per i dati relativi al traffico telefonico;',
            'privacy_policy_list_nineth_item_6' => '1 anno per i dati di accesso ed uso delle risorse ICT.',
            'privacy_policy_list_second_item_1' => 'Dati identificativi personali;',
            'privacy_policy_list_second_item_2' => 'Dati particolari;',
            'privacy_policy_list_second_item_3' => 'Dati relativi al soggiorno;',
            'privacy_policy_list_second_item_4' => 'Preferenze personali;',
            'privacy_policy_list_second_item_5' => 'Documenti identificativi;',
            'privacy_policy_list_second_item_6' => 'Firma autografa;',
            'privacy_policy_list_second_item_7' => 'Storico degli acquisti;',
            'privacy_policy_list_second_item_8' => 'Dati delle carte di credito e/o bancari;',
            'privacy_policy_list_second_item_9' => 'Immagini della videosorveglianza;',
            'privacy_policy_list_second_item_10' => 'Dati relativi ai device elettronici utilizzati per connettersi alla rete della struttura;',
            'privacy_policy_list_second_item_11' => 'Dati relativi alle telefonate;',
            'privacy_policy_list_second_item_12' => 'Dati di accesso ed uso delle risorse ICT',
            'privacy_policy_list_second_item_extra' => 'Dati relativi a condizioni di salute.',
            'privacy_policy_list_seventh_item_1' => 'Incaricati;',
            'privacy_policy_list_seventh_item_2' => 'Responsabili del Trattamento; ',
            'privacy_policy_list_seventh_item_3' => 'Amministratori di sistema; ',
            'privacy_policy_list_seventh_item_4' => 'Consulenti Contabilità;',
            'privacy_policy_list_seventh_item_5' => 'Consulenti legali; ',
            'privacy_policy_list_seventh_item_6' => 'Banche',
            'privacy_policy_list_seventh_item_7' => 'Enti assicurativi;',
            'privacy_policy_list_seventh_item_8' => 'Società di revisione;',
            'privacy_policy_list_seventh_item_9' => 'Società di servizi per la manutenzione dell’infrastruttura alberghiera',
            'privacy_policy_list_seventh_item_10' => 'Società di forniture servizi internet e posta elettronica; ',
            'privacy_policy_list_seventh_item_11' => 'Enti, Associazioni, Organizzazioni, Aziende o privati che organizzano eventi o soggiorni nella struttura; ',
            'privacy_policy_list_seventh_item_12' => 'Pubblica autorità;',
            'privacy_policy_list_seventh_item_13' => 'Forze di polizia.',
            'privacy_policy_list_third_item_1' => 'OTA (Online Travel Agency) quali, ad esempio, Booking.com, Venere.com, Worldhotels.com, Trivago.com, Expedia.com, ecc',
            'privacy_policy_list_third_item_2' => 'Agenzie di viaggio tradizionali;',
            'privacy_policy_list_third_item_3' => 'Enti, Associazioni, Organizzazioni, Aziende o privati che organizzano eventi o soggiorni nella struttura; ',
            'privacy_policy_location' => ':businessCity, lì',
            'privacy_policy_name_surname' => 'Nome e cognome',
            'privacy_policy_nineth_item' => ' 9. Per quanto tempo saranno conservati i miei dati?',
            'privacy_policy_not_authorize' => 'Non Autorizzo',
            'privacy_policy_second_item' => '2. Quali sono i dati personali oggetto del trattamento da parte del Titolare del Trattamento?',
            'privacy_policy_second_item' => '2. Quali sono i dati personali oggetto del trattamento da parte del Titolare del Trattamento?',
            'privacy_policy_second_paragraph' => 'La invitiamo pertanto a prendere atto delle informazioni ivi contenute e ad esprimere il consenso al trattamento sottoscrivendo la presente informativa.',
            'privacy_policy_seventh_item' => ' 7. Chi verrà a conoscenza dei miei dati?',
            'privacy_policy_sign' => 'Firma:',
            'privacy_policy_sixth_item' => ' 6. Perché dovrei conferire i miei dati al Titolare? Posso opporre un rifiuto?',
            'privacy_policy_sub1' => 'Diritto di accesso ai dati (Art. 15, GDPR)',
            'privacy_policy_sub2' => 'Diritto di rettifica (Art. 16, GDPR)',
            'privacy_policy_sub3' => 'Diritto alla cancellazione (Art. 17, GDPR)',
            'privacy_policy_sub4' => 'Diritto di limitazione di trattamento (Art. 18, GDPR)',
            'privacy_policy_sub5' => 'Diritto alla portabilità dei dati (Art. 20, GDPR)',
            'privacy_policy_sub6' => 'Diritto di opposizione (Art. 21, GDPR)',
            'privacy_policy_sub7' => 'Diritto che i suoi dati non siano sottoposti ad un Processo decisionale automatizzato compresa la profilazione (art. 22, GDPR)',
            'privacy_policy_sub8' => "Diritto di proporre reclamo all'autorità di controllo (Art. 77, GDPR)",
            'privacy_policy_tenth_item' => ' 10. Come posso intervenire per limitare, impedire o oppormi al trattamento dei miei dati da parte del Titolare?',
            'privacy_policy_text_eighth_item' => ' I dati personali potranno essere trasferiti verso Paesi dell’Unione Europea o verso Paesi terzi rispetto all’Unione Europea o ad un’organizzazione internazionale qualora questo adempimento risulti necessario per il raggiungimento delle finalità attività di cui al paragrafo 4 e poter adempiere alle obbligazioni assunte. Alla data della presente i paesi verso i quali vengono trasferiti i suoi dati sono:',
            'privacy_policy_text_eleventh_item' => " In caso di richiesta da parte Sua di informazioni relative ai Suoi dati, il Titolare darà riscontro al più presto ‐ salvo che ciò si riveli impossibile o implichi uno sforzo sproporzionato ‐ e, comunque, non oltre 30 giorni dall'istanza. Eventuali impossibilità o ritardi da parte del titolare nel soddisfare le richieste verranno motivati",
            'privacy_policy_text_first_item' => 'Il Titolare del trattamento dei dati è la :businessName con sede a :businessCity in :businessAddress, :businessCap, Partita IVA :businessVat.',
            'privacy_policy_text_second_item' => 'Il Titolare del Trattamento raccoglierà e tratterà i Suoi dati personali, ovvero qualsiasi informazione che possa identificarla e che sia a Lei direttamente o indirettamente riconducibile, quali, a titolo meramente indicativo:',
            'privacy_policy_text_second_item_part_2' => 'e ogni altro dato che risulti necessario per il raggiungimento delle finalità di cui al paragrafo 4. ',
            'privacy_policy_text_second_item_part_2_span' => 'Saranno inoltre trattati dati particolari quali:',
            'privacy_policy_text_third_item' => 'I dati personali vengono forniti direttamente dall’interessato al Titolare del trattamento o raccolti attraverso altri soggetti quali:',
            'privacy_policy_text_fourth_item' => ' I dati personali raccolti dal Titolare del Trattamento, verranno trattati per le seguenti finalità:',
            'privacy_policy_text_fourth_item_part_2' => ' Il trattamento dei dati avverrà nella rigorosa osservanza delle prescrizioni di legge, secondo i principi di liceità e correttezza e nel rispetto del diritto alla riservatezza. Il trattamento dei dati avverrà sulla base di:',
            'privacy_policy_text_fifth_item' => 'Il trattamento sarà svolto in forma automatizzata e manuale, nel rispetto di quanto previsto dall’art. 32 del GDPR 2016/679 ed in particolare:',
            'privacy_policy_text_sixth_item' => 'Ove il conferimento dei dati personali sia funzionale all’esecuzione di un contratto o all’adempimento di un obbligo di legge il trattamento è indispensabile e in caso di rifiuto a trattare i dati oggetto della presente informativa, il Titolare del Trattamento non potrà adempiere alle attività di cui al paragrafo 4 ed in generale non sarà in grado di poter adempiere alle obbligazioni assunte. ',
            'privacy_policy_text_sixth_item_span' => 'Relativamente alle finalità del trattamento per le quali è richiesto il suo consenso, il diniego non pregiudicherà gli obblighi assunti.',
            'privacy_policy_text_seventh_item' => ' I dati personali potranno essere trasferiti e trattati da altri soggetti, nella qualità di autorizzati, responsabili o titolari autonomi del trattamento dati, al fine di ottemperare ad obblighi precontrattuali, contrattuali, di legge, o per interesse legittimo. ',
            'privacy_policy_text_seventh_item_part_2' => ' I dati conferiti e raccolti dal Titolare del Trattamento non sono soggetti a pubblica diffusione o profilazione.',
            'privacy_policy_text_seventh_item_span' => ' Categorie dei destinatari potrebbero quindi essere, a titolo meramente indicativo: ',
            'privacy_policy_text_nineth_item' => ' I dati personali saranno conservati per il tempo strettamente necessario all’esecuzione delle attività connesse alle finalità di cui alla presente informativa. Nella fattispecie i tempi di conservazione saranno:',
            'privacy_policy_text_nineth_item_part_2' => ' Fatti salvi in ogni caso, periodi di conservazione maggiori se previsti da specifiche normative di settore. In caso di contenziosi, i dati personali verranno conservati fino al termine prescrizionale previsto dalla normativa per la tutela dei diritti connessi al rapporto contrattuale.',
            'privacy_policy_text_tenth_item' => '  Con apposita comunicazione scritta trasmessa a mezzo Pec o lettera raccomandata a/r all’indirizzo del Titolare del Trattamento, Lei ha:',
            'privacy_policy_text_tenth_item_part_2' => "Ottenere dal titolare del trattamento la conferma che sia o meno in corso un trattamento di dati personali che La riguardano e in tal caso, di ottenere l'accesso ai dati personali e a determinate informazioni specificatamente indicate all’art. 15 del GDPR.",
            'privacy_policy_text_tenth_item_part_3' => "Ottenere dal titolare del trattamento la rettifica dei dati personali inesatti che La riguardano senza ingiustificato ritardo. Tenuto conto delle finalità del trattamento, inoltre ha il diritto di ottenere l'integrazione dei dati personali incompleti, anche fornendo una dichiarazione integrativa.",
            'privacy_policy_text_tenth_item_part_4' => "Ottenere dal titolare del trattamento la cancellazione dei dati personali che La riguardano senza ingiustificato ritardo e il titolare del trattamento ha l'obbligo di cancellare senza ingiustificato ritardo i Suoi dati personali, salvo non vi siano motivi impeditivi all’esercizio del suddetto diritto.",
            'privacy_policy_text_tenth_item_part_5' => 'Ottenere, ove possibile, la limitazione del trattamento dei Suoi dati personali o revocare il consenso precedentemente reso. La revoca del consenso non pregiudicherà la liceità dei trattamenti effettuati in precedenza.',
            'privacy_policy_text_tenth_item_part_6' => 'Se il trattamento si basa sul consenso o su un contratto ed è effettuato con mezzi automatizzati, ha il diritto di ricevere in un formato strutturato, di uso comune e leggibile da dispositivo automatico i dati personali che ha fornito al titolare del trattamento e ha il diritto di trasmetterli ad un altro titolare del trattamento o farli trasferire direttamente dal titolare, se tecnicamente fattibile.',
            'privacy_policy_text_tenth_item_part_7' => "Opporsi in qualsiasi momento, per motivi connessi alla sua situazione particolare, al trattamento dei dati personali basati sull'interesse legittimo del titolare o sul Suo consenso, compresa la profilazione, salvo che il Titolare dimostri l'esistenza di motivi legittimi cogenti per procedere al trattamento che prevalgano sui Suoi diritti.",
            'privacy_policy_text_tenth_item_part_8' => 'Non essere sottoposto a una decisione basata unicamente sul trattamento automatizzato che produca effetti giuridici che La riguardino o che incida in modo analogo significativamente sulla Sua persona. Come espresso al paragrafo 7, il Titolare del Trattamento non utilizza processi decisionali automatizzati.',
            'privacy_policy_text_tenth_item_part_9' => 'Fatto salvo ogni altro ricorso amministrativo o giurisdizionale, qualora dovesse ritenere che il trattamento che La riguarda violi il presente regolamento può proporre reclamo all’Autorità di controllo, nonché, più in generale, esercitare tutti i diritti che gli sono riconosciuti dalle vigenti disposizioni di legge.',
            'privacy_policy_text_twelfth_item' => ' La presente informativa deve ritenersi valida anche per le posizioni aperte prima del 25.05.2018.',
            'privacy_policy_third_item' => '3. Come vengono raccolti i dati personali?',
            'privacy_policy_title' => 'Informativa Privacy Clienti',
            'privacy_policy_title_first_item' => 'Il Titolare del Trattamento',
            'privacy_policy_title_fourth_item' => 'Finalità del trattamento',
            'privacy_policy_title_fifth_item' => 'Modalità del Trattamento',
            'privacy_policy_title_sixth_item' => 'Natura del conferimento dei dati e rifiuto a conferirli',
            'privacy_policy_title_seventh_item' => 'Comunicazione dei dati',
            'privacy_policy_title_tenth_item' => 'Diritti dell’interessato',
            'privacy_policy_twelfth_item' => ' 12. Decorrenza e efficacia  ',
            'privacy_policy_title_consent' => 'Dichiarazioni di consenso al trattamento',
            'privacy_policy_title_footer' => 'Per presa visione dell’informativa',
            'privacy_policy_vers' => 'vers. 1.1 del 4.4.2019',
        ],
    ],

    'city_tax_channel' => [
        'default' => [
            'accommodations_mapping' => 'Mappatura camere',
            'scheduled_send' => 'Vuoi abilitare l\'invio automatico dei report?',
            'scheduled_send_info' => 'Il sistema invia automaticamente tutti gli ospiti in check-out del giorno precedente alla data odierna. Ad esempio il 25 Giugno invia gli ospiti in check-out del 24 Giugno.',
            'which_guests_to_send' => 'Invia automaticamente:',
            'only_invoiced' => 'Solo ospiti con tassa fatturata',
            'all_guest_with_city_tax_calculated' => 'Tutti gli ospiti con tassa calcolata',
        ],
        'pay_tourist' => [
            'structure_id' => 'Id PayTourist della struttura',
            'software_id' => 'Partner Software ID Autorizzato, rilasciato da PayTourist',
            'get_extra_specifications' => 'Ottieni tipologie camere',
            'token' => 'Token per accedere alle API, rilasciato da PayTourist',
            'period' => 'Periodo di cui fare il report della tassa di soggiorno',
            'calculation_type' => 'Tipo di calcolo della tassa di soggiorno',
            'calculation_percentage' => 'Calcolo in percentuale',
            'calculation_price_range' => 'Calcolo per fascia di prezzo',
            'calculation_amount' => 'Tipo di calcolo della tassa di soggiorno',
        ],
        'tourist_tax' => [
            'period' => 'Periodo di cui fare il report della tassa di soggiorno',
            'city_tax_channel_group_id' => 'Gruppo di configurazione di invio/esportazione del report delle tasse di soggiorno',
        ],
        'exceptions' => [
            'city_tax_channel_configuration_not_valid' => 'I seguenti parametri per l\'associazione di una struttura a un canale di invio della tassa di soggiorno non sono validi: ',
            'channel_configuration_not_valid' => 'I seguenti parametri richiesti dal canale :channelName non sono validi: :params',
            'channel_credential_not_valid' => 'Le credenziali per il canale :channelName non sono valide',
            'channel_configuration_must_have_one_property' => 'Il canale :channelName richiede al massimo una sola struttura',
            'channel_params_not_valid' => 'I seguenti parametri richiesti dal canale :channelName per creare il report non sono validi: :params',
            'channel_configuration_missing' => 'I parametri di configurazione richiesti dal canale :channelName non sono presenti all\'interno della request',
            'channel_params_missing' => 'I parametri richiesti dal canale :channelName per creare il report non sono presenti all\'interno della request',
            'city_tax_exemption_not_mapped' => 'Esenzione :exemptionName non prevista per l\'ospite :guestName :guestSurname della prenotazione :reservationId - :booker',
            'city_tax_channel_place_not_found' => 'Il comune :placeName non è ancora disponibile per il canale selezionato',
            'city_tax_channel_group_not_found' => 'Il gruppo selezionato non esiste',
            'file_not_valid' => 'Impossibile salvare il file esportato sul cloud per il canale :channelName',
            'networking_error' => 'Errore nella richiesta per l\'invio del report della prenotazione :reservationId per il canale :channelName per il seguente errore: :error',
            'channel_unreachable' => 'Impossibile raggiungere al momento il canale :channelName per i seguenti errori: :errors',
            'date_range_out_of_boundaries' => 'Il periodo massimo del report per il canale :channelName è di :days giorni dalla data di inizio',
            'date_from_not_valid' => 'La data minima di inizio di generazione del report per il canale :channelName è al massimo di :days giorni precedenti alla data di trasmissione',
            'guest_attributes_missing' => 'Impossibile inviare il report delle tasse di soggiorno per il canale :channelName a causa di dati mancanti per gli ospiti: :guests',
            'empty_report' => 'Nel report della tassa di soggiorno richiesto non è stato estratto nessun ospite',
            'endpoint_not_mapped' => "L'endpoint per il comune :place per il canale :channelName non è presente, contattare il supporto tecnico"
        ],
    ],

    'city_tax_configuration' => [
        'errors' => [
            'restriction_fields_not_valid' => 'I fields passati non appartengono alla restrizione di tassa di soggiorno passata',
            'option_fields_not_valid' => 'I fields passati non appartengono all\'opzione di tassa di soggiorno passata',
            'field_not_valid' => 'Il field :fieldNotValid passato non rispecchia la validazione :condition :validation',
            'configuration_override_already_exist' => 'Esiste già una configurazione della tassa di soggiorno che include le date selezionate',
        ],
        'exceptions' => [
            'city_tax_configuration_not_valid' => 'I seguenti parametri per creare la configurazione di una tassa di soggiorno non sono validi: ',
            'field_not_valid' => 'Il field :fieldName non è presente tra i field previsti della configurazione',
            'field_is_required' => 'Il field :fieldName è obbligatorio',
        ],
    ],

    'city_tax_option_field' => [
        'option_field' => [
            'nationality' => [
                'country_id' => [
                    'name' => 'Nazionalità',
                    'description' => 'Nazionalità dell\'ospite',
                ],
            ],
            'reservation_from' => [
                'reservation_from_id' => [
                    'name' => 'Provenienza',
                    'description' => 'Provenienza della prenotazione.',
                ],
            ],
            'reservation_reason' => [
                'reservation_reason_id' => [
                    'name' => 'Motivazione',
                    'description' => 'Motivo della prenotazione.',
                ],
            ],
            'group_leader' => [
                'active' => [
                    'name' => 'Attiva',
                    'description' => 'Attiva esclusione.',
                ]

            ],
            'residence_country' => [
                'country_id' => [
                    'name' => 'Nazione di residenza',
                    'description' => 'Nazione di residenza dell\'ospite.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Esenzione',
                    'description' => 'Esenzione'
                ]
            ],
            'residence_state' => [
                'state_id' => [
                    'name' => 'Regione di residenza',
                    'description' => 'Regione di residenza dell\'ospite.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Esenzione',
                    'description' => 'Esenzione'
                ]
            ],
            'residence_county' => [
                'county_id' => [
                    'name' => 'Provincia di residenza',
                    'description' => 'Provincia di residenza dell\'ospite.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Esenzione',
                    'description' => 'Esenzione'
                ]
            ],
            'residence_city' => [
                'city_id' => [
                    'name' => 'Città di residenza',
                    'description' => 'Città di residenza dell\'ospite.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Esenzione',
                    'description' => 'Esenzione'
                ]
            ],
            'accommodation_tableau_number' => [
                'accommodation_tableau_number_id' => [
                    'name' => 'Alloggio',
                    'description' => 'Alloggio',
                ],
            ],
            'accommodation' => [
                'accommodation_id' => [
                    'name' => 'Tipologia di Alloggio',
                    'description' => 'Tipologia di Alloggio',
                ],
            ],
        ],
    ],

    'city_tax_option' => [
        'option' => [
            'nationality' => [
                'name' => 'Nazionalità',
                'description' => 'Nazionalità dell\'ospite',
            ],
            'reservation_from' => [
                'name' => 'Provenienza',
                'description' => 'Provenienza della prenotazione.',
            ],
            'reservation_reason' => [
                'name' => 'Motivazione',
                'description' => 'Motivo della prenotazione.',
            ],
            'group_leader' => [
                'name' => 'Capogruppo',
                'description' => 'Capogruppo tra gli ospiti.',
            ],
            'residence_country' => [
                'name' => 'Nazione di residenza',
                'description' => 'Nazione di residenza dell\'ospite.',
            ],
            'residence_state' => [
                'name' => 'Regione di residenza',
                'description' => 'Regione di residenza dell\'ospite.',
            ],
            'residence_county' => [
                'name' => 'Provincia di residenza',
                'description' => 'Provincia di residenza dell\'ospite.',
            ],
            'residence_city' => [
                'name' => 'Città di residenza',
                'description' => 'Città di residenza dell\'ospite.',
            ],
            'accommodation_tableau_number' => [
                'name' => 'Alloggio',
                'description' => 'Alloggio.',
            ],
            'accommodation' => [
                'name' => 'Tipologia di Alloggio',
                'description' => 'Tipologia di Alloggio.',
            ],
        ],
    ],

    'city_tax_restriction_field' => [
        'restriction_field' => [
            'age_range' => [
                'min_age' => [
                    'name' => 'Età minima',
                    'description' => 'Età minima della fascia'
                ],
                'max_age' => [
                    'name' => 'Età massima',
                    'description' => 'Età massima della fascia'
                ],
                'amount_price' => [
                    'name' => 'Importo fisso',
                    'description' => 'Importo della tassa di soggiorno'
                ],
                'percentage_price' => [
                    'name' => 'Percentuale di importo',
                    'description' => 'Percentuale di calcolo per l\'importo'
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Esenzione',
                    'description' => 'Esenzione'
                ],
                'price_type' => [
                    'name' => 'Tipo di prezzo',
                    'description' => 'Tipologia di prezzo',
                ],
            ],
            'percentage_range' => [
                'min_amount' => [
                    'name' => 'Importo minimo',
                    'description' => 'Valore minimo del calcolo percentuale'
                ],
                'max_amount' => [
                    'name' => 'Importo massimo',
                    'description' => 'Valore massimo del calcolo percentuale'
                ],
            ],
            'validity_period' => [
                'date_from' => [
                    'name' => 'Inizio periodo',
                    'description' => 'Inizio periodo di validità'
                ],
                'date_to' => [
                    'name' => 'Fine periodo',
                    'description' => 'Fine periodo di validità'
                ],
                'flag_year' => [
                    'name' => 'Stagionalità',
                    'description' => 'Periodo valido ogni anno'
                ],
            ],
            'price_range_night' => [
                'min_price' => [
                    'name' => 'Prezzo minimo',
                    'description' => 'Prezzo minimo valido per il calcolo'
                ],
                'max_price' => [
                    'name' => 'Prezzo massimo',
                    'description' => 'Prezzo massimo valido per il calcolo'
                ]
            ],
            'limit_days' => [
                'days' => [
                    'name' => 'Notti di applicabilità',
                    'description' => 'Notti massime di applicabilità'
                ]
            ],
            'month_max_nights' => [
                'max_days' => [
                    'name' => 'Notti di applicabilità',
                    'description' => 'Se un ospite supera questo limite nel mese solare (anche per prenotazioni diverse e non consecutive) la tassa non viene più calcolata'
                ]
            ],
            'year_max_nights' => [
                'max_days' => [
                    'name' => 'Notti di applicabilità',
                    'description' => 'Se un ospite supera questo limite nell’anno solare (anche per prenotazioni diverse e non consecutive) la tassa non viene più calcolata'
                ]
            ],
            'reservation_max' => [
                'max' => [
                    'name' => 'Numero massimo',
                    'description' => 'Limite numero prenotazioni applicabili annualmente ad uno specifico ospite'
                ]
            ],
            'limit_nights' => [
                'min_nights' => [
                    'name' => 'Notti minime',
                    'description' => 'Numero minimo di notti della prenotazione.'
                ],
                'max_nights' => [
                    'name' => 'Notti massime',
                    'description' => 'Numero massimo di notti della prenotazione.'
                ]
            ],
            'range_nights' => [
                'night_from' => [
                    'name' => 'Dalla notte',
                    'description' => 'Notte di inizio conteggio.'
                ],
                'night_to' => [
                    'name' => 'Alla notte',
                    'description' => 'Notte di fine conteggio.'
                ],
                'amount_price' => [
                    'name' => 'Importo fisso',
                    'description' => 'Importo della tassa di soggiorno'
                ],
                'percentage_price' => [
                    'name' => 'Percentuale di importo',
                    'description' => 'Percentuale di calcolo per l\'importo'
                ],
                'price_type' => [
                    'name' => 'Tipo di prezzo',
                    'description' => 'Tipologia di prezzo',
                    'amount_name' => 'Importo',
                    'percentage_name' => 'Percentuale',
                ],
            ],
            'adult_quote_range' => [
                'min_amount' => [
                    'name' => 'Importo minimo',
                    'description' => 'Scegli l\'importo minimo della quota adulto calcolato sul prezzo della notte al netto dell\'IVA'
                ],
                'max_amount' => [
                    'name' => 'Importo massimo',
                    'description' => 'Scegli l\'importo massimo della quota adulto calcolato sul prezzo della notte al netto dell\'IVA'
                ],
                'amount_price' => [
                    'name' => 'Importo fisso',
                    'description' => 'Importo della tassa di soggiorno'
                ],
                'percentage_price' => [
                    'name' => 'Percentuale di importo',
                    'description' => 'Percentuale di calcolo per l\'importo'
                ],
                'price_type' => [
                    'name' => 'Tipo di prezzo',
                    'description' => 'Tipologia di prezzo',
                    'amount_name' => 'Importo',
                    'percentage_name' => 'Percentuale',
                ],
            ],
            'price_type_name' => [
                'amount_name' => '€',
                'percentage_name' => '%',
            ]
        ],
    ],

    'city_tax_restriction' => [
        'restriction' => [
            'age_range' => [
                'name' => 'Fascia di età',
                'description' => 'Fascia di età per l\'applicazione della tassa',
            ],
            'percentage_range' => [
                'name' => 'Limiti di importi in caso di calcoli percentuali',
                'description' => 'Limiti di importo min e max del calcolo percentuale.',
            ],
            'validity_period' => [
                'name' => 'Periodo di validità',
                'description' => 'Periodo di applicabilità della tassa.',
            ],
            'price_range_night' => [
                'name' => 'Range del prezzo giornaliero dell\'alloggio',
                'description' => 'Prezzo minimo e massimo che una notte deve avere per essere presa in considerazione dal calcolo della tassa.',
            ],
            'limit_days' => [
                'name' => 'Notti massime di applicabilità',
                'description' => 'Limite delle notti di applicazione.',
            ],
            'month_max_nights' => [
                'name' => 'Limite notti applicabili mensilmente ad uno specifico ospite',
                'description' => 'Numero massimo di notti applicabili in un mese per ospite.',
            ],
            'year_max_nights' => [
                'name' => 'Limite notti applicabili annualmente ad uno specifico ospite',
                'description' => 'Numero massimo di notti applicabili in un anno per ospite.',
            ],
            'reservation_max' => [
                'name' => 'Limite numero prenotazioni applicabili annualmente ad uno specifico ospite',
                'description' => 'Numero massimo di prenotazioni in un anno  per ospite.',
            ],
            'limit_nights' => [
                'name' => 'Limiti di notti di applicabilità all’interno di una prenotazione',
                'description' => 'Numero minimo e massimo di notti di una prenotazione per applicare la tassa.',
            ],
            'range_nights' => [
                'name' => 'Sovrascrivi calcolo in base alle notti della prenotazione',
                'description' => 'Numero della notte di inizio e di fine per la prenotazione.',
            ],
            'adult_quote_range' => [
                'name' => 'Prezzo per quota ospite del pernottamento',
                'description' => 'Scegli il range di quota ospite e il relativo prezzo.',
            ],
        ],
    ],

    'city_tax' => [
        'tax_type' => [
            'xpax' => [
                'name' => 'Importo per persona',
                'description' => 'La tassa viene calcolata per ogni ospite secondo gli importi scelti, non considerando il numero di notti di pernottamento.',
            ],
            'xnightxpax' => [
                'name' => 'Importo per persona a notte',
                'description' => 'La tassa viene calcolata per ogni ospite su tutte le notti di pernottamento secondo gli importi scelti.',
            ],
            'xnight' => [
                'name' => 'Importo per notte',
                'description' => 'La tassa viene calcolata su ogni notte di pernottamento secondo l\'importo scelto, non considerando il numero di ospiti.',
            ],
            'xroomxnight' => [
                'name' => 'Importo percentuale su prezzo alloggio a notte',
                'description' => 'La tassa viene calcolata come percentuale del prezzo dell\'alloggio su ogni notte di pernottamento, non considerando il numero di ospiti.',
            ],
            'xroomxnightxpax' => [
                'name' => 'Importo percentuale su quota alloggio per persona a notte',
                'description' => 'La tassa viene calcolata per ogni ospite su tutte le notti di pernottamento come percentuale sulla quota alloggio (prezzo alloggio diviso numero ospiti).',
            ],
            'xroomxtotalnightxpax' => [
                'name' => 'Importo percentuale su prezzo alloggio per persona a notte',
                'description' => 'La tassa viene calcolata per ogni ospite su tutte le notti di pernottamento come percentuale del prezzo dell\'alloggio',
            ],
            'xtotalroomxnightxpax' => [
                'name' => 'Importo percentuale su prezzo totale (alloggio + extra) per persona a notte',
                'description' => 'La tassa viene calcolata su ogni ospite per tutte le notti di pernottamento come percentuale del prezzo totale (alloggio + extra).',
            ],
            'xbook' => [
                'name' => 'Importo fisso una tantum',
                'description' => 'La tassa viene calcolata con l\'importo fisso scelto a prescindere dal numero di notti e ospiti.',
            ],
            'xroomextraxnightxpax' => [
                'name' => 'Importo percentuale su quota alloggio + extra per persona a notte',
                'description' => 'La tassa viene calcolata per ogni ospite su tutte le notti di pernottamento come percentuale sulla quota alloggio + extra (prezzo alloggio + extra diviso numero ospiti).',
            ],
        ],
        'price_type' => [
            'amount' => 'Importo',
            'percentage' => 'Percentuale',
            'amount_percentage' => 'Importo e percentuale',
        ],
        'warnings' => [
            'no_tax_for_accommodation' => 'Sull\'alloggio :accommodation_name non è applicabile nessuna delle configurazioni di tassa di soggiorno presenti.',
            'no_guests_for_accommodation' => 'Per l\'alloggio :accommodation_name non sono presenti ospiti per cui è necessario effettuare il calcolo della tassa di soggiorno.',
        ],
        'errors' => [
            'no_city_tax_configuration' => 'Tasse di soggiorno non configurate.'
        ],
        'city_tax_extra_text' => 'L\'importo della tassa è una stima e potrebbe subire variazioni in presenza di condizioni stabilite dalle normative vigenti al momento del soggiorno.',
    ],

    'cloners' => [
        'treatments' => [
            'description' => 'Questa opzione ti permetterà di clonare i trattamenti della struttura sorgente verso la destinazione. Selezionando questa opzione i trattamenti della struttura sorgente verranno eliminati.',
        ],
        'accommodations' => [
            'description' => 'Questa opzione ti permetterà di clonare le camera della struttura sorgente. Se viene selezionata insieme ai piani tariffari verranno creati i legami in modo da rispecchiare la struttura sorgente.',
        ],
        'priceLists' => [
            'description' => 'Questa opzione ti permetterà di clonare i listini della struttura sorgente',
        ],
        'ratePlans' => [
            'description' => 'Questa opzione ti permetterà di clonare i piani tariffari della struttura sorgente.',
        ],
        'rates' => [
            'description' => 'Questa opzione ti permetterà di clonare le tariffe della struttura sorgente.',
        ],
        'modules' => [
            'description' => 'Questa opzione ti permetterà di clonare i moduli della struttura sorgente.',
        ],
        'customers' => [
            'description' => 'Questa opzione ti permetterà di clonare i clienti della struttura sorgente.',
        ],
        'companies' => [
            'description' => 'Questa opzione ti permetterà di clonare le aziende della struttura sorgente.',
        ],
        'invoiceLayouts' => [
            'description' => 'Questa opzione ti permetterà di clonare i profili di fatturazione della struttura sorgente',
        ],
        'addons' => [
            'description' => 'Questa opzione ti permetterà di clonare i servizi extra della struttura sorgente.',
        ],
        'availabilities' => [
            'description' => 'Questa opzione ti permetterà di clonare le disponibilità della struttura sorgente',
        ],
        'childrenRanges' => [
            'description' => 'Questa opzione ti permetterà di clonare le fasce bambino della struttura sorgente.',
        ],
        'roles' => [
            'description' => 'Questa opzione ti permetterà di clonare i ruoli della struttura sorgente.',
        ],
        'paymentMethods' => [
            'description' => 'Questa opzione ti permetterà di clonare i metodi di pagamento della struttura sorgente.',
        ],
        'rules' => [
            'description' => 'Questa opzione ti permetterà di clonare tutte le regole della struttura sorgente.',
        ],
        'emailTemplates' => [
            'description' => 'Questa opzione ti permetterà di clonare tutti i template email della struttura sorgente.',
        ],
        'events' => [
            'description' => 'Questa opzione ti permetterà di clonare tutti gli eventi della struttura sorgente.',
        ],
        'policies' => [
            'description' => 'Questa opzione ti permetterà di clonare tutte le condizioni di cancellazione della struttura sorgente.',
        ],
        'cityTaxes' => [
            'description' => 'Questa opzione ti permetterà di clonare il tab: Configurazioni tassa di soggiorno.',
        ],
    ],

    'common' => [
        'datetime' => [
            'default' => '%d/%m/%Y %H:%M',
            'extended_phrasal_date' => '%A, %e %B %Y', // "Venerdì,  7 Giugno 2019"
            'extended_phrasal_date_short' => '%a, %e %b %Y', // "Ven,  7 Giu 2019"
            'extended_phrasal_date_with_time' => '%A, %e %B %Y - %H:%M', // "Venerdì,  7 Giugno 2019 - 18:03"
            'extended_phrasal_date_short_with_time' => '%a, %e %b %Y - %H:%M', // "Ven,  7 Giu 2019 - 18:03"
            'phrasal_date' => '%e %B %Y', // " 7 Giugno 2019"
            'phrasal_date_short' => '%e %b %Y', // " 7 Giu 2019"
            'date' => '%d/%m/%Y', // "07/06/2019" per 7 giugno 2019
            'for_range' => '%d %b', // "04 Apr" - per quando si deve indicare un range di date, ad es: "04 Apr - 07 Apr"
            'time' => '%H:%M', // orario in formato 24 ore; es.: "00:00" oppure "18:03"

            'year' => 'Anno',
            'month' => 'Mese',
            'day' => 'Giorno,',
            'time' => 'Orario',

            'dates_interval' => 'Intervallo di date',
            'from_day' => 'Dal',
            'to_day' => 'Al',
            'days' => 'Giorni',

            'months' => [
                1 => 'Gennaio',
                2 => 'Febbraio',
                3 => 'Marzo',
                4 => 'Aprile',
                5 => 'Maggio',
                6 => 'Giugno',
                7 => 'Luglio',
                8 => 'Agosto',
                9 => 'Settembre',
                10 => 'Ottobre',
                11 => 'Novembre',
                12 => 'Dicembre',
            ],

            'months_short' => [
                1 => 'Gen',
                2 => 'Feb',
                3 => 'Mar',
                4 => 'Apr',
                5 => 'Mag',
                6 => 'Giu',
                7 => 'Lug',
                8 => 'Ago',
                9 => 'Set',
                10 => 'Ott',
                11 => 'Nov',
                12 => 'Dic',
            ],

            'days_of_week' => [
                'Domenica',
                'Lunedì',
                'Martedì',
                'Mercoledì',
                'Giovedì',
                'Venerdì',
                'Sabato',
            ],
            'days_of_week_short' => [
                'Dom',
                'Lun',
                'Mar',
                'Mer',
                'Gio',
                'Ven',
                'Sab',
            ],
            'days_of_week_initials' => [
                'D',
                'L',
                'M',
                'M',
                'G',
                'V',
                'S',
            ],
        ],

        'currency' => [
            'display' => ':prefix :symbol :amount',
            'format' => '%.2n',
        ],

        'gender' => [
            'male' => 'Uomo',
            'female' => 'Donna',
        ],

        'bool' => [
            'yes_no' => [
                1 => 'Sì',
                0 => 'No',
            ],
            'true_false' => [
                1 => 'Vero',
                0 => 'Falso',
            ],
        ],

        'exports' => [
            'customers_generic' => 'Elenco Anagrafiche Clienti',
            'companies_generic' => 'Elenco Anagrafiche Aziende',
            'reservations_generic' => 'Elenco Prenotazioni',
            'reservations_invoices_opened_generic' => 'Elenco Conti aperti',
            'reservations_invoices_generic' => 'Elenco Fatture',
            'social_archive_generic' => 'Elenco Clienti offerta sbloccabile',

            // "active", "revoked", "accepted", "expired", "draft"
            'reservations_quotes_all_generic' => 'Elenco Preventivi',
            'reservations_quotes_active_generic' => 'Elenco Preventivi Attivi',
            'reservations_quotes_revoked_generic' => 'Elenco Preventivi Rifiutati',
            'reservations_quotes_accepted_generic' => 'Elenco Preventivi Accettati',
            'reservations_quotes_expired_generic' => 'Elenco Preventivi Scaduti',
            'reservations_quotes_draft_generic' => 'Elenco Preventivi in stato Bozza',

            'rateplans_generic' => 'Elenco Piani Tariffari, Offerte e Pacchetti',
            'rateplans_plans_generic' => 'Elenco Piani Tariffari',
            'rateplans_offers_generic' => 'Elenco Offerte',
            'rateplans_bundles_generic' => 'Elenco Pacchetti',
            'coupons_generic' => 'Elenco Coupons',
            'reservations_list' => 'Lista Prenotazioni',

            'housekeeper' => 'governante_:date',

            'total_entries' => 'Totale righe: :value',
            'meals' => 'Pasti',
            'meals_plan' => 'Piano pasti',
            'city_tax' => 'Tassa di soggiorno',
            'reservations_guests_presences' => 'Ospiti in casa',
            'deposits' => 'Acconti e caparre',
            'failed_imports' => 'Importazioni fallite',
        ],

        'number_of_nights' => 'Numero di notti',
        'user_full_name' => 'Operatore',
        'print_date' => 'Data stampa',
        'total' => 'Totale',
        'totals' => 'Totali',
        'quantity' => 'Quantità',
        'category' => 'Categoria',
        'qty' => 'Q.tà',
        'discount' => 'Sconto',
        'description' => 'Descrizione',
        'wrap_up' => 'Riepilogo',
        'amount' => 'Importo',
        'vat' => 'IVA',
        'nic' => 'CF',
        'reservation' => 'Prenotazione',
        'nights' => '{1} 1 Notte|[2,*] :count Notti',
        'accommodation' => '{1} 1 Alloggio|[2,*] :count Alloggi',
        'vat_code' => 'P.IVA',
        'unmapped_addons' => 'Servizi extra da portale ',
        'details' => 'Dettagli',
        'stripe_statement_descriptor' => 'Numero prenotazione: :reservationNumber - :email',
        'date' => 'Data',
        'available_soon' => 'Questa funzionalità sarà disponibile a breve',
        'payments' => 'Pagamenti',
        'buyer' => 'Pagante',
        'payment_method' => 'Metodo',
        'yes' => 'Si',
        'no' => 'No',
        'checkin_hour' => 'Checkin ore',
        'checkout_hour' => 'Checkout ore',
    ],

    'company' => [
        'errors' => [
            'vat_code_not_valid' => "La partita IVA inserita non è valida",
            'tax_code_not_valid' => "Il codice fiscale inserito non è valido"
        ],
        'warnings' => [
            'existing_company' => "Esiste già l'azienda :company_name associata alla partita iva inserita",
        ],
        'fields' => [
            'company_id' => 'identificativo azienda'
        ],

        'export_fields' => [
            'name' => 'Nome',
            'address' => 'Indirizzo',
            'vat_code' => 'Partita IVA',
            'zip_code' => 'CAP',
            'email' => 'Email',
            'telephone' => 'Telefono',
            'state' => 'Regione',
            'county' => 'Provincia',
            'country' => 'Nazione',
            'city' => 'Comune',
            'tax_code' => 'Codice Fiscale',
            'nick_name' => 'Nickname',
        ],

        'import' => [
            'validations' => [
                'vat_code_unique' => 'Esiste già un azienda con la stessa Partita IVA',
                'vat_code_required' => 'Il campo Partita IVA è obbligatorio',
                'name_required' => 'Il campo ragione sociale è obbligatorio',
                'nick_name_required' => 'Il campo nick_name è obbligatorio',
                'email' => 'Il campo email non contiene una email valida',
                'pec' => 'Il campo pec non contiene una email valida',
                'company_type' => 'Campo tipologia azienda non valido,  i valori concessi sono: :values',
            ],
        ],
    ],

    'content_api' => [
        'bank_transfer' => 'Accetta bonifico bancario',
        'bank_transfer_note' => 'Note per il pagamento Bancario (MAX 500 caratteri)',
        'checkin_hour' => 'Ora del checkin',
        'checkout_hour' => 'Ora del checkout',
        'children_allowed' => 'Bambini ammessi',
        'pets_allowed' => 'Animali ammessi',
        'smoking_allowed' => 'Fumatori ammessi',
        'max_adults_number' => 'Numero massimo adulti',
        'max_guests_number' => 'Numero massimo ospiti',
        'minimum_age' => 'Età minima',
        'percent_payment_at_booking' => '% pagamento in fase di prenotazione',
        'remaining_payment_type' => 'Restante pagamento',
        'remaining_payment_type_at_checkin_label' => 'Pagamento al check-in',
        'remaining_payment_type_at_checkin_description' => 'Il completamento del pagamento verrà richiesto in fase di check-in',
        'remaining_payment_type_before_checkin_label' => 'Pagamento X giorni prima del check-in',
        'remaining_payment_type_before_checkin_description' => 'Il completamento del pagamento verrà richiesto X giorni prima del check-in',
        'remaining_payment_type_before_checkin_day' => 'Numero di giorni prima del check-in',
        'rental_document_upload' => 'Upload documento di affitto',
        'advertise_name' => 'Nome inserzionista',
        'merchant_name' => 'Nome del commerciante',

        'managment_applies_guest_value' => 'Costi gestione ospite',
        'managment_applies_guest_type' => 'Tipologia costi gestione ospite',

        'managment_applies_pets_value' => 'Costi gestione animali',
        'managment_applies_value' => 'Costo gestionale',

        'management_energy_value' => 'Costi gestione energia',
        'management_energy_type' => 'Tipologia costi gestione energia',

        'managment_applies_pets_type' => 'Tipologia costi gestione animali',

        'x_night' => 'Per notte',
        'x_stay' => 'Per soggiorno',
    ],

    'coupons' => [
        'refundable' => [
            '0' => 'Non rimborsabile',
            '1' => 'Rimborsabile',
        ],

        'export_fields' => [
            'code' => 'Codice',
            'quantity' => 'Quantità',
            'discount' => 'Sconto',
            'date_from' => 'Dal',
            'date_to' => 'Al',
            'type' => 'Tipo',

            'min_expense' => 'Spesa minima',
            'min_stay' => 'Sogg. min.',
            'max_stay' => 'Sogg. max',
            'valid_days' => 'Giorni di validità',
        ],
    ],

    'credit_card_type' => [
        'errors' => [],
        'warnings' => [],
        'fields' => [
            'model_name' => 'Carta di Credito',
        ],
    ],

    'customer' => [
        'errors' => [
            'reservationExists' => 'Esistono prenotazioni o preventivi collegati.',
            'guestExist' => 'Esistono ospiti collegati.',
            'documentExists' => 'Esiste un documento dello stesso tipo in archivio.',
            'privacyCheckExists' => 'La privacy è gia stata accettata dal cliente',
            'customerNotFound' => 'Cliente non trovato',
            'guestExists' => 'Cliente configurato come ospite in prenotazioni attive',
            'tax_code_not_valid' => "Il codice fiscale inserito non è valido",
            "birthday_date_major_than_now" => "La data di nascita non può essere maggiore della data odierna",
        ],
        'warnings' => [],
        'fields' => [
            'birthday_date' => 'data di nascita ospite',
            'sex' => 'sesso ospite',
            'address' => 'indirizzo ospite',
            'zip_code' => 'cap ospite',
            'email' => 'email ospite',
            'telephone' => 'telefono ospite',
            'name' => 'nome ospite',
            'surname' => 'cognome ospite',
            'model_name' => 'ospite',
            'language_id' => 'lingua'
        ],

        'export_fields' => [
            'name' => 'Nome',
            'surname' => 'Cognome',
            'birthday_date' => 'Data di nascita',
            'sex' => 'Sesso',
            'note' => 'Note',
            'city' => 'Città',
            'county' => 'Provincia',
            'state' => 'Regione',
            'country' => 'Nazione',
            'address' => 'Indirizzo',
            'zip_code' => 'CAP',
            'email' => 'Email',
            'telephone' => 'Telefono',
            'fax' => 'Fax',
            'facebook' => 'Facebook',
            'linkedin' => 'Linkedin',
            'twitter' => 'Twitter',
            'web_address' => 'Sito web',

            'birth_city_name' => 'Città di nascita',
            'birth_state_name' => 'Stato di nascita',
            'birth_state' => 'Regione di nascita',

            'residence_city' => 'Residenza - Città',
            'residence_county' => 'Residenza - Provincia',
            'residence_state' => 'Residenza - Regione',
            'residence_country' => 'Residenza - Nazione',
            'residence_address' => 'Residenza - Indirizzo',
            'residence_zip_code' => 'Residenza - CAP',

            'billing_city' => 'Fatturazione - Città',
            'billing_county' => 'Fatturazione - Provincia',
            'billing_state' => 'Fatturazione - Regione',
            'billing_country' => 'Fatturazione - Nazione',
            'billing_address' => 'Fatturazione - Indirizzo',
            'billing_zip_code' => 'Fatturazione - CAP',

            'promotion_check' => 'Newsletter',
            'privacy_check' => 'GDPR',

            'reservations_count' => 'Prenotazioni',
            'type' => 'Tipo',

            'newsletter' => 'Newsletter',
            'GDPR' => 'GDPR',
        ],

        'import' => [
            'validations' => [
                'nic_unique' => 'Esiste già un cliente con lo stesso codice fiscale',
                'name_required' => 'Il campo nome è obbligatorio',
                'sex' => 'Il campo sesso non è valido, i valori concessi sono: :values',
                'surname_required' => 'Il campo cognome è obbligatorio',
                'email' => 'Il campo email non contiene una email valida',
                'pec' => 'Il campo pec non contiene una email valida',
                'birthday_date_date_format' => 'Il campo data di nascita non è formattato correttamente',
                'expiration_date_date_format' => 'Il campo data di scadenza del documento non è formattato correttamente',
                'document_type' => 'Il tipo di documento non esiste',
                'birth_country_not_valid' => 'Il campo nazione di nascita non è valido',
                'birth_city_not_valid' => 'Il campo città di nascita non è valido',
                'invoicing_country_not_valid' => 'Il campo nazione di fatturazione non è valido',
                'invoicing_city_not_valid' => 'Il campo città di fatturazione non è valido',
                'released_country_not_valid' => 'Il campo nazione di rilascio documento non è valido',
                'released_city_not_valid' => 'Il campo città di rilascio documento non è valido',
                'citizenship_country_not_valid' => 'Il campo cittadinanza non è valido',
                'residence_country_not_valid' => 'Il campo nazione di residenza non è valido',
                'residence_city_not_valid' => 'Il campo città di residenza non è valido',
                'nationality_country_not_valid' => 'Il campo nazionalità non è valido',
                'language' => 'Campo lingua non valido, inserire il formato ISO 639-1 (due lettere) ad esempio it
ISO 639-2 (3 lettere) ad esempio ita
Il nome esteso della lingua sia in italiano che tradotto in inglese francese, tedesco e spagnolo ad esempio italiano, italian, italien, italienisch, italiano',
                'document_type' => 'Campo tipologia documento non valido,  i valori concessi sono: :values',
                'string' => 'Il campo :attribute non è una stringa valida',
            ],
            'alredy-in-progress' => 'L\'importazione è ancora in corso, attendi il completamento e riprova',
            'validated_records_confirm_import' => 'Saranno importati :validated contatti su :count, vuoi procedere?',
            'task_not_found' => 'Task di importazione non trovato o non validato',
        ],
    ],

    'daily_closure' => [
        'daily_title' => 'Chiusura giornaliera',
        'department' => 'Reparto',
        'production' => 'Produzione',
        'total' => 'Totale',
        'property' => 'Struttura',
        'receipt' => 'Ricevuta',
        'name' => 'Nome',
        'invoice' => 'Fattura',
        'amount' => 'Saldo',
        'guests' => 'Ospiti',
        'accommodation' => 'Camere',
        'empty_documents' => 'Nessun documento emesso o ricevuto nel periodo selezionato',
        'empty_payments' => 'Nessun pagamento emesso o ricevuto nel periodo selezionato',

        'export_fields' => [
            'production_department' => 'Produzione per reparto',
            'production_treatments' => 'Produzione per trattamento',
            'production_accommodations' => 'Produzione per alloggio',
            'occupancy' => 'Occupazione',
            'documents' => 'Documenti del :date_from|Documenti dal :date_from al :date_to',
            'payments' => 'Pagamenti del :date_from|Pagamenti dal :date_from al :date_to',
            'summary' => 'Riepilogo cassa (:date_from)|Riepilogo cassa (:date_from - :date_to)',
            'accommodations_sold' => 'Camere vendute',
            'sold_nights' => 'Notti vendute',
            'unsold_nights' => 'Notti invendute',
            'penalty_nights' => 'Notti in penale',
            'accommodations_available' => 'Camere disponibili',
            'date' => 'Data',
            'income' => 'Incasso',
            'outcome' => 'Uscite',
            'occupancy' => 'Occupazione',
            'payment_method' => 'Metodo di pagamento',
            'type' => 'Tipologia',
            'reversal_receipt' => 'Storno ricevuta',
            'number' => 'Numero',
            'in' => 'Entrate',
            'out' => 'Uscite',
            'intestatary' => 'Intestatario',
            'name' => 'Nome',
            'modality' => 'Modalità',
            'note' => 'Note',
            'taxable' => 'Imponibile',
            'vat_quote' => 'IVA',
            'treatment' => 'Trattamento',
            'average_revenue' => 'Ricavo Medio Ospite',
            'adr' => 'Adr',
            'revpar' => 'RevPar',
            'reservations' => 'Prenotazioni',
            'no_show' => 'No-Show',
            'confirmed' => 'Confermate',
            'cancelled' => 'Cancellate',
            'optionable' => 'Opzioni',
            'expired' => 'Scadute',
            'unknown' => 'Sconosciuto',
            'checkin' => 'Arrivi',
            'checkout' => 'Partenze',
            'in_house' => 'Fermate',
            'attendance' => 'Presenze',
            'absolute_guests' => 'Ospiti Assoluti',
        ],
    ],

    'daily_summary' => [
        'daily_summary' => 'Riepilogo Giornaliero',
        'accommodation' => 'Camera',
        'accommodation_type' => 'Tipologia di camera',
        'name_and_surname' => 'Nome e cognome',
        'stay' => 'Soggiorno',
        'guests' => 'Ospiti',
        'treatment' => 'Trattamento',
        'channel' => 'Canale',
        'payment_details' => 'Dettagli di pagamento',
        'notes' => 'Note',
        'adults' => 'Adulti',
        'children' => 'Bambini',
        'total' => 'Totale',
        'arrivals' => 'Arrivi',
        'departures' => 'Partenze',
        'in_home' => 'In fermata',
        'nights' => 'Notti',
        'paid' => 'Pagato',
        'to_pay' => 'Da pagare',
        'no_reservations_found' => 'Non sono presenti prenotazioni per questa data',
        'daily_summary_of_date' => 'Riepilogo giornaliero del :date',
    ],

    'deposits' => [
        'export_fields' => [
            'property' => 'Struttura',
            'number' => 'Numero',
            'deposit_number' => 'Numero',
            'document_number' => 'Numero documento',
            'date' => 'Data',
            'registration_date' => 'Data',
            'type' => 'Tipo',
            'amount' => 'Importo',
            'amount_available' => 'Importo disponibile',
            'amount_used' => 'Utilizzato',
            'reservation_number' => 'ID Prenotazione',
            'pos' => 'Pos',
            'description' => 'Descrizione',
            'buyer' => 'Pagante',
            'reservation_id' => 'ID Prenotazione',
            'used_amount' => 'Utilizzato',
            'user_pay' => 'Pagante',
            'reservation' => 'Prenotazione',
            'payment_method' => 'Metodo di pagamento',
            'arrival_date' => 'Data di arrivo',
            'departure_date' => 'Data di partenza',
            'deposit' => 'Caparra',
            'part_payment' => 'Acconto',
            'stay' => 'Soggiorno',
        ],
    ],

    'email_suppression_list' => [
        'reason_types' => [
            'BOUNCE' => 'Mancato recapito',
            'COMPLAINT' => 'Segnalato come SPAM'
        ],
        'errors' => [
            'NotFoundException' => 'Email non trovata',
            'BadRequestException' => 'Parametri della richiesta non validi',
            'TooManyRequestsException' => 'Troppe richieste effettuate',
            'TooManyRequestException' => 'Troppe richieste effettuate'
        ],
    ],

    'emails' => [
        'multiple_sessions' => [
            'subject' => 'Avviso di sicurezza: più dispositivi connessi al suo account',
            'body' => "Salve :user_first_name,<br />abbiamo rilevato connessioni da più dispositivi al suo account, le consigliamo di verificare le sessioni attualmente attive:",
            'summary_reset' => 'Se non conosce questi dispositivi le <a href=":recoveryPasswordLink" target="_blank"> consigliamo di cambiare immediatamente la password</a> per proteggere il suo account.',
            'device' => 'Dispositivo',
            'place' => 'Luogo',
            'date_hour' => 'Data e ora',
            'unknown' => 'Sconosciuto',
            'logout' => 'Inoltre, è possibile effettuare la <a href=":logoutAllDevice" target="_blank"> disconnessione</a> da tutti i dispositivi dal menu Profilo > Protezione e accesso.',
        ],
        'general' => [
            'link_preview' => 'clicca qui per la versione stampabile',
            'additionals_informations' => 'Informazioni addizionali',
            'automatic_email_message' => 'Questa email viene inviata automaticamente, ti preghiamo quindi di non rispondere a questo indirizzo.',
            'message' => 'Messaggio'
        ],
        'reservation_confirmed' => [
            'subject' => 'Prenotazione numero #:reference_number',
            'reservation_confirm' => 'La tua prenotazione',
            'reply' => 'Rispondi',
            'tax' => 'Tasse',
            'reservation_number' => 'numero',
            'thanks' => 'Grazie',
            'view_quote' => 'clicca qui per vedere il preventivo',
            'show_detail' => '<a href=":showDetailsReservation">Clicca qui per visualizzare la prenotazione</a>',
            'confirm_reservation_with_bank_transfer_suggestion' => 'Per completare la prenotazione ti consigliamo di concludere al più presto il pagamento',
            'your_reservation' => 'La tua prenotazione per',
            'is_confirmed' => 'è confermata',
            'ti_aspettiamo_il' => 'Ti aspettiamo il',
            'city_tax' => 'Tassa di soggiorno',
            'reservation_summary' => 'Riepilogo Prenotazione',
            'nights' => 'Notte|Notti',
            'accommodations' => 'Alloggio|Alloggi',
            'adults' => 'adulto|adulti',
            'childrens' => 'bambino|bambini',
            'reservation_confirmed_with_stripe' => 'La prenotazione è stata confermata usando il gateway di pagamento di Stripe',
            'total_reservation' => 'Totale prenotazione',
            'price_payed' => 'Importo pagato',
            'price_to_pay' => 'Importo da pagare',
            'payment_method' => 'Metodo di pagamento',
            'other_request' => 'Specifiche e altre richieste',
            'banktransfer_informations' => 'Coordinate Bancarie',
            'printable_link' => 'Clicca qui per la versione stampabile',
            'other_operations' => 'Altre operazioni',
            'checkin' => 'Effettua Check-In Online',
            'modify_reservation' => 'Modifica la prenotazione',
            'cancel_reservation' => 'Cancella la prenotazione',
            'additional_informations' => 'Informazioni aggiuntive',
            'contability_informations' => 'Alla ricezione della contabile di <b>:price_deposit</b> procederemo con la conferma della prenotazione. Per velocizzare l\'operazione ti consigliamo di inviarci copia della disposizione con il numero di CRO.',
            'checkin_online_pin' => 'Il tuo codice per effettuare il <a style="color: #8f743f; text-decoration: underline !important;" target="_blank" href=":link">Check-In</a> online è ',
            'pin' => 'Pin',
        ],
        'reservation_request_avail' => [
            'subject' => 'Richiesta disponibilità per :property_name  (:arrival_date - :departure_date)',
            'reservation_confirm' => 'Richiesta di disponibilità',
            'reply' => 'Rispondi',
            'tax' => 'Tasse',
            'reservation_number' => 'numero',
            'thanks' => 'Grazie',
            'view_quote' => 'clicca qui per vedere il preventivo',
            'show_detail' => 'clicca qui per visualizzare la prenotazione',
            'show_detail_avail' => 'clicca qui per visualizzare la richiesta di disponibilità',
            'your_request_avail' => 'La tua richiesta di disponibilità per',
            'is_confirmed' => 'è stata inviata',
            'invalid_reservation' => 'Ti ricordiamo che la presente richiesta non ha valore di prenotazione finché non verrà confermata.',
            'invalid_reservation_property' => 'La presente richiesta non ha valore di prenotazione, il cliente attende la tua Conferma',
            'receive_news' => 'Riceverai nostre notizie nel più breve tempo possibile.',
            'city_tax' => 'Tassa di soggiorno',
            'reservation_summary' => 'Riepilogo Richiesta',
            'nights' => 'Notte|Notti',
            'accommodations' => 'Alloggio|Alloggi',
            'adults' => 'adulto|adulti',
            'childrens' => 'bambino|bambini',
            'total_reservation' => 'Totale prenotazione',
            'price_payed' => 'Importo pagato',
            'price_to_pay' => 'Importo da pagare',
            'payment_method' => 'Metodo di pagamento',
            'other_request' => 'Specifiche e altre richieste',
            'printable_link' => 'Clicca qui per la versione stampabile',
            'other_operations' => 'Altre operazioni',
            'additional_informations' => 'Informazioni aggiuntive',
        ],
        'reservation_cancelled_from_user' => [
            'subject' => 'Prenotazione cancellata (#:reference_number)',
            'body_1' => 'Salve,<br>la presente email automatica le conferma la cancellazione della prenotazione n.<b>:reference_number</b> effettuata il <b>:booked_at</b>.',
            'body_2' => '<b>Riepilogo prenotazione</b><br>
                         <b>:name :surname</b> (dal <b>:arrival_date</b> al <b>:departure_date</b>)<br>
                         <b>Camera:</b> :reservation_accommodations<br>
                         <b>Ospiti: </b> :total_guests<br>
                         <b>Totale: </b> :currency  :total_price',
            'body_policy_no_penalty' => 'Secondo le <b>Condizioni di Cancellazione</b> non va incontro ad alcuna penale.',
            'body_policy_penalty' => 'Secondo le <b>Condizioni di Cancellazione</b> va incontro ad una penale di :currency :penalty_value .',
            'body_3' => 'Per ulteriori informazioni non esiti a contattarci.',
        ],
        'property_reservation_new' => [
            'subject' => 'Nuova prenotazione da :channel_name - :property_name (#:reference_number)',
        ],
        'property_reservation_modified' => [
            'subject' => 'Modifica prenotazione da :channel_name (#:reference_number)',
        ],
        'invoice_rejected' => [
            'subject' => 'Fattura :number_complete del :invoice_date rifiutata dallo SDI',
            'body' => 'La fattura numero <b>:number_complete</b> è stata rifiutata dallo SDI per il seguente motivo: <b>:rejected_reason</b>',
        ],
        'invoice_received' => [
            'subject' => 'Ricevuta fattura :document_number del :document_date da :sender_name',
            'body' => 'E\'stata ricevuta la fattura numero <b>:document_number</b> di giorno <b>:document_date</b> da parte di <b>:sender_name</b>',
        ],
        'document_default_email' => [
            'body' => 'Gentile Cliente,<br>di seguito le informazioni relative alla :document_type :document_number del :document_date.<br>In allegato trova copia del documento.<br><br>Cogliamo l\'occasione per porgerle<br>Distinti Saluti,<br>:sender_name',
        ],
        'suspend_email_reminder' => [
            'subject' => "{{% invoice.type %}} n. {{% invoice.number_complete %}}",
            'body' => "Gentile Cliente,<br>ci risulta che la {{% invoice.type %}} {{% invoice.number_complete %}} del {{% invoice.invoice_date %}} di {{% invoice.total %}} non è stata ancora saldata.<br><br>La preghiamo pertanto di regolarizzare al più presto la posizione contabile.<br>In allegato trova copia del documento.<br><br>Nel caso avesse già provveduto al pagamento, la preghiamo di ignorare il presente messaggio.<br><br>Cogliamo l'occasione per porgerle<br>Distinti Saluti,<br>{{% reservation.property_name %}}"
        ],
        'property_reservation_cancelled' => [
            'subject' => 'Prenotazione cancellata da :channel_name (#:reference_number)',
            'body_1' => 'È stata cancellata sul canale <b>:channel_name</b> la prenotazione <b>:xml_reservation_id</b> a nome di <b>:name :surname</b> (dal <b>:arrival_date</b> al <b>:departure_date</b>) riguardante le camere della struttura <b>:property_name</b>:<br>:accommodations_lists',
            'body_2' => 'Per visualizzare tutti i dettagli della prenotazione <a href="https://app.beddy.io/reservation/:reservation_id">clicca qui</a>',
        ],
        'property_reservation_banktransfer_cancelled' => [
            'subject' => 'Prenotazione cancellata da :channel_name (#:reference_number) per mancato pagamento',
            'body_1' => 'Una prenotazione è stata cancellata in automatico, per mancato pagamento con bonifico.<br /><br />
                        <u>Di seguito i dettagli della cancellazione in oggetto:</u><br /><br />
                        Struttura: <b>:property_name</b><br />
                        Portale di provenienza: :channel_name<br />
                        ID Prenotazione/riferimento: :xml_reservation_id<br />
                        Cliente: <b>:name :surname</b><br />
                        Periodo soggiorno: dal <b>:arrival_date</b> al <b>:departure_date</b><br />
                        Camere interessate: <br>:accommodations_lists<br />',
            'body_2' => 'Per visualizzare tutti i dettagli della prenotazione <a href="https://app.beddy.io/reservation/:reservation_id">clicca qui</a>',
        ],
        'past_connect_reservation_cancelled' => [
            'subject' => 'Avviso: prenotazione cancellata ma non presente su Beddy, verificare la disponibilità',
            'body' => 'Una prenotazione non presente su Beddy è stata cancellata, <strong>è necessaria quindi una verifica manuale</strong> in quanto è possibile che la disponibilità degli alloggi coinvolti non sia aggiornata.
                        <br>
                        Una prenotazione può mancare per due motivi:
                        <br>
                        1. La prenotazione è antecedente alla connessione del Channel Manager: non tutti i portali permettono lo scarico delle stesse (oppure permettono uno scarico limitato nel tempo).
                        <br>
                        2. Il cliente ha cancellato immediatamente la prenotazione, in questi casi può capitare che il portale ci invii la cancellazione senza aver inviato la relativa prenotazione e quindi Beddy non ha un riferimento.
                        <br>
                        <br>
                        <strong>Riportiamo di seguito i dettagli della cancellazione in oggetto:</strong>
                        <br>
                        Portale di provenienza: :channel_name
                        <br>
                        ID Prenotazione: :xml_reservation_id
                        <br>
                        Effettuata il: :booked_at
                        <br>
                        Cliente: :customer_name :customer_surname
                        <br>
                        <br>
                        <strong>Cosa fare:</strong>
                        <br>
                        - Verificare sull\'extranet del portale la presenza della prenotazione e della relativa cancellazione.
                        <br>
                        - Verificare la disponibilità coinvolte su Beddy e sull\'extranet del portale e, se necessario, provvedere ad aggiornarle dal Channel Manager.
                        <br><br>
                        Cordiali Saluti',
        ],
        'property_activation' => [
            'subject' => 'Account :product_name - :property_name',
            'heading' => 'Gentile Cliente, <br>
                come richiesto, le segnalo che abbiamo attivato l\'account :product_name per la struttura <b>:property_name</b>.
    
                <br><br>
    
                Aggiunga ai suoi contatti i nostri indirizzi ' . config('app.email_noreply') . ' e ' . config('app.email_notification') . ' per essere sicuro di ricevere tutte le mail correttamente.<br>
                Tuttavia le consigliamo di controllare sempre le cartelle "Spam" della sua posta.<br>
                Le mail, in alcuni casi, potrebbero finire lì.
    
                <br><br>
    
                Abbiamo effettuato una veloce configurazione del suo account in base alle informazioni presenti sul sito web.<br>
                È comunque necessario configurare camere, tariffe e disponibilità per completare le informazioni relative alla sua struttura<br>
    
                <br><br>
    
                Di seguito riportiamo le credenziali per l\'accesso:<br>
                ' . config('app.url_beddy_client') . '<br>
                Username: :username<br>
                Password: :password
    
                <br><br>
                In ogni pagina, troverà un tasto "Help" che la guiderà nella configurazione.',

            'module_bol' => 'Non appena avrà completato la configurazione, le invieremo il codice html da fornire al suo webmaster per l\'inserimento della maschera di prenotazione sul suo sito.<br>
                Nel caso in cui il webmaster dovesse riscontrare difficoltà, potremmo effettuare noi l\'integrazione, ma, in questo caso, avremmo bisogno di username e password per l\'accesso ftp.<br>
                Il codice potrà inserirlo anche su altri siti, le prenotazioni confluiranno sempre sul suo account.
    
                <br><br>
    
                ' . config('app.name') . ' le dà la possibilità di inserire la mascherina di prenotazione anche sul profilo facebook:<br><br>
    
                N.B. Per poter effettuare l\'installazione è richiesto un numero minimo di 2000 like.<br>
    
                <br>
                1. Per prima cosa, bisogna mettere un like alla nostra fanpage: ' . config('app.app_facebook_page_url') . '<br>
                2. Adesso, dalla pagina: http://www.facebook.com/dialog/pagetab?app_id=' . config('app.app_facebook_page_id') . '&next=' . config('app.url') . ' scelga a quale profilo collegare il booking e clicchi "Add Page Tab"<br>
                3. Ci segnali via email (' . config('app.email_support') . ') l\'indirizzo della sua pagina facebook e, se ha eseguito correttamente i 2 step precedenti, troverà la mascherina di prenotazione sul suo profilo.<br>',
            'footer' => 'Per qualsiasi altra informazione il nostro servizio clienti è a sua completa disposizione dal lunedì al venerdì dalle 10:00 alle 14:00 e dalle 15:30 alle 18:00.
                Nel ringraziarLa per aver scelto :product_name, cogliamo l\'occasione per porgerle
                <br><br>
                Distinti Saluti',
        ],
        'users' => [
            'changedPassword' => [
                'subject' => 'Beddy - La tua password è stata modificata',
                'summary' => 'Gentile <b>:firstname</b>,<br>ti informiamo che la password del tuo account <b>Beddy</b> è stata modificata con successo.',
                'errors' => [
                    'unexpectedNotice' => 'Se non sei stato tu a cambiare la password, ti invitiamo a contattare l’amministratore della struttura e/o il nostro supporto.<br><br>
                    Cordiali Saluti,<br>
                    Il team di Beddy',
                ],
            ],
            'attachment' => [
                'subject' => 'Sei stato associato ad una nuova struttura su Beddy',
                'summary' => 'Gentile <b>:firstname</b>,<br>il tuo account Beddy è stato associato ad una nuova struttura.<br><br> Ecco i dettagli del nuovo accesso:',
                'property' => 'Struttura',
                'roleAssigned' => 'Ruolo assegnato',
                'loginDetails' => [
                    'login' => 'Puoi accedere a questa struttura sempre tramite app.beddy.io con le stesse credenziali.',
                    'helpContactInfo' => 'In caso di necessità puoi contattare:',
                    'master' => 'l’amministratore della struttura: :masterEmail',
                    'support' => 'il supporto Beddy: <a href="mailto: :supportEmail">:supportEmail</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'Se non aspettavi questa comunicazione o ritieni che si tratti di un errore, ti invitiamo a non completare l’attivazione e a contattare l’amministratore della struttura e/o il nostro supporto.',
                ]
            ],
            'activation' => [
                'subject' => 'Sei stato invitato su Beddy – Attiva il tuo accesso',
                'summary' => 'Gentile <b>:firstname</b>,<br> è stato creato per te un account Beddy.<br><br> Di seguito i tuoi dati:',
                'username' => 'Username',
                'email' => 'Email',
                'username' => 'Username',
                'toDo' => 'Per <b>attivare l’account</b> è necessario impostare la <b>password</b>:',
                'button' => '<a href=":creationPasswordLink">Crea Password</a>',
                'expiration' => 'Il link di attivazione ha una validità di 5 giorni.',
                'contacts' => [
                    'helpContactInfo' => 'In caso di necessità puoi contattare:',
                    'master' => 'l’amministratore della struttura: ',
                    'support' => 'il supporto Beddy: <a href="mailto: :supportEmail">support@beddy.io</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'Se non aspettavi questa comunicazione o ritieni che si tratti di un errore, ti invitiamo a non completare l’attivazione e a contattare l’amministratore della struttura e/o il nostro supporto.',
                    'uncompletedRegistration' => 'Registrazione non completata: l’account non è ancora attivo. Controlla l’e-mail che ti abbiamo inviato e imposta la password per attivarlo.',
                ]
            ],
            'passwordreset' => [
                'subject' => 'Procedura reset Password Account :product_name',
                'body' => 'Ciao <b>:first_name!</b>
                <br/>
                 hai ricevuto questa email perché hai richiesto di modificare la password di accesso al tuo account :product_name,
                 <br><br>
                 Per poter cambiare la password clicca <a href=":link_reset">qui</a> entro 30 minuti.
                 <br>
                 Se non sei stato tu a richiedere di modificare la password o non vuoi più procedere alla modifica, ignora questa email.
                 <br>
                Cordiali Saluti.',
            ],
            'password_expiration_notify' => [
                'subject' => 'Avviso di scadenza Password Account Beddy',
                'body' => 'Gentile <b>:name :surname</b>,
                <br/>
                 la informiamo che la password associata al suo account Beddy scadrà tra <b>:days giorni</b>. La invitiamo ad aggiornarla al più presto dalla sezione <a href=":profile" target="_blank">Profilo</a>.
                 <br><br>
                 Qualora avesse dimenticato la sua attuale password, può effettuare la procedura di <b>reset</b> cliccando su <i><a href=":resetPassword" target="_blank">problemi di accesso?</a></i> dalla pagina di <a href=":login" target="_blank">login</a>.
                 <br>
                 <br>
                Cordiali Saluti,<br>
                Il team di Beddy',
            ],
        ],
        'bank_transfer_reminder' => [
            'subject' => 'Prenotazione numero :reference_number - Promemoria bonifico',
            'body' => 'Gentile :booker_name :booker_surname,<br>
                in merito alla sua prenotazione :reference_number del :booked_at le ricordiamo che per poterla confermare, rimaniamo in attesa del pagamento di :price.
                <br><br>
                Di seguito le coordinate bancarie per il pagamento:<br>
                <i>:bank_text</i>
                <br><br>
                Nel caso non dovessimo ricevere sue notizie entro i prossimi giorni la prenotazione verrà automaticamente cancellata.
                <br><br>
                Qualora avesse già provveduto al pagamento, la preghiamo di non tenere in considerazione la presente comunicazione.<br>
                Per maggiori informazioni, non esiti a contattarci.<br>',
            'footer' => 'Cordiali saluti,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'bank_transfer_cancelled' => [
            'subject' => 'Prenotazione cancellata numero :reference_number',
            'body' => 'Gentile :booker_name :booker_surname,<br>
                non avendo ricevuto sue notizie, le segnaliamo che la prenotazione  :reference_number del :booked_at è stata cancellata.
                <br><br>
                Per maggiori informazioni, non esiti a contattarci.<br>',
            'footer' => 'Cordiali saluti,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'cutoff_errors' => [
            'subject' => 'Errore invio cutoff - :property_name',
            'body_1' => 'Per la struttura <b>:property_name</b> abbiamo riscontrato i seguenti errori:<br><br>',
            'footer' => 'Cordiali saluti.',
        ],
        'deactivate_properties' => [
            'first_notice' => [
                'subject' => 'Rinnovo Account Beddy',
                'body_1' => 'Gentile Cliente,
                    <br><br>
                    siamo felici di confermarle il rinnovo del suo account Beddy e di tutti i servizi ad esso annessi.
                    <br><br>',
                'body_2' => 'Nei prossimi giorni, attraverso il canale SDI, riceverà la fattura per l\'utilizzo del Software Beddy ( dal :date_from al :date_to ). Le chiediamo, gentilmente, di inviarci la copia dell\'avvenuto pagamento, per facilitarne l\'individuazione.
                    <br><br>
                    I suoi dati:',
                'body_3' => 'Per qualsiasi informazione il nostro servizio clienti è a sua completa disposizione dal lunedì al venerdì dalle 10:00 alle 14:00 e dalle 15:30 alle 18:00.',
                'footer' => 'Nel ringraziarla per aver scelto Beddy, cogliamo l\'occasione per porgerle
                    <br><br>
                    Distinti saluti,',
            ],
            'second_notice' => [
                'subject' => 'Rinnovo Account Beddy',
                'body_1' => 'Gentile Cliente,
                    <br><br>
                    siamo felici di confermarle nuovamente il rinnovo del suo account Beddy e di tutti i servizi ad esso annessi.
                    <br><br>
                    A breve, attraverso il canale SDI, riceverà la fattura per l\'utilizzo del Software Beddy ( dal :date_from al :date_to ).
                    <br><br>
                    I suoi dati:',
                'body_2' => 'Per qualsiasi informazione, il nostro Servizio Clienti è a sua completa disposizione dal lunedì al venerdì dalle 10:00 alle 14:00 e dalle 15:30 alle 18:00.
                    <br><br>
                    Nel ringraziarla per aver scelto Beddy, cogliamo l\'occasione per porgerle
                    <br><br>
                    Distinti Saluti,',
            ],
            'deactivate_property' => [],
        ],
        'reservation_quote_expire' => [
            'subject' => 'Il tuo preventivo è scaduto',
            'body_1' => 'Gentile :customer_name :customer_surname,
                <br>ci spiace informarti che il preventivo che ci hai richiesto in data :creation_date è appena scaduto.',
            'body_2' => '<br><br>Per maggiori informazioni, non esitare a contattarci.',
            'footer' => '<br><br>Cordiali saluti,
                <br>:property_name
                <br>:property_telephone
                <br>:property_email',
        ],
        'reservation_quote_expire_property' => [
            'subject' => 'Il tuo preventivo è scaduto',
            'body_1' => 'Il preventivo per il cliente :customer_name :customer_surname, che hai creato in data :creation_date, è appena scaduto.',
            'footer' => '<br><br>Cordiali saluti.',
        ],
        'housekeeper_maintainer' => [
            'subject' => 'Nuova segnalazione manutenzione per l\'alloggio :accommodation_name',
            'body' => 'È stata inserita una nuova segnalazione di manutenzione relativa all\'alloggio <b>:accommodation_name</b> (<b>:tableau_label</b>). Di seguito tutti i dati: <br><br><b>Titolo:</b> :title <br><br><b>Descrizione:</b> :description',
        ],
        'payments_timetable' => [
            'stripe_not_active' => [
                'subject' => 'Addebito pagamento automatico fallito (ID: :payment_timetable_id - :scheduled_date) - Stripe non attivo',
                'body' => 'Non è stato possibile effettuare l\'addebito relativo al pagamento automatico in oggetto (ID: :payment_timetable_id del :scheduled_date - Prenotazione :reservation_reference_number a nome di :booker_name :booker_surname) poichè non risulta un account Stripe attivo da utilizzare per effettuare l\'addebito.',
            ],
            'no_credit_card' => [
                'subject' => 'Addebito pagamento automatico fallito (ID: :payment_timetable_id - :scheduled_date) - Carta di credito non presente',
                'body' => 'Non è stato possibile effettuare l\'addebito relativo al pagamento automatico in oggetto (ID: :payment_timetable_id del :scheduled_date - Prenotazione :reservation_reference_number a nome di :booker_name :booker_surname) poichè non è presente una carta di credito da utilizzare per effettuare l\'addebito.',
            ],
            'charge_failed' => [
                'subject' => 'Addebito pagamento automatico fallito (ID: :payment_timetable_id - :scheduled_date)',
                'body' => 'Non è stato possibile effettuare l\'addebito relativo al pagamento automatico in oggetto (ID: :payment_timetable_id del :scheduled_date - Prenotazione :reservation_reference_number a nome di :booker_name :booker_surname) per il seguente motivo: :error_description',
            ],
            'payment_exceeded' => [
                'subject' => 'Addebito pagamento automatico fallito (ID: :payment_timetable_id - :scheduled_date) - Pagamento in eccesso rispetto al totale della prenotazione',
                'body' => 'Non è stato possibile effettuare l\'addebito relativo al pagamento automatico in oggetto (ID: :payment_timetable_id del :scheduled_date - Prenotazione :reservation_reference_number a nome di :booker_name :booker_surname) poichè il pagamento eccede il totale della prenotazione',
            ],
            'payment_require_action' => [
                'subject' => 'Addebito pagamento automatico fallito (ID: :payment_timetable_id - :scheduled_date) - Richiesto 3D secure',
                'body' => 'Addebito automatico non riuscito per richiesta 3D Secure (ID: :payment_timetable_id, del :scheduled_date - Prenotazione :reservation_reference_number a nome di :booker_name :booker_surname).',
            ],
            'payment_require_action_send_request' => [
                'subject' => 'Addebito pagamento automatico fallito (ID: :payment_timetable_id - :scheduled_date) - Pagamento in attesa di conferma',
                'body' => 'Addebito automatico non riuscito per richiesta 3D Secure (ID: :payment_timetable_id, del :scheduled_date - Prenotazione :reservation_reference_number a nome di :booker_name :booker_surname).\nÈ stata inviata al cliente richiesta di pagamento via mail.',
            ],
        ],
        'reservation_quote_expire_days_before' => [
            'subject' => 'Il tuo preventivo è in scadenza',
            'body_1' => 'Gentile :customer_name :customer_surname,
                <br>ti informiamo che il <a href=":quote_link">preventivo</a> che ci hai richiesto scadrà giorno :expire_date',
            'body_2' => '<br><br>Per maggiori informazioni, non esitare a contattarci.',
            'footer' => '<br><br>Cordiali saluti,
                <br>:property_name
                <br>:property_telephone
                <br>:property_email',
        ],
        'email_auth_verification' => [
            'body' => 'Gentile :name :surname, <br/> <br/> questo è il pin da te richiesto per confermare l\'accesso al tuo account di Beddy: <strong>:pin</strong> <br/> <br/> Il tuo pin scadrà alle :expire_time',
        ],
        'user_update_email_verification_code' => [
            'body' => 'Gentile :name :surname, <br/> <br/> per completare la richiesta di modifica al tuo account Beddy inserisci questo PIN: <strong>:pin</strong>',
            'warning' => 'Se non hai richiesto la modifica ti consigliamo di <a href=":recoveryPasswordLink" target="_blank">cambiare immediatamente la password</a> per proteggere il tuo account. <br/> <br/> 
            Inoltre, è possibile effettuare la disconnessione da tutti i dispositivi dal menu <a href=":logoutAllDevice" target="_blank"> Profilo > Protezione e accesso</a>.'
        ],
        'user_update_email_confirmed' => [
            'subject' => 'Il tuo indirizzo email è stato aggiornato',
            'body' => 'Gentile :name :surname, <br/> <br/> la mail associata al tuo account Beddy è stata correttamente aggiornata.<br/> <br/>Da questo momento riceverai le comunicazioni a questo indirizzo.',
        ],
        'checkin_online_complete' => [
            'subject' => 'Check-in Online effettuato - :reference_number',
            'body_1' => 'Gentile <b>:property_name</b>, <br/><br /> <b>:main_guest_name :main_guest_surname</b> ha appena effettuato il check-in online per la seguente prenotazione:<br/>',
            'reservation_number' => 'Prenotazione #:reference_number',
            'view_guests' => 'Verifica Dati Ospiti',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'subject' => 'Cambio stato di pulizia per l\'alloggio :cleanable_name - :accommodation_name',
            'body' => ':user_name ha impostato lo stato di pulizia in <b>:clean_status</b> nel giorno <b>:reference_date</b> per l\'alloggio <b>:cleanable_name</b> (:accommodation_name) della struttura :property_name.',
        ],
        'reservation_option_expired' => [
            'subject' => 'Prenotazione in opzione scaduta (#:reference_number)',
            'body' => 'La prenotazione numero  <b>:reference_number</b> a nome di <b>:booker_name :booker_surname</b> con data di arrivo <b>:arrival_date e data di partenza :departure_date </b>  è scaduta',
        ],
        'order_payment_release' => [
            'subject' => 'Preautorizzazione rilasciata (#:reference_number)',
            'body' => 'La preautorizzazione di pagamento relativo alla prenotazione numero <b>:reference_number</b> (dal: <b>:arrival_date</b> al <b>:departure_date</b>) intestato a <b>:customer_name :customer_surname</b> è stata rilasciata',
        ],
        'sca_authorized' => [
            'subject' => 'SCA autorizzata (#:reference_number)',
            'body' => 'La SCA relativa alla prenotazione numero <b>:reference_number</b> a nome di <b>:booker_name :booker_surname</b> (dal: <b>:arrival_date</b> al <b>:departure_date</b>) è stata autorizzata in data <b>:accepted_date</b>. L\'indirizzo ip dal quale è stata autorizzata la sca è: <b>:ip_address</b>',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => 'Disponibilità terminata per l\'alloggio :accommodation_name - Struttura: (:property_name)',
            'body' => 'In data <b>:date_now</b> è terminata la disponibilità relativa all\'alloggio: <b>:accommodation_name - (:property_name)</b> per i seguenti giorni: <b>:days</b>',
        ],
        'guests_reporting' => [
            'error_levels' => [
                'reservation' => 'Prenotazione :reservationId - :booker',
                'accommodation' => 'Alloggio :accommodationType - :accommodationTableauNumber',
                'guest' => 'Ospite :guest',
            ],
            'alloggiatiweb' => [
                'mail' => [
                    'subject' => 'Report Schedine Alloggiati - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'summary' => 'Di seguito il report Schedine Alloggiati in data :alloggiatiweb_send_date del gruppo d’invio :alloggiatiweb_group_label:',
                    'success' => [
                        'body' => ':number su :alloggiatiweb_guest_total inviata.|:number su :alloggiatiweb_guest_total inviate.',
                    ],
                    'error_internal' => [
                        'body' => ':number su :alloggiatiweb_guest_total non inviata a causa di questi errori:<br/>:errors|:number su :alloggiatiweb_guest_total non inviate a causa di questi errori:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Non è stato possibile inviare le schedine Alloggiati a causa di questi errori comunicati dal portale:<br/>:errors',
                    ],
                    'fix_error' => 'È necessario correggere gli errori e inviare le schedine alloggiati da <a href=":link">Documenti > Schedine Istat e alloggiati</a>'
                ],
                'push' => [
                    'subject' => 'Schedine Alloggiati - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'success' => [
                        'body' => ':number su :alloggiatiweb_guest_total inviata.|:number su :alloggiatiweb_guest_total inviate.',
                    ],
                    'error_internal' => [
                        'body' => ":number su :alloggiatiweb_guest_total non è stata inviata.\nCompila i dati mancanti o correggi gli errori e riprova l’invio manualmente.|:number su :alloggiatiweb_guest_total non inviate.\nCompila i dati mancanti o correggi gli errori e riprova l’invio manualmente.",
                    ],
                    'error_external' => [
                        'body' => "Non è stato possibile inviare le schedine Alloggiati a causa di questi errori comunicati dal portale:\n:errors\nCorreggi gli errori e riprova l’invio manualmente.",
                    ],
                ],
                'warning' => [
                    'subject' => 'Errori Schedine Alloggiati - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'error_internal' => [
                        'body' => ":number su :alloggiatiweb_guest_total non è stata inviata a causa di questi errori:<br/>:errors|:number su :alloggiatiweb_guest_total non inviate a causa di questi errori:<br/>:errors",
                    ],
                    'error_external' => [
                        'body' => "Non è stato possibile inviare le schedine Alloggiati a causa di questi errori comunicati dal portale:\n:errors\nCorreggi gli errori e riprova l’invio manualmente.",
                    ],
                    'fix_error' => 'È necessario correggere gli errori e inviare le schedine alloggiati da <a href=":link">Documenti > Schedine Istat e alloggiati</a>'
                ],
            ],
            'istat' => [
                'mail' => [
                    'subject' => 'Report Schedine ISTAT - :istat_send_date - :istat_group_label',
                    'summary' => 'Di seguito il report Schedine ISTAT in data :istat_send_date del gruppo d’invio :istat_group_label:',
                    'success' => [
                        'body' => ':number su :istat_guest_total inviata.|:number su :istat_guest_total inviate.',
                    ],
                    'error_internal' => [
                        'body' => ':number su :istat_guest_total non inviata a causa di questi errori:<br/>:errors|:number su :istat_guest_total non inviate a causa di questi errori:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Non è stato possibile inviare le schedine ISTAT a causa di questi errori comunicati dal portale:<br/>:errors',
                    ],
                    'fix_error' => 'È necessario correggere gli errori e inviare le schedine ISTAT da <a href=":link">Documenti > Schedine Istat e alloggiati</a>'
                ],
                'push' => [
                    'subject' => 'Schedine ISTAT :istat_send_date - :istat_group_label',
                    'success' => [
                        'body' => ':number su :istat_guest_total inviata.|:number su :istat_guest_total inviate.',
                    ],
                    'error_internal' => [
                        'body' => ":number su :istat_guest_total non è stata inviata.\nCompila i dati mancanti o correggi gli errori e riprova l’invio manualmente.|:number su :istat_guest_total non inviate.\nCompila i dati mancanti o correggi gli errori e riprova l’invio manualmente.",
                    ],
                    'error_external' => [
                        'body' => "Non è stato possibile inviare le schedine ISTAT a causa di questi errori:\n:errors\nCorreggi gli errori e riprova l’invio manualmente.",
                    ],
                ],
            ],
        ],
        'treatment_price_update' => [
            'subject' => 'Calcolo prezzi trattamento (:treatment_name) - :property_name',
            'body' => 'Il calcolo dal :start_date al :end_date è stato completato con successo',
        ],
        'reservation_message_received' => [
            'subject' => 'Nuovo messaggio da :senderName (#:reference)',
            'title' => ':senderName ti ha inviato un messaggio!',
            'sender_wrote' => 'L\'ospite ha scritto:',
            'go_to_conversation' => 'Vai alla conversazione',
        ],
        'external_services' => [
            'UrmetSclak' => [
                'error_generate_key_subject' => 'Errore creazione chiavi prenotazione :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'Si è verificato un errore su Sclak relativo alla generazione delle chiavi delle camere. <br> :errors <br> Riprovare manualmente, se il problema persiste contattare l\'assistenza Urmet',
                'error_seding_sms_subject' => 'Errore invio SMS chiavi prenotazione :booker_name :booker_surname (#ID: :reference_number)',
                'error_seding_sms_body' => 'Non è stato possibile inviare l\'SMS di Sclak poichè è avvenuto un errore. <br> Ti consigliamo di contattare l\'assistenza Urmet',
            ],
            'nuki' => [
                'error_generate_key_subject' => 'Errore creazione PIN prenotazione :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'Si è verificato un errore su Nuki relativo alla generazione del PIN delle camere. <br> :errors <br> Riprovare manualmente, se il problema persiste contattare l\'assistenza Nuki',
                'unauthorized_opening' => 'Apertura non autorizzata'
            ],
            'warning' => [
                'subject' => 'Errore creazione chiavi prenotazione :booker_name :booker_surname (#ID: :reference_number)',
                'body' => 'Si è verificato un errore su Sclak relativo alla generazione delle chiavi delle camere. <br> :errors <br> Riprovare manualmente, se il problema persiste contattare l\'assistenza Urmet',
            ],
            'remote_door_key_service' => [
                'reservation_resumed' => [
                    'title' => 'Modifiche a prenotazioni, generare nuove chiavi',
                    'body' => 'È necessario generare una nuova chiave per la prenotazione di <b>:booker_name :booker_surname- :reference_number</b> della struttura <b>:property_name</b>. Quella precedente è stata disabilitata in seguito al cambio di stato della prenotazione.'
                ],
                'reservation_moved' => [
                    'title' => 'Uno o più alloggi sono stati spostati. È necessario generare una nuova chiave.',
                    'body' => 'Uno o più alloggi della prenotazione di <b>:booker_name :booker_surname- :reference_number</b> della struttura <b>:property_name</b> sono stati spostati. È necessario generare una nuova chiave.'
                ],
            ],
        ],
        'conversation_message_send_failed' => [
            'subject' => 'Invio messaggio fallito',
            'title' => 'Il messaggio diretto a :recipientName non è stato recapitato. Prova a inviarlo nuovamente.',
            'go_to_conversation' => 'Vai alla conversazione'
        ],
        'newsletters' => [
            'newsletter_sent_subject' => 'Conferma invio newsletter',
            'newsletter_sent_content' => 'La campagna ":newsletterName" è stata recapita a :sentContacts destinatari su un totale di :totalContacts contatti selezionati.',
            'newsletter_not_sent_subject' => 'Errore invio newsletter',
            'newsletter_exceeded_sent_limit_subject' => 'Quota di invii mensile superata',
            'newsletter_exceeded_sent_limit_content' => 'La newsletter :newsletterName non è stata inviata, a causa del superamento della quota mensile di invii di email',
            'newsletter_not_sent_content' => 'Non è stato possibile inviare la campagna “:newsletterName” a causa di questi errori: :errorMessage',
        ],
        'city_taxes_reports' => [
            'send_city_tax_report' => [
                'subject' => 'Conferma invio report tasse di soggiorno',
                'content' => 'L\'invio del report della tassa di soggiorno per il canale di invio :channelName è stato effettuato con successo'
            ],
            'send_city_tax_report_not_completed' => [
                'subject' => 'Errore invio report tasse di soggiorno',
                'content' => 'L\'invio del report della tassa di soggiorno per il canale di invio :channelName non è andato a buon fine'
            ],
            'export_city_tax_report' => [
                'subject' => 'L \'esportazione del report delle tasse di soggiorno per il canale :channelName è pronta',
                'content' => 'Clicca sul seguente link per essere reindirizzato allo storico dei report di tassa di soggiorno: <a href=":link">Storico report tassa di soggiorno</a>.'
            ],
            'export_city_tax_report_not_completed' => [
                'subject' => 'Non è stato possibile completare l\'esportazione dei report della tassa di soggiorno per il canale :channelName',
                'content' => 'La generazione del report :reportId non è andata a buon fine'
            ],
            'guest_atrtributes_missing' => [
                'subject' => 'Errore invio/esportazione report tasse di soggiorno',
            ],
            'empty_report' => [
                'subject' => 'Non è stato possibile completare l\'invio/esportazione dei report della tassa di soggiorno per il canale :channelName',
                'content' => 'Il report delle tasse di soggiorno non è stato elaborato poichè per il periodo selezionato non è stato estratto nessun ospite da comunicare al canale'
            ],
        ],
        'accommodation_deleted' => [
            'subject' => '[Azione Richiesta] - È necessario aggiornare la disponibilità',
            'body' => 'È stato ridotto il numero di unità disponibili per l\'alloggio :accommodationName della struttura :propertyName, per evitare l\'overbooking è necessario effettuare un reset delle disponibilità dal menù' .
                ' <a href=":bulkUpdateLink">Tariffe e disponibilità > Aggiornamento bulk</a>.<br>Consulta la <a href=":guideLink">guida</a> oppure guarda il <a href="https://www.youtube.com/watch?v=uhCBdsjuUmQ&t=107s">video training</a>.'
        ],
        'max_email_attachments_size_exceeded' => 'La dimensione dei file allegati supera il limite massimo consentito di 8 MB',
        'check_pci_expiration' => [
            'expiring_certification' => [
                'subject' => 'Beddy - Importante: avviso di scadenza certificazione PCI',
                'content' => "Gentile partner :apiPartnerName,<br><br>
                            la certificazione PCI da voi fornita scade tra 30 giorni.<br>
                            Vi preghiamo di inviarci la certificazione aggiornata a <a href=\"mailto:support@beddy.io\">support@beddy.io</a> entro la data di scadenza.<br>
                            Decorso tale termine, il sistema revoca l'accesso ai dati dei pagamenti.<br><br>
                            Il team di Beddy"
            ],
            'certification_expired' => [
                'subject' => 'Certificazione PCI scaduta',
                'content' => "Gentile partner :apiPartnerName,<br>
                            la certificazione PCI da voi fornita è scaduta.<br>
                            Di conseguenza è stato revocato l'accesso ai dati dei pagamenti.<br>
                            Vi preghiamo di inviarci la certificazione aggiornata a <a href=\"mailto:support@beddy.io\">support@beddy.io</a> per ripristinare il servizio.<br><br>
                            Il team di Beddy"
            ]
        ],
        'api_partner_disabled' => [
            'subject' => 'Beddy - Importante: avviso disabilitazione account API',
            'body' => "Gentile partner :apiPartnerName,<br>
            il vostro account è stato disabilitato al fronte di troppe richieste ricevute.<br>
            Dopo aver effettuato un controllo sui vostri sistemi, vi preghiamo di contattarci a <a href=\"mailto:support@beddy.io\">support@beddy.io</a> per ripristinare l'account.<br><br>
            Il team di Beddy"
        ],
        'api_partner_disabled_test' => [
            'subject' => 'Beddy - Importante: avviso di eventuale disabilitazione account API',
            'body' => "Il partner :apiPartnerName,<br>
            sarebbe stato disabilitato per troppe richieste effettuate al servizio: :errorMessage.<br>"
        ],
        'property_first_login' => [
            'subject' => 'Beddy - Accesso da un nuovo dispositivo',
            'summary' => 'Salve :user_first_name,<br> è stato rilevato l\'accesso da un nuovo dispositivo al suo account Beddy.',
            'summary_reset' => 'Se non conosce questo dispositivo, le consigliamo di <a href=":recoveryPasswordLink" target="_blank">cambiare immediatamente la password</a> per proteggere il suo account.',
            'device' => 'Dispositivo',
            'place' => 'Luogo',
            'date_hour' => 'Data e ora',
            'unknown' => 'Sconosciuto',
            'logout' => 'La notifica di accesso è una nuova funzionalità di Beddy, viene inviata al primo accesso anche su dispositivi già utilizzati in passato. Controlli i dispositivi collegati dal menu <a href=":logoutAllDevice" target="_blank"> Profilo > Protezione e accesso</a>. Se corrispondono può ignorare questa mail.',
        ],
        'channel_update_exclusion' => [
            'subject' => 'Il portale ha modificato le restrizioni sugli aggiornamenti per la struttura',
            'summary' => 'Portale coinvolto',
            'oldvalue' => 'Vecchio valore',
            'newvalue' => 'Nuovo valore',
            'modified_value' => 'Valore modificato',
            'deleted_value' => 'Valore eliminato',
            'more_info' => 'Questa email è stata inviata a seguito dell\'esecuzione del cron di scarico nuove camere',
            'they_have_been' => 'sono state ',
            'the_following_restrictions' => ' le seguenti restrizioni:',
            'edited' => 'modificate',
            'new' => 'aggiunte',
            'removed' => 'rimosse',
            'price' => 'Prezzo',
            'availability' => 'Disponibilità',
            'room_barred' => 'Chiusura',
            'min_stay' => 'Soggiorno minimo',
            'max_stay' => 'Soggiorno massimo',
            'close_to_arrival' => 'Chiusura all\'arrivo',
            'close_to_departure' => 'Chiusura alla partenza',
            'date_from' => 'Data inizio periodo',
            'date_to' => 'Data fine periodo',
            'type_change' => 'Tipo di cambiamento',
            '1' => 'attivata',
            '0' => 'disattivata',
            'field_involved' => 'Nome campo coinvolto',
            'rate' => 'Per la tariffa ',
            'property' => 'struttura',
            'subject_short' => 'Modifica restrizioni per: '
        ],
        'credit_card_view_blocked' => [
            'subject' => 'Beddy - Superamento del limite di visualizzazioni carta di credito.',
            'body' => 'Gentile cliente,<br>ti informiamo che la carta associata alla prenotazione <b>#:reference_number</b> oppure a uno dei relativi pagamenti effettuati ha raggiunto il numero massimo di visualizzazioni consentite, di conseguenza, l\'accesso a questa carta è stato <b>temporaneamente bloccato</b>.
            <br><br>Se desideri aumentare il limite di visualizzazioni o ricevere maggiori informazioni, ti invitiamo a contattare l\'assistenza all\'indirizzo <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
            Il team di Beddy<br><br>',
        ],
        'credit_card_view_notify' => [
            'subject' => 'Beddy - Notifica accesso dati carta di credito - Prenotazione #:reservation_reference',
            'body' => 'Gentile Cliente,<br>Sono stati visualizzati i dati di carta di credito relativi alla prenotazione #<b>:reservation_reference</b> proveniente dal canale <b>:channel_name</b>.
            <br><br>
            Dettagli dell’evento:
            <ul>
              <li>Operatore: <b>:user_first_name :user_last_name</b> (<b>:user_email</b>)</li>
              <li>Data e ora: <b>:event_date</b> <b>:event_hour</b></li>
              <li>IP: <b>:ip_address</b></li>
            </ul>
            Questa notifica viene generata come misura di sicurezza e tracciamento degli accessi ai dati sensibili.<br><br>
            Il team di Beddy<br><br>',
        ],
        'user_created_notify' => [
            'subject' => 'Beddy - Nuovo utente creato per la struttura :property_name',
            'bodySection1' => 'Gentile Cliente,<br>è stato appena creato l\'utente <b>:user_first_name :user_last_name (:user_email)</b> per la struttura <b>:property_name</b>.
            <br><br>
            Dettagli dell’evento:
            <ul>
              <li>Operatore: <b>:author_first_name :author_last_name</b> (<b>:author_email</b>)</li>
              <li>Data e ora: <b>:event_date</b> <b>:event_hour</b></li>
              <li>IP: <b>:ip_address</b></li>
            </ul>
            Se non riconosce questa operazione può disattivare il nuovo utente.',
            'buttonText' => 'Disattiva utente',
            'bodySection2' => 'Questa notifica viene generata come misura di sicurezza e tracciamento degli accessi ai dati sensibili.<br><br>
            Il team di Beddy<br><br>'
        ],
    ],

    'export' => [
        'providers' => [
            'customers' => 'Clienti',
            'companies' => 'Aziende',
            'reservations' => 'Prenotazioni',
            'social_archive' => 'Clienti offerta sbloccabile',
            'reservation_quotes' => 'Preventivi',
            'cash_desk' => 'Cassa',
            'fees' => 'Corrispettivi',
            'cash_desk_closure' => 'Chiusura cassa',
            'production_stats' => 'Statistiche di Produzione',
            'sales_stats' => 'Statistiche di Vendita',
            'invoices' => 'Documenti fiscali',
            'invoices_received' => 'Documenti fiscali ricevuti',
            'payments_timetable' => 'Scadenziario pagamenti',
            'properties' => 'Strutture',
            'deposits' => 'Acconti e caparre',
            'reservations_guests_presences' => 'Ospiti in casa',
            'failed_imports' => 'Importazioni fallite',
        ],
        'translations' => [
            'export_format' => 'Formato di esportazione'
        ],
        'errors' => [
            'service_not_active' => 'Il servizio di esportazione richiesto non risulta attivo per le strutture selezionate',
            'method_not_found' => 'Il metodo :methodName non è implementato all\'interno della classe :className',
            'export_provider_not_found' => 'Export Provider non trovato',
        ],
        'warnings' => [
            'service_not_active' => 'Il servizio di esportazione richiesto non è attivo per la struttura :propertyName',
            'export_inserted' => 'Esportazione inserita correttamente. Al termine del processo, riceverai una notifica.',
        ],
    ],

    'external_services' => [
        'urmet_sclak' => [
            'one_time' => 'Validità chiave',
            'confirm_required' => 'Il gestore dovrà autorizzare ogni accesso con l\'app Sclak',
            'app_enabled' => 'Abilita utilizzo APP (se NO sarà abilitato ad usare solo il tastierino numerico)',
            'generate_keypad_pin' => 'Genera il PIN da inviare per l\'apertura con il tastierino numerico (scegliere SI solo se nella struttura sono 
            presenti i tastierini per accedere)',
            'push_notify_enabled' => 'Ricevi una notifica push sullo smartphone ogni volta che il tuo ospite accede',
            'security_level' => 'L\'ospite deve essere collegato ad internet',
            'instant_key' => 'Registrazione ospite opzionale',
            'purchase_type' => 'Chi paga la chiave?',

            'send_sms' => 'Invia la chiave al cliente tramite SMS automatico da Sclack',
            'sms_text_main' => "Ciao, di seguito le istruzioni per avere le chiavi di accesso alla struttura.\n- INSTALLA APP Sclak: http://app.sclak.com/download",
            'sms_text_app_code' => "\n - ATTIVA CHIAVE: https://key.sclak.com/a/:app_key_code",
            'sms_text_pin_code' => "\n - Il codice PIN della tastiera è: :pin_code'",

            'all_booking_duration' => 'Per tutta la durata del soggiorno',
            'only_one' => 'Solo una volta',
            'property' => 'La struttura',
            'guest' => 'L\'ospite',
            'door_app_code' => 'Codice attivazione APP',
            'door_link_code' => 'Link attivazione APP',
            'app_activation_code' => 'Codice attivazione APP :accommodation_name (:accommodation_label): :key_code',
            'app_activation_code_log' => ':key_code',
            'door_key_code' => 'Codice porta',
            'checkin_hour' => 'Orario di Check-in (la chiave per accedere sarà valida solo a partire dall\'orario di check-in scelto)',
            'checkout_hour' => 'Orario di Check-out (la chiave per accedere sarà valida fino all\'orario di check-out scelto)',
            'room_not_mapped' => 'Camera :accommodation_name - :tableau_number non associata su Sclak',
        ],
        'nuki' => [
            'property' => 'La struttura',
            'guest' => 'L\'ospite',
            'door_key_code' => 'Codice porta',
            'checkin_hour' => 'Orario di Check-in (la chiave per accedere sarà valida solo a partire dall\'orario di check-in scelto)',
            'checkout_hour' => 'Orario di Check-out (la chiave per accedere sarà valida fino all\'orario di check-out scelto)',
            'room_not_mapped' => 'Camera :accommodation_name - :tableau_number non associata su Nuki',
            'code' => 'PIN porta :accommodation_name (:accommodation_label): :key_code',
            'email_address_not_found' => 'Indirizzo email non presente, inserisci un\'indirizzo email nella prenotazione a cui inviare l\'invito per accedere a Nuki',
            'generate_keypad_pin' => 'Genera il PIN da inviare per l\'apertura con il tastierino numerico (scegliere SI solo se nella struttura sono
            presenti i tastierini per accedere)',
            'sent_with_app' => 'Inviato via mail da Nuki',
            'authorization_not_found' => 'Stai tentando di modificare un codice non esistente, genera un nuovo codice porta',
            'multi_port_management' => 'Permetti la generazione dello stesso pin per aprire più porte (esempio cancello di ingresso e camera), potrai associare dopo quali porte collegare',
            'device_not_configured' => 'Nessun device Nuki trovato o configurato per l\'apertura via link'
        ],
        'dh_exchange_data' => [
            'vat_code' => 'P.iva modulo di fatturazione',
            'invoice_module_required' => 'Modulo fatturazione richiesto non attivo',
            'index_code_mapping' => 'Indice codice mappatura (inserire un num progressivo se si configurano piu strutture con stessa p.iva)',
            'data_type_export' => 'Tipi di dati da esportare',
            'documents' => 'Documenti',
            'customers' => 'Anagrafiche clienti',
            'payments' => 'Pagamenti',
            'invalid_range_export' => 'Range export non valido',
            'element_exported' => 'Pagamento già inviato in contabilità ERP, impossibile modificare.',
            'element_delete_exported' => 'Pagamento già inviato in contabilità ERP, impossibile eliminare.',
            'cron_auto_export' => 'Abilita invio automatico file giornaliero?',
            'enable_cron_auto_export' => 'Si, abilita export automatico',
            'disable_cron_auto_export' => 'No, solo invio manuale',
            'uncollected_payment' => 'Includi esportazione sospesi/non riscosso?',
            'enable_uncollected_payment' => 'Si, abilita export sospesi/non riscosso',
            'disable_uncollected_payment' => 'No, escludi i sospesi (integrazione standard)',
            'tax_addon_category' => 'Id categoria addebiti da mappare come tasse (Production type Tax)',
            'customer_id' => 'Identificativo cliente (fornito da ERP Mago)',
            'mapping_payment_method' => 'Metodi di pagamento',
            'mapping_tax' => 'Aliquote IVA',
            'mapping_causal_type' => 'Causali contabili',
            'mapping_payment_type' => 'Movimenti cassa',
            'mapping_revenue_levels' => 'Livelli di ricavo',
        ],
        'errors' => [
            'service_not_active' => 'Servizio esterno non attivo',
            'scheduler_not_supported' => 'Il Servizio esterno :external_service_name non supporta la funzionalità di pianificazione automatica',
        ],
        'warnings' => [
            'manual_code_detected' => 'Sono stati rilevati codici camere inseriti manualmente, non è possibile associare quelli manuali a dispositivi remoti, dovresti quindi cancellarli manualmente'
        ],

        'key_door_services' => [
            'key_door_related' => 'questo codice aprirà anche i seguenti dispositivi: :devices_name'
        ],
        'gt_revenue' => [
            'spreadsheet_type' => 'Criterio di esportazione del revenue',
            'spreadsheet_type_segments' => 'Segmenti',
            'spreadsheet_type_rooms' => 'Camere',
            'date_from' => 'Data da cui iniziare l\'esportazione',
            'date_to' => 'Data in cui si conclude l\'esportazione',
            'period' => 'Periodo di esportazione',
        ],
        'pa_friuli' => [
            'year_type' => 'Scegli l\'anno da esportare',
            'year_type_previous' => 'Anno precedente (:year)',
            'year_type_current' => 'Anno in corso (:year)',
        ],
    ],

    'fees' => [
        'deferred' => 'IVA ad esigibilità differita',
        'payment_split' => 'Scissione dei pagamenti',
        'immediate' => 'IVA ad esigibilità immediata',
        'export_fields' => [
            'date' => 'Data',
            'document_type' => 'Tipo documento',
            'document_number' => 'Numero documento',
            'total_taxable' => 'Totale imponibile',
            'total_taxation' => 'Totale IVA',
            'total_documents' => 'Totale documento',
            'customer_name' => 'Nome cliente',
            'customer_type' => 'Tipo cliente',
            'documents' => 'Documenti',
            'total_nets' => 'Totale imponibile',
            'total_taxes' => 'Totale IVA',
            'documents_total' => 'Totale documenti',
        ],
        'net' => 'Imp',
        'tax' => 'IVA',
        'sheets_name' => [
            'rows' => 'Corrispettivi',
            'summary' => 'Riepilogo',
        ],
    ],

    'fiscal_printer' => [
        'not_collected' => 'Non riscosso',
        'electronic' => 'Carta di credito',
        'not_collected_follows_invoice' => 'Non riscosso segue fattura',
    ],

    'gdpr' => [
        'privacy' => [
            'title' => '',
            'header' => '<p><strong>PRIVACY POLICY</strong></p>
            <p><strong>on the processing of personal data</strong></p>
            <p>Arts. 12 et seq of Regulation (EU) 2016/679 (GDPR)</p>
            <p>&nbsp;</p>
            <p><strong>FOREWORD </strong></p>
            <p>In compliance with the provisions of EU Regulation 2016/679 (hereinafter referred to as GDPR) we hereby provide information regarding the processing of personal data provided by the data subject, relating to the relationships with the Company. The information is provided pursuant to art. 13 GDPR.</p>
            <p>&nbsp;</p>
            <ol>
            <li><strong>IDENTITY AND CONTACT DETAILS</strong></li>
            </ol>
            <p>The Data Controller :property_name - :property_address (hereinafter the Company).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>
            <p>&nbsp;</p>
            <p>&nbsp;</p>',
            'default_body' => '<p>&nbsp;</p>
            <ol start="2">
            <li><strong>CONTACT DETAILS OF THE DATA PROTECTION OFFICER (DPO)</strong></li>
            </ol>
            <p>The Data Protection Officer is ________________, tel. ______________, e-mail: ______________.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="3">
            <li><strong>PURPOSE OF PROCESSING, LEGAL BASIS AND DATA STORAGE PERIOD</strong></li>
            </ol>
            <table width="680">
            <tbody>
            <tr>
            <td width="191">
            <p><strong><em>Purpose</em></strong></p>
            </td>
            <td width="135">
            <p><strong><em>Types of data that can be processed:</em></strong></p>
            </td>
            <td width="149">
            <p><strong><em>Legal basis</em></strong></p>
            </td>
            <td width="206">
            <p><strong><em>Storage period</em></strong></p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>a)&nbsp;&nbsp; </strong><strong><u>Service Delivery</u></strong></p>
            <p>Registration of the customer and then subsequently fulfilling legal obligations.</p>
            </td>
            <td width="135">
            <p>First Name, Last Name, Phone Number, Additional Requests, Address, ZIP Code, Province, Country, State and E-mail, Payment Information</p>
            </td>
            <td width="149">
            <p>Performance of a contract to which you are a party or pre-contractual measures taken at the request of the data subject;</p>
            <p>Fulfilment of legal obligations.</p>
            <p><em>&nbsp;</em></p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>The retention time is changeable as it is dictated by the difference between the time the reservation is made and the time the guest actually arrives at the facility.</p>
            <p>Encrypted payment information is retained up to 15days after the departure of the client\'s guest.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>b)&nbsp;&nbsp; </strong><strong><u>Request for quotation</u></strong></p>
            <p>Request for quotation with subsequent contact from the Data Controller</p>
            </td>
            <td width="135">
            <p>First name, last name, email and phone number</p>
            </td>
            <td width="149">
            <p>Pre-contractual measures taken at the request of the data subject</p>
            <p>&nbsp;</p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time it takes to process the request</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>c)&nbsp;&nbsp; </strong><strong><u>Newsletter</u></strong></p>
            <p>Sending newsletters, by automated means of contacting</p>
            </td>
            <td width="135">
            <p>Personal and contact data</p>
            </td>
            <td width="149">
            <p>Consent (required by contract or specific request);</p>
            <p>(optional and revocable at any time)</p>
            <p><em>Art. 6 co. 1 lett. a) GDPR.</em></p>
            </td>
            <td width="206">
            <p>Until consent for that purpose is withdrawn and/or five years have elapsed since the \'expression of consent.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>d)&nbsp; </strong>If necessary, to <strong>ascertain, exercise or defend the rights</strong> of the Joint Data Controllers in judicial proceedings</p>
            </td>
            <td width="135">
            <p>Personal data and contact details; data necessary for the execution of the contractual relationship.</p>
            </td>
            <td width="149">
            <p>Legitimate interest (judicial protection).</p>
            <p><em>Art. 6, paragraph 1 letter f) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time necessary to exercise rights in court.</p>
            </td>
            </tr>
            </tbody>
            </table>
            <p><strong>&nbsp;</strong></p>
            <ol start="4">
            <li><strong>OBLIGATORY NATURE OF PROVISION OF DATA</strong></li>
            </ol>
            <p>The data subject must provide necessary data for carrying out the contractual relationship to the Company, as well as the data necessary to fulfil the obligations provided for by laws, regulations, community standards, and by provisions of Authorities legitimated by law and by supervisory and control bodies (referred to in purposes a) and f) above).</p>
            <p>Data that are not essential for the performance of the contractual relationship are qualified and considered supplementary and their provision by the data subject, if requested, is optional and subject to consent. Consent provided may be withdrawn by the data subject at any time. Such withdrawal shall in no way affect the lawfulness of processing based on the consents given prior to withdrawal of consent.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong>PROCESSING METHODS</strong></li>
            </ol>
            <p>Personal data will be recorded, processed and stored in the Company&rsquo; archive, paper and electronic, in compliance with the appropriate technical and organizational measures referred to in Art. 32 of the GDPR. The processing of the data subject personal data may consist of any operation or set of operations described in Art. 4, paragraph 1, point 2 of the GDPR.</p>
            <p>Personal data will be processed using suitable tools and procedures that guarantee security and confidentiality. Such processing may be carried out directly and/or via delegated third parties, both manually using hard-copy support and electronically using IT equipment and other instruments. In order to manage properly the relationship and fulfilment of legal obligations, personal data may be entered in the internal documentation of the Company and, if necessary, in the documents and registers required by law.</p>
            <p>Your data may be processed by the employees of the departments of the Company assigned to the pursuit of the above-mentioned purposes. These employees have been expressly authorized to process the data and have received adequate operating instructions pursuant to and for the purposes of Art. 29 GDPR.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="6">
            <li><strong>CATEGORIES OF RECIPIENTS OF PERSONAL DATA</strong></li>
            </ol>
            <p>Personal data under purpose (a) are only disclosed to possible legal offices where required by law.</p>
            <p>Payment data is transmitted to payment service providers for completion of the transaction.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="7">
            <li><strong>DATA TRANSFER TO COUNTRIES OUTSIDE THE EU</strong></li>
            </ol>
            <p>The data provided by the data subject will only be processed countries within the European Union. If the personal data of the data subjects are processed in a country outside of the EU, the data subject&rsquo;s rights under EU legislation will be guaranteed and the data subject will be notified on a timely basis.</p>
            <p>&nbsp;</p>
            <ol start="8">
            <li><strong>RIGHTS OF THE DATA SUBJECT </strong></li>
            </ol>
            <p>Pursuant to Articles 15 et seq of the GDPR, the data subject may exercise the following rights:</p>
            <ol>
            <li>access: to obtain confirmation of whether or not the personal data of the data subject are being processed and the right to access them; requests that are manifestly unfounded, excessive or repetitive cannot be answered;</li>
            <li>rectification: to correct/obtain the correction of personal data if incorrect or outdated and to complete data if incomplete;</li>
            <li>erasure/to be forgotten in some cases, to obtain the erasure of the personal data provided; this is not an absolute right, as the Company may have legitimate or legal reasons to store them;</li>
            <li>limitation: the data will be stored, but cannot be processed further, in the cases foreseen by the regulation;</li>
            <li>portability: to move, copy or transfer data from the Company&rsquo; databases to third parties. This applies only to data provided by the data subject for the performance of a contract or for which express consent has been given and the processing is carried out by automated means;</li>
            <li>objection to direct marketing;</li>
            <li>withdraw of the consent at any time if processing is based on consent.</li>
            </ol>
            <p>Pursuant to Art. 2-<em>undicies</em> of Legislative Decree 196/2003, the exercise of data subjects rights may be delayed, restricted or excluded, following justification provided without delay, unless this might compromise the purpose of the restriction, for as long as and to the extent that this constitutes a necessary and proportionate measure, taking into account the fundamental rights and legitimate interests of the data subject, in order to safeguard the interests referred to in paragraph 1, letters a) (protected interests with regard to money laundering), e) (for the conduct of defensive investigations or the exercise of a right in court) and f) (for the confidentiality of the identity of the employee who reports offenses he becomes aware of on his duties). In such cases, data subjects&rsquo; rights may also be exercised through the Personal Data Protection Authority in the manner referred to in Article 160 of said Decree. In such case, the Personal Data Protection Authority will inform the data subject that it has carried out all the necessary checks or that it has carried out a review, as well as of the data subject right to take legal action.</p>
            <p>&nbsp;</p>
            <p>It should also be noted that - before processing the requests - the Company may ascertain the identity of the data subject, in order to evaluate the legitimacy of the same.</p>
            <p>&nbsp;</p>
            <p>To exercise these rights, the data subject may contact the Data Controller at the addresses indicated in section 1 of this document. The Company will respond within 30 days of receiving the data subject formal request.</p>
            <p>If the abovementioned rights concerning data subject personal data are infringed, the latest may complain to the competent authority.</p>
            <p>&nbsp;</p>
            <p><strong>&nbsp;</strong></p>
            <p><strong>THE DATA</strong></p>
            <p><strong>CONTROLLER</strong></p>',
        ],
        'cookie' => [
            'title' => '',
            'header' => '<p><strong>Cookie Policy of :property_name</strong></p>
            <ol>
            <li><strong>Data Controller</strong></li>
            </ol>
            <p>The Data Controller is :property_name - :property_address (hereinafter the Company or the Owner).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>',
            'default_body' => '<p>Since the use of third-party Trackers through this Website cannot be fully controlled by the Owner, any specific references to third-party Trackers are to be considered indicative. In order to obtain complete information, Users are kindly requested to consult the privacy policies of the respective third-party services listed in this document.</p>
            <p>Given the objective complexity surrounding tracking technologies, Users are encouraged to contact the Owner should they wish to receive any further information on the use of such technologies by this Website.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="2">
            <li><strong>Foreword </strong></li>
            </ol>
            <p>This document informs Users about the technologies that help this Website to achieve the purposes described below. Such technologies allow the Owner to access and store information (for example by using a Cookie) or use resources (for example by running a script) on a User&rsquo;s device as they interact with this Website.</p>
            <p>For simplicity, all such technologies are defined as "Trackers" within this document &ndash; unless there is a reason to differentiate.</p>
            <p>For example, while Cookies can be used on both web and mobile browsers, it would be inaccurate to talk about Cookies in the context of mobile apps as they are a browser-based Tracker. For this reason, within this document, the term Cookies is only used where it is specifically meant to indicate that particular type of Tracker.</p>
            <p>Some of the purposes for which Trackers are used may also require the User\'s consent. Whenever consent is given, it can be freely withdrawn at any time following the instructions provided in this document.</p>
            <p>This Website uses Trackers managed directly by the Owner (so-called &ldquo;first-party&rdquo; Trackers) and Trackers that enable services provided by a third-party (so-called &ldquo;third-party&rdquo; Trackers). Unless otherwise specified within this document, third-party providers may access the Trackers managed by them.</p>
            <p>The validity and expiration periods of Cookies and other similar Trackers may vary depending on the lifetime set by the Owner or the relevant provider. Some of them expire upon termination of the User&rsquo;s browsing session.</p>
            <p>In addition to what&rsquo;s specified in the descriptions within each of the categories below, Users may find more precise and updated information regarding lifetime specification as well as any other relevant information &ndash; such as the presence of other Trackers - in the linked privacy policies of the respective third-party providers or by contacting the Owner.</p>
            <p>&nbsp;</p>
            <ol start="3">
            <li><strong> Activities strictly necessary for the operation of this Website and delivery of the Service</strong></li>
            </ol>
            <p>This Website uses so-called &ldquo;technical&rdquo; Cookies and other similar Trackers to carry out activities that are strictly necessary for the operation or delivery of the Service.</p>
            <p><strong>3.1 Third-party Trackers</strong></p>
            <p><strong>3.1.1 Tag Management</strong></p>
            <p>This type of service helps the Owner to manage the tags or scripts needed on this Website in a centralized fashion.</p>
            <p>This results in the Users\' Data flowing through these services, potentially resulting in the retention of this Data.</p>
            <p><strong>3.1.1.1 Google Tag Manager (Google Ireland Limited)</strong></p>
            <p>Google Tag Manager is a tag management service provided by Google Ireland Limited.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Irlanda &ndash; <a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p><strong>3.1.2 Handling payments</strong></p>
            <p>Se non diversamente specificato, questo Sito Web elabora i pagamenti con carta di credito tramite fornitori esterni di servizi di pagamento. In generale, e salvo diversa indicazione, gli Utenti sono pregati di fornire i dettagli di pagamento e le informazioni personali direttamente a tali fornitori di servizi di pagamento.</p>
            <p>Questo Sito Web non &egrave; coinvolto nella raccolta e nell\'elaborazione di tali informazioni: ricever&agrave; invece solo una notifica da parte del fornitore di servizi di pagamento in questione circa l\'avvenuto pagamento.</p>
            <p>Unless otherwise specified, this Website processes payments by credit card via external payment service providers. In general and unless where otherwise stated, Users are requested to provide their payment details and personal information directly to such payment service providers.</p>
            <p>This Website isn\'t involved in the collection and processing of such information: instead, it will only receive a notification by the relevant payment service provider as to whether payment has been successfully completed.</p>
            <p><strong>3.1.2.1 Stripe (Stripe Technology Europe Ltd)</strong></p>
            <p>Stripe is a payment service provided by Stripe Technology Europe, Limited.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://stripe.com/ie/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__stripe_mid: 1 year</li>
            <li>__stripe_sid: 30 minutes</li>
            <li>m: 2 years</li>
            </ul>
            <p><strong>3.1.2.2 PayPal (Paypal)</strong></p>
            <p>PayPal is a payment service provided by PayPal Inc., which allows Users to make online payments.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: See the PayPal privacy policy &ndash;&nbsp;<a href="https://www.paypal.com/webapps/mpp/ua/privacy-full">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__paypal_storage__: indefinite</li>
            <li>akavpau_ppsd: duration of the session</li>
            <li>enforce_policy: duration of the session</li>
            <li>l7_az: duration of the session</li>
            <li>nsid: duration of the session</li>
            <li>ts: duration of the session</li>
            <li>tsrce: duration of the session</li>
            <li>x-cdn: duration of the session</li>
            <li>x-pp-s: duration of the session</li>
            </ul>
            <p>&nbsp;</p>
            <ol start="4">
            <li><strong> Other activities involving the use of Trackers</strong></li>
            </ol>
            <p><strong>4.1 Measurement</strong></p>
            <p>This Website uses Trackers to measure traffic and analyze User behavior with the goal of improving the Service.</p>
            <p><strong>4.1.1 Analytics</strong></p>
            <p>The services contained in this section enable the Owner to monitor and analyze web traffic and can be used to keep track of User behavior.</p>
            <p><strong>4.1.1.1 Google Analytics 4 (Google Ireland Limited)</strong></p>
            <p>Google Analytics 4 is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.<br /> In Google Analytics 4, IP addresses are used at collection time and then discarded before Data is logged in any data center or server. Users can learn more by consulting&nbsp;<a href="https://support.google.com/analytics/answer/12017362?hl=en&amp;ref_topic=2919631">Google&rsquo;s official documentation</a>.</p>
            <p>Personal Data processed: browser information, city, device information, latitude (of city), longitude (of city), number of Users, session statistics, Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_ga: 2 years</li>
            <li>_ga_*: 2 years</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.2 Google Analytics (Google Ireland Limited)</strong></p>
            <p>Google Analytics is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>AMP_TOKEN: 1 hour</li>
            <li>_ga: 2 years</li>
            <li>_gac*: 3 months</li>
            <li>_gat: 1 minute</li>
            <li>_gid: 1 day</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Facebook Ads conversion tracking (Facebook pixel) (Meta Platforms Ireland Limited)</strong></p>
            <p>Facebook Ads conversion tracking (Meta pixel) is an analytics service provided by Meta Platforms Ireland Limited that connects data from the Meta Audience Network with actions performed on this Website. The Meta pixel tracks conversions that can be attributed to ads on Facebook, Instagram and Meta Audience Network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://www.facebook.com/about/privacy/">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_fbp: 3 months</li>
            <li>fr: 3 months</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Google Ads conversion tracking (Google Ireland Limited)</strong></p>
            <p>Google Ads conversion tracking is an analytics service provided by Google Ireland Limited that connects data from the Google Ads advertising network with actions performed on this Website.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>IDE: 2 years</li>
            <li>test_cookie: 15 minutes</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.2 Marketing</strong></p>
            <p><strong>4.1.2.1. Userguest</strong></p>
            <p>This service allows the user to be shown personalized ads on this website, based on previous visits to this website.</p>
            <p>It does not collect personal data.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong> How to manage preferences and provide or withdraw consent</strong></li>
            </ol>
            <p>There are various ways to manage Tracker related preferences and to provide and withdraw consent, where relevant:</p>
            <p>Users can manage preferences related to Trackers from directly within their own device settings, for example, by preventing the use or storage of Trackers.</p>
            <p>Additionally, whenever the use of Trackers is based on consent, Users can provide or withdraw such consent by setting their preferences within the cookie notice or by updating such preferences accordingly via the relevant consent-preferences widget, if available.</p>
            <p>It is also possible, via relevant browser or device features, to delete previously stored Trackers, including those used to remember the User&rsquo;s initial consent.</p>
            <p>Other Trackers in the browser&rsquo;s local memory may be cleared by deleting the browsing history.</p>
            <p>With regard to any third-party Trackers, Users can manage their preferences and withdraw their consent via the related opt-out link (where provided), by using the means indicated in the third party\'s privacy policy, or by contacting the third party.</p>
            <p><strong>5.1 Locating Tracker Settings</strong></p>
            <p>Users can, for example, find information about how to manage Cookies in the most commonly used browsers at the following addresses:</p>
            <ul>
            <li><a href="https://support.google.com/chrome/answer/95647?hl=en&amp;p=cpn_cookies">Google Chrome</a></li>
            <li><a href="https://support.mozilla.org/en-US/kb/enable-and-disable-cookies-website-preferences">Mozilla Firefox</a></li>
            <li><a href="https://support.apple.com/guide/safari/manage-cookies-and-website-data-sfri11471/">Apple Safari</a></li>
            <li><a href="http://windows.microsoft.com/en-us/windows-vista/block-or-allow-cookies">Microsoft Internet Explorer</a></li>
            <li><a href="https://support.microsoft.com/en-us/help/4027947">Microsoft Edge</a></li>
            <li><a href="https://support.brave.com/hc/en-us/articles/360022806212-How-do-I-use-Shields-while-browsing">Brave</a></li>
            <li><a href="https://help.opera.com/en/latest/web-preferences/#cookies">Opera</a></li>
            </ul>
            <p>Users may also manage certain categories of Trackers used on mobile apps by opting out through relevant device settings such as the device advertising settings for mobile devices, or tracking settings in general (Users may open the device settings and look for the relevant setting).</p>
            <p><strong>5.2 </strong><strong>Consequences of denying consent</strong></p>
            <p>Users are free to decide whether or not to grant consent. However, please note that Trackers help this Website to provide a better experience and advanced functionalities to Users (in line with the purposes outlined in this document). Therefore, in the absence of the User\'s consent, the Owner may be unable to provide related features.</p>
            <ol start="6">
            <li><strong> Definitions and legal references</strong></li>
            </ol>
            <p><strong>Personal Data (or Data)</strong></p>
            <p>Any information that directly, indirectly, or in connection with other information &mdash; including a personal identification number &mdash; allows for the identification or identifiability of a natural person.</p>
            <p><strong>Usage Data</strong></p>
            <p>Information collected automatically through this Website (or third-party services employed in this Website), which can include: the IP addresses or domain names of the computers utilized by the Users who use this Website, the URI addresses (Uniform Resource Identifier), the time of the request, the method utilized to submit the request to the server, the size of the file received in response, the numerical code indicating the status of the server\'s answer (successful outcome, error, etc.), the country of origin, the features of the browser and the operating system utilized by the User, the various time details per visit (e.g., the time spent on each page within the Application) and the details about the path followed within the Application with special reference to the sequence of pages visited, and other parameters about the device operating system and/or the User\'s IT environment.</p>
            <p><strong>User</strong></p>
            <p>The individual using this Website who, unless otherwise specified, coincides with the Data Subject.</p>
            <p><strong>Data Subject</strong></p>
            <p>The natural person to whom the Personal Data refers.</p>
            <p><strong>Data Processor (or Data Supervisor)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which processes Personal Data on behalf of the Controller, as described in this privacy policy.</p>
            <p><strong>Data Controller (or Owner)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which, alone or jointly with others, determines the purposes and means of the processing of Personal Data, including the security measures concerning the operation and use of this Website. The Data Controller, unless otherwise specified, is the Owner of this Website.</p>
            <p><strong>This Website (or this Application)</strong></p>
            <p>The means by which the Personal Data of the User is collected and processed.</p>
            <p><strong>Service</strong></p>
            <p>The service provided by this Website as described in the relative terms (if available) and on this site/application.</p>
            <p><strong>European Union (or EU)</strong></p>
            <p>Unless otherwise specified, all references made within this document to the European Union include all current member states to the European Union and the European Economic Area.</p>
            <p><strong>Cookie</strong></p>
            <p>Cookies are Trackers consisting of small sets of data stored in the User\'s browser.</p>
            <p><strong>Tracker</strong></p>
            <p>Tracker indicates any technology - e.g Cookies, unique identifiers, web beacons, embedded scripts, e-tags and fingerprinting - that enables the tracking of Users, for example by accessing or storing information on the User&rsquo;s device.</p>
            <p><strong>Legal information</strong></p>
            <p>This privacy statement has been prepared based on provisions of multiple legislations, including Art. 13/14 of Regulation (EU) 2016/679 (General Data Protection Regulation).</p>
            <p>This policy relates solely to this Website, if not stated otherwise within this document.</p>
            <p>&nbsp;</p>',
        ],
    ],

    'general' => [
        'accommodation_not_found' => 'camera non trovata',
        'channel_unsupported_function' => 'Questo canale non supporta questa funzione',
        'rateplan_not_found' => 'piano tariffario non trovato',
        'accommodations' => 'Camere',
        'unknown' => 'sconosciuto',
        'unauthorized' => 'Non autorizzato',
        'expired_password' => 'La tua password è scaduta. Aggiornala per continuare.',
        'not_found' => 'Non trovato',
        'not_found_or_not_authorized' => 'Risorsa non trovata o autorizzazione negata',
        'no_relationship_found' => 'nessuna relazione trovata',
        'existing_periods' => 'sono presenti valori sovrapposti',
        'existing_condition' => 'condizione già esistente',
        'missing_accommodation_rateplan' => 'Piano tariffario legato a camera mancante',
        'missing_accommodation_channel_source' => 'Camera canale sorgente mancante',
        'missing_accommodation_channel_destination' => 'Camera canale destinazione mancante',
        'missing_accommodation_channel' => 'Camera canale mancante',
        'missing_treatment_or_rateplan' => 'Trattamento o Rateplan non presente per questa camera',
        'same_source_destination' => 'Sorgente e destinazione coincidenti',
        'impossible_delete_addon_category' => 'Impossibile cancellare categoria servizi extra se ancora collegata',
        'impossible_delete_system_addon_category' => 'Impossibile modificare o cancellare categoria servizi extra di sistema',
        'property_xml_already_connected' => 'PropertyXml già connesso su un\'altra struttura',
        'city_tax' => 'Tassa di Soggiorno',
        'taxs' => 'Tasse',
        'virtual_stamp' => 'Bollo virtuale',
        'default_group' => 'Gruppo predefinito',
        'existing_mail' => 'Email esistente',
        'unique_mail' => 'Mail univoca',
        'existing_username' => 'Username esistente',
        'unique_username' => 'Username univoco',
        'resource_conflict' => 'Conflitto nella risorsa selezionata',
        'special_requests' => 'Richieste speciali',
        'name' => 'Nome',
        'surname' => 'Cognome',
        'and' => 'e',
        'arrival' => 'Arrivo',
        'clean_fees' => 'Costi di pulizia',
        'departure' => 'Partenza',
        'adults' => 'Adulti',
        'adult' => 'Adulto',
        'children' => 'Bambini',
        'child' => 'Bambino',
        'eta' => 'Età',
        'male' => 'Maschio',
        'female' => 'Femmina',
        'customer' => 'Cliente',
        'company' => 'Azienda',
        'telephone' => 'Telefono',
        'email' => 'E-Mail',
        'nationality' => 'Nazionalità',
        'too_many_login_attemps' => 'Troppi di tentativi errati. Potrai riprovare tra :minute_unthrottle minuti',
        'country' => 'Paese',
        'coupon' => 'Coupon',
        'from' => 'Dal',
        'to' => 'Al',
        'nights' => 'Notti',
        'payment_status' => 'Stato Pagamento',
        'total' => 'Totale',
        'reservation' => 'Prenotazione',
        'quote' => 'Preventivo',
        'di' => 'di',
        'stay' => 'Soggiorno',
        'extra' => 'Extra',
        'tax' => 'Tassa',
        'payment' => 'Pagamenti',
        'del' => 'del',
        // es: Bonifico "Di" 50 euro
        'channel' => 'Canale',
        'lodging' => 'Alloggi',
        'treatment' => 'Trattamento',
        'accommodations_reserved' => 'Alloggi prenotati',
        // External services
        'option_status_export' => 'Status export',
        'option_revenue' => 'Dato revenue',
        'option_time' => 'Orari export',
        'guest_card_service_not_connected' => 'Servizio non collegato alla struttura o di tipologia errata',
        'guest_card_guests_number_error' => 'Numero di ospiti insufficiente',
        'guest_card_date_from_error' => 'Modifiche non consentite. La data di inizio validità è antecedente ad oggi.',
        'imp' => 'Imp',
        'iva' => 'IVA',
        'type' => 'Tipo',
        'documents' => 'Documenti',
        'generic_payment' => 'Pagamento Generico',
        'accommodation' => 'Camera',
        'accommodation_name' => 'Alloggio',
        'accommodation_total' => 'Totale Alloggio',
        'error' => 'Errore',
        'status' => 'Stato',
        'language' => 'Lingua',
        'guests' => 'Ospiti',
        'guest' => 'Ospite',
        'paid' => 'Pagato',
        'to_pay' => 'Da pagare',
        'suspended' => 'Sospeso',
        'to_be_invoiced' => 'Da fatturare',
        'note' => 'Note',
        'note_internal' => 'Appunti sulla prenotazione',
        'note_internal_accommodation' => 'Note interne alloggio',
        'note_customer' => 'Richieste del cliente',
        'note_checkin' => 'Appunti per il Check-in',
        'note_checkout' => 'Appunti per il Check-out',
        'note_housekeeper' => 'Appunti per la governante',
        'note_catering' => 'Note pasti',
        'note_bill' => 'Appunti per l\'emissione del conto',
        'bill_charged' => 'Addebbito fatturato',
        'total_documents' => 'Totale Doc.',
        'checkin_online' => 'Check In Online',
        'cancellation' => 'cancellazione',
        'no_show' => 'no-show',
        'referral_id' => '#:referral_id:',
        'missing_param' => 'parametro :param mancante',
        'properties' => 'strutture',
        'amount' => 'Importo',
        'reservation_total' => 'Totale prenotazione',
        'total_paid' => 'Totale pagato',
        'total_to_pay' => 'Totale da pagare',
        'general_error' => 'Errore generale',
        'module_not_active' => 'Il modulo :moduleName non è attivo per le seguenti strutture: ',
        'reservation_summary' => 'Riepilogo prenotazione',
        'department_not_faund' => 'Reparto non trovato',
        'department_exist' => 'Non puoi eliminare un reparto già associato alla stampante fiscale',
        'upload_virus_found' => 'Il file caricato risulta corrotto o malevolo',
        'upload_antivirus_service' => 'Non è stato possibile effettuare l\'upload del file, riprova più tardi o contatta il servizio',
        'document' => '{1} Documento|[2,*] Documenti',
        'reservation_to_queue_from_cart' => 'Stiamo processando la prenotazione, una notifica ti avviserà al completamento delle operazioni.',
        'active' => 'Attivo',
        'expired' => 'Scaduto',
        'export' => 'Esporta',
        'send_data' => 'Invia dati',
        'missing_credentials' => 'Username o password mancanti',
        'yes' => 'Si',
        'no' => 'No',
        'door_key_codes' => 'Codice apertura',
        'external_door_link' => 'Link apertura porta esterna',
        'accommodation_door_key_codes' => 'Codice apertura alloggio :accommodationTableauLabel',
        'city_tax_report' => [
            'errors' => [
                'filter_not_available' => 'Filtro non disponibile',
                'filter_format' => 'Formato filtro non accettato',
                'filter_number_arguments_exceeded' => 'Numero di argomenti per filtro non accettato',
            ],
        ],
        'fields' => [
            'field_update' => 'il campo :field da :oldValue a :newValue',
            'guest_type_id' => 'tipologia ospite',
            'city_tax_exemption_id' => 'esenzione tassa di soggiorno',
            'main_guest' => 'ospite principale',
            'arrival_date' => 'data di arrivo',
            'departure_date' => 'data di partenza',
            'roomreservation_id' => 'camera',
            'checkin' => 'checkin',
            'checkout' => 'checkout',
            'enabled' => 'abilitato',
            'disabled' => 'disabilitato',
            'undefined' => 'non definito',
            'deleting' => 'Sono stati eliminati:',
            'update_guest' => 'Per l\'ospite :name :surname (:id) sono stati modificati: :fields',
            'delete_guest' => 'ospite :name :surname (:id) :invoiced_city_tax',
            'invoiced_city_tax' => 'con tassa di soggiorno fatturata',
            'arrival_lunch' => 'arrivo per pranzo',
            'arrival_dinner' => 'arrivo per cena',
            'arrival_not_set' => 'nessuna preferenza',
        ],
        'exceptions' => [
            'impossible_to_get_conversation_references' => 'Non è possibile recuperare le informazioni della conversazione',
            'ota_channel_message_not_supported' => 'Il canale specificato non supporta la funzionalità di invio messaggi.',
            'recipient_has_not_configured_email_address' => 'Il destinatario non ha configurato alcun indirizzo email',
            'impossible_to_resend_not_failed_message' => 'Non è possibile effettuare il reinvio di un messaggio non fallito',
            'impossible_to_delete_this_message' => 'Non è possibile eliminare questo messaggio',
            'message_not_valid' => 'I seguenti campi non sono validi: ',
            'newsletter_config_not_valid' => 'I seguenti campi di configurazione non sono validi: ',
            'newsletter_not_valid' => 'I seguenti campi della newsletter non sono validi: ',
            'newsletter_default_mail_not_valid' => 'I seguenti campi della email di default non sono validi: ',
            'newsletter_default_mail_not_valid' => 'I seguenti campi della email di default non sono validi: ',

            'newsletter_condition_not_valid' => 'I seguenti campi per la condizione della lista di invio non sono validi: ',

            'message_alredy_exists' => 'Messaggio già presente',
            'some_uploaded_files_are_unsupported' => 'Alcuni file caricati non sono supportati',
            'attachments_not_permitted_for_channel' => 'Per questo canale di comunicazione non è previsto l\'invio di allegati',
            'uploaded_too_many_images' => 'Puoi inviare una sola immagine per messaggio',
            'you_cannot_send_message_that_contains_email_addresses' => 'Non puoi inviare un messaggio che contiene indirizzi email',
            'you_cannot_send_message_that_contains_url' => 'Non puoi inviare un messaggio che contiene url',
            'you_cannot_send_message_that_contains_phone_number' => 'Non puoi inviare un messaggio che contiene numeri di telefono',
            'you_cannot_receive_message_without_reservation_type' => 'Non puoi ricevere messaggi senza prenotazione',
            'impossible_to_set_message_read_status' => 'impossibile modificare lo stato di lettura del messaggio',
            'gt_revenue_not_valid' => 'I seguenti parametri per l\'esportazione GT Revenue non sono validi: ',
            'export_not_valid' => 'I seguenti parametri per generare l\'esportazione non sono validi: ',
            'method_not_implemented' => 'Il metodo :methodName del driver :driverName non è implementato',
            'temporary_disabled_action_move_guest' => 'La seguente azione è al momento disabilitata: procedere eliminando l\'ospite e ricreandolo nella stanza designata',
            'batch_job_not_found' => 'Job not found',
            'impossible_invoke_method' => 'Impossibile invocare questo metodo',
        ],
        'conversation_messages' => [
            'participant_alredy_exists' => 'Partecipante già associato alla conversazione',
            'placeholder_photo' => 'Foto',
        ],
    ],

    'guest_presence' => [
        'summary' => 'Riepilogo ospiti in casa',
        'daily_summary_of_date' => ':date',
        'accommodation' => 'Alloggio',
        'accommodation_type' => 'Tipologia di alloggio',
        'name_and_surname' => 'Nome e cognome',
        'age' => 'Età',
        'sex' => 'Sesso',
        'stay' => 'Soggiorno',
        'stay_status' => 'Stato',
        'plan' => 'Piano',
        'property' => 'Struttura',
        'no_records' => 'Nessun dato da visualizzare',
        'date' => 'Data',
        'property' => 'Struttura',
        'export_title' => 'Presenze ospiti',
    ],

    'guest_reporting' => [
        'errors' => [
            // toggler
            'generic_already_reported' => 'Elemento già esportato',
            'reservation_already_reported' => 'Prenotazione :identifier già esportata',
            'reservation_accommodation_already_reported' => 'Alloggio :identifier già esportato',
            'reservation_accommodation_guest_already_reported' => 'Ospite :identifier già esportato',
            'reservation_accommodation_guest_not_sent' => 'Ospite non inviato',

            'reservation_accommodation_guest_can_not_delete' => 'Impossibile cancellare l\'ospite poichè è già presente all\'interno di una chiusura mensile',
            'reservation_accommodation_guest_missing' => 'Ospite non trovato',

            // errori con riepilogo per ospite
            'place_code_missing' => 'Codice luogo non presente. Contattare il supporto tecnico.',
            'cannot_be_single_guest' => 'Tipologia ospite errata: non può essere Ospite Singolo.',
            'customer_has_incomplete_birth_place' => 'Luogo di nascita mancante o incompleto.',
            'customer_has_incomplete_document_data' => 'Dati dei documenti mancanti o incompleti.',
            'customer_has_incomplete_residence' => 'Codice luogo di nascita o di residenza mancante, contattare assistenza.',
            'customer_has_invalid_gender' => 'Sesso non inserito.',
            'customer_has_invalid_type' => 'Tipologia ospite non valida.',
            'customer_has_no_birth_date' => 'Data di nascita mancante.',
            'customer_birth_date_in_future' => 'La data di nascita non può essere successiva alla data di oggi.',
            'customer_has_no_birth_city_country_place' => 'Codici luogo e nazione di nascita mancanti, contattare assistenza.',
            'customer_has_no_birth_place' => 'Luogo di nascita mancante o incompleto.',
            'customer_has_no_name' => 'Nome mancante.',
            'customer_has_no_nationality_or_has_null_code' => 'Stato di cittadinanza mancante.',
            'customer_has_no_residence_city_country_place' => 'Codici luogo e nazione di residenza mancanti, contattare assistenza.',
            'customer_has_no_residence_place' => 'Codice nazione di resisdenza mancante, contattare assistenza.',
            'customer_has_no_surname' => 'Cognome mancante.',
            'customer_has_no_data' => 'Compilare tutti i dati obbligatori.',
            'customer_has_not_present' => 'Non sono stati registrati ospiti nella prenotazione.',
            'some_customer_has_not_present' => 'Non sono stati inseriti i dati di :customer_number ospite|Non sono stati inseriti i dati di :customer_number ospiti',
            'guest_has_no_customer_data' => 'Compilare tutti i dati obbligatori.',
            'invalid_length_of_stay' => 'Durata del soggiorno non valida',
            'invalid_row_size' => 'Lunghezza riga alloggiato non valida' . '. Contattare il supporto tecnico',
            'invalid_value_size' => 'Lunghezza campi non valida',
            'invalid_surname_size' => 'Lunghezza cognome non valida. Massimo 50 caratteri consentiti',
            'invalid_name_size' => 'Lunghezza nome non valida. Massimo 30 caratteri consentiti',
            'invalid_document_number_size' => 'Lunghezza numero documento non valida. Massimo 20 caratteri consentiti',
            'invalid_released_size' => 'Lunghezza luogo rilascio documento non valida. Massimo 9 caratteri consentiti',
            'must_be_single_guest' => 'Tipologia ospite errata: inserire Ospite Singolo.',

            // errori con riepilogo per raggruppaento
            'customer_has_no_leader' => 'Manca il capogruppo o capofamiglia.',
            'family_leader_alone' => 'Presente Capofamiglia senza Familiari.',
            'family_member_alone' => 'Inserire un Capofamiglia.',
            'group_leader_alone' => 'Presente Capogruppo senza Membri.',
            'group_member_alone' => 'Inserire un Capogruppo.',
            'multiple_family_leaders' => 'Può esserci solo un Capofamiglia per alloggio.',
            'multiple_group_leaders' => 'Può esserci solo un Capogruppo per prenotazione.',
            'invalid_group_leader_in_family' => 'Capogruppo non valido (presente Capofamiglia).',
            'invalid_group_member_in_family' => 'Membro del gruppo non valido (deve essere Familiare)',
            'invalid_family_leader_in_group' => 'Capofamiglia non valido (presente Capogruppo)',
            'invalid_family_member_in_group' => 'Familiare non valido (deve essere Membro)',

            'room_has_no_family_leader' => 'Inserire un Capofamiglia.',
            'room_has_many_leaders' => 'Può esserci solo un Capofamiglia per alloggio.',
            'room_has_no_family_members' => 'Presente Capofamiglia senza Familiari.',

            // altri errori
            // 'beds_number_overflow' => 'Il numero di posti letto occupati è maggiore di quanto dichiarato in fase di configurazione. Contattare il supporto tecnico',
            'no_exportable_guests' => 'Nessuna schedina da esportare.',
            'no_istat_module_configured' => 'Gruppo Istat non configurato.',
            'rooms_number_overflow' => 'Il numero di alloggi occupati è maggiore al numero massimo di alloggi configurati nel portale. Verifica la correttezza delle informazioni da Configurazione > Istat.',
            'unmapped_tableau_number' => 'Alloggio senza mappatura. Verificare configurazione gruppo alloggiati web.',
            'no_tableau_number' => 'Nessun alloggio associato in data: :date',
            'unexpected_date' => 'La data di esportazione attesa è :date . Cambiare data di esportazione.',
            'unexpected_send_date' => 'La data di invio attesa è :date. Cambiare data di invio.',
            'empty_italian_birth_city_code' => 'Codice comune di nascita non trovato. Contattare il supporto tecnico.',
            'empty_italian_birth_county_abbreviation' => 'Codice provincia di nascita non trovato. Contattare il supporto tecnico.',
            'empty_italian_residence_city_code' => 'Codice comune di residenza non trovato. Contattare il supporto tecnico.',
            'empty_italian_residence_county_abbreviation' => 'Codice provincia di residenza non trovato. Contattare il supporto tecnico.',

            // errori specifici di sicilia (negli errori ho solo il customer)
            'guest_validation_failed' => 'Osservatorio Turistico Sicilia non può validare l\'ospite :name.',

            // questo può capitare solo se lo stay è stato inviato ma qualcuno dall'osservatorio lo ha poi eliminato
            'sync_failed' => '\nSi sta tentando di inviare presenze o modifiche a prenotazioni eliminate manualmente dal portale Osservatorio Turistico Sicilia. Disabilita l\'invio della prenotazione cancellata o ritenta l\'invio.',

            // errori specifici di turismo 5/sicilia
            'uncaught_forbidden' => 'Credenziali o Codice Struttura errati. Verificare la correttezza dei dati.',

            // errore specifico del webservice alloggiatiweb
            'wrong_username_password_wskey' => 'Username, password o WsKey errate',
            // errore specifico del webservice alloggiatiweb
            'generic_error' => 'Il portale non ha risposto correttamente. Riprovare più tardi.',
            'generic_error_send' => 'Il portale non ha risposto correttamente. Riprovare più tardi.',

            'missing_istat_code' => 'Codice Istat non trovato per il luogo: :placeName. Ti preghiamo di contattare il supporto tecnico.',

            'alloggiatiweb_error_owner_apartment' => 'È necessario utilizzare i codici appartamento per questo account. Abilita la configurazione per alloggio da Configurazione > Alloggiati Web.',
            'alloggiatiweb_error_owner_hotel' => 'Non è possibile utilizzare i codici appartamento per questo account. Disabilita la configurazione per alloggio da Configurazione > Alloggiati Web',

            'sicilia_web_service_outcome_empty_response' => 'Il portale non ha risposto correttamente. Riprovare più tardi.',
            'istat_the_portal_not_responding' => 'Il portale non ha risposto correttamente. Riprovare più tardi.',

            'istat_exemption_not_valid' => 'Esenzione non prevista da ABIT',
            'unable_to_delete_movements' => 'Impossibile eliminare i movimenti per il seguente errore: :error',
            'unable_to_send_movements' => 'Impossibile inviare i movimenti per il seguente errore: :error',
            'unable_to_check_movements_type' => 'Impossibile verificare il tipo di movimenti per il seguente errore: :error',
            'movements_type_not_valid' => 'Il tipo di movimenti della struttua non è valido per questo portale',
            'cannot_delete_movements' =>  'Impossibile eliminare i movimenti poichè la data di invio non è uguale all\'ultima data di invio registrata dal portale',
        ],
        'success' => [
            'upload_recordset_completed' => 'Caricamento schedine completato correttamente.',
        ],
        'webservice' => [
            'service_unavailable' => 'Servizio non disponibile o non correttamente configurato.',
        ],
        'fields' => [
            'date_to_send' => 'Data di invio',
            'date_to_export' => 'Data da esportare',
            'current_date' => 'Data corrente',
            'last_sent_day' => 'Ultima data esportata',
            'use_progression' => 'Progressivo da usare',

            'is_auto' => 'Tipo di invio',
            'is_auto_description' => 'Invio automatico/manuale',

            'reference_date' => 'Data di riferimento per la ricerca',

            'operation_code_label' => 'Codice operazione',
            'operation_code_description' => "Identifica l\'operazione di invio",

            'do_not_update_current_day_label' => 'Non aggiornare il current day',
            'do_not_update_current_day_description' => "Quando l\'istat viene inviato non viene incrementata la data del current day",

            'hotel_code' => 'Codice Struttura',
            'property_list' => 'Elenco strutture',
            'get_property_code' => 'Ottieni codice struttura',

            'username' => 'Username',
            'password' => 'Password',

            'declared_available_rooms' => 'Numero di alloggi effettivamente disponibili per la vendita',
            'declared_available_beds' => 'Numero dei posti letto effettivamente disponibili per la vendita',

            'guest_id' => 'Id dell\'ospite',
            'guest_id_description' => 'Id dell\'ospite da cancellare',

            'delete_movements_flag' => 'Conferma della cancellazione dei movimenti',
            'delete_movements_flag_description' => 'Flag che indica se procedere con la cancellazione dei movimenti',
            'delete_movements_not_confirmed' => 'Sei sicuro di voler cancellare i movimenti a partire da questa data? L\'operazione è irreversibile.',

            // traduzioni personalizzate ricestat
            'ricestat' => [
                'username' => 'Username Ricestat',
            ],

            // traduzioni personalizzate osservatorio turistico sicilia
            'sicilia' => [
                'username' => 'UserID Osservatorio Turistico',
                'hotel_code' => 'Codice Hotel rilasciato in fase di registrazione (se diverso da username)',
            ],

            // traduzioni personalizzate sired
            'sired' => [
                'declared_available_rooms' => 'Totale unità ricettive potenzialmente disponibili alla vendita (quantità dichiarata sul Portale)',
                'declared_available_beds' => 'Numero letti disponibili (quantità dichiarata sul Portale)',
            ],

            // traduzioni personalizzate abit network
            'abitnetwork' => [
                'hotel_code' => 'Codice Struttura o Codice Regione',
                'declared_available_rooms' => 'Totale unità ricettive potenzialmente disponibili alla vendita (quantità dichiarata sul Portale)',
                'declared_available_beds' => 'Numero letti disponibili (quantità dichiarata sul Portale)',
                'endpoint' => 'Area geografica',
            ],

            // traduzioni personalizzate turismo 5
            'turismo5' => [
                'hotel_code' => 'Codice Struttura o Codice Regione',
                'declared_available_rooms' => 'Totale unità ricettive potenzialmente disponibili alla vendita (quantità dichiarata sul Portale)',
                'declared_available_beds' => 'Numero letti disponibili (quantità dichiarata sul Portale)',
                'endpoint' => 'Area geografica',
            ],

            // traduzioni personalizzate c59
            'c59' => [
                'c59_progression' => 'Progressivo alla data di riferimento',
                'c59_year' => 'Anno di riferimento del progressivo',
            ],

            // traduzioni personalizzate trento
            'trento' => [
                'declared_available_rooms' => 'Numero di camere disponibili',
            ],

            // traduzioni personalizzate astat
            'astat' => [
                'accommodationId' => 'HotelCode o accommodationId',
                'prepare_local_tax' => 'Prepara tassa di soggiorno',
                'close_month' => 'Chiudi mese',
                'token' => 'Token',
                'last_month_closed' => 'Ultimo mese chiuso',
                'property_closed_date_range' => 'Periodo di chiusura della struttura',
            ],

            'sinfonia' => [
                'cusr' => 'Identificativo struttura',
                'api_key' => 'Api key del gestionale'
            ],

            'webtur' => [
                'cir' => 'Codice Identificativo Struttura Regionale (CIR)',
                'cin' => 'Codice Identificativo Struttura Nazionale (CIN)',
                'declared_available_rooms' => 'Numero di camere disponibili',
            ],

            'option_scheduled_label' => 'Vuoi abilitare l\'invio automatico delle schedine istat?',
            'option_scheduled_description' => 'Il sistema invierà automaticamente le schedine a partire dalla data corrente impostata',
            'option_scheduled_send_every_hour_label' => 'Indica la frequenza di invio delle schedine istat',
            'show_city_tax' => 'Mostra la tassa di soggiorno',
        ],
    ],

    'guest' => [
        'alloggiatiweb' => [
            'no_guests_txt' => 'Non ci sono ospiti registrati',
            'property_no_module_configured' => 'La struttura non ha configurato il modulo degli Alloggiatiweb',
            'wrong_size_file' => 'Dimensione del file errata, contattare l\'assistenza',
            'wrong_arrival_date' => 'Data di arrivo errata',
            'general_error' => 'Credenziali errate o certificato non valido',
            'error_txt_file' => 'Errore sulla creazione del file schedine alloggiati',
            'post_upload_error' => 'File non valido. Verificare il tipo file',
            'invalid_certificate' => 'File certificato non valido',
            'certificate_and_password_required' => 'Certificato e password sono necessari',
        ],
        'logger' => [
            'city_tax_log' => ':name :surname di età :age anni (:first_date - :last_date per :accommodation_name) Tot. :total_city_tax',
            'naming' => 'Ospite :name :surname: ',
            'checkin_date' => 'Checkin: :arrival_date => :checkin_date',
            'checkout_date' => 'Checkout: :departure_date => :checkout_date',
        ],
        'errors' => [
            'different_property_on_move' => 'La struttura della camera designata non fa parte del tuo gruppo strutture',
            'family_master_already_in_room' => 'Impossibile proseguire, capofamiglia presente nella camera destinazione',
            'checkin_checkout_not_suitable' => 'Date di checkin o checkout ospiti non compatibili con camera di detinazione',
            'not_found' => 'Ospite non trovato',
            'city_tax_already_sent_to_channel' => 'Ospite già inviato ai portali di tassa di soggiorno collegati, impossibile procedere',
            'change_accommodation_with_invoiced_tax' => 'Impossibile cambiare tipologia di camera ad un ospite che ha tasse di soggiorno fatturate',
        ],
        'guest_cards' => [
            'empty_error' => 'Credenziali errate o struttura non abilitata.',
            'uknown_error' => 'Errore sconosciuto del servizio esterno',
            'venice_tax_exemption_type' => 'Esenzione Contributo di accesso Comune di Venezia',
            'guest_required' => 'É necessario specificare l\'ospite a cui associare la tessera',
            'customer_fields_are_required' => 'I seguenti campi dell\'ospite sono obbligatori: :fields',
            'customer_required_fields' => [
                'name' => 'Nome',
                'surname' => 'Cognome',
                'nic' => 'Codice fiscale',
                'birthday_date' => 'Data di nascita',
                'birth_country.translations.0.name' => 'Luogo di nascita',
                'detail.email' => 'Email',
                'detail.telephone' => 'Telefono',
                'detail.country.translations.0.name' => 'Residenza',
            ],
        ],
    ],

    'housekeeper' => [
        'main_title' => 'Governante',
        'clean_status' => 'Stato',
        'name' => 'Governante',
        'label' => 'Numero',
        'accommodation' => 'Alloggio',
        'bed_type' => 'Allestimento',
        'bed_type_requested' => 'Allestimento richiesto',
        'bed_type_last' => 'Allestimento precedente',
        'bed_type_next' => 'Prossimo allestimento',
        'next_abbrevation' => 'Prox',
        'prev_abbrevation' => 'Prec',
        'guests' => 'Ospiti',
        'reservations' => 'Prenotazioni',
        'guests_checkin' => 'In arrivo',
        'guests_in_home' => 'Fermata',
        'guests_checkout' => 'In partenza',
        'next_change_sheet' => 'Cambio lenzuola',
        'day' => 'giorno',
        'days' => 'giorni',
        'today' => 'Oggi',
        'notes' => 'Note',
        'housekeeper_notes' => 'Note Governante',
        'room_clean' => 'pulito',
        'room_dirty' => 'sporco',
        'adults' => 'Adulti: :count',
        'children' => 'Bambini: :count',
        'requested' => 'Richiesto',
        'today' => 'Oggi',
        'tomorrow' => 'Domani',
        'maintenance' => 'Manutenzione',
        'export_fields' => [
            'cleaning' => 'Pulizia',
            'accommodation' => 'Alloggio',
            'housekeeper' => 'Governante',
            'status' => 'Stato',
            'staging' => 'Allestimento',
            'sheet' => 'Lenzuola',
            'linen' => 'Biancheria',
            'details' => 'Dettagli',
            'created_at' => 'Data',
            'user' => 'Utente',
            'scenario_title' => 'Scenario',
            'column1' => 'Data/Risorsa',
            'column2' => 'Pianificazione',
            'column3' => 'Ora',
            'scenario' => 'Pianificazione',
            'housekeeper_collaborator' => 'In collaborazione con',
        ],
        'print' => [
            'number_of_accommodations' => ':number alloggi ',
            'number_of_checkin' => 'Arrivi: :checkin_done di :checkin_total',
            'number_of_checkout' => 'Partenze: :checkout_done di :checkout_total',
            'number_of_inhome' => 'In Fermata :number_in_home',
            'change_sheet' => 'Cambio Lenzuola',
            'change_linen' => 'Cambio Biancheria',
            'note_housekeeper' => 'Note per la governante',
            'pending_manteiner' => ':number segnalazioni in attesa di risoluzione',
            'status_checkin' => 'In arrivo',
            'status_checkout' => 'In partenza',
            'status_in_home' => 'In fermata',
            'status_label_adult' => ':adults Adulti',
            'status_label_children' => ':children_number Bambini',
            'passed_nights' => 'Notte :passed_nights di :total_nights',
        ],
        'bed_type_current' => 'Allestimento richiesto',
    ],

    'import' => [
        'customer' => [
            'job_name' => 'Clienti',
            'warnings' => ['required_field' => 'Campo obbligatorio'],
            'tooltips' => [
                'skip_on_missing' => "I record del file caricato che non contengono valori per questo abbinamento verranno ignorati nell’importazione.",

                'sex_value' => '<br />Valori accettati per ogni parametro: <br />- Uomo: male, maschio, uomo, m, man, maschile, u <br />- Donna: female, femmina, donna, f, woman, femminile, d <br />- Non specificato: not_defined, non definito, non specificato, na, n/a, cella vuota 
                            <br />Il sistema non fa distinzione tra maiuscolo minuscolo ed accetta allo stesso modo “uomo”, “UOMO” oppure “Uomo”. ',
                'birth_country_required' => 'Per permettere un corretto abbinamento della città di nascita è obbligatorio abbinare anche questo campo. <br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere)',
                'birth_country' => 'Abbinando solo il campo Stato di nascita (senza la relativa città) il sistema inserisce in automatico la capitale dello stato scelto come città di nascita nell’anagrafica cliente. <br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere) senza distinzione tra maiuscole e minuscole.',
                'birth_city' => 'Per permettere un corretto abbinamento della città è necessario abbinare anche il campo successivo Stato di nascita. <br /> Il sistema accetta il nome della città in qualsiasi lingua.',
                'citizenship_country' => 'Accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere) senza distinzione tra maiuscole e minuscole',
                'language' => 'Il sistema accetta le lingue supportate da Beddy: italiano, inglese, francese, tedesco, spagnolo, russo, giapponese. Le altre lingue vengono settate come inglese.  <br />
                                I parametri accettati (indipendentemente da maiuscole e minuscole) sono: <br />
                                    ISO 639-1 (due lettere) ad esempio it <br />
                                    ISO 639-2 (3 lettere) ad esempio ita <br />
                                    Il nome esteso della lingua sia in italiano che tradotto in inglese francese, tedesco e spagnolo ad esempio italiano, italian, italien, italienisch, italiano. <br />
                                    In caso di valori non presenti nel file o nessun abbinamento scelto il sistema utilizza la lingua ufficiale dello Stato di residenza, se presente, altrimenti utilizza la lingua di default.',
                'residence_city' => 'Per permettere un corretto abbinamento della città è necessario abbinare anche il campo successivo Stato di residenza. <br /> Il sistema accetta il nome della città in qualsiasi lingua.',
                'residence_country_required' => 'Per permettere un corretto abbinamento della città di residenza è obbligatorio abbinare anche questo campo. <br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere)',
                'residence_country' => 'Abbinando solo il campo Stato di residenza (senza la relativa città) il sistema inserisce in automatico la capitale dello stato scelto come città di nascita nell’anagrafica cliente.<br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere) senza distinzione tra maiuscole e minuscole.',
                'residence_address' => ' Inserire un abbinamento che contenga solo indirizzo senza città, CAP, Stato.',
                'email' => ' Inserire l’indirizzo mail, non l’eventuale PEC che ha un campo apposito.',
                'document_type' => 'Accetta tutte le tipologie di documento previste dal portale Alloggiati web indipendentemente da maiuscole e minuscole. <br /> Inoltre, per i documenti più utilizzati, carta d’identità, carta d’identità elettronica, patente e passaporto, il sistema accetta anche le abbreviazioni più comuni ad esempio CI, CIE, ID, PASS.',
                'released_country_required' => 'Per permettere un corretto abbinamento della città di rilascio è obbligatorio abbinare anche questo campo. <br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere)',
                'released_country' => 'Abbinando solo il campo Stato di rilascio (senza la relativa città) il sistema inserisce in automatico la capitale dello stato scelto come città di nascita nell’anagrafica cliente.<br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere) senza distinzione tra maiuscole e minuscole.',
                'released_city' => 'Per permettere un corretto abbinamento della città è necessario abbinare anche il campo successivo Stato di rilascio documento. <br /> Il sistema accetta il nome della città in qualsiasi lingua.',
                'invoicing_country_required' => 'Per permettere un corretto abbinamento della città di fatturazione è obbligatorio abbinare anche questo campo. <br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere)',
                'invoicing_country' => 'Abbinando solo il campo Stato di fatturazione (senza la relativa città) il sistema inserisce in automatico la capitale dello stato scelto come città di nascita nell’anagrafica cliente. <br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere) senza distinzione tra maiuscole e minuscole.',
                'invoicing_city' => 'Per permettere un corretto abbinamento della città è necessario abbinare anche il campo successivo Stato di fatturazione. <br /> Il sistema accetta il nome della città in qualsiasi lingua.',
            ],
            'columns' => [
                'name' => 'Nome',
                'surname' => 'Cognome',
                'sex' => 'Sesso',
                'birthday_date' => 'Data di nascita',
                'nic' => 'Codice fiscale',
                'email' => 'Indirizzo email',
                'pec' => 'Indirizzo PEC',
                'telephone' => 'Telefono',
                'language' => 'Lingua',
                'birth_country' => 'Stato di nascita',
                'birth_city' => 'Città di nascita',
                'nationality_country' => 'Nazionalità (es. Italia)',
                'citizenship_country' => 'Stato di Cittadinanza',
                'residence_country' => 'Stato di Residenza',
                'residence_city' => 'Città di Residenza',
                'residence_address' => 'Indirizzo di Residenza',
                'residence_zip_code' => 'CAP di Residenza',
                'invoicing_country' => 'Stato di Fatturazione',
                'invoicing_city' => 'Città Di Fatturazione',
                'invoicing_address' => 'Indirizzo Di Fatturazione',
                'invoicing_zip_code' => 'CAP Di Fatturazione',
                'sdi_code' => 'Codice SDI',
                'facebook' => 'URL facebook',
                'linkedin' => 'URL linkedin',
                'twitter' => 'URL twitter',
                'skype' => 'Skype',
                'x' => 'X',
                'note' => 'Note',
                'lottery_code' => 'Codice lotteria',
                'document_type' => 'ID Tipologia documento',
                'document_number' => 'Numero documento',
                'expiration_date' => 'Data di scadenza documento',
                'released_country' => 'Paese di rilascio documento',
                'released_city' => 'Città di rilascio documento',
                'release_county' => 'Provincia di rilascio documento',
                'release_state' => 'Regione di rilascio documento',
                'lang_values' => ['italiano', 'italian', 'italien', 'italienisch', 'ita',],
                'newsletter_consent' => 'Consenso privacy',
                'error_description' => 'Errore',
                'sex_values' => [
                    'male' => [
                        'maschio',
                        'uomo',
                        'm',
                        'maschile',
                        'u',
                    ],
                    'female' => [
                        'femmina',
                        'donna',
                        'f',
                        'femminile',
                        'd',
                    ],
                    'not_defined' => [
                        'non definito',
                        'non specificato',
                        'na',
                        'n/a',
                    ],
                ]
            ]
        ],

        'company' => [
            'job_name' => 'Aziende',
            'columns' => [
                'name' => 'Ragione sociale',
                'vat_code' => 'Partita IVA',
                'nic' => 'Codice Fiscale',
                'nick_name' => 'Nickname',
                'email' => 'Email',
                'pec' => 'PEC',
                'telephone' => 'Telefono',
                'country' => 'Nazione',
                'city' => 'Città',
                'address' => 'Indirizzo',
                'zip_code' => 'CAP',
                'invoicing_country' => 'Stato di fatturazione',
                'invoicing_city' => 'Città di fatturazione',
                'invoicing_address' => 'Indirizzo di fatturazione',
                'invoicing_zip_code' => 'CAP di fatturazione',
                'sdi_code' => 'Codice SDI',
                'facebook' => 'Facebook',
                'linkedin' => 'Linkedin',
                'twitter' => 'Twitter',
                'skype' => 'Skype',
                'note' => 'Note',
                'country_vat_code_prefix' => 'Prefisso partita iva',
                'company_type' => 'Tipologia azienda',
                'company_types' => [
                    'private' => [
                        'azienda',
                        'privato',
                        'privata',
                        'azienda privata',
                    ],
                    'public' => [
                        'PA',
                        'P.A.',
                        'pubblica amministrazione',
                        'statale',
                    ],
                ],
            ],
            'warnings' => [
                'country_vat_code_prefix' => 'Inserire solo la parte letterale della partita iva',
                'vat_code' => 'Inserire solo la parte numerica della partita iva',
            ],
            'tooltips' => [
                'nick_name' => 'Nome ad uso interno, nei documenti viene riportata la ragione sociale',
                'company_type' => 'Accetta i seguenti valori indipendentemente da maiuscole o minuscole: 
Per azienda privata: azienda, privato, privata, azienda privata 
Per Pubblica Amministrazione: PA, P.A., pubblica amministrazione, statale. <br /> 
In caso di mancato abbinamento il sistema inserisce l’anagrafica come azienda privata, è sempre possibile modificare la tipologia prima di emettere la fattura',
                'country_vat_code_prefix' => 'Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere) senza distinzione tra maiuscole e minuscole. <br />
In caso di cella vuota o nessun abbinamento il prefisso viene impostato secondo quanto impostato nel campo Stato di fatturazione se presente altrimenti imposta IT.',
                'vat_code' => 'Il prefisso dello stato si configura dal campo prefisso P.IVA',
                'nic' =>  'Il codice fiscale è necessario per fatturare ad alcune categorie quali imprese individuali e associazioni.',
                'required_country' => 'Per permettere un corretto abbinamento della città di fatturazione è obbligatorio abbinare anche questo campo. <br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere)',
                'country' => 'Abbinando solo il campo Stato di fatturazione (senza la relativa città) il sistema inserisce in automatico la capitale dello stato scelto come città.<br /> Il sistema accetta il nome dello Stato in qualsiasi lingua e tutti i Codici ISO: 3166-1 (3 cifre), 3166-1 alpha-2 (due lettere), 3166-1 alpha-3 (tre lettere) senza distinzione tra maiuscole e minuscole',
                'city' => 'Per permettere un corretto abbinamento della città è necessario abbinare anche il campo successivo Stato. <br /> Il sistema accetta il nome della città in qualsiasi lingua.',
                'address' => ' Inserire un abbinamento che contenga solo indirizzo senza città, CAP, Stato.',

            ]
        ],
        'booking_onboard_photo_property' => [
            'job_name' => 'Import foto struttura da Booking',
            'columns' => []
        ],

        'common' => [
            'personal_informations' => 'Anagrafica',
            'contacts' => 'Contatti',
            'residential_details' => 'Dettagli Residenza',
            'invoice_address' => 'Dettagli di fatturazione',
            'documents' => 'Documenti',
            'email' => 'Email',
            'other' => 'Altro',
        ],

        'sending_list_contacts' => [
            'job_name' => 'Lista contatti',
            'columns' => [
                'label' => 'Etichetta',
                'email' => 'Indirizzo email',
                'locale' => 'Lingua',
            ]
        ],

        'errors' => [
            'request_params_not_valid' => 'I seguenti parametri della richiesta non sono validi: '
        ],
        'column' => 'Colonna :column_value'
    ],

    'invoice_layouts' => [
        'errors' => [
            'delete' => [
                'one_or_more_receipt_modules_attached' => 'Sono presenti una o più stampanti fiscali associate a questo modulo di fatturazione. Per eliminare questo profilo di fatturazione è necessario eliminare le stampanti fiscali o associarle ad un nuovo profilo di fatturazione.',
            ],
        ],
    ],

    'invoice_received' => [
        'title' => 'Fatture ricevute',
        'export_fields' => [
            'document_date' => 'Data documento',
            'received_date' => 'Data di ricezione',
            'document_name' => 'Documento',
            'sender_name' => 'Mittente',
            'sender_vat_code' => 'P.IVA Mittente',
            'total_taxable' => 'Imponibile',
            'total_taxes' => 'I.V.A',
            'total_document' => 'Totale',
            'discount_amount' => 'Sconto',
            'status' => 'Stato',
            'paid' => 'Pagato',
            'amount_to_be_paid' => 'Totale da pagare',
        ],
        'statuses' => [
            'unpaid' => 'Non pagato',
            'paid' => 'Pagato',
            'partially_paid' => 'Parzialmente pagato',
            'cancelled' => 'Cancellato',
        ],
        'document_types' =>  [
            'RT01' => 'Ritenuta persone fisiche',
            'RT02' => 'Ritenuta persone giuridiche',
            'RT03' => 'Contributo INPS',
            'RT04' => 'Contributo ENASARCO',
            'RT05' => 'Contributo ENPAM',
            'RT06' => 'Altro contributo previdenziale',
            'TD01' => 'Fattura',
            'TD02' => 'Acconto/Anticipo su fattura',
            'TD03' => 'Acconto/Acnticipo su parcella',
            'TD04' => 'Nota di credito',
            'TD05' => 'Nota di debito',
            'TD06' => 'Parcella',
            'TD16' => 'Integrazione fattura reverse charge interno',
            'TD17' => 'Integrazione/autofattura per acquisto servizi dall’estero',
            'TD18' => 'Integrazione per acquisto di beni intracomunitari',
            'TD19' => 'Integrazione/autofattura per acquisto di beni ex art. 17, c. 2, D.P.R. n. 633/1972',
            'TD20' => 'Autofattura per regolarizzazione e integrazione delle fatture (art. 6, c. 8, D.Lgs. n. 471/1997 o art. 46, c. 5, D.L. n. 331/1993)',
            'TD21' => 'Autofattura per splafonamento',
            'TD22' => 'Estrazione beni da Deposito IVA',
            'TD23' => 'Estrazione beni da Deposito IVA con versamento dell’IVA',
            'TD24' => 'Fattura differita di cui all’art. 21, comma 4, lett. a)',
            'TD25' => 'Fattura differita di cui all’art. 21, comma 4, terzo Periodo, lett. b)',
            'TD26' => 'Cessione di beni ammortizzabili e per passaggi interni (ex art. 36 D.P.R. n. 633/1972)',
            'TD27' => 'Fattura per autoconsumo o per cessioni gratuite senza rivalsa'
        ]
    ],

    'invoice' => [
        'export_fields' => [
            'payment_date' => 'Data di pagamento',
            'number' => 'Numero fattura',
            'business_name' => 'Ragione sociale',
            'total_price' => 'Totale',
            'vat' => 'IVA',
            'taxable' => 'Imponibile',
            'invoice_date' => 'Data Documento',
            'recipient_vat_code' => 'Partita IVA',
            'number_complete' => 'Numero',
            'recipient_business_name' => 'Denominazione',
            'total_with_discount' => 'Imponibile',
            'total_tax' => 'Tot. IVA',
            'total' => 'Totale',
            'status_sdi' => 'SDI',
            'expire_date' => 'Scadenza',
            'status' => 'Stato',
            'payment_term' => 'Termine di pagamento',
            'customer_name' => 'Cliente',
            'payment' => 'Pagamento',
            'date' => 'Data',
            'accountholder' => 'Intestatario',
            'notes' => 'Note',
            'paid' => 'Pagato',
            'to_pay' => 'Da pagare',
            'property' => 'Struttura',
            'payment_status' => 'Stato pagamento',
            'data' => 'Dati',
            'currency' => 'Valuta',
            'total_document' => 'Totale documento',
        ],
        'statuses' => [
            'paid' => 'Pagato',
            'suspended' => 'Sospeso',
            'cancelled' => 'Cancellato',
        ],
        'sdi_statuses' => [
            '0' => 'Non inviato',
            '1' => 'In attesa',
            '2' => 'Rifiutato',
            '3' => 'Concluso',
        ],
        'pdf_export' => [
            'description' => 'Descrizione',
            'quantity' => 'Q.tà',
            'amount' => 'Importo',
            'vat' => 'IVA',
            'vat_abbr' => 'P.IVA',
            'total' => 'Totale',
            'invoice_label' => 'Fatt.',
            'of_date' => 'del',
            'taxable' => 'Imponibile',
            'deposit' => 'Caparra',
            'deposit_document_reference' => 'Riferimento documento',
            'aomount_not_taxable' => 'Importo non soggetto a iva',
        ],
        'invoices_opened' => [
            'invoices_opened_title' => 'Pagamenti Sospesi',
            'export_fields' => [
                'expire_date' => 'Scadenza',
                'accountholder' => 'Intestatario',
                'document_number' => 'Numero documento',
                'date' => 'Data',
                'type' => 'Tipo',
                'paid' => 'Pagato',
                'to_pay' => 'Da pagare',
                'total' => 'Totale',
                'note' => 'Note',
                'property' => 'Struttura',
            ],
        ],
        'errors' => [
            'advance_not_suitable' => 'Allegato acconto non compatibile con la tipologia di documento',
            'credit_note_on_follows_invoice_paid' => 'Impossibile emettere storno su documento segue fattura saldato',
            'credit_note_on_follows_invoice_linked' => 'Impossibile emettere storno su documento segue fattura collegato a un conto',
            'restore_on_follows_invoice_linked' => 'Impossibile riaprire il conto di un documento segue fattura collegato a un altro conto',
            'cant_restore_opened_invoice' => 'Non puoi riaprire un conto non fiscalizzato',
            'module_sdi_not_active' => 'Modulo fatturazione elettronica non attivo',
            'refund_major_than_total_credit_note' => 'Rimborso di nota di credito superiore al totale, impossibile procedere',
            'expense_on_invoice' => 'Impossibile associare una spesa ad un documento diverso da nota di credito',
            'cant_resend_due_status' => 'Lo stato attuale dello SDI non permette il reinvio',
            'empty_xml' => 'Nessun XML trovato',
            'cancellation_no_show_conflict' => 'E\' possibile specificare solo una tipologia: no-show o cancellazione',
            'cant_delete_credit_note' => 'Impossibile eliminare nota di credito',
            'add_to_invoices_already_registered' => 'Impossibile aggiungere addebiti a fatture registrate o a note di credito',
            'edit_invoices_already_registered' => 'Impossibile modificare fatture registrate',
            'delete_registered_invoice' => 'Impossibile eliminare una fattura registrata',
            'impossible_delete_until_moves' => 'Impossibile eliminare il conto, spostare preventivamente gli addebiti su altri conti prima di effettuare l\'operazione',
            'not_exist' => 'Fattura inesistente',
            'vat_payment_impossible_for_receipt' => 'Impossibile impostare un\'esigiblità iva diversa di Immediata per ricevuta fiscale',
            'unrestorable_bill' => 'Addebito non soggetto a ripristino',
            'impossible_discount_for_discounted_bills' => 'Impossibile applicare lo sconto in fattura ad addebiti con sconto',
            'refundable_bill_in_invoice' => 'Impossibile aggungere riferimento di rimborso fuori da una nota di credito',
            'impossible_manual_charge_updating' => 'Impossibile apportare la modifica a questo addebito',
            'impossible_follows_invoice_updating' => 'Impossibile apportare la modifica ad addebito collegato a documento segue fattura',
            'impossible_associate_invoice_as_advance' => 'Impossibile associare una fattura normale come acconto',
            'advances_over_allowed' => 'Valore impostato per la fattura di acconto esubera il valore consentito',
            'fp_advances_with_different_department' => 'Le ricevute d\'acconto selezionate devono avere la stessa aliquota IVA',
            'advances_no_have_department' => 'Il reparto utilizzato nell\'acconto deve essere presente tra gli addebiti della ricevuta di saldo.',
            'advances_total_major' => 'L\'importo dell\'acconto non può essere superiore alla somma degli addebiti che hanno lo stesso reparto della ricevuta d\'acconto.',
            'invoice_totally_refunded' => 'Fattura completamente rimborsata, impossibile procedere',
            'advance_with_different_customer' => 'Fattura di acconto non associabile per differenza di destinatario',
            'advance_totally_assigned' => 'Fattura di acconto totalmente associata impossibile rimborsare',
            'deposit_in_general_invoice' => 'Impossibile attribuire una caparra ad un conto passante',
            'bill_overrated' => 'Somma del pagamento superiore al totale addebito associato',
            'invoice_overrated' => 'Somma del pagamento superiore al totale fattura associato',
            'property_not_attached' => 'Struttura non associata',
            'funds_params_unsuitable' => 'Parametri incompatibili con fondocassa',
            'registered_advance_invoice' => 'Fattura d\'acconto registrata, eliminare prima le fatture correlate',
            'registered_sdi invoice' => 'Fattura d\'acconto inviata allo sdi, non cancellabile',
            'move_between_different_types' => 'Impossibile spostare addebiti da fatture a note di credito o da note di credito a fatture',
            'discount_over' => 'Sconto applicato maggiore del totale degli addebiti scontabili',
            'archive_completed' => 'Archivio già completo',
            'too_many_tasks' => 'Troppi task in esecuzione',
            'unsaved_file' => 'Il file non è stato salvato correttamente.',
            'archive_warning' => 'Alcuni file sono mancanti',
            'archive_complete' => 'Completo',
            'invoice_registered' => 'Documento già emesso, impossibile continuare',
            'bill_tranfer_follows_invoice' => 'Impossibile trasferire un addebito generato da scontrino segue fattura',
            'bill_generic_and_follows_invoice' => 'Non puoi aggiungere contemporaneamente righe generiche e righe genarate da scontrino segue fattura',
            'different_vat_code_follows_invoice' => 'Rilevata ricevuta segue fattura con partita iva differente dalla fattura di riepilogo, impossibile procedere',
            'receipt_with_follows_invoice' => 'Non si può emettere una fattura di riepilogo registrandola come ricevuta',
            'type_not_invoice_summary' => 'Non puoi associare documenti non riscossi al tipo di documento corrente',
            'archive_all_file_not_found' => 'Nessun file è stato trovato',
            'impossible_apply_discount_row_on_discounted_invoice' => 'Impossibile applicare sconto all\'addebito se la fattura ha già uno sconto',
            'cant_delete_invoice_due_convention' => 'Impossibile cancellare la fattura poichè è associata ad una convenzione',
            'discount_on_invoice_and_on_row' => 'Impossibile registrare fattura con sconto se presenti addebiti scontati',
            'discount_on_summary_invoice' => 'Impossibile applicare sconto a fattura di riepilogo',
            'cant_delete_invoice_due_linked_advances' => 'Impossibile cancellare una fattura di acconto messa a saldo di altre fatture',
            'cant_delete_invoice_due_credit_notes' => 'Impossibile cancellare un documento già stornato',
            'cant_delete_invoice_due_module_fattelettronica' => 'Impossibile cancellare la fattura perchè è stata già registrata e/o inviata allo SDI',
            'cant_restore_invoice_due_sdi_ns' => 'Impossibile riaprire il conto. La fattura risulta scartata da SDI e reinviabile con stesso numero e data.',
            'cant_transfer_due_invoice_registered' => 'Impossibile spostare una fattura già registrata',
            'cant_merge_credit_note' => 'Non è possibile unire note di credito',
            'cant_merge_due_module_fattelettronica' => 'Non è possibile unire mmoa fattura inviata allo SDI',
            'cant_transfer_without_holder' => 'Non puoi trasferire in un conto senza intestatario',
            'empty_row_document' => 'Inserire almeno una riga nel documento',
            'cant_delete_receipt' => 'Impossibile eliminare ricevuta fiscale',
            'addon_unrelated' => 'Impossibile legare il servizio extra a questo conto',
            'impossible_add_row' => 'Impossibile aggiungere una riga ad un documento fatturato o inesistente',
            'uncharged_rows_found_on_restore' => 'Impossibile ripristinare la fattura: gli addebiti associati sono attualmente presenti in un conto aperto con una sovrascrittura, ripristinare i valori originali prima di procedere',
            'cant_create_temporary_due_missing_layout' => 'Impossibile creare il documento perchè non è presente nessun layout di fatturazione',
            'move_bill_over_discount' => 'Non è possibile trasferire l\'addebbito perchè il valore rimanente sarebbe minore di zero. Il massimo trasferibile è: :max_threshold',
            'cant_decrement_price_invoiced_bill' => 'Impossibile diminuire il prezzo di un addebito già fatturato',
            'printer_id_not_associated' => 'Identificativo stampante fiscale non associato al profilo di fatturazione',
            'cant_move_reservation_due_advance_invoice' => 'Sono presenti fatture di acconto. Per spostare la prenotazione bisogna emettere fattura di saldo o nota di credito.',
            'cant_move_reservation_due_deposit' => 'Sono presenti caparre. Per spostare la prenotazione bisogna eliminarle o rimborsarle.',
            'cant_move_reservation_due_payments' => 'Sono presenti pagamenti. Per spostare la prenotazione bisogna eliminarli o rimborsarli',
            'cant_update_invoice_balance' => 'Impossibile modificare dati relativi ad una fattura di saldo',
            'cant_update_invoice_balance_layout' => 'Impossibile modificare il layout se non è compatibile con la p.iva del layout corrente',
            'cant_register_invoice_balance_price' => 'Il totale della fattura deve corrispondere al totale del pagamento',
            'cant_choose_payment_deposit_different_property' => 'Non è possibile  utilizzare la capparra numero :deposit_number su questo documento perchè appartamente ad un\'altra struttura',
            'cant_choose_payment_advance_different_property' => 'Non è possibile utilizzare la fattura d\'acconto  numero :number_complete perche appartamente ad un\'altra struttura',
            'cant_create_invoice_layout_without_vat_code_without_properties_enabled' => 'Non è possibile creare un profilo di fatturazione senza partita iva per strutture non abilitate all\'emissione di cedolare secca',
            'unable_to_register_not_all_inclusive_tax_document_addons' => 'Esistono addebiti non abilitati per la cedolare secca, si prega di modificarli in configurazione o unirli ad addebiti abilitati sul conto',
            'tax_bills_rows_joined_with_other_type_bills_on_all_tax_inclusive_document' => 'Esistono addebiti di tipo tassa uniti ad addebiti di altra natura, ripristinare la situazione non includendo tasse con altre voci di conto prima di procedere',
            'all_tax_inclusive_layout_on_fiscal_printer' => 'Impossibile associare profilo di fatturazione privo di partita iva a stampante fiscale',
            'all_inclusive_tax_document_for_advance' => 'Impossibile emettere documento di acconto con le impostazioni di cedolare secca',
            'advances_on_all_inclusive_tax_doument' => 'Impossibile mettere a saldo di cedolare secca documenti di acconto',
            'credit_note_on_all_inclusive_tax_document' => 'Impossibile emettere nota di credito per cedolare secca, procedere con l\'annullamento',
            'missing_department_override' => 'Reparto stampante fiscale mancante per l\'addebito :name',
            'missing_department' => 'Reparto stampante fiscale mancante per aliquota :vat_quote % di tipo ',
            'advance_bill_not_found' => 'Addebito di acconto non trovato',
            'totals_bills_not_equals' => 'Il totale delle righe non coincide con il totale del documento',
            'multiple_invoices_bill_rows_override' => 'Non è possibile creare una sovrascrittura per righe di documenti diversi',
            'cant_create_override_for_registered_invoice' => 'Non è possibile creare, modificare o cancellare una sovrascrittura per un documento fiscalizzato o non esistente',
            'cant_edit_print_settings_for_registered' => 'Non è possibile modificare opzioni di stampa per un documento fiscalizzato o non esistente',
            'not_found' => 'Documento non trovato',
            'no_attachments' => 'Non ci sono allegati per questo documento',
            'error_attachments' => 'Si è verificato un errore durante il download degli allegati',
            'advance_with_all_inclusive_tax_document' => 'Impossibile emettere fattura di acconto in regime di cedolare secca, procedere con tipologia ricevuta',
            'empty_email' => 'Inserisci un indirizzo email',
            'empty_email_pdf' => 'Documento pdf non disponibile',
            'advance_partially_used' => 'Impossibile emettere nota di credito su fattura d\'acconto utilizzata',
            'different_vat_payment_on_advance' => 'Impossibile associare fatture di acconto con esigibiltà IVA diversa',
            'cant_delete_credit_note_due_to_sdi_or_fp' => 'Impossibile cancellare note di credito inviate a SDI o storni emessi con stampante fiscali',
            'cant_delete_credit_note_between' => 'Impossibile cancellare una nota di credito o uno storno di addebiti appartenenti a più documenti fatturati',
            'destination_deleted' => 'Il destinatario appartiene ad una anagrafica non più presente nel sistema.',
            'vat_code_not_valid' => 'La partita IVA inserita non è valida',
            'tax_code_not_valid' => 'Il codice fiscale inserito non è valido',
            'empty_codes' => 'Codice fiscale o Partita IVA non validi',
            'row_exceed_total_price' => 'La riga da rimborsare eccede il totale originale',
            'row_exceed_qty' => 'La riga da rimborsare eccede la quantità originale',
            'cant_register_invoice_as_follows_invoice' => 'Non si può emettere fattura in modalità \'segue fattura\' ',
            'cant_register_rejected_invoice_as_receipt' => 'Non si può emettere come ricevuta un documento scartato, è necessario correggere le difformità segnalate e reinviarlo entro 5 giorni',
            'cant_turn_to_paid_follows_invoice' => 'Non può essere marcata come \'pagata\' una ricevuta in modalità \'segue fattura\'',
            'reversal_on_receipt_follows_invoice_joined' => 'Impossibile emettere nota di credito di una ricevuta segue fattura associata a fattura di riepilogo',
            'receipt_channel_must_activated' => 'Per configurare la stampante virtuale è necessario attivare il modulo <em>Interfaccia sistemi terzi.</em> <br /> Contattare il proprio consulente Zucchetti di riferimento per aggiungere il modulo alla propria licenza Beddy.',
            'partial_cannot_exceed_total' => 'L\'importo non può eccedere il totale del documento da stornare',
            'partial_cannot_exceed_percentage' => 'La percentuale non può eccedere il totale del documento da stornare',
            'credit_note_partial_on_advance' => 'Impossibile procedere con nota di credito parziale per documento di acconto',
            'credit_note_partial_on_fp_send' => 'Impossbile procedere con storno parziale per documento collegato a stampante fiscale',
            'credit_note_partial_on_follows_invoice' => 'Impossibile procedere con storno parziale per documento segue fattura',
            'row_to_refund_not_found' => 'Riga da rimborsare non trovata',
            'partial_only_credit_note' => 'I parziali non possonoe ssere calcolati per una nota di credito',
            'partial_credit_note_total_payment_exceed_source_payment' => 'Il totale dei pagamenti eccede il totale del documento',
            'payment_not_belonging_to_invoice_source' => 'Il pagamento selezionato non è appartenente al documento sorgente',
            'payment_not_found' => 'Il pagamento selezionato non esiste',
            'partial_credit_note_row_payment_exceed_source_payment' => 'Il totale del pagamento selezionato eccede il totale del pagamento originario',
            'city_tax_bills_partial_refund' => 'Impossibile procedere con il rimborso parziale di addebiti di tipologia Tassa di soggiorno',
            'credit_note_paid_major_than_total' => 'Il totale dei pagamenti del documento eccede il totale',
            'balance_invoice_needs_advances_refunds' => 'L\'importo richiesto per la nota di credito necessita di almeno un rimborso delle fatture di acconto associate',
            'advance_refunds_different_from_amount_requested' => 'I rimborsi previsti per le fatture di acconto associate, sono inferiori all\'eccedenza tra l\'importo della nota di credito e il totale del documento sorgente',
            'refundable_advance_amount_major_than_maxusable' => 'L\'importo da rimborsare per il documento :advance_number eccede quello utilizzato nel documento sorgente',
            'discount_over_permitted' => 'Lo sconto applicato eccede il massimo consentito del totale senza gli addebiti di tipo tassa',
            'voucher_payment_not_allowed_for_document' => 'Questo tipo di documento non può essere pagato tramite voucher.',
        ],
        'errors_xml' => [
            'error_additional_charges_are_required_to_issue_the_receipt' => 'La differenza tra saldo e acconti (:totalPayments €) è inferiore al valore necessario (:subtractPayment €) per chiudere il documento, ogni voce infatti deve valere almeno 0,01 €. Aumenta un addebito di :amountRequired € oppure raggruppa gli addebiti per categoria o servizio per ottenere un numero di voci inferiore.',
            'error_total_cannot_be_less_than_one_cent' => 'Il totale del documento deve essere superiore al totale degli acconti (almeno 0.01 €)',
            'payment_not_valid' => 'Metodo di pagamento non valido',
            'tax_system' => 'Regime fiscale emittente non valido. Configura il regime fiscale sul profilo di fatturazione',
            'cap' => 'Cap soggetto emittente non valido',
            'destination_code' => 'Codice destinatario non valido',
            'destination_code_pa' => 'Codice destinatario non valido per PA',
            'destination_code_pr' => 'Codice destinatario non valido per privato',
            'destination_cf' => 'Codice fiscale destinatario non valido',
            'destination_cap' => 'CAP destinatario non valido',
            'address' => 'Indirizzo fatturazione non compilato',
            'empty_row_description' => 'Inserire la descrizione di tutte le righe del documento',
            'department_fp' => 'Reparto con aliquota iva non presente',
            'payment_error' => 'Errore dettaglio pagamento',
            'payment_error_amount' => 'Importo totale del documento minore del totale dei pagamenti indicati',
            'payment_error_code' => 'Codice pagamento non valido: ',
            'nature' => 'Natura non è valorizzato, a fronte di una Aliquota IVA pari a zero',
            'reverse_charge' => 'Non puoi applicare la scissione dei pagamenti e il reverse charge contemporaneamente.',
            'error_sdi' => 'Errore invio SDI. Verifica i valori inseriti.',
            'document_no_xml' => 'Tipologia di documento non abilitata per XML',
            'not_found' => 'XML non trovato',
            'error_send_invoice' => 'Errore invio provider',
            'limit_document_id' => 'Il numero documento :id_document non è valido poichè supera il limite consentito di 20 caratteri',
            'error_import_invoice' => 'Import rifiutato',
            'xsd_validation_skip' => 'Problema validazione xsd. Validazione ignorata',
            'xsd_validation_failed' => 'Il valore inserito (:value) dell\'elemento :node non è valido',
            'error_limit_number_invoice' => 'Impossibile inviare il file. Documenti esauriti. Contattare l\'assistenza',
            'error_account_inactive' => 'L\'account non risulta attivo sul provider di fatturazione. Contattare l\'assistenza',
            'payment_error_vat_quote' => 'Aliquote iva differenti tra importo totale ed acconto.',
            'error_content_document' => 'Contenuto del documento non corretto, contattare l\'assistenza',
            'error_create_document' => 'Errore nella creazione del documento XML, contattare l\'assistenza.',
            'error_xml_format_received' => 'Xml di risposta non valido.',
            'error_empty_response' => 'Xml di risposta vuoto.',
            'error_zip_archive_creation' => 'Errore nella creazione del file zip.',
            'error_empty_document' => 'Documento XML vuoto, contattare l\'assistenza.',
            'voucher_code_not_valid' => 'Il codice del voucher non è valido.',
            'custom' => [
                'limit_message_content' => 'Il contenuto del messaggio supera il limite di 42 caratteri.'
            ],
            'rch' => [
                'limit_message_content' => 'Il contenuto del messaggio supera il limite di 25 caratteri.'
            ]
        ],
        'warnings' => [
            'document_not_found' => 'Nessun documento trovato con ID :invoice_id',
            'city_tax_charged_for_guest' => 'Addebito fatturato per l\'ospite, vuoi continuare?',
            'vat_code_already_joined' => 'Il profilo risulta associato a fatture o pagamenti, impossibile modificare la partita iva o i dati di intestazione',
            'all_inclusive_tax_document_with_vat_code' => 'Documento cedolare secca incompatibile con emissione tramite partita iva',
            'cant_restore_bill_invoiced' => 'L\'addebito è fatturato, impossibile ripristinarlo',
            'cant_restore_bill_stay_not_involved' => 'L\'addebito è relativo a date non presenti nel soggiorno, vuoi eliminarlo?',
            'cant_restore_bill_not_related' => 'Impossibile ripristinare questo addebito perchè la risorsa non è più presente',
            'cant_update_bill_day_price' => 'Impossibile modificare il prezzo relativo alla data :date perchè il totale da fatturare dell\'addebito del pagante è minore della differenza di prezzo',
            'cant_update_bill_day_price_due_convention' => 'Il pagante relativo all\'addebito del giorno :date non rispecchia la suddivisione conto, pertanto procedere con la modifica dell\'importo direttamente dalla sezione addebiti',
            'cant_delete_bill_stay' => 'Impossibile cancellare un addebbito di tipo soggiorno',
            'cant_delete_due_to_joined_documents' => 'Impossibile cancellare un addebbito presente in documenti emessi',
            'number_used' => 'Il numero fattura è stato già utilizzato',
            'number_no_sequential' => 'Il numero utilizzato deve avere una data compresa tra la data della fattura precedente e la data della fattura successiva',
            'transferred_bills_present' => 'Sul conto sono presenti addebiti trasferiti da prenotazione, la seguente operazione li cancellerà definitivamente o li azzererà',
            'layout_numbers_existing' => 'Esistono numerazioni progressive attive per questa P.IVA o Codice Fiscale, vuoi sostituirle con le numerazioni impostate in questo nuovo profilo di fatturazione? Ti consigliamo di verificare il numero degli ultimi documenti emessi da questa P.IVA o Codice Fiscale.',
            'additional_info_block_only_for_invoice' => 'Impossibile inserire blocchi informativi aggiuntivi per questo tipo di documento',
            'detach_not_collected_document' => 'Cambiando il tipo di documento, verranno eliminati i documenti non riscosso associati. Vuoi Procedere?',
            'archive_creating' => 'L\'archivio zippato è in fase di creazione.',
            'cant_restore_general_bill' => 'Impossibile ripristinare addebito da conto passante, provvedere al trasferimento manualmente',
        ],
        'pdf' => [
            'accommodations' => 'Soggiorno',
            'addons' => 'Extra',
            'advances' => 'Acconti',
            'taxes' => 'Tasse',
            'deposits' => 'Caparre',
            'credit_note_reversal' => 'Storni ricevute',
            'advance_with_number_complete' => 'Fattura d\'acconto n° :number_complete',
            'payment' => 'Pagamento',
            'taxation_list' => 'Riepilogo IVA',
            'taxable_amount' => 'Imponibile',
            'tax_amount' => 'Imposte',
            'total' => 'Totale',
            'total_taxes' => 'Totale imposte',
            'total_taxable' => 'Tot imponibile',
            'total_taxation' => 'Tot Iva',
            'total_amount' => 'Totale generale',
            'total_paid' => 'Pagato',
            'total_to_pay' => 'Da pagare',
            'document_heading' => 'Documento num. :identifier del :date',
            'document_advance_heading' => 'Prenotazione #:identifier - Acconto',
            'document_heading_no_date' => 'Documento num. :identifier',
            'document_num' => 'Documento num',
            // DEPRECATED:
            'document_date' => 'del',
            // DEPRECATED:
            'payable' => 'Documento non fiscale',
            'proforma' => 'Fattura proforma',
            'additional_information' => 'Informazioni aggiuntive',
            'additional_information_contract' => 'Contratto',
            'additional_information_purchase_order' => 'Ordine aquisto',
            'additional_information_agreement' => 'Convenzione',
            'additional_information_receiving' => 'Ricezione',
            'additional_information_joined_invoices' => 'Fatture collegate',
            'additional_information_progress_status' => 'Stato di avanzamento',
            'additional_information_document_id' => 'ID documento',
            'additional_information_line_number_referral' => 'Numero linea',
            'additional_information_num_item' => 'ID riga',
            'additional_information_date' => 'Data',
            'additional_information_agreement_deal_code' => 'Codice commessa',
            'additional_information_cup' => 'Codice CUP',
            'additional_information_cig' => 'Codice CIG',
            'additional_information_step_reference' => 'Riferimento fase',
            'invoice' => 'Fattura',
            'unregistered_invoice' => 'Conto',
            'receipt' => 'Ricevuta',
            'credit_note' => 'Nota di credito',
            'proforma' => 'Proforma',
            'auto_invoice' => 'Autofattura',
            'reverse_auto_invoice' => 'Annullo Autofattura',
            'debit_note' => 'Nota di debito',
            'destination' => 'Destinatario',
            'causal' => 'Causale',
            'extra_notes' => 'Note',
            'attachments' => 'Allegati',
            'sdi_send_date' => 'Data invio SDI',
            'rounding' => 'Arrotondamento',
            'vat_payment' => [
                'D' => 'IVA ad esigibilità differita',
                'I' => 'IVA ad esigibilità immediata',
            ],
            'payment_method' => 'Modalità di pagamento',
            'iban' => 'IBAN',
            'institution' => 'Istituto',
            'credit_institution' => 'Istituto di credito',
            'amount_virtual_stamp' => 'Importo bollo',
            'discount' => 'Sconto',
            'discount_amount' => 'Sconto o maggiorazione',
            'receipts' => 'Elenco Ricevute',
            'reversal' => 'Elenco Storno Ricevute',
            'receipts_expired' => 'Elenco Ricevute con stato "scadute"',
            'receipts_unpaid' => 'Elenco Ricevute con stato "da pagare"',
            'receipts_suspended' => 'Elenco Ricevute con stato "sospesi"',
            'receipts_paid' => 'Elenco Ricevute con stato "pagato"',
            'payments' => 'Pagamenti',
            // era "Altri pagamenti"
            'payment_date' => 'Data pagamento',
            'payment_label' => 'Pagante',
            'payment_method' => 'Metodo',
            'amount_available' => 'Importo disponibile',
            'amount_used' => 'Importo',
            'deposit' => 'Caparra',
            'copy_text' => 'Copia di cortesia priva di valenza fiscale ai sensi dell’art. 21 Dpr 633/72. L’originale è stato trasmesso allo SDI (Sistema di Interscambio) e disponibile nella Sua area riservata dell’Agenzia delle Entrate.',
        ],
        'wording' => [
            'virtual_stamp_causal_more' => 'Imposta di bollo assolta in modo virtuale ai sensi dell’articolo 6 del DM 17/06/2014',
            'all_inclusive_tax_document_exemption' => 'Esenzione - Art.3 del D.lgs n. 23 del 14/03/2011',
            'standard_advance' => 'Prenotazione #:reference_number - Acconto',
            'manual_fp_register' => 'come documento già fiscalizzato',
            'follows_invoice' => 'segue fattura',
            'default' => 'standard',
            'force_change' => 'di forzatura modifica addebiti'
        ],
        'art17' => 'Operazione assoggettata a split payment con IVA non incassata dal cedente ai sensi dell’ex art.17-ter del DPR 633/1972.',
        'art6' => 'Operazione soggetta ad esigibilità IVA differita ai sensi dell\'Art. 6, comma 5 del DPR 633/1972.',
        'invoice_module' => [
            'invalid_vat_code' => 'P.iva non valida',
            'invalid_invoice_channel' => 'Seleziona un canale valido',
            'error_get_data' => 'Errore recupero info account',
            'vat_code_exist' => 'Esiste già un modulo con questa p.iva',
            'error_fiscal_printer_linked' => 'Sono presenti ricevute fiscali emesse, collegate alla stampante. Vuoi eliminare?',
            'customer' => 'Cliente',
            'subcontracting' => 'Subfornitura'
        ],
        'invoice_import' => [
            'import_success' => 'File importati con successo',
            'import_skip' => 'File ignorati (p.iva destinatario non valida o file già importato)',
            'import_error' => 'Errore import, file xml non valido',
        ],
        'no_show' => [
            'invoice_label' => 'No Show',
            'invoice_cancellation' => 'Cancellazione',
            'no_vat_quote_defined' => 'La struttura non ha una aliquota iva di :type definita',
        ],
        'cancellation' => [
            'invoice_label' => 'Penale di cancellazione',
        ],
        'lottery_code' => 'Codice Lotteria: :lottery_code',
        'log' => [
            'title' => 'fatturazione',
            'advance' => 'fattura :invoice_number del :invoice_date con profilo di fatturazione :invoice_layout (:invoice_business_name - :invoice_vat_code) e intestata a :invoice_customer (Totale :invoice_total)',
            'refunded_advance' => 'E\' stato reso nuovamente disponibile l\'importo di :amount del documento :number del :date',
            'partial_credit_note' => 'Il documento :credit_note_number ha rimborsato in modalità :refund_mode il documento :invoice_source_number di :credit_note_total: :bill_logs. :advance_logs',
        ],
        'types' => [
            'reversal' => 'Ricevuta di storno',
            'credit_note' => 'Nota di credito',
            'receipt' => 'Ricevuta',
            'invoice' => 'Fattura',
            'proforma' => 'Proforma',
            'auto_invoice' => 'Autofattura',
            'debit_note' => 'Nota di debito',
            'reverse_auto_invoice' => 'Annullamento autofattura',
            'unregistered_invoice' => 'Conto',
        ],
        'open_charges' => 'Conti aperti',
        'operational_headquarter' => 'Sede operativa',
        'advances' => 'Acconti',
        'log_module' => [
            'invoice_module_updated' => 'Modulo fatturazione modificato',
            'invoice_module_created' => 'Modulo fatturazione creato',
            'invoice_module_deleted' => 'Modulo fatturazione eliminato',
        ]
    ],

    'logger' => [
        'field_updated' => 'Updated :section [:field] from :old_value to :new_value',
        'titles' => [
            'queue_update' => 'Queue update',
            'bulk_update' => 'Bulk update',
            'new_reservation' => 'Nuova prenotazione',
            'update_reservation_status' => 'Cambio status prenotazione',
            'cancel_accommodation' => 'Cancellata camera prenotata',
            'move_accommodation' => 'Spostata camera prenotata',
            'update_accommodation' => 'Aggiornata camera prenotata',
            'update_accommodation_arrival' => 'Aggiornata data di arrivo',
            'update_accommodation_departure' => 'Aggiornata data di partenza',
            'add_accommodation' => 'Aggiunta camera a prenotazione',
            'reservation_status' => 'Updated Reservation Status',
            'cancel_reservation' => 'Prenotazione cancellata',
            'delete_reservation' => 'Prenotazione eliminata',
            'cancel_reservation_no_new' => 'Canceled reservation without New status',
            'clone_rates' => 'Clonazione da :channel_source a :channel_destination',
            'clone_rates_bulk' => 'Bulk update from clone',
            'payment_transaction' => 'Payment transaction',
            'update_accommodation_listing_price' => 'Update accommodation listing price to :channel_destination',
            'accommodations_overview' => 'Panoramica giornaliera',
            'reset_min_stay' => 'Reset min stay',
            'tableau_closure_create' => 'Creazione chiusure tableau',
            'tableau_closure_delete' => 'Eliminazione chiusure tableau',
            'attach_channel' => 'Connesso canale :channel_name',
            'detach_channel' => 'Disconnesso canale :channel_name',
            'read_channel' => 'Lettura dati canale :channel_name',
            'increase_quantity' => 'Incrementata quantità camera',
            'decrease_quantity' => 'Diminuita quantità camera',
            'insert_rule' => 'Aggiunta nuova regola',
            'update_rule' => 'Modificata regola',
            'delete_rule' => 'Cancellata regola',
            'cutoff' => 'Cutoff',
            'insert_cutoff' => 'Regola di CutOff inserita',
            'modify_cutoff' => 'Regola di CutOff modificata',
            'delete_cutoff' => 'Regola di CutOff eliminata',
            'bulk_treatments_update' => 'Aggiornamento bulk trattamenti',
            'treatments_overview' => 'Panoramica giornaliera trattamenti',
            'rateplan_update' => 'Aggiornamento piano tariffario',
            'OTA-API' => 'Partner API',
            'update_channel' => 'Modifica canale di provenienza',
            'keep_accommodation' => 'Blocco spostamento alloggio',
            'keep_accommodation_label' => 'Il valore è variato per l\'alloggio :accommodations',
            'channel_not_connected' => 'Canale non collegato',
            'city_tax_report_exclusion' => 'Esclusione tassa di soggiorno',
            'city_tax_report_exclusion_label' => 'Il valore è variato per l\'alloggio :accommodations',
            'update_from_past_years' => 'Copia tariffe da anni precedenti',
            'accommodations_mapping' => 'Mappatura Camere',
            'no_association' => 'Nessuna associazione',
        ],
        'messages' => [
            'accommodation_mapping' => 'Da :origin a :destination',
        ],
        'warnings' => [
            'missing_dates_updates' => 'Non è stato possibile sincronizzare i dati per i seguenti periodi: ',
        ],
    ],

    'mail_channels_errors' => [
        'ses' => [
            'missing_required_fields_for_verfication' => 'Campi mancanti per la verifica del canale di invio',
            'existing_ses_identity' => 'Email mittente esistente',
            'configuration_set' => [
                'AlreadyExistsException' => 'Set di configurazione già esistente',
                'NotFoundException' => 'Set di configurazione non trovata',
                'TooManyRequestsException' => 'Limite massimo di richieste raggiunto per creare un set di configurazione',
                'LimitExceededException' => 'Limite di istanze raggiunto per il set di configurazione richiesto',
                'BadRequestException' => 'Set di configurazione non valido',
                'ConcurrentModificationException' => 'Set di configurazione modificato da un altra istanza',
            ],
            'send_bulk_email' => [
                'TooManyRequestsException' => 'Limite massimo di richieste raggiunto per invio email',
                'LimitExceededException' => 'Limite di istanze raggiunto per l\'invio di email',
                'AccountSuspendedException' => 'L\'email non può essere inviata perché la capacità dell\'account di inviare e-mail è stata permanentemente limitata',
                'SendingPausedException' => 'L\'email non può essere inviata perché la capacità dell\'account di inviare e-mail è attualmente sospesa',
                'MessageRejected' => 'L\'email non può essere inviata perché contiene un contenuto non valido',
                'MailFromDomainNotVerifiedException' => 'L\'email non può essere inviata perché il dominio di invio non è verificato',
                'NotFoundException' => 'Risorsa per l\'invio delle email non trovata',
                'BadRequestException' => 'Input dell\'invio dell\'email non valido',
            ],
            'configuration_set_event_destination' => [
                'AlreadyExistsException' => 'Evento di destinazione già esistente',
                'NotFoundException' => 'Evento di destinazione non trovata',
                'TooManyRequestsException' => 'Limite massimo di richieste raggiunto per creare un evento di destinazione',
                'LimitExceededException' => 'Limite di istanze raggiunto per l\'evento di destinazione richiesto',
                'BadRequestException' => 'Evento di destinazione non valido',
            ],
            'configuration_set_attributes' => [
                'NotFoundException' => 'Non è possibile settare gli attributi della configurazione, poichè non è stata trovata',
                'TooManyRequestsException' => 'Limite massimo di richieste raggiunto per settare gli attributi della configurazione',
                'BadRequestException' => 'Attributi della configurazioni non validi',
            ],
        ]
    ],

    'mail_channels' => [
        'fields' => [
            'host' => 'Host',
            'port' => 'Porta',
            'username' => 'Nome utente',
            'password' => 'Password',
            'email_from' => 'Mittente mail',
            'secure' => 'TLS\SSL',
            'domain_email' => 'Email mittente',
        ],
        'choices' => [
            'ssl' => 'SSL',
            'tls' => 'TLS',
        ],
        'errors' => [
            'missing_required_fields_for_verfication' => 'Campi mancanti per la verifica del canale di invio',
            'existing_ses_identity' => 'Email mittente esistente',
        ],
        'channels_name' => [
            1 => 'SMTP',
            2 => 'Beddy - Servizio di Posta'
        ]
    ],

    'meals' => [
        'breakfasts' => 'Colazioni',
        'lunches' => 'Pranzi',
        'dinners' => 'Cene',
        'note' => 'Note'
    ],

    'media' => [
        'errors' => [
            'invalid_type' => 'Tipo non valido: :type. Sono accettati solo \'customer\'.',
            'invalid_file_or_extension' => 'File non valido o estensione non riconosciuta.',
            'cloud_upload_error' => 'Errore nel caricamento del file sullo storage cloud.',
            'not_authorized_to_delete_media' => 'Non sei autorizzato ad eliminare questo media.',
        ]
    ],

    'messages' => [
        'download_attachments' => 'Scarica gli allegati'
    ],

    'newsletters_conditions' => [
        'errors' => [
            'validation_error' => 'Il tipo del valore passato per la feature \':feature\', deve essere del tipo \':type\'',
            'duplicate_condition_error' => 'Il criterio \':criteriaName\' è già associato alla lista di invio',
            'limit_values_error' => 'Il numero di parametri passati per la feature \':feature\', non coincide con il valore massimo previsto \':limitValues\'',
            'condition_not_found' => 'Nessuna condizione associata alla lista trovata',
            'unsuitable_condition_for_sending_list_category' => 'Il criterio \':criteriaName\' non è compatibile con la tipologia di lista di invio',
            'option_relation_error' => 'L\'opzione selezionata identificata dall\'id \':option\' non è presente per la feature \':feature\'',
        ]
    ],

    'newsletters_criteria' => [
        'field_translate' => [
            'country' => 'Nazione',
            'city' => 'Città',
            'county' => 'Provincia',
            'state' => 'Regione',
            'check_phone_number' => 'Gli ospiti devono avere inserito il proprio numero di telefono?',
            'check_newsletter_consent' => 'Gli utenti devono aver dato il consenso alla ricezione delle newsletter?',
            'check_newsletter_unsubscribe' => 'Gli utenti che hanno chiesto disiscrizione dalle newsletter?',
            'language' => '',
            'check_reservation_with_children' => 'Gli ospiti devono aver effettuato una prenotazioni con bambini?',
            'addon' => '',
            'last_reservation_date' => '',
            'birthdays_date' => '',
            'reservation_period_date' => '',
            'reservation_stay_period_date' => '',
            'guests_in_house' => 'Vuoi selezionare tutti gli ospiti in casa?',
            'accommodation' => '',
            'channel' => '',
            'reservation_tag' => '',
            'category_addon' => '',
        ],
        'criteria_translate' => [
            'place' => 'Residenza',
            'company_place' => 'Sede',
            'phone_number' => 'Telefono',
            'newsletter_consent' => 'Consenso Newsletter',
            'newsletter_unsubscribed' => 'Disiscritti dalle Newsletter',
            'language' => 'Lingua',
            'reservation_with_children' => 'Prenotazioni con Bambini',
            'reservation_with_extra_services' => 'Prenotato con uno specifico servizio extra',
            'last_reservation_year' => 'Anno ultima prenotazione',
            'birthdays' => 'Compleanni',
            'reservation_period' => 'Periodo della prenotazione',
            'reservation_stay_period' => 'Periodo di soggiorno',
            'customers_at_home' => 'Clienti in casa',
            'type_of_room_booked' => 'Tipologia camera prenotata',
            'booking_portal' => 'Portale di provenienza delle prenotazioni',
            'reservation_tag' => 'Etichetta',
            'addon_category' => 'Categoria servizi extra',
        ],
        'field_translate_error' => [
            'country' => 'Nazione',
            'city' => 'Città',
            'county' => 'Provincia',
            'state' => 'Regione',
            'check_phone_number' => 'Consenso numero di telefono',
            'check_newsletter_consent' => 'Consenso newsletter',
            'language' => 'Lingua',
            'check_reservation_with_children' => 'Prenotazioni con bambini',
            'addon' => 'Servizi Extra',
            'last_reservation_date' => 'Anno ultima prenotazione',
            'birthdays_date' => 'Data compleanno',
            'reservation_period_date' => 'Periodo della prenotazione',
            'check_actual_reservations' => 'Ospiti attualmente a casa',
            'accommodation' => 'Tipologia camera prenotata',
            'channel' => 'Portale di provenienza delle prenotazioni',
            'reservation_tag' => 'Etichetta',
        ]
    ],

    'newsletters' => [
        'unsubscribe_from_newsletter' => 'Disiscriviti dalla newsletter',
        'warnings' => [
            'cant_active' => 'La configurazione è stata salvata ma non può essere attivata per i seguenti motivi: :errors',
            'uneditable_channels' => 'Il canale di invio di una configurazione non può essere modificato',
            'uneditable_options' => 'Il canale di invio non permette modifica dei campi, per modificarli cancellare e creare una nuova configurazione',
            'existing_configuration' => 'Esiste una configurazione con gli stessi parametri',
            'cant_delete_pending_configuration' => 'Per eliminare questa configurazione in attesa di conferma è necessario attendere la scadenza della richiesta (24 ore dopo averla effettuata)',
            'cant_delete_blocked_configuration' => 'Non è possibile eliminare una configurazione bloccata',
            'cant_delete_configuration' => 'Momentaneamente non è possibile eliminare la configurazione per problemi tecnici, si prega di riprovare più tardi',
            'cant_delete_configuration_with_newsletters' => 'Non è possibile eliminare la configurazione poichè è associata alle seguenti newsletter non ancora inviate o pianificate: ',
            'cant_delete_sending_list' => 'Non è possibile eliminare la lista di invio selezionata poichè è associata alle seguenti newsletter: :newslettersTitles',
        ],
        'errors' => [
            'configuration_not_active' => 'Il mittente non è stato ancora verificato',
            'configuration_not_found' => 'La configurazione selezionata non è presente',
            'configuration_not_expired' => 'Impossibile riverificare la configurazione se non è scaduta o in attesa di conferma',
            'missing_default_configuration' => 'Per creare la newsletter occorre una configurazione di default attiva, verifica e riprova',
            'missing_default_locale' => 'Il template HTML nella lingua di default non è presente tra i template inviati',
            'missing_newsletter' => 'La newsletter selezionata non è presente',
            'elaborated_newsletter' => 'Non è possibile modificare o cancellare la newsletter selezionata, poichè è in lavorazione o è stata inviata',
            'missing_newsletter_contact' => 'Il contatto richiesto non è presente o non ha un indirizzo email impostato',
            'sending_list_contact_not_valid' => 'I seguenti parametri del contatto non sono validi: ',
            'contact_already_exclude' => 'Impossibile aggiungere il contatto poichè è già stato escluso dalla lista di invio',
            'contact_already_exist' => 'Impossibile aggiungere il contatto poichè è già presente all\'interno della lista di invio',
            'newsletter_in_processing' => 'Non è possibile modificare lo stato della newsletter selezionata, poichè è in lavorazione',
            'cant_update_sent_newsletter' => 'Non è possibile modificare la newsletter selezionata poichè è stata inviata. Può solo essere duplicata e archiviata',
            'impossible_delete_attempted_newsletter' => 'Non è possibile eliminare una newsletter con degli invii già effettuati',
            'newsletter_without_contacts' => 'Non sono stati trovati contatti nelle liste d\'invio selezionate, modifica le condizioni di inserimento contatti o seleziona altre liste.',
            'newsletter_task_in_error' => 'Errore generico di invio, duplica la campagna e riprova l\'invio tra qualche minuto.',
        ],
        'import' => [
            'validations' => [
                'email_required' => 'Il campo email è richiesto',
                'email_not_valid' => 'Il campo email non contiene una email valida',
            ]
        ]
    ],

    'odigeo' => [
        'exceptions' => [
            'configuration_missing' => 'I parametri di configurazione richiesti dal canale :channelName non sono presenti all\'interno della request',
            'configuration_not_valid' => 'I seguenti parametri non sono validi: :params',
            'invalid_age_range' => 'L\'intervallo di età per :field non è valido. Assicurati che le fasce di età siano corrette e in ordine.'
        ]
    ],

    'pa_friuli_venezia_giulia' => [
        'accommodation_name' => 'Tipologia',
        'accommodation_tableau_name' => 'Alloggio',
        'check_in' => 'Check In',
        'check_out' => 'Check Out',
        'nights' => 'Notti',
        'surname_and_name' => 'Cognome e nome',
        'date_of_birth' => 'Data di nascita',
        'citizenship' => 'Cittadinanza',
        'residence' => 'Residenza',
    ],

    'payment_method' => [
        'errors' => [],
        'warnings' => [],
        'fields' => [
            'model_name' => 'Metodo di pagamento',
        ],
        'paypal' => [
            'cannot_activate_paypal' => 'Impossibile attivare paypal, verifica che i campi Client ID e Secret siano corretti.',
        ],
        'nexi' => [
            'cannot_activate_nexi' => 'Impossibile attivare nexi, verifica che i campi Alias e Chiave MAC siano corretti.',
        ],
        'zpay' => [
            'payment_description_order' => 'Pagamento per conferma prenotazione',
            'cannot_activate_zpay' => 'Impossibile attivare ZPay, verifica che il codice esercente sia corretto',
            'cannot_refund' => 'Impossibile effettuare il rimborso di questo pagamento',
        ],
        'pos_argentea' => [
            'cannot_activate_pos_argentea' => 'Impossibile attivare POS Argentea, verifica che tutti i campi siano corretti.',
        ],
    ],

    'payments' => [
        'default_payment_email_body' => '<p>Gentile :name :surname,</p><p>In allegato potrai trovare il documento relativo al tuo pagamento</p>',
        'default_payment_email_subject' => 'Notifica di pagamento',
        'cannot_complete_payment_due_to_gateway' => 'Il gateway di pagamento non ha potuto completare l\'operazione con successo',
        'payment_order_cannot_be_completed_due_to_wrong_status' => 'Lo stato del pagamento risulta già completato',
        'payment_order_is_not_a_pre_authorization' => 'Questo pagamento non risulta essere una pre autorizzazione',
        'cannot_complete_payment_gateway_requires_action' => 'La richiesta è stata inviata correttamente. Riceverai una notifica quando il pagamento verrà effettuato.',
        'payment' => 'pagamento',
        'checkinonline_created_order_citytax' => 'Pagamento tassa di soggiorno da Checkin Online',
        'refund_payment' => 'Rimborso pagamento di :customer_name :customer_surname del :payment_date',
        'pre_authorization_text' => 'Pre autorizzazione',
        'zpay' => [
            'payment_already_process' => 'Il pagamento risulta in fase di elaborazione, ti preghiamo di attendere qualche minuto prima di riprovare',
        ],
        'email_payment_request' => [
            'subject' => 'Richiesta di pagamento da parte di :propertyName',
            'message' => '<p>Gentile <strong>:name :surname</strong>,</p><p>Per la sua prenotazione numero <strong>#:reference_number</strong> è stato richiesto il seguente addebito.</p>',
            'message_without_reservation' => '<p>Gentile <strong>:name :surname</strong> è stato richiesto il seguente addebito.</p>',
            'confirm_payment' => 'Paga adesso :amount',
        ],
        'email_pre_authorization_request' => [
            'subject' => 'Richiesta di pre autorizzazione da parte di :propertyName',
            'message' => '<p>Gentile <strong>:name :surname</strong></p><p>per la sua prenotazione numero <strong>#:reference_number</strong> è stata effettuata la seguente pre autorizzazione.</p>',
            'message_without_reservation' => '<p>Gentile <strong>:name :surname</strong> è stata effettuata la seguente pre autorizzazione.</p>',
        ],
        'pre_authorization' => [
            'subject' => 'Pre autorizzazione da parte di :propertyName',
            'message' => '<p>Gentile <strong>:name :surname</strong>,</p><p>per la sua prenotazione numero <strong>#:reference_number</strong> è stata richiesta la seguente pre autorizzazione.</p>',
        ],
        'direct_charge' => [
            'subject' => 'Addebito diretto da parte di :propertyName',
            'message' => '<p>Gentile <strong>:name :surname</strong></p><p>per la sua prenotazione numero <strong>#:reference_number</strong> è stato effettuato il seguente addebito.</p>',
        ],
        'direct_charge_failed' => [
            'subject' => 'Addebito diretto da parte di :propertyName fallito',
            'message' => '<p>Gentile <strong>:name :surname</strong></p><p>la informiamo che in  data odierna abbiamo provato ad effettuare l\'addebito relativo alla prenotazione <strong>#:reference_number</strong>. Tuttavia non siamo riusciti ad effettuare il seguente addebito.</p>',
        ],
        'payment_order' => [
            'default_whatsapp_text' => 'Gentile :name :surname, Per la sua prenotazione numero :reference_number. ti è stata inviata una richiesta di :type clicca qui :link',
        ],
        'customer_confirmed_payment_order_notification' => [
            'subject' => 'Ricevuto pagamento di :amount da :customerName :customerSurname - :propertyName',
            'message' => 'La informiamo che :customerName :customerSurname ha effettuato il pagamento di :amount per la prenotazione # :referenceNumber (:arrivalDate - :departureDate) - :propertyName',
            'click_here_to_view' => 'Per visualizzare tutti i dettagli della prenotazione clicca qui',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'subject' => 'Il cliente ha completato il pagamento',
            'message' => 'La informiamo :customerName :customerSurname ha effettuato il pagamento di :amount - :propertyName',
        ],
        'pre_authorization_is_expiring' => [
            'subject' => 'La tua pre autorizzazione è in scadenza',
            'message' => 'La informiamo :customerName :customerSurname non ha ancora autorizzato la pre autorizzazione in scadenza domani di :amount per la prenotazione # :referenceNumber (:arrivalDate - :departureDate) - :propertyName',
            'message_without_reservation' => 'La informiamo :customerName :customerSurname non ha ancora autorizzato la pre autorizzazione in scadenza domani di :amount - :propertyName',
        ],

        'timetable' => [
            'title' => 'Pagamenti programmati',
            'export_fields' => [
                'scheduled_date' => 'Data di pagamento',
                'booker' => 'Prenotante',
                'reservation_total_price' => 'Totale prenotazione',
                'amount' => 'Pagamento programmato',
                'reservation_arrival_date' => 'Data di arrivo',
                'reservation_departure_date' => 'Data di partenza',
                'property' => 'Struttura',
                'sca_accepted' => 'Stato SCA'
            ],
            'sca_accepted' => 'Accettata',
            'sca_not_accepted' => 'Non Accettata',
            'change_status_date_past' => 'Non è possibile pianificare una data di pagamento nel passato.',
            'no_credit_card_found' => 'Nessuna carta di credito impostata nella prenotazione',
            'required_action_3d' => 'Addebito non riuscito, è stata richiesta l\'autenticazione 3D Secure',
            'required_action_requested_payment' => 'Richiesta di pagamento inviata il :send_date - scadenza :expire_date',
            'request_payment_wait_customer_expired' => 'Richiesta di pagamento scaduta',
            'timetable_pause_expired' => 'Pagamento programmato in pausa scaduto',
            'force_payment_due_date' => 'Il pagamento può essere forzato solo se la data di pagamento coincide con la data odierna',
            'reservation_cancelled' => 'Prenotazione cancellata',
            'property_cancelled' => 'Struttura sospesa, scaduta o cancellata',
            'module_deactivated' => 'Il modulo Pagamenti Programmati è stato disattivato o è scaduto',
            'charge_status_manual_change' => 'Pagamento modificato da :current_charge_status a :new_charge_status',
            'manual_payment_bound' => 'Pagamento manuale inserito',
            'stripe_not_active' => 'Il metodo di pagamento Stripe non risulta attivo',
            'invoice_default_causal' => 'Addebito del pagamento :payment_method_name del :date riferito alla prenotazione :reservation_reference',
            'delete_propery_has_payments' => 'La struttura ha pagamenti programmati attivi. Proseguendo tutti i pagamenti programmati verranno messi in pausa. L\'operazione è irreversibile',
            'amount_over_to_pay' => 'Il pagamento eccede il totale da pagare della prenotazione',
            'change_tax_payment_amount' => 'Pagamento di tassa di soggiorno modificato da :old_amount a :new_amount',
            'manual_payment_cancelled' => 'Cancellato pagamento manuale precedentemente associato',
            'payment_refunded_created' => 'Effettuato rimborso di  :amount',
            'payment_refunded_modified' => 'Modificato il rimboerso da :currency_symbol :old_amount a :currency_symbol :new_amount',
            'reservation_reconfirmed' => 'Prenotazione riconfermata',
            'reservation_optionable' => 'Prenotazione in opzione',
            'reservation_pending' => 'Prenotazione in attesa di conferma',
            'payment_succeded' => 'Pagamento di :amount :currency_symbol eseguito',
            'city_tax_estimation_warning' => 'L\'importo stimato di :city_tax_amount :currency_symbol della tassa di soggiorno non è stato addebitato perché non è stato effettuato il calcolo per uno o più ospiti.',
            'charge_reminder_email_sent' => 'Inviata email di promemoria addebito',
            'charge_reminder' => [
                'subject' => ':propertyName - Promemoria di addebito',
                'message' => 'Gentile :booker_name :booker_surname, 
                <br /><br />
                In data :date_today, è previsto un addebito di :amount :currency_symbol, secondo quanto previsto dalle condizioni di pagamento. 
                <br /><br />  
                <strong><span style="color: #8f743f;">Prenotazione numero #:reference_number dal :arrival_date al :departure_date.</strong>',
            ],
            'city_tax_distrubuited_first_payment' => 'Calcolata tassa di soggiorno e distribuita nella prima data di pagamento utile',
            'city_tax_distrubuited_in_checkout_date' => 'Calcolata tassa di soggiorno e distribuita nella data di checkout',
            'city_tax_recalculated_change_checkout_without_missing_guest' => 'Calcolata tassa di soggiorno per :registered_guests ospiti registrati',
            'city_tax_recalculated_change_checkout_with_missing_guest' => 'Calcolata tassa di soggiorno per :registered_guests ospiti registrati e stimati :missing_guests ospiti',
        ],
        'errors' => [
            'conditions_with_conflicts' => 'Le condizioni passate hanno giorni di addebiti di notti identici o i totali delle percentuali di addebito supera il 100% dell\'importo',
            'payment_timetable_already_processed' => 'Il pagamento da scadenziario è stato già processato o in attesa',
            'payment_timetable_already_bound' => 'Il pagamento da scadenziario ha già generato un pagamento',
            'payment_timetable_attach_email_invoice_error' => 'Non è stato possibile allegare la fattura richiesta dal cliente a causa del seguente errore: :error_description',
            'missing_policy' => 'Policy di pagamento non trovata per la prenotazione',
            'impossible_change_payment_method_id' => 'Impossibile modificare il pagamento con il metodo di pagamento selezionato',
        ],
        'warnings' => [
            'no_restrictions_and_period_policy' => 'La policy di pagamento non ha restrizioni e/o periodi di applicazione, potrebbe entrare in conflitto con le altre esistenti',
            'no_restrictions_and_period_others' => 'La policy :name non ha restrizioni o periodi di applicazione potrebbe entrare in conflitto con quella che stai gestendo',
            'overlapping_period_for_restriction' => 'La policy :name ha almeno un periodo di sovrapposizione con almeno una restrizione in comune con quella che stai gestendo e potrebbe creare conflitti',
            'existing_restriction' => 'La policy :name ha almeno una restrizione in comune con quella che stai gestendo e potrebbe creare conflitti',
        ],
        'fields' => [
            'payment_agreement_id' => 'identificativo accordo di pagamento'
        ],
        'method_options_fields' => [
            'type' => 'Tipo pagamento',
            'ALT' => 'Altro pagamento',
        ]
    ],

    'policy' => [
        'errors' => [
            'no_show_option_not_compatible' => 'Opzioni di no_show non compatibili',
            'deposit_option_not_compatible' => 'Opzioni di acconto non compatibili',
            'choose_deposit_pay' => 'Devi scegliere quando effettuare addebito',
            'condition_not_compatible' => 'Condizioni di cancellazione non compatibili',
            'duplicate_penalty' => 'Penalità duplicate nelle condizioni di cancellazione',
            'no_show_condition_not_applicable' => 'Non puoi applicare queste condizioni al no_show',
            'deposit_condition_not_applicable' => 'Non puoi applicare queste condizioni all\'acconto',
            'duplicate_penalty_deposit' => 'Penalità duplicate nella sezione acconto',
            'no_condition_to_deposit' => 'Nessuna condizione applicata al deposito',
            'policy_to_rateplan' => 'Policy connessa ad almeno un rateplan',
            'delete_policy_default' => 'Non puoi eliminare le policy di default',
            'last_policy' => 'Non è possibile elimnare l\'ultima policy della struttura',
            'policy_not_allowed_in_period' => 'Non puoi sovrascrivere un periodo con la stessa policy del piano tariffario.',
            'policy_period_overlapping' => 'I periodi per le policy sono sovrapposti.',
            'check_priority_custom' => 'Sono presenti priorità per la policy, verificarne la correttezza.',
            'check_priority_and_period' => 'Sono presenti priorità o periodi per la policy.',
        ],
        'names' => [
            'standard' => 'Cancellazione gratuita',
            'not_ref' => 'Non rimborsabile',
            'default_ota_name' => 'Vedi OTA',
            'default_ota_description' => 'Policy non inviata dal canale',
            'hour_title_policy' => ' fino alle :hour del giorno di arrivo.',
            'nights' => 'notte|notti',
            'days' => 'giorno|giorni',
        ],
        'transform_to_date' => [
            'date_limit' => '<p>Puoi cancellare gratuitamente fino alle 23:59 del :date_limit.</p>',
            'date_limit_percentage' => '<p>Se cancelli entro il :date_limit ti verrà addebitato il :penalty_value% del costo totale.</p>',
            'date_limit_nights' => '<p>Se cancelli entro il :date_limit ti verrà addebitato il costo di :penalty_value notti.</p>',
            'date_limit_amount' => '<p>Se cancelli entro il :date_limit ti verrà addebitato l\'importo di :penalty_value :currency.</p>',
            'date_over_percentage' => '<p>Se cancelli dopo il :date_limit ti verrà addebitato il :penalty_value% del costo totale.</p>',
            'date_over_nights' => '<p>Se cancelli dopo il :date_limit ti verrà addebitato il costo di :penalty_value notti.</p>',
            'date_over_amount' => '<p>Se cancelli dopo il :date_limit ti verrà addebitato l\'importo di :penalty_value :currency.</p>',
            'date_over_percentage_hour' => '<p>Se cancelli dopo le :hour_limit del :date_limit ti verrà addebitato il :penalty_value% del costo totale.</p>',
            'date_over_nights_hour' => '<p>Se cancelli dopo le :hour_limit del :date_limit ti verrà addebitato il costo di :penalty_value notti.</p>',
            'date_over_amount_hour' => '<p>Se cancelli dopo le :hour_limit del :date_limit ti verrà addebitato l\'importo di :penalty_value :currency.</p>',
            'date_now_percentage' => '<p>Se cancelli adesso ti verrà addebitato il :penalty_value% del costo totale.</p>',
            'date_now_nights' => '<p>Se cancelli adesso ti verrà addebitato il costo di :penalty_value notti.</p>',
            'date_now_amount' => '<p>Se cancelli adesso ti verrà addebitato l\'importo di :penalty_value :currency.</p>',
            'date_now_noshow_percentage' => '<p>In caso di mancata presentazione ti verrà addebitato il :penalty_value% del costo totale.</p>',
            'date_now_noshow_nights' => '<p>In caso di mancata presentazione ti verrà addebitato il costo di :penalty_value notti.</p>',
            'date_now_noshow_amount' => '<p>In caso di mancata presentazione ti verrà addebitato l\'importo di :penalty_value :currency.</p>',
        ],
        'transform_to_date_notref' => [
            'date_now_percentage' => '<p>Se cancelli in qualsiasi momento dopo la prenotazione ti verrà addebitato il :penalty_value% del costo totale.</p>',
            'date_now_nights' => '<p>Se cancelli in qualsiasi momento dopo la prenotazione ti verrà addebitato il costo di :penalty_value notti.</p>',
            'date_now_amount' => '<p>Se cancelli in qualsiasi momento dopo la prenotazione ti verrà addebitato l\'importo di :penalty_value :currency.</p>',

            'date_limit_percentage' => '<p>Se cancelli entro le :hour_limit del :date_limit ti verrà addebitato il :penalty_value% del costo totale.</p>',
            'date_limit_nights' => '<p>Se cancelli entro le :hour_limit del :date_limit ti verrà addebitato il costo di :penalty_value notti.</p>',
            'date_limit_amount' => '<p>Se cancelli entro le :hour_limit del :date_limit ti verrà addebitato l\'importo di :penalty_value :currency.</p>',

            'date_now_deposit_percentage' => '<p>Ti verrà addebitato il :penalty_value% del costo totale al momento della prenotazione.</p>',
            'date_now_deposit_nights' => '<p>Ti verrà addebitato il costo di :penalty_value notti al momento della prenotazione.</p>',
            'date_now_deposit_amount' => '<p>Ti verrà addebitato l\'importo di :penalty_value :currency al momento della prenotazione.</p>',

            'date_now_noshow_percentage' => '<p>In caso di mancata presentazione ti verrà addebitato il :penalty_value% del costo totale.</p>',
            'date_now_noshow_nights' => '<p>In caso di mancata presentazione ti verrà addebitato il costo di :penalty_value notti.</p>',
            'date_now_noshow_amount' => '<p>In caso di mancata presentazione ti verrà addebitato l\'importo di :penalty_value :currency.</p>',
        ],
    ],

    'property_report' => [
        'property' => [
            'label' => 'Struttura',
            'description' => 'Questa opzione ti permette di esportare i dati della struttura',
        ],
        'children_ranges' => [
            'label' => 'Fasce bambini',
            'description' => 'Questa opzione ti permette di esportare le fasce bambini',
        ],
        'accommodations' => [
            'label' => 'Alloggi',
            'description' => 'Questa opzione ti permette di esportare gli alloggi con i relativi dettagli',
        ],
        'treatments' => [
            'label' => 'Trattamenti',
            'description' => 'Questa opzione ti permette di esportare i trattamenti',
        ],
        'policies' => [
            'label' => 'Politiche di cancellazione',
            'description' => 'Questa opzione ti permette di esportare le condizioni di cancellazione',
            'addons_to_deposit' => [
                'included' => 'Servizi extra inclusi',
                'not_included' => 'Servizi extra non inclusi nel calcolo'
            ]
        ],
        'rate_plans' => [
            'label' => 'Piani tariffari',
            'description' => 'Questa opzione ti permette di esportare i piani tariffari',
        ],
        'invoice_layouts' => [
            'label' => 'Profili di fatturazione',
            'description' => 'Questa opzione ti permette di esportare i profili di fatturazione',
        ],
        'city_tax' => [
            'label' => 'Tassa di soggiorno',
            'description' => 'Questa opzione ti permette di esportare la configurazione della tassa di soggiorno',
            'active' => 'Attivo',
            'not_active' => 'Non Attivo'
        ],
        'payments_method' => [
            'label' => 'Metodi di pagamento',
            'description' => 'Questa opzione ti permette di esportare la configurazione dei pagamenti',
            'day' => '{0,1} giorno|[2,*] giorni'
        ],
    ],

    'property' => [
        'errors' => [
            'already_attached' => 'Attach già esistente',
            'property_has_another_master' => 'La stuttura ha già un utente master. Per procedere, eliminare l\'associazione di quest\'ultimo con la struttura',
            'letti_extra_exception_delete' => 'non puoi eliminare questo letto extra perchè devi prima eliminare il numero :lettimax invece hai cambiato il numero :lettimin',
            'letti_extra_exception_missing' => 'alcuni elementi sono mancanti',
            'override_periods_policy' => 'Periodi sovrapposti',
            'place_not_found' => 'Luogo non trovato',
            'not_group_owner' => 'Non sei il properietario di questo gruppo',
            'group_is_default' => 'Non è possibile rimuovere il gruppo predefinito',
            'already_in' => 'Struttura presente nel gruppo, impossibile procedere',
            'already_all_in' => 'Struttura presente in uno dei tuoi gruppi, impossibile procedere',
            'not_in_group' => 'Struttura non presente in un gruppo',
            'existing_extra_bed_setting' => 'Impostazione del letto extra esistente',
            'missing_extra_bed_setting' => 'Impostazione del letto extra mancante rispetto a questa',
            'overcoming_extra_bed' => 'Letto extra in esubero rispetto la configurazione camere esistente',
            'role_conflict' => 'Il ruolo è già esistente',
            'cant_detach_default_group' => 'Non è possibile disassociare la struttura dal gruppo di default',
            'groups_have_properties' => 'Non è possibile cancellare questo gruppo perchè sono presenti strutture',
            'uneditable_expense_category' => 'Categoria spese non modificabile',
            'expenses_pending' => 'Categoria spese non cancellabile per spese collegate',
            'missing_vat_quotes' => 'Attenzione! La nazione selezionata non ha aliquote iva impostate. Configurarle prima di procedere',
            'cutoff_rules_exist' => 'Regola di cutoff già esistente.',
            'missing_lat_lon' => 'Non sono state impostate le coordinate (LAT o LON) relative a questa struttura',
            'undetachable_layout' => 'Non puoi disassociare questo profilo se non ne hai almeno un altro associato',
            'customer_not_belonging_to_property_group' => 'Il cliente :customer_id non appartiene al gruppo strutture o non esiste',
            'update_expiration_bulk' => 'Errore nell\'aggiornamento delle scadenze',
            'update_cancellation_bulk' => 'Errore nell\'aggiornamento dello stato di disdetta',
            'update_activation_bulk' => 'Errore nell\'aggiornamento dello stato di abilita / disabilita',
            'unauthorized_access' => 'Non sei autorizzato ad accedere a questa risorsa.',
            'unauthorized_insolvent_status' => 'Il suo account è stato bloccato per insoluto, pertanto, la invitiamo a scrivere a "zucchettihospitality.gestione.crediti@zucchetti.it" per allineare la sua posizione contabile.'
        ],
        'warnings' => [
            'request_confirm_change_discount_type' => 'La modifica della tipologia di sconto comporta l\'eliminazione di tutte le configurazioni personalizzate. Continuare?',
            'request_confirm_delete_extra_bed' => 'La cancellazione di questo letto extra comporta l\'eliminazione dei letti extra superiori. Continuare?',
            'invalid_facility' => 'Facility non compatibile',
            'disabled_update' => 'Il canale :channel_name non è abilitato all\'invio dei dati',
            'nothing_to_update' => 'Niente da inviare su :channel',
            'missing_invoice_layout_without_vat_code_with_all_inclusive_tax_enabled' => 'Attenzione! La struttura abilitata non ha nessun profilo di fatturazione idoneo all\'emissione della cedolare secca',
            'properties_has_not_istat_module' => 'la struttura :property_name non ha il modulo istat abilitato',
            'update_overcome_days' => 'Le seguenti date non sono state aggiornate poichè superano il limite massimo dei giorni: :dates',
            'download_overcome_days' => 'Non sono stati scaricati dati per le seguenti date poichè superano il limite massimo dei giorni: :dates',
            'missing_property_xml_id' => 'Attenzione! Non è stato inserito il property_xml_id all\'interno dei settings del canale :channel_name'
        ],
        'city_tax' => [
            'main_report_title' => 'Riepilogo tassa di soggiorno',
            'recap_city_tax_totals' => 'Riepilogo totali tassa di soggiorno',
            'exemptions' => 'Esenzioni',
            'limit_nights' => 'Limite notti',
            'total_guests' => 'Ospiti totali',
            'totals' => 'Totali',
            'total_taxed_guests' => 'Ospiti tassati',
            'total_exempted_guests' => 'Ospiti esenti',
            'exemption_details' => 'Dettaglio esenzioni',
            'taxed_details' => 'Dettaglio tassati',
            'taxed_details_ranges' => 'Da :min a :max anni',
            'exemptions_over' => 'Esenti oltre limite',
            'guests_over' => 'Paganti oltre limite',
            'guests' => 'Ospiti',
            'city_tax_amount' => 'Totale tassa di soggiorno',
            'all_properties' => 'Tutte le strutture',
            'from_to_age_ranges' => 'Da :min_age a :max_age anni',
            'taxed_nights' => 'Pernottamenti di ospiti soggetti ad imposta',
        ],
        'commissions' => [
            'period_exists' => 'Periodo già esistente',
            'invalid_period' => 'Periodo errato',
            'season_too_long' => 'Intervallo stagionale troppo lungo',
        ],
        'list' => 'Lista strutture',
        'export_fields' => [
            'id' => 'ID',
            'name' => 'Nome',
            'group' => 'Gruppo',
            'address' => 'Indirizzo',
            'city' => 'Città',
            'state' => 'Stato',
            'county' => 'Provincia',
            'country' => 'Nazione',
            'zip_code' => 'Cap',
            'type' => 'Tipologia',
            'email' => 'Email',
            'telephone' => 'Tel',
            'reference_name' => 'Nome referente',
            'reference_surname' => 'Cognome referente',
            'reference' => 'Referente',
            'modules' => 'Moduli',
            'activated_date' => 'Data attivazione',
            'expire_date' => 'Data scadenza',
            'status' => 'Stato',
            'user_first_name' => 'Nome proprietario',
            'user_last_name' => 'Cognome proprietario',
            'user' => 'Proprietario',
            'user_email' => 'Email proprietario',
            'resellers' => 'Rivenditori',
            'business_name' => 'Ragione sociale',
            'vat_number' => 'Partita IVA',
            'fiscal_code' => 'Codice Fiscale',
            'properties_modules' => 'Moduli struttura',
            'accommodations' => 'Alloggi',
            'quantity' => 'Quantità',
            'contacts' => 'Contatti',
        ],
        'initials_name' => [
            'booking-engine' => 'BE',
            'channel-manager' => 'CM',
            'rate-checker' => 'RC',
            'brand-protection' => 'BP',
            'google-ads' => 'GA',
            'google-commission' => 'GC',
            'tripadvisor-istant-booking' => 'TIB',
            'trivago-fast-connect' => 'TFC',
            'booking-engine-quotes' => 'BEQ',
            'guests-reporting' => 'GR',
            'pms' => 'PMS',
            'newsletter' => 'CRM',
            'automatic-payments' => 'AP',
        ],
        'clone' => [
            'cloning-job-scheduled' => 'La clonazione verrà effettuata a breve, controlla tra qualche minuto.'
        ],
        'not_found' => 'I seguenti ID non esistono: ',
        'log'  => [
            'property_module_enabled' => 'Modulo stuttura abilitato',
            'property_module_disabled' => 'Modulo struttura disabilitato',
            'beddy_channel_disabled' => 'Canale Beddy disabilitato',
            'beddy_channel_enabled' => 'Canale Beddy abilitato',
            'property_disactivated' => 'Struttura disattivata',
            'property_activated' => 'Struttura attivata',
            'property_cancelled' => 'Disdetta registrata per la struttura',
            'property_cancellation_reversed' => 'Annullamento della disdetta registrato per la struttura',
            'property_update_expiration_date' => 'Scadenza contratto struttura aggiornato',
        ],
        'treatment' => [
            'log' => [
                'attach' => 'E\' stato associato il trattamento :treatment_name alle strutture :property_names con supplemento prezzo :supplement_price e variazione prezzo :share_price. :children_detail :apply_past',
                'children_detail' => ' Per la fascia :age_range è stato impostato il supplemento di :supplement_price e la variazione :share_price.',
                'apply_past' => ' La configurazione è stata propagata nelle prenotazioni effettuate tra il :from e il :to',
                'detach' => 'E\' stato dissociato il trattamento :treatment_name per la struttura :property_name',
                'update' => 'E\' stato modificato il trattamento :treatment_name impostando supplemento prezzo :supplement_price e variazione prezzo :share_price. :children_detail :children_delete :detail_delete',
                'detail_delete' => 'La variazione prezzo è stata azzerata rispetto alla precedente, quindi sono stati eliminati tutti i dettagli associati precedentemente',
            ],
        ],
    ],

    'push_notifications' => [
        'multiple_sessions' => [
            'title' => 'Avviso di sicurezza: più dispositivi connessi al suo account',
            'message' => 'Sono state rilevate connessioni da più dispositivi al suo account, è necessario verificare le sessioni attualmente attive.',
        ],
        'reservation_new' => [
            'title' => 'Nuova prenotazione da :channel_name (:name_surname).',
            'message' => ':name_surname ha prenotato l’alloggio :accommodation_name della struttura :property_name dal :arrival_date al :departure_date.',
        ],
        'reservation_modified' => [
            'title' => 'Modifica prenotazione di :name :surname da :channel_name.',
            'message' => 'È stata modificata la prenotazione di :name :surname dal :arrival_date al :departure_date per l’alloggio :accommodation_name della struttura :property_name.',
        ],
        'reservation_cancelled' => [
            'title' => 'Cancellazione prenotazione di :name :surname da :channel_name.',
            'message' => 'È stata cancellata la prenotazione di :name :surname dal :arrival_date al :departure_date della struttura :property_name. ',
        ],
        'reservation_banktransfer_cancelled' => [
            'title' => 'Cancellazione prenotazione di :name :surname da :channel_name per mancato pagamento',
            'message' => 'È stata cancellata in automatico la prenotazione di :name :surname dal :arrival_date al :departure_date della struttura :property_name. ',
        ],
        'invoice_rejected' => [
            'title' => 'Fattura :number_complete di :name :surname rifiutata da SDI.',
            'message' => 'La fattura :number_complete di :name :surname è stata rifiutata per il seguente motivo: :rejected_reason.',
        ],
        'invoice_received' => [
            'title' => 'Ricevuta fattura da :sender_name.',
            'message' => 'È stata ricevuta la fattura numero :document_number del :document_date da :sender_name',
        ],
        'checkin_online_complete' => [
            'title' => 'Check-in online effettuato (:name :surname).',
            'message' => 'Il cliente :name :surname ha effettuato il check-in online per la prenotazione dal :arrival_date al :departure_date dell’alloggio :accommodation_name della struttura :property_name.',
        ],
        'reservation_quote_expired' => [
            'title' => 'Preventivo scaduto :name :surname.',
            'message' => 'È scaduto il preventivo di :name :surname, creato il :created_date.',
        ],
        'housekeeper_maintainer' => [
            'title' => 'Nuova segnalazione di manutenzione per l\'alloggio :accommodation_name',
            'message' => 'È stata inserita una nuova segnalazione di manutenzione per l\'alloggio :tableau_label. :title - :description',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'title' => 'Cambio stato di pulizia per l\'alloggio :cleanable_name - :accommodation_name',
            'message' => ':user_name ha impostato lo stato di pulizia in :clean_status nel giorno :reference_date per l\'alloggio :cleanable_name (:accommodation_name) della struttura :property_name.',
        ],
        'reservation_option_expired' => [
            'title' => 'Prenotazione in opzione scaduta (:name :surname) ',
            'message' => 'È scaduta l’opzione della prenotazione di :name :surname dal :arrival_date al :departure_date per l’alloggio :accommodation_name della struttura :property_name. ',
        ],
        'order_payment_release' => [
            'subject' => 'Pre-Autorizzazione sbloccata (:name :surname).',
            'body' => 'È stata rilasciata la pre-autorizzazione di pagamento della prenotazione di :name :surname dal :arrival_date al :departure_date della struttura :property_name.',
        ],
        'sca_authorized' => [
            'title' => 'Modulo SCA confermato da :name :surname.',
            'message' => 'Il cliente :name :surname ha confermato il modulo SCA in data :accepted_date dall’indirizzo IP :ip_address. ',
        ],
        'customer_confirmed_payment_order_notification' => [
            'title' => 'Nuovo pagamento ricevuto da :name :surname.',
            'message' => 'Il cliente :name :surname ha effettuato un pagamento di :amount sulla prenotazione dal :arrival_date al :departure_date della struttura :property_name. ',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'title' => 'Nuovo pagamento ricevuto da :name :surname.',
            'message' => 'Il cliente :name :surname ha effettuato un pagamento di :amount.',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => 'Disponibilità terminata per l’alloggio :accommodation_name della struttura :property_name.',
            'body' => 'È terminata la disponibilità su :accommodation_name per le seguenti date: :days',
        ],
        'reservation_queue_complete' => [
            'subject' => 'Prenotazione :name :surname elaborata.',
            'body' => 'La prenotazione per il cliente :name :surname è stata correttamente elaborata',
        ],

        'guests_reporting' => [
            'subject' => 'Invio schedine Alloggiati - :alloggiatiweb_group_label',
            'success' => '1 schedina inviata con successo|:number schedine inviate con successo',
            'error' => '1 schedina non inviata|:number schedine non inviate :errorMessage',
        ],

        'quote_request' => [
            'subject' => 'Nuova richiesta di preventivo',
            'message' => ':customer_name :customer_surname ha appena effettuato una richiesta di preventivo per la tua struttura.',
        ],
        'treatment_price_update' => [
            'subject' => 'Statistiche trattamenti aggiornate su - :property_name',
            'message' => 'Il ricalcolo con i valori aggiornati dal :start_date al :end_date per il trattamento :treatment_name è stato completato.',
        ],
        'queue_past_reservations_task_record_summary' => [
            'subject' => 'Riepilogo Task elaborazioni prenotazioni antecedenti - :property_name (:property_id) canale :channel_name (:channel_id)',
            'message' => 'Sono state elaborate :reservations_elaborated prenotazioni antecendenti su :reservations_total totali. Ci sono :reservations_require_action prenotazioni che richiedono azioni da parte tua.',
        ],
        'queue_past_reservations_task_error' => [
            'subject' => 'Errore Task elaborazioni prenotazioni antecedenti - :property_name (:property_id) canale :channel_name (:channel_id)',
            'message' => 'Si è verificato un errore durante l\'elaborazione della coda prenotazioni antecendenti. Messaggio di errore :error_description',
        ],
        'reservation_message_received' => [
            'title' => 'Nuovo messaggio da :senderName (#:reference)',
        ],
        'conversation_message_send_failed' => [
            'title' => 'Invio messaggio fallito',
            'message' => 'Il messaggio diretto a :recipientName non è stato consegnato',
        ],
        'urmet_sclak_error_generate_key' => [
            'title' => 'Errore creazione chiavi prenotazione :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Si è verificato un errore su Sclak relativo alla generazione delle chiavi delle camere: :errors . Riprovare manualmente, se il problema persiste contattare l\'assistenza Urmet',
        ],
        'nuki_error_generate_key' => [
            'title' => 'Errore creazione PIN prenotazione :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Si è verificato un errore su Nuki relativo alla generazione del PIN delle camere: :errors . Riprovare manualmente, se il problema persiste contattare l\'assistenza Nuki',
        ],
        'urmet_sclak_error_sending_sms' => [
            'title' => 'Errore invio SMS chiavi prenotazione :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Non è stato possibile inviare l\'SMS di Sclak poichè è avvenuto un errore. <br> Ti consigliamo di contattare l\'assistenza Urmet',
        ],
        'single_property_export_completed' => [
            'title' => 'Esportazione :exportProviderName completata',
            'message' => 'Il file :fileName è pronto per il download',
        ],
        'single_property_export_not_completed' => [
            'title' => 'Esportazione :exportProviderName non riuscita',
            'message' => 'L\'esportazione effettuata in data :date alle ore :time non è andata a buon fine',
        ],
        'multi_property_export_completed' => [
            'title' => 'Esportazione :exportProviderName completata',
            'message' => 'Il file :fileName è pronto per il download',
        ],
        'multi_property_export_not_completed' => [
            'title' => 'Esportazione :exportProviderName non riuscita',
            'message' => 'L\'esportazione effettuata in data :date alle ore :time non è andata a buon fine',
        ],
        'newsletter_sent' => [
            'title' => 'Conferma di invio newsletter',
            'message' => 'La newsletter :newsletterName è stata inviata correttamente',
        ],
        'newsletter_not_sent' => [
            'title' => 'Errore invio newsletter',
            'message' => 'Non è stato possibile inviare la campagna “:newsletterName” a causa di questi errori: :errorMessage',
        ],
        'newsletter_exceeded_sent_limit' => [
            'title' => 'Quota di invii mensile superata',
            'message' => 'La newsletter :newsletterName non è stata inviata, a causa del superamento della quota mensile di invii di email',
        ],
        'remote_door_key_service_reservation_resumed' => [
            'title' => 'Modifiche a prenotazioni, generare nuove chiavi',
            'message' => 'È necessario generare una nuova chiave per la prenotazione di <b>:booker_name :booker_surname- :reference_number</b> della struttura <b>:property_name</b>',
        ],
        'remote_door_key_service_reservation_moved' => [
            'title' => 'Uno o più alloggi sono stati spostati. È necessario generare una nuova chiave.',
            'message' => 'Uno o più alloggi della prenotazione di <b>:booker_name :booker_surname- :reference_number</b> della struttura <b>:property_name</b> sono stati spostati. È necessario generare una nuova chiave.',
        ],
        'send_city_tax_report' => [
            'title' => 'Conferma invio report tasse di soggiorno',
            'message' => 'L\'invio del report della tassa di soggiorno per il canale di invio :channelName è stato effettuato con successo'
        ],
        'send_city_tax_report_not_completed' => [
            'title' => 'Errore invio report tasse di soggiorno',
            'message' => 'L\'invio del report della tassa di soggiorno per il canale di invio :channelName non è andato a buon fine'
        ],
        'export_city_tax_report' => [
            'title' => 'L\'esportazione del report delle tasse di soggiorno per il canale :channelName è pronta',
            'message' => 'Clicca sulla notifica per essere reindirizzato alla pagina di storico delle esportazioni'
        ],
        'export_city_tax_report_not_completed' => [
            'title' => 'Non è stato possibile completare l\'esportazione dei report della tassa di soggiorno per il canale :channelName',
            'message' => 'La generazione del report :reportId non è andata a buon fine'
        ],
        'guest_atrtributes_missing_in_city_tax_report' => [
            'title' => 'Errore invio/esportazione report tasse di soggiorno'
        ],
        'empty_city_tax_report' => [
            'title' => 'Errore invio/esportazione report tasse di soggiorno per il canale :channelName',
            'message' => 'Il report delle tasse di soggiorno non è stato elaborato poichè per il periodo selezionato non è stato estratto nessun ospite da comunicare al canale'
        ],
        'accommodation_deleted' => [
            'title' => 'Azione Richiesta',
            'message' => 'È stato ridotto il numero di unità disponibili per l\'alloggio :accommodationName della struttura :propertyName, per evitare l\'overbooking è necessario effettuare un reset delle disponibilità.'
        ],
        'payment_timetable_stripe_not_active' => [
            'title' => 'Addebito pagamento automatico fallito - Stripe non attivo',
            'message' => 'Non è stato possibile effettuare l\'addebito relativo al pagamento automatico in oggetto poichè non risulta un account Stripe attivo da utilizzare per effettuare l\addebito.',
        ],
        'payment_timetable_charge_failed' => [
            'title' => 'Addebito pagamento automatico fallito',
            'message' => 'Non è stato possibile effettuare l\'addebito relativo al pagamento automatico in oggetto per il seguente motivo: :error_description',
        ],
        'payment_timetable_no_credit_card' => [
            'title' => 'Addebito pagamento automatico fallito - Carta di credito non presente',
            'message' => 'Non è stato possibile effettuare l\'addebito relativo al pagamento automatico in oggetto poichè non è presente una carta di credito da utilizzare per effettuare l\addebito.',
        ],
        'accommodation_deleted' => [
            'title' => 'Azione Richiesta',
            'message' => 'È stato ridotto il numero di unità disponibili per l\'alloggio :accommodationName della struttura :propertyName, per evitare l\'overbooking è necessario effettuare un reset delle disponibilità.'
        ],
        'payment_timetable_exceeded' => [
            'title' => 'Addebito pagamento automatico fallito - Pagamento in eccesso rispetto al totale della prenotazione',
            'message' => 'Non è stato possibile effettuare l\'addebito relativo al pagamento automatico in oggetto perchè eccede la parzialità non pagata della prenotazione',
        ],
        'payment_timetable_require_action' => [
            'subject' => 'Addebito pagamento automatico fallito - Richiesto 3D secure',
            'message' => 'Addebito automatico non riuscito per richiesta 3D Secure (ID: :payment_timetable_id, del :scheduled_date - Prenotazione :reservation_reference_number a nome di :booker_name :booker_surname).',
        ],
        'payment_timetable_require_action_send_request' => [
            'subject' => 'Addebito pagamento automatico fallito - Richiesta inviata al cliente',
            'message' => "Addebito automatico non riuscito per richiesta 3D Secure (ID: :payment_timetable_id, del :scheduled_date - Prenotazione :reservation_reference_number a nome di :booker_name :booker_surname).\nÈ stata inviata al cliente richiesta di pagamento via mail.",
        ],
    ],

    'quote_request' => [
        'email' => [
            'subject' => 'Richiesta preventivo per :property_name - :customer_name :customer_surname (:arrival_date - :departure_date)',
            'quote_request_confermation' => 'Gentile <b>:property_name</b>,<br></br>
                <b>:customer_name :customer_surname</b> ha appena effettuato una richiesta di preventivo per la tua struttura.',
            'summary_request' => 'Riepilogo richiesta:',
            'stay' => 'Soggiorno',
            'name_surname' => 'Nome e Cognome',
            'telephone' => 'Telefono',
            'email' => 'Email',
            'from' => 'Arrivo',
            'to' => 'Partenza',
            'alternative_dates' => 'Disponibile a date alternative',
            'alternative_beds' => 'Disponibile a posti letto differenti',
            'yes' => 'Si',
            'no' => 'No',
            'accommodation' => 'Alloggio',
            'accommodations' => 'Alloggi',
            'night' => 'Notte',
            'nights' => 'Notti',
            'adults' => 'Adulti',
            'children' => 'Bambini',
            'eta_children' => 'Età bambini',
            'button' => 'Clicca qui per visualizzare la richiesta',
        ],
        'email_customer' => [
            'subject' => 'Grazie per la tua richiesta :customer_name!',
            'message' => 'Grazie <b>:customer_name</b>,<br></br>La tua richiesta di preventivo è stata correttamente inviata, sarà nostra cura contattarti nel minor tempo possibile.',
        ],
    ],

    'rateplans' => [
        'errors' => [
            'max_day_update' => 'Non è possibile eliminare questa tariffa poichè sono presenti canali connessi',
            'insert_periods_plan' => 'Non è possibile inserire periodi su un piano tariffario',
            'uneditable_rateplan' => 'Piano tariffario sorgente non modificabile',
            'source_not_found' => 'Sulla camera non è presente la tariffa sorgente',
            'detach_accommodations_channels' => 'Non è possibile eliminare questa tariffa poichè sono presenti canali connessi',
            'multi_property_not_permitted' => 'Non è possibile creare o modificare tariffe per più di una struttura alla volta',
            'rules_present_cannot_update' => 'Non è possibile applicare la modifica richiesta perché esistono regole attive associate a questo piano tariffario.',
        ],
        'warnings' => [
            'missing_set_rules' => 'Non è stato possibile per alcuni canali sorgente impostare le regole su piani tariffari iensistenti su canali destinazione',
        ],
        'conflicts' => [
            'unsuitable_conditions' => 'I valori per la condizione di :condition_from non è compatibile con quelli inseriti per la condizione di :condition_to',
            'conditions_not_formatted' => 'Condizioni non formattate correttamente, id mancante',
        ],
        'export_fields' => [
            'name' => 'Nome',
            'policy' => 'Politiche di rimborso',
            'periods' => 'Periodi e giorni di validità',
            'accommodations' => 'Alloggi',
        ],
    ],

    'rates' => [
        'errors' => [
            'max_day_update' => 'Non è possibile aggiornare un periodo complessivo superiore ad un anno',
            'no_rooms_to_clone' => 'Nessuna camera può essere clonata',
            'no_rooms_to_clone_source' => 'Una o più camere/tariffe non sono presenti nel canale sorgente',
            'no_rooms_to_clone_destination' => 'Una o più camere/tariffe non sono presenti nel canale destinatario',
            'same_channel_to_clone' => 'Non puoi clonare una canale su se stesso',
            'no_date_valid' => 'Nessuna data da aggiornare',
            'max_availability_exceeded' => 'Il valore di disponibilità inserito è superiore a quello consentito dalla configurazione dell\'alloggio. Il valore è stato adeguato con il massimo consentito',
            'anti_overbooking_bloccante' => 'Attenzione: il valore della disponibilità che stai provando ad inserire è superiore al numero di camere vendibili. Rischi l\'overbooking',
            'channel_update_error' => 'L\'aggiornamento verso il portale non è andato a buon fine, consulta la sezione <b>Log Aggiornamenti</b> per maggiori informazioni.',
            'period_over_limit' => 'Il periodo che va dal :dateFrom al :dateTo è oltre il limite massimo consentito',
        ],
        'warnings' => [
            'past_period' => 'Il periodo selezionato è passato',
            'past_today_adjustment' => 'La data di inizio è stata adeguata alla data di oggi',
            'period_adjustment_limit' => 'La data finale è stata adeguata al limite massimo consentito. (:dateTo)',
            'channel_not_connected' => 'La struttura non è connessa al canale :channel_name',
            'anti_overbooking' => 'Attenzione: il valore della disponibilità che stai provando ad inserire è superiore al numero di camere vendibili. Potresti rischiare l\'overbooking',
            'missing_association' => 'La camera non è associata al canale :channel_name ',
            'identical_update' => 'Un aggiornamento identico è ancora in corso, riprova più tardi.',
            'rate_copy_not_found' => 'Non ci sono dati da copiare per il periodo passato. Aggiornamento ignorato',
        ],
    ],

    'receipt_modules' => [
        'errors' => [
            'already_migrated' => 'Questa stampante fiscale è già stata migrata alla nuova gestione dei reparti',
        ],
        'log' => [
            'receipt_module_updated' => 'Stampante fiscale modificata',
            'receipt_module_created' => 'Stampante fiscale creata',
            'receipt_module_deleted' => 'Stampante fiscale eliminata',
            'receipt_module_department_deleted' => 'Reparto stampante fiscale eliminato',
            'receipt_module_department_created' => 'Reparto stampante fiscale creato',
            'receipt_module_department_updated' => 'Reparto stampante fiscale modificato',
        ],
        'validation' => [
            'ateco_slot_code' => [
                'wrong_format' => 'Formato codice ateco errato.',
                'wrong_slot' => 'Valore slot non supportato. (0 - 3).',
            ]
        ]
    ],

    'receipt_channels' => [
        'log' => [
            'receipt_channel_created' => 'Scontrino elettronico creato',
            'receipt_channel_deleted' => 'Scontrino elettronico eliminato',
        ]
    ],

    'reservation_accommodation_room_day' => [
        'errors' => [],
        'warnings' => [],
        'fields' => [
            'model_name' => 'giorno',
            'price' => 'prezzo giornaliero',
            'adults_number' => 'numero adulti',
            'children_number' => 'numero bambini',
        ],
    ],

    'reservation_addon' => [
        'fields' => [
            'related_id' => 'identificativo correlato',
            'related_type' => 'tipo correlato'
        ],
    ],

    'reservation_accommodation' => [
        'errors' => [],
        'warnings' => [],
        'fields' => [
            'price_total' => 'prezzo totale camera',
            'smoking' => 'fumatori',
            'accommodation_bed_type_combination_id' => 'Identificativo combinazione tipo di letto per alloggio'
        ],
    ],

    'reservation_cc' => [
        'errors' => [],
        'warnings' => [],
        'fields' => [
            'holder' => 'proprietario della carta di credito',
            'number' => 'numero della carta di credito',
            'expire_date' => 'scadenza carta di credito',
            'cvc' => 'codice cvc',
            'credit_card' => 'carta di credito',
            'current_balance' => 'saldo corrente',
            'type_id' => 'identificativo tipo',
            'activation_date' => 'data di attivazione',
            'vcc_expiration_date' => 'data di scadenza vcc',
            'is_virtual_card' => 'è una carta virtuale'
        ],
    ],

    'reservation_invoice' => [
        'export_fields' => [
            'reference_number' => 'ID Prenotazione',
            'reservation_id' => 'ID Prenotazione',
            'accommodations' => 'Alloggi',
            'room' => 'Numero',
            'period' => 'Soggiorno',
            'pax' => 'Ospiti',
            'type' => 'Tipo',
            'customer' => 'Intestatario',
            'payment_agreement' => 'Credit',
            'paid' => 'Pagato',
            'to_pay' => 'Da pagare',
            'accountholder' => 'Intestatario',
            'total' => 'Totale',
            'stay' => 'Soggiorno',
            'guests' => 'Ospiti',
            'credit' => 'Credito',
            'note' => 'Note',
            'notes' => 'Note',
            'status' => 'Stato',
            'booker' => 'Prenotante',
            'property_name' => 'Struttura',
            'open_charges' => 'Conti aperti',
        ],
        'errors' => [
            'invoice_opened_for_customer' => 'Il cliente ha dei conti aperti per questa prenotazione, finalizzare i conti prima di aprirne nuovi',
            'credit_note_on_opened' => 'Impossibile emettere nota di credito per fatture non registrate',
            'associate_in_to_credit_note' => 'Impossibile associare un incasso ad una nota di credito',
            'associate_out_to_invoice' => 'Impossibile associare un pagamento in uscita ad una fattura',
            'cant_update_due_invoice_no_show' => 'Impossibile modificare la prenotazione poichè ci sono fatture di no-show o di cancellazione',
            'keep_same_customer_on_credit_note' => 'Impossibile cambiare destinatario nota di credito collegata a fattura emessa',
            'impossibile_move_through_reservations' => 'Impossibile riversare addebito fuori dai conti aperti di questa prenotazione, su conti chiusi o note di credito',
            'cant_refund_pending_sdi_invoice' => 'Impossibile emettere nota di credito per fatture in attesa di validazione da parte dello SDI',
            'associate_payments_to_follows_invoice' => 'Impossibile associare pagamenti ad una ricevuta marcata come \'segue fattura\'',
        ],
    ],

    'reservation_note' => [
        'errors' => [],
        'warnings' => [],
        'fields' => [
            'reservation_internal' => 'appunti sulla prenotazione',
            'reservation_customer' => 'note cliente',
            'accommodation_customer' => 'richieste del cliente',
            'accommodation_checkin' => 'note checkin camera',
            'accommodation_checkout' => 'note checkout camera',
            'accommodation_housekeeper' => 'Note governante'
        ],
        'deposit' => [
            'wording' => 'Lasciata la somma di :amount con metodo di pagamento :payment_method dal cliente :customer',
            'card_info' => 'Registrati i dati di carta di tipo :card_type con numero :card_number, codice :card_code e scadenza :expire_date',
        ],
    ],

    'reservation_payment' => [
        'move_errors' => [
            'reservation_payment_is_not_payment' => 'Il pagamento effettuato in data :date intestato a :accountholder è un rimborso',
            'reservation_payment_rows_with_bills' => 'Il pagamento effettuato in data :date intestato a :accountholder ha degli addebiti associati',
            'reservation_payment_is_invoiced' => 'Il pagamento effettuato in data :date intestato a :accountholder è presente in documenti già emessi',
            'reservation_payment_with_different_invoice_layout' => 'Il pagamento effettuato in data :date intestato a :accountholder ha un profilo di fatturazione non presente nella struttura di destinazione',
        ],
        'pre_check_errors' => [
            'reservation_payment_is_not_payment' => 'Il pagamento è un rimborso',
            'reservation_payment_rows_with_bills' => 'Il pagamento ha degli addebiti associati',
            'reservation_payment_is_invoiced' => 'Il pagamento è presente in documenti già emessi',
        ],
    ],

    'reservation_quote' => [
        'export_fields' => [
            'reference_number' => 'Numero',
            'created_at' => 'Creato',
            'customer_full_name' => 'Cliente',
            'expire_date' => 'Scadenza',
            'status' => 'Stato',
            'expire_date_availability' => 'Scadenza Opzione',
            'email_read_at' => 'Letto il',
            'property' => 'Struttura',
            'option' => 'Proposta',
            'accommodations' => 'Alloggi',
            'stay' => 'Soggiorno',
            'guests' => 'Ospiti',
            'treatment' => 'Trattamento',
            'total' => 'Totale',
            'customer_email' => 'Indirizzo e-mail',
            'customer_telephone' => 'Telefono',
        ],

        'status' => [
            'active' => 'Abilitato',
            'revoked' => 'Rifiutato',
            'accepted' => 'Accettato',
            'expired' => 'Scaduto',
            'draft' => 'Bozza',
        ],

        'adults' => '{1} 1 Adulto|[2,*] :count Adulti',
        'children' => '{1} 1 Bambino|[2,*] :count Bambini',

        'errors' => [
            'no_email_found' => 'Non sono stati specificati indirizzi email alle quali inviare il preventivo. Specificare almeno un indirizzo.',
            'email_already_feedback_cannot_update' => 'Non è possibile modificare il preventivo perchè il cliente lo ha già visualizzato o ha già dato un riscontro',
            'no_customer_specified' => 'Il preventivo non è associato a nessun utente.',
            'quote_not_active' => 'Il preventivo non è attivo.',
            'quote_option_empty' => 'L\'opzione del preventivo non contiene camere, impossibile confermarlo',
            'quote_option_no_availability' => 'Gli alloggi che stai tentando di prenotare non sono più disponibili',
            'upload_attachment' => 'Errore nel caricamento file',
            'other_modified' => 'Questo preventivo non è più disponibile perchè è stato modificato da un altro utente',
            'no_valid_property' => 'Non puoi inserire un alloggio di una struttura diversa in questa opzione'
        ],
    ],

    'reservation' => [
        'reservation' => 'Prenotazione',
        'notes' => [
            'accommodation_internal' => 'note interne alloggio',
            'accommodation_checkout' => 'note checkout della camera',
            'accommodation_checkin' => 'note checkin della camera',
            'accommodation_bill' => 'note addebiti della camera',
            'accommodation_housekeeper' => 'note governante della camera',
            'accommodation_customer' => 'note ospite della camera',
        ],
        'details' => [
            'inserted' => 'Il costo del servizio :title è di :amount :currency',
        ],
        'export_fields' => [
            'id' => 'Id',
            'booked_at' => 'Data/ora prenotazione',
            'modified_at' => 'Data/ora ultima modifica',
            'channel_name' => 'Canale',
            'channel' => 'Canale',
            'booker' => 'prenotante',
            'booker_full_name' => 'Prenotante',
            'group_label' => 'Gruppo',
            'accommodations' => 'Alloggi',
            'rateplans' => 'Piani tariffari',
            'original_accommodations' => 'Alloggi originali',
            'property' => 'Struttura',
            'stay' => 'Soggiorno',
            'period' => 'Soggiorno',
            'tag' => 'Etichetta',
            'arrival_date' => 'Data inizio soggiorno',
            'departure_date' => 'Data partenza',
            'number_nights' => 'Num. notti',
            'total_price' => 'Importo',
            'property_name' => 'Struttura',
            'reservation_id' => 'ID Prenotazione',
            'room' => 'Stanza',
            'total' => 'Totale',
            'total_to_pay' => 'Totale da pagare',
            'status' => 'Stato',
            'note_customer' => 'Note del cliente',
            'internal_note' => 'Note interne',
            'group' => 'Gruppo',
            'reference_number' => 'numero di riferimento',
            'commission_amount' => 'Importo della commissione',
            'treatments' => 'Trattamenti',
            'booker_telephone' => 'Num. telefono prenotante',
            'booker_email' => 'Email prenotante',
            'company' => 'Azienda',
            'currency' => 'valuta',
            'nic' => 'C.F.',
            'extra' => 'Extra',
            'city_tax' => 'Tassa di soggiorno',
            'advance' => 'Deposito',
            'guests' => 'Ospiti',
            'xml_reservation_id' => 'ID prenotazione canale',
            'user' => 'Utente',
            'reservation_from_id' => 'Provenienza',
            'reservation_reason_id' => 'Motivazione',
            'escalate_report_to_booking' => 'Inoltrare segnalazione a Booking.com?',
            'allow_guest_to_book_again' => 'Permettere all\'ospite di prenotare di nuovo?',
        ],
        'activity' => [
            'new' => [
                'message' => 'Nuova prenotazione proveniente da :channel_name',
                'message_sclak_generated_key' => 'Generata la chiave su Sclak per la camera: :accommodation_name (:tableau_label)',
                'message_nuki_generated_key' => 'Generato il PIN per Nuki per la camera: :accommodation_name (:tableau_label)',
                'message_sclak_sms_sent' => 'È stato inviato l\'sms con i codici Sclak al numero :telephone_number',
                'message_sclak_deleted_key' => 'Eliminata chiave su Sclak per la camera: :accommodation_name (:tableau_label)',
                'message_nuki_deleted_key' => 'Eliminato il PIN per la camera: :accommodation_name (:tableau_label)',
                'invoice_printig_session' => 'Avviata stampa fiscale sulla stampante :printer_name (ID: :printer_id) relativa alla ricevuta con ID: :invoice_id',
                'added_payment' => 'Aggiunto il pagamento di :amount :currency (ID: :payment_id) con il metodo :payment_method',
                'added_refund' => 'Emesso il rimborso di :amount :currency (ID: :payment_id) con il metodo :payment_method',
            ],
            'update' => [
                'message' => 'Il campo :field_translate è stato cambiato da :old_value a :new_value',
                'message_novalue' => 'Il campo :field_translate è stato cambiato',
                'message_newvalue' => 'Inserimento :field_translate :new_value',
                'message_deletevalue' => 'Eliminazione :field_translate :old_value',
                'message_forobject' => 'Il campo :field_translate è stato cambiato da :old_value a :new_value per :model_type :model_name',
                'message_split_accommodation' => 'La camera prenotata :accommodation_source (riferimento tableau: :tableau_label_source) (dal :original_arrival_date al :original_departure_date) è stata divisa dal :split_arrival_date al :split_departure_date e spostata nella camera :accommodation_destination (riferimento tableau: :tableau_label_destination)',
                'message_move_accommodation' => 'La camera prenotata :accommodation_source (riferimento tableau: :tableau_label_source, Rateplan: :rateplan_name_source , Trattamento: :treatment_name_source, Prezzo: :price_source) è stata spostata nella camera :accommodation_destination (riferimento tableau: :tableau_label_destination, Rateplan: :rateplan_name_destination , Trattamento: :treatment_name_destination , Prezzo: :price_destination)',
                'message_resend_email_customer' => 'Email prenotazione nuovamente inviata al prenotante, indirizzo :new_value',
                'message_resend_email_company' => 'Email prenotazione nuovamente inviata all\'azienda, indirizzo :new_value',
                'message_resend_email_property' => 'Email prenotazione nuovamente inviata alla struttura, indirizzo :new_value',
                'message_resend_email_additional' => 'Email prenotazione nuovamente inviata all\'indirizzo aggiuntivo :new_value',
                'message_restored_sdi_rejected_invoice' => 'E\' stato riaperto il documento :invoice_number del :invoice_date con annesse le seguenti notifiche: :sdi_notify',
                'message_sdi_rejected_invoice' => 'E\' stato scartato il documento :invoice_number del :invoice_date emesso con profilo di fatturazione :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'message_sdi_rejected_invoice_with_advances' => 'E\' stato scartato il documento :invoice_number del :invoice_date emesso con profilo di fatturazione :invoice_layout (:invoice_business_name - :invoice_vat_code) con annessi i seguenti acconti: :advances',
                'message_sdi_rejected_invoice_as_receipt' => 'E\' stato emesso come ricevuta il documento scartato :invoice_number del :invoice_date con profilo di fatturazione :invoice_layout (:invoice_business_name - :invoice_vat_code) e intestata a :invoice_customer (Totale :invoice_total), con annesse le seguenti notifiche: :sdi_notify',
                'message_registered_invoice' => 'E\' stata registrata la :document_type :invoice_number :follows_invoice del :invoice_date emesso con profilo di fatturazione :invoice_layout (:invoice_business_name - :invoice_vat_code) e intestata a :invoice_customer (Totale :invoice_total) :manual_fp_register',
                'message_restored_invoice' => 'E\' stata annullata la :document_type :invoice_number del :invoice_date emesso con profilo di fatturazione :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'calculate_city_tax' => 'E\' stata calcolata la tassa di soggiorno per i seguenti ospiti: :guests',
                'no_guests_calculate_city_tax' => 'E\' stata calcolata la tassa di soggiorno ma non sono presenti ospiti idonei ai fini del calcolo',
                'add_extra' => 'Sono stati aggiunti gli addebiti: :extra',
                'delete_bill' => 'Sono stati eliminati gli addebiti: :extra',
                'transferred_bills' => 'E\' stato trasferito il :transfer_label degli addebiti: :bills_label',
                'transferred_bills_qty' => 'E\' stata trasferita la quantità :transfer_label degli addebiti: :bills_label',
                'transferred_bills_to_charges' => 'E\' stato trasferito il valore: :transfer_label degli addebiti: :bills_label verso conto passante :invoice_label (:invoice_id)',
                'transferred_bills_to_accommodation' => 'E\' stato trasferito il valore: :transfer_label degli addebiti: :bills_label verso camera :accommodation_label (:accommodation_id) - Prenotazione :reference_number',
                'transferred_bills_to_accommodation_multi_customer' => 'E\' stato trasferito il valore: :transfer_label degli addebiti: :bills_label verso camera :accommodation_label (:accommodation_id) - Prenotazione :reference_number ai clienti: :customers',
                'transferred_bills_qty_to_charges' => 'E\' stata trasferita la quantità :transfer_label degli addebiti: :bills_label verso conto passante :invoice_label (:invoice_id)',
                'transferred_bills_qty_to_accommodation' => 'E\' stata trasferita la quantità :transfer_label degli addebiti: :bills_label verso camera :accommodation_label (:accommodation_id) - Prenotazione :reference_number',
                'transferred_bills_qty_to_accommodation_multi_customer' => 'E\' stata trasferita la quantità :transfer_label degli addebiti: :bills_label verso camera :accommodation_label (:accommodation_id) - Prenotazione :reference_number ai clienti: :customers',
                'transferred_bills_to_accommodation_reservation_destination' => 'Sono stati trasferiti dal conto passante :invoice_origin (#:invoice_origin_id) i seguenti addebiti: :bills_label',
                'restored_bills' => 'Sono stati ripristinati gli addebiti: :bills_label',
                'message_deleted_credit_note' => 'E\' stato cancellato il documento :document_type :invoice_number del :invoice_date emesso con profilo di fatturazione :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'edit_payment' => 'È stato modificato il pagamento (ID: :payment_id) con il metodo :payment_method. Totale :amount :currency',
                'message_edit_guest' => 'È stato modificato l\'ospite :guest_name',
                'transferred_payment_to_reservation' => 'E\' stato trasferito il pagamento (#:paymentId) effettuato in data :date intestato a :accountholder della Prenotazione :reservationOrigin verso la Prenotazione :reservationDestination',
                'restored_payment_to_reservation' => 'E\' stato ripristinato il pagamento (#:paymentId) effettuato in data :date intestato a :accountholder dalla Prenotazione :reservationOrigin',
                'guest_checkin_checkout' => 'Sono state variate le date di arrivo o di partenza, in seguito a cambio date di soggiorno camera, per i seguenti ospiti:guests',
                'model_price_original' => 'Il campo :field_translate è stato cambiato da :old_value a :new_value. Il cliente ha scelto di mantenere il prezzo attuale.',
                'model_price_moved' => 'Il campo :field_translate è stato cambiato da :old_value a :new_value. Il cliente ha scelto il nuovo prezzo.',
            ],
            'delete' => [
                'delete_payment' => 'È stato rimosso un pagamento di :amount :currency (ID: :payment_id) con il metodo :payment_method'
            ],
            'view' => [
                'credit_card_fail' => 'E\' stato effettuato un tentativo di lettura della carta di credito. (:ip_address)',
                'credit_card_success' => 'Sono stati visualizzati i dati di carta di credito. (:ip_address)',
            ],
            'internal_note' => 'Nota interna: :note',
            'bill_note' => 'Appunti per l\'emissione conto: :note',
            'catering_note' => 'Nota pasti: :note',
            'customer_note' => 'Richieste del cliente: :note',
            'nuki' => [
                'create' => 'Dispositivo Nuki (:device_id): codice porta creato per la camera :tableau_label',
                'update' => 'Dispositivo Nuki (:device_id): modificate autorizzazioni codice per la camera :tableau_label',
                'delete' => 'Dispositivo Nuki (:device_id): codice porta eliminato per la camera :tableau_label',
            ],
        ],
        'wording' => [
            'advance_invoice' => 'Soggiorno dal :date_from al :date_to',
            'customer' => 'Cliente: ',
            'advance_count' => 'Acconto nr: ',
            'partial' => 'Parziale',
            'total' => 'Totale',
            'credit_note' => 'A storno della :type nr. :number del :invoice_date',
            'accommodation_bill_label' => 'Soggiorno',
            'city_tax_label' => ':cost a notte da :min_age a :max_age anni per un massimo di :limit_days gg',
            'city_tax_label_no_limit' => ':cost a notte da :min_age a :max_age anni senza limite di giorni',
        ],
        'fields' => [
            'model_name' => 'prenotazione',
            'arrival_date' => 'Data di arrivo',
            'departure_date' => 'Data di partenza',
            'total_price' => 'prezzo finale',
            'total_adults' => 'numero adulti',
            'overbooking' => 'overbooking',
            'label_name' => 'gruppo clienti',
            'reason' => 'motivo del viaggio',
            'total_children' => 'numero bambini',
            'split_reservation' => 'taglio prenotazione',
            'sclak_deleted_key' => 'Eliminata chiave su sclak',
            'sclak_generated_key' => 'Generata chiave su sclak',
            'sclak_sms_sent' => 'Inviato SMS codice Slack',
            'move_accommodation' => 'spostamento camera',
            'accommodation_bill' => 'Note conto',
            'status' => 'stato',
            'keep_availability' => 'non ripristinare',
            'expiration_date' => 'data di scadenza',
            'availability_option' => 'opzione disponibilità',
            'resend_email' => 'nuovo invio mail',
            'commission_amount' => 'importo commissione',
            'reservation_reason_id' => 'identificativo motivo della prenotazione',
            'reservation_from_id' => 'Provenienza',
            'reservation_bill' => 'conto della prenotazione',
            'reservation_checkin' => 'check-in della prenotazione',
            'reservation_checkout' => 'check-out della prenotazione',
            'partner_download' => 'download del partner',
            'commissionable_amount' => 'importo commissionabile',
            'is_group' => 'è un gruppo',
            'commission_discount_type_id' => 'identificativo del tipo di sconto per commissione',
            'commission_discount_value' => 'valore dello sconto sulla commissione',
            'added_credit_card_data' => 'aggiunti dati carta di credito',
        ],
        'payment_status' => [
            'paid' => 'Pagato',
            'to_be_invoiced' => 'Da fatturare',
            'to_pay' => 'Da pagare',
            'suspended' => 'Sospeso',
        ],
        'policy' => [
            'none' => 'Nessuna penale',
        ],
        'errors' => [
            'property_deleted' => 'Impossibile cancellare la prenotazione, contattare la struttura',
            'missing_main_room_guest' => 'Ospite principale non configurato per tutte le camere',
            'accommodation_not_found' => 'L\'alloggio è stato eliminato',
            'different_accommodation_checkout_date' => 'Le camere della prenotazioni hanno data di checkout differente',
            'different_accommodation_checkin_date' => 'Le camere della prenotazione hanno data di checkin differente',
            'transfer_on_same_customer_bill' => 'Impossibile suddividere allo stesso pagante',
            'no_guests_loaded' => 'Nessun ospite individuato per la camera',
            'not_mapped_accommodation' => 'La camera non è correttamente mappata',
            'not_switch_virtual' => 'Non puoi spostare la prenotazione su una camera virtuale di un\'altra struttura',
            'last_accommodation' => 'Non puoi eliminare l\'ultima camera rimasta',
            'not_tableau' => 'Camera Tableau non appartenente alla sistemazione',
            'impossible_change' => 'Impossibile operare questo passaggio di stato',
            'missing_roomreservation_id' => 'Nessuna camera trovata per la roomreservation inviata',
            'missing_order' => 'Ordine non trovato',
            'existing_bills_invoiced' => 'Esistono fatture e ricevute riferenti alla prenotazione. Impossibile procedere',
            'uneditable_field' => 'Campo non modificabile',
            'no_gateway_response' => 'Errore di connessione con il gateway di pagamento',
            'reservation_unpaid' => 'La transazione non è andata a buon fine',
            'missing_balance' => 'Mancanza di pagamento a saldo',
            'uneditable_fields_invoice' => 'I seguenti campi non possono essere modificati: ',
            'not_editable_total_due_paid' => 'Prezzo inserito minore del totale pagato',
            'not_editable_total_due_invoice' => 'Prezzo inserito minore del totale fatturato',
            'accommodation_room_guest_exists' => 'L\'ospite specificato esiste già nelle date specificate',
            'no_payment_amount_enough' => 'Il credito disponibile (:amount_available) non è sufficiente per coprire la cifra (:request_amount)',
            'payment_amoun_minor_of_amount_used' => 'L\'importo specificato (:request_amount) è minore di quello già utilizzato (:amount_used_global)',
            'cannot_delete_deposit_invoice' => 'Non è possibile cancellare un pagamento poichè già utilizzato in una fattura emessa',
            'accommodation_invoiced' => 'La camera è gia stata fatturata, non può essere eliminata',
            'resend_email_empty_address' => 'Non è stato specificato un indirizzo email su questo cliente',
            'householder_in_agreement' => 'Il capofamiglia rientra nella suddivisione conti, modificare la personalizzazione prima di procedere con questa modifica',
            'missing_company' => 'Riferimento azienda mancante per la prenotazione',
            'accommodation_bill_charged' => 'Addebito camera fatturato. Impossibile procedere',
            'all_billed' => 'Tutti gli addebiti risultano fiscalizzati o spostati. Impossibile rigenerare',
            'impossible_move_nature_bill' => 'Impossibile spostare su conto passante la natura dell\'addebito: ',
            'billed_accommodation' => 'Non è possibile cambiare le date di prenotazione perché sono stati emessi documenti fiscali.
            Inserisci una nuova prenotazione o aggiungi una camera a questa prenotazione con le nuove date.',
            'deposit_as_refund' => 'Una caparra non può essere configurata come rimborso',
            'refund_in_invoice' => 'Non puoi associare un rimborso a fatture o ricevute',
            'different_vat_codes' => 'Non puoi associare pagamenti o ricevute segue fattura a profili di fatturazione con partita iva diversa dal documento',
            'property_not_attached' => 'Non puoi associare pagamenti a strutture non coinvolte nella prenotazione',
            'too_many_payments' => 'L\'ammontare dei pagamenti esubera la spesa o il pagamento da rimborsare',
            'bill_and_expense' => 'Impossibile legare il pagamento ad un addebito e ad una spesa',
            'expense_minimum_payment' => 'La spesa deve avere almeno un pagamento, impossibile procedere',
            'amount_exceed_refunds' => 'Il pagamento da associare eccede la parte utilizzabile considerati i rimborsi',
            'missing_reservation' => 'Prenotazione non valida.',
            'already_cancelled' => 'La prenotazione è già cancellata.',
            'impossible_decrement_shared_bill' => 'Impossibile decrementare la quantità di un addebito suddiviso',
            'pax_fields_in_not_paxable_bill' => 'Non puoi inserire riferimenti ospiti per un addebito diverso dai servizi extra basati su ospiti',
            'company_email_address_is_empty' => 'Non è stato specificato un indirizzo email su questa azienda',
            'checkinonline_dati_mancanti' => 'Dati non inviati correttamente.',
            'checkinonline_reservation_not_found' => 'Prenotazione non trovata.',
            'checkinonline_reservation_is_cancelled' => 'La prenotazione è cancellata.',
            'checkinonline_reservation_is_not_confirmed' => 'La prenotazione non è confermata',
            'checkinonline_reservation_arrival_date_past' => 'La data di arrivo è antecedente ad oggi.',
            'checkinonline_reservation_departure_date_over' => 'La prenotazione è già conclusa.',
            'checkinonline_city_tax_cannot_pay' => 'Nessuna tassa di soggiorno da pagare.',
            'deposit_as_deposit' => 'Il pagamento è già una caparra, impossibile procedere',
            'deposit_as_advance' => 'Impossibile emettere documento di acconto su caparra confirmatoria',
            'document_on_funds' => 'Impossibile emettere documento su somma di fondocassa',
            'document_on_used_payment' => 'Impossibile emettere documento su pagamento utilizzato a saldo di altri documenti',
            'not_whole' => 'Impossibile emettere documento su pagamento associato',
            'document_on_refunded' => 'Impossibile emettere documento su pagamento rimborsato',
            'document_on_payments_out' => 'Impossibile emettere documento su pagamenti in uscita',
            'channel_checkin_missing_info' => 'Nessuna informazione sullo stato della richiesta',
            'channel_checkin_missing_status_already_present' => 'Lo status del checkin è già stato elaborato',
            'no_bills_on_customer' => 'Non esistono addebiti relativi al conventore della suddivisione conto',
            'discount_over_invoiced_value' => 'Differenza di prezzo da applicare superiore al valore da fatturare',
            'no_show_requested_total_major_bills_to_invoice' => 'Totale richiesto come no show superiore al valore da fatturare',
            'checkin_major_checkout' => 'Data di checkin maggiore o coincidente con la data di checkout per la camera :accommodation_name, impossible procedere',
            'checkout_major_checkin' => 'Data di checkout maggiore o coincidente con la data di checkin per la camera :accommodation_name, impossible procedere',
            'missing_addon' => 'Servizio extra con campi mancanti, impossibile proseguire',
            'missing_customer_on_split_bills_same_reservation' => 'Impossibile suddividere addebiti nella stessa prenotazione senza indicare paganti specifici',
            'have_door_service_active' => 'Impossibile aggiungere manualmente una chiave relativa all\'apertura di una porta poichè è attivo il servizio esterno :external_service_name',
            'conflict_system_custom_email_template' => 'É stato specificato più di un template da inviare, specificarne solo uno.',
            'guest_already_present_in_same_dates' => 'Impossibile proseguire: ospite già presente nelle stesse date',
            'can_not_move_reservation_payments' => 'Impossbile trasferire i pagamenti per i seguenti errori: :errors',
            'can_not_modify_ota_checkin_checkout' => 'Non è possibile cambiare le date di una prenotazione proveniente da un canale.',
            'unsuitable_dates_for_guests' => 'Date di soggiorno incompatibili per gli ospiti: :guests',
            'unsuitable_dates_for_guests_one_day' => 'Date di soggiorno multiple per gli ospiti: :guests per un solo pernottamento, eliminare uno dei soggiorni prima di procedere',
            'credit_card_view_locked' => 'Questa carta non è più visualizzabile: limite massimo raggiunto.',
        ],
        'warnings' => [
            'not_mapped_addons' => 'Il servizio desiderato non risulta associato alla camera: ',
            'bill_splitted' => 'Addebito distribuito su più conti non modificabile: ',
            'bill_children' => 'Addebito parziale derivato non modificabile: ',
            'all_bills_closed' => 'Tutti i conti chiusi per questa prenotazione',
            'deposit_cut' => 'Effettuato uno storno dal pagamento dell\'addebito: ',
            'not_existing_bill' => 'Addebito non esistente',
            'exceeding_num_adults' => 'Numero adulti eccedente rispetto al massimo impostato per la camera',
            'exceeding_num_children' => 'Numero bambini eccedente rispetto al massimo impostato per la camera',
            'existing_payments_pending' => 'Esistono pagamenti pendenti su addebiti della camera, vuoi comunque procedere?',
            'existing_invoices_joined' => 'Esistono documenti legati all\'addebito :bill_name, impossibile trasferire in alloggi di altre prenotazioni o conti passanti',
            'customer_invoiced' => 'Esistono fatture emesse per il cliente :customer impossibile da cancellare',
            'is_previous' => 'Prenotazione antecedente all\'allaccio del channel',
            'bill_cant_split' => 'Addebito non splittabile in questa tipologia ',
            'bill_charged' => 'Uno o più addebiti sono fatturati, impossibile effettuare la modifica.',
            'bill_qty_incoerence' => "Quantità non coerente con il numero di ospiti associato all\'addebito",
            'no_guests' => 'Nessun ospite presente in questa prenotazione',
            'move_other_property_notify' => 'Scegliere una struttura dalla quale fare partire le notifiche',
            'bill_deposit_not_allowed' => 'Pagamento non associabile alla tipologia di addebito',
            'bill_discount_unsuitable_to_row' => 'Lo sconto ricalcolato è incompatibile con la parte di addebito fatturata',
            'bill_rows_discount_deleting' => 'Il trasferimento ha causato il reset dello sconto relativo all\' addebito sorgente presente su conto aperto',
            'existing_bills_night' => 'I servizi extra delle notti non incluse nel soggiorno verranno eliminati',
            'bills_not_found' => 'Addebiti non trovati',
            'change_status_in_progress' => 'La prenotazione sta già effettuando un cambio di status.',
            'reservation_accommodation_door_key_code_reservation_resumed' => 'È necessario generare una nuova chiave, quella precedente è stata disabilitata in seguito al cambio di stato della prenotazione. ',
            'reservation_accommodation_door_key_code_exist' => 'Sono presenti codici di apertura porte. Procedere manualmente alla rigenerazione o alla revoca.',
            'reservation_accommodation_door_key_code_exist_moved_accommodation' => 'Uno o più alloggi sono stati spostati. È necessario generare una nuova chiave.',
            'reservation_accommodation_door_key_code_delete' => 'Si è verificato un errore durante la cancellazione delle chiavi. Riprovare manualmente',
            'reservation_accommodation_door_key_code_generate' => 'Si è verificato un errore durante la generazione delle chiavi. Riprovare manualmente',
            'existing_transferred_bills' => 'Sono presenti addebiti provenienti da altre camere, è necessario ripristinarli o riassegnarli prima di procedere',
            'bill_has_payment' => 'Esistono pagamenti legati all\'addebito :bill_name, impossibile trasferire in camere o documenti esterni',
        ],
        'channels' => [
            'no_report_invalid_cc' => 'Report carta di credito non valida non richiesto per questo canale',
            'no_report_noshow' => 'Report no show non richiesto per questo canale',
            'no_report_cancellation_due_invalid' => 'Report cancellation non richiesto per questo canale',
            'payment_to_ota' => 'Pagamento effettuato al portale :channel_name',
            'no_previous' => 'Il canale non supporta lo scarico di prenotazioni antecedenti',
            'email' => [
                'without_room_title' => 'Nuova prenotazione senza camera da :channel_name (ID: :reference_number) - Struttura: :property_name',
                'without_rate_title' => 'Nuova prenotazione senza tariffa da :channel_name (ID: :reference_number) - Struttura: :property_name',
            ],
            'change_stay_synch_error' => 'Errore di sincronizzazione per il cambio date del soggiorno',
            'change_stay_synch_success' => 'Sincronizzazione per il cambio date del soggiorno inviata, attendi la ricezione della modifica da parte del portale',
            'change_stay_synch_not_enabled' => 'Funzione non abilitata per questo portale',
            'error_booking_get_data_for_report_misconduct' => 'Errore nel recupero dei dati per l\'invio della segnalazione di cattiva condotta per Booking.com',
            'error_booking_report_misconduct' => 'Errore nell\'invio della segnalazione di cattiva condotta per Booking.com',

        ],
        'bills' => [
            'reservation_bill_id_not_found' => 'L\'ID :reservation_bill_id non appartiene alla prenotazione specificata',
            'reservation_bill_id_already_override' => 'L\'ID :reservation_bill_id risulta già essere sovrascritto',
            'reservation_bill_id_no_updates' => 'Tutti gli elementi appartengono già ad una sovrascrittura oppure non appartengono alla prenotazione specificata',
            'delete_bill_accounted' => 'Impossibile eliminare perchè uno o più elementi sono stati già contabilizzati',
            'delete_sheet_bill_emitted' => 'Impossibile eliminare il conto perchè è stata già emessa fattura',
            'different_vat_quotes_in_merge' => 'Impossibile sovrascrivere addebiti con IVA differente',
            'cant_editable_due_moved' => 'Addebito spostato: prevista solo modifica dello sconto',
        ],
        'invoice' => [
            'invoice_already_registered' => 'La Fattura è stata già emessa',
            'no_invoice_layout' => 'Non è presente nessun layout di fatturazione. Impossibile continuare',
            'no_an_invoice' => 'Non è una fattura',
            'no_company_id' => 'Non è stata specificata un\'azienda a cui effettuare la fattura',
            'unsuitable_payments' => 'I pagamenti associati non sono compatibili con la partita iva collegata al conto',
            'too_many_advances' => 'Il valore degli acconti versati supera il totale addebiti',
            'advances_in_advance' => 'Impossibile accludere acconti in una fattura di acconto',
            'payments_major_total_invoice' => 'Il totale dei pagamenti supera il totale della fattura',
        ],
        'pdf' => [
            'reservation' => [
                'filters' => [
                    'in_house' => 'In fermata',
                    'arrival_date' => 'In arrivo',
                    'departure_date' => 'In partenza',
                ],
                'booker' => [
                    'origin' => 'Canale di riferimento',
                    'name' => 'Nome dell\'ospite',
                    'telephone' => 'Tel',
                    'email' => 'E-Mail',
                    'pec' => 'PEC',
                    'language' => 'Lingua',
                    'reference_number' => 'Numero prenotazione',
                    'booked_at' => 'Data prenotazione',
                    'commissionable_amount' => 'Importo soggetto a commissione',
                    'commission_amount' => 'Commissione',
                    'other_infos' => 'Informazioni importanti su questo ospite',
                    'notes' => [
                        'note_internal' => 'Note interne',
                        'note_customer' => 'Note del cliente',
                        'note_bill' => 'Note di pagamento',
                        'note_checkin' => 'Note di checkin',
                        'note_checkout' => 'Note di checkout',
                    ],
                ],
                'accommodation' => [
                    // 'room_number' => '', NO!!!!
                    'from_date' => 'Arrivo',
                    'to_date' => 'Partenza',
                    'duration' => 'Durata del soggiorno',
                    'duration_text' => '{1} :length notte|[2,*] :length notti',
                    // ':length notti',
                    'total_guests' => 'Totale ospiti',
                    'guests_adults_text' => ':quantity adulti',
                    'guests_children_text' => ':quantity bambini',
                    'total_accommodations' => 'Numero totale di camere',
                ],
                'reservation' => [
                    'name' => 'Nome dell\'ospite',
                    'total_guests' => 'Numero di ospiti',
                    'guests_adults_text' => ':quantity adulti',
                    'guests_children_text' => ':quantity bambini',
                    'max_capacity' => 'Occupazione massima',
                    'capacity_text' => ':quantity ospiti',
                    'meals' => 'Pasti',
                    'meals_breakfast_included' => 'La colazione è inclusa nella tariffa della camera',
                    'table' => [
                        'date' => 'Data',
                        'price' => 'Prezzo',
                        'price_per_day' => 'Prezzo a notte',
                        'non_refundable_rate' => 'Non refundable rate',
                        // !?! TODO:
                        'subtotal' => 'Subtotale',
                        'city_tax' => 'Tassa di soggiorno',
                        'city_tax_detail' => 'Importo a persona per notte',
                        'total_accommodation_price' => 'Prezzo complessivo dell\'alloggio',
                        'vat_included' => 'La tariffa include :amount di IVA',
                        'vat_not_included' => 'Tariffa Iva esclusa',
                    ],
                ],
                'statuses' => [
                    'cancelled' => 'Cancellate',
                    'optionable' => 'Opzionabili',
                    'hidden' => 'Nascoste',
                    'pending' => 'In attesa di pagamento',
                    'confirmed' => 'Confermate',
                ],
                'totals' => [
                    'statuses' => [
                        'Cancelled' => 'Cancellata',
                        'Optionable' => 'Opzionabile',
                        'Hidden' => 'Nascosta',
                        'Pending' => 'In attesa di pagamento',
                        'Confirmed' => 'Confermata',
                        'Expired' => 'Scaduta',
                    ],
                    'status' => 'Stato prenotazione',
                    'total_amount' => 'Importo totale',
                    'paid_deposit' => 'Caparra pagata',
                    'total_paid' => 'Pagato',
                    'total_to_be_paid' => 'Da saldare',
                ],
                'payments' => [
                    'table' => [
                        'date' => 'Data registrazione',
                        'method' => 'Modalità di pagamento',
                        'amount' => 'Importo',
                        'notes' => 'Note',
                    ],
                ],
            ],
            'bills' => [
                'accommodations' => 'Sistemazioni',
                'accommodation' => 'Sistemazione',
                'total' => 'Totale',
                'date' => 'Data',
                'room' => 'Camera',
                'treatment' => 'Trattamento',
                'amount_per_night' => 'Importo per notte',
                'addons_categories' => 'Servizi aggiuntivi',
                'addon_category' => 'Tipologia',
                'addon_name' => 'Servizio',
                'addon_price_type' => 'Tipo Tariffa',
                'amount' => 'Importo',
                'taxes' => 'Tasse',
                'tax_name' => 'Tipologia',
                'accommodations_title' => 'Dettaglio Sistemazioni',
                'addons_categories_title' => 'Dettaglio Servizi aggiuntivi',
                'taxes_title' => 'Dettaglio Tasse',
            ],
            'guests' => [
                'guests_list' => 'Elenco ospiti registrati per la prenotazione',
                'reservation_of_date' => 'del',
                'duration_text' => ':length notti',
                'from' => 'Dal',
                'to' => 'Al',
                'table' => [
                    'type' => 'Tipologia',
                    'name' => 'Nome',
                    'surname' => 'Cognome',
                    'birthday_date' => 'Data nascita',
                    'gender' => 'Sesso',
                    'birth_place' => 'Luogo nascita',
                    'checked_in' => 'Check in effettuato',
                    'none' => 'Nessun ospite registrato',
                ],
            ],
            'payment' => [
                'payments_short_title' => 'Dettaglio pagamenti',
                'payments_title' => 'Pagamenti e documenti',
                'report_title' => 'Nota di pagamento',
                'deposit_title' => 'Caparra confirmatoria',
                'refund_title' => 'Nota di rimborso',
                'issuer' => 'Intestatario del Pagamento',
                'registration_date' => 'Data registrazione pagamento',
                'payment' => 'Pagamento',
                'payment_date' => 'Data pagamento',
                'method' => 'Metodo di pagamento',
                'amount' => 'Importo',
                'pos' => 'POS',
                'deposit_number' => 'Numero caparra',
                'payments_received' => 'Pagamenti ricevuti',
                'notes' => 'Note',
                'deposit' => 'Caparra',
                'to_pay' => 'Importo da pagare',
                'excess_payment' => 'Totale importo in eccesso',
                'invoiced' => 'Importo fatturato',
                'to_be_invoiced' => 'Importo da fatturare',
                'total_to_be_invoiced' => 'Totale importo da fatturare',
                'document_type' => 'Tipo documento',
                'document_number' => 'Numero',
                'document_date' => 'Data emissione',
                'invoice_issuer' => 'Intestatario',
                'invoice_paid' => 'Pagato',
                'invoice_to_pay' => 'Da pagare',
            ],
            'fees' => [
                'fees_title' => 'Corrispettivi',
                'document_type' => 'Tipo',
                'total' => 'Totale',
                '22' => 'IVA 22%',
                '10' => 'IVA 10%',
                'customer' => 'Cliente o azienda',
            ],
            'deposits' => [
                'deposits_title' => 'Acconti e caparre',
                'export_fields' => [
                    'property' => 'Struttura',
                    'number' => 'Numero',
                    'date' => 'Data',
                    'total' => 'Totale',
                    'amount_available' => 'Importo disponibile',
                    'used' => 'Utilizzato',
                    'reservation_id' => 'Id prenotazione',
                    'pos' => 'Pos',
                    'type_payment' => 'Tipo di pagamento',
                    'type_reservation' => 'Tipo di prenotazione',
                    'description' => 'Descrizione',
                    'user_pay' => 'Pagante',
                    'reservation' => 'Prenotazioni',
                    'payment_method' => 'Metodo di pagamento',
                    'stay' => 'Soggiorno',
                    'departure_date' => 'Data di partenza',
                ],
            ],
        ],

        'of_date' => 'del :date',
        'arrival_date' => 'Arrivo',
        'departure_date' => 'Partenza',
        'nights' => 'Notti',
        'accommodations' => 'Camere',
        'policy_description' => 'Riepilogo delle condizioni',
        'policy_deposit_description' => 'Riepilogo del pagamento',
        'payments_timetable' => [
            'title' => 'Condizioni di pagamento',
            'subtitle' => 'Di seguito le date in cui verranno effettuati gli addebiti per il soggiorno',
            'statuses' => [
                'scheduled' => 'Pianificato',
                'processed' => 'Processato',
                'failed' => 'Fallito',
                'paused' => 'In pausa',
                'cancelled' => 'Cancellato',
                'wait_customer' => 'In attesa del cliente',
                'partial_processed' => 'Parzialmente processato',
            ],
            'city_tax' => [
                'checkin_online' => 'La tassa di soggiorno di :amount è esclusa e verrà addebitata automaticamente dopo la compilazione del check-in online. In caso di mancata compilazione del check-in online verrà addebitata direttamente in struttura.',
                'checkout' => 'L\importo di :amount è una stima e potrebbe variare in presenza di esenzioni o di modifiche al numero di ospiti o notti soggiornate.'
            ],
        ],
        'log' => [
            'city_tax_log_title' => 'Tassa di soggiorno',
            'extra_log_title' => 'Servizi Extra',
            'bill_title' => 'Addebiti',
            'notes' => 'Sezione Note',
            'guest' => 'Ospite',
            'payment' => 'Pagamento',
        ],
        'errors_reason' => [
            'update_system' => 'Non puoi modificare una reason di sistema',
            'delete_system' => 'Non puoi eliminare una reason di sistema',
            'not_exist' => 'Reason non trovata',
        ],
        'customer_profile_deleted' => 'L\'anagrafica di questo ospite è stata eliminata e non può essere modificata. Vuoi riattivarla per procedere con la modifica?',
    ],

    'rhino' => [
        'exceptions' => [
            'request_not_valid' => 'Campi mancanti ',
            'method_not_found' => 'Il metodo chiamato non esiste'
        ],
        'vat_code_already_exists' => 'Questa partita IVA è già presente nel sistema. Assicurati di inserire una partita IVA unica che non sia già stata registrata.',
    ],

    'roles' => [
        'user' => [
            // TODO:
        ],

        'property' => [
            'master' => 'Direzione',
            'operator' => 'Operatore',
            'housekeeper' => 'Governante',
        ],
        'errors' => [
            'access_denied_property' => 'Ruolo errato: l\'utente non ha i permessi da direttore per accedere alla struttura.'
        ]
    ],

    'sca' => [
        'pdf' => [
            'filename' => 'Autorizzazione per Carte di credito',

            'card_holder' => 'Nome titolare',
            'card_type' => 'Tipo di carta',
            'card_number' => 'Numero carta',
            'card_expiration' => 'Data di scadenza',
            'card_cvc' => 'CVC',
            'parts' => [
                'p1' => 'Autorizzazione per carte di credito',
                'p2' => 'Attenzione – I campi contrassegnati con asterisco sono obbligatori',
                'p3' => 'Si richiede gentilmente di fornire tutte le informazioni per procedere alla conferma della vostra prenotazione.',
                'p4' => 'Inviare il modulo compilato insieme ad ogni documento necessario a: <span class="link">:email</span>',
                'p5' => 'Informazioni del possessore della carta:',
                'p6' => 'Si certifica che le informazioni fornite sono esatte e veritiere.',
                'p7' => 'Con la presente autorizzo l’addebito dell’importo indicato sulla seguente carta di credito/debito',
                'p8' => '<span class="bold">Per tariffe non rimborsabili</span>, la carta di credito in elenco sarà subito addebitata per l’importo richiesto.',
                'p9' => '<span class="bold">Per tariffe flessibili</span>, la carta di credito in elenco potrà essere sottoposta a controllo di validità previa preautorizzazione per l’importo come previsto dalla policy.',
                'p10' => 'Firma possessore carta',
                'p11' => 'Numero prenotazione',
                'p12' => 'Data arrivo',
                'p13' => 'Insieme a questo documento è richiesto l’invio fronte/retro della carta di credito/debito utilizzata per il pagamento insieme ad una copia della Carta d’Identità/Passaporto dell’intestatario. Accertarsi che i documenti richiesti siano subito inviati a: <span class="link">:email</span>',
                'p14' => 'Non ricevendo i documenti richiesti, la prenotazione sarà considerata nulla e di conseguenza cancellata.Tutte le informazioni saranno considerate confidenziali e utilizzate solo ai fini sopra menzionati.',
                'p15' => ':name – :address, :zip_code – :city_name <span class="link">:email</span> - <span class="link">:website</span>',
            ],
        ],

        'email' => [
            'subject' => ':property - Richiesta autorizzazione',
            'subject_accepted' => 'Autorizzazione SCA/3DS è stata confermata',
            'subject_reservation' => ':name :surname, conferma la tua prenotazione',
            'dear_customer_reservation' => 'Gentile :name :surname, <br /> per garantire la sua prenotazione la invitiamo ad autorizzare l\'utilizzo della sua carta di credito in base alle condizioni di prenotazione e cancellazione.<br><br>Grazie per la collaborazione.',
            'dear_customer_payment' => 'Gentile :name :surname, <br /> per garantire la sua prenotazione la invitiamo ad autorizzare l\'utilizzo della sua carta di credito in base alle condizioni di prenotazione e cancellazione.<br><br>Grazie per la collaborazione.',
            'your_reservation_for' => 'La tua prenotazione per :name',
            'you_payment_for' => 'Il tuo pagamento per :name',
            'we_are_waiting_for_you_on_date' => 'Ti aspettiamo il :date',
            'reservation_summary' => 'Riepilogo prenotazione',
            'payment_summary' => 'Riepilogo pagamento',
            'reservation_total' => 'Totale prenotazione',
            'payment_total' => 'Totale pagamento',
            'authorize_card_use' => 'Autorizza utilizzo carta',
            'payment_click_here_link' => 'Clicca qui per confermare pagamento',
            'non_beddy_payment_click_here_link' => 'Per confermare la prenotazione vai al seguente link: :link',
            'non_beddy_reservation_click_here_link' => 'Per confermare il pagamento vai al seguente link: :link',
            'date' => 'Data',
            'reservation_confirmation' => 'Conferma prenotazione numero :referenceNumber',
            'payment_confirmation' => 'Conferma pagamento',
            'sca_reservation_accepted' => 'La informiamo che la sua richiesta di conferma del modulo SCA/PSD2 per la prenotazione #:referenceNumber è stata accettata dal cliente.',
            'sca_payment_accepted' => 'La informiamo che la sua richiesta di conferma del modulo SCA/PSD2 per la prenotazione #:referenceNumber è stata accettata dal cliente.',
        ],
        'confirmation_request_expired' => 'Richiesta già scaduta',
        'whatsapp' => [
            'message' => 'Gentile :name :surname, per confermare la prenotazione # :referenceNumber (:arrivalDate - :departureDate) abbiamo bisogno della tua autorizzazione all\'utilizzo della carta di credito. Clicca qui :link',
        ],
    ],

    'social_archive' => [
        'export_fields' => [
            'property_name' => 'Struttura',
            'unlock_email' => 'Email',
            'unlock_date' => 'Data iscrizione'
        ],
    ],

    'statistics' => [
        'partitioning_translations' => [
            'yearly' => 'ad un anno|a :value anni',
            'monthly' => 'ad un anno|a :value anni',
            'daily' => 'ad un anno|a :value anni',
        ],
        'warnings' => [
            'limit_truncation' => 'Visualizzazione richiesta per un periodo troppo ampio. L\'intervallo di ricerca è stato limitato :partitioning_translation.',
            'previous_offset_available_only_with_daily_partitioning' => 'Tipo di confronto disponibile soltanto in visualizzazione giornaliera. Verrà confrontato il periodo scelto con l\'anno precedente',
        ],
        'exceptions' => [
            'invalid_split' => 'Operazione non disponibile',
            'not_available' => 'Funzionalità momentaneamente non disponibile',
            'cannot_create_groupable' => 'Parametri non validi per il raggruppamento',
            'invalid_date_range' => 'Date inviate non valide',
        ],
        'legend' => [
            'no_model' => 'Non specificato',
            'deleted_rateplans' => 'Tariffe eliminate',
            'no_treatment' => 'Trattamento Non specificato',
            'charges' => 'Extra Manuali',
            'no_label' => 'Senza nome',
            'stay' => 'Soggiorni',
            'tax' => 'Tasse',
            'ob' => 'Overbooking',
            'virtual_stamp' => 'Bollo Virtuale',
            'city_tax' => 'Tassa di soggiorno',
            'no_show' => 'No Show',
            'cancellation' => 'Cancellazione oltre i termini',
            'no_show_stay' => 'Soggiorno in No Show',
            'cancellation_stay' => 'Soggiorno in Cancellazione oltre i termini',
            'no_show_extra' => 'Servizio Extra in No Show',
            'cancellation_extra' => 'Servizio Extra in Cancellazione oltre i termini',
            'penalty' => 'Penali',
            'general_invoices' => 'Conti Passanti',
            'manual' => 'Addebiti Manuali',
            'payment' => 'Acconti',
            'beddy_channel_labels' => [
                '' => 'Beddy',
                'quote' => 'Beddy (Preventivi)',
                'website' => 'Beddy (Sito Web)',
                'manual' => 'Beddy (PMS)',
                'general' => 'Beddy (Conti Passanti)',
                'google-hotel' => 'Google Hotel',
                'trivago-fast-connect' => 'Trivago',
                'trivago-express-booking' => 'Trivago Express Booking',
                'bookingbooster' => 'Booking Booster',
            ],
        ],
        'label' => 'Data',
        'label_date' => 'Riferimento data',
        'label_channel' => 'Segmento canale',
        'label_accommodation' => 'Segmento camera',
        'label_room' => 'Segmento numero tableau',
        'label_booker_category' => 'Segmento categoria cliente',
        'label_rateplan' => 'Segmento piano tariffario',
        'label_reservation_from' => 'Segmento provenienza prenotazione',
        'label_nationality' => 'Segmento nazionalità',
        'label_property' => 'Segmento struttura',
        'label_dealer_company' => 'Segmento azienda',
        'label_dealer_agency' => 'Segmento agenzia',
        'label_dealer_tour_operator' => 'Segmento tour operator',
        'label_production_type' => 'Segmento Reparto',
        'production_over_time' => 'Vendita per periodo',
        'revenue' => 'Vendita',
        'production' => 'Produzione per periodo',
        'available_nights' => 'Notti disponibili',
        'unsold_nights' => 'Notti invendute',
        'penalty_nights' => 'Notti in penale',
        'arrivals' => 'Arrivi',
        'departures' => 'Partenze',
        'average_stay_length' => 'Soggiorno medio',
        'average_guest_earning' => 'Ricavo medio ospite',
        'sold_nights' => 'Notti vendute',
        'occupation_percentage' => 'Occupazione',
        'total_price' => 'Vendita',
        'adr' => 'ADR',
        'revpar' => 'Revpar',
        'counted_reservations' => 'Totale prenotazioni',
        'confirmed_reservations' => 'Prenotazioni confermate',
        'cancelled_reservations' => 'Prenotazioni cancellate',
        'cancellation_ratio' => 'Tasso di cancellazione',
        'counted_average_booking_window' => 'counted_average_booking_window',
        'confirmed_average_booking_window' => 'GG anticipo prenotazione',
        'cancelled_average_booking_window' => 'GG anticipo cancellazione',
        'rooms_checkin' => 'Camere in arrivo',
        'rooms_checkout' => 'Camere in partenza',
        'label_department' => 'Reparto',
        'label_service' => 'Servizio',
        'gross_amount' => 'Importo lordo',
        'share_percent' => 'Incidenza (%)',
        'taxes' => 'Iva',
        'net_amount' => 'Netto iva',
        'quantity' => 'Quantità',
        'net_revenue' => 'Ricavo Netto',
        'commissions_amount' => 'Commissione',
        'in_stay_rooms' => 'Camere in fermata',
        'presence_rooms' => 'Presenza camere',
        'in_stay_guests' => 'Fermate',
        'presence_guests' => 'Presenze',
        'absolute_guests' => 'Ospiti',
        'gross_amount_without_commissions' => 'Netto commissioni',
        'net_amount_without_commissions' => 'Netto commissioni e iva',
        'gt_revenue' => [
            'rooms' => [
                'date' => 'DATE',
                'hotel_capacity' => 'HOTEL_CAPACITY',
                'rooms_sold' => 'ROOMS_SOLD',
                'rooms_ooo' => 'ROOMS_OOO',
                'rooms_revenue' => 'ROOMS_REVENUE'
            ],
            'segments' => [
                'date' => 'DATE',
                'cam_business' => 'CAM_BUSINESS',
                'rev_business' => 'REV_BUSINESS',
                'cam_tour_operator' => 'CAM_TOUR_OPERATOR',
                'rev_tour_operator' => 'REV_TOUR_OPERATOR',
                'cam_ota' => 'CAM_OTA',
                'rev_ota' => 'REV_OTA',
                'cam_beddy' => 'CAM_BEDDY',
                'rev_beddy' => 'REV_BEDDY',
                'cam_diretta' => 'CAM_DIRETTA',
                'rev_diretta' => 'REV_DIRETTA'
            ]
        ]
    ],

    'stripe' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Errore generale sconosciuto.',
                'next_steps' => 'Contattare il supporto tecnico.',
            ],
            'approve_with_id' => [
                'description' => 'Il pagamento non può essere autorizzato.',
                'next_steps' => 'Il pagamento dovrebbe essere tentato di nuovo. Se non può ancora essere elaborato, il cliente deve contattare l\'emittente della carta.',
            ],
            'customer_max_payment_methods' => [
                'description' => 'Il cliente ha già il numero massimo di metodi di pagamento collegati.',
                'next_steps' => 'Scollegare alcuni metodi di pagamento da questo cliente o procedere con un cliente diverso.',
            ],
            'call_issuer' => [
                'description' => 'La carta è stata rifiutata per una ragione sconosciuta.',
                'next_steps' => 'Il cliente deve contattare l\'emittente della carta per maggiori informazioni.',
            ],
            'card_not_supported' => [
                'description' => 'La carta non supporta questo tipo di acquisto.',
                'next_steps' => 'Il cliente deve provare con un metodo di pagamento diverso.',
            ],
            'card_velocity_exceeded' => [
                'description' => 'Il cliente ha superato il limite di spesa sulla carta.',
                'next_steps' => 'Il cliente deve provare ad attendere un certo tempo prima di ritentare, oppure utilizzare una carta diversa.',
            ],
            'currency_not_supported' => [
                'description' => 'La carta non supporta la valuta specificata.',
                'next_steps' => 'Il cliente deve utilizzare una carta diversa che supporti questa valuta.',
            ],
            'do_not_honor' => [
                'description' => 'La carta è stata rifiutata.',
                'next_steps' => 'Il cliente deve contattare l\'emittente della carta per maggiori informazioni.',
            ],
            'do_not_try_again' => [
                'description' => 'La carta è stata rifiutata.',
                'next_steps' => 'Non riprovare il pagamento. Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'duplicate_transaction' => [
                'description' => 'Una transazione con lo stesso importo e dati è stata recentemente inviata.',
                'next_steps' => 'Il cliente deve attendere e riprovare più tardi.',
            ],
            'expired_card' => [
                'description' => 'La carta è scaduta.',
                'next_steps' => 'Il cliente deve utilizzare una carta diversa.',
            ],
            'fraudulent' => [
                'description' => 'La transazione è stata rifiutata perché sospetta di essere fraudolenta.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'generic_decline' => [
                'description' => 'La carta è stata rifiutata.',
                'next_steps' => 'Il cliente deve contattare l\'emittente della carta per maggiori informazioni.',
            ],
            'incorrect_number' => [
                'description' => 'Il numero di carta inserito non è corretto.',
                'next_steps' => 'Il cliente deve verificare il numero della carta o utilizzare una carta diversa.',
            ],
            'incorrect_cvc' => [
                'description' => 'Il codice di sicurezza della carta (CVC) non è corretto.',
                'next_steps' => 'Il cliente deve verificare il CVC o utilizzare una carta diversa.',
            ],
            'incorrect_pin' => [
                'description' => 'Il PIN inserito non è corretto.',
                'next_steps' => 'Il cliente deve inserire il PIN corretto.',
            ],
            'incorrect_zip' => [
                'description' => 'Il codice postale non è corretto.',
                'next_steps' => 'Il cliente deve verificare il proprio codice postale.',
            ],
            'insufficient_funds' => [
                'description' => 'La carta non ha fondi sufficienti.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'invalid_account' => [
                'description' => 'La carta o il conto non esistono.',
                'next_steps' => 'Il cliente deve verificare le informazioni della carta o utilizzare un metodo di pagamento diverso.',
            ],
            'invalid_amount' => [
                'description' => 'L\'importo del pagamento non è valido.',
                'next_steps' => 'Verificare l\'importo e riprovare.',
            ],
            'invalid_cvc' => [
                'description' => 'Il codice di sicurezza della carta (CVC) non è valido.',
                'next_steps' => 'Il cliente deve verificare il CVC o utilizzare una carta diversa.',
            ],
            'invalid_expiry_year' => [
                'description' => 'L\'anno di scadenza della carta non è valido.',
                'next_steps' => 'Il cliente deve verificare la data di scadenza o utilizzare una carta diversa.',
            ],
            'invalid_number' => [
                'description' => 'Il numero di carta non è valido.',
                'next_steps' => 'Il cliente deve verificare il numero della carta o utilizzare una carta diversa.',
            ],
            'issuer_not_available' => [
                'description' => 'L\'emittente della carta non è disponibile.',
                'next_steps' => 'Il cliente deve riprovare più tardi.',
            ],
            'lost_card' => [
                'description' => 'La carta è stata segnalata come smarrita.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'merchant_blacklist' => [
                'description' => 'Il pagamento è stato rifiutato a causa delle regole del commerciante.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'new_account_information_available' => [
                'description' => 'Esistono nuove informazioni sull\'account della carta.',
                'next_steps' => 'Il cliente deve verificare le informazioni aggiornate con la propria banca.',
            ],
            'no_action_taken' => [
                'description' => 'L\'emittente della carta non ha intrapreso alcuna azione.',
                'next_steps' => 'Il cliente deve contattare l\'emittente della carta per maggiori informazioni.',
            ],
            'not_permitted' => [
                'description' => 'Il pagamento non è permesso.',
                'next_steps' => 'Il cliente deve contattare l\'emittente della carta per maggiori informazioni.',
            ],
            'offline_pin_required' => [
                'description' => 'È richiesto un PIN offline.',
                'next_steps' => 'Il cliente deve inserire il PIN corretto.',
            ],
            'online_or_offline_pin_required' => [
                'description' => 'È richiesto un PIN online o offline.',
                'next_steps' => 'Il cliente deve inserire il PIN corretto.',
            ],
            'pickup_card' => [
                'description' => 'La carta deve essere ritirata.',
                'next_steps' => 'Il cliente deve contattare l\'emittente della carta per maggiori informazioni.',
            ],
            'pin_try_exceeded' => [
                'description' => 'Il cliente ha superato il numero massimo di tentativi di PIN errati.',
                'next_steps' => 'Il cliente deve contattare l\'emittente della carta per sbloccare il PIN o utilizzare un metodo di pagamento alternativo.',
            ],
            'processing_error' => [
                'description' => 'Si è verificato un errore di elaborazione.',
                'next_steps' => 'Il cliente deve riprovare più tardi.',
            ],
            'reenter_transaction' => [
                'description' => 'Il pagamento deve essere inserito nuovamente.',
                'next_steps' => 'Il commerciante deve reinserire il pagamento.',
            ],
            'restricted_card' => [
                'description' => 'La carta non può essere utilizzata per questo pagamento.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'revocation_of_all_authorizations' => [
                'description' => 'La carta è stata rifiutata.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'revocation_of_authorization' => [
                'description' => 'La carta è stata rifiutata.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'security_violation' => [
                'description' => 'La carta è stata rifiutata a causa di una violazione della sicurezza.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'service_not_allowed' => [
                'description' => 'Il servizio non è permesso.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'stolen_card' => [
                'description' => 'La carta è stata segnalata come rubata.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'stop_payment_order' => [
                'description' => 'Il pagamento è stato bloccato dal cliente.',
                'next_steps' => 'Il cliente deve utilizzare un metodo di pagamento alternativo.',
            ],
            'testmode_charges_only' => [
                'description' => 'Il vostro conto non è stato attivato e può solo effettuare addebiti di prova.',
                'next_steps' => 'Attivate il vostro conto nella Dashboard per iniziare a elaborare addebiti reali.',
            ],
            'testmode_decline' => [
                'description' => 'È stata usata una carta di test Stripe.',
                'next_steps' => 'Utilizzare una carta di pagamento reale.',
            ],
            'transaction_not_allowed' => [
                'description' => 'La transazione non è permessa.',
                'next_steps' => 'Il cliente deve contattare l\'emittente della carta per maggiori informazioni.',
            ],
            'try_again_later' => [
                'description' => 'L\'emittente della carta non ha approvato la richiesta.',
                'next_steps' => 'Il cliente deve riprovare più tardi.',
            ],
        ],
    ],
    'zpay' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Errore generale sconosciuto.',
                'next_steps' => 'Contattare il supporto tecnico.',
            ],
            'validation_failed' => [
                'description' => 'Autorizzazione carta non riuscita',
                'next_steps' => 'Il cliente deve utilizzare una nuova carta.',
            ],
            'canceled' => [
                'description' => 'La richiesta è stata annullata',
                'next_steps' => 'Il cliente deve effettuare una nuova richiesta.',
            ],
            'failed' => [
                'description' => 'Richiesta fallita',
                'next_steps' => 'Il cliente deve effettuare una nuova richiesta.',
            ],
            'waiting_for_payment' => [
                'description' => 'Richiesta in attesa di pagamento',
                'next_steps' => 'Il cliente deve confermare il pagamento.',
            ],
            'requires_capture' => [
                'description' => 'Richiesta in attesa di conferma',
                'next_steps' => 'Il cliente deve autorizzare l\'operazione.',
            ],
            'refunded' => [
                'description' => 'Pagamento rimborsato',
                'next_steps' => 'Il pagamento è stata rimborsato correttamente.',
            ],
            'partially_refunded' => [
                'description' => 'Pagamento parzialmente rimborsato',
                'next_steps' => 'Il pagamento è stato rimborsato parzialmente.',
            ],
            'processing' => [
                'description' => 'Il pagamento è in fase di elaborazione',
                'next_steps' => 'Attendere l\'esito dell\'operazione.',
            ],
        ],
    ],
    'tableau' => [
        'errors' => [
            'roomNotFound' => 'Camera non trovata o inesistente',
            'tableauNumberNotFound' => 'Il numero camera non è corretto.',
            'closureConflict' => 'Non puoi sovrapporre periodi di chiusura',
            'lockedRoom' => 'La camera risulta bloccata o in camera d\'appoggio e non può subire modifiche',
            'lockedAccommodation' => 'Tipo di camera bloccato non modificabile',
            'reservation_accommodation_not_fund' => 'La camera prenotata non è stata trovata',
            'accommodation_destination_not_found' => 'La camera di destinazione non è stata trovata',
            'accommodation_destination_treatment_not_found' => 'Il trattamento non è attivo per la camera scelta',
            'accommodation_destination_rateplan_not_found' => 'La tariffa selezionata non è attiva per la camera scelta',
            'reservation_locked' => 'Questa prenotazione ha uno stato di blocco, non è possibile apportare modifiche.',
            'exists_reservation_destination' => 'Nella camera di destinazione è già presente una prenotazione, impossibile continuare!',
            'split_checkin_minor' => 'La data di checkin specificata è inferiore alla data di checkin della prenotazione',
            'split_checkout_major' => 'La data di checkout specificata è superiore alla data di checkout della prenotazione',
            'split_incompatible_rates' => 'La camera di destinazione è incompatibile perchè non ha le stesse tariffe della camera sorgente',
            'exists_tableau_closure' => 'Nella camera di destinazione è presente una chiusura, rimuovere la chiusura tableau prima di procedere',
            'exists_reservation_closure' => 'Nel periodo selezionato sono presenti alcune prenotazioni, impossibile chiudere l\'alloggio',
            'reservation_not_found' => 'Prenotazione non trovata',
            'reservation_accommodation_keep_activated' => 'L\'alloggio non può essere spostato. Per continuare rimuovi il blocco dal dettaglio della prenotazione.',
            'reservation_moved_or_cancelled' => 'La prenotazione è stata spostata o cancellata.',
            'reservation_is_moving' => 'Attenzione, è già in corso un\'operazione di modifica della prenotazione. Aggiorna il Tableau e ritenta tra qualche istante',
            'closure_just_creating' => 'Una chiusura è ancora in atto per questa camera, riprovare più tardi',
            'closure_just_removing' => 'Una rimozione chiusura è ancora in atto per questa camera, riprovare più tardi',
        ],
        'warnings' => [
            'tableauNumberWillBeChanged' => 'Attenzione, la camera verrà spostata sul numero :newTableauNumber',
        ],
    ],

    'technical_notices' => [
        'email' => [
            'failed_log_job_title' => 'Invio SendLogJob fallito',
        ],
        'errors' => [
            'channel_unsupported' => 'Canale non supportato',
            'property_not_found' => 'Struttura non trovata',
        ],
    ],

    'templates_snippets_categories' => [
        'reservation_data' => 'Dati prenotazione',
        'property_data' => 'Dati struttura',
        'automatism' => 'Automatismi',
        'reservations_accommodation_datails' => 'Dettagli alloggi prenotati',
        'reservation_personal_data' => 'Dati anagrafici prenotante',
        'payments_data' => 'Dati sui pagamenti',
        'cancellation_policy_data' => 'Dati policy di cancellazione',
        'estimate_data' => 'Dati preventivo',
        'tax_document_data' => 'Dati documenti fiscali',
        'payments_timetable' => 'Pagamenti programmati',
    ],

    'users' => [
        'new' => [
            'title' => 'Nuovo utente :username',
            'message' => 'Un nuovo utente è stato creato da :self_username',
        ],
        'update' => [
            'title' => 'Utente :username modificato',
            'message' => 'Utente :username modificato correttamente',
            'missing_email_verification_code' => 'La modifica che si sta tentando di effettuare richiede una conferma, le abbiamo inviato una notifica al suo indirizzo email corrente.',
        ],
        'delete' => [
            'title' => 'Utente :username eliminato',
            'message' => 'Utente :username eliminato correttamente',
            'error_delete_1' => 'Non puoi eliminare il tuo stesso account.',
        ],
        'errors' => [
            'emailnotfound' => 'Email non valida',
            'passwordIncorrect' => 'la password corrente non è valida',
            'reminderNotValid' => 'Codice non valido o scaduto',
            'propertyAttached' => 'L\'utente e la struttura sono già associati',
            'propertyDetached' => 'L\'utente e la struttura non hanno relazioni',
            'permissionNotFound' => 'Uno dei permessi non è presente per questo utente',
            'tokenNotGenerated' => 'Errore nella generazione del token',
            'username_exists' => 'L\'username è già in uso',
            'email_exists' => 'L\'indirizzo email è già in uso',
            'user_not_allowed' => 'L\'utente loggato non è autorizzato a creare nuovi utenti',
            'cannot_detach_all_auth_verification_methods' => 'Non è possibile scollegare tutti i metodi di verifica, almeno uno di questi deve essere attivo.',
            'no_active_properties' => 'Non risulta alcuna struttura attiva associata al tuo account. Ti invitiamo a contattare il supporto di Beddy per ricevere assistenza.'
        ],
    ],

    'vat_quote' => [
        'related_model' => [
            'accommodation' => 'Alloggio',
            'addon' => 'Servizio aggiuntivo',
            'city_tax' => 'Tassa di soggiorno',
            'manual_charge' => 'Extra inserito manualmente',
            'expense_category' => 'Categoria spese',
            'reservation_payment' => 'Fatture e ricevute di acconto',
            'place_tax' => 'Imposta di Bollo',
            'reservation_no_show' => 'No Show',
            'reservation_cancellation' => 'Cancellazione oltre i termini',
        ],
        'log_module' => [
            'vat_quote_created' => 'Aliquota IVA creato',
            'vat_quote_updated' => 'Aliquota IVA modificato',
            'vat_quote_deleted' => 'Aliquota IVA eliminato',
            'vat_quote_default_created' => 'Aliquota IVA Default creato',
            'vat_quote_default_updated' => 'Aliquota IVA Default modificato',
            'vat_quote_default_deleted' => 'Aliquota IVA Default eliminato',
            'property_vat_quote_added' => 'Aliquota IVA aggiunta',
            'property_vat_quote_replaced' => 'Aliquota IVA sostituita',
        ],
        'errors' => [
            'vat_quote_associated' => 'Aliquota IVA inserita come default di alcune strutture, impossibile procedere',
            'insufficient_default_number' => 'Impossibile procedere con la cancellazione della seguente Aliquota IVA, cancellandola non ci sarebbero più Aliquote IVA di Default per i seguenti campi: ',
            'invalid_place_id' => 'Il parametro Nazione non ha un valore valido.'
        ]
    ],

    'venice_exemption' => [
        'errors' => [
            'CDAError' => 'Le date selezionate non sono previste dal Comune di Venezia.'
        ]
    ],

    'vrbo' => [
        'checkpoints' => [
            'IsActiveByOwner' => 'Controlla che la distribuzione a Vrbo sia attiva',
            'IsListingNotArchived' => 'La proprietà è archiviata su Vrbo. Contatta l\'assistenza di Vrbo',
            'IsActiveByCsr' => ' Il supporto di Vrbo ha disattivato la proprietà. Contatta l\'assistenza di Vrbo',
            'HasImages' => 'Mancano le immagini (minimo 6)',
            'HasValidatedAddress' => 'Indirizzo non valido',
            'HasGeoCode' => 'Coordinate GPS non valide o mancanti',
            'HasPropertyAddress' => 'Indirizzo non valido',
            'HasBathroom' => 'Mancano i numeri dei bagni',
            'HasMaxOccupancy' => 'Mancano le informazioni delle occupazioni',
            'HasPropertyDescription' => 'Manca la descrizione',
            'HasPropertyHeadline' => 'Manca la descrizione',
            'HasPropertyName' => 'Manca il nome',
            'HasPropertyType' => 'Manca la tipologia di struttura',
            'HasRates' => 'Mancano le tariffe/disponibilità',
            'HasRegistrationNumber' => 'Manca il numero di registrazione',
        ],
    ],

    'webcontroller' => [
        'downloader' => [
            'title_waiting' => 'Attendere...',
            'message_waiting' => 'L\'operazione da te richiesta è in corso... Grazie per la pazienza',
            'title_started' => 'Download avviato',
            'message_started' => 'Il download è stato avviato. Una volta scaricato puoi chiudere questa finestra',
            'title_error' => 'Errore!',
            'message_error' => 'Si è verificato un errore durante l\'elaborazione della richiesta.<br> Ti preghiamo di contattarci.',
        ],
        'metasearch' => [
            'title_error' => 'Errore!',
            'message_error' => 'Si è verificato un errore durante l\'elaborazione della richiesta.',
        ],
    ],

    'welcome_automatic_email' => [
        'email' => [
            'preview_text' => 'Informazioni utili per essere operativi ',
            'subject' => 'Benvenuto in Beddy - Iniziamo la configurazione!',
            'greetings_text' => 'Per oggi è tutto, la ringraziamo ancora per aver scelto i nostri servizi.<br><br>Lo staff di Beddy',
            'training_pms_text_button' => 'VIDEO TRAINING PMS',
            'training_pms_channel_button' => 'VIDEO TRAINING CHANNEL MANAGER',
            'model_welcome' => [
                'subject' => 'Benvenuto in Beddy - Primi passi e informazioni importanti',
                'preview_text' => 'Tutto quello che c’è da sapere',
                'body_1' => 'Benvenuto in Beddy,  
                    <br><br>
                    la ringraziamo per aver scelto il nostro servizio e la invitiamo a <b>seguire con attenzione le indicazioni che riceverà nelle prossime comunicazioni</b>, pertanto le consigliamo di aggiungere gli indirizzi support@beddy.io e info@beddy.io nella rubrica del suo provider di posta per evitare che le nostre email finiscano nella cartella spam. 
                    <br><br>
                    Ecco le guide per i provider più usati: 
                    <br><br>
                    <a href="https://support.google.com/contacts/answer/1069522">Aggiungere un contatto su Gmail</a>
                    <br><br>
                    <a href="https://support.microsoft.com/it-it/office/aggiungere-un-contatto-e1dc4548-3bd6-4644-aecd-47b5728f7b0d#ID0EAABAAA=Newer_versions">Aggiungere un contatto su Outlook</a>',
                'greetings_text' => 'La ringraziamo ancora per aver scelto i nostri servizi.<br><br>Lo staff di Beddy',
            ],
            'model_A' => [
                'body_1' => 'Salve :userMasterName,  
                    <br><br>
                    di seguito i prossimi step da seguire per configurare il suo account Beddy. 
                    <br><br>          
                    &nbsp;&nbsp;<b>1. Primi passi - Configurazione Generale</b>
                    <br><br>
                    A breve la contatteremo per configurare il suo account Beddy.  
                    <br><br>
                    La configurazione iniziale è molto importante ed è propedeutica per gli step a seguire. 
                    <br><br>
                    Le suggeriamo di <b>compilare il modulo Excel</b> allegato prima dell’appuntamento con il nostro operatore, in questo modo riusciremo a ridurre i tempi di configurazione. 
                    <br><br>
                    Il file contiene più fogli ed è necessario compilarli tutti.<br>  
                    Non appena avrà concluso, dovrà inviare il file a <a href="mailto:support@beddy.io">support@beddy.io</a>. 
                    <br><br>
                    Tutti i campi del modulo allegato sono necessari, la mancanza di informazioni potrebbe ritardare la configurazione del suo account Beddy. 
                    <br><br>
                    Nel caso gestisca un account multi-struttura è necessario copiare il file Excel e compilarne uno per ogni struttura.  
                    <br><br>
                    Al termine della configurazione le saranno fornite le credenziali di accesso al suo account.',
                'body_2' => '&nbsp;&nbsp;<b>2. Formazione - Training PMS</b>             
                    <br><br>
                    Completata la configurazione, la contatteremo per fissare l’appuntamento per il <b>training formativo di 
                    gruppo</b> sulle funzionalità del PMS. Le sessioni formative sono disponibili il martedì alle 15:00 e il giovedì alle 10:00.                     
                    <br><br>
                    Il training durerà <b>90 minuti</b> e potranno partecipare anche collaboratori e dipendenti. 
                    <br><br>
                    In attesa del training, le suggeriamo di farsi un\'idea delle funzionalità del software consultando il training online.',
                'body_3' => '&nbsp;&nbsp;<b>3. Formazione - Training Channel Manager</b>            
                    <br><br>
                    Completata la formazione PMS, la contatteremo per fissare l’appuntamento per il <b>training formativo di 
                    gruppo</b> sulle funzionalità del Channel Manager. Le sessioni formative sono disponibili il lunedì alle 15:00 e il  
                    mercoledì e venerdì alle 11:30. 
                    <br><br>
                    Il training durerà <b>60 minuti</b> e potranno partecipare anche collaboratori e dipendenti. 
                    <br><br>
                    In attesa del training, le suggeriamo di farsi un\'idea delle funzionalità del software consultando il training online.',
                'body_4' => '&nbsp;&nbsp;<b>4. Connessione dei portali - Configurazione Channel Manager</b>
                    <br><br>
                    Dopo aver terminato i training, verrà programmato un nuovo incontro per la connessione dei portali. Le 
                    ricordiamo che una volta attivato il Channel Manager non sarà più possibile utilizzare le extranet dei portali 
                    o l’eventuale vecchio channel manager.',
            ],
            'model_B' => [
                'body_1' => 'Salve :userMasterName,  
                    <br><br>
                    di seguito i prossimi step da seguire per configurare il suo account Beddy. 
                    <br><br>          
                    &nbsp;&nbsp;<b>1. Primi passi - Configurazione Generale</b>
                    <br><br>
                    A breve la contatteremo per configurare il suo account Beddy.  
                    <br><br>
                    La configurazione iniziale è molto importante ed è propedeutica per gli step a seguire. 
                    <br><br>
                    Le suggeriamo di <b>compilare il modulo Excel</b> allegato prima dell’appuntamento con il nostro operatore, in questo modo riusciremo a ridurre i tempi di configurazione. 
                    <br><br>
                    Il file contiene più fogli ed è necessario compilarli tutti.<br>  
                    Non appena avrà concluso, dovrà inviare il file a <a href="mailto:support@beddy.io">support@beddy.io</a>. 
                    <br><br>
                    Tutti i campi del modulo allegato sono necessari, la mancanza di informazioni potrebbe ritardare la configurazione del suo account Beddy. 
                    <br><br>
                    Nel caso gestisca un account multi-struttura è necessario copiare il file Excel e compilarne uno per ogni struttura.  
                    <br><br>
                    Al termine della configurazione le saranno fornite le credenziali di accesso al suo account.',
                'body_2' => '&nbsp;&nbsp;<b>2. Formazione - Training PMS</b>             
                    <br><br>
                    Completata la configurazione, la contatteremo per fissare l’appuntamento per il <b>training formativo di gruppo</b> sulle funzionalità del PMS. Le sessioni formative sono disponibili il martedì alle 15:00 e il giovedì alle 10:00.<br><br>
                    Il training durerà <b>90 minuti</b> e potranno partecipare anche collaboratori e dipendenti. 
                    <br><br>
                    In attesa del training, le suggeriamo di farsi un\'idea delle funzionalità del software consultando il training online.',
                'body_3' => '&nbsp;&nbsp;<b>3. Formazione – Training Gestione Tariffe e Disponibilità</b>            
                    <br><br>
                    Completata la formazione PMS, la contatteremo per fissare l’appuntamento per il <b>training formativo di 
                    gruppo</b> sulle funzionalità del Channel Manager. Le sessioni formative sono disponibili il lunedì alle 15:00 e il  
                    mercoledì e venerdì alle 11:30. 
                    <br><br>
                    Il training durerà <b>60 minuti</b> e potranno partecipare anche collaboratori e dipendenti. 
                    <br><br>
                    In attesa del training, le suggeriamo di farsi un\'idea delle funzionalità del software consultando il training online.',
            ],
            'model_C' => [
                'body_1' => 'Salve :userMasterName,  
                    <br><br>
                    di seguito i prossimi step da seguire per configurare il suo account Beddy. 
                    <br><br>          
                    &nbsp;&nbsp;<b>1. Primi passi - Configurazione Generale</b>
                    <br><br>
                    A breve la contatteremo per configurare il suo account Beddy.  
                    <br><br>
                    La configurazione iniziale è molto importante ed è propedeutica per gli step a seguire. 
                    <br><br>
                    Le suggeriamo di <b>compilare il modulo Excel</b> allegato prima dell’appuntamento con il nostro operatore, in questo modo riusciremo a ridurre i tempi di configurazione. 
                    <br><br>
                    Il file contiene più fogli ed è necessario compilarli tutti.<br>  
                    Non appena avrà concluso, dovrà inviare il file a <a href="mailto:support@beddy.io">support@beddy.io</a>. 
                    <br><br>
                    Tutti i campi del modulo allegato sono necessari, la mancanza di informazioni potrebbe ritardare la configurazione del suo account Beddy. 
                    <br><br>
                    Nel caso gestisca un account multi-struttura è necessario copiare il file Excel e compilarne uno per ogni struttura.  
                    <br><br>
                    Al termine della configurazione le saranno fornite le credenziali di accesso al suo account.',
                'body_2' => '&nbsp;&nbsp;<b>2. Formazione - Training Channel Manager</b>            
                    <br><br>
                    Completata la configurazione, la contatteremo per fissare l’appuntamento per il <b>training formativo di 
                    gruppo</b> sulle funzionalità del Channel Manager. Le sessioni formative sono disponibili il lunedì alle 15:00 e il  
                    mercoledì e venerdì alle 11:30.
                    <br><br>
                    Il training durerà <b>60 minuti</b> e potranno partecipare anche collaboratori e dipendenti. 
                    <br><br>
                    In attesa del training, le suggeriamo di farsi un\'idea delle funzionalità del software consultando il training online.',
                'body_3' => '&nbsp;&nbsp;<b>3. Connessione dei portali - Configurazione Channel Manager</b>
                    <br><br>
                    Dopo aver terminato il training, verrà programmato un nuovo incontro per la connessione dei portali. Le 
                    ricordiamo che una volta attivato il Channel Manager non sarà più possibile utilizzare le extranet dei portali 
                    o l’eventuale vecchio channel manager.',
            ],
            'model_D' => [
                'body_1' => 'Salve :userMasterName,  
                    <br><br>
                    ecco i prossimi step da seguire per configurare il suo account Beddy, le chiediamo di <b>leggere con attenzione questa comunicazione</b> e comunicarci i dati necessari per velocizzare la configurazione.  
                    <br><br>          
                    &nbsp;&nbsp;<b>1. Primi passi - Configurazione Generale</b>
                    <br><br>
                    A breve la contatteremo per configurare il suo account Beddy.  
                    <br><br>
                    Le chiediamo, prima dell\'appuntamento con il nostro operatore, di:
                    <br><br>
                    &nbsp;&nbsp;&nbsp;&nbsp;- <b>compilare il modulo Excel</b> allegato<br>
                    &nbsp;&nbsp;&nbsp;&nbsp;- <b>richiedere la mappatura degli alloggi e dei piani tariffari</b> al vostro fornitore di servizi esterni da collegare a Beddy<br>
                    &nbsp;&nbsp;&nbsp;&nbsp;- <b>inviare modulo e mappatura</b> a <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
                    Questi dati sono <b>molto importanti</b> per procedere alla configurazione e ridurre i tempi di configurazione.
                    <br><br>
                    Tutti i campi del modulo allegato sono necessari, la mancanza di informazioni potrebbe ritardare la configurazione del suo account Beddy.
                    <br><br>
                    Nel caso gestisca un account multi-struttura è necessario compilare il file Excel e richiedere la mappatura per ognuna delle strutture.
                    <br><br>
                    Al termine della configurazione le saranno fornite le credenziali di accesso al suo account.',
                'body_2' => '&nbsp;&nbsp;<b>2. Formazione - Training PMS</b>             
                    <br><br>
                    Completata la configurazione, la contatteremo per fissare l’appuntamento per il <b>training formativo di 
                    gruppo</b> sulle funzionalità del PMS. Le sessioni formative sono disponibili il martedì alle 15:00 e il giovedì alle 10:00.  
                    <br><br>
                    Il training durerà <b>90 minuti</b> e potranno partecipare anche collaboratori e dipendenti. 
                    <br><br>
                    In attesa del training, le suggeriamo di farsi un\'idea delle funzionalità del software consultando il training online.',
                'body_3' => '&nbsp;&nbsp;<b>3. Formazione - Training per Channel Manager integrato a Beddy</b>            
                    <br><br>
                    Al termine della procedura di connessione, le verrà proposto un <b>training formativo di gruppo</b> su come 
                    utilizzare il PMS per aggiornare tariffe, disponibilità e restrizioni attraverso il Channel Manager esterno.
                    <br><br>
                    Le sessioni formative sono disponibili il lunedì alle 15:00 e il  mercoledì e venerdì alle 11:30.
                    <br><br>
                    Il training durerà <b>60 minuti</b> e potranno partecipare anche collaboratori e dipendenti.
                    <br><br>
                    Se il Channel Manager è integrato in modalità “solo scarico prenotazioni” il training è facoltativo, tuttavia 
                    consigliamo sempre di seguirlo qualora si volessero gestire le tariffe sul PMS per l’inserimento di 
                    prenotazioni o per la generazione di preventivi da Beddy.',
                'body_4' => '&nbsp;&nbsp;<b>4. Connessione del Channel Manager integrato a Beddy</b>
                    <br><br>
                    Dopo aver terminato il training PMS, verrà programmato un nuovo incontro per la connessione del Channel Manager esterno a Beddy. ',
            ],
        ],
        'errors' => [
            'fail_to_send' => 'Impossibile inviare la mail richiesta all\'indirizzo :email_address',
        ],
    ],

    'zdatalake' => [
        'Couple' => 'Coppie',
        'Family' => 'Famiglie',
        'Single' => 'Singolo',
        'Group' => 'Gruppo',
    ],
    'booking_booster_configuration' => [
        'errors' => [
            'configuration_not_found' => 'Configurazione non trovata'
        ]
    ],
    'booking_booster' => [
        'errors' => [
            'auth_token' => 'Impossibile recuperare il token di autenticazione di Booking Booster per questo errore: :error',
            'available_budget' => 'Impossibile recuperare il budget disponibile per questo errore: :error',
            'campaigns_statistics' => 'Impossibile recuperare le statistiche delle campagne per questo errore: :error',
            'ads_statistics' => 'Impossibile recuperare le statistiche degli annunci per questo errore: :error',
            'ads_details' => 'Impossibile recuperare i dettagli degli annunci per questo errore: :error',
            'property_targets' => 'Impossibile recuperare i target delle strutture per questo errore: :error',
            'client_error' => 'Credenziali non corrette o non autorizzati ad accedere alle risorse richieste. Dettagli: :error',
            'server_error' => 'Stiamo riscontrando difficoltà tecniche. Ti invitiamo a riprovare più tardi. Dettagli: :error',
            'connection_error' => 'Impossibile connettersi a Booking Booster. Ti invitiamo a riprovare più tardi. Dettagli: :error'
        ],
        'warnings' => [
            'property_not_mapped' => 'Le seguenti strutture non sono mappate e potrebbero non comparire correttamente nelle statistiche delle campagne: :propertyNames'
        ]
    ]
];
