<?php
$suffix = ' pour l\'hôte :customer_name, hébergement :tableau_number - :accommodation_name';
$roomReservationSuffix = ' dans l\'hébergement :accommodation_name - réservation :reservation_booker - :reservation_reference_number';
$reservationSuffix = ' parmi les invités à envoyer dans la réservation :reservation_booker - :reservation_reference_number';
$customerReservationSuffix = ' :customer_name - :reservation_reference_number';
$customerEmptyDataSuffix = 'pour l\'hôte :customer_name de la réservation :reservation_reference_number';

return [

    'accommodations' => [
        'errors' => [
            'attachExist' => 'Tarif déjà présent pour la chambre',
            'detachNotExist' => 'Piano tariffario non presente per la camera.',
            'detachStandardRateplan' => 'Vous ne pouvez pas supprimer le tarif standard',
            'guestsCnfigurationBase' => 'Vous ne pouvez pas appliquer de remises au tarif de base',
            'virtualRidondanceConflict' => 'Non è possibile associare questa camera. E\'già presente un legame',
            'parentTreeExist' => 'La chambre mère est déjà associée ou vous ne pouvez pas dépasser le quota de chambre mère. ',
            'quantityZero' => 'Vous ne pouvez pas supprimer la dernière caméra disponible',
            'quantityNotValid' => 'Vous envoyez une quantité inférieure ou égale à celle déjà existante',
            'quantitySum' => 'Le montant d\'une chambre ne peut pas être supérieur à un ',
            'quantitySuperior' => 'Vous ne pouvez pas dépasser le quota de la chambre mère',
            'quantityWithReservation' => 'Vous ne pouvez pas dépasser la hauteur de la chambre mère',
            'numberNotAvail' => 'Numéros de chambre non disponibles',
            'guestsConfigurationBase' => 'Il n\'est pas possible d\'appliquer une réduction à la configuration de base',
            'tooManyAdults' => 'Nombre d\'adultes au-dessus de la limite',
            'tooManyChildren' => 'Nombre d\'enfants au-dessus de la limite',
            'stillConnected' => 'Chambre toujours connectée à un ou plusieurs portails',
            'stillVirtual' => 'Chambre toujours connectée à une autre',
            'stillReserved' => 'Il y a des réservations sur cette salle',
            'notVirtualToSum' => 'Les liens de cette pièce ne suffisent pas',
            'notVirtualQty' => 'Le contingent de chambre doit être 1',
            'notVirtualChildQty' => 'Le contingent de la chambre liée doit être 1',
            'notVirtualSum' => 'Ce n\'est pas une salle de somme',
            'isVirtual' => 'Caméra virtuelle, opération non autorisée',
            'isNotVirtual' => 'Caméra non virtuelle, opération non autorisée',
            'ruleToBundle' => 'Vous ne pouvez pas affecter les règles de paquet',
            'noRateplanExist' => 'Pas de tarifs présents dans cet établissement d\'hébergement',
            'ruleIsLocked' => 'Non puoi modificare una regola su camere All Linked',
            'duplicateLabel' => 'Impossible d\'utiliser ce nom car il est déjà utilisé sur :accommodationName',
        ],
        'warnings' => [
            'request_confirm_delete_tableau_number' => 'Des chambres liées sont présentes, continuer ?',
            'accommodation_tableau_not_found' => 'ID Tableau :tableau_number_id non associé ou introuvable dans la chambre avec ID :accommodation_id',
            'accommodation_beds_types_combination_not_found' => 'La combinaison avec ID :acc_bed_type_combination_id est introuvable dans la chambre avec ID :accommodation_id',
            'confimation_delete_father_and_childs_combinations' => "Vous êtes sur le point de supprimer une combinaison d'aménagement parent (ID : :combination_id). En procédant, toutes ses combinaisons enfants seront également automatiquement supprimées. Confirmez-vous que vous souhaitez continuer ?",
            'invalid_facility' => 'Équipement incompatible',
        ],
        'channel' => [
            'single_use_exists' => 'La chambre :accommodation_name - :acommodation_ratename est déjà associée ou déjà créée',
            'single_use_dont_exists' => 'La chambre du canal avec l\'ID :accommodation_channel_id n\'a pas été trouvée',
            'email' => [
                'new_title' => 'Nouvelles chambres ajoutées pour le canal :channel_name - Établissement : :property_name - ID Établissement: :property_id',
                'deleted_title' => 'Chambres supprimées pour le canal :channel_name - Établissement : :property_name - ID Établissement: :property_id',
                'attached_title' => 'Des chambres non associées ont été détectées pour l\'établissement : :property_name - ID Établissement: :property_id',
                'conflict_rule' => 'Conflit de règles pour le canal :channel_name - Établissement : :property_name - ID Établissement: :property_id',
            ],
        ],
        'fields' => [
            'model_name' => 'camera',
            'checkin' => 'checkin',
            'checkout' => 'checkout',
            'checkin_hour' => 'heure d\'arrivée',
            'checkout_hour' => 'heure de départ',
            'checkin_arrival_preference' => 'préférence check in',
        ],
    ],

    'account_renewal' => [
        'email' => [
            'subject' => 'Renouvellement automatique des structures Beddy - :monthAndYear',
        ],
    ],

    'addon' => [
        'price_type' => [
            'xunit' => 'Par unité',
            // 1
            'xpax' => 'Par personne et par nuit',
            // 2
            'xweekxpax' => 'Par personne par semaine',
            // 3
            'xbookxpax' => 'Par personne en une seule fois',
            // 4
            'xnight' => 'Par nuit',
            // 5
            'xweek' => 'Hebdomadaire',
            // 6
            // 7
            'xbook' => 'Une seule fois',
        ],
        'warnings' => [
            'not_available' => 'Non disponible pour la période sélectionnée',
            'min_stay_violated' => 'La durée minimale de séjour requise est :min_stay',
            'max_stay_violated' => 'La durée maximale de séjour autorisée est :max_stay',
            'release_violated' => 'La durée maximale de libération autorisée est :release',
            'rateplan_excluded' => 'Le plan tarifaire :rateplan est exclu pour le service supplémentaire le :date',
            'treatment_excluded' => 'Le traitement :treatment est exclu pour le service supplémentaire le :date',
            'weekdays_excluded' => 'Un ou plusieurs jours de la semaine sont exclus',
        ],
        'errors' => [
            'not_in_stay' => 'Les dates sélectionnées sont en dehors de la période de séjour de la chambre',
            'not_found' => 'Service supplémentaire non associé à la chambre demandée',
            'billed_addon' => 'Service supplémentaire non annulable car lié à des frais de comptes encore ouverts',
        ],
        'logger' => [
            'added' => ':label pour :accommodation_name avec un prix de :price (:date) #:id',
        ],
    ],

    'admin' => [
        'errors' => [
            'not_demo' => 'La structure doit être de type DEMO',
            'no_accommodations' => 'La structure n\'a pas de chambres',
            'no_rateplans' => 'La structure n\'a pas de plans tarifaires',
            'channelmanager_module_needed' => 'Le module Channel Manager n\'est pas actif',
            'channel_beddy_only' => 'La structure doit avoir uniquement le canal Beddy actuellement actif',
        ],
    ],

    'api_partners' => [
        'contacts_types' => [
            'manager_email' => 'email du responsable',
            'technical_manager_email' => 'email du responsable technique',
            'customer_service_email' => 'email du service client',
            'commercial_requests_email' => 'email pour les demandes commerciales',
        ],
        'errors' => [
            'cannot_delete_has_users' => 'Impossible de supprimer le partenaire, car il a des utilisateurs associés',
            'action_not_allowed' => 'Vous n\'êtes pas autorisé à accéder au service :service.',
            'max_days' => 'L’intervalle maximum est de :days jours.',
            'date_filters' => 'Vous ne pouvez utiliser qu\'un seul type de filtre de date par demande, pas plus d\'un à la fois.',
            'cannot_delete_guest_city_tax' => 'Impossible de supprimer le client :guestId pour la réservation :reservationId car la taxe de séjour a déjà été facturée.',
            'too_many_reservation_ids' => 'Vous ne pouvez pas transmettre plus de :max reservationIds par requête. Vous en avez actuellement transmis :count.',
            'reservations_not_found' => 'Les réservations suivantes sont introuvables ou vous n’y avez pas accès : :ids',
            'customer_id_or_customer_required' => 'Vous devez fournir au moins l’un des deux champs : customerId ou customer.',
            'customer_id_and_customer_conflict' => 'Vous ne pouvez pas fournir customerId et customer en même temps : choisissez-en un seul.'
        ],
        'services' => [
            'ping' => 'Ping',
            'get_infos' => 'Récupérer les informations',
            'hotel_rateplan' => 'Plan tarifaire',
            'push_availabilities' => 'Saisie de disponibilités',
            'push_rates' => 'Saisie des tarifs',
            'reservations_lookup' => 'Recherche de réservations',
            'reservations_acknowledge' => 'Confirmation de réception des réservations',
            'hotel_res_modify_notif' => 'Notification de modification des réservations',
            'reservation_send_message' => 'Envoi de messages',
            'reservation_message_status' => 'Vérification de l\'état du message',
            'modify_reservation' => 'Modifier les réservations',
            'media' => 'Pièces jointes',
            'modify_media' => 'Modifier les pièces jointes',
            'delete_media' => 'Supprimer les pièces jointes',
            'invoices' => 'Factures',
            'credit_card' => 'Carte de crédit',
            'all_guests' => 'Tous les invités',
            'get_invoices' => 'Récupérer les factures',
            'generic_bol' => 'Génériques sur le moteur de réservation',
            'hotel_quote_request' => 'Demande de devis',
            'revenue_data' => 'Récupérer des données sur l’occupation et les revenus'
        ],
    ],
    'api_partner_detail' => [
        'fields' => [
            'country_id' => 'identifiant du pays',
            'city_id' => 'identifiant de la ville',
            'state_id' => 'identifiant de l\'état',
            'county_id' => 'identifiant du comté',
        ]
    ],
    'auth_verification_methods' => [
        'your_pin' => 'Votre code PIN d\'accès pour Beddy',
        'error_pin_invalid' => 'Erreur. Vérifiez que le code PIN saisi est correct',
        'email_authentication' => [
            'get_connection_info_message' => 'Nous venons de vous envoyer par email le code PIN à saisir pour compléter l\'authentification',
            'pin_invalid' => 'Le code PIN saisi n\'est pas valide',
        ],
        'google_authentication' => [
            'get_connection_info_message' => 'Vérifiez votre Google Authenticator pour obtenir le code PIN à saisir pour compléter l\'authentification',
            'pin_invalid' => 'Le code PIN saisi n\'est pas valide',
        ],
    ],

    'availability' => [
        'errors' => [
            'not_found' => 'Pas de disponibilité pour cet hébergement',
        ],
    ],

    'bills' => [
        'ordination_of_date' => 'Commande du :date',
        'vat_title' => 'TVA',
        'accommodation' => 'Hébergement',
        'total' => 'Total',
        'service' => 'Service',
        'quantity_abbreviated' => 'Qte',
        'amount' => 'Montant',
        'sign' => 'Signature',
        'account_balance_by_date' => 'Relevé de compte par date',
        'account_balance_by_buyer' => 'Relevé de compte par acheteur',
        'account_balance_by_guest' => 'Relevé de compte par invité',
        'account_balance_by_accommodation' => 'Relevé de compte par hébergement',
        'account_balance' => 'Relevé de compte',
        'payer' => 'Payeur',
        'quantity' => 'Qte',
        'date' => 'Date',
        'notes' => 'Notes',
        'scloby' => [
            'ordination_name' => 'Vente Tilby',
            'ordination_from_sale' => 'Commande créée par la vente Tilby',
            'confirmation_mode' => 'Mode de confirmation',
            'confirmation_by_phone' => 'numéro de téléphone',
            'confirmation_by_signature' => 'signature',
        ],
        'log' => [
            'refunds' => 'Le paiement :bill_label (:bill_common_id) a été remboursé de :refunded',
        ],
    ],

    'booking_onboard' => [
        'no_contract_found' => 'Aucun contrat trouvé pour cet établissement',
    ],

    'bookingengine' => [
        'addons_type' => [
            'xweek' => 'Par semaine',
            'xnight' => 'Par nuit',
            'xpax' => 'Par personne et par nuit',
            'xunit' => 'À l\'unité',
            'xbook' => 'Par réservation',
            'xbookxpax' => 'Par personne une seule fois',
            'xweekxpax' => 'Par personne et par semaine',
        ],
        'errors' => [
            'min_expense_coupon' => 'Code promo non applicable pour cette réservation : valeur insuffisante',
            'min_stay_coupon' => 'Code promo non applicable pour cette réservation : nombre de nuits insuffisant',
            'max_stay_coupon' => 'Code promo non applicable pour cette réservation : nombre de nuits supérieur au maximum prévu',
            'invalid_days_coupon' => 'Code promo non applicable les jours de semaine sélectionnés pour cette réservation',
            'invalid_conditions_coupon' => 'Code promo non applicable pour cette réservation : consulter les restrictions',
            'invalid_periods_coupon' => 'Code promo non applicable aux dates sélectionnées pour cette réservation',
            'invalid_coupon' => 'Code promo non valide ou inexistant',
            'already_coupon' => 'Vous ne pouvez appliquer qu\'un seul code promo',
            'availability_ended' => 'Les chambres sélectionnées ne sont plus disponibles',
            'cart_empty_accommodation' => 'Il n\'y a pas de chambre dans votre chariot',
            'date_past_quote_expire' => 'Impossible d\'ajouter la chambre au devis car la date de départ est antécédente à celle de l\'expiration du devis',
            'process_cart_date_past' => 'Impossible de continuer car la date de départ d\'une chambre précède la date d\'aujourd\'hui',
            'change_expire_date_quote_past' => 'La date d\'expiration du devis est antécédente à la date de départ d\'une ou de plusieurs chambres',
            'quote_expired' => 'Le devis a expiré',
            'quote_accepted' => 'Le devis a déjà été accepté',
            'quote_not_active' => 'Le devis n\'est plus valide',
            'quote_just_confirmed' => 'Le devis a déjà été confirmé, impossible de modifier le statut',
            'payment_not_valid' => 'Moyen de paiement non valide',
            'module_quote_not_active' => 'Le formulaire de devis n\'est pas disponible pour cette structure',
            'quote_option_no_availability' => 'Cette option n\'est plus disponible',
            'addon_excluded_from_coupon' => 'Impossible d\'ajouter le supplément ":addon_name" car il n\'est pas compatible avec le code promo appliqué',
            // Sezione sblocco offerte
            'unlock_wrong_accommodation' => 'Chambre incorrecte.',
            'unlock_wrong_accommodation_to_property' => 'Cette chambre n\'appartient pas à la structure.',
            'unlock_rateplan_not_unlockable' => 'La remise n\'est pas applicable pour cette offre.',
            // estimate addon
            'estimate_addon_failure' => 'Les données saisies dans la recherche sont incorrectes',
            // errori generali in step intermedi
            'step_not_complete' => 'Certains passages sont incomplets',
            'property_different' => 'Vous avez sélectionné des chambres de structures différentes',
            'data_sent_not_correct' => 'Les données envoyées sont incorrectes',
            'no_dns_found' => 'Aucun DNS associé à :subdomain',
            'no_payment_method_available' => 'Aucun moyen de paiement sélectionné',
            'session_expired' => 'Votre session a expiré',
            'booking_in_progress' => 'Réservation déjà en cours de traitement',
            'quote_option_no_availability_linked' => 'Logement non disponible et connecté à un autre logement, vérifiez le tableau lors de la confirmation de l\'estimation.',
            'quote_option_no_availability_accommodation' => 'Certains hébergements ne sont pas disponibles, consultez le tableau lors de la confirmation du estimation.',
            // alternative search
            'search_not_found' => 'recherche introuvable',
            'failed_to_create_reservation' => 'Une erreur s\'est produite lors de la création de la réservation',
            'create_quote_order_already_exist' => 'Ordre de cotation déjà en cours de traitement (le cache existe) - Référence :reference',
            'create_order_already_exist' => 'Ordre déjà en traitement (le cache existe) - SID :sid',
            'invalid_stay_coupon' => 'Coupon non applicable pour la période choisie',
        ],
        'persuasive_sentences' => [
            'prepayment' => 'Paiement anticipé',
            'hotel_payment' => 'Paiement à l’hôtel. Vous ne payez pas maintenant',
            'free_cancellation_until' => 'Annulation gratuite jusqu\'au :date_limit',
            'cancellation_term' => 'Termes et conditions de réservation',
            'cheapest_rate' => 'Ce tarif est le plus intéressant',
        ],
        'payment_method_description' => [
            'transfer' => 'testo no deposito',
            'transfer_deposit' => 'Il y a un prépaiement de :deposit, ce montant sera remboursable si les conditions d\'annulation de ce tarif le permettent. Vous recevrez les détails pour effectuer le transfert par e-mail. ',
            'cc_a_garanzia' => 'Zéro frais supplémentaires ! La carte de crédit sert uniquement à garantir la réservation. Vous n’aurez pas à payer d’acompte à l’avance. Vous paierez directement à :property_name le coût total de la réservation pendant votre séjour.',
            'cc_pos' => 'Zéro frais supplémentaires ! La carte de crédit sert uniquement à garantir la réservation. Vous n’aurez pas à payer d’acompte à l’avance. Vous paierez directement à :property_name le coût total de la réservation pendant votre séjour.',
            'cc_pos_deposit' => 'Il y a un prépaiement de :deposit, ce montant sera remboursable si les conditions d\'annulation de ce tarif le permettent.',
            'cc_stripe_deposit' => 'Le paiement sera effectué via la passerelle de paiement Stripe. Il y a un prépaiement de :deposit, ce montant sera remboursable si les conditions d\'annulation de ce tarif le permettent.',
            'nexi_deposit' => 'Le paiement sera effectué via la passerelle de paiement Nexi. Il y a un prépaiement de :deposit, ce montant sera remboursable si les conditions d\'annulation de ce tarif le permettent. <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Politique de confidentialité</a> de Nexi.',
            'zpay_deposit' => 'Le paiement sera effectué via la passerelle de paiement ZPay. Un acompte de :deposit est requis, remboursable si prévu par la politique d’annulation de ce tarif. <a href="https://www.zpay.it/privacy" target="_blank">Politique de confidentialité</a> de ZPay.',
            'cc_paypal_deposit' => 'Le paiement sera effectué via la passerelle de paiement Paypal. Il y a un prépaiement de :deposit, ce montant sera remboursable si les conditions d\'annulation de ce tarif le permettent.',
            'availability_request' => 'En raison de la période particulière de haute saison, cette demande n\'a pas valeur de réservation effective. Vous pouvez cependant demander des informations sur les disponibilités en remplissant le formulaire suivant. Votre demande de réservation sera confirmée dans les plus brefs délais.',
            'cc_paypal_deposit_with_commission' => 'Le paiement sera effectué via la passerelle de paiement Paypal. Il y a un acompte de :deposit + :commission de commission, ce montant sera remboursable si les conditions d\'annulation de ce tarif le permettent.',
        ],
        'automatic_payment_method_description' => [
            'transfer' => 'pas de texte de dépôt',
            'transfer_deposit' => 'Vous recevrez les détails pour effectuer le virement par email.',
            'cc_a_garanzia' => 'Aucun paiement anticipé requis maintenant. Vous paierez selon les délais indiqués dans les Conditions de paiement.',
            'cc_pos' => 'Aucun coût supplémentaire! La carte de crédit est uniquement utilisée pour garantir la réservation. Vous n\'avez pas besoin de verser un dépôt. Vous paierez le coût total de la réservation directement à :property_name pendant votre séjour.',
            'cc_pos_deposit' => 'Un paiement anticipé de :deposit est requis, ce montant sera remboursable si les conditions d\'annulation de ce tarif le permettent.',
            'cc_stripe_deposit' => 'Le paiement sera effectué via la passerelle de paiement Stripe.',
            'nexi_deposit' => 'Le paiement sera effectué via la passerelle de paiement Nexi. <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Politique de confidentialité Nexi</a>.',
            'zpay_deposit' => 'Le paiement sera effectué via la passerelle de paiement ZPay. Un acompte de :deposit est requis, remboursable si prévu par la politique d’annulation de ce tarif. <a href="https://www.zpay.it/privacy" target="_blank">Politique de confidentialité</a> de ZPay.',
            'cc_paypal_deposit' => 'Le paiement sera effectué via la passerelle de paiement Paypal.',
            'availability_request' => 'Cette demande ne constitue pas une réservation réelle, cependant, vous pouvez demander des informations sur les disponibilités en remplissant le formulaire suivant. La demande de réservation sera confirmée dès que possible.',
            'cc_paypal_deposit_with_commission' => 'Le paiement sera effectué via la passerelle de paiement Paypal.',
        ],
        'validators' => [
            'errors' => [
                'name' => 'Nom de l\'hôte invalide.',
                'surname' => 'Prénom de l\'hôte invalide.',
                'email' => 'Adresse e-mail de l\'hôte incorrecte.',
                'credit_card_type_id' => 'Type de carte de crédit non pris en charge.',
                'credit_card_holder' => 'Titulaire de la carte invalide.',
                'credit_card_number' => 'Numéro de carte invalide.',
                'credit_card_expire_date' => 'Date d\'expiration de la carte invalide.',
            ],
        ],
    ],

    'cash_desk_closure' => [
        'title' => 'Fermeture de la caisse',
        'invoice' => 'Facture',
        'invoices' => 'Factures',
        'receipt' => 'Reçu',
        'receipt_follows_invoice' => 'Le reçu suit la facture',
        'receipts' => 'Reçus',
        'type' => 'Type',
        'status' => 'Payé',
        'deposit' => 'Acompte',
        'recipient_business_name' => 'Destinataire',
        'taxable' => 'Imposable',
        'vat_quote' => 'TVA',
        'total' => 'Total',
        'payments' => 'Paiements',
        'totals' => 'TOTAL GÉNÉRAL',
        'cash_type' => 'Type de paiement',
        'reversal_receipt' => 'Annulation de reçu',
        'reversal_receipts' => 'Annulation des reçus',
        'to_give' => 'À donner',
        'to_have' => 'À recevoir',
        'balance' => 'Solde',
        'documents' => 'Documents',
        'deposits' => 'Acomptes',
        'cash_desk_closure' => 'Suspendus',
        'credit_note' => 'Note de crédit',
        'invoice_received' => 'Facture reçue',
        'credit_notes' => 'Notes de crédit',
        'suspended' => 'Suspendus',
        'follows_invoice' => 'Suit la facture',
        'receipts_follows_invoice' => 'Le reçu suit la facture',
        'suspend' => 'Suspendu',
        'empty_documents' => 'Aucun document à afficher',
        'sheets_name' => [
            'cash_desk' => 'Caisse',
            'cahs_desk_summary' => 'Résumé de la caisse',
        ],
        'export_fields' => [
            'date' => 'Date d\'entrée',
            'status' => 'Payé',
            'document_type' => 'Type de document',
            'document_number' => 'Numéro de document',
            'customer' => 'Destinataire',
            'taxable' => 'Imposable',
            'total_tax' => 'TVA',
            'total_to_pay' => 'Total',
            'payment_type' => 'Type de paiement',
            'to_have' => 'À recevoir',
            'to_give' => 'À donner',
            'balance' => 'Solde',
            'deposit_document_number' => 'Numéro de document de l\'acompte',
            'deposit_payment_type' => 'Type de paiement de l\'acompte',
        ],
    ],

    'cash' => [
        'cash_title' => 'Situation de la caisse',
        'cash_totals_title' => 'Totaux',
        'total' => 'Total',
        'cash_desk' => 'Caisse',
        'export_fields' => [
            'registration_date' => 'Date d\'entrée',
            'accountholder' => 'Titulaire du compte',
            'document' => 'Document',
            'document_date' => 'Date du document',
            'date' => 'Date',
            'in-out' => 'Entrées-sorties',
            'cash_in' => 'Encaissement (entrées)',
            'cash_out' => 'Sorties (paiements)',
            'payment_method' => 'Méthode de paiement',
            'note' => 'Notes',
            'type_payment' => 'Type de paiement',
            'stay' => 'Séjour',
            'extra' => 'Supplément',
            'city_tax' => 'Taxe de séjour',
            'pos' => 'POS',
            'property' => 'Propriété',
            'amount' => 'Montant',
            'mode' => 'Mode',
            'type' => 'Type',
            'category' => 'Catégories de dépenses',
            'notes' => 'Notes',
            'movement_amount' => 'Mouvements',
            'customer_or_company' => 'Client ou Entreprise',
            'label' => 'Étiquette',
        ],
        'document_types' => [
            'invoice' => 'Facture',
            'receipt' => 'Reçu',
            'credit_note' => 'Note de crédit',
        ],
        'payment_types' => [
            'deposit' => 'Acompte',
            'part_payment' => 'Paiement partiel',
        ],
        'total_yesterday' => 'Total d\'hier',
        'total_today' => 'Total d\'aujourd\'hui',
        'all_properties' => 'Toutes les propriétés',
        'sub_year' => 'Total de l\'année',
        'sub_month' => 'Total du mois',
        'sub_day' => 'Total du jour',
        'ins' => 'Encaissement (entrées)',
        'outs' => 'Sorties (paiements)',
        'cash_fund' => 'Caisse',
        'cash_in' => 'Entrées',
        'cash_out' => 'Sorties',
        'cash_balance' => 'Solde',
        'to_cash_in' => 'À encaisser',
        'wrap_up' => 'Résumé par mode de paiement',
        'summary' => 'Résumé',
        'in_out' => [
            'in' => 'Encaissement',
            'out' => 'Sortie',
        ],
        'totals' => [
            'method' => 'Méthode',
            'ins' => 'Encaissement',
            'outs' => 'Sorties',
            'diff' => 'Solde',
        ],
    ],

    'channel' => [
        '1' => [
            'promotions' => [
                'mobile_rate' => [
                    // indique l'ID du canal
                    'all' => 'Application et navigateur mobile',
                    'app' => 'Application',
                ],
                'geo_rate' => [
                    'algeria_pos' => 'Algérie',
                    'argentina_pos' => 'Argentine',
                    'australia_pos' => 'Australie',
                    'belarus_pos' => 'Biélorussie',
                    'brazil_pos' => 'Brésil',
                    'canada_pos' => 'Canada',
                    'chile_pos' => 'Chili',
                    'colombia_pos' => 'Colombie',
                    'eu_pos' => 'Europe',
                    'hong_kong_pos' => 'Hong Kong',
                    'india_pos' => 'Inde',
                    'indonesia_pos' => 'Indonésie',
                    'iran_pos' => 'Iran',
                    'israel_pos' => 'Israël',
                    'japan_pos' => 'Japon',
                    'kazakhstan_pos' => 'Kazakhstan',
                    'kuwait_pos' => 'Koweït',
                    'malaysia_pos' => 'Malaisie',
                    'mexico_pos' => 'Mexique',
                    'new_zealand_pos' => 'Nouvelle-Zélande',
                    'oman_pos' => 'Oman',
                    'pakistan_pos' => 'Pakistan',
                    'peru_pos' => 'Pérou',
                    'philippines_pos' => 'Philippines',
                    'qatar_pos' => 'Qatar',
                    'russia_pos' => 'Russie',
                    'saudi_arabia_pos' => 'Arabie Saoudite',
                    'singapore_pos' => 'Singapour',
                    'south_africa_pos' => 'Afrique du Sud',
                    'south_korea_pos' => 'Corée du Sud',
                    'switzerland_pos' => 'Suisse',
                    'taiwan_pos' => 'Taïwan',
                    'thailand_pos' => 'Thaïlande',
                    'trinidad_&_tobago_pos' => 'Trinité-et-Tobago',
                    'turkey_pos' => 'Turquie',
                    'ukraine_pos' => 'Ukraine',
                    'united_arab_emirates_pos' => 'Émirats Arabes Unis',
                    'united_states_pos' => 'États-Unis',
                    'vietnam_pos' => 'Vietnam',
                ],
            ],
            'json_request' => [
                'errors' => [
                    'INVALID_ARGUMENT' => 'Un ou plusieurs paramètres ne sont pas valides. (:message)',
                    'MISSING_ARGUMENT' => 'Un ou plusieurs paramètres sont manquants. (:message)',
                    'OPERATION_NOT_ALLOWED' => 'Opération non autorisée. (:message)',
                    'FORBIDDEN' => 'Opération interdite (:message)',
                ],
            ],
        ],
        '11' => [
            'availability_model' => 'Gestion de la disponibilité des types de chambres "Private":',
            'per_room' => 'Par chambre (avail*beds)',
            'per_person' => 'Par lits',
        ],
        '14' => [
            'availability_value_greater' => 'Vous avez entré une valeur de disponibilité supérieure à celle acceptée.',
        ],
        '39' => [
            'period_not_valid' => 'Tarif :rate valide du :valid_from au :valid_to. Mise à jour ignorée.',
        ],
        '53' => [
            'warning_update_category' => 'Erreur de mise à jour de la catégorie de chambre :rate_xml. Règles non définies sur Beddy.',
            'empty_response_update' => 'Erreur de mise à jour, réponse vide.',
        ],
        '68' => [
            'used_voucher' => 'VOUCHER UTILISÉ',
            'amount_voucher' => 'Montant du voucher',
            'used_amount' => 'Montant utilisé',
            'virtual_rate_option' => 'Gestion des tarifs dérivés',
            'virtual_rate_option_off' => 'Ne pas gérer (télécharger en lecture seule)',
            'virtual_rate_option_on' => 'Activer la gestion des tarifs dérivés (prix non gérable)',
            'manage_type' => 'Type de gestion',
            'manage_type_complete' => 'Gestion complète',
            'manage_type_reservation' => 'Gestion des réservations uniquement',
            'manage_type_avail_reservation' => 'Gestion des réservations et de la disponibilité',
            'message_only_reservation' => 'Mises à jour ignorées (Connecté à la gestion des réservations uniquement)',
            'message_avail_reservation' => 'Mises à jour des prix et des restrictions ignorées (Connecté à la gestion des réservations et de la disponibilité)',
            'deposit_requested' => 'Dépôt demandé',
            'deposit_payed' => 'Dépôt payé',
            'payed_via' => 'Payé par',
        ],
        '69' => [
            'manage_type' => 'Type de gestion',
            'manage_type_complete' => 'Gestion complète',
            'manage_type_reservation' => 'Gestion des réservations uniquement',
            'manage_type_avail_reservation' => 'Gestion des réservations et de la disponibilité',
            'manage_type_avail_restriction_reservation' => 'Gestion des réservations, de la disponibilité et des restrictions',
            'message_only_reservation' => 'Mises à jour ignorées (Connecté à la gestion des réservations uniquement)',
            'message_avail_reservation' => 'Mises à jour des prix et des restrictions ignorées (Connecté à la gestion des réservations et de la disponibilité)',
            'message_avail_restriction_reservation' => 'Mises à jour des prix ignorées (Connecté à la gestion des réservations, de la disponibilité et des restrictions)',
        ],
        '72' => [
            'manage_type' => 'Type de gestion',
            'manage_type_complete' => 'Gestion complète',
            'manage_type_reservation' => 'Gestion des réservations uniquement',
            'manage_type_avail_reservation' => 'Gestion des réservations et de la disponibilité',
            'manage_type_avail_restriction_reservation' => 'Gestion des réservations, de la disponibilité et des restrictions',
            'message_only_reservation' => 'Mises à jour ignorées (Connecté à la gestion des réservations uniquement)',
            'message_avail_reservation' => 'Mises à jour des prix et des restrictions ignorées (Connecté à la gestion des réservations et de la disponibilité)',
            'message_avail_restriction_reservation' => 'Mises à jour des prix ignorées (Connecté à la gestion des réservations, de la disponibilité et des restrictions)',
        ],
        '73' => [
            'pricing_model' => 'Modèle de tarification',
            'per_room' => 'Par chambre/tarif',
            'per_person' => 'Par personne',
            'manage_type' => 'Type de gestion',
            'manage_type_complete' => 'Gestion complète',
            'manage_type_reservation' => 'Gestion des réservations uniquement',
            'manage_type_avail_reservation' => 'Gestion des réservations et de la disponibilité',
            'manage_type_avail_restriction_reservation' => 'Gestion des réservations, de la disponibilité et des restrictions',
            'manage_type_avail_avail_price_reservation' => 'Gestion des réservations, de la disponibilité et des prix',
            'message_only_reservation' => 'Mises à jour ignorées (Connecté à la gestion des réservations uniquement)',
            'message_avail_reservation' => 'Mises à jour des prix et des restrictions ignorées (Connecté à la gestion des réservations et de la disponibilité)',
            'message_avail_restriction_reservation' => 'Mises à jour des prix ignorées (Connecté à la gestion des réservations, de la disponibilité et des restrictions)',
            'manage_avail_price_reservation' => 'Mises à jour des restrictions ignorées (Connecté à la gestion des réservations, de la disponibilité et des prix)',
            'payment_info' => 'Informations de paiement',
            'payment_amount' => 'Montant payé',
            'payment_extra_info' => 'Détails',
            'payment_transaction' => 'Code de la transaction',
            'payment_full' => 'Prépaiement effectué pour le montant total de la réservation',
            'payment_partial' => 'Prépaiement partiel effectué',
            'payment_none' => 'Aucun prépaiement',
            'payment_channel_collect' => 'L\'hôte a payé via le canal',
            'payment_hotel_collect' => 'L\'hôte doit payer à l\'hôtel (en totalité ou partiellement)',
            'payment_gateway' => 'L\'hôte a payé via la passerelle bancaire',
            'service_inclusive' => 'Inclus dans le prix',
        ],
        '93' => [
            'reservation_status' => 'Statut de la réservation',
            'booked' => 'Réservé, en attente de confirmation de la structure',
            'waiting_payment' => 'En attente du paiement de l\'acompte',
            'payment_in_progress' => 'Paiement en gestion et vérification',
            'confirmed' => 'Confirmée',
            'canceled' => 'Annulée',
            'waiting_credit_card_guarantee' => 'En attente de la carte de crédit pour garantie',
            'deposit' => 'Dépôt',
            'payed' => 'Payé',
            'not_payed' => 'Non payé',
            'payment_mothod' => 'Méthode de paiement',
            'option_property_xml_id' => 'Id de la structure (le même que Beddy)',
            'option_email' => 'Email',
            'option_apikey' => 'Clé API',
        ],
        '95' => [
            'unknown_rate' => 'Tarif PMS inconnu. ID chambre et tarif reçus du canal: ',
        ],
        'option_general' => [
            // traductions option générales (statique) canaux
            'property_xml_id' => 'Xml id de la structure',
            'username' => 'Nom d\'utilisateur',
            'password' => 'Mot de passe',
        ],
        'general' => [
            'get_channel_rate_empty' => 'Aucune donnée téléchargée depuis le portail',
            'no_data_to_update' => 'Aucune donnée à envoyer.',
            'no_valid_period' => 'La période mise à jour n\'est pas valide. Mise à jour ignorée.',
            'no_valid_response' => 'Réponse reçue du canal non valide (:error_message)',
            'only_min_stay_update' => 'La structure est configurée pour mettre à jour uniquement le séjour minimum.',
            'period_not_valid' => 'Tarif :rate valide du :valid_from au :valid_to. Mise à jour ignorée.',
            'no_valid_response_update' => 'Réponse reçue du canal non valide.',
            'discount' => 'Remise',
            'unknown' => 'Inconnu',
            'deposit_payed' => 'Dépôt payé',
            'to_payed' => 'À payer',
            'payment_type' => 'Type',
            'ota_commission' => 'Commission OTA',
            'ota_due' => 'Dû par OTA',
            'arrival_time' => 'Heure d\'arrivée',
            'cancellable_until' => 'Annulable jusqu\'au',
        ],
        'queue_update' => [
            'already_updated' => 'Mise à jour envoyée par code opération: :operation_code',
            'max_retry' => 'Nombre maximum de tentatives effectuées pour la mise à jour du canal: :channel_name - Période du: :date_from au: :date_to. Dernier message: :message',
            'queue_update_max_retry_strategy_mail' => 'Nombre maximum de renvois canal :channel_name - Structure: :property_name',
            'queue_update_exception_mail' => 'Exception canal :channel_name - Structure: :property_name',
        ],
        'errors' => [
            'content_api_update_errors_mail_connectivity' => 'Erreur de mise à jour CONTENT-API :channel_name - Structure: :property_name',
            'property_is_related' => 'La structure n\'est pas une mère et est déjà liée à une autre structure',
            'accommodation_channel_not_found' => 'La chambre avec l\'id xml :accommodation_xml_id n\'a pas été trouvée',
            'unsupported_min_dvance_res' => 'Ce canal ne permet pas de définir une valeur minimale d\'anticipation de réservation.'
        ],
        'queue_past_reservations' => [
            'queue_task_exists' => 'Propriété #:property_id déjà en file d\'attente d\'exécution',
        ],
    ],

    'checkinonline' => [
        'policy' => [
            'privacy_policy_accept' => 'Le soussigné(e), identifié(e) ci-dessous, déclare avoir reçu une information complète conformément aux Articles 13 et 14 du Règlement UE 2016/679 et avoir bien compris son contenu.',
            'privacy_policy_auth_1' => 'Le responsable du traitement des données personnelles, conformément à l\'article 9 du Règlement UE 679/2016, afin de bénéficier d\'un niveau optimal d\'hospitalité et pour protéger sa santé physique;',
            'privacy_policy_auth_2' => 'Le responsable pour communiquer les données relatives à mon séjour, exclusivement dans le but de permettre la réception de messages et d\'appels me concernant.',
            'privacy_policy_auth_3' => 'Le responsable pour envoyer des communications promotionnelles à mes coordonnées.',
            'privacy_policy_authorize' => 'J\'autorise',
            'privacy_policy_eighth_item' => '8. Mes données pourraient-elles être transférées à l\'étranger ?',
            'privacy_policy_eleventh_item' => '11. Quels sont les délais pour recevoir une réponse du responsable ?',
            'privacy_policy_fifth_item' => '5. Comment les données collectées seront-elles traitées ?',
            'privacy_policy_first_item' => '1. Qui détermine les finalités et les modalités du traitement ?',
            'privacy_policy_first_paragraph' => 'Conformément aux Articles 13 et 14 du règlement UE n°2016/679 (ci-après le \'RGPD\'), relatif à la protection des données personnelles et à leur libre circulation, la :businessName en tant que responsable du traitement des données personnelles, est tenue de vous fournir toutes les informations concernant les finalités et modalités du traitement de vos données personnelles, l\'indication des destinataires auxquels vos données pourront être communiquées, ainsi que tous les droits que la loi vous reconnaît concernant la gestion de vos données personnelles par le responsable.',
            'privacy_policy_fourth_item' => '4. Pourquoi collectez-vous mes données ?',
            'privacy_policy_fourth_item_part_2' => 'Base juridique du traitement',
            'privacy_policy_list_eighth_item_1' => 'Autres pays de l\'UE par rapport à l\'Italie;',
            'privacy_policy_list_eighth_item_2' => 'Royaume-Uni;',
            'privacy_policy_list_eighth_item_3' => 'Irlande;',
            'privacy_policy_list_eighth_item_4' => 'Suisse;',
            'privacy_policy_list_eighth_item_5' => 'USA',
            'privacy_policy_list_fifth_item_1' => 'Par des opérations permettant la collecte, l\'enregistrement, l\'organisation, la conservation, la consultation, le traitement, la modification, la sélection, l\'extraction, l\'utilisation, la communication, la suppression et la destruction des données.',
            'privacy_policy_list_fifth_item_2' => 'Par l\'utilisation d\'outils électroniques ou automatisés permettant la mémorisation, la gestion et la transmission des données, mais toujours configurés de manière à garantir leur confidentialité maximale et la nécessaire protection.',
            'privacy_policy_list_fifth_item_3' => 'Par l\'utilisation de documents sur support papier avec des mesures de sécurité appropriées empêchant leur connaissance par des personnes non autorisées.',
            'privacy_policy_list_fourth_item_1' => 'Gestion des clients;',
            'privacy_policy_list_fourth_item_10' => 'Protéger et garantir la sécurité et l\'intégrité des personnes;',
            'privacy_policy_list_fourth_item_11' => 'Protéger l\'intégrité des biens et du patrimoine de l\'entreprise;',
            'privacy_policy_list_fourth_item_12' => 'Permettre l\'utilisation et garantir la sécurité des infrastructures ICT.',
            'privacy_policy_list_fourth_item_1_part_2' => 'Consentement manifesté;',
            'privacy_policy_list_fourth_item_2' => 'Souscription et gestion des contrats;',
            'privacy_policy_list_fourth_item_2_part_2' => 'Obligations précontractuelles et contractuelles;',
            'privacy_policy_list_fourth_item_3' => 'Gestion administrative;',
            'privacy_policy_list_fourth_item_3_part_2' => 'Obligations légales;',
            'privacy_policy_list_fourth_item_4' => 'Gestion des contentieux;',
            'privacy_policy_list_fourth_item_4_part_2' => 'Intérêt légitime du responsable.',
            'privacy_policy_list_fourth_item_5' => 'Service client;',
            'privacy_policy_list_fourth_item_6' => 'Relations publiques',
            'privacy_policy_list_fourth_item_7' => 'Promotion, marketing et publicité;',
            'privacy_policy_list_fourth_item_8' => 'Protection de la santé physique des personnes;',
            'privacy_policy_list_fourth_item_9' => 'Sécurité interne;',
            'privacy_policy_list_nineth_item_1' => '10 ans (conformément aux obligations civiles - Art. 2220 Code Civil);',
            'privacy_policy_list_nineth_item_2' => '3 mois maximum à partir de la date de check-out pour les données des cartes de crédit;',
            'privacy_policy_list_nineth_item_3' => '3 ans maximum après le dernier check-out pour les données personnelles, particulières, relatives au séjour, les préférences personnelles, documents d\'identification, signature manuscrite et l\'historique des achats et des données marketing (points de 2.1 à 2.7), sauf indication contraire de l\'intéressé;',
            'privacy_policy_list_nineth_item_4' => '5 jours maximum pour les images de vidéosurveillance;',
            'privacy_policy_list_nineth_item_5' => '90 jours après le check-out pour les données relatives au trafic téléphonique;',
            'privacy_policy_list_nineth_item_6' => '1 an pour les données d\'accès et d\'utilisation des ressources ICT.',
            'privacy_policy_list_second_item_1' => 'Données d\'identification personnelle;',
            'privacy_policy_list_second_item_2' => 'Données particulières;',
            'privacy_policy_list_second_item_3' => 'Données relatives au séjour;',
            'privacy_policy_list_second_item_4' => 'Préférences personnelles;',
            'privacy_policy_list_second_item_5' => 'Documents d\'identification;',
            'privacy_policy_list_second_item_6' => 'Signature manuscrite;',
            'privacy_policy_list_second_item_7' => 'Historique des achats;',
            'privacy_policy_list_second_item_8' => 'Données de cartes de crédit et/ou bancaires;',
            'privacy_policy_list_second_item_9' => 'Images de vidéosurveillance;',
            'privacy_policy_list_second_item_10' => 'Données relatives aux appareils électroniques utilisés pour se connecter au réseau de la structure;',
            'privacy_policy_list_second_item_11' => 'Données relatives aux appels téléphoniques;',
            'privacy_policy_list_second_item_12' => 'Données d\'accès et d\'utilisation des ressources ICT',
            'privacy_policy_list_second_item_extra' => 'Données relatives à la santé.',
            'privacy_policy_list_seventh_item_1' => 'Responsables;',
            'privacy_policy_list_seventh_item_2' => 'Responsables du traitement;',
            'privacy_policy_list_seventh_item_3' => 'Administrateurs système;',
            'privacy_policy_list_seventh_item_4' => 'Consultants comptabilité;',
            'privacy_policy_list_seventh_item_5' => 'Consultants juridiques;',
            'privacy_policy_list_seventh_item_6' => 'Banques',
            'privacy_policy_list_seventh_item_7' => 'Organismes d\'assurance;',
            'privacy_policy_list_seventh_item_8' => 'Sociétés de révision;',
            'privacy_policy_list_seventh_item_9' => 'Sociétés de services pour la maintenance des infrastructures hôtelières',
            'privacy_policy_list_seventh_item_10' => 'Sociétés de fourniture de services Internet et de courrier électronique;',
            'privacy_policy_list_seventh_item_11' => 'Organismes, associations, entreprises, ou particuliers organisant des événements ou séjours dans la structure;',
            'privacy_policy_list_seventh_item_12' => 'Autorités publiques;',
            'privacy_policy_list_seventh_item_13' => 'Forces de l\'ordre.',
            'privacy_policy_list_third_item_1' => 'OTA (Agence de voyages en ligne) telles que, par exemple, Booking.com, Venere.com, Worldhotels.com, Trivago.com, Expedia.com, etc.',
            'privacy_policy_list_third_item_2' => 'Agences de voyages traditionnelles;',
            'privacy_policy_list_third_item_3' => 'Organismes, associations, entreprises ou particuliers organisant des événements ou séjours dans la structure;',
            'privacy_policy_location' => ':businessCity, le',
            'privacy_policy_name_surname' => 'Nom et prénom',
            'privacy_policy_nineth_item' => '9. Combien de temps mes données seront-elles conservées ?',
            'privacy_policy_not_authorize' => 'Je n\'autorise pas',
            'privacy_policy_second_item' => '2. Quelles sont les données personnelles traitées par le responsable du traitement ?',
            'privacy_policy_second_paragraph' => 'Nous vous invitons donc à prendre connaissance des informations contenues et à exprimer votre consentement en signant cette déclaration.',
            'privacy_policy_seventh_item' => '7. Qui aura accès à mes données ?',
            'privacy_policy_sign' => 'Signature :',
            'privacy_policy_sixth_item' => '6. Pourquoi devrais-je fournir mes données au responsable ? Puis-je refuser ?',
            'privacy_policy_sub1' => 'Droit d\'accès aux données (Article 15, RGPD)',
            'privacy_policy_sub2' => 'Droit de rectification (Article 16, RGPD)',
            'privacy_policy_sub3' => 'Droit à l\'effacement (Article 17, RGPD)',
            'privacy_policy_sub4' => 'Droit de limitation du traitement (Article 18, RGPD)',
            'privacy_policy_sub5' => 'Droit à la portabilité des données (Article 20, RGPD)',
            'privacy_policy_sub6' => 'Droit d\'opposition (Article 21, RGPD)',
            'privacy_policy_sub7' => 'Droit à ce que vos données ne fassent pas l\'objet d\'une décision automatisée, y compris le profilage (Article 22, RGPD)',
            'privacy_policy_sub8' => 'Droit de déposer une plainte auprès de l\'autorité de contrôle (Article 77, RGPD)',
            'privacy_policy_tenth_item' => '10. Comment puis-je intervenir pour limiter, empêcher ou m\'opposer au traitement de mes données par le responsable ?',
            'privacy_policy_text_eighth_item' => 'Les données personnelles peuvent être transférées vers des pays de l’Union Européenne ou vers des pays tiers par rapport à l’Union Européenne ou une organisation internationale si cette mesure est nécessaire pour atteindre les finalités indiquées au paragraphe 4 et remplir les obligations contractuelles. À ce jour, les pays vers lesquels vos données sont transférées sont :',
            'privacy_policy_text_eleventh_item' => 'En cas de demande d\'informations sur vos données, le responsable du traitement vous répondra dans les plus brefs délais, sauf si cela s\'avère impossible ou nécessite des efforts disproportionnés, et en tout cas dans un délai ne dépassant pas 30 jours suivant la demande. Toute impossibilité ou retard de la part du responsable sera justifiée.',
            'privacy_policy_text_first_item' => 'Le responsable du traitement des données est :businessName situé à :businessCity, :businessAddress, :businessCap, Numéro de TVA :businessVat.',
            'privacy_policy_text_second_item' => 'Le responsable du traitement recueillera et traitera vos données personnelles, telles que toute information permettant de vous identifier directement ou indirectement, comme, à titre indicatif :',
            'privacy_policy_text_second_item_part_2' => 'et toute autre donnée nécessaire pour atteindre les objectifs mentionnés au paragraphe 4.',
            'privacy_policy_text_second_item_part_2_span' => 'Il sera également traité des données particulières telles que :',
            'privacy_policy_text_third_item' => 'Les données personnelles sont fournies directement par la personne concernée au responsable du traitement ou recueillies auprès d\'autres entités telles que :',
            'privacy_policy_text_fourth_item' => 'Les données personnelles recueillies par le responsable du traitement seront traitées pour les finalités suivantes :',
            'privacy_policy_text_fourth_item_part_2' => 'Le traitement des données se fera dans le strict respect des prescriptions légales, conformément aux principes de légalité et de transparence et en respectant le droit à la vie privée.',
            'privacy_policy_text_fifth_item' => 'Le traitement sera effectué de manière automatisée et manuelle, conformément à l\'article 32 du RGPD 2016/679 et en particulier :',
            'privacy_policy_text_sixth_item' => 'Lorsque la fourniture des données personnelles est nécessaire pour l\'exécution d\'un contrat ou pour se conformer à une obligation légale, le traitement est indispensable et si vous refusez de fournir les données visées par la présente politique, le responsable ne pourra pas remplir les activités visées au paragraphe 4.',
            'privacy_policy_text_sixth_item_span' => 'Concernant les finalités pour lesquelles votre consentement est demandé, le refus n\'affectera pas les obligations du responsable.',
            'privacy_policy_text_seventh_item' => 'Les données personnelles peuvent être transférées et traitées par d\'autres entités dans la qualité de responsables ou sous-traitants, afin de respecter les obligations précontractuelles, contractuelles, légales ou pour un intérêt légitime.',
            'privacy_policy_text_seventh_item_part_2' => 'Les données fournies et collectées par le responsable du traitement ne seront pas diffusées publiquement ni utilisées pour du profilage.',
            'privacy_policy_text_seventh_item_span' => 'Les catégories de destinataires peuvent être, à titre indicatif :',
            'privacy_policy_text_nineth_item' => 'Les données personnelles seront conservées pendant la durée strictement nécessaire à l\'exécution des activités liées aux finalités de cette politique. Les délais de conservation seront :',
            'privacy_policy_text_nineth_item_part_2' => 'Sous réserve de périodes de conservation plus longues prévues par des normes spécifiques. En cas de litige, les données personnelles seront conservées jusqu\'à la fin du délai de prescription prévu par la loi.',
            'privacy_policy_text_tenth_item' => 'Par une communication écrite envoyée par Pec ou lettre recommandée, vous avez :',
            'privacy_policy_text_tenth_item_part_2' => 'Obtenir du responsable du traitement la confirmation que des données personnelles vous concernant sont ou non traitées, et dans ce cas, obtenir l\'accès à vos données personnelles.',
            'privacy_policy_text_tenth_item_part_3' => 'Obtenir du responsable la rectification des données incorrectes qui vous concernent sans délai.',
            'privacy_policy_text_tenth_item_part_4' => 'Obtenir l\'effacement des données vous concernant sans délai, sauf s\'il existe des raisons légales de maintenir ces données.',
            'privacy_policy_text_tenth_item_part_5' => 'Obtenir, si possible, la limitation du traitement de vos données personnelles ou retirer votre consentement.',
            'privacy_policy_text_tenth_item_part_6' => 'Si le traitement est basé sur un contrat, et effectué par des moyens automatisés, vous avez le droit de recevoir vos données dans un format structuré, couramment utilisé et lisible par un dispositif automatique et de les transmettre à un autre responsable.',
            'privacy_policy_text_tenth_item_part_7' => 'S\'opposer à tout moment, pour des raisons liées à votre situation particulière, au traitement de vos données personnelles fondé sur l\'intérêt légitime du responsable.',
            'privacy_policy_text_tenth_item_part_8' => 'Ne pas être soumis à une décision uniquement basée sur le traitement automatisé des données, sauf si cette décision produit des effets juridiques vous concernant.',
            'privacy_policy_text_tenth_item_part_9' => 'Sous réserve de recours administratif ou judiciaire, si vous estimez que le traitement de vos données viole le RGPD, vous pouvez introduire une plainte auprès de l\'autorité de contrôle.',
            'privacy_policy_text_twelfth_item' => 'Cette politique s\'applique également aux positions ouvertes avant le 25.05.2018.',
            'privacy_policy_third_item' => '3. Comment les données personnelles sont-elles collectées ?',
            'privacy_policy_title' => 'Politique de confidentialité des clients',
            'privacy_policy_title_first_item' => 'Le responsable du traitement',
            'privacy_policy_title_fourth_item' => 'Objectifs du traitement',
            'privacy_policy_title_fifth_item' => 'Modalités du traitement',
            'privacy_policy_title_sixth_item' => 'Nature de la fourniture des données et refus de les fournir',
            'privacy_policy_title_seventh_item' => 'Communication des données',
            'privacy_policy_title_tenth_item' => 'Droits de la personne concernée',
            'privacy_policy_twelfth_item' => '12. Entrée en vigueur et efficacité',
            'privacy_policy_title_consent' => 'Déclarations de consentement au traitement',
            'privacy_policy_title_footer' => 'Pour prendre connaissance de l\'information',
            'privacy_policy_vers' => 'vers. 1.1 du 4.4.2019',
        ],
    ],

    'city_tax_channel' => [
        'default' => [
            'accommodations_mapping' => 'Cartographie des chambres',
            'scheduled_send' => 'Souhaitez-vous activer l\'envoi automatique des rapports ?',
            'scheduled_send_info' => 'Le système envoie automatiquement tous les invités qui ont effectué leur check-out le jour précédent à la date actuelle. Par exemple, le 25 juin, il envoie les invités qui ont effectué leur check-out le 24 juin.',
            'which_guests_to_send' => 'Envoyer automatiquement :',
            'only_invoiced' => 'Seulement les invités avec taxe facturée',
            'all_guest_with_city_tax_calculated' => 'Tous les invités avec taxe calculée',
        ],
        'pay_tourist' => [
            'structure_id' => 'ID PayTourist de la structure',
            'software_id' => 'ID partenaire logiciel autorisé, délivré par PayTourist',
            'get_extra_specifications' => 'Obtenir les types de chambres',
            'token' => 'Token pour accéder aux API, délivré par PayTourist',
            'period' => 'Période pour générer le rapport de la taxe de séjour',
        ],
        'tourist_tax' => [
            'period' => 'Période pour générer le rapport de la taxe de séjour',
            'city_tax_channel_group_id' => 'Groupe de configuration pour l\'envoi/exportation du rapport de la taxe de séjour',
        ],
        'exceptions' => [
            'city_tax_channel_configuration_not_valid' => 'Les paramètres suivants pour l\'association d\'une structure à un canal d\'envoi de taxe de séjour ne sont pas valides : ',
            'channel_configuration_not_valid' => 'Les paramètres suivants requis par le canal :channelName ne sont pas valides : :params',
            'channel_credential_not_valid' => 'Les identifiants pour le canal :channelName ne sont pas valides',
            'channel_configuration_must_have_one_property' => 'Le canal :channelName nécessite au maximum une seule structure',
            'channel_params_not_valid' => 'Les paramètres suivants requis par le canal :channelName pour créer le rapport ne sont pas valides : :params',
            'channel_configuration_missing' => 'Les paramètres de configuration requis par le canal :channelName ne sont pas présents dans la demande',
            'channel_params_missing' => 'Les paramètres requis par le canal :channelName pour créer le rapport ne sont pas présents dans la demande',
            'city_tax_exemption_not_mapped' => 'Exemption :exemptionName non prévue pour l\'invité :guestName :guestSurname de la réservation :reservationId - :booker',
            'city_tax_channel_place_not_found' => 'La ville :placeName n\'est pas encore disponible pour le canal sélectionné',
            'city_tax_channel_group_not_found' => 'Le groupe sélectionné n\'existe pas',
            'file_not_valid' => 'Impossible de sauvegarder le fichier exporté sur le cloud pour le canal :channelName',
            'networking_error' => 'Erreur dans la demande d\'envoi du rapport de la réservation :reservationId pour le canal :channelName avec l\'erreur suivante : :error',
            'channel_unreachable' => 'Impossible d\'atteindre le canal :channelName pour les erreurs suivantes : :errors',
            'date_range_out_of_boundaries' => 'La période maximale du rapport pour le canal :channelName est de :days jours à partir de la date de début',
            'date_from_not_valid' => 'La date minimale de début pour la génération du rapport pour le canal :channelName est de :days jours avant la date de transmission',
            'guest_attributes_missing' => 'Impossible d\'envoyer le rapport de taxe de séjour pour le canal :channelName en raison de données manquantes pour les invités : :guests',
            'empty_report' => 'Aucun invité n\'a été extrait dans le rapport de taxe de séjour demandé',
            'endpoint_not_mapped' => 'L\'endpoint pour la ville :place pour le canal :channelName n\'est pas présent, veuillez contacter le support technique',
        ],
    ],

    'city_tax_configuration' => [
        'errors' => [
            'restriction_fields_not_valid' => 'Les champs fournis ne font pas partie de la restriction de la taxe de séjour fournie',
            'option_fields_not_valid' => 'Les champs fournis ne font pas partie de l\'option de taxe de séjour fournie',
            'field_not_valid' => 'Le champ :fieldNotValid fourni ne correspond pas à la validation :condition :validation',
            'configuration_override_already_exist' => 'Une configuration de taxe de séjour existante inclut déjà les dates sélectionnées',
        ],
        'exceptions' => [
            'city_tax_configuration_not_valid' => 'Les paramètres suivants pour créer la configuration de la taxe de séjour ne sont pas valides : ',
            'field_not_valid' => 'Le champ :fieldName n\'est pas présent parmi les champs attendus de la configuration',
            'field_is_required' => 'Le champ :fieldName est obligatoire',
        ],
    ],

    'city_tax_option_field' => [
        'option_field' => [
            'nationality' => [
                'country_id' => [
                    'name' => 'Nationalité',
                    'description' => 'Nationalité de l\'hôte',
                ],
            ],
            'reservation_from' => [
                'reservation_from_id' => [
                    'name' => 'Provenance',
                    'description' => 'Provenance de la réservation.',
                ],
            ],
            'reservation_reason' => [
                'reservation_reason_id' => [
                    'name' => 'Raison',
                    'description' => 'Motif de la réservation.',
                ],
            ],
            'group_leader' => [
                'active' => [
                    'name' => 'Activer',
                    'description' => 'Activer l\'exclusion.',
                ],
            ],
            'residence_country' => [
                'country_id' => [
                    'name' => 'Pays de résidence',
                    'description' => 'Pays de résidence de l\'hôte.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exonération',
                    'description' => 'Exonération',
                ],
            ],
            'residence_state' => [
                'state_id' => [
                    'name' => 'État de résidence',
                    'description' => 'État de résidence de l\'hôte.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exonération',
                    'description' => 'Exonération',
                ],
            ],
            'residence_county' => [
                'county_id' => [
                    'name' => 'Comté de résidence',
                    'description' => 'Comté de résidence de l\'hôte.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exonération',
                    'description' => 'Exonération',
                ],
            ],
            'residence_city' => [
                'city_id' => [
                    'name' => 'Ville de résidence',
                    'description' => 'Ville de résidence de l\'hôte.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exonération',
                    'description' => 'Exonération',
                ],
            ],
            'accommodation_tableau_number' => [
                'accommodation_tableau_number_id' => [
                    'name' => 'Hébergement',
                    'description' => 'Hébergement',
                ],
            ],
            'accommodation' => [
                'accommodation_id' => [
                    'name' => 'Type d\'hébergement',
                    'description' => 'Type d\'hébergement',
                ],
            ],
        ],
    ],

    'city_tax_option' => [
        'option' => [
            'nationality' => [
                'name' => 'Nationalité',
                'description' => 'Nationalité de l\'hôte',
            ],
            'reservation_from' => [
                'name' => 'Provenance',
                'description' => 'Provenance de la réservation.',
            ],
            'reservation_reason' => [
                'name' => 'Raison',
                'description' => 'Motif de la réservation.',
            ],
            'group_leader' => [
                'name' => 'Chef de groupe',
                'description' => 'Chef de groupe parmi les hôtes.',
            ],
            'residence_country' => [
                'name' => 'Pays de résidence',
                'description' => 'Pays de résidence de l\'hôte.',
            ],
            'residence_state' => [
                'name' => 'État de résidence',
                'description' => 'État de résidence de l\'hôte.',
            ],
            'residence_county' => [
                'name' => 'Comté de résidence',
                'description' => 'Comté de résidence de l\'hôte.',
            ],
            'residence_city' => [
                'name' => 'Ville de résidence',
                'description' => 'Ville de résidence de l\'hôte.',
            ],
            'accommodation_tableau_number' => [
                'name' => 'Hébergement',
                'description' => 'Hébergement.',
            ],
            'accommodation' => [
                'name' => 'Type d\'hébergement',
                'description' => 'Type d\'hébergement.',
            ],
        ],
    ],

    'city_tax_restriction_field' => [
        'restriction_field' => [
            'age_range' => [
                'min_age' => [
                    'name' => 'Âge minimum',
                    'description' => 'Âge minimum de la tranche',
                ],
                'max_age' => [
                    'name' => 'Âge maximum',
                    'description' => 'Âge maximum de la tranche',
                ],
                'amount_price' => [
                    'name' => 'Montant fixe',
                    'description' => 'Montant de la taxe de séjour',
                ],
                'percentage_price' => [
                    'name' => 'Pourcentage du montant',
                    'description' => 'Pourcentage de calcul pour le montant',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exonération',
                    'description' => 'Exonération',
                ],
                'price_type' => [
                    'name' => 'Type de prix',
                    'description' => 'Type de prix',
                ],
            ],
            'percentage_range' => [
                'min_amount' => [
                    'name' => 'Montant minimum',
                    'description' => 'Valeur minimale du calcul en pourcentage',
                ],
                'max_amount' => [
                    'name' => 'Montant maximum',
                    'description' => 'Valeur maximale du calcul en pourcentage',
                ],
            ],
            'validity_period' => [
                'date_from' => [
                    'name' => 'Début de la période',
                    'description' => 'Début de la période de validité',
                ],
                'date_to' => [
                    'name' => 'Fin de la période',
                    'description' => 'Fin de la période de validité',
                ],
                'flag_year' => [
                    'name' => 'Saisonnalité',
                    'description' => 'Période valable chaque année',
                ],
            ],
            'price_range_night' => [
                'min_price' => [
                    'name' => 'Prix minimum',
                    'description' => 'Prix minimum valable pour le calcul',
                ],
                'max_price' => [
                    'name' => 'Prix maximum',
                    'description' => 'Prix maximum valable pour le calcul',
                ],
            ],
            'limit_days' => [
                'days' => [
                    'name' => 'Nuits d\'application',
                    'description' => 'Nuits maximales d\'application',
                ],
            ],
            'month_max_nights' => [
                'max_days' => [
                    'name' => 'Nuits d\'application',
                    'description' => 'Si un hôte dépasse cette limite dans le mois calendaire (même pour des réservations différentes et non consécutives), la taxe n\'est plus calculée',
                ],
            ],
            'year_max_nights' => [
                'max_days' => [
                    'name' => 'Nuits d\'application',
                    'description' => 'Si un hôte dépasse cette limite dans l\'année civile (même pour des réservations différentes et non consécutives), la taxe n\'est plus calculée',
                ],
            ],
            'reservation_max' => [
                'max' => [
                    'name' => 'Nombre maximum',
                    'description' => 'Limite du nombre de réservations applicables annuellement pour un hôte spécifique',
                ],
            ],
            'limit_nights' => [
                'min_nights' => [
                    'name' => 'Nuits minimales',
                    'description' => 'Nombre minimum de nuits de la réservation.',
                ],
                'max_nights' => [
                    'name' => 'Nuits maximales',
                    'description' => 'Nombre maximum de nuits de la réservation.',
                ],
            ],
            'range_nights' => [
                'night_from' => [
                    'name' => 'De la nuit',
                    'description' => 'Nuit de début du calcul.',
                ],
                'night_to' => [
                    'name' => 'À la nuit',
                    'description' => 'Nuit de fin du calcul.',
                ],
                'amount_price' => [
                    'name' => 'Montant fixe',
                    'description' => 'Montant de la taxe de séjour',
                ],
                'percentage_price' => [
                    'name' => 'Pourcentage du montant',
                    'description' => 'Pourcentage de calcul pour le montant',
                ],
                'price_type' => [
                    'name' => 'Type de prix',
                    'description' => 'Type de prix',
                    'amount_name' => 'Montant',
                    'percentage_name' => 'Pourcentage',
                ],
            ],
            'adult_quote_range' => [
                'min_amount' => [
                    'name' => 'Montant minimum',
                    'description' => 'Choisir le montant minimum de la part adulte calculée sur le prix de la nuit hors TVA',
                ],
                'max_amount' => [
                    'name' => 'Montant maximum',
                    'description' => 'Choisir le montant maximum de la part adulte calculée sur le prix de la nuit hors TVA',
                ],
                'amount_price' => [
                    'name' => 'Montant fixe',
                    'description' => 'Montant de la taxe de séjour',
                ],
                'percentage_price' => [
                    'name' => 'Pourcentage du montant',
                    'description' => 'Pourcentage de calcul pour le montant',
                ],
                'price_type' => [
                    'name' => 'Type de prix',
                    'description' => 'Type de prix',
                    'amount_name' => 'Montant',
                    'percentage_name' => 'Pourcentage',
                ],
            ],
            'price_type_name' => [
                'amount_name' => '€',
                'percentage_name' => '%',
            ],
        ],
    ],

    'city_tax_restriction' => [
        'restriction' => [
            'age_range' => [
                'name' => 'Tranche d\'âge',
                'description' => 'Tranche d\'âge pour l\'application de la taxe',
            ],
            'percentage_range' => [
                'name' => 'Limites des montants en cas de calculs en pourcentage',
                'description' => 'Limites des montants min et max du calcul en pourcentage.',
            ],
            'validity_period' => [
                'name' => 'Période de validité',
                'description' => 'Période d\'applicabilité de la taxe.',
            ],
            'price_range_night' => [
                'name' => 'Plage de prix de la chambre par nuit',
                'description' => 'Prix minimum et maximum qu\'une nuit doit avoir pour être prise en compte dans le calcul de la taxe.',
            ],
            'limit_days' => [
                'name' => 'Nuits maximales d\'applicabilité',
                'description' => 'Limite des nuits d\'application.',
            ],
            'month_max_nights' => [
                'name' => 'Limite des nuits applicables mensuellement par invité',
                'description' => 'Nombre maximal de nuits applicables par mois pour un invité.',
            ],
            'year_max_nights' => [
                'name' => 'Limite des nuits applicables annuellement par invité',
                'description' => 'Nombre maximal de nuits applicables par an pour un invité.',
            ],
            'reservation_max' => [
                'name' => 'Limite du nombre de réservations applicables annuellement par invité',
                'description' => 'Nombre maximal de réservations par an pour un invité.',
            ],
            'limit_nights' => [
                'name' => 'Limites des nuits d\'applicabilité au sein d\'une réservation',
                'description' => 'Nombre minimum et maximum de nuits dans une réservation pour appliquer la taxe.',
            ],
            'range_nights' => [
                'name' => 'Écraser le calcul en fonction des nuits de la réservation',
                'description' => 'Numéro de la nuit de début et de fin pour la réservation.',
            ],
            'adult_quote_range' => [
                'name' => 'Prix par quota d\'invité pour le séjour',
                'description' => 'Choisir la plage de quota d\'invité et le prix associé.',
            ],
        ],
    ],

    'city_tax' => [
        'city_tax_extra_text' => 'Le montant de la taxe est une estimation et peut varier en fonction des conditions établies par la réglementation en vigueur au moment du séjour.',
        'errors' => [
            'no_city_tax_configuration' => 'Taxes de séjour non configurées.',
        ],
        'warnings' => [
            'no_guests_for_accommodation' => 'Pour le logement :accommodation_name il n\'y a pas de clients, il faut donc calculer la taxe de séjour.',
            'no_tax_for_accommodation' => 'Pour le logement :accommodation_name aucune des configurations fiscales actuelles n\'est applicable.',
        ],
        'price_type' => [
            'amount_percentage' => 'Montant et pourcentage',
            'percentage' => 'Pourcentage',
            'amount' => 'Montant',
        ],
        'tax_type' => [
            'xroomextraxnightxpax' => [
                'description' => 'La taxe est calculée pour chaque hôte, pour toutes les nuitées, en pourcentage du prix de l\'hébergement + supplément (prix de l\'hébergement + supplément divisé par le nombre d\'hôtes).',
                'name' => 'Pourcentage sur l\'hébergement + les extras par personne et par nuit',
            ],
            'xbook' => [
                'description' => 'La taxe est calculée avec le somme forfaitaire unique choisi indépendamment du nombre de nuits et d’invités.',
                'name' => 'Somme forfaitaire unique',
            ],
            'xtotalroomxnightxpax' => [
                'description' => 'La taxe est calculée sur chaque hôte pour toutes les nuits d\'hébergement, en pourcentage du prix total (hébergement + extras).',
                'name' => 'Pourcentage sur le prix total (hébergement + extras) par personne et par nuit',
            ],
            'xroomxtotalnightxpax' => [
                'description' => 'La taxe est calculée pour chaque invité sur toutes les nuitées, en pourcentage du prix de l\'hébergement',
                'name' => 'Pourcentage sur le prix de l\'hébergement par personne et par nuit',
            ],
            'xroomxnightxpax' => [
                'description' => 'La taxe est calculée pour chaque hôte, pour toutes les nuitées, en pourcentage du prix de l\'hébergement (prix de l\'hébergement divisé par le nombre d\'hôtes).',
                'name' => 'Pourcentage de la taxe d\'hébergement par personne et par nuit',
            ],
            'xroomxnight' => [
                'description' => 'La taxe est calculée en pourcentage du prix de l\'hébergement pour chaque nuitée, sans tenir compte du nombre de personnes.',
                'name' => 'Pourcentage sur le prix de l\'hébergement par nuit',
            ],
            'xnight' => [
                'description' => 'La taxe est calculée sur chaque nuitée en fonction du montant choisi, sans tenir compte du nombre de personnes.',
                'name' => 'Montant par nuit',
            ],
            'xnightxpax' => [
                'description' => 'La taxe est calculée pour chaque hôte sur toutes les nuits d\'hébergement en fonction des montants choisis.',
                'name' => 'Montant par personne et par nuit',
            ],
            'xpax' => [
                'description' => 'La taxe est calculée pour chaque hôte en fonction des montants choisis, sans tenir compte du nombre de nuitées.',
                'name' => 'Montant par personne',
            ],
        ],
    ],

    'cloners' => [
        'treatments' => [
            'description' => 'Cette option vous permettra de cloner les traitements de la structure source vers la destination. En sélectionnant cette option, les traitements de la structure source seront supprimés.',
        ],
        'accommodations' => [
            'description' => 'Cette option vous permettra de cloner les chambres de la structure source. Si elle est sélectionnée avec les plans tarifaires, les liens seront créés pour refléter la structure source.',
        ],
        'priceLists' => [
            'description' => 'Cette option vous permettra de cloner les listes de prix de la structure source.',
        ],
        'ratePlans' => [
            'description' => 'Cette option vous permettra de cloner les plans tarifaires de la structure source.',
        ],
        'rates' => [
            'description' => 'Cette option vous permettra de cloner les tarifs de la structure source.',
        ],
        'modules' => [
            'description' => 'Cette option vous permettra de cloner les modules de la structure source.',
        ],
        'customers' => [
            'description' => 'Cette option vous permettra de cloner les clients de la structure source.',
        ],
        'companies' => [
            'description' => 'Cette option vous permettra de cloner les entreprises de la structure source.',
        ],
        'invoiceLayouts' => [
            'description' => 'Cette option vous permettra de cloner les profils de facturation de la structure source.',
        ],
        'addons' => [
            'description' => 'Cette option vous permettra de cloner les services supplémentaires de la structure source.',
        ],
        'availabilities' => [
            'description' => 'Cette option vous permettra de cloner les disponibilités de la structure source.',
        ],
        'childrenRanges' => [
            'description' => 'Cette option vous permettra de cloner les plages d\'âge pour les enfants de la structure source.',
        ],
        'roles' => [
            'description' => 'Cette option vous permettra de cloner les rôles de la structure source.',
        ],
        'paymentMethods' => [
            'description' => 'Cette option vous permettra de cloner les méthodes de paiement de la structure source.',
        ],
        'rules' => [
            'description' => 'Cette option vous permettra de cloner toutes les règles de la structure source.',
        ],
        'emailTemplates' => [
            'description' => 'Cette option vous permettra de cloner tous les modèles d\'email de la structure source.',
        ],
        'events' => [
            'description' => 'Cette option vous permettra de cloner tous les événements de la structure source.',
        ],
        'policies' => [
            'description' => 'Cette option vous permettra de cloner toutes les conditions d\'annulation de la structure source.',
        ],
        'cityTaxes' => [
            'description' => 'Cette option vous permettra de cloner l\'onglet : Configuration de la taxe de séjour.',
        ],
    ],

    'common' => [
        'datetime' => [
            'default' => '%d/%m/%Y %H:%M',
            'extended_phrasal_date' => '%A, %e %B %Y',
            // "Vendredi, 7 Juin 2019"
            'extended_phrasal_date_short' => '%a, %e %b %Y',
            // "Ven, 7 Juin 2019"
            'extended_phrasal_date_with_time' => '%A, %e %B %Y - %H:%M',
            // "Vendredi, 7 Juin 2019 - 18:03"
            'extended_phrasal_date_short_with_time' => '%a, %e %b %Y - %H:%M',
            // "Ven, 7 Juin 2019 - 18:03"
            'phrasal_date' => '%e %B %Y',
            // "7 Juin 2019"
            'phrasal_date_short' => '%e %b %Y',
            // "7 Juin 2019"
            'date' => '%d/%m/%Y',
            // "07/06/2019"
            'for_range' => '%d %b',
            // "04 Avril" - pour une plage de dates, ex: "04 Avr - 07 Avr"
            'time' => '%H:%M',
            // "18:03"
            'year' => 'Année',
            'month' => 'Mois',
            'day' => 'Jour',
            'time' => 'Heure',
            'dates_interval' => 'Intervalle de dates',
            'from_day' => 'De',
            'to_day' => 'À',
            'days' => 'Jours',
            'months' => [
                1 => 'Janvier',
                2 => 'Février',
                3 => 'Mars',
                4 => 'Avril',
                5 => 'Mai',
                6 => 'Juin',
                7 => 'Juillet',
                8 => 'Août',
                9 => 'Septembre',
                10 => 'Octobre',
                11 => 'Novembre',
                12 => 'Décembre',
            ],
            'months_short' => [
                1 => 'Jan',
                2 => 'Fév',
                3 => 'Mar',
                4 => 'Avr',
                5 => 'Mai',
                6 => 'Jui',
                7 => 'Jui',
                8 => 'Aoû',
                9 => 'Sep',
                10 => 'Oct',
                11 => 'Nov',
                12 => 'Déc',
            ],
            'days_of_week' => [
                'None' => 'Dimanche',
                'None' => 'Lundi',
                'None' => 'Mardi',
                'None' => 'Mercredi',
                'None' => 'Jeudi',
                'None' => 'Vendredi',
                'None' => 'Samedi',
            ],
            'days_of_week_short' => [
                'None' => 'Dim',
                'None' => 'Lun',
                'None' => 'Mar',
                'None' => 'Mer',
                'None' => 'Jeu',
                'None' => 'Ven',
                'None' => 'Sam',
            ],
            'days_of_week_initials' => [
                'None' => 'D',
                'None' => 'L',
                'None' => 'M',
                'None' => 'M',
                'None' => 'J',
                'None' => 'V',
                'None' => 'S',
            ],
        ],
        'currency' => [
            'display' => ':prefix :symbol :amount',
            'format' => '%.2n',
        ],
        'gender' => [
            'male' => 'Homme',
            'female' => 'Femme',
        ],
        'bool' => [
            'yes_no' => [
                1 => 'Oui',
                0 => 'Non',
            ],
            'true_false' => [
                1 => 'Vrai',
                0 => 'Faux',
            ],
        ],
        'exports' => [
            'customers_generic' => 'Liste des Clients',
            'companies_generic' => 'Liste des Entreprises',
            'reservations_generic' => 'Liste des Réservations',
            'reservations_invoices_opened_generic' => 'Liste des Comptes ouverts',
            'reservations_invoices_generic' => 'Liste des Factures',
            'social_archive_generic' => 'Liste des Clients avec offre déverrouillable',
            'reservations_quotes_all_generic' => 'Liste des Devis',
            'reservations_quotes_active_generic' => 'Liste des Devis Actifs',
            'reservations_quotes_revoked_generic' => 'Liste des Devis Révoqués',
            'reservations_quotes_accepted_generic' => 'Liste des Devis Acceptés',
            'reservations_quotes_expired_generic' => 'Liste des Devis Expirés',
            'reservations_quotes_draft_generic' => 'Liste des Devis Brouillons',
            'rateplans_generic' => 'Liste des Plans Tarifs, Offres et Paquets',
            'rateplans_plans_generic' => 'Liste des Plans Tarifs',
            'rateplans_offers_generic' => 'Liste des Offres',
            'rateplans_bundles_generic' => 'Liste des Paquets',
            'coupons_generic' => 'Liste des Coupons',
            'reservations_list' => 'Liste des Réservations',
            'housekeeper' => 'gouvernante_:date',
            'total_entries' => 'Total des lignes : :value',
            'meals' => 'Repas',
            'meals_plan' => 'Plan des repas',
            'city_tax' => 'Taxe de séjour',
            'reservations_guests_presences' => 'Invités présents',
            'deposits' => 'Acomptes et arrhes'
        ],
        'number_of_nights' => 'Nombre de nuits',
        'user_full_name' => 'Opérateur',
        'print_date' => 'Date d\'impression',
        'total' => 'Total',
        'totals' => 'Totaux',
        'quantity' => 'Quantité',
        'category' => 'Catégorie',
        'qty' => 'Qté',
        'discount' => 'Remise',
        'description' => 'Description',
        'wrap_up' => 'Résumé',
        'amount' => 'Montant',
        'vat' => 'TVA',
        'nic' => 'SIREN',
        'reservation' => 'Réservation',
        'nights' => '{1} 1 Nuit|[2,*] :count Nuits',
        'accommodation' => '{1} 1 Hébergement|[2,*] :count Hébergements',
        'vat_code' => 'N° TVA',
        'unmapped_addons' => 'Services supplémentaires du portail',
        'details' => 'Détails',
        'stripe_statement_descriptor' => 'Numéro de réservation : :reservationNumber - :email',
        'date' => 'Date',
        'available_soon' => 'Cette fonctionnalité sera bientôt disponible',
        'payments' => 'Paiements',
        'buyer' => 'Acheteur',
        'payment_method' => 'Méthode de paiement',
        'yes' => 'Oui',
        'no' => 'Non',
        'checkin_hour' => 'Heure d\'arrivée',
        'checkout_hour' => 'Heure de départ',
    ],

    'company' => [
        'errors' => [
            'vat_code_not_valid' => 'Le numéro de TVA saisi n\'est pas valide',
            'tax_code_not_valid' => 'Le code fiscal saisi n\'est pas valide',
        ],
        'warnings' => [
            'existing_company' => 'Il existe déjà une entreprise :company_name associée au numéro de TVA saisi',
        ],
        'export_fields' => [
            'name' => 'Nom',
            'address' => 'Adresse',
            'vat_code' => 'Numéro de TVA',
            'zip_code' => 'Code Postal',
            'email' => 'Email',
            'telephone' => 'Téléphone',
            'state' => 'Région',
            'county' => 'Département',
            'country' => 'Pays',
            'city' => 'Ville',
            'tax_code' => 'Code fiscal',
            'nick_name' => 'Surnom',
        ],
        'import' => [
            'validations' => [
                'vat_code_unique' => 'Une entreprise avec le même numéro de TVA existe déjà',
                'vat_code_required' => 'Le champ numéro de TVA est obligatoire',
                'name_required' => 'Le champ raison sociale est obligatoire',
                'nick_name_required' => 'Le champ surnom est obligatoire',
                'email' => 'Le champ email ne contient pas un email valide',
                'pec' => 'Le champ PEC ne contient pas un email valide',
            ],
        ],
        'fields' => [
            'company_id' => 'identifiant de l’entreprise'
        ],
    ],

    'content_api' => [
        'bank_transfer' => 'Accepte virement bancaire',
        'bank_transfer_note' => 'Notes pour le paiement bancaire (MAX 500 caractères)',
        'checkin_hour' => 'Heure d\'arrivée',
        'checkout_hour' => 'Heure de départ',
        'children_allowed' => 'Enfants admis',
        'pets_allowed' => 'Animaux admis',
        'smoking_allowed' => 'Fumeurs autorisés',
        'max_adults_number' => 'Nombre maximum d\'adultes',
        'max_guests_number' => 'Nombre maximum d\'invités',
        'minimum_age' => 'Âge minimum',
        'percent_payment_at_booking' => '% de paiement lors de la réservation',
        'remaining_payment_type' => 'Paiement restant',
        'remaining_payment_type_at_checkin_label' => 'Paiement à l\'arrivée',
        'remaining_payment_type_at_checkin_description' => 'Le paiement restant sera demandé lors de l\'arrivée',
        'remaining_payment_type_before_checkin_label' => 'Paiement X jours avant l\'arrivée',
        'remaining_payment_type_before_checkin_description' => 'Le paiement restant sera demandé X jours avant l\'arrivée',
        'remaining_payment_type_before_checkin_day' => 'Nombre de jours avant l\'arrivée',
        'rental_document_upload' => 'Téléchargement du document de location',
        'advertise_name' => 'Nom de l\'annonceur',
        'merchant_name' => 'Nom du commerçant',
        'managment_applies_guest_value' => 'Frais de gestion des invités',
        'managment_applies_guest_type' => 'Type de frais de gestion des invités',
        'managment_applies_pets_value' => 'Frais de gestion des animaux',
        'managment_applies_value' => 'Frais de gestion',
        'management_energy_value' => 'Frais de gestion de l\'énergie',
        'management_energy_type' => 'Type de frais de gestion de l\'énergie',
        'managment_applies_pets_type' => 'Type de frais de gestion des animaux',
        'x_night' => 'Par nuit',
        'x_stay' => 'Par séjour',
    ],

    'coupons' => [
        'refundable' => [
            '0' => 'Non remboursable',
            '1' => 'Remboursable',
        ],
        'export_fields' => [
            'code' => 'Code',
            'quantity' => 'Quantité',
            'discount' => 'Réduction',
            'date_from' => 'De',
            'date_to' => 'À',
            'type' => 'Type',
            'min_expense' => 'Dépense minimale',
            'min_stay' => 'Séjour min.',
            'max_stay' => 'Séjour max.',
            'valid_days' => 'Jours de validité',
        ],
    ],

    'credit_card_type' => [
        'fields' => [
            'model_name' => 'Carte de Crédit',
        ],
    ],

    'customer' => [
        'errors' => [
            'reservationExists' => 'Il existe des réservations ou devis associés.',
            'guestExist' => 'Il existe des invités associés.',
            'documentExists' => 'Un document du même type existe déjà dans l\'archive.',
            'privacyCheckExists' => 'La politique de confidentialité a déjà été acceptée par le client.',
            'customerNotFound' => 'Client non trouvé.',
            'guestExists' => 'Client configuré en tant qu\'invité dans des réservations actives.',
            'tax_code_not_valid' => 'Le code fiscal saisi n\'est pas valide.',
            'birthday_date_major_than_now' => 'La date de naissance ne peut pas être postérieure à la date d\'aujourd\'hui',
        ],
        'fields' => [
            'birthday_date' => 'date de naissance de l\'invité',
            'sex' => 'sexe de l\'invité',
            'address' => 'adresse de l\'invité',
            'zip_code' => 'code postal de l\'invité',
            'email' => 'email de l\'invité',
            'telephone' => 'téléphone de l\'invité',
            'name' => 'nom de l\'invité',
            'surname' => 'prénom de l\'invité',
            'model_name' => 'invité',
            'language_id' => 'langue'
        ],
        'export_fields' => [
            'name' => 'Nom',
            'surname' => 'Prénom',
            'birthday_date' => 'Date de naissance',
            'sex' => 'Sexe',
            'note' => 'Notes',
            'city' => 'Ville',
            'county' => 'Province',
            'state' => 'Région',
            'country' => 'Pays',
            'address' => 'Adresse',
            'zip_code' => 'Code postal',
            'email' => 'Email',
            'telephone' => 'Téléphone',
            'fax' => 'Fax',
            'facebook' => 'Facebook',
            'linkedin' => 'Linkedin',
            'twitter' => 'Twitter',
            'web_address' => 'Site web',
            'birth_city_name' => 'Ville de naissance',
            'birth_state_name' => 'État de naissance',
            'birth_state' => 'Région de naissance',
            'residence_city' => 'Résidence - Ville',
            'residence_county' => 'Résidence - Province',
            'residence_state' => 'Résidence - Région',
            'residence_country' => 'Résidence - Pays',
            'residence_address' => 'Résidence - Adresse',
            'residence_zip_code' => 'Résidence - Code postal',
            'billing_city' => 'Facturation - Ville',
            'billing_county' => 'Facturation - Province',
            'billing_state' => 'Facturation - Région',
            'billing_country' => 'Facturation - Pays',
            'billing_address' => 'Facturation - Adresse',
            'billing_zip_code' => 'Facturation - Code postal',
            'promotion_check' => 'Newsletter',
            'privacy_check' => 'RGPD',
            'reservations_count' => 'Réservations',
            'type' => 'Type',
            'newsletter' => 'Newsletter',
            'GDPR' => 'RGPD',
        ],
        'import' => [
            'validations' => [
                'nic_unique' => 'Un client avec ce code fiscal existe déjà.',
                'name_required' => 'Le champ nom est obligatoire.',
                'sex' => 'Le champ sexe n\'est pas valide, les valeurs autorisées sont non défini, homme, femme.',
                'surname_required' => 'Le champ prénom est obligatoire.',
                'email' => 'Le champ email ne contient pas un email valide.',
                'birthday_date_date_format' => 'Le champ date de naissance n\'est pas correctement formaté.',
                'document_type' => 'Le type de document n\'existe pas.',
                'birth_country_not_valid' => 'Le champ pays de naissance n\'est pas valide.',
                'birth_city_not_valid' => 'Le champ ville de naissance n\'est pas valide.',
                'citizenship_country_not_valid' => 'Le champ nationalité n\'est pas valide.',
                'residence_country_not_valid' => 'Le champ pays de résidence n\'est pas valide.',
                'residence_city_not_valid' => 'Le champ ville de résidence n\'est pas valide.',
                'nationality_country_not_valid' => 'Le champ nationalité n\'est pas valide.',
                'language' => 'Le champ langue n\'est pas valide, veuillez entrer le format iso en minuscule (exemples : fr, en).',
            ],
            'alredy-in-progress' => 'L\'importation est toujours en cours, veuillez patienter jusqu\'à la fin et réessayer.',
        ],
    ],

    'daily_closure' => [
        'daily_title' => 'Clôture quotidienne',
        'department' => 'Département',
        'production' => 'Production',
        'total' => 'Total',
        'property' => 'Propriété',
        'receipt' => 'Reçu',
        'name' => 'Nom',
        'invoice' => 'Facture',
        'amount' => 'Solde',
        'guests' => 'Invités',
        'accommodation' => 'Chambres',
        'empty_documents' => 'Aucun document émis ou reçu pour la période sélectionnée',
        'empty_payments' => 'Aucun paiement émis ou reçu pour la période sélectionnée',
        'export_fields' => [
            'production_department' => 'Production par département',
            'production_treatments' => 'Production par traitement',
            'production_accommodations' => 'Production par hébergement',
            'occupancy' => 'Occupation',
            'documents' => 'Documents du :date_from|Documents du :date_from au :date_to',
            'payments' => 'Paiements du :date_from|Paiements du :date_from au :date_to',
            'summary' => 'Résumé caisse (:date_from)|Résumé caisse (:date_from - :date_to)',
            'accommodations_sold' => 'Chambres vendues',
            'sold_nights' => 'Nuits vendues',
            'unsold_nights' => 'Nuits invendues',
            'penalty_nights' => 'Nuits pénalisées',
            'accommodations_available' => 'Chambres disponibles',
            'date' => 'Date',
            'income' => 'Recette',
            'outcome' => 'Dépenses',
            'occupancy' => 'Occupation',
            'payment_method' => 'Méthode de paiement',
            'type' => 'Type',
            'reversal_receipt' => 'Annulation de reçu',
            'number' => 'Numéro',
            'in' => 'Entrées',
            'out' => 'Sorties',
            'intestatary' => 'Titulaire',
            'name' => 'Nom',
            'modality' => 'Mode',
            'note' => 'Notes',
            'taxable' => 'Taxable',
            'vat_quote' => 'TVA',
            'treatment' => 'Traitement',
            'average_revenue' => 'Revenu moyen par invité',
            'adr' => 'ADR',
            'revpar' => 'RevPar',
            'reservations' => 'Réservations',
            'no_show' => 'Non-présentation',
            'confirmed' => 'Confirmées',
            'cancelled' => 'Annulées',
            'optionable' => 'Options',
            'expired' => 'Expirées',
            'unknown' => 'Inconnu',
            'checkin' => 'Arrivées',
            'checkout' => 'Départs',
            'in_house' => 'Séjour en cours',
            'attendance' => 'Présences',
            'absolute_guests' => 'Invités absolus',
        ],
    ],

    'daily_summary' => [
        'daily_summary' => 'Résumé quotidien',
        'accommodation' => 'Chambre',
        'accommodation_type' => 'Type de chambre',
        'name_and_surname' => 'Nom et prénom',
        'stay' => 'Séjour',
        'guests' => 'Invités',
        'treatment' => 'Traitement',
        'channel' => 'Canal',
        'payment_details' => 'Détails du paiement',
        'notes' => 'Notes',
        'adults' => 'Adultes',
        'children' => 'Enfants',
        'total' => 'Total',
        'arrivals' => 'Arrivées',
        'departures' => 'Départs',
        'in_home' => 'En arrêt',
        'nights' => 'Nuits',
        'paid' => 'Payé',
        'to_pay' => 'À payer',
        'no_reservations_found' => 'Aucune réservation trouvée pour cette date',
        'daily_summary_of_date' => 'Résumé quotidien du :date',
    ],

    'deposits' => [
        'export_fields' => [
            'property' => 'Propriété',
            'number' => 'Numéro',
            'deposit_number' => 'Numéro de dépôt',
            'document_number' => 'Numéro de document',
            'date' => 'Date',
            'registration_date' => 'Date d\'enregistrement',
            'type' => 'Type',
            'amount' => 'Montant',
            'amount_available' => 'Montant disponible',
            'amount_used' => 'Montant utilisé',
            'reservation_number' => 'ID Réservation',
            'pos' => 'POS',
            'description' => 'Description',
            'buyer' => 'Payeur',
            'reservation_id' => 'ID Réservation',
            'used_amount' => 'Montant utilisé',
            'user_pay' => 'Payeur',
            'reservation' => 'Réservation',
            'payment_method' => 'Méthode de paiement',
            'arrival_date' => 'Date d\'arrivée',
            'departure_date' => 'Date de départ',
            'deposit' => 'Dépôt',
            'part_payment' => 'Acompte',
            'stay' => 'Séjour',
        ],
    ],

    'email_suppression_list' => [
        'reason_types' => [
            'BOUNCE' => 'Échec de la livraison',
            'COMPLAINT' => 'Signalé comme SPAM',
        ],
        'errors' => [
            'NotFoundException' => 'Email non trouvé',
            'BadRequestException' => 'Paramètres de la demande non valides',
            'TooManyRequestsException' => 'Trop de demandes effectuées',
            'TooManyRequestException' => 'Trop de demandes effectuées',
        ],
    ],

    'emails' => [
        'multiple_sessions' => [
            'subject' => 'Alerte de sécurité : plusieurs appareils connectés à votre compte',
            'body' => "Bonjour :user_first_name,<br />nous avons détecté des connexions depuis plusieurs appareils sur votre compte. Nous vous recommandons de vérifier les sessions actuellement actives :",
            'summary_reset' => 'Si vous ne reconnaissez pas ces appareils, <a href=":recoveryPasswordLink" target="_blank">nous vous recommandons de changer immédiatement votre mot de passe</a> pour protéger votre compte.',
            'device' => 'Appareil',
            'place' => 'Lieu',
            'date_hour' => 'Date et heure',
            'unknown' => 'Inconnu',
            'logout' => 'Vous pouvez également <a href=":logoutAllDevice" target="_blank">vous déconnecter</a> de tous les appareils depuis Profil > Sécurité et accès.',
        ],
        'general' => [
            'link_preview' => 'Cliquez ici pour la version imprimable',
            'additionals_informations' => 'Informations supplémentaires',
            'automatic_email_message' => 'Cet email est envoyé automatiquement, merci de ne pas répondre à cet adresse.',
            'message' => 'Message',
        ],
        'reservation_confirmed' => [
            'subject' => 'Réservation numéro #:reference_number',
            'reservation_confirm' => 'Votre réservation',
            'reply' => 'Répondre',
            'tax' => 'Taxes',
            'reservation_number' => 'numéro',
            'thanks' => 'Merci',
            'view_quote' => 'Cliquez ici pour voir le devis',
            'show_detail' => '<a href=":showDetailsReservation">Cliquez ici pour afficher la réservation</a>',
            'confirm_reservation_with_bank_transfer_suggestion' => 'Pour compléter la réservation, nous vous recommandons de finaliser le paiement dès que possible',
            'your_reservation' => 'Votre réservation pour',
            'is_confirmed' => 'est confirmée',
            'ti_aspettiamo_il' => 'Nous vous attendons le',
            'city_tax' => 'Taxe de séjour',
            'reservation_summary' => 'Résumé de la réservation',
            'nights' => 'Nuit|Nuits',
            'accommodations' => 'Logement|Logements',
            'adults' => 'adulte|adultes',
            'childrens' => 'enfant|enfants',
            'reservation_confirmed_with_stripe' => 'La réservation a été confirmée en utilisant la passerelle de paiement Stripe',
            'total_reservation' => 'Total de la réservation',
            'price_payed' => 'Montant payé',
            'price_to_pay' => 'Montant à payer',
            'payment_method' => 'Méthode de paiement',
            'other_request' => 'Spécifications et autres demandes',
            'banktransfer_informations' => 'Coordonnées bancaires',
            'printable_link' => 'Cliquez ici pour la version imprimable',
            'other_operations' => 'Autres opérations',
            'checkin' => 'Effectuer l\'enregistrement en ligne',
            'modify_reservation' => 'Modifier la réservation',
            'cancel_reservation' => 'Annuler la réservation',
            'additional_informations' => 'Informations supplémentaires',
            'contability_informations' => 'Dès réception du reçu de <b>:price_deposit</b>, nous procéderons à la confirmation de la réservation. Pour accélérer l\'opération, nous vous conseillons de nous envoyer une copie de la disposition avec le numéro CRO.',
            'checkin_online_pin' => 'Votre code pour effectuer le <a style="color: #8f743f; text-decoration: underline !important;" target="_blank" href=":link">Check-In</a> en ligne est ',
            'pin' => 'Pin',
        ],
        'reservation_request_avail' => [
            'subject' => 'Demande de disponibilité pour :property_name  (:arrival_date - :departure_date)',
            'reservation_confirm' => 'Demande de disponibilité',
            'reply' => 'Répondre',
            'tax' => 'Taxes',
            'reservation_number' => 'numéro',
            'thanks' => 'Merci',
            'view_quote' => 'Cliquez ici pour voir le devis',
            'show_detail' => 'Cliquez ici pour afficher la réservation',
            'show_detail_avail' => 'Cliquez ici pour afficher la demande de disponibilité',
            'your_request_avail' => 'Votre demande de disponibilité pour',
            'is_confirmed' => 'a été envoyée',
            'invalid_reservation' => 'Veuillez noter que cette demande n\'a pas valeur de réservation tant qu\'elle n\'a pas été confirmée.',
            'invalid_reservation_property' => 'Cette demande n\'a pas valeur de réservation, le client attend votre confirmation',
            'receive_news' => 'Vous recevrez nos nouvelles dans les plus brefs délais.',
            'city_tax' => 'Taxe de séjour',
            'reservation_summary' => 'Résumé de la demande',
            'nights' => 'Nuit|Nuits',
            'accommodations' => 'Logement|Logements',
            'adults' => 'adulte|adultes',
            'childrens' => 'enfant|enfants',
            'total_reservation' => 'Total de la réservation',
            'price_payed' => 'Montant payé',
            'price_to_pay' => 'Montant à payer',
            'payment_method' => 'Méthode de paiement',
            'other_request' => 'Spécifications et autres demandes',
            'printable_link' => 'Cliquez ici pour la version imprimable',
            'other_operations' => 'Autres opérations',
            'additional_informations' => 'Informations supplémentaires',
        ],
        'reservation_cancelled_from_user' => [
            'subject' => 'Réservation annulée (#:reference_number)',
            'body_1' => 'Bonjour,<br>Ce courriel automatique vous confirme l\'annulation de la réservation n.<b>:reference_number</b> effectuée le <b>:booked_at</b>.',
            'body_2' => '<b>Résumé de la réservation</b><br>
                 <b>:name :surname</b> (du <b>:arrival_date</b> au <b>:departure_date</b>)<br>
                 <b>Chambre:</b> :reservation_accommodations<br>
                 <b>Invités: </b> :total_guests<br>
                 <b>Total: </b> :currency  :total_price',
            'body_policy_no_penalty' => 'Conformément aux <b>Conditions d\'annulation</b>, aucune pénalité ne s\'applique.',
            'body_policy_penalty' => 'Conformément aux <b>Conditions d\'annulation</b>, une pénalité de :currency :penalty_value s\'applique.',
            'body_3' => 'Pour plus d\'informations, n\'hésitez pas à nous contacter.',
        ],
        'property_reservation_new' => [
            'subject' => 'Nouvelle réservation de :channel_name - :property_name (#:reference_number)',
        ],
        'property_reservation_modified' => [
            'subject' => 'Modification de réservation de :channel_name (#:reference_number)',
        ],
        'invoice_rejected' => [
            'subject' => 'Facture :number_complete du :invoice_date rejetée par le SDI',
            'body' => 'La facture numéro <b>:number_complete</b> a été rejetée par le SDI pour la raison suivante : <b>:rejected_reason</b>',
        ],
        'invoice_received' => [
            'subject' => 'Facture reçue :document_number du :document_date de :sender_name',
            'body' => 'La facture numéro <b>:document_number</b> du <b>:document_date</b> a été reçue de la part de <b>:sender_name</b>',
        ],
        'document_default_email' => [
            'body' => 'Cher client,<br>Voici les informations relatives au :document_type :document_number du :document_date.<br>Vous trouverez ci-joint une copie du document.<br><br>Nous vous adressons nos salutations distinguées,<br>:sender_name',
        ],
        'suspend_email_reminder' => [
            'subject' => '{{% invoice.type %}} n. {{% invoice.number_complete %}}',
            'body' => 'Cher client,<br>Il semble que la {{% invoice.type %}} {{% invoice.number_complete %}} du {{% invoice.invoice_date %}} d\'un montant de {{% invoice.total %}} n\'ait pas encore été réglée.<br><br>Nous vous prions de bien vouloir régulariser votre situation dans les plus brefs délais.<br>Vous trouverez ci-joint une copie du document.<br><br>Si vous avez déjà effectué le paiement, veuillez ignorer ce message.<br><br>Nous vous adressons nos salutations distinguées,<br>{{% reservation.property_name %}}',
        ],
        'property_reservation_cancelled' => [
            'subject' => 'Réservation annulée de :channel_name (#:reference_number)',
            'body_1' => 'La réservation <b>:xml_reservation_id</b> à nom de <b>:name :surname</b> (du <b>:arrival_date</b> au <b>:departure_date</b>) a été annulée sur le canal <b>:channel_name</b> concernant les chambres de la structure <b>:property_name</b>:<br>:accommodations_lists',
            'body_2' => 'Pour voir tous les détails de la réservation <a href="https://app.beddy.io/reservation/:reservation_id">cliquez ici</a>',
        ],
        'property_reservation_banktransfer_cancelled' => [
            'subject' => 'Réservation annulée par :channel_name (#:reference_number) pour non-paiement',
            'body_1' => 'Une réservation a été annulée automatiquement en raison d\'un non-paiement par virement bancaire.<br /><br />
                    <u>Voici les détails de l\'annulation concernée :</u><br /><br />
                    Structure : <b>:property_name</b><br />
                    Portail d\'origine : :channel_name<br />
                    ID Réservation/référence : :xml_reservation_id<br />
                    Client : <b>:name :surname</b><br />
                    Période de séjour : du <b>:arrival_date</b> au <b>:departure_date</b><br />
                    Chambres concernées : <br>:accommodations_lists<br />',
            'body_2' => 'Pour voir tous les détails de la réservation <a href="https://app.beddy.io/reservation/:reservation_id">cliquez ici</a>',
        ],
        'past_connect_reservation_cancelled' => [
            'subject' => 'Alerte : réservation annulée mais non présente sur Beddy, veuillez vérifier la disponibilité',
            'body' => 'Une réservation non présente sur Beddy a été annulée, <strong>une vérification manuelle est donc nécessaire</strong> car il est possible que la disponibilité des logements concernés ne soit pas mise à jour.
                    <br>
                    Une réservation peut être manquante pour deux raisons :
                    <br>
                    1. La réservation précède la connexion du Channel Manager : tous les portails ne permettent pas de récupérer les anciennes réservations (ou autorisent une récupération limitée dans le temps).
                    <br>
                    2. Le client a annulé immédiatement la réservation, dans ce cas, il se peut que le portail nous envoie l\'annulation sans nous avoir envoyé la réservation correspondante, et Beddy n\'a donc pas de référence.
                    <br>
                    <br>
                    <strong>Voici les détails de l\'annulation concernée :</strong>
                    <br>
                    Portail d\'origine : :channel_name
                    <br>
                    ID Réservation : :xml_reservation_id
                    <br>
                    Effectuée le : :booked_at
                    <br>
                    Client : :customer_name :customer_surname
                    <br>
                    <br>
                    <strong>Que faire :</strong>
                    <br>
                    - Vérifiez sur l\'extranet du portail la présence de la réservation et de son annulation.
                    <br>
                    - Vérifiez la disponibilité des logements sur Beddy et sur l\'extranet du portail et, si nécessaire, mettez-les à jour via le Channel Manager.
                    <br><br>
                    Cordialement',
        ],
        'property_activation' => [
            'subject' => 'Compte :product_name - :property_name',
            'footer' => 'Pour toute information supplémentaire, notre service client est à votre disposition du lundi au vendredi de 10h00 à 14h00 et de 15h30 à 18h00.
                    En vous remerciant d\'avoir choisi :product_name, nous vous adressons
                    <br><br>
                    Cordialement',
        ],
        'users' => [
            'changedPassword' => [
                'subject' => 'Beddy - Votre mot de passe a été modifié',
                'summary' => 'Cher/Chère <b>:firstname</b>,<br>nous vous informons que le mot de passe de votre compte <b>Beddy</b> a été modifié avec succès.',
                'errors' => [
                    'unexpectedNotice' => 'Si vous n’êtes pas à l’origine de ce changement, veuillez contacter l’administrateur de l’établissement et/ou notre service d’assistance.<br><br>
                Cordialement,<br>
                L’équipe Beddy',
                ],
            ],
            'attachment' => [
                'subject' => 'Vous avez été associé à un nouveau bien sur Beddy',
                'summary' => 'Cher <b>:firstname</b>,<br>Votre compte Beddy a été associé à un nouveau bien.<br><br>Voici les détails d’accès :',
                'property' => 'Bien',
                'roleAssigned' => 'Rôle attribué',
                'loginDetails' => [
                    'login' => 'Vous pouvez toujours accéder à ce bien via app.beddy.io avec les mêmes identifiants.',
                    'helpContactInfo' => 'En cas de besoin, vous pouvez contacter :',
                    'master' => 'l’administrateur du bien : :masterEmail',
                    'support' => 'Support Beddy: <a href="mailto: :supportEmail">:supportEmail</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'Si vous n’attendiez pas cette communication ou pensez qu’il s’agit d’une erreur, veuillez ne pas compléter l’activation et contacter l’administrateur du bien et/ou notre support.',
                ],
            ],
            'activation' => [
                'subject' => 'Vous avez été invité sur Beddy – Activez votre accès',
                'summary' => 'Cher/Chère <b>:firstname</b>,<br> un compte Beddy a été créé pour vous.<br><br> Voici vos informations :',
                'username' => 'Nom d’utilisateur',
                'email' => 'E-mail',
                'toDo' => 'Pour <b>activer votre compte</b>, vous devez définir votre <b>mot de passe</b>.',
                'button' => '<a href=":creationPasswordLink">Créer le mot de passe</a>',
                'expiration' => 'Le lien d’activation est valable pendant 5 jours.',
                'contacts' => [
                    'helpContactInfo' => 'En cas de besoin, vous pouvez contacter :',
                    'master' => 'l’administrateur de l’établissement : ',
                    'support' => 'le support Beddy : <a href=\"mailto:support@beddy.io\">support@beddy.io</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'Si vous n’attendiez pas ce message ou pensez qu’il s’agit d’une erreur, veuillez ne pas compléter l’activation et contacter l’administrateur de l’établissement et/ou notre support.',
                    'uncompletedRegistration' => 'Inscription non terminée : le compte n’est pas encore actif. Vérifiez l’e-mail que nous vous avons envoyé et définissez le mot de passe pour l’activer.',
                ]
            ],
            'passwordreset' => [
                'subject' => 'Procédure de réinitialisation du mot de passe pour le compte :product_name',
                'body' => 'Bonjour <b>:first_name!</b>
                    <br/>
                     Vous avez reçu cet email car vous avez demandé à modifier le mot de passe pour votre compte :product_name,
                     <br><br>
                     Pour changer votre mot de passe, cliquez <a href=":link_reset">ici</a> dans les 30 minutes.
                     <br>
                     Si ce n\'était pas vous qui avez demandé la modification du mot de passe ou si vous ne souhaitez pas poursuivre la modification, ignorez cet email.
                     <br>
                    Cordialement.',
            ],
            'password_expiration_notify' => [
                'subject' => 'Avis d’expiration du mot de passe du compte Beddy',
                'body' => 'Cher/Chère <b>:name :surname</b>,
                <br/>
                Nous vous informons que le mot de passe associé à votre compte Beddy expirera dans <b>:days jours</b>. Nous vous invitons à le mettre à jour dès que possible depuis la section <a href=":profile" target="_blank">Profil</a>.
                <br><br>
                Si vous avez oublié votre mot de passe actuel, vous pouvez le réinitialiser en cliquant sur <i><a href=":resetPassword" target="_blank">Problèmes de connexion?</a></i> sur la page de <a href=":login" target="_blank">connexion</a>.
                <br>
                <br>
                Cordialement,<br>
                L’équipe Beddy',
            ],
        ],
        'bank_transfer_reminder' => [
            'subject' => 'Réservation numéro :reference_number - Rappel virement bancaire',
            'body' => 'Cher(e) :booker_name :booker_surname,<br>
                    En ce qui concerne votre réservation :reference_number du :booked_at, nous vous rappelons qu\'afin de la confirmer, nous attendons votre paiement de :price.
                    <br><br>
                    Voici les coordonnées bancaires pour le paiement :<br>
                    <i>:bank_text</i>
                    <br><br>
                    Si nous ne recevons pas de nouvelles de votre part dans les prochains jours, la réservation sera automatiquement annulée.
                    <br><br>
                    Si vous avez déjà effectué le paiement, veuillez ignorer cette communication.<br>
                    Pour plus d\'informations, n\'hésitez pas à nous contacter.<br>',
            'footer' => 'Cordialement,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'bank_transfer_cancelled' => [
            'subject' => 'Réservation annulée numéro :reference_number',
            'body' => 'Cher(e) :booker_name :booker_surname,<br>
                    N\'ayant pas reçu de nouvelles de votre part, nous vous informons que la réservation :reference_number du :booked_at a été annulée.
                    <br><br>
                    Pour plus d\'informations, n\'hésitez pas à nous contacter.<br>',
            'footer' => 'Cordialement,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'cutoff_errors' => [
            'subject' => 'Erreur d\'envoi cutoff - :property_name',
            'body_1' => 'Pour la structure <b>:property_name</b>, nous avons rencontré les erreurs suivantes :<br><br>',
            'footer' => 'Cordialement.',
        ],
        'deactivate_properties' => [
            'first_notice' => [
                'subject' => 'Renouvellement du compte Beddy',
                'body_1' => 'Cher client,<br><br>
                         Nous sommes heureux de vous confirmer le renouvellement de votre compte Beddy et de tous les services associés.<br><br>',
                'body_2' => 'Dans les prochains jours, vous recevrez la facture pour l\'utilisation du logiciel Beddy (du :date_from au :date_to) via le canal SDI. Nous vous demandons gentiment de nous envoyer une copie du paiement effectué pour faciliter son identification.<br><br>
                         Vos informations :',
                'body_3' => 'Pour toute information, notre service client est à votre disposition du lundi au vendredi de 10h00 à 14h00 et de 15h30 à 18h00.',
                'footer' => 'En vous remerciant d\'avoir choisi Beddy, nous vous adressons<br><br>Distinguées salutations,',
            ],
            'second_notice' => [
                'subject' => 'Renouvellement du compte Beddy',
                'body_1' => 'Cher client,<br><br>
                         Nous sommes heureux de vous confirmer à nouveau le renouvellement de votre compte Beddy et de tous les services associés.<br><br>
                         Bientôt, vous recevrez la facture pour l\'utilisation du logiciel Beddy (du :date_from au :date_to) via le canal SDI.<br><br>
                         Vos informations :',
                'body_2' => 'Pour toute information, notre service client est à votre disposition du lundi au vendredi de 10h00 à 14h00 et de 15h30 à 18h00.<br><br>
                         En vous remerciant d\'avoir choisi Beddy, nous vous adressons<br><br>Distinguées salutations,',
            ],
        ],
        'reservation_quote_expire' => [
            'subject' => 'Votre devis a expiré',
            'body_1' => 'Cher(e) :customer_name :customer_surname,<br>
                     Nous sommes désolés de vous informer que le devis que vous nous avez demandé le :creation_date vient d\'expirer.',
            'body_2' => '<br><br>Pour plus d\'informations, n\'hésitez pas à nous contacter.',
            'footer' => '<br><br>Cordialement,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'reservation_quote_expire_property' => [
            'subject' => 'Votre devis a expiré',
            'body_1' => 'Le devis pour le client :customer_name :customer_surname que vous avez créé le :creation_date vient d\'expirer.',
            'footer' => '<br><br>Cordialement.',
        ],
        'housekeeper_maintainer' => [
            'subject' => 'Nouveau rapport de maintenance pour le logement :accommodation_name',
            'body' => 'Un nouveau rapport de maintenance a été soumis pour le logement <b>:accommodation_name</b> (<b>:tableau_label</b>). Voici tous les détails : <br><br><b>Titre :</b> :title <br><br><b>Description :</b> :description',
        ],
        'payments_timetable' => [
            'stripe_not_active' => [
                'subject' => 'Échec de l\'encaissement du paiement automatique (ID : :payment_timetable_id - :scheduled_date) - Stripe non actif',
                'body' => 'Il n\'a pas été possible de procéder à l\'encaissement du paiement automatique pour l\'ID :payment_timetable_id du :scheduled_date - Réservation :reservation_reference_number au nom de :booker_name :booker_surname car aucun compte Stripe actif n\'est disponible pour effectuer l\'encaissement.',
            ],
            'no_credit_card' => [
                'subject' => 'Échec de l\'encaissement du paiement automatique (ID : :payment_timetable_id - :scheduled_date) - Carte de crédit non présente',
                'body' => 'Il n\'a pas été possible de procéder à l\'encaissement du paiement automatique pour l\'ID :payment_timetable_id du :scheduled_date - Réservation :reservation_reference_number au nom de :booker_name :booker_surname car aucune carte de crédit n\'est disponible pour effectuer l\'encaissement.',
            ],
            'charge_failed' => [
                'subject' => 'Échec de l\'encaissement du paiement automatique (ID : :payment_timetable_id - :scheduled_date)',
                'body' => 'Il n\'a pas été possible de procéder à l\'encaissement du paiement automatique pour l\'ID :payment_timetable_id du :scheduled_date - Réservation :reservation_reference_number au nom de :booker_name :booker_surname pour la raison suivante : :error_description',
            ],
            'payment_exceeded' => [
                'subject' => 'Échec de l\'encaissement du paiement automatique (ID : :payment_timetable_id - :scheduled_date) - Paiement supérieur au montant total de la réservation',
                'body' => 'Il n\'a pas été possible de procéder à l\'encaissement du paiement automatique pour l\'ID :payment_timetable_id du :scheduled_date - Réservation :reservation_reference_number au nom de :booker_name :booker_surname car le paiement dépasse le montant total de la réservation.',
            ],
            'payment_require_action' => [
                'subject' => 'Échec du prélèvement automatique (ID : :payment_timetable_id - :scheduled_date) - 3D Secure requis',
                'body' => 'Le prélèvement automatique a échoué en raison d’une demande 3D Secure (ID : :payment_timetable_id, le :scheduled_date - Réservation :reservation_reference_number au nom de :booker_name :booker_surname).',
            ],
            'payment_require_action_send_request' => [
                'subject' => 'Échec du prélèvement automatique (ID : :payment_timetable_id - :scheduled_date) - Paiement en attente de confirmation',
                'body' => "Le prélèvement automatique a échoué en raison d’une demande 3D Secure (ID : :payment_timetable_id, le :scheduled_date - Réservation :reservation_reference_number au nom de :booker_name :booker_surname).\nUne demande de paiement a été envoyée au client par e-mail.",
            ],
        ],
        'reservation_quote_expire_days_before' => [
            'subject' => 'Votre devis expire bientôt',
            'body_1' => 'Cher(e) :customer_name :customer_surname,<br>
                     Nous vous informons que le <a href=":quote_link">devis</a> que vous nous avez demandé expirera le :expire_date',
            'body_2' => '<br><br>Pour plus d\'informations, n\'hésitez pas à nous contacter.',
            'footer' => '<br><br>Cordialement,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'email_auth_verification' => [
            'body' => 'Cher(e) :name :surname,<br/> <br/> voici le code PIN que vous avez demandé pour confirmer l\'accès à votre compte Beddy : <strong>:pin</strong> <br/> <br/> Votre PIN expirera à :expire_time',
        ],
        'user_update_email_verification_code' => [
            'body' => 'Cher(e) :name :surname,<br/> <br/> pour finaliser la demande de modification de votre compte Beddy, entrez ce PIN : <strong>:pin</strong>',
            'warning' => 'Si vous n\'avez pas demandé cette modification, nous vous conseillons de <a href=":recoveryPasswordLink" target="_blank">changer immédiatement votre mot de passe</a> pour protéger votre compte. <br/> <br/>
                      De plus, vous pouvez vous déconnecter de tous vos appareils depuis le menu <a href=":logoutAllDevice" target="_blank"> Profil > Protection et accès</a>.',
        ],
        'user_update_email_confirmed' => [
            'subject' => 'Votre adresse email a été mise à jour',
            'body' => 'Cher(e) :name :surname,<br/> <br/> l\'email associée à votre compte Beddy a bien été mise à jour.<br/> <br/>Dès maintenant, vous recevrez toutes les communications à cette adresse.',
        ],
        'checkin_online_complete' => [
            'subject' => 'Check-in en ligne effectué - :reference_number',
            'body_1' => 'Cher(e) <b>:property_name</b>, <br/><br /> <b>:main_guest_name :main_guest_surname</b> vient de compléter son check-in en ligne pour la réservation suivante :<br/>',
            'reservation_number' => 'Réservation #:reference_number',
            'view_guests' => 'Vérifier les informations des invités',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'subject' => 'Changement de statut de nettoyage pour le logement :cleanable_name - :accommodation_name',
            'body' => ':user_name a modifié le statut de nettoyage en <b>:clean_status</b> le <b>:reference_date</b> pour le logement <b>:cleanable_name</b> (:accommodation_name) de la structure :property_name.',
        ],
        'reservation_option_expired' => [
            'subject' => 'Réservation en option expirée (#:reference_number)',
            'body' => 'La réservation numéro <b>:reference_number</b> au nom de <b>:booker_name :booker_surname</b> avec une arrivée le <b>:arrival_date</b> et un départ le <b>:departure_date</b> a expiré.',
        ],
        'order_payment_release' => [
            'subject' => 'Préautorisation libérée (#:reference_number)',
            'body' => 'La préautorisation de paiement pour la réservation numéro <b>:reference_number</b> (du <b>:arrival_date</b> au <b>:departure_date</b>) au nom de <b>:customer_name :customer_surname</b> a été libérée.',
        ],
        'sca_authorized' => [
            'subject' => 'SCA autorisée (#:reference_number)',
            'body' => 'La SCA relative à la réservation numéro <b>:reference_number</b> au nom de <b>:booker_name :booker_surname</b> (du <b>:arrival_date</b> au <b>:departure_date</b>) a été autorisée le <b>:accepted_date</b>. L\'adresse IP depuis laquelle la SCA a été autorisée est : <b>:ip_address</b>',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => 'Disponibilité terminée pour le logement :accommodation_name - Structure :property_name',
            'body' => 'Le <b>:date_now</b>, la disponibilité pour le logement <b>:accommodation_name - (:property_name)</b> pour les jours suivants : <b>:days</b> a été épuisée.',
        ],
        'guests_reporting' => [
            'error_levels' => [
                'reservation' => 'Réservation :reservationId - :booker',
                'accommodation' => 'Logement :accommodationType - :accommodationTableauNumber',
                'guest' => 'Invité :guest',
            ],
            'alloggiatiweb' => [
                'mail' => [
                    'subject' => 'Rapport Schedine Alloggiati - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'summary' => 'Voici le rapport des Schedine Alloggiati du :alloggiatiweb_send_date pour le groupe d\'envoi :alloggiatiweb_group_label :',
                    'success' => [
                        'body' => ':number sur :alloggiatiweb_guest_total envoyé.|:number sur :alloggiatiweb_guest_total envoyées.',
                    ],
                    'error_internal' => [
                        'body' => ':number sur :alloggiatiweb_guest_total non envoyé à cause de ces erreurs :<br/>:errors|:number sur :alloggiatiweb_guest_total non envoyées à cause de ces erreurs :<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Il n\'a pas été possible d\'envoyer les Schedine Alloggiati en raison de ces erreurs communiquées par le portail :<br/>:errors',
                    ],
                    'fix_error' => 'Il est nécessaire de corriger les erreurs et de renvoyer les Schedine Alloggiati depuis <a href=":link">Documents > Schedines Istat et Alloggiati</a>',
                ],
                'push' => [
                    'subject' => 'Schedine Alloggiati - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'success' => [
                        'body' => ':number sur :alloggiatiweb_guest_total envoyée.|:number sur :alloggiatiweb_guest_total envoyées.',
                    ],
                    'error_internal' => [
                        'body' => ':number sur :alloggiatiweb_guest_total n\'a pas été envoyée.
        Complétez les données manquantes ou corrigez les erreurs et essayez à nouveau l\'envoi manuellement.|:number sur :alloggiatiweb_guest_total non envoyées.
        Complétez les données manquantes ou corrigez les erreurs et essayez à nouveau l\'envoi manuellement.',
                    ],
                    'error_external' => [
                        'body' => 'Il n\'a pas été possible d\'envoyer les Schedine Alloggiati en raison de ces erreurs communiquées par le portail :
        :errors
        Corrigez les erreurs et essayez à nouveau l\'envoi manuellement.',
                    ],
                ],
                'warning' => [
                    'subject' => 'Erreurs Schedine Alloggiati - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'error_internal' => [
                        'body' => ':number sur :alloggiatiweb_guest_total n\'a pas été envoyé en raison de ces erreurs :<br/>:errors|:number sur :alloggiatiweb_guest_total non envoyées à cause de ces erreurs :<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Il n\'a pas été possible d\'envoyer les Schedine Alloggiati en raison de ces erreurs communiquées par le portail :
        :errors
        Corrigez les erreurs et essayez à nouveau l\'envoi manuellement.',
                    ],
                    'fix_error' => 'Il est nécessaire de corriger les erreurs et de renvoyer les Schedine Alloggiati depuis <a href=":link">Documents > Schedines Istat et Alloggiati</a>',
                ],
            ],
            'istat' => [
                'mail' => [
                    'subject' => 'Rapport Schedine ISTAT - :istat_send_date - :istat_group_label',
                    'summary' => 'Voici le rapport des Schedines ISTAT du :istat_send_date pour le groupe d\'envoi :istat_group_label :',
                    'success' => [
                        'body' => ':number sur :istat_guest_total envoyée.|:number sur :istat_guest_total envoyées.',
                    ],
                    'error_internal' => [
                        'body' => ':number sur :istat_guest_total non envoyée à cause de ces erreurs :<br/>:errors|:number sur :istat_guest_total non envoyées à cause de ces erreurs :<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Il n\'a pas été possible d\'envoyer les Schedines ISTAT en raison de ces erreurs communiquées par le portail :<br/>:errors',
                    ],
                    'fix_error' => 'Il est nécessaire de corriger les erreurs et de renvoyer les Schedines ISTAT depuis <a href=":link">Documents > Schedines Istat et Alloggiati</a>',
                ],
                'push' => [
                    'subject' => 'Schedines ISTAT :istat_send_date - :istat_group_label',
                    'success' => [
                        'body' => ':number sur :istat_guest_total envoyée.|:number sur :istat_guest_total envoyées.',
                    ],
                    'error_internal' => [
                        'body' => ':number sur :istat_guest_total n\'a pas été envoyée.
        Complétez les données manquantes ou corrigez les erreurs et essayez à nouveau l\'envoi manuellement.|:number sur :istat_guest_total non envoyées.
        Complétez les données manquantes ou corrigez les erreurs et essayez à nouveau l\'envoi manuellement.',
                    ],
                    'error_external' => [
                        'body' => 'Il n\'a pas été possible d\'envoyer les Schedines ISTAT en raison de ces erreurs :
        :errors
        Corrigez les erreurs et essayez à nouveau l\'envoi manuellement.',
                    ],
                ],
            ],
        ],
        'treatment_price_update' => [
            'subject' => 'Calcul des prix du traitement (:treatment_name) - :property_name',
            'body' => 'Le calcul du :start_date au :end_date a été effectué avec succès',
        ],
        'reservation_message_received' => [
            'subject' => 'Nouveau message de :senderName (#:reference)',
            'title' => ':senderName vous a envoyé un message !',
            'sender_wrote' => 'L\'invité a écrit :',
            'go_to_conversation' => 'Allez à la conversation',
        ],
        'external_services' => [
            'UrmetSclak' => [
                'error_generate_key_subject' => 'Erreur de création des clés de réservation :booker_name :booker_surname (#ID :reference_number)',
                'error_generate_key_body' => 'Une erreur est survenue avec Sclak concernant la génération des clés des chambres. <br> :errors <br> Veuillez réessayer manuellement, si le problème persiste, contactez le support Urmet',
                'error_seding_sms_subject' => 'Erreur d\'envoi de SMS pour les clés de réservation :booker_name :booker_surname (#ID :reference_number)',
                'error_seding_sms_body' => 'Il n\'a pas été possible d\'envoyer le SMS de Sclak en raison d\'une erreur. <br> Nous vous conseillons de contacter le support Urmet',
            ],
            'nuki' => [
                'error_generate_key_subject' => 'Erreur de création du PIN pour la réservation :booker_name :booker_surname (#ID :reference_number)',
                'error_generate_key_body' => 'Une erreur est survenue avec Nuki concernant la génération du PIN des chambres. <br> :errors <br> Veuillez réessayer manuellement, si le problème persiste, contactez le support Nuki',
                'unauthorized_opening' => 'Ouverture non autorisée'
            ],
            'warning' => [
                'subject' => 'Erreur de création des clés pour la réservation :booker_name :booker_surname (#ID :reference_number)',
                'body' => 'Une erreur est survenue avec Sclak concernant la génération des clés des chambres. <br> :errors <br> Veuillez réessayer manuellement, si le problème persiste, contactez le support Urmet',
            ],
            'remote_door_key_service' => [
                'reservation_resumed' => [
                    'title' => 'Modifications des réservations, générer de nouvelles clés',
                    'body' => 'Il est nécessaire de générer une nouvelle clé pour la réservation de <b>:booker_name :booker_surname - :reference_number</b> pour la structure <b>:property_name</b>. L\'ancienne clé a été désactivée après le changement d\'état de la réservation.',
                ],
                'reservation_moved' => [
                    'title' => 'Un ou plusieurs logements ont été déplacés. Il est nécessaire de générer une nouvelle clé.',
                    'body' => 'Un ou plusieurs logements de la réservation de <b>:booker_name :booker_surname - :reference_number</b> pour la structure <b>:property_name</b> ont été déplacés. Il est nécessaire de générer une nouvelle clé.',
                ],
            ],
        ],
        'conversation_message_send_failed' => [
            'subject' => 'Échec de l\'envoi du message',
            'title' => 'Le message envoyé à :recipientName n\'a pas été délivré. Veuillez essayer de l\'envoyer à nouveau.',
            'go_to_conversation' => 'Allez à la conversation',
        ],
        'newsletters' => [
            'newsletter_sent_subject' => 'Confirmation de l\'envoi de la newsletter',
            'newsletter_sent_content' => 'La campagne ":newsletterName" a été envoyée à :sentContacts destinataires sur un total de :totalContacts contacts sélectionnés.',
            'newsletter_not_sent_subject' => 'Erreur d\'envoi de la newsletter',
            'newsletter_exceeded_sent_limit_subject' => 'Limite d\'envoi mensuel dépassée',
            'newsletter_exceeded_sent_limit_content' => 'La newsletter :newsletterName n\'a pas été envoyée en raison du dépassement de la limite mensuelle d\'envoi d\'emails',
            'newsletter_not_sent_content' => 'Il n\'a pas été possible d\'envoyer la campagne ":newsletterName" en raison de ces erreurs : :errorMessage',
        ],
        'city_taxes_reports' => [
            'send_city_tax_report' => [
                'subject' => 'Confirmation d\'envoi du rapport de taxe de séjour',
                'content' => 'L\'envoi du rapport de la taxe de séjour pour le canal :channelName a été effectué avec succès',
            ],
            'send_city_tax_report_not_completed' => [
                'subject' => 'Erreur d\'envoi du rapport de taxe de séjour',
                'content' => 'L\'envoi du rapport de la taxe de séjour pour le canal :channelName n\'a pas été effectué',
            ],
            'export_city_tax_report' => [
                'subject' => 'L\'exportation du rapport des taxes de séjour pour le canal :channelName est prête',
                'content' => 'Cliquez sur le lien suivant pour accéder à l\'historique des rapports de taxe de séjour : <a href=":link">Historique des rapports de taxe de séjour</a>.',
            ],
            'export_city_tax_report_not_completed' => [
                'subject' => 'L\'exportation des rapports des taxes de séjour pour le canal :channelName n\'a pas été complétée',
                'content' => 'La génération du rapport :reportId n\'a pas été réalisée avec succès',
            ],
            'guest_atrtributes_missing' => [
                'subject' => 'Erreur lors de l\'envoi/ de l\'exportation des rapports de taxe de séjour',
            ],
            'empty_report' => [
                'subject' => 'Il n\'a pas été possible de compléter l\'envoi/ l\'exportation des rapports de taxe de séjour pour le canal :channelName',
                'content' => 'Le rapport des taxes de séjour n\'a pas été traité car aucun invité n\'a été extrait pour la période sélectionnée afin de le communiquer au canal',
            ],
        ],
        'accommodation_deleted' => [
            'subject' => '[Action requise] - Mise à jour de la disponibilité nécessaire',
        ],
        'max_email_attachments_size_exceeded' => 'La taille des fichiers joints dépasse la limite maximale autorisée de 8 Mo',
        'check_pci_expiration' => [
            'expiring_certification' => [
                'subject' => 'Beddy - Important : Alerte expiration certification PCI',
                'content' => 'Cher partenaire :apiPartnerName,<br><br>
                            La certification PCI que vous avez fournie expire dans 30 jours.<br>
                            Nous vous prions de nous envoyer la certification mise à jour à <a href="mailto:support@beddy.io">support@beddy.io</a> avant la date d\'expiration.<br>
                            Passé ce délai, le système révoquera l\'accès aux données de paiement.<br><br>
                            L\'équipe de Beddy',
            ],
            'certification_expired' => [
                'subject' => 'Certification PCI expirée',
                'content' => 'Cher partenaire :apiPartnerName,<br>
                            La certification PCI que vous avez fournie est expirée.<br>
                            Par conséquent, l\'accès aux données de paiement a été révoqué.<br>
                            Nous vous prions de nous envoyer la certification mise à jour à <a href="mailto:support@beddy.io">support@beddy.io</a> pour rétablir le service.<br><br>
                            L\'équipe de Beddy',
            ],
        ],
        'api_partner_disabled' => [
            'subject' => 'Beddy - Important : Alerte désactivation du compte API',
            'body' => 'Cher partenaire :apiPartnerName,<br>
                    Votre compte a été désactivé en raison de trop nombreuses demandes reçues.<br>
                    Après avoir effectué une vérification sur vos systèmes, nous vous prions de nous contacter à <a href="mailto:support@beddy.io">support@beddy.io</a> pour réactiver le compte.<br><br>
                    L\'équipe de Beddy',
        ],
        'api_partner_disabled_test' => [
            'subject' => 'Beddy - Important : Alerte de désactivation éventuelle du compte API',
            'body' => 'Le partenaire :apiPartnerName,<br>
                    a été désactivé en raison de trop nombreuses demandes effectuées sur le service : :errorMessage.<br>',
        ],
        'property_first_login' => [
            'subject' => 'Beddy - Connexion depuis un nouvel appareil',
            'summary' => 'Bonjour :user_first_name,<br> Il a été détecté une connexion depuis un nouvel appareil à votre compte Beddy.',
            'summary_reset' => 'Si vous ne reconnaissez pas cet appareil, nous vous conseillons de <a href=":recoveryPasswordLink" target="_blank">changer immédiatement votre mot de passe</a> pour protéger votre compte.',
            'device' => 'Appareil',
            'place' => 'Lieu',
            'date_hour' => 'Date et heure',
            'unknown' => 'Inconnu',
            'logout' => 'La notification de connexion est une nouvelle fonctionnalité de Beddy, elle est envoyée lors de la première connexion sur des appareils déjà utilisés auparavant. Vérifiez les appareils connectés depuis le menu <a href=":logoutAllDevice" target="_blank">Profil > Sécurité et accès</a>. Si cela correspond, vous pouvez ignorer cet e-mail.',
        ],
        'channel_update_exclusion' => [
            'subject' => 'Le portail a modifié les restrictions sur les mises à jour de la propriété',
            'summary' => 'Portail impliqué',
            'oldvalue' => 'Ancienne valeur',
            'newvalue' => 'Nouvelle valeur',
            'modified_value' => 'Valeur modifiée',
            'deleted_value' => 'Valeur supprimée',
            'more_info' => 'Cet email a été envoyé suite à l\'exécution du cron de téléchargement des nouvelles chambres',
            'they_have_been' => 'ont été',
            'the_following_restrictions' => ' les restrictions suivantes :',
            'edited' => 'modifiées',
            'new' => 'ajoutées',
            'removed' => 'supprimées',
            'price' => 'Prix',
            'availability' => 'Disponibilité',
            'room_barred' => 'Fermeture',
            'min_stay' => 'Séjour minimum',
            'max_stay' => 'Séjour maximum',
            'close_to_arrival' => 'Fermeture à l\'arrivée',
            'close_to_departure' => 'Fermeture au départ',
            'date_from' => 'Date de début',
            'date_to' => 'Date de fin',
            'type_change' => 'Type de changement',
            '1' => 'activé',
            '0' => 'désactivé',
            'field_involved' => 'Champ impliqué',
            'rate' => 'Pour le tarif ',
            'property' => 'propriété',
            'subject_short' => 'Modifications des restrictions pour: '
        ],
        'credit_card_view_blocked' => [
            'subject' => 'Beddy - Limite de consultations de la carte bancaire dépassé.',
            'body' => 'Cher client,<br>nous vous informons que la carte associée à la réservation <b>#:reference_number</b> ou à l’un des paiements correspondants a atteint le nombre maximal de consultations autorisées. Par conséquent, l’accès à cette carte a été <b>temporairement bloqué</b>.
    <br><br>Si vous souhaitez augmenter la limite de consultations ou obtenir plus d’informations, veuillez contacter notre support à l’adresse suivante : <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
    L’équipe Beddy<br><br>',
        ],
        'credit_card_view_notify' => [
            'subject' => 'Beddy - Notification d’accès aux données de carte bancaire - Réservation n°:reservation_reference',
            'body' => 'Cher Client,<br>Les données de carte bancaire liées à la réservation n°<b>:reservation_reference</b> provenant du canal <b>:channel_name</b> ont été consultées.
    <br><br>
    Détails de l’événement :
    <ul>
      <li>Opérateur : <b>:user_first_name :user_last_name</b> (<b>:user_email</b>)</li>
      <li>Date et heure : <b>:event_date</b> <b>:event_hour</b></li>
      <li>IP : <b>:ip_address</b></li>
    </ul>
    Cette notification est générée comme mesure de sécurité et de traçabilité des accès aux données sensibles.<br><br>
    L’équipe Beddy<br><br>',
        ],
        'user_created_notify' => [
            'subject' => 'Beddy - Nouvel utilisateur créé pour l’établissement :property_name',
            'bodySection1' => 'Cher Client,<br>un nouvel utilisateur <b>:user_first_name :user_last_name (:user_email)</b> vient d’être créé pour l’établissement <b>:property_name</b>.
        <br><br>
        Détails de l’événement :
        <ul>
          <li>Opérateur : <b>:author_first_name :author_last_name</b> (<b>:author_email</b>)</li>
          <li>Date et heure : <b>:event_date</b> <b>:event_hour</b></li>
          <li>IP : <b>:ip_address</b></li>
        </ul>
        Si vous ne reconnaissez pas cette opération, vous pouvez désactiver le nouvel utilisateur.',
            'buttonText' => 'Désactiver l’utilisateur',
            'bodySection2' => 'Cette notification est générée comme mesure de sécurité et de suivi des accès aux données sensibles.<br><br>
        L’équipe Beddy<br><br>'
        ],

    ],

    'export' => [
        'providers' => [
            'customers' => 'Clients',
            'companies' => 'Entreprises',
            'reservations' => 'Réservations',
            'social_archive' => 'Clients avec offre déverrouillable',
            'reservation_quotes' => 'Devis',
            'cash_desk' => 'Caisse',
            'fees' => 'Honoraires',
            'cash_desk_closure' => 'Fermeture de la caisse',
            'production_stats' => 'Statistiques de production',
            'sales_stats' => 'Statistiques de vente',
            'invoices' => 'Documents fiscaux',
            'invoices_received' => 'Documents fiscaux reçus',
            'payments_timetable' => 'Calendrier des paiements',
            'properties' => 'Structures',
            'deposits' => 'Acomptes et dépôts',
            'reservations_guests_presences' => 'Invités présents'
        ],
        'translations' => [
            'export_format' => 'Format d\'exportation',
        ],
        'errors' => [
            'service_not_active' => 'Le service d\'exportation demandé n\'est pas actif pour les structures sélectionnées',
            'method_not_found' => 'La méthode :methodName n\'est pas implémentée dans la classe :className',
            'export_provider_not_found' => 'Export Provider non trouvé',
        ],
        'warnings' => [
            'service_not_active' => 'Le service d\'exportation demandé n\'est pas actif pour la structure :propertyName',
            'export_inserted' => 'Exportation insérée avec succès. Vous recevrez une notification à la fin du processus.',
        ],
    ],

    'external_services' => [
        'urmet_sclak' => [
            'one_time' => 'Validité du code',
            'confirm_required' => 'Le gestionnaire devra autoriser chaque accès avec l\'application Sclak',
            'app_enabled' => 'Activer l\'utilisation de l\'APP (si NON, il sera activé pour utiliser uniquement le clavier numérique)',
            'generate_keypad_pin' => 'Générer le code PIN du pavé numérique',
            'push_notify_enabled' => 'Recevez une notification chaque fois que votre invité accède',
            'security_level' => 'L\'invité doit être connecté à Internet',
            'instant_key' => 'Enregistrement de l\'invité optionnel',
            'purchase_type' => 'Qui paie la clé ?',
            'send_sms' => 'Envoyer le SMS par défaut',
            'sms_text_main' => 'Salut, voici les instructions pour obtenir les clés pour accéder à l\'installation.
            - INSTALLER L\'APPLICATION Sclak : http://app.sclak.com/download',
            'sms_text_app_code' => '
            - ACTIVER LA CLÉ : https://key.sclak.com/a/:app_key_code',
            'sms_text_pin_code' => '
            - Le code PIN du clavier est : :pin_code\'',
            'all_booking_duration' => 'Pendant toute la durée du séjour',
            'only_one' => 'Juste une fois',
            'property' => 'L\'établissement d\'hébergement',
            'guest' => 'Le client',
            'door_app_code' => 'Code d\'activation de l\'application',
            'door_link_code' => 'Lien d\'activation de l\'application',
            'app_activation_code' => 'Code d\'activation de l\'APP :accommodation_name (:accommodation_label): :key_code',
            'app_activation_code_log' => ':key_code',
            'door_key_code' => 'Code de porte',
            'checkin_hour' => 'Heure d\'arrivée',
            'checkout_hour' => 'Heures de paiement',
            'room_not_mapped' => 'Chambre :accommodation_name - :tableau_number non associé sur Sclak',
        ],
        'nuki' => [
            'property' => 'La propriété',
            'guest' => 'L\'invité',
            'door_key_code' => 'Code de la porte',
            'checkin_hour' => 'Heure de check-in (la clé d\'accès ne sera valable qu\'à partir de l\'heure de check-in choisie)',
            'checkout_hour' => 'Heure de check-out (la clé d\'accès sera valable jusqu\'à l\'heure de check-out choisie)',
            'room_not_mapped' => 'Chambre :accommodation_name - :tableau_number non associée sur Nuki',
            'code' => 'PIN de la porte :accommodation_name (:accommodation_label): :key_code',
            'email_address_not_found' => 'Adresse e-mail introuvable, veuillez ajouter une adresse e-mail à la réservation pour envoyer l\'invitation d\'accès à Nuki',
            'generate_keypad_pin' => 'Générer le PIN à envoyer pour l\'ouverture avec le clavier numérique (choisissez OUI seulement si des claviers sont présents dans la propriété)',
            'sent_with_app' => 'Envoyé via l\'application Nuki',
            'authorization_not_found' => 'Vous essayez de modifier un code inexistant, générez un nouveau code de porte',
            'multi_port_management' => 'Permettre la génération du même code PIN pour ouvrir plusieurs portes (par exemple, portail d’entrée et chambre) ; vous pourrez ensuite associer les portes à relier',
            'device_not_configured' => 'Aucun appareil Nuki trouvé ou configuré pour une ouverture via lien'
        ],
        'errors' => [
            'service_not_active' => 'Service externe non actif',
            'scheduler_not_supported' => 'Le service externe :external_service_name ne prend pas en charge la fonctionnalité de planification automatique',
        ],
        'warnings' => [
            'manual_code_detected' => 'Des codes de chambres ont été détectés manuellement, ceux-ci ne peuvent pas être associés à des dispositifs distants. Vous devez donc les supprimer manuellement',
        ],
        'key_door_services' => [
            'key_door_related' => 'Ce code ouvrira également les dispositifs suivants : :devices_name',
        ],
        'gt_revenue' => [
            'spreadsheet_type' => 'Critère d\'exportation des revenus',
            'spreadsheet_type_segments' => 'Segments',
            'spreadsheet_type_rooms' => 'Chambres',
            'date_from' => 'Date de début de l\'exportation',
            'date_to' => 'Date de fin de l\'exportation',
            'period' => 'Période d\'exportation',
        ],
        'pa_friuli' => [
            'year_type' => 'Sélectionnez l’année à exporter',
            'year_type_previous' => 'Année précédente (:year)',
            'year_type_current' => 'Année en cours (:year)',
        ],
    ],

    'fees' => [
        'deferred' => 'TVA à exigibilité différée',
        'payment_split' => 'Scission des paiements',
        'immediate' => 'TVA à exigibilité immédiate',
        'export_fields' => [
            'date' => 'Date',
            'document_type' => 'Type de document',
            'document_number' => 'Numéro de document',
            'total_taxable' => 'Total taxable',
            'total_taxation' => 'Total TVA',
            'total_documents' => 'Total des documents',
            'customer_name' => 'Nom du client',
            'customer_type' => 'Type de client',
            'documents' => 'Documents',
            'total_nets' => 'Total net',
            'total_taxes' => 'Total des taxes',
            'documents_total' => 'Total des documents',
        ],
        'net' => 'Net',
        'tax' => 'TVA',
        'sheets_name' => [
            'rows' => 'Corrispettifs',
            'summary' => 'Résumé',
        ],
    ],

    'fiscal_printer' => [
        'not_collected' => 'Non collecté',
        'electronic' => 'Carte de crédit',
        'not_collected_follows_invoice' => 'Non collecté suit la facture',
    ],

    'gdpr' => [
        'privacy' => [
            'title' => '',
            'header' => '<p><strong>POLITIQUE DE CONFIDENTIALITÉ</strong></p>
            <p><strong>concernant le traitement des données personnelles</strong></p>
            <p>Articles 12 et suivants du Règlement (UE) 2016/679 (RGPD)</p>
            <p>&nbsp;</p>
            <p><strong>PRÉAMBULE</strong></p>
            <p>Conformément aux dispositions du Règlement (UE) 2016/679 (ci-après RGPD), nous fournissons des informations sur le traitement des données personnelles fournies par la personne concernée, relatives aux relations avec l\'Entreprise. Les informations sont fournies conformément à l\'article 13 du RGPD.</p>
            <p>&nbsp;</p>
            <ol>
            <li><strong>IDENTITÉ ET COORDONNÉES</strong></li>
            </ol>
            <p>Le Responsable du traitement : :property_name - :property_address (ci-après l\'Entreprise).</p>
            <p>L\'Entreprise peut être contactée aux adresses suivantes : tél : :property_telephone ; e-mail : :property_email</p>
            <p>&nbsp;</p>
            <p>&nbsp;</p>',
            'default_body' => '<p>&nbsp;</p>
            <ol start="2">
            <li><strong>COORDONNÉES DU DÉLÉGUÉ À LA PROTECTION DES DONNÉES (DPO)</strong></li>
            </ol>
            <p>Le Délégué à la protection des données est ________________, tél. ______________, e-mail : ______________.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="3">
            <li><strong>FINALITÉS DU TRAITEMENT, BASE JURIDIQUE ET DURÉE DE CONSERVATION DES DONNÉES</strong></li>
            </ol>
            <table width="680">
            <tbody>
            <tr>
            <td width="191">
            <p><strong><em>Finalité</em></strong></p>
            </td>
            <td width="135">
            <p><strong><em>Types de données pouvant être traitées :</em></strong></p>
            </td>
            <td width="149">
            <p><strong><em>Base juridique</em></strong></p>
            </td>
            <td width="206">
            <p><strong><em>Durée de conservation</em></strong></p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>a)&nbsp;&nbsp; </strong><strong><u>Prestation de service</u></strong></p>
            <p>Enregistrement du client et respect ultérieur des obligations légales.</p>
            </td>
            <td width="135">
            <p>Prénom, Nom, Numéro de téléphone, Demandes supplémentaires, Adresse, Code postal, Province, Pays, État, E-mail, Informations de paiement</p>
            </td>
            <td width="149">
            <p>Exécution d\'un contrat auquel vous êtes partie ou mesures précontractuelles prises à la demande de la personne concernée ;</p>
            <p>Respect des obligations légales.</p>
            <p><em>&nbsp;</em></p>
            <p><em>art. 6 co. 1 lett. b) et c) RGPD.</em></p>
            </td>
            <td width="206">
            <p>Le temps de conservation est variable, car il dépend de la différence entre la date de la réservation et l\'arrivée effective du client à l\'établissement.</p>
            <p>Les informations de paiement chiffrées sont conservées jusqu\'à 15 jours après le départ du client.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>b)&nbsp;&nbsp; </strong><strong><u>Demande de devis</u></strong></p>
            <p>Demande de devis suivie d\'un contact par le Responsable du traitement</p>
            </td>
            <td width="135">
            <p>Prénom, Nom, E-mail et Numéro de téléphone</p>
            </td>
            <td width="149">
            <p>Mesures précontractuelles prises à la demande de la personne concernée</p>
            <p>&nbsp;</p>
            <p><em>art. 6 co. 1 lett. b) et c) RGPD.</em></p>
            </td>
            <td width="206">
            <p>Pendant le temps nécessaire pour traiter la demande</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>c)&nbsp;&nbsp; </strong><strong><u>Newsletter</u></strong></p>
            <p>Envoi de newsletters, par des moyens automatisés de contact</p>
            </td>
            <td width="135">
            <p>Données personnelles et de contact</p>
            </td>
            <td width="149">
            <p>Consentement (requis par contrat ou demande spécifique) ;</p>
            <p>(optionnel et révocable à tout moment)</p>
            <p><em>Art. 6 co. 1 lett. a) RGPD.</em></p>
            </td>
            <td width="206">
            <p>Jusqu\'à ce que le consentement à cette finalité soit retiré et/ou que cinq ans se soient écoulés depuis l\'expression du consentement.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>d)&nbsp; </strong>Si nécessaire, pour <strong>vérifier, exercer ou défendre les droits</strong> des Responsables conjoints dans des procédures judiciaires</p>
            </td>
            <td width="135">
            <p>Données personnelles et de contact ; données nécessaires à l\'exécution de la relation contractuelle.</p>
            </td>
            <td width="149">
            <p>Intérêt légitime (protection judiciaire).</p>
            <p><em>Art. 6, paragraphe 1 lettre f) RGPD.</em></p>
            </td>
            <td width="206">
            <p>Pendant le temps nécessaire pour exercer les droits en justice.</p>
            </td>
            </tr>
            </tbody>
            </table>
            <p><strong>&nbsp;</strong></p>
            <ol start="4">
            <li><strong>CARACTÈRE OBLIGATOIRE DE LA FOURNITURE DES DONNÉES</strong></li>
            </ol>
            <p>La personne concernée doit fournir les données nécessaires à l\'exécution de la relation contractuelle avec l\'Entreprise, ainsi que les données nécessaires pour respecter les obligations prévues par les lois, règlements, normes communautaires et les dispositions des autorités légitimes et des organismes de contrôle (mentionnées dans les finalités a) et f) ci-dessus).</p>
            <p>Les données qui ne sont pas essentielles à l\'exécution de la relation contractuelle sont qualifiées et considérées comme complémentaires. Leur fourniture par la personne concernée, si demandée, est facultative et soumise à consentement. Le consentement donné peut être retiré par la personne concernée à tout moment. Un tel retrait n\'affectera en aucun cas la légalité du traitement fondé sur les consentements donnés avant le retrait.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong>MÉTHODES DE TRAITEMENT</strong></li>
            </ol>
            <p>Les données personnelles seront enregistrées, traitées et stockées dans les archives de l\'Entreprise, sur support papier et électronique, conformément aux mesures techniques et organisationnelles appropriées visées à l\'article 32 du RGPD. Le traitement des données personnelles de la personne concernée peut consister en toute opération ou ensemble d\'opérations décrites à l\'article 4, paragraphe 1, point 2 du RGPD.</p>
            <p>Les données personnelles seront traitées à l\'aide d\'outils et de procédures appropriés garantissant leur sécurité et leur confidentialité. Un tel traitement peut être effectué directement et/ou par l\'intermédiaire de tiers délégués, manuellement sur support papier ou électroniquement à l\'aide d\'équipements informatiques et d\'autres instruments. Afin de gérer correctement la relation et le respect des obligations légales, les données personnelles peuvent être intégrées dans la documentation interne de l\'Entreprise et, si nécessaire, dans les documents et registres requis par la loi.</p>
            <p>Vos données peuvent être traitées par les employés des départements de l\'Entreprise chargés de poursuivre les finalités susmentionnées. Ces employés ont été expressément autorisés à traiter les données et ont reçu des instructions opérationnelles adéquates conformément et pour les besoins de l\'article 29 du RGPD.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="6">
            <li><strong>CATÉGORIES DE DESTINATAIRES DES DONNÉES PERSONNELLES</strong></li>
            </ol>
            <p>Les données personnelles utilisées dans le cadre de la finalité (a) sont uniquement communiquées aux bureaux juridiques éventuels lorsque la loi l\'exige.</p>
            <p>Les données de paiement sont transmises aux prestataires de services de paiement pour l\'exécution de la transaction.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="7">
            <li><strong>TRANSFERT DE DONNÉES VERS DES PAYS HORS DE L\'UE</strong></li>
            </ol>
            <p>Les données fournies par la personne concernée ne seront traitées que dans les pays au sein de l\'Union européenne. Si les données personnelles de la personne concernée sont traitées dans un pays hors de l\'UE, les droits de la personne concernée prévus par la législation européenne seront garantis, et la personne concernée sera informée en temps utile.</p>
            <p>&nbsp;</p>
            <ol start="8">
            <li><strong>DROITS DE LA PERSONNE CONCERNÉE</strong></li>
            </ol>
            <p>Conformément aux articles 15 et suivants du RGPD, la personne concernée peut exercer les droits suivants :</p>
            <ol>
            <li>Accès : obtenir la confirmation que des données personnelles sont ou non traitées, ainsi que le droit d\'y accéder ; les demandes manifestement infondées, excessives ou répétées ne peuvent pas être prises en compte.</li>
            <li>Rectification : corriger ou obtenir la correction des données personnelles si elles sont incorrectes ou obsolètes et compléter les données incomplètes.</li>
            <li>Effacement/droit à l\'oubli : dans certains cas, obtenir l\'effacement des données personnelles fournies ; ce droit n\'est pas absolu, car l\'Entreprise peut avoir des raisons légitimes ou légales de les conserver.</li>
            <li>Limitation : les données seront conservées, mais ne pourront pas être traitées davantage, dans les cas prévus par la réglementation.</li>
            <li>Portabilité : transférer, copier ou déplacer les données des bases de données de l\'Entreprise vers des tiers. Cela s\'applique uniquement aux données fournies par la personne concernée pour l\'exécution d\'un contrat ou pour lesquelles un consentement explicite a été donné, et le traitement est effectué par des moyens automatisés.</li>
            <li>Opposition au marketing direct.</li>
            <li>Retrait du consentement à tout moment, si le traitement est basé sur le consentement.</li>
            </ol>
            <p>Conformément à l\'article 2-<em>undecies</em> du Décret législatif 196/2003, l\'exercice des droits de la personne concernée peut être retardé, limité ou exclu, à condition qu\'une justification soit fournie sans délai, sauf si cela compromettrait le but de la restriction, tant que et dans la mesure où cela constitue une mesure nécessaire et proportionnée pour protéger les intérêts visés au paragraphe 1, lettres a) (intérêts protégés en matière de blanchiment d\'argent), e) (pour la conduite d\'enquêtes défensives ou l\'exercice d\'un droit en justice) et f) (pour garantir la confidentialité de l\'identité de l\'employé qui signale des infractions dont il a connaissance dans l\'exercice de ses fonctions). Dans de tels cas, les droits des personnes concernées peuvent également être exercés par l\'intermédiaire de l\'Autorité de protection des données personnelles, selon les modalités prévues à l\'article 160 dudit Décret. Dans ce cas, l\'Autorité informera la personne concernée qu\'elle a effectué toutes les vérifications nécessaires ou un examen, ainsi que du droit de la personne concernée d\'engager une action en justice.</p>
            <p>&nbsp;</p>
            <p>Il convient également de noter que - avant de traiter les demandes - l\'Entreprise peut vérifier l\'identité de la personne concernée, afin d\'évaluer la légitimité de celles-ci.</p>
            <p>&nbsp;</p>
            <p>Pour exercer ces droits, la personne concernée peut contacter le Responsable du traitement aux adresses indiquées dans la section 1 de ce document. L\'Entreprise répondra dans les 30 jours suivant la réception de la demande formelle de la personne concernée.</p>
            <p>Si les droits susmentionnés relatifs aux données personnelles de la personne concernée sont violés, celle-ci peut déposer une plainte auprès de l\'autorité compétente.</p>
            <p>&nbsp;</p>
            <p><strong>&nbsp;</strong></p>
            <p><strong>LE RESPONSABLE</strong></p>
            <p><strong>DU TRAITEMENT</strong></p>',
        ],
        'cookie' => [
            'title' => '',
            'header' => '<p><strong>Politique de Cookies de :property_name</strong></p>
            <ol>
            <li><strong>Responsable du traitement</strong></li>
            </ol>
            <p>Le Responsable du traitement est :property_name - :property_address (ci-après, l\'Entreprise ou le Propriétaire).</p>
            <p>L\'Entreprise peut être contactée aux adresses suivantes : tél : :property_telephone ; e-mail : :property_email</p>',
            'default_body' => '<p>Étant donné que l\'utilisation de traceurs tiers via ce Site Web ne peut pas être entièrement contrôlée par le Propriétaire, toutes les références spécifiques aux traceurs tiers doivent être considérées comme indicatives. Pour obtenir des informations complètes, les utilisateurs sont invités à consulter les politiques de confidentialité des services tiers mentionnés dans ce document.</p>
            <p>Compte tenu de la complexité objective entourant les technologies de suivi, les utilisateurs sont encouragés à contacter le Propriétaire s\'ils souhaitent recevoir des informations supplémentaires sur l\'utilisation de ces technologies par ce Site Web.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="2">
            <li><strong>Introduction</strong></li>
            </ol>
            <p>Ce document informe les utilisateurs sur les technologies qui aident ce Site Web à atteindre les objectifs décrits ci-dessous. Ces technologies permettent au Propriétaire d\'accéder à des informations (par exemple, en utilisant un cookie) ou d\'utiliser des ressources (par exemple, en exécutant un script) sur l\'appareil d\'un utilisateur lorsqu\'ils interagissent avec ce Site Web.</p>
            <p>Pour simplifier, toutes ces technologies sont définies comme "traceurs" dans ce document – sauf raison de différencier.</p>
            <p>Par exemple, bien que les cookies puissent être utilisés à la fois sur les navigateurs web et mobiles, il serait inexact de parler de cookies dans le contexte des applications mobiles, car il s\'agit de traceurs spécifiques au navigateur. Pour cette raison, dans ce document, le terme cookies est utilisé uniquement pour désigner ce type particulier de traceur.</p>
            <p>Certaines des finalités pour lesquelles les traceurs sont utilisés peuvent également nécessiter le consentement de l\'utilisateur. Chaque fois qu\'un consentement est donné, il peut être librement retiré à tout moment en suivant les instructions fournies dans ce document.</p>
            <p>Ce Site Web utilise des traceurs gérés directement par le Propriétaire (dits « traceurs de première partie ») et des traceurs qui permettent des services fournis par un tiers (dits « traceurs de tierce partie »). Sauf indication contraire dans ce document, les fournisseurs tiers peuvent accéder aux traceurs qu\'ils gèrent.</p>
            <p>La validité et les périodes d\'expiration des cookies et autres traceurs similaires peuvent varier en fonction de la durée de vie définie par le Propriétaire ou le fournisseur concerné. Certains d\'entre eux expirent à la fin de la session de navigation de l\'utilisateur.</p>
            <p>En plus de ce qui est spécifié dans les descriptions de chaque catégorie ci-dessous, les utilisateurs peuvent trouver des informations plus précises et à jour sur les durées de vie, ainsi que toute autre information pertinente (par exemple, la présence d\'autres traceurs) dans les politiques de confidentialité des fournisseurs tiers respectifs ou en contactant le Propriétaire.</p>
            <p>&nbsp;</p>
            <ol start="3">
            <li><strong>Activités strictement nécessaires au fonctionnement de ce Site Web et à la fourniture du Service</strong></li>
            </ol>
            <p>Ce Site Web utilise des cookies dits « techniques » et d\'autres traceurs similaires pour effectuer des activités strictement nécessaires au fonctionnement ou à la fourniture du Service.</p>
            <p><strong>3.1 Traceurs tiers</strong></p>
            <p><strong>3.1.1 Gestion des tags</strong></p>
            <p>Ce type de service aide le Propriétaire à gérer les tags ou scripts nécessaires sur ce Site Web de manière centralisée.</p>
            <p>Cela peut entraîner le transfert des données des utilisateurs à travers ces services, potentiellement entraînant la conservation de ces données.</p>
            <p><strong>3.1.1.1 Google Tag Manager (Google Ireland Limited)</strong></p>
            <p>Google Tag Manager est un service de gestion de tags fourni par Google Ireland Limited.</p>
            <p>Données personnelles traitées : traceurs et données d\'utilisation.</p>
            <p>Lieu de traitement : Irlande – <a href="https://policies.google.com/privacy">Politique de confidentialité</a>.</p>
            <p><strong>3.1.2 Gestion des paiements</strong></p>
            <p>À moins qu\'il en soit spécifié autrement, ce Site Web traite les paiements par carte de crédit via des prestataires externes de services de paiement. En général, sauf indication contraire, les utilisateurs sont invités à fournir leurs informations de paiement et données personnelles directement à ces prestataires de services de paiement.</p>
            <p>Ce Site Web ne participe pas à la collecte et au traitement de ces informations : il reçoit uniquement une notification de la part du prestataire de services de paiement concerné en cas de paiement réussi.</p>
            <p><strong>3.1.2.1 Stripe (Stripe Technology Europe Ltd)</strong></p>
            <p>Stripe est un service de paiement fourni par Stripe Technology Europe, Limited.</p>
            <p>Données personnelles traitées : traceurs et différents types de données, comme spécifié dans la politique de confidentialité du service.</p>
            <p>Lieu de traitement : Irlande – <a href="https://stripe.com/ie/privacy">Politique de confidentialité</a>.</p>
            <p>Durée de conservation :</p>
            <ul>
            <li>__stripe_mid : 1 an</li>
            <li>__stripe_sid : 30 minutes</li>
            <li>m : 2 ans</li>
            </ul>
            <p><strong>3.1.2.2 PayPal (Paypal)</strong></p>
            <p>PayPal est un service de paiement fourni par PayPal Inc., qui permet aux utilisateurs d\'effectuer des paiements en ligne.</p>
            <p>Données personnelles traitées : traceurs et différents types de données, comme spécifié dans la politique de confidentialité du service.</p>
            <p>Lieu de traitement : Voir la politique de confidentialité de PayPal – <a href="https://www.paypal.com/webapps/mpp/ua/privacy-full">Politique de confidentialité</a>.</p>
            <p>Durée de conservation :</p>
            <ul>
            <li>__paypal_storage__ : indéfinie</li>
            <li>akavpau_ppsd : durée de la session</li>
            <li>enforce_policy : durée de la session</li>
            <li>l7_az : durée de la session</li>
            <li>nsid : durée de la session</li>
            <li>ts : durée de la session</li>
            <li>tsrce : durée de la session</li>
            <li>x-cdn : durée de la session</li>
            <li>x-pp-s : durée de la session</li>
            </ul>
            <p>&nbsp;</p>
            <ol start="4">
            <li><strong>Autres activités impliquant l\'utilisation de traceurs</strong></li>
            </ol>
            <p><strong>4.1 Mesure</strong></p>
            <p>Ce site Web utilise des traceurs pour mesurer le trafic et analyser le comportement des utilisateurs dans le but d\'améliorer le service.</p>
            <p><strong>4.1.1 Analytique</strong></p>
            <p>Les services contenus dans cette section permettent au Propriétaire de surveiller et d\'analyser le trafic Web et peuvent être utilisés pour suivre le comportement des utilisateurs.</p>
            <p><strong>4.1.1.1 Google Analytics 4 (Google Ireland Limited)</strong></p>
            <p>Google Analytics 4 est un service d\'analyse Web fourni par Google Ireland Limited (« Google »). Google utilise les données collectées pour suivre et examiner l\'utilisation de ce site Web, pour préparer des rapports sur ses activités et les partager avec d\'autres services Google.<br /> Google peut utiliser les données collectées pour contextualiser et personnaliser les annonces de son propre réseau publicitaire.<br /> Dans Google Analytics 4, les adresses IP sont utilisées au moment de la collecte, puis supprimées avant que les données ne soient enregistrées dans tout centre de données ou serveur. Les utilisateurs peuvent en savoir plus en consultant&nbsp;<a href="https://support.google.com/analytics/answer/12017362?hl=fr&amp;ref_topic=2919631">la documentation officielle de Google</a>.</p>
            <p>Données personnelles traitées : informations sur le navigateur, ville, informations sur l\'appareil, latitude (de la ville), longitude (de la ville), nombre d\'utilisateurs, statistiques de session, traceurs et données d\'utilisation.</p>
            <p>Lieu de traitement : Irlande &ndash;&nbsp;<a href="https://policies.google.com/privacy">Politique de confidentialité</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=fr">Option de retrait</a>.</p>
            <p>Durée de conservation :</p>
            <ul>
            <li>_ga : 2 ans</li>
            <li>_ga_* : 2 ans</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.2 Google Analytics (Google Ireland Limited)</strong></p>
            <p>Google Analytics est un service d\'analyse Web fourni par Google Ireland Limited (« Google »). Google utilise les données collectées pour suivre et examiner l\'utilisation de ce site Web, préparer des rapports sur ses activités et les partager avec d\'autres services Google.<br /> Google peut utiliser les données collectées pour contextualiser et personnaliser les annonces de son propre réseau publicitaire.</p>
            <p>Données personnelles traitées : traceurs et données d\'utilisation.</p>
            <p>Lieu de traitement : Irlande &ndash;&nbsp;<a href="https://policies.google.com/privacy">Politique de confidentialité</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=fr">Option de retrait</a>.</p>
            <p>Durée de conservation :</p>
            <ul>
            <li>AMP_TOKEN : 1 heure</li>
            <li>_ga : 2 ans</li>
            <li>_gac* : 3 mois</li>
            <li>_gat : 1 minute</li>
            <li>_gid : 1 jour</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Suivi des conversions Facebook Ads (pixel Facebook) (Meta Platforms Ireland Limited)</strong></p>
            <p>Le suivi des conversions Facebook Ads (pixel Meta) est un service d\'analyse fourni par Meta Platforms Ireland Limited qui connecte les données du Meta Audience Network avec les actions effectuées sur ce site Web. Le pixel Meta suit les conversions qui peuvent être attribuées aux annonces sur Facebook, Instagram et Meta Audience Network.</p>
            <p>Données personnelles traitées : traceurs et données d\'utilisation.</p>
            <p>Lieu de traitement : Irlande &ndash;&nbsp;<a href="https://www.facebook.com/about/privacy/">Politique de confidentialité</a>.</p>
            <p>Durée de conservation :</p>
            <ul>
            <li>_fbp : 3 mois</li>
            <li>fr : 3 mois</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.4 Suivi des conversions Google Ads (Google Ireland Limited)</strong></p>
            <p>Le suivi des conversions Google Ads est un service d\'analyse fourni par Google Ireland Limited qui connecte les données du réseau publicitaire Google Ads avec les actions effectuées sur ce site Web.</p>
            <p>Données personnelles traitées : traceurs et données d\'utilisation.</p>
            <p>Lieu de traitement : Irlande &ndash;&nbsp;<a href="https://policies.google.com/privacy">Politique de confidentialité</a>.</p>
            <p>Durée de conservation :</p>
            <ul>
            <li>IDE : 2 ans</li>
            <li>test_cookie : 15 minutes</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.2 Marketing</strong></p>
            <p><strong>4.1.2.1 Userguest</strong></p>
            <p>Ce service permet à l\'utilisateur de voir des publicités personnalisées sur ce site Web, basées sur les visites précédentes à ce site.</p>
            <p>Il ne collecte pas de données personnelles.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong>Comment gérer les préférences et donner ou retirer son consentement</strong></li>
            </ol>
            <p>Il existe plusieurs façons de gérer les préférences liées aux traceurs et de donner ou retirer son consentement, le cas échéant :</p>
            <p>Les utilisateurs peuvent gérer les préférences liées aux traceurs directement depuis les paramètres de leur appareil, par exemple en empêchant l\'utilisation ou le stockage des traceurs.</p>
            <p>De plus, lorsque l\'utilisation des traceurs est basée sur le consentement, les utilisateurs peuvent donner ou retirer ce consentement en configurant leurs préférences dans l\'avis relatif aux cookies ou en mettant à jour ces préférences via le widget de gestion des préférences de consentement, si disponible.</p>
            <p>Il est également possible, via les fonctionnalités pertinentes du navigateur ou de l\'appareil, de supprimer les traceurs précédemment stockés, y compris ceux utilisés pour mémoriser le consentement initial de l\'utilisateur.</p>
            <p>D\'autres traceurs stockés dans la mémoire locale du navigateur peuvent être effacés en supprimant l\'historique de navigation.</p>
            <p>En ce qui concerne les traceurs tiers, les utilisateurs peuvent gérer leurs préférences et retirer leur consentement via le lien de désinscription correspondant (lorsqu\'il est fourni), en utilisant les moyens indiqués dans la politique de confidentialité du tiers ou en contactant ce dernier.</p>
            <p><strong>5.1 Localisation des paramètres des traceurs</strong></p>
            <p>Les utilisateurs peuvent, par exemple, trouver des informations sur la gestion des cookies dans les navigateurs les plus couramment utilisés aux adresses suivantes :</p>
            <ul>
            <li><a href="https://support.google.com/chrome/answer/95647?hl=fr&amp;p=cpn_cookies">Google Chrome</a></li>
            <li><a href="https://support.mozilla.org/fr/kb/activer-desactiver-cookies-preferences-sites">Mozilla Firefox</a></li>
            <li><a href="https://support.apple.com/fr-fr/guide/safari/sfri11471/">Apple Safari</a></li>
            <li><a href="https://support.microsoft.com/fr-fr/help/4027947">Microsoft Edge</a></li>
            <li><a href="https://support.brave.com/hc/fr/articles/360022806212-Comment-utiliser-les-Shields-lors-de-la-navigation">Brave</a></li>
            <li><a href="https://help.opera.com/fr/latest/web-preferences/#cookies">Opera</a></li>
            </ul>
            <p>Les utilisateurs peuvent également gérer certaines catégories de traceurs utilisés dans les applications mobiles en optant via les paramètres pertinents de l\'appareil, comme les paramètres publicitaires pour les appareils mobiles ou les paramètres de suivi en général (les utilisateurs peuvent ouvrir les paramètres de l\'appareil et rechercher l\'option appropriée).</p>
            <p><strong>5.2 Conséquences du refus de consentement</strong></p>
            <p>Les utilisateurs sont libres de décider de donner ou non leur consentement. Toutefois, veuillez noter que les traceurs permettent à ce site Web d\'offrir une meilleure expérience et des fonctionnalités avancées aux utilisateurs (conformément aux objectifs décrits dans ce document). Par conséquent, en l\'absence de consentement de l\'utilisateur, le Propriétaire pourrait ne pas être en mesure de fournir les fonctionnalités associées.</p>
            <ol start="6">
            <li><strong>Définitions et références légales</strong></li>
            </ol>
            <p><strong>Données personnelles (ou Données)</strong></p>
            <p>Toute information qui, directement, indirectement ou en combinaison avec d\'autres informations — y compris un numéro d\'identification personnel — permet d\'identifier ou de rendre identifiable une personne physique.</p>
            <p><strong>Données d\'utilisation</strong></p>
            <p>Informations collectées automatiquement via ce site Web (ou des services tiers utilisés dans ce site Web), qui peuvent inclure : les adresses IP ou noms de domaine des ordinateurs utilisés par les utilisateurs accédant au site, les adresses URI (Uniform Resource Identifier), l\'heure de la demande, la méthode utilisée pour soumettre la demande au serveur, la taille du fichier reçu en réponse, le code numérique indiquant le statut de la réponse du serveur (résultat réussi, erreur, etc.), le pays d\'origine, les caractéristiques du navigateur et du système d\'exploitation utilisé par l\'utilisateur, divers détails sur le temps passé par visite (par exemple, le temps passé sur chaque page de l\'application) et les détails concernant le chemin suivi dans l\'application avec une référence particulière à la séquence des pages visitées, et d\'autres paramètres concernant le système d\'exploitation de l\'appareil et/ou l\'environnement informatique de l\'utilisateur.</p>
            <p><strong>Utilisateur</strong></p>
            <p>La personne utilisant ce site Web, qui, sauf indication contraire, coïncide avec la personne concernée.</p>
            <p><strong>Personne concernée</strong></p>
            <p>La personne physique à laquelle se réfèrent les données personnelles.</p>
            <p><strong>Responsable du traitement des données (ou Responsable des données)</strong></p>
            <p>La personne physique ou morale, autorité publique, agence ou autre organisme qui traite les données personnelles pour le compte du Responsable du traitement, comme décrit dans cette politique de confidentialité.</p>
            <p><strong>Propriétaire (ou Responsable du traitement)</strong></p>
            <p>La personne physique ou morale, autorité publique, agence ou autre organisme qui, seule ou conjointement avec d\'autres, détermine les finalités et les moyens du traitement des données personnelles, y compris les mesures de sécurité concernant le fonctionnement et l\'utilisation de ce site Web. Sauf indication contraire, le Responsable du traitement est le Propriétaire de ce site Web.</p>
            <p><strong>Ce site Web (ou cette Application)</strong></p>
            <p>Le moyen par lequel les données personnelles de l\'utilisateur sont collectées et traitées.</p>
            <p><strong>Service</strong></p>
            <p>Le service fourni par ce site Web tel que décrit dans les termes relatifs (le cas échéant) et sur ce site/application.</p>
            <p><strong>Union européenne (ou UE)</strong></p>
            <p>Sauf indication contraire, toutes les références faites dans ce document à l\'Union européenne incluent tous les États membres actuels de l\'Union européenne et de l\'Espace économique européen.</p>
            <p><strong>Cookie</strong></p>
            <p>Les cookies sont des traceurs constitués de petits ensembles de données stockées dans le navigateur de l\'utilisateur.</p>
            <p><strong>Traceur</strong></p>
            <p>Un traceur désigne toute technologie - par exemple des cookies, des identifiants uniques, des balises Web, des scripts intégrés, des e-tags et des empreintes digitales - permettant de suivre les utilisateurs, par exemple en accédant ou en stockant des informations sur leur appareil.</p>
            <p><strong>Informations légales</strong></p>
            <p>Cette déclaration de confidentialité a été préparée sur la base de multiples législations, y compris les articles 13/14 du Règlement (UE) 2016/679 (Règlement général sur la protection des données).</p>
            <p>Cette politique concerne uniquement ce site Web, sauf indication contraire dans ce document.</p>
            <p>&nbsp;</p>',
        ],
    ],

    'general' => [
        'accommodation_not_found' => 'chambre non trouvée',
        'channel_unsupported_function' => 'Cette fonction n\'est pas supportée par ce canal',
        'rateplan_not_found' => 'plan tarifaire non trouvé',
        'accommodations' => 'Chambres',
        'unknown' => 'inconnu',
        'unauthorized' => 'Non autorisé',
        'expired_password' => 'Votre mot de passe a expiré. Veuillez le mettre à jour pour continuer.',
        'not_found' => 'Non trouvé',
        'not_found_or_not_authorized' => 'Ressource non trouvée ou autorisation refusée',
        'no_relationship_found' => 'aucune relation trouvée',
        'existing_periods' => 'des valeurs superposées sont présentes',
        'existing_condition' => 'condition déjà existante',
        'missing_accommodation_rateplan' => 'Plan tarifaire lié à la chambre manquant',
        'missing_accommodation_channel_source' => 'Chambre canal source manquante',
        'missing_accommodation_channel_destination' => 'Chambre canal destination manquante',
        'missing_accommodation_channel' => 'Chambre canal manquant',
        'missing_treatment_or_rateplan' => 'Traitement ou plan tarifaire non présent pour cette chambre',
        'same_source_destination' => 'Source et destination identiques',
        'impossible_delete_addon_category' => 'Impossible de supprimer la catégorie des services supplémentaires si elle est encore liée',
        'impossible_delete_system_addon_category' => 'Impossible de modifier ou de supprimer la catégorie des services supplémentaires système',
        'property_xml_already_connected' => 'PropertyXml déjà connecté à une autre structure',
        'city_tax' => 'Taxe de séjour',
        'taxs' => 'Taxes',
        'virtual_stamp' => 'Cachet virtuel',
        'default_group' => 'Groupe par défaut',
        'existing_mail' => 'Email existant',
        'unique_mail' => 'Email unique',
        'existing_username' => 'Nom d\'utilisateur existant',
        'unique_username' => 'Nom d\'utilisateur unique',
        'resource_conflict' => 'Conflit dans la ressource sélectionnée',
        'special_requests' => 'Demandes spéciales',
        'name' => 'Nom',
        'surname' => 'Prénom',
        'and' => 'et',
        'arrival' => 'Arrivée',
        'clean_fees' => 'Frais de nettoyage',
        'departure' => 'Départ',
        'adults' => 'Adultes',
        'adult' => 'Adulte',
        'children' => 'Enfants',
        'child' => 'Enfant',
        'eta' => 'Âge',
        'male' => 'Homme',
        'female' => 'Femme',
        'customer' => 'Client',
        'company' => 'Entreprise',
        'telephone' => 'Téléphone',
        'email' => 'E-mail',
        'nationality' => 'Nationalité',
        'too_many_login_attemps' => 'Trop de tentatives incorrectes. Vous pourrez réessayer dans :minute_unthrottle minutes',
        'country' => 'Pays',
        'coupon' => 'Coupon',
        'from' => 'De',
        'to' => 'À',
        'nights' => 'Nuittées',
        'payment_status' => 'Statut du paiement',
        'total' => 'Total',
        'reservation' => 'Réservation',
        'quote' => 'Devis',
        'di' => 'de',
        'stay' => 'Séjour',
        'extra' => 'Supplément',
        'tax' => 'Taxe',
        'payment' => 'Paiements',
        'del' => 'de',
        'channel' => 'Canal',
        'lodging' => 'Hébergement',
        'treatment' => 'Traitement',
        'accommodations_reserved' => 'Chambres réservées',
        'option_status_export' => 'Statut export',
        'option_revenue' => 'Données de revenus',
        'option_time' => 'Heures d\'export',
        'guest_card_service_not_connected' => 'Service non connecté à la structure ou de type incorrect',
        'guest_card_guests_number_error' => 'Nombre d\'invités insuffisant',
        'guest_card_date_from_error' => 'Modifications non autorisées. La date de début de validité est antérieure à aujourd\'hui.',
        'imp' => 'Imp',
        'iva' => 'TVA',
        'type' => 'Type',
        'documents' => 'Documents',
        'generic_payment' => 'Paiement générique',
        'accommodation' => 'Chambre',
        'accommodation_name' => 'Hébergement',
        'accommodation_total' => 'Total hébergement',
        'error' => 'Erreur',
        'status' => 'Statut',
        'language' => 'Langue',
        'guests' => 'Invités',
        'guest' => 'Invité',
        'paid' => 'Payé',
        'to_pay' => 'À payer',
        'suspended' => 'Suspendu',
        'to_be_invoiced' => 'À facturer',
        'note' => 'Note',
        'note_internal' => 'Notes internes de réservation',
        'note_internal_accommodation' => 'Notes internes à l\'hébergement',
        'note_customer' => 'Demandes du client',
        'note_checkin' => 'Notes pour l\'enregistrement',
        'note_checkout' => 'Notes pour le départ',
        'note_housekeeper' => 'Notes pour le personnel de ménage',
        'note_catering' => 'Notes repas',
        'note_bill' => 'Notes pour l\'émission de la facture',
        'bill_charged' => 'Facture débitée',
        'total_documents' => 'Total documents',
        'checkin_online' => 'Enregistrement en ligne',
        'cancellation' => 'Annulation',
        'no_show' => 'Non-présentation',
        'referral_id' => '#:referral_id:',
        'missing_param' => 'paramètre :param manquant',
        'properties' => 'structures',
        'amount' => 'Montant',
        'reservation_total' => 'Total réservation',
        'total_paid' => 'Total payé',
        'total_to_pay' => 'Total à payer',
        'general_error' => 'Erreur générale',
        'module_not_active' => 'Le module :moduleName n\'est pas actif pour les structures suivantes :',
        'reservation_summary' => 'Résumé de la réservation',
        'department_not_faund' => 'Département non trouvé',
        'department_exist' => 'Vous ne pouvez pas supprimer un département déjà associé à l\'imprimante fiscale',
        'upload_virus_found' => 'Le fichier téléchargé est corrompu ou malveillant',
        'upload_antivirus_service' => 'Le téléchargement du fichier a échoué, veuillez réessayer plus tard ou contacter le support',
        'document' => '{1} Document|[2,*] Documents',
        'reservation_to_queue_from_cart' => 'Nous traitons la réservation, une notification vous sera envoyée une fois les opérations terminées.',
        'active' => 'Actif',
        'expired' => 'Expiré',
        'export' => 'Exporter',
        'send_data' => 'Envoyer les données',
        'missing_credentials' => 'Nom d\'utilisateur ou mot de passe manquant',
        'yes' => 'Oui',
        'no' => 'Non',
        'door_key_codes' => 'Code d\'ouverture',
        'external_door_link' => 'Lien d\'ouverture de la porte extérieure',
        'accommodation_door_key_codes' => 'Code d’accès de l’hébergement :accommodationTableauLabel',
        'city_tax_report' => [
            'errors' => [
                'filter_not_available' => 'Filtre non disponible',
                'filter_format' => 'Format de filtre non accepté',
                'filter_number_arguments_exceeded' => 'Le nombre d\'arguments pour le filtre est dépassé',
            ],
        ],
        'fields' => [
            'field_update' => 'le champ :field de :oldValue à :newValue',
            'guest_type_id' => 'type d\'invité',
            'city_tax_exemption_id' => 'exemption de la taxe de séjour',
            'main_guest' => 'invité principal',
            'arrival_date' => 'date d\'arrivée',
            'departure_date' => 'date de départ',
            'roomreservation_id' => 'chambre',
            'checkin' => 'enregistrement',
            'checkout' => 'départ',
            'enabled' => 'activé',
            'disabled' => 'désactivé',
            'undefined' => 'non défini',
            'deleting' => 'Éléments supprimés :',
            'update_guest' => 'Pour l\'invité :name :surname (:id), les informations suivantes ont été modifiées : :fields',
            'delete_guest' => 'invité :name :surname (:id) :invoiced_city_tax',
            'invoiced_city_tax' => 'avec la taxe de séjour facturée',
            'arrival_lunch' => 'arrivée pour le déjeuner',
            'arrival_dinner' => 'arrivée pour le dîner',
            'arrival_not_set' => 'pas de préférence définie',
        ],
        'exceptions' => [
            'impossible_to_get_conversation_references' => 'Impossible d\'obtenir les informations de la conversation',
            'ota_channel_message_not_supported' => 'Le canal spécifié ne supporte pas l\'envoi de messages',
            'recipient_has_not_configured_email_address' => 'Le destinataire n\'a pas configuré d\'adresse email',
            'impossible_to_resend_not_failed_message' => 'Impossible de renvoyer un message qui n\'a pas échoué',
            'impossible_to_delete_this_message' => 'Impossible de supprimer ce message',
            'message_not_valid' => 'Les champs suivants ne sont pas valides :',
            'newsletter_config_not_valid' => 'Les champs suivants de la configuration ne sont pas valides :',
            'newsletter_not_valid' => 'Les champs suivants de la newsletter ne sont pas valides :',
            'newsletter_default_mail_not_valid' => 'Les champs suivants de l\'email par défaut ne sont pas valides :',
            'newsletter_condition_not_valid' => 'Les champs suivants de la condition de la liste d\'envoi ne sont pas valides :',
            'message_alredy_exists' => 'Message déjà présent',
            'some_uploaded_files_are_unsupported' => 'Certains fichiers téléchargés ne sont pas supportés',
            'attachments_not_permitted_for_channel' => 'Les pièces jointes ne sont pas autorisées pour ce canal de communication',
            'uploaded_too_many_images' => 'Vous pouvez envoyer une seule image par message',
            'you_cannot_send_message_that_contains_email_addresses' => 'Vous ne pouvez pas envoyer de message contenant des adresses email',
            'you_cannot_send_message_that_contains_url' => 'Vous ne pouvez pas envoyer de message contenant des URL',
            'you_cannot_send_message_that_contains_phone_number' => 'Vous ne pouvez pas envoyer de message contenant des numéros de téléphone',
            'you_cannot_receive_message_without_reservation_type' => 'Vous ne pouvez pas recevoir de message sans type de réservation',
            'impossible_to_set_message_read_status' => 'Impossible de modifier le statut de lecture du message',
            'gt_revenue_not_valid' => 'Les paramètres suivants pour l\'exportation des revenus GT ne sont pas valides :',
            'export_not_valid' => 'Les paramètres suivants pour générer l\'export ne sont pas valides :',
            'method_not_implemented' => 'La méthode :methodName du driver :driverName n\'est pas implémentée',
            'temporary_disabled_action_move_guest' => 'L\'action suivante est temporairement désactivée : veuillez supprimer l\'invité et le recréer dans la chambre désignée',
            'batch_job_not_found' => 'Travail en lot introuvable',
            'impossible_invoke_method' => 'Impossible d\'invoker cette méthode',
        ],
        'conversation_messages' => [
            'participant_alredy_exists' => 'Participant déjà associé à la conversation',
            'placeholder_photo' => 'Photo',
        ],
    ],

    'guest_presence' => [
        'summary' => 'Résumé de la présence des invités',
        'daily_summary_of_date' => 'Résumé quotidien du :date',
        'accommodation' => 'Hébergement',
        'accommodation_type' => 'Type d\'hébergement',
        'name_and_surname' => 'Nom et prénom',
        'age' => 'Âge',
        'sex' => 'Sexe',
        'stay' => 'Séjour',
        'stay_status' => 'Statut',
        'plan' => 'Étage',
        'property' => 'Propriété',
        'no_records' => 'Aucune donnée à afficher',
        'date' => 'Date',
        'export_title' => 'Présence des invités',
    ],

    'guest_reporting' => [
        'errors' => [
            'unable_to_delete_movements' => 'Impossible de supprimer les mouvements en raison de l’erreur suivante : :error',
            'unable_to_send_movements' => 'Impossible d’envoyer les mouvements en raison de l’erreur suivante : :error',
            'unable_to_check_movements_type' => 'Impossible de vérifier le type de mouvements en raison de l’erreur suivante : :error',
            'movements_type_not_valid' => 'Le type de mouvements de l’hébergement n’est pas valide pour ce portail',
            'cannot_delete_movements' => 'Impossible de supprimer les mouvements car la date d\'envoi ne correspond pas à la dernière date d\'envoi enregistrée par le portail',
            // toggler
            'generic_already_reported' => 'Élément déjà exporté',
            'reservation_already_reported' => 'Réservation :identifier déjà exportée',
            'reservation_accommodation_already_reported' => 'Hébergement :identifier déjà exporté',
            'reservation_accommodation_guest_already_reported' => 'Invité :identifier déjà exporté',
            'reservation_accommodation_guest_not_sent' => 'Invité non envoyé',
            'reservation_accommodation_guest_can_not_delete' => 'Impossible de supprimer l\'invité car il est déjà présent dans une fermeture mensuelle',
            'reservation_accommodation_guest_missing' => 'Invité non trouvé',
            // erreurs avec résumé pour invité
            'place_code_missing' => 'Code du lieu manquant. Contactez le support technique.',
            'cannot_be_single_guest' => 'Type d\'invité incorrect : ne peut pas être un invité seul.',
            'customer_has_incomplete_birth_place' => 'Lieu de naissance manquant ou incomplet.',
            'customer_has_incomplete_document_data' => 'Données des documents manquantes ou incomplètes.',
            'customer_has_incomplete_residence' => 'Code du lieu de naissance ou de résidence manquant, contactez le support.',
            'customer_has_invalid_gender' => 'Sexe non renseigné.',
            'customer_has_invalid_type' => 'Type d\'invité non valide.',
            'customer_has_no_birth_date' => 'Date de naissance manquante.',
            'customer_birth_date_in_future' => 'La date de naissance ne peut pas être dans le futur.',
            'customer_has_no_birth_city_country_place' => 'Codes de lieu et de pays de naissance manquants, contactez le support.',
            'customer_has_no_birth_place' => 'Lieu de naissance manquant ou incomplet.',
            'customer_has_no_name' => 'Prénom manquant.',
            'customer_has_no_nationality_or_has_null_code' => 'Nationalité manquante.',
            'customer_has_no_residence_city_country_place' => 'Codes de lieu et de pays de résidence manquants, contactez le support.',
            'customer_has_no_residence_place' => 'Code pays de résidence manquant, contactez le support.',
            'customer_has_no_surname' => 'Nom manquant.',
            'customer_has_no_data' => 'Veuillez remplir toutes les informations obligatoires.',
            'customer_has_not_present' => 'Aucun invité enregistré pour cette réservation.',
            'some_customer_has_not_present' => 'Les données de :customer_number invité|Les données de :customer_number invités ne sont pas présentes',
            'guest_has_no_customer_data' => 'Veuillez remplir toutes les informations obligatoires.',
            'invalid_length_of_stay' => 'Durée du séjour invalide',
            'invalid_row_size' => 'Longueur de la ligne de l\'hébergement invalide. Contactez le support technique',
            'invalid_value_size' => 'Longueur de champ invalide',
            'invalid_surname_size' => 'Longueur du nom invalide. Maximum 50 caractères autorisés',
            'invalid_name_size' => 'Longueur du prénom invalide. Maximum 30 caractères autorisés',
            'invalid_document_number_size' => 'Longueur du numéro de document invalide. Maximum 20 caractères autorisés',
            'invalid_released_size' => 'Longueur du lieu de délivrance du document invalide. Maximum 9 caractères autorisés',
            'must_be_single_guest' => 'Type d\'invité incorrect : insérer un invité seul.',
            // erreurs avec résumé pour regroupement
            'customer_has_no_leader' => 'Chef de groupe ou chef de famille manquant.',
            'family_leader_alone' => 'Chef de famille présent sans famille.',
            'family_member_alone' => 'Veuillez insérer un chef de famille.',
            'group_leader_alone' => 'Chef de groupe présent sans membres.',
            'group_member_alone' => 'Veuillez insérer un chef de groupe.',
            'multiple_family_leaders' => 'Il ne peut y avoir qu\'un chef de famille par hébergement.',
            'multiple_group_leaders' => 'Il ne peut y avoir qu\'un chef de groupe par réservation.',
            'invalid_group_leader_in_family' => 'Chef de groupe invalide (chef de famille présent).',
            'invalid_group_member_in_family' => 'Membre de groupe invalide (doit être un membre de la famille)',
            'invalid_family_leader_in_group' => 'Chef de famille invalide (chef de groupe présent)',
            'invalid_family_member_in_group' => 'Membre de famille invalide (doit être un membre)',
            'room_has_no_family_leader' => 'Veuillez insérer un chef de famille.',
            'room_has_many_leaders' => 'Il ne peut y avoir qu\'un chef de famille par hébergement.',
            'room_has_no_family_members' => 'Chef de famille présent sans famille.',
            // autres erreurs
            'no_exportable_guests' => 'Aucune fiche à exporter.',
            'no_istat_module_configured' => 'Groupe Istat non configuré.',
            'rooms_number_overflow' => 'Le nombre d\'hébergements occupés est supérieur au nombre d\'hébergements configurés dans le portail. Vérifiez les informations sous Configuration > Istat.',
            'unmapped_tableau_number' => 'Hébergement sans mappage. Vérifiez la configuration du groupe Alloggiati Web.',
            'no_tableau_number' => 'Aucun hébergement associé à la date : :date',
            'unexpected_date' => 'La date d\'exportation attendue est :date. Modifiez la date d\'exportation.',
            'unexpected_send_date' => 'La date d\'envoi attendue est :date. Modifiez la date d\'envoi.',
            'empty_italian_birth_city_code' => 'Code de la commune de naissance non trouvé. Contactez le support technique.',
            'empty_italian_birth_county_abbreviation' => 'Code de la province de naissance non trouvé. Contactez le support technique.',
            'empty_italian_residence_city_code' => 'Code de la commune de résidence non trouvé. Contactez le support technique.',
            'empty_italian_residence_county_abbreviation' => 'Code de la province de résidence non trouvé. Contactez le support technique.',
            // erreurs spécifiques de Sicile (dans les erreurs j\'ai uniquement le client)
            'guest_validation_failed' => 'L\'Observatoire Touristique de Sicile ne peut pas valider l\'invité :name.',
            // cela peut arriver si le séjour a été envoyé mais que quelqu\'un de l\'observatoire l\'a ensuite supprimé
            'sync_failed' => '\nUne tentative d\'envoi des présences ou des modifications pour des réservations supprimées manuellement par le portail Observatoire Touristique de Sicile a échoué. Désactivez l\'envoi de la réservation annulée ou réessayez l\'envoi.',
            // erreurs spécifiques à tourisme 5/Sicile
            'uncaught_forbidden' => 'Identifiants ou code de l\'établissement incorrects. Veuillez vérifier l\'exactitude des données.',
            // erreurs spécifiques du service web alloggiatiweb
            'wrong_username_password_wskey' => 'Nom d\'utilisateur, mot de passe ou WsKey incorrects',
            'generic_error' => 'Le portail n\'a pas répondu correctement. Réessayez plus tard.',
            'generic_error_send' => 'Le portail n\'a pas répondu correctement. Réessayez plus tard.',
            'missing_istat_code' => 'Code Istat non trouvé pour le lieu : :placeName. Veuillez contacter le support technique.',
            'alloggiatiweb_error_owner_apartment' => 'Il est nécessaire d\'utiliser les codes appartement pour ce compte. Activez la configuration pour l\'hébergement sous Configuration > Alloggiati Web.',
            'alloggiatiweb_error_owner_hotel' => 'Impossible d\'utiliser les codes appartement pour ce compte. Désactivez la configuration pour l\'hébergement sous Configuration > Alloggiati Web',
            'sicilia_web_service_outcome_empty_response' => 'Le portail n\'a pas répondu correctement. Réessayez plus tard.',
            'istat_the_portal_not_responding' => 'Le portail n\'a pas répondu correctement. Réessayez plus tard.',
            'istat_exemption_not_valid' => 'Exemption non prévue par ABIT',
        ],
        'success' => [
            'upload_recordset_completed' => 'Téléchargement des fiches terminé avec succès.',
        ],
        'webservice' => [
            'service_unavailable' => 'Service non disponible ou mal configuré.',
        ],
        'fields' => [
            'date_to_send' => 'Date d\'envoi',
            'date_to_export' => 'Date à exporter',
            'current_date' => 'Date actuelle',
            'last_sent_day' => 'Dernière date d\'exportation',
            'use_progression' => 'Progression à utiliser',
            'is_auto' => 'Type d\'envoi',
            'is_auto_description' => 'Envoi automatique/manual',
            'reference_date' => 'Date de référence pour la recherche',
            'operation_code_label' => 'Code de l\'opération',
            'operation_code_description' => 'Identifie l\'opération d\'envoi',
            'do_not_update_current_day_label' => 'Ne pas mettre à jour le jour actuel',
            'do_not_update_current_day_description' => 'Lorsque l\'istat est envoyé, la date du jour actuel n\'est pas mise à jour',
            'hotel_code' => 'Code de l\'hôtel',
            'property_list' => 'Liste des propriétés',
            'get_property_code' => 'Obtenez le code de la propriété',
            'username' => 'Nom d\'utilisateur',
            'password' => 'Mot de passe',
            'declared_available_rooms' => 'Nombre d\'hébergements effectivement disponibles à la vente',
            'declared_available_beds' => 'Nombre de lits effectivement disponibles à la vente',
            'guest_id' => 'ID de l\'invité',
            'guest_id_description' => 'ID de l\'invité à supprimer',
            'delete_movements_flag' => 'Confirmation de la suppression des mouvements',
            'delete_movements_flag_description' => 'Indicateur indiquant s’il faut procéder à la suppression des mouvements',
            'delete_movements_not_confirmed' => 'Êtes-vous sûr de vouloir supprimer les mouvements à partir de cette date ? Cette opération est irréversible.',
            'ricestat' => [
                // traductions personnalisées ricestat
                'username' => 'Nom d\'utilisateur Ricestat',
            ],
            'sicilia' => [
                // traductions personnalisées observatoire touristique sicilia
                'username' => 'UserID Observatoire Touristique',
                'hotel_code' => 'Code de l\'hôtel délivré lors de l\'inscription (si différent du nom d\'utilisateur)',
            ],
            'sired' => [
                // traductions personnalisées sired
                'declared_available_rooms' => 'Total des unités d\'hébergement potentiellement disponibles à la vente (quantité déclarée sur le portail)',
                'declared_available_beds' => 'Nombre de lits disponibles (quantité déclarée sur le portail)',
            ],
            'turismo5' => [
                // traductions personnalisées tourisme 5
                'hotel_code' => 'Code de la structure ou Code de la région',
                'declared_available_rooms' => 'Total des unités d\'hébergement potentiellement disponibles à la vente (quantité déclarée sur le portail)',
                'declared_available_beds' => 'Nombre de lits disponibles (quantité déclarée sur le portail)',
                'endpoint' => 'Zone géographique',
            ],
            'c59' => [
                // traductions personnalisées c59
                'c59_progression' => 'Progression à la date de référence',
                'c59_year' => 'Année de référence de la progression',
            ],
            'trento' => [
                // traductions personnalisées trento
                'declared_available_rooms' => 'Nombre de chambres disponibles',
            ],
            'astat' => [
                // traductions personnalisées astat
                'accommodationId' => 'HotelCode ou accommodationId',
                'prepare_local_tax' => 'Préparer la taxe de séjour',
                'close_month' => 'Fermer le mois',
                'token' => 'Jeton',
                'last_month_closed' => 'Dernier mois fermé',
                'property_closed_date_range' => 'Plage de dates de fermeture de la structure',
            ],
            'sinfonia' => [
                'cusr' => 'Identifiant de la structure',
                'api_key' => 'Clé API du système de gestion'
            ],
            'webtur' => [
                'cir' => 'Code d’Identification Régional de l’Établissement (CIR)',
                'cin' => 'Code d’Identification National de l’Hébergement (CIN)',
                'declared_available_rooms' => 'Nombre de chambres disponibles',
            ],
            'option_scheduled_label' => 'Voulez-vous activer l\'envoi automatique des fiches Istat ?',
            'option_scheduled_description' => 'Le système enverra automatiquement les fiches à partir de la date actuelle définie',
            'option_scheduled_send_every_hour_label' => 'Indiquez la fréquence d\'envoi des fiches Istat',
            'show_city_tax' => 'Afficher la taxe de séjour',
        ],
    ],

    'guest' => [
        'alloggiatiweb' => [
            'no_guests_txt' => 'Il n\'y a pas d\'invités enregistrés',
            'property_no_module_configured' => 'La structure n\'a pas configuré le module d\'Alloggiatiweb',
            'wrong_size_file' => 'Mauvaise taille de fichier, contactez l\'assistance',
            'wrong_arrival_date' => 'Mauvaise date d\'arrivée',
            'general_error' => 'Identifiants incorrects ou certificat invalide',
            'error_txt_file' => 'Erreur lors de la création du fichier',
            'post_upload_error' => 'Fichier invalide. Vérifiez le type de fichier',
            'invalid_certificate' => 'Certificat de fichier invalide',
            'certificate_and_password_required' => 'Certificat et mot de passe requis',
        ],
        'logger' => [
            'city_tax_log' => ':name :surname âgé(e) de :age ans (:first_date - :last_date pour :accommodation_name) Tot. :total_city_tax',
            'naming' => 'Invité :name :surname :',
            'checkin_date' => 'Check-in : :arrival_date => :checkin_date',
            'checkout_date' => 'Check-out : :departure_date => :checkout_date',
        ],
        'errors' => [
            'different_property_on_move' => 'La structure de la chambre désignée ne fait pas partie de votre groupe de structures',
            'family_master_already_in_room' => 'Impossible de continuer, le chef de famille est déjà dans la chambre de destination',
            'checkin_checkout_not_suitable' => 'Les dates de check-in ou check-out des invités ne sont pas compatibles avec la chambre de destination',
            'not_found' => 'Invité non trouvé',
            'city_tax_already_sent_to_channel' => 'L\'invité a déjà été envoyé aux portails de taxe de séjour connectés, impossible de continuer',
            'change_accommodation_with_invoiced_tax' => 'Impossible de changer le type de chambre pour un invité ayant des taxes de séjour facturées',
        ],
        'guest_cards' => [
            'empty_error' => 'Identifiants incorrects ou structure non activée.',
            'uknown_error' => 'Erreur inconnue du service externe',
            'venice_tax_exemption_type' => 'Exemption de la contribution d\'accès de la ville de Venise',
            'guest_required' => 'Il est nécessaire de spécifier l\'invité auquel associer la carte',
            'customer_fields_are_required' => 'Les champs suivants de l\'invité sont obligatoires : :fields',
            'customer_required_fields' => [
                'name' => 'Prénom',
                'surname' => 'Nom',
                'nic' => 'Numéro de sécurité sociale',
                'birthday_date' => 'Date de naissance',
                'birth_country.translations.0.name' => 'Lieu de naissance',
                'detail.email' => 'Email',
                'detail.telephone' => 'Téléphone',
                'detail.country.translations.0.name' => 'Résidence',
            ],
        ],
    ],

    'housekeeper' => [
        'main_title' => 'Gouvernante',
        'clean_status' => 'État',
        'name' => 'Gouvernante',
        'label' => 'Numéro',
        'accommodation' => 'Logement',
        'bed_type' => 'Aménagement',
        'bed_type_requested' => 'Aménagement demandé',
        'bed_type_last' => 'Aménagement précédent',
        'bed_type_next' => 'Prochain aménagement',
        'next_abbrevation' => 'Proch',
        'prev_abbrevation' => 'Préc',
        'guests' => 'Invités',
        'reservations' => 'Réservations',
        'guests_checkin' => 'Arrivées',
        'guests_in_home' => 'Arrêt',
        'guests_checkout' => 'Départs',
        'next_change_sheet' => 'Changement des draps',
        'day' => 'jour',
        'days' => 'jours',
        'today' => 'Aujourd\'hui',
        'notes' => 'Notes',
        'housekeeper_notes' => 'Notes de la gouvernante',
        'room_clean' => 'Propre',
        'room_dirty' => 'Sale',
        'adults' => 'Adultes: :count',
        'children' => 'Enfants: :count',
        'requested' => 'Demandé',
        'today' => 'Aujourd\'hui',
        'tomorrow' => 'Demain',
        'maintenance' => 'Maintenance',
        'export_fields' => [
            'cleaning' => 'Nettoyage',
            'accommodation' => 'Logement',
            'housekeeper' => 'Gouvernante',
            'status' => 'État',
            'staging' => 'Aménagement',
            'sheet' => 'Draps',
            'linen' => 'Linge',
            'details' => 'Détails',
            'created_at' => 'Date',
            'user' => 'Utilisateur',
            'scenario_title' => 'Scénario',
            'column1' => 'Date/Ressource',
            'column2' => 'Planification',
            'column3' => 'Heure',
            'scenario' => 'Planification',
            'housekeeper_collaborator' => 'En collaboration avec',
        ],
        'print' => [
            'number_of_accommodations' => ':number logements',
            'number_of_checkin' => 'Arrivées: :checkin_done sur :checkin_total',
            'number_of_checkout' => 'Départs: :checkout_done sur :checkout_total',
            'number_of_inhome' => 'En arrêt :number_in_home',
            'change_sheet' => 'Changement des draps',
            'change_linen' => 'Changement de linge',
            'note_housekeeper' => 'Notes pour la gouvernante',
            'pending_manteiner' => ':number signalements en attente de résolution',
            'status_checkin' => 'Arrivées',
            'status_checkout' => 'Départs',
            'status_in_home' => 'En arrêt',
            'status_label_adult' => ':adults Adultes',
            'status_label_children' => ':children_number Enfants',
            'passed_nights' => 'Nuit :passed_nights sur :total_nights',
        ],
        'bed_type_current' => 'Préparation demandée',
    ],

    'import' => [
        'customer' => [
            'job_name' => 'Clients',
            'warnings' => ['required_field' => 'champ obligatoire'],
            'tooltips' => [
                'skip_on_missing' => 'Les enregistrements du fichier importé qui ne contiennent pas de valeur pour ce champ seront ignorés lors de l’importation.',

                'sex_value' => '<br />Valeurs acceptées pour chaque paramètre :  
        <br />- Homme : male, maschio, uomo, m, man, maschile, u  
        <br />- Femme : female, femmina, donna, f, woman, femminile, d  
        <br />- Non spécifié : not_defined, non definito, non specificato, na, n/a, cellule vide  
        <br />Le système ne fait pas de distinction entre les majuscules et les minuscules, et accepte indifféremment “homme”, “HOMME” ou “Homme”.',

                'birth_country_required' => 'Pour permettre une correspondance correcte de la ville de naissance, ce champ doit également être associé. Le système accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO : 3166-1 (3 chiffres), 3166-1 alpha-2 (2 lettres), 3166-1 alpha-3 (3 lettres).',

                'birth_country' => 'Si seul le champ Pays de naissance est associé (sans la ville correspondante), le système attribue automatiquement la capitale du pays comme ville de naissance dans la fiche client. Le système accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO, sans distinction entre majuscules et minuscules.',

                'birth_city' => 'Pour permettre une correspondance correcte de la ville, il est nécessaire d’associer également le champ suivant : Pays de naissance. Le système accepte le nom de la ville dans n’importe quelle langue.',

                'citizenship_country' => 'Accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO : 3166-1 (3 chiffres), alpha-2 (2 lettres), alpha-3 (3 lettres), sans distinction entre majuscules et minuscules.',

                'language' => 'Le système accepte les langues prises en charge par Beddy : italien, anglais, français, allemand, espagnol, russe et japonais. Les autres langues sont définies par défaut sur l’anglais.  
    Les paramètres acceptés (sans distinction entre majuscules et minuscules) sont :  
    - ISO 639-1 (2 lettres), par exemple "fr"  
    - ISO 639-2 (3 lettres), par exemple "fra"  
    - Le nom complet de la langue, en italien, ou traduit en anglais, français, allemand ou espagnol, par exemple italien, italian, italien, italienisch, italiano  
    En cas de valeur absente ou de champ non associé, le système utilise la langue officielle du pays de résidence si disponible, sinon la langue par défaut.',

                'residence_city' => 'Pour permettre une correspondance correcte de la ville, il est nécessaire d’associer également le champ suivant : Pays de résidence. Le système accepte le nom de la ville dans n’importe quelle langue.',

                'residence_country_required' => 'Pour permettre une correspondance correcte de la ville de résidence, ce champ doit également être associé. Le système accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO : 3166-1 (3 chiffres), alpha-2 (2 lettres), alpha-3 (3 lettres).',

                'residence_country' => 'Si seul le champ Pays de résidence est associé (sans la ville correspondante), le système attribue automatiquement la capitale du pays comme ville de naissance dans la fiche client. Le système accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO, sans distinction entre majuscules et minuscules.',

                'residence_address' => ' Saisir une correspondance contenant uniquement l’adresse sans ville, code postal ni pays.',

                'email' => ' Saisir l’adresse e-mail, et non une éventuelle adresse PEC qui dispose d’un champ spécifique.',

                'document_type' => 'Accepte tous les types de documents prévus par le portail Alloggiati Web, sans distinction de majuscules ou minuscules. En outre, pour les documents les plus courants (carte d’identité, carte d’identité électronique, permis de conduire et passeport), le système accepte également les abréviations les plus communes, telles que CI, CIE, ID, PASS.',

                'released_country_required' => 'Pour permettre une correspondance correcte de la ville de délivrance, ce champ doit également être associé. Le système accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO.',

                'released_country' => 'Si seul le champ Pays de délivrance est associé (sans la ville correspondante), le système attribue automatiquement la capitale du pays comme ville de naissance dans la fiche client. Le système accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO, sans distinction entre majuscules et minuscules.',

                'released_city' => 'Pour permettre une correspondance correcte de la ville, il est nécessaire d’associer également le champ suivant : Pays de délivrance. Le système accepte le nom de la ville dans n’importe quelle langue.',

                'invoicing_country_required' => 'Pour permettre une correspondance correcte de la ville de facturation, ce champ doit également être associé. Le système accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO.',

                'invoicing_country' => 'Si seul le champ Pays de facturation est associé (sans la ville correspondante), le système attribue automatiquement la capitale du pays comme ville de naissance dans la fiche client. Le système accepte le nom du pays dans n’importe quelle langue ainsi que tous les codes ISO, sans distinction entre majuscules et minuscules.',

                'invoicing_city' => 'Pour permettre une correspondance correcte de la ville, il est nécessaire d’associer également le champ suivant : Pays de facturation. Le système accepte le nom de la ville dans n’importe quelle langue.',
            ],

            'columns' => [
                'name' => 'Prénom',
                'surname' => 'Nom',
                'sex' => 'Sexe',
                'birthday_date' => 'Date de naissance',
                'nic' => 'Numéro de sécurité sociale',
                'email' => 'Adresse e-mail',
                'pec' => 'Adresse PEC',
                'telephone' => 'Téléphone',
                'language' => 'Langue',
                'birth_country' => 'Pays de naissance',
                'birth_city' => 'Ville de naissance',
                'nationality_country' => 'Nationalité (ex. France)',
                'citizenship_country' => 'Pays de citoyenneté',
                'residence_country' => 'Pays de résidence',
                'residence_city' => 'Ville de résidence',
                'residence_address' => 'Adresse de résidence',
                'residence_zip_code' => 'Code postal de résidence',
                'invoicing_country' => 'Pays de facturation',
                'invoicing_city' => 'Ville de facturation',
                'invoicing_address' => 'Adresse de facturation',
                'invoicing_zip_code' => 'Code postal de facturation',
                'sdi_code' => 'Code SDI',
                'facebook' => 'URL Facebook',
                'linkedin' => 'URL Linkedin',
                'twitter' => 'URL Twitter',
                'skype' => 'Skype',
                'note' => 'Notes',
                'lottery_code' => 'Code de loterie',
                'document_type' => 'Type de document',
                'document_number' => 'Numéro de document',
                'expiration_date' => 'Date d\'expiration du document',
                'released_country' => 'Pays de délivrance du document',
                'released_city' => 'Ville de délivrance du document',
                'release_county' => 'Comté de délivrance du document',
                'release_state' => 'État de délivrance du document',
                'lang_values' => ['francese', 'french', 'français', 'französisch', 'francés', 'fra',],
                'sex_values' => [
                    'male' => [
                        'mâle',
                        'homme',
                        'm',

                    ],
                    'female' => [
                        'femelle',
                        'femme',
                        'f',
                    ],
                    'not_defined' => [
                        'non défini',
                        'non spécifié',
                    ],
                ]
            ],
        ],
        'company' => [
            'job_name' => 'Entreprises',
            'columns' => [
                'name' => 'Raison sociale',
                'vat_code' => 'Numéro de TVA',
                'nic' => 'Numéro de sécurité sociale',
                'nick_name' => 'Surnom',
                'email' => 'E-mail',
                'pec' => 'PEC',
                'telephone' => 'Téléphone',
                'country' => 'Pays',
                'city' => 'Ville',
                'address' => 'Adresse',
                'zip_code' => 'Code postal',
                'invoicing_country' => 'Pays de facturation',
                'invoicing_city' => 'Ville de facturation',
                'invoicing_address' => 'Adresse de facturation',
                'invoicing_zip_code' => 'Code postal de facturation',
                'sdi_code' => 'Code SDI',
                'facebook' => 'Facebook',
                'linkedin' => 'Linkedin',
                'twitter' => 'Twitter',
                'skype' => 'Skype',
                'note' => 'Notes',
            ],
        ],
        'booking_onboard_photo_property' => [
            'job_name' => 'Importer les photos de la structure depuis Booking',
        ],
        'common' => [
            'personal_informations' => 'Informations personnelles',
            'contacts' => 'Contacts',
            'residential_details' => 'Détails de la résidence',
            'invoice_address' => 'Détails de facturation',
            'documents' => 'Documents',
            'email' => 'E-mail',
            'other' => 'Autre',
        ],
        'sending_list_contacts' => [
            'job_name' => 'Liste des contacts',
            'columns' => [
                'label' => 'Étiquette',
                'email' => 'Adresse e-mail',
                'locale' => 'Langue',
            ],
        ],
        'errors' => [
            'request_params_not_valid' => 'Les paramètres suivants de la demande ne sont pas valides : ',
        ],
    ],

    'invoice_layouts' => [
        'errors' => [
            'delete' => [
                'one_or_more_receipt_modules_attached' => 'Il y a une ou plusieurs imprimantes fiscales associées à ce modèle de facturation. Pour supprimer ce profil de facturation, vous devez d\'abord supprimer les imprimantes fiscales ou les associer à un nouveau profil de facturation.',
            ],
        ],
    ],

    'invoice_received' => [
        'title' => 'Factures reçues',
        'export_fields' => [
            'document_date' => 'Date du document',
            'received_date' => 'Date de réception',
            'document_name' => 'Document',
            'sender_name' => 'Expéditeur',
            'sender_vat_code' => 'TVA expéditeur',
            'total_taxable' => 'Montant taxable',
            'total_taxes' => 'TVA',
            'total_document' => 'Total',
            'discount_amount' => 'Montant de la remise',
            'status' => 'Statut',
            'paid' => 'Payé',
            'amount_to_be_paid' => 'Montant à payer',
        ],
        'statuses' => [
            'unpaid' => 'Non payé',
            'paid' => 'Payé',
            'partially_paid' => 'Partiellement payé',
            'cancelled' => 'Annulé',
        ],
        'document_types' => [
            'RT01' => 'Retenue sur les personnes physiques',
            'RT02' => 'Retenue sur les personnes morales',
            'RT03' => 'Cotisation INPS',
            'RT04' => 'Cotisation ENASARCO',
            'RT05' => 'Cotisation ENPAM',
            'RT06' => 'Autre cotisation sociale',
            'TD01' => 'Facture',
            'TD02' => 'Acompte/Avance sur facture',
            'TD03' => 'Acompte/Avance sur note',
            'TD04' => 'Note de crédit',
            'TD05' => 'Note de débit',
            'TD06' => 'Note',
            'TD16' => 'Intégration de facture reverse charge interne',
            'TD17' => 'Intégration/facturation pour achats de services à l’étranger',
            'TD18' => 'Intégration pour achats de biens intracommunautaires',
            'TD19' => 'Intégration/facturation pour achats de biens selon l’art. 17, c. 2, D.P.R. n. 633/1972',
            'TD20' => 'Autofacturation pour régularisation et intégration des factures (art. 6, c. 8, D.Lgs. n. 471/1997 ou art. 46, c. 5, D.L. n. 331/1993)',
            'TD21' => 'Autofacturation pour dépassement de seuil',
            'TD22' => 'Extraction des biens du dépôt TVA',
            'TD23' => 'Extraction des biens du dépôt TVA avec paiement de la TVA',
            'TD24' => 'Facture différée selon l’art. 21, alinéa 4, lettre a)',
            'TD25' => 'Facture différée selon l’art. 21, alinéa 4, troisième période, lettre b)',
            'TD26' => 'Cession de biens amortissables et passages internes (ex art. 36 D.P.R. n. 633/1972)',
            'TD27' => 'Facture pour autoconsommation ou pour cessions gratuites sans reprise',
        ],
    ],

    'invoice' => [
        'export_fields' => [
            'payment_date' => 'Date de paiement',
            'number' => 'Numéro de facture',
            'business_name' => 'Raison sociale',
            'total_price' => 'Total',
            'vat' => 'TVA',
            'taxable' => 'Imposable',
            'invoice_date' => 'Date du document',
            'recipient_vat_code' => 'TVA destinataire',
            'number_complete' => 'Numéro complet',
            'recipient_business_name' => 'Dénomination',
            'total_with_discount' => 'Montant avec remise',
            'total_tax' => 'Total TVA',
            'total' => 'Total',
            'status_sdi' => 'SDI',
            'expire_date' => 'Date d\'expiration',
            'status' => 'Statut',
            'payment_term' => 'Termes de paiement',
            'customer_name' => 'Client',
            'payment' => 'Paiement',
            'date' => 'Date',
            'accountholder' => 'Titulaire du compte',
            'notes' => 'Notes',
            'paid' => 'Payé',
            'to_pay' => 'À payer',
            'property' => 'Propriété',
            'payment_status' => 'Statut du paiement',
            'data' => 'Données',
            'currency' => 'Monnaie',
            'total_document' => 'Document total',
        ],
        'statuses' => [
            'paid' => 'Payé',
            'suspended' => 'Suspendu',
            'cancelled' => 'Annulé',
        ],
        'sdi_statuses' => [
            '0' => 'Non envoyé',
            '1' => 'En attente',
            '2' => 'Rejeté',
            '3' => 'Terminé',
        ],
        'pdf_export' => [
            'description' => 'Description',
            'quantity' => 'Quantité',
            'amount' => 'Montant',
            'vat' => 'TVA',
            'vat_abbr' => 'TVA',
            'total' => 'Total',
            'invoice_label' => 'Fact.',
            'of_date' => 'du',
            'taxable' => 'Imposable',
            'deposit' => 'Acompte',
            'deposit_document_reference' => 'Référence du document',
            'aomount_not_taxable' => 'Montant non soumis à la TVA',
        ],
        'invoices_opened' => [
            'invoices_opened_title' => 'Paiements suspendus',
            'export_fields' => [
                'expire_date' => 'Date d\'expiration',
                'accountholder' => 'Titulaire du compte',
                'document_number' => 'Numéro du document',
                'date' => 'Date',
                'type' => 'Type',
                'paid' => 'Payé',
                'to_pay' => 'À payer',
                'total' => 'Total',
                'note' => 'Note',
                'property' => 'Propriété',
            ],
        ],
        'errors' => [
            'advance_not_suitable' => 'Acompte non compatible avec ce type de document',
            'credit_note_on_follows_invoice_paid' => 'Impossible d\'émettre une note de crédit sur une facture suivie déjà payée',
            'credit_note_on_follows_invoice_linked' => 'Impossible d\'émettre une note de crédit sur une facture suivie liée à un compte',
            'restore_on_follows_invoice_linked' => 'Impossible de restaurer un compte de document suivi lié à un autre compte',
            'cant_restore_opened_invoice' => 'Impossible de restaurer un compte non fiscalisé',
            'module_sdi_not_active' => 'Module de facturation électronique non activé',
            'refund_major_than_total_credit_note' => 'Remboursement de la note de crédit supérieur au total, impossible de continuer',
            'expense_on_invoice' => 'Impossible d\'associer une dépense à un document autre qu\'une note de crédit',
            'cant_resend_due_status' => 'L\'état actuel de SDI ne permet pas de renvoyer',
            'empty_xml' => 'Aucun XML trouvé',
            'cancellation_no_show_conflict' => 'Vous pouvez spécifier uniquement un type: no-show ou annulation',
            'cant_delete_credit_note' => 'Impossible de supprimer la note de crédit',
            'add_to_invoices_already_registered' => 'Impossible d\'ajouter des frais à des factures enregistrées ou des notes de crédit',
            'edit_invoices_already_registered' => 'Impossible de modifier des factures enregistrées',
            'delete_registered_invoice' => 'Impossible de supprimer une facture enregistrée',
            'impossible_delete_until_moves' => 'Impossible de supprimer le compte, transférez d\'abord les frais sur d\'autres comptes avant de procéder',
            'not_exist' => 'Facture inexistante',
            'vat_payment_impossible_for_receipt' => 'Impossible de définir une exigibilité TVA différente pour une réception fiscale',
            'unrestorable_bill' => 'Facture non récupérable',
            'impossible_discount_for_discounted_bills' => 'Impossible d\'appliquer un rabais à une facture déjà réduite',
            'refundable_bill_in_invoice' => 'Impossible d\'ajouter une référence de remboursement à une note de crédit',
            'impossible_manual_charge_updating' => 'Impossible de modifier cette charge manuellement',
            'impossible_follows_invoice_updating' => 'Impossible de modifier une charge liée à une facture suivie',
            'impossible_associate_invoice_as_advance' => 'Impossible d\'associer une facture normale comme acompte',
            'advances_over_allowed' => 'La valeur fixée pour la facture d\'acompte dépasse la valeur autorisée',
            'fp_advances_with_different_department' => 'Les reçus d\'acompte sélectionnés doivent avoir le même taux de TVA',
            'advances_no_have_department' => 'Le département utilisé dans l\'acompte doit être présent dans les charges du reçu final.',
            'advances_total_major' => 'Le montant de l\'acompte ne peut pas dépasser la somme des charges ayant le même département que le reçu d\'acompte.',
            'invoice_totally_refunded' => 'Facture totalement remboursée, impossible de continuer',
            'advance_with_different_customer' => 'Facture d\'acompte non associable en raison de destinataires différents',
            'advance_totally_assigned' => 'Facture d\'acompte totalement associée, impossible de rembourser',
            'deposit_in_general_invoice' => 'Impossible d\'attribuer un acompte à un compte général',
            'bill_overrated' => 'Le montant du paiement est supérieur au total de la charge associée',
            'invoice_overrated' => 'Le montant du paiement est supérieur au total de la facture associée',
            'property_not_attached' => 'Propriété non associée',
            'funds_params_unsuitable' => 'Paramètres incompatibles avec la caisse',
            'registered_advance_invoice' => 'Facture d\'acompte enregistrée, supprimez d\'abord les factures associées',
            'registered_sdi invoice' => 'Facture d\'acompte envoyée à SDI, non supprimable',
            'move_between_different_types' => 'Impossible de déplacer des frais entre factures et notes de crédit ou vice versa',
            'discount_over' => 'Rabais appliqué supérieur au total des charges réduites',
            'archive_completed' => 'Archive déjà complète',
            'too_many_tasks' => 'Trop de tâches en cours',
            'archive_warning' => 'Certains fichiers sont manquants',
            'archive_complete' => 'Complet',
            'invoice_registered' => 'Document déjà émis, impossible de continuer',
            'bill_tranfer_follows_invoice' => 'Impossible de transférer une charge générée par un reçu de facture suivie',
            'bill_generic_and_follows_invoice' => 'Vous ne pouvez pas ajouter à la fois des lignes génériques et des lignes générées par un reçu de facture suivie',
            'different_vat_code_follows_invoice' => 'Facture de suivi détectée avec un code TVA différent de la facture récapitulative, impossible de continuer',
            'receipt_with_follows_invoice' => 'Il est impossible d\'émettre une facture récapitulative en la définissant comme reçu',
            'type_not_invoice_summary' => 'Vous ne pouvez pas associer des documents non perçus au type de document actuel',
            'archive_all_file_not_found' => 'Aucun fichier trouvé',
            'impossible_apply_discount_row_on_discounted_invoice' => 'Impossible d\'appliquer un rabais à la ligne si la facture a déjà un rabais',
            'cant_delete_invoice_due_convention' => 'Impossible de supprimer la facture car elle est associée à une convention',
            'discount_on_invoice_and_on_row' => 'Impossible d\'enregistrer une facture avec un rabais si des charges réduites sont présentes',
            'discount_on_summary_invoice' => 'Impossible d\'appliquer un rabais à une facture récapitulative',
            'cant_delete_invoice_due_linked_advances' => 'Impossible de supprimer une facture d\'acompte liée à d\'autres factures',
            'cant_delete_invoice_due_credit_notes' => 'Impossible de supprimer un document déjà annulé',
            'cant_delete_invoice_due_module_fattelettronica' => 'Impossible de supprimer la facture car elle a déjà été enregistrée et/ou envoyée à SDI',
            'cant_restore_invoice_due_sdi_ns' => 'Impossible de restaurer le compte. La facture a été rejetée par SDI et doit être renvoyée avec le même numéro et la même date.',
            'cant_transfer_due_invoice_registered' => 'Impossible de déplacer une facture déjà enregistrée',
            'cant_merge_credit_note' => 'Impossible de fusionner des notes de crédit',
            'cant_merge_due_module_fattelettronica' => 'Impossible de fusionner une facture envoyée à SDI',
            'cant_transfer_without_holder' => 'Vous ne pouvez pas transférer un compte sans titulaire',
            'empty_row_document' => 'Veuillez insérer au moins une ligne dans le document',
            'cant_delete_receipt' => 'Impossible de supprimer un reçu fiscal',
            'addon_unrelated' => 'Impossible d\'associer le service supplémentaire à ce compte',
            'impossible_add_row' => 'Impossible d\'ajouter une ligne à un document facturé ou inexistant',
            'uncharged_rows_found_on_restore' => 'Impossible de restaurer la facture : les frais associés sont actuellement présents dans un compte ouvert avec un remplacement, veuillez restaurer les valeurs originales avant de continuer',
            'cant_create_temporary_due_missing_layout' => 'Impossible de créer le document car aucun modèle de facturation n\'est disponible',
            'move_bill_over_discount' => 'Impossible de transférer la charge car la valeur restante serait inférieure à zéro. Le maximum transférable est : :max_threshold',
            'cant_decrement_price_invoiced_bill' => 'Impossible de diminuer le prix d\'une charge déjà facturée',
            'printer_id_not_associated' => 'Identifiant de l\'imprimante fiscale non associé au profil de facturation',
            'cant_move_reservation_due_advance_invoice' => 'Il existe des factures d\'acompte. Pour déplacer la réservation, vous devez émettre une facture finale ou une note de crédit.',
            'cant_move_reservation_due_deposit' => 'Il existe des dépôts. Pour déplacer la réservation, vous devez les supprimer ou les rembourser.',
            'cant_move_reservation_due_payments' => 'Il existe des paiements. Pour déplacer la réservation, vous devez les supprimer ou les rembourser',
            'cant_update_invoice_balance' => 'Impossible de modifier les données relatives à une facture finale',
            'cant_update_invoice_balance_layout' => 'Impossible de modifier la mise en page si elle n\'est pas compatible avec la TVA du modèle actuel',
            'cant_register_invoice_balance_price' => 'Le total de la facture doit correspondre au total du paiement',
            'cant_choose_payment_deposit_different_property' => 'Il est impossible d\'utiliser le dépôt numéro :deposit_number pour ce document car il appartient à une autre propriété',
            'cant_choose_payment_advance_different_property' => 'Il est impossible d\'utiliser la facture d\'acompte numéro :number_complete car elle appartient à une autre propriété',
            'cant_create_invoice_layout_without_vat_code_without_properties_enabled' => 'Il est impossible de créer un profil de facturation sans TVA pour des propriétés non habilitées à émettre des taxes de séjour',
            'unable_to_register_not_all_inclusive_tax_document_addons' => 'Il existe des frais non autorisés pour la taxe de séjour, veuillez les modifier dans la configuration ou les associer à des frais autorisés sur le compte',
            'tax_bills_rows_joined_with_other_type_bills_on_all_tax_inclusive_document' => 'Il existe des frais de type taxe associés à d\'autres types de frais, veuillez rétablir la situation sans inclure des taxes avec d\'autres éléments de compte avant de continuer',
            'all_tax_inclusive_layout_on_fiscal_printer' => 'Impossible d\'associer un profil de facturation sans TVA à une imprimante fiscale',
            'all_inclusive_tax_document_for_advance' => 'Il est impossible d\'émettre un document d\'acompte avec les paramètres de taxe de séjour',
            'advances_on_all_inclusive_tax_doument' => 'Il est impossible de compenser les documents d\'acompte avec taxe de séjour',
            'credit_note_on_all_inclusive_tax_document' => 'Impossible d\'émettre une note de crédit pour la taxe de séjour, procédez avec l\'annulation',
            'missing_department_override' => 'Département d\'imprimante fiscale manquant pour la charge :name',
            'missing_department' => 'Département d\'imprimante fiscale manquant pour le taux de TVA :vat_quote % de type ',
            'advance_bill_not_found' => 'Acompte non trouvé',
            'totals_bills_not_equals' => 'La somme des lignes ne correspond pas au total du document',
            'multiple_invoices_bill_rows_override' => 'Il est impossible de créer un remplacement pour des lignes de documents différents',
            'cant_create_override_for_registered_invoice' => 'Impossible de créer, modifier ou supprimer un remplacement pour un document fiscalisé ou inexistant',
            'cant_edit_print_settings_for_registered' => 'Impossible de modifier les options d\'impression pour un document fiscalisé ou inexistant',
            'not_found' => 'Document non trouvé',
            'no_attachments' => 'Il n\'y a pas de pièces jointes pour ce document',
            'error_attachments' => 'Une erreur s\'est produite lors du téléchargement des pièces jointes',
            'advance_with_all_inclusive_tax_document' => 'Impossible d\'émettre une facture d\'acompte dans le régime de taxe de séjour',
            'empty_email' => 'Veuillez entrer une adresse email',
            'empty_email_pdf' => 'Document pdf non disponible',
            'advance_partially_used' => 'Impossible d\'émettre une note de crédit sur une facture d\'acompte utilisée',
            'different_vat_payment_on_advance' => 'Impossible d\'associer des factures d\'acompte avec une TVA différente',
            'cant_delete_credit_note_due_to_sdi_or_fp' => 'Impossible de supprimer des notes de crédit envoyées à SDI ou annulées avec une imprimante fiscale',
            'cant_delete_credit_note_between' => 'Impossible de supprimer une note de crédit ou une annulation de frais appartenant à plusieurs documents facturés',
            'destination_deleted' => 'Le destinataire appartient à un profil supprimé du système.',
            'vat_code_not_valid' => 'Le code TVA saisi est invalide',
            'tax_code_not_valid' => 'Le code fiscal saisi est invalide',
            'empty_codes' => 'Le code fiscal ou le code TVA sont invalides',
            'row_exceed_total_price' => 'La ligne à rembourser dépasse le montant total original',
            'row_exceed_qty' => 'La ligne à rembourser dépasse la quantité originale',
            'cant_register_invoice_as_follows_invoice' => 'Impossible d\'émettre une facture en mode \'suivi de facture\' ',
            'cant_register_rejected_invoice_as_receipt' => 'Impossible d\'émettre un document rejeté en tant que reçu, corrigez les incohérences signalées et renvoyez-le dans les 5 jours',
            'cant_turn_to_paid_follows_invoice' => 'Impossible de marquer comme \'payé\' un reçu en mode \'suivi de facture\'',
            'reversal_on_receipt_follows_invoice_joined' => 'Impossible d\'émettre une note de crédit pour un reçu suivi de facture associé à une facture récapitulative',
            'receipt_channel_must_activated' => 'Pour configurer l\'imprimante virtuelle, vous devez activer le module <em>Interface systèmes tiers</em>. <br /> Veuillez contacter votre consultant Zucchetti pour ajouter ce module à votre licence Beddy.',
            'partial_cannot_exceed_total' => 'Le montant ne peut excéder le total du document à annuler',
            'partial_cannot_exceed_percentage' => 'Le pourcentage ne peut excéder le total du document à annuler',
            'credit_note_partial_on_advance' => 'Impossible de procéder avec une note de crédit partielle pour un document d\'acompte',
            'credit_note_partial_on_fp_send' => 'Impossible de procéder avec un annulé partiel pour un document lié à une imprimante fiscale',
            'credit_note_partial_on_follows_invoice' => 'Impossible de procéder avec un annulé partiel pour un document suivi de facture',
            'row_to_refund_not_found' => 'Ligne à rembourser non trouvée',
            'partial_only_credit_note' => 'Les partiels ne peuvent être calculés que pour une note de crédit',
            'partial_credit_note_total_payment_exceed_source_payment' => 'Le total des paiements excède le total du document',
            'payment_not_belonging_to_invoice_source' => 'Le paiement sélectionné n\'appartient pas au document source',
            'payment_not_found' => 'Le paiement sélectionné n\'existe pas',
            'partial_credit_note_row_payment_exceed_source_payment' => 'Le total du paiement sélectionné excède le total du paiement originel',
            'city_tax_bills_partial_refund' => 'Impossible de procéder avec le remboursement partiel des frais de taxe de séjour',
            'credit_note_paid_major_than_total' => 'Le total des paiements du document dépasse le montant total',
            'discount_over_permitted' => 'La remise appliquée dépasse le total maximum autorisé hors taxes',
        ],
        'errors_xml' => [
            'error_additional_charges_are_required_to_issue_the_receipt' => 'La différence entre le solde et les acomptes (:totalPayments €) est inférieure à la valeur nécessaire (:subtractPayment €) pour clôturer le document, car chaque poste doit valoir au moins 0,01 €. Augmentez un débit de :amountRequired € ou regroupez les débits par catégorie ou service pour obtenir un nombre de postes inférieur.',
            'error_total_cannot_be_less_than_one_cent' => 'Le total du document doit être supérieur au total des acomptes (au moins 0,01 €)',
            'payment_not_valid' => 'Méthode de paiement invalide',
            'tax_system' => 'Régime fiscal de l\'émetteur invalide. Configurez le régime fiscal dans le profil de facturation',
            'cap' => 'Code postal de l\'émetteur invalide',
            'destination_code' => 'Code destinataire invalide',
            'destination_code_pa' => 'Code destinataire invalide pour la PA',
            'destination_code_pr' => 'Code destinataire invalide pour le privé',
            'destination_cf' => 'Code fiscal du destinataire invalide',
            'destination_cap' => 'Code postal destinataire invalide',
            'address' => 'Adresse de facturation non renseignée',
            'empty_row_description' => 'Veuillez entrer la description de toutes les lignes du document',
            'department_fp' => 'Département avec taux TVA non présent',
            'payment_error' => 'Erreur détail paiement',
            'payment_error_amount' => 'Le montant total du document est inférieur au total des paiements indiqués',
            'payment_error_code' => 'Code paiement invalide: ',
            'nature' => 'Nature non renseignée, pour un taux de TVA égal à zéro',
            'reverse_charge' => 'Vous ne pouvez pas appliquer le reverse charge et la scission des paiements simultanément.',
            'error_sdi' => 'Erreur envoi SDI. Vérifiez les valeurs saisies.',
            'document_no_xml' => 'Type de document non activé pour XML',
            'not_found' => 'XML non trouvé',
            'error_send_invoice' => 'Erreur envoi fournisseur',
            'limit_document_id' => 'Le numéro de document :id_document n\'est pas valide car il dépasse la limite de 20 caractères',
            'error_import_invoice' => 'Importation rejetée',
            'xsd_validation_skip' => 'Problème de validation xsd. Validation ignorée',
            'xsd_validation_failed' => 'La valeur saisie (:value) de l\'élément :node n\'est pas valide',
            'error_limit_number_invoice' => 'Impossible d\'envoyer le fichier. Documents épuisés. Contactez l\'assistance',
            'error_account_inactive' => 'Le compte n\'est pas actif auprès du fournisseur de facturation. Contactez l\'assistance',
            'payment_error_vat_quote' => 'Taux de TVA différents entre le montant total et l\'acompte.',
            'error_content_document' => 'Contenu du document incorrect, contactez l\'assistance',
            'error_create_document' => 'Erreur dans la création du document XML, contactez l\'assistance.',
            'error_xml_format_received' => 'Xml de réponse invalide.',
            'error_empty_response' => 'Xml de réponse vide.',
            'error_zip_archive_creation' => 'Erreur dans la création du fichier zip.',
            'error_empty_document' => 'Document XML vide, contactez l\'assistance.',
            'voucher_code_not_valid' => 'Le code de bon saisi n\'est pas valide.',
            'custom' => [
                'limit_message_content' => 'Le contenu du message dépasse la limite de 42 caractères.',
            ],
            'rch' => [
                'limit_message_content' => 'Le contenu du message dépasse la limite de 25 caractères.',
            ]
        ],
        'warnings' => [
            'document_not_found' => 'Aucun document trouvé avec ID :invoice_id',
            'city_tax_charged_for_guest' => 'Taxe facturée pour l\'invité, voulez-vous continuer ?',
            'vat_code_already_joined' => 'Le profil est déjà associé à des factures ou paiements, il est impossible de modifier le numéro de TVA ou les données d\'en-tête',
            'all_inclusive_tax_document_with_vat_code' => 'Document de taxe de séjour incompatible avec émission via numéro de TVA',
            'cant_restore_bill_invoiced' => 'La charge est facturée, impossible de la restaurer',
            'cant_restore_bill_stay_not_involved' => 'La charge est liée à des dates non présentes dans le séjour, voulez-vous la supprimer ?',
            'cant_restore_bill_not_related' => 'Impossible de restaurer cette charge car la ressource n\'est plus présente',
            'cant_update_bill_day_price' => 'Impossible de modifier le prix du jour :date car le total à facturer pour le payeur est inférieur à la différence de prix',
            'cant_update_bill_day_price_due_convention' => 'Le payeur de la charge du jour :date ne correspond pas à la division du compte, veuillez procéder à la modification du montant directement dans la section des frais',
            'cant_delete_bill_stay' => 'Impossible de supprimer une charge de séjour',
            'cant_delete_due_to_joined_documents' => 'Impossible de supprimer une charge présente dans des documents émis',
            'number_used' => 'Le numéro de facture a déjà été utilisé',
            'number_no_sequential' => 'Le numéro utilisé doit être compris entre la date de la facture précédente et la date de la facture suivante',
            'transferred_bills_present' => 'Le compte présente des charges transférées de réservation, cette opération les supprimera définitivement ou les annulera',
            'layout_numbers_existing' => 'Il existe des numérotations progressives actives pour cette TVA ou ce numéro de Code Fiscal, souhaitez-vous les remplacer par les numérotations définies dans ce nouveau profil de facturation ? Veuillez vérifier le numéro des derniers documents émis par cette TVA ou Code Fiscal.',
            'additional_info_block_only_for_invoice' => 'Impossible d\'insérer des informations supplémentaires pour ce type de document',
            'detach_not_collected_document' => 'En changeant le type de document, les documents non collectés associés seront supprimés. Voulez-vous continuer ?',
            'cant_restore_general_bill' => 'Impossible de restaurer le débit du compte intermédiaire, veuillez procéder au transfert manuellement',
        ],
        'pdf' => [
            'accommodations' => 'Séjour',
            'addons' => 'Extras',
            'advances' => 'Acomptes',
            'taxes' => 'Taxes',
            'deposits' => 'Dépôts',
            'credit_note_reversal' => 'Annulations reçues',
            'advance_with_number_complete' => 'Facture d\'acompte n° :number_complete',
            'payment' => 'Paiement',
            'taxation_list' => 'Résumé TVA',
            'taxable_amount' => 'Montant imposable',
            'tax_amount' => 'Taxes',
            'total' => 'Total',
            'total_taxes' => 'Total taxes',
            'total_taxable' => 'Total imposable',
            'total_taxation' => 'Total TVA',
            'total_amount' => 'Montant total',
            'total_paid' => 'Payé',
            'total_to_pay' => 'À payer',
            'document_heading' => 'Document n° :identifier du :date',
            'document_advance_heading' => 'Réservation #:identifier - Acompte',
            'document_heading_no_date' => 'Document n° :identifier',
            'document_num' => 'Document n°',
            // DÉCONSEILLÉ :
            'document_date' => 'du',
            // DÉCONSEILLÉ :
            'payable' => 'Document non fiscal',
            'proforma' => 'Facture proforma',
            'additional_information' => 'Informations supplémentaires',
            'additional_information_contract' => 'Contrat',
            'additional_information_purchase_order' => 'Bon de commande',
            'additional_information_agreement' => 'Convention',
            'additional_information_receiving' => 'Réception',
            'additional_information_joined_invoices' => 'Factures liées',
            'additional_information_progress_status' => 'État d\'avancement',
            'additional_information_document_id' => 'ID document',
            'additional_information_line_number_referral' => 'Numéro de ligne',
            'additional_information_num_item' => 'ID de ligne',
            'additional_information_date' => 'Date',
            'additional_information_agreement_deal_code' => 'Code de commande',
            'additional_information_cup' => 'Code CUP',
            'additional_information_cig' => 'Code CIG',
            'additional_information_step_reference' => 'Référence étape',
            'invoice' => 'Facture',
            'unregistered_invoice' => 'Compte',
            'receipt' => 'Reçu',
            'credit_note' => 'Note de crédit',
            'proforma' => 'Proforma',
            'auto_invoice' => 'Autofacture',
            'reverse_auto_invoice' => 'Annulation Autofacture',
            'debit_note' => 'Note de débit',
            'destination' => 'Destinataire',
            'causal' => 'Motif',
            'extra_notes' => 'Notes',
            'attachments' => 'Pièces jointes',
            'sdi_send_date' => 'Date d\'envoi SDI',
            'rounding' => 'Arrondi',
            'vat_payment' => [
                'D' => 'TVA à exigibilité différée',
                'I' => 'TVA à exigibilité immédiate',
            ],
            'payment_method' => 'Mode de paiement',
            'iban' => 'IBAN',
            'institution' => 'Institution',
            'credit_institution' => 'Établissement de crédit',
            'amount_virtual_stamp' => 'Montant du timbre',
            'discount' => 'Remise',
            'discount_amount' => 'Remise ou majoration',
            'receipts' => 'Liste des reçus',
            'reversal' => 'Liste des annulations de reçus',
            'receipts_expired' => 'Liste des reçus avec l\'état "expirés"',
            'receipts_unpaid' => 'Liste des reçus avec l\'état "à payer"',
            'receipts_suspended' => 'Liste des reçus avec l\'état "suspendus"',
            'receipts_paid' => 'Liste des reçus avec l\'état "payé"',
            'payments' => 'Paiements',
            // anciennement "Autres paiements"
            'payment_date' => 'Date de paiement',
            'payment_label' => 'Payeur',
            'payment_method' => 'Méthode',
            'amount_available' => 'Montant disponible',
            'amount_used' => 'Montant utilisé',
            'deposit' => 'Dépôt',
            'copy_text' => 'Copie de courtoisie sans valeur fiscale au sens de l\'article 21 Dpr 633/72. L\'original a été transmis au SDI (Système d\'Échange) et est disponible dans votre espace réservé de l\'Agence des Revenus.',
        ],
        'wording' => [
            'virtual_stamp_causal_more' => 'Droit de timbre acquitté de manière virtuelle conformément à l\'article 6 du DM 17/06/2014',
            'all_inclusive_tax_document_exemption' => 'Exonération - Art.3 du D.lgs n. 23 du 14/03/2011',
            'standard_advance' => 'Réservation #:reference_number - Acompte',
            'manual_fp_register' => 'comme document déjà fiscalisé',
            'follows_invoice' => 'suit la facture',
            'default' => 'standard',
            'force_change' => 'forcer la modification des charges'
        ],
        'art17' => 'Opération soumise au split payment avec TVA non perçue par le vendeur conformément à l\'ancien article 17-ter du DPR 633/1972.',
        'art6' => 'Opération soumise à la TVA différée conformément à l\'article 6, alinéa 5 du DPR 633/1972.',
        'invoice_module' => [
            'invalid_vat_code' => 'N° de TVA invalide',
            'invalid_invoice_channel' => 'Sélectionnez un canal valide',
            'error_get_data' => 'Erreur lors de la récupération des informations du compte',
            'vat_code_exist' => 'Un module avec ce n° de TVA existe déjà',
            'error_fiscal_printer_linked' => 'Des reçus fiscaux émis sont liés à l\'imprimante. Voulez-vous supprimer ?',
            'customer' => 'Client',
            'subcontracting' => 'Sous-traitance'
        ],
        'invoice_import' => [
            'import_success' => 'Fichiers importés avec succès',
            'import_skip' => 'Fichiers ignorés (n° de TVA destinataire invalide ou fichier déjà importé)',
            'import_error' => 'Erreur d\'importation, fichier XML invalide',
        ],
        'no_show' => [
            'invoice_label' => 'No Show',
            'invoice_cancellation' => 'Annulation',
            'no_vat_quote_defined' => 'La structure n\'a pas de taux de TVA défini pour :type',
        ],
        'cancellation' => [
            'invoice_label' => 'Pénalité d\'annulation',
        ],
        'lottery_code' => 'Code Loterie : :lottery_code',
        'log' => [
            'title' => 'facturation',
            'advance' => 'facture :invoice_number du :invoice_date avec profil de facturation :invoice_layout (:invoice_business_name - :invoice_vat_code) et adressée à :invoice_customer (Total :invoice_total)',
            'refunded_advance' => 'Le :amount du :number document du :date est à nouveau disponible',
            'partial_credit_note' => 'Le document :number_complete a remboursé le document :invoice_source_number de :credit_note_total : :bill_logs',
        ],
        'types' => [
            'reversal' => 'Reçu d\'annulation',
            'credit_note' => 'Note de crédit',
            'receipt' => 'Reçu',
            'invoice' => 'Facture',
            'proforma' => 'Proforma',
            'auto_invoice' => 'Autofacture',
            'debit_note' => 'Note de débit',
            'reverse_auto_invoice' => 'Annulation autofacture',
            'unregistered_invoice' => 'Compte',
        ],
        'open_charges' => 'Comptes ouverts',
        'operational_headquarter' => 'Siège opérationnel',
        'advances' => 'Acomptes',
        'log_module' => [
            'invoice_module_updated' => 'Module de facturation modifié',
            'invoice_module_created' => 'Module de facturation créé',
            'invoice_module_deleted' => 'Module de facturation supprimé',
        ]
    ],

    'logger' => [
        'field_updated' => 'Mis à jour :section [:field] de :old_value à :new_value',
        'titles' => [
            'queue_update' => 'Mise à jour de la file d\'attente',
            'bulk_update' => 'Mise à jour en masse',
            'new_reservation' => 'Nouvelle réservation',
            'update_reservation_status' => 'Changement de statut de réservation',
            'cancel_accommodation' => 'Annulation de l\'hébergement réservé',
            'move_accommodation' => 'Hébergement réservé déplacé',
            'update_accommodation' => 'Hébergement réservé mis à jour',
            'update_accommodation_arrival' => 'Date d\'arrivée mise à jour',
            'update_accommodation_departure' => 'Date de départ mise à jour',
            'add_accommodation' => 'Hébergement ajouté à la réservation',
            'reservation_status' => 'Statut de réservation mis à jour',
            'cancel_reservation' => 'Réservation annulée',
            'delete_reservation' => 'Réservation supprimée',
            'cancel_reservation_no_new' => 'Réservation annulée sans statut nouveau',
            'clone_rates' => 'Clonage de :channel_source à :channel_destination',
            'clone_rates_bulk' => 'Mise à jour en masse depuis le clonage',
            'payment_transaction' => 'Transaction de paiement',
            'update_accommodation_listing_price' => 'Mise à jour du prix de l\'hébergement pour :channel_destination',
            'accommodations_overview' => 'Aperçu quotidien',
            'reset_min_stay' => 'Réinitialiser le séjour minimum',
            'tableau_closure_create' => 'Création de fermetures de tableau',
            'tableau_closure_delete' => 'Suppression de fermetures de tableau',
            'attach_channel' => 'Canal connecté :channel_name',
            'detach_channel' => 'Canal déconnecté :channel_name',
            'read_channel' => 'Lecture des données du canal :channel_name',
            'increase_quantity' => 'Augmentation de la quantité d\'hébergements',
            'decrease_quantity' => 'Diminution de la quantité d\'hébergements',
            'insert_rule' => 'Ajout d\'une nouvelle règle',
            'update_rule' => 'Règle mise à jour',
            'delete_rule' => 'Règle supprimée',
            'cutoff' => 'Limite',
            'insert_cutoff' => 'Règle de limite insérée',
            'modify_cutoff' => 'Règle de limite modifiée',
            'delete_cutoff' => 'Règle de limite supprimée',
            'bulk_treatments_update' => 'Mise à jour en masse des traitements',
            'treatments_overview' => 'Aperçu quotidien des traitements',
            'rateplan_update' => 'Mise à jour du plan tarifaire',
            'OTA-API' => 'Partenaire API',
            'update_channel' => 'Canal source modifié',
            'keep_accommodation' => 'Mouvement de l\'hébergement bloqué',
            'keep_accommodation_label' => 'La valeur a changé pour l\'hébergement :accommodations',
            'channel_not_connected' => 'Canal non connecté',
            'city_tax_report_exclusion' => 'Exclusion de la taxe de séjour',
            'city_tax_report_exclusion_label' => 'La valeur a changé pour l\'hébergement :accommodations',
            'update_from_past_years' => 'Copier les tarifs des années précédentes',
            'accommodations_mapping' => 'Cartographie des chambres',
            'no_association' => 'Aucune association',
        ],
        'messages' => [
            'accommodation_mapping' => 'De :origin à :destination',
        ],
        'warnings' => [
            'missing_dates_updates' => 'Impossible de synchroniser les données pour les périodes suivantes : ',
        ],
    ],

    'mail_channels_errors' => [
        'ses' => [
            'missing_required_fields_for_verfication' => 'Champs manquants pour la vérification du canal d\'envoi',
            'existing_ses_identity' => 'Identité de l\'expéditeur existante',
            'configuration_set' => [
                'AlreadyExistsException' => 'Ensemble de configuration déjà existant',
                'NotFoundException' => 'Ensemble de configuration non trouvé',
                'TooManyRequestsException' => 'Limite maximale de requêtes atteinte pour créer un ensemble de configuration',
                'LimitExceededException' => 'Limite d\'instances atteinte pour l\'ensemble de configuration requis',
                'BadRequestException' => 'Ensemble de configuration invalide',
                'ConcurrentModificationException' => 'Ensemble de configuration modifié par une autre instance',
            ],
            'send_bulk_email' => [
                'TooManyRequestsException' => 'Limite maximale de requêtes atteinte pour l\'envoi d\'emails',
                'LimitExceededException' => 'Limite d\'instances atteinte pour l\'envoi d\'emails',
                'AccountSuspendedException' => 'L\'email ne peut pas être envoyé car la capacité du compte à envoyer des emails a été limitée de manière permanente',
                'SendingPausedException' => 'L\'email ne peut pas être envoyé car la capacité du compte à envoyer des emails est actuellement suspendue',
                'MessageRejected' => 'L\'email ne peut pas être envoyé car il contient un contenu invalide',
                'MailFromDomainNotVerifiedException' => 'L\'email ne peut pas être envoyé car le domaine d\'expédition n\'est pas vérifié',
                'NotFoundException' => 'Ressource pour l\'envoi des emails non trouvée',
                'BadRequestException' => 'Entrée d\'envoi d\'email invalide',
            ],
            'configuration_set_event_destination' => [
                'AlreadyExistsException' => 'Événement de destination déjà existant',
                'NotFoundException' => 'Événement de destination non trouvé',
                'TooManyRequestsException' => 'Limite maximale de requêtes atteinte pour créer un événement de destination',
                'LimitExceededException' => 'Limite d\'instances atteinte pour l\'événement de destination requis',
                'BadRequestException' => 'Événement de destination invalide',
            ],
            'configuration_set_attributes' => [
                'NotFoundException' => 'Impossible de définir les attributs de la configuration car il n\'a pas été trouvé',
                'TooManyRequestsException' => 'Limite maximale de requêtes atteinte pour définir les attributs de la configuration',
                'BadRequestException' => 'Attributs de configuration non valides',
            ],
        ],
    ],

    'mail_channels' => [
        'fields' => [
            'host' => 'Hôte',
            'port' => 'Port',
            'username' => 'Nom d\'utilisateur',
            'password' => 'Mot de passe',
            'email_from' => 'Email de l\'expéditeur',
            'secure' => 'TLS/SSL',
            'domain_email' => 'Email de l\'expéditeur',
        ],
        'choices' => [
            'ssl' => 'SSL',
            'tls' => 'TLS',
        ],
        'errors' => [
            'missing_required_fields_for_verfication' => 'Champs manquants pour la vérification du canal d\'envoi',
            'existing_ses_identity' => 'Identité de l\'expéditeur existante',
        ],
        'channels_name' => [
            1 => 'SMTP',
            2 => 'Beddy - Service de messagerie',
        ],
    ],

    'meals' => [
        'breakfasts' => 'Petits déjeuners',
        'lunches' => 'Déjeuners',
        'dinners' => 'Dîners',
        'note' => 'Notes',
    ],

    'messages' => [
        'download_attachments' => 'Télécharger les pièces jointes',
    ],

    'newsletters_conditions' => [
        'errors' => [
            'validation_error' => 'Le type de la valeur passée pour la fonctionnalité \':feature\' doit être du type \':type\'',
            'duplicate_condition_error' => 'Le critère \':criteriaName\' est déjà associé à la liste d\'envoi',
            'limit_values_error' => 'Le nombre de paramètres passés pour la fonctionnalité \':feature\' ne correspond pas à la valeur maximale prévue \':limitValues\'',
            'condition_not_found' => 'Aucune condition associée à la liste trouvée',
            'option_relation_error' => 'L\'option sélectionnée identifiée par l\'id \':option\' n\'est pas présente pour la fonctionnalité \':feature\'',
            'unsuitable_condition_for_sending_list_category' => 'Le critère \':criteriaName\' n\'est pas compatible avec le type de liste de diffusion',

        ],
    ],

    'newsletters_criteria' => [
        'field_translate' => [
            'country' => 'Pays',
            'city' => 'Ville',
            'county' => 'Département',
            'state' => 'Région',
            'check_phone_number' => 'Les invités doivent-ils avoir entré leur numéro de téléphone ?',
            'check_newsletter_consent' => 'Les utilisateurs doivent-ils avoir donné leur consentement pour recevoir la newsletter ?',
            'check_newsletter_unsubscribe' => 'Les utilisateurs qui se sont désinscrits de la newsletter ?',
            'language' => '',
            'check_reservation_with_children' => 'Les invités doivent-ils avoir effectué une réservation avec des enfants ?',
            'addon' => '',
            'last_reservation_date' => '',
            'birthdays_date' => '',
            'reservation_period_date' => '',
            'reservation_stay_period_date' => '',
            'guests_in_house' => 'Voulez-vous sélectionner tous les invités présents ?',
            'accommodation' => '',
            'channel' => '',
            'reservation_tag' => '',
            'category_addon' => '',
        ],
        'criteria_translate' => [
            'place' => 'Résidence',
            'company_place' => 'Site',
            'phone_number' => 'Téléphone',
            'newsletter_consent' => 'Consentement à la newsletter',
            'newsletter_unsubscribed' => 'Désinscrits de la newsletter',
            'language' => 'Langue',
            'reservation_with_children' => 'Réservations avec enfants',
            'reservation_with_extra_services' => 'Réservé avec un service supplémentaire spécifique',
            'last_reservation_year' => 'Année de la dernière réservation',
            'birthdays' => 'Anniversaires',
            'reservation_period' => 'Période de la réservation',
            'reservation_stay_period' => 'Période de séjour',
            'customers_at_home' => 'Clients présents à la maison',
            'type_of_room_booked' => 'Type de chambre réservée',
            'booking_portal' => 'Portail de réservation',
            'reservation_tag' => 'Étiquette',
            'addon_category' => 'Catégorie des services supplémentaires',
        ],
        'field_translate_error' => [
            'country' => 'Pays',
            'city' => 'Ville',
            'county' => 'Département',
            'state' => 'Région',
            'check_phone_number' => 'Consentement numéro de téléphone',
            'check_newsletter_consent' => 'Consentement à la newsletter',
            'language' => 'Langue',
            'check_reservation_with_children' => 'Réservations avec enfants',
            'addon' => 'Services supplémentaires',
            'last_reservation_date' => 'Année de la dernière réservation',
            'birthdays_date' => 'Date d\'anniversaire',
            'reservation_period_date' => 'Période de la réservation',
            'check_actual_reservations' => 'Invités actuellement à la maison',
            'accommodation' => 'Type de chambre réservée',
            'channel' => 'Portail de réservation',
            'reservation_tag' => 'Étiquette',
        ],
    ],

    'newsletters' => [
        'unsubscribe_from_newsletter' => 'Se désinscrire de la newsletter',
        'warnings' => [
            'cant_active' => 'La configuration a été enregistrée mais ne peut pas être activée pour les raisons suivantes : :errors',
            'uneditable_channels' => 'Le canal d\'envoi d\'une configuration ne peut pas être modifié',
            'uneditable_options' => 'Le canal d\'envoi ne permet pas de modifier les champs ; pour les modifier, supprimez et créez une nouvelle configuration',
            'existing_configuration' => 'Une configuration avec les mêmes paramètres existe déjà',
            'cant_delete_pending_configuration' => 'Pour supprimer cette configuration en attente, vous devez attendre l\'expiration de la demande (24 heures après la soumission)',
            'cant_delete_blocked_configuration' => 'Impossible de supprimer une configuration bloquée',
            'cant_delete_configuration' => 'Il est actuellement impossible de supprimer la configuration en raison de problèmes techniques, veuillez réessayer plus tard',
            'cant_delete_configuration_with_newsletters' => 'La configuration ne peut pas être supprimée car elle est associée aux newsletters suivantes qui n\'ont pas encore été envoyées ou programmées : ',
            'cant_delete_sending_list' => 'Impossible de supprimer la liste d\'envoi sélectionnée car elle est associée aux newsletters suivantes : :newslettersTitles',
        ],
        'errors' => [
            'configuration_not_active' => 'L\'expéditeur n\'a pas encore été vérifié',
            'configuration_not_found' => 'La configuration sélectionnée n\'est pas disponible',
            'configuration_not_expired' => 'Impossible de re-vérifier la configuration à moins qu\'elle ne soit expirée ou en attente de confirmation',
            'missing_default_configuration' => 'Pour créer la newsletter, une configuration par défaut active est requise, veuillez vérifier et réessayer',
            'missing_default_locale' => 'Le modèle HTML dans la langue par défaut n\'est pas présent parmi les modèles envoyés',
            'missing_newsletter' => 'La newsletter sélectionnée n\'est pas disponible',
            'elaborated_newsletter' => 'Impossible de modifier ou supprimer la newsletter sélectionnée car elle est en cours de traitement ou a été envoyée',
            'missing_newsletter_contact' => 'Le contact demandé n\'est pas disponible ou n\'a pas d\'adresse email définie',
            'sending_list_contact_not_valid' => 'Les paramètres suivants du contact sont invalides : ',
            'contact_already_exclude' => 'Impossible d\'ajouter le contact car il a déjà été exclu de la liste d\'envoi',
            'contact_already_exist' => 'Impossible d\'ajouter le contact car il est déjà présent dans la liste d\'envoi',
            'newsletter_in_processing' => 'Impossible de modifier l\'état de la newsletter sélectionnée car elle est en cours de traitement',
            'cant_update_sent_newsletter' => 'Impossible de modifier la newsletter sélectionnée car elle a été envoyée. Elle peut seulement être dupliquée et archivée',
            'impossible_delete_attempted_newsletter' => 'Impossible de supprimer une newsletter avec des envois tentés',
            'newsletter_without_contacts' => 'Aucun contact n\'a été trouvé dans les listes d\'envoi sélectionnées, modifiez les conditions d\'inclusion des contacts ou sélectionnez d\'autres listes.',
            'newsletter_task_in_error' => 'Erreur générique d\'envoi, dupliquez la campagne et essayez d\'envoyer à nouveau dans quelques minutes.',
        ],
        'import' => [
            'validations' => [
                'email_required' => 'Le champ email est requis',
                'email_not_valid' => 'Le champ email ne contient pas une adresse email valide',
            ],
        ],
    ],

    'odigeo' => [
        'exceptions' => [
            'configuration_missing' => 'Les paramètres de configuration requis par le canal :channelName sont manquants dans la demande',
            'configuration_not_valid' => 'Les paramètres suivants ne sont pas valides : :params',
            'invalid_age_range' => 'L\'intervalle d\'âge pour :field est invalide. Assurez-vous que les groupes d\'âge sont corrects et dans le bon ordre.',
        ],
    ],

    'pa_friuli_venezia_giulia' => [
        'accommodation_name' => 'Hébergement',
        'accommodation_tableau_name' => 'Chambre',
        'check_in' => 'Arrivée',
        'check_out' => 'Départ',
        'nights' => 'Nuits',
        'surname_and_name' => 'Nom et Prénom',
        'date_of_birth' => 'Date de Naissance',
        'citizenship' => 'Nationalité',
        'residence' => 'Résidence',
    ],

    'payment_method' => [
        'fields' => [
            'model_name' => 'Méthode de paiement',
        ],
        'paypal' => [
            'cannot_activate_paypal' => 'Impossible d\'activer PayPal, vérifiez que les champs Client ID et Secret sont corrects.',
        ],
        'nexi' => [
            'cannot_activate_nexi' => 'Impossible d\'activer Nexi, vérifiez que les champs Alias et Clé MAC sont corrects.',
        ],
    ],

    'payments' => [
        'default_payment_email_body' => '<p>Cher :name :surname,</p><p>Vous trouverez ci-joint le document relatif à votre paiement</p>',
        'default_payment_email_subject' => 'Notification de paiement',
        'cannot_complete_payment_due_to_gateway' => 'Le passerelle de paiement n\'a pas pu compléter la transaction avec succès',
        'payment_order_cannot_be_completed_due_to_wrong_status' => 'L\'état du paiement est déjà complété',
        'payment_order_is_not_a_pre_authorization' => 'Ce paiement n\'est pas une pré-autorisation',
        'cannot_complete_payment_gateway_requires_action' => 'La demande a été envoyée avec succès. Vous recevrez une notification lorsque le paiement sera traité.',
        'payment' => 'paiement',
        'refund_payment' => 'Remboursement du paiement de :customer_name :customer_surname du :payment_date',
        'checkinonline_created_order_citytax' => 'Paiement de la taxe de séjour depuis le Check-in en ligne',
        'pre_authorization_text' => 'Pré-autorisation',
        'email_payment_request' => [
            'subject' => 'Demande de paiement de :propertyName',
            'message' => '<p>Cher <strong>:name :surname</strong>,</p><p>Pour votre réservation numéro <strong>#:reference_number</strong>, le montant suivant a été demandé.</p>',
            'message_without_reservation' => '<p>Cher <strong>:name :surname</strong>, le montant suivant a été demandé.</p>',
            'confirm_payment' => 'Payer maintenant :amount',
        ],
        'email_pre_authorization_request' => [
            'subject' => 'Demande de pré-autorisation de :propertyName',
            'message' => '<p>Cher <strong>:name :surname</strong></p><p>Pour votre réservation numéro <strong>#:reference_number</strong>, la pré-autorisation suivante a été effectuée.</p>',
            'message_without_reservation' => '<p>Cher <strong>:name :surname</strong>, la pré-autorisation suivante a été effectuée.</p>',
        ],
        'pre_authorization' => [
            'subject' => 'Pré-autorisation de :propertyName',
            'message' => '<p>Cher <strong>:name :surname</strong>,</p><p>Pour votre réservation numéro <strong>#:reference_number</strong>, la pré-autorisation suivante a été demandée.</p>',
        ],
        'direct_charge' => [
            'subject' => 'Frais directs de :propertyName',
            'message' => '<p>Cher <strong>:name :surname</strong></p><p>Pour votre réservation numéro <strong>#:reference_number</strong>, le montant suivant a été facturé.</p>',
        ],
        'direct_charge_failed' => [
            'subject' => 'Échec des frais directs de :propertyName',
            'message' => '<p>Cher <strong>:name :surname</strong></p><p>Nous vous informons qu\'aujourd\'hui, nous avons tenté de traiter le paiement pour la réservation <strong>#:reference_number</strong>. Cependant, nous n\'avons pas pu effectuer ce paiement.</p>',
        ],
        'payment_order' => [
            'default_whatsapp_text' => 'Cher :name :surname, pour votre réservation numéro :reference_number, vous avez reçu une demande de :type. Cliquez ici :link',
        ],
        'customer_confirmed_payment_order_notification' => [
            'subject' => 'Paiement de :amount reçu de :customerName :customerSurname - :propertyName',
            'message' => 'Nous vous informons que :customerName :customerSurname a effectué un paiement de :amount pour la réservation # :referenceNumber (:arrivalDate - :departureDate) - :propertyName',
            'click_here_to_view' => 'Cliquez ici pour voir tous les détails de la réservation',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'subject' => 'Le client a complété le paiement',
            'message' => 'Nous vous informons que :customerName :customerSurname a effectué un paiement de :amount - :propertyName',
        ],
        'pre_authorization_is_expiring' => [
            'subject' => 'Votre pré-autorisation expire',
            'message' => 'Nous vous informons que :customerName :customerSurname n\'a pas encore autorisé la pré-autorisation expirant demain pour :amount pour la réservation # :referenceNumber (:arrivalDate - :departureDate) - :propertyName',
            'message_without_reservation' => 'Nous vous informons que :customerName :customerSurname n\'a pas encore autorisé la pré-autorisation expirant demain pour :amount - :propertyName',
        ],
        'timetable' => [
            'title' => 'Paiements programmés',
            'export_fields' => [
                'scheduled_date' => 'Date de paiement',
                'booker' => 'Réservant',
                'reservation_total_price' => 'Prix total de la réservation',
                'amount' => 'Paiement programmé',
                'reservation_arrival_date' => 'Date d\'arrivée',
                'reservation_departure_date' => 'Date de départ',
                'property' => 'Propriété',
                'sca_accepted' => 'SCA accepté',
            ],
            'sca_accepted' => 'Accepté',
            'sca_not_accepted' => 'Non accepté',
            'change_status_date_past' => 'Il est impossible de planifier une date de paiement dans le passé.',
            'no_credit_card_found' => 'Aucune carte de crédit définie dans la réservation',
            'required_action_3d' => 'Échec du paiement, authentification 3D Secure requise',
            'required_action_requested_payment' => 'Demande de paiement envoyée le :send_date - expiration :expire_date',
            'request_payment_wait_customer_expired' => 'Demande de paiement expirée',
            'timetable_pause_expired' => 'La pause de paiement programmée a expiré',
            'force_payment_due_date' => 'Le paiement peut être forcé uniquement si la date de paiement correspond à la date actuelle',
            'reservation_cancelled' => 'Réservation annulée',
            'property_cancelled' => 'Propriété suspendue, expirée ou annulée',
            'module_deactivated' => 'Le module Paiements programmés a été désactivé ou a expiré',
            'charge_status_manual_change' => 'L\'état du paiement a été modifié de :current_charge_status à :new_charge_status',
            'manual_payment_bound' => 'Paiement manuel inséré',
            'stripe_not_active' => 'Le mode de paiement Stripe n\'est pas actif',
            'invoice_default_causal' => 'Frais de paiement :payment_method_name le :date pour la réservation :reservation_reference',
            'delete_propery_has_payments' => 'La propriété a des paiements programmés actifs. En poursuivant, tous les paiements programmés seront mis en pause. Cette action est irréversible',
            'amount_over_to_pay' => 'Le paiement dépasse le montant total dû pour la réservation',
            'change_tax_payment_amount' => 'Le paiement de la taxe de séjour a changé de :old_amount à :new_amount',
            'manual_payment_cancelled' => 'Le paiement manuel précédemment associé a été annulé',
            'payment_refunded_created' => 'Remboursement créé pour :currency_symbol :amount',
            'payment_refunded_modified' => 'Remboursement modifié de :currency_symbol :old_amount à :currency_symbol :new_amount',
            'reservation_reconfirmed' => 'Réservation reconfirmée',
            'reservation_optionable' => 'Réservation en option',
            'reservation_pending' => 'Réservation en attente de confirmation',
            'payment_succeded' => 'Paiement réussi',
            'charge_reminder_email_sent' => 'E-mail de rappel de paiement envoyé',
            'charge_reminder' => [
                'subject' => ':propertyName - Rappel de paiement',
                'message' => 'Cher :booker_name :booker_surname, <br /><br /> Le :date_today, un paiement de :amount :currency_symbol est dû, selon les conditions de paiement. <br /><br /> <strong><span style="color: #8f743f;">Réservation numéro #:reference_number du :arrival_date au :departure_date.</strong>',
            ],
        ],
        'errors' => [
            'conditions_with_conflicts' => 'Les conditions passées ont des jours de charge de nuit identiques ou le total des pourcentages de charge dépasse 100 % du montant',
            'payment_timetable_already_processed' => 'Le paiement du calendrier a déjà été traité ou est en attente',
            'payment_timetable_already_bound' => 'Le paiement du calendrier a déjà généré un paiement',
            'payment_timetable_attach_email_invoice_error' => 'La facture par e-mail demandée n\'a pas pu être attachée en raison de l\'erreur suivante : :error_description',
            'missing_policy' => 'Politique de paiement non trouvée pour la réservation',
            'impossible_change_payment_method_id' => 'Impossible de modifier le mode de paiement pour les paiements enregistrés',

        ],
        'warnings' => [
            'no_restrictions_and_period_policy' => 'La politique de paiement n\'a pas de restrictions et/ou de périodes d\'application, ce qui peut entrer en conflit avec d\'autres politiques existantes',
            'no_restrictions_and_period_others' => 'La politique :name n\'a pas de restrictions ni de périodes d\'application, ce qui peut entrer en conflit avec celle que vous gérez',
            'overlapping_period_for_restriction' => 'La politique :name a au moins une période qui se chevauche avec au moins une restriction commune avec celle que vous gérez, ce qui peut entraîner des conflits',
            'existing_restriction' => 'La politique :name a au moins une restriction en commun avec celle que vous gérez, ce qui peut entraîner des conflits',
        ],
        'fields' => [
            'payment_agreement_id' => 'identifiant de l’accord de paiement'
        ],
    ],

    'policy' => [
        'errors' => [
            'no_show_option_not_compatible' => 'Les options de no-show ne sont pas compatibles',
            'deposit_option_not_compatible' => 'Les options de dépôt ne sont pas compatibles',
            'choose_deposit_pay' => 'Vous devez choisir quand facturer le dépôt',
            'condition_not_compatible' => 'Les conditions d\'annulation ne sont pas compatibles',
            'duplicate_penalty' => 'Pénalités en double dans les conditions d\'annulation',
            'no_show_condition_not_applicable' => 'Vous ne pouvez pas appliquer ces conditions à un no-show',
            'deposit_condition_not_applicable' => 'Vous ne pouvez pas appliquer ces conditions au dépôt',
            'duplicate_penalty_deposit' => 'Pénalités en double dans la section dépôt',
            'no_condition_to_deposit' => 'Aucune condition appliquée au dépôt',
            'policy_to_rateplan' => 'Politique liée à au moins un plan tarifaire',
            'delete_policy_default' => 'Vous ne pouvez pas supprimer les politiques par défaut',
            'last_policy' => 'Vous ne pouvez pas supprimer la dernière politique de la propriété',
            'policy_not_allowed_in_period' => 'Vous ne pouvez pas écraser une période avec la même politique que celle du plan tarifaire.',
            'policy_period_overlapping' => 'Les périodes de politique se chevauchent.',
            'check_priority_custom' => 'Il y a des priorités pour la politique, vérifiez leur validité.',
            'check_priority_and_period' => 'Il y a des priorités ou des périodes pour la politique.',
        ],
        'names' => [
            'standard' => 'Annulation gratuite',
            'not_ref' => 'Non remboursable',
            'default_ota_name' => 'Voir OTA',
            'default_ota_description' => 'Politique non envoyée par le canal',
            'hour_title_policy' => 'jusqu\'à :hour le jour d\'arrivée.',
            'nights' => 'nuit|nuits',
            'days' => 'jour|jours',
        ],
        'transform_to_date' => [
            'date_limit' => '<p>Vous pouvez annuler gratuitement jusqu\'à 23h59 le :date_limit.</p>',
            'date_limit_percentage' => '<p>Si vous annulez avant le :date_limit, vous serez facturé :penalty_value% du coût total.</p>',
            'date_limit_nights' => '<p>Si vous annulez avant le :date_limit, vous serez facturé pour :penalty_value nuits.</p>',
            'date_limit_amount' => '<p>Si vous annulez avant le :date_limit, vous serez facturé :penalty_value :currency.</p>',
            'date_over_percentage' => '<p>Si vous annulez après le :date_limit, vous serez facturé :penalty_value% du coût total.</p>',
            'date_over_nights' => '<p>Si vous annulez après le :date_limit, vous serez facturé pour :penalty_value nuits.</p>',
            'date_over_amount' => '<p>Si vous annulez après le :date_limit, vous serez facturé :penalty_value :currency.</p>',
            'date_over_percentage_hour' => '<p>Si vous annulez après :hour_limit le :date_limit, vous serez facturé :penalty_value% du coût total.</p>',
            'date_over_nights_hour' => '<p>Si vous annulez après :hour_limit le :date_limit, vous serez facturé pour :penalty_value nuits.</p>',
            'date_over_amount_hour' => '<p>Si vous annulez après :hour_limit le :date_limit, vous serez facturé :penalty_value :currency.</p>',
            'date_now_percentage' => '<p>Si vous annulez maintenant, vous serez facturé :penalty_value% du coût total.</p>',
            'date_now_nights' => '<p>Si vous annulez maintenant, vous serez facturé pour :penalty_value nuits.</p>',
            'date_now_amount' => '<p>Si vous annulez maintenant, vous serez facturé :penalty_value :currency.</p>',
            'date_now_noshow_percentage' => '<p>En cas de no-show, vous serez facturé :penalty_value% du coût total.</p>',
            'date_now_noshow_nights' => '<p>En cas de no-show, vous serez facturé pour :penalty_value nuits.</p>',
            'date_now_noshow_amount' => '<p>En cas de no-show, vous serez facturé :penalty_value :currency.</p>',
        ],
        'transform_to_date_notref' => [
            'date_now_percentage' => '<p>Si vous annulez à tout moment après la réservation, vous serez facturé :penalty_value% du coût total.</p>',
            'date_now_nights' => '<p>Si vous annulez à tout moment après la réservation, vous serez facturé pour :penalty_value nuits.</p>',
            'date_now_amount' => '<p>Si vous annulez à tout moment après la réservation, vous serez facturé :penalty_value :currency.</p>',
            'date_limit_percentage' => '<p>Si vous annulez avant :hour_limit le :date_limit, vous serez facturé :penalty_value% du coût total.</p>',
            'date_limit_nights' => '<p>Si vous annulez avant :hour_limit le :date_limit, vous serez facturé pour :penalty_value nuits.</p>',
            'date_limit_amount' => '<p>Si vous annulez avant :hour_limit le :date_limit, vous serez facturé :penalty_value :currency.</p>',
            'date_now_deposit_percentage' => '<p>Vous serez facturé :penalty_value% du coût total au moment de la réservation.</p>',
            'date_now_deposit_nights' => '<p>Vous serez facturé pour :penalty_value nuits au moment de la réservation.</p>',
            'date_now_deposit_amount' => '<p>Vous serez facturé :penalty_value :currency au moment de la réservation.</p>',
            'date_now_noshow_percentage' => '<p>En cas de no-show, vous serez facturé :penalty_value% du coût total.</p>',
            'date_now_noshow_nights' => '<p>En cas de no-show, vous serez facturé pour :penalty_value nuits.</p>',
            'date_now_noshow_amount' => '<p>En cas de no-show, vous serez facturé :penalty_value :currency.</p>',
        ],
    ],

    'property_report' => [
        'property' => [
            'label' => 'Propriété',
            'description' => 'Cette option vous permet d\'exporter les données de la propriété',
        ],
        'children_ranges' => [
            'label' => 'Plages d\'enfants',
            'description' => 'Cette option vous permet d\'exporter les plages d\'enfants',
        ],
        'accommodations' => [
            'label' => 'Hébergements',
            'description' => 'Cette option vous permet d\'exporter les hébergements avec leurs détails',
        ],
        'treatments' => [
            'label' => 'Traitements',
            'description' => 'Cette option vous permet d\'exporter les traitements',
        ],
        'policies' => [
            'label' => 'Politiques d\'annulation',
            'description' => 'Cette option vous permet d\'exporter les conditions d\'annulation',
            'addons_to_deposit' => [
                'included' => 'Services supplémentaires inclus',
                'not_included' => 'Services supplémentaires non inclus dans le calcul',
            ],
        ],
        'rate_plans' => [
            'label' => 'Plans tarifaires',
            'description' => 'Cette option vous permet d\'exporter les plans tarifaires',
        ],
        'invoice_layouts' => [
            'label' => 'Profils de facturation',
            'description' => 'Cette option vous permet d\'exporter les profils de facturation',
        ],
        'city_tax' => [
            'label' => 'Taxe de séjour',
            'description' => 'Cette option vous permet d\'exporter la configuration de la taxe de séjour',
            'active' => 'Actif',
            'not_active' => 'Inactif',
        ],
        'payments_method' => [
            'label' => 'Méthodes de paiement',
            'description' => 'Cette option vous permet d\'exporter la configuration des paiements',
            'day' => '{0,1} jour|[2,*] jours',
        ],
    ],

    'property' => [
        'errors' => [
            'already_attached' => 'Pièce jointe déjà existante',
            'property_has_another_master' => 'La propriété a déjà un utilisateur maître. Pour continuer, supprimez l\'association avec cet utilisateur',
            'letti_extra_exception_delete' => 'Vous ne pouvez pas supprimer ce lit supplémentaire tant que vous n\'avez pas d\'abord supprimé le nombre :lettimax, mais vous avez changé le nombre :lettimin',
            'letti_extra_exception_missing' => 'Certains éléments sont manquants',
            'override_periods_policy' => 'Périodes qui se chevauchent',
            'place_not_found' => 'Lieu introuvable',
            'not_group_owner' => 'Vous n\'êtes pas le propriétaire de ce groupe',
            'group_is_default' => 'Vous ne pouvez pas supprimer le groupe par défaut',
            'already_in' => 'Propriété déjà dans le groupe, impossible de continuer',
            'already_all_in' => 'Propriété déjà dans un de vos groupes, impossible de continuer',
            'not_in_group' => 'Propriété non dans un groupe',
            'existing_extra_bed_setting' => 'Paramètre de lit supplémentaire existant',
            'missing_extra_bed_setting' => 'Paramètre de lit supplémentaire manquant pour celui-ci',
            'overcoming_extra_bed' => 'Lit supplémentaire dépasse la configuration de chambre existante',
            'role_conflict' => 'Rôle déjà existant',
            'cant_detach_default_group' => 'Impossible de détacher du groupe par défaut',
            'groups_have_properties' => 'Impossible de supprimer ce groupe car il contient des propriétés',
            'uneditable_expense_category' => 'Catégorie de dépenses non modifiable',
            'expenses_pending' => 'Catégorie de dépenses non supprimable en raison des dépenses liées',
            'missing_vat_quotes' => 'Attention! Le pays sélectionné n\'a pas de taux de TVA définis. Veuillez les configurer avant de continuer',
            'cutoff_rules_exist' => 'Règle de coupure déjà existante.',
            'missing_lat_lon' => 'Aucune coordonnée (LAT ou LON) définie pour cette propriété',
            'undetachable_layout' => 'Vous ne pouvez pas détacher ce profil à moins d\'en avoir au moins un autre associé',
            'customer_not_belonging_to_property_group' => 'Le client :customer_id n\'appartient pas au groupe de propriétés ou n\'existe pas',
            'update_expiration_bulk' => 'Erreur lors de la mise à jour des dates d\'expiration',
            'update_cancellation_bulk' => 'Erreur lors de la mise à jour de l\'état de la annulation',
            'update_activation_bulk' => 'Erreur lors de la mise à jour de l\'état d\'activation / désactivation',
            'unauthorized_access' => 'Vous n’êtes pas autorisé à accéder à cette ressource.',
            'unauthorized_insolvent_status' => 'Votre compte a été bloqué pour non-paiement. Nous vous invitons donc à écrire à "zucchettihospitality.gestione.crediti@zucchetti.it" afin de régulariser votre situation comptable.'
        ],
        'warnings' => [
            'request_confirm_change_discount_type' => 'Le changement de type de réduction entraînera la suppression de toutes les configurations personnalisées. Continuer?',
            'request_confirm_delete_extra_bed' => 'La suppression de ce lit supplémentaire entraînera la suppression de tous les lits supplémentaires supérieurs. Continuer?',
            'invalid_facility' => 'Équipement incompatible',
            'disabled_update' => 'Le canal :channel_name n\'est pas activé pour l\'envoi des données',
            'nothing_to_update' => 'Rien à envoyer sur :channel',
            'missing_invoice_layout_without_vat_code_with_all_inclusive_tax_enabled' => 'Attention! La propriété activée n\'a pas de profil de facturation adapté pour l\'émission d\'une quittance en régime de taxe forfaitaire',
            'properties_has_not_istat_module' => 'La propriété :property_name n\'a pas le module Istat activé',
            'update_overcome_days' => 'Les dates suivantes n\'ont pas été mises à jour car elles dépassent la limite maximale des jours: :dates',
            'download_overcome_days' => 'Aucune donnée n\'a été téléchargée pour les dates suivantes car elles dépassent la limite maximale des jours: :dates',
            'missing_property_xml_id' => 'Attention! Le property_xml_id n\'a pas été inséré dans les paramètres du canal :channel_name',
        ],
        'city_tax' => [
            'main_report_title' => 'Résumé de la taxe de séjour',
            'recap_city_tax_totals' => 'Résumé des totaux de la taxe de séjour',
            'exemptions' => 'Exemptions',
            'limit_nights' => 'Limite de nuits',
            'total_guests' => 'Nombre total d\'invités',
            'totals' => 'Totaux',
            'total_taxed_guests' => 'Invités taxés',
            'total_exempted_guests' => 'Invités exemptés',
            'exemption_details' => 'Détails des exemptions',
            'taxed_details' => 'Détails des taxés',
            'taxed_details_ranges' => 'De :min à :max ans',
            'exemptions_over' => 'Exemptés au-delà de la limite',
            'guests_over' => 'Invités au-delà de la limite',
            'guests' => 'Invités',
            'city_tax_amount' => 'Montant de la taxe de séjour',
            'all_properties' => 'Toutes les propriétés',
            'from_to_age_ranges' => 'De :min_age à :max_age ans',
            'taxed_nights' => 'Nuits des invités soumis à la taxe',
        ],
        'commissions' => [
            'period_exists' => 'Période déjà existante',
            'invalid_period' => 'Période invalide',
            'season_too_long' => 'Période saisonnière trop longue',
        ],
        'list' => 'Liste des propriétés',
        'export_fields' => [
            'id' => 'ID',
            'name' => 'Nom',
            'group' => 'Groupe',
            'address' => 'Adresse',
            'city' => 'Ville',
            'state' => 'État',
            'county' => 'Comté',
            'country' => 'Pays',
            'zip_code' => 'Code postal',
            'type' => 'Type',
            'email' => 'Email',
            'telephone' => 'Téléphone',
            'reference_name' => 'Nom du référent',
            'reference_surname' => 'Prénom du référent',
            'reference' => 'Référent',
            'modules' => 'Modules',
            'activated_date' => 'Date d\'activation',
            'expire_date' => 'Date d\'expiration',
            'status' => 'Statut',
            'user_first_name' => 'Prénom du propriétaire',
            'user_last_name' => 'Nom du propriétaire',
            'user' => 'Propriétaire',
            'user_email' => 'Email du propriétaire',
            'resellers' => 'Revendeurs',
            'business_name' => 'Raison sociale',
            'vat_number' => 'Numéro de TVA',
            'fiscal_code' => 'Code fiscal',
            'properties_modules' => 'Modules de propriété',
            'accommodations' => 'Hébergements',
            'quantity' => 'Quantité',
            'contacts' => 'Contacts',
        ],
        'initials_name' => [
            'booking-engine' => 'BE',
            'channel-manager' => 'CM',
            'rate-checker' => 'RC',
            'brand-protection' => 'BP',
            'google-ads' => 'GA',
            'google-commission' => 'GC',
            'tripadvisor-istant-booking' => 'TIB',
            'trivago-fast-connect' => 'TFC',
            'booking-engine-quotes' => 'BEQ',
            'guests-reporting' => 'GR',
            'pms' => 'PMS',
            'newsletter' => 'CRM',
            'automatic-payments' => 'AP',
        ],
        'clone' => [
            'cloning-job-scheduled' => 'La clonage sera effectué bientôt, veuillez vérifier dans quelques minutes.',
        ],
        'not_found' => 'Les ID suivants n\'existent pas: ',
        'log'  => [
            'property_module_enabled' => 'Module de propriété activé',
            'property_module_disabled' => 'Module de propriété désactivé',
            'beddy_channel_disabled' => 'Canal Beddy désactivé',
            'beddy_channel_enabled' => 'Canal Beddy activé',
            'property_disactivated' => 'Propriété désactivée',
            'property_activated' => 'Propriété activée',
            'property_cancelled' => 'Annulation enregistrée pour la propriété',
            'property_cancellation_reversed' => 'Réversibilité de l’annulation enregistrée pour la propriété',
            'property_update_expiration_date' => 'Expiration du contrat de la propriété mise à jour',
        ],
        'treatment' => [
            'log' => [
                'attach' => 'Le traitement :treatment_name a été associé aux établissements :property_names avec un supplément de prix :supplement_price et une variation de prix :share_price. :children_detail :apply_past',
                'children_detail' => ' Pour la tranche d’âge :age_range, un supplément de :supplement_price et une variation de :share_price ont été définis.',
                'apply_past' => ' La configuration a été appliquée aux réservations effectuées entre le :from et le :to',
                'detach' => 'Le traitement :treatment_name a été dissocié de l’établissement :property_name',
                'update' => 'Le traitement :treatment_name a été modifié avec un supplément de :supplement_price et une variation de :share_price. :children_detail :children_delete :detail_delete',
                'detail_delete' => 'La variation de prix a été réinitialisée par rapport à la précédente, tous les détails associés ont donc été supprimés.',
            ],
        ],

    ],

    'push_notifications' => [
        'multiple_sessions' => [
            'title' => 'Alerte de sécurité : plusieurs appareils connectés à votre compte',
            'message' => 'Des connexions depuis plusieurs appareils sur votre compte ont été détectées. Veuillez vérifier les sessions actuellement actives.',
        ],
        'reservation_new' => [
            'title' => 'Nouvelle réservation de :channel_name (:name_surname).',
            'message' => ':name_surname a réservé l\'hébergement :accommodation_name de la structure :property_name du :arrival_date au :departure_date.',
        ],
        'reservation_modified' => [
            'title' => 'Modification de la réservation de :name :surname de :channel_name.',
            'message' => 'La réservation de :name :surname a été modifiée du :arrival_date au :departure_date pour l\'hébergement :accommodation_name de la structure :property_name.',
        ],
        'reservation_cancelled' => [
            'title' => 'Annulation de la réservation de :name :surname de :channel_name.',
            'message' => 'La réservation de :name :surname du :arrival_date au :departure_date de la structure :property_name a été annulée.',
        ],
        'reservation_banktransfer_cancelled' => [
            'title' => 'Annulation de la réservation de :name :surname de :channel_name pour non-paiement',
            'message' => 'La réservation de :name :surname du :arrival_date au :departure_date de la structure :property_name a été annulée automatiquement.',
        ],
        'invoice_rejected' => [
            'title' => 'Facture :number_complete de :name :surname rejetée par SDI.',
            'message' => 'La facture :number_complete de :name :surname a été rejetée pour la raison suivante : :rejected_reason.',
        ],
        'invoice_received' => [
            'title' => 'Facture reçue de :sender_name.',
            'message' => 'La facture numéro :document_number du :document_date de :sender_name a été reçue.',
        ],
        'checkin_online_complete' => [
            'title' => 'Check-in en ligne effectué (:name :surname).',
            'message' => 'Le client :name :surname a effectué le check-in en ligne pour la réservation du :arrival_date au :departure_date de l\'hébergement :accommodation_name de la structure :property_name.',
        ],
        'reservation_quote_expired' => [
            'title' => 'Devis expiré :name :surname.',
            'message' => 'Le devis de :name :surname, créé le :created_date, a expiré.',
        ],
        'housekeeper_maintainer' => [
            'title' => 'Nouveau signalement de maintenance pour l\'hébergement :accommodation_name',
            'message' => 'Un nouveau signalement de maintenance a été ajouté pour l\'hébergement :tableau_label. :title - :description',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'title' => 'Changement de statut de nettoyage pour l\'hébergement :cleanable_name - :accommodation_name',
            'message' => ':user_name a mis à jour le statut de nettoyage en :clean_status le :reference_date pour l\'hébergement :cleanable_name (:accommodation_name) de la structure :property_name.',
        ],
        'reservation_option_expired' => [
            'title' => 'Option de réservation expirée (:name :surname)',
            'message' => 'L\'option de réservation de :name :surname du :arrival_date au :departure_date pour l\'hébergement :accommodation_name de la structure :property_name a expiré.',
        ],
        'order_payment_release' => [
            'subject' => 'Pré-autorisation débloquée (:name :surname).',
            'body' => 'La pré-autorisation de paiement de la réservation de :name :surname du :arrival_date au :departure_date de la structure :property_name a été libérée.',
        ],
        'sca_authorized' => [
            'title' => 'Formulaire SCA confirmé par :name :surname.',
            'message' => 'Le client :name :surname a confirmé le formulaire SCA le :accepted_date depuis l\'adresse IP :ip_address.',
        ],
        'customer_confirmed_payment_order_notification' => [
            'title' => 'Nouveau paiement reçu de :name :surname.',
            'message' => 'Le client :name :surname a effectué un paiement de :amount pour la réservation du :arrival_date au :departure_date de la structure :property_name.',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'title' => 'Nouveau paiement reçu de :name :surname.',
            'message' => 'Le client :name :surname a effectué un paiement de :amount.',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => 'Disponibilité terminée pour l\'hébergement :accommodation_name de la structure :property_name.',
            'body' => 'L\'hébergement :accommodation_name n\'est plus disponible pour les dates suivantes : :days.',
        ],
        'reservation_queue_complete' => [
            'subject' => 'Réservation :name :surname traitée.',
            'body' => 'La réservation pour le client :name :surname a été correctement traitée.',
        ],
        'guests_reporting' => [
            'subject' => 'Envoi des fiches des Hébergés - :alloggiatiweb_group_label',
            'success' => '1 fiche envoyée avec succès|:number fiches envoyées avec succès',
            'error' => '1 fiche non envoyée|:number fiches non envoyées :errorMessage',
        ],
        'quote_request' => [
            'subject' => 'Nouvelle demande de devis',
            'message' => ':customer_name :customer_surname a récemment fait une demande de devis pour votre établissement.',
        ],
        'treatment_price_update' => [
            'subject' => 'Statistiques des traitements mises à jour sur - :property_name',
            'message' => 'Le recalcul avec les valeurs mises à jour du :start_date au :end_date pour le traitement :treatment_name a été terminé.',
        ],
        'queue_past_reservations_task_record_summary' => [
            'subject' => 'Résumé des tâches de traitement des réservations passées - :property_name (:property_id) canal :channel_name (:channel_id)',
            'message' => ':reservations_elaborated réservations passées sur :reservations_total totales ont été traitées. Il y a :reservations_require_action réservations nécessitant une action de votre part.',
        ],
        'queue_past_reservations_task_error' => [
            'subject' => 'Erreur de tâche de traitement des réservations passées - :property_name (:property_id) canal :channel_name (:channel_id)',
            'message' => 'Une erreur s\'est produite lors du traitement de la file des réservations passées. Message d\'erreur :error_description',
        ],
        'reservation_message_received' => [
            'title' => 'Nouveau message de :senderName (#:reference)',
        ],
        'conversation_message_send_failed' => [
            'title' => 'Échec de l\'envoi du message',
            'message' => 'Le message envoyé à :recipientName n\'a pas été délivré.',
        ],
        'urmet_sclak_error_generate_key' => [
            'title' => 'Erreur lors de la création des clés pour la réservation :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Une erreur est survenue sur Sclak lors de la génération des clés des chambres :errors. Réessayez manuellement, si le problème persiste contactez l\'assistance Urmet.',
        ],
        'nuki_error_generate_key' => [
            'title' => 'Erreur de création du PIN pour la réservation :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Une erreur est survenue sur Nuki lors de la génération du PIN des chambres :errors. Réessayez manuellement, si le problème persiste contactez l\'assistance Nuki.',
        ],
        'urmet_sclak_error_sending_sms' => [
            'title' => 'Erreur d\'envoi du SMS des clés de réservation :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Il n\'a pas été possible d\'envoyer le SMS de Sclak en raison d\'une erreur. <br>Nous vous conseillons de contacter l\'assistance Urmet.',
        ],
        'single_property_export_completed' => [
            'title' => 'Exportation :exportProviderName terminée',
            'message' => 'Le fichier :fileName est prêt à être téléchargé.',
        ],
        'single_property_export_not_completed' => [
            'title' => 'Exportation :exportProviderName échouée',
            'message' => 'L\'exportation effectuée le :date à :time a échoué.',
        ],
        'multi_property_export_completed' => [
            'title' => 'Exportation :exportProviderName terminée',
            'message' => 'Le fichier :fileName est prêt à être téléchargé.',
        ],
        'multi_property_export_not_completed' => [
            'title' => 'Exportation :exportProviderName échouée',
            'message' => 'L\'exportation effectuée le :date à :time a échoué.',
        ],
        'newsletter_sent' => [
            'title' => 'Confirmation d\'envoi de la newsletter',
            'message' => 'La newsletter :newsletterName a été envoyée avec succès.',
        ],
        'newsletter_not_sent' => [
            'title' => 'Erreur d\'envoi de la newsletter',
            'message' => 'La campagne ":newsletterName" n\'a pas pu être envoyée en raison des erreurs suivantes : :errorMessage.',
        ],
        'newsletter_exceeded_sent_limit' => [
            'title' => 'Limite d\'envois mensuels dépassée',
            'message' => 'La newsletter :newsletterName n\'a pas été envoyée, car la limite mensuelle d\'envois d\'emails a été atteinte.',
        ],
        'remote_door_key_service_reservation_resumed' => [
            'title' => 'Modifications de réservation, génération de nouvelles clés',
            'message' => 'Il est nécessaire de générer une nouvelle clé pour la réservation de <b>:booker_name :booker_surname- :reference_number</b> de la structure <b>:property_name</b>.',
        ],
        'remote_door_key_service_reservation_moved' => [
            'title' => 'Un ou plusieurs hébergements ont été déplacés. Il est nécessaire de générer une nouvelle clé.',
            'message' => 'Un ou plusieurs hébergements de la réservation <b>:booker_name :booker_surname- :reference_number</b> de la structure <b>:property_name</b> ont été déplacés. Il est nécessaire de générer une nouvelle clé.',
        ],
        'send_city_tax_report' => [
            'title' => 'Confirmation d\'envoi du rapport de taxe de séjour',
            'message' => 'L\'envoi du rapport de taxe de séjour pour le canal d\'envoi :channelName a été effectué avec succès.',
        ],
        'send_city_tax_report_not_completed' => [
            'title' => 'Erreur d\'envoi du rapport de taxe de séjour',
            'message' => 'L\'envoi du rapport de taxe de séjour pour le canal d\'envoi :channelName n\'a pas abouti.',
        ],
        'export_city_tax_report' => [
            'title' => 'L\'exportation du rapport de taxe de séjour pour le canal :channelName est prête',
            'message' => 'Cliquez sur la notification pour être redirigé vers la page historique des exportations.',
        ],
        'export_city_tax_report_not_completed' => [
            'title' => 'Impossible de terminer l\'exportation du rapport de taxe de séjour pour le canal :channelName',
            'message' => 'La génération du rapport :reportId a échoué.',
        ],
        'guest_atrtributes_missing_in_city_tax_report' => [
            'title' => 'Erreur d\'envoi/exportation du rapport de taxe de séjour',
        ],
        'empty_city_tax_report' => [
            'title' => 'Erreur d\'envoi/exportation du rapport de taxe de séjour pour le canal :channelName',
            'message' => 'Le rapport de taxe de séjour n\'a pas été traité car aucun invité n\'a été extrait pour la période sélectionnée à communiquer au canal.',
        ],
        'accommodation_deleted' => [
            'title' => 'Action requise',
            'message' => 'Le nombre d\'unités disponibles pour l\'hébergement :accommodationName de la structure :propertyName a été réduit. Pour éviter le surbooking, il est nécessaire de réinitialiser la disponibilité.',
            'title' => 'Action requise',
            'message' => 'Le nombre d\'unités disponibles pour l\'hébergement :accommodationName de la structure :propertyName a été réduit. Pour éviter le surbooking, il est nécessaire de réinitialiser la disponibilité.',
        ],
        'payment_timetable_stripe_not_active' => [
            'title' => 'Échec du paiement automatique - Stripe non actif',
            'message' => 'Le paiement automatique n\'a pas pu être effectué car aucun compte Stripe actif n\'est disponible pour effectuer l\'encaissement.',
        ],
        'payment_timetable_charge_failed' => [
            'title' => 'Échec du paiement automatique',
            'message' => 'Le paiement automatique n\'a pas pu être effectué pour la raison suivante : :error_description.',
        ],
        'payment_timetable_no_credit_card' => [
            'title' => 'Échec du paiement automatique - Pas de carte de crédit présente',
            'message' => 'Le paiement automatique n\'a pas pu être effectué car aucune carte de crédit n\'est présente pour effectuer l\'encaissement.',
        ],
        'payment_timetable_exceeded' => [
            'title' => 'Échec du paiement automatique - Montant excédentaire par rapport au total de la réservation',
            'message' => 'Le paiement automatique n\'a pas pu être effectué car il excède la partie non payée de la réservation.',
        ],
        'payment_timetable_require_action' => [
            'subject' => 'Échec du prélèvement automatique - 3D Secure requis',
            'message' => 'Le prélèvement automatique a échoué en raison d’une demande 3D Secure (ID : :payment_timetable_id, le :scheduled_date - Réservation :reservation_reference_number au nom de :booker_name :booker_surname).',
        ],
        'payment_timetable_require_action_send_request' => [
            'subject' => 'Échec du prélèvement automatique - Demande envoyée au client',
            'message' => "Le prélèvement automatique a échoué en raison d’une demande 3D Secure (ID : :payment_timetable_id, le :scheduled_date - Réservation :reservation_reference_number au nom de :booker_name :booker_surname).\nUne demande de paiement a été envoyée au client par e-mail.",
        ],
    ],

    'quote_request' => [
        'email' => [
            'subject' => 'Demande de devis pour :property_name - :customer_name :customer_surname (:arrival_date - :departure_date)',
            'quote_request_confermation' => 'Cher(e) <b>:property_name</b>,<br></br>
            <b>:customer_name :customer_surname</b> vient de faire une demande de devis pour votre établissement.',
            'summary_request' => 'Résumé de la demande :',
            'stay' => 'Séjour',
            'name_surname' => 'Nom et Prénom',
            'telephone' => 'Téléphone',
            'email' => 'Email',
            'from' => 'Arrivée',
            'to' => 'Départ',
            'alternative_dates' => 'Disponible à d\'autres dates',
            'alternative_beds' => 'Disponible à d\'autres types de lits',
            'yes' => 'Oui',
            'no' => 'Non',
            'accommodation' => 'Hébergement',
            'accommodations' => 'Hébergements',
            'night' => 'Nuit',
            'nights' => 'Nuits',
            'adults' => 'Adultes',
            'children' => 'Enfants',
            'eta_children' => 'Âge des enfants',
            'button' => 'Cliquez ici pour voir la demande',
        ],
        'email_customer' => [
            'subject' => 'Merci pour votre demande :customer_name !',
            'message' => 'Merci <b>:customer_name</b>,<br></br>Votre demande de devis a été correctement envoyée, nous vous contacterons dans les plus brefs délais.',
        ],
    ],

    'rateplans' => [
        'errors' => [
            'max_day_update' => 'Il est impossible de supprimer ce tarif car il y a des canaux connectés',
            'insert_periods_plan' => 'Il est impossible d\'ajouter des périodes à un plan tarifaire',
            'uneditable_rateplan' => 'Le plan tarifaire source est non modifiable',
            'source_not_found' => 'Le tarif source n\'est pas présent sur la chambre',
            'detach_accommodations_channels' => 'Il est impossible de supprimer ce tarif car il y a des canaux connectés',
            'multi_property_not_permitted' => 'Il est impossible de créer ou modifier des tarifs pour plusieurs propriétés à la fois',
            'rules_present_cannot_update' => 'Il n\'est pas possible d\'appliquer la modification demandée car des règles actives sont associées à ce plan tarifaire.',
        ],
        'warnings' => [
            'missing_set_rules' => 'Il n\'a pas été possible de définir des règles pour certains canaux source sur des plans tarifaires existants sur les canaux de destination',
        ],
        'conflicts' => [
            'unsuitable_conditions' => 'Les valeurs pour la condition de :condition_from ne sont pas compatibles avec celles définies pour la condition de :condition_to',
            'conditions_not_formatted' => 'Conditions mal formatées, identifiant manquant',
        ],
        'export_fields' => [
            'name' => 'Nom',
            'policy' => 'Politiques de remboursement',
            'periods' => 'Périodes et jours de validité',
            'accommodations' => 'Hébergements',
        ],
    ],

    'rates' => [
        'errors' => [
            'max_day_update' => 'Il est impossible de mettre à jour une période supérieure à un an',
            'no_rooms_to_clone' => 'Aucune chambre ne peut être clonée',
            'no_rooms_to_clone_source' => 'Une ou plusieurs chambres/tarifs ne sont pas présents dans le canal source',
            'no_rooms_to_clone_destination' => 'Une ou plusieurs chambres/tarifs ne sont pas présents dans le canal de destination',
            'same_channel_to_clone' => 'Vous ne pouvez pas cloner un canal sur lui-même',
            'no_date_valid' => 'Aucune date à mettre à jour',
            'max_availability_exceeded' => 'La valeur de disponibilité saisie dépasse celle autorisée par la configuration de l\'hébergement. La valeur a été ajustée au maximum autorisé',
            'anti_overbooking_bloccante' => 'Attention : la valeur de la disponibilité que vous essayez d\'insérer est supérieure au nombre de chambres vendables. Vous risquez l\'overbooking',
            'channel_update_error' => 'La mise à jour vers le portail a échoué, veuillez consulter la section <b>Log des Mises à Jour</b> pour plus d\'informations.',
            'period_over_limit' => 'La période du :dateFrom au :dateTo dépasse la limite maximale autorisée.',
        ],
        'warnings' => [
            'past_period' => 'La période sélectionnée est passée',
            'past_today_adjustment' => 'La date de début a été ajustée à la date d\'aujourd\'hui',
            'period_adjustment_limit' => 'La date de fin a été ajustée à la limite maximale autorisée. (:dateTo)',
            'channel_not_connected' => 'La propriété n\'est pas connectée au canal :channel_name',
            'anti_overbooking' => 'Attention : la valeur de la disponibilité que vous essayez d\'insérer est supérieure au nombre de chambres vendables. Vous risquez l\'overbooking',
            'missing_association' => 'La chambre n\'est pas associée au canal :channel_name',
            'identical_update' => 'Une mise à jour identique est déjà en cours, veuillez réessayer plus tard.',
            'rate_copy_not_found' => 'Aucune donnée à copier pour la période passée. Mise à jour ignorée',
        ],
    ],

    'receipt_modules' => [
        'errors' => [
            'already_migrated' => 'Cette imprimante fiscale a déjà été migrée vers la nouvelle gestion des départements',
        ],
        'log' => [
            'receipt_module_updated' => 'Imprimante fiscale modifiée',
            'receipt_module_created' => 'Imprimante fiscale créée',
            'receipt_module_deleted' => 'Imprimante fiscale supprimée',
            'receipt_module_department_deleted' => 'Département d\'imprimante fiscale supprimé',
            'receipt_module_department_created' => 'Département d\'imprimante fiscale créé',
            'receipt_module_department_updated' => 'Département d\'imprimante fiscale modifié',
        ],
        'validation' => [
            'ateco_slot_code' => [
                'wrong_format' => 'Format du code ATECO incorrect.',
                'wrong_slot' => 'Valeur de slot non supportée. (0 - 3).',
            ],
        ],
    ],

    'receipt_channels' => [
        'log' => [
            'receipt_channel_created' => 'Reçu électronique créé',
            'receipt_channel_deleted' => 'Reçu électronique supprimé',
        ]
    ],

    'reservation_accommodation_room_day' => [
        'fields' => [
            'model_name' => 'jour',
            'price' => 'prix journalier',
            'adults_number' => 'nombre d\'adultes',
            'children_number' => 'nombre d\'enfants',
        ],
    ],

    'reservation_addon' => [
        'fields' => [
            'related_id' => 'identifiant relié',
            'related_type' => 'type relié'
        ],
    ],

    'reservation_accommodation' => [
        'fields' => [
            'price_total' => 'prix total chambre',
            'smoking' => 'fumeurs',
            'accommodation_bed_type_combination_id' => 'Identifiant de combinaison de types de lits pour l\'hébergement'
        ],
    ],

    'reservation_cc' => [
        'fields' => [
            'holder' => 'titulaire de la carte de crédit',
            'number' => 'numéro de carte de crédit',
            'expire_date' => 'date d\'expiration de la carte de crédit',
            'cvc' => 'code cvc',
            'credit_card' => 'carte de crédit',
            'current_balance' => 'solde actuel',
            'type_id' => 'type d\'identifiant',
            'activation_date' => 'date d\'activation',
            'vcc_expiration_date' => 'date d\'expiration vcc',
            'is_virtual_card' => 'est une carte virtuelle'
        ],
    ],

    'reservation_invoice' => [
        'export_fields' => [
            'reference_number' => 'ID Réservation',
            'reservation_id' => 'ID Réservation',
            'accommodations' => 'Hébergements',
            'room' => 'Numéro',
            'period' => 'Séjour',
            'pax' => 'Invités',
            'type' => 'Type',
            'customer' => 'Titulaire',
            'payment_agreement' => 'Crédit',
            'paid' => 'Payé',
            'to_pay' => 'À payer',
            'accountholder' => 'Titulaire',
            'total' => 'Total',
            'stay' => 'Séjour',
            'guests' => 'Invités',
            'credit' => 'Crédit',
            'note' => 'Note',
            'notes' => 'Notes',
            'status' => 'Statut',
            'booker' => 'Réservant',
            'property_name' => 'Propriété',
            'open_charges' => 'Comptes ouverts',
        ],
        'errors' => [
            'invoice_opened_for_customer' => 'Le client a des comptes ouverts pour cette réservation, veuillez finaliser les comptes avant d\'en ouvrir de nouveaux',
            'credit_note_on_opened' => 'Impossible d\'émettre une note de crédit pour les factures non enregistrées',
            'associate_in_to_credit_note' => 'Impossible d\'associer un encaissement à une note de crédit',
            'associate_out_to_invoice' => 'Impossible d\'associer un paiement sortant à une facture',
            'cant_update_due_invoice_no_show' => 'Impossible de modifier la réservation car il y a des factures de no-show ou d\'annulation',
            'keep_same_customer_on_credit_note' => 'Impossible de changer le destinataire de la note de crédit liée à une facture émise',
            'impossibile_move_through_reservations' => 'Impossible de transférer un débit depuis les comptes ouverts de cette réservation, vers des comptes fermés ou des notes de crédit',
            'cant_refund_pending_sdi_invoice' => 'Impossible d\'émettre une note de crédit pour les factures en attente de validation par le SDI',
            'associate_payments_to_follows_invoice' => 'Impossible d\'associer des paiements à un reçu marqué comme "suit la facture"',
        ],
    ],

    'reservation_note' => [
        'fields' => [
            'reservation_internal' => 'notes internes sur la réservation',
            'reservation_customer' => 'notes client',
            'accommodation_customer' => 'demandes du client',
            'accommodation_checkin' => 'notes d\'enregistrement de la chambre',
            'accommodation_checkout' => 'notes de départ de la chambre',
            'accommodation_housekeeper' => 'Notes de gouvernante'
        ],
        'deposit' => [
            'wording' => 'Somme de :amount laissée avec le mode de paiement :payment_method par le client :customer',
            'card_info' => 'Données de carte enregistrées de type :card_type avec le numéro :card_number, code :card_code et expiration :expire_date',
        ],
    ],

    'reservation_payment' => [
        'move_errors' => [
            'reservation_payment_is_not_payment' => 'Le paiement effectué le :date au nom de :accountholder est un remboursement',
            'reservation_payment_rows_with_bills' => 'Le paiement effectué le :date au nom de :accountholder a des frais associés',
            'reservation_payment_is_invoiced' => 'Le paiement effectué le :date au nom de :accountholder est présent dans des documents déjà émis',
            'reservation_payment_with_different_invoice_layout' => 'Le paiement effectué le :date au nom de :accountholder a un profil de facturation non présent dans la structure de destination',
        ],
        'pre_check_errors' => [
            'reservation_payment_is_not_payment' => 'Le paiement est un remboursement',
            'reservation_payment_rows_with_bills' => 'Le paiement a des frais associés',
            'reservation_payment_is_invoiced' => 'Le paiement est présent dans des documents déjà émis',
        ],
    ],

    'reservation_quote' => [
        'export_fields' => [
            'reference_number' => 'Numéro',
            'created_at' => 'Créé',
            'customer_full_name' => 'Client',
            'expire_date' => 'Expiration',
            'status' => 'Statut',
            'expire_date_availability' => 'Expiration de l\'option',
            'email_read_at' => 'Lu le',
            'property' => 'Propriété',
            'option' => 'Proposition',
            'accommodations' => 'Hébergements',
            'stay' => 'Séjour',
            'guests' => 'Invités',
            'treatment' => 'Traitement',
            'total' => 'Total',
            'customer_email' => 'Adresse e-mail',
            'customer_telephone' => 'Téléphone',
        ],
        'status' => [
            'active' => 'Actif',
            'revoked' => 'Révoqué',
            'accepted' => 'Accepté',
            'expired' => 'Expiré',
            'draft' => 'Brouillon',
        ],
        'adults' => '{1} 1 Adulte|[2,*] :count Adultes',
        'children' => '{1} 1 Enfant|[2,*] :count Enfants',
        'errors' => [
            'no_email_found' => 'Aucune adresse email spécifiée pour envoyer le devis. Veuillez spécifier au moins une adresse.',
            'email_already_feedback_cannot_update' => 'Il n\'est pas possible de modifier le devis car le client l\'a déjà consulté ou a déjà donné un retour.',
            'no_customer_specified' => 'Le devis n\'est associé à aucun utilisateur.',
            'quote_not_active' => 'Le devis n\'est pas actif.',
            'quote_option_empty' => 'L\'option du devis ne contient pas de chambres, impossible de la confirmer.',
            'quote_option_no_availability' => 'Les hébergements que vous essayez de réserver ne sont plus disponibles.',
            'upload_attachment' => 'Erreur lors du téléchargement du fichier.',
            'other_modified' => 'Ce devis n\'est plus disponible car il a été modifié par un autre utilisateur.',
            'no_valid_property' => 'Vous ne pouvez pas insérer un hébergement d\'une propriété différente dans cette option.',
        ],
    ],

    'reservation' => [
        'reservation' => 'Réservation',
        'notes' => [
            'accommodation_internal' => 'notes internes de l\'hébergement',
            'accommodation_checkout' => 'notes de checkout de la chambre',
            'accommodation_checkin' => 'notes de check-in de la chambre',
            'accommodation_bill' => 'notes de facturation de la chambre',
            'accommodation_housekeeper' => 'notes de gouvernante de la chambre',
            'accommodation_customer' => 'notes client de la chambre',
        ],
        'details' => [
            'inserted' => 'Le coût du service :title est de :amount :currency',
        ],
        'export_fields' => [
            'id' => 'Id',
            'booked_at' => 'Date/heure de réservation',
            'modified_at' => 'Date/heure de dernière modification',
            'channel_name' => 'Canal',
            'channel' => 'Canal',
            'booker' => 'réservataire',
            'booker_full_name' => 'Réservataire',
            'group_label' => 'Groupe',
            'accommodations' => 'Hébergements',
            'rateplans' => 'Plans tarifaires',
            'original_accommodations' => 'Hébergements originaux',
            'property' => 'Propriété',
            'stay' => 'Séjour',
            'period' => 'Séjour',
            'tag' => 'Étiquette',
            'arrival_date' => 'Date d\'arrivée',
            'departure_date' => 'Date de départ',
            'number_nights' => 'Nb de nuits',
            'total_price' => 'Montant',
            'property_name' => 'Propriété',
            'reservation_id' => 'ID Réservation',
            'room' => 'Chambre',
            'total' => 'Total',
            'total_to_pay' => 'Total à payer',
            'status' => 'Statut',
            'note_customer' => 'Notes du client',
            'internal_note' => 'Notes internes',
            'group' => 'Groupe',
            'reference_number' => 'Numéro de référence',
            'commission_amount' => 'Montant de la commission',
            'treatments' => 'Traitements',
            'booker_telephone' => 'Téléphone réservataire',
            'booker_email' => 'Email réservataire',
            'company' => 'Entreprise',
            'currency' => 'Devise',
            'nic' => 'Numéro fiscal',
            'extra' => 'Supplément',
            'city_tax' => 'Taxe de séjour',
            'advance' => 'Acompte',
            'guests' => 'Invités',
            'xml_reservation_id' => 'ID réservation canal',
            'user' => 'Utilisateur',
            'reservation_from_id' => 'Provenance',
            'reservation_reason_id' => 'Motif',
            'escalate_report_to_booking' => 'Transférer le signalement à Booking.com ?',
            'allow_guest_to_book_again' => 'Permettre à l\'invité de réserver à nouveau ?'
        ],
        'activity' => [
            'new' => [
                'message' => 'Nouvelle réservation provenant de :channel_name',
                'message_sclak_generated_key' => 'Clé générée sur Sclak pour la chambre :accommodation_name (:tableau_label)',
                'message_nuki_generated_key' => 'PIN généré pour Nuki pour la chambre :accommodation_name (:tableau_label)',
                'message_sclak_sms_sent' => 'SMS envoyé avec les codes Sclak au numéro :telephone_number',
                'message_sclak_deleted_key' => 'Clé supprimée sur Sclak pour la chambre :accommodation_name (:tableau_label)',
                'message_nuki_deleted_key' => 'PIN supprimé pour la chambre :accommodation_name (:tableau_label)',
                'invoice_printig_session' => 'Impression fiscale lancée sur l’imprimante :printer_name (ID : :printer_id) pour le reçu avec l’ID : :invoice_id',
                'added_payment' => 'Ajout du paiement de :amount :currency (ID :payment_id) avec le mode :payment_method',
                'added_refund' => 'Remboursement émis de :amount :currency (ID :payment_id) avec le mode :payment_method',
            ],
            'update' => [
                'message' => 'Le champ :field_translate a été modifié de :old_value à :new_value',
                'message_novalue' => 'Le champ :field_translate a été modifié',
                'message_newvalue' => 'Ajout :field_translate :new_value',
                'message_deletevalue' => 'Suppression :field_translate :old_value',
                'message_forobject' => 'Le champ :field_translate a été modifié de :old_value à :new_value pour :model_type :model_name',
                'message_split_accommodation' => 'La chambre réservée :accommodation_source (référence tableau :tableau_label_source) (du :original_arrival_date au :original_departure_date) a été divisée du :split_arrival_date au :split_departure_date et déplacée dans la chambre :accommodation_destination (référence tableau :tableau_label_destination)',
                'message_move_accommodation' => 'La chambre réservée :accommodation_source (référence tableau :tableau_label_source, Rateplan :rateplan_name_source, Traitement :treatment_name_source, Prix :price_source) a été déplacée dans la chambre :accommodation_destination (référence tableau :tableau_label_destination, Rateplan :rateplan_name_destination, Traitement :treatment_name_destination, Prix :price_destination)',
                'message_resend_email_customer' => 'Email de réservation renvoyée au réservataire, adresse :new_value',
                'message_resend_email_company' => 'Email de réservation renvoyée à l\'entreprise, adresse :new_value',
                'message_resend_email_property' => 'Email de réservation renvoyée à la propriété, adresse :new_value',
                'message_resend_email_additional' => 'Email de réservation renvoyée à l\'adresse supplémentaire :new_value',
                'message_restored_sdi_rejected_invoice' => 'Le document :invoice_number du :invoice_date a été rouvert avec les notifications suivantes : :sdi_notify',
                'message_sdi_rejected_invoice' => 'Le document :invoice_number du :invoice_date a été rejeté avec le profil de facturation :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'message_sdi_rejected_invoice_with_advances' => 'Le document :invoice_number du :invoice_date a été rejeté avec le profil de facturation :invoice_layout (:invoice_business_name - :invoice_vat_code) avec les acomptes suivants : :advances',
                'message_sdi_rejected_invoice_as_receipt' => 'Le document rejeté :invoice_number du :invoice_date a été émis comme reçu avec le profil de facturation :invoice_layout (:invoice_business_name - :invoice_vat_code) et destiné à :invoice_customer (Total :invoice_total), avec les notifications suivantes : :sdi_notify',
                'message_registered_invoice' => 'La :document_type :invoice_number :follows_invoice du :invoice_date a été enregistrée avec le profil de facturation :invoice_layout (:invoice_business_name - :invoice_vat_code) et destinée à :invoice_customer (Total :invoice_total) :manual_fp_register',
                'message_restored_invoice' => 'La :document_type :invoice_number du :invoice_date a été annulée avec le profil de facturation :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'calculate_city_tax' => 'La taxe de séjour a été calculée pour les invités suivants : :guests',
                'no_guests_calculate_city_tax' => 'La taxe de séjour a été calculée mais il n\'y a pas d\'invités éligibles pour le calcul',
                'add_extra' => 'Les frais supplémentaires ont été ajoutés : :extra',
                'delete_bill' => 'Les frais ont été supprimés : :extra',
                'transferred_bills' => 'Les frais : :transfer_label ont été transférés : :bills_label',
                'transferred_bills_qty' => 'La quantité : :transfer_label des frais : :bills_label a été transférée',
                'transferred_bills_to_charges' => 'La valeur : :transfer_label des frais : :bills_label a été transférée au compte courant :invoice_label (:invoice_id)',
                'transferred_bills_to_accommodation' => 'La valeur : :transfer_label des frais : :bills_label a été transférée à la chambre :accommodation_label (:accommodation_id) - Réservation :reference_number',
                'transferred_bills_to_accommodation_multi_customer' => 'La valeur : :transfer_label des frais : :bills_label a été transférée à la chambre :accommodation_label (:accommodation_id) - Réservation :reference_number aux clients :customers',
                'transferred_bills_qty_to_charges' => 'La quantité : :transfer_label des frais : :bills_label a été transférée au compte courant :invoice_label (:invoice_id)',
                'transferred_bills_qty_to_accommodation' => 'La quantité : :transfer_label des frais : :bills_label a été transférée à la chambre :accommodation_label (:accommodation_id) - Réservation :reference_number',
                'transferred_bills_qty_to_accommodation_multi_customer' => 'La quantité : :transfer_label des frais : :bills_label a été transférée à la chambre :accommodation_label (:accommodation_id) - Réservation :reference_number aux clients :customers',
                'transferred_bills_to_accommodation_reservation_destination' => 'Les frais suivants ont été transférés du compte courant :invoice_origin (#:invoice_origin_id) : :bills_label',
                'restored_bills' => 'Les frais ont été restaurés : :bills_label',
                'message_deleted_credit_note' => 'Le document :document_type :invoice_number du :invoice_date a été supprimé avec le profil de facturation :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'edit_payment' => 'Le paiement (ID :payment_id) avec le mode :payment_method a été modifié. Total :amount :currency',
                'message_edit_guest' => 'L\'invité :guest_name a été modifié',
                'transferred_payment_to_reservation' => 'Le paiement (#:paymentId) effectué le :date au nom de :accountholder de la Réservation :reservationOrigin a été transféré à la Réservation :reservationDestination',
                'restored_payment_to_reservation' => 'Le paiement (#:paymentId) effectué le :date au nom de :accountholder de la Réservation :reservationOrigin a été restauré',
                'guest_checkin_checkout' => 'Les dates d\'arrivée ou de départ ont été modifiées à la suite d\'un changement de dates pour les invités suivants :guests',
                'model_price_original' => 'Le champ :field_translate a été modifié de :old_value à :new_value. Le client a choisi de conserver le prix actuel.',
                'model_price_moved' => 'Le champ :field_translate a été modifié de :old_value à :new_value. Le client a choisi le nouveau prix.',
            ],
            'delete' => [
                'delete_payment' => 'Un paiement de :amount :currency (ID :payment_id) avec le mode :payment_method a été supprimé',
            ],
            'view' => [
                'credit_card_fail' => 'Une tentative de lecture de la carte de crédit a échoué. (:ip_address)',
                'credit_card_success' => 'Les données de la carte de crédit ont été visualisées. (:ip_address)',
            ],
            'internal_note' => 'Note interne : :note',
            'bill_note' => 'Notes pour la facturation : :note',
            'catering_note' => 'Note repas : :note',
            'customer_note' => 'Demandes du client : :note',
            'nuki' => [
                'create' => 'Appareil Nuki (:device_id) : code de porte créé pour la chambre :tableau_label',
                'update' => 'Appareil Nuki (:device_id) : autorisations de code modifiées pour la chambre :tableau_label',
                'delete' => 'Appareil Nuki (:device_id) : code de porte supprimé pour la chambre :tableau_label',
            ],

        ],
        'wording' => [
            'advance_invoice' => 'Séjour du :date_from au :date_to',
            'customer' => 'Client : ',
            'advance_count' => 'Acompte nr : ',
            'partial' => 'Partiel',
            'total' => 'Total',
            'credit_note' => 'En storno de la :type nr. :number du :invoice_date',
            'accommodation_bill_label' => 'Séjour',
            'city_tax_label' => ':cost par nuit de :min_age à :max_age ans pour un maximum de :limit_days jours',
            'city_tax_label_no_limit' => ':cost par nuit de :min_age à :max_age ans sans limite de jours',
        ],
        'fields' => [
            'model_name' => 'réservation',
            'arrival_date' => 'Date d\'arrivée',
            'departure_date' => 'Date de départ',
            'total_price' => 'prix final',
            'total_adults' => 'nombre d\'adultes',
            'overbooking' => 'surréservation',
            'label_name' => 'groupe de clients',
            'reason' => 'raison du voyage',
            'total_children' => 'nombre d\'enfants',
            'split_reservation' => 'réservation partagée',
            'sclak_deleted_key' => 'Clé supprimée sur Sclak',
            'sclak_generated_key' => 'Clé générée sur Sclak',
            'sclak_sms_sent' => 'SMS envoyé avec code Slack',
            'move_accommodation' => 'déplacement de chambre',
            'accommodation_bill' => 'Notes de facturation',
            'status' => 'statut',
            'keep_availability' => 'ne pas restaurer',
            'expiration_date' => 'date d\'expiration',
            'availability_option' => 'option de disponibilité',
            'resend_email' => 'renvoyer l\'email',
            'commission_amount' => 'montant de la commission',
            'reservation_reason_id' => 'identifiant du motif de la réservation',
            'reservation_from_id' => 'origine',
            'reservation_bill' => 'facture de réservation',
            'reservation_checkin' => 'réservation check-in',
            'reservation_checkout' => 'réservation check-out',
            'partner_download' => 'téléchargement du partenaire',
            'commissionable_amount' => 'montant commissionnable',
            'is_group' => 'est un groupe',
            'commission_discount_type_id' => 'identifiant du type de remise sur commission',
            'commission_discount_value' => 'valeur de la réduction de commission',
            'added_credit_card_data' => 'données de carte de crédit ajoutées',
        ],
        'payment_status' => [
            'paid' => 'Payé',
            'to_be_invoiced' => 'À facturer',
            'to_pay' => 'À payer',
            'suspended' => 'Suspendu',
        ],
        'policy' => [
            'none' => 'Aucune pénalité',
        ],
        'errors' => [
            'property_deleted' => 'Impossible de supprimer la réservation, contacter la propriété',
            'missing_main_room_guest' => 'Hôte principal non configuré pour toutes les chambres',
            'accommodation_not_found' => 'L\'hébergement a été supprimé',
            'different_accommodation_checkout_date' => 'Les chambres de la réservation ont des dates de départ différentes',
            'different_accommodation_checkin_date' => 'Les chambres de la réservation ont des dates d\'arrivée différentes',
            'transfer_on_same_customer_bill' => 'Impossible de diviser pour le même payeur',
            'no_guests_loaded' => 'Aucun invité trouvé pour la chambre',
            'not_mapped_accommodation' => 'La chambre n\'est pas correctement mappée',
            'not_switch_virtual' => 'Impossible de déplacer la réservation sur une chambre virtuelle d\'une autre propriété',
            'last_accommodation' => 'Impossible de supprimer la dernière chambre restante',
            'not_tableau' => 'Chambre Tableau non appartenant à l\'hébergement',
            'impossible_change' => 'Impossible de procéder à ce changement d\'état',
            'missing_roomreservation_id' => 'Aucune chambre trouvée pour la roomreservation envoyée',
            'missing_order' => 'Commande introuvable',
            'existing_bills_invoiced' => 'Des factures et des reçus sont associés à la réservation. Impossible de continuer',
            'uneditable_field' => 'Champ non modifiable',
            'no_gateway_response' => 'Erreur de connexion avec la passerelle de paiement',
            'reservation_unpaid' => 'La transaction n\'a pas été effectuée',
            'missing_balance' => 'Manque de paiement restant',
            'uneditable_fields_invoice' => 'Les champs suivants ne peuvent pas être modifiés : ',
            'not_editable_total_due_paid' => 'Le prix saisi est inférieur au total payé',
            'not_editable_total_due_invoice' => 'Le prix saisi est inférieur au total facturé',
            'accommodation_room_guest_exists' => 'L\'invité spécifié existe déjà pour les dates spécifiées',
            'no_payment_amount_enough' => 'Le crédit disponible (:amount_available) n\'est pas suffisant pour couvrir la somme demandée (:request_amount)',
            'payment_amoun_minor_of_amount_used' => 'Le montant spécifié (:request_amount) est inférieur à celui déjà utilisé (:amount_used_global)',
            'cannot_delete_deposit_invoice' => 'Impossible de supprimer un paiement déjà utilisé dans une facture émise',
            'accommodation_invoiced' => 'La chambre a déjà été facturée, elle ne peut pas être supprimée',
            'resend_email_empty_address' => 'Aucune adresse email spécifiée pour ce client',
            'householder_in_agreement' => 'Le chef de famille est inclus dans le partage des frais, modifiez la personnalisation avant de procéder avec cette modification',
            'missing_company' => 'Référence entreprise manquante pour la réservation',
            'accommodation_bill_charged' => 'Le frais de la chambre a été facturé. Impossible de continuer',
            'all_billed' => 'Tous les frais ont été fiscalisés ou transférés. Impossible de régénérer',
            'impossible_move_nature_bill' => 'Impossible de déplacer la nature du frais : ',
            'billed_accommodation' => 'Non è possibile cambiare le date di prenotazione perché sono stati emessi documenti fiscali.
            Inserisci una nuova prenotazione o aggiungi una camera a questa prenotazione con le nuove date.',
            'deposit_as_refund' => 'Un dépôt ne peut pas être configuré comme remboursement',
            'refund_in_invoice' => 'Impossible d\'associer un remboursement à une facture ou un reçu',
            'different_vat_codes' => 'Impossible d\'associer des paiements ou reçus à une facture avec un numéro de TVA différent',
            'property_not_attached' => 'Impossible d\'associer des paiements à des propriétés non impliquées dans la réservation',
            'too_many_payments' => 'Le montant des paiements dépasse les dépenses ou le montant à rembourser',
            'bill_and_expense' => 'Impossible de lier le paiement à une dépense et à une facture',
            'expense_minimum_payment' => 'La dépense doit avoir au moins un paiement, impossible de continuer',
            'amount_exceed_refunds' => 'Le paiement à associer dépasse la partie utilisable considérant les remboursements',
            'missing_reservation' => 'Réservation non valide.',
            'already_cancelled' => 'La réservation est déjà annulée.',
            'impossible_decrement_shared_bill' => 'Impossible de diminuer la quantité d\'un frais partagé',
            'pax_fields_in_not_paxable_bill' => 'Impossible d\'insérer des invités pour des frais autres que les services supplémentaires basés sur des invités',
            'company_email_address_is_empty' => 'Aucune adresse email spécifiée pour cette entreprise',
            'checkinonline_dati_mancanti' => 'Données non envoyées correctement.',
            'checkinonline_reservation_not_found' => 'Réservation introuvable.',
            'checkinonline_reservation_is_cancelled' => 'La réservation est annulée.',
            'checkinonline_reservation_is_not_confirmed' => 'La réservation n\'est pas confirmée',
            'checkinonline_reservation_arrival_date_past' => 'La date d\'arrivée est antérieure à aujourd\'hui.',
            'checkinonline_reservation_departure_date_over' => 'La réservation est déjà terminée.',
            'checkinonline_city_tax_cannot_pay' => 'Aucune taxe de séjour à payer.',
            'deposit_as_deposit' => 'Le paiement est déjà un acompte, impossible de continuer',
            'deposit_as_advance' => 'Impossible d\'émettre un document d\'acompte pour un dépôt confirmé',
            'document_on_funds' => 'Impossible d\'émettre un document sur la somme de fonds',
            'document_on_used_payment' => 'Impossible d\'émettre un document sur un paiement utilisé pour régler d\'autres documents',
            'not_whole' => 'Impossible d\'émettre un document sur un paiement associé',
            'document_on_refunded' => 'Impossible d\'émettre un document sur un paiement remboursé',
            'document_on_payments_out' => 'Impossible d\'émettre un document sur des paiements sortants',
            'channel_checkin_missing_info' => 'Aucune information sur l\'état de la demande',
            'channel_checkin_missing_status_already_present' => 'L\'état du checkin a déjà été traité',
            'no_bills_on_customer' => 'Aucun frais pour le client dans la division de la facture',
            'discount_over_invoiced_value' => 'Différence de prix à appliquer supérieure à la valeur à facturer',
            'no_show_requested_total_major_bills_to_invoice' => 'Le total demandé pour le no show dépasse la valeur à facturer',
            'checkin_major_checkout' => 'La date d\'arrivée est égale ou supérieure à la date de checkout pour la chambre :accommodation_name, impossible de continuer',
            'checkout_major_checkin' => 'La date de départ est égale ou supérieure à la date d\'arrivée pour la chambre :accommodation_name, impossible de continuer',
            'missing_addon' => 'Le service supplémentaire avec des champs manquants, impossible de continuer',
            'missing_customer_on_split_bills_same_reservation' => 'Impossible de diviser les frais dans la même réservation sans spécifier des payeurs spécifiques',
            'have_door_service_active' => 'Impossible d\'ajouter manuellement une clé de porte car le service externe :external_service_name est actif',
            'conflict_system_custom_email_template' => 'Plus d\'un modèle a été spécifié pour l\'envoi, spécifiez-en seulement un.',
            'guest_already_present_in_same_dates' => 'Impossible de continuer : invité déjà présent pour les mêmes dates',
            'can_not_move_reservation_payments' => 'Impossible de déplacer les paiements pour les erreurs suivantes : :errors',
            'can_not_modify_ota_checkin_checkout' => 'Impossible de modifier les dates d\'une réservation provenant d\'un canal.',
            'unsuitable_dates_for_guests' => 'Dates de séjour incompatibles pour les invités : :guests',
            'unsuitable_dates_for_guests_one_day' => 'Dates de séjour multiples pour les invités : :guests pour une seule nuitée, veuillez supprimer un des séjours avant de continuer',
        ],
        'warnings' => [
            'not_mapped_addons' => 'Le service demandé n\'est pas associé à la chambre : ',
            'bill_splitted' => 'Frais répartis sur plusieurs comptes non modifiables : ',
            'bill_children' => 'Frais partiels dérivés non modifiables : ',
            'all_bills_closed' => 'Tous les comptes sont fermés pour cette réservation',
            'deposit_cut' => 'Un remboursement a été effectué à partir du paiement de frais : ',
            'not_existing_bill' => 'Frais non existants',
            'exceeding_num_adults' => 'Nombre d\'adultes supérieur au maximum autorisé pour la chambre',
            'exceeding_num_children' => 'Nombre d\'enfants supérieur au maximum autorisé pour la chambre',
            'existing_payments_pending' => 'Des paiements sont en attente sur les frais de la chambre, voulez-vous continuer ?',
            'existing_invoices_joined' => 'Il existe des documents liés à ces frais : :bill_name, impossible de transférer vers d\'autres chambres ou comptes externes',
            'customer_invoiced' => 'Des factures ont été émises pour le client :customer, impossible de les annuler',
            'is_previous' => 'Réservation antérieure à la connexion du canal',
            'bill_cant_split' => 'Frais non divisibles dans ce type',
            'bill_charged' => 'Un ou plusieurs frais ont été facturés, impossible de modifier.',
            'bill_qty_incoerence' => 'Quantité non cohérente avec le nombre d\'invités associés aux frais',
            'no_guests' => 'Aucun invité présent pour cette réservation',
            'move_other_property_notify' => 'Veuillez choisir une propriété pour envoyer les notifications',
            'bill_deposit_not_allowed' => 'Le paiement ne peut être associé à ce type de frais',
            'bill_discount_unsuitable_to_row' => 'La remise recalculée est incompatible avec la portion de frais facturée',
            'bill_rows_discount_deleting' => 'Le transfert a causé la réinitialisation de la remise sur les frais sources dans le compte ouvert',
            'existing_bills_night' => 'Les services supplémentaires pour les nuits non incluses dans le séjour seront supprimés',
            'change_status_in_progress' => 'Le statut de la réservation est déjà en train d\'être modifié.',
            'reservation_accommodation_door_key_code_reservation_resumed' => 'Il est nécessaire de générer une nouvelle clé, l\'ancienne ayant été désactivée suite au changement de statut de la réservation.',
            'reservation_accommodation_door_key_code_exist' => 'Des codes d\'ouverture de porte existent. Procédez manuellement à la régénération ou à l\'annulation.',
            'reservation_accommodation_door_key_code_exist_moved_accommodation' => 'Un ou plusieurs hébergements ont été déplacés. Il est nécessaire de générer une nouvelle clé.',
            'reservation_accommodation_door_key_code_delete' => 'Une erreur est survenue lors de la suppression des clés. Veuillez réessayer manuellement',
            'reservation_accommodation_door_key_code_generate' => 'Une erreur est survenue lors de la génération des clés. Veuillez réessayer manuellement',
            'existing_transferred_bills' => 'Des frais transférés d\'autres chambres existent, vous devez les restaurer ou les réassigner avant de continuer',
            'bill_has_payment' => 'Il existe des paiements liés à ces frais : :bill_name, impossible de les transférer vers des chambres ou des documents externes',
        ],
        'channels' => [
            'no_report_invalid_cc' => 'Le rapport carte de crédit invalide n\'est pas requis pour ce canal',
            'no_report_noshow' => 'Le rapport no-show n\'est pas requis pour ce canal',
            'no_report_cancellation_due_invalid' => 'Le rapport annulation n\'est pas requis pour ce canal',
            'payment_to_ota' => 'Le paiement a été effectué au canal :channel_name',
            'no_previous' => 'Le canal ne prend pas en charge le téléchargement des réservations antérieures',
            'email' => [
                'without_room_title' => 'Nouvelle réservation sans chambre de :channel_name (ID :reference_number) - Propriété :property_name',
                'without_rate_title' => 'Nouvelle réservation sans tarif de :channel_name (ID :reference_number) - Propriété :property_name',
            ],
        ],
        'bills' => [
            'reservation_bill_id_not_found' => 'L\'ID :reservation_bill_id n\'appartient pas à la réservation spécifiée',
            'reservation_bill_id_already_override' => 'L\'ID :reservation_bill_id a déjà été écrasé',
            'reservation_bill_id_no_updates' => 'Tous les éléments appartiennent déjà à une réécriture ou n\'appartiennent pas à la réservation spécifiée',
            'delete_bill_accounted' => 'Impossible de supprimer car un ou plusieurs éléments ont déjà été comptabilisés',
            'delete_sheet_bill_emitted' => 'Impossible de supprimer la facture car une facture a déjà été émise',
            'different_vat_quotes_in_merge' => 'Impossible d\'écraser les frais avec une TVA différente',
            'cant_editable_due_moved' => 'Frais déplacés : seule la modification de la remise est autorisée',
        ],
        'invoice' => [
            'invoice_already_registered' => 'La facture a déjà été émise',
            'no_invoice_layout' => 'Aucun modèle de facturation n\'est présent. Impossible de continuer',
            'no_an_invoice' => 'Ce n\'est pas une facture',
            'no_company_id' => 'Aucune entreprise spécifiée pour effectuer la facture',
            'unsuitable_payments' => 'Les paiements associés ne sont pas compatibles avec le numéro de TVA lié au compte',
            'too_many_advances' => 'Le montant des acomptes versés dépasse le total des frais',
            'advances_in_advance' => 'Impossible d\'ajouter des acomptes dans une facture d\'acompte',
            'payments_major_total_invoice' => 'Le total des paiements dépasse le montant total de la facture',
        ],
        'pdf' => [
            'reservation' => [
                'filters' => [
                    'in_house' => 'En séjour',
                    'arrival_date' => 'Arrivée',
                    'departure_date' => 'Départ',
                ],
                'booker' => [
                    'origin' => 'Canal de réservation',
                    'name' => 'Nom de l\'hôte',
                    'telephone' => 'Téléphone',
                    'email' => 'E-Mail',
                    'pec' => 'PEC',
                    'language' => 'Langue',
                    'reference_number' => 'Numéro de réservation',
                    'booked_at' => 'Date de réservation',
                    'commissionable_amount' => 'Montant soumis à commission',
                    'commission_amount' => 'Commission',
                    'other_infos' => 'Informations importantes sur cet hôte',
                    'notes' => [
                        'note_internal' => 'Notes internes',
                        'note_customer' => 'Notes du client',
                        'note_bill' => 'Notes de facturation',
                        'note_checkin' => 'Notes de check-in',
                        'note_checkout' => 'Notes de check-out',
                    ],
                ],
                'accommodation' => [
                    'from_date' => 'Arrivée',
                    'to_date' => 'Départ',
                    'duration' => 'Durée du séjour',
                    'duration_text' => '{1} :length nuit|[2,*] :length nuits',
                    'total_guests' => 'Total des hôtes',
                    'guests_adults_text' => ':quantity adultes',
                    'guests_children_text' => ':quantity enfants',
                    'total_accommodations' => 'Nombre total de chambres',
                ],
                'reservation' => [
                    'name' => 'Nom de l\'hôte',
                    'total_guests' => 'Nombre d\'hôtes',
                    'guests_adults_text' => ':quantity adultes',
                    'guests_children_text' => ':quantity enfants',
                    'max_capacity' => 'Capacité maximale',
                    'capacity_text' => ':quantity hôtes',
                    'meals' => 'Repas',
                    'meals_breakfast_included' => 'Le petit-déjeuner est inclus dans le tarif de la chambre',
                    'table' => [
                        'date' => 'Date',
                        'price' => 'Prix',
                        'price_per_day' => 'Prix par nuit',
                        'non_refundable_rate' => 'Tarif non remboursable',
                        'subtotal' => 'Sous-total',
                        'city_tax' => 'Taxe de séjour',
                        'city_tax_detail' => 'Montant par personne et par nuit',
                        'total_accommodation_price' => 'Prix total de l\'hébergement',
                        'vat_included' => 'Le tarif inclut :amount de TVA',
                        'vat_not_included' => 'Tarif hors TVA',
                    ],
                ],
                'statuses' => [
                    'cancelled' => 'Annulée',
                    'optionable' => 'Optionnelle',
                    'hidden' => 'Cachée',
                    'pending' => 'En attente de paiement',
                    'confirmed' => 'Confirmée',
                ],
                'totals' => [
                    'statuses' => [
                        'Cancelled' => 'Annulée',
                        'Optionable' => 'Optionnelle',
                        'Hidden' => 'Cachée',
                        'Pending' => 'En attente de paiement',
                        'Confirmed' => 'Confirmée',
                        'Expired' => 'Expirée',
                    ],
                    'status' => 'Statut de la réservation',
                    'total_amount' => 'Montant total',
                    'paid_deposit' => 'Acompte payé',
                    'total_paid' => 'Payé',
                    'total_to_be_paid' => 'À régler',
                ],
                'payments' => [
                    'table' => [
                        'date' => 'Date d\'enregistrement',
                        'method' => 'Mode de paiement',
                        'amount' => 'Montant',
                        'notes' => 'Notes',
                    ],
                ],
            ],
            'bills' => [
                'accommodations' => 'Hébergements',
                'accommodation' => 'Hébergement',
                'total' => 'Total',
                'date' => 'Date',
                'room' => 'Chambre',
                'treatment' => 'Traitement',
                'amount_per_night' => 'Montant par nuit',
                'addons_categories' => 'Services supplémentaires',
                'addon_category' => 'Catégorie',
                'addon_name' => 'Service',
                'addon_price_type' => 'Type de tarif',
                'amount' => 'Montant',
                'taxes' => 'Taxes',
                'tax_name' => 'Type de taxe',
                'accommodations_title' => 'Détails des hébergements',
                'addons_categories_title' => 'Détails des services supplémentaires',
                'taxes_title' => 'Détails des taxes',
            ],
            'guests' => [
                'guests_list' => 'Liste des hôtes enregistrés pour la réservation',
                'reservation_of_date' => 'du',
                'duration_text' => ':length nuits',
                'from' => 'Du',
                'to' => 'Au',
                'table' => [
                    'type' => 'Type',
                    'name' => 'Nom',
                    'surname' => 'Prénom',
                    'birthday_date' => 'Date de naissance',
                    'gender' => 'Sexe',
                    'birth_place' => 'Lieu de naissance',
                    'checked_in' => 'Enregistrement effectué',
                    'none' => 'Aucun hôte enregistré',
                ],
            ],
            'payment' => [
                'payments_short_title' => 'Détails des paiements',
                'payments_title' => 'Paiements et documents',
                'report_title' => 'Note de paiement',
                'deposit_title' => 'Acompte',
                'refund_title' => 'Note de remboursement',
                'issuer' => 'Émetteur du paiement',
                'registration_date' => 'Date d\'enregistrement du paiement',
                'payment' => 'Paiement',
                'payment_date' => 'Date du paiement',
                'method' => 'Mode de paiement',
                'amount' => 'Montant',
                'pos' => 'POS',
                'deposit_number' => 'Numéro d\'acompte',
                'payments_received' => 'Paiements reçus',
                'notes' => 'Notes',
                'deposit' => 'Acompte',
                'to_pay' => 'Montant à payer',
                'excess_payment' => 'Montant excédentaire',
                'invoiced' => 'Montant facturé',
                'to_be_invoiced' => 'Montant à facturer',
                'total_to_be_invoiced' => 'Montant total à facturer',
                'document_type' => 'Type de document',
                'document_number' => 'Numéro',
                'document_date' => 'Date d\'émission',
                'invoice_issuer' => 'Émetteur de la facture',
                'invoice_paid' => 'Payé',
                'invoice_to_pay' => 'À payer',
            ],
            'fees' => [
                'fees_title' => 'Honoraires',
                'document_type' => 'Type',
                'total' => 'Total',
                '22' => 'TVA 22%',
                '10' => 'TVA 10%',
                'customer' => 'Client ou entreprise',
            ],
            'deposits' => [
                'deposits_title' => 'Acomptes et dépôts',
                'export_fields' => [
                    'property' => 'Propriété',
                    'number' => 'Numéro',
                    'date' => 'Date',
                    'total' => 'Total',
                    'amount_available' => 'Montant disponible',
                    'used' => 'Utilisé',
                    'reservation_id' => 'ID réservation',
                    'pos' => 'POS',
                    'type_payment' => 'Type de paiement',
                    'type_reservation' => 'Type de réservation',
                    'description' => 'Description',
                    'user_pay' => 'Payeur',
                    'reservation' => 'Réservations',
                    'payment_method' => 'Méthode de paiement',
                    'stay' => 'Séjour',
                    'departure_date' => 'Date de départ',
                ],
            ],
        ],
        'of_date' => 'du :date',
        'arrival_date' => 'Arrivée',
        'departure_date' => 'Départ',
        'nights' => 'Nuits',
        'accommodations' => 'Chambres',
        'policy_description' => 'Résumé des conditions',
        'policy_deposit_description' => 'Résumé du paiement',
        'payments_timetable' => [
            'title' => 'Conditions de paiement',
            'subtitle' => 'Ci-dessous les dates des paiements pour le séjour',
            'statuses' => [
                'scheduled' => 'Planifié',
                'processed' => 'Traité',
                'failed' => 'Échoué',
                'paused' => 'En pause',
                'cancelled' => 'Annulé',
                'wait_customer' => 'En attente du client',
                'partial_processed' => 'Traité partiellement',
            ],
            'city_tax' => [
                'checkin_online' => 'La taxe de séjour de :amount est exclue et sera automatiquement facturée après la réalisation du check-in en ligne. En cas de non-réalisation du check-in en ligne, elle sera facturée directement sur place.',
                'checkout' => 'Le montant de :amount est une estimation et peut varier en présence d\'exemptions ou de modifications du nombre d\'hôtes ou de nuits passées.'
            ],
        ],
        'log' => [
            'city_tax_log_title' => 'Taxe de séjour',
            'extra_log_title' => 'Services supplémentaires',
            'bill_title' => 'Frais',
            'notes' => 'Section Notes',
            'guest' => 'Hôte',
            'payment' => 'Paiement',
        ],
        'errors_reason' => [
            'update_system' => 'Vous ne pouvez pas modifier une raison système',
            'delete_system' => 'Vous ne pouvez pas supprimer une raison système',
            'not_exist' => 'Raison non trouvée',
        ],
        'customer_profile_deleted' => 'Le profil de cet invité a été supprimé et ne peut pas être modifié. Voulez-vous le réactiver pour poursuivre la modification?',
    ],

    'rhino' => [
        'exceptions' => [
            'request_not_valid' => 'Champs manquants',
            'method_not_found' => 'La méthode appelée n\'existe pas',
        ],
        'vat_code_already_exists' => 'Ce numéro de TVA est déjà présent dans le système. Assurez-vous d\'entrer un numéro de TVA unique qui n\'a pas déjà été enregistré.',
    ],

    'roles' => [
        'property' => [
            // TODO:
            'master' => 'Direction',
            'operator' => 'Opérateur',
            'housekeeper' => 'Femme de chambre',
        ],
        'errors' => [
            'access_denied_property' => 'Rôle incorrect : l\'utilisateur n\'a pas les permissions de directeur pour accéder à la structure.'
        ]
    ],

    'sca' => [
        'pdf' => [
            'filename' => 'Autorisation de carte de crédit',
            'card_holder' => 'Le nom du propriétaire',
            'card_type' => 'type de carte de crédit',
            'card_number' => 'Numéro de Carte de Crédit',
            'card_expiration' => 'Date d\'expiration',
            'card_cvc' => 'CVC',
            'parts' => [
                'p1' => 'Autorisation de carte de crédit',
                'p2' => 'Attention - Les champs marqués d\'un astérisque sont obligatoires',
                'p3' => 'Nous vous prions de bien vouloir fournir toutes les informations pour procéder à la confirmation de votre réservation.',
                'p4' => 'Envoyez le formulaire rempli avec tous les documents nécessaires a: <span class="link">:email</span>',
                'p5' => 'Information du proprietarie de carte:',
                'p6' => 'Nous certifions que les informations fournies sont exactes et véridiques.',
                'p7' => 'J\'autorise par la présente le débit du montant indiqué sur la carte de crédit / débit suivante',
                'p8' => '<span class = "bold"> Pour les tarifs non remboursables </span>, la carte de crédit indiquée sera immédiatement débitée du montant demandé.',
                'p9' => '<span class = "bold"> Pour des tarifs flexibles </span>, la carte de crédit indiquée peut faire l\'objet d\'un contrôle de validité après préautorisation du montant requis par la politique.',
                'p10' => 'La signature du titulaire',
                'p11' => 'Numéro de réservation',
                'p12' => 'Date d\'arrivée',
                'p13' => 'Avec ce document, le recto / verso de la carte de crédit/débit utilisée pour le paiement est exigé avec une copie de la carte d\'identité/passeport du titulaire. Assurez-vous que les documents requis sont immédiatement envoyés à: <span class="link">:email</span>',
                'p14' => 'Ne recevant pas les documents requis, la réservation sera considérée comme nulle et par conséquent annulée.Toutes les informations seront considérées comme confidentielles et utilisées uniquement aux fins mentionnées ci-dessus.',
                'p15' => ':name – :address, :zip_code – :city_name <span class="link">:email</span> - <span class="link">:website</span>',
            ],
        ],
        'confirmation_request_expired' => 'Demande déjà expirée',
        'email' => [
            'subject' => ':property - Solicitud de autorización',
            'payment_confirmation' => 'Confirmation de paiement',
            'reservation_confirmation' => 'Numéro de confirmation de réservation :referenceNumber',
            'date' => 'Date',
            'click_here_link' => 'Cliquez ici pour confirmer le formulaire SCA',
            'payment_total' => 'Paiement total',
            'reservation_total' => 'Réservation totale',
            'payment_summary' => 'Résumé de paiement',
            'reservation_summary' => 'Résumé de la réservation',
            'we_are_waiting_for_you_on_date' => 'Nous sommes impatients de vous accueillir sur :date',
            'you_payment_for' => 'Votre paiement pour :name',
            'your_reservation_for' => 'Votre réservation pour :name',
            'dear_customer_reservation' => 'Cher(e) :name :surname, <br /> Pour garantir votre réservation, nous vous invitons à autoriser l\'utilisation de votre carte de crédit conformément aux conditions de réservation et d\'annulation.<br><br>Merci de votre coopération.',
            'dear_customer_payment' => 'Cher(e) :name :surname, <br /> Pour garantir votre réservation, nous vous invitons à autoriser l\'utilisation de votre carte de crédit conformément aux conditions de réservation et d\'annulation.<br><br>Merci de votre coopération.',
            'subject_reservation' => ':name :surname, confirmer votre réservation',
            'subject' => 'Autorisation SCA / 3DS requise',
            'payment_click_here_link' => 'Cliquez ici pour confirmer le paiement',
            'authorize_card_use' => 'Autoriser l\'utilisation de la carte',
            'non_beddy_payment_click_here_link' => 'Pour confirmer votre réservation, rendez-vous sur le lien suivant : :link',
            'non_beddy_reservation_click_here_link' => 'Pour confirmer le paiement, rendez-vous sur le lien suivant : :link',
            'sca_payment_accepted' => 'Nous vous informons que votre demande de confirmation du formulaire SCA/PSD2 pour la réservation #:referenceNumber a été acceptée par le client.',
            'sca_reservation_accepted' => 'Nous vous informons que votre demande de confirmation du formulaire SCA/PSD2 pour la réservation #:referenceNumber a été acceptée par le client.',
            'subject_accepted' => 'L\'autorisation SCA/3DS a été confirmée',
        ],
        'whatsapp' => [
            'message' => 'Cher :name :surname, pour confirmer votre réservation # :referenceNumber (:arrivalDate - :departureDate) nous avons besoin de l\'autorisation de votre carte de crédit. Cliquez ici :link',
        ],
    ],

    'social_archive' => [
        'export_fields' => [
            'property_name' => 'Propriété',
            'unlock_email' => 'Email',
            'unlock_date' => 'Date d\'inscription',
        ],
    ],

    'statistics' => [
        'partitioning_translations' => [
            'yearly' => 'par an|à :value ans',
            'monthly' => 'par an|à :value ans',
            'daily' => 'par an|à :value ans',
        ],
        'warnings' => [
            'limit_truncation' => 'La plage de visualisation demandée est trop large. La plage de recherche a été limitée à :partitioning_translation.',
            'previous_offset_available_only_with_daily_partitioning' => 'Le type de comparaison est disponible uniquement en affichage quotidien. La période choisie sera comparée avec l\'année précédente',
        ],
        'exceptions' => [
            'invalid_split' => 'Opération non disponible',
            'not_available' => 'Fonctionnalité momentanément non disponible',
            'cannot_create_groupable' => 'Paramètres non valides pour le regroupement',
            'invalid_date_range' => 'Plages de dates invalides',
        ],
        'legend' => [
            'no_model' => 'Non spécifié',
            'deleted_rateplans' => 'Tarifs supprimés',
            'no_treatment' => 'Traitement non spécifié',
            'charges' => 'Extras manuels',
            'no_label' => 'Sans nom',
            'stay' => 'Séjours',
            'tax' => 'Taxes',
            'ob' => 'Surbooking',
            'virtual_stamp' => 'Timbre virtuel',
            'city_tax' => 'Taxe de séjour',
            'no_show' => 'No show',
            'cancellation' => 'Annulation hors délais',
            'no_show_stay' => 'Séjour en no show',
            'cancellation_stay' => 'Séjour en annulation hors délais',
            'no_show_extra' => 'Extra en no show',
            'cancellation_extra' => 'Extra en annulation hors délais',
            'penalty' => 'Pénalités',
            'general_invoices' => 'Comptes en suspens',
            'manual' => 'Adhésions manuelles',
            'payment' => 'Accomptes',
            'beddy_channel_labels' => [
                'quote' => 'Beddy (Devis)',
                'website' => 'Beddy (Site Web)',
                'manual' => 'Beddy (PMS)',
                'general' => 'Beddy (Comptes en suspens)',
                'google-hotel' => 'Google Hotel',
                'trivago-fast-connect' => 'Trivago',
                'trivago-express-booking' => 'Trivago Express Booking',
                'bookingbooster' => 'Booking Booster',
            ],
        ],
        'label' => 'Date',
        'label_date' => 'Date de référence',
        'label_channel' => 'Segment de canal',
        'label_accommodation' => 'Segment de chambre',
        'label_room' => 'Segment numéro de tableau',
        'label_booker_category' => 'Segment catégorie client',
        'label_rateplan' => 'Segment plan tarifaire',
        'label_reservation_from' => 'Segment source de réservation',
        'label_nationality' => 'Segment nationalité',
        'label_property' => 'Segment propriété',
        'label_dealer_company' => 'Segment entreprise',
        'label_dealer_agency' => 'Segment agence',
        'label_dealer_tour_operator' => 'Segment tour opérateur',
        'label_production_type' => 'Segment département',
        'production_over_time' => 'Ventes par période',
        'revenue' => 'Ventes',
        'production' => 'Production par période',
        'available_nights' => 'Nuits disponibles',
        'unsold_nights' => 'Nuits invendues',
        'penalty_nights' => 'Nuits en pénalité',
        'arrivals' => 'Arrivées',
        'departures' => 'Départs',
        'average_stay_length' => 'Durée moyenne du séjour',
        'average_guest_earning' => 'Revenu moyen par invité',
        'sold_nights' => 'Nuits vendues',
        'occupation_percentage' => 'Taux d\'occupation',
        'total_price' => 'Ventes',
        'adr' => 'ADR',
        'revpar' => 'Revpar',
        'counted_reservations' => 'Total des réservations',
        'confirmed_reservations' => 'Réservations confirmées',
        'cancelled_reservations' => 'Réservations annulées',
        'cancellation_ratio' => 'Taux d\'annulation',
        'counted_average_booking_window' => 'Fenêtre de réservation moyenne comptabilisée',
        'confirmed_average_booking_window' => 'Jours d\'avance sur réservation',
        'cancelled_average_booking_window' => 'Jours d\'avance sur annulation',
        'rooms_checkin' => 'Chambres à l\'arrivée',
        'rooms_checkout' => 'Chambres au départ',
        'label_department' => 'Département',
        'label_service' => 'Service',
        'gross_amount' => 'Montant brut',
        'share_percent' => 'Part (%)',
        'taxes' => 'TVA',
        'net_amount' => 'Montant net',
        'quantity' => 'Quantité',
        'net_revenue' => 'Revenu net',
        'commissions_amount' => 'Commission',
        'in_stay_rooms' => 'Chambres en séjour',
        'presence_rooms' => 'Chambres présentes',
        'in_stay_guests' => 'Invités en séjour',
        'presence_guests' => 'Présence d\'invités',
        'absolute_guests' => 'Invités',
        'gross_amount_without_commissions' => 'Montant brut sans commissions',
        'net_amount_without_commissions' => 'Montant net sans commissions et TVA',
        'gt_revenue' => [
            'rooms' => [
                'date' => 'DATE',
                'hotel_capacity' => 'CAPACITÉ_HÔTEL',
                'rooms_sold' => 'CHAMBRES_VENDUES',
                'rooms_ooo' => 'CHAMBRES_OOO',
                'rooms_revenue' => 'REVENUS_CHAMBRES',
            ],
            'segments' => [
                'date' => 'DATE',
                'cam_business' => 'CAM_BUSINESS',
                'rev_business' => 'REV_BUSINESS',
                'cam_tour_operator' => 'CAM_TOUR_OPERATOR',
                'rev_tour_operator' => 'REV_TOUR_OPERATOR',
                'cam_ota' => 'CAM_OTA',
                'rev_ota' => 'REV_OTA',
                'cam_beddy' => 'CAM_BEDDY',
                'rev_beddy' => 'REV_BEDDY',
                'cam_diretta' => 'CAM_DIRETTA',
                'rev_diretta' => 'REV_DIRETTA',
            ],
        ],
    ],

    'stripe' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Erreur générale inconnue.',
                'next_steps' => 'Contacter le support technique.',
            ],
            'approve_with_id' => [
                'description' => 'Le paiement ne peut pas être autorisé.',
                'next_steps' => 'Le paiement doit être tenté à nouveau. Si cela échoue encore, le client doit contacter l\'émetteur de la carte.',
            ],
            'customer_max_payment_methods' => [
                'description' => 'Le client a déjà le nombre maximum de méthodes de paiement liées.',
                'next_steps' => 'Détacher quelques méthodes de paiement de ce client ou procéder avec un autre client.',
            ],
            'call_issuer' => [
                'description' => 'La carte a été refusée pour une raison inconnue.',
                'next_steps' => 'Le client doit contacter l\'émetteur de la carte pour plus d\'informations.',
            ],
            'card_not_supported' => [
                'description' => 'La carte ne prend pas en charge ce type d\'achat.',
                'next_steps' => 'Le client doit essayer avec un autre mode de paiement.',
            ],
            'card_velocity_exceeded' => [
                'description' => 'Le client a dépassé la limite de dépenses sur la carte.',
                'next_steps' => 'Le client doit attendre un certain temps avant de réessayer ou utiliser une autre carte.',
            ],
            'currency_not_supported' => [
                'description' => 'La carte ne prend pas en charge la devise spécifiée.',
                'next_steps' => 'Le client doit utiliser une autre carte qui supporte cette devise.',
            ],
            'do_not_honor' => [
                'description' => 'La carte a été refusée.',
                'next_steps' => 'Le client doit contacter l\'émetteur de la carte pour plus d\'informations.',
            ],
            'do_not_try_again' => [
                'description' => 'La carte a été refusée.',
                'next_steps' => 'Ne pas tenter à nouveau le paiement. Le client doit utiliser un autre mode de paiement.',
            ],
            'duplicate_transaction' => [
                'description' => 'Une transaction avec le même montant et les mêmes informations a été récemment envoyée.',
                'next_steps' => 'Le client doit attendre et essayer plus tard.',
            ],
            'expired_card' => [
                'description' => 'La carte a expiré.',
                'next_steps' => 'Le client doit utiliser une autre carte.',
            ],
            'fraudulent' => [
                'description' => 'La transaction a été refusée car suspectée d\'être frauduleuse.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'generic_decline' => [
                'description' => 'La carte a été refusée.',
                'next_steps' => 'Le client doit contacter l\'émetteur de la carte pour plus d\'informations.',
            ],
            'incorrect_number' => [
                'description' => 'Le numéro de carte saisi est incorrect.',
                'next_steps' => 'Le client doit vérifier le numéro de la carte ou utiliser une autre carte.',
            ],
            'incorrect_cvc' => [
                'description' => 'Le code de sécurité de la carte (CVC) est incorrect.',
                'next_steps' => 'Le client doit vérifier le CVC ou utiliser une autre carte.',
            ],
            'incorrect_pin' => [
                'description' => 'Le code PIN saisi est incorrect.',
                'next_steps' => 'Le client doit entrer le bon code PIN.',
            ],
            'incorrect_zip' => [
                'description' => 'Le code postal est incorrect.',
                'next_steps' => 'Le client doit vérifier son code postal.',
            ],
            'insufficient_funds' => [
                'description' => 'La carte n\'a pas suffisamment de fonds.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'invalid_account' => [
                'description' => 'La carte ou le compte n\'existent pas.',
                'next_steps' => 'Le client doit vérifier les informations de la carte ou utiliser un autre mode de paiement.',
            ],
            'invalid_amount' => [
                'description' => 'Le montant du paiement n\'est pas valide.',
                'next_steps' => 'Vérifiez le montant et réessayez.',
            ],
            'invalid_cvc' => [
                'description' => 'Le code de sécurité de la carte (CVC) n\'est pas valide.',
                'next_steps' => 'Le client doit vérifier le CVC ou utiliser une autre carte.',
            ],
            'invalid_expiry_year' => [
                'description' => 'L\'année d\'expiration de la carte n\'est pas valide.',
                'next_steps' => 'Le client doit vérifier la date d\'expiration ou utiliser une autre carte.',
            ],
            'invalid_number' => [
                'description' => 'Le numéro de carte n\'est pas valide.',
                'next_steps' => 'Le client doit vérifier le numéro de la carte ou utiliser une autre carte.',
            ],
            'issuer_not_available' => [
                'description' => 'L\'émetteur de la carte n\'est pas disponible.',
                'next_steps' => 'Le client doit réessayer plus tard.',
            ],
            'lost_card' => [
                'description' => 'La carte a été signalée comme perdue.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'merchant_blacklist' => [
                'description' => 'Le paiement a été refusé en raison des règles du commerçant.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'new_account_information_available' => [
                'description' => 'De nouvelles informations sur le compte de la carte sont disponibles.',
                'next_steps' => 'Le client doit vérifier les informations mises à jour avec sa banque.',
            ],
            'no_action_taken' => [
                'description' => 'L\'émetteur de la carte n\'a pris aucune action.',
                'next_steps' => 'Le client doit contacter l\'émetteur de la carte pour plus d\'informations.',
            ],
            'not_permitted' => [
                'description' => 'Le paiement n\'est pas autorisé.',
                'next_steps' => 'Le client doit contacter l\'émetteur de la carte pour plus d\'informations.',
            ],
            'offline_pin_required' => [
                'description' => 'Un PIN hors ligne est requis.',
                'next_steps' => 'Le client doit entrer le bon PIN.',
            ],
            'online_or_offline_pin_required' => [
                'description' => 'Un PIN en ligne ou hors ligne est requis.',
                'next_steps' => 'Le client doit entrer le bon PIN.',
            ],
            'pickup_card' => [
                'description' => 'La carte doit être retirée.',
                'next_steps' => 'Le client doit contacter l\'émetteur de la carte pour plus d\'informations.',
            ],
            'pin_try_exceeded' => [
                'description' => 'Le client a dépassé le nombre maximum de tentatives de PIN incorrects.',
                'next_steps' => 'Le client doit contacter l\'émetteur de la carte pour débloquer le PIN ou utiliser un autre mode de paiement.',
            ],
            'processing_error' => [
                'description' => 'Une erreur de traitement est survenue.',
                'next_steps' => 'Le client doit réessayer plus tard.',
            ],
            'reenter_transaction' => [
                'description' => 'Le paiement doit être saisi à nouveau.',
                'next_steps' => 'Le commerçant doit saisir à nouveau le paiement.',
            ],
            'restricted_card' => [
                'description' => 'La carte ne peut pas être utilisée pour ce paiement.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'revocation_of_all_authorizations' => [
                'description' => 'La carte a été refusée.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'revocation_of_authorization' => [
                'description' => 'La carte a été refusée.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'security_violation' => [
                'description' => 'La carte a été refusée en raison d\'une violation de sécurité.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'service_not_allowed' => [
                'description' => 'Le service n\'est pas autorisé.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'stolen_card' => [
                'description' => 'La carte a été signalée comme volée.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'stop_payment_order' => [
                'description' => 'Le paiement a été bloqué par le client.',
                'next_steps' => 'Le client doit utiliser un autre mode de paiement.',
            ],
            'testmode_charges_only' => [
                'description' => 'Votre compte n\'a pas été activé et ne peut effectuer que des prélèvements de test.',
                'next_steps' => 'Activez votre compte dans le tableau de bord pour commencer à traiter de véritables prélèvements.',
            ],
            'testmode_decline' => [
                'description' => 'Une carte de test Stripe a été utilisée.',
                'next_steps' => 'Utiliser une carte de paiement réelle.',
            ],
            'transaction_not_allowed' => [
                'description' => 'La transaction n\'est pas autorisée.',
                'next_steps' => 'Le client doit contacter l\'émetteur de la carte pour plus d\'informations.',
            ],
            'try_again_later' => [
                'description' => 'L\'émetteur de la carte n\'a pas approuvé la demande.',
                'next_steps' => 'Le client doit réessayer plus tard.',
            ],
        ],
    ],

    'tableau' => [
        'errors' => [
            'roomNotFound' => 'Chambre non trouvée ou inexistante',
            'tableauNumberNotFound' => 'Le numéro de chambre n\'est pas correct.',
            'closureConflict' => 'Vous ne pouvez pas superposer des périodes de fermeture',
            'lockedRoom' => 'La chambre est verrouillée ou en chambre d\'appoint et ne peut être modifiée',
            'lockedAccommodation' => 'Type de chambre verrouillé, modification non possible',
            'reservation_accommodation_not_fund' => 'La chambre réservée n\'a pas été trouvée',
            'accommodation_destination_not_found' => 'La chambre de destination n\'a pas été trouvée',
            'accommodation_destination_treatment_not_found' => 'Le traitement n\'est pas actif pour la chambre sélectionnée',
            'accommodation_destination_rateplan_not_found' => 'Le tarif sélectionné n\'est pas actif pour la chambre sélectionnée',
            'reservation_locked' => 'Cette réservation a un statut de verrouillage, aucune modification n\'est possible.',
            'exists_reservation_destination' => 'Une réservation existe déjà pour la chambre de destination, impossible de continuer !',
            'split_checkin_minor' => 'La date d\'arrivée spécifiée est inférieure à la date d\'arrivée de la réservation',
            'split_checkout_major' => 'La date de départ spécifiée est supérieure à la date de départ de la réservation',
            'split_incompatible_rates' => 'La chambre de destination est incompatible car elle n\'a pas les mêmes tarifs que la chambre source',
            'exists_tableau_closure' => 'Une fermeture est présente pour la chambre de destination, veuillez retirer la fermeture tableau avant de continuer',
            'exists_reservation_closure' => 'Des réservations existent pendant la période sélectionnée, il est impossible de fermer le logement',
            'reservation_not_found' => 'Réservation non trouvée',
            'reservation_accommodation_keep_activated' => 'Le logement ne peut pas être déplacé. Pour continuer, veuillez retirer le verrouillage depuis les détails de la réservation.',
            'reservation_moved_or_cancelled' => 'La réservation a été déplacée ou annulée.',
            'reservation_is_moving' => 'Attention, une opération de modification de la réservation est déjà en cours. Veuillez actualiser le Tableau et réessayer dans un instant',
            'closure_just_creating' => 'Une fermeture est encore en cours pour cette chambre, réessayez plus tard',
            'closure_just_removing' => 'Une suppression de fermeture est encore en cours pour cette chambre, réessayez plus tard',
        ],
        'warnings' => [
            'tableauNumberWillBeChanged' => 'Attention, la chambre sera déplacée vers le numéro :newTableauNumber',
        ],
    ],

    'technical_notices' => [
        'email' => [
            'failed_log_job_title' => 'Échec de l\'envoi de SendLogJob',
        ],
        'errors' => [
            'channel_unsupported' => 'Canal non supporté',
            'property_not_found' => 'Propriété non trouvée',
        ],
    ],
    'templates_snippets_categories' => [
        'reservation_data' => 'Données de réservation',
        'property_data' => 'Données de la propriété',
        'automatism' => 'Automatismes',
        'reservations_accommodation_datails' => 'Détails des hébergements réservés',
        'reservation_personal_data' => 'Données personnelles du réservataire',
        'payments_data' => 'Données des paiements',
        'cancellation_policy_data' => 'Données de la politique d\'annulation',
        'estimate_data' => 'Données du devis',
        'tax_document_data' => 'Données des documents fiscaux',
        'payments_timetable' => 'Paiements programmés',
    ],

    'users' => [
        'new' => [
            'title' => 'Nouvel utilisateur :username',
            'message' => 'Un nouvel utilisateur a été créé par :self_username',
        ],
        'update' => [
            'title' => 'Utilisateur :username modifié',
            'message' => 'Utilisateur :username modifié avec succès',
            'missing_email_verification_code' => 'La modification que vous tentez d\'effectuer nécessite une confirmation, nous avons envoyé une notification à votre adresse e-mail actuelle.',
        ],
        'delete' => [
            'title' => 'Utilisateur :username supprimé',
            'message' => 'Utilisateur :username supprimé avec succès',
            'error_delete_1' => 'Vous ne pouvez pas supprimer votre propre compte.',
        ],
        'errors' => [
            'emailnotfound' => 'E-mail invalide',
            'passwordIncorrect' => 'Le mot de passe actuel est invalide',
            'reminderNotValid' => 'Code invalide ou expiré',
            'propertyAttached' => 'L\'utilisateur et la propriété sont déjà associés',
            'propertyDetached' => 'L\'utilisateur et la propriété n\'ont pas de relation',
            'permissionNotFound' => 'L\'un des permissions n\'est pas présent pour cet utilisateur',
            'tokenNotGenerated' => 'Erreur lors de la génération du token',
            'username_exists' => 'Le nom d\'utilisateur est déjà pris',
            'email_exists' => 'L\'adresse e-mail est déjà utilisée',
            'user_not_allowed' => 'L\'utilisateur connecté n\'est pas autorisé à créer de nouveaux utilisateurs',
            'cannot_detach_all_auth_verification_methods' => 'Il n\'est pas possible de dissocier tous les méthodes de vérification, au moins une doit être active.',
            'no_active_properties' => 'Aucune propriété active n’est associée à votre compte. Veuillez contacter l’assistance Beddy pour obtenir de l’aide.'
        ],
    ],

    'vat_quote' => [
        'related_model' => [
            'accommodation' => 'Hébergement',
            'addon' => 'Service supplémentaire',
            'city_tax' => 'Taxe de séjour',
            'manual_charge' => 'Frais ajoutés manuellement',
            'expense_category' => 'Catégorie de dépenses',
            'reservation_payment' => 'Factures et reçus d\'acompte',
            'place_tax' => 'Taxe de timbre',
            'reservation_no_show' => 'No Show',
            'reservation_cancellation' => 'Annulation après la date limite',
        ],
        'log_module' => [
            'vat_quote_created' => 'Taux de TVA créé',
            'vat_quote_updated' => 'Taux de TVA mis à jour',
            'vat_quote_deleted' => 'Taux de TVA supprimé',
            'vat_quote_default_created' => 'Taux de TVA par défaut créé',
            'vat_quote_default_updated' => 'Taux de TVA par défaut mis à jour',
            'vat_quote_default_deleted' => 'Taux de TVA par défaut supprimé',
            'property_vat_quote_added' => 'Taux de TVA ajouté',
            'property_vat_quote_replaced' => 'Taux de TVA remplacé',
        ],
        'errors' => [
            'vat_quote_associated' => 'Le taux de TVA est défini comme par défaut pour certaines structures, impossible de continuer',
            'insufficient_default_number' => 'Impossible de procéder à la suppression du taux de TVA suivant, car il n’y aurait plus de taux de TVA par défaut pour les champs suivants : ',
            'invalid_place_id' => 'Le paramètre Pays n\'a pas de valeur valide.'
        ]
    ],

    'venice_exemption' => [
        'errors' => [
            'CDAError' => 'Les dates sélectionnées ne sont pas prévues par la municipalité de Venise.',
        ],
    ],

    'vrbo' => [
        'checkpoints' => [
            'IsActiveByOwner' => 'Vérifiez que la distribution sur Vrbo est active',
            'IsListingNotArchived' => 'La propriété est archivée sur Vrbo. Contactez l\'assistance de Vrbo',
            'IsActiveByCsr' => 'Le support de Vrbo a désactivé la propriété. Contactez l\'assistance de Vrbo',
            'HasImages' => 'Il manque des images (au moins 6)',
            'HasValidatedAddress' => 'Adresse invalide',
            'HasGeoCode' => 'Coordonnées GPS invalides ou manquantes',
            'HasPropertyAddress' => 'Adresse invalide',
            'HasBathroom' => 'Il manque les nombres de salles de bains',
            'HasMaxOccupancy' => 'Il manque les informations sur la capacité maximale',
            'HasPropertyDescription' => 'Description manquante',
            'HasPropertyHeadline' => 'Description manquante',
            'HasPropertyName' => 'Nom manquant',
            'HasPropertyType' => 'Type de propriété manquant',
            'HasRates' => 'Tarifs/disponibilité manquants',
            'HasRegistrationNumber' => 'Numéro d\'enregistrement manquant',
        ],
    ],

    'webcontroller' => [
        'downloader' => [
            'title_waiting' => 'Veuillez patienter...',
            'message_waiting' => 'L\'opération que vous avez demandée est en cours... Merci de votre patience',
            'title_started' => 'Téléchargement lancé',
            'message_started' => 'Le téléchargement a été lancé. Une fois terminé, vous pouvez fermer cette fenêtre',
            'title_error' => 'Erreur !',
            'message_error' => 'Une erreur est survenue lors du traitement de votre demande.<br> Veuillez nous contacter.',
        ],
        'metasearch' => [
            'title_error' => 'Erreur !',
            'message_error' => 'Une erreur est survenue lors du traitement de votre demande.',
        ],
    ],

    'welcome_automatic_email' => [
        'email' => [
            'preview_text' => 'Informations utiles pour être opérationnel',
            'subject' => 'Bienvenue sur Beddy - Commençons la configuration !',
            'greetings_text' => 'C\'est tout pour aujourd\'hui, nous vous remercions encore d\'avoir choisi nos services.<br><br>L\'équipe de Beddy',
            'training_pms_text_button' => 'FORMATION VIDEO PMS',
            'training_pms_channel_button' => 'FORMATION VIDEO CHANNEL MANAGER',
            'model_welcome' => [
                'subject' => 'Bienvenue sur Beddy - Premiers pas et informations importantes',
                'preview_text' => 'Tout ce qu\'il y a à savoir',
                'body_1' => 'Bienvenue sur Beddy,  
                <br><br>
                Nous vous remercions d\'avoir choisi notre service et vous invitons à <b>suivre attentivement les instructions que vous recevrez dans les prochaines communications</b>. Nous vous conseillons donc d\'ajouter les adresses support@beddy.io et info@beddy.io dans le carnet d\'adresses de votre fournisseur de messagerie pour éviter que nos emails ne finissent dans le dossier spam. 
                <br><br>
                Voici des guides pour les fournisseurs les plus utilisés : 
                <br><br>
                <a href="https://support.google.com/contacts/answer/1069522">Ajouter un contact sur Gmail</a>
                <br><br>
                <a href="https://support.microsoft.com/it-it/office/aggiungere-un-contatto-e1dc4548-3bd6-4644-aecd-47b5728f7b0d#ID0EAABAAA=Newer_versions">Ajouter un contact sur Outlook</a>',
                'greetings_text' => 'Nous vous remercions encore d\'avoir choisi nos services.<br><br>L\'équipe de Beddy',
            ],
            'model_A' => [
                'body_1' => 'Bonjour :userMasterName,  
                <br><br>
                Voici les prochaines étapes à suivre pour configurer votre compte Beddy. 
                <br><br>          
                &nbsp;&nbsp;<b>01. Premiers pas - Configuration générale</b>
                <br><br>
                Nous vous contacterons bientôt pour configurer votre compte Beddy.  
                <br><br>
                La configuration initiale est très importante et prépare les étapes suivantes. 
                <br><br>
                Nous vous suggérons de <b>remplir le formulaire Excel</b> joint avant le rendez-vous avec notre opérateur, afin de réduire le temps de configuration. 
                <br><br>
                Le fichier contient plusieurs onglets et tous doivent être remplis.<br>  
                Une fois terminé, vous devrez envoyer le fichier à <a href="mailto:support@beddy.io">support@beddy.io</a>. 
                <br><br>
                Tous les champs du formulaire joint sont obligatoires, un manque d\'informations pourrait retarder la configuration de votre compte Beddy. 
                <br><br>
                Si vous gérez un compte multi-structures, il est nécessaire de copier le fichier Excel et d’en remplir un pour chaque structure.  
                <br><br>
                À la fin de la configuration, vos identifiants d\'accès vous seront fournis.',
                'body_2' => '&nbsp;&nbsp;<b>02. Formation - Formation PMS</b>             
                <br><br>
                Une fois la configuration terminée, nous vous contacterons pour fixer le rendez-vous pour le <b>training</b> sur les fonctionnalités du PMS. Les sessions de formation sont disponibles le mardi à 15h00 et le jeudi à 10h00.
                <br><br>
                La formation durera <b>90 minutes</b> et les collaborateurs et employés peuvent également y participer.
                <br><br>
                En attendant la formation, nous vous suggérons de vous familiariser avec les fonctionnalités du logiciel en consultant la formation en ligne.',
                'body_3' => '&nbsp;&nbsp;<b>03. Connexion des portails - Configuration du Channel Manager</b>            
                <br><br>
                Une fois la formation PMS terminée, un nouveau rendez-vous sera programmé pour connecter les portails. Nous vous rappelons qu’une fois le Channel Manager activé, il ne sera plus possible d’utiliser les extranets des portails ou l’ancien Channel Manager.',
                'body_4' => '&nbsp;&nbsp;<b>04. Formation - Formation du Channel Manager</b>
                <br><br>
                À la fin de la procédure de connexion, vous serez invité à participer à la formation sur le Channel Manager. 
                <br><br>
                La formation durera <b>30 minutes</b> et les collaborateurs et employés peuvent également y participer.
                <br><br>
                En attendant la formation, nous vous suggérons de vous familiariser avec les fonctionnalités du logiciel en consultant la formation en ligne.',
            ],
            'model_B' => [
                'body_1' => 'Bonjour :userMasterName,  
                <br><br>
                Voici les prochaines étapes à suivre pour configurer votre compte Beddy. 
                <br><br>          
                &nbsp;&nbsp;<b>01. Premiers pas - Configuration générale</b>
                <br><br>
                Nous vous contacterons bientôt pour configurer votre compte Beddy.  
                <br><br>
                La configuration initiale est très importante et prépare les étapes suivantes. 
                <br><br>
                Nous vous suggérons de <b>remplir le formulaire Excel</b> joint avant le rendez-vous avec notre opérateur, afin de réduire le temps de configuration. 
                <br><br>
                Le fichier contient plusieurs onglets et tous doivent être remplis.<br>  
                Une fois terminé, vous devrez envoyer le fichier à <a href="mailto:support@beddy.io">support@beddy.io</a>. 
                <br><br>
                Tous les champs du formulaire joint sont obligatoires, un manque d\'informations pourrait retarder la configuration de votre compte Beddy. 
                <br><br>
                Si vous gérez un compte multi-structures, il est nécessaire de copier le fichier Excel et d’en remplir un pour chaque structure.  
                <br><br>
                À la fin de la configuration, vos identifiants d\'accès vous seront fournis.',
                'body_2' => '&nbsp;&nbsp;<b>02. Formation - Formation PMS</b>             
                <br><br>
                Une fois la configuration terminée, nous vous contacterons pour fixer le rendez-vous pour le <b>training</b> sur les fonctionnalités du PMS. Les sessions de formation sont disponibles le mardi à 15h00 et le jeudi à 10h00.
                <br><br>
                La formation durera <b>90 minutes</b> et les collaborateurs et employés peuvent également y participer.
                <br><br>
                En attendant la formation, nous vous suggérons de vous familiariser avec les fonctionnalités du logiciel en consultant la formation en ligne.',
                'body_3' => '&nbsp;&nbsp;<b>03. Formation - Gestion des tarifs et disponibilités</b>            
                <br><br>
                Une fois la formation PMS terminée, nous vous contacterons pour fixer le rendez-vous pour le <b>training</b> sur les fonctionnalités du Channel Manager. Les sessions sont disponibles le lundi à 15h00 et le mercredi et vendredi à 11h30.
                <br><br>
                La formation durera <b>60 minutes</b> et les collaborateurs et employés peuvent également y participer.
                <br><br>
                En attendant la formation, nous vous suggérons de vous familiariser avec les fonctionnalités du logiciel en consultant la formation en ligne.',
            ],
            'model_C' => [
                'body_1' => 'Bonjour :userMasterName,  
                <br><br>
                Voici les prochaines étapes à suivre pour configurer votre compte Beddy. 
                <br><br>          
                &nbsp;&nbsp;<b>01. Premiers pas - Configuration générale</b>
                <br><br>
                Nous vous contacterons bientôt pour configurer votre compte Beddy.  
                <br><br>
                La configuration initiale est très importante et prépare les étapes suivantes. 
                <br><br>
                Nous vous suggérons de <b>remplir le formulaire Excel</b> joint avant le rendez-vous avec notre opérateur, afin de réduire le temps de configuration. 
                <br><br>
                Le fichier contient plusieurs onglets et tous doivent être remplis.<br>  
                Une fois terminé, vous devrez envoyer le fichier à <a href="mailto:support@beddy.io">support@beddy.io</a>. 
                <br><br>
                Tous les champs du formulaire joint sont obligatoires, un manque d\'informations pourrait retarder la configuration de votre compte Beddy. 
                <br><br>
                Si vous gérez un compte multi-structures, il est nécessaire de copier le fichier Excel et d’en remplir un pour chaque structure.  
                <br><br>
                À la fin de la configuration, vos identifiants d\'accès vous seront fournis.',
                'body_2' => '&nbsp;&nbsp;<b>02. Formation - Formation Channel Manager</b>            
                <br><br>
                Une fois la configuration terminée, nous vous contacterons pour fixer le rendez-vous pour le <b>training</b> sur les fonctionnalités du Channel Manager. Les sessions sont disponibles le lundi à 15h00 et le mercredi et vendredi à 11h30.
                <br><br>
                La formation durera <b>60 minutes</b> et les collaborateurs et employés peuvent également y participer.
                <br><br>
                En attendant la formation, nous vous suggérons de vous familiariser avec les fonctionnalités du logiciel en consultant la formation en ligne.',
                'body_3' => '&nbsp;&nbsp;<b>03. Connexion des portails - Configuration du Channel Manager</b>
                <br><br>
                Après la formation, un nouveau rendez-vous sera programmé pour connecter les portails. 
                <br><br>
                Nous vous rappelons qu’une fois le Channel Manager activé, il ne sera plus possible d’utiliser les extranets des portails ou l’ancien Channel Manager.',
            ],
            'model_D' => [
                'body_1' => 'Bonjour :userMasterName,  
                <br><br>
                Voici les prochaines étapes à suivre pour configurer votre compte Beddy. Veuillez <b>lire attentivement ce message</b> et nous fournir les informations nécessaires pour accélérer la configuration.  
                <br><br>          
                &nbsp;&nbsp;<b>01. Premiers pas - Configuration générale</b>
                <br><br>
                Nous vous contacterons bientôt pour configurer votre compte Beddy.  
                <br><br>
                Avant le rendez-vous avec notre opérateur, nous vous demandons de :
                <br><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>remplir le formulaire Excel</b> joint<br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>demander la cartographie des logements et des plans tarifaires</b> à votre fournisseur de services externe à connecter à Beddy<br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>envoyer le formulaire et la cartographie</b> à <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
                Ces informations sont <b>très importantes</b> pour réduire le temps de configuration.
                <br><br>
                Tous les champs du formulaire sont obligatoires, un manque d’information pourrait retarder la configuration.
                <br><br>
                Si vous gérez un compte multi-structures, il est nécessaire de remplir le formulaire et demander la cartographie pour chaque structure.
                <br><br>
                À la fin de la configuration, vos identifiants d\'accès vous seront fournis.',
                'body_2' => '&nbsp;&nbsp;<b>02. Formation - Formation PMS</b>             
                <br><br>
                Une fois la configuration terminée, nous vous contacterons pour fixer le rendez-vous pour le training sur les fonctionnalités du PMS. Les sessions sont disponibles le mardi à 15h00 et le jeudi à 10h00.  
                <br><br>
                La formation durera <b>90 minutes</b> et les collaborateurs et employés peuvent également y participer. 
                <br><br>
                En attendant la formation, nous vous suggérons de vous familiariser avec les fonctionnalités du logiciel en consultant la formation en ligne.',
                'body_3' => '&nbsp;&nbsp;<b>03. Formation - Formation Channel Manager intégré à Beddy</b>            
                <br><br>
                À la fin de la procédure de connexion, un training sur l’utilisation du PMS pour mettre à jour tarifs, disponibilités et restrictions via le Channel Manager sera proposé.
                <br><br>
                Les sessions sont disponibles le lundi à 15h00 et le mercredi et vendredi à 11h30.
                <br><br>
                La formation durera 60 minutes et les collaborateurs et employés peuvent également y participer.
                <br><br>
                Si le Channel Manager est intégré en mode “téléchargement des réservations uniquement”, la formation est optionnelle, mais nous recommandons de la suivre pour gérer les tarifs sur le PMS ou générer des devis depuis Beddy.',
                'body_4' => '&nbsp;&nbsp;<b>04. Connexion du Channel Manager intégré à Beddy</b>
                <br><br>
                Après la formation PMS, un nouveau rendez-vous sera programmé pour connecter le Channel Manager externe à Beddy.',
            ],
        ],
        'errors' => [
            'fail_to_send' => 'Impossible d\'envoyer l\'email demandé à l\'adresse :email_address',
        ],
    ],

    'zdatalake' => [
        'Couple' => 'Couples',
        'Family' => 'Familles',
        'Single' => 'Célibataire',
        'Group' => 'Groupe',
    ],
    'booking_booster_configuration' => [
        'errors' => [
            'configuration_not_found' => 'Configuration non trouvée',
        ],
    ],
    'booking_booster' => [
        'errors' => [
            'auth_token' => 'Impossible de récupérer le jeton d\'authentification Booking Booster pour cette erreur : :error',
            'available_budget' => 'Impossible de récupérer le budget disponible pour cette erreur : :error',
            'campaigns_statistics' => 'Impossible de récupérer les statistiques des campagnes pour cette erreur : :error',
            'ads_statistics' => 'Impossible de récupérer les statistiques des annonces en raison de cette erreur : :error',
            'ads_details' => 'Impossible de récupérer les détails des annonces en raison de cette erreur : :error',
            'property_targets' => 'Impossible de récupérer les cibles des propriétés pour cette erreur : :error',
            'client_error' => 'Identifiants incorrects ou non autorisé à accéder aux ressources demandées. Détails : :error',
            'server_error' => 'Nous rencontrons des difficultés techniques. Veuillez réessayer plus tard. Détails : :error',
            'connection_error' => 'Impossible de se connecter à Booking Booster. Veuillez réessayer plus tard. Détails : :error'
        ],
        'warnings' => [
            'property_not_mapped' => 'Les propriétés suivantes ne sont pas mappées et peuvent ne pas apparaître correctement dans les statistiques des campagnes : :propertyNames'
        ]
    ],
    'zpay' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Erreur générale inconnue.',
                'next_steps' => 'Contacter le support technique.',
            ],
            'validation_failed' => [
                'description' => 'Autorisation de la carte échouée',
                'next_steps' => 'Le client doit utiliser une nouvelle carte.',
            ],
            'canceled' => [
                'description' => 'La demande a été annulée',
                'next_steps' => 'Le client doit effectuer une nouvelle demande.',
            ],
            'failed' => [
                'description' => 'La demande a échoué',
                'next_steps' => 'Le client doit effectuer une nouvelle demande.',
            ],
            'waiting_for_payment' => [
                'description' => 'Demande en attente de paiement',
                'next_steps' => 'Le client doit confirmer le paiement.',
            ],
            'requires_capture' => [
                'description' => 'Demande en attente de confirmation',
                'next_steps' => 'Le client doit autoriser l\'opération.',
            ],
            'refunded' => [
                'description' => 'Paiement remboursé',
                'next_steps' => 'Le paiement a été remboursé avec succès.',
            ],
            'partially_refunded' => [
                'description' => 'Paiement partiellement remboursé',
                'next_steps' => 'Le paiement a été partiellement remboursé.',
            ],
            'processing' => [
                'description' => 'Le paiement est en cours de traitement',
                'next_steps' => 'Veuillez attendre le résultat de l\'opération.',
            ],
        ],
    ]
];
