<?php
$reservationSuffix = ' among guests to send in the reservation :reservation_booker - :reservation_reference_number';
$roomSuffix = ' in the accommodation:tableau_number-:accommodation_name';
$suffix = ' fort the guest:customer_name, accommodation:tableau_number-:accommodation_name';
$roomReservationSuffix = ' for the accommodation :accommodation_name - reservation :reservation_booker - :reservation_reference_number';
$customerReservationSuffix = ' :customer_name - :reservation_reference_number';
$customerEmptyDataSuffix = 'for the guest :customer_name of the reservation :reservation_reference_number';
return [
    'accommodations' => [
        'errors' => [
            'attachExist' => 'Existing rate plan',
            'detachNotExist' => 'the rate plan is not associated to this accommodation',
            'detachStandardRateplan' => 'You can\'t delete the Standard rate plan',
            'guestsCnfigurationBase' => 'Cannot apply discounts to the base rate',
            'virtualRidondanceConflict' => 'You can\'t connect this accommodation. A link is already configured',
            'parentTreeExist' => 'The main accommodation is already associated or you cannot exceed the ',
            'quantityZero' => 'Cannot delete the last available room',
            'quantityNotValid' => 'You\'re sending a lower or equal quantity to the existing one',
            'quantitySum' => 'The quantity of a ',
            'quantitySuperior' => 'You cannot exceed the number of people set in the mother room',
            'quantityWithReservation' => 'There are existing reservations, you cannot delete this room number',
            'numberNotAvail' => 'the room numbers are not available',
            'guestsConfigurationBase' => 'You can\'t apply a discount to the base configuration',
            'tooManyAdults' => 'Adults number exceeds the limit',
            'tooManyChildren' => 'Children number exceeds the limit',
            'stillConnected' => 'the accommodation is still connected to one or more portals',
            'stillVirtual' => 'the accommodation is still connected to another one',
            'stillReserved' => 'There are reservations for this accommodation',
            'notVirtualToSum' => 'the links for this accommodation are not sufficient',
            'notVirtualQty' => 'The accommodation quantity must be 1',
            'notVirtualChildQty' => 'The connected accommodation quantity must be 1',
            'notVirtualSum' => 'This is not a sum room',
            'isVirtual' => 'Virtual accommodation, this operation is not allowed',
            'isNotVirtual' => 'Not a virtual accommodation, this operation is not allowed',
            'ruleToBundle' => 'Cannot override the package rules in use.',
            'noRateplanExist' => 'No rate plan for the property',
            'ruleIsLocked' => 'You can\'t modify a rule on All Linked rooms',
            'duplicateLabel' => 'Unable to use this name since it is already in use: accommodationName',
        ],
        'warnings' => [
            'request_confirm_delete_tableau_number' => 'There are linked rooms, would you like to continue?',
            'accommodation_tableau_not_found' => 'ID Tableau :tableau_number_id not associated or not found in the room with ID :accommodation_id',
            'accommodation_beds_types_combination_not_found' => 'Combination with ID :acc_bed_type_combination_id not found in the room with ID: :accommodation_id',
            'confimation_delete_father_and_childs_combinations' => "You are about to delete a parent setup combination (ID: :combination_id). By proceeding, all of its child combinations will also be automatically deleted. Do you confirm you want to continue?",
            'invalid_facility' => 'Not compatible facility',
        ],
        'channel' => [
            'single_use_exists' => 'The accommodation :accommodation_name - :acommodation_ratename is aready associated or created',
            'single_use_dont_exists' => 'The channel room with ID :accommodation_channel_id wasn\'t found',
            'email' => [
                'new_title' => 'New rooms added for the channel :channel_name - Property: :property_name - ID Property: :property_id',
                'deleted_title' => 'Rooms deleted for the channel :channel_name - Property: :property_name - ID Property: :property_id',
                'attached_title' => 'Not associated rooms for the facility: :property_name - ID Property: :property_id were found',
                'conflict_rule' => 'Rules conflict for the channel :channel_name - Property: :property_name - ID Property: :property_id',
            ],
        ],
        'fields' => [
            'model_name' => 'accommodation',
            'checkin' => 'check in',
            'checkout' => 'check-out',
            'checkin_hour' => 'check-in time',
            'checkout_hour' => 'check-out time',
            'checkin_arrival_preference' => 'check-in preference',
        ],
    ],
    'account_renewal' => [
        'email' => [
            'subject' => 'Automatic renewal of Beddy structures - :monthAndYear',
        ],
    ],
    'addon' => [
        'price_type' => [
            'xunit' => 'Per unit',
            // 1
            'xpax' => 'Per person per night',
            // 2
            'xweekxpax' => 'Per person per week',
            // 3
            'xbookxpax' => 'Per person one-off',
            // 4
            'xnight' => 'Per night',
            // 5
            'xweek' => 'Weekly',
            // 6
            // 7
            'xbook' => 'One-off',
        ],
        'warnings' => [
            'not_available' => 'Not available for the set period',
            'min_stay_violated' => 'The minimum stay required is :min_stay',
            'max_stay_violated' => 'The maximum stay permitted is :max_stay',
            'release_violated' => 'The maximum release permitted is :release',
            'rateplan_excluded' => 'Rateplan :rateplan not included for this extra service on the day :date',
            'treatment_excluded' => 'Treatment :treatment not included for this extra service on the day :date',
            'weekdays_excluded' => 'One or more weekly days not included',
        ],
        'errors' => [
            'not_in_stay' => 'The selected dates are beyond the reservation date range of this accommodation',
            'not_found' => 'Extra service not associated to the requested accommodation',
            'billed_addon' => 'This extra service cannot be deleted as it is linked to charges of other open bills',
        ],
        'logger' => [
            'added' => ':label for :accommodation_name with a rate of :price (:date) #:id',
        ],
    ],
    'admin' => [
        'errors' => [
            'channel_beddy_only' => 'The property must only have the Beddy channel active',
            'channelmanager_module_needed' => 'the Channel Manager module has not been activated',
            'no_rateplans' => 'No rate plans configured for this property',
            'no_accommodations' => 'No accommodations configured for this property',
            'not_demo' => 'The property must be a DEMO type',
        ],
    ],
    'api_partners' => [
        'contacts_types' => [
            'manager_email' => 'manager email',
            'technical_manager_email' => 'technical manager email',
            'customer_service_email' => 'customer service email',
            'commercial_requests_email' => 'email for commercial requests',
        ],
        'errors' => [
            'cannot_delete_has_users' => 'Unable to delete the partner, as it has associated users',
            'action_not_allowed' => 'You are not authorized to access the :service service.',
            'max_days' => 'The maximum interval is :days days.',
            'date_filters' => 'You can only use one type of date filter per request, not more than one at a time.',
            'cannot_delete_guest_city_tax' => 'Cannot delete guest :guestId for reservation :reservationId because the city tax has already been invoiced.',
            'too_many_reservation_ids' => 'You cannot pass more than :max reservationIds per request. You have currently passed :count.',
            'reservations_not_found' => 'The following reservations were not found or you do not have access: :ids',
            'customer_id_or_customer_required' => 'You must provide at least one of customerId or customer.',
            'customer_id_and_customer_conflict' => 'You cannot provide both customerId and customer at the same time: choose one.'
        ],
        'services' => [
            'ping' => 'Ping',
            'get_infos' => 'Retrieve information',
            'hotel_rateplan' => 'Rate plan',
            'push_availabilities' => 'Submit availabilities',
            'push_rates' => 'Submit rates',
            'reservations_lookup' => 'Reservation lookup',
            'reservations_acknowledge' => 'Reservation acknowledgment',
            'hotel_res_modify_notif' => 'Reservation modification notification',
            'reservation_send_message' => 'Send messages',
            'reservation_message_status' => 'Check message status',
            'modify_reservation' => 'Modify reservations',
            'media' => 'Attachments',
            'modify_media' => 'Modify attachments',
            'delete_media' => 'Delete attachments',
            'invoices' => 'Invoices',
            'credit_card' => 'Credit card',
            'all_guests' => 'All guests',
            'get_invoices' => 'Retrieve invoices',
            'generic_bol' => 'General booking engine information',
            'hotel_quote_request' => 'Quote request',
            'revenue_data' => 'Retrieve data on occupancy and revenue'
        ],
    ],
    'api_partner_detail' => [
        'fields' => [
            'country_id' => 'country identifier',
            'city_id' => 'city identifier',
            'state_id' => 'state identifier',
            'county_id' => 'county identifier',
        ]
    ],
    'auth_verification_methods' => [
        'your_pin' => 'Your Beddy access pin',
        'error_pin_invalid' => 'Error. Please check if the entered PIN is correct',
        'email_authentication' => [
            'get_connection_info_message' => 'We have just sent you an email with the PIN code to complete the authentication',
            'pin_invalid' => 'The entered PIN code is not valid',
        ],
        'google_authentication' => [
            'get_connection_info_message' => 'Check your Google Authenticator for the PIN to complete the authentication',
            'pin_invalid' => 'The entered PIN code is not valid',
        ],
    ],
    'availability' => [
        'errors' => [
            'not_found' => 'Availability not found for this accommodation',
        ],
    ],
    'bills' => [
        'ordination_of_date' => 'Order of :date',
        'vat_title' => 'VAT',
        'accommodation' => 'Accommodation',
        'total' => 'Total',
        'service' => 'Service',
        'quantity_abbreviated' => 'Qty',
        'amount' => 'Amount',
        'sign' => 'Signature',
        'account_balance_by_date' => 'Account statement by date',
        'account_balance_by_buyer' => 'Account statement by payer',
        'account_balance_by_guest' => 'Account statement by guest',
        'account_balance_by_accommodation' => 'Account statement by accommodation',
        'account_balance' => 'Account statement',
        'payer' => 'Payer',
        'quantity' => 'QTY',
        'date' => 'Date',
        'notes' => 'Notes',
        'scloby' => [
            'ordination_name' => 'Tilby Sale',
            'ordination_from_sale' => 'Order created from Tilby sale',
            'confirmation_mode' => 'Confirmation mode',
            'confirmation_by_phone' => 'phone number',
            'confirmation_by_signature' => 'signature',
        ],
        'log' => [
            'refunds' => 'The charge :bill_label (:bill_common_id) was refunded for :refunded',
        ],
    ],
    'booking_onboard' => [
        'no_contract_found' => 'No contract found for this property',
    ],
    'bookingengine' => [
        'addons_type' => [
            'xweek' => 'Per week',
            'xnight' => 'Per night',
            'xpax' => 'Per person per night',
            'xunit' => 'Per unit',
            'xbook' => 'Per booking',
            'xbookxpax' => 'One-off fee per person',
            'xweekxpax' => 'Per person per week',
        ],
        'errors' => [
            'min_expense_coupon' => 'Coupon not applicable for the value of this booking',
            'min_stay_coupon' => 'Coupon not applicable for the number of nights in this booking',
            'max_stay_coupon' => 'Coupon not applicable for the maximum number of nights in this booking',
            'invalid_days_coupon' => 'Coupon not applicable for the days of the week in this booking',
            'invalid_stay_coupon' => 'Coupon not applicable for the chosen period of stay',
            'invalid_conditions_coupon' => 'Coupon not applicable for the exclusion conditions of this booking',
            'invalid_periods_coupon' => 'Coupon not applicable for the dates in this booking',
            'invalid_coupon' => 'Coupon invalid or non existent',
            'already_coupon' => 'You cannot use other coupons',
            'availability_ended' => 'Selected rooms no longer available',
            'cart_empty_accommodation' => 'There are not rooms in your cart',
            'date_past_quote_expire' => 'Impossible to add the room to your quotation because the departure date is earlier than the expiry date on your quotation',
            'process_cart_date_past' => 'Impossible to proceed because one of the rooms has the departure date prior to today\'s date',
            'change_expire_date_quote_past' => 'The expiry date of the quotation is earlier than the departure date for one or more rooms',
            'quote_expired' => 'Quotation expired',
            'quote_accepted' => 'The quotation has already been accepted',
            'quote_not_active' => 'The quotation is no longer active',
            'quote_just_confirmed' => 'The quotation has already been confirmed. No changes can be made',
            'payment_not_valid' => 'Invalid payment method',
            'module_quote_not_active' => 'The Stay Quote Module is inactive for this property',
            'quote_option_no_availability' => 'This option is no longer available',
            'addon_excluded_from_coupon' => 'Unable to add the addon ":addon_name" because it is not included in the Coupon used',
            // Sezione sblocco offerte
            'unlock_wrong_accommodation' => 'Incorrect accommodation.',
            'unlock_wrong_accommodation_to_property' => 'Accommodation not belonging to the property.',
            'unlock_rateplan_not_unlockable' => 'The offer cannot be unlocked.',
            // estimate addon
            'estimate_addon_failure' => 'Incorrect search data',
            // errori generali in step intermedi
            'step_not_complete' => 'Some steps are incomplete',
            'property_different' => 'You have selected rooms from different properties',
            'data_sent_not_correct' => 'Data sent aren\'t correct',
            'no_dns_found' => 'No DNS associated with :subdomain',
            'no_payment_method_available' => 'No payment method set up',
            'session_expired' => 'Expired session',
            'booking_in_progress' => 'Your booking is being processed',
            'quote_option_no_availability_accommodation' => 'Some accommodations are not available, check your tableau upon quote confirmation.',
            'quote_option_no_availability_linked' => 'Accommodation not available and connected to other accommodation, check the tableau upon confirmation of the quote.',
            // alternative search
            'search_not_found' => 'Search not found',
            'failed_to_create_reservation' => 'An error occurred while creating the reservation',
            'create_order_already_exist' => 'Order already in processing (cache exists) - SID :sid',
            'create_quote_order_already_exist' => 'Quote Order already in processing (cache exists) - Reference :reference',
        ],
        'persuasive_sentences' => [
            'prepayment' => 'Advance payment',
            'hotel_payment' => 'Payment on site. You don\'t pay now',
            'free_cancellation_until' => 'Free cancellation up to :date_limit',
            'cancellation_term' => 'Booking terms and conditions',
            'cheapest_rate' => 'This is the best rate',
        ],
        'payment_method_description' => [
            'transfer' => 'no deposit text',
            'transfer_deposit' => 'An advance payment of :deposit must be made as a deposit, this amount will be refunded in accordance to the cancellation policy for this rate. You will receive the bank details by email to make the transfer. ',
            'cc_a_garanzia' => 'No extra cost! The credit card is used to guarantee the booking. No advance deposit is required. You will pay directly to:property_name the total cost of your booking during your stay.',
            'cc_pos' => 'No extra cost! The credit card is used to guarantee the booking. No advance deposit is required. You will pay directly to :property_name the total cost of your booking during your stay.',
            'cc_pos_deposit' => 'An advance payment of :deposit is required as a deposit, this amount will be refunded in accordance to the cancellation policy for this rate.',
            'cc_stripe_deposit' => 'Payment will be made via Stripe payment gateway. There is a prepayment of :deposit, this amount will be refunded in accordance to the cancellation policy associated to this rate plan.',
            'availability_request' => 'During the high season, do not consider this request as a confirmed reservation, however, you can request the availability by filling out the following form. The booking request will be processed as soon as possible.',
            'cc_paypal_deposit' => 'The payment will be made via Paypal payment gateway. An advance payment of: deposit is required, this amount will be refunded in accordance to the cancellation policy associated to this rate plan.',
            'cc_paypal_deposit_with_commission' => 'Payment will be made via Paypal payment gateway. There is an advance payment of :deposit + :commission for commissions, this amount will be refundable in accordance to the cancellation policy of this rate.',
            'nexi_deposit' => 'Payment will be made via Nexi XPay payment gateway. A pre-payment of :deposit is due, this amount will be refunded if applicable by the cancellation policy of this ratep plan.',
            'zpay_deposit' => 'The payment will be made through the ZPay payment gateway. An advance payment of :deposit is required, which will be refundable if provided for by the cancellation policy of this rate. <a href="https://www.zpay.it/privacy" target="_blank">ZPay Privacy Policy</a>.',
        ],
        'automatic_payment_method_description' => [
            'transfer' => 'no deposit text',
            'transfer_deposit' => 'You will receive the details to make the transfer via email.',
            'cc_a_garanzia' => 'No advance payment required now. You will pay according to the deadlines indicated in the Payment Conditions.',
            'cc_pos' => 'No additional costs! The credit card is only used to guarantee the reservation. You do not need to advance any deposit. You will pay the total cost of the reservation directly to :property_name during your stay.',
            'cc_pos_deposit' => 'An advance payment of :deposit is required, this amount will be refundable if provided by the cancellation policies of this rate.',
            'cc_stripe_deposit' => 'The payment will be made through the Stripe payment gateway.',
            'nexi_deposit' => 'The payment will be made through the Nexi payment gateway. <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Nexi privacy policy</a>.',
            'zpay_deposit' => 'The payment will be made through the ZPay payment gateway. An advance payment of :deposit is required, which will be refundable if provided for by the cancellation policy of this rate. <a href="https://www.zpay.it/privacy" target="_blank">ZPay Privacy Policy</a>.',
            'cc_paypal_deposit' => 'The payment will be made through the Paypal payment gateway.',
            'availability_request' => 'This request does not constitute an actual reservation, however, you can request availability information by filling out the following form. The reservation request will be confirmed as soon as possible.',
            'cc_paypal_deposit_with_commission' => 'The payment will be made through the Paypal payment gateway.',
        ],
        'validators' => [
            'errors' => [
                'name' => 'Guest name not valid.',
                'surname' => 'Guest surname not valid.',
                'email' => 'Incorrect guest email.',
                'credit_card_type_id' => 'Credit card not supported.',
                'credit_card_holder' => 'Invalid card holder.',
                'credit_card_number' => 'Invalid card number.',
                'credit_card_expire_date' => 'Invalid card expiration date.',
            ],
        ],
    ],
    'cash_desk_closure' => [
        'title' => 'Cash desk closure',
        'invoice' => 'Invoice',
        'invoices' => 'Invoices',
        'receipt' => 'Receipt',
        'receipt_follows_invoice' => 'Receipt follows invoice',
        'receipts' => 'Receipts',
        'type' => 'Type',
        'status' => 'Paid',
        'deposit' => 'Deposit',
        'recipient_business_name' => 'Recipient',
        'taxable' => 'Taxable',
        'vat_quote' => 'VAT',
        'total' => 'Total',
        'payments' => 'Payments',
        'totals' => 'TOTAL OVERVIEW',
        'cash_type' => 'Cash type',
        'reversal_receipt' => 'Receipt reversal',
        'reversal_receipts' => 'Reversal receipts',
        'to_give' => 'To give',
        'to_have' => 'To have',
        'balance' => 'Balance',
        'documents' => 'Documents',
        'deposits' => 'Deposits',
        'cash_desk_closure' => 'Pending',
        'credit_note' => 'Credit note',
        'invoice_received' => 'Received invoice',
        'credit_notes' => 'Credit notes',
        'suspended' => 'Suspended',
        'follows_invoice' => 'Follows invoice',
        'receipts_follows_invoice' => 'Receipt follows invoice',
        'suspend' => 'Suspended',
        'empty_documents' => 'No documents available to display',
        'sheets_name' => [
            'cash_desk' => 'Cash desk',
            'cahs_desk_summary' => 'Cash desk summary',
        ],
        'export_fields' => [
            'date' => 'Entry date',
            'status' => 'Paid',
            'document_type' => 'Document type',
            'document_number' => 'Document number',
            'customer' => 'Recipient',
            'taxable' => 'Taxable',
            'total_tax' => 'VAT',
            'total_to_pay' => 'Total',
            'payment_type' => 'Cash type',
            'to_have' => 'To have',
            'to_give' => 'To give',
            'balance' => 'Balance',
            'deposit_document_number' => 'Deposit document number',
            'deposit_payment_type' => 'Deposit payment type',
        ],
    ],
    'cash' => [
        'cash_title' => 'Cash situation',
        'cash_totals_title' => 'Totals',
        'total' => 'Total',
        'cash_desk' => 'Cash desk',
        'export_fields' => [
            'registration_date' => 'Entry date',
            'accountholder' => 'Bill Holder',
            'document' => 'Document',
            'date' => 'Date',
            'in-out' => 'In Out',
            'cash_in' => 'Takings (income)',
            'cash_out' => 'Outflows (payments)',
            'payment_method' => 'Payment method',
            'note' => 'Notes',
            'type_payment' => 'Payment type',
            'stay' => 'Stay',
            'extra' => 'Extra services',
            'city_tax' => 'City Tax',
            'pos' => 'POS',
            'property' => 'Property',
            'amount' => 'Amount',
            'type' => 'Type',
            'category' => 'Spending categories',
            'customer_or_company' => 'Guest or Company',
            'movement_amount' => 'Transactions',
            'notes' => 'Notes',
            'mode' => 'Mode',
            'document_date' => 'Document date',
            'label' => 'Label',
        ],
        'document_types' => [
            'invoice' => 'Invoice',
            'receipt' => 'Receipt',
            'credit_note' => 'Credit note',
        ],
        'payment_types' => [
            'deposit' => 'Down payment',
            'part_payment' => 'Deposit',
        ],
        'total_yesterday' => 'Yesterday total',
        'total_today' => 'Today total',
        'all_properties' => 'All properties',
        'sub_year' => 'Total of the year',
        'sub_month' => 'Total of the month',
        'sub_day' => 'Total of the day',
        'ins' => 'Takings (Income)',
        'outs' => 'Outflows (Payments)',
        'cash_fund' => 'Petty cash',
        'to_cash_in' => 'To cash out',
        'wrap_up' => 'Payment mode summary',
        'summary' => 'Summary',
        'in_out' => [
            'in' => 'Takings',
            'out' => 'Outflows',
        ],
        'totals' => [
            'method' => 'Method',
            'ins' => 'Takings',
            'outs' => 'Outflow',
            'diff' => 'Balace',
        ],
        'cash_balance' => 'Balace',
        'cash_out' => 'Outflows',
        'cash_in' => 'Takings',
    ],
    'channel' => [
        '1' => [
            'promotions' => [
                'mobile_rate' => [
                    // indicates channel ID
                    'all' => 'Application and Mobile Browser',
                    'app' => 'Application',
                ],
                'geo_rate' => [
                    'algeria_pos' => 'Algeria',
                    'argentina_pos' => 'Argentina',
                    'australia_pos' => 'Australia',
                    'belarus_pos' => 'Belarus',
                    'brazil_pos' => 'Brazil',
                    'canada_pos' => 'Canada',
                    'chile_pos' => 'Chile',
                    'colombia_pos' => 'Colombia',
                    'eu_pos' => 'Europe',
                    'hong_kong_pos' => 'Hong Kong',
                    'india_pos' => 'India',
                    'indonesia_pos' => 'Indonesia',
                    'iran_pos' => 'Iran',
                    'israel_pos' => 'Israel',
                    'japan_pos' => 'Japan',
                    'kazakhstan_pos' => 'Kazakhstan',
                    'kuwait_pos' => 'Kuwait',
                    'malaysia_pos' => 'Malaysia',
                    'mexico_pos' => 'Mexico',
                    'new_zealand_pos' => 'New Zealand',
                    'oman_pos' => 'Oman',
                    'pakistan_pos' => 'Pakistan',
                    'peru_pos' => 'Peru',
                    'philippines_pos' => 'Philippines',
                    'qatar_pos' => 'Qatar',
                    'russia_pos' => 'Russia',
                    'saudi_arabia_pos' => 'Saudi Arabia',
                    'singapore_pos' => 'Singapore',
                    'south_africa_pos' => 'South Africa',
                    'south_korea_pos' => 'South Korea',
                    'switzerland_pos' => 'Switzerland',
                    'taiwan_pos' => 'Taiwan',
                    'thailand_pos' => 'Thailand',
                    'trinidad_&_tobago_pos' => 'Trinidad & Tobago',
                    'turkey_pos' => 'Turkey',
                    'ukraine_pos' => 'Ukraine',
                    'united_arab_emirates_pos' => 'United Arab Emirates',
                    'united_states_pos' => 'USA',
                    'vietnam_pos' => 'Vietnam',
                ],
            ],
            'json_request' => [
                'errors' => [
                    'INVALID_ARGUMENT' => 'One or more data fields are invalid. (:message)',
                    'MISSING_ARGUMENT' => 'One or more data fields are missing. (:message)',
                    'OPERATION_NOT_ALLOWED' => 'Operation not allowed. (:message)',
                    'FORBIDDEN' => 'Operation forbidden (:message)',
                ],
            ],
        ],
        '11' => [
            'availability_model' => 'Room type "Private" availability management:',
            'per_room' => 'Per room (avail*beds)',
            'per_person' => 'Per bed',
        ],
        '14' => [
            'availability_value_greater' => 'You have entered an availability value greater than accepted.',
        ],
        '39' => [
            'period_not_valid' => 'Rate :rate valid from :valid_from to :valid_to. Update ignored.',
        ],
        '53' => [
            'warning_update_category' => 'Error updating category room :rate_xml. Rules not set in Beddy.',
            'empty_response_update' => 'Update error: empty response.',
        ],
        '68' => [
            'used_voucher' => 'VOUCHER USED',
            'amount_voucher' => 'Voucher amount',
            'used_amount' => 'Amount used',
            'virtual_rate_option' => 'Derived rates management',
            'virtual_rate_option_off' => 'Do not manage (read-only)',
            'virtual_rate_option_on' => 'Enable derived rates management (price not manageable)',
            'manage_type' => 'Connection type',
            'manage_type_complete' => 'Complete management',
            'manage_type_reservation' => 'Reservations only management',
            'manage_type_avail_reservation' => 'Availability and reservations management',
            'message_only_reservation' => 'Updates ignored (Linked for reservations only)',
            'message_avail_reservation' => 'Price and restriction updates ignored (Linked for availability and reservations management)',
            'deposit_requested' => 'Deposit requested',
            'deposit_payed' => 'Deposit paid',
            'payed_via' => 'Paid via',
        ],
        '69' => [
            'manage_type' => 'Connection type',
            'manage_type_complete' => 'Complete management',
            'manage_type_reservation' => 'Reservations only management',
            'manage_type_avail_reservation' => 'Availability and reservations management',
            'manage_type_avail_restriction_reservation' => 'Reservations, availability, and restrictions management',
            'message_only_reservation' => 'Updates ignored (Linked for reservations only)',
            'message_avail_reservation' => 'Price and restriction updates ignored (Linked for availability and reservations management)',
            'message_avail_restriction_reservation' => 'Price updates ignored (Linked for reservations, availability, and restrictions management)',
        ],
        '72' => [
            'manage_type' => 'Connection type',
            'manage_type_complete' => 'Complete management',
            'manage_type_reservation' => 'Reservations only management',
            'manage_type_avail_reservation' => 'Availability and reservations management',
            'manage_type_avail_restriction_reservation' => 'Reservations, availability, and restrictions management',
            'message_only_reservation' => 'Updates ignored (Linked for reservations only)',
            'message_avail_reservation' => 'Price and restriction updates ignored (Linked for availability and reservations management)',
            'message_avail_restriction_reservation' => 'Price updates ignored (Linked for reservations, availability, and restrictions management)',
        ],
        '73' => [
            'pricing_model' => 'Pricing model',
            'per_room' => 'Per room/rate',
            'per_person' => 'Per person',
            'manage_type' => 'Connection type',
            'manage_type_complete' => 'Complete management',
            'manage_type_reservation' => 'Reservations only management',
            'manage_type_avail_reservation' => 'Availability and reservations management',
            'manage_type_avail_restriction_reservation' => 'Reservations, availability, and restrictions management',
            'manage_type_avail_avail_price_reservation' => 'Reservations, availability, and prices management',
            'message_only_reservation' => 'Updates ignored (Linked for reservations only)',
            'message_avail_reservation' => 'Price and restriction updates ignored (Linked for availability and reservations management)',
            'message_avail_restriction_reservation' => 'Price updates ignored (Linked for reservations, availability, and restrictions management)',
            'manage_avail_price_reservation' => 'Restriction updates ignored (Linked for reservations, availability, and prices management)',
            'payment_info' => 'Payment info',
            'payment_amount' => 'Amount paid',
            'payment_extra_info' => 'Details',
            'payment_transaction' => 'Transaction code',
            'payment_full' => 'Full prepayment made for the entire booking amount',
            'payment_partial' => 'Partial prepayment made',
            'payment_none' => 'No prepayment',
            'payment_channel_collect' => 'Guest paid via the channel',
            'payment_hotel_collect' => 'Guest must pay at the hotel (fully or partially)',
            'payment_gateway' => 'Guest paid via bank gateway',
            'service_inclusive' => 'Included in the price',
        ],
        '93' => [
            'reservation_status' => 'Reservation status',
            'booked' => 'Booked, waiting for property confirmation',
            'waiting_payment' => 'Waiting for deposit payment',
            'payment_in_progress' => 'Payment being processed and verified',
            'confirmed' => 'Confirmed',
            'canceled' => 'Canceled',
            'waiting_credit_card_guarantee' => 'Waiting for credit card guarantee',
            'deposit' => 'Deposit',
            'payed' => 'Paid',
            'not_payed' => 'Not paid',
            'payment_mothod' => 'Payment method',
            'option_property_xml_id' => 'Property ID (same as Beddy)',
            'option_email' => 'Email',
            'option_apikey' => 'API key',
        ],
        '95' => [
            'unknown_rate' => 'Unknown PMS rate. Room and rate ID received from the channel: ',
        ],
        'option_general' => [
            'property_xml_id' => 'Property XML ID',
            'username' => 'Username',
            'password' => 'Password',
        ],
        'general' => [
            'get_channel_rate_empty' => 'No data downloaded from the portal',
            'no_data_to_update' => 'No data to send.',
            'no_valid_period' => 'Updated period is not valid. Update ignored.',
            'no_valid_response' => 'Invalid response received from the channel (:error_message)',
            'only_min_stay_update' => 'Property configured to update only the minimum stay.',
            'period_not_valid' => 'Rate :rate valid from :valid_from to :valid_to. Update ignored.',
            'no_valid_response_update' => 'Invalid response received from the channel.',
            'discount' => 'Discount',
            'unknown' => 'Unknown',
            'deposit_payed' => 'Deposit paid',
            'to_payed' => 'To be paid',
            'payment_type' => 'Type',
            'ota_commission' => 'OTA commission',
            'ota_due' => 'Due to OTA',
            'arrival_time' => 'Arrival time',
            'cancellable_until' => 'Cancelable until',
        ],
        'queue_update' => [
            'already_updated' => 'Update sent by operation code: :operation_code',
            'max_retry' => 'Maximum retry attempts executed for channel update: :channel_name - Period from: :date_from - to: :date_to. Last message: :message',
            'queue_update_max_retry_strategy_mail' => 'Maximum retry attempts for channel :channel_name - Property: :property_name',
            'queue_update_exception_mail' => 'Channel exception :channel_name - Property: :property_name',
        ],
        'errors' => [
            'content_api_update_errors_mail_connectivity' => 'CONTENT-API update error :channel_name - Property: :property_name',
            'property_is_related' => 'The property is not a parent and is already related to another property',
            'accommodation_channel_not_found' => 'Room with XML ID :accommodation_xml_id not found',
            'unsupported_min_dvance_res' => 'This channel does not allow setting a minimum advance booking value.'
        ],
        'queue_past_reservations' => [
            'queue_task_exists' => 'Property #:property_id already in execution queue',
        ],
    ],
    'checkinonline' => [
        'policy' => [
            'privacy_policy_first_paragraph' => 'Pursuant to art.s 13 and 14 of Regulation (EU) no. 2016/679 (hereinafter “GDPR”) on the protection of natural persons with regard to the processing of personal data and on the free flow of such data, :businessName in its capacity as Data Controller, is obliged to provide you with complete information concerning the purposes for which your personal data are processed and the procedures used, the entities to which your data may be disclosed, and all your legal rights with regard to the processing of your personal data by the Data Controller.',
            'privacy_policy_first_item' => '1. Who decides the purposes for which the data are processed and the procedures used?',
            'privacy_policy_list_second_item_1' => 'Personal identifying data;',
            'privacy_policy_list_second_item_2' => 'Special categories of data;',
            'privacy_policy_list_second_item_3' => 'Data relating to your stay;',
            'privacy_policy_list_second_item_4' => 'Personal preferences;',
            'privacy_policy_list_second_item_5' => 'Identification papers;',
            'privacy_policy_list_second_item_6' => 'Autograph signature;',
            'privacy_policy_list_second_item_7' => 'Purchasing history;',
            'privacy_policy_list_second_item_8' => 'Credit card and/or bank data;',
            'privacy_policy_list_second_item_9' => 'Security camera images;',
            'privacy_policy_list_second_item_10' => 'Data relating to the electronic devices used to connect to the hotel\'s Internet;',
            'privacy_policy_list_second_item_11' => 'Data relating to telephone calls;',
            'privacy_policy_list_second_item_12' => 'Data concerning access to and use of ICT resources',
            'privacy_policy_list_second_item_extra' => 'Health data.',
            'privacy_policy_list_third_item_1' => 'OTA (Online Travel Agencies) such as, for example, Booking.com, Venere.com, Worldhotels.com, Trivago.com, Expedia.com, etc',
            'privacy_policy_list_third_item_2' => 'Traditional travel agencies;',
            'privacy_policy_list_third_item_3' => 'Institutions, Associations, Organisations, Businesses or individuals who organise events or stays at the hotel; ',
            'privacy_policy_list_fourth_item_1' => 'Guest management;',
            'privacy_policy_list_fourth_item_2' => 'Signing and management of contracts; ',
            'privacy_policy_list_fourth_item_3' => 'Administrative management;',
            'privacy_policy_list_fourth_item_4' => 'Management of disputes;',
            'privacy_policy_list_fourth_item_5' => 'Customer care;',
            'privacy_policy_list_fourth_item_6' => 'Public relations',
            'privacy_policy_list_fourth_item_7' => 'Promotion, marketing and advertising;',
            'privacy_policy_list_fourth_item_8' => 'Protecting people\'s physical health;',
            'privacy_policy_list_fourth_item_9' => ' Internal security;',
            'privacy_policy_list_fourth_item_10' => 'Protecting and guaranteeing people\'s security and safety;',
            'privacy_policy_list_fourth_item_11' => 'Protecting the company\'s assets and property;',
            'privacy_policy_list_fourth_item_12' => 'Allowing the use and guaranteeing the safety of ICT infrastructure.',
            'privacy_policy_list_fourth_item_1_part_2' => 'Issue of consent; ',
            'privacy_policy_list_fourth_item_2_part_2' => 'Contractual and pre‐contractual obligations; ',
            'privacy_policy_list_fourth_item_3_part_2' => 'Legal obligations;',
            'privacy_policy_list_fourth_item_4_part_2' => 'Legitimate interest of the Data Controller. ',
            'privacy_policy_list_fifth_item_1' => 'Through operations which will enable the collection, recording, organisation, storage, consultation, processing, modification, selection, extraction, use, communication, erasure and destruction of data.',
            'privacy_policy_list_fifth_item_2' => ' Through the use of electronic or other automated tools allowing the storage, processing and transmission of data, always configured in order to guarantee the maximum privacy and the necessary safeguards.',
            'privacy_policy_list_fifth_item_3' => 'Through the use of paper documents with the adoption of suitable storage measures which prevent them from coming to the knowledge of unauthorised subjects.',
            'privacy_policy_list_seventh_item_1' => 'People in charge of data processing;',
            'privacy_policy_list_seventh_item_2' => 'Data Processors; ',
            'privacy_policy_list_seventh_item_3' => 'System administrators; ',
            'privacy_policy_list_seventh_item_4' => 'Accounting Consultants;',
            'privacy_policy_list_seventh_item_5' => 'Legal Advisers; ',
            'privacy_policy_list_seventh_item_6' => 'Banks',
            'privacy_policy_list_seventh_item_7' => 'Insurance companies;',
            'privacy_policy_list_seventh_item_8' => 'Auditing firms;',
            'privacy_policy_list_seventh_item_9' => 'Hotel infrastructure maintenance service companies',
            'privacy_policy_list_seventh_item_10' => 'Internet and email service provider companies; ',
            'privacy_policy_list_seventh_item_11' => 'Institutions, Associations, Organisations, Businesses or individuals who organise events or stays at the hotel; ',
            'privacy_policy_list_seventh_item_12' => 'Public authorities;',
            'privacy_policy_list_seventh_item_13' => 'Police forces.',
            'privacy_policy_list_eighth_item_1' => 'Other EU states (apart from Italy); ',
            'privacy_policy_list_eighth_item_2' => 'United Kingdom; ',
            'privacy_policy_list_eighth_item_3' => 'Ireland; ',
            'privacy_policy_list_eighth_item_4' => 'Switzerland;',
            'privacy_policy_list_eighth_item_5' => 'USA',
            'privacy_policy_list_nineth_item_1' => '10 years (as envisaged by Italian Civil Law ‐ Art. 2220 Civil Code);',
            'privacy_policy_list_nineth_item_2' => 'no more than 3 months from the check‐out date for credit card data;  ',
            'privacy_policy_list_nineth_item_3' => 'no more than 3 years after the last check‐out for personal data, special data, stay‐related data, personal preferences, identification papers, signature, purchasing record and marketing data (Points 2.1 to 2.7), unless otherwise specified by the data subject; ',
            'privacy_policy_list_nineth_item_4' => 'no more than 5 days for security camera images;',
            'privacy_policy_list_nineth_item_5' => '90 days from check‐out for telephone traffic data;',
            'privacy_policy_list_nineth_item_6' => '1 year for data concerning access to and use of ICT resources.',
            'privacy_policy_second_item' => '2. Which personal data does the Data Controller process?',
            'privacy_policy_second_paragraph' => 'You are therefore kindly requested to note the information provided here and to give your consent to the processing by signing this privacy policy statement.',
            'privacy_policy_text_first_item' => 'The Data Controller is :businessName with registered office :businessCity in :businessAddress, :businessCap,  VAT n. :businessVat.',
            'privacy_policy_text_second_item' => 'The Data Controller will collect and process your personal data, meaning any data which may identify you and which can be directly or indirectly traced to you, such as (but not limited to):',
            'privacy_policy_text_second_item_part_2' => 'and all other data necessary to provide the activities covered by point 4. ',
            'privacy_policy_text_second_item_part_2_span' => 'Special categories of data will also be processed, including:',
            'privacy_policy_text_third_item' => 'Personal data are contributed to the Data Controller directly by the data subject or collected through other entities such as:',
            'privacy_policy_text_fourth_item' => ' The personal data collected by the Data Controller will be processed for the following purposes:',
            'privacy_policy_text_fifth_item' => 'Data will be processed in automated and/or manual form, in accordance with the provisions of art. 32 of GDPR 2016/679, and in particular:',
            'privacy_policy_text_fourth_item_part_2' => ' Personal data will be processed in strict compliance with legal requirements, in accordance with principles of lawfulness and ethics and without breaching your right to privacy. Personal data will be processed for:',
            'privacy_policy_text_sixth_item' => 'If the contribution of personal data is necessary for the fulfilment of a contract or a legal obligation, processing is essential, and in case of a refusal to contribute or allow the processing of the data covered by this privacy policy statement, the Data Controller will be unable to provide the activities covered by point 4 and in general will be unable to fulfil the obligations undertaken. ',
            'privacy_policy_text_sixth_item_span' => 'With regard to the purposes of the data processing for which your consent is requested, the refusal will not affect the obligations undertaken.',
            'privacy_policy_text_seventh_item' => ' Your data may be transferred to and processed by other entities, in the capacity of authorised processors, data processors or independent data controllers, for the fulfilment of precontractual, contractual or statutory obligations, or on the grounds of legitimate interest. ',
            'privacy_policy_text_seventh_item_span' => ' Categories of recipients may therefore include: ',
            'privacy_policy_text_seventh_item_part_2' => ' The data contributed to and collected by the Data Controller are not publicly disseminated or used for profiling.',
            'privacy_policy_text_eighth_item' => ' Personal data may be transferred to European Union Countries, non‐European Union Countries or an international organisation if this is necessary to provide the activities covered by point 4 and in general will be unable to fulfil the obligations undertaken. As of the date of this document, the countries to which your data are transferred are:',
            'privacy_policy_text_nineth_item' => ' Your data will be stored for the time strictly necessary for the performance of the activities related to the purposes set out in this Statement. Specifically, the storage times will be:',
            'privacy_policy_text_nineth_item_part_2' => ' In all cases, longer storage periods will apply if required by specific legislation in the sector. In the event of disputes, personal data will be stored until the end of the expiration period envisaged by law for the protection of rights relating to the contractual relationship.',
            'privacy_policy_text_tenth_item' => '  Via a specific written communication, sent by certified email or registered letter with return receipt to the Data Controller\'s address, you have:',
            'privacy_policy_sub1' => 'Right of access to data (Art. 15, GDPR)',
            'privacy_policy_text_tenth_item_part_2' => 'To obtain from the Data Controller confirmation as to whether or not personal data concerning you are being processed, and, where that is the case, access to the personal data and specific information detailed in art. 15 of the GDPR.',
            'privacy_policy_sub2' => 'Right to rectification (Art. 16, GDPR)',
            'privacy_policy_text_tenth_item_part_3' => 'To obtain from the Data Controller, without undue delay, the rectification of inaccurate personal data concerning you, depending on the purposes of the processing, you also have the right to the supplementation of incomplete personal data, also by providing an additional statement.',
            'privacy_policy_sub3' => 'Right to cancel(Art. 17, GDPR)',
            'privacy_policy_text_tenth_item_part_4' => 'To obtain from the controller the erasure of personal data concerning you without undue delay, and the controller has the obligation to erase your personal data without undue delay, unless there are grounds impeding the exercise of the above right.',
            'privacy_policy_sub4' => 'Right to restriction of processing (Art. 18, GDPR)',
            'privacy_policy_text_tenth_item_part_5' => 'To obtain the restriction of processing of your personal data when possible, or to withdraw consent given previously. The withdrawal of consent is without prejudice to the lawfulness of the processing prior to the withdrawal.',
            'privacy_policy_sub5' => 'Right to the portability of the data (Art. 20, GDPR)',
            'privacy_policy_text_tenth_item_part_6' => 'If the processing is based on consent or on a contract, and is undertaken by automated means, you have the right to receive the personal data concerning you, which you have provided to the controller, in a structured, commonly used and machine‐readable format and to transmit them to another data controller, or have them transferred by the controller itself, if technically feasible.',
            'privacy_policy_sub6' => 'Right to object (Art. 21, GDPR)',
            'privacy_policy_text_tenth_item_part_7' => 'The right to object, on grounds relating to your situation at any time to processing of personal data concerning you which is based on the legitimate interest of the data controller or your consent, including profiling, unless the controller demonstrates compelling legitimate grounds for the processing which override your rights.',
            'privacy_policy_sub7' => 'Right to ensure that your data are not subject to an automated decision‐making process, including profiling (art. 22, GDPR)',
            'privacy_policy_text_tenth_item_part_8' => 'Not to be subject to a decision based solely on automated processing, including profiling, which produces legal effects concerning you or similarly significantly affects you. As stated in point 7, the Data Controller does not use automated decision‐ making processes.',
            'privacy_policy_sub8' => 'The right to lodge a complaint with a supervisory authority (Art. 77, GDPR)',
            'privacy_policy_text_tenth_item_part_9' => 'Without prejudice to any other administrative or judicial remedy, if you consider that the processing of personal data relating to you infringes these regulations, you may lodge a complaint with the Supervisory Authority, and exercise all your rights under current legislation in general.',
            'privacy_policy_text_eleventh_item' => ' If you request information concerning your data, the Data Controller will reply as soon as possible ‐ unless this is impossible or implies a disproportionate effort ‐ and in all cases not more than 30 days after the application. Any inability to reply or delays on the part of the data controller will be justified',
            'privacy_policy_text_twelfth_item' => ' This privacy policy statement also applies to positions opened before 25.05.2018.',
            'privacy_policy_third_item' => '3. How are personal data collected?',
            'privacy_policy_fourth_item' => '4. Why do you collect my data?',
            'privacy_policy_fifth_item' => '5. How will the data collected be processed?',
            'privacy_policy_sixth_item' => ' 6. Why should I contribute my data to the Data Controller? Can I refuse?',
            'privacy_policy_seventh_item' => ' 7. Who will obtain knowledge of my data?',
            'privacy_policy_eighth_item' => ' 8. May my data be transferred abroad?',
            'privacy_policy_nineth_item' => ' 9. For how long will my data be stored?',
            'privacy_policy_tenth_item' => ' 10. What can I do to restrict, prevent or object to the processing of my data by the Data Controller?',
            'privacy_policy_eleventh_item' => '  11. How long will it take to receive a reply from the Data Controller? ',
            'privacy_policy_twelfth_item' => ' 12. Validity and duration  ',
            'privacy_policy_fourth_item_part_2' => 'Legal basis of processing',
            'privacy_policy_title' => 'Customer Privacy Policy Statement',
            'privacy_policy_title_footer' => 'Signature confirming reading of the privacy policy statement',
            'privacy_policy_title_first_item' => 'The Data Controller',
            'privacy_policy_title_fourth_item' => 'Purposes of the processing',
            'privacy_policy_title_fifth_item' => 'Processing Procedures',
            'privacy_policy_title_sixth_item' => 'Nature of the contribution of data and Refusal to contribute them',
            'privacy_policy_title_seventh_item' => 'Disclosure of data',
            'privacy_policy_title_tenth_item' => 'Rights of the data subject',
            'privacy_policy_vers' => 'Version 1.1 dated 4.4.2019',
            'privacy_policy_accept' => 'I, the undersigned, identified as below, declare that I have received the full privacy policy statement as required by Art. 13 and 14 of Regulation (EU) 2016/679 and that I have clearly understood its contents.',
            'privacy_policy_name_surname' => 'Name and surname',
            'privacy_policy_title_consent' => 'Declaration of consent to processing',
            'privacy_policy_authorize' => 'I authorise',
            'privacy_policy_not_authorize' => 'I do not authorise',
            'privacy_policy_auth_1' => 'The Data Controller to process special categories of data as per art. 9 of Regulation (EU) 679/2016, to enable me to enjoy an optimal level of hospitality and for the protection of my health and safety;',
            'privacy_policy_auth_2' => ' The Data Controller to disclose data concerning my stay, for the sole purpose of enabling me to receive any telephone messages intended for me.',
            'privacy_policy_auth_3' => 'The Data Controller to send marketing communications to my addresses.',
            'privacy_policy_location' => ':businessCity',
            'privacy_policy_sign' => 'Signature:',
        ],
    ],
    'city_tax_channel' => [
        'default' => [
            'accommodations_mapping' => 'Room mapping',
            'scheduled_send' => 'Do you want to enable automatic report sending?',
            'scheduled_send_info' => 'The system automatically sends all guests checking out the day before the current date. For example, on June 25th, it sends guests who checked out on June 24th.',
            'which_guests_to_send' => 'Automatically send:',
            'only_invoiced' => 'Only guests with invoiced city tax',
            'all_guest_with_city_tax_calculated' => 'All guests with calculated city tax',
        ],
        'pay_tourist' => [
            'structure_id' => 'PayTourist structure ID',
            'software_id' => 'Authorized Software Partner ID issued by PayTourist',
            'get_extra_specifications' => 'Get room types',
            'token' => 'Token for API access, issued by PayTourist',
            'period' => 'Period for which to generate the city tax report',
        ],
        'tourist_tax' => [
            'period' => 'Period for which to generate the city tax report',
            'city_tax_channel_group_id' => 'City tax report configuration group for sending/exporting',
        ],
        'exceptions' => [
            'city_tax_channel_configuration_not_valid' => 'The following parameters for associating a structure with a city tax channel are not valid:',
            'channel_configuration_not_valid' => 'The following parameters required by the channel :channelName are not valid: :params',
            'channel_credential_not_valid' => 'The credentials for the channel :channelName are not valid',
            'channel_configuration_must_have_one_property' => 'The channel :channelName requires at most one structure',
            'channel_params_not_valid' => 'The following parameters required by the channel :channelName to create the report are not valid: :params',
            'channel_configuration_missing' => 'The configuration parameters required by the channel :channelName are missing from the request',
            'channel_params_missing' => 'The parameters required by the channel :channelName to create the report are missing from the request',
            'city_tax_exemption_not_mapped' => 'Exemption :exemptionName not mapped for guest :guestName :guestSurname in reservation :reservationId - :booker',
            'city_tax_channel_place_not_found' => 'The city :placeName is not yet available for the selected channel',
            'city_tax_channel_group_not_found' => 'The selected group does not exist',
            'file_not_valid' => 'Unable to save the exported file to the cloud for the channel :channelName',
            'networking_error' => 'Error in the request to send the city tax report for reservation :reservationId for the channel :channelName with the following error: :error',
            'channel_unreachable' => 'Unable to reach the channel :channelName at the moment due to the following errors: :errors',
            'date_range_out_of_boundaries' => 'The maximum report period for the channel :channelName is :days days from the start date',
            'date_from_not_valid' => 'The earliest start date for generating the report for the channel :channelName is at most :days days before the transmission date',
            'guest_attributes_missing' => 'Unable to send the city tax report for the channel :channelName due to missing data for the following guests: :guests',
            'empty_report' => 'No guests were extracted in the requested city tax report',
            'endpoint_not_mapped' => 'The endpoint for the city :place for the channel :channelName is not available, please contact technical support',
        ],
    ],
    'city_tax_configuration' => [
        'errors' => [
            'restriction_fields_not_valid' => 'The fields provided do not belong to the specified city tax restriction',
            'option_fields_not_valid' => 'The fields provided do not belong to the specified city tax option',
            'field_not_valid' => 'The field :fieldNotValid does not meet the validation :condition :validation',
            'configuration_override_already_exist' => 'A city tax configuration already exists that includes the selected dates',
        ],
        'exceptions' => [
            'city_tax_configuration_not_valid' => 'The following parameters for creating a city tax configuration are not valid:',
            'field_not_valid' => 'The field :fieldName is not among the expected fields of the configuration',
            'field_is_required' => 'The field :fieldName is required',
        ],
    ],
    'city_tax_option_field' => [
        'option_field' => [
            'nationality' => [
                'country_id' => [
                    'name' => 'Nationality',
                    'description' => 'Guest nationality',
                ],
            ],
            'reservation_from' => [
                'reservation_from_id' => [
                    'name' => 'Source',
                    'description' => 'Reservation source.',
                ],
            ],
            'reservation_reason' => [
                'reservation_reason_id' => [
                    'name' => 'Reason',
                    'description' => 'Reason for the reservation.',
                ],
            ],
            'group_leader' => [
                'active' => [
                    'name' => 'Active',
                    'description' => 'Activate exclusion.',
                ],
            ],
            'residence_country' => [
                'country_id' => [
                    'name' => 'Country of residence',
                    'description' => 'Guest\'s country of residence.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exemption',
                    'description' => 'Exemption',
                ],
            ],
            'residence_state' => [
                'state_id' => [
                    'name' => 'State of residence',
                    'description' => 'Guest\'s state of residence.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exemption',
                    'description' => 'Exemption',
                ],
            ],
            'residence_county' => [
                'county_id' => [
                    'name' => 'County of residence',
                    'description' => 'Guest\'s county of residence.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exemption',
                    'description' => 'Exemption',
                ],
            ],
            'residence_city' => [
                'city_id' => [
                    'name' => 'City of residence',
                    'description' => 'Guest\'s city of residence.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exemption',
                    'description' => 'Exemption',
                ],
            ],
            'accommodation_tableau_number' => [
                'accommodation_tableau_number_id' => [
                    'name' => 'Accommodation',
                    'description' => 'Accommodation',
                ],
            ],
            'accommodation' => [
                'accommodation_id' => [
                    'name' => 'Type of Accommodation',
                    'description' => 'Type of Accommodation',
                ],
            ],
        ],
    ],
    'city_tax_option' => [
        'option' => [
            'nationality' => [
                'name' => 'Nationality',
                'description' => 'Guest nationality',
            ],
            'reservation_from' => [
                'name' => 'Source',
                'description' => 'Reservation source.',
            ],
            'reservation_reason' => [
                'name' => 'Reason',
                'description' => 'Reason for the reservation.',
            ],
            'group_leader' => [
                'name' => 'Group leader',
                'description' => 'Group leader among the guests.',
            ],
            'residence_country' => [
                'name' => 'Country of residence',
                'description' => 'Guest\'s country of residence.',
            ],
            'residence_state' => [
                'name' => 'State of residence',
                'description' => 'Guest\'s state of residence.',
            ],
            'residence_county' => [
                'name' => 'County of residence',
                'description' => 'Guest\'s county of residence.',
            ],
            'residence_city' => [
                'name' => 'City of residence',
                'description' => 'Guest\'s city of residence.',
            ],
            'accommodation_tableau_number' => [
                'name' => 'Accommodation',
                'description' => 'Accommodation.',
            ],
            'accommodation' => [
                'name' => 'Type of Accommodation',
                'description' => 'Type of Accommodation.',
            ],
        ],
    ],
    'city_tax_restriction_field' => [
        'restriction_field' => [
            'age_range' => [
                'min_age' => [
                    'name' => 'Minimum age',
                    'description' => 'Minimum age of the range',
                ],
                'max_age' => [
                    'name' => 'Maximum age',
                    'description' => 'Maximum age of the range',
                ],
                'amount_price' => [
                    'name' => 'Fixed amount',
                    'description' => 'City tax amount',
                ],
                'percentage_price' => [
                    'name' => 'Percentage amount',
                    'description' => 'Percentage calculation for the amount',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Exemption',
                    'description' => 'Exemption',
                ],
                'price_type' => [
                    'name' => 'Price type',
                    'description' => 'Type of price',
                ],
            ],
            'percentage_range' => [
                'min_amount' => [
                    'name' => 'Minimum amount',
                    'description' => 'Minimum value for percentage calculation',
                ],
                'max_amount' => [
                    'name' => 'Maximum amount',
                    'description' => 'Maximum value for percentage calculation',
                ],
            ],
            'validity_period' => [
                'date_from' => [
                    'name' => 'Start date',
                    'description' => 'Start date of the validity period',
                ],
                'date_to' => [
                    'name' => 'End date',
                    'description' => 'End date of the validity period',
                ],
                'flag_year' => [
                    'name' => 'Seasonality',
                    'description' => 'Period valid every year',
                ],
            ],
            'price_range_night' => [
                'min_price' => [
                    'name' => 'Minimum price',
                    'description' => 'Minimum price valid for calculation',
                ],
                'max_price' => [
                    'name' => 'Maximum price',
                    'description' => 'Maximum price valid for calculation',
                ],
            ],
            'limit_days' => [
                'days' => [
                    'name' => 'Applicability nights',
                    'description' => 'Maximum nights of applicability',
                ],
            ],
            'month_max_nights' => [
                'max_days' => [
                    'name' => 'Applicability nights',
                    'description' => 'If a guest exceeds this limit in the calendar month (even for different and non-consecutive bookings), the tax will no longer be applied',
                ],
            ],
            'year_max_nights' => [
                'max_days' => [
                    'name' => 'Applicability nights',
                    'description' => 'If a guest exceeds this limit in the calendar year (even for different and non-consecutive bookings), the tax will no longer be applied',
                ],
            ],
            'reservation_max' => [
                'max' => [
                    'name' => 'Maximum number',
                    'description' => 'Maximum number of bookings applicable annually to a specific guest',
                ],
            ],
            'limit_nights' => [
                'min_nights' => [
                    'name' => 'Minimum nights',
                    'description' => 'Minimum number of nights for the booking.',
                ],
                'max_nights' => [
                    'name' => 'Maximum nights',
                    'description' => 'Maximum number of nights for the booking.',
                ],
            ],
            'range_nights' => [
                'night_from' => [
                    'name' => 'From night',
                    'description' => 'Starting night for the calculation.',
                ],
                'night_to' => [
                    'name' => 'To night',
                    'description' => 'Ending night for the calculation.',
                ],
                'amount_price' => [
                    'name' => 'Fixed amount',
                    'description' => 'City tax amount',
                ],
                'percentage_price' => [
                    'name' => 'Percentage amount',
                    'description' => 'Percentage calculation for the amount',
                ],
                'price_type' => [
                    'name' => 'Price type',
                    'description' => 'Type of price',
                    'amount_name' => 'Amount',
                    'percentage_name' => 'Percentage',
                ],
            ],
            'adult_quote_range' => [
                'min_amount' => [
                    'name' => 'Minimum amount',
                    'description' => 'Select the minimum adult quote amount calculated on the nightly price excluding VAT',
                ],
                'max_amount' => [
                    'name' => 'Maximum amount',
                    'description' => 'Select the maximum adult quote amount calculated on the nightly price excluding VAT',
                ],
                'amount_price' => [
                    'name' => 'Fixed amount',
                    'description' => 'City tax amount',
                ],
                'percentage_price' => [
                    'name' => 'Percentage amount',
                    'description' => 'Percentage calculation for the amount',
                ],
                'price_type' => [
                    'name' => 'Price type',
                    'description' => 'Type of price',
                    'amount_name' => 'Amount',
                    'percentage_name' => 'Percentage',
                ],
            ],
            'price_type_name' => [
                'amount_name' => '€',
                'percentage_name' => '%',
            ],
        ],
    ],
    'city_tax_restriction' => [
        'restriction' => [
            'age_range' => [
                'name' => 'Age range',
                'description' => 'Age range for tax application',
            ],
            'percentage_range' => [
                'name' => 'Amount limits for percentage calculations',
                'description' => 'Min and max amount limits for percentage calculation.',
            ],
            'validity_period' => [
                'name' => 'Validity period',
                'description' => 'Tax applicability period.',
            ],
            'price_range_night' => [
                'name' => 'Accommodation daily price range',
                'description' => 'Minimum and maximum price a night must have to be considered for tax calculation.',
            ],
            'limit_days' => [
                'name' => 'Maximum nights of applicability',
                'description' => 'Limit on nights for tax application.',
            ],
            'month_max_nights' => [
                'name' => 'Monthly limit of applicable nights per specific guest',
                'description' => 'Maximum number of nights applicable in a month for a guest.',
            ],
            'year_max_nights' => [
                'name' => 'Annual limit of applicable nights per specific guest',
                'description' => 'Maximum number of nights applicable in a year for a guest.',
            ],
            'reservation_max' => [
                'name' => 'Annual limit of applicable reservations per specific guest',
                'description' => 'Maximum number of reservations in a year for a guest.',
            ],
            'limit_nights' => [
                'name' => 'Night limits of applicability within a reservation',
                'description' => 'Minimum and maximum number of nights in a reservation for tax application.',
            ],
            'range_nights' => [
                'name' => 'Override calculation based on reservation nights',
                'description' => 'Start and end night numbers for the reservation.',
            ],
            'adult_quote_range' => [
                'name' => 'Guest night quota price',
                'description' => 'Choose the guest quota range and its respective price.',
            ],
        ],
    ],
    'city_tax' => [
        'tax_type' => [
            'xroomxnightxpax' => [
                'name' => 'Percentage amount on accommodation fee per person per night',
                'description' => 'The tax is calculated for each guest on all overnight stays as a percentage of the accommodation fee (accommodation price divided by number of guests).',
            ],
            'xroomxnight' => [
                'description' => 'The tax is calculated as a percentage of the accommodation price on each night\'s stay, not taking into account the number of guests.',
                'name' => 'Percentage amount on accommodation price per night',
            ],
            'xnight' => [
                'description' => 'The tax is calculated on each night\'s stay according to the amount chosen, not considering the number of guests.',
                'name' => 'Amount per night',
            ],
            'xnightxpax' => [
                'description' => 'The tax is calculated for each guest for all nights of accommodation according to the amounts chosen.',
                'name' => 'Amount per person per night',
            ],
            'xpax' => [
                'description' => 'The fee is calculated for each guest according to the amounts chosen, not taking into account the number of overnight stays.',
                'name' => 'Amount per person',
            ],
            'xroomextraxnightxpax' => [
                'description' => 'The tax is calculated for each guest on all overnight stays as a percentage of the accommodation fee + extra (accommodation price + extra divided by number of guests).',
                'name' => 'Percentage amount on accommodation price + extras per person per night',
            ],
            'xbook' => [
                'description' => 'The tax is calculated with the fixed amount chosen regardless of the number of nights and guests.',
                'name' => 'One-off fixed amount',
            ],
            'xtotalroomxnightxpax' => [
                'description' => 'The tax is calculated on each guest for all nights of accommodation as a percentage of the total price (accommodation + extras).',
                'name' => 'Percentage amount on total price (accommodation + extras) per person per night',
            ],
            'xroomxtotalnightxpax' => [
                'description' => 'The tax is calculated for each guest on all overnight stays as a percentage of the accommodation price',
                'name' => 'Percentage amount on accommodation price per person per night',
            ],
        ],
        'price_type' => [
            'amount_percentage' => 'Amount and percentage',
            'percentage' => 'Percentage',
            'amount' => 'Amount',
        ],
        'city_tax_extra_text' => 'The amount of the tax is an estimate and may be subject to changes according to terms and conditions during the stay.',
        'errors' => [
            'no_city_tax_configuration' => 'City tax not configured.',
        ],
        'warnings' => [
            'no_guests_for_accommodation' => 'For the accommodation :accommodation_name there are no guests for whom the tourist tax can be calculated.',
            'no_tax_for_accommodation' => 'For the accommodation :accommodation_name the system is unable to calculate any city tax configured.',
        ],
    ],
    'cloners' => [
        'treatments' => [
            'description' => 'This option will allow you to clone the treatments from the source property to the destination. By selecting this option, the treatments of the source property will be overwritten.',
        ],
        'accommodations' => [
            'description' => 'This option will allow you to clone the rooms of the source property. If selected together with rate plans, the links will be created to reflect the source property.',
        ],
        'priceLists' => [
            'description' => 'This option will allow you to clone the price lists of the source property.',
        ],
        'ratePlans' => [
            'description' => 'This option will allow you to clone the rate plans of the source property.',
        ],
        'rates' => [
            'description' => 'This option will allow you to clone the rates of the source property.',
        ],
        'modules' => [
            'description' => 'This option will allow you to clone the modules of the source property.',
        ],
        'customers' => [
            'description' => 'This option will allow you to clone the customers of the source property.',
        ],
        'companies' => [
            'description' => 'This option will allow you to clone the companies of the source property.',
        ],
        'invoiceLayouts' => [
            'description' => 'This option will allow you to clone the invoicing profiles of the source property.',
        ],
        'addons' => [
            'description' => 'This option will allow you to clone the extra services of the source property.',
        ],
        'availabilities' => [
            'description' => 'This option will allow you to clone the availabilities of the source property.',
        ],
        'childrenRanges' => [
            'description' => 'This option will allow you to clone the children ranges of the source property.',
        ],
        'roles' => [
            'description' => 'This option will allow you to clone the roles of the source property.',
        ],
        'paymentMethods' => [
            'description' => 'This option will allow you to clone the payment methods of the source property.',
        ],
        'rules' => [
            'description' => 'This option will allow you to clone all the rules of the source property.',
        ],
        'emailTemplates' => [
            'description' => 'This option will allow you to clone all the email templates of the source property.',
        ],
        'events' => [
            'description' => 'This option will allow you to clone all the events of the source property.',
        ],
        'policies' => [
            'description' => 'This option will allow you to clone all the cancellation policies of the source property.',
        ],
        'cityTaxes' => [
            'description' => 'This option will allow you to clone the tab: City tax configurations.',
        ],
    ],
    'common' => [
        'datetime' => [
            'default' => '%d/%m/%Y %H:%M',
            'extended_phrasal_date' => '%A, %e %B %Y',
            // "Venerdì,  7 Giugno 2019"
            'extended_phrasal_date_short' => '%a, %e %b %Y',
            // "Ven,  7 Giu 2019"
            'extended_phrasal_date_with_time' => '%A, %e %B %Y - %H:%M',
            // "Venerdì,  7 Giugno 2019 - 18:03"
            'extended_phrasal_date_short_with_time' => '%a, %e %b %Y - %H:%M',
            // "Ven,  7 Giu 2019 - 18:03"
            'phrasal_date' => '%e %B %Y',
            // " 7 Giugno 2019"
            'phrasal_date_short' => '%e %b %Y',
            // " 7 Giu 2019"
            'date' => '%d/%m/%Y',
            // "07/06/2019" per 7 giugno 2019
            'for_range' => '%d %b',
            // "04 Apr" - per quando si deve indicare un range di date, ad es: "04 Apr - 07 Apr"
            'time' => '%H:%M',
            // orario in formato 24 ore; es.: "00:00" oppure "18:03"
            'year' => 'Year',
            'month' => 'Month',
            'day' => 'Day,',
            'time' => 'Time',
            'dates_interval' => 'Date interval',
            'from_day' => 'From',
            'to_day' => 'To',
            'days' => 'Days',
            'months' => [
                1 => 'January',
                2 => 'February',
                3 => 'March',
                4 => 'April',
                5 => 'May',
                6 => 'June',
                7 => 'July',
                8 => 'August',
                9 => 'September',
                10 => 'October',
                11 => 'November',
                12 => 'December',
            ],
            'months_short' => [
                1 => 'Jan',
                2 => 'Feb',
                3 => 'Mar',
                4 => 'Apr',
                5 => 'May',
                6 => 'Jun',
                7 => 'Jul',
                8 => 'Aug',
                9 => 'Sep',
                10 => 'Oct',
                11 => 'Nov',
                12 => 'Dec',
            ],
            'days_of_week' => [
                'None' => 'Domenica',
                'None' => 'Lunedì',
                'None' => 'Martedì',
                'None' => 'Mercoledì',
                'None' => 'Giovedì',
                'None' => 'Venerdì',
                'None' => 'Sunday',
            ],
            'days_of_week_short' => [
                'None' => 'Dom',
                'None' => 'Lun',
                'None' => 'Mar',
                'None' => 'Mer',
                'None' => 'Gio',
                'None' => 'Ven',
                'None' => 'Sun',
            ],
            'days_of_week_initials' => [
                'None' => 'D',
                'None' => 'L',
                'None' => 'M',
                'None' => 'M',
                'None' => 'G',
                'None' => 'V',
                'None' => 'Sun',
            ],
        ],
        'currency' => [
            'display' => ':prefix :symbol :amount',
            'format' => '%!.2n',
        ],
        'gender' => [
            'male' => 'Male',
            'female' => 'Woman',
        ],
        'bool' => [
            'yes_no' => [
                1 => 'Yes',
                0 => 'No',
            ],
            'true_false' => [
                1 => 'True',
                0 => 'False',
            ],
        ],
        'exports' => [
            'customers_generic' => 'Clients List',
            'companies_generic' => 'Companies List',
            'reservations_generic' => 'Reservations List',
            'reservations_invoices_opened_generic' => 'Open Bills list',
            'reservations_invoices_generic' => 'Invoices List',
            'social_archive_generic' => 'Unlockable offer customers list',
            // "active", "revoked", "accepted", "expired", "draft"
            'reservations_quotes_all_generic' => 'Quotes list',
            'reservations_quotes_active_generic' => 'Active quotes list',
            'reservations_quotes_revoked_generic' => 'Rejected Quotes List',
            'reservations_quotes_accepted_generic' => 'Accepted Quotes List',
            'reservations_quotes_expired_generic' => 'Expired Quotes List',
            'reservations_quotes_draft_generic' => 'Draft Quotes List',
            'rateplans_generic' => 'Rate Plans, Offers and Packages List',
            'rateplans_plans_generic' => 'Rate Plans List',
            'rateplans_offers_generic' => 'Offers List',
            'rateplans_bundles_generic' => 'Packages List',
            'coupons_generic' => 'Coupons List',
            'reservations_list' => 'Reservations List',
            'total_entries' => 'Total raws: :value',
            'meals_plan' => 'Meal Plan',
            'meals' => 'Meals',
            'city_tax' => 'City tax',
            'reservations_guests_presences' => 'Guests in house',
            'housekeeper' => 'housekeeper_:date',
            'deposits' => 'Deposits and down payments'
        ],
        'user_full_name' => 'Operator',
        'print_date' => 'Print date',
        'total' => 'Total',
        'totals' => 'Totals',
        'total' => 'Total',
        'quantity' => 'Quantity',
        'category' => 'Category',
        'qty' => 'Q.ty',
        'discount' => 'Discount',
        'description' => 'Description',
        'wrap_up' => 'Summary',
        'amount' => 'Amount',
        'vat' => 'VAT',
        'reservation' => 'Reservation',
        'nights' => '{1} 1 Night|[2,*] :count Nights',
        'vat_code' => 'VAT',
        'unmapped_addons' => 'OTA Extra services ',
        'date' => 'Date',
        'stripe_statement_descriptor' => 'Reservation number: :reservationNumber - :email',
        'payment_method' => 'Method',
        'buyer' => 'Payer',
        'payments' => 'Payments',
        'available_soon' => 'This feature will be available soon',
        'details' => 'Details',
        'accommodation' => '{1} 1 Accommodation|[2,*] :count Accommodations',
        'nic' => 'Fisc.Code',
        'number_of_nights' => 'Number of nights',
        'checkout_hour' => 'Check-out hours',
        'checkin_hour' => 'Check-in hours',
        'yes' => 'Yes',
        'no' => 'No',
    ],
    'company' => [
        'errors' => [
            'vat_code_not_valid' => 'The entered VAT code is not valid',
            'tax_code_not_valid' => 'The entered tax code is not valid',
        ],
        'warnings' => [
            'existing_company' => 'The Company already exists :company_name associated with the entered VAT code',
        ],
        'export_fields' => [
            'name' => 'Name',
            'address' => 'Address',
            'vat_code' => 'VAT code',
            'zip_code' => 'Zip Code',
            'state' => 'Region',
            'county' => 'County',
            'country' => 'Country',
            'city' => 'City',
            'tax_code' => 'National Insurance Number',
            'nick_name' => 'Nick name',
            'telephone' => 'Telephone',
            'email' => 'Email',
        ],
        'import' => [
            'validations' => [
                'name_required' => 'The name field is compulsory',
                'vat_code_required' => 'The VAT code field is required',
                'nick_name_required' => 'The nick_name field is compulsory',
                'vat_code_unique' => 'There is an existing Company with the same VAT number',
                'email' => 'The email field does not contain a valid email',
                'pec' => 'The pec field does not contain a valid email',
            ],
        ],
        'fields' => [
            'company_id' => 'company identifier'
        ],
    ],
    'content_api' => [
        'checkin_hour' => 'Check-in time',
        'checkout_hour' => 'Check-out time',
        'children_allowed' => 'Children allowed',
        'pets_allowed' => 'Animals allowed',
        'smoking_allowed' => 'Smokers allowed',
        'max_adults_number' => 'Maximum number of adults',
        'max_guests_number' => 'Maximum number of guests',
        'minimum_age' => 'Minimum age',
        'percent_payment_at_booking' => '% payment at the booking',
        'remaining_payment_type' => 'Remaining payment',
        'remaining_payment_type_at_checkin_label' => 'Payment at the check-in',
        'remaining_payment_type_at_checkin_description' => 'The remaining payment will be required at the check-in',
        'remaining_payment_type_before_checkin_label' => 'Payment X days before the check-in',
        'remaining_payment_type_before_checkin_description' => 'The remaining payment will be required X days before the check-in',
        'remaining_payment_type_before_checkin_day' => 'Number of days before the check-in',
        'advertise_name' => 'Name',
        'rental_document_upload' => 'Rental document upload',
        'merchant_name' => 'Business name',
        'x_stay' => 'Per Stay',
        'x_night' => 'Per night',
        'managment_applies_guest_type' => 'Guest management fee types',
        'managment_applies_pets_type' => 'Pet management fee type',
        'managment_applies_value' => 'Management Fee',
        'management_energy_value' => 'Energy management fee',
        'management_energy_type' => 'Energy management fee type',
        'managment_applies_pets_value' => 'Pet management fee',
        'managment_applies_guest_value' => 'Guest management fee',
        'bank_transfer_note' => 'Notes for the Banking transfer (Max 500 characters',
        'bank_transfer' => 'Accept Bank transfer',
    ],
    'coupons' => [
        'refundable' => [
            '0' => 'Not refundable',
            '1' => 'Refundable',
        ],
        'export_fields' => [
            'code' => 'Code',
            'quantity' => 'Quantity',
            'discount' => 'Discount',
            'date_from' => 'From',
            'date_to' => 'To',
            'type' => 'Type',
            'min_expense' => 'Minimum expense',
            'min_stay' => 'Min. stay',
            'max_stay' => 'Max. stay',
            'valid_days' => 'Valid days',
        ],
    ],
    'credit_card_type' => [
        'fields' => [
            'model_name' => 'Credit Card Type',
        ],
    ],
    'customer' => [
        'errors' => [
            'reservationExists' => 'There are connected reservations.',
            'guestExist' => 'There are connected guests.',
            'documentExists' => 'There is a similar document type in the archive.',
            'privacyCheckExists' => 'The privacy policy has already been accepted by the client.',
            'customerNotFound' => 'Guest not found',
            'guestExists' => 'Customer configured as a guest in active reservations',
            'tax_code_not_valid' => 'The fiscal code entered is invalid',
            'birthday_date_major_than_now' => 'The date of birth cannot be later than today\'s date',
        ],
        'fields' => [
            'birthday_date' => 'guest birth date',
            'sex' => 'guest gender',
            'address' => 'guest address',
            'zip_code' => 'guest zip code',
            'email' => 'guest email',
            'telephone' => 'guest telephone',
            'name' => 'guest name',
            'surname' => 'guest surname',
            'model_name' => 'guest',
            'language_id' => 'language'
        ],
        'export_fields' => [
            'name' => 'Name',
            'surname' => 'Surname',
            'birthday_date' => 'Birth date',
            'sex' => 'Gender',
            'note' => 'Notes',
            'city' => 'City',
            'county' => 'County',
            'state' => 'Region',
            'country' => 'Country',
            'address' => 'Address',
            'zip_code' => 'Zip Code',
            'email' => 'Email',
            'telephone' => 'Telephone',
            'fax' => 'Fax',
            'facebook' => 'Facebook',
            'linkedin' => 'Linkedin',
            'twitter' => 'Twitter',
            'web_address' => 'Website',
            'birth_city_name' => 'City of birth',
            'birth_state_name' => 'Birth Country',
            'birth_state' => 'State of birth',
            'residence_city' => 'Residency - City',
            'residence_county' => 'Residency - County',
            'residence_state' => 'Residency - Region',
            'residence_country' => 'Residency - Country',
            'residence_address' => 'Residency - Address',
            'residence_zip_code' => 'Residency - ZIP Code',
            'billing_city' => 'Billing - City',
            'billing_county' => 'Billing - County',
            'billing_state' => 'Billing - Region',
            'billing_country' => 'Billing - Country',
            'billing_address' => 'Billing - Address',
            'billing_zip_code' => 'Billing - ZIP Code',
            'promotion_check' => 'Newsletter',
            'privacy_check' => 'GDPR',
            'reservations_count' => 'Reservations',
            'type' => 'Type',
            'newsletter' => 'Newsletter',
            'GDPR' => 'GDPR',
        ],
        'import' => [
            'validations' => [
                'nic_unique' => 'Existing guest with the same fiscal code',
                'name_required' => 'The name field is compulsory',
                'sex' => 'The gender field is not valid, the values granted are not defined, male, female',
                'surname_required' => 'The surname field is compulsory',
                'email' => 'The email field is invalid',
                'birthday_date_date_format' => 'The birth date field is not formatted correctly',
                'document_type' => 'The document type does not exist',
                'birth_country_not_valid' => 'The birth country field is invalid',
                'birth_city_not_valid' => 'The birth city field is invalid',
                'citizenship_country_not_valid' => 'The citizenship country field is invalid',
                'residence_country_not_valid' => 'The residence country field is invalid',
                'residence_city_not_valid' => 'The residence city field is invalid',
                'nationality_country_not_valid' => 'The nationality country field is invalid',
                'language' => 'Invalid language field, use lowercase ISO format (e.g., it, en)',
            ],
            'alredy-in-progress' => 'Import is still in progress, wait for completion and try again',
        ],
    ],
    'daily_closure' => [
        'daily_title' => 'Daily Closure',
        'department' => 'Department',
        'production' => 'Production',
        'total' => 'Total',
        'property' => 'Property',
        'receipt' => 'Receipt',
        'name' => 'Name',
        'invoice' => 'Invoice',
        'amount' => 'Balance',
        'guests' => 'Guests',
        'accommodation' => 'Rooms',
        'empty_documents' => 'No documents issued or received in the selected period',
        'empty_payments' => 'No payments issued or received in the selected period',
        'export_fields' => [
            'production_department' => 'Production by Department',
            'production_treatments' => 'Production by Treatment',
            'production_accommodations' => 'Production by Accommodation',
            'occupancy' => 'Occupancy',
            'documents' => 'Documents of :date_from|Documents from :date_from to :date_to',
            'payments' => 'Payments of :date_from|Payments from :date_from to :date_to',
            'summary' => 'Cash Summary (:date_from)|Cash Summary (:date_from - :date_to)',
            'accommodations_sold' => 'Rooms Sold',
            'sold_nights' => 'Nights Sold',
            'unsold_nights' => 'Nights Unsold',
            'penalty_nights' => 'Penalty Nights',
            'accommodations_available' => 'Available Rooms',
            'date' => 'Date',
            'income' => 'Income',
            'outcome' => 'Expenses',
            'occupancy' => 'Occupancy',
            'payment_method' => 'Payment Method',
            'type' => 'Type',
            'reversal_receipt' => 'Reversal Receipt',
            'number' => 'Number',
            'in' => 'Income',
            'out' => 'Expenses',
            'intestatary' => 'Account Holder',
            'name' => 'Name',
            'modality' => 'Method',
            'note' => 'Notes',
            'taxable' => 'Taxable',
            'vat_quote' => 'VAT',
            'treatment' => 'Treatment',
            'average_revenue' => 'Average Guest Revenue',
            'adr' => 'ADR',
            'revpar' => 'RevPar',
            'reservations' => 'Reservations',
            'no_show' => 'No-Show',
            'confirmed' => 'Confirmed',
            'cancelled' => 'Cancelled',
            'optionable' => 'Options',
            'expired' => 'Expired',
            'unknown' => 'Unknown',
            'checkin' => 'Check-ins',
            'checkout' => 'Check-outs',
            'in_house' => 'Stays',
            'attendance' => 'Attendance',
            'absolute_guests' => 'Absolute Guests',
        ],
    ],
    'daily_summary' => [
        'daily_summary' => 'Daily Summary',
        'accommodation' => 'Room',
        'accommodation_type' => 'Room Type',
        'name_and_surname' => 'Name and Surname',
        'stay' => 'Stay',
        'guests' => 'Guests',
        'treatment' => 'Treatment',
        'channel' => 'Channel',
        'payment_details' => 'Payment Details',
        'notes' => 'Notes',
        'adults' => 'Adults',
        'children' => 'Children',
        'total' => 'Total',
        'arrivals' => 'Arrivals',
        'departures' => 'Departures',
        'in_home' => 'Stays',
        'nights' => 'Nights',
        'paid' => 'Paid',
        'to_pay' => 'To Pay',
        'no_reservations_found' => 'No reservations found for this date',
        'daily_summary_of_date' => 'Daily summary of :date',
    ],
    'deposits' => [
        'export_fields' => [
            'property' => 'Property',
            'number' => 'Number',
            'deposit_number' => 'Number',
            'document_number' => 'Document Number',
            'date' => 'Date',
            'registration_date' => 'Date',
            'type' => 'Type',
            'amount' => 'Amount',
            'amount_available' => 'Available Amount',
            'amount_used' => 'Used Amount',
            'reservation_number' => 'Reservation ID',
            'pos' => 'POS',
            'description' => 'Description',
            'buyer' => 'Payer',
            'reservation_id' => 'Reservation ID',
            'used_amount' => 'Used Amount',
            'user_pay' => 'Payer',
            'reservation' => 'Reservation',
            'payment_method' => 'Payment Method',
            'arrival_date' => 'Arrival Date',
            'departure_date' => 'Departure Date',
            'deposit' => 'Deposit',
            'part_payment' => 'Part Payment',
            'stay' => 'Stay',
        ],
    ],
    'email_suppression_list' => [
        'reason_types' => [
            'BOUNCE' => 'Undelivered',
            'COMPLAINT' => 'Reported as SPAM',
        ],
        'errors' => [
            'NotFoundException' => 'Email not found',
            'BadRequestException' => 'Invalid request parameters',
            'TooManyRequestsException' => 'Too many requests made',
            'TooManyRequestException' => 'Too many requests made',
        ],
    ],
    'emails' => [
        'multiple_sessions' => [
            'subject' => 'Security Alert: Multiple devices connected to your account',
            'body' => "Hello :user_first_name,<br />we have detected connections from multiple devices on your account. We recommend checking your currently active sessions:",
            'summary_reset' => 'If you do not recognize these devices, <a href=":recoveryPasswordLink" target="_blank">we recommend changing your password immediately</a> to protect your account.',
            'device' => 'Device',
            'place' => 'Location',
            'date_hour' => 'Date and Time',
            'unknown' => 'Unknown',
            'logout' => 'You can also <a href=":logoutAllDevice" target="_blank">log out</a> from all devices via Profile > Security & Access.',
        ],
        'general' => [
            'link_preview' => 'click here for the printable version',
            'additionals_informations' => 'Additional information',
            'automatic_email_message' => 'This email has been sent automatically, please do not reply to this address.',
            'message' => 'Message',
        ],
        'reservation_confirmed' => [
            'subject' => 'Reservation number #:reference_number',
            'reservation_confirm' => 'Your reservation',
            'reply' => 'Reply',
            'reservation_number' => 'number',
            'thanks' => 'Thank you',
            'view_quote' => 'click here for the quotation',
            'show_detail' => '<a href=":showDetailsReservation">click here for your reservation</a>',
            'your_reservation' => 'Your reservation for',
            'is_confirmed' => 'is confirmed',
            'ti_aspettiamo_il' => 'We\'ll wait for you on',
            'reservation_summary' => 'Booking summary',
            'nights' => 'Night|Nights',
            'city_tax' => 'City Tax',
            'accommodations' => 'Accommodation|Accommodations',
            'adults' => 'adult|adults',
            'childrens' => 'child|children',
            'total_reservation' => 'Booking total',
            'price_payed' => 'Amount paid',
            'price_to_pay' => 'Amount to be paid',
            'payment_method' => 'Payment method',
            'other_request' => 'Specifications and other requests',
            'banktransfer_informations' => 'Bank details',
            'printable_link' => 'Click here for the printable version',
            'other_operations' => 'Other operations',
            'checkin' => 'Check-in online',
            'modify_reservation' => 'Change your reservation',
            'cancel_reservation' => 'Cancel your reservation',
            'additional_informations' => 'Additional information',
            'contability_informations' => 'Upon receipt of the payment of <b>:price_deposit</b> we will proceed with the booking confirmation. To speed up the operation, we recommend that you send us a copy of the payment made with the CRO number.',
            'tax' => 'Taxes',
            'confirm_reservation_with_bank_transfer_suggestion' => 'To complete the transaction, we recommend that you complete the payment as soon as possible',
            'checkin_online_pin' => 'The code to the online <a style="color: #8f743f; text-decoration: underline !important;" target="_blank" href=":link">Check-In</a> is ',
            'pin' => 'Pin Code',
            'reservation_confirmed_with_stripe' => 'The reservation has been confirmed through the payment gateway Stripe',
        ],
        'property_reservation_new' => [
            'subject' => 'New reservation from :channel_name - :property_name (#:reference_number)',
        ],
        'property_reservation_modified' => [
            'subject' => 'Modify reservation from :channel_name (#:reference_number)',
            'body_1' => 'Reservation changed on channel <b>:channel_name </b> <b>:xml_reservation_id</b> on behalf of <b>:name :surname </b> (From <b>:arrival_date </b> To <b>:departure_date </b> )',
            'body_2' => 'To see all the reservation details <a href="https://app.beddy.io/reservation/:reservation_id">click here</a>',
        ],
        'property_reservation_cancelled' => [
            'subject' => 'Reservation canceled by :channel_name (#:reference_number)',
            'body_1' => 'The reservation has been canceled on the channel <b>:channel_name</b> <b>:xml_reservation_id</b> a nome di <b>:name :surname</b> (Dal <b>:arrival_date</b> Al <b>:departure_date</b>) of the property <b>:property_name</b> for the accommodations:<br>:accommodations_lists',
            'body_2' => 'To see all the reservation details <a href="https://app.beddy.io/reservation/:reservation_id"> click here </a>',
        ],
        'property_activation' => [
            'subject' => 'Account :product_name - :property_name',
            'footer' => 'For any further information our customer service is at your disposal from Monday to Friday from 10:00 to 14:00 and from 15:30 to 18:00.
            Thank you for choosing :product_name.
            <br>
            Best Regards',
        ],
        'users' => [
            'changedPassword' => [
                'subject' => 'Beddy - Your password has been changed',
                'summary' => 'Dear <b>:firstname</b>,<br>we inform you that the password for your <b>Beddy</b> account has been successfully changed.',
                'errors' => [
                    'unexpectedNotice' => 'If you did not change your password, please contact the property administrator and/or our support team.<br><br>
                Best regards,<br>
                The Beddy Team',
                ],
            ],
            'attachment' => [
                'subject' => 'You have been associated with a new property on Beddy',
                'summary' => 'Dear <b>:firstname</b>,<br>Your Beddy account has been associated with a new property.<br><br>Here are the access details:',
                'property' => 'Property',
                'roleAssigned' => 'Assigned Role',
                'loginDetails' => [
                    'login' => 'You can always access this property via app.beddy.io with the same credentials.',
                    'helpContactInfo' => 'If needed, you can contact:',
                    'master' => 'the property administrator: :masterEmail',
                    'support' => 'Beddy support: <a href="mailto: :supportEmail">:supportEmail</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'If you were not expecting this communication or believe this is a mistake, please do not complete the activation and contact the property administrator and/or our support.',
                ],
            ],
            'activation' => [
                'subject' => 'You have been invited to Beddy – Activate your access',
                'summary' => 'Dear <b>:firstname</b>,<br> a Beddy account has been created for you.<br><br> Here are your details:',
                'username' => 'Username',
                'email' => 'Email',
                'toDo' => 'To <b>activate your account</b>, you need to set your <b>password</b>.',
                'button' => '<a href=":creationPasswordLink">Create Password</a>',
                'expiration' => 'The activation link is valid for 5 days.',
                'contacts' => [
                    'helpContactInfo' => 'If you need assistance, you can contact:',
                    'master' => 'the property administrator: ',
                    'support' => 'Beddy support: <a href="mailto: :supportEmail">support@beddy.io</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'If you were not expecting this message or believe it was sent in error, please do not complete the activation and contact the property administrator and/or our support team.',
                    'uncompletedRegistration' => 'Registration not completed: the account is not yet active. Check the email we sent you and set your password to activate it.',
                ]
            ],
            'passwordreset' => [
                'subject' => 'Password account reset procedure :product_name',
                'body' => 'Hi <b> :first_name! </b>
            <br/>
            you received this email because you asked to change the password to enter your account :product_name,
            <br><br>
            To change your password, click <a href=":link_reset"> here </a> within 30 minutes.
            <br>
            If it wasn\'t you who asked to change the password or you don\'t want to change it anymore, ignore this email.
            <br>
            Best Regards.',
            ],
            'password_expiration_notify' => [
                'subject' => 'Beddy Account Password Expiration Notice',
                'body' => 'Dear <b>:name :surname</b>,
                <br/>
                We inform you that the password associated with your Beddy account will expire in <b>:days days</b>. Please update it as soon as possible from the <a href=":profile" target="_blank">Profile</a> section.
                <br><br>
                If you have forgotten your current password, you can reset it by clicking on <i><a href=":resetPassword" target="_blank">Having trouble logging in?</a></i> from the <a href=":login" target="_blank">login</a> page.
                <br>
                <br>
                Best regards,<br>
                The Beddy Team',
            ],
        ],
        'past_connect_reservation_cancelled' => [
            'body' => 'A reservation not listed in Beddy has been cancelled.
                 <br />
                 <strong>It is necessary to check the availability of the accommodations involved.</strong>
                 <br /><br />
                 <u>Details of the cancellation in question are as follows:</u>
                 <br />
                 Source portal: :channel_name
                 <br />
                 Reservation ID: :xml_reservation_id
                 <br />
                 Made on: :booked_at
                 <br />
                 Customer: :customer_detail
                 <br /><br />
                 <u>What to do:</u>
                 <br />
                 - Check the reservation and the accommodations involved on the portal\'s extranet.
                 <br />
                 - Check the availability of the accommodations involved in this reservation and, if necessary, update them from the Channel Manager.
                 <br /><br />
                 <u>A reservation may not be listed on Beddy for the following reasons:</u>
                 <br />
                 1. The reservation is prior to the connection of the Channel Manager. Not all portals allow the download of reservations received before the connection of the Channel Manager (or they allow a limited time download).
                 <br />
                 2. The guest cancelled immediately after confirming the reservation, in these cases it may happen that the portal sends us the cancellation without having sent the relevant booking and therefore Beddy does not have a reference.
                 <br /><br />
                 Best regards',
            'subject' => 'Notice: reservation cancelled but not present in Beddy, please check the availability',
        ],
        'reservation_cancelled_from_user' => [
            'body_3' => 'For further information, do not hesitate to contact us.',
            'body_policy_penalty' => 'According to the <b>Cancellation Conditions</b>, you will face a penalty of :currency :penalty_value.',
            'body_policy_no_penalty' => 'According to the <b>Cancellation Policy</b> there is no penalty.',
            'body_2' => '<b> Booking summary </b> <br>
                 <b>:name :surname </b> (From <b>:arrival_date </b> To <b>:departure_date </b>) <br>
                 <b> Room: </b>:reservation_accommodations <br>
                 <b> Guests: </b>:total_guests <br>
                 <b> Total: </b>:currency :total_price',
            'body_1' => 'Hi, <br> this automatic email confirms that you have canceled your reservation n.<b>:reference_number </b> made on <b>:booked_at </b>.',
            'subject' => 'Reservation canceled (#:reference_number)',
        ],
        'bank_transfer_reminder' => [
            'subject' => 'Reservation number :reference_number - Bank transfer reminder',
            'body' => 'Dear :booker_name :booker_surname,<br>
            we would like to inform you that in order to confirm your booking :reference_number dated :booked_at, you must send us a payment in the amount of :price.
            <br><br>
            Please find below all necessary data for your bank transfer:<br>
            <i>:bank_text</i>
            <br><br>
            If you don\'t manage to send us a payment confirmation, your booking will be automatically cancelled.
            <br><br>
            Please disregard this email if you have already made the payment.<br>
            Do not hesitate to contact us for any further information.<br>',
            'footer' => 'Yours sincerely,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'bank_transfer_cancelled' => [
            'subject' => 'Cancelled reservation number :reference_number',
            'body' => 'Dear :booker_name :booker_surname,<br>
            Since you didn\'t send us your payment confirmation, your booking :reference_number dated :booked_at has been cancelled.
            <br><br>
            Do not hesitate to contact us for any further information.<br>',
            'footer' => 'Yours sincerely,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'cutoff_errors' => [
            'footer' => 'Kind regards.',
            'body_1' => 'For the property <b>:property_name</b> have been found the following errors: <br><br>',
            'subject' => 'Cutoff sending error - :property_name',
        ],
        'deactivate_properties' => [
            'first_notice' => [
                'subject' => 'Beddy account renewal',
                'body_1' => 'Dear Customer,
            <br><br>
            we are glad to confirm the renewal of your Beddy account and all related services.
            <br><br>',
                'body_2' => 'In the next few days, through the SDI channel, you will receive the invoice for the use of Beddy Software ( from :date_from to :date_to ). We kindly ask you to send us the receipt of the payment, in order to easily locate it.
            <br><br>
            Your details:',
                'body_3' => 'For any further information our customer service is available from Monday to Friday from 10:00 to 14:00 and from 15:30 to 18:00.',
                'footer' => 'In thanking you for choosing Beddy, we take this opportunity to thank you again
            <br><br>
            Kind regards,',
            ],
            'second_notice' => [
                'subject' => 'Beddy account renewal',
                'body_1' => 'Dear Customer,
            <br><br>
            we are glad to confirm once again the renewal of your Beddy account and all related services.
            <br><br>
            In the next few days, through the SDI channel, you will receive the invoice for the use of Beddy Software ( from :date_from to :date_to ).
            <br><br>
            Your details:',
                'body_2' => 'For any further information our customer service is available from Monday to Friday from 10:00 to 14:00 and from 15:30 to 18:00.
            <br><br>
            In thanking you for choosing Beddy, we take this opportunity to thank you again
            <br><br>
            Kind regards,',
            ],
        ],
        'reservation_quote_expire_days_before' => [
            'footer' => '<br><br>Kind regards,
            <br>:property_name
            <br>:property_telephone
            <br>:property_email',
            'body_2' => '<br><br>For further information, do not hesitate to contact us.',
            'body_1' => 'Dear :customer_name :customer_surname,
             <br> we would like to inform you that  the <a href=":quote_link">quote</a> requested will expire on :expire_date',
            'subject' => 'Your quote is due to expire',
        ],
        'reservation_quote_expire_property' => [
            'footer' => '<br><br>Kind Regards.',
            'body_1' => 'The quote for this guest : customer_name :customer_surname, created on :creation_date, has just expired.',
            'subject' => 'Your quote has expired',
        ],
        'reservation_quote_expire' => [
            'footer' => '<br><br>Kind regards,
            <br>:property_name
            <br>:property_telephone
            <br>:property_email',
            'body_2' => '<br><br> For further information, please do not hesitate to contact us.',
            'body_1' => 'Dear :customer_name :customer_surname,
             <br>please note that your quote you kindly requested on: :creation_date has just expired.',
            'subject' => 'Your quote has expired',
        ],
        'email_auth_verification' => [
            'body' => 'Dear :name :surname, <br/> <br/> this is the pin requested to confirm the login into your Beddy account: <strong>:pin</strong> <br/> <br/> Your pin will expire at :expire_time',
        ],
        'checkin_online_complete' => [
            'view_guests' => 'Verify Guest data',
            'reservation_number' => 'Reservation #:reference_number',
            'body_1' => 'Dear<b>:property_name</b>, <br/><br /> <b>:main_guest_name :main_guest_surname</b> has just completed the online cehck-in registration for the following reservation:<br/>',
            'subject' => 'Online Check-in successfully done - :reference_number',
        ],
        'order_payment_release' => [
            'subject' => 'Pre-authorization issued (#:reference_number)',
            'body' => 'The payment preauthorization for the reservation number <b>:reference_number</b> (dal: <b>:arrival_date</b> al <b>:departure_date</b>) for the guest <b>:customer_name :customer_surname</b>has been released',
        ],
        'reservation_request_avail' => [
            'payment_method' => 'Payment method',
            'price_to_pay' => 'Amount to be paid',
            'price_payed' => 'Paid amount',
            'total_reservation' => 'Total reservation',
            'childrens' => 'child | children',
            'adults' => 'adult | adults',
            'additional_informations' => 'Extra information',
            'other_operations' => 'Other options',
            'printable_link' => 'Click here to view the printable version',
            'other_request' => 'Details and other requests',
            'accommodations' => 'Accommodation| Accommodations',
            'nights' => 'Night| Nights',
            'reservation_summary' => 'Request summary',
            'city_tax' => 'City tax',
            'receive_news' => 'You will receive our feedback as soon as possible.',
            'invalid_reservation_property' => 'This request is not a reservation yet, the guest is still waiting for your feedback',
            'invalid_reservation' => 'We kindly remind you that this request is not a reservation yet until we will send the confirmation.',
            'is_confirmed' => 'has been sent',
            'your_request_avail' => 'Your availability request for',
            'show_detail_avail' => 'Click here to view the availability request',
            'view_quote' => 'Click here to view the quote',
            'show_detail' => 'Click here to view the reservation',
            'thanks' => 'Thank you',
            'reservation_number' => 'number',
            'tax' => 'Taxes',
            'reply' => 'Reply',
            'reservation_confirm' => 'Availability request',
            'subject' => 'Availability request for :property_name (:arrival_date - :departure_date)',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'subject' => 'Clean status chenged for accommodation :cleanable_name - :accommodation_name',
            'body' => ':user_name changed clean status to <b>:clean_status</b> of <b>:reference_date</b> for accommodation <b>:cleanable_name</b> (:accommodation_name) of property :property_name.',
        ],
        'user_update_email_verification_code' => [
            'body' => 'Dear :name :surname, <br/> <br/> to complete the request to change your Beddy account, please enter this PIN: <strong>:pin</strong>',
            'warning' => 'If you did not request the change, we recommend that you <a href=":recoveryPasswordLink" target="_blank">immediately change your password</a> to protect your account. <br/> <br/>
            Additionally, you can log out from all devices from the menu <a href=":logoutAllDevice" target="_blank"> Profile > Security and access</a>.',
        ],
        'user_update_email_confirmed' => [
            'subject' => 'Your email address has been updated',
            'body' => 'Dear :name :surname, <br/> <br/> the email associated with your Beddy account has been successfully updated.<br/> <br/>From now on, you will receive communications at this address.',
        ],
        'housekeeper_maintainer' => [
            'subject' => 'New maintenance report for the accommodation: :accommodation_name',
            'body' => 'A new maintenance report has been submitted for accommodation <b>:accommodation_name</b> (<b>:tableau_label</b>). Below are all the details: <br><br><b>Title:</b> :title <br><br><b>Description:</b> :description',
        ],
        'invoice_received' => [
            'body' => 'Invoice number<b> :document_number</b> of day<b> :document_date</b> was received from <b>:sender_name</b>',
            'subject' => 'Invoice receipt :document_number of :doc_date from :sender_name',
        ],
        'invoice_rejected' => [
            'body' => 'Invoice number <b>: number_complete</b> was rejected by the SDI for the following reason: <b>: rejected_reason</b>',
            'subject' => 'Invoice :number_complete of :invoice_date rejected by SDI',
        ],
        'reservation_accommodation_zero_avails' => [
            'body' => 'On <b>:date_now</b> the availability was depleted for the accommodation: <b>:accommodation_name - (:property_name)</b> for the following dates: <b>:days</b>',
            'subject' => 'Availability depleted for the accommodation :accommodation_name - Property: (:property_name)',
        ],
        'sca_authorized' => [
            'body' => 'The SCA for the reservation number <b>:reference_number</b> for the guest <b>:booker_name :booker_surname</b> (dal: <b>:arrival_date</b> al <b>:departure_date</b>) has been authorized on <b>:accepted_date</b>.The IP address the SCA has been authorized from is: <b>:ip_address</b>',
            'subject' => 'Sca authorization (#:reference_number)',
        ],
        'reservation_option_expired' => [
            'body' => 'The reservation number  <b>:reference_number</b> under the name of <b>:booker_name :booker_surname</b> with check-in date on <b>:arrival_date and check-out date on :departure_date </b>  has expired',
            'subject' => 'Reservation option expired (#:reference_number)',
        ],
        'guests_reporting_ko' => [
            'body' => '1 schedina not sent :error_message|:number_of_guests not sent :error_message',
            'subject' => 'Sending Error schedine Alloggiati for - :property_name',
        ],
        'guests_reporting_ok' => [
            'body' => '1 schedina successfully sent |:number_of_guests schedine successfully sent',
            'subject' => 'The schedine alloggiati have been successfully sent for - :property_name',
        ],
        'guests_reporting' => [
            'error' => '1 schedina not sent|:number schedine not sent :errorMessage',
            'success' => '1 schedina sent successfully|:number schedine sent successfully',
            'subject' => 'Send schedine Alloggiati - :alloggiatiweb_group_label',
            'alloggiatiweb' => [
                'push' => [
                    'general_error' => [
                        'subject' => 'Schedine alloggiati of :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                        'body' => 'Unable to send the schedine alloggiati due to the following errors: :errorMessage.',
                    ],
                    'error' => [
                        'body' => ':number of :number_total not sent. Fill in the missing data or correct the errors.|:number of :number_total not sent. Fill in the missing data or correct the errors.',
                        'subject' => 'Schedine alloggiati of :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    ],
                    'success' => [
                        'body' => 'The schedine alloggiati of :alloggiatiweb_send_date del gruppo :alloggiatiweb_group_label have been successfully sent (number of Schedine sent: :number).',
                        'subject' => 'Schedine alloggiati del :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    ],
                    'error_external' => [
                        'body' => 'Unable to send the Schedine Alloggiati due to these errors communicated by the portal: :errors Fix the errors and try to send them again manually.',
                    ],
                    'error_internal' => [
                        'body' => ':number of :alloggiatiweb_guest_total not been sent.
                        Fill in missing data or correct errors and manually try again.|:number su :alloggiatiweb_guest_total non inviate.
                        Fill in missing data or correct errors and manually try again.',
                    ],
                    'subject' => 'Alloggiati Web- :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                ],
                'mail' => [
                    'error' => [
                        'body' => ':number of :alloggiatiweb_guest_total not sent due to the following errors:| :number of :alloggiatiweb_guest_total not sent due to the following errors:',
                        'subject' => 'Schedine Alloggiati sending error - :alloggiatiweb_group_label',
                    ],
                    'success' => [
                        'subject' => 'Schedine Alloggiati sending :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                        'body' => ':number of :alloggiatiweb_guest_total sent.|:number of :alloggiatiweb_guest_total sent.',
                    ],
                    'fix_error' => 'Correct the errors and send the schedine alloggiati from <a href=":link">Documents > Schedine Istat e alloggiati</a>',
                    'error_external' => [
                        'body' => 'Unable to send the schedine Alloggiati due to following errors:<br/>:errors',
                    ],
                    'error_internal' => [
                        'body' => ':number on:alloggiatiweb_guest_total not sent for the following errors:<br/>:errors|:number on :alloggiatiweb_guest_total not sent for the following errors:<br/>:errors',
                    ],
                    'subject' => 'Report Schedine Alloggiati Report - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'summary' => 'Hereby the report Schedine Alloggiati of :alloggiatiweb_send_date of the sending group :alloggiatiweb_group_label:',
                ],
                'warning' => [
                    'fix_error' => 'It is necessary to correct the errors and send the cards lodged from <a href=":link">Documents > Schedine Istat e alloggiati</a>',
                    'error_external' => [
                        'body' => 'Unable to send the Schedine Alloggiati due to these errors communicated by the portal: :errors Fix the errors and try to send them again manually.',
                    ],
                    'error_internal' => [
                        'body' => ':number of :alloggiatiweb_guest_total have not been sent due to the following errors:<br/>:errors|:number of :alloggiatiweb_guest_total have not been sent due to the following errors:<br/>:errors',
                    ],
                    'subject' => 'Schedine Alloggiati errors- :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                ],
            ],
            'istat' => [
                'mail' => [
                    'subject' => 'ISTAT Forms Report - :istat_send_date - :istat_group_label',
                    'summary' => 'Below is the ISTAT Forms Report dated :istat_send_date for the sending group :istat_group_label:',
                    'success' => [
                        'body' => ':number out of :istat_guest_total sent.|:number out of :istat_guest_total sent.',
                    ],
                    'error_internal' => [
                        'body' => ':number out of :istat_guest_total not sent due to these errors:<br/>:errors|:number out of :istat_guest_total not sent due to these errors:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'The ISTAT forms could not be sent due to these errors reported by the portal:<br/>:errors',
                    ],
                    'fix_error' => 'You need to fix the errors and resend the ISTAT forms from <a href=":link">Documents > ISTAT and Guest Forms</a>',
                ],
                'push' => [
                    'subject' => 'ISTAT Forms :istat_send_date - :istat_group_label',
                    'success' => [
                        'body' => ':number out of :istat_guest_total sent.|:number out of :istat_guest_total sent.',
                    ],
                    'error_internal' => [
                        'body' => ':number out of :istat_guest_total was not sent.
    Fill in the missing data or correct the errors and try resending manually.|:number out of :istat_guest_total were not sent.
    Fill in the missing data or correct the errors and try resending manually.',
                    ],
                    'error_external' => [
                        'body' => 'The ISTAT forms could not be sent due to these errors:
    :errors
    Correct the errors and try resending manually.',
                    ],
                ],
            ],
            'error_levels' => [
                'guest' => 'Guest :guest',
                'accommodation' => 'Accommodation :accommodationType - :accommodationTableauNumber',
                'reservation' => 'Reservation :reservationId - :booker',
            ],
        ],
        'treatment_price_update' => [
            'body' => 'The calculation from :start_date to :end_date has been successfully completed',
            'subject' => 'Set treatment amount (:treatment_name) - :property_name',
        ],
        'document_default_email' => [
            'body' => 'Dear Guest,<br>please find below the information about :document_type :document_number of :document_date.<br>Please find also attached a copy of the document.<br><br>Thank you very much and<br>Best regards,<br>:sender_name',
        ],
        'suspend_email_reminder' => [
            'subject' => '{{% invoice.type %}} no. {{% invoice.number_complete %}}',
            'body' => 'Dear Customer,<br>we have noticed that the {{% invoice.type %}} {{% invoice.number_complete %}} dated {{% invoice.invoice_date %}} for {{% invoice.total %}} has not yet been paid.<br><br>We kindly ask you to settle the outstanding amount as soon as possible.<br>Attached you will find a copy of the document.<br><br>If you have already made the payment, please ignore this message.<br><br>We take this opportunity to extend our<br>Best Regards,<br>{{% reservation.property_name %}}',
        ],
        'conversation_message_send_failed' => [
            'go_to_conversation' => 'Go to the conversation',
            'title' => 'The message to :recipientName has not been sent. Please try again.',
            'subject' => 'Message send failed',
        ],
        'external_services' => [
            'UrmetSclak' => [
                'error_generate_key_subject' => 'Error Generating Keys for Booking :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'An error occurred in Sclak while generating the room keys. <br> :errors <br> Please retry manually. If the problem persists, contact Urmet support.',
                'error_seding_sms_subject' => 'Error Sending SMS for Booking Keys :booker_name :booker_surname (#ID: :reference_number)',
                'error_seding_sms_body' => 'It was not possible to send the Sclak SMS due to an error. <br> We recommend contacting Urmet support.',
            ],
            'nuki' => [
                'error_generate_key_subject' => 'Error Generating PIN for Booking :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'An error occurred in Nuki while generating the room PIN. <br> :errors <br> Please retry manually. If the problem persists, contact Nuki support.',
                'unauthorized_opening' => 'Unauthorized opening'
            ],
            'warning' => [
                'subject' => 'Error Generating Keys for Booking :booker_name :booker_surname (#ID: :reference_number)',
                'body' => 'An error occurred in Sclak while generating the room keys. <br> :errors <br> Please retry manually. If the problem persists, contact Urmet support.',
            ],
            'remote_door_key_service' => [
                'reservation_resumed' => [
                    'title' => 'Booking Changes, Generate New Keys',
                    'body' => 'A new key needs to be generated for the booking of <b>:booker_name :booker_surname - :reference_number</b> at the property <b>:property_name</b>. The previous one has been disabled following a booking status change.',
                ],
                'reservation_moved' => [
                    'title' => 'One or More Accommodations Have Been Moved. A New Key Must Be Generated.',
                    'body' => 'One or more accommodations in the booking of <b>:booker_name :booker_surname - :reference_number</b> at the property <b>:property_name</b> have been moved. A new key must be generated.',
                ],
            ],
        ],
        'reservation_message_received' => [
            'go_to_conversation' => 'Go to the conversation',
            'sender_wrote' => 'The guest has written:',
            'title' => ':senderName has sent you a new message!',
            'subject' => 'New Message from :senderName (#:reference)',
        ],
        'newsletters' => [
            'newsletter_not_sent_content' => 'Unable to send the newsletter campaign “:newsletterName” due to the following errors: :errorMessage',
            'newsletter_not_sent_subject' => 'Newsletter sending error',
            'newsletter_sent_content' => 'The Newsletter campaign ":newsletterName" has been sent to :sentContacts recipient on a total of :totalContacts selected contacts.',
            'newsletter_sent_subject' => 'Confirm the sending of the newsletter',
            'newsletter_exceeded_sent_limit_content' => 'The newsletter :newsletterName not sent due to exceeding the monthly quota of email sending',
            'newsletter_exceeded_sent_limit_subject' => 'Monthly sending quota limit reached',
        ],
        'property_reservation_banktransfer_cancelled' => [
            'body_2' => 'Click here <a href="https://app.beddy.io/reservation/:reservation_id">to view the reservation details</a>',
            'body_1' => 'A reservation has been cancelled automatically, due to missing payment by bank transfer. <br /><br />
                <u>Below are the details of the subject cancellation:</u><br />br />
                Property: <b>:property_name</b><br />
                Source channel: :channel_name<br />
                ID Reservation/reference: :xml_reservation_id<br />
                Customer: <b>:name :surname</b><br />
                Dates of stay: from <b>:arrival_date</b> to <b>:departure_date</b><br />
                Accommodation involved: <br>:accommodations_lists<br />',
            'subject' => 'Reservation cancelled from :channel_name (#:reference_number) for missing payment',
        ],
        'property_first_login' => [
            'subject' => 'Beddy - Login from a new device',
            'summary' => 'Hello :user_first_name,<br> a login from a new device to your Beddy account has been detected.',
            'summary_reset' => 'If you do not recognize this device, we recommend that you <a href=":recoveryPasswordLink" target="_blank">immediately change your password</a> to protect your account.',
            'device' => 'Device',
            'place' => 'Location',
            'date_hour' => 'Date and time',
            'unknown' => 'Unknown',
            'logout' => 'The login notification is a new Beddy feature, it is sent on first login even on devices already used in the past. Check the connected devices from the menu <a href=":logoutAllDevice" target="_blank"> Profile > Protection and access</a>. If they match, you can ignore this email.',
        ],
        'payments_timetable' => [
            'charge_failed' => [
                'body' => 'The charge for this automatic payment (ID:payment_timetable_id del :scheduled_date - Reservation :reservation_reference_number on behalf of :booker_name :booker_surname) could not be made due to the following reason: error_description',
                'subject' => 'Automatic payment debit failed (ID: :payment_timetable_id - :scheduled_date)',
            ],
            'no_credit_card' => [
                'body' => 'The automatic payment could not be debited (ID:payment_timetable_id del :scheduled_date - Reservation :reservation_reference_number on behalf of :booker_name :booker_surname) because there is no credit card to be used for the charge.',
                'subject' => 'Automatic payment debit failed (ID: :payment_timetable_id - :scheduled_date) - Credit card missing',
            ],
            'stripe_not_active' => [
                'body' => 'The automatic payment could not be debited (ID:payment_timetable_id del :scheduled_date - Reservation :reservation_reference_number on behalf of :booker_name :booker_surname) because there is no active Stripe account to be used for the charge.',
                'subject' => 'Automatic payment debit failed (ID: :payment_timetable_id - :scheduled_date) - Stripe not active',
            ],
            'payment_exceeded' => [
                'subject' => 'Automatic Payment Charge Failed (ID: :payment_timetable_id - :scheduled_date) - Payment Exceeds Total Booking Amount',
                'body' => 'The charge for the referenced automatic payment (ID: :payment_timetable_id on :scheduled_date - Booking :reservation_reference_number under the name of :booker_name :booker_surname) could not be processed because the payment exceeds the total amount of the booking.',
            ],
            'payment_require_action' => [
                'subject' => 'Automatic payment charge failed (ID: :payment_timetable_id - :scheduled_date) - 3D Secure required',
                'body' => 'Automatic charge failed due to 3D Secure request (ID: :payment_timetable_id, on :scheduled_date - Reservation :reservation_reference_number under the name of :booker_name :booker_surname).',
            ],
            'payment_require_action_send_request' => [
                'subject' => 'Automatic payment charge failed (ID: :payment_timetable_id - :scheduled_date) - Payment pending confirmation',
                'body' => "Automatic charge failed due to 3D Secure request (ID: :payment_timetable_id, on :scheduled_date - Reservation :reservation_reference_number under the name of :booker_name :booker_surname).\nA payment request has been sent to the customer via email.",
            ],

        ],
        'city_taxes_reports' => [
            'send_city_tax_report' => [
                'subject' => 'Confirmation of City Tax Report Submission',
                'content' => 'The city tax report for the submission channel :channelName has been successfully sent.',
            ],
            'send_city_tax_report_not_completed' => [
                'subject' => 'Error Sending City Tax Report',
                'content' => 'The city tax report for the submission channel :channelName could not be sent successfully.',
            ],
            'export_city_tax_report' => [
                'subject' => 'The City Tax Report Export for Channel :channelName Is Ready',
                'content' => 'Click the following link to be redirected to the city tax report history: <a href=":link">City Tax Report History</a>.',
            ],
            'export_city_tax_report_not_completed' => [
                'subject' => 'Unable to Complete City Tax Report Export for Channel :channelName',
                'content' => 'The generation of the report :reportId was not successful.',
            ],
            'guest_atrtributes_missing' => [
                'subject' => 'Error Sending/Exporting City Tax Report',
            ],
            'empty_report' => [
                'subject' => 'Unable to Complete the Sending/Exporting of City Tax Reports for Channel :channelName',
                'content' => 'The city tax report was not processed because no guests were found to report for the selected period.',
            ],
        ],
        'accommodation_deleted' => [
            'subject' => '[Action Required] - Availability Update Needed',
        ],
        'max_email_attachments_size_exceeded' => 'The size of the attached files exceeds the maximum allowed limit of 8 MB',
        'check_pci_expiration' => [
            'expiring_certification' => [
                'subject' => 'Beddy - Important: PCI Certification Expiration Notice',
                'content' => 'Dear partner :apiPartnerName,<br><br>
                    The PCI certification you provided will expire in 30 days.<br>
                    Please send us the updated certification at <a href="mailto:support@beddy.io">support@beddy.io</a> before the expiration date.<br>
                    After this date, access to payment data will be revoked by the system.<br><br>
                    The Beddy Team',
            ],
            'certification_expired' => [
                'subject' => 'PCI Certification Expired',
                'content' => 'Dear partner :apiPartnerName,<br>
                    The PCI certification you provided has expired.<br>
                    As a result, access to payment data has been revoked.<br>
                    Please send us the updated certification at <a href="mailto:support@beddy.io">support@beddy.io</a> to restore the service.<br><br>
                    The Beddy Team',
            ],
        ],
        'api_partner_disabled' => [
            'subject' => 'Beddy - Important: API Account Deactivation Notice',
            'body' => 'Dear partner :apiPartnerName,<br>
            Your account has been deactivated due to too many requests received.<br>
            After reviewing your systems, please contact us at <a href="mailto:support@beddy.io">support@beddy.io</a> to restore your account.<br><br>
            The Beddy Team',
        ],
        'api_partner_disabled_test' => [
            'subject' => 'Beddy - Important: Possible API Account Deactivation Notice',
            'body' => 'Partner :apiPartnerName,<br>
             would have been disabled due to too many requests made to the service: :errorMessage.<br>',
        ],
        'channel_update_exclusion' => [
            'subject' => 'The portal has changed the restrictions on updates for the property',
            'summary' => 'Portal involved',
            'oldvalue' => 'Old value',
            'newvalue' => 'New value',
            'modified_value' => 'Modified value',
            'deleted_value' => 'Deleted value',
            'more_info' => 'This email was sent following the execution of the cron job to download new rooms',
            'they_have_been' => 'have been',
            'the_following_restrictions' => ' the following restrictions:',
            'edited' => 'edited',
            'new' => 'added',
            'removed' => 'removed',
            'price' => 'Price',
            'availability' => 'Availability',
            'room_barred' => 'Closure',
            'min_stay' => 'Minimum stay',
            'max_stay' => 'Maximum stay',
            'close_to_arrival' => 'Close to arrival',
            'close_to_departure' => 'Close to departure',
            'date_from' => 'Start date',
            'date_to' => 'End date',
            'type_change' => 'Type of change',
            '1' => 'enabled',
            '0' => 'disabled',
            'field_involved' => 'Field name involved',
            'rate' => 'For the rate ',
            'property' => 'property',
            'subject_short' => 'Restriction changes for: '
        ],
        'credit_card_view_blocked' => [
            'subject' => 'Beddy - Credit card view limit exceeded.',
            'body' => 'Dear customer,<br>we inform you that the card associated with booking <b>#:reference_number</b> or with one of its related payments has reached the maximum number of allowed views. As a result, access to this card has been <b>temporarily blocked</b>.
    <br><br>If you wish to increase the view limit or receive more information, please contact support at <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
    The Beddy team<br><br>',
        ],
        'credit_card_view_notify' => [
            'subject' => 'Beddy - Credit Card Data Access Notification - Reservation #:reservation_reference',
            'body' => 'Dear Customer,<br>The credit card data related to reservation #<b>:reservation_reference</b> from channel <b>:channel_name</b> has been viewed.
    <br><br>
    Event details:
    <ul>
      <li>Operator: <b>:user_first_name :user_last_name</b> (<b>:user_email</b>)</li>
      <li>Date and time: <b>:event_date</b> <b>:event_hour</b></li>
      <li>IP: <b>:ip_address</b></li>
    </ul>
    This notification is generated as a security and access tracking measure for sensitive data.<br><br>
    The Beddy Team<br><br>',
        ],
        'user_created_notify' => [
            'subject' => 'Beddy - New user created for property :property_name',
            'bodySection1' => 'Dear Customer,<br>a new user <b>:user_first_name :user_last_name (:user_email)</b> has just been created for property <b>:property_name</b>.
        <br><br>
        Event details:
        <ul>
          <li>Operator: <b>:author_first_name :author_last_name</b> (<b>:author_email</b>)</li>
          <li>Date and time: <b>:event_date</b> <b>:event_hour</b></li>
          <li>IP: <b>:ip_address</b></li>
        </ul>
        If you do not recognize this operation, you can deactivate the new user.',
            'buttonText' => 'Deactivate user',
            'bodySection2' => 'This notification is generated as a security measure and for tracking access to sensitive data.<br><br>
        The Beddy team<br><br>'
        ],

    ],
    'export' => [
        'providers' => [
            'customers' => 'Customers',
            'companies' => 'Companies',
            'reservations' => 'Reservations',
            'social_archive' => 'Unlockable Offer Customers',
            'reservation_quotes' => 'Quotes',
            'cash_desk' => 'Cash Desk',
            'fees' => 'Fees',
            'cash_desk_closure' => 'Cash Desk Closure',
            'production_stats' => 'Production Statistics',
            'sales_stats' => 'Sales Statistics',
            'invoices' => 'Fiscal Documents',
            'invoices_received' => 'Received Fiscal Documents',
            'payments_timetable' => 'Payment Schedule',
            'properties' => 'Properties',
            'deposits' => 'Advances and deposits',
            'reservations_guests_presences' => 'Guests in house',
        ],
        'translations' => [
            'export_format' => 'Export Format',
        ],
        'errors' => [
            'service_not_active' => 'The requested export service is not active for the selected properties.',
            'method_not_found' => 'The method :methodName is not implemented within the class :className.',
            'export_provider_not_found' => 'Export Provider not found.',
        ],
        'warnings' => [
            'service_not_active' => 'The requested export service is not active for the property :propertyName.',
            'export_inserted' => 'Export successfully added. You will receive a notification when the process is complete.',
        ],
    ],
    'external_services' => [
        'urmet_sclak' => [
            'one_time' => 'Validità chiave',
            'confirm_required' => 'Il gestore dovrà autorizzare ogni accesso con l\'app Sclak',
            'app_enabled' => 'Abilita utilizzo APP (se NO sarà abilitato ad usare solo il tastierino numerico)',
            'generate_keypad_pin' => 'Genera il PIN da inviare per l\'apertura con il tastierino numerico (scegliere SI solo se nella struttura sono 
            presenti i tastierini per accedere)',
            'push_notify_enabled' => 'Ricevi una notifica push sullo smartphone ogni volta che il tuo ospite accede',
            'security_level' => 'L\'ospite deve essere collegato ad internet',
            'instant_key' => 'Registrazione ospite opzionale',
            'purchase_type' => 'Chi paga la chiave?',
            'send_sms' => 'Send the key to the customer via automatic SMS from Sclack',
            'sms_text_main' => 'Hi, below are the instructions for obtaining the keys to access the facility.
            - INSTALL Sclak APP: http://app.sclak.com/download',
            'sms_text_app_code' => '
            - ACTIVATE KEY: https://key.sclak.com/a/:app_key_code',
            'sms_text_pin_code' => '
            - The PIN code of the keyboard is: :pin_code\'',
            'all_booking_duration' => 'For the whole stay',
            'only_one' => 'Just once',
            'property' => 'The property',
            'guest' => 'The guest',
            'door_app_code' => 'APP Activation Code',
            'door_link_code' => 'APP Activation Link',
            'app_activation_code' => 'APP Activation Code :accommodation_name (:accommodation_label): :key_code',
            'app_activation_code_log' => ':key_code',
            'door_key_code' => 'Door Code',
            'checkin_hour' => 'Check-in time (the key to access will be valid only from the chosen check-in time)',
            'checkout_hour' => 'Check-out time Check-in time (the key to access will be valid only from the selected check-in time)',
            'room_not_mapped' => 'Accommodation :accommodation_name - :tableau_number not associated on Sclak',
        ],
        'nuki' => [
            'property' => 'The property',
            'guest' => 'The guest',
            'door_key_code' => 'Door code',
            'checkin_hour' => 'Check-in time (the access key will only be valid from the selected check-in time)',
            'checkout_hour' => 'Check-out time (the access key will be valid until the selected check-out time)',
            'room_not_mapped' => 'Room :accommodation_name - :tableau_number not mapped on Nuki',
            'code' => 'Door PIN :accommodation_name (:accommodation_label): :key_code',
            'email_address_not_found' => 'Email address not found, please add an email address in the booking to send the invitation for Nuki access',
            'generate_keypad_pin' => 'Generate the PIN to send for keypad access (choose YES only if keypads are available in the property)',
            'sent_with_app' => 'Sent via Nuki APP',
            'authorization_not_found' => 'You are trying to modify a non-existent code, generate a new door code',
            'multi_port_management' => 'Allow the generation of the same pin to open multiple doors (e.g. entrance gate and room); you can later associate which doors to link',
            'device_not_configured' => 'No Nuki device found or configured for link-based opening'
        ],
        'errors' => [
            'service_not_active' => 'External service not active',
            'scheduler_not_supported' => 'The External service :external_service_name does not support the automatic scheduling functionality',
        ],
        'warnings' => [
            'manual_code_detected' => 'Manually entered room codes have been detected, it is not possible to associate the manual ones with remote devices, you should therefore delete them manually',
        ],
        'key_door_services' => [
            'key_door_related' => 'this code will also open the following devices: :devices_name',
        ],
        'gt_revenue' => [
            'spreadsheet_type' => 'Revenue export criteria',
            'spreadsheet_type_segments' => 'Segments',
            'spreadsheet_type_rooms' => 'Rooms',
            'date_from' => 'Start date for export',
            'date_to' => 'End date for export',
            'period' => 'Period of export',
        ],
        'pa_friuli' => [
            'year_type' => 'Select the year to export',
            'year_type_previous' => 'Previous year (:year)',
            'year_type_current' => 'Current year (:year)',
        ],
    ],
    'fees' => [
        'deferred' => 'Deferred VAT',
        'payment_split' => 'Payment split',
        'immediate' => 'Immediate VAT',
        'export_fields' => [
            'date' => 'Date',
            'document_type' => 'Document type',
            'document_number' => 'Document number',
            'total_taxable' => 'Total taxable',
            'total_taxation' => 'Total VAT',
            'total_documents' => 'Total document',
            'customer_name' => 'Customer name',
            'customer_type' => 'Customer type',
            'documents' => 'Documents',
            'total_nets' => 'Total taxable',
            'total_taxes' => 'Total VAT',
            'documents_total' => 'Total documents',
        ],
        'net' => 'Net',
        'tax' => 'VAT',
        'sheets_name' => [
            'rows' => 'Receivables',
            'summary' => 'Summary',
        ],
    ],
    'fiscal_printer' => [
        'not_collected' => 'Not collected',
        'electronic' => 'Credit card',
        'not_collected_follows_invoice' => 'Not collected follows invoice',
    ],
    'gdpr' => [
        'privacy' => [
            'title' => '',
            'header' => '<p><strong>PRIVACY POLICY</strong></p>
            <p><strong>on the processing of personal data</strong></p>
            <p>Arts. 12 et seq of Regulation (EU) 2016/679 (GDPR)</p>
            <p>&nbsp;</p>
            <p><strong>FOREWORD </strong></p>
            <p>In compliance with the provisions of EU Regulation 2016/679 (hereinafter referred to as GDPR) we hereby provide information regarding the processing of personal data provided by the data subject, relating to the relationships with the Company. The information is provided pursuant to art. 13 GDPR.</p>
            <p>&nbsp;</p>
            <ol>
            <li><strong>IDENTITY AND CONTACT DETAILS</strong></li>
            </ol>
            <p>The Data Controller :property_name - :property_address (hereinafter the Company).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>
            <p>&nbsp;</p>
            <p>&nbsp;</p>',
            'default_body' => '<p>&nbsp;</p>
            <ol start="2">
            <li><strong>CONTACT DETAILS OF THE DATA PROTECTION OFFICER (DPO)</strong></li>
            </ol>
            <p>The Data Protection Officer is ________________, tel. ______________, e-mail: ______________.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="3">
            <li><strong>PURPOSE OF PROCESSING, LEGAL BASIS AND DATA STORAGE PERIOD</strong></li>
            </ol>
            <table width="680">
            <tbody>
            <tr>
            <td width="191">
            <p><strong><em>Purpose</em></strong></p>
            </td>
            <td width="135">
            <p><strong><em>Types of data that can be processed:</em></strong></p>
            </td>
            <td width="149">
            <p><strong><em>Legal basis</em></strong></p>
            </td>
            <td width="206">
            <p><strong><em>Storage period</em></strong></p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>a)&nbsp;&nbsp; </strong><strong><u>Service Delivery</u></strong></p>
            <p>Registration of the customer and then subsequently fulfilling legal obligations.</p>
            </td>
            <td width="135">
            <p>First Name, Last Name, Phone Number, Additional Requests, Address, ZIP Code, Province, Country, State and E-mail, Payment Information</p>
            </td>
            <td width="149">
            <p>Performance of a contract to which you are a party or pre-contractual measures taken at the request of the data subject;</p>
            <p>Fulfilment of legal obligations.</p>
            <p><em>&nbsp;</em></p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>The retention time is changeable as it is dictated by the difference between the time the reservation is made and the time the guest actually arrives at the facility.</p>
            <p>Encrypted payment information is retained up to 15days after the departure of the client\'s guest.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>b)&nbsp;&nbsp; </strong><strong><u>Request for quotation</u></strong></p>
            <p>Request for quotation with subsequent contact from the Data Controller</p>
            </td>
            <td width="135">
            <p>First name, last name, email and phone number</p>
            </td>
            <td width="149">
            <p>Pre-contractual measures taken at the request of the data subject</p>
            <p>&nbsp;</p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time it takes to process the request</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>c)&nbsp;&nbsp; </strong><strong><u>Newsletter</u></strong></p>
            <p>Sending newsletters, by automated means of contacting</p>
            </td>
            <td width="135">
            <p>Personal and contact data</p>
            </td>
            <td width="149">
            <p>Consent (required by contract or specific request);</p>
            <p>(optional and revocable at any time)</p>
            <p><em>Art. 6 co. 1 lett. a) GDPR.</em></p>
            </td>
            <td width="206">
            <p>Until consent for that purpose is withdrawn and/or five years have elapsed since the \'expression of consent.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>d)&nbsp; </strong>If necessary, to <strong>ascertain, exercise or defend the rights</strong> of the Joint Data Controllers in judicial proceedings</p>
            </td>
            <td width="135">
            <p>Personal data and contact details; data necessary for the execution of the contractual relationship.</p>
            </td>
            <td width="149">
            <p>Legitimate interest (judicial protection).</p>
            <p><em>Art. 6, paragraph 1 letter f) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time necessary to exercise rights in court.</p>
            </td>
            </tr>
            </tbody>
            </table>
            <p><strong>&nbsp;</strong></p>
            <ol start="4">
            <li><strong>OBLIGATORY NATURE OF PROVISION OF DATA</strong></li>
            </ol>
            <p>The data subject must provide necessary data for carrying out the contractual relationship to the Company, as well as the data necessary to fulfil the obligations provided for by laws, regulations, community standards, and by provisions of Authorities legitimated by law and by supervisory and control bodies (referred to in purposes a) and f) above).</p>
            <p>Data that are not essential for the performance of the contractual relationship are qualified and considered supplementary and their provision by the data subject, if requested, is optional and subject to consent. Consent provided may be withdrawn by the data subject at any time. Such withdrawal shall in no way affect the lawfulness of processing based on the consents given prior to withdrawal of consent.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong>PROCESSING METHODS</strong></li>
            </ol>
            <p>Personal data will be recorded, processed and stored in the Company&rsquo; archive, paper and electronic, in compliance with the appropriate technical and organizational measures referred to in Art. 32 of the GDPR. The processing of the data subject personal data may consist of any operation or set of operations described in Art. 4, paragraph 1, point 2 of the GDPR.</p>
            <p>Personal data will be processed using suitable tools and procedures that guarantee security and confidentiality. Such processing may be carried out directly and/or via delegated third parties, both manually using hard-copy support and electronically using IT equipment and other instruments. In order to manage properly the relationship and fulfilment of legal obligations, personal data may be entered in the internal documentation of the Company and, if necessary, in the documents and registers required by law.</p>
            <p>Your data may be processed by the employees of the departments of the Company assigned to the pursuit of the above-mentioned purposes. These employees have been expressly authorized to process the data and have received adequate operating instructions pursuant to and for the purposes of Art. 29 GDPR.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="6">
            <li><strong>CATEGORIES OF RECIPIENTS OF PERSONAL DATA</strong></li>
            </ol>
            <p>Personal data under purpose (a) are only disclosed to possible legal offices where required by law.</p>
            <p>Payment data is transmitted to payment service providers for completion of the transaction.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="7">
            <li><strong>DATA TRANSFER TO COUNTRIES OUTSIDE THE EU</strong></li>
            </ol>
            <p>The data provided by the data subject will only be processed countries within the European Union. If the personal data of the data subjects are processed in a country outside of the EU, the data subject&rsquo;s rights under EU legislation will be guaranteed and the data subject will be notified on a timely basis.</p>
            <p>&nbsp;</p>
            <ol start="8">
            <li><strong>RIGHTS OF THE DATA SUBJECT </strong></li>
            </ol>
            <p>Pursuant to Articles 15 et seq of the GDPR, the data subject may exercise the following rights:</p>
            <ol>
            <li>access: to obtain confirmation of whether or not the personal data of the data subject are being processed and the right to access them; requests that are manifestly unfounded, excessive or repetitive cannot be answered;</li>
            <li>rectification: to correct/obtain the correction of personal data if incorrect or outdated and to complete data if incomplete;</li>
            <li>erasure/to be forgotten in some cases, to obtain the erasure of the personal data provided; this is not an absolute right, as the Company may have legitimate or legal reasons to store them;</li>
            <li>limitation: the data will be stored, but cannot be processed further, in the cases foreseen by the regulation;</li>
            <li>portability: to move, copy or transfer data from the Company&rsquo; databases to third parties. This applies only to data provided by the data subject for the performance of a contract or for which express consent has been given and the processing is carried out by automated means;</li>
            <li>objection to direct marketing;</li>
            <li>withdraw of the consent at any time if processing is based on consent.</li>
            </ol>
            <p>Pursuant to Art. 2-<em>undicies</em> of Legislative Decree 196/2003, the exercise of data subjects rights may be delayed, restricted or excluded, following justification provided without delay, unless this might compromise the purpose of the restriction, for as long as and to the extent that this constitutes a necessary and proportionate measure, taking into account the fundamental rights and legitimate interests of the data subject, in order to safeguard the interests referred to in paragraph 1, letters a) (protected interests with regard to money laundering), e) (for the conduct of defensive investigations or the exercise of a right in court) and f) (for the confidentiality of the identity of the employee who reports offenses he becomes aware of on his duties). In such cases, data subjects&rsquo; rights may also be exercised through the Personal Data Protection Authority in the manner referred to in Article 160 of said Decree. In such case, the Personal Data Protection Authority will inform the data subject that it has carried out all the necessary checks or that it has carried out a review, as well as of the data subject right to take legal action.</p>
            <p>&nbsp;</p>
            <p>It should also be noted that - before processing the requests - the Company may ascertain the identity of the data subject, in order to evaluate the legitimacy of the same.</p>
            <p>&nbsp;</p>
            <p>To exercise these rights, the data subject may contact the Data Controller at the addresses indicated in section 1 of this document. The Company will respond within 30 days of receiving the data subject formal request.</p>
            <p>If the abovementioned rights concerning data subject personal data are infringed, the latest may complain to the competent authority.</p>
            <p>&nbsp;</p>
            <p><strong>&nbsp;</strong></p>
            <p><strong>THE DATA</strong></p>
            <p><strong>CONTROLLER</strong></p>',
        ],
        'cookie' => [
            'title' => '',
            'header' => '<p><strong>Cookie Policy of :property_name</strong></p>
            <ol>
            <li><strong>Data Controller</strong></li>
            </ol>
            <p>The Data Controller is :property_name - :property_address (hereinafter the Company or the Owner).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>',
            'default_body' => '<p>Since the use of third-party Trackers through this Website cannot be fully controlled by the Owner, any specific references to third-party Trackers are to be considered indicative. In order to obtain complete information, Users are kindly requested to consult the privacy policies of the respective third-party services listed in this document.</p>
            <p>Given the objective complexity surrounding tracking technologies, Users are encouraged to contact the Owner should they wish to receive any further information on the use of such technologies by this Website.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="2">
            <li><strong>Foreword </strong></li>
            </ol>
            <p>This document informs Users about the technologies that help this Website to achieve the purposes described below. Such technologies allow the Owner to access and store information (for example by using a Cookie) or use resources (for example by running a script) on a User&rsquo;s device as they interact with this Website.</p>
            <p>For simplicity, all such technologies are defined as "Trackers" within this document &ndash; unless there is a reason to differentiate.</p>
            <p>For example, while Cookies can be used on both web and mobile browsers, it would be inaccurate to talk about Cookies in the context of mobile apps as they are a browser-based Tracker. For this reason, within this document, the term Cookies is only used where it is specifically meant to indicate that particular type of Tracker.</p>
            <p>Some of the purposes for which Trackers are used may also require the User\'s consent. Whenever consent is given, it can be freely withdrawn at any time following the instructions provided in this document.</p>
            <p>This Website uses Trackers managed directly by the Owner (so-called &ldquo;first-party&rdquo; Trackers) and Trackers that enable services provided by a third-party (so-called &ldquo;third-party&rdquo; Trackers). Unless otherwise specified within this document, third-party providers may access the Trackers managed by them.</p>
            <p>The validity and expiration periods of Cookies and other similar Trackers may vary depending on the lifetime set by the Owner or the relevant provider. Some of them expire upon termination of the User&rsquo;s browsing session.</p>
            <p>In addition to what&rsquo;s specified in the descriptions within each of the categories below, Users may find more precise and updated information regarding lifetime specification as well as any other relevant information &ndash; such as the presence of other Trackers - in the linked privacy policies of the respective third-party providers or by contacting the Owner.</p>
            <p>&nbsp;</p>
            <ol start="3">
            <li><strong> Activities strictly necessary for the operation of this Website and delivery of the Service</strong></li>
            </ol>
            <p>This Website uses so-called &ldquo;technical&rdquo; Cookies and other similar Trackers to carry out activities that are strictly necessary for the operation or delivery of the Service.</p>
            <p><strong>3.1 Third-party Trackers</strong></p>
            <p><strong>3.1.1 Tag Management</strong></p>
            <p>This type of service helps the Owner to manage the tags or scripts needed on this Website in a centralized fashion.</p>
            <p>This results in the Users\' Data flowing through these services, potentially resulting in the retention of this Data.</p>
            <p><strong>3.1.1.1 Google Tag Manager (Google Ireland Limited)</strong></p>
            <p>Google Tag Manager is a tag management service provided by Google Ireland Limited.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Irlanda &ndash; <a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p><strong>3.1.2 Handling payments</strong></p>
            <p>Se non diversamente specificato, questo Sito Web elabora i pagamenti con carta di credito tramite fornitori esterni di servizi di pagamento. In generale, e salvo diversa indicazione, gli Utenti sono pregati di fornire i dettagli di pagamento e le informazioni personali direttamente a tali fornitori di servizi di pagamento.</p>
            <p>Questo Sito Web non &egrave; coinvolto nella raccolta e nell\'elaborazione di tali informazioni: ricever&agrave; invece solo una notifica da parte del fornitore di servizi di pagamento in questione circa l\'avvenuto pagamento.</p>
            <p>Unless otherwise specified, this Website processes payments by credit card via external payment service providers. In general and unless where otherwise stated, Users are requested to provide their payment details and personal information directly to such payment service providers.</p>
            <p>This Website isn\'t involved in the collection and processing of such information: instead, it will only receive a notification by the relevant payment service provider as to whether payment has been successfully completed.</p>
            <p><strong>3.1.2.1 Stripe (Stripe Technology Europe Ltd)</strong></p>
            <p>Stripe is a payment service provided by Stripe Technology Europe, Limited.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://stripe.com/ie/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__stripe_mid: 1 year</li>
            <li>__stripe_sid: 30 minutes</li>
            <li>m: 2 years</li>
            </ul>
            <p><strong>3.1.2.2 PayPal (Paypal)</strong></p>
            <p>PayPal is a payment service provided by PayPal Inc., which allows Users to make online payments.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: See the PayPal privacy policy &ndash;&nbsp;<a href="https://www.paypal.com/webapps/mpp/ua/privacy-full">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__paypal_storage__: indefinite</li>
            <li>akavpau_ppsd: duration of the session</li>
            <li>enforce_policy: duration of the session</li>
            <li>l7_az: duration of the session</li>
            <li>nsid: duration of the session</li>
            <li>ts: duration of the session</li>
            <li>tsrce: duration of the session</li>
            <li>x-cdn: duration of the session</li>
            <li>x-pp-s: duration of the session</li>
            </ul>
            <p>&nbsp;</p>
            <ol start="4">
            <li><strong> Other activities involving the use of Trackers</strong></li>
            </ol>
            <p><strong>4.1 Measurement</strong></p>
            <p>This Website uses Trackers to measure traffic and analyze User behavior with the goal of improving the Service.</p>
            <p><strong>4.1.1 Analytics</strong></p>
            <p>The services contained in this section enable the Owner to monitor and analyze web traffic and can be used to keep track of User behavior.</p>
            <p><strong>4.1.1.1 Google Analytics 4 (Google Ireland Limited)</strong></p>
            <p>Google Analytics 4 is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.<br /> In Google Analytics 4, IP addresses are used at collection time and then discarded before Data is logged in any data center or server. Users can learn more by consulting&nbsp;<a href="https://support.google.com/analytics/answer/12017362?hl=en&amp;ref_topic=2919631">Google&rsquo;s official documentation</a>.</p>
            <p>Personal Data processed: browser information, city, device information, latitude (of city), longitude (of city), number of Users, session statistics, Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_ga: 2 years</li>
            <li>_ga_*: 2 years</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.2 Google Analytics (Google Ireland Limited)</strong></p>
            <p>Google Analytics is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>AMP_TOKEN: 1 hour</li>
            <li>_ga: 2 years</li>
            <li>_gac*: 3 months</li>
            <li>_gat: 1 minute</li>
            <li>_gid: 1 day</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Facebook Ads conversion tracking (Facebook pixel) (Meta Platforms Ireland Limited)</strong></p>
            <p>Facebook Ads conversion tracking (Meta pixel) is an analytics service provided by Meta Platforms Ireland Limited that connects data from the Meta Audience Network with actions performed on this Website. The Meta pixel tracks conversions that can be attributed to ads on Facebook, Instagram and Meta Audience Network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://www.facebook.com/about/privacy/">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_fbp: 3 months</li>
            <li>fr: 3 months</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Google Ads conversion tracking (Google Ireland Limited)</strong></p>
            <p>Google Ads conversion tracking is an analytics service provided by Google Ireland Limited that connects data from the Google Ads advertising network with actions performed on this Website.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>IDE: 2 years</li>
            <li>test_cookie: 15 minutes</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.2 Marketing</strong></p>
            <p><strong>4.1.2.1. Userguest</strong></p>
            <p>This service allows the user to be shown personalized ads on this website, based on previous visits to this website.</p>
            <p>It does not collect personal data.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong> How to manage preferences and provide or withdraw consent</strong></li>
            </ol>
            <p>There are various ways to manage Tracker related preferences and to provide and withdraw consent, where relevant:</p>
            <p>Users can manage preferences related to Trackers from directly within their own device settings, for example, by preventing the use or storage of Trackers.</p>
            <p>Additionally, whenever the use of Trackers is based on consent, Users can provide or withdraw such consent by setting their preferences within the cookie notice or by updating such preferences accordingly via the relevant consent-preferences widget, if available.</p>
            <p>It is also possible, via relevant browser or device features, to delete previously stored Trackers, including those used to remember the User&rsquo;s initial consent.</p>
            <p>Other Trackers in the browser&rsquo;s local memory may be cleared by deleting the browsing history.</p>
            <p>With regard to any third-party Trackers, Users can manage their preferences and withdraw their consent via the related opt-out link (where provided), by using the means indicated in the third party\'s privacy policy, or by contacting the third party.</p>
            <p><strong>5.1 Locating Tracker Settings</strong></p>
            <p>Users can, for example, find information about how to manage Cookies in the most commonly used browsers at the following addresses:</p>
            <ul>
            <li><a href="https://support.google.com/chrome/answer/95647?hl=en&amp;p=cpn_cookies">Google Chrome</a></li>
            <li><a href="https://support.mozilla.org/en-US/kb/enable-and-disable-cookies-website-preferences">Mozilla Firefox</a></li>
            <li><a href="https://support.apple.com/guide/safari/manage-cookies-and-website-data-sfri11471/">Apple Safari</a></li>
            <li><a href="http://windows.microsoft.com/en-us/windows-vista/block-or-allow-cookies">Microsoft Internet Explorer</a></li>
            <li><a href="https://support.microsoft.com/en-us/help/4027947">Microsoft Edge</a></li>
            <li><a href="https://support.brave.com/hc/en-us/articles/360022806212-How-do-I-use-Shields-while-browsing">Brave</a></li>
            <li><a href="https://help.opera.com/en/latest/web-preferences/#cookies">Opera</a></li>
            </ul>
            <p>Users may also manage certain categories of Trackers used on mobile apps by opting out through relevant device settings such as the device advertising settings for mobile devices, or tracking settings in general (Users may open the device settings and look for the relevant setting).</p>
            <p><strong>5.2 </strong><strong>Consequences of denying consent</strong></p>
            <p>Users are free to decide whether or not to grant consent. However, please note that Trackers help this Website to provide a better experience and advanced functionalities to Users (in line with the purposes outlined in this document). Therefore, in the absence of the User\'s consent, the Owner may be unable to provide related features.</p>
            <ol start="6">
            <li><strong> Definitions and legal references</strong></li>
            </ol>
            <p><strong>Personal Data (or Data)</strong></p>
            <p>Any information that directly, indirectly, or in connection with other information &mdash; including a personal identification number &mdash; allows for the identification or identifiability of a natural person.</p>
            <p><strong>Usage Data</strong></p>
            <p>Information collected automatically through this Website (or third-party services employed in this Website), which can include: the IP addresses or domain names of the computers utilized by the Users who use this Website, the URI addresses (Uniform Resource Identifier), the time of the request, the method utilized to submit the request to the server, the size of the file received in response, the numerical code indicating the status of the server\'s answer (successful outcome, error, etc.), the country of origin, the features of the browser and the operating system utilized by the User, the various time details per visit (e.g., the time spent on each page within the Application) and the details about the path followed within the Application with special reference to the sequence of pages visited, and other parameters about the device operating system and/or the User\'s IT environment.</p>
            <p><strong>User</strong></p>
            <p>The individual using this Website who, unless otherwise specified, coincides with the Data Subject.</p>
            <p><strong>Data Subject</strong></p>
            <p>The natural person to whom the Personal Data refers.</p>
            <p><strong>Data Processor (or Data Supervisor)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which processes Personal Data on behalf of the Controller, as described in this privacy policy.</p>
            <p><strong>Data Controller (or Owner)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which, alone or jointly with others, determines the purposes and means of the processing of Personal Data, including the security measures concerning the operation and use of this Website. The Data Controller, unless otherwise specified, is the Owner of this Website.</p>
            <p><strong>This Website (or this Application)</strong></p>
            <p>The means by which the Personal Data of the User is collected and processed.</p>
            <p><strong>Service</strong></p>
            <p>The service provided by this Website as described in the relative terms (if available) and on this site/application.</p>
            <p><strong>European Union (or EU)</strong></p>
            <p>Unless otherwise specified, all references made within this document to the European Union include all current member states to the European Union and the European Economic Area.</p>
            <p><strong>Cookie</strong></p>
            <p>Cookies are Trackers consisting of small sets of data stored in the User\'s browser.</p>
            <p><strong>Tracker</strong></p>
            <p>Tracker indicates any technology - e.g Cookies, unique identifiers, web beacons, embedded scripts, e-tags and fingerprinting - that enables the tracking of Users, for example by accessing or storing information on the User&rsquo;s device.</p>
            <p><strong>Legal information</strong></p>
            <p>This privacy statement has been prepared based on provisions of multiple legislations, including Art. 13/14 of Regulation (EU) 2016/679 (General Data Protection Regulation).</p>
            <p>This policy relates solely to this Website, if not stated otherwise within this document.</p>
            <p>&nbsp;</p>',
        ],
    ],
    'general' => [
        'accommodation_not_found' => 'accommodation not found',
        'channel_unsupported_function' => 'This channel doesn\'t support this function',
        'rateplan_not_found' => 'rate plan not found',
        'accommodations' => 'Accommodations',
        'unknown' => 'unknown',
        'unauthorized' => 'not authorized',
        'expired_password' => 'Your password has expired. Please reset it to continue.',
        'not_found' => 'Not found',
        'not_found_or_not_authorized' => 'Resource not found or authorization denied',
        'no_relationship_found' => 'no relation found',
        'existing_periods' => 'there are overlaid values',
        'existing_condition' => 'already existing condition',
        'missing_accommodation_rateplan' => 'Rate plan linked to a missing accommodation',
        'missing_accommodation_channel_source' => 'Missing source channel accommodation',
        'missing_accommodation_channel_destination' => 'Missing destination channel accommodation',
        'missing_accommodation_channel' => 'Channel accommodation missing',
        'missing_treatment_or_rateplan' => 'Treatment or Rateplan not set for this accommodation',
        'same_source_destination' => 'Coincident source and destination',
        'impossible_delete_addon_category' => 'Impossible delete extra services category if not connected yet',
        'impossible_delete_system_addon_category' => 'Impossible modify or delete system extra services category',
        'property_xml_already_connected' => 'PropertyXml is already connected to another property',
        'city_tax' => 'City Tax',
        'taxs' => 'Taxes',
        'virtual_stamp' => 'Virtual Stamp',
        'default_group' => 'Default Group',
        'existing_mail' => 'Existing Email',
        'unique_mail' => 'Unique Email',
        'existing_username' => 'Existing Username',
        'unique_username' => 'Unique Username',
        'resource_conflict' => 'Conflict in Selected Resource',
        'special_requests' => 'Special Requests',
        'name' => 'Name',
        'surname' => 'Surname',
        'and' => 'and',
        'arrival' => 'Arrival',
        'clean_fees' => 'Cleaning Costs',
        'departure' => 'Departure',
        'adults' => 'Adults',
        'adult' => 'Adult',
        'children' => 'Children',
        'child' => 'Child',
        'eta' => 'Age',
        'male' => 'Male',
        'female' => 'Female',
        'customer' => 'Customer',
        'company' => 'Company',
        'telephone' => 'Phone',
        'email' => 'Email',
        'nationality' => 'Nationality',
        'too_many_login_attemps' => 'Too many failed attempts. You can try again in :minute_unthrottle minutes',
        'country' => 'Country',
        'coupon' => 'Coupon',
        'from' => 'From',
        'to' => 'To',
        'nights' => 'Nights',
        'payment_status' => 'Payment Status',
        'total' => 'Total',
        'reservation' => 'Reservation',
        'quote' => 'Quote',
        'di' => 'of',
        'stay' => 'Stay',
        'extra' => 'Extra',
        'tax' => 'Tax',
        'payment' => 'Payments',
        'del' => 'of',
        'channel' => 'Channel',
        'lodging' => 'Accommodations',
        'treatment' => 'Treatment',
        'accommodations_reserved' => 'Reserved Accommodations',
        'option_status_export' => 'Status Export',
        'option_revenue' => 'Revenue Data',
        'option_time' => 'Export Time',
        'guest_card_service_not_connected' => 'Service not linked to the property or incorrect type',
        'guest_card_guests_number_error' => 'Insufficient number of guests',
        'guest_card_date_from_error' => 'Modifications not allowed. The validity start date is prior to today.',
        'imp' => 'Imp',
        'iva' => 'VAT',
        'type' => 'Type',
        'documents' => 'Documents',
        'generic_payment' => 'Generic Payment',
        'accommodation' => 'Room',
        'accommodation_name' => 'Accommodation',
        'accommodation_total' => 'Accommodation Total',
        'error' => 'Error',
        'status' => 'Status',
        'language' => 'Language',
        'guests' => 'Guests',
        'guest' => 'Guest',
        'paid' => 'Paid',
        'to_pay' => 'To Pay',
        'suspended' => 'Suspended',
        'to_be_invoiced' => 'To Be Invoiced',
        'note' => 'Notes',
        'note_internal' => 'Booking Notes',
        'note_internal_accommodation' => 'Internal Accommodation Notes',
        'note_customer' => 'Customer Requests',
        'note_checkin' => 'Check-in Notes',
        'note_checkout' => 'Check-out Notes',
        'note_housekeeper' => 'Housekeeper Notes',
        'note_catering' => 'Meal Notes',
        'note_bill' => 'Billing Notes',
        'bill_charged' => 'Billed Charge',
        'total_documents' => 'Total Documents',
        'checkin_online' => 'Online Check-In',
        'cancellation' => 'Cancellation',
        'no_show' => 'No-Show',
        'referral_id' => '#:referral_id:',
        'missing_param' => 'Missing parameter :param',
        'properties' => 'Properties',
        'amount' => 'Amount',
        'reservation_total' => 'Reservation Total',
        'total_paid' => 'Total Paid',
        'total_to_pay' => 'Total to Pay',
        'general_error' => 'General Error',
        'module_not_active' => 'The module :moduleName is not active for the following properties:',
        'reservation_summary' => 'Reservation Summary',
        'department_not_faund' => 'Department Not Found',
        'department_exist' => 'You cannot delete a department already associated with the fiscal printer',
        'upload_virus_found' => 'The uploaded file appears corrupted or malicious',
        'upload_antivirus_service' => 'Unable to upload the file, please try again later or contact support',
        'document' => '{1} Document|[2,*] Documents',
        'reservation_to_queue_from_cart' => 'Processing the reservation, you will receive a notification upon completion.',
        'active' => 'Active',
        'expired' => 'Expired',
        'export' => 'Export',
        'send_data' => 'Send Data',
        'missing_credentials' => 'Missing Username or Password',
        'yes' => 'Yes',
        'no' => 'No',
        'door_key_codes' => 'Door Code',
        'external_door_link' => 'External door opening link',
        'accommodation_door_key_codes' => 'Accommodation door key code :accommodationTableauLabel',
        'city_tax_report' => [
            'errors' => [
                'filter_not_available' => 'Filter not available',
                'filter_format' => 'Filter format not accepted',
                'filter_number_arguments_exceeded' => 'Number of arguments for filter not accepted',
            ],
        ],
        'fields' => [
            'field_update' => 'the field :field from :oldValue to :newValue',
            'guest_type_id' => 'guest type',
            'city_tax_exemption_id' => 'city tax exemption',
            'main_guest' => 'main guest',
            'arrival_date' => 'arrival date',
            'departure_date' => 'departure date',
            'roomreservation_id' => 'room',
            'checkin' => 'check-in',
            'checkout' => 'check-out',
            'enabled' => 'enabled',
            'disabled' => 'disabled',
            'undefined' => 'undefined',
            'deleting' => 'Deleted:',
            'update_guest' => 'For guest :name :surname (:id), the following were modified: :fields',
            'delete_guest' => 'Guest :name :surname (:id) :invoiced_city_tax',
            'invoiced_city_tax' => 'with city tax invoiced',
            'arrival_lunch' => 'arrival for lunch',
            'arrival_dinner' => 'arrival for dinner',
            'arrival_not_set' => 'no preference',
        ],
        'exceptions' => [
            'impossible_to_get_conversation_references' => 'Unable to retrieve conversation information',
            'ota_channel_message_not_supported' => 'The specified channel does not support messaging functionality',
            'recipient_has_not_configured_email_address' => 'Recipient has not configured any email address',
            'impossible_to_resend_not_failed_message' => 'Unable to resend a message that has not failed',
            'impossible_to_delete_this_message' => 'Unable to delete this message',
            'message_not_valid' => 'The following fields are invalid:',
            'newsletter_config_not_valid' => 'The following configuration fields are invalid:',
            'newsletter_not_valid' => 'The following newsletter fields are invalid:',
            'newsletter_default_mail_not_valid' => 'The following default email fields are invalid:',
            'newsletter_condition_not_valid' => 'The following fields for the list condition are invalid:',
            'message_alredy_exists' => 'Message already exists',
            'some_uploaded_files_are_unsupported' => 'Some uploaded files are unsupported',
            'attachments_not_permitted_for_channel' => 'Attachments are not allowed for this communication channel',
            'uploaded_too_many_images' => 'You can send only one image per message',
            'you_cannot_send_message_that_contains_email_addresses' => 'You cannot send a message containing email addresses',
            'you_cannot_send_message_that_contains_url' => 'You cannot send a message containing URLs',
            'you_cannot_send_message_that_contains_phone_number' => 'You cannot send a message containing phone numbers',
            'you_cannot_receive_message_without_reservation_type' => 'You cannot receive messages without a reservation',
            'impossible_to_set_message_read_status' => 'Unable to update message read status',
            'gt_revenue_not_valid' => 'The following parameters for GT Revenue export are invalid:',
            'export_not_valid' => 'The following parameters for generating the export are invalid:',
            'method_not_implemented' => 'The method :methodName in driver :driverName is not implemented',
            'temporary_disabled_action_move_guest' => 'The following action is temporarily disabled: proceed by deleting the guest and recreating it in the designated room',
            'batch_job_not_found' => 'Job not found',
            'impossible_invoke_method' => 'Unable to invoke this method',
        ],
        'conversation_messages' => [
            'participant_alredy_exists' => 'Participant already associated with the conversation',
            'placeholder_photo' => 'Photo',
        ],
    ],
    'guest_presence' => [
        'summary' => 'Guest presence summary',
        'daily_summary_of_date' => 'Daily summary for :date',
        'accommodation' => 'Accommodation',
        'accommodation_type' => 'Accommodation type',
        'name_and_surname' => 'First and last name',
        'age' => 'Age',
        'sex' => 'Gender',
        'stay' => 'Stay',
        'stay_status' => 'Status',
        'plan' => 'Floor',
        'property' => 'Property',
        'no_records' => 'No data to display',
        'date' => 'Date',
        'export_title' => 'Guest presence',
    ],
    'guest_reporting' => [
        'errors' => [
            'unable_to_delete_movements' => 'Unable to delete movements due to the following error: :error',
            'unable_to_send_movements' => 'Unable to send movements due to the following error: :error',
            'unable_to_check_movements_type' => 'Unable to verify the movement type due to the following error: :error',
            'movements_type_not_valid' => 'The movement type of the accommodation is not valid for this portal',
            'cannot_delete_movements' => 'Unable to delete movements because the submission date does not match the last submission date recorded by the portal',
            // toggler
            'generic_already_reported' => 'Item already exported',
            'reservation_already_reported' => 'Reservation :identifier already exported',
            'reservation_accommodation_already_reported' => 'Accommodation :identifier already exported',
            'reservation_accommodation_guest_already_reported' => 'Guest :identifier already exported',
            'reservation_accommodation_guest_not_sent' => 'Guest not sent',
            'reservation_accommodation_guest_can_not_delete' => 'Unable to delete guest as they are already part of a monthly closure',
            'reservation_accommodation_guest_missing' => 'Guest not found',
            // errors with summary for guest
            'place_code_missing' => 'Place code not available. Contact technical support.',
            'cannot_be_single_guest' => 'Invalid guest type: cannot be Single Guest.',
            'customer_has_incomplete_birth_place' => 'Incomplete or missing place of birth.',
            'customer_has_incomplete_document_data' => 'Incomplete or missing document data.',
            'customer_has_incomplete_residence' => 'Missing birth or residence place codes, contact support.',
            'customer_has_invalid_gender' => 'Gender not specified.',
            'customer_has_invalid_type' => 'Invalid guest type.',
            'customer_has_no_birth_date' => 'Missing date of birth.',
            'customer_birth_date_in_future' => 'Date of birth cannot be after today.',
            'customer_has_no_birth_city_country_place' => 'Missing birth city and country codes, contact support.',
            'customer_has_no_birth_place' => 'Incomplete or missing place of birth.',
            'customer_has_no_name' => 'Name missing.',
            'customer_has_no_nationality_or_has_null_code' => 'Missing citizenship.',
            'customer_has_no_residence_city_country_place' => 'Missing residence city and country codes, contact support.',
            'customer_has_no_residence_place' => 'Missing residence country code, contact support.',
            'customer_has_no_surname' => 'Surname missing.',
            'customer_has_no_data' => 'Complete all required fields.',
            'customer_has_not_present' => 'No guests registered in the reservation.',
            'some_customer_has_not_present' => ':customer_number guest data not entered|:customer_number guests data not entered',
            'guest_has_no_customer_data' => 'Complete all required fields.',
            'invalid_length_of_stay' => 'Invalid length of stay.',
            'invalid_row_size' => 'Invalid row size for accommodation. Contact technical support.',
            'invalid_value_size' => 'Invalid field length.',
            'invalid_surname_size' => 'Invalid surname length. Maximum of 50 characters allowed.',
            'invalid_name_size' => 'Invalid name length. Maximum of 30 characters allowed.',
            'invalid_document_number_size' => 'Invalid document number length. Maximum of 20 characters allowed.',
            'invalid_released_size' => 'Invalid document issue place length. Maximum of 9 characters allowed.',
            'must_be_single_guest' => 'Invalid guest type: must be Single Guest.',
            // errors with summary for grouping
            'customer_has_no_leader' => 'Leader or head of family is missing.',
            'family_leader_alone' => 'Head of family present without family members.',
            'family_member_alone' => 'Add a Head of Family.',
            'group_leader_alone' => 'Group leader present without members.',
            'group_member_alone' => 'Add a Group Leader.',
            'multiple_family_leaders' => 'Only one Head of Family allowed per accommodation.',
            'multiple_group_leaders' => 'Only one Group Leader allowed per reservation.',
            'invalid_group_leader_in_family' => 'Invalid Group Leader (Head of Family present).',
            'invalid_group_member_in_family' => 'Invalid Group Member (must be Family Member).',
            'invalid_family_leader_in_group' => 'Invalid Head of Family (Group Leader present).',
            'invalid_family_member_in_group' => 'Invalid Family Member (must be Group Member).',
            'room_has_no_family_leader' => 'Add a Head of Family.',
            'room_has_many_leaders' => 'Only one Head of Family allowed per accommodation.',
            'room_has_no_family_members' => 'Head of Family present without family members.',
            // other errors
            'no_exportable_guests' => 'No data to export.',
            'no_istat_module_configured' => 'Istat group not configured.',
            'rooms_number_overflow' => 'The number of occupied accommodations exceeds the maximum number configured in the portal. Check the information under Configuration > Istat.',
            'unmapped_tableau_number' => 'Accommodation without mapping. Verify configuration in the accommodations group.',
            'no_tableau_number' => 'No accommodation associated on date: :date',
            'unexpected_date' => 'Expected export date is :date. Change the export date.',
            'unexpected_send_date' => 'Expected send date is :date. Change the send date.',
            'empty_italian_birth_city_code' => 'Birth city code not found. Contact technical support.',
            'empty_italian_birth_county_abbreviation' => 'Birth province code not found. Contact technical support.',
            'empty_italian_residence_city_code' => 'Residence city code not found. Contact technical support.',
            'empty_italian_residence_county_abbreviation' => 'Residence province code not found. Contact technical support.',
            // Sicilia-specific errors
            'guest_validation_failed' => 'Sicilian Tourism Observatory cannot validate guest :name.',
            'sync_failed' => 'Attempting to send data or modifications for reservations manually deleted from the Sicilian Tourism Observatory portal. Disable the sending of the canceled reservation or retry.',
            // Turismo5/Sicilia-specific errors
            'uncaught_forbidden' => 'Incorrect credentials or property code. Verify the data.',
            // AlloggiatiWeb-specific error
            'wrong_username_password_wskey' => 'Incorrect Username, Password, or WsKey',
            'generic_error' => 'The portal did not respond correctly. Try again later.',
            'generic_error_send' => 'The portal did not respond correctly. Try again later.',
            'missing_istat_code' => 'Istat code not found for the place: :placeName. Please contact technical support.',
            'alloggiatiweb_error_owner_apartment' => 'Apartment codes must be used for this account. Enable the configuration under Configuration > Alloggiati Web.',
            'alloggiatiweb_error_owner_hotel' => 'Apartment codes cannot be used for this account. Disable the configuration under Configuration > Alloggiati Web.',
            'sicilia_web_service_outcome_empty_response' => 'The portal did not respond correctly. Try again later.',
            'istat_the_portal_not_responding' => 'The portal did not respond correctly. Try again later.',
            'istat_exemption_not_valid' => 'Exemption not supported by ABIT.',
        ],
        'success' => [
            'upload_recordset_completed' => 'Upload completed successfully.',
        ],
        'webservice' => [
            'service_unavailable' => 'Service unavailable or incorrectly configured.',
        ],
        'fields' => [
            'date_to_send' => 'Send Date',
            'date_to_export' => 'Export Date',
            'current_date' => 'Current Date',
            'last_sent_day' => 'Last Export Date',
            'use_progression' => 'Progression to use',
            'is_auto' => 'Send Type',
            'is_auto_description' => 'Automatic/Manual Sending',
            'reference_date' => 'Reference Date for Search',
            'operation_code_label' => 'Operation Code',
            'operation_code_description' => 'Identifies the send operation',
            'do_not_update_current_day_label' => 'Do not update the current day',
            'do_not_update_current_day_description' => 'When Istat is sent, the current day is not incremented',
            'hotel_code' => 'Property Code',
            'property_list' => 'Property List',
            'get_property_code' => 'Retrieve Property Code',
            'username' => 'Username',
            'password' => 'Password',
            'declared_available_rooms' => 'Number of accommodations actually available for sale',
            'declared_available_beds' => 'Number of beds actually available for sale',
            'guest_id' => 'Guest ID',
            'guest_id_description' => 'ID of the guest to delete',
            'delete_movements_flag' => 'Confirmation of movements deletion',
            'delete_movements_flag_description' => 'Flag indicating whether to proceed with deleting the movements',
            'delete_movements_not_confirmed' => 'Are you sure you want to delete the movements starting from this date? This action is irreversible.',
            'ricestat' => [
                // Ricestat custom translations
                'username' => 'Ricestat Username',
            ],
            'sicilia' => [
                // Sicilian Tourism Observatory custom translations
                'username' => 'Tourism Observatory UserID',
                'hotel_code' => 'Hotel Code provided at registration (if different from username)',
            ],
            'sired' => [
                // Sired custom translations
                'declared_available_rooms' => 'Total accommodations potentially available for sale (declared on the Portal)',
                'declared_available_beds' => 'Number of available beds (declared on the Portal)',
            ],
            'turismo5' => [
                // Turismo5 custom translations
                'hotel_code' => 'Property Code or Region Code',
                'declared_available_rooms' => 'Total accommodations potentially available for sale (declared on the Portal)',
                'declared_available_beds' => 'Number of available beds (declared on the Portal)',
                'endpoint' => 'Geographic Area',
            ],
            'c59' => [
                // C59 custom translations
                'c59_progression' => 'Progression for the reference date',
                'c59_year' => 'Year of the reference progression',
            ],
            'trento' => [
                // Trento custom translations
                'declared_available_rooms' => 'Number of available rooms',
            ],
            'astat' => [
                // Astat custom translations
                'accommodationId' => 'HotelCode or accommodationId',
                'prepare_local_tax' => 'Prepare Local Tax',
                'close_month' => 'Close Month',
                'token' => 'Token',
                'last_month_closed' => 'Last Closed Month',
                'property_closed_date_range' => 'Property Closed Date Range',
            ],
            'sinfonia' => [
                'cusr' => 'Property identifier',
                'api_key' => 'Management system API key'
            ],
            'webtur' => [
                'cir' => 'Regional Structure Identification Code (CIR)',
                'cin' => 'National Accommodation Identification Code (CIN)',
                'declared_available_rooms' => 'Number of available rooms',
            ],
            'option_scheduled_label' => 'Do you want to enable automatic Istat record sending?',
            'option_scheduled_description' => 'The system will automatically send records starting from the current date set',
            'option_scheduled_send_every_hour_label' => 'Specify the frequency of Istat record sending',
            'show_city_tax' => 'Show City Tax',
        ],
    ],
    'guest' => [
        'alloggiatiweb' => [
            'no_guests_txt' => 'No guests registered',
            'property_no_module_configured' => 'The property has not configured the Alloggiatiweb module',
            'wrong_size_file' => 'Incorrect file size, please contact support',
            'wrong_arrival_date' => 'Incorrect arrival date',
            'general_error' => 'Invalid credentials or certificate',
            'error_txt_file' => 'Error creating the Alloggiati file',
            'post_upload_error' => 'Invalid file. Please check the file type',
            'invalid_certificate' => 'Invalid certificate file',
            'certificate_and_password_required' => 'Certificate and password are required',
        ],
        'logger' => [
            'city_tax_log' => ':name :surname aged :age years (:first_date - :last_date for :accommodation_name) Tot. :total_city_tax',
            'naming' => 'Guest :name :surname: ',
            'checkin_date' => 'Check-in: :arrival_date => :checkin_date',
            'checkout_date' => 'Check-out: :departure_date => :checkout_date',
        ],
        'errors' => [
            'different_property_on_move' => 'The property of the designated room is not part of your property group',
            'family_master_already_in_room' => 'Cannot proceed, head of family already present in the destination room',
            'checkin_checkout_not_suitable' => 'Guest check-in or check-out dates are incompatible with the destination room',
            'not_found' => 'Guest not found',
            'city_tax_already_sent_to_channel' => 'Guest already sent to connected city tax portals, cannot proceed',
            'change_accommodation_with_invoiced_tax' => 'Cannot change room type for a guest with invoiced city taxes',
        ],
        'guest_cards' => [
            'empty_error' => 'Invalid credentials or property not enabled.',
            'uknown_error' => 'Unknown error from the external service',
            'venice_tax_exemption_type' => 'Exemption for Venice City Access Fee',
            'guest_required' => 'You must specify the guest to associate with the card',
            'customer_fields_are_required' => 'The following guest fields are required: :fields',
            'customer_required_fields' => [
                'name' => 'First Name',
                'surname' => 'Last Name',
                'nic' => 'Tax Code',
                'birthday_date' => 'Date of Birth',
                'birth_country.translations.0.name' => 'Place of Birth',
                'detail.email' => 'Email',
                'detail.telephone' => 'Phone',
                'detail.country.translations.0.name' => 'Residence',
            ],
        ],
    ],
    'housekeeper' => [
        'main_title' => 'Housekeeper',
        'clean_status' => 'Status',
        'name' => 'Housekeeper',
        'label' => 'Number',
        'accommodation' => 'Accomodation',
        'bed_type' => 'Bed types layouts',
        'bed_type_requested' => 'Bed type layouts requested',
        'bed_type_last' => 'Previous beds layout',
        'bed_type_next' => 'Next beds layout',
        'guests' => 'Guests',
        'guests_checkin' => 'Checking in',
        'guests_in_home' => 'In House',
        'guests_checkout' => 'Checking Out',
        'next_change_sheet' => 'Bed Linen change',
        'day' => 'day',
        'days' => 'days',
        'today' => 'Today',
        'notes' => 'Notes',
        'housekeeper_notes' => 'Housekeeper notes',
        'room_clean' => 'Clean',
        'room_dirty' => 'dirty',
        'reservations' => 'Reservations',
        'children' => 'Children: :count',
        'adults' => 'Adults: :count',
        'export_fields' => [
            'column1' => 'Date/Resourse',
            'scenario_title' => 'Scenary',
            'user' => 'User',
            'created_at' => 'Date',
            'details' => 'Details',
            'linen' => 'Towels',
            'sheet' => 'Bed linen',
            'staging' => 'Beds layout',
            'status' => 'Status',
            'housekeeper' => 'Housekeeper',
            'accommodation' => 'Accommodation',
            'cleaning' => 'Cleaning',
            'housekeeper_collaborator' => 'In collaboration with',
            'scenario' => 'Scheduling',
            'column3' => 'Time',
            'column2' => 'Scheduling',
        ],
        'maintenance' => 'Mantainance',
        'tomorrow' => 'Tomorrow',
        'requested' => 'Requested',
        'prev_abbrevation' => 'Prev',
        'next_abbrevation' => 'Next',
        'print' => [
            'passed_nights' => 'Night :passed_nights of :total_nights',
            'status_label_children' => 'Children :children_number',
            'status_label_adult' => 'Adults :adults',
            'status_in_home' => 'In House',
            'status_checkout' => 'Check-out',
            'status_checkin' => 'Check-in',
            'pending_manteiner' => 'pending maintenance reports :number',
            'note_housekeeper' => 'Housekeeping notes',
            'change_linen' => 'Towel change',
            'change_sheet' => 'Bed linen change',
            'number_of_inhome' => 'In House :number_in_home',
            'number_of_checkout' => 'Check-outs: :checkout_done di :checkout_total',
            'number_of_checkin' => 'Check-ins: :checkin_done of :checkin_total',
            'number_of_accommodations' => 'accommodations :number ',
        ],
        'bed_type_current' => 'Requested preparation',
    ],
    'import' => [
        'customer' => [
            'job_name' => 'Customers',
            'warnings' => ['required_field' => 'Required field'],
            'tooltips' => [
                'skip_on_missing' => 'Records from the uploaded file that do not contain values for this mapping will be skipped during import.',

                'sex_value' => '<br />Accepted values for each parameter: <br />- Male: male, maschio, uomo, m, man, maschile, u <br />- Female: female, femmina, donna, f, woman, femminile, d <br />- Not specified: not_defined, non definito, non specificato, na, n/a, empty cell. <br />The system is case-insensitive, so "uomo", "UOMO", and "Uomo" are all accepted.',

                'birth_country_required' => 'To enable correct matching of the birth city, this field is required. The system accepts the country name in any language and all ISO codes: 3166-1 numeric (3 digits), 3166-1 alpha-2 (2 letters), 3166-1 alpha-3 (3 letters).',

                'birth_country' => 'If only the birth country is mapped (without the corresponding city), the system will automatically assign the capital of the selected country as the birth city in the customer record. The system accepts the country name in any language and all ISO codes without case sensitivity.',

                'birth_city' => 'To correctly match the city, the next field (birth country) must also be mapped. The system accepts the city name in any language.',

                'citizenship_country' => 'Accepts the country name in any language and all ISO codes (3166-1 numeric, alpha-2, and alpha-3), without case sensitivity.',

                'language' => 'The system accepts the languages supported by Beddy: Italian, English, French, German, Spanish, Russian, Japanese. Other languages will default to English.  
    Accepted parameters (case-insensitive):  
    - ISO 639-1 (2 letters), e.g., "it"  
    - ISO 639-2 (3 letters), e.g., "ita"  
    - Full language name in Italian, English, French, German, or Spanish (e.g., "italiano", "italian", "italien", "italienisch", etc.)  
    If no value is present or no mapping is selected, the system will use the official language of the country of residence, if available, otherwise the default language.',

                'residence_city' => 'To correctly match the city, the next field (residence country) must also be mapped. The system accepts the city name in any language.',

                'residence_country_required' => 'To enable correct matching of the residence city, this field is required. The system accepts the country name in any language and all ISO codes (3166-1 numeric, alpha-2, and alpha-3).',

                'residence_country' => 'If only the residence country is mapped (without the corresponding city), the system will automatically assign the capital of the selected country as the residence city in the customer record. The system accepts the country name in any language and all ISO codes without case sensitivity.',

                'residence_address' => 'Enter a mapping that includes only the address, without city, ZIP code, or country.',

                'email' => 'Enter the email address. Do not enter PEC (certified email), which has its own field.',

                'document_type' => 'Accepts all document types defined by the Alloggiati Web portal, case-insensitively. For common documents such as identity card, electronic ID, driver’s license, and passport, common abbreviations (e.g., CI, CIE, ID, PASS) are also accepted.',

                'released_country_required' => 'To enable correct matching of the document issue city, this field is required. The system accepts the country name in any language and all ISO codes.',

                'released_country' => 'If only the issue country is mapped (without the corresponding city), the system will automatically assign the capital of the selected country as the issue city in the customer record. The system accepts the country name in any language and all ISO codes without case sensitivity.',

                'released_city' => 'To correctly match the city, the next field (document issue country) must also be mapped. The system accepts the city name in any language.',

                'invoicing_country_required' => 'To enable correct matching of the invoicing city, this field is required. The system accepts the country name in any language and all ISO codes.',

                'invoicing_country' => 'If only the invoicing country is mapped (without the corresponding city), the system will automatically assign the capital of the selected country as the invoicing city in the customer record. The system accepts the country name in any language and all ISO codes without case sensitivity.',

                'invoicing_city' => 'To correctly match the city, the next field (invoicing country) must also be mapped. The system accepts the city name in any language.',
            ],

            'columns' => [
                'name' => 'First Name',
                'surname' => 'Last Name',
                'sex' => 'Gender',
                'birthday_date' => 'Date of Birth',
                'nic' => 'Tax Code',
                'email' => 'Email Address',
                'pec' => 'PEC Address',
                'telephone' => 'Phone',
                'language' => 'Language',
                'birth_country' => 'Country of Birth',
                'birth_city' => 'City of Birth',
                'nationality_country' => 'Nationality (e.g., Italy)',
                'citizenship_country' => 'Country of Citizenship',
                'residence_country' => 'Country of Residence',
                'residence_city' => 'City of Residence',
                'residence_address' => 'Residence Address',
                'residence_zip_code' => 'Residence ZIP Code',
                'invoicing_country' => 'Billing Country',
                'invoicing_city' => 'Billing City',
                'invoicing_address' => 'Billing Address',
                'invoicing_zip_code' => 'Billing ZIP Code',
                'sdi_code' => 'SDI Code',
                'facebook' => 'Facebook URL',
                'linkedin' => 'LinkedIn URL',
                'twitter' => 'Twitter URL',
                'skype' => 'Skype',
                'note' => 'Notes',
                'lottery_code' => 'Lottery Code',
                'document_type' => 'ID Document Type',
                'document_number' => 'Document Number',
                'expiration_date' => 'Document Expiration Date',
                'released_country' => 'Document Issuing Country',
                'released_city' => 'Document Issuing City',
                'release_county' => 'Document Issuing Province',
                'release_state' => 'Document Issuing Region',
                'lang_values' => ['inglese', 'english', 'anglais', 'englisch', 'inglés', 'eng',],
                'newsletter_consent' => 'Privacy Check',
                'sex_values' => [
                    'male' => [
                        'male',
                        'man',
                        'm',

                    ],
                    'female' => [
                        'female',
                        'woman',
                        'f',
                    ],
                    'not_defined' => [
                        'not defined',
                        'not specified',
                        'not_defined',
                    ],
                ]
            ],
        ],
        'company' => [
            'job_name' => 'Companies',
            'columns' => [
                'name' => 'Company Name',
                'vat_code' => 'VAT Code',
                'nic' => 'Tax Code',
                'nick_name' => 'Nickname',
                'email' => 'Email',
                'pec' => 'PEC',
                'telephone' => 'Phone',
                'country' => 'Country',
                'city' => 'City',
                'address' => 'Address',
                'zip_code' => 'ZIP Code',
                'invoicing_country' => 'Billing Country',
                'invoicing_city' => 'Billing City',
                'invoicing_address' => 'Billing Address',
                'invoicing_zip_code' => 'Billing ZIP Code',
                'sdi_code' => 'SDI Code',
                'facebook' => 'Facebook',
                'linkedin' => 'LinkedIn',
                'twitter' => 'Twitter',
                'skype' => 'Skype',
                'note' => 'Notes',
            ],
        ],
        'booking_onboard_photo_property' => [
            'job_name' => 'Import Property Photos from Booking',
        ],
        'common' => [
            'personal_informations' => 'Personal Information',
            'contacts' => 'Contacts',
            'residential_details' => 'Residence Details',
            'invoice_address' => 'Billing Details',
            'documents' => 'Documents',
            'email' => 'Email',
            'other' => 'Other',
        ],
        'sending_list_contacts' => [
            'job_name' => 'Contact List',
            'columns' => [
                'label' => 'Label',
                'email' => 'Email Address',
                'locale' => 'Language',
            ],
        ],
        'errors' => [
            'request_params_not_valid' => 'The following request parameters are not valid: ',
        ],
    ],
    'invoice_layouts' => [
        'errors' => [
            'delete' => [
                'one_or_more_receipt_modules_attached' => 'One or more fiscal printers are attached to this invoicing module. To delete this invoicing profile, you must either delete the fiscal printers or assign them to a new invoicing profile.',
            ],
        ],
    ],
    'invoice_received' => [
        'title' => 'Invoices received',
        'export_fields' => [
            'document_date' => 'Document date',
            'received_date' => 'Received date',
            'document_name' => 'Document',
            'sender_name' => 'Sender',
            'sender_vat_code' => 'Sender VAT code',
            'total_taxable' => 'Taxable amount',
            'total_taxes' => 'VAT',
            'total_document' => 'Total',
            'discount_amount' => 'Discount',
            'status' => 'Status',
            'paid' => 'Paid',
            'amount_to_be_paid' => 'Amount to be paid',
        ],
        'statuses' => [
            'unpaid' => 'Unpaid',
            'paid' => 'Paid',
            'partially_paid' => 'Partially paid',
            'cancelled' => 'Cancelled',
        ],
        'document_types' => [
            'RT01' => 'Withholding tax for individuals',
            'RT02' => 'Withholding tax for corporations',
            'RT03' => 'INPS Contribution',
            'RT04' => 'ENASARCO Contribution',
            'RT05' => 'ENPAM Contribution',
            'RT06' => 'Other social security contribution',
            'TD01' => 'Invoice',
            'TD02' => 'Advance payment on invoice',
            'TD03' => 'Advance payment on statement',
            'TD04' => 'Credit note',
            'TD05' => 'Debit note',
            'TD06' => 'Statement',
            'TD16' => 'Invoice integration for reverse charge (internal)',
            'TD17' => 'Self-invoice for services purchased from abroad',
            'TD18' => 'Integration for intra-community goods purchase',
            'TD19' => 'Self-invoice for goods purchase under article 17, paragraph 2, D.P.R. no. 633/1972',
            'TD20' => 'Self-invoice for invoice regularization and integration (article 6, paragraph 8, D.Lgs. no. 471/1997 or article 46, paragraph 5, D.L. no. 331/1993)',
            'TD21' => 'Self-invoice for overrun',
            'TD22' => 'Goods extraction from VAT warehouse',
            'TD23' => 'Goods extraction from VAT warehouse with VAT payment',
            'TD24' => 'Deferred invoice pursuant to article 21, paragraph 4, letter a)',
            'TD25' => 'Deferred invoice pursuant to article 21, paragraph 4, third period, letter b)',
            'TD26' => 'Transfer of depreciable goods and for internal transfers (former article 36 D.P.R. no. 633/1972)',
            'TD27' => 'Invoice for self-consumption or for free transfers without VAT surcharge',
        ],
    ],
    'invoice' => [
        'export_fields' => [
            'payment_date' => 'Payment date',
            'number' => 'Invoice number',
            'business_name' => 'Business name',
            'total_price' => 'Total',
            'vat' => 'VAT',
            'taxable' => 'Taxable income',
            'invoice_date' => 'Invoice date',
            'number_complete' => 'Number',
            'recipient_business_name' => 'Registered name',
            'total_with_discount' => 'Taxable income',
            'total_tax' => 'VAT total',
            'total' => 'Total',
            'status_sdi' => 'SDI',
            'expire_date' => 'Expiry date',
            'status' => 'Status',
            'customer_name' => 'Guest',
            'payment_term' => 'Payment term',
            'recipient_vat_code' => 'VAT number',
            'payment' => 'Payment',
            'property' => 'Property',
            'to_pay' => 'To be paid',
            'paid' => 'Paid',
            'notes' => 'Notes',
            'accountholder' => 'Bill Holder',
            'date' => 'Date',
            'data' => 'Data',
            'payment_status' => 'Payment status',
            'currency' => 'Currency',
            'total_document' => 'Document total',
        ],
        'statuses' => [
            'paid' => 'Paid',
            'suspended' => 'Pending',
            'cancelled' => 'Deleted',
        ],
        'sdi_statuses' => [
            '0' => 'Not sent',
            '1' => 'Pending',
            '3' => 'Sent',
            '2' => 'Rejected',
        ],
        'pdf_export' => [
            'description' => 'Description',
            'quantity' => 'Qty',
            'amount' => 'Amount',
            'vat' => 'VAT',
            'vat_abbr' => 'VAT number',
            'total' => 'Total',
            'invoice_label' => 'Inv.',
            'of_date' => 'of',
            'taxable' => 'Taxable income',
            'deposit' => 'Deposit',
            'deposit_document_reference' => 'Document reference',
            'aomount_not_taxable' => 'Amount not subject to VAT',
        ],
        'invoices_opened' => [
            'invoices_opened_title' => 'Pending payments',
            'export_fields' => [
                'expire_date' => 'Expiry date',
                'accountholder' => 'Account holder',
                'document_number' => 'Document number',
                'date' => 'Date',
                'type' => 'Type',
                'paid' => 'Paid',
                'to_pay' => 'To be paid',
                'total' => 'Total',
                'note' => 'Notes',
                'property' => 'Property',
            ],
        ],
        'errors' => [
            'advance_not_suitable' => 'The attached advance is not compatible with the document type',
            'credit_note_on_follows_invoice_paid' => 'Unable to issue a credit note on a fully paid "follows invoice" document',
            'credit_note_on_follows_invoice_linked' => 'Unable to issue a credit note on a "follows invoice" document linked to another account',
            'restore_on_follows_invoice_linked' => 'Unable to reopen the account of a "follows invoice" document linked to another account',
            'cant_restore_opened_invoice' => 'You cannot reopen an unfiscalized account',
            'module_sdi_not_active' => 'Electronic invoicing module is not active',
            'refund_major_than_total_credit_note' => 'Refund amount exceeds the total of the credit note, unable to proceed',
            'expense_on_invoice' => 'Unable to associate an expense with a document other than a credit note',
            'cant_resend_due_status' => 'The current SDI status does not allow resending',
            'empty_xml' => 'No XML found',
            'cancellation_no_show_conflict' => 'You can specify only one type: no-show or cancellation',
            'cant_delete_credit_note' => 'Unable to delete the credit note',
            'add_to_invoices_already_registered' => 'Unable to add charges to registered invoices or credit notes',
            'edit_invoices_already_registered' => 'Unable to edit registered invoices',
            'delete_registered_invoice' => 'Unable to delete a registered invoice',
            'impossible_delete_until_moves' => 'Unable to delete the account. Move the charges to other accounts before proceeding.',
            'not_exist' => 'Invoice does not exist',
            'vat_payment_impossible_for_receipt' => 'Cannot set a VAT liability other than Immediate for a fiscal receipt',
            'unrestorable_bill' => 'Charge is not subject to restoration',
            'impossible_discount_for_discounted_bills' => 'Cannot apply a discount to charges that already have a discount',
            'refundable_bill_in_invoice' => 'Cannot add a refund reference outside of a credit note',
            'impossible_manual_charge_updating' => 'Unable to modify this charge',
            'impossible_follows_invoice_updating' => 'Unable to modify a charge linked to a "follows invoice" document',
            'impossible_associate_invoice_as_advance' => 'Unable to associate a regular invoice as an advance',
            'advances_over_allowed' => 'Set value for the advance invoice exceeds the allowed value',
            'fp_advances_with_different_department' => 'Selected advance receipts must have the same VAT rate',
            'advances_no_have_department' => 'The department used in the advance must be present among the charges of the settlement receipt.',
            'advances_total_major' => 'The advance amount cannot exceed the sum of the charges with the same department as the advance receipt.',
            'invoice_totally_refunded' => 'Invoice fully refunded, unable to proceed',
            'advance_with_different_customer' => 'Advance invoice not associable due to different recipient',
            'advance_totally_assigned' => 'Advance invoice fully allocated, unable to refund',
            'deposit_in_general_invoice' => 'Unable to allocate a deposit to a passing account',
            'bill_overrated' => 'Payment amount exceeds the total of the associated charge',
            'invoice_overrated' => 'Payment amount exceeds the total of the associated invoice',
            'property_not_attached' => 'Property not associated',
            'funds_params_unsuitable' => 'Parameters incompatible with cash fund',
            'registered_advance_invoice' => 'Advance invoice registered, delete linked invoices first',
            'registered_sdi invoice' => 'Advance invoice sent to SDI, cannot be deleted',
            'move_between_different_types' => 'Unable to move charges between invoices and credit notes or vice versa',
            'discount_over' => 'Applied discount exceeds the total of discountable charges',
            'archive_completed' => 'Archive already completed',
            'too_many_tasks' => 'Too many tasks running',
            'archive_warning' => 'Some files are missing',
            'archive_complete' => 'Complete',
            'invoice_registered' => 'Document already issued, unable to continue',
            'bill_tranfer_follows_invoice' => 'Unable to transfer a charge generated by a "follows invoice" receipt',
            'bill_generic_and_follows_invoice' => 'Cannot add generic lines and lines generated by "follows invoice" receipt simultaneously',
            'different_vat_code_follows_invoice' => 'Detected "follows invoice" receipt with a VAT code different from the summary invoice, unable to proceed',
            'receipt_with_follows_invoice' => 'Cannot issue a summary invoice while registering it as a receipt',
            'type_not_invoice_summary' => 'Cannot associate unpaid documents with the current document type',
            'archive_all_file_not_found' => 'No files found',
            'impossible_apply_discount_row_on_discounted_invoice' => 'Cannot apply discount to the charge if the invoice already has a discount',
            'cant_delete_invoice_due_convention' => 'Unable to delete the invoice as it is linked to a convention',
            'discount_on_invoice_and_on_row' => 'Unable to register invoice with discount if there are discounted charges',
            'discount_on_summary_invoice' => 'Cannot apply discount to a summary invoice',
            'cant_delete_invoice_due_linked_advances' => 'Unable to delete an advance invoice used as settlement for other invoices',
            'cant_delete_invoice_due_credit_notes' => 'Unable to delete a document that has already been credited',
            'cant_delete_invoice_due_module_fattelettronica' => 'Unable to delete the invoice as it has already been registered and/or sent to SDI',
            'cant_restore_invoice_due_sdi_ns' => 'Unable to reopen the account. The invoice was rejected by SDI and can be resent with the same number and date.',
            'cant_transfer_due_invoice_registered' => 'Unable to transfer a registered invoice',
            'cant_merge_credit_note' => 'Unable to merge credit notes',
            'cant_merge_due_module_fattelettronica' => 'Unable to merge an invoice sent to SDI',
            'cant_transfer_without_holder' => 'Cannot transfer to an account without a holder',
            'empty_row_document' => 'Insert at least one line in the document',
            'cant_delete_receipt' => 'Unable to delete fiscal receipt',
            'addon_unrelated' => 'Unable to link the extra service to this account',
            'impossible_add_row' => 'Unable to add a row to an invoiced or non-existent document',
            'uncharged_rows_found_on_restore' => 'Unable to restore the invoice: associated charges are currently present in an open account with an override, restore the original values before proceeding',
            'cant_create_temporary_due_missing_layout' => 'Unable to create the document because no billing layout is present',
            'move_bill_over_discount' => 'Unable to transfer the charge because the remaining value would be less than zero. The maximum transferable is: :max_threshold',
            'cant_decrement_price_invoiced_bill' => 'Unable to decrease the price of an already invoiced charge',
            'printer_id_not_associated' => 'Fiscal printer ID not associated with the billing profile',
            'cant_move_reservation_due_advance_invoice' => 'Advance invoices are present. To move the reservation, issue a settlement invoice or credit note.',
            'cant_move_reservation_due_deposit' => 'Deposits are present. To move the reservation, they must be removed or refunded.',
            'cant_move_reservation_due_payments' => 'Payments are present. To move the reservation, they must be removed or refunded.',
            'cant_update_invoice_balance' => 'Unable to modify data related to a settlement invoice',
            'cant_update_invoice_balance_layout' => 'Unable to modify the layout if it is not compatible with the VAT code of the current layout',
            'cant_register_invoice_balance_price' => 'The total invoice amount must match the total payment amount',
            'cant_choose_payment_deposit_different_property' => 'Cannot use deposit number :deposit_number on this document because it belongs to another property',
            'cant_choose_payment_advance_different_property' => 'Cannot use advance invoice number :number_complete because it belongs to another property',
            'cant_create_invoice_layout_without_vat_code_without_properties_enabled' => 'Unable to create a billing profile without a VAT code for properties not enabled for flat tax issuance',
            'unable_to_register_not_all_inclusive_tax_document_addons' => 'There are charges not enabled for flat tax. Please modify them in configuration or merge them with enabled charges in the account',
            'tax_bills_rows_joined_with_other_type_bills_on_all_tax_inclusive_document' => 'There are tax-type charges combined with charges of another nature. Restore the situation by excluding taxes from other account items before proceeding.',
            'all_tax_inclusive_layout_on_fiscal_printer' => 'Unable to associate a billing profile without a VAT code to a fiscal printer',
            'all_inclusive_tax_document_for_advance' => 'Unable to issue an advance document with flat tax settings',
            'advances_on_all_inclusive_tax_doument' => 'Unable to settle flat tax documents with advance invoices',
            'credit_note_on_all_inclusive_tax_document' => 'Unable to issue a credit note for flat tax, proceed with cancellation',
            'missing_department_override' => 'Missing fiscal printer department for charge :name',
            'missing_department' => 'Missing fiscal printer department for :vat_quote% VAT type',
            'advance_bill_not_found' => 'Advance charge not found',
            'totals_bills_not_equals' => 'The total rows do not match the total of the document',
            'multiple_invoices_bill_rows_override' => 'Cannot create an override for rows of different documents',
            'cant_create_override_for_registered_invoice' => 'Cannot create, modify, or delete an override for a fiscalized or non-existent document',
            'cant_edit_print_settings_for_registered' => 'Cannot modify print options for a fiscalized or non-existent document',
            'not_found' => 'Document not found',
            'no_attachments' => 'There are no attachments for this document',
            'error_attachments' => 'An error occurred while downloading attachments',
            'advance_with_all_inclusive_tax_document' => 'Unable to issue advance invoice under flat tax regime',
            'empty_email' => 'Please enter an email address',
            'empty_email_pdf' => 'PDF document not available',
            'advance_partially_used' => 'Unable to issue a credit note on a partially used advance invoice',
            'different_vat_payment_on_advance' => 'Unable to associate advance invoices with different VAT liabilities',
            'cant_delete_credit_note_due_to_sdi_or_fp' => 'Unable to delete credit notes sent to SDI or reversals issued with fiscal printers',
            'cant_delete_credit_note_between' => 'Unable to delete a credit note or reversal of charges belonging to multiple invoiced documents',
            'destination_deleted' => 'The recipient belongs to a profile no longer present in the system.',
            'vat_code_not_valid' => 'The entered VAT code is not valid',
            'tax_code_not_valid' => 'The entered tax code is not valid',
            'empty_codes' => 'Invalid tax code or VAT number',
            'row_exceed_total_price' => 'The row to be refunded exceeds the original total',
            'row_exceed_qty' => 'The row to be refunded exceeds the original quantity',
            'cant_register_invoice_as_follows_invoice' => 'Cannot issue an invoice in "follows invoice" mode',
            'cant_register_rejected_invoice_as_receipt' => 'Cannot issue a rejected document as a receipt. Correct the discrepancies and resend within 5 days.',
            'cant_turn_to_paid_follows_invoice' => 'Cannot mark a "follows invoice" receipt as paid',
            'reversal_on_receipt_follows_invoice_joined' => 'Unable to issue a credit note for a "follows invoice" receipt linked to a summary invoice',
            'receipt_channel_must_activated' => 'To configure the virtual printer, the module <em>Third-party systems interface</em> must be activated. <br /> Contact your Zucchetti consultant to add the module to your Beddy license.',
            'partial_cannot_exceed_total' => 'The amount cannot exceed the total of the document to be reversed',
            'partial_cannot_exceed_percentage' => 'The percentage cannot exceed the total of the document to be reversed',
            'credit_note_partial_on_advance' => 'Unable to proceed with a partial credit note for an advance document',
            'credit_note_partial_on_fp_send' => 'Unable to proceed with partial reversal for a document linked to a fiscal printer',
            'credit_note_partial_on_follows_invoice' => 'Unable to proceed with partial reversal for a "follows invoice" document',
            'row_to_refund_not_found' => 'Row to be refunded not found',
            'partial_only_credit_note' => 'Partials cannot be calculated for a credit note',
            'partial_credit_note_total_payment_exceed_source_payment' => 'The total payments exceed the document total',
            'payment_not_belonging_to_invoice_source' => 'The selected payment does not belong to the source document',
            'payment_not_found' => 'The selected payment does not exist',
            'partial_credit_note_row_payment_exceed_source_payment' => 'The total of the selected payment exceeds the total of the original payment',
            'city_tax_bills_partial_refund' => 'Unable to proceed with a partial refund of city tax-type charges',
            'credit_note_paid_major_than_total' => 'The total payments of the document exceed the total amount',
            'discount_over_permitted' => 'The discount applied exceeds the maximum allowed total without tax charges',
        ],
        'warnings' => [
            'city_tax_charged_for_guest' => 'Deposit invoiced for the guest, would you like to continue?',
            'vat_code_already_joined' => 'The profile is associated to invoices or payments, impossible modify the VAT number',
            'all_inclusive_tax_document_with_vat_code' => 'All-inclusive tax document is incompatible with issuance via VAT code',
            'number_used' => 'the invoice number is already in use',
            'cant_delete_bill_stay' => 'Unable to delete the charge for the stay',
            'cant_update_bill_day_price_due_convention' => 'The payer of the daily\' stay charge: date does not reflect the bill splitting method, the charge modification must be done directly from the charges section',
            'cant_update_bill_day_price' => 'Unable to modify the daily rate :date because the payer total charge is fewer than the amount difference',
            'cant_restore_bill_not_related' => 'Unable to restore this charge because the accommodation does not exist',
            'cant_restore_bill_invoiced' => 'The charge has been invoiced, unable to restore it',
            'additional_info_block_only_for_invoice' => 'Cannot insert additional information blocks for this type of document',
            'layout_numbers_existing' => 'There are active progressive numbers for this VAT number or Tax Code, do you want to replace them with the numbers set in this new billing profile? We advise you to check the number of the latest documents issued by this VAT number or Tax Code.',
            'cant_delete_due_to_joined_documents' => 'Unable to cancel a charge included in the issued documents',
            'cant_restore_bill_stay_not_involved' => 'The charge refers to dates not included in the stay, do you wish to delete it?',
            'document_not_found' => 'No document found with ID :invoice_id',
            'transferred_bills_present' => 'There are transferred charges from the reservation, this operation will permanently cancel the charges or reset them',
            'number_no_sequential' => 'The number used must be dated between the previous and the consecutive next invoice date',
            'detach_not_collected_document' => 'Changing the document type will remove the associated uncollected documents. Do you want to proceed?',
            'cant_restore_general_bill' => 'Unable to restore debit from pass-through account, please proceed with the transfer manually',
        ],
        'pdf' => [
            'accommodations' => 'Stay',
            'addons' => 'Extra',
            'advances' => 'Down payments',
            'taxes' => 'Taxes',
            'deposits' => 'Deposit',
            'taxation_list' => 'VAT summary',
            'taxable_amount' => 'Taxable income',
            'tax_amount' => 'Taxes',
            'total_taxes' => 'Taxes total',
            'total_taxable' => 'Taxable income total',
            'total_taxation' => 'Total VAT',
            'total_amount' => 'Total amount',
            'document_heading' => 'Document num. :identifier of :date',
            'document_heading_no_date' => 'Document num. :identifier',
            'document_num' => 'Document number',
            // DEPRECATED:
            'document_date' => 'of',
            // DEPRECATED:
            'payable' => 'Non-fiscal document',
            'proforma' => 'Proforma invoice',
            'invoice' => 'Invoice',
            'unregistered_invoice' => 'Bill',
            'receipt' => 'Receipt',
            'credit_note' => 'Credit note',
            'destination' => 'Recipient',
            'causal' => 'Causal',
            'extra_notes' => 'Notes',
            'sdi_send_date' => 'SDI sending date',
            'rounding' => 'Rounding',
            'vat_payment' => [
                'D' => 'VAT with deferred due date',
                'I' => 'VAT with immediate collectability',
            ],
            'payment_method' => 'Modalità di pagamento',
            'iban' => 'IBAN',
            'institution' => 'Institute',
            'amount_virtual_stamp' => 'Stamp amount',
            'discount_amount' => 'Discount or Increase',
            'receipts' => 'Receipts\' list',
            'reversal' => 'Receipts Reversal List',
            'receipts_expired' => 'Receipts\' list in \'expired\' status',
            'receipts_unpaid' => 'Receipts\' list in \'to be paid\' status',
            'receipts_suspended' => 'Receipts list with pending status',
            'receipts_paid' => 'Receipts\' list in \'paid\' status',
            'payments' => 'Payments',
            // era "Altri pagamenti"
            'payment_date' => 'Payment date',
            'payment_label' => 'Paying guest',
            'payment_method' => 'Payment method',
            'amount_available' => 'Amount available',
            'amount_used' => 'Amount',
            'deposit' => 'Deposit',
            'copy_text' => 'Courtesy copy without fiscal value according to article 21 of Presidential Decree 633/72. The original document has been sent to SDI and available on your Agenzia delle Entrate extranet',
            'total_to_pay' => 'To be paid',
            'total_paid' => 'Paid',
            'total' => 'Total',
            'discount' => 'Void',
            'payment' => 'Payment',
            'advance_with_number_complete' => 'Deposit invoice n°:number_complete',
            'credit_note_reversal' => 'receipt void',
            'credit_institution' => 'Bank',
            'document_advance_heading' => 'Reservation #:identifier - Deposit',
            'additional_information_cig' => 'CIG Code',
            'additional_information_cup' => 'CUP code',
            'additional_information_agreement_deal_code' => 'Order code',
            'additional_information_date' => 'Date',
            'additional_information_num_item' => 'Row ID',
            'additional_information_line_number_referral' => 'Row number',
            'additional_information_document_id' => 'Document ID',
            'additional_information_joined_invoices' => 'Related invoices',
            'additional_information_receiving' => 'Reception',
            'additional_information_agreement' => 'Agreement',
            'additional_information_purchase_order' => 'Purchase Order',
            'additional_information_contract' => 'Contract',
            'additional_information' => 'Additional Information',
            'attachments' => 'Attachments',
            'additional_information_step_reference' => 'Reference step',
            'additional_information_progress_status' => 'Progress status',
            'debit_note' => 'Debit note',
            'auto_invoice' => 'Self invoice',
            'reverse_auto_invoice' => 'SelfInvoice Cancellation',
        ],
        'errors_xml' => [
            'error_additional_charges_are_required_to_issue_the_receipt' => 'The difference between balance and advances (:totalPayments €) is lower than the required value (:subtractPayment €) to close the document, as each item must be worth at least 0.01 €. Increase a charge by :amountRequired € or group charges by category or service to obtain a lower number of items.',
            'error_total_cannot_be_less_than_one_cent' => 'The total of the document must be higher than the total of the advances (at least €0.01)',
            'payment_not_valid' => 'Invalid payment method',
            'tax_system' => 'Invalid issuer tax regime. Configure the tax regime on the billing profile',
            'cap' => 'Invalid issuer postal code (CAP)',
            'destination_code' => 'Invalid recipient code',
            'destination_code_pa' => 'Invalid recipient code for public administration (PA)',
            'destination_code_pr' => 'Invalid recipient code for private entities',
            'destination_cf' => 'Invalid recipient tax code',
            'destination_cap' => 'Invalid recipient postal code (CAP)',
            'address' => 'Billing address not provided',
            'empty_row_description' => 'Enter a description for all rows in the document',
            'department_fp' => 'Department with missing VAT rate',
            'payment_error' => 'Payment detail error',
            'payment_error_amount' => 'Document total amount is less than the sum of the indicated payments',
            'payment_error_code' => 'Invalid payment code: ',
            'nature' => 'Nature not specified, despite a zero VAT rate',
            'reverse_charge' => 'You cannot apply both split payments and reverse charge simultaneously.',
            'error_sdi' => 'SDI submission error. Check the entered values.',
            'document_no_xml' => 'Document type not enabled for XML',
            'not_found' => 'XML not found',
            'error_send_invoice' => 'Provider submission error',
            'limit_document_id' => 'The document number :id_document is invalid because it exceeds the 20-character limit',
            'error_import_invoice' => 'Import rejected',
            'xsd_validation_skip' => 'XSD validation issue. Validation skipped',
            'xsd_validation_failed' => 'The entered value (:value) for element :node is invalid',
            'error_limit_number_invoice' => 'Unable to send the file. Document limit reached. Contact support',
            'error_account_inactive' => 'The account is inactive on the billing provider. Contact support',
            'payment_error_vat_quote' => 'Mismatched VAT rates between total amount and advance.',
            'error_content_document' => 'Invalid document content, contact support',
            'error_create_document' => 'Error creating XML document, contact support.',
            'error_xml_format_received' => 'Invalid response XML format.',
            'error_empty_response' => 'Empty response XML.',
            'error_zip_archive_creation' => 'Error creating ZIP file.',
            'error_empty_document' => 'Empty XML document, contact support.',
            'voucher_code_not_valid' => 'The voucher code is not valid.',
            'custom' => [
                'limit_message_content' => 'The message content exceeds the 42-character limit.',
            ],
            'rch' => [
                'limit_message_content' => 'The message content exceeds the 25-character limit.',
            ]
        ],
        'invoice_module' => [
            'vat_code_exist' => 'Existing account with this VAT code',
            'error_get_data' => 'Account info recovery error',
            'invalid_invoice_channel' => 'Select a valid channel',
            'invalid_vat_code' => 'invalid VAT code',
            'error_fiscal_printer_linked' => 'There are fiscal receipts issued and linked to the printer. Do you want to delete them?',
            'customer' => 'Customer',
            'subcontracting' => 'Subcontracting'
        ],
        'art6' => 'Operation subject to VAT deferred collectability according to Art. 6, comma 5 del DPR 633/1972.',
        'art17' => 'Operation subjected to split payment  and VAT not taken by the issuer according to ex art.17-ter of DPR 633/1972.',
        'wording' => [
            'virtual_stamp_causal_more' => 'Stamp duty paid virtually pursuant to Article 6 of Ministerial Decree 17/06/2014',
            'all_inclusive_tax_document_exemption' => 'Exemption - Art. 3 of Legislative Decree no. 23 of 14/03/2011',
            'standard_advance' => 'Booking #:reference_number - Advance Payment',
            'manual_fp_register' => 'as a document already fiscalized',
            'follows_invoice' => 'follows invoice',
            'default' => 'standard',
            'force_change' => 'force change of charges'
        ],
        'cancellation' => [
            'invoice_label' => 'Cancellation Policy',
        ],
        'no_show' => [
            'no_vat_quote_defined' => 'The Property does not have a VAT code for :type set',
            'invoice_cancellation' => 'Cancellation',
            'invoice_label' => 'No-Show',
        ],
        'lottery_code' => 'Lottery Code: :lottery_code',
        'invoice_import' => [
            'import_error' => 'Import error, xml file invalid',
            'import_skip' => 'File ignored (the recipient vat code is invalid or already imported)',
            'import_success' => 'File imported successfully',
        ],
        'types' => [
            'invoice' => 'Invoice',
            'receipt' => 'Receipt',
            'credit_note' => 'Credit note',
            'reversal' => 'Void receipt',
            'unregistered_invoice' => 'Bill',
            'reverse_auto_invoice' => 'SelfInvoice cancellation',
            'debit_note' => 'Debit note',
            'auto_invoice' => 'SelfInvoice',
            'proforma' => 'Proforma',
        ],
        'log' => [
            'title' => 'invoicing',
            'advance' => 'invoice :invoice_number of :invoice_date issued with the invoicing layout :invoice_layout (:invoice_business_name - :invoice_vat_code) and issued to :invoice_customer (Total :invoice_total)',
            'refunded_advance' => 'The :amount of the :number document from :date has been made available again',
            'partial_credit_note' => 'The document :number_complete refunded the document :invoice_source_number by :credit_note_total: :bill_logs',
        ],
        'open_charges' => 'Open Bills',
        'operational_headquarter' => 'Operational Headquarters',
        'advances' => 'Advances',
        'log_module' => [
            'invoice_module_updated' => 'Invoice module updated',
            'invoice_module_created' => 'Invoice module created',
            'invoice_module_deleted' => 'Invoice module deleted',
        ]
    ],
    'logger' => [
        'field_updated' => 'Updated :section [:field] from :old_value to :new_value',
        'titles' => [
            'queue_update' => 'Queue update',
            'bulk_update' => 'Bulk update',
            'new_reservation' => 'New reservation',
            'update_reservation_status' => 'Reservation status updated',
            'cancel_accommodation' => 'Canceled reserved accommodation',
            'move_accommodation' => 'Moved reserved accommodation',
            'update_accommodation' => 'Updated reserved accommodation',
            'update_accommodation_arrival' => 'Updated arrival date',
            'update_accommodation_departure' => 'Updated departure date',
            'add_accommodation' => 'Added accommodation to reservation',
            'reservation_status' => 'Updated Reservation Status',
            'cancel_reservation' => 'Reservation canceled',
            'delete_reservation' => 'Reservation deleted',
            'cancel_reservation_no_new' => 'Canceled reservation without New status',
            'clone_rates' => 'Cloning from :channel_source to :channel_destination',
            'clone_rates_bulk' => 'Bulk update from clone',
            'payment_transaction' => 'Payment transaction',
            'update_accommodation_listing_price' => 'Updated accommodation listing price to :channel_destination',
            'accommodations_overview' => 'Daily overview',
            'reset_min_stay' => 'Reset minimum stay',
            'tableau_closure_create' => 'Created tableau closures',
            'tableau_closure_delete' => 'Deleted tableau closures',
            'attach_channel' => 'Connected channel :channel_name',
            'detach_channel' => 'Disconnected channel :channel_name',
            'read_channel' => 'Read channel data :channel_name',
            'increase_quantity' => 'Increased accommodation quantity',
            'decrease_quantity' => 'Decreased accommodation quantity',
            'insert_rule' => 'Added new rule',
            'update_rule' => 'Updated rule',
            'delete_rule' => 'Deleted rule',
            'cutoff' => 'Cutoff',
            'insert_cutoff' => 'Inserted Cutoff rule',
            'modify_cutoff' => 'Modified Cutoff rule',
            'delete_cutoff' => 'Deleted Cutoff rule',
            'bulk_treatments_update' => 'Bulk treatments update',
            'treatments_overview' => 'Daily treatments overview',
            'rateplan_update' => 'Rate plan update',
            'OTA-API' => 'API Partner',
            'update_channel' => 'Updated source channel',
            'keep_accommodation' => 'Locked accommodation movement',
            'keep_accommodation_label' => 'The value has changed for accommodation :accommodations',
            'channel_not_connected' => 'Channel not connected',
            'city_tax_report_exclusion' => 'City tax report exclusion',
            'city_tax_report_exclusion_label' => 'The value has changed for accommodation :accommodations',
            'update_from_past_years' => 'Copy rates from previous years',
            'accommodations_mapping' => 'Accommodation Mapping',
            'no_association' => 'No association',
        ],
        'messages' => [
            'accommodation_mapping' => 'From :origin to :destination',
        ],
        'warnings' => [
            'missing_dates_updates' => 'Unable to sync data for the following periods: ',
        ],
    ],
    'mail_channels_errors' => [
        'ses' => [
            'missing_required_fields_for_verfication' => 'Missing fields for verification of the sending channel',
            'existing_ses_identity' => 'Sender email already exists',
            'configuration_set' => [
                'AlreadyExistsException' => 'Configuration set already exists',
                'NotFoundException' => 'Configuration set not found',
                'TooManyRequestsException' => 'Maximum number of requests reached for creating a configuration set',
                'LimitExceededException' => 'Limit of instances reached for the requested configuration set',
                'BadRequestException' => 'Invalid configuration set',
                'ConcurrentModificationException' => 'Configuration set modified by another instance',
            ],
            'send_bulk_email' => [
                'TooManyRequestsException' => 'Maximum number of requests reached for sending emails',
                'LimitExceededException' => 'Limit of instances reached for sending emails',
                'AccountSuspendedException' => 'Email cannot be sent because the account\'s email sending ability has been permanently limited',
                'SendingPausedException' => 'Email cannot be sent because the account\'s email sending ability is currently paused',
                'MessageRejected' => 'Email cannot be sent because it contains invalid content',
                'MailFromDomainNotVerifiedException' => 'Email cannot be sent because the sending domain is not verified',
                'NotFoundException' => 'Resource for sending emails not found',
                'BadRequestException' => 'Invalid email sending input',
            ],
            'configuration_set_event_destination' => [
                'AlreadyExistsException' => 'Destination event already exists',
                'NotFoundException' => 'Destination event not found',
                'TooManyRequestsException' => 'Maximum number of requests reached for creating a destination event',
                'LimitExceededException' => 'Limit of instances reached for the requested destination event',
                'BadRequestException' => 'Invalid destination event',
            ],
            'configuration_set_attributes' => [
                'NotFoundException' => 'Unable to set configuration attributes, as it was not found',
                'TooManyRequestsException' => 'Maximum number of requests reached for setting configuration attributes',
                'BadRequestException' => 'Invalid configuration attributes',
            ],
        ],
    ],
    'mail_channels' => [
        'fields' => [
            'host' => 'Host',
            'port' => 'Port',
            'username' => 'Username',
            'password' => 'Password',
            'email_from' => 'Sender email',
            'secure' => 'TLS/SSL',
            'domain_email' => 'Sender email address',
        ],
        'choices' => [
            'ssl' => 'SSL',
            'tls' => 'TLS',
        ],
        'errors' => [
            'missing_required_fields_for_verfication' => 'Missing fields for verification of the sending channel',
            'existing_ses_identity' => 'Sender email already exists',
        ],
        'channels_name' => [
            1 => 'SMTP',
            2 => 'Beddy - Mail Service',
        ],
    ],
    'meals' => [
        'breakfasts' => 'Breakfasts',
        'lunches' => 'Lunches',
        'dinners' => 'Dinners',
        'note' => 'Note',
    ],

    'media' => [
        'errors' => [
            'invalid_type' => 'Invalid type: :type. Only \'customer\' is accepted.',
            'invalid_file_or_extension' => 'Invalid file or unrecognized extension.',
            'cloud_upload_error' => 'Error uploading file to cloud storage.',
            'not_authorized_to_delete_media' => 'You are not authorized to delete this media.',
        ]
    ],

    'messages' => [
        'download_attachments' => 'Download the attachments',
    ],
    'newsletters_conditions' => [
        'errors' => [
            'validation_error' => 'The value type passed for the feature \':feature\' must be of type \':type\'',
            'duplicate_condition_error' => 'The criterion \':criteriaName\' is already associated with the mailing list',
            'limit_values_error' => 'The number of parameters passed for the feature \':feature\' does not match the expected maximum value \':limitValues\'',
            'condition_not_found' => 'No condition associated with the list found',
            'unsuitable_condition_for_sending_list_category' => 'The \':criteriaName\' criterion is not compatible with the mailing list type',
            'option_relation_error' => 'The selected option identified by id \':option\' is not present for the feature \':feature\'',
        ],
    ],
    'newsletters_criteria' => [
        'field_translate' => [
            'country' => 'Country',
            'city' => 'City',
            'county' => 'County',
            'state' => 'State',
            'check_phone_number' => 'Should guests have entered their phone number?',
            'check_newsletter_consent' => 'Should users have given consent to receive newsletters?',
            'check_newsletter_unsubscribe' => 'Should users who have unsubscribed from newsletters be considered?',
            'language' => 'Language',
            'check_reservation_with_children' => 'Should guests have made a reservation with children?',
            'addon' => 'Add-ons',
            'last_reservation_date' => 'Last reservation date',
            'birthdays_date' => 'Birthdays date',
            'reservation_period_date' => 'Reservation period date',
            'reservation_stay_period_date' => 'Reservation stay period date',
            'guests_in_house' => 'Do you want to select all guests in house?',
            'accommodation' => 'Accommodation',
            'channel' => 'Channel',
            'reservation_tag' => 'Reservation tag',
            'category_addon' => 'Add-on category',
        ],
        'criteria_translate' => [
            'place' => 'Residence',
            'company_place' => 'Site',
            'phone_number' => 'Phone number',
            'newsletter_consent' => 'Newsletter consent',
            'newsletter_unsubscribed' => 'Unsubscribed from newsletters',
            'language' => 'Language',
            'reservation_with_children' => 'Reservations with children',
            'reservation_with_extra_services' => 'Reserved with a specific extra service',
            'last_reservation_year' => 'Last reservation year',
            'birthdays' => 'Birthdays',
            'reservation_period' => 'Reservation period',
            'reservation_stay_period' => 'Stay period',
            'customers_at_home' => 'Customers in house',
            'type_of_room_booked' => 'Type of room booked',
            'booking_portal' => 'Booking portal',
            'reservation_tag' => 'Tag',
            'addon_category' => 'Add-on category',
        ],
        'field_translate_error' => [
            'country' => 'Country',
            'city' => 'City',
            'county' => 'County',
            'state' => 'State',
            'check_phone_number' => 'Phone number consent',
            'check_newsletter_consent' => 'Newsletter consent',
            'language' => 'Language',
            'check_reservation_with_children' => 'Reservations with children',
            'addon' => 'Extra services',
            'last_reservation_date' => 'Last reservation year',
            'birthdays_date' => 'Birthday date',
            'reservation_period_date' => 'Reservation period',
            'check_actual_reservations' => 'Guests currently at home',
            'accommodation' => 'Accommodation type',
            'channel' => 'Booking portal',
            'reservation_tag' => 'Tag',
        ],
    ],
    'newsletters' => [
        'import' => [
            'validations' => [
                'email_not_valid' => 'Email field does not contain a valid email',
                'email_required' => 'The email field is required',
            ],
        ],
        'errors' => [
            'newsletter_task_in_error' => 'General send error, duplicate the campaign and try again in a few minutes.',
            'newsletter_without_contacts' => 'No contacts were found in the selected mailing lists, change the contact entry conditions or select other lists.',
            'impossible_delete_attempted_newsletter' => 'It is not possible to delete a newsletter already sent',
            'cant_update_sent_newsletter' => 'You cannot edit the selected newsletter because it has been sent. It can only be duplicated and stored',
            'newsletter_in_processing' => 'It is not possible to change the status of the selected newsletter, as it is being processed',
            'contact_already_exist' => 'Could not add contact because it is already present in the sending list',
            'contact_already_exclude' => 'Could not add contact because it has already been excluded from the sending list',
            'sending_list_contact_not_valid' => 'The following contact parameters are not valid: ',
            'missing_newsletter_contact' => 'The requested contact is not present or has no email address set',
            'elaborated_newsletter' => 'It is not possible to modify or delete the selected newsletter, as it is being processed or has been sent',
            'missing_newsletter' => 'The selected newsletter is not present',
            'missing_default_locale' => 'The HTML template in the default language is not present among the submitted templates',
            'missing_default_configuration' => 'To create the newsletter you need an active default configuration, check and try again',
            'configuration_not_expired' => 'Cannot check again the configuration if it has not expired or is waiting for confirmation',
            'configuration_not_found' => 'The selected configuration is not longer existing',
            'configuration_not_active' => 'Sender has not been verified yet',
        ],
        'warnings' => [
            'cant_delete_sending_list' => 'You cannot delete the selected mailing list because it is associated to the following newsletters: newslettersTitles',
            'cant_delete_configuration_with_newsletters' => 'It is not possible to delete the configuration because it is associated to the following newsletters not yet sent or already scheduled: ',
            'cant_delete_configuration' => 'Currently it is not possible to delete the configuration for technical problems, please try again later',
            'cant_delete_pending_configuration' => 'To delete this pending configuration confirmation, it is necessary to wait for the request to expire (24 hours after the creation)',
            'cant_delete_blocked_configuration' => 'It is not possible to delete a locked configuration',
            'existing_configuration' => 'There is an active configuration with the same parameters',
            'uneditable_options' => 'The sending channel does not allow the editing of the fields, in order to modify them you must delete the existing configuration and create a new one',
            'uneditable_channels' => 'The sending channel of a configuration cannot be modified',
            'cant_active' => 'The configuration has been saved but cannot be activated for the following reasons :errors',
        ],
        'unsubscribe_from_newsletter' => 'Unsubscribe from the newsletter',
    ],
    'odigeo' => [
        'exceptions' => [
            'configuration_missing' => 'The configuration parameters required by the :channelName channel are not present in the request',
            'configuration_not_valid' => 'The following parameters are invalid: :params',
            'invalid_age_range' => 'The age range for :field is not valid. Please ensure that the age ranges are correct and in order.',
        ],
    ],
    'payment_method' => [
        'fields' => [
            'model_name' => 'Payment method',
        ],
        'paypal' => [
            'cannot_activate_paypal' => 'Unable to activate Paypal, fill in the Client ID and Secret fields correctly.',
        ],
        'nexi' => [
            'cannot_activate_nexi' => 'Unable to activate Nexi, verify the field Alias and MAC key are correcty filled in.',
        ],
    ],
    'payments' => [
        'pre_authorization_is_expiring' => [
            'message_without_reservation' => 'We would like to inform you that :customerName :customerSurnamehas not yet pre-authorized the payment due to expire tomorrow of :amount - :propertyName',
            'message' => 'We would like to inform you that :customerName :customerSurname has not yet pre-authorized the payment due to expire tomorrow of :amount for the reservation number # :referenceNumber (:arrivalDate - :departureDate) - :propertyName',
            'subject' => 'Your pre-authorization is about to expire',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'message' => 'We would like to inform you that :customerName :customerSurname has made a new payment of :amount - :propertyName',
            'subject' => 'The Guest has successfully completed the payment',
        ],
        'customer_confirmed_payment_order_notification' => [
            'click_here_to_view' => 'Click here to view all reservation\'s details',
            'message' => 'We would like to inform you that :customerName :customerSurname has made a new payment of :amount for the reservation number # :referenceNumber (:arrivalDate - :departureDate) - :propertyName',
            'subject' => 'Payment receipt of :amount from :customerName :customerSurname - :propertyName',
        ],
        'payment_order' => [
            'default_whatsapp_text' => 'Dear :name :surname, for your reservation number :reference_number.a new request has been set :type click here :link',
        ],
        'direct_charge' => [
            'message' => '<p>Dear <strong>:name :surname</strong></p><p>for your reservation number <strong>#:reference_number</strong> the following payment has been processed.</p>',
            'subject' => 'Direct debit from :propertyName',
        ],
        'pre_authorization' => [
            'message' => '<p>Dear<strong>:name :surname</strong>,</p><p>for your reservation number <strong>#:reference_number</strong>a pre-authorization has been requested.</p>',
            'subject' => 'Pre-authorization request from :propertyName',
        ],
        'email_pre_authorization_request' => [
            'message_without_reservation' => '<p>Dear<strong>:name :surname</strong> has been processed the following pre-authorization.</p>',
            'message' => '<p>Dear<strong>:name :surname</strong></p><p>for your reservation number <strong>#:reference_number</strong>has been processed the following pre-authorization.</p>',
            'subject' => 'Request of pre-authorization from :propertyName',
        ],
        'email_payment_request' => [
            'confirm_payment' => 'Pay now :amount',
            'message_without_reservation' => '<p>Dear <strong>:name :surname</strong>has been requested the following payment.</p>',
            'message' => '<p>Dear <strong>:name :surname</strong>,</p><p>For your reservation number <strong>#:reference_number</strong>has been requested the following payment.</p>',
            'subject' => 'Payment request from :propertyName',
        ],
        'pre_authorization_text' => 'Pre-authorization',
        'refund_payment' => 'Payment reimbursement for :customer_name :customer_surname del :payment_date',
        'payment' => 'payment',
        'checkinonline_created_order_citytax' => 'City tax payment from Online Check-in',
        'cannot_complete_payment_gateway_requires_action' => 'The request has been sent correctly. You will receive a notification once the payment will be processed.',
        'payment_order_is_not_a_pre_authorization' => 'The operation requested is not a pre-authorization',
        'payment_order_cannot_be_completed_due_to_wrong_status' => 'The payment has been completed successfully',
        'cannot_complete_payment_due_to_gateway' => 'The payment gateway was unable to complete the transaction',
        'default_payment_email_subject' => 'Payment notification',
        'default_payment_email_body' => '<p>Dear:name :surname,</p><p>Please find attached the receipt for the payment made</p>',
        'warnings' => [
            'existing_restriction' => 'The :name policy has at least one restriction in common with the one you are managing and could create conflicts',
            'overlapping_period_for_restriction' => 'The :name policy has at least one overlap period with at least one restriction in common with the one you are managing and could create conflicts',
            'no_restrictions_and_period_others' => 'The :name policy has no restrictions or application periods may conflict with the one you are managing',
            'no_restrictions_and_period_policy' => 'The payment policy has no restrictions and/or application periods, it could conflict with other existing ones',
        ],
        'errors' => [
            'missing_policy' => 'Payment policy not found for the reservation',
            'payment_timetable_attach_email_invoice_error' => 'The invoice requested by the customer could not be attached due to the following error: :error_description',
            'payment_timetable_already_bound' => 'The scheduled payment has already generated a payment',
            'payment_timetable_already_processed' => 'The due date payment has already been processed or is pending',
            'conditions_with_conflicts' => 'The past conditions have identical number of nights\' charge or the totals of the charge percentages exceeds 100% of the amount',
            'impossible_change_payment_method_id' => 'Unable to change payment method for registered payments',

        ],
        'timetable' => [
            'charge_reminder' => [
                'message' => 'Dear :booker_name :booker_surname, 
                <br /><br />
                Today :date_today, a charge of :amount :currency_symbol is due according to the terms of the payment policy. 
                <br /><br />  
                <strong><span style="color: #8f743f;">Reservation number #:reference_number from :arrival_date to :departure_date.</strong>',
                'subject' => ':propertyName - Charge reminder',
            ],
            'charge_reminder_email_sent' => 'Sent reminder charge email',
            'payment_succeded' => 'Payment succeded',
            'reservation_pending' => 'Reservation pending confirmation',
            'reservation_optionable' => 'Reservation with option',
            'reservation_reconfirmed' => 'Reservation reconfirmed',
            'payment_refunded_modified' => 'Refund modified from :currency_symbol :old_amount to :currency_symbol :new_amount',
            'payment_refunded_created' => 'Refunded for :currency_symbol :amount',
            'manual_payment_cancelled' => 'The previously associated manual payment has been cancelled',
            'change_tax_payment_amount' => 'The payment of the city tax has been modified from :old_amount to :new_amount',
            'amount_over_to_pay' => 'Payment exceeds the total to be paid for the booking',
            'delete_propery_has_payments' => 'The property has active scheduled payments. By continuing this, all scheduled payments will be paused. The operation is irreversible',
            'invoice_default_causal' => 'Payment charge :payment_method_name of :date of reservation :reservation_reference',
            'stripe_not_active' => 'The Stripe payment method is not active',
            'manual_payment_bound' => 'Payment manually registered',
            'charge_status_manual_change' => 'The payment status has been changed from :current_charge_status to :new_charge_status',
            'module_deactivated' => 'The Scheduled Payments module has been disabled or expired',
            'property_cancelled' => 'The property is suspended, expired or cancelled',
            'reservation_cancelled' => 'reservation cancelled',
            'force_payment_due_date' => 'The payment can only be forced if the payment date matches with the current date',
            'timetable_pause_expired' => 'Scheduled payment paused expired',
            'request_payment_wait_customer_expired' => 'Payment request has expired',
            'required_action_requested_payment' => 'Payment request sent on :send_date - expiration date :expire_date',
            'required_action_3d' => 'Failed to charge, 3D Secure authentication was required',
            'no_credit_card_found' => 'No credit card for the reservation',
            'change_status_date_past' => 'Unable to schedule a payment date in the past.',
            'sca_not_accepted' => 'Non accepted',
            'sca_accepted' => 'Accepted',
            'export_fields' => [
                'sca_accepted' => 'SCA status',
                'property' => 'Property',
                'reservation_departure_date' => 'Check-out date',
                'reservation_arrival_date' => 'Check-in date',
                'amount' => 'scheduled payment',
                'reservation_total_price' => 'Reservation total amount',
                'booker' => 'Booker',
                'scheduled_date' => 'Payment date',
            ],
            'title' => 'Scheduled payments',
        ],
        'direct_charge_failed' => [
            'message' => '<p>Dear<strong>:name :surname</strong></p><p>we would like to inform you that today we have tried to debit the amount due for your reservation <strong>#:reference_number</strong>. However, we were unable to make the following charge.</p>',
            'subject' => 'Direct debit from :propertyName failed',
        ],
        'fields' => [
            'payment_agreement_id' => 'payment agreement identifier'
        ],

    ],
    'policy' => [
        'errors' => [
            'no_show_option_not_compatible' => 'Non-show options not compatible',
            'deposit_option_not_compatible' => 'Deposit options not compatible',
            'choose_deposit_pay' => 'You must choose when to make the deposit',
            'condition_not_compatible' => 'Cancellation conditions not compatible',
            'duplicate_penalty' => 'Duplicate penalty in cancellation conditions',
            'no_show_condition_not_applicable' => 'You cannot apply these conditions to the no-show',
            'deposit_condition_not_applicable' => 'You cannot apply these conditions to the deposit',
            'duplicate_penalty_deposit' => 'Duplicate penalty in the deposit section',
            'no_condition_to_deposit' => 'No conditions applied to the deposit',
            'policy_to_rateplan' => 'Policy connected to at least one rate plan',
            'delete_policy_default' => 'You cannot delete default policies',
            'last_policy' => 'You cannot delete the last policy of the structure',
            'policy_not_allowed_in_period' => 'You cannot override a period with the same rate plan policy.',
            'policy_period_overlapping' => 'Periods for policies are overlapping.',
            'check_priority_custom' => 'There are priorities for the policy, verify their correctness.',
            'check_priority_and_period' => 'There are priorities or periods for the policy.',
        ],
        'names' => [
            'standard' => 'Free cancellation',
            'not_ref' => 'Non-refundable',
            'default_ota_name' => 'See OTA',
            'default_ota_description' => 'Policy not sent by the channel',
            'hour_title_policy' => ' until :hour on the day of arrival.',
            'nights' => 'night|nights',
            'days' => 'day|days',
        ],
        'transform_to_date' => [
            'date_limit' => '<p>You can cancel for free until 23:59 on :date_limit.</p>',
            'date_limit_percentage' => '<p>If you cancel by :date_limit, you will be charged :penalty_value% of the total cost.</p>',
            'date_limit_nights' => '<p>If you cancel by :date_limit, you will be charged the cost of :penalty_value nights.</p>',
            'date_limit_amount' => '<p>If you cancel by :date_limit, you will be charged :penalty_value :currency.</p>',
            'date_over_percentage' => '<p>If you cancel after :date_limit, you will be charged :penalty_value% of the total cost.</p>',
            'date_over_nights' => '<p>If you cancel after :date_limit, you will be charged the cost of :penalty_value nights.</p>',
            'date_over_amount' => '<p>If you cancel after :date_limit, you will be charged :penalty_value :currency.</p>',
            'date_over_percentage_hour' => '<p>If you cancel after :hour_limit on :date_limit, you will be charged :penalty_value% of the total cost.</p>',
            'date_over_nights_hour' => '<p>If you cancel after :hour_limit on :date_limit, you will be charged the cost of :penalty_value nights.</p>',
            'date_over_amount_hour' => '<p>If you cancel after :hour_limit on :date_limit, you will be charged :penalty_value :currency.</p>',
            'date_now_percentage' => '<p>If you cancel now, you will be charged :penalty_value% of the total cost.</p>',
            'date_now_nights' => '<p>If you cancel now, you will be charged the cost of :penalty_value nights.</p>',
            'date_now_amount' => '<p>If you cancel now, you will be charged :penalty_value :currency.</p>',
            'date_now_noshow_percentage' => '<p>In case of no-show, you will be charged :penalty_value% of the total cost.</p>',
            'date_now_noshow_nights' => '<p>In case of no-show, you will be charged the cost of :penalty_value nights.</p>',
            'date_now_noshow_amount' => '<p>In case of no-show, you will be charged :penalty_value :currency.</p>',
        ],
        'transform_to_date_notref' => [
            'date_now_percentage' => '<p>If you cancel at any time after booking, you will be charged :penalty_value% of the total cost.</p>',
            'date_now_nights' => '<p>If you cancel at any time after booking, you will be charged the cost of :penalty_value nights.</p>',
            'date_now_amount' => '<p>If you cancel at any time after booking, you will be charged :penalty_value :currency.</p>',
            'date_limit_percentage' => '<p>If you cancel before :hour_limit on :date_limit, you will be charged :penalty_value% of the total cost.</p>',
            'date_limit_nights' => '<p>If you cancel before :hour_limit on :date_limit, you will be charged the cost of :penalty_value nights.</p>',
            'date_limit_amount' => '<p>If you cancel before :hour_limit on :date_limit, you will be charged :penalty_value :currency.</p>',
            'date_now_deposit_percentage' => '<p>You will be charged :penalty_value% of the total cost at the time of booking.</p>',
            'date_now_deposit_nights' => '<p>You will be charged the cost of :penalty_value nights at the time of booking.</p>',
            'date_now_deposit_amount' => '<p>You will be charged :penalty_value :currency at the time of booking.</p>',
            'date_now_noshow_percentage' => '<p>In case of no-show, you will be charged :penalty_value% of the total cost.</p>',
            'date_now_noshow_nights' => '<p>In case of no-show, you will be charged the cost of :penalty_value nights.</p>',
            'date_now_noshow_amount' => '<p>In case of no-show, you will be charged :penalty_value :currency.</p>',
        ],
    ],
    'property_report' => [
        'property' => [
            'label' => 'Property',
            'description' => 'This option allows you to export the property data',
        ],
        'children_ranges' => [
            'label' => 'Children Ranges',
            'description' => 'This option allows you to export the children ranges',
        ],
        'accommodations' => [
            'label' => 'Accommodations',
            'description' => 'This option allows you to export accommodations with their details',
        ],
        'treatments' => [
            'label' => 'Treatments',
            'description' => 'This option allows you to export treatments',
        ],
        'policies' => [
            'label' => 'Cancellation Policies',
            'description' => 'This option allows you to export the cancellation conditions',
            'addons_to_deposit' => [
                'included' => 'Included extra services',
                'not_included' => 'Extra services not included in the calculation',
            ],
        ],
        'rate_plans' => [
            'label' => 'Rate Plans',
            'description' => 'This option allows you to export rate plans',
        ],
        'invoice_layouts' => [
            'label' => 'Billing Profiles',
            'description' => 'This option allows you to export billing profiles',
        ],
        'city_tax' => [
            'label' => 'City Tax',
            'description' => 'This option allows you to export the city tax configuration',
            'active' => 'Active',
            'not_active' => 'Not Active',
        ],
        'payments_method' => [
            'label' => 'Payment Methods',
            'description' => 'This option allows you to export the payment methods configuration',
            'day' => '{0,1} day|[2,*] days',
        ],
    ],
    'property' => [
        'errors' => [
            'already_attached' => 'Attach già esistente',
            'property_has_another_master' => 'La stuttura ha già un utente master. Per procedere, eliminare l\'associazione di quest\'ultimo con la struttura',
            'letti_extra_exception_delete' => 'non puoi eliminare questo letto extra perchè devi prima eliminare il numero :lettimax invece hai cambiato il numero :lettimin',
            'letti_extra_exception_missing' => 'alcuni elementi sono mancanti',
            'override_periods_policy' => 'Periodi sovrapposti',
            'place_not_found' => 'Luogo non trovato',
            'not_group_owner' => 'Non sei il properietario di questo gruppo',
            'group_is_default' => 'Non è possibile rimuovere il gruppo predefinito',
            'already_in' => 'Struttura presente nel gruppo, impossibile procedere',
            'already_all_in' => 'Struttura presente in uno dei tuoi gruppi, impossibile procedere',
            'not_in_group' => 'Struttura non presente in un gruppo',
            'existing_extra_bed_setting' => 'Impostazione del letto extra esistente',
            'missing_extra_bed_setting' => 'Impostazione del letto extra mancante rispetto a questa',
            'overcoming_extra_bed' => 'Letto extra in esubero rispetto la configurazione camere esistente',
            'role_conflict' => 'Il ruolo è già esistente',
            'cant_detach_default_group' => 'Non è possibile disassociare la struttura dal gruppo di default',
            'groups_have_properties' => 'Non è possibile cancellare questo gruppo perchè sono presenti strutture',
            'uneditable_expense_category' => 'Categoria spese non modificabile',
            'expenses_pending' => 'Categoria spese non cancellabile per spese collegate',
            'missing_vat_quotes' => 'Attenzione! La nazione selezionata non ha aliquote iva impostate. Configurarle prima di procedere',
            'cutoff_rules_exist' => 'Regola di cutoff già esistente.',
            'missing_lat_lon' => 'Non sono state impostate le coordinate (LAT o LON) relative a questa struttura',
            'undetachable_layout' => 'Non puoi disassociare questo profilo se non ne hai almeno un altro associato',
            'customer_not_belonging_to_property_group' => 'Il cliente :customer_id non appartiene al gruppo strutture o non esiste',
            'update_expiration_bulk' => 'Errore nell\'aggiornamento delle scadenze',
            'update_cancellation_bulk' => 'Errore nell\'aggiornamento dello stato di disdetta',
            'update_activation_bulk' => 'Errore nell\'aggiornamento dello stato di abilita / disabilita',
            'invalid_credentials' => 'Authentication failed or missing. Please log in to access this resource.',
            'unauthorized_access' => 'You are not authorized to access this resource.',
            'unauthorized_insolvent_status' => 'Your account has been blocked due to an outstanding payment. Therefore, we invite you to contact "zucchettihospitality.gestione.crediti@zucchetti.it" to regularize your accounting position.'
        ],
        'warnings' => [
            'request_confirm_change_discount_type' => 'La modifica della tipologia di sconto comporta l\'eliminazione di tutte le configurazioni personalizzate. Continuare?',
            'request_confirm_delete_extra_bed' => 'La cancellazione di questo letto extra comporta l\'eliminazione dei letti extra superiori. Continuare?',
            'invalid_facility' => 'Facility non compatibile',
            'disabled_update' => 'Il canale :channel_name non è abilitato all\'invio dei dati',
            'nothing_to_update' => 'Niente da inviare su :channel',
            'missing_invoice_layout_without_vat_code_with_all_inclusive_tax_enabled' => 'Attenzione! La struttura abilitata non ha nessun profilo di fatturazione idoneo all\'emissione della cedolare secca',
            'properties_has_not_istat_module' => 'la struttura :property_name non ha il modulo istat abilitato',
            'update_overcome_days' => 'Le seguenti date non sono state aggiornate poichè superano il limite massimo dei giorni: :dates',
            'download_overcome_days' => 'Non sono stati scaricati dati per le seguenti date poichè superano il limite massimo dei giorni: :dates',
            'missing_property_xml_id' => 'Attenzione! Non è stato inserito il property_xml_id all\'interno dei settings del canale :channel_name',
        ],
        'city_tax' => [
            'main_report_title' => 'Riepilogo tassa di soggiorno',
            'recap_city_tax_totals' => 'Riepilogo totali tassa di soggiorno',
            'exemptions' => 'Esenzioni',
            'limit_nights' => 'Limite notti',
            'total_guests' => 'Ospiti totali',
            'totals' => 'Totali',
            'total_taxed_guests' => 'Ospiti tassati',
            'total_exempted_guests' => 'Ospiti esenti',
            'exemption_details' => 'Dettaglio esenzioni',
            'taxed_details' => 'Dettaglio tassati',
            'taxed_details_ranges' => 'Da :min a :max anni',
            'exemptions_over' => 'Esenti oltre limite',
            'guests_over' => 'Paganti oltre limite',
            'guests' => 'Ospiti',
            'city_tax_amount' => 'Totale tassa di soggiorno',
            'all_properties' => 'Tutte le strutture',
            'from_to_age_ranges' => 'Da :min_age a :max_age anni',
            'taxed_nights' => 'Pernottamenti di ospiti soggetti ad imposta',
        ],
        'commissions' => [
            'period_exists' => 'Periodo già esistente',
            'invalid_period' => 'Periodo errato',
            'season_too_long' => 'Intervallo stagionale troppo lungo',
        ],
        'list' => 'Lista strutture',
        'export_fields' => [
            'id' => 'ID',
            'name' => 'Nome',
            'group' => 'Gruppo',
            'address' => 'Indirizzo',
            'city' => 'Città',
            'state' => 'Stato',
            'county' => 'Provincia',
            'country' => 'Nazione',
            'zip_code' => 'Cap',
            'type' => 'Tipologia',
            'email' => 'Email',
            'telephone' => 'Tel',
            'reference_name' => 'Nome referente',
            'reference_surname' => 'Cognome referente',
            'reference' => 'Referente',
            'modules' => 'Moduli',
            'activated_date' => 'Data attivazione',
            'expire_date' => 'Data scadenza',
            'status' => 'Stato',
            'user_first_name' => 'Nome proprietario',
            'user_last_name' => 'Cognome proprietario',
            'user' => 'Proprietario',
            'user_email' => 'Email proprietario',
            'resellers' => 'Rivenditori',
            'business_name' => 'Ragione sociale',
            'vat_number' => 'Partita IVA',
            'fiscal_code' => 'Codice Fiscale',
            'properties_modules' => 'Moduli struttura',
            'accommodations' => 'Alloggi',
            'quantity' => 'Quantità',
            'contacts' => 'Contatti',
        ],
        'initials_name' => [
            'booking-engine' => 'BE',
            'channel-manager' => 'CM',
            'rate-checker' => 'RC',
            'brand-protection' => 'BP',
            'google-ads' => 'GA',
            'google-commission' => 'GC',
            'tripadvisor-istant-booking' => 'TIB',
            'trivago-fast-connect' => 'TFC',
            'booking-engine-quotes' => 'BEQ',
            'guests-reporting' => 'GR',
            'pms' => 'PMS',
            'newsletter' => 'CRM',
            'automatic-payments' => 'AP',
        ],
        'clone' => [
            'cloning-job-scheduled' => 'La clonazione verrà effettuata a breve, controlla tra qualche minuto.',
        ],
        'not_found' => 'I seguenti ID non esistono: ',
        'log'  => [
            'property_module_enabled' => 'Property module enabled',
            'property_module_disabled' => 'Property module disabled',
            'beddy_channel_disabled' => 'Beddy channel disabled',
            'beddy_channel_enabled' => 'Beddy channel enabled',
            'property_disactivated' => 'Property deactivated',
            'property_activated' => 'Property activated',
            'property_cancelled' => 'Cancellation registered for the property',
            'property_cancellation_reversed' => 'Cancellation reversal registered for the property',
            'property_update_expiration_date' => 'Property contract expiration updated',
        ],
        'treatment' => [
            'log' => [
                'attach' => 'The treatment :treatment_name has been associated with the properties :property_names with a price supplement of :supplement_price and a price variation of :share_price. :children_detail :apply_past',
                'children_detail' => ' For the age group :age_range, a supplement of :supplement_price and a variation of :share_price has been set.',
                'apply_past' => ' The configuration has been propagated to bookings made between :from and :to',
                'detach' => 'The treatment :treatment_name has been dissociated for the property :property_name',
                'update' => 'The treatment :treatment_name has been updated by setting a price supplement of :supplement_price and a price variation of :share_price. :children_detail :children_delete :detail_delete',
                'detail_delete' => 'The price variation has been reset compared to the previous one, so all previously associated details have been deleted',
            ],
        ],
    ],
    'push_notifications' => [
        'multiple_sessions' => [
            'title' => 'Security Alert: Multiple devices connected to your account',
            'message' => 'Connections from multiple devices on your account have been detected. Please check your currently active sessions.',
        ],
        'reservation_accommodation_zero_avails' => [
            'body' => 'The availability is depleted for the accommodation :accommodation_name for the following dates: :days',
            'subject' => 'Availability depleted for the accommodation :accommodation_name of the property :property_name.',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'message' => 'The guest :name :surname has made a payment of :amount.',
            'title' => 'A new payment has been received from :name :surname.',
        ],
        'customer_confirmed_payment_order_notification' => [
            'message' => 'The guest :name :surname has made a payment of :amount fro the reservation from :arrival_date to :departure_date of the property :property_name. ',
            'title' => 'A new payment has been received from :amount from :name :surname.',
        ],
        'sca_authorized' => [
            'message' => 'The guest :name :surname confirmed the SCA form on :accepted_date from the IP address :ip_address.',
            'title' => 'SCA authorized :name :surname.',
        ],
        'order_payment_release' => [
            'body' => 'The payment pre-authorization for the reservation number :name :surname from :arrival_date to :departure_date of the property :property_name.',
            'subject' => 'Pre-authorization unlocked (:name :surname).',
        ],
        'reservation_option_expired' => [
            'message' => 'A reservation option expired for the reservation :name :surname from :arrival_date to :departure_date for the accommodation :accommodation_name of the property :property_name. ',
            'title' => 'Option reservation expired (:name :surname) ',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'title' => 'Clean status chenged for accommodation :cleanable_name - :accommodation_name',
            'message' => ':user_name changed clean status to :clean_status of :reference_date for accommodation :cleanable_name (:accommodation_name) of property :property_name.',
        ],
        'housekeeper_maintainer' => [
            'message' => 'A new maintenance report has been entered for the accommodation :tableau_label. :title - :description',
            'title' => 'New maintenance report for the accommodation :accommodation_name',
        ],
        'reservation_quote_expired' => [
            'message' => 'A quote expired for the guest :name :surname, created on :created_date.',
            'title' => 'Quote expired :name :surname.',
        ],
        'checkin_online_complete' => [
            'message' => 'The guest :name :surname completed the online check-in for the reservation from :arrival_date to :departure_date for the accommodation :accommodation_name of the property :property_name.',
            'title' => 'Online Check-in completed (:name :surname).',
        ],
        'invoice_received' => [
            'message' => 'Received a new invoice number :document_number of :document_date from :sender_name',
            'title' => 'Invoice received from :sender_name.',
        ],
        'invoice_rejected' => [
            'message' => 'The invoice number :number_complete has been rejected by SDI for the following reason: :rejected_reason.',
            'title' => 'Invoice :number_complete of :name :surname rejected by SDI.',
        ],
        'reservation_cancelled' => [
            'message' => 'A reservation has been cancelled :name :surname from :arrival_date to :departure_date the property :property_name. ',
            'title' => 'Reservation cancelled :name :surname da :channel_name.',
        ],
        'reservation_modified' => [
            'message' => 'A reservation has been modified :name :surname from :arrival_date to :departure_date for the accommodation :accommodation_name of the property :property_name.',
            'title' => 'Reservation modified from :name :surname from :channel_name.',
        ],
        'reservation_new' => [
            'message' => ':name_surname has reserved the accommodation :accommodation_name of the property :property_name from :arrival_date to :departure_date.',
            'title' => 'New reservation from :channel_name (:name_surname).',
        ],
        'reservation_queue_complete' => [
            'body' => 'The reservation for the guest :name :surname has been successfully processed',
            'subject' => 'Reservation processed :name :surname.',
        ],
        'guests_reporting_ko' => [
            'message' => '1 schedina not sent :error_message|:number_of_guests guests not sent :error_message',
            'title' => 'Schedine Alloggiati send error - :property_name',
        ],
        'guests_reporting_ok' => [
            'message' => '1 schedina successfully sent| :number_of_guests guests successfully sent',
            'title' => 'Schedine Alloggiati successfully sent - :property_name',
        ],
        'guests_reporting' => [
            'error' => '1 schedina not sent|:number schedine not sent :errorMessage',
            'success' => '1 schedina sent successfully|:number schedine sent successfully',
            'subject' => 'Send schedine Alloggiati - :alloggiatiweb_group_label',
        ],
        'quote_request' => [
            'message' => ':customer_name :customer_surname just sent a quote request for your property.',
            'subject' => 'New Quote request',
        ],
        'treatment_price_update' => [
            'message' => 'The recalculation of the updated data from :start_date to :end_date for the treatment :treatment_name has been completed.',
            'subject' => 'Treatments statistics updated for - :property_name',
        ],
        'export_not_completed' => [
            'message' => 'The generation of the :exportId failed',
            'title' => 'The export of :exportServiceName for structure :propertyName could not be completed',
        ],
        'export_completed' => [
            'message' => 'Click on the notification to be redirected to the export history page',
            'title' => 'Export of :exportServiceName for structure :propertyName is ready',
        ],
        'urmet_sclak_error_generate_key' => [
            'message' => 'An error occurred on Sclak related to the generation of room keys: :errors . Try again manually, if the problem persists contact Urmet assistance',
            'title' => 'Booking key creation error :booker name :booker surname (#ID: :reference number)',
        ],
        'conversation_message_send_failed' => [
            'message' => 'The message directed to :recipientName was not delivered',
            'title' => 'Sending message failed',
        ],
        'reservation_message_received' => [
            'title' => 'New message from :senderName (#:reference)',
        ],
        'remote_door_key_service_reservation_moved' => [
            'message' => 'One or more accommodations of the reservation of <b>:booker_name :booker_surname- :reference_number</b> of the property <b>:property_name</b> have been moved. You need to generate a new key code.',
            'title' => 'One or more accommodations have been moved. You need to generate a new key code.',
        ],
        'remote_door_key_service_reservation_resumed' => [
            'message' => 'You need to generate a new reservation key code for <b>:booker_name :booker_surname- :reference_number</b> of property <b>:property_name</b>',
            'title' => 'Changes to reservations, generate new key codes',
        ],
        'newsletter_not_sent' => [
            'message' => 'Unable to send the newsletter campaign ":newsletterName" because of the following errors: :errorMessage',
            'title' => 'Error newsletter sending',
        ],
        'newsletter_sent' => [
            'message' => 'The :newsletterName newsletter has been successfully sent',
            'title' => 'Newsletter sending confirmation',
        ],
        'urmet_sclak_error_sending_sms' => [
            'message' => 'Unable to send the Sclak SMS because an error occurred. <br> We advise you to contact Urmet assistance',
            'title' => 'Error reservation keys SMS sending :booker name :booker surname (#ID: :reference number)',
        ],
        'queue_past_reservations_task_error' => [
            'message' => 'An error occurred while processing the antecedent booking queue. Error message :error_description',
            'subject' => 'Previous reservations processing task error - :property_name (:property_id) channel :channel_name (:channel_id)',
        ],
        'queue_past_reservations_task_record_summary' => [
            'message' => 'Previous reservations have been processed :reservations processed on :reservations total totals. There are :reservations_require_action reservations that require action from you.',
            'subject' => 'Task summary previous reservation processing - :property_name (:property_id) channel :channel_name (:channel_id)',
        ],
        'reservation_banktransfer_cancelled' => [
            'message' => 'The reservation under :name :surname from :arrival_date to :departure_date of the property :property_name has been automatically cancelled. ',
            'title' => 'Reservation cancellation for :name :surname from :channel_name due to non-payment',
        ],
        'newsletter_exceeded_sent_limit' => [
            'message' => 'The newsletter :newsletterName has not been sent, due to the exceeding monthly quota of email sending',
            'title' => 'Monthly sending limit quota exceeded',
        ],
        'payment_timetable_exceeded' => [
            'message' => 'Automatic payment debit failed - Payment in Unable to make the charge for the automatic payment in question because it exceeds the unpaid portion of the booking',
            'title' => 'Automatic payment debit failed - Payment in excess of the total booking',
        ],
        'payment_timetable_no_credit_card' => [
            'message' => 'Unable to make the charge for the automatic payment in question because there is no credit card to be used to make the charge.',
            'title' => 'Automatic payment Debit failed - Credit card not present',
        ],
        'payment_timetable_charge_failed' => [
            'message' => 'The automatic payment could not be debited for the following reason :error_description',
            'title' => 'Debit failed automatic payment',
        ],
        'payment_timetable_stripe_not_active' => [
            'message' => 'The automatic payment in question could not be debited because there is no active Stripe account to use for the charge.',
            'title' => 'Debit failed automatic payment - Stripe not active',
        ],
        'accommodation_deleted' => [
            'message' => 'The number of units available for accommodation has been reduced :accommodationName of the property :propertyName, to avoid overbooking you need to reset availability.',
            'title' => 'Action required',
        ],
        'empty_city_tax_report' => [
            'message' => 'The report of tourist taxes has not been processed because for the selected period no guest was extracted to be communicated to the channel',
            'title' => 'Error sending/exporting report city tax for the channel :channelName',
        ],
        'guest_atrtributes_missing_in_city_tax_report' => [
            'title' => 'Error sending/exporting city tax report',
        ],
        'export_city_tax_report_not_completed' => [
            'message' => 'The generation of the report :reportId was not successful',
            'title' => 'Could not complete the export of the city tax reports for the channel :channelName',
        ],
        'export_city_tax_report' => [
            'message' => 'Click on the notification to be redirected to the export history page',
            'title' => 'The report of the city tax for channel :channelName is ready',
        ],
        'send_city_tax_report_not_completed' => [
            'message' => 'The city tax report sent to the sending channel :channelName failed',
            'title' => 'City taxes report sending error',
        ],
        'send_city_tax_report' => [
            'message' => 'The city tax report for the sending channel :channelName has been successfully sent',
            'title' => 'City tax report sending confermation',
        ],
        'multi_property_export_not_completed' => [
            'message' => 'Export made on date :date at hours :time failed',
            'title' => 'Export :exportProviderName failed',
        ],
        'multi_property_export_completed' => [
            'message' => 'The file :fileName is ready to download',
            'title' => 'Export :exportProviderName completed',
        ],
        'single_property_export_not_completed' => [
            'message' => 'Export made on date :date at hours :time failed',
            'title' => 'Export :exportProviderName failed',
        ],
        'single_property_export_completed' => [
            'message' => 'The file :fileName is ready to download',
            'title' => 'Export :exportProviderName completed',
        ],
        'nuki_error_generate_key' => [
            'message' => 'There was an error on Nuki when generating the camera PIN:errors . Try again manually, if the problem persists contact Nuki support',
            'title' => 'Automatic debit payment failed - Payment in Unable to charge for the automatic payment in question because it exceeds the unpaid part of the booking',
        ],
        'payment_timetable_require_action' => [
            'subject' => 'Automatic payment charge failed - 3D Secure required',
            'message' => 'Automatic charge failed due to 3D Secure request (ID: :payment_timetable_id, on :scheduled_date - Reservation :reservation_reference_number under the name of :booker_name :booker_surname).',
        ],
    ],
    'pa_friuli_venezia_giulia' => [
        'accommodation_name' => 'Accommodation',
        'accommodation_tableau_name' => 'Room',
        'check_in' => 'Check In',
        'check_out' => 'Check Out',
        'nights' => 'Nights',
        'surname_and_name' => 'Surname and Name',
        'date_of_birth' => 'Date of Birth',
        'citizenship' => 'Citizenship',
        'residence' => 'Residence',
    ],
    'quote_request' => [
        'email' => [
            'summary_request' => 'Your quotation summary:',
            'stay' => 'Length of stay',
            'eta_children' => 'Children age',
            'accommodations' => 'Accomodations',
            'alternative_dates' => 'Different dates are available',
            'alternative_beds' => 'Different bed settings are available',
            'yes' => 'Yes',
            'no' => 'No',
            'accommodation' => 'Accomodation',
            'night' => 'Night',
            'nights' => 'Room nights',
            'adults' => 'Adults',
            'children' => 'Children',
            'button' => 'Click here to check your request',
            'telephone' => 'Phone number',
            'to' => 'Check- out',
            'from' => 'Check -in',
            'email' => 'Email address',
            'name_surname' => 'Name and Last Name',
            'quote_request_confermation' => 'Dear <b>:property_name</b>,<br></br>
            <b>:customer_name :customer_surname</b> a request for quotation has been submitted for your property.',
            'subject' => 'Quotation request for :property_name - :customer_name :customer_surname (:arrival_date - :departure_date)',
        ],
        'email_customer' => [
            'subject' => 'Thanks for your request :customer_name!',
            'message' => 'Thank you<b>:customer_name</b>,<br></br>Your request for quotation has been submitted. We will contact you as soon as possible.',
        ],
    ],
    'rateplans' => [
        'errors' => [
            'max_day_update' => 'It is not possible to delete this rate plan because connected channels are present',
            'insert_periods_plan' => 'It is not possible to insert periods into a rate plan',
            'uneditable_rateplan' => 'Source rate plan cannot be edited',
            'source_not_found' => 'The source rate is not present on the accommodation',
            'detach_accommodations_channels' => 'It is not possible to delete this rate plan because connected channels are present',
            'multi_property_not_permitted' => 'It is not possible to create or edit rate plans for more than one property at a time',
            'rules_present_cannot_update' => 'It is not possible to apply the requested change because there are active rules associated with this rate plan.',
        ],
        'warnings' => [
            'missing_set_rules' => 'It was not possible for some source channels to set rules on rate plans not existing on destination channels',
        ],
        'conflicts' => [
            'unsuitable_conditions' => 'The values for the condition :condition_from are not compatible with those entered for the condition :condition_to',
            'conditions_not_formatted' => 'Conditions not properly formatted, missing ID',
        ],
        'export_fields' => [
            'name' => 'Name',
            'policy' => 'Refund policies',
            'periods' => 'Periods and validity days',
            'accommodations' => 'Accommodations',
        ],
    ],
    'rates' => [
        'errors' => [
            'max_day_update' => 'You cant update a total period higher than one year',
            'no_rooms_to_clone' => 'No accommodation can be cloned',
            'no_rooms_to_clone_source' => 'One or more rooms/rates aren\'t present in the source channel',
            'no_rooms_to_clone_destination' => 'One ore more rooms/rates aren\'t present in the destination channel',
            'same_channel_to_clone' => 'You can\'t clone a channel on itself',
            'no_date_valid' => 'No dates to update',
            'max_availability_exceeded' => 'The availability value entered is higher than the one allowed by the accomodation configuration. The value had been adapted to the maximum allowed',
            'anti_overbooking_bloccante' => 'Careful! The availability value you\'re trying to enter is higher than the number of seleable rooms. You risk the overbooking',
            'channel_update_error' => 'The channel update went wrong, please visit the section<b>Update Logs</b>for further information.',
            'period_over_limit' => 'The period from :dateFrom to :dateTo exceeds the maximum allowed limit.',
        ],
        'warnings' => [
            'past_period' => 'The selected period passed',
            'past_today_adjustment' => 'The starting date had been adapted to today date',
            'period_adjustment_limit' => 'The end date has been adjusted to the maximum allowed limit. (:dateTo)',
            'channel_not_connected' => 'The property isn\'t connected to the channel :channel_name',
            'anti_overbooking' => 'Careful! The availability value you\'re trying to enter is higher than the number of seleable rooms. You could risk the overbooking',
            'missing_association' => 'The accommodation is not associated to this channel :channel_name ',
            'identical_update' => 'An identical update is still ongoing, try again later.',
            'rate_copy_not_found' => 'There is no data to copy for the past period. Update ignored',
        ],
    ],
    'receipt_modules' => [
        'errors' => [
            'already_migrated' => 'This fiscal printer has already been migrated to the new department management system',
        ],
        'log' => [
            'receipt_module_updated' => 'Fiscal printer updated',
            'receipt_module_created' => 'Fiscal printer created',
            'receipt_module_deleted' => 'Fiscal printer deleted',
            'receipt_module_department_deleted' => 'Fiscal printer department deleted',
            'receipt_module_department_created' => 'Fiscal printer department created',
            'receipt_module_department_updated' => 'Fiscal printer department updated',
        ],
        'validation' => [
            'ateco_slot_code' => [
                'wrong_format' => 'Incorrect ateco code format.',
                'wrong_slot' => 'Unsupported slot value. (0 - 3).',
            ],
        ],
    ],

    'receipt_channels' => [
        'log' => [
            'receipt_channel_created' => 'Electronic receipt created',
            'receipt_channel_deleted' => 'Electronic receipt deleted',
        ]
    ],

    'reservation_accommodation_room_day' => [
        'fields' => [
            'model_name' => 'day',
            'price' => 'daily price',
            'children_number' => 'children number',
            'adults_number' => 'adult number',
        ],
    ],
    'reservation_addon' => [
        'fields' => [
            'related_id' => 'related identifier',
            'related_type' => 'related type'
        ],
    ],
    'reservation_accommodation' => [
        'fields' => [
            'price_total' => 'total room price',
            'smoking' => 'smokers',
            'accommodation_bed_type_combination_id' => 'Bed type combination identifier for accommodation'
        ],
    ],
    'reservation_cc' => [
        'fields' => [
            'holder' => 'credit card holder',
            'number' => 'credit card number',
            'expire_date' => 'credit card expiry date',
            'cvc' => 'cvc code',
            'credit_card' => 'credit card',
            'current_balance' => 'current balance',
            'type_id' => 'identifier type',
            'activation_date' => 'activation_date',
            'vcc_expiration_date' => 'vcc expiration date',
            'is_virtual_card' => 'is virtual card'
        ],
    ],
    'reservation_invoice' => [
        'export_fields' => [
            'reference_number' => 'Reservation ID',
            'accommodations' => 'Accommodations',
            'room' => 'Accommodation number',
            'period' => 'Stay',
            'pax' => 'Guests',
            'type' => 'Type',
            'customer' => 'Accountholder',
            'payment_agreement' => 'Credit',
            'paid' => 'Paid',
            'to_pay' => 'To be paid',
            'total' => 'Total',
            'notes' => 'Notes',
            'status' => 'Status',
            'booker' => 'Booker',
            'property_name' => 'Property',
            'stay' => 'Stay',
            'note' => 'Notes',
            'accountholder' => 'Bill Holder',
            'open_charges' => 'Open bills',
            'credit' => 'Credit',
            'guests' => 'Guests',
            'reservation_id' => 'Reservation ID',
        ],
        'errors' => [
            'invoice_opened_for_customer' => 'The guest has open bills for this reservation, you must close the open bills before opening new ones',
            'credit_note_on_opened' => 'Impossible release credit note for not registered invoices',
            'associate_in_to_credit_note' => 'Impossible associate takings to a credit note',
            'associate_out_to_invoice' => 'Impossible associate a outgoing payment to an invoice',
            'keep_same_customer_on_credit_note' => 'Impossible change the recipient of a credit note linked to an issued invoice',
            'impossibile_move_through_reservations' => 'Impossible transfer this charge outside this reservation open bills, closed bills or credit notes',
            'cant_refund_pending_sdi_invoice' => 'Unable to issue a credit note for invoices that are still in pending of SDI result',
            'cant_update_due_invoice_no_show' => 'Unable to modify the reservation as there are no-show or cancellation invoices',
            'associate_payments_to_follows_invoice' => 'It is not possible to associate payments to a receipt marked as \'follows invoice\'',
        ],
    ],
    'reservation_note' => [
        'fields' => [
            'reservation_internal' => 'internal notes',
            'reservation_customer' => 'guest notes',
            'accommodation_customer' => 'accommodation notes',
            'accommodation_checkin' => 'accommodation check-in notes',
            'accommodation_checkout' => 'accommodation check-out notes',
            'accommodation_housekeeper' => 'Note to the housekeeper'
        ],
        'deposit' => [
            'card_info' => 'Credit card type :card_type number :card_number, code :card_code and expire date :expire_date registered',
            'wording' => 'Deposited the amount :amount with payment method :payment_method by the guest :customer',
        ],
    ],
    'reservation_payment' => [
        'move_errors' => [
            'reservation_payment_is_not_payment' => 'The payment made on :date to :accountholder is a refund',
            'reservation_payment_rows_with_bills' => 'The payment made on :date to :accountholder has charges associated with it',
            'reservation_payment_is_invoiced' => 'The payment made on :date to :accountholder is present in already issued documents',
            'reservation_payment_with_different_invoice_layout' => 'The payment made on :date to :accountholder has an invoicing profile not present in the destination property',
        ],
        'pre_check_errors' => [
            'reservation_payment_is_not_payment' => 'The payment is a refund',
            'reservation_payment_rows_with_bills' => 'The payment has charges associated with it',
            'reservation_payment_is_invoiced' => 'The payment is present in already issued documents',
        ],
    ],
    'reservation_quote' => [
        'export_fields' => [
            'reference_number' => 'Number',
            'created_at' => 'Created',
            'customer_full_name' => 'Guest',
            'expire_date' => 'Expiry date',
            'status' => 'Status',
            'property' => 'Property',
            'expire_date_availability' => 'Option expiration',
            'email_read_at' => 'Read on',
            'total' => 'Total',
            'stay' => 'Stay',
            'accommodations' => 'Accommodations',
            'treatment' => 'Treatment',
            'guests' => 'Guests',
            'option' => 'Option',
            'customer_email' => 'Email address',
            'customer_telephone' => 'Phone',
        ],
        'status' => [
            'active' => 'Authorised',
            'revoked' => 'Declined',
            'accepted' => 'Accepted',
            'expired' => 'Expired',
            'draft' => 'Draft',
        ],
        'errors' => [
            'no_email_found' => 'No email address have been provided to send the quotation to. Please give at least one.',
            'email_already_feedback_cannot_update' => 'It is not possible to change the quotation because the guest has already seen it or replied',
            'no_customer_specified' => 'The quotation is not associated to any user.',
            'quote_not_active' => 'The quotation is no longer valid.',
            'quote_option_empty' => 'The option in the quotation does not contain any rooms and is therefore impossible to confirm',
            'quote_option_no_availability' => 'The accommodations you are trying to reserve are no longer available',
            'upload_attachment' => 'File loading error',
            'other_modified' => 'This quote is no longer available because it has been modified by another user',
            'no_valid_property' => 'You cannot enter accommodation from a different property in this quote option',
        ],
        'children' => '{1} 1 Child|[2,*] :count Children',
        'adults' => '{1} 1 Adult|[2,*] :count Adults',
    ],
    'reservation' => [
        'notes' => [
            'accommodation_internal' => 'internal accommodation note',
            'accommodation_checkout' => 'accommodation check-out notes',
            'accommodation_checkin' => 'accommodation check-in notes',
            'accommodation_bill' => 'accommodation charges notes',
            'accommodation_housekeeper' => 'accommodation housekeeper notes',
            'accommodation_customer' => 'accommodation guest notes',
        ],
        'export_fields' => [
            'id' => 'Id',
            'booked_at' => 'Date/time of booking',
            'channel_name' => 'Channel',
            'booker_full_name' => 'Booker',
            'group_label' => 'Group',
            'accommodations' => 'Accommodations',
            'period' => 'Stay',
            'tag' => 'Label',
            'arrival_date' => 'Arrival date',
            'departure_date' => 'Departure date',
            'number_nights' => 'Number of nights',
            'total_price' => 'Amount',
            'property_name' => 'Property',
            'reservation_id' => 'Reservation ID',
            'room' => 'Room',
            'total' => 'Total',
            'status' => 'Status',
            'property' => 'Property',
            'stay' => 'Stay',
            'nic' => 'National Insurance Number',
            'currency' => 'Currency',
            'booker_email' => 'Booker Email',
            'booker_telephone' => 'Booker telephone number',
            'treatments' => 'Treatments',
            'commission_amount' => 'Commission Amount',
            'reference_number' => 'Reference number',
            'group' => 'Group',
            'internal_note' => 'Internal Notes',
            'note_customer' => 'Guest\'s notes',
            'booker' => 'booker',
            'channel' => 'Channel',
            'modified_at' => 'Date/time of last modification',
            'guests' => 'Guests',
            'advance' => 'Deposit',
            'extra' => 'Extra services',
            'city_tax' => 'City Tax',
            'xml_reservation_id' => 'Channel reservation ID',
            'user' => 'User',
            'original_accommodations' => 'Booked accommodations',
            'reservation_reason_id' => 'Reason of reservation',
            'reservation_from_id' => 'Origin',
            'company' => 'Company',
            'total_to_pay' => 'Total to pay',
            'rateplans' => 'Rate plans',
            'escalate_report_to_booking' => 'Inoltrare segnalazione a Booking.com?',
            'allow_guest_to_book_again' => 'Permettere all\'ospite di prenotare di nuovo?',
        ],
        'activity' => [
            'new' => [
                'message' => 'New booking from :channel_name',
                'message_sclak_deleted_key' => 'Access code deleted on Sclak successfully for the accommodation: :accommodation_name (:tableau_label)',
                'message_sclak_generated_key' => 'Access code generated on Sclak successfully for the accommodation: :accommodation_name (:tableau_label)',
                'message_sclak_sms_sent' => 'The sms with the Sclak codes has been sent to the number :telephone_number',
                'invoice_printig_session' => 'Fiscal printing sent to the printer :printer_name (ID: :printer_id) for the receipt with ID: :invoice_id',
                'added_payment' => 'Added the payment of :amount :currency (ID: :payment_id) registered with :payment_method',
                'added_refund' => 'Refund of :amount :currency issued, (ID: :payment_id) registered with :payment_method',
                'message_nuki_deleted_key' => 'The Nuki PIN for the accommodation :accommodation_name (:tableau_label) has been deleted',
                'message_nuki_generated_key' => 'The Nuki PIN for the accommodation :accommodation_name (:tableau_label) has been generated',
            ],
            'update' => [
                'message' => 'Field :field_translate was changed from :old_value to :new_value',
                'message_novalue' => 'Field :field_translate has been changed',
                'message_newvalue' => 'Entry :field_translate :new_value',
                'message_deletevalue' => 'Cancel :field_translate :old_value',
                'message_forobject' => 'Field :field_translate was changed from :old_value to:new_value by :model_type :model_name',
                'message_split_accommodation' => 'The room booked :accommodation_source (refer to tableau: :tableau_label_source) (from :original_arrival_date to :original_departure_date) was divided from :split_arrival_date to :split_departure_date and moved to the room :accommodation_destination (refer to tableau: :tableau_label_destination)',
                'message_move_accommodation' => 'The room booked :accommodation_source (refer to tableau: :tableau_label_source, Rateplan: :rateplan_name_source , Treatment: :treatment_name_source , Price: :price_source) was moved to the room :accommodation_destination (refer to tableau: :tableau_label_destination, Rateplan: :rateplan_name_destination , Treatment: :treatment_name_destination , Price: :price_destination)',
                'message_resend_email_customer' => 'Email prenotazione nuovamente inviata al prenotante, indirizzo :new_value',
                'message_resend_email_company' => 'Email prenotazione nuovamente inviata all\'azienda, indirizzo :new_value',
                'message_resend_email_property' => 'Email prenotazione nuovamente inviata alla struttura, indirizzo :new_value',
                'message_resend_email_additional' => 'Email prenotazione nuovamente inviata all\'indirizzo aggiuntivo :new_value',
                'message_sdi_rejected_invoice_as_receipt' => 'The following receipt has been rejected :invoice_number of :invoice_date with the invoice profile :invoice_layout (:invoice_business_name - :invoice_vat_code) for the recipient :invoice_customer (Total :invoice_total), with the following notifications: :sdi_notify',
                'message_restored_sdi_rejected_invoice' => 'The following document has been re-opened :invoice_number of :invoice_date with the following notifications: :sdi_notify',
                'message_sdi_rejected_invoice' => 'The following document has been rejected :invoice_number of :invoice_date issued with the invoice profile :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'delete_bill' => 'The following charges have been deleted: :extra',
                'add_extra' => 'The following charges have been added: :extra',
                'no_guests_calculate_city_tax' => 'The city tax has been processed but there are no elegible guests for the computation',
                'calculate_city_tax' => 'The city tax charge has been added for the guests: :guests',
                'message_restored_invoice' => 'This document has been rejected :document_type :invoice_number of :invoice_date issued with the invoice profile :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'message_registered_invoice' => 'This documenti has been issued :document_type :invoice_number :follows_invoice of :invoice_date issued with the invoice profile :invoice_layout (:invoice_business_name - :invoice_vat_code) for the recipent :invoice_customer (Total :invoice_total) :manual_fp_register',
                'transferred_bills_qty_to_charges' => 'It has been transferred the amount of  :transfer_label of the charges: :bills_label to the single bill :invoice_label (:invoice_id)',
                'transferred_bills_to_accommodation_multi_customer' => 'It has been transferred the amount of: :transfer_label of the charges: :bills_label to the accommodation :accommodation_label (:accommodation_id) - Reservation :reference_numberof the guests: :customers',
                'transferred_bills_to_accommodation' => 'It has been transferred the amount of: :transfer_label of the charges: :bills_label to the accommodation :accommodation_label (:accommodation_id) - Reservation:reference_number',
                'transferred_bills_to_charges' => 'It has been transferred the amount of: :transfer_labelof the charges: :bills_label to a single bill :invoice_label (:invoice_id)',
                'transferred_bills_qty' => 'It has been trasferred the quantity of :transfer_label degli addebiti: :bills_label',
                'transferred_bills' => 'It has been trasferred on :transfer_label degli addebiti: :bills_label',
                'restored_bills' => 'Charges have been restored:: bills_label',
                'transferred_bills_to_accommodation_reservation_destination' => 'The following charges were transferred from the sigle bill: invoice_origin (#: invoice_origin_id):: bills_label',
                'transferred_bills_qty_to_accommodation_multi_customer' => 'The amount of :transfer_label of charges: has been transferred to :bills_label to the accommodation: accommodation_label (: accommodation_id) - Reservation: reference_number to the guests: :customers',
                'transferred_bills_qty_to_accommodation' => 'The amount of :transfer_label of charges: has been transferred to :bills_label to the accommodation: accommodation_label (: accommodation_id) - Reservation: reference_number',
                'message_deleted_credit_note' => 'This document has been deleted :document_type :invoice_number of :invoice_date issued with the invoice layout :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'message_sdi_rejected_invoice_with_advances' => 'The following document has been rejected :invoice_number of:invoice_date issued with the invoice layout :invoice_layout (:invoice_business_name - :invoice_vat_code)with the following advanced payments :advances',
                'edit_payment' => 'Modified payment (ID: :payment_id) registered with :payment_method. Total :amount :currency',
                'guest_checkin_checkout' => 'The arrival and departure dates have been changed, following change of room stay dates, for the following guests :guests',
                'restored_payment_to_reservation' => 'The payment (#:paymentId) registered on :date associated to :accountholder has been restored from the reservation :reservationOrigin',
                'transferred_payment_to_reservation' => 'The payment (#:paymentId) registered on :date associated to :accountholder has been transferred from the reservation :reservationOrigin to the reservation :reservationDestination',
                'message_edit_guest' => 'The guest :guest_name has been modified',
                'model_price_original' => 'The field :field_translate was changed from :old_value to :new_value. The customer chose to keep the current price.',
                'model_price_moved' => 'The field :field_translate was changed from :old_value to :new_value. The customer chose the new price.',
            ],
            'customer_note' => 'Guest\'s requests: :note',
            'catering_note' => 'Meal note: :note',
            'bill_note' => 'Billing note: :note',
            'internal_note' => 'Internal note: :note',
            'delete' => [
                'delete_payment' => 'Removed payment of :amount :currency (ID: :payment_id) registered with :payment_method',
            ],
            'view' => [
                'credit_card_fail' => 'An attempt was made to read your credit card. (:ip_address)',
                'credit_card_success' => 'Your credit card information has been displayed. (:ip_address)',
            ],
            'nuki' => [
                'create' => 'Nuki device (:device_id): door code created for room :tableau_label',
                'update' => 'Nuki device (:device_id): code permissions updated for room :tableau_label',
                'delete' => 'Nuki device (:device_id): door code deleted for room :tableau_label',
            ],

        ],
        'wording' => [
            'advance_invoice' => 'Stay from :date_from to :date_to',
            'customer' => 'Guest: ',
            'advance_count' => 'Deposit n: ',
            'partial' => 'Partial',
            'total' => 'Total',
            'credit_note' => 'Refund from :type no. :number of the :invoice_date',
            'city_tax_label' => ':cost per night from :min_age to :max_age years old for a maximum of :limit_days days',
            'city_tax_label_no_limit' => ':cost per night from :min_age to :max_age years old without limit of days',
            'accommodation_bill_label' => 'Stay',
        ],
        'fields' => [
            'model_name' => 'booking',
            'arrival_date' => 'Arrival date',
            'departure_date' => 'Departure date',
            'total_price' => 'final price',
            'total_adults' => 'number of adults',
            'overbooking' => 'overbooking',
            'label_name' => 'guest group',
            'reason' => 'reason of your journey',
            'total_children' => 'number of children',
            'split_reservation' => 'divide booking',
            'move_accommodation' => 'Move accommodation',
            'accommodation_bill' => 'Bill notes',
            'status' => 'status',
            'keep_availability' => 'do not restore',
            'expiration_date' => 'expiration date',
            'availability_option' => 'availability option',
            'resend_email' => 'new email send',
            'commission_amount' => 'commission amount',
            'reservation_reason_id' => 'reservation reason identifier',
            'reservation_from_id' => 'origin',
            'reservation_bill' => 'reservation bill',
            'reservation_checkin' => 'reservation check-in',
            'reservation_checkout' => 'reservation check-out',
            'sclak_generated_key' => 'Generated access code on Sclak successfully',
            'sclak_deleted_key' => 'Deleted access code on Sclak successfully',
            'sclak_sms_sent' => 'Slack code SMS sent',
            'partner_download' => 'partner download',
            'commissionable_amount' => 'commissionable amount',
            'is_group' => 'is group',
            'commission_discount_type_id' => 'commission discount type identifier',
            'commission_discount_value' => 'commission discount value',
            'added_credit_card_data' => 'added credit card data',
        ],
        'payment_status' => [
            'paid' => 'Paid',
            'to_be_invoiced' => 'To be invoiced',
            'to_pay' => 'To be paid',
            'suspended' => 'pending',
        ],
        'policy' => [
            'none' => 'No penalty',
        ],
        'errors' => [
            'not_mapped_accommodation' => 'The accommodation is not mapped correctly',
            'last_accommodation' => 'Unable to delete the last available accommodation',
            'not_tableau' => 'Planning Accommodation number not set for this bed configuration',
            'impossible_change' => 'Impossible change the status',
            'missing_roomreservation_id' => 'No room found for the room reservation sent',
            'missing_order' => 'Order not found',
            'existing_bills_invoiced' => 'There are invoices and receipts related to this booking. Impossible proceed',
            'uneditable_field' => 'Field cannot be changed',
            'no_gateway_response' => 'Connection error with payment gateway',
            'reservation_unpaid' => 'Your transaction didn\'t go through',
            'missing_balance' => 'Outstanding balance',
            'uneditable_fields_invoice' => 'The following fields cannot be changed: ',
            'not_editable_total_due_paid' => 'Price inserted is less than the total paid',
            'not_editable_total_due_invoice' => 'Price inserted is less than the invoice total',
            'accommodation_room_guest_exists' => 'The guest already exists in the specified dates',
            'no_payment_amount_enough' => 'The credit available (:amount_available) is not enough to cover the cost (:request_amount)',
            'payment_amoun_minor_of_amount_used' => 'The specified amount (:request_amount) is lower than previously used (:amount_used_global)',
            'cannot_delete_deposit_invoice' => 'The payment cannot be cancelled because it has already been used in an issued invoice',
            'accommodation_invoiced' => 'The room has already been invoiced, it cannot be cancelled',
            'resend_email_empty_address' => 'No email address was specified for this guest',
            'householder_in_agreement' => 'The family master is included in the bills\'splitting, change the customization before proceeding with this change',
            'missing_company' => 'The company contact details are missing for this booking',
            'accommodation_bill_charged' => 'Room charge invoiced. Impossible to proceed',
            'all_billed' => 'All charges have been issued or transferred. Unable to restore',
            'impossible_move_nature_bill' => 'Impossible to move the nature of the charge to a volatile account: ',
            'billed_accommodation' => 'It is not possible to change the booking dates because tax documents have been issued.
    Insert a new booking or add a room to this booking with new dates.',
            'deposit_as_refund' => 'A deposit cannot be configured as a refund',
            'refund_in_invoice' => 'Refunds cannot be associated to invoices or receipts',
            'different_vat_codes' => 'Payments and receipt followed by invoice cannot be associated to billing profiles with VAT different to those specified in the document',
            'property_not_attached' => 'Payments to hotels not involved in bookings are not allowed',
            'too_many_payments' => 'The payment amount exceed the cost or payment to be refunded',
            'bill_and_expense' => 'Impossible to link the payment to a charge or a cost',
            'expense_minimum_payment' => 'The expense must have at least a payment, impossible to proceed',
            'missing_reservation' => 'Invalid booking.',
            'amount_exceed_refunds' => 'The payment to associate exceeds the part used considered as refunds',
            'company_email_address_is_empty' => 'Company email address is missing',
            'pax_fields_in_not_paxable_bill' => 'Unable to set a different guest for the extra charges calculated on the guests',
            'impossible_decrement_shared_bill' => 'Unable to decrease the quantity of a split charge',
            'transfer_on_same_customer_bill' => 'Unable to split the charge to the same payer',
            'no_guests_loaded' => 'No guests registered for this accommodations',
            'document_on_payments_out' => 'Unable to issue a document for outflow payments',
            'document_on_refunded' => 'unable to issue a document for a reimbursed payment',
            'not_whole' => 'Unable to issue a document for associated payments',
            'document_on_used_payment' => 'Unable ti issue a document for payments used to settle other documents',
            'document_on_funds' => 'Unable to issue an invoice for cash fund amount',
            'deposit_as_advance' => 'Unable to issue a deposit invoice for a deposit payment type',
            'deposit_as_deposit' => 'The payment is already a deposit, unable to proceed',
            'checkinonline_reservation_arrival_date_past' => 'The arrival date is antecedent to current date.',
            'checkinonline_reservation_is_not_confirmed' => 'The reservation is not confirmed',
            'checkinonline_reservation_is_cancelled' => 'The reservation has been cancelled.',
            'checkinonline_reservation_not_found' => 'Reservation not found.',
            'checkinonline_dati_mancanti' => 'Data not sent correctly.',
            'checkout_major_checkin' => 'Check-out date greater or equal to the check-in date for the room :accommodation_name, unable to proceed',
            'checkin_major_checkout' => 'Check-in date greater or equal to the check-out date for the room :accommodation_name, unable to proceed',
            'no_show_requested_total_major_bills_to_invoice' => 'Total requested as no show higher than the value to be invoiced',
            'discount_over_invoiced_value' => 'Price difference to be applied greater than the value to be invoiced',
            'no_bills_on_customer' => 'There are no charges for the billing recipient set on the bill-splitting',
            'channel_checkin_missing_status_already_present' => 'The check-in status has been processed',
            'channel_checkin_missing_info' => 'No information on the request status',
            'different_accommodation_checkout_date' => 'The reservation\'s accommodations have different check-out dates',
            'different_accommodation_checkin_date' => 'The reservation\'s accommodations have different check-in dates',
            'missing_addon' => 'Extra service with missing fields, unable to continue',
            'checkinonline_reservation_departure_date_over' => 'The stay has already ended.',
            'checkinonline_city_tax_cannot_pay' => 'No city tax to pay.',
            'already_cancelled' => 'The reservation is already cancelled.',
            'not_switch_virtual' => 'Unable to move the reservation into a virtual room of a different property',
            'conflict_system_custom_email_template' => 'More than one template has been selected to be sent, please only select one.',
            'have_door_service_active' => 'Unable to manually add an access code because the external service :external_service_name is active on the account',
            'missing_customer_on_split_bills_same_reservation' => 'Unable to split charges on the same reservation without specifying the payers',
            'accommodation_not_found' => 'The accommodation has been deleted',
            'missing_main_room_guest' => 'Main guest not set for all accommodations',
            'property_deleted' => 'Unable to cancel the reservation, please contact the property',
            'can_not_modify_ota_checkin_checkout' => 'It is not possible to change the dates of a booking from a channel.',
            'can_not_move_reservation_payments' => 'Unable to transfer the payments for the following errors: :errors',
            'guest_already_present_in_same_dates' => 'Unable to proceed: guest already registered for the same dates',
            'unsuitable_dates_for_guests' => 'Stay dates incompatible for guests: :guests',
            'unsuitable_dates_for_guests_one_day' => 'Multiple stay dates for guests: :guests for a single overnight stay, please remove one of the stays before proceeding',
        ],
        'warnings' => [
            'not_mapped_addons' => 'The service chosen does not appear to be connected to the room: ',
            'bill_charged' => 'One or more charges already invoiced, unable to modify.',
            'bill_splitted' => 'Charge splitted over several bills cannot be changed: ',
            'bill_children' => 'Partial derived charge cannot be changed: ',
            'all_bills_closed' => 'All bills are closed for this booking',
            'deposit_cut' => 'Refund of a charge payment carried out: ',
            'not_existing_bill' => 'Charge non-existent',
            'exceeding_num_adults' => 'The number of adults exceeds the maximum number set for the room',
            'exceeding_num_children' => 'The number of children exceeds the maximum number set for the room',
            'existing_payments_pending' => 'Payments pending for charges on the room, do you still want to proceed?',
            'customer_invoiced' => 'There are invoices issued for the guest :customer that cannot be cancelled',
            'is_previous' => 'Booking prior to setting up the channel',
            'no_guests' => 'No guest present in this booking',
            'guest_no_birthday' => 'Tax not calculated for this guest :name, surname . Date of birth missing.',
            'bill_rows_discount_deleting' => 'The transfer caused the reset of the discount of the original charge',
            'bill_discount_unsuitable_to_row' => 'The discount calculated is incompatible with the portion of the charge already invoiced',
            'bill_deposit_not_allowed' => 'Unable to associate this payment to this type of charge',
            'bill_qty_incoerence' => 'Quantity not coherent with the number of guests associated to the charge',
            'bill_cant_split' => 'Unable to split this charge for this type ',
            'existing_invoices_joined' => 'There are existing documents issued for this charge :bill_name, unable to trasnfer to external invoices or accommodations',
            'existing_bills_night' => 'The extra charges of the nights not included in the stay will be deleted',
            'bills_not_found' => 'Charges not found',
            'move_other_property_notify' => 'Choose a property to send the notifications from',
            'change_status_in_progress' => 'The reservation is already undergoing a change of status.',
            'reservation_accommodation_door_key_code_generate' => 'An error occurred while generating the access codes. Please try again manually',
            'reservation_accommodation_door_key_code_delete' => 'An error occurred while deleting the access codes. Please try again manually',
            'reservation_accommodation_door_key_code_exist_moved_accommodation' => 'One or more accommodations have been moved. It is necessary to regenerate a new key code.',
            'reservation_accommodation_door_key_code_exist' => 'There are door opening codes. Proceed manually for regeneration or revocation.',
            'existing_transferred_bills' => 'There are charges transferred from other accommodations, you must restore or reassign them before proceeding',
            'reservation_accommodation_door_key_code_reservation_resumed' => 'A new key code must be generate, the previous one has been disabled due to a reservation status change. ',
            'bill_has_payment' => 'There are payments related to the charge :bill_name, unable to transfer to external rooms or documents',
        ],
        'channels' => [
            'no_report_invalid_cc' => 'Report invalid credit card not required for this channel',
            'no_report_noshow' => 'Report no show not required for this channel',
            'no_report_cancellation_due_invalid' => 'Report cancellation not required for this channel',
            'payment_to_ota' => 'Payment made on the portal :channel_name',
            'no_previous' => 'This channel does not support download of previous bookings',
            'email' => [
                'without_room_title' => 'New booking without room from :channel_name (ID: :reference_number) - Hotel: :property_name',
                'without_rate_title' => 'New reservations without rate plans from :channel_name (ID: :reference_number) - Property: :property_name',
            ],
        ],
        'bills' => [
            'reservation_bill_id_not_found' => 'ID :reservation_bill_id does not belong to the specified booking',
            'reservation_bill_id_already_override' => 'ID :reservation_bill_id is already overridden',
            'reservation_bill_id_no_updates' => 'All elements have already been overridden or do not belong to the specified booking',
            'delete_bill_accounted' => 'Impossible to eliminate because one or more elements have already be recorded',
            'delete_sheet_bill_emitted' => 'Unable to delete the bill because the invoice has already been issued',
            'different_vat_quotes_in_merge' => 'Impossible to overwrite charges with a different VAT number',
            'cant_editable_due_moved' => 'This charge has been transferred: modification allowed only for the discount',
        ],
        'invoice' => [
            'invoice_already_registered' => 'The Invoice has already been issued',
            'no_invoice_layout' => 'There is no inovice layout present. Impossible to continue',
            'no_an_invoice' => 'This is not an invoice',
            'no_company_id' => 'No company has been specified to issue the invoice to',
            'unsuitable_payments' => 'The payments associated are not compatible with the VAT code connected to the account',
            'too_many_advances' => 'The value of the payments on account exceed the total charges',
            'advances_in_advance' => 'Impossible to include deposits in a down payment invoice',
            'payments_major_total_invoice' => 'The total of the payment is higher than the total of the invoice',
        ],
        'pdf' => [
            'reservation' => [
                'booker' => [
                    'origin' => 'Reference channel',
                    'name' => 'Guest name',
                    'telephone' => 'Tel',
                    'email' => 'Email',
                    'pec' => 'PEC',
                    'language' => 'Language',
                    'reference_number' => 'Reservation number',
                    'booked_at' => 'Reservation date',
                    'commissionable_amount' => 'Amount subject to commission',
                    'commission_amount' => 'Commission',
                    'other_infos' => 'Important information on this guest',
                    'notes' => [
                        'note_internal' => 'Internal notes',
                        'note_customer' => 'Guest notes',
                        'note_bill' => 'Payment notes',
                        'note_checkin' => 'Check-in notes',
                        'note_checkout' => 'Check-out notes',
                    ],
                ],
                'accommodation' => [
                    // 'room_number' => '', NO!!!!
                    'from_date' => 'Arrival',
                    'to_date' => 'Departure',
                    'duration' => 'Duration of the stay',
                    'duration_text' => '{1} :length night|[2,*] :length nights',
                    // ':length notti',
                    'total_guests' => 'Guests total',
                    'guests_adults_text' => ':quantity adults',
                    'guests_children_text' => ':quantity children',
                    'total_accommodations' => 'Total number of rooms',
                ],
                'reservation' => [
                    'name' => 'Guest name',
                    'total_guests' => 'Number of guests',
                    'guests_adults_text' => ':quantity adults',
                    'guests_children_text' => ':quantity children',
                    'max_capacity' => 'Maximum occupation',
                    'capacity_text' => ':quantity guests',
                    'meals' => 'Meals',
                    'meals_breakfast_included' => 'Breakfast is included in the room rate',
                    'table' => [
                        'date' => 'Date',
                        'price' => 'Price',
                        'price_per_day' => 'Price per night',
                        'non_refundable_rate' => 'Non-refundable rate',
                        // !?! TODO:
                        'subtotal' => 'Subtotal',
                        'city_tax' => 'City Tax',
                        'city_tax_detail' => 'Amount per person per night',
                        'total_accommodation_price' => 'Accomodation total price',
                        'vat_included' => 'The rate includes :amount VAT',
                        'vat_not_included' => 'VAT not included in the rate',
                    ],
                ],
                'totals' => [
                    'statuses' => [
                        'Cancelled' => 'Cancelled',
                        'Optionable' => 'Optional',
                        'Hidden' => 'Hidden',
                        'Pending' => 'Pending payment',
                        'Confirmed' => 'Confirmed',
                        'Expired' => 'expired',
                    ],
                    'status' => 'Booking status',
                    'total_amount' => 'Total amount',
                    'paid_deposit' => 'Deposit paid',
                    'total_paid' => 'Paid',
                    'total_to_be_paid' => 'To be paid',
                ],
                'payments' => [
                    'table' => [
                        'date' => 'Registration date',
                        'method' => 'Payment method',
                        'amount' => 'Amount',
                        'notes' => 'Notes',
                    ],
                ],
                'filters' => [
                    'in_house' => 'In house',
                    'arrival_date' => 'Check-in',
                    'departure_date' => 'Checking-out',
                ],
                'statuses' => [
                    'cancelled' => 'Cancelled',
                    'optionable' => 'Optional',
                    'hidden' => 'Hidden',
                    'pending' => 'Pending payment',
                    'confirmed' => 'Confirmed',
                ],
            ],
            'bills' => [
                'accommodations' => 'Accommodations',
                'accommodation' => 'Accommodation',
                'total' => 'Total',
                'date' => 'Date',
                'room' => 'Room',
                'treatment' => 'Package details',
                'amount_per_night' => 'Amount per night',
                'addons_categories' => 'Extra services',
                'addon_category' => 'Type',
                'addon_name' => 'Service',
                'addon_price_type' => 'Rate Type',
                'amount' => 'Amount',
                'taxes' => 'Tax',
                'tax_name' => 'Type',
                'accommodations_title' => 'Accommodation details',
                'addons_categories_title' => 'Details on extra services',
                'taxes_title' => 'Details on Taxes',
            ],
            'guests' => [
                'guests_list' => 'List of guests registered for the booking',
                'reservation_of_date' => 'for',
                'duration_text' => ':length nights',
                'from' => 'From',
                'to' => 'To',
                'table' => [
                    'type' => 'Type',
                    'name' => 'Name',
                    'surname' => 'Surname',
                    'birthday_date' => 'Date of birth',
                    'gender' => 'Gender',
                    'birth_place' => 'Place of birth',
                    'checked_in' => 'Check-in done',
                    'none' => 'No guest registered',
                ],
            ],
            'payment' => [
                'payments_short_title' => 'Payment details',
                'payments_title' => 'Payments and documents',
                'report_title' => 'Payment note',
                'issuer' => 'Payer\'s name',
                'registration_date' => 'Payment registration date',
                'payment_date' => 'Payment date',
                'method' => 'Payment method',
                'amount' => 'Amount',
                'pos' => 'POS',
                'deposit_number' => 'Deposit number',
                'payments_received' => 'Payments received',
                'notes' => 'Note',
                'deposit' => 'Deposit',
                'to_pay' => 'Amount to be paid',
                'excess_payment' => 'Total amount paid in excess',
                'invoiced' => 'Invoiced amount',
                'to_be_invoiced' => 'Amount to be invoiced',
                'total_to_be_invoiced' => 'Total amount to invoice',
                'document_type' => 'Document type',
                'document_number' => 'Number',
                'document_date' => 'Issue date',
                'invoice_issuer' => 'Account holder',
                'invoice_paid' => 'Paid',
                'invoice_to_pay' => 'To be paid',
                'deposit_title' => 'Deposit',
                'refund_title' => 'Refund note',
                'payment' => 'Payment',
            ],
            'fees' => [
                'fees_title' => 'VAT Fee Payments',
                'document_type' => 'Type',
                'total' => 'Total',
                '22' => 'VAT 22%',
                '10' => 'VAT 10%',
                'customer' => 'Guest or company',
            ],
            'deposits' => [
                'deposits_title' => 'Advances and deposits',
                'export_fields' => [
                    'number' => 'Number',
                    'date' => 'Date',
                    'total' => 'Total',
                    'amount_available' => 'Amount available',
                    'used' => 'Used',
                    'reservation_id' => 'Booking Id',
                    'pos' => 'Pos',
                    'type_payment' => 'Type of payment',
                    'type_reservation' => 'Booking type',
                    'description' => 'Description',
                    'user_pay' => 'Payer',
                    'reservation' => 'Bookings',
                    'payment_method' => 'Payment method',
                    'stay' => 'Stay',
                    'departure_date' => 'Departure date',
                    'property' => 'Property',
                ],
            ],
        ],
        'reservation' => 'Reservation',
        'details' => [
            'inserted' => 'The cost of the service :title is :amount :currency',
        ],
        'policy_deposit_description' => 'Payment overview',
        'payments_timetable' => [
            'title' => 'Payments Timetable',
            'statuses' => [
                'scheduled' => 'Scheduled',
                'processed' => 'Processed',
                'failed' => 'Failed',
                'paused' => 'Paused',
                'cancelled' => 'Cancelled',
                'wait_customer' => 'Waiting for customer',
                'partial_processed' => 'Partial processed',
            ],
            'subtitle' => 'The dates on which the stay will be charged are as follows',
            'city_tax' => [
                'checkin_online' => 'The city tax of :amount is excluded and will be automatically charged after completing the online check-in. If the online check-in is not completed, it will be charged directly at the property.',
                'checkout' => 'The amount of :amount is an estimate and may vary in the presence of exemptions or changes in the number of guests or nights stayed.'
            ],
        ],
        'policy_description' => 'Policy overview',
        'accommodations' => 'Accommodations',
        'nights' => 'Nights',
        'departure_date' => 'Check-out',
        'arrival_date' => 'Check-in',
        'of_date' => 'of: date',
        'log' => [
            'bill_title' => 'Charges',
            'extra_log_title' => 'Extra charges',
            'city_tax_log_title' => 'City tax',
            'notes' => 'Notes section',
            'guest' => 'Guest',
            'payment' => 'Payment',
        ],
        'errors_reason' => [
            'not_exist' => 'Reason not found',
            'delete_system' => 'Unable to delete the system option',
            'update_system' => 'Unable to delete the system option',
        ],
        'customer_profile_deleted' => 'This customer\'s profile has been deleted and cannot be modified. Do you want to reactivate it to proceed with the changes?',
    ],
    'rhino' => [
        'exceptions' => [
            'request_not_valid' => 'Missing fields',
            'method_not_found' => 'The called method does not exist',
        ],
        'vat_code_already_exists' => 'This VAT number is already present in the system. Please make sure to enter a unique VAT number that has not already been registered.',
    ],
    'roles' => [
        'property' => [
            // TODO:
            // TODO:
            'master' => 'Management',
            'operator' => 'Operator',
            'housekeeper' => 'Housekeeper',
        ],
        'errors' => [
            'access_denied_property' => 'Wrong role: the user does not have director permissions to access the structure.'
        ]
    ],
    'sca' => [
        'pdf' => [
            'filename' => 'Credit cards authorization',
            'card_holder' => 'Holder name',
            'card_type' => 'Credit Card type',
            'card_number' => 'Credit card number',
            'card_expiration' => 'Expiry date',
            'card_cvc' => 'CVC',
            'parts' => [
                'p1' => 'Credit cards authorization',
                'p2' => 'Be Careful! – Filds marked with asterisk are mandatory',
                'p3' => 'Please provide all the information to proceed with the confirmation of your reservation.',
                'p4' => 'Send the filled form together with other necessary documents to: <span class="link">:email</span>',
                'p5' => 'Card holder information:',
                'p6' => 'Is certified that the information provided are correct and accurate.',
                'p7' => 'I hereby authorize the charge of the amount indicated on the following credit/debit card',
                'p8' => '<span class="bold">For the non-refundable rates</span>, the given credit card will be charged for the amount required.',
                'p9' => '<span class="bold">For flexible rates</span>, the given credit card could be subject to verification and validity check prior pre-authorization for the due amount as provided by the policy.',
                'p10' => 'Card holder signature',
                'p11' => 'Reservation number',
                'p12' => 'Arrival Date',
                'p13' => 'Along with this document you are required to send front/back of the credit/debit card used for the payment and a copy of the Identity Card/Passport of the cardholder. Make sure the required documents are promptly sent to: <span class="link">:email</span>',
                'p14' => 'Not getting the required documents, the reservation will be considered null and canceled accordingly. All information will be considered confidential and used only for the purposes mentioned above.',
                'p15' => ':name – :address, :zip_code – :city_name <span class="link">:email</span> - <span class="link">:website</span>',
            ],
        ],
        'confirmation_request_expired' => 'Request already expired',
        'email' => [
            'subject' => ':property - Authorization request',
            'payment_confirmation' => 'Confirm payment',
            'reservation_confirmation' => 'Reservation confirmation number :referenceNumber',
            'date' => 'Date',
            'click_here_link' => 'Click here to confirm the SCA procedure',
            'payment_total' => 'Payment total',
            'reservation_total' => 'Reservation total',
            'payment_summary' => 'Payment overview',
            'reservation_summary' => 'Reservation overview',
            'we_are_waiting_for_you_on_date' => 'We are looking forward to seeing you on :date',
            'you_payment_for' => 'Your payment for :name',
            'your_reservation_for' => 'Your reservation for :name',
            'dear_customer_payment' => 'Dear :name :surname, <br /> To secure your reservation, we invite you to authorize the use of your credit card according to the booking and cancellation conditions.<br><br>Thank you for your cooperation.',
            'dear_customer_reservation' => 'Dear :name :surname, <br /> To secure your reservation, we invite you to authorize the use of your credit card according to the booking and cancellation conditions.<br><br>Thank you for your cooperation.',
            'subject_reservation' => ':name :surname, confirm your reservation',
            'payment_click_here_link' => 'Click here to confirm the payment',
            'authorize_card_use' => 'Authorize card use',
            'non_beddy_reservation_click_here_link' => 'Click the following link to confirm the payment: :link',
            'non_beddy_payment_click_here_link' => 'Click the following link to confirm the reservation: :link',
            'sca_payment_accepted' => 'We inform you that your request for confirmation of the SCA / PSD2 form for booking #:referenceNumber has been accepted by the guest.',
            'sca_reservation_accepted' => 'We inform you that your request for confirmation of the SCA / PSD2 form for booking #:referenceNumber has been accepted by the guest.',
            'subject_accepted' => 'SCA / 3DS authorization has been confirmed',
        ],
        'whatsapp' => [
            'message' => 'Dear :name :surname, to confirm your reservation #:referenceNumber (:arrivalDate - :departureDate) we need your credit card authorization. Click here :link',
        ],
    ],
    'social_archive' => [
        'export_fields' => [
            'property_name' => 'Property',
            'unlock_email' => 'Email',
            'unlock_date' => 'Subscription Date',
        ],
    ],
    'statistics' => [
        'partitioning_translations' => [
            'yearly' => 'per year|to :value years',
            'monthly' => 'per month|to :value months',
            'daily' => 'per day|to :value days',
        ],
        'warnings' => [
            'limit_truncation' => 'Requested view period is too wide. The search interval has been limited to :partitioning_translation.',
            'previous_offset_available_only_with_daily_partitioning' => 'Comparison type only available with daily view. The selected period will be compared with the previous year',
        ],
        'exceptions' => [
            'invalid_split' => 'Operation not available',
            'not_available' => 'Feature temporarily unavailable',
            'cannot_create_groupable' => 'Invalid parameters for grouping',
            'invalid_date_range' => 'Invalid date range sent',
        ],
        'legend' => [
            'no_model' => 'Not specified',
            'deleted_rateplans' => 'Deleted rates',
            'no_treatment' => 'No treatment specified',
            'charges' => 'Manual charges',
            'no_label' => 'No name',
            'stay' => 'Stays',
            'tax' => 'Taxes',
            'ob' => 'Overbooking',
            'virtual_stamp' => 'Virtual stamp',
            'city_tax' => 'City tax',
            'no_show' => 'No Show',
            'cancellation' => 'Cancellation after deadline',
            'no_show_stay' => 'No Show stay',
            'cancellation_stay' => 'Cancellation after deadline stay',
            'no_show_extra' => 'Extra service in No Show',
            'cancellation_extra' => 'Extra service in Cancellation after deadline',
            'penalty' => 'Penalties',
            'general_invoices' => 'General invoices',
            'manual' => 'Manual charges',
            'payment' => 'Payments',
            'beddy_channel_labels' => [
                'quote' => 'Beddy (Quotes)',
                'website' => 'Beddy (Website)',
                'manual' => 'Beddy (PMS)',
                'general' => 'Beddy (General Invoices)',
                'google-hotel' => 'Google Hotel',
                'trivago-fast-connect' => 'Trivago',
                'trivago-express-booking' => 'Trivago Express Booking',
                'bookingbooster' => 'Booking Booster',
            ],
        ],
        'label' => 'Date',
        'label_date' => 'Reference date',
        'label_channel' => 'Channel segment',
        'label_accommodation' => 'Room segment',
        'label_room' => 'Tableau number segment',
        'label_booker_category' => 'Client category segment',
        'label_rateplan' => 'Rateplan segment',
        'label_reservation_from' => 'Reservation source segment',
        'label_nationality' => 'Nationality segment',
        'label_property' => 'Property segment',
        'label_dealer_company' => 'Company segment',
        'label_dealer_agency' => 'Agency segment',
        'label_dealer_tour_operator' => 'Tour operator segment',
        'label_production_type' => 'Department segment',
        'production_over_time' => 'Sales over time',
        'revenue' => 'Revenue',
        'production' => 'Production over time',
        'available_nights' => 'Available nights',
        'unsold_nights' => 'Unsold nights',
        'penalty_nights' => 'Penalty nights',
        'arrivals' => 'Arrivals',
        'departures' => 'Departures',
        'average_stay_length' => 'Average stay length',
        'average_guest_earning' => 'Average guest earning',
        'sold_nights' => 'Sold nights',
        'occupation_percentage' => 'Occupation',
        'total_price' => 'Sale',
        'adr' => 'ADR',
        'revpar' => 'Revpar',
        'counted_reservations' => 'Total reservations',
        'confirmed_reservations' => 'Confirmed reservations',
        'cancelled_reservations' => 'Cancelled reservations',
        'cancellation_ratio' => 'Cancellation ratio',
        'counted_average_booking_window' => 'counted_average_booking_window',
        'confirmed_average_booking_window' => 'Booking lead time',
        'cancelled_average_booking_window' => 'Cancellation lead time',
        'rooms_checkin' => 'Rooms arriving',
        'rooms_checkout' => 'Rooms departing',
        'label_department' => 'Department',
        'label_service' => 'Service',
        'gross_amount' => 'Gross amount',
        'share_percent' => 'Share (%)',
        'taxes' => 'VAT',
        'net_amount' => 'Net VAT',
        'quantity' => 'Quantity',
        'net_revenue' => 'Net revenue',
        'commissions_amount' => 'Commission amount',
        'in_stay_rooms' => 'Rooms in stay',
        'presence_rooms' => 'Rooms presence',
        'in_stay_guests' => 'In-house guests',
        'presence_guests' => 'Guest presence',
        'absolute_guests' => 'Guests',
        'gross_amount_without_commissions' => 'Gross amount without commissions',
        'net_amount_without_commissions' => 'Net amount without commissions and VAT',
        'gt_revenue' => [
            'rooms' => [
                'date' => 'DATE',
                'hotel_capacity' => 'HOTEL_CAPACITY',
                'rooms_sold' => 'ROOMS_SOLD',
                'rooms_ooo' => 'ROOMS_OOO',
                'rooms_revenue' => 'ROOMS_REVENUE',
            ],
            'segments' => [
                'date' => 'DATE',
                'cam_business' => 'CAM_BUSINESS',
                'rev_business' => 'REV_BUSINESS',
                'cam_tour_operator' => 'CAM_TOUR_OPERATOR',
                'rev_tour_operator' => 'REV_TOUR_OPERATOR',
                'cam_ota' => 'CAM_OTA',
                'rev_ota' => 'REV_OTA',
                'cam_beddy' => 'CAM_BEDDY',
                'rev_beddy' => 'REV_BEDDY',
                'cam_diretta' => 'CAM_DIRETTA',
                'rev_diretta' => 'REV_DIRETTA',
            ],
        ],
    ],
    'stripe' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Unknown Generic error.',
                'next_steps' => 'Contact the technical support.',
            ],
            'approve_with_id' => [
                'description' => 'The payment cannot be authorized.',
                'next_steps' => 'The payment should be attempted again. If it still cannot be processed, the customer needs to contact their card issuer.',
            ],
            'customer_max_payment_methods' => [
                'description' => 'The customer has already reached the maximum number of linked payment methods.',
                'next_steps' => 'Unlink some payment methods from this customer or proceed with a different customer.',
            ],
            'call_issuer' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'card_not_supported' => [
                'description' => 'The card does not support this type of purchase.',
                'next_steps' => 'The customer needs to contact their card issuer to make sure their card can be used to make this type of purchase.',
            ],
            'card_velocity_exceeded' => [
                'description' => 'The customer has exceeded the balance or credit limit available on their card.',
                'next_steps' => 'The customer should contact their card issuer for more information.',
            ],
            'currency_not_supported' => [
                'description' => 'The card does not support the specified currency.',
                'next_steps' => 'The customer needs to check with the issuer whether the card can be used for the type of currency specified.',
            ],
            'do_not_honor' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'do_not_try_again' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer should contact their card issuer for more information.',
            ],
            'duplicate_transaction' => [
                'description' => 'A transaction with identical amount and credit card information was submitted very recently.',
                'next_steps' => 'Check to see if a recent payment already exists.',
            ],
            'expired_card' => [
                'description' => 'The card has expired.',
                'next_steps' => 'The customer should use another card.',
            ],
            'fraudulent' => [
                'description' => 'The payment has been declined as Stripe suspects it is fraudulent.',
                'next_steps' => 'Do not report more detailed information to your customer.  Instead, present as you would the generic_decline described below.',
            ],
            'generic_decline' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'incorrect_number' => [
                'description' => 'The card number is incorrect.',
                'next_steps' => 'The customer should try again using the correct card number.',
            ],
            'incorrect_cvc' => [
                'description' => 'The CVC number is incorrect.',
                'next_steps' => 'The customer should try again using the correct CVC.',
            ],
            'incorrect_pin' => [
                'description' => 'The PIN entered is incorrect. This decline code only applies to payments made with a card reader. ',
                'next_steps' => 'The customer should try again using the correct PIN.',
            ],
            'incorrect_zip' => [
                'description' => 'The ZIP/postal code is incorrect.',
                'next_steps' => 'The customer should try again using the correct billing ZIP/postal code.',
            ],
            'insufficient_funds' => [
                'description' => 'The card has insufficient funds to complete the purchase.',
                'next_steps' => 'The customer should use an alternative payment method.',
            ],
            'invalid_account' => [
                'description' => 'The card, or account the card is connected to, is invalid.',
                'next_steps' => 'The customer needs to contact their card issuer to check that the card is working correctly.',
            ],
            'invalid_amount' => [
                'description' => 'The payment amount is invalid, or exceeds the amount that is allowed.',
                'next_steps' => 'If the amount appears to be correct, the customer needs to check with their card issuer that they can make purchases of that amount.',
            ],
            'invalid_cvc' => [
                'description' => 'The CVC number is incorrect.',
                'next_steps' => 'The customer should try again using the correct CVC.',
            ],
            'invalid_expiry_year' => [
                'description' => 'The expiration year invalid.',
                'next_steps' => 'The customer should try again using the correct expiration date.',
            ],
            'invalid_number' => [
                'description' => 'The card number is incorrect.',
                'next_steps' => 'The customer should try again using the correct card number.',
            ],
            'invalid_pin' => [
                'description' => 'The PIN entered is incorrect. This decline code only applies to payments made with a card reader.',
                'next_steps' => 'The customer should try again using the correct PIN.',
            ],
            'issuer_not_available' => [
                'description' => 'The card issuer could not be reached, so the payment could not be authorized.',
                'next_steps' => 'The payment should be attempted again. If it still cannot be processed, the customer needs to contact their card issuer.',
            ],
            'lost_card' => [
                'description' => 'The payment has been declined because the card is reported lost.',
                'next_steps' => 'The specific reason for the decline should not be reported to the customer. Instead, it needs to be presented as a generic decline.',
            ],
            'merchant_blacklist' => [
                'description' => 'The payment has been declined because it matches a value on the Stripe user\'s blocklist.',
                'next_steps' => 'Do not report more detailed information to your customer. Instead, present as you would the generic_decline described above.',
            ],
            'new_account_information_available' => [
                'description' => 'The card, or account the card is connected to, is invalid.',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'no_action_taken' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer should contact their card issuer for more information.',
            ],
            'not_permitted' => [
                'description' => 'The payment is not permitted.',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'offline_pin_required' => [
                'description' => 'An offline PIN is required.',
                'next_steps' => 'The customer must enter the correct PIN.',
            ],
            'online_or_offline_pin_required' => [
                'description' => 'An online or offline PIN is required.',
                'next_steps' => 'The customer must enter the correct PIN.',
            ],
            'pickup_card' => [
                'description' => 'The card cannot be used to make this payment (it is possible it has been reported lost or stolen).',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'pin_try_exceeded' => [
                'description' => 'The allowable number of PIN tries has been exceeded.',
                'next_steps' => 'The customer must use another card or method of payment.',
            ],
            'processing_error' => [
                'description' => 'An error occurred while processing the card.',
                'next_steps' => 'The payment should be attempted again. If it still cannot be processed, try again later.',
            ],
            'reenter_transaction' => [
                'description' => 'The payment could not be processed by the issuer for an unknown reason.',
                'next_steps' => 'The payment should be attempted again. If it still cannot be processed, the customer needs to contact their card issuer.',
            ],
            'restricted_card' => [
                'description' => 'The card cannot be used to make this payment (it is possible it has been reported lost or stolen).',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'revocation_of_all_authorizations' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer should contact their card issuer for more information.',
            ],
            'revocation_of_authorization' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer should contact their card issuer for more information.',
            ],
            'security_violation' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'service_not_allowed' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer should contact their card issuer for more information.',
            ],
            'stolen_card' => [
                'description' => 'The payment has been declined because the card is reported stolen.',
                'next_steps' => 'The specific reason for the decline should not be reported to the customer. Instead, it needs to be presented as a generic decline.',
            ],
            'stop_payment_order' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer should contact their card issuer for more information.',
            ],
            'testmode_charges_only' => [
                'description' => 'Your account has not been activated and can only make test charges.',
                'next_steps' => 'Activate your account in the Dashboard to begin processing live charges.',
            ],
            'testmode_decline' => [
                'description' => 'A Stripe test card number was used.',
                'next_steps' => 'A genuine card must be used to make a payment.',
            ],
            'transaction_not_allowed' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'The customer needs to contact their card issuer for more information.',
            ],
            'try_again_later' => [
                'description' => 'The card has been declined for an unknown reason.',
                'next_steps' => 'Ask the customer to attempt the payment again. If subsequent payments are declined, the customer should contact their card issuer for more information.',
            ],
            'withdrawal_count_limit_exceeded' => [
                'description' => 'The customer has exceeded the balance or credit limit available on their card. ',
                'next_steps' => 'The customer should use an alternative payment method.',
            ],
            'testmode_charges_only' => [
                'description' => 'The Stripe payment method is not enabled for receiving payments. Contact the property or choose another payment method, if available.',
            ],
            'missing_email' => [
                'description' => 'You must enter an email to send the payment request',
            ],
            'live_mode_test_card' => [
                'description' => 'Your card was declined. Your request was in live mode, but used a known test card.',
            ],
        ],
        'stripe_email_is_required_to_create_payment_request' => [
            'description' => 'The payment attempt requires 3d secure but no email has been set to send the authorization request',
        ],
        'offline_pin_required' => [
            'description' => 'An offline PIN is required.',
            'next_steps' => 'The customer must enter the correct PIN.',
        ],
        'online_or_offline_pin_required' => [
            'description' => 'An online or offline PIN is required.',
            'next_steps' => 'The customer must enter the correct PIN.',
        ],
    ],
    'tableau' => [
        'errors' => [
            'roomNotFound' => 'Accommodation not found or non-existent',
            'tableauNumberNotFound' => 'The accommodation number is incorrect.',
            'closureConflict' => 'You can\'t overlap closure periods',
            'lockedRoom' => 'The accommodation seems to be blocked or moved into the room swap section and cannot be modified',
            'lockedAccommodation' => 'Accommodation type blocked and not modifiable',
            'reservation_accommodation_not_fund' => 'Unable to find the accommodation booked',
            'accommodation_destination_not_found' => 'Unable to find the destination accommodation',
            'accommodation_destination_treatment_not_found' => 'The treatment is disabled for the chosen accommodation',
            'accommodation_destination_rateplan_not_found' => 'The selected rate plan is disabled for the chosen accommodation',
            'reservation_locked' => 'This reservation is blocked, unable to modify.',
            'exists_reservation_destination' => 'There is another reservation in the destination accommodation, unable to continue!',
            'split_checkin_minor' => 'The specified check-in date is precedent to the reservation check-in date',
            'split_checkout_major' => 'The specified check-out date is after the reservation check-out date',
            'split_incompatible_rates' => 'The destination accommodation is incompatible as it is not associated to the same rate plans of the accommodation source',
            'exists_tableau_closure' => 'An availability closure has been set for the destination accommodation type, please remove the closure to proceed',
            'exists_reservation_closure' => 'For the selected period there are several reservations, uneble close the accomodation',
            'reservation_not_found' => 'Reservation not found',
            'reservation_is_moving' => 'Warning, a booking modification operation is already in progress. Update your Tableau and try again in a few moments',
            'reservation_moved_or_cancelled' => 'The reservation has been moved or canceled.',
            'reservation_accommodation_keep_activated' => 'The accommodation cannot be moved. To continue remove the block from the booking detail.',
            'closure_just_removing' => 'A cloasure removal is still in progress for this accommodation, please try again later',
            'closure_just_creating' => 'A clousure is still in progress for this accommodation, please try again later',
        ],
        'warnings' => [
            'tableauNumberWillBeChanged' => 'Warning, the reservation will be moved to the number: newTableauNumber',
        ],
    ],
    'technical_notices' => [
        'email' => [
            'failed_log_job_title' => 'SendLogJob send failed',
        ],
        'errors' => [
            'property_not_found' => 'Property not found',
            'channel_unsupported' => 'Channel not supported',
        ],
    ],
    'templates_snippets_categories' => [
        'reservation_data' => 'Reservation data',
        'property_data' => 'Property data',
        'automatism' => 'Automatisms',
        'reservations_accommodation_datails' => 'Details of booked accommodations',
        'reservation_personal_data' => 'Personal data of the reserving party',
        'payments_data' => 'Payment data',
        'cancellation_policy_data' => 'Cancellation policy data',
        'estimate_data' => 'Estimate data',
        'tax_document_data' => 'Tax document data',
        'payments_timetable' => 'Payments timetable',
    ],
    'users' => [
        'new' => [
            'title' => 'New user :username',
            'message' => 'A new user has been created by :self_username',
        ],
        'update' => [
            'title' => 'User :username modified',
            'message' => 'User :username successfully modified',
            'missing_email_verification_code' => 'The modification you are trying to make requires a confirmation, we have sent you a notification to your current email address.',
        ],
        'delete' => [
            'title' => 'User :username deleted',
            'message' => 'User :username successfully deleted',
            'error_delete_1' => 'You cannot delete your own account.',
        ],
        'errors' => [
            'emailnotfound' => 'Invalid email',
            'passwordIncorrect' => 'the current password is not valid',
            'reminderNotValid' => 'Invalid or expired code',
            'propertyAttached' => 'The user and the property are already associated',
            'propertyDetached' => 'The user and the property aren\'t related',
            'permissionNotFound' => 'One of the permissions is not enabled for this user',
            'tokenNotGenerated' => 'Error during token generation',
            'username_exists' => 'The username is already in use',
            'email_exists' => 'The email is already in use',
            'cannot_detach_all_auth_verification_methods' => 'It is not possible to disable all verification methods, one of them must be always active.',
            'user_not_allowed' => 'The logged-in user is not authorized to create new users',
            'no_active_properties' => 'No active properties are associated with your account. Please contact Beddy support for assistance.'
        ],
    ],
    'vat_quote' => [
        'related_model' => [
            'accommodation' => 'Accommodation',
            'addon' => 'Additional Service',
            'city_tax' => 'City Tax',
            'manual_charge' => 'Manually Added Charge',
            'expense_category' => 'Expense Category',
            'reservation_payment' => 'Invoices and Deposit Receipts',
            'place_tax' => 'Stamp Tax',
            'reservation_no_show' => 'No Show',
            'reservation_cancellation' => 'Cancellation after Deadline',
        ],
        'log_module' => [
            'vat_quote_created' => 'VAT rate created',
            'vat_quote_updated' => 'VAT rate updated',
            'vat_quote_deleted' => 'VAT rate deleted',
            'vat_quote_default_created' => 'Default VAT rate created',
            'vat_quote_default_updated' => 'Default VAT rate updated',
            'vat_quote_default_deleted' => 'Default VAT rate deleted',
            'property_vat_quote_added' => 'VAT rate added',
            'property_vat_quote_replaced' => 'VAT rate replaced',
        ],
        'errors' => [
            'vat_quote_associated' => 'Default VAT quota set for some of the properties, impossible proceed',
            'insufficient_default_number' => 'Unable to proceed with the deletion of the following VAT rate, as it would leave no default VAT rates for the following fields: ',
            'invalid_place_id' => 'The Country parameter does not have a valid value.'
        ]
    ],
    'venice_exemption' => [
        'errors' => [
            'CDAError' => 'The selected dates are not allowed by the Municipality of Venice.',
        ],
    ],
    'vrbo' => [
        'checkpoints' => [
            'IsActiveByOwner' => 'Check if the distribution to Vrbo is active',
            'IsListingNotArchived' => 'The property is archived on Vrbo. Contact Vrbo support',
            'IsActiveByCsr' => 'Vrbo support has deactivated the property. Contact Vrbo support',
            'HasImages' => 'Images are missing (at least 6 required)',
            'HasValidatedAddress' => 'Invalid address',
            'HasGeoCode' => 'Invalid or missing GPS coordinates',
            'HasPropertyAddress' => 'Invalid address',
            'HasBathroom' => 'Missing bathroom numbers',
            'HasMaxOccupancy' => 'Missing occupancy information',
            'HasPropertyDescription' => 'Description is missing',
            'HasPropertyHeadline' => 'Headline is missing',
            'HasPropertyName' => 'Name is missing',
            'HasPropertyType' => 'Property type is missing',
            'HasRates' => 'Rates/availability are missing',
            'HasRegistrationNumber' => 'Registration number is missing',
        ],
    ],
    'webcontroller' => [
        'downloader' => [
            'title_waiting' => 'Wait...',
            'message_waiting' => 'The operation required is in progress... Thank you for your patience',
            'title_started' => 'Download launched',
            'message_started' => 'The download has been launched. Once downloaded you can close this window',
            'title_error' => 'Error!',
            'message_error' => 'An erroro occurred during the enquiry elaboration.<br> we kindly ask you to contact us.',
        ],
        'metasearch' => [
            'message_error' => 'An error occurred while processing your request.',
            'title_error' => 'Error!',
        ],
    ],
    'welcome_automatic_email' => [
        'errors' => [
            'fail_to_send' => 'Unable to send the requested email to the address :email_address',
        ],
        'email' => [
            'model_A' => [
                'body_1' => 'Hello :userMasterName,
                <br><br>
                below are the next steps to follow to set up your Beddy account.
                <br><br>
                &nbsp;&nbsp;<b>01. First Steps - General Configuration</b>
                <br><br>
                We will contact you shortly to set up your Beddy account.
                <br><br>
                The first configuration is very important and is preparatory for the steps to follow.
                <br><br>
                We suggest you <b>to fill in the attached Excel form</b> before scheduling an appointment with our operator, so we will be able to reduce configuration times.
                <br><br>
                The file contains multiple sheets and all of them must be filled in.<br>
                Once you\'re done, you\'ll need to send the file to <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                All fields in the attached form are required, a lack of information may delay the setup of your Beddy account.
                <br><br>
                If you manage a multi-structure account, you need to copy the Excel file and compile one for each structure.
                <br><br>
                At the end of the configuration you will be provided with the access credentials to your account.',
                'body_2' => '&nbsp;&nbsp;<b>02. Training - PMS Training</b>
                <br><br>
                Once the configuration is complete, we will contact you to schedule an appointment for the <b>training</b> on PMS functionality.
                <br><br>
                The training will last <b>90 minutes</b> and collaborators and employees can also participate.
                <br><br>
                While waiting for the training, I suggest you get an idea of the software\'s features by consulting the online training.',
                'body_3' => '&nbsp;&nbsp;<b>03. Connecting Channels - Channel Manager Configuration</b>
                <br><br>
                After finishing the PMS training, a new channel connection meeting will be scheduled. We remind you that once the Channel Manager has been activated, it will no longer be possible to use the OTAs\' extranet or any old channel manager.',
                'body_4' => '&nbsp;&nbsp;<b>04. Training - Training Channel Manager</b>
                <br><br>
                At the end of the connection procedure, you will be offered to participate in the training on the Channel Manager functions, which will be held at 12:30 on the same day. If it is not available, we will arrange a new appointment for you.
                <br><br>
                The training will last <b>30 minutes</b> and collaborators and employees can also participate.
                <br><br>
                While waiting for the training, I suggest you get an idea of the software\'s features by consulting the online training.',
            ],
            'model_B' => [
                'body_1' => 'Hello :userMasterName,
                <br><br>
                below are the next steps to follow to set up your Beddy account.
                <br><br>
                &nbsp;&nbsp;<b>01. First Steps - General Configuration</b>
                <br><br>
                We will contact you shortly to set up your Beddy account.
                <br><br>
                The initial configuration is very important and is preparatory for the steps to follow.
                <br><br>
                We suggest you <b>to fill in the attached Excel form</b> before scheduling an appointment with our operator, so we will be able to reduce configuration times.
                <br><br>
                The file contains multiple sheets and all of them must be filled in.<br>
                Once you\'re done, you\'ll need to send the file to <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                All fields in the attached form are required, a lack of information may delay the setup of your Beddy account.
                <br><br>
                If you manage a multi-structure account, you need to copy the Excel file and compile one for each structure.
                <br><br>
                At the end of the configuration you will be provided with the access credentials to your account.',
                'body_2' => '&nbsp;&nbsp;<b>02. Training - PMS Training</b>
                <br><br>
                Once the configuration is complete, we will contact you to schedule an appointment for the <b>training</b> on PMS functionality.
                <br><br>
                The training will last <b>90 minutes</b> and collaborators and employees can also participate.
                <br><br>
                While waiting for the training, I suggest you get an idea of the software\'s features by consulting the online training.',
                'body_3' => '&nbsp;&nbsp;<b>03. Training - Rate and Availability Management Training</b>
                <br><br>
                At the end of the connection procedure, you will be offered to participate in the training on the Channel Manager functions, which will be held at 12:30 on the same day.
                If it is not available, we will arrange a new appointment for you.
                <br><br>
                Even if the Channel Manager is not present in its license, it is necessary to participate in the training because entering prices and availability on the PMS uses the same operations.
                <br><br>
                The training will last <b>30 minutes</b> and collaborators and employees can also participate.
                <br><br>
                While waiting for the training, I suggest you get an idea of the software\'s features by consulting the online training.',
            ],
            'model_C' => [
                'body_1' => 'Hello :userMasterName,
                <br><br>
                below are the next steps to follow to set up your Beddy account.
                <br><br>
                &nbsp;&nbsp;<b>01. First Steps - General Configuration</b>
                <br><br>
                We will contact you shortly to set up your Beddy account.
                <br><br>
                The initial configuration is very important and is preparatory for the steps to follow.
                <br><br>
                We suggest you <b>fill in the attached Excel form</b> before making an appointment with our operator, in this way we will be able to reduce configuration times.
                <br><br>
                The file contains multiple sheets and all of them must be filled in.<br>
                Once you\'re done, you\'ll need to send the file to <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                All fields in the attached form are required, a lack of information may delay the setup of your Beddy account.
                <br><br>
                If you manage a multi-structure account, you need to copy the Excel file and compile one for each structure.
                <br><br>
                At the end of the configuration you will be provided with the access credentials to your account.',
                'body_2' => '&nbsp;&nbsp;<b>02. Connecting Channels - Channel Manager Configuration</b>
                <br><br>
                After finishing the configuration, a new meeting will be scheduled to connect the channels. We remind you that once the Channel Manager has been activated, it will no longer be possible to use the OTAs\' extranet or any old channel manager.',
                'body_3' => '&nbsp;&nbsp;<b>03. Training - Training Channel Manager</b>
                <br><br>
                At the end of the connection procedure, you will be offered to participate in the training on the Channel Manager functions, which will be held at 12:30 on the same day. If it is not available, we will arrange a new appointment for you.
                <br><br>
                The training will last <b>30 minutes</b> and collaborators and employees can also participate.
                <br><br>
                While waiting for the training, I suggest you get an idea of the software\'s features by consulting the online training.',
            ],
            'model_D' => [
                'body_1' => 'Hello :userMasterName,  
                <br><br>
                here are the next steps to follow to set up your Beddy account. Please <b>read this message carefully</b> and provide the requested information to help us speed up the configuration process.  
                <br><br>          
                &nbsp;&nbsp;<b>1. First steps - General Configuration</b>
                <br><br>
                We will contact you shortly to configure your Beddy account.  
                <br><br>
                Before your appointment with our operator, please:
                <br><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>fill in the attached Excel form</b><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>request the mapping of accommodations and rate plans</b> from your external service provider to be connected to Beddy<br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>send the completed form and mapping</b> to <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
                This information is <b>very important</b> to proceed with the configuration and reduce setup times.
                <br><br>
                All fields in the attached form are mandatory; missing information may delay the configuration of your Beddy account.
                <br><br>
                If you manage a multi-property account, you must fill in the Excel file and request the mapping for each property.
                <br><br>
                Once the configuration is complete, you will receive your login credentials for your account.',
                'body_2' => '&nbsp;&nbsp;<b>2. Training - PMS Training</b>             
                <br><br>
                Once the configuration is completed, we will contact you to schedule the <b>group training session</b> on PMS functionalities. Training sessions are available on Tuesdays at 3:00 PM and Thursdays at 10:00 AM.  
                <br><br>
                The training will last <b>90 minutes</b> and collaborators or employees may also attend. 
                <br><br>
                While waiting for the training, we suggest you explore the software features by consulting the online training resources.',
                'body_3' => '&nbsp;&nbsp;<b>3. Training - Channel Manager training integrated with Beddy</b>            
                <br><br>
                After completing the connection procedure, you will be offered a <b>group training session</b> on how to use the PMS to update rates, availability, and restrictions through the external Channel Manager.
                <br><br>
                Training sessions are available on Mondays at 3:00 PM and on Wednesdays and Fridays at 11:30 AM.
                <br><br>
                The training will last <b>60 minutes</b> and collaborators or employees may also attend.
                <br><br>
                If the Channel Manager is integrated in “reservation download only” mode, the training is optional. However, we recommend attending if you wish to manage rates directly from the PMS for booking entry or quote generation in Beddy.',
                'body_4' => '&nbsp;&nbsp;<b>4. Connection of the Channel Manager integrated with Beddy</b>
                <br><br>
                After completing the PMS training, a new appointment will be scheduled to connect the external Channel Manager to Beddy.',
            ],
            'model_welcome' => [
                'greetings_text' => 'Thank you again for choosing our services.<br><br>The Beddy staff',
                'body_1' => 'Welcome to Beddy,
               <br><br>
               Thank you for choosing our service , we would like to invite you to <b>carefully follow the instructions you will receive in future communications</b>, therefore please add the addresses support@beddy.io and info@beddy.io in your mail provider contacts to prevent our emails from ending up in the spam folder.
               <br><br>
               Here are the guides for the most used providers:
               <br><br>
               <a href="https://support.google.com/contacts/answer/1069522">Add a contact to Gmail</a>
               <br><br>
               <a href="https://support.microsoft.com/en-us/office/add-a-contact-e1dc4548-3bd6-4644-aecd-47b5728f7b0d#ID0EAABAAA=Newer_versions">Add a contact in Outlook</a >',
                'preview_text' => 'Everything you need to know',
                'subject' => 'Welcome to Beddy - First steps and important information',
            ],
            'training_pms_channel_button' => 'VIDEO TRAINING CHANNEL MANAGER',
            'training_pms_text_button' => 'PMS TRAINING VIDEOS',
            'greetings_text' => 'That\'s all for today, thank you again for choosing our services.<br><br>The Beddy staff',
            'subject' => 'Welcome to Beddy - Let\'s get started!',
            'preview_text' => 'Useful information to be ready to start ',
        ],
    ],
    'zdatalake' => [
        'Couple' => 'Couples',
        'Family' => 'Families',
        'Single' => 'Single',
        'Group' => 'Group',
    ],
    'booking_booster_configuration' => [
        'errors' => [
            'configuration_not_found' => 'Configuration not found'
        ],
    ],
    'booking_booster' => [
        'errors' => [
            'auth_token' => 'Unable to retrieve Booking Booster authentication token for this error: :error',
            'available_budget' => 'Unable to retrieve available budget for this error: :error',
            'campaigns_statistics' => 'Unable to retrieve campaigns statistics for this error: :error',
            'ads_statistics' => 'Unable to retrieve ad statistics due to this error: :error',
            'ads_details' => 'Unable to retrieve ad details due to this error: :error',
            'property_targets' => 'Unable to retrieve the property targets for this error: :error',
            'client_error' => 'Incorrect credentials or unauthorized to access the requested resources. Details: :error',
            'server_error' => 'We are experiencing technical difficulties. Please try again later. Details: :error',
            'connection_error' => 'Unable to connect to Booking Booster. Please try again later. Details: :error'
        ],
        'warnings' => [
            'property_not_mapped' => 'The following properties are not mapped and may not appear correctly in the campaign statistics: :propertyNames'
        ]
    ],
    'zpay' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Unknown general error.',
                'next_steps' => 'Contact technical support.',
            ],
            'validation_failed' => [
                'description' => 'Card authorization failed',
                'next_steps' => 'The customer must use a new card.',
            ],
            'canceled' => [
                'description' => 'The request has been canceled',
                'next_steps' => 'The customer must submit a new request.',
            ],
            'failed' => [
                'description' => 'Request failed',
                'next_steps' => 'The customer must submit a new request.',
            ],
            'waiting_for_payment' => [
                'description' => 'Request pending payment',
                'next_steps' => 'The customer must confirm the payment.',
            ],
            'requires_capture' => [
                'description' => 'Request awaiting confirmation',
                'next_steps' => 'The customer must authorize the operation.',
            ],
            'refunded' => [
                'description' => 'Payment refunded',
                'next_steps' => 'The payment has been successfully refunded.',
            ],
            'partially_refunded' => [
                'description' => 'Payment partially refunded',
                'next_steps' => 'The payment has been partially refunded.',
            ],
            'processing' => [
                'description' => 'The payment is being processed',
                'next_steps' => 'Wait for the operation result.',
            ],
        ],
    ],
];
