<?php
$suffix = ' per l\'ospite :customer_name, alloggio :tableau_number - :accommodation_name';
$roomReservationSuffix = ' в размещении :accommodation_name - бронь :reservation_booker - :reservation_reference_number';
$reservationSuffix = ' среди гостей, которые будут отправлены в бронировании: :reservation_booker - :reservation_reference_number';
$customerReservationSuffix = ' :customer_name - :reservation_reference_number';
$customerEmptyDataSuffix = 'для гостя :customer_name брони :reservation_reference_number';

return [

    'accommodations' => [
        'errors' => [
            'attachExist' => 'Тарифный план уже существует',
            'detachNotExist' => 'Тарифный план отсутствует в этом жилье',
            'detachStandardRateplan' => 'Невозможно удалить стандартный тарифный план',
            'guestsCnfigurationBase' => 'Нельзя применять скидки к базовому тарифу',
            'virtualRidondanceConflict' => 'Невозможно связать это жилье. Связь уже настроена',
            'parentTreeExist' => 'Основная комната уже связана или превышен лимит ',
            'quantityZero' => 'Нельзя удалить последнюю доступную комнату',
            'quantityNotValid' => 'Переданное количество равно или меньше существующего',
            'quantitySum' => 'Количество для ',
            'quantitySuperior' => 'Нельзя превысить количество людей в основной комнате',
            'quantityWithReservation' => 'Существуют текущие бронирования, нельзя удалить это количество комнат',
            'numberNotAvail' => 'Номера комнат недоступны',
            'guestsConfigurationBase' => 'Нельзя применять скидку к базовой конфигурации',
            'tooManyAdults' => 'Количество взрослых превышает лимит',
            'tooManyChildren' => 'Количество детей превышает лимит',
            'stillConnected' => 'Комната все еще связана с одним или несколькими порталами',
            'stillVirtual' => 'Комната все еще связана с другой комнатой',
            'stillReserved' => 'Существуют текущие бронирования для этой комнаты',
            'notVirtualToSum' => 'Связей для этой комнаты недостаточно',
            'notVirtualQty' => 'Количество для связанной комнаты должно быть равно 1',
            'notVirtualChildQty' => 'Количество для связанной комнаты должно быть равно 1',
            'notVirtualSum' => 'Эта комната не является суммированной',
            'isVirtual' => 'Виртуальная комната, операция невозможна',
            'isNotVirtual' => 'Невиртуальная комната, операция невозможна',
            'ruleToBundle' => 'Невозможно удалить правило по тарифному пакету, который еще активен.',
            'noRateplanExist' => 'Для объекта нет тарифных планов',
            'ruleIsLocked' => 'Невозможно изменить правило для комнат All Linked',
            'duplicateLabel' => 'Нельзя использовать это имя, так как оно уже используется в :accommodationName',
        ],
        'warnings' => [
            'request_confirm_delete_tableau_number' => 'Есть связанные комнаты, продолжить?',
            'accommodation_tableau_not_found' => 'ID Tableau :tableau_number_id не связан или не найден в комнате с ID :accommodation_id',
            'accommodation_beds_types_combination_not_found' => 'Комбинация с ID :acc_bed_type_combination_id не найдена в комнате с ID: :accommodation_id',
            'confimation_delete_father_and_childs_combinations' => "Вы собираетесь удалить родительскую комбинацию конфигурации (ID: :combination_id). При продолжении будут автоматически удалены все её дочерние комбинации. Подтверждаете, что хотите продолжить?",
            'invalid_facility' => 'Несовместимое удобство',
        ],
        'channel' => [
            'single_use_exists' => 'Комната :accommodation_name - :acommodation_ratename уже связана или создана',
            'single_use_dont_exists' => 'Комната канала с ID :accommodation_channel_id не найдена',
            'email' => [
                'new_title' => 'Добавлены новые комнаты для канала :channel_name - Объект: :property_name - ID Объекта: :property_id',
                'deleted_title' => 'Удалены комнаты для канала :channel_name - Объект: :property_name - ID Объекта: :property_id',
                'attached_title' => 'Обнаружены несвязанные комнаты для объекта: :property_name - ID Объекта: :property_id',
                'conflict_rule' => 'Конфликт правил для канала :channel_name - Объект: :property_name - ID Объекта: :property_id',
            ],
        ],
        'fields' => [
            'model_name' => 'комната',
            'checkin' => 'заезд',
            'checkout' => 'выезд',
            'checkin_hour' => 'время заезда',
            'checkout_hour' => 'время выезда',
            'checkin_arrival_preference' => 'предпочтение заезда',
        ],
    ],

    'account_renewal' => [
        'email' => [
            'subject' => 'Автоматическое продление объектов Beddy - :monthAndYear',
        ],
    ],

    'addon' => [
        'price_type' => [
            'xunit' => 'За единицу',
            // 1
            'xpax' => 'За человека за ночь',
            // 2
            'xweekxpax' => 'За человека за неделю',
            // 3
            'xbookxpax' => 'За человека единовременно',
            // 4
            'xnight' => 'За ночь',
            // 5
            'xweek' => 'За неделю',
            // 6
            // 7
            'xbook' => 'Единовременно',
        ],
        'warnings' => [
            'not_available' => 'Недоступно для выбранного периода',
            'min_stay_violated' => 'Минимальный срок пребывания :min_stay',
            'max_stay_violated' => 'Максимальный срок пребывания :max_stay',
            'release_violated' => 'Максимальный release :release',
            'rateplan_excluded' => 'Тарифный план :rateplan исключен для дополнительной услуги в день :date',
            'treatment_excluded' => 'Услуга :treatment исключена для дополнительной услуги в день :date',
            'weekdays_excluded' => 'Исключен один или несколько дней недели',
        ],
        'errors' => [
            'not_in_stay' => 'Выбранные даты не входят в период проживания в комнате',
            'not_found' => 'Дополнительная услуга не связана с запрашиваемой комнатой',
            'billed_addon' => 'Дополнительная услуга не может быть отменена, так как связана с открытыми счетами',
        ],
        'logger' => [
            'added' => ':label для :accommodation_name с ценой :price (:date) #:id',
        ],
    ],

    'admin' => [
        'errors' => [
            'not_demo' => 'Объект должен быть типа DEMO',
            'no_accommodations' => 'Объект не имеет жилья',
            'no_rateplans' => 'Объект не имеет тарифных планов',
            'channelmanager_module_needed' => 'Модуль Channel Manager не активен',
            'channel_beddy_only' => 'Объект должен иметь только активный канал Beddy',
        ],
    ],

    'api_partners' => [
        'contacts_types' => [
            'manager_email' => 'Email ответственного лица',
            'technical_manager_email' => 'Email технического руководителя',
            'customer_service_email' => 'Email службы поддержки клиентов',
            'commercial_requests_email' => 'Email для коммерческих запросов',
        ],
        'errors' => [
            'cannot_delete_has_users' => 'Невозможно удалить партнера, так как у него есть связанные пользователи',
            'action_not_allowed' => 'У вас нет доступа к сервису :service.',
            'max_days' => 'Максимальный интервал составляет :days дней.',
            'date_filters' => 'Вы можете использовать только один тип фильтра даты для запроса, не более одного одновременно.',
            'cannot_delete_guest_city_tax' => 'Невозможно удалить гостя :guestId для бронирования :reservationId, так как туристический налог уже выставлен.',
            'too_many_reservation_ids' => 'Нельзя передавать более :max reservationIds за один запрос. Сейчас передано :count.',
            'reservations_not_found' => 'Следующие бронирования не найдены или у вас нет к ним доступа: :ids',
            'customer_id_or_customer_required' => 'Необходимо указать хотя бы одно из полей: customerId или customer.',
            'customer_id_and_customer_conflict' => 'Нельзя указывать одновременно customerId и customer. Выберите одно из них.'
        ],
        'services' => [
            'ping' => 'Пинг',
            'get_infos' => 'Получение информации',
            'hotel_rateplan' => 'Тарифный план',
            'push_availabilities' => 'Отправка доступности',
            'push_rates' => 'Отправка тарифов',
            'reservations_lookup' => 'Поиск бронирований',
            'reservations_acknowledge' => 'Подтверждение получения бронирований',
            'hotel_res_modify_notif' => 'Уведомление о изменении бронирования',
            'reservation_send_message' => 'Отправка сообщений',
            'reservation_message_status' => 'Проверка состояния сообщения',
            'modify_reservation' => 'Изменение бронирования',
            'media' => 'Вложения',
            'modify_media' => 'Изменение вложений',
            'delete_media' => 'Удаление вложений',
            'invoices' => 'Счета',
            'credit_card' => 'Кредитная карта',
            'all_guests' => 'Все гости',
            'get_invoices' => 'Получить счета',
            'generic_bol' => 'Общие для системы бронирования',
            'hotel_quote_request' => 'Запрос на предложение',
            'revenue_data' => 'Получить данные о заполняемости и доходах'
        ],
    ],
    'api_partner_detail' => [
        'fields' => [
            'country_id' => 'идентификатор страны',
            'city_id' => 'идентификатор города',
            'state_id' => 'идентификатор штата',
            'county_id' => 'идентификатор округа',
        ]
    ],
    'auth_verification_methods' => [
        'your_pin' => 'Ваш PIN-код для Beddy',
        'error_pin_invalid' => 'Ошибка. Проверьте правильность введенного PIN-кода',
        'email_authentication' => [
            'get_connection_info_message' => 'Мы только что отправили вам на email PIN-код для завершения аутентификации',
            'pin_invalid' => 'Введенный PIN-код неверен',
        ],
        'google_authentication' => [
            'get_connection_info_message' => 'Проверьте ваш Google Authenticator, чтобы получить PIN-код для завершения аутентификации',
            'pin_invalid' => 'Введенный PIN-код неверен',
        ],
    ],

    'availability' => [
        'errors' => [
            'not_found' => 'Доступность для этой комнаты не найдена',
        ],
    ],

    'bills' => [
        'ordination_of_date' => 'Заказ от :date',
        'vat_title' => 'НДС',
        'accommodation' => 'Проживание',
        'total' => 'Итого',
        'service' => 'Услуга',
        'quantity_abbreviated' => 'Кол-во',
        'amount' => 'Сумма',
        'sign' => 'Подпись',
        'account_balance_by_date' => 'Выписка по дате',
        'account_balance_by_buyer' => 'Выписка по плательщику',
        'account_balance_by_guest' => 'Выписка по гостю',
        'account_balance_by_accommodation' => 'Выписка по размещению',
        'account_balance' => 'Выписка',
        'payer' => 'Плательщик',
        'quantity' => 'Кол-во',
        'date' => 'Дата',
        'notes' => 'Примечания',
        'scloby' => [
            'ordination_name' => 'Продажа Tilby',
            'ordination_from_sale' => 'Заказ, созданный от продажи Tilby',
            'confirmation_mode' => 'Способ подтверждения',
            'confirmation_by_phone' => 'номер телефона',
            'confirmation_by_signature' => 'подпись',
        ],
        'log' => [
            'refunds' => 'Списание :bill_label (:bill_common_id) было возвращено на сумму :refunded',
        ],
    ],

    'booking_onboard' => [
        'no_contract_found' => 'Контракт для этой недвижимости не найден',
    ],

    'bookingengine' => [
        'addons_type' => [
            'xweek' => 'За неделю',
            'xnight' => 'За ночь',
            'xpax' => 'За человека за ночь',
            'xunit' => 'За единицу',
            'xbook' => 'За бронирование',
            'xbookxpax' => 'За человека один раз',
            'xweekxpax' => 'За человека в неделю',
        ],
        'errors' => [
            'min_expense_coupon' => 'Купон не применим для текущего значения бронирования',
            'min_stay_coupon' => 'Купон не применим для количества ночей текущего бронирования',
            'max_stay_coupon' => 'Купон не применим для максимального количества ночей текущего бронирования',
            'invalid_days_coupon' => 'Купон не применим для дней недели текущего бронирования',
            'invalid_stay_coupon' => 'Купон не применим для выбранного периода пребывания',
            'invalid_conditions_coupon' => 'Купон не применим для условий исключения текущего бронирования',
            'invalid_periods_coupon' => 'Купон не применим для дат текущего бронирования',
            'invalid_coupon' => 'Неверный или несуществующий купон',
            'already_coupon' => 'Вы не можете применить другие купоны',
            'availability_ended' => 'Доступность для выбранных номеров закончилась',
            'cart_empty_accommodation' => 'В корзине нет номеров',
            'date_past_quote_expire' => 'Невозможно добавить номер в предложение, так как дата выезда предшествует дате истечения срока предложения',
            'process_cart_date_past' => 'Невозможно продолжить, так как дата выезда одного из номеров ранее текущей даты',
            'change_expire_date_quote_past' => 'Дата истечения срока предложения ранее даты выезда одного или нескольких номеров',
            'quote_expired' => 'Предложение истекло',
            'quote_accepted' => 'Предложение уже принято',
            'quote_not_active' => 'Предложение не активно',
            'quote_just_confirmed' => 'Предложение уже подтверждено, невозможно изменить его состояние',
            'payment_not_valid' => 'Неверный способ оплаты',
            'module_quote_not_active' => 'Модуль предложений не активирован для этой недвижимости',
            'quote_option_no_availability' => 'Для этого варианта больше нет доступных номеров',
            'quote_option_no_availability_accommodation' => 'Некоторые номера недоступны, проверьте таблицу при подтверждении предложения.',
            'quote_option_no_availability_linked' => 'Номер недоступен и связан с другими номерами, проверьте таблицу при подтверждении предложения.',
            'addon_excluded_from_coupon' => 'Невозможно добавить дополнительную услугу ":addon_name", так как она исключена из применяемого купона',
            'unlock_wrong_accommodation' => 'Неверный номер.',
            'unlock_wrong_accommodation_to_property' => 'Номер не принадлежит данному объекту.',
            'unlock_rateplan_not_unlockable' => 'Предложение не подлежит разблокировке.',
            'estimate_addon_failure' => 'Неверные данные поиска',
            'step_not_complete' => 'Некоторые шаги не завершены',
            'property_different' => 'Вы выбрали номера из разных объектов',
            'data_sent_not_correct' => 'Отправленные данные некорректны',
            'no_dns_found' => 'Не найден DNS для :subdomain',
            'no_payment_method_available' => 'Не установлен способ оплаты',
            'session_expired' => 'Сессия истекла',
            'booking_in_progress' => 'Бронирование уже в процессе',
            'search_not_found' => 'Поиск не найден',
            'failed_to_create_reservation' => 'Произошла ошибка при создании бронирования',
            'create_order_already_exist' => 'Заказ уже в процессе обработки (кэш существует) - SID :sid',
            'create_quote_order_already_exist' => 'Заказ предложения уже в процессе обработки (кэш существует) - Reference :reference',
        ],
        'persuasive_sentences' => [
            'prepayment' => 'Предоплата',
            'hotel_payment' => 'Оплата в отеле. Сейчас не платите',
            'free_cancellation_until' => 'Бесплатная отмена до :date_limit',
            'cancellation_term' => 'Условия отмены бронирования',
            'cheapest_rate' => 'Это самая выгодная ставка',
        ],
        'payment_method_description' => [
            'transfer' => 'текст без депозита',
            'transfer_deposit' => 'Предусмотрена предоплата :deposit, которая будет возвращена, если это предусмотрено условиями отмены этой ставки. Вы получите по email реквизиты для перевода.',
            'cc_a_garanzia' => 'Без дополнительных затрат! Кредитная карта используется только для гарантии бронирования. Никакой предоплаты не требуется. Вы оплатите полную стоимость бронирования непосредственно в :property_name во время пребывания.',
            'cc_pos' => 'Без дополнительных затрат! Кредитная карта используется только для гарантии бронирования. Никакой предоплаты не требуется. Вы оплатите полную стоимость бронирования непосредственно в :property_name во время пребывания.',
            'cc_pos_deposit' => 'Предусмотрена предоплата :deposit, которая будет возвращена, если это предусмотрено условиями отмены этой ставки.',
            'cc_stripe_deposit' => 'Оплата будет произведена через платежный шлюз Stripe. Предусмотрена предоплата :deposit, которая будет возвращена, если это предусмотрено условиями отмены этой ставки.',
            'nexi_deposit' => 'Оплата будет произведена через платежный шлюз Nexi. Предусмотрена предоплата :deposit, которая будет возвращена, если это предусмотрено условиями отмены этой ставки. <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Политика конфиденциальности</a> Nexi.',
            'zpay_deposit' => 'Оплата будет произведена через платежный шлюз ZPay. Требуется предоплата в размере :deposit, которая будет возвращена, если это предусмотрено правилами отмены данного тарифа. <a href="https://www.zpay.it/privacy" target="_blank">Политика конфиденциальности</a> ZPay.',
            'cc_paypal_deposit' => 'Оплата будет произведена через платежный шлюз Paypal. Предусмотрена предоплата :deposit, которая будет возвращена, если это предусмотрено условиями отмены этой ставки.',
            'availability_request' => 'Из-за высокого сезона эта заявка не является окончательным бронированием. Вы можете запросить информацию о доступности, заполнив следующую форму. Бронирование будет подтверждено как можно скорее.',
            'cc_paypal_deposit_with_commission' => 'Оплата будет произведена через платежный шлюз Paypal. Предусмотрена предоплата :deposit + :commission комиссии, которая будет возвращена, если это предусмотрено условиями отмены этой ставки.',
        ],
        'automatic_payment_method_description' => [
            'transfer' => 'текст без депозита',
            'transfer_deposit' => 'Вы получите по email реквизиты для перевода.',
            'cc_a_garanzia' => 'Кредитная карта используется для гарантии бронирования. В данный момент не требуется никаких платежей, вы заплатите согласно описанным условиям оплаты.',
            'cc_pos' => 'Кредитная карта используется для гарантии бронирования. В данный момент не требуется никаких платежей, вы заплатите согласно описанным условиям оплаты.',
            'cc_pos_deposit' => 'Предусмотрена предоплата :deposit, которая будет возвращена, если это предусмотрено условиями отмены этой ставки.',
            'cc_stripe_deposit' => 'Оплата будет произведена через платежный шлюз Stripe.',
            'nexi_deposit' => 'Оплата будет произведена через платежный шлюз Nexi. <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Политика конфиденциальности</a> Nexi.',
            'zpay_deposit' => 'Оплата будет произведена через платежный шлюз ZPay. Требуется предоплата в размере :deposit, которая будет возвращена, если это предусмотрено правилами отмены данного тарифа. <a href="https://www.zpay.it/privacy" target="_blank">Политика конфиденциальности</a> ZPay.',
            'cc_paypal_deposit' => 'Оплата будет произведена через платежный шлюз Paypal.',
            'availability_request' => 'Эта заявка не является окончательным бронированием, однако вы можете запросить информацию о доступности, заполнив следующую форму. Бронирование будет подтверждено как можно скорее.',
            'cc_paypal_deposit_with_commission' => 'Оплата будет произведена через платежный шлюз Paypal.',
        ],
        'validators' => [
            'errors' => [
                'name' => 'Неверное имя гостя.',
                'surname' => 'Неверная фамилия гостя.',
                'email' => 'Неверный email гостя.',
                'credit_card_type_id' => 'Кредитная карта не поддерживается.',
                'credit_card_holder' => 'Неверное имя владельца карты.',
                'credit_card_number' => 'Неверный номер карты.',
                'credit_card_expire_date' => 'Неверная дата истечения срока карты.',
            ],
        ],
    ],

    'cash_desk_closure' => [
        'title' => 'Закрытие кассы',
        'invoice' => 'Счет-фактура',
        'invoices' => 'Счета-фактуры',
        'receipt' => 'Квитанция',
        'receipt_follows_invoice' => 'Квитанция следует за счетом-фактурой',
        'receipts' => 'Квитанции',
        'type' => 'Тип',
        'status' => 'Оплачено',
        'deposit' => 'Депозит',
        'recipient_business_name' => 'Получатель',
        'taxable' => 'Облагаемая налогом',
        'vat_quote' => 'НДС',
        'total' => 'Итого',
        'payments' => 'Платежи',
        'totals' => 'ОБЩИЕ ИТОГИ',
        'cash_type' => 'Тип сбора',
        'reversal_receipt' => 'Аннулирование квитанции',
        'reversal_receipts' => 'Аннулирование квитанций',
        'to_give' => 'К выданию',
        'to_have' => 'К получению',
        'balance' => 'Баланс',
        'documents' => 'Документы',
        'deposits' => 'Депозиты',
        'cash_desk_closure' => 'Приостановленные',
        'credit_note' => 'Кредитная записка',
        'invoice_received' => 'Полученная счет-фактура',
        'credit_notes' => 'Кредитные записки',
        'suspended' => 'Приостановленные',
        'follows_invoice' => 'Следует за счетом-фактурой',
        'receipts_follows_invoice' => 'Квитанция следует за счетом-фактурой',
        'suspend' => 'Приостановлено',
        'empty_documents' => 'Нет документов для отображения',
        'sheets_name' => [
            'cash_desk' => 'Касса',
            'cahs_desk_summary' => 'Сводка кассы',
        ],
        'export_fields' => [
            'date' => 'Дата ввода',
            'status' => 'Оплачено',
            'document_type' => 'Тип документа',
            'document_number' => 'Номер документа',
            'customer' => 'Получатель',
            'taxable' => 'Облагаемая налогом',
            'total_tax' => 'НДС',
            'total_to_pay' => 'Итого',
            'payment_type' => 'Тип сбора',
            'to_have' => 'К получению',
            'to_give' => 'К выданию',
            'balance' => 'Баланс',
            'deposit_document_number' => 'Номер документа депозита',
            'deposit_payment_type' => 'Тип сбора депозита',
        ],
    ],

    'cash' => [
        'cash_title' => 'Ситуация с кассой',
        'cash_totals_title' => 'Итоги',
        'total' => 'Итого',
        'cash_desk' => 'Касса',
        'export_fields' => [
            'registration_date' => 'Дата ввода',
            'accountholder' => 'Владелец счета',
            'document' => 'Документ',
            'document_date' => 'Дата документа',
            'date' => 'Дата',
            'in-out' => 'Вход-выход',
            'cash_in' => 'Поступления (доходы)',
            'cash_out' => 'Выходы (платежи)',
            'payment_method' => 'Способ оплаты',
            'note' => 'Примечание',
            'type_payment' => 'Тип платежа',
            'stay' => 'Пребывание',
            'extra' => 'Дополнительно',
            'city_tax' => 'Городской налог',
            'pos' => 'POS',
            'property' => 'Объект',
            'amount' => 'Сумма',
            'mode' => 'Режим',
            'type' => 'Тип',
            'category' => 'Категории расходов',
            'notes' => 'Примечания',
            'movement_amount' => 'Движение',
            'customer_or_company' => 'Клиент или компания',
            'label' => 'Этикетка',
        ],
        'document_types' => [
            'invoice' => 'Счет-фактура',
            'receipt' => 'Квитанция',
            'credit_note' => 'Кредитная записка',
        ],
        'payment_types' => [
            'deposit' => 'Депозит',
            'part_payment' => 'Частичная оплата',
        ],
        'total_yesterday' => 'Итого за вчера',
        'total_today' => 'Итого за сегодня',
        'all_properties' => 'Все объекты',
        'sub_year' => 'Итого за год',
        'sub_month' => 'Итого за месяц',
        'sub_day' => 'Итого за день',
        'ins' => 'Поступления (Доходы)',
        'outs' => 'Выходы (Платежи)',
        'cash_fund' => 'Кассовый фонд',
        'cash_in' => 'Поступления',
        'cash_out' => 'Выходы',
        'cash_balance' => 'Баланс',
        'to_cash_in' => 'К получению',
        'wrap_up' => 'Резюме по способам оплаты',
        'summary' => 'Резюме',
        'in_out' => [
            'in' => 'Поступления',
            'out' => 'Выходы',
        ],
        'totals' => [
            'method' => 'Метод',
            'ins' => 'Поступления',
            'outs' => 'Выходы',
            'diff' => 'Баланс',
        ],
    ],

    'channel' => [
        '1' => [
            'promotions' => [
                'mobile_rate' => [
                    // ID канала
                    'all' => 'Мобильное приложение и браузер',
                    'app' => 'Приложение',
                ],
                'geo_rate' => [
                    'algeria_pos' => 'Алжир',
                    'argentina_pos' => 'Аргентина',
                    'australia_pos' => 'Австралия',
                    'belarus_pos' => 'Беларусь',
                    'brazil_pos' => 'Бразилия',
                    'canada_pos' => 'Канада',
                    'chile_pos' => 'Чили',
                    'colombia_pos' => 'Колумбия',
                    'eu_pos' => 'Европа',
                    'hong_kong_pos' => 'Гонконг',
                    'india_pos' => 'Индия',
                    'indonesia_pos' => 'Индонезия',
                    'iran_pos' => 'Иран',
                    'israel_pos' => 'Израиль',
                    'japan_pos' => 'Япония',
                    'kazakhstan_pos' => 'Казахстан',
                    'kuwait_pos' => 'Кувейт',
                    'malaysia_pos' => 'Малайзия',
                    'mexico_pos' => 'Мексика',
                    'new_zealand_pos' => 'Новая Зеландия',
                    'oman_pos' => 'Оман',
                    'pakistan_pos' => 'Пакистан',
                    'peru_pos' => 'Перу',
                    'philippines_pos' => 'Филиппины',
                    'qatar_pos' => 'Катар',
                    'russia_pos' => 'Россия',
                    'saudi_arabia_pos' => 'Саудовская Аравия',
                    'singapore_pos' => 'Сингапур',
                    'south_africa_pos' => 'Южноафриканская Республика',
                    'south_korea_pos' => 'Южная Корея',
                    'switzerland_pos' => 'Швейцария',
                    'taiwan_pos' => 'Тайвань',
                    'thailand_pos' => 'Таиланд',
                    'trinidad_&_tobago_pos' => 'Тринидад и Тобаго',
                    'turkey_pos' => 'Турция',
                    'ukraine_pos' => 'Украина',
                    'united_arab_emirates_pos' => 'Объединенные Арабские Эмираты',
                    'united_states_pos' => 'США',
                    'vietnam_pos' => 'Вьетнам',
                ],
            ],
            'json_request' => [
                'errors' => [
                    'INVALID_ARGUMENT' => 'Один или несколько данных неверны. (:message)',
                    'MISSING_ARGUMENT' => 'Один или несколько данных отсутствуют. (:message)',
                    'OPERATION_NOT_ALLOWED' => 'Операция не разрешена. (:message)',
                    'FORBIDDEN' => 'Операция запрещена (:message)',
                ],
            ],
        ],
        '11' => [
            'availability_model' => 'Модель управления доступностью для типа комнаты "Private":',
            'per_room' => 'За комнату (avail*beds)',
            'per_person' => 'За кровать',
        ],
        '14' => [
            'availability_value_greater' => 'Вы ввели значение доступности, которое превышает допустимое.',
        ],
        '39' => [
            'period_not_valid' => 'Тариф :rate действителен с :valid_from по :valid_to. Обновление игнорируется.',
        ],
        '53' => [
            'warning_update_category' => 'Ошибка обновления категории комнаты :rate_xml. Правила не установлены на Beddy.',
            'empty_response_update' => 'Ошибка обновления: пустой ответ.',
        ],
        '68' => [
            'used_voucher' => 'ИСПОЛЬЗОВАННЫЙ ВАУЧЕР',
            'amount_voucher' => 'Сумма ваучера',
            'used_amount' => 'Использованная сумма',
            'virtual_rate_option' => 'Управление производными тарифами',
            'virtual_rate_option_off' => 'Не управлять (только для чтения)',
            'virtual_rate_option_on' => 'Включить управление производными тарифами (не управляемая цена)',
            'manage_type' => 'Тип связи',
            'manage_type_complete' => 'Полное управление',
            'manage_type_reservation' => 'Управление только бронированиями',
            'manage_type_avail_reservation' => 'Управление бронированиями и доступностью',
            'message_only_reservation' => 'Обновления игнорируются (связан с управлением только бронированиями)',
            'message_avail_reservation' => 'Обновления цен и ограничений игнорируются (связан с управлением бронированиями и доступностью)',
            'deposit_requested' => 'Требуется депозит',
            'deposit_payed' => 'Депозит оплачен',
            'payed_via' => 'Оплачено через',
        ],
        '69' => [
            'manage_type' => 'Тип связи',
            'manage_type_complete' => 'Полное управление',
            'manage_type_reservation' => 'Управление только бронированиями',
            'manage_type_avail_reservation' => 'Управление бронированиями и доступностью',
            'manage_type_avail_restriction_reservation' => 'Управление бронированиями, доступностью и ограничениями',
            'message_only_reservation' => 'Обновления игнорируются (связан с управлением только бронированиями)',
            'message_avail_reservation' => 'Обновления цен и ограничений игнорируются (связан с управлением бронированиями и доступностью)',
            'message_avail_restriction_reservation' => 'Обновления цен игнорируются (связан с управлением бронированиями, доступностью и ограничениями)',
        ],
        '72' => [
            'manage_type' => 'Тип связи',
            'manage_type_complete' => 'Полное управление',
            'manage_type_reservation' => 'Управление только бронированиями',
            'manage_type_avail_reservation' => 'Управление бронированиями и доступностью',
            'manage_type_avail_restriction_reservation' => 'Управление бронированиями, доступностью и ограничениями',
            'message_only_reservation' => 'Обновления игнорируются (связан с управлением только бронированиями)',
            'message_avail_reservation' => 'Обновления цен и ограничений игнорируются (связан с управлением бронированиями и доступностью)',
            'message_avail_restriction_reservation' => 'Обновления цен игнорируются (связан с управлением бронированиями, доступностью и ограничениями)',
        ],
        '73' => [
            'pricing_model' => 'Модель ценообразования',
            'per_room' => 'За комнату/тариф',
            'per_person' => 'За человека',
            'manage_type' => 'Тип связи',
            'manage_type_complete' => 'Полное управление',
            'manage_type_reservation' => 'Управление только бронированиями',
            'manage_type_avail_reservation' => 'Управление бронированиями и доступностью',
            'manage_type_avail_restriction_reservation' => 'Управление бронированиями, доступностью и ограничениями',
            'manage_type_avail_avail_price_reservation' => 'Управление бронированиями, доступностью и ценами',
            'message_only_reservation' => 'Обновления игнорируются (связан с управлением только бронированиями)',
            'message_avail_reservation' => 'Обновления цен и ограничений игнорируются (связан с управлением бронированиями и доступностью)',
            'message_avail_restriction_reservation' => 'Обновления цен игнорируются (связан с управлением бронированиями, доступностью и ограничениями)',
            'manage_avail_price_reservation' => 'Обновления ограничений игнорируются (связан с управлением бронированиями, доступностью и ценами)',
            'payment_info' => 'Информация о платеже',
            'payment_amount' => 'Сумма платежа',
            'payment_extra_info' => 'Детали',
            'payment_transaction' => 'Код транзакции',
            'payment_full' => 'Предоплата на всю сумму бронирования',
            'payment_partial' => 'Частичная предоплата',
            'payment_none' => 'Нет предоплаты',
            'payment_channel_collect' => 'Гость оплатил через канал',
            'payment_hotel_collect' => 'Гость должен оплатить в отеле (полностью или частично)',
            'payment_gateway' => 'Гость оплатил через банковский шлюз',
            'service_inclusive' => 'Включено в цену',
        ],
        '93' => [
            'reservation_status' => 'Статус бронирования',
            'booked' => 'Забронировано, ожидает подтверждения от объекта',
            'waiting_payment' => 'Ожидает предоплату',
            'payment_in_progress' => 'Платеж в процессе обработки и проверки',
            'confirmed' => 'Подтверждено',
            'canceled' => 'Отменено',
            'waiting_credit_card_guarantee' => 'Ожидает гарантию по кредитной карте',
            'deposit' => 'Депозит',
            'payed' => 'Оплачено',
            'not_payed' => 'Не оплачено',
            'payment_mothod' => 'Метод оплаты',
            'option_property_xml_id' => 'ID объекта (тот же, что и у Beddy)',
            'option_email' => 'Email',
            'option_apikey' => 'API-ключ',
        ],
        '95' => [
            'unknown_rate' => 'Неизвестная ставка PMS. ID комнаты и тариф, полученные от канала: ',
        ],
        'option_general' => [
            'property_xml_id' => 'Xml id объекта',
            'username' => 'Имя пользователя',
            'password' => 'Пароль',
        ],
        'general' => [
            'get_channel_rate_empty' => 'Нет данных, загруженных с портала',
            'no_data_to_update' => 'Нет данных для отправки.',
            'no_valid_period' => 'Обновленный период не является действительным. Обновление проигнорировано.',
            'no_valid_response' => 'Получен недействительный ответ от канала (:error_message)',
            'only_min_stay_update' => 'Объект настроен для обновления только минимального срока пребывания.',
            'period_not_valid' => 'Тариф :rate действителен с :valid_from по :valid_to. Обновление проигнорировано.',
            'no_valid_response_update' => 'Получен недействительный ответ от канала.',
            'discount' => 'Скидка',
            'unknown' => 'Неизвестно',
            'deposit_payed' => 'Депозит оплачен',
            'to_payed' => 'К оплате',
            'payment_type' => 'Тип',
            'ota_commission' => 'Комиссия OTA',
            'ota_due' => 'Должно быть выплачено OTA',
            'arrival_time' => 'Время прибытия',
            'cancellable_until' => 'Можно отменить до',
        ],
        'queue_update' => [
            'already_updated' => 'Обновление отправлено с кодом операции: :operation_code',
            'max_retry' => 'Максимальное количество попыток обновления канала: :channel_name - Период с: :date_from по :date_to. Последнее сообщение: :message',
            'queue_update_max_retry_strategy_mail' => 'Максимальное количество повторных отправок канала :channel_name - Объект: :property_name',
            'queue_update_exception_mail' => 'Исключение канала :channel_name - Объект: :property_name',
        ],
        'errors' => [
            'content_api_update_errors_mail_connectivity' => 'Ошибка обновления CONTENT-API :channel_name - Объект: :property_name',
            'property_is_related' => 'Объект не является основным и уже связан с другим объектом',
            'accommodation_channel_not_found' => 'Комната с id xml :accommodation_xml_id не найдена',
            'unsupported_min_dvance_res' => 'Этот канал не позволяет установить минимальное время предварительного бронирования.'
        ],
        'queue_past_reservations' => [
            'queue_task_exists' => 'Объект #:property_id уже в очереди на выполнение',
        ],
    ],

    'checkinonline' => [
        'policy' => [
            'privacy_policy_accept' => 'Я, нижеподписавшийся/ая, заявляю, что получил/а полную информацию в соответствии с статьями 13 и 14 Регламента ЕС 2016/679 и понял/а содержание этой информации.',
            'privacy_policy_auth_1' => 'Ответственный за обработку особых данных, указанных в статье 9 Регламента ЕС 679/2016, для обеспечения высокого уровня гостеприимства и защиты физического здоровья;',
            'privacy_policy_auth_2' => 'Ответственный за передачу данных о моем пребывании с целью получения сообщений и звонков, направленных ко мне.',
            'privacy_policy_auth_3' => 'Ответственный за отправку рекламных материалов на мои контактные данные.',
            'privacy_policy_authorize' => 'Авторизую',
            'privacy_policy_eighth_item' => '8. Могут ли мои данные быть переданы за границу?',
            'privacy_policy_eleventh_item' => '11. Каковы сроки для получения ответа от ответственного?',
            'privacy_policy_fifth_item' => '5. Как будут обрабатываться собранные данные?',
            'privacy_policy_first_item' => '1. Кто определяет цели и методы обработки данных?',
            'privacy_policy_first_paragraph' => 'В соответствии с статьями 13 и 14 Регламента ЕС № 2016/679 (далее \'GDPR\'), касающимся защиты персональных данных и их свободного обращения, :businessName, как Ответственный за обработку персональных данных, обязан предоставить всю информацию о целях и методах обработки ваших данных, а также указание лицам, которым ваши данные могут быть переданы, и всех правах, которые закон предоставляет вам в отношении обработки ваших данных.',
            'privacy_policy_fourth_item' => '4. Зачем вы собираете мои данные?',
            'privacy_policy_fourth_item_part_2' => 'Правовая основа обработки',
            'privacy_policy_list_eighth_item_1' => 'Другие страны ЕС, кроме Италии;',
            'privacy_policy_list_eighth_item_2' => 'Великобритания;',
            'privacy_policy_list_eighth_item_3' => 'Ирландия;',
            'privacy_policy_list_eighth_item_4' => 'Швейцария;',
            'privacy_policy_list_eighth_item_5' => 'США',
            'privacy_policy_list_fifth_item_1' => 'Через операции, которые позволят собирать, записывать, организовывать, сохранять, консультировать, обрабатывать, изменять, отбирать, извлекать, использовать, передавать, уничтожать и уничтожать данные.',
            'privacy_policy_list_fifth_item_2' => 'Используя электронные или автоматизированные средства для хранения, управления и передачи данных, но всегда настроенные так, чтобы гарантировать их максимальную конфиденциальность и необходимую защиту.',
            'privacy_policy_list_fifth_item_3' => 'Используя документы на бумажных носителях с мерами хранения, которые исключают доступ к данным для неавторизованных лиц.',
            'privacy_policy_list_fourth_item_1' => 'Управление клиентами;',
            'privacy_policy_list_fourth_item_10' => 'Защита и обеспечение безопасности и благополучия людей;',
            'privacy_policy_list_fourth_item_11' => 'Защита целостности собственности и корпоративных активов;',
            'privacy_policy_list_fourth_item_12' => 'Обеспечение безопасности инфраструктуры ИТ-технологий.',
            'privacy_policy_list_fourth_item_1_part_2' => 'Предоставление согласия;',
            'privacy_policy_list_fourth_item_2' => 'Заключение и управление договорами;',
            'privacy_policy_list_fourth_item_2_part_2' => 'Преддоговорные и договорные обязательства;',
            'privacy_policy_list_fourth_item_3' => 'Административное управление;',
            'privacy_policy_list_fourth_item_3_part_2' => 'Законодательные обязательства;',
            'privacy_policy_list_fourth_item_4' => 'Управление спорами;',
            'privacy_policy_list_fourth_item_4_part_2' => 'Законный интерес Ответственного.',
            'privacy_policy_list_fourth_item_5' => 'Обслуживание клиентов;',
            'privacy_policy_list_fourth_item_6' => 'Связи с общественностью',
            'privacy_policy_list_fourth_item_7' => 'Продажа, маркетинг и реклама;',
            'privacy_policy_list_fourth_item_8' => 'Защита физического здоровья людей;',
            'privacy_policy_list_fourth_item_9' => 'Внутренняя безопасность;',
            'privacy_policy_list_nineth_item_1' => '10 лет (в соответствии с гражданскими обязательствами - статья 2220 Гражданского кодекса);',
            'privacy_policy_list_nineth_item_2' => 'Максимум 3 месяца с даты выезда для данных кредитных карт;',
            'privacy_policy_list_nineth_item_3' => 'Максимум 3 года с последнего выезда для персональных данных, особенностей проживания, предпочтений, идентификационных документов, подписи и истории покупок и данных для маркетинга (пункты с 2.1 по 2.7), если не указано иное самим субъектом;',
            'privacy_policy_list_nineth_item_4' => 'Максимум 5 дней для изображений с видеонаблюдения;',
            'privacy_policy_list_nineth_item_5' => '90 дней с момента выезда для данных о телефонном трафике;',
            'privacy_policy_list_nineth_item_6' => '1 год для данных доступа и использования ресурсов ИТ.',
            'privacy_policy_list_second_item_1' => 'Персональные идентификационные данные;',
            'privacy_policy_list_second_item_2' => 'Особые данные;',
            'privacy_policy_list_second_item_3' => 'Данные о пребывании;',
            'privacy_policy_list_second_item_4' => 'Личные предпочтения;',
            'privacy_policy_list_second_item_5' => 'Идентификационные документы;',
            'privacy_policy_list_second_item_6' => 'Подпись;',
            'privacy_policy_list_second_item_7' => 'История покупок;',
            'privacy_policy_list_second_item_8' => 'Данные о кредитных и/или банковских картах;',
            'privacy_policy_list_second_item_9' => 'Изображения с видеонаблюдения;',
            'privacy_policy_list_second_item_10' => 'Данные об устройствах, используемых для подключения к сети объекта;',
            'privacy_policy_list_second_item_11' => 'Данные о телефонных звонках;',
            'privacy_policy_list_second_item_12' => 'Данные доступа и использования ИТ-ресурсов',
            'privacy_policy_list_second_item_extra' => 'Данные о состоянии здоровья.',
            'privacy_policy_list_seventh_item_1' => 'Назначенные лица;',
            'privacy_policy_list_seventh_item_2' => 'Ответственные за обработку;',
            'privacy_policy_list_seventh_item_3' => 'Системные администраторы;',
            'privacy_policy_list_seventh_item_4' => 'Консультанты бухгалтерии;',
            'privacy_policy_list_seventh_item_5' => 'Юридические консультанты;',
            'privacy_policy_list_seventh_item_6' => 'Банки',
            'privacy_policy_list_seventh_item_7' => 'Страховые компании;',
            'privacy_policy_list_seventh_item_8' => 'Аудиторские компании;',
            'privacy_policy_list_seventh_item_9' => 'Компании, предоставляющие услуги по обслуживанию гостиничной инфраструктуры',
            'privacy_policy_list_seventh_item_10' => 'Компании, предоставляющие услуги интернета и электронной почты;',
            'privacy_policy_list_seventh_item_11' => 'Организации, Ассоциации, Компании или частные лица, организующие мероприятия или пребывания в объекте;',
            'privacy_policy_list_seventh_item_12' => 'Государственные органы;',
            'privacy_policy_list_seventh_item_13' => 'Полиция.',
            'privacy_policy_list_third_item_1' => 'Онлайн-агентства, такие как Booking.com, Venere.com, Worldhotels.com, Trivago.com, Expedia.com и другие',
            'privacy_policy_list_third_item_2' => 'Традиционные туристические агентства;',
            'privacy_policy_list_third_item_3' => 'Организации, Ассоциации, Компании или частные лица, организующие мероприятия или пребывания в объекте;',
            'privacy_policy_location' => ':businessCity, там',
            'privacy_policy_name_surname' => 'Имя и фамилия',
            'privacy_policy_nineth_item' => '9. Как долго будут храниться мои данные?',
            'privacy_policy_not_authorize' => 'Не авторизую',
            'privacy_policy_second_item' => '2. Какие персональные данные подлежат обработке?',
            'privacy_policy_second_paragraph' => 'Просим вас ознакомиться с информацией и выразить согласие на обработку, подписав данное уведомление.',
            'privacy_policy_seventh_item' => '7. Кто будет иметь доступ к моим данным?',
            'privacy_policy_sign' => 'Подпись:',
            'privacy_policy_sixth_item' => '6. Зачем мне предоставлять мои данные ответственному? Могу ли я отказаться?',
            'privacy_policy_sub1' => 'Право на доступ к данным (статья 15, GDPR)',
            'privacy_policy_sub2' => 'Право на исправление (статья 16, GDPR)',
            'privacy_policy_sub3' => 'Право на удаление (статья 17, GDPR)',
            'privacy_policy_sub4' => 'Право на ограничение обработки (статья 18, GDPR)',
            'privacy_policy_sub5' => 'Право на переносимость данных (статья 20, GDPR)',
            'privacy_policy_sub6' => 'Право на возражение (статья 21, GDPR)',
            'privacy_policy_sub7' => 'Право на то, чтобы ваши данные не подвергались автоматизированному принятию решений, включая профилирование (статья 22, GDPR)',
            'privacy_policy_sub8' => 'Право на подачу жалобы в орган надзора (статья 77, GDPR)',
            'privacy_policy_tenth_item' => '10. Как я могу вмешаться, чтобы ограничить, предотвратить или возразить против обработки моих данных?',
            'privacy_policy_text_eighth_item' => 'Персональные данные могут быть переданы в страны ЕС или третьи страны за пределами ЕС или международные организации, если это необходимо для достижения целей, указанных в пункте 4, и выполнения взятых обязательств. На данный момент страны, в которые передаются ваши данные, следующие:',
            'privacy_policy_text_eleventh_item' => 'В случае запроса информации о ваших данных, Ответственный постарается предоставить ответ как можно скорее, если это не невозможно или не требует чрезмерных усилий, и в любом случае не позднее 30 дней с момента запроса. Все невозможности или задержки со стороны ответственного будут обоснованы.',
            'privacy_policy_text_first_item' => 'Ответственный за обработку данных: :businessName, расположенная в :businessCity по адресу :businessAddress, :businessCap, ИНН :businessVat.',
            'privacy_policy_text_second_item' => 'Ответственный за обработку данных соберет и обработает ваши персональные данные, которые могут вас идентифицировать и которые могут быть прямо или косвенно связаны с вами, включая, например:',
            'privacy_policy_text_second_item_part_2' => 'и все другие данные, которые могут быть необходимы для достижения целей, указанных в пункте 4.',
            'privacy_policy_text_second_item_part_2_span' => 'Также будут обработаны такие особые данные, как:',
            'privacy_policy_text_third_item' => 'Персональные данные предоставляются напрямую субъектом данных или собираются через другие источники, такие как:',
            'privacy_policy_text_fourth_item' => 'Персональные данные, собранные Ответственным, будут обработаны для следующих целей:',
            'privacy_policy_text_fourth_item_part_2' => 'Обработка данных будет осуществляться в строгом соответствии с законодательными требованиями, с соблюдением принципов законности и добросовестности и с уважением к праву на конфиденциальность. Обработка данных будет основываться на:',
            'privacy_policy_text_fifth_item' => 'Обработка будет выполняться как в автоматизированной, так и в ручной форме, в соответствии с требованиями статьи 32 GDPR 2016/679, а именно:',
            'privacy_policy_text_sixth_item' => 'Если предоставление персональных данных необходимо для выполнения договора или выполнения законодательных обязательств, то обработка данных обязательна. В случае отказа от предоставления данных, предусмотренных настоящим уведомлением, Ответственный не сможет выполнить действия, указанные в пункте 4, и в целом не сможет выполнить взятые обязательства.',
            'privacy_policy_text_sixth_item_span' => 'Отказ от предоставления данных, на обработку которых требуется согласие, не повлияет на выполнение обязательств.',
            'privacy_policy_text_seventh_item' => 'Персональные данные могут быть переданы и обработаны другими субъектами, которые являются уполномоченными, ответственными или независимыми контролерами данных, для выполнения преддоговорных, договорных или законодательных обязательств или в случае законного интереса.',
            'privacy_policy_text_seventh_item_part_2' => 'Данные, предоставленные и собранные Ответственным, не подлежат публичному распространению или профилированию.',
            'privacy_policy_text_seventh_item_span' => 'Категории получателей могут быть, например:',
            'privacy_policy_text_nineth_item' => 'Персональные данные будут храниться только в течение необходимого времени для выполнения задач, связанных с целями, указанными в настоящем уведомлении. В частности, сроки хранения следующие:',
            'privacy_policy_text_nineth_item_part_2' => 'За исключением случаев, когда более длительные сроки хранения установлены специализированными нормативными актами. В случае споров данные будут храниться до окончания срока давности, предусмотренного для защиты прав по контракту.',
            'privacy_policy_text_tenth_item' => 'С помощью письменного уведомления через Pec или рекомендованное письмо на адрес Ответственного за обработку данных, вы имеете право:',
            'privacy_policy_text_tenth_item_part_2' => 'Получить от Ответственного подтверждение того, происходит ли обработка ваших данных, и, в случае положительного ответа, получить доступ к своим данным и определенной информации, указанной в статье 15 GDPR.',
            'privacy_policy_text_tenth_item_part_3' => 'Получить от Ответственного исправление неточных данных без неоправданной задержки. С учетом целей обработки вы также имеете право на дополнение неполных данных, предоставив дополнительное заявление.',
            'privacy_policy_text_tenth_item_part_4' => 'Получить от Ответственного удаление своих данных без неоправданной задержки, если нет препятствий для реализации этого права.',
            'privacy_policy_text_tenth_item_part_5' => 'Получить, где возможно, ограничение обработки своих данных или отозвать ранее данное согласие. Отзыв согласия не влияет на законность обработки данных до отзыва.',
            'privacy_policy_text_tenth_item_part_6' => 'Если обработка основана на согласии или контракте и осуществляется автоматизированными средствами, вы имеете право получить ваши данные в структурированном формате и передать их другому Ответственному.',
            'privacy_policy_text_tenth_item_part_7' => 'Возразить в любое время против обработки ваших данных на основе законного интереса Ответственного или на основе вашего согласия, включая профилирование, если только Ответственный не сможет доказать, что существуют законные основания для обработки данных, которые перевешивают ваши права.',
            'privacy_policy_text_tenth_item_part_8' => 'Не быть подвергнутым решению, основанному исключительно на автоматизированной обработке данных, которое имеет юридические последствия или значительно влияет на вас. Как указано в пункте 7, Ответственный не использует автоматизированные решения.',
            'privacy_policy_text_tenth_item_part_9' => 'В случае нарушения настоящего Регламента, вы можете подать жалобу в надзорный орган или воспользоваться всеми правами, предусмотренными действующими законодательными актами.',
            'privacy_policy_text_twelfth_item' => 'Настоящее уведомление также применяется к данным, собранным до 25.05.2018.',
            'privacy_policy_third_item' => '3. Как собираются персональные данные?',
            'privacy_policy_title' => 'Политика конфиденциальности клиентов',
            'privacy_policy_title_first_item' => 'Ответственный за обработку данных',
            'privacy_policy_title_fourth_item' => 'Цели обработки',
            'privacy_policy_title_fifth_item' => 'Методы обработки',
            'privacy_policy_title_sixth_item' => 'Природа предоставления данных и отказ от их предоставления',
            'privacy_policy_title_seventh_item' => 'Передача данных',
            'privacy_policy_title_tenth_item' => 'Права субъекта данных',
            'privacy_policy_twelfth_item' => '12. Дата начала действия и эффективности',
            'privacy_policy_title_consent' => 'Заявления согласия на обработку данных',
            'privacy_policy_title_footer' => 'Для ознакомления с уведомлением',
            'privacy_policy_vers' => 'верс. 1.1 от 4.4.2019',
        ],
    ],

    'city_tax_channel' => [
        'default' => [
            'accommodations_mapping' => 'Карта номеров',
            'scheduled_send' => 'Вы хотите включить автоматическую отправку отчетов?',
            'scheduled_send_info' => 'Система автоматически отправляет всех гостей, выезжающих на день ранее текущей даты. Например, 25 июня она отправит гостей, выезжающих 24 июня.',
            'which_guests_to_send' => 'Автоматическая отправка: ',
            'only_invoiced' => 'Только гости с начисленным налогом',
            'all_guest_with_city_tax_calculated' => 'Все гости с рассчитанным налогом',
        ],
        'pay_tourist' => [
            'structure_id' => 'Id PayTourist структуры',
            'software_id' => 'ID авторизованного партнера программного обеспечения, выданный PayTourist',
            'get_extra_specifications' => 'Получить типы номеров',
            'token' => 'Токен для доступа к API, выданный PayTourist',
            'period' => 'Период для составления отчета по налогу на пребывание',
        ],
        'tourist_tax' => [
            'period' => 'Период для составления отчета по налогу на пребывание',
            'city_tax_channel_group_id' => 'Группа конфигурации для отправки/экспорта отчета по налогу на пребывание',
        ],
        'exceptions' => [
            'city_tax_channel_configuration_not_valid' => 'Следующие параметры для связи структуры с каналом отправки налога на пребывание не являются действительными: ',
            'channel_configuration_not_valid' => 'Следующие параметры, требуемые каналом :channelName, не являются действительными: :params',
            'channel_credential_not_valid' => 'Учетные данные канала :channelName не действительны',
            'channel_configuration_must_have_one_property' => 'Канал :channelName требует только одну структуру',
            'channel_params_not_valid' => 'Следующие параметры, требуемые каналом :channelName для создания отчета, не являются действительными: :params',
            'channel_configuration_missing' => 'Требуемые параметры конфигурации для канала :channelName отсутствуют в запросе',
            'channel_params_missing' => 'Параметры, требуемые каналом :channelName для создания отчета, отсутствуют в запросе',
            'city_tax_exemption_not_mapped' => 'Освобождение :exemptionName не предусмотрено для гостя :guestName :guestSurname бронирования :reservationId - :booker',
            'city_tax_channel_place_not_found' => 'Город :placeName еще не доступен для выбранного канала',
            'city_tax_channel_group_not_found' => 'Выбранная группа не существует',
            'file_not_valid' => 'Невозможно сохранить экспортированный файл в облаке для канала :channelName',
            'networking_error' => 'Ошибка при запросе на отправку отчета бронирования :reservationId для канала :channelName с ошибкой: :error',
            'channel_unreachable' => 'Невозможно связаться с каналом :channelName в данный момент по следующим ошибкам: :errors',
            'date_range_out_of_boundaries' => 'Максимальный период отчета для канала :channelName составляет :days дней с даты начала',
            'date_from_not_valid' => 'Минимальная дата начала формирования отчета для канала :channelName составляет не более :days дней до даты отправки',
            'guest_attributes_missing' => 'Невозможно отправить отчет по налогу на пребывание для канала :channelName из-за отсутствующих данных о гостях: :guests',
            'empty_report' => 'В запрашиваемом отчете по налогу на пребывание не найдено гостей',
            'endpoint_not_mapped' => 'Точка доступа для города :place для канала :channelName отсутствует, обратитесь в техническую поддержку',
        ],
    ],

    'city_tax_configuration' => [
        'errors' => [
            'restriction_fields_not_valid' => 'Переданные поля не принадлежат к ограничениям налога на пребывание',
            'option_fields_not_valid' => 'Переданные поля не принадлежат к опции налога на пребывание',
            'field_not_valid' => 'Поле :fieldNotValid не соответствует валидации :condition :validation',
            'configuration_override_already_exist' => 'Конфигурация налога на пребывание для выбранных дат уже существует',
        ],
        'exceptions' => [
            'city_tax_configuration_not_valid' => 'Следующие параметры для создания конфигурации налога на пребывание не являются действительными: ',
            'field_not_valid' => 'Поле :fieldName отсутствует среди ожидаемых полей конфигурации',
            'field_is_required' => 'Поле :fieldName обязательно для заполнения',
        ],
    ],

    'city_tax_option_field' => [
        'option_field' => [
            'nationality' => [
                'country_id' => [
                    'name' => 'Национальность',
                    'description' => 'Национальность гостя',
                ],
            ],
            'reservation_from' => [
                'reservation_from_id' => [
                    'name' => 'Происхождение',
                    'description' => 'Происхождение бронирования.',
                ],
            ],
            'reservation_reason' => [
                'reservation_reason_id' => [
                    'name' => 'Причина',
                    'description' => 'Причина бронирования.',
                ],
            ],
            'group_leader' => [
                'active' => [
                    'name' => 'Активно',
                    'description' => 'Активировать исключение.',
                ],
            ],
            'residence_country' => [
                'country_id' => [
                    'name' => 'Страна проживания',
                    'description' => 'Страна проживания гостя.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Освобождение',
                    'description' => 'Освобождение',
                ],
            ],
            'residence_state' => [
                'state_id' => [
                    'name' => 'Регион проживания',
                    'description' => 'Регион проживания гостя.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Освобождение',
                    'description' => 'Освобождение',
                ],
            ],
            'residence_county' => [
                'county_id' => [
                    'name' => 'Провинция проживания',
                    'description' => 'Провинция проживания гостя.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Освобождение',
                    'description' => 'Освобождение',
                ],
            ],
            'residence_city' => [
                'city_id' => [
                    'name' => 'Город проживания',
                    'description' => 'Город проживания гостя.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Освобождение',
                    'description' => 'Освобождение',
                ],
            ],
            'accommodation_tableau_number' => [
                'accommodation_tableau_number_id' => [
                    'name' => 'Жилье',
                    'description' => 'Жилье',
                ],
            ],
            'accommodation' => [
                'accommodation_id' => [
                    'name' => 'Тип жилья',
                    'description' => 'Тип жилья',
                ],
            ],
        ],
    ],

    'city_tax_option' => [
        'option' => [
            'nationality' => [
                'name' => 'Национальность',
                'description' => 'Национальность гостя',
            ],
            'reservation_from' => [
                'name' => 'Происхождение',
                'description' => 'Происхождение бронирования.',
            ],
            'reservation_reason' => [
                'name' => 'Причина',
                'description' => 'Причина бронирования.',
            ],
            'group_leader' => [
                'name' => 'Руководитель группы',
                'description' => 'Руководитель среди гостей.',
            ],
            'residence_country' => [
                'name' => 'Страна проживания',
                'description' => 'Страна проживания гостя.',
            ],
            'residence_state' => [
                'name' => 'Регион проживания',
                'description' => 'Регион проживания гостя.',
            ],
            'residence_county' => [
                'name' => 'Провинция проживания',
                'description' => 'Провинция проживания гостя.',
            ],
            'residence_city' => [
                'name' => 'Город проживания',
                'description' => 'Город проживания гостя.',
            ],
            'accommodation_tableau_number' => [
                'name' => 'Жилье',
                'description' => 'Жилье.',
            ],
            'accommodation' => [
                'name' => 'Тип жилья',
                'description' => 'Тип жилья.',
            ],
        ],
    ],

    'city_tax_restriction_field' => [
        'restriction_field' => [
            'age_range' => [
                'min_age' => [
                    'name' => 'Минимальный возраст',
                    'description' => 'Минимальный возраст категории',
                ],
                'max_age' => [
                    'name' => 'Максимальный возраст',
                    'description' => 'Максимальный возраст категории',
                ],
                'amount_price' => [
                    'name' => 'Фиксированная сумма',
                    'description' => 'Сумма налога на пребывание',
                ],
                'percentage_price' => [
                    'name' => 'Процент от суммы',
                    'description' => 'Процент для расчета суммы',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Освобождение',
                    'description' => 'Освобождение',
                ],
                'price_type' => [
                    'name' => 'Тип цены',
                    'description' => 'Тип цены',
                ],
            ],
            'percentage_range' => [
                'min_amount' => [
                    'name' => 'Минимальная сумма',
                    'description' => 'Минимальное значение для процентного расчета',
                ],
                'max_amount' => [
                    'name' => 'Максимальная сумма',
                    'description' => 'Максимальное значение для процентного расчета',
                ],
            ],
            'validity_period' => [
                'date_from' => [
                    'name' => 'Дата начала периода',
                    'description' => 'Дата начала действия',
                ],
                'date_to' => [
                    'name' => 'Дата окончания периода',
                    'description' => 'Дата окончания действия',
                ],
                'flag_year' => [
                    'name' => 'Сезонность',
                    'description' => 'Период действия каждый год',
                ],
            ],
            'price_range_night' => [
                'min_price' => [
                    'name' => 'Минимальная цена',
                    'description' => 'Минимальная цена для расчета',
                ],
                'max_price' => [
                    'name' => 'Максимальная цена',
                    'description' => 'Максимальная цена для расчета',
                ],
            ],
            'limit_days' => [
                'days' => [
                    'name' => 'Ночи применения',
                    'description' => 'Максимальное количество ночей для применения',
                ],
            ],
            'month_max_nights' => [
                'max_days' => [
                    'name' => 'Ночи применения',
                    'description' => 'Если гость превышает этот лимит в календарном месяце (даже если это разные и несмежные бронирования), налог больше не рассчитывается',
                ],
            ],
            'year_max_nights' => [
                'max_days' => [
                    'name' => 'Ночи применения',
                    'description' => 'Если гость превышает этот лимит в календарном году (даже если это разные и несмежные бронирования), налог больше не рассчитывается',
                ],
            ],
            'reservation_max' => [
                'max' => [
                    'name' => 'Максимальное количество',
                    'description' => 'Лимит количества бронирований, которые могут быть применены к конкретному гостю за год',
                ],
            ],
            'limit_nights' => [
                'min_nights' => [
                    'name' => 'Минимальное количество ночей',
                    'description' => 'Минимальное количество ночей в бронировании.',
                ],
                'max_nights' => [
                    'name' => 'Максимальное количество ночей',
                    'description' => 'Максимальное количество ночей в бронировании.',
                ],
            ],
            'range_nights' => [
                'night_from' => [
                    'name' => 'С ночи',
                    'description' => 'Ночь начала отсчета.',
                ],
                'night_to' => [
                    'name' => 'По ночь',
                    'description' => 'Ночь окончания отсчета.',
                ],
                'amount_price' => [
                    'name' => 'Фиксированная сумма',
                    'description' => 'Сумма налога на пребывание',
                ],
                'percentage_price' => [
                    'name' => 'Процент от суммы',
                    'description' => 'Процент для расчета суммы',
                ],
                'price_type' => [
                    'name' => 'Тип цены',
                    'description' => 'Тип цены',
                    'amount_name' => 'Сумма',
                    'percentage_name' => 'Процент',
                ],
            ],
            'adult_quote_range' => [
                'min_amount' => [
                    'name' => 'Минимальная сумма',
                    'description' => 'Выберите минимальную сумму взрослой ставки, рассчитанную на ночную цену без НДС',
                ],
                'max_amount' => [
                    'name' => 'Максимальная сумма',
                    'description' => 'Выберите максимальную сумму взрослой ставки, рассчитанную на ночную цену без НДС',
                ],
                'amount_price' => [
                    'name' => 'Фиксированная сумма',
                    'description' => 'Сумма налога на пребывание',
                ],
                'percentage_price' => [
                    'name' => 'Процент от суммы',
                    'description' => 'Процент для расчета суммы',
                ],
                'price_type' => [
                    'name' => 'Тип цены',
                    'description' => 'Тип цены',
                    'amount_name' => 'Сумма',
                    'percentage_name' => 'Процент',
                ],
            ],
            'price_type_name' => [
                'amount_name' => '€',
                'percentage_name' => '%',
            ],
        ],
    ],

    'city_tax_restriction' => [
        'restriction' => [
            'age_range' => [
                'name' => 'Возрастная категория',
                'description' => 'Возрастная категория для применения налога',
            ],
            'percentage_range' => [
                'name' => 'Пределы сумм для процентных расчетов',
                'description' => 'Пределы минимальной и максимальной суммы для процентных расчетов.',
            ],
            'validity_period' => [
                'name' => 'Период действия',
                'description' => 'Период применения налога.',
            ],
            'price_range_night' => [
                'name' => 'Диапазон дневной цены жилья',
                'description' => 'Минимальная и максимальная цена за ночь, чтобы она была учтена в расчете налога.',
            ],
            'limit_days' => [
                'name' => 'Максимальные ночи для применения',
                'description' => 'Лимит ночей применения.',
            ],
            'month_max_nights' => [
                'name' => 'Максимальные ночи для применения в месяц для конкретного гостя',
                'description' => 'Максимальное количество ночей для применения налога в месяц на гостя.',
            ],
            'year_max_nights' => [
                'name' => 'Максимальные ночи для применения в год для конкретного гостя',
                'description' => 'Максимальное количество ночей для применения налога в год на гостя.',
            ],
            'reservation_max' => [
                'name' => 'Максимальное количество бронирований, применяемых к конкретному гостю в год',
                'description' => 'Максимальное количество бронирований для гостя в год.',
            ],
            'limit_nights' => [
                'name' => 'Ограничения ночей для применения в бронировании',
                'description' => 'Минимальное и максимальное количество ночей в бронировании для применения налога.',
            ],
            'range_nights' => [
                'name' => 'Пересчитать расчет в зависимости от ночей бронирования',
                'description' => 'Номера ночей начала и окончания для бронирования.',
            ],
            'adult_quote_range' => [
                'name' => 'Цена для квоты гостя на ночь',
                'description' => 'Выберите диапазон квоты для гостя и соответствующую цену.',
            ],
        ],
    ],

    'city_tax' => [
        'tax_type' => [
            'xpax' => [
                'name' => 'Сумма на человека',
                'description' => 'Налог рассчитывается для каждого гостя по выбранным суммам, независимо от количества ночей проживания.',
            ],
            'xnightxpax' => [
                'name' => 'Сумма на человека за ночь',
                'description' => 'Налог рассчитывается для каждого гостя за каждую ночь проживания по выбранным суммам.',
            ],
            'xnight' => [
                'name' => 'Сумма за ночь',
                'description' => 'Налог рассчитывается за каждую ночь проживания по выбранной сумме, независимо от количества гостей.',
            ],
            'xroomxnight' => [
                'name' => 'Процент от стоимости проживания за ночь',
                'description' => 'Налог рассчитывается как процент от стоимости проживания за каждую ночь, независимо от количества гостей.',
            ],
            'xroomxnightxpax' => [
                'name' => 'Процент от доли проживания на человека за ночь',
                'description' => 'Налог рассчитывается для каждого гостя за каждую ночь проживания как процент от доли проживания (стоимость проживания делится на количество гостей).',
            ],
            'xroomxtotalnightxpax' => [
                'name' => 'Процент от стоимости проживания на человека за ночь',
                'description' => 'Налог рассчитывается для каждого гостя за каждую ночь проживания как процент от стоимости проживания.',
            ],
            'xtotalroomxnightxpax' => [
                'name' => 'Процент от общей стоимости (проживание + дополнительные услуги) на человека за ночь',
                'description' => 'Налог рассчитывается для каждого гостя за каждую ночь проживания как процент от общей стоимости (проживание + дополнительные услуги).',
            ],
            'xbook' => [
                'name' => 'Фиксированная сумма единовременно',
                'description' => 'Налог рассчитывается по фиксированной сумме, независимо от количества ночей и гостей.',
            ],
            'xroomextraxnightxpax' => [
                'name' => 'Процент от доли проживания + дополнительных услуг на человека за ночь',
                'description' => 'Налог рассчитывается для каждого гостя за каждую ночь проживания как процент от доли проживания + дополнительных услуг (стоимость проживания + дополнительные услуги делятся на количество гостей).',
            ],
        ],
        'price_type' => [
            'amount' => 'Сумма',
            'percentage' => 'Процент',
            'amount_percentage' => 'Сумма и процент',
        ],
        'warnings' => [
            'no_tax_for_accommodation' => 'К проживанию :accommodation_name не применима ни одна из доступных конфигураций налога на проживание.',
            'no_guests_for_accommodation' => 'Для проживания :accommodation_name отсутствуют гости, для которых необходимо рассчитывать налог на проживание.',
        ],
        'errors' => [
            'no_city_tax_configuration' => 'Налог на проживание не настроен.',
        ],
        'city_tax_extra_text' => 'Сумма налога является ориентировочной и может измениться в соответствии с нормативными требованиями, действующими на момент проживания.',
    ],

    'cloners' => [
        'treatments' => [
            'description' => 'Этот параметр позволяет клонировать услуги исходного объекта в целевой объект. При выборе этого параметра услуги исходного объекта будут удалены.',
        ],
        'accommodations' => [
            'description' => 'Этот параметр позволяет клонировать номера исходного объекта. Если выбраны тарифные планы, будут созданы связи, отражающие структуру исходного объекта.',
        ],
        'priceLists' => [
            'description' => 'Этот параметр позволяет клонировать прайс-листы исходного объекта.',
        ],
        'ratePlans' => [
            'description' => 'Этот параметр позволяет клонировать тарифные планы исходного объекта.',
        ],
        'rates' => [
            'description' => 'Этот параметр позволяет клонировать тарифы исходного объекта.',
        ],
        'modules' => [
            'description' => 'Этот параметр позволяет клонировать модули исходного объекта.',
        ],
        'customers' => [
            'description' => 'Этот параметр позволяет клонировать клиентов исходного объекта.',
        ],
        'companies' => [
            'description' => 'Этот параметр позволяет клонировать компании исходного объекта.',
        ],
        'invoiceLayouts' => [
            'description' => 'Этот параметр позволяет клонировать шаблоны счетов исходного объекта.',
        ],
        'addons' => [
            'description' => 'Этот параметр позволяет клонировать дополнительные услуги исходного объекта.',
        ],
        'availabilities' => [
            'description' => 'Этот параметр позволяет клонировать доступность исходного объекта.',
        ],
        'childrenRanges' => [
            'description' => 'Этот параметр позволяет клонировать диапазоны для детей исходного объекта.',
        ],
        'roles' => [
            'description' => 'Этот параметр позволяет клонировать роли исходного объекта.',
        ],
        'paymentMethods' => [
            'description' => 'Этот параметр позволяет клонировать методы оплаты исходного объекта.',
        ],
        'rules' => [
            'description' => 'Этот параметр позволяет клонировать все правила исходного объекта.',
        ],
        'emailTemplates' => [
            'description' => 'Этот параметр позволяет клонировать все шаблоны электронных писем исходного объекта.',
        ],
        'events' => [
            'description' => 'Этот параметр позволяет клонировать все события исходного объекта.',
        ],
        'policies' => [
            'description' => 'Этот параметр позволяет клонировать все условия отмены исходного объекта.',
        ],
        'cityTaxes' => [
            'description' => 'Этот параметр позволяет клонировать вкладку: Конфигурации налога на проживание.',
        ],
    ],

    'common' => [
        'datetime' => [
            'default' => '%d/%m/%Y %H:%M',
            'extended_phrasal_date' => '%A, %e %B %Y',
            // "Пятница, 7 Июня 2019"
            'extended_phrasal_date_short' => '%a, %e %b %Y',
            // "Пт, 7 Июн 2019"
            'extended_phrasal_date_with_time' => '%A, %e %B %Y - %H:%M',
            // "Пятница, 7 Июня 2019 - 18:03"
            'extended_phrasal_date_short_with_time' => '%a, %e %b %Y - %H:%M',
            // "Пт, 7 Июн 2019 - 18:03"
            'phrasal_date' => '%e %B %Y',
            // "7 Июня 2019"
            'phrasal_date_short' => '%e %b %Y',
            // "7 Июн 2019"
            'date' => '%d/%m/%Y',
            // "07/06/2019" для 7 июня 2019
            'for_range' => '%d %b',
            // "04 Апр" - для указания диапазона дат, например, "04 Апр - 07 Апр"
            'time' => '%H:%M',
            // 24-часовой формат времени; например, "00:00" или "18:03"
            'year' => 'Год',
            'month' => 'Месяц',
            'day' => 'День',
            'time' => 'Время',
            'dates_interval' => 'Интервал дат',
            'from_day' => 'С',
            'to_day' => 'По',
            'days' => 'Дни',
            'months' => [
                1 => 'Январь',
                2 => 'Февраль',
                3 => 'Март',
                4 => 'Апрель',
                5 => 'Май',
                6 => 'Июнь',
                7 => 'Июль',
                8 => 'Август',
                9 => 'Сентябрь',
                10 => 'Октябрь',
                11 => 'Ноябрь',
                12 => 'Декабрь',
            ],
            'months_short' => [
                1 => 'Янв',
                2 => 'Фев',
                3 => 'Мар',
                4 => 'Апр',
                5 => 'Май',
                6 => 'Июн',
                7 => 'Июл',
                8 => 'Авг',
                9 => 'Сен',
                10 => 'Окт',
                11 => 'Ноя',
                12 => 'Дек',
            ],
            'days_of_week' => [
                'None' => 'Воскресенье',
                'None' => 'Понедельник',
                'None' => 'Вторник',
                'None' => 'Среда',
                'None' => 'Четверг',
                'None' => 'Пятница',
                'None' => 'Суббота',
            ],
            'days_of_week_short' => [
                'None' => 'Вс',
                'None' => 'Пн',
                'None' => 'Вт',
                'None' => 'Ср',
                'None' => 'Чт',
                'None' => 'Пт',
                'None' => 'Сб',
            ],
            'days_of_week_initials' => [
                'None' => 'В',
                'None' => 'П',
                'None' => 'В',
                'None' => 'С',
                'None' => 'Ч',
                'None' => 'П',
                'None' => 'С',
            ],
        ],
        'currency' => [
            'display' => ':prefix :symbol :amount',
            'format' => '%.2n',
        ],
        'gender' => [
            'male' => 'Мужчина',
            'female' => 'Женщина',
        ],
        'bool' => [
            'yes_no' => [
                1 => 'Да',
                0 => 'Нет',
            ],
            'true_false' => [
                1 => 'Истина',
                0 => 'Ложь',
            ],
        ],
        'exports' => [
            'customers_generic' => 'Список клиентов',
            'companies_generic' => 'Список компаний',
            'reservations_generic' => 'Список бронирований',
            'reservations_invoices_opened_generic' => 'Список открытых счетов',
            'reservations_invoices_generic' => 'Список счетов',
            'social_archive_generic' => 'Список клиентов с доступными предложениями',
            'reservations_quotes_all_generic' => 'Список всех предложений',
            'reservations_quotes_active_generic' => 'Список активных предложений',
            'reservations_quotes_revoked_generic' => 'Список отклоненных предложений',
            'reservations_quotes_accepted_generic' => 'Список принятых предложений',
            'reservations_quotes_expired_generic' => 'Список просроченных предложений',
            'reservations_quotes_draft_generic' => 'Список черновых предложений',
            'rateplans_generic' => 'Список тарифных планов, предложений и пакетов',
            'rateplans_plans_generic' => 'Список тарифных планов',
            'rateplans_offers_generic' => 'Список предложений',
            'rateplans_bundles_generic' => 'Список пакетов',
            'coupons_generic' => 'Список купонов',
            'reservations_list' => 'Список бронирований',
            'housekeeper' => 'уборка_:date',
            'total_entries' => 'Всего записей: :value',
            'meals' => 'Питание',
            'meals_plan' => 'План питания',
            'city_tax' => 'Налог на проживание',
            'reservations_guests_presences' => 'Гости на объекте',
            'deposits' => 'Авансы и залоги',
            'reservations_guests_presences' => '滞在中のゲスト'
        ],
        'number_of_nights' => 'Количество ночей',
        'user_full_name' => 'Оператор',
        'print_date' => 'Дата печати',
        'total' => 'Итого',
        'totals' => 'Итоги',
        'quantity' => 'Количество',
        'category' => 'Категория',
        'qty' => 'Кол-во',
        'discount' => 'Скидка',
        'description' => 'Описание',
        'wrap_up' => 'Итоги',
        'amount' => 'Сумма',
        'vat' => 'НДС',
        'nic' => 'ИНН',
        'reservation' => 'Бронирование',
        'nights' => '{1} 1 Ночь|[2,*] :count Ночи',
        'accommodation' => '{1} 1 Проживание|[2,*] :count Проживаний',
        'vat_code' => 'НДС Код',
        'unmapped_addons' => 'Дополнительные услуги с портала ',
        'details' => 'Детали',
        'stripe_statement_descriptor' => 'Номер бронирования: :reservationNumber - :email',
        'date' => 'Дата',
        'available_soon' => 'Эта функция скоро будет доступна',
        'payments' => 'Платежи',
        'buyer' => 'Плательщик',
        'payment_method' => 'Метод оплаты',
        'yes' => 'Да',
        'no' => 'Нет',
        'checkin_hour' => 'Чек-ин в',
        'checkout_hour' => 'Чек-аут в',
    ],

    'company' => [
        'errors' => [
            'vat_code_not_valid' => 'Указанный НДС код недействителен',
            'tax_code_not_valid' => 'Указанный налоговый код недействителен',
        ],
        'warnings' => [
            'existing_company' => 'Компания :company_name уже существует с указанным НДС кодом',
        ],
        'export_fields' => [
            'name' => 'Имя',
            'address' => 'Адрес',
            'vat_code' => 'НДС Код',
            'zip_code' => 'Индекс',
            'email' => 'Электронная почта',
            'telephone' => 'Телефон',
            'state' => 'Регион',
            'county' => 'Область',
            'country' => 'Страна',
            'city' => 'Город',
            'tax_code' => 'Налоговый код',
            'nick_name' => 'Никнейм',
        ],
        'import' => [
            'validations' => [
                'vat_code_unique' => 'Компания с таким же НДС кодом уже существует',
                'vat_code_required' => 'Поле НДС код обязательно',
                'name_required' => 'Поле название обязательно',
                'nick_name_required' => 'Поле никнейм обязательно',
                'email' => 'Поле email содержит неверный email',
                'pec' => 'Поле pec содержит неверный email',
            ],
        ],
        'fields' => [
            'company_id' => 'идентификатор компании'
        ],
    ],

    'content_api' => [
        'bank_transfer' => 'Принимается банковский перевод',
        'bank_transfer_note' => 'Заметки для банковского перевода (максимум 500 символов)',
        'checkin_hour' => 'Время заселения',
        'checkout_hour' => 'Время выселения',
        'children_allowed' => 'Разрешены дети',
        'pets_allowed' => 'Разрешены животные',
        'smoking_allowed' => 'Разрешено курение',
        'max_adults_number' => 'Максимальное количество взрослых',
        'max_guests_number' => 'Максимальное количество гостей',
        'minimum_age' => 'Минимальный возраст',
        'percent_payment_at_booking' => '% оплаты при бронировании',
        'remaining_payment_type' => 'Оставшаяся оплата',
        'remaining_payment_type_at_checkin_label' => 'Оплата при заселении',
        'remaining_payment_type_at_checkin_description' => 'Оставшаяся оплата будет запрошена при заселении',
        'remaining_payment_type_before_checkin_label' => 'Оплата за X дней до заселения',
        'remaining_payment_type_before_checkin_description' => 'Оставшаяся оплата будет запрошена за X дней до заселения',
        'remaining_payment_type_before_checkin_day' => 'Количество дней до заселения',
        'rental_document_upload' => 'Загрузка документа аренды',
        'advertise_name' => 'Имя рекламодателя',
        'merchant_name' => 'Имя продавца',
        'managment_applies_guest_value' => 'Стоимость обслуживания гостя',
        'managment_applies_guest_type' => 'Тип стоимости обслуживания гостя',
        'managment_applies_pets_value' => 'Стоимость обслуживания животных',
        'managment_applies_value' => 'Стоимость управления',
        'management_energy_value' => 'Стоимость обслуживания энергии',
        'management_energy_type' => 'Тип стоимости обслуживания энергии',
        'managment_applies_pets_type' => 'Тип стоимости обслуживания животных',
        'x_night' => 'За ночь',
        'x_stay' => 'За пребывание',
    ],

    'coupons' => [
        'refundable' => [
            '0' => 'Невозвратный',
            '1' => 'Возвратный',
        ],
        'export_fields' => [
            'code' => 'Код',
            'quantity' => 'Количество',
            'discount' => 'Скидка',
            'date_from' => 'С',
            'date_to' => 'По',
            'type' => 'Тип',
            'min_expense' => 'Минимальная трата',
            'min_stay' => 'Мин. пребывание',
            'max_stay' => 'Макс. пребывание',
            'valid_days' => 'Действующие дни',
        ],
    ],

    'credit_card_type' => [
        'fields' => [
            'model_name' => 'Кредитная карта',
        ],
    ],

    'customer' => [
        'errors' => [
            'reservationExists' => 'Существуют связанные бронирования или предложения.',
            'guestExist' => 'Существуют связанные гости.',
            'documentExists' => 'Документ такого же типа уже существует в архиве.',
            'privacyCheckExists' => 'Политика конфиденциальности уже была принята клиентом.',
            'customerNotFound' => 'Клиент не найден.',
            'guestExists' => 'Клиент настроен как гость в активных бронированиях.',
            'tax_code_not_valid' => 'Указанный налоговый код недействителен.',
            "birthday_date_major_than_now" => "Дата рождения не может быть позже сегодняшней даты.",
        ],
        'fields' => [
            'birthday_date' => 'дата рождения гостя',
            'sex' => 'пол гостя',
            'address' => 'адрес гостя',
            'zip_code' => 'почтовый индекс гостя',
            'email' => 'электронная почта гостя',
            'telephone' => 'телефон гостя',
            'name' => 'имя гостя',
            'surname' => 'фамилия гостя',
            'model_name' => 'гость',
            'language_id' => 'язык'
        ],
        'export_fields' => [
            'name' => 'Имя',
            'surname' => 'Фамилия',
            'birthday_date' => 'Дата рождения',
            'sex' => 'Пол',
            'note' => 'Заметки',
            'city' => 'Город',
            'county' => 'Район',
            'state' => 'Регион',
            'country' => 'Страна',
            'address' => 'Адрес',
            'zip_code' => 'Почтовый индекс',
            'email' => 'Электронная почта',
            'telephone' => 'Телефон',
            'fax' => 'Факс',
            'facebook' => 'Facebook',
            'linkedin' => 'Linkedin',
            'twitter' => 'Twitter',
            'web_address' => 'Веб-сайт',
            'birth_city_name' => 'Город рождения',
            'birth_state_name' => 'Страна рождения',
            'birth_state' => 'Регион рождения',
            'residence_city' => 'Место жительства - Город',
            'residence_county' => 'Место жительства - Район',
            'residence_state' => 'Место жительства - Регион',
            'residence_country' => 'Место жительства - Страна',
            'residence_address' => 'Место жительства - Адрес',
            'residence_zip_code' => 'Место жительства - Почтовый индекс',
            'billing_city' => 'Фактурирование - Город',
            'billing_county' => 'Фактурирование - Район',
            'billing_state' => 'Фактурирование - Регион',
            'billing_country' => 'Фактурирование - Страна',
            'billing_address' => 'Фактурирование - Адрес',
            'billing_zip_code' => 'Фактурирование - Почтовый индекс',
            'promotion_check' => 'Рассылка',
            'privacy_check' => 'GDPR',
            'reservations_count' => 'Бронирования',
            'type' => 'Тип',
            'newsletter' => 'Рассылка',
            'GDPR' => 'GDPR',
        ],
        'import' => [
            'validations' => [
                'nic_unique' => 'Клиент с таким же налоговым кодом уже существует.',
                'name_required' => 'Поле имя обязательно.',
                'sex' => 'Поле пол недействительно. Разрешенные значения: не определено, мужской, женский.',
                'surname_required' => 'Поле фамилия обязательно.',
                'email' => 'Поле email содержит некорректный адрес.',
                'birthday_date_date_format' => 'Поле дата рождения имеет некорректный формат.',
                'document_type' => 'Тип документа не существует.',
                'birth_country_not_valid' => 'Поле страна рождения недействительно.',
                'birth_city_not_valid' => 'Поле город рождения недействительно.',
                'citizenship_country_not_valid' => 'Поле гражданство недействительно.',
                'residence_country_not_valid' => 'Поле страна проживания недействительно.',
                'residence_city_not_valid' => 'Поле город проживания недействительно.',
                'nationality_country_not_valid' => 'Поле национальность недействительно.',
                'language' => 'Поле язык недействительно. Используйте ISO формат в нижнем регистре (например: it, en).',
            ],
            'alredy-in-progress' => 'Импорт еще выполняется, дождитесь завершения и повторите попытку.',
        ],
    ],

    'daily_closure' => [
        'daily_title' => 'Ежедневное закрытие',
        'department' => 'Отдел',
        'production' => 'Производство',
        'total' => 'Итого',
        'property' => 'Объект',
        'receipt' => 'Квитанция',
        'name' => 'Имя',
        'invoice' => 'Счет',
        'amount' => 'Баланс',
        'guests' => 'Гости',
        'accommodation' => 'Комнаты',
        'empty_documents' => 'За выбранный период не было выдано или получено никаких документов.',
        'empty_payments' => 'За выбранный период не было произведено или получено никаких платежей.',
        'export_fields' => [
            'production_department' => 'Производство по отделам',
            'production_treatments' => 'Производство по услугам',
            'production_accommodations' => 'Производство по размещениям',
            'occupancy' => 'Занятость',
            'documents' => 'Документы с :date_from|Документы с :date_from по :date_to',
            'payments' => 'Платежи с :date_from|Платежи с :date_from по :date_to',
            'summary' => 'Кассовый отчет (:date_from)|Кассовый отчет (:date_from - :date_to)',
            'accommodations_sold' => 'Проданные комнаты',
            'sold_nights' => 'Проданные ночи',
            'unsold_nights' => 'Непроданные ночи',
            'penalty_nights' => 'Штрафные ночи',
            'accommodations_available' => 'Доступные комнаты',
            'date' => 'Дата',
            'income' => 'Доход',
            'outcome' => 'Расходы',
            'occupancy' => 'Занятость',
            'payment_method' => 'Метод оплаты',
            'type' => 'Тип',
            'reversal_receipt' => 'Сторно квитанции',
            'number' => 'Номер',
            'in' => 'Поступления',
            'out' => 'Расходы',
            'intestatary' => 'Владелец',
            'name' => 'Имя',
            'modality' => 'Способ',
            'note' => 'Примечания',
            'taxable' => 'Облагаемое налогом',
            'vat_quote' => 'НДС',
            'treatment' => 'Услуга',
            'average_revenue' => 'Средний доход на гостя',
            'adr' => 'ADR',
            'revpar' => 'RevPar',
            'reservations' => 'Бронирования',
            'no_show' => 'Не явились',
            'confirmed' => 'Подтвержденные',
            'cancelled' => 'Отмененные',
            'optionable' => 'Опции',
            'expired' => 'Просроченные',
            'unknown' => 'Неизвестно',
            'checkin' => 'Заезды',
            'checkout' => 'Выезды',
            'in_house' => 'Оставшиеся',
            'attendance' => 'Посещаемость',
            'absolute_guests' => 'Абсолютное число гостей',
        ],
    ],

    'daily_summary' => [
        'daily_summary' => 'Ежедневный отчет',
        'accommodation' => 'Комната',
        'accommodation_type' => 'Тип комнаты',
        'name_and_surname' => 'Имя и фамилия',
        'stay' => 'Проживание',
        'guests' => 'Гости',
        'treatment' => 'Услуга',
        'channel' => 'Канал',
        'payment_details' => 'Детали оплаты',
        'notes' => 'Примечания',
        'adults' => 'Взрослые',
        'children' => 'Дети',
        'total' => 'Итого',
        'arrivals' => 'Прибытия',
        'departures' => 'Отъезды',
        'in_home' => 'Оставшиеся',
        'nights' => 'Ночи',
        'paid' => 'Оплачено',
        'to_pay' => 'К оплате',
        'no_reservations_found' => 'На эту дату нет бронирований.',
        'daily_summary_of_date' => 'Ежедневный отчет за :date',
    ],

    'deposits' => [
        'export_fields' => [
            'property' => 'Объект',
            'number' => 'Номер',
            'deposit_number' => 'Номер депозита',
            'document_number' => 'Номер документа',
            'date' => 'Дата',
            'registration_date' => 'Дата регистрации',
            'type' => 'Тип',
            'amount' => 'Сумма',
            'amount_available' => 'Доступная сумма',
            'amount_used' => 'Использовано',
            'reservation_number' => 'ID бронирования',
            'pos' => 'POS',
            'description' => 'Описание',
            'buyer' => 'Плательщик',
            'reservation_id' => 'ID бронирования',
            'used_amount' => 'Использовано',
            'user_pay' => 'Плательщик',
            'reservation' => 'Бронирование',
            'payment_method' => 'Способ оплаты',
            'arrival_date' => 'Дата прибытия',
            'departure_date' => 'Дата отъезда',
            'deposit' => 'Депозит',
            'part_payment' => 'Частичная оплата',
            'stay' => 'Проживание',
        ],
    ],

    'email_suppression_list' => [
        'reason_types' => [
            'BOUNCE' => 'Недоставлено',
            'COMPLAINT' => 'Помечено как СПАМ',
        ],
        'errors' => [
            'NotFoundException' => 'Электронная почта не найдена',
            'BadRequestException' => 'Неверные параметры запроса',
            'TooManyRequestsException' => 'Слишком много запросов',
            'TooManyRequestException' => 'Слишком много запросов',
        ],
    ],

    'emails' => [
        'multiple_sessions' => [
            'subject' => 'Предупреждение безопасности: несколько устройств подключены к вашей учетной записи',
            'body' => "Здравствуйте, :user_first_name,<br />мы обнаружили подключения с нескольких устройств к вашей учетной записи. Рекомендуем проверить активные сессии:",
            'summary_reset' => 'Если вы не узнаете эти устройства, <a href=":recoveryPasswordLink" target="_blank">рекомендуем немедленно изменить пароль</a> для защиты вашей учетной записи.',
            'device' => 'Устройство',
            'place' => 'Место',
            'date_hour' => 'Дата и время',
            'unknown' => 'Неизвестно',
            'logout' => 'Также вы можете <a href=":logoutAllDevice" target="_blank">выйти</a> со всех устройств через Профиль > Безопасность и доступ.',
        ],
        'general' => [
            'link_preview' => 'нажмите здесь для печатной версии',
            'additionals_informations' => 'Дополнительная информация',
            'automatic_email_message' => 'Это письмо отправлено автоматически, пожалуйста, не отвечайте на этот адрес.',
            'message' => 'Сообщение',
        ],
        'reservation_confirmed' => [
            'subject' => 'Бронирование номер #:reference_number',
            'reservation_confirm' => 'Ваше бронирование',
            'reply' => 'Ответить',
            'tax' => 'Налоги',
            'reservation_number' => 'номер',
            'thanks' => 'Спасибо',
            'view_quote' => 'нажмите здесь, чтобы увидеть предложение',
            'show_detail' => '<a href=":showDetailsReservation">Нажмите здесь, чтобы просмотреть бронирование</a>',
            'confirm_reservation_with_bank_transfer_suggestion' => 'Для завершения бронирования рекомендуем как можно скорее завершить оплату',
            'your_reservation' => 'Ваше бронирование для',
            'is_confirmed' => 'подтверждено',
            'ti_aspettiamo_il' => 'Мы ждем вас',
            'city_tax' => 'Налог на проживание',
            'reservation_summary' => 'Сводка бронирования',
            'nights' => 'Ночь|Ночей',
            'accommodations' => 'Размещение|Размещения',
            'adults' => 'взрослый|взрослых',
            'childrens' => 'ребенок|детей',
            'reservation_confirmed_with_stripe' => 'Бронирование подтверждено через платежный шлюз Stripe',
            'total_reservation' => 'Общая сумма бронирования',
            'price_payed' => 'Оплаченная сумма',
            'price_to_pay' => 'Сумма к оплате',
            'payment_method' => 'Способ оплаты',
            'other_request' => 'Спецификации и другие запросы',
            'banktransfer_informations' => 'Банковские реквизиты',
            'printable_link' => 'Нажмите здесь для печатной версии',
            'other_operations' => 'Другие операции',
            'checkin' => 'Онлайн регистрация',
            'modify_reservation' => 'Изменить бронирование',
            'cancel_reservation' => 'Отменить бронирование',
            'additional_informations' => 'Дополнительная информация',
            'contability_informations' => 'После получения платежа на сумму <b>:price_deposit</b> мы подтвердим бронирование. Для ускорения процесса отправьте нам копию платежного поручения с номером CRO.',
            'checkin_online_pin' => 'Ваш код для выполнения <a style="color: #8f743f; text-decoration: underline !important;" target="_blank" href=":link">онлайн регистрации</a> — ',
            'pin' => 'Пин-код',
        ],
        'reservation_request_avail' => [
            'subject' => 'Запрос на доступность для :property_name (:arrival_date - :departure_date)',
            'reservation_confirm' => 'Запрос на доступность',
            'reply' => 'Ответить',
            'tax' => 'Налоги',
            'reservation_number' => 'номер',
            'thanks' => 'Спасибо',
            'view_quote' => 'нажмите здесь, чтобы увидеть предложение',
            'show_detail' => 'нажмите здесь, чтобы просмотреть бронирование',
            'show_detail_avail' => 'нажмите здесь, чтобы просмотреть запрос на доступность',
            'your_request_avail' => 'Ваш запрос на доступность для',
            'is_confirmed' => 'был отправлен',
            'invalid_reservation' => 'Обратите внимание, что этот запрос не имеет силы бронирования, пока не будет подтвержден.',
            'invalid_reservation_property' => 'Этот запрос не имеет силы бронирования, клиент ждет вашего подтверждения.',
            'receive_news' => 'Вы получите ответ в кратчайшие сроки.',
            'city_tax' => 'Налог на проживание',
            'reservation_summary' => 'Сводка запроса',
            'nights' => 'Ночь|Ночей',
            'accommodations' => 'Размещение|Размещения',
            'adults' => 'взрослый|взрослых',
            'childrens' => 'ребенок|детей',
            'total_reservation' => 'Общая сумма бронирования',
            'price_payed' => 'Оплаченная сумма',
            'price_to_pay' => 'Сумма к оплате',
            'payment_method' => 'Способ оплаты',
            'other_request' => 'Спецификации и другие запросы',
            'printable_link' => 'Нажмите здесь для печатной версии',
            'other_operations' => 'Другие операции',
            'additional_informations' => 'Дополнительная информация',
        ],
        'reservation_cancelled_from_user' => [
            'subject' => 'Бронирование отменено (#:reference_number)',
            'body_1' => 'Здравствуйте,<br>настоящее автоматическое письмо подтверждает отмену бронирования №<b>:reference_number</b>, выполненную <b>:booked_at</b>.',
            'body_2' => '<b>Сводка бронирования</b><br>
                 <b>:name :surname</b> (с <b>:arrival_date</b> по <b>:departure_date</b>)<br>
                 <b>Комната:</b> :reservation_accommodations<br>
                 <b>Гости: </b> :total_guests<br>
                 <b>Итого: </b> :currency  :total_price',
            'body_policy_no_penalty' => 'Согласно <b>Условиям Отмены</b>, вы не понесете штрафов.',
            'body_policy_penalty' => 'Согласно <b>Условиям Отмены</b>, вам будет начислен штраф в размере :currency :penalty_value.',
            'body_3' => 'Если у вас есть вопросы, пожалуйста, свяжитесь с нами.',
        ],
        'property_reservation_new' => [
            'subject' => 'Новое бронирование через :channel_name - :property_name (#:reference_number)',
        ],
        'property_reservation_modified' => [
            'subject' => 'Изменение бронирования через :channel_name (#:reference_number)',
        ],
        'invoice_rejected' => [
            'subject' => 'Счет №:number_complete от :invoice_date отклонен SDI',
            'body' => 'Счет № <b>:number_complete</b> был отклонен SDI по следующей причине: <b>:rejected_reason</b>',
        ],
        'invoice_received' => [
            'subject' => 'Получен счет №:document_number от :document_date от :sender_name',
            'body' => 'Получен счет № <b>:document_number</b> от <b>:document_date</b> от <b>:sender_name</b>',
        ],
        'document_default_email' => [
            'body' => 'Уважаемый клиент,<br>ниже приведена информация о :document_type :document_number от :document_date.<br>Во вложении вы найдете копию документа.<br><br>С уважением,<br>:sender_name',
        ],
        'suspend_email_reminder' => [
            'subject' => '{{% invoice.type %}} № {{% invoice.number_complete %}}',
            'body' => 'Уважаемый клиент,<br>наша система показывает, что {{% invoice.type %}} {{% invoice.number_complete %}} от {{% invoice.invoice_date %}} на сумму {{% invoice.total %}} еще не была оплачена.<br><br>Пожалуйста, произведите оплату как можно скорее.<br>Во вложении вы найдете копию документа.<br><br>Если вы уже произвели оплату, проигнорируйте это сообщение.<br><br>С уважением,<br>{{% reservation.property_name %}}',
        ],
        'property_reservation_cancelled' => [
            'subject' => 'Бронирование отменено через :channel_name (#:reference_number)',
            'body_1' => 'На канале <b>:channel_name</b> было отменено бронирование <b>:xml_reservation_id</b> на имя <b>:name :surname</b> (с <b>:arrival_date</b> по <b>:departure_date</b>) для комнат объекта <b>:property_name</b>:<br>:accommodations_lists',
            'body_2' => 'Чтобы просмотреть все детали бронирования, <a href="https://app.beddy.io/reservation/:reservation_id">нажмите здесь</a>',
        ],
        'property_reservation_banktransfer_cancelled' => [
            'subject' => 'Бронирование отменено через :channel_name (#:reference_number) из-за отсутствия оплаты',
            'body_1' => 'Бронирование было автоматически отменено из-за отсутствия оплаты банковским переводом.<br /><br />
                <u>Подробности отмены:</u><br /><br />
                Объект: <b>:property_name</b><br />
                Канал: :channel_name<br />
                ID бронирования/ссылка: :xml_reservation_id<br />
                Клиент: <b>:name :surname</b><br />
                Период проживания: с <b>:arrival_date</b> по <b>:departure_date</b><br />
                Затронутые номера: <br>:accommodations_lists<br />',
            'body_2' => 'Чтобы просмотреть все детали бронирования, <a href="https://app.beddy.io/reservation/:reservation_id">нажмите здесь</a>',
        ],
        'past_connect_reservation_cancelled' => [
            'subject' => 'Уведомление: бронирование отменено, но отсутствует в Beddy, проверьте доступность',
            'body' => 'Было отменено бронирование, которое отсутствует в Beddy, <strong>необходима ручная проверка</strong>, так как доступность размещений может быть не обновлена.
                <br>
                Причины отсутствия бронирования могут быть следующими:
                <br>
                1. Бронирование было сделано до подключения Channel Manager: не все порталы позволяют загрузить старые бронирования (или их загрузка ограничена по времени).
                <br>
                2. Клиент отменил бронирование сразу после его создания, и портал мог отправить только отмену, не отправляя самого бронирования. Поэтому в Beddy отсутствует соответствующая ссылка.
                <br>
                <br>
                <strong>Детали отмененного бронирования:</strong>
                <br>
                Канал: :channel_name
                <br>
                ID бронирования: :xml_reservation_id
                <br>
                Дата выполнения: :booked_at
                <br>
                Клиент: :customer_name :customer_surname
                <br>
                <br>
                <strong>Что делать:</strong>
                <br>
                - Проверьте в экснете портала наличие бронирования и его отмены.
                <br>
                - Проверьте доступность на Beddy и в экснете портала и, если необходимо, обновите её через Channel Manager.
                <br><br>
                С уважением',
        ],
        'property_activation' => [
            'subject' => 'Аккаунт :product_name - :property_name',
            'footer' => 'Если вам потребуется дополнительная информация, наша служба поддержки к вашим услугам с понедельника по пятницу с 10:00 до 14:00 и с 15:30 до 18:00.
                Благодарим вас за выбор :product_name и желаем успехов.
                <br><br>
                С уважением',
        ],
        'users' => [
            'changedPassword' => [
                'subject' => 'Beddy - Ваш пароль был изменён',
                'summary' => 'Уважаемый(ая) <b>:firstname</b>,<br>сообщаем вам, что пароль вашей учётной записи <b>Beddy</b> был успешно изменён.',
                'errors' => [
                    'unexpectedNotice' => 'Если вы не меняли пароль, пожалуйста, свяжитесь с администратором объекта и/или нашей службой поддержки.<br><br>
                С уважением,<br>
                Команда Beddy',
                ],
            ],
            'attachment' => [
                'subject' => 'Вы были добавлены к новой недвижимости на Beddy',
                'summary' => 'Уважаемый <b>:firstname</b>,<br>Ваш аккаунт Beddy был связан с новой недвижимостью.<br><br>Вот данные для доступа:',
                'property' => 'Недвижимость',
                'roleAssigned' => 'Назначенная роль',
                'loginDetails' => [
                    'login' => 'Вы всегда можете получить доступ к этой недвижимости через app.beddy.io с теми же учетными данными.',
                    'helpContactInfo' => 'При необходимости вы можете связаться с:',
                    'master' => 'администратором недвижимости: :masterEmail',
                    'support' => 'Служба поддержки Beddy: <a href="mailto: :supportEmail">:supportEmail</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'Если вы не ожидали этого сообщения или считаете, что произошла ошибка, не завершайте активацию и свяжитесь с администратором недвижимости и/или нашей поддержкой.',
                ],
            ],
            'activation' => [
                'subject' => 'Вас пригласили в Beddy – Активируйте свой доступ',
                'summary' => 'Уважаемый(ая) <b>:firstname</b>,<br> для вас была создана учетная запись Beddy.<br><br> Ваши данные:',
                'username' => 'Имя пользователя',
                'email' => 'Электронная почта',
                'toDo' => 'Чтобы <b>активировать учетную запись</b>, необходимо установить <b>пароль</b>.',
                'button' => '<a href=":creationPasswordLink">Создать пароль</a>',
                'expiration' => 'Ссылка для активации действительна в течение 5 дней.',
                'contacts' => [
                    'helpContactInfo' => 'В случае необходимости вы можете связаться с:',
                    'master' => 'администратором объекта размещения: ',
                    'support' => 'службой поддержки Beddy: <a href=\"mailto:support@beddy.io\">support@beddy.io</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'Если вы не ожидали это сообщение или считаете, что оно было отправлено по ошибке, пожалуйста, не завершайте активацию и свяжитесь с администратором объекта и/или нашей службой поддержки.',
                    'uncompletedRegistration' => 'Регистрация не завершена: учетная запись еще не активна. Проверьте письмо, которое мы вам отправили, и установите пароль для активации.',
                ]
            ],
            'passwordreset' => [
                'subject' => 'Сброс пароля аккаунта :product_name',
                'body' => 'Здравствуйте, <b>:first_name!</b>
                <br/>
                Вы получили это письмо, потому что запросили смену пароля для вашего аккаунта :product_name.
                <br><br>
                Чтобы сменить пароль, нажмите <a href=":link_reset">здесь</a> в течение 30 минут.
                <br>
                Если вы не запрашивали смену пароля или больше не хотите его менять, проигнорируйте это письмо.
                <br>
                С уважением.',
            ],
            'password_expiration_notify' => [
                'subject' => 'Уведомление об истечении срока действия пароля учетной записи Beddy',
                'body' => 'Уважаемый(ая) <b>:name :surname</b>,
                <br/>
                Сообщаем вам, что пароль, связанный с вашей учетной записью Beddy, истекает через <b>:days дней</b>. Пожалуйста, обновите его как можно скорее в разделе <a href=":profile" target="_blank">Профиль</a>.
                <br><br>
                Если вы забыли свой текущий пароль, вы можете сбросить его, нажав <i><a href=":resetPassword" target="_blank">Проблемы со входом?</a></i> на <a href=":login" target="_blank">странице входа</a>.
                <br>
                <br>
                С уважением,<br>
                Команда Beddy',
            ],
        ],
        'bank_transfer_reminder' => [
            'subject' => 'Бронирование номер :reference_number - Напоминание о банковском переводе',
            'body' => 'Уважаемый(ая) :booker_name :booker_surname,<br>
                касаемо вашего бронирования :reference_number от :booked_at, напоминаем, что для подтверждения бронирования мы ожидаем оплату в размере :price.
                <br><br>
                Ниже указаны банковские реквизиты для оплаты:<br>
                <i>:bank_text</i>
                <br><br>
                Если мы не получим оплату в ближайшие дни, бронирование будет автоматически отменено.
                <br><br>
                Если вы уже произвели оплату, пожалуйста, проигнорируйте это сообщение.<br>
                Для получения дополнительной информации, свяжитесь с нами.<br>',
            'footer' => 'С уважением,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'bank_transfer_cancelled' => [
            'subject' => 'Бронирование отменено номер :reference_number',
            'body' => 'Уважаемый(ая) :booker_name :booker_surname,<br>
                так как мы не получили от вас оплату, сообщаем, что бронирование :reference_number от :booked_at было отменено.
                <br><br>
                Для получения дополнительной информации, свяжитесь с нами.<br>',
            'footer' => 'С уважением,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'cutoff_errors' => [
            'subject' => 'Ошибка отправки cutoff - :property_name',
            'body_1' => 'Для объекта <b>:property_name</b> обнаружены следующие ошибки:<br><br>',
            'footer' => 'С уважением.',
        ],
        'deactivate_properties' => [
            'first_notice' => [
                'subject' => 'Продление аккаунта Beddy',
                'body_1' => 'Уважаемый клиент,
                    <br><br>
                    Мы рады подтвердить продление вашего аккаунта Beddy и всех связанных с ним услуг.
                    <br><br>',
                'body_2' => 'В ближайшие дни через канал SDI вы получите счет за использование программного обеспечения Beddy (с :date_from по :date_to). Пожалуйста, отправьте нам копию произведенной оплаты для ускорения обработки.
                    <br><br>
                    Ваши данные:',
                'body_3' => 'Для получения дополнительной информации наша служба поддержки доступна с понедельника по пятницу с 10:00 до 14:00 и с 15:30 до 18:00.',
                'footer' => 'Благодарим за выбор Beddy и желаем успехов.
                    <br><br>
                    С уважением,',
            ],
            'second_notice' => [
                'subject' => 'Продление аккаунта Beddy',
                'body_1' => 'Уважаемый клиент,
                    <br><br>
                    Мы рады еще раз подтвердить продление вашего аккаунта Beddy и всех связанных с ним услуг.
                    <br><br>
                    В ближайшее время через канал SDI вы получите счет за использование программного обеспечения Beddy (с :date_from по :date_to).
                    <br><br>
                    Ваши данные:',
                'body_2' => 'Для получения дополнительной информации наша служба поддержки доступна с понедельника по пятницу с 10:00 до 14:00 и с 15:30 до 18:00.
                    <br><br>
                    Благодарим за выбор Beddy и желаем успехов.
                    <br><br>
                    С уважением,',
            ],
        ],
        'reservation_quote_expire' => [
            'subject' => 'Ваше предложение истекло',
            'body_1' => 'Уважаемый :customer_name :customer_surname,
                <br>сожалеем сообщить, что ваше предложение от :creation_date только что истекло.',
            'body_2' => '<br><br>Для получения дополнительной информации, пожалуйста, свяжитесь с нами.',
            'footer' => '<br><br>С уважением,
                <br>:property_name
                <br>:property_telephone
                <br>:property_email',
        ],
        'reservation_quote_expire_property' => [
            'subject' => 'Ваше предложение истекло',
            'body_1' => 'Предложение для клиента :customer_name :customer_surname, созданное вами :creation_date, только что истекло.',
            'footer' => '<br><br>С уважением.',
        ],
        'housekeeper_maintainer' => [
            'subject' => 'Новое уведомление о техобслуживании для жилья :accommodation_name',
            'body' => 'Было добавлено новое уведомление о техобслуживании для жилья <b>:accommodation_name</b> (<b>:tableau_label</b>). Все данные ниже: <br><br><b>Заголовок:</b> :title <br><br><b>Описание:</b> :description',
        ],
        'payments_timetable' => [
            'stripe_not_active' => [
                'subject' => 'Ошибка автоматического списания (ID: :payment_timetable_id - :scheduled_date) - Stripe не активен',
                'body' => 'Не удалось выполнить автоматическое списание (ID: :payment_timetable_id от :scheduled_date - Бронирование :reservation_reference_number на имя :booker_name :booker_surname), так как активный аккаунт Stripe для списания отсутствует.',
            ],
            'no_credit_card' => [
                'subject' => 'Ошибка автоматического списания (ID: :payment_timetable_id - :scheduled_date) - Карта не добавлена',
                'body' => 'Не удалось выполнить автоматическое списание (ID: :payment_timetable_id от :scheduled_date - Бронирование :reservation_reference_number на имя :booker_name :booker_surname), так как отсутствует карта для списания.',
            ],
            'charge_failed' => [
                'subject' => 'Ошибка автоматического списания (ID: :payment_timetable_id - :scheduled_date)',
                'body' => 'Не удалось выполнить автоматическое списание (ID: :payment_timetable_id от :scheduled_date - Бронирование :reservation_reference_number на имя :booker_name :booker_surname) по следующей причине: :error_description',
            ],
            'payment_exceeded' => [
                'subject' => 'Ошибка автоматического списания (ID: :payment_timetable_id - :scheduled_date) - Сумма превышает общую стоимость бронирования',
                'body' => 'Не удалось выполнить автоматическое списание (ID: :payment_timetable_id от :scheduled_date - Бронирование :reservation_reference_number на имя :booker_name :booker_surname), так как сумма списания превышает общую стоимость бронирования.',
            ],
        ],
        'reservation_quote_expire_days_before' => [
            'subject' => 'Ваше предложение скоро истечет',
            'body_1' => 'Уважаемый :customer_name :customer_surname,
                <br>сообщаем, что <a href=":quote_link">предложение</a>, запрошенное вами, истечет :expire_date.',
            'body_2' => '<br><br>Для получения дополнительной информации, пожалуйста, свяжитесь с нами.',
            'footer' => '<br><br>С уважением,
                <br>:property_name
                <br>:property_telephone
                <br>:property_email',
        ],
        'email_auth_verification' => [
            'body' => 'Уважаемый(ая) :name :surname, <br/> <br/> вот PIN-код, который вы запросили для подтверждения входа в ваш аккаунт Beddy: <strong>:pin</strong> <br/> <br/> Ваш PIN-код истечет в :expire_time',
        ],
        'user_update_email_verification_code' => [
            'body' => 'Уважаемый(ая) :name :surname, <br/> <br/> чтобы завершить запрос на изменение вашего аккаунта Beddy, введите этот PIN-код: <strong>:pin</strong>',
            'warning' => 'Если вы не запрашивали изменения, мы рекомендуем вам <a href=":recoveryPasswordLink" target="_blank">немедленно сменить пароль</a>, чтобы защитить ваш аккаунт. <br/> <br/> 
            Кроме того, вы можете выполнить выход со всех устройств через меню <a href=":logoutAllDevice" target="_blank"> Профиль > Защита и доступ</a>.',
        ],
        'user_update_email_confirmed' => [
            'subject' => 'Ваш адрес электронной почты был обновлен',
            'body' => 'Уважаемый(ая) :name :surname, <br/> <br/> электронная почта, связанная с вашим аккаунтом Beddy, была успешно обновлена.<br/> <br/> С этого момента вы будете получать уведомления на этот адрес.',
        ],
        'checkin_online_complete' => [
            'subject' => 'Онлайн регистрация выполнена - :reference_number',
            'body_1' => 'Уважаемый(ая) <b>:property_name</b>, <br/><br /> <b>:main_guest_name :main_guest_surname</b> только что выполнил(а) онлайн регистрацию для следующего бронирования:<br/>',
            'reservation_number' => 'Бронирование #:reference_number',
            'view_guests' => 'Проверьте данные гостей',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'subject' => 'Изменение статуса уборки для размещения :cleanable_name - :accommodation_name',
            'body' => ':user_name установил(а) статус уборки на <b>:clean_status</b> на дату <b>:reference_date</b> для размещения <b>:cleanable_name</b> (:accommodation_name) в объекте :property_name.',
        ],
        'reservation_option_expired' => [
            'subject' => 'Истекла опция бронирования (#:reference_number)',
            'body' => 'Бронирование номер <b>:reference_number</b> на имя <b>:booker_name :booker_surname</b> с датой прибытия <b>:arrival_date</b> и датой отъезда <b>:departure_date</b> истекло.',
        ],
        'order_payment_release' => [
            'subject' => 'Предавторизация платежа снята (#:reference_number)',
            'body' => 'Предавторизация платежа для бронирования номер <b>:reference_number</b> (с: <b>:arrival_date</b> по <b>:departure_date</b>) на имя <b>:customer_name :customer_surname</b> была снята.',
        ],
        'sca_authorized' => [
            'subject' => 'SCA авторизована (#:reference_number)',
            'body' => 'SCA для бронирования номер <b>:reference_number</b> на имя <b>:booker_name :booker_surname</b> (с: <b>:arrival_date</b> по <b>:departure_date</b>) была авторизована <b>:accepted_date</b>. IP-адрес, с которого была выполнена авторизация SCA: <b>:ip_address</b>.',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => 'Доступность закончилась для размещения :accommodation_name - Объект: (:property_name)',
            'body' => 'На дату <b>:date_now</b> закончилась доступность размещения: <b>:accommodation_name - (:property_name)</b> на следующие дни: <b>:days</b>',
        ],
        'guests_reporting' => [
            'error_levels' => [
                'reservation' => 'Бронирование :reservationId - :booker',
                'accommodation' => 'Размещение :accommodationType - :accommodationTableauNumber',
                'guest' => 'Гость :guest',
            ],
            'alloggiatiweb' => [
                'mail' => [
                    'subject' => 'Отчет о "Schedine Alloggiati" - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'summary' => 'Ниже представлен отчет о "Schedine Alloggiati" на дату :alloggiatiweb_send_date для группы отправки :alloggiatiweb_group_label:',
                    'success' => [
                        'body' => ':number из :alloggiatiweb_guest_total отправлено.|:number из :alloggiatiweb_guest_total отправлены.',
                    ],
                    'error_internal' => [
                        'body' => ':number из :alloggiatiweb_guest_total не отправлено из-за следующих ошибок:<br/>:errors|:number из :alloggiatiweb_guest_total не отправлено из-за следующих ошибок:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Не удалось отправить "Schedine Alloggiati" из-за следующих ошибок, сообщенных порталом:<br/>:errors',
                    ],
                    'fix_error' => 'Необходимо исправить ошибки и повторно отправить "Schedine Alloggiati" через <a href=":link">Документы > Schedine Istat и Alloggiati</a>',
                ],
                'push' => [
                    'subject' => 'Schedine Alloggiati - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'success' => [
                        'body' => ':number из :alloggiatiweb_guest_total отправлено.|:number из :alloggiatiweb_guest_total отправлены.',
                    ],
                    'error_internal' => [
                        'body' => ':number из :alloggiatiweb_guest_total не отправлено.
        Заполните недостающие данные или исправьте ошибки и попробуйте отправить вручную.|:number из :alloggiatiweb_guest_total не отправлено.
        Заполните недостающие данные или исправьте ошибки и попробуйте отправить вручную.',
                    ],
                    'error_external' => [
                        'body' => 'Не удалось отправить "Schedine Alloggiati" из-за следующих ошибок, сообщенных порталом:\n:errors\nИсправьте ошибки и попробуйте отправить вручную.',
                    ],
                ],
                'warning' => [
                    'subject' => 'Ошибки в Schedine Alloggiati - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'error_internal' => [
                        'body' => ':number из :alloggiatiweb_guest_total не отправлено из-за следующих ошибок:<br/>:errors|:number из :alloggiatiweb_guest_total не отправлено из-за следующих ошибок:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Не удалось отправить "Schedine Alloggiati" из-за следующих ошибок, сообщенных порталом:\n:errors\nИсправьте ошибки и попробуйте отправить вручную.',
                    ],
                    'fix_error' => 'Необходимо исправить ошибки и повторно отправить "Schedine Alloggiati" через <a href=":link">Документы > Schedine Istat и Alloggiati</a>',
                ],
            ],
            'istat' => [
                'mail' => [
                    'subject' => 'Отчет о "Schedine ISTAT" - :istat_send_date - :istat_group_label',
                    'summary' => 'Ниже представлен отчет о "Schedine ISTAT" на дату :istat_send_date для группы отправки :istat_group_label:',
                    'success' => [
                        'body' => ':number из :istat_guest_total отправлено.|:number из :istat_guest_total отправлены.',
                    ],
                    'error_internal' => [
                        'body' => ':number из :istat_guest_total не отправлено из-за следующих ошибок:<br/>:errors|:number из :istat_guest_total не отправлено из-за следующих ошибок:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Не удалось отправить "Schedine ISTAT" из-за следующих ошибок, сообщенных порталом:<br/>:errors',
                    ],
                    'fix_error' => 'Необходимо исправить ошибки и повторно отправить "Schedine ISTAT" через <a href=":link">Документы > Schedine Istat и Alloggiati</a>',
                ],
                'push' => [
                    'subject' => 'Schedine ISTAT :istat_send_date - :istat_group_label',
                    'success' => [
                        'body' => ':number из :istat_guest_total отправлено.|:number из :istat_guest_total отправлены.',
                    ],
                    'error_internal' => [
                        'body' => ':number из :istat_guest_total не отправлено.
        Заполните недостающие данные или исправьте ошибки и попробуйте отправить вручную.|:number из :istat_guest_total не отправлено.
        Заполните недостающие данные или исправьте ошибки и попробуйте отправить вручную.',
                    ],
                    'error_external' => [
                        'body' => 'Не удалось отправить Schedine ISTAT из-за следующих ошибок:
        :errors
        Исправьте ошибки и попробуйте отправить вручную.',
                    ],
                ],
            ],
        ],
        'treatment_price_update' => [
            'subject' => 'Расчет цен на лечение (:treatment_name) - :property_name',
            'body' => 'Расчет с :start_date по :end_date был успешно завершен.',
        ],
        'reservation_message_received' => [
            'subject' => 'Новое сообщение от :senderName (#:reference)',
            'title' => ':senderName отправил(а) вам сообщение!',
            'sender_wrote' => 'Гость написал:',
            'go_to_conversation' => 'Перейти к беседе',
        ],
        'external_services' => [
            'UrmetSclak' => [
                'error_generate_key_subject' => 'Ошибка создания ключей для бронирования :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'Произошла ошибка в системе Sclak при создании ключей для комнат. <br> :errors <br> Повторите попытку вручную, если ошибка повторяется, обратитесь в поддержку Urmet.',
                'error_seding_sms_subject' => 'Ошибка отправки SMS ключей для бронирования :booker_name :booker_surname (#ID: :reference_number)',
                'error_seding_sms_body' => 'Не удалось отправить SMS для Sclak, так как произошла ошибка. <br> Рекомендуем обратиться в поддержку Urmet.',
            ],
            'nuki' => [
                'error_generate_key_subject' => 'Ошибка создания PIN-кода для бронирования :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'Произошла ошибка в системе Nuki при создании PIN-кодов для комнат. <br> :errors <br> Повторите попытку вручную, если ошибка повторяется, обратитесь в поддержку Nuki.',
                'unauthorized_opening' => 'Несанкционированное открытие'
            ],
            'warning' => [
                'subject' => 'Ошибка создания ключей для бронирования :booker_name :booker_surname (#ID: :reference_number)',
                'body' => 'Произошла ошибка в системе Sclak при создании ключей для комнат. <br> :errors <br> Повторите попытку вручную, если ошибка повторяется, обратитесь в поддержку Urmet.',
            ],
            'remote_door_key_service' => [
                'reservation_resumed' => [
                    'title' => 'Изменения в бронировании, необходимо создать новые ключи',
                    'body' => 'Необходимо создать новый ключ для бронирования <b>:booker_name :booker_surname- :reference_number</b> для объекта <b>:property_name</b>. Старый ключ был деактивирован после изменения состояния бронирования.',
                ],
                'reservation_moved' => [
                    'title' => 'Одно или несколько размещений были перемещены. Необходимо создать новый ключ.',
                    'body' => 'Одно или несколько размещений в бронировании <b>:booker_name :booker_surname- :reference_number</b> для объекта <b>:property_name</b> были перемещены. Необходимо создать новый ключ.',
                ],
            ],
        ],
        'conversation_message_send_failed' => [
            'subject' => 'Ошибка отправки сообщения',
            'title' => 'Сообщение, адресованное :recipientName, не было доставлено. Попробуйте отправить его снова.',
            'go_to_conversation' => 'Перейти к беседе',
        ],
        'newsletters' => [
            'newsletter_sent_subject' => 'Подтверждение отправки рассылки',
            'newsletter_sent_content' => 'Кампания ":newsletterName" была доставлена :sentContacts получателям из :totalContacts выбранных контактов.',
            'newsletter_not_sent_subject' => 'Ошибка отправки рассылки',
            'newsletter_exceeded_sent_limit_subject' => 'Превышен лимит отправки рассылок на месяц',
            'newsletter_exceeded_sent_limit_content' => 'Рассылка :newsletterName не была отправлена, так как превышен месячный лимит отправки электронных писем.',
            'newsletter_not_sent_content' => 'Не удалось отправить кампанию ":newsletterName" по следующим причинам: :errorMessage',
        ],
        'city_taxes_reports' => [
            'send_city_tax_report' => [
                'subject' => 'Подтверждение отправки отчета по налогам на проживание',
                'content' => 'Отправка отчета по налогу на проживание для канала :channelName была успешно выполнена.',
            ],
            'send_city_tax_report_not_completed' => [
                'subject' => 'Ошибка отправки отчета по налогу на проживание',
                'content' => 'Отправка отчета по налогу на проживание для канала :channelName не была успешной.',
            ],
            'export_city_tax_report' => [
                'subject' => 'Экспорт отчета по налогу на проживание для канала :channelName завершен',
                'content' => 'Нажмите на следующую ссылку, чтобы перейти к историческим данным по отчетам по налогу на проживание: <a href=":link">Исторический отчет по налогу на проживание</a>.',
            ],
            'export_city_tax_report_not_completed' => [
                'subject' => 'Не удалось завершить экспорт отчета по налогу на проживание для канала :channelName',
                'content' => 'Генерация отчета :reportId не была успешной.',
            ],
            'guest_atrtributes_missing' => [
                'subject' => 'Ошибка отправки/экспорта отчета по налогу на проживание',
            ],
            'empty_report' => [
                'subject' => 'Не удалось завершить отправку/экспорт отчета по налогу на проживание для канала :channelName',
                'content' => 'Отчет по налогу на проживание не был обработан, так как для выбранного периода не были извлечены гости для отправки в канал.',
            ],
        ],
        'accommodation_deleted' => [
            'subject' => '[Требуется действие] - Необходимо обновить доступность',
        ],
        'max_email_attachments_size_exceeded' => 'Размер вложенных файлов превышает максимально допустимый лимит в 8 МБ',
        'check_pci_expiration' => [
            'expiring_certification' => [
                'subject' => 'Beddy - Важное уведомление: истечение срока действия PCI сертификации',
                'content' => 'Уважаемый партнер :apiPartnerName,<br><br>
                            Ваш PCI сертификат истекает через 30 дней.<br>
                            Пожалуйста, отправьте нам обновленный сертификат по адресу <a href="mailto:support@beddy.io">support@beddy.io</a> до даты истечения срока.<br>
                            После истечения срока доступ к данным платежей будет отозван.<br><br>
                            Команда Beddy',
            ],
            'certification_expired' => [
                'subject' => 'PCI сертификат истек',
                'content' => 'Уважаемый партнер :apiPartnerName,<br>
                            Ваш PCI сертификат истек.<br>
                            В связи с этим доступ к данным платежей был отозван.<br>
                            Пожалуйста, отправьте нам обновленный сертификат по адресу <a href="mailto:support@beddy.io">support@beddy.io</a>, чтобы восстановить доступ.<br><br>
                            Команда Beddy',
            ],
        ],
        'api_partner_disabled' => [
            'subject' => 'Beddy - Важное уведомление: отключение API аккаунта',
            'body' => 'Уважаемый партнер :apiPartnerName,<br>
                    Ваш аккаунт был отключен из-за слишком большого количества запросов.<br>
                    После проверки вашей системы, пожалуйста, свяжитесь с нами по адресу <a href="mailto:support@beddy.io">support@beddy.io</a> для восстановления аккаунта.<br><br>
                    Команда Beddy',
        ],
        'api_partner_disabled_test' => [
            'subject' => 'Beddy - Важное уведомление: возможное отключение API аккаунта',
            'body' => 'Партнер :apiPartnerName,<br>
                    был отключен из-за слишком большого количества запросов к сервису: :errorMessage.<br>',
        ],
        'property_first_login' => [
            'subject' => 'Beddy - Доступ с нового устройства',
            'summary' => 'Здравствуйте, :user_first_name,<br> был обнаружен вход в ваш аккаунт Beddy с нового устройства.',
            'summary_reset' => 'Если вы не узнаете это устройство, рекомендуется <a href=":recoveryPasswordLink" target="_blank">немедленно сменить пароль</a>, чтобы защитить свой аккаунт.',
            'device' => 'Устройство',
            'place' => 'Место',
            'date_hour' => 'Дата и время',
            'unknown' => 'Неизвестно',
            'logout' => 'Уведомление о входе — новая функция Beddy, которая отправляется при первом входе, даже на устройствах, которые использовались ранее. Проверьте подключенные устройства через меню <a href=":logoutAllDevice" target="_blank">Профиль > Защита и доступ</a>. Если устройства совпадают, вы можете проигнорировать это письмо.',
        ],
        'channel_update_exclusion' => [
            'subject' => 'Портал изменил ограничения на обновления для объекта',
            'summary' => 'Задействованный портал',
            'oldvalue' => 'Старое значение',
            'newvalue' => 'Новое значение',
            'modified_value' => 'Изменённое значение',
            'deleted_value' => 'Удалённое значение',
            'more_info' => 'Это письмо было отправлено после выполнения cron-задачи по загрузке новых комнат',
            'they_have_been' => 'были',
            'the_following_restrictions' => ' следующие ограничения:',
            'edited' => 'изменены',
            'new' => 'добавлены',
            'removed' => 'удалены',
            'price' => 'Цена',
            'availability' => 'Доступность',
            'room_barred' => 'Закрытие',
            'min_stay' => 'Минимальное пребывание',
            'max_stay' => 'Максимальное пребывание',
            'close_to_arrival' => 'Закрытие при заезде',
            'close_to_departure' => 'Закрытие при выезде',
            'date_from' => 'Дата начала',
            'date_to' => 'Дата окончания',
            'type_change' => 'Тип изменения',
            '1' => 'включено',
            '0' => 'отключено',
            'field_involved' => 'Задействованное поле',
            'rate' => 'Для тарифа ',
            'property' => 'объект',
            'subject_short' => 'Изменение ограничений для: '
        ],
        'credit_card_view_blocked' => [
            'subject' => 'Beddy – Превышен лимит просмотров кредитной карты.',
            'body' => 'Уважаемый клиент,<br>информируем вас, что карта, связанная с бронированием <b>#:reference_number</b> или одним из соответствующих платежей, достигла максимального допустимого количества просмотров. В связи с этим доступ к данной карте был <b>временно заблокирован</b>.
    <br><br>Если вы хотите увеличить лимит просмотров или получить дополнительную информацию, пожалуйста, свяжитесь с нашей службой поддержки по адресу <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
    Команда Beddy<br><br>',
        ],
        'credit_card_view_notify' => [
            'subject' => 'Beddy - Уведомление о доступе к данным кредитной карты - Бронирование №:reservation_reference',
            'body' => 'Уважаемый клиент,<br>Данные кредитной карты, связанные с бронированием №<b>:reservation_reference</b> из канала <b>:channel_name</b>, были просмотрены.
    <br><br>
    Детали события:
    <ul>
      <li>Оператор: <b>:user_first_name :user_last_name</b> (<b>:user_email</b>)</li>
      <li>Дата и время: <b>:event_date</b> <b>:event_hour</b></li>
      <li>IP: <b>:ip_address</b></li>
    </ul>
    Это уведомление создано в качестве меры безопасности и отслеживания доступа к конфиденциальным данным.<br><br>
    Команда Beddy<br><br>',
        ],
        'user_created_notify' => [
            'subject' => 'Beddy - Создан новый пользователь для объекта :property_name',
            'bodySection1' => 'Уважаемый клиент,<br>был создан новый пользователь <b>:user_first_name :user_last_name (:user_email)</b> для объекта <b>:property_name</b>.
        <br><br>
        Детали события:
        <ul>
          <li>Оператор: <b>:author_first_name :author_last_name</b> (<b>:author_email</b>)</li>
          <li>Дата и время: <b>:event_date</b> <b>:event_hour</b></li>
          <li>IP: <b>:ip_address</b></li>
        </ul>
        Если вы не признаёте эту операцию, вы можете деактивировать нового пользователя.',
            'buttonText' => 'Деактивировать пользователя',
            'bodySection2' => 'Это уведомление создано как мера безопасности и для отслеживания доступа к конфиденциальным данным.<br><br>
        Команда Beddy<br><br>'
        ],

    ],

    'export' => [
        'providers' => [
            'customers' => 'Клиенты',
            'companies' => 'Компании',
            'reservations' => 'Бронирования',
            'social_archive' => 'Клиенты с разблокированным предложением',
            'reservation_quotes' => 'Предложения',
            'cash_desk' => 'Касса',
            'fees' => 'Платежи',
            'cash_desk_closure' => 'Закрытие кассы',
            'production_stats' => 'Статистика производства',
            'sales_stats' => 'Статистика продаж',
            'invoices' => 'Налоговые документы',
            'invoices_received' => 'Полученные налоговые документы',
            'payments_timetable' => 'Расписание платежей',
            'properties' => 'Структуры',
            'deposits' => 'Авансы и залоги'
        ],
        'translations' => [
            'export_format' => 'Формат экспорта',
        ],
        'errors' => [
            'service_not_active' => 'Запрашиваемая услуга экспорта не активна для выбранных объектов',
            'method_not_found' => 'Метод :methodName не реализован в классе :className',
            'export_provider_not_found' => 'Поставщик экспорта не найден',
        ],
        'warnings' => [
            'service_not_active' => 'Запрашиваемая услуга экспорта не активна для объекта :propertyName',
            'export_inserted' => 'Экспорт успешно вставлен. После завершения процесса вы получите уведомление.',
        ],
    ],

    'external_services' => [
        'urmet_sclak' => [
            'one_time' => 'Срок действия ключа',
            'confirm_required' => 'Администратор должен авторизовать каждый доступ с помощью приложения Sclak',
            'app_enabled' => 'Включить использование приложения (если НЕТ, будет разрешено использовать только цифровую клавиатуру)',
            'generate_keypad_pin' => 'Создать PIN-код для отправки для открытия с помощью цифровой клавиатуры (выберите ДА только если в объекте есть клавиатуры для доступа)',
            'push_notify_enabled' => 'Получайте push-уведомления на смартфоне каждый раз, когда ваш гость заходит',
            'security_level' => 'Гость должен быть подключен к интернету',
            'instant_key' => 'Опциональная регистрация гостя',
            'purchase_type' => 'Кто оплачивает ключ?',
            'send_sms' => 'Отправить ключ клиенту через автоматическое SMS от Sclak',
            'sms_text_main' => 'Здравствуйте, ниже инструкции для получения ключей доступа к объекту.
            - УСТАНОВИТЕ APP Sclak: http://app.sclak.com/download',
            'sms_text_app_code' => '
            - АКТИВИРУЙТЕ КЛЮЧ: https://key.sclak.com/a/:app_key_code',
            'sms_text_pin_code' => '
            - PIN-код для клавиатуры: :pin_code',
            'all_booking_duration' => 'На весь период проживания',
            'only_one' => 'Только один раз',
            'property' => 'Объект',
            'guest' => 'Гость',
            'door_app_code' => 'Код активации приложения',
            'door_link_code' => 'Ссылка активации приложения',
            'app_activation_code' => 'Код активации приложения :accommodation_name (:accommodation_label): :key_code',
            'app_activation_code_log' => ':key_code',
            'door_key_code' => 'Код двери',
            'checkin_hour' => 'Время заезда (ключ будет действителен только с выбранного времени заезда)',
            'checkout_hour' => 'Время выезда (ключ будет действителен до выбранного времени выезда)',
            'room_not_mapped' => 'Комната :accommodation_name - :tableau_number не ассоциирована с Sclak',
        ],
        'nuki' => [
            'property' => 'Объект',
            'guest' => 'Гость',
            'door_key_code' => 'Код двери',
            'checkin_hour' => 'Время заезда (ключ будет действителен только с выбранного времени заезда)',
            'checkout_hour' => 'Время выезда (ключ будет действителен до выбранного времени выезда)',
            'room_not_mapped' => 'Комната :accommodation_name - :tableau_number не ассоциирована с Nuki',
            'code' => 'PIN-код двери :accommodation_name (:accommodation_label): :key_code',
            'email_address_not_found' => 'Адрес электронной почты не найден, добавьте адрес в бронирование, чтобы отправить приглашение для доступа к Nuki',
            'generate_keypad_pin' => 'Создать PIN-код для отправки для открытия с помощью цифровой клавиатуры (выберите ДА только если в объекте есть клавиатуры для доступа)',
            'sent_with_app' => 'Отправлено через приложение Nuki',
            'authorization_not_found' => 'Вы пытаетесь изменить несуществующий код, создайте новый дверной код',
            'multi_port_management' => 'Разрешить создание одного и того же PIN-кода для открытия нескольких дверей (например, ворот и комнаты); позже можно будет указать, какие двери связать',
            'device_not_configured' => 'Устройство Nuki не найдено или не настроено для открытия по ссылке'
        ],
        'errors' => [
            'service_not_active' => 'Внешняя услуга не активна',
            'scheduler_not_supported' => 'Внешняя услуга :external_service_name не поддерживает автоматическое планирование',
        ],
        'warnings' => [
            'manual_code_detected' => 'Обнаружены вручную введенные коды комнат, их нельзя ассоциировать с удаленными устройствами, их нужно удалить вручную',
        ],
        'key_door_services' => [
            'key_door_related' => 'Этот код также откроет следующие устройства: :devices_name',
        ],
        'gt_revenue' => [
            'spreadsheet_type' => 'Критерий экспорта доходов',
            'spreadsheet_type_segments' => 'Сегменты',
            'spreadsheet_type_rooms' => 'Комнаты',
            'date_from' => 'Дата начала экспорта',
            'date_to' => 'Дата окончания экспорта',
            'period' => 'Период экспорта',
        ],
        'pa_friuli' => [
            'year_type' => 'Выберите год для экспорта',
            'year_type_previous' => 'Предыдущий год (:year)',
            'year_type_current' => 'Текущий год (:year)',
        ],
    ],

    'fees' => [
        'deferred' => 'НДС с отсроченным начислением',
        'payment_split' => 'Разделение платежей',
        'immediate' => 'НДС с немедленным начислением',
        'export_fields' => [
            'date' => 'Дата',
            'document_type' => 'Тип документа',
            'document_number' => 'Номер документа',
            'total_taxable' => 'Общая сумма, подлежащая налогообложению',
            'total_taxation' => 'Общий НДС',
            'total_documents' => 'Общая сумма документа',
            'customer_name' => 'Имя клиента',
            'customer_type' => 'Тип клиента',
            'documents' => 'Документы',
            'total_nets' => 'Общая сумма без НДС',
            'total_taxes' => 'Общий НДС',
            'documents_total' => 'Общий итог по документам',
            'customer_email' => 'Электронная почта',
            'customer_telephone' => 'Телефон',
        ],
        'net' => 'Без НДС',
        'tax' => 'НДС',
        'sheets_name' => [
            'rows' => 'Платежи',
            'summary' => 'Резюме',
        ],
    ],

    'fiscal_printer' => [
        'not_collected' => 'Не взыскано',
        'electronic' => 'Кредитная карта',
        'not_collected_follows_invoice' => 'Не взыскано, следует из счета',
    ],

    'gdpr' => [
        'privacy' => [
            'title' => '',
            'header' => '<p><strong>PRIVACY POLICY</strong></p>
            <p><strong>on the processing of personal data</strong></p>
            <p>Arts. 12 et seq of Regulation (EU) 2016/679 (GDPR)</p>
            <p>&nbsp;</p>
            <p><strong>FOREWORD </strong></p>
            <p>In compliance with the provisions of EU Regulation 2016/679 (hereinafter referred to as GDPR) we hereby provide information regarding the processing of personal data provided by the data subject, relating to the relationships with the Company. The information is provided pursuant to art. 13 GDPR.</p>
            <p>&nbsp;</p>
            <ol>
            <li><strong>IDENTITY AND CONTACT DETAILS</strong></li>
            </ol>
            <p>The Data Controller :property_name - :property_address (hereinafter the Company).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>
            <p>&nbsp;</p>
            <p>&nbsp;</p>',
            'default_body' => '<p>&nbsp;</p>
            <ol start="2">
            <li><strong>CONTACT DETAILS OF THE DATA PROTECTION OFFICER (DPO)</strong></li>
            </ol>
            <p>The Data Protection Officer is ________________, tel. ______________, e-mail: ______________.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="3">
            <li><strong>PURPOSE OF PROCESSING, LEGAL BASIS AND DATA STORAGE PERIOD</strong></li>
            </ol>
            <table width="680">
            <tbody>
            <tr>
            <td width="191">
            <p><strong><em>Purpose</em></strong></p>
            </td>
            <td width="135">
            <p><strong><em>Types of data that can be processed:</em></strong></p>
            </td>
            <td width="149">
            <p><strong><em>Legal basis</em></strong></p>
            </td>
            <td width="206">
            <p><strong><em>Storage period</em></strong></p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>a)&nbsp;&nbsp; </strong><strong><u>Service Delivery</u></strong></p>
            <p>Registration of the customer and then subsequently fulfilling legal obligations.</p>
            </td>
            <td width="135">
            <p>First Name, Last Name, Phone Number, Additional Requests, Address, ZIP Code, Province, Country, State and E-mail, Payment Information</p>
            </td>
            <td width="149">
            <p>Performance of a contract to which you are a party or pre-contractual measures taken at the request of the data subject;</p>
            <p>Fulfilment of legal obligations.</p>
            <p><em>&nbsp;</em></p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>The retention time is changeable as it is dictated by the difference between the time the reservation is made and the time the guest actually arrives at the facility.</p>
            <p>Encrypted payment information is retained up to 15days after the departure of the client\'s guest.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>b)&nbsp;&nbsp; </strong><strong><u>Request for quotation</u></strong></p>
            <p>Request for quotation with subsequent contact from the Data Controller</p>
            </td>
            <td width="135">
            <p>First name, last name, email and phone number</p>
            </td>
            <td width="149">
            <p>Pre-contractual measures taken at the request of the data subject</p>
            <p>&nbsp;</p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time it takes to process the request</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>c)&nbsp;&nbsp; </strong><strong><u>Newsletter</u></strong></p>
            <p>Sending newsletters, by automated means of contacting</p>
            </td>
            <td width="135">
            <p>Personal and contact data</p>
            </td>
            <td width="149">
            <p>Consent (required by contract or specific request);</p>
            <p>(optional and revocable at any time)</p>
            <p><em>Art. 6 co. 1 lett. a) GDPR.</em></p>
            </td>
            <td width="206">
            <p>Until consent for that purpose is withdrawn and/or five years have elapsed since the \'expression of consent.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>d)&nbsp; </strong>If necessary, to <strong>ascertain, exercise or defend the rights</strong> of the Joint Data Controllers in judicial proceedings</p>
            </td>
            <td width="135">
            <p>Personal data and contact details; data necessary for the execution of the contractual relationship.</p>
            </td>
            <td width="149">
            <p>Legitimate interest (judicial protection).</p>
            <p><em>Art. 6, paragraph 1 letter f) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time necessary to exercise rights in court.</p>
            </td>
            </tr>
            </tbody>
            </table>
            <p><strong>&nbsp;</strong></p>
            <ol start="4">
            <li><strong>OBLIGATORY NATURE OF PROVISION OF DATA</strong></li>
            </ol>
            <p>The data subject must provide necessary data for carrying out the contractual relationship to the Company, as well as the data necessary to fulfil the obligations provided for by laws, regulations, community standards, and by provisions of Authorities legitimated by law and by supervisory and control bodies (referred to in purposes a) and f) above).</p>
            <p>Data that are not essential for the performance of the contractual relationship are qualified and considered supplementary and their provision by the data subject, if requested, is optional and subject to consent. Consent provided may be withdrawn by the data subject at any time. Such withdrawal shall in no way affect the lawfulness of processing based on the consents given prior to withdrawal of consent.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong>PROCESSING METHODS</strong></li>
            </ol>
            <p>Personal data will be recorded, processed and stored in the Company&rsquo; archive, paper and electronic, in compliance with the appropriate technical and organizational measures referred to in Art. 32 of the GDPR. The processing of the data subject personal data may consist of any operation or set of operations described in Art. 4, paragraph 1, point 2 of the GDPR.</p>
            <p>Personal data will be processed using suitable tools and procedures that guarantee security and confidentiality. Such processing may be carried out directly and/or via delegated third parties, both manually using hard-copy support and electronically using IT equipment and other instruments. In order to manage properly the relationship and fulfilment of legal obligations, personal data may be entered in the internal documentation of the Company and, if necessary, in the documents and registers required by law.</p>
            <p>Your data may be processed by the employees of the departments of the Company assigned to the pursuit of the above-mentioned purposes. These employees have been expressly authorized to process the data and have received adequate operating instructions pursuant to and for the purposes of Art. 29 GDPR.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="6">
            <li><strong>CATEGORIES OF RECIPIENTS OF PERSONAL DATA</strong></li>
            </ol>
            <p>Personal data under purpose (a) are only disclosed to possible legal offices where required by law.</p>
            <p>Payment data is transmitted to payment service providers for completion of the transaction.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="7">
            <li><strong>DATA TRANSFER TO COUNTRIES OUTSIDE THE EU</strong></li>
            </ol>
            <p>The data provided by the data subject will only be processed countries within the European Union. If the personal data of the data subjects are processed in a country outside of the EU, the data subject&rsquo;s rights under EU legislation will be guaranteed and the data subject will be notified on a timely basis.</p>
            <p>&nbsp;</p>
            <ol start="8">
            <li><strong>RIGHTS OF THE DATA SUBJECT </strong></li>
            </ol>
            <p>Pursuant to Articles 15 et seq of the GDPR, the data subject may exercise the following rights:</p>
            <ol>
            <li>access: to obtain confirmation of whether or not the personal data of the data subject are being processed and the right to access them; requests that are manifestly unfounded, excessive or repetitive cannot be answered;</li>
            <li>rectification: to correct/obtain the correction of personal data if incorrect or outdated and to complete data if incomplete;</li>
            <li>erasure/to be forgotten in some cases, to obtain the erasure of the personal data provided; this is not an absolute right, as the Company may have legitimate or legal reasons to store them;</li>
            <li>limitation: the data will be stored, but cannot be processed further, in the cases foreseen by the regulation;</li>
            <li>portability: to move, copy or transfer data from the Company&rsquo; databases to third parties. This applies only to data provided by the data subject for the performance of a contract or for which express consent has been given and the processing is carried out by automated means;</li>
            <li>objection to direct marketing;</li>
            <li>withdraw of the consent at any time if processing is based on consent.</li>
            </ol>
            <p>Pursuant to Art. 2-<em>undicies</em> of Legislative Decree 196/2003, the exercise of data subjects rights may be delayed, restricted or excluded, following justification provided without delay, unless this might compromise the purpose of the restriction, for as long as and to the extent that this constitutes a necessary and proportionate measure, taking into account the fundamental rights and legitimate interests of the data subject, in order to safeguard the interests referred to in paragraph 1, letters a) (protected interests with regard to money laundering), e) (for the conduct of defensive investigations or the exercise of a right in court) and f) (for the confidentiality of the identity of the employee who reports offenses he becomes aware of on his duties). In such cases, data subjects&rsquo; rights may also be exercised through the Personal Data Protection Authority in the manner referred to in Article 160 of said Decree. In such case, the Personal Data Protection Authority will inform the data subject that it has carried out all the necessary checks or that it has carried out a review, as well as of the data subject right to take legal action.</p>
            <p>&nbsp;</p>
            <p>It should also be noted that - before processing the requests - the Company may ascertain the identity of the data subject, in order to evaluate the legitimacy of the same.</p>
            <p>&nbsp;</p>
            <p>To exercise these rights, the data subject may contact the Data Controller at the addresses indicated in section 1 of this document. The Company will respond within 30 days of receiving the data subject formal request.</p>
            <p>If the abovementioned rights concerning data subject personal data are infringed, the latest may complain to the competent authority.</p>
            <p>&nbsp;</p>
            <p><strong>&nbsp;</strong></p>
            <p><strong>THE DATA</strong></p>
            <p><strong>CONTROLLER</strong></p>',
        ],
        'cookie' => [
            'title' => '',
            'header' => '<p><strong>Cookie Policy of :property_name</strong></p>
            <ol>
            <li><strong>Data Controller</strong></li>
            </ol>
            <p>The Data Controller is :property_name - :property_address (hereinafter the Company or the Owner).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>',
            'default_body' => '<p>Since the use of third-party Trackers through this Website cannot be fully controlled by the Owner, any specific references to third-party Trackers are to be considered indicative. In order to obtain complete information, Users are kindly requested to consult the privacy policies of the respective third-party services listed in this document.</p>
            <p>Given the objective complexity surrounding tracking technologies, Users are encouraged to contact the Owner should they wish to receive any further information on the use of such technologies by this Website.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="2">
            <li><strong>Foreword </strong></li>
            </ol>
            <p>This document informs Users about the technologies that help this Website to achieve the purposes described below. Such technologies allow the Owner to access and store information (for example by using a Cookie) or use resources (for example by running a script) on a User&rsquo;s device as they interact with this Website.</p>
            <p>For simplicity, all such technologies are defined as "Trackers" within this document &ndash; unless there is a reason to differentiate.</p>
            <p>For example, while Cookies can be used on both web and mobile browsers, it would be inaccurate to talk about Cookies in the context of mobile apps as they are a browser-based Tracker. For this reason, within this document, the term Cookies is only used where it is specifically meant to indicate that particular type of Tracker.</p>
            <p>Some of the purposes for which Trackers are used may also require the User\'s consent. Whenever consent is given, it can be freely withdrawn at any time following the instructions provided in this document.</p>
            <p>This Website uses Trackers managed directly by the Owner (so-called &ldquo;first-party&rdquo; Trackers) and Trackers that enable services provided by a third-party (so-called &ldquo;third-party&rdquo; Trackers). Unless otherwise specified within this document, third-party providers may access the Trackers managed by them.</p>
            <p>The validity and expiration periods of Cookies and other similar Trackers may vary depending on the lifetime set by the Owner or the relevant provider. Some of them expire upon termination of the User&rsquo;s browsing session.</p>
            <p>In addition to what&rsquo;s specified in the descriptions within each of the categories below, Users may find more precise and updated information regarding lifetime specification as well as any other relevant information &ndash; such as the presence of other Trackers - in the linked privacy policies of the respective third-party providers or by contacting the Owner.</p>
            <p>&nbsp;</p>
            <ol start="3">
            <li><strong> Activities strictly necessary for the operation of this Website and delivery of the Service</strong></li>
            </ol>
            <p>This Website uses so-called &ldquo;technical&rdquo; Cookies and other similar Trackers to carry out activities that are strictly necessary for the operation or delivery of the Service.</p>
            <p><strong>3.1 Third-party Trackers</strong></p>
            <p><strong>3.1.1 Tag Management</strong></p>
            <p>This type of service helps the Owner to manage the tags or scripts needed on this Website in a centralized fashion.</p>
            <p>This results in the Users\' Data flowing through these services, potentially resulting in the retention of this Data.</p>
            <p><strong>3.1.1.1 Google Tag Manager (Google Ireland Limited)</strong></p>
            <p>Google Tag Manager is a tag management service provided by Google Ireland Limited.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Irlanda &ndash; <a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p><strong>3.1.2 Handling payments</strong></p>
            <p>Se non diversamente specificato, questo Sito Web elabora i pagamenti con carta di credito tramite fornitori esterni di servizi di pagamento. In generale, e salvo diversa indicazione, gli Utenti sono pregati di fornire i dettagli di pagamento e le informazioni personali direttamente a tali fornitori di servizi di pagamento.</p>
            <p>Questo Sito Web non &egrave; coinvolto nella raccolta e nell\'elaborazione di tali informazioni: ricever&agrave; invece solo una notifica da parte del fornitore di servizi di pagamento in questione circa l\'avvenuto pagamento.</p>
            <p>Unless otherwise specified, this Website processes payments by credit card via external payment service providers. In general and unless where otherwise stated, Users are requested to provide their payment details and personal information directly to such payment service providers.</p>
            <p>This Website isn\'t involved in the collection and processing of such information: instead, it will only receive a notification by the relevant payment service provider as to whether payment has been successfully completed.</p>
            <p><strong>3.1.2.1 Stripe (Stripe Technology Europe Ltd)</strong></p>
            <p>Stripe is a payment service provided by Stripe Technology Europe, Limited.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://stripe.com/ie/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__stripe_mid: 1 year</li>
            <li>__stripe_sid: 30 minutes</li>
            <li>m: 2 years</li>
            </ul>
            <p><strong>3.1.2.2 PayPal (Paypal)</strong></p>
            <p>PayPal is a payment service provided by PayPal Inc., which allows Users to make online payments.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: See the PayPal privacy policy &ndash;&nbsp;<a href="https://www.paypal.com/webapps/mpp/ua/privacy-full">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__paypal_storage__: indefinite</li>
            <li>akavpau_ppsd: duration of the session</li>
            <li>enforce_policy: duration of the session</li>
            <li>l7_az: duration of the session</li>
            <li>nsid: duration of the session</li>
            <li>ts: duration of the session</li>
            <li>tsrce: duration of the session</li>
            <li>x-cdn: duration of the session</li>
            <li>x-pp-s: duration of the session</li>
            </ul>
            <p>&nbsp;</p>
            <ol start="4">
            <li><strong> Other activities involving the use of Trackers</strong></li>
            </ol>
            <p><strong>4.1 Measurement</strong></p>
            <p>This Website uses Trackers to measure traffic and analyze User behavior with the goal of improving the Service.</p>
            <p><strong>4.1.1 Analytics</strong></p>
            <p>The services contained in this section enable the Owner to monitor and analyze web traffic and can be used to keep track of User behavior.</p>
            <p><strong>4.1.1.1 Google Analytics 4 (Google Ireland Limited)</strong></p>
            <p>Google Analytics 4 is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.<br /> In Google Analytics 4, IP addresses are used at collection time and then discarded before Data is logged in any data center or server. Users can learn more by consulting&nbsp;<a href="https://support.google.com/analytics/answer/12017362?hl=en&amp;ref_topic=2919631">Google&rsquo;s official documentation</a>.</p>
            <p>Personal Data processed: browser information, city, device information, latitude (of city), longitude (of city), number of Users, session statistics, Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_ga: 2 years</li>
            <li>_ga_*: 2 years</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.2 Google Analytics (Google Ireland Limited)</strong></p>
            <p>Google Analytics is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>AMP_TOKEN: 1 hour</li>
            <li>_ga: 2 years</li>
            <li>_gac*: 3 months</li>
            <li>_gat: 1 minute</li>
            <li>_gid: 1 day</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Facebook Ads conversion tracking (Facebook pixel) (Meta Platforms Ireland Limited)</strong></p>
            <p>Facebook Ads conversion tracking (Meta pixel) is an analytics service provided by Meta Platforms Ireland Limited that connects data from the Meta Audience Network with actions performed on this Website. The Meta pixel tracks conversions that can be attributed to ads on Facebook, Instagram and Meta Audience Network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://www.facebook.com/about/privacy/">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_fbp: 3 months</li>
            <li>fr: 3 months</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Google Ads conversion tracking (Google Ireland Limited)</strong></p>
            <p>Google Ads conversion tracking is an analytics service provided by Google Ireland Limited that connects data from the Google Ads advertising network with actions performed on this Website.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>IDE: 2 years</li>
            <li>test_cookie: 15 minutes</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.2 Marketing</strong></p>
            <p><strong>4.1.2.1. Userguest</strong></p>
            <p>This service allows the user to be shown personalized ads on this website, based on previous visits to this website.</p>
            <p>It does not collect personal data.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong> How to manage preferences and provide or withdraw consent</strong></li>
            </ol>
            <p>There are various ways to manage Tracker related preferences and to provide and withdraw consent, where relevant:</p>
            <p>Users can manage preferences related to Trackers from directly within their own device settings, for example, by preventing the use or storage of Trackers.</p>
            <p>Additionally, whenever the use of Trackers is based on consent, Users can provide or withdraw such consent by setting their preferences within the cookie notice or by updating such preferences accordingly via the relevant consent-preferences widget, if available.</p>
            <p>It is also possible, via relevant browser or device features, to delete previously stored Trackers, including those used to remember the User&rsquo;s initial consent.</p>
            <p>Other Trackers in the browser&rsquo;s local memory may be cleared by deleting the browsing history.</p>
            <p>With regard to any third-party Trackers, Users can manage their preferences and withdraw their consent via the related opt-out link (where provided), by using the means indicated in the third party\'s privacy policy, or by contacting the third party.</p>
            <p><strong>5.1 Locating Tracker Settings</strong></p>
            <p>Users can, for example, find information about how to manage Cookies in the most commonly used browsers at the following addresses:</p>
            <ul>
            <li><a href="https://support.google.com/chrome/answer/95647?hl=en&amp;p=cpn_cookies">Google Chrome</a></li>
            <li><a href="https://support.mozilla.org/en-US/kb/enable-and-disable-cookies-website-preferences">Mozilla Firefox</a></li>
            <li><a href="https://support.apple.com/guide/safari/manage-cookies-and-website-data-sfri11471/">Apple Safari</a></li>
            <li><a href="http://windows.microsoft.com/en-us/windows-vista/block-or-allow-cookies">Microsoft Internet Explorer</a></li>
            <li><a href="https://support.microsoft.com/en-us/help/4027947">Microsoft Edge</a></li>
            <li><a href="https://support.brave.com/hc/en-us/articles/360022806212-How-do-I-use-Shields-while-browsing">Brave</a></li>
            <li><a href="https://help.opera.com/en/latest/web-preferences/#cookies">Opera</a></li>
            </ul>
            <p>Users may also manage certain categories of Trackers used on mobile apps by opting out through relevant device settings such as the device advertising settings for mobile devices, or tracking settings in general (Users may open the device settings and look for the relevant setting).</p>
            <p><strong>5.2 </strong><strong>Consequences of denying consent</strong></p>
            <p>Users are free to decide whether or not to grant consent. However, please note that Trackers help this Website to provide a better experience and advanced functionalities to Users (in line with the purposes outlined in this document). Therefore, in the absence of the User\'s consent, the Owner may be unable to provide related features.</p>
            <ol start="6">
            <li><strong> Definitions and legal references</strong></li>
            </ol>
            <p><strong>Personal Data (or Data)</strong></p>
            <p>Any information that directly, indirectly, or in connection with other information &mdash; including a personal identification number &mdash; allows for the identification or identifiability of a natural person.</p>
            <p><strong>Usage Data</strong></p>
            <p>Information collected automatically through this Website (or third-party services employed in this Website), which can include: the IP addresses or domain names of the computers utilized by the Users who use this Website, the URI addresses (Uniform Resource Identifier), the time of the request, the method utilized to submit the request to the server, the size of the file received in response, the numerical code indicating the status of the server\'s answer (successful outcome, error, etc.), the country of origin, the features of the browser and the operating system utilized by the User, the various time details per visit (e.g., the time spent on each page within the Application) and the details about the path followed within the Application with special reference to the sequence of pages visited, and other parameters about the device operating system and/or the User\'s IT environment.</p>
            <p><strong>User</strong></p>
            <p>The individual using this Website who, unless otherwise specified, coincides with the Data Subject.</p>
            <p><strong>Data Subject</strong></p>
            <p>The natural person to whom the Personal Data refers.</p>
            <p><strong>Data Processor (or Data Supervisor)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which processes Personal Data on behalf of the Controller, as described in this privacy policy.</p>
            <p><strong>Data Controller (or Owner)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which, alone or jointly with others, determines the purposes and means of the processing of Personal Data, including the security measures concerning the operation and use of this Website. The Data Controller, unless otherwise specified, is the Owner of this Website.</p>
            <p><strong>This Website (or this Application)</strong></p>
            <p>The means by which the Personal Data of the User is collected and processed.</p>
            <p><strong>Service</strong></p>
            <p>The service provided by this Website as described in the relative terms (if available) and on this site/application.</p>
            <p><strong>European Union (or EU)</strong></p>
            <p>Unless otherwise specified, all references made within this document to the European Union include all current member states to the European Union and the European Economic Area.</p>
            <p><strong>Cookie</strong></p>
            <p>Cookies are Trackers consisting of small sets of data stored in the User\'s browser.</p>
            <p><strong>Tracker</strong></p>
            <p>Tracker indicates any technology - e.g Cookies, unique identifiers, web beacons, embedded scripts, e-tags and fingerprinting - that enables the tracking of Users, for example by accessing or storing information on the User&rsquo;s device.</p>
            <p><strong>Legal information</strong></p>
            <p>This privacy statement has been prepared based on provisions of multiple legislations, including Art. 13/14 of Regulation (EU) 2016/679 (General Data Protection Regulation).</p>
            <p>This policy relates solely to this Website, if not stated otherwise within this document.</p>
            <p>&nbsp;</p>',
        ],
    ],

    'general' => [
        'accommodation_not_found' => 'Комната не найдена',
        'channel_unsupported_function' => 'Этот канал не поддерживает данную функцию',
        'rateplan_not_found' => 'Тарифный план не найден',
        'accommodations' => 'Комнаты',
        'unknown' => 'Неизвестно',
        'unauthorized' => 'Не авторизовано',
        'expired_password' => 'Ваш пароль истек. Пожалуйста, обновите его, чтобы продолжить.',
        'not_found' => 'Не найдено',
        'not_found_or_not_authorized' => 'Ресурс не найден или доступ запрещен',
        'no_relationship_found' => 'Нет связи',
        'existing_periods' => 'Есть пересекающиеся значения',
        'existing_condition' => 'Условие уже существует',
        'missing_accommodation_rateplan' => 'Отсутствует тарифный план для комнаты',
        'missing_accommodation_channel_source' => 'Отсутствует исходный канал для комнаты',
        'missing_accommodation_channel_destination' => 'Отсутствует целевой канал для комнаты',
        'missing_accommodation_channel' => 'Отсутствует канал для комнаты',
        'missing_treatment_or_rateplan' => 'Отсутствуют лечение или тарифный план для этой комнаты',
        'same_source_destination' => 'Источник и назначение совпадают',
        'impossible_delete_addon_category' => 'Невозможно удалить категорию дополнительных услуг, если она все еще связана',
        'impossible_delete_system_addon_category' => 'Невозможно изменить или удалить системную категорию дополнительных услуг',
        'property_xml_already_connected' => 'PropertyXml уже подключен к другому объекту',
        'city_tax' => 'Городской налог',
        'taxs' => 'Налоги',
        'virtual_stamp' => 'Виртуальная марка',
        'default_group' => 'По умолчанию',
        'existing_mail' => 'Существующий адрес электронной почты',
        'unique_mail' => 'Уникальный адрес электронной почты',
        'existing_username' => 'Существующее имя пользователя',
        'unique_username' => 'Уникальное имя пользователя',
        'resource_conflict' => 'Конфликт с выбранным ресурсом',
        'special_requests' => 'Особые запросы',
        'name' => 'Имя',
        'surname' => 'Фамилия',
        'and' => 'и',
        'arrival' => 'Прибытие',
        'clean_fees' => 'Стоимость уборки',
        'departure' => 'Отъезд',
        'adults' => 'Взрослые',
        'adult' => 'Взрослый',
        'children' => 'Дети',
        'child' => 'Ребёнок',
        'eta' => 'Возраст',
        'male' => 'Мужской',
        'female' => 'Женский',
        'customer' => 'Клиент',
        'company' => 'Компания',
        'telephone' => 'Телефон',
        'email' => 'Электронная почта',
        'nationality' => 'Национальность',
        'too_many_login_attemps' => 'Слишком много неверных попыток. Попробуйте снова через :minute_unthrottle минут',
        'country' => 'Страна',
        'coupon' => 'Купон',
        'from' => 'С',
        'to' => 'По',
        'nights' => 'Ночи',
        'payment_status' => 'Статус оплаты',
        'total' => 'Итого',
        'reservation' => 'Бронирование',
        'quote' => 'Предложение',
        'di' => 'от',
        'stay' => 'Проживание',
        'extra' => 'Дополнительно',
        'tax' => 'Налог',
        'payment' => 'Платежи',
        'del' => 'от',
        'channel' => 'Канал',
        'lodging' => 'Размещение',
        'treatment' => 'Лечение',
        'accommodations_reserved' => 'Забронированные комнаты',
        'option_status_export' => 'Статус экспорта',
        'option_revenue' => 'Доход',
        'option_time' => 'Время экспорта',
        'guest_card_service_not_connected' => 'Сервис не подключен к объекту или неправильный тип',
        'guest_card_guests_number_error' => 'Недостаточное количество гостей',
        'guest_card_date_from_error' => 'Изменения не разрешены. Дата начала действия раньше сегодняшнего дня.',
        'imp' => 'Без НДС',
        'iva' => 'НДС',
        'type' => 'Тип',
        'documents' => 'Документы',
        'generic_payment' => 'Общий платеж',
        'accommodation' => 'Комната',
        'accommodation_name' => 'Размещение',
        'accommodation_total' => 'Итого за размещение',
        'error' => 'Ошибка',
        'status' => 'Статус',
        'language' => 'Язык',
        'guests' => 'Гости',
        'guest' => 'Гость',
        'paid' => 'Оплачено',
        'to_pay' => 'К оплате',
        'suspended' => 'Приостановлено',
        'to_be_invoiced' => 'Подлежит выставлению счета',
        'note' => 'Заметка',
        'note_internal' => 'Внутренние заметки по бронированию',
        'note_internal_accommodation' => 'Внутренние заметки по размещению',
        'note_customer' => 'Запросы клиента',
        'note_checkin' => 'Заметки для регистрации',
        'note_checkout' => 'Заметки для выезда',
        'note_housekeeper' => 'Заметки для горничной',
        'note_catering' => 'Заметки по питанию',
        'note_bill' => 'Заметки по счету',
        'bill_charged' => 'Счет выставлен',
        'total_documents' => 'Итого документов',
        'checkin_online' => 'Онлайн регистрация',
        'cancellation' => 'Отмена',
        'no_show' => 'Не явился',
        'referral_id' => '#:referral_id:',
        'missing_param' => 'Отсутствует параметр :param',
        'properties' => 'Объекты',
        'amount' => 'Сумма',
        'reservation_total' => 'Итого по бронированию',
        'total_paid' => 'Итого оплачено',
        'total_to_pay' => 'Итого к оплате',
        'general_error' => 'Общая ошибка',
        'module_not_active' => 'Модуль :moduleName не активен для следующих объектов: ',
        'reservation_summary' => 'Резюме бронирования',
        'department_not_faund' => 'Отдел не найден',
        'department_exist' => 'Невозможно удалить отдел, уже связанный с фискальным принтером',
        'upload_virus_found' => 'Загруженный файл поврежден или содержит вирус',
        'upload_antivirus_service' => 'Не удалось загрузить файл, повторите попытку позже или свяжитесь с сервисной поддержкой',
        'document' => '{1} Документ|[2,*] Документы',
        'reservation_to_queue_from_cart' => 'Мы обрабатываем ваше бронирование, уведомление будет отправлено по завершении',
        'active' => 'Активно',
        'expired' => 'Истекло',
        'export' => 'Экспорт',
        'send_data' => 'Отправить данные',
        'missing_credentials' => 'Отсутствуют имя пользователя или пароль',
        'yes' => 'Да',
        'no' => 'Нет',
        'door_key_codes' => 'Коды открытия',
        'external_door_link' => 'Ссылка для открытия внешней двери',
        'accommodation_door_key_codes' => 'Код доступа к жилью :accommodationTableauLabel',
        'city_tax_report' => [
            'errors' => [
                'filter_not_available' => 'Фильтр недоступен',
                'filter_format' => 'Неверный формат фильтра',
                'filter_number_arguments_exceeded' => 'Превышено количество аргументов фильтра',
            ],
        ],
        'fields' => [
            'field_update' => 'Поле :field изменено с :oldValue на :newValue',
            'guest_type_id' => 'Тип гостя',
            'city_tax_exemption_id' => 'Освобождение от налога на проживание',
            'main_guest' => 'Основной гость',
            'arrival_date' => 'Дата прибытия',
            'departure_date' => 'Дата отъезда',
            'roomreservation_id' => 'Комната',
            'checkin' => 'Регистрация',
            'checkout' => 'Выезд',
            'enabled' => 'Включено',
            'disabled' => 'Отключено',
            'undefined' => 'Не определено',
            'deleting' => 'Удалено: ',
            'update_guest' => 'Для гостя :name :surname (:id) изменены: :fields',
            'delete_guest' => 'Гость :name :surname (:id) :invoiced_city_tax',
            'invoiced_city_tax' => 'с налогом на проживание',
            'arrival_lunch' => 'Прибытие на обед',
            'arrival_dinner' => 'Прибытие на ужин',
            'arrival_not_set' => 'Без предпочтений',
        ],
        'exceptions' => [
            'impossible_to_get_conversation_references' => 'Невозможно получить информацию о беседе',
            'ota_channel_message_not_supported' => 'Указанный канал не поддерживает функцию отправки сообщений',
            'recipient_has_not_configured_email_address' => 'Получатель не настроил адрес электронной почты',
            'impossible_to_resend_not_failed_message' => 'Невозможно повторно отправить сообщение, которое не завершилось ошибкой',
            'impossible_to_delete_this_message' => 'Невозможно удалить это сообщение',
            'message_not_valid' => 'Следующие поля недействительны: ',
            'newsletter_config_not_valid' => 'Следующие поля конфигурации недействительны: ',
            'newsletter_not_valid' => 'Следующие поля рассылки недействительны: ',
            'newsletter_default_mail_not_valid' => 'Следующие поля стандартного письма недействительны: ',
            'newsletter_default_mail_not_valid' => 'Следующие поля стандартного письма недействительны: ',
            'newsletter_condition_not_valid' => 'Следующие поля для условия списка отправки недействительны: ',
            'message_alredy_exists' => 'Сообщение уже существует',
            'some_uploaded_files_are_unsupported' => 'Некоторые загруженные файлы не поддерживаются',
            'attachments_not_permitted_for_channel' => 'Для этого канала связи не разрешено отправлять вложения',
            'uploaded_too_many_images' => 'Можно отправить только одно изображение в сообщении',
            'you_cannot_send_message_that_contains_email_addresses' => 'Нельзя отправить сообщение, содержащее адреса электронной почты',
            'you_cannot_send_message_that_contains_url' => 'Нельзя отправить сообщение, содержащее URL',
            'you_cannot_send_message_that_contains_phone_number' => 'Нельзя отправить сообщение, содержащее номер телефона',
            'you_cannot_receive_message_without_reservation_type' => 'Нельзя получать сообщения без типа бронирования',
            'impossible_to_set_message_read_status' => 'Невозможно изменить статус прочтения сообщения',
            'gt_revenue_not_valid' => 'Следующие параметры для экспорта GT Revenue недействительны: ',
            'export_not_valid' => 'Следующие параметры для генерации экспорта недействительны: ',
            'method_not_implemented' => 'Метод :methodName в драйвере :driverName не реализован',
            'temporary_disabled_action_move_guest' => 'Следующее действие временно отключено: удалите гостя и создайте его в назначенной комнате',
            'batch_job_not_found' => 'Задание не найдено',
            'impossible_invoke_method' => 'Невозможно вызвать этот метод',
        ],
        'conversation_messages' => [
            'participant_alredy_exists' => 'Участник уже добавлен в беседу',
            'placeholder_photo' => 'Фото',
        ],
    ],

    'guest_presence' => [
        'summary' => 'Сводка о присутствии гостей',
        'daily_summary_of_date' => 'Ежедневная сводка за :date',
        'accommodation' => 'Жильё',
        'accommodation_type' => 'Тип жилья',
        'name_and_surname' => 'Имя и фамилия',
        'age' => 'Возраст',
        'sex' => 'Пол',
        'stay' => 'Пребывание',
        'stay_status' => 'Статус',
        'plan' => 'Этаж',
        'property' => 'Объект',
        'no_records' => 'Нет данных для отображения',
        'date' => 'Дата',
        'export_title' => 'Присутствие гостей',
    ],

    'guest_reporting' => [
        'errors' => [
            'unable_to_delete_movements' => 'Не удалось удалить перемещения из-за следующей ошибки: :error',
            'unable_to_send_movements' => 'Не удалось отправить перемещения из-за следующей ошибки: :error',
            'unable_to_check_movements_type' => 'Не удалось проверить тип перемещений из-за следующей ошибки: :error',
            'movements_type_not_valid' => 'Тип перемещений объекта размещения недействителен для данного портала',
            'cannot_delete_movements' => 'Невозможно удалить движения, так как дата отправки не совпадает с последней датой отправки, зарегистрированной порталом',
            // toggler
            'generic_already_reported' => 'Элемент уже экспортирован',
            'reservation_already_reported' => 'Бронирование :identifier уже экспортировано',
            'reservation_accommodation_already_reported' => 'Комната :identifier уже экспортирована',
            'reservation_accommodation_guest_already_reported' => 'Гость :identifier уже экспортирован',
            'reservation_accommodation_guest_not_sent' => 'Гость не отправлен',
            'reservation_accommodation_guest_can_not_delete' => 'Невозможно удалить гостя, так как он уже находится в месячном закрытии',
            'reservation_accommodation_guest_missing' => 'Гость не найден',
            // ошибки с отчетами по гостю
            'place_code_missing' => 'Отсутствует код места. Обратитесь в техническую поддержку.',
            'cannot_be_single_guest' => 'Неверный тип гостя: не может быть одиночным гостем.',
            'customer_has_incomplete_birth_place' => 'Место рождения отсутствует или неполное.',
            'customer_has_incomplete_document_data' => 'Данные документа отсутствуют или неполные.',
            'customer_has_incomplete_residence' => 'Отсутствует код места рождения или проживания, обратитесь в службу поддержки.',
            'customer_has_invalid_gender' => 'Пол не указан.',
            'customer_has_invalid_type' => 'Неверный тип гостя.',
            'customer_has_no_birth_date' => 'Отсутствует дата рождения.',
            'customer_birth_date_in_future' => 'Дата рождения не может быть позже сегодняшнего дня.',
            'customer_has_no_birth_city_country_place' => 'Отсутствуют коды места и страны рождения, обратитесь в службу поддержки.',
            'customer_has_no_birth_place' => 'Место рождения отсутствует или неполное.',
            'customer_has_no_name' => 'Отсутствует имя.',
            'customer_has_no_nationality_or_has_null_code' => 'Отсутствует гражданство.',
            'customer_has_no_residence_city_country_place' => 'Отсутствуют коды места и страны проживания, обратитесь в службу поддержки.',
            'customer_has_no_residence_place' => 'Отсутствует код страны проживания, обратитесь в службу поддержки.',
            'customer_has_no_surname' => 'Отсутствует фамилия.',
            'customer_has_no_data' => 'Заполните все обязательные данные.',
            'customer_has_not_present' => 'Не зарегистрировано гостей в бронировании.',
            'some_customer_has_not_present' => 'Не были введены данные для :customer_number гостя|Не были введены данные для :customer_number гостей',
            'guest_has_no_customer_data' => 'Заполните все обязательные данные.',
            'invalid_length_of_stay' => 'Неверная продолжительность пребывания',
            'invalid_row_size' => 'Неверная длина строки для размещения. Обратитесь в техническую поддержку',
            'invalid_value_size' => 'Неверная длина поля',
            'invalid_surname_size' => 'Неверная длина фамилии. Максимум 50 символов',
            'invalid_name_size' => 'Неверная длина имени. Максимум 30 символов',
            'invalid_document_number_size' => 'Неверная длина номера документа. Максимум 20 символов',
            'invalid_released_size' => 'Неверная длина места выдачи документа. Максимум 9 символов',
            'must_be_single_guest' => 'Неверный тип гостя: должен быть одиночный гость.',
            // ошибки для группировки
            'customer_has_no_leader' => 'Отсутствует глава семьи или группы.',
            'family_leader_alone' => 'Присутствует глава семьи без членов семьи.',
            'family_member_alone' => 'Необходимо добавить главу семьи.',
            'group_leader_alone' => 'Присутствует глава группы без участников.',
            'group_member_alone' => 'Необходимо добавить главу группы.',
            'multiple_family_leaders' => 'В семье может быть только один глава.',
            'multiple_group_leaders' => 'В группе может быть только один лидер.',
            'invalid_group_leader_in_family' => 'Неверный лидер группы (присутствует глава семьи).',
            'invalid_group_member_in_family' => 'Неверный член группы (должен быть членом семьи)',
            'invalid_family_leader_in_group' => 'Неверный глава семьи (присутствует глава группы)',
            'invalid_family_member_in_group' => 'Неверный член семьи (должен быть участником группы)',
            'room_has_no_family_leader' => 'Необходимо добавить главу семьи.',
            'room_has_many_leaders' => 'В комнате может быть только один глава семьи.',
            'room_has_no_family_members' => 'Присутствует глава семьи без членов семьи.',
            // другие ошибки
            'no_exportable_guests' => 'Нет гостей для экспорта.',
            'no_istat_module_configured' => 'Модуль Istat не настроен.',
            'rooms_number_overflow' => 'Число занятых комнат больше, чем максимальное количество, установленное в портале. Проверьте правильность информации в разделе Конфигурация > Istat.',
            'unmapped_tableau_number' => 'Комната без маппинга. Проверьте настройку группы для размещения.',
            'no_tableau_number' => 'Нет номера комнаты на дату: :date',
            'unexpected_date' => 'Ожидаемая дата экспорта: :date. Измените дату экспорта.',
            'unexpected_send_date' => 'Ожидаемая дата отправки: :date. Измените дату отправки.',
            'empty_italian_birth_city_code' => 'Не найден код города рождения. Обратитесь в техническую поддержку.',
            'empty_italian_birth_county_abbreviation' => 'Не найден код провинции рождения. Обратитесь в техническую поддержку.',
            'empty_italian_residence_city_code' => 'Не найден код города проживания. Обратитесь в техническую поддержку.',
            'empty_italian_residence_county_abbreviation' => 'Не найден код провинции проживания. Обратитесь в техническую поддержку.',
            // ошибки для Сицилии
            'guest_validation_failed' => 'Туристическое наблюдение Сицилии не может проверить гостя :name.',
            // ошибка при удалении
            'sync_failed' => '\nПопытка отправить присутствие или изменения для бронирования, удаленного вручную с портала Туристического наблюдения Сицилии. Отключите отправку отмененных бронирований или попробуйте отправить снова.',
            // ошибки для Turismo 5
            'uncaught_forbidden' => 'Неверные учетные данные или код структуры. Проверьте правильность данных.',
            'wrong_username_password_wskey' => 'Неверное имя пользователя, пароль или WsKey',
            'generic_error' => 'Портал не ответил корректно. Повторите попытку позже.',
            'generic_error_send' => 'Портал не ответил корректно. Повторите попытку позже.',
            'missing_istat_code' => 'Не найден код Istat для места: :placeName. Пожалуйста, свяжитесь с технической поддержкой.',
            'alloggiatiweb_error_owner_apartment' => 'Для этого аккаунта необходимо использовать коды квартир. Включите настройку для размещения в разделе Конфигурация > Alloggiati Web.',
            'alloggiatiweb_error_owner_hotel' => 'Невозможно использовать коды квартир для этого аккаунта. Отключите настройку для размещения в разделе Конфигурация > Alloggiati Web',
            'sicilia_web_service_outcome_empty_response' => 'Портал не ответил корректно. Повторите попытку позже.',
            'istat_the_portal_not_responding' => 'Портал не ответил корректно. Повторите попытку позже.',
            'istat_exemption_not_valid' => 'Освобождение не предусмотрено ABIT',
        ],
        'success' => [
            'upload_recordset_completed' => 'Загрузка данных завершена успешно.',
        ],
        'webservice' => [
            'service_unavailable' => 'Сервис недоступен или неправильно настроен.',
        ],
        'fields' => [
            'date_to_send' => 'Дата отправки',
            'date_to_export' => 'Дата для экспорта',
            'current_date' => 'Текущая дата',
            'last_sent_day' => 'Последняя отправленная дата',
            'use_progression' => 'Используемый прогресс',
            'is_auto' => 'Тип отправки',
            'is_auto_description' => 'Автоматическая/ручная отправка',
            'reference_date' => 'Дата ссылки для поиска',
            'operation_code_label' => 'Код операции',
            'operation_code_description' => 'Идентифицирует операцию отправки',
            'do_not_update_current_day_label' => 'Не обновлять текущий день',
            'do_not_update_current_day_description' => 'Когда Istat отправляется, дата текущего дня не обновляется',
            'hotel_code' => 'Код структуры',
            'property_list' => 'Список объектов',
            'get_property_code' => 'Получить код структуры',
            'username' => 'Имя пользователя',
            'password' => 'Пароль',
            'declared_available_rooms' => 'Число доступных комнат для продажи',
            'declared_available_beds' => 'Число доступных мест для продажи',
            'guest_id' => 'Id гостя',
            'guest_id_description' => 'Id гостя для удаления',
            'delete_movements_flag' => 'Подтверждение удаления движений',
            'delete_movements_flag_description' => 'Флаг, указывающий, следует ли выполнять удаление движений',
            'delete_movements_not_confirmed' => 'Вы уверены, что хотите удалить движения, начиная с этой даты? Эта операция необратима.',
            'ricestat' => [
                // custom Ricestat translations
                'username' => 'Имя пользователя Ricestat',
            ],
            'sicilia' => [
                // custom Sicilian tourist observatory translations
                'username' => 'UserID Туристического наблюдения',
                'hotel_code' => 'Код отеля, выданный при регистрации (если отличается от имени пользователя)',
            ],
            'sired' => [
                // custom Sired translations
                'declared_available_rooms' => 'Общее количество доступных единиц для продажи (количество, указанное на портале)',
                'declared_available_beds' => 'Количество доступных мест (количество, указанное на портале)',
            ],
            'turismo5' => [
                // custom Turismo 5 translations
                'hotel_code' => 'Код структуры или код региона',
                'declared_available_rooms' => 'Общее количество доступных единиц для продажи (количество, указанное на портале)',
                'declared_available_beds' => 'Количество доступных мест (количество, указанное на портале)',
                'endpoint' => 'Географическая область',
            ],
            'c59' => [
                // custom C59 translations
                'c59_progression' => 'Прогресс на дату ссылки',
                'c59_year' => 'Год прогресса',
            ],
            'trento' => [
                // custom Trento translations
                'declared_available_rooms' => 'Количество доступных комнат',
            ],
            'astat' => [
                // custom Astat translations
                'accommodationId' => 'HotelCode или accommodationId',
                'prepare_local_tax' => 'Подготовить налог на проживание',
                'close_month' => 'Закрыть месяц',
                'token' => 'Токен',
                'last_month_closed' => 'Последний закрытый месяц',
                'property_closed_date_range' => 'Период закрытия структуры',
            ],
            'sinfonia' => [
                'cusr' => 'Идентификатор объекта',
                'api_key' => 'API-ключ системы управления'
            ],
            'webtur' => [
                'cir' => 'Региональный идентификационный код объекта (CIR)',
                'cin' => 'Национальный идентификационный код объекта размещения (CIN)',
                'declared_available_rooms' => 'Количество доступных номеров',
            ],
            'option_scheduled_label' => 'Включить автоматическую отправку отчетов Istat?',
            'option_scheduled_description' => 'Система будет автоматически отправлять отчеты начиная с текущей даты',
            'option_scheduled_send_every_hour_label' => 'Укажите частоту отправки отчетов Istat',
            'show_city_tax' => 'Показать налог на проживание',
        ],
    ],

    'guest' => [
        'alloggiatiweb' => [
            'no_guests_txt' => 'Нет зарегистрированных гостей',
            'property_no_module_configured' => 'Структура не настроила модуль Alloggiatiweb',
            'wrong_size_file' => 'Неверный размер файла, обратитесь в поддержку',
            'wrong_arrival_date' => 'Неверная дата прибытия',
            'general_error' => 'Неверные учетные данные или недействительный сертификат',
            'error_txt_file' => 'Ошибка при создании файла регистраций гостей',
            'post_upload_error' => 'Неверный файл. Проверьте тип файла',
            'invalid_certificate' => 'Неверный сертификат',
            'certificate_and_password_required' => 'Необходимы сертификат и пароль',
        ],
        'logger' => [
            'city_tax_log' => ':name :surname, :age лет (:first_date - :last_date для :accommodation_name) Общая сумма налога на проживание: :total_city_tax',
            'naming' => 'Гость :name :surname: ',
            'checkin_date' => 'Дата заезда: :arrival_date => :checkin_date',
            'checkout_date' => 'Дата выезда: :departure_date => :checkout_date',
        ],
        'errors' => [
            'different_property_on_move' => 'Структура назначенной комнаты не входит в ваш список структур',
            'family_master_already_in_room' => 'Невозможно продолжить, глава семьи уже находится в комнате назначения',
            'checkin_checkout_not_suitable' => 'Даты заезда или выезда гостей не совпадают с датами комнаты назначения',
            'not_found' => 'Гость не найден',
            'city_tax_already_sent_to_channel' => 'Гость уже отправлен в каналы налога на проживание, дальнейшее действие невозможно',
            'change_accommodation_with_invoiced_tax' => 'Невозможно изменить тип комнаты для гостя, у которого уже есть выставленные налоги на проживание',
        ],
        'guest_cards' => [
            'empty_error' => 'Неверные учетные данные или структура не активирована.',
            'uknown_error' => 'Неизвестная ошибка внешнего сервиса',
            'venice_tax_exemption_type' => 'Освобождение от взноса на доступ в город Венеция',
            'guest_required' => 'Необходимо указать гостя для привязки карты',
            'customer_fields_are_required' => 'Необходимо заполнить следующие поля гостя: :fields',
            'customer_required_fields' => [
                'name' => 'Имя',
                'surname' => 'Фамилия',
                'nic' => 'Идентификационный номер',
                'birthday_date' => 'Дата рождения',
                'birth_country.translations.0.name' => 'Место рождения',
                'detail.email' => 'Электронная почта',
                'detail.telephone' => 'Телефон',
                'detail.country.translations.0.name' => 'Страна проживания',
            ],
        ],
    ],

    'housekeeper' => [
        'main_title' => 'Горничная',
        'clean_status' => 'Статус',
        'name' => 'Горничная',
        'label' => 'Номер',
        'accommodation' => 'Номер',
        'bed_type' => 'Тип кровати',
        'bed_type_requested' => 'Запрашиваемый тип кровати',
        'bed_type_last' => 'Предыдущий тип кровати',
        'bed_type_next' => 'Следующий тип кровати',
        'next_abbrevation' => 'След',
        'prev_abbrevation' => 'Пред',
        'guests' => 'Гости',
        'reservations' => 'Бронирования',
        'guests_checkin' => 'Прибытие',
        'guests_in_home' => 'На месте',
        'guests_checkout' => 'Отъезд',
        'next_change_sheet' => 'Смена постельного белья',
        'day' => 'день',
        'days' => 'дни',
        'today' => 'Сегодня',
        'notes' => 'Заметки',
        'housekeeper_notes' => 'Заметки горничной',
        'room_clean' => 'Уборка завершена',
        'room_dirty' => 'Комната грязная',
        'adults' => 'Взрослых: :count',
        'children' => 'Детей: :count',
        'requested' => 'Запрашиваемый',
        'today' => 'Сегодня',
        'tomorrow' => 'Завтра',
        'maintenance' => 'Техническое обслуживание',
        'export_fields' => [
            'cleaning' => 'Уборка',
            'accommodation' => 'Номер',
            'housekeeper' => 'Горничная',
            'status' => 'Статус',
            'staging' => 'Тип кровати',
            'sheet' => 'Постельное белье',
            'linen' => 'Белье',
            'details' => 'Детали',
            'created_at' => 'Дата',
            'user' => 'Пользователь',
            'scenario_title' => 'Сценарий',
            'column1' => 'Дата/Ресурс',
            'column2' => 'Планирование',
            'column3' => 'Время',
            'scenario' => 'Планирование',
            'housekeeper_collaborator' => 'В сотрудничестве с',
        ],
        'print' => [
            'number_of_accommodations' => ':number номеров',
            'number_of_checkin' => 'Прибытие: :checkin_done из :checkin_total',
            'number_of_checkout' => 'Отъезд: :checkout_done из :checkout_total',
            'number_of_inhome' => 'На месте: :number_in_home',
            'change_sheet' => 'Смена постельного белья',
            'change_linen' => 'Смена белья',
            'note_housekeeper' => 'Заметки для горничной',
            'pending_manteiner' => ':number заявок ожидают решения',
            'status_checkin' => 'Прибытие',
            'status_checkout' => 'Отъезд',
            'status_in_home' => 'На месте',
            'status_label_adult' => ':adults Взрослых',
            'status_label_children' => ':children_number Детей',
            'passed_nights' => 'Ночей: :passed_nights из :total_nights',
        ],
        'bed_type_current' => 'Запрошенная подготовка',
    ],

    'import' => [
        'customer' => [
            'job_name' => 'Клиенты',
            'warnings' => ['required_field' => 'обязательное поле'],
            'tooltips' => [
                'skip_on_missing' => 'Записи в загруженном файле, не содержащие значения для этого соответствия, будут проигнорированы при импорте.',

                'sex_value' => '<br />Допустимые значения для каждого параметра:  
        <br />- Мужской: male, maschio, uomo, m, man, maschile, u  
       <br /> - Женский: female, femmina, donna, f, woman, femminile, d  
        <br />- Не указано: not_defined, non definito, non specificato, na, n/a, пустая ячейка  
        <br />Система не различает регистр: «uomo», «UOMO» и «Uomo» будут распознаны одинаково.',

                'birth_country_required' => 'Для корректного сопоставления города рождения необходимо также сопоставить это поле. Система принимает название страны на любом языке, а также все коды ISO: 3166-1 (3 цифры), 3166-1 alpha-2 (2 буквы), 3166-1 alpha-3 (3 буквы).',

                'birth_country' => 'Если сопоставлено только поле «Страна рождения» (без города), система автоматически установит столицу выбранной страны как город рождения в анкете клиента. Система принимает название страны на любом языке и любые ISO-коды без учета регистра.',

                'birth_city' => 'Для корректного сопоставления города необходимо также сопоставить поле «Страна рождения». Система принимает название города на любом языке.',

                'citizenship_country' => 'Принимаются названия стран на любом языке и все коды ISO: 3166-1 (3 цифры), 3166-1 alpha-2 (2 буквы), 3166-1 alpha-3 (3 буквы) без учета регистра.',

                'language' => 'Система поддерживает следующие языки Beddy: итальянский, английский, французский, немецкий, испанский, русский, японский. Другие языки устанавливаются как английский.  
        Допустимые параметры (независимо от регистра):  
        - ISO 639-1 (2 буквы), например: ru  
        - ISO 639-2 (3 буквы), например: rus  
        - Полное название языка (на итальянском, английском, французском, немецком, испанском), например: russo, russian, russe, russisch, ruso  
        Если значение не указано или не сопоставлено, система установит официальный язык страны проживания, если он доступен, или язык по умолчанию.',

                'residence_city' => 'Для корректного сопоставления города необходимо также сопоставить поле «Страна проживания». Система принимает название города на любом языке.',

                'residence_country_required' => 'Для корректного сопоставления города проживания необходимо также сопоставить это поле. Система принимает название страны на любом языке и все ISO-коды.',

                'residence_country' => 'Если сопоставлено только поле «Страна проживания» (без города), система автоматически установит столицу выбранной страны как город рождения в анкете клиента. Система принимает название страны на любом языке и все ISO-коды без учета регистра.',

                'residence_address' => 'Введите только адрес, без города, почтового индекса и страны.',

                'email' => 'Введите адрес электронной почты, а не PEC (сертифицированную почту), у которой есть отдельное поле.',

                'document_type' => 'Принимаются все типы документов, предусмотренные порталом Alloggiati Web, без учета регистра. Также принимаются распространенные аббревиатуры для таких документов, как удостоверение личности, электронная карта, водительские права и паспорт (например: CI, CIE, ID, PASS).',

                'released_country_required' => 'Для корректного сопоставления города выдачи документа необходимо также сопоставить это поле. Система принимает название страны на любом языке и все коды ISO.',

                'released_country' => 'Если сопоставлено только поле «Страна выдачи» (без города), система автоматически установит столицу выбранной страны как город рождения в анкете клиента. Система принимает название страны на любом языке и все ISO-коды без учета регистра.',

                'released_city' => 'Для корректного сопоставления города необходимо также сопоставить поле «Страна выдачи документа». Система принимает название города на любом языке.',

                'invoicing_country_required' => 'Для корректного сопоставления города выставления счета необходимо также сопоставить это поле. Система принимает название страны на любом языке и все коды ISO.',

                'invoicing_country' => 'Если сопоставлено только поле «Страна выставления счета» (без города), система автоматически установит столицу выбранной страны как город рождения в анкете клиента. Система принимает название страны на любом языке и все ISO-коды без учета регистра.',

                'invoicing_city' => 'Для корректного сопоставления города необходимо также сопоставить поле «Страна выставления счета». Система принимает название города на любом языке.',
            ],

            'columns' => [
                'name' => 'Имя',
                'surname' => 'Фамилия',
                'sex' => 'Пол',
                'birthday_date' => 'Дата рождения',
                'nic' => 'Налоговый код',
                'email' => 'Электронная почта',
                'pec' => 'PEC адрес',
                'telephone' => 'Телефон',
                'language' => 'Язык',
                'birth_country' => 'Страна рождения',
                'birth_city' => 'Город рождения',
                'nationality_country' => 'Гражданство (например, Италия)',
                'citizenship_country' => 'Страна гражданства',
                'residence_country' => 'Страна проживания',
                'residence_city' => 'Город проживания',
                'residence_address' => 'Адрес проживания',
                'residence_zip_code' => 'Почтовый индекс проживания',
                'invoicing_country' => 'Страна для выставления счета',
                'invoicing_city' => 'Город для выставления счета',
                'invoicing_address' => 'Адрес для выставления счета',
                'invoicing_zip_code' => 'Почтовый индекс для выставления счета',
                'sdi_code' => 'Код SDI',
                'facebook' => 'URL Facebook',
                'linkedin' => 'URL LinkedIn',
                'twitter' => 'URL Twitter',
                'skype' => 'Skype',
                'note' => 'Заметки',
                'lottery_code' => 'Код лотереи',
                'document_type' => 'Тип документа',
                'document_number' => 'Номер документа',
                'expiration_date' => 'Дата истечения срока документа',
                'released_country' => 'Страна выпуска документа',
                'released_city' => 'Город выпуска документа',
                'release_county' => 'Провинция выпуска документа',
                'release_state' => 'Регион выпуска документа',
                'lang_values' => ['russo', 'russian', 'russe', 'russisch', 'ruso', 'pусский', 'jpn',],
                'sex_values' => [
                    'male' => [
                        'мужской',
                        'мужской',
                        'м',
                    ],
                    'female' => [
                        'женский',
                        'женщина',
                        'ж',
                    ],
                    'not_defined' => [
                        'не определено',
                        'не указан',
                    ],
                ]
            ],
        ],
        'company' => [
            'job_name' => 'Компании',
            'columns' => [
                'name' => 'Наименование',
                'vat_code' => 'НДС код',
                'nic' => 'Налоговый код',
                'nick_name' => 'Псевдоним',
                'email' => 'Электронная почта',
                'pec' => 'PEC адрес',
                'telephone' => 'Телефон',
                'country' => 'Страна',
                'city' => 'Город',
                'address' => 'Адрес',
                'zip_code' => 'Почтовый индекс',
                'invoicing_country' => 'Страна для выставления счета',
                'invoicing_city' => 'Город для выставления счета',
                'invoicing_address' => 'Адрес для выставления счета',
                'invoicing_zip_code' => 'Почтовый индекс для выставления счета',
                'sdi_code' => 'Код SDI',
                'facebook' => 'Facebook',
                'linkedin' => 'LinkedIn',
                'twitter' => 'Twitter',
                'skype' => 'Skype',
                'note' => 'Заметки',
            ],
        ],
        'booking_onboard_photo_property' => [
            'job_name' => 'Импорт фотографий с Booking',
        ],
        'common' => [
            'personal_informations' => 'Личные данные',
            'contacts' => 'Контакты',
            'residential_details' => 'Детали проживания',
            'invoice_address' => 'Данные для выставления счета',
            'documents' => 'Документы',
            'email' => 'Электронная почта',
            'other' => 'Прочее',
        ],
        'sending_list_contacts' => [
            'job_name' => 'Список контактов',
            'columns' => [
                'label' => 'Этикетка',
                'email' => 'Электронная почта',
                'locale' => 'Язык',
            ],
        ],
        'errors' => [
            'request_params_not_valid' => 'Следующие параметры запроса не являются действительными: ',
        ],
    ],

    'invoice_layouts' => [
        'errors' => [
            'delete' => [
                'one_or_more_receipt_modules_attached' => 'Есть одна или несколько фискальных принтеров, привязанных к этому профилю счета. Для удаления этого профиля счета необходимо удалить принтеры или привязать их к новому профилю счета.',
            ],
        ],
    ],

    'invoice' => [
        'export_fields' => [
            'payment_date' => 'Дата платежа',
            'number' => 'Номер счета',
            'business_name' => 'Юридическое лицо',
            'total_price' => 'Общая стоимость',
            'vat' => 'НДС',
            'taxable' => 'Налоговая база',
            'invoice_date' => 'Дата документа',
            'recipient_vat_code' => 'НДС получателя',
            'number_complete' => 'Номер',
            'recipient_business_name' => 'Название получателя',
            'total_with_discount' => 'Общая сумма со скидкой',
            'total_tax' => 'Всего НДС',
            'total' => 'Всего',
            'status_sdi' => 'SDI',
            'expire_date' => 'Дата истечения',
            'status' => 'Статус',
            'payment_term' => 'Условия оплаты',
            'customer_name' => 'Клиент',
            'payment' => 'Платеж',
            'date' => 'Дата',
            'accountholder' => 'Владелец счета',
            'notes' => 'Примечания',
            'paid' => 'Оплачено',
            'to_pay' => 'К оплате',
            'property' => 'Структура',
            'payment_status' => 'Статус платежа',
            'data' => 'Данные',
            'currency' => 'Валюта',
            'total_document' => 'Итог по документу',
        ],
        'statuses' => [
            'paid' => 'Оплачено',
            'suspended' => 'Приостановлено',
            'cancelled' => 'Отменено',
        ],
        'sdi_statuses' => [
            '0' => 'Не отправлено',
            '1' => 'Ожидает',
            '2' => 'Отклонено',
            '3' => 'Завершено',
        ],
        'pdf_export' => [
            'description' => 'Описание',
            'quantity' => 'Количество',
            'amount' => 'Сумма',
            'vat' => 'НДС',
            'vat_abbr' => 'НДС',
            'total' => 'Итого',
            'invoice_label' => 'Счет',
            'of_date' => 'от',
            'taxable' => 'Налоговая база',
            'deposit' => 'Депозит',
            'deposit_document_reference' => 'Ссылка на документ',
            'aomount_not_taxable' => 'Сумма без налога',
        ],
        'invoices_opened' => [
            'invoices_opened_title' => 'Ожидающие платежи',
            'export_fields' => [
                'expire_date' => 'Дата истечения',
                'accountholder' => 'Владелец счета',
                'document_number' => 'Номер документа',
                'date' => 'Дата',
                'type' => 'Тип',
                'paid' => 'Оплачено',
                'to_pay' => 'К оплате',
                'total' => 'Итого',
                'note' => 'Примечания',
                'property' => 'Структура',
            ],
        ],
        'errors' => [
            'advance_not_suitable' => 'Приложенный аванс не соответствует типу документа',
            'credit_note_on_follows_invoice_paid' => 'Невозможно выпустить кредит-ноту для оплаченного документа, который является продолжением счета',
            'credit_note_on_follows_invoice_linked' => 'Невозможно выпустить кредит-ноту для документа, связанного с основным счетом',
            'restore_on_follows_invoice_linked' => 'Невозможно восстановить счет, связанный с другим документом',
            'cant_restore_opened_invoice' => 'Невозможно восстановить открытую счет-фактуру',
            'module_sdi_not_active' => 'Модуль электронной фактуры не активен',
            'refund_major_than_total_credit_note' => 'Возврат по кредитной ноте превышает общую сумму, невозможно продолжить',
            'expense_on_invoice' => 'Невозможно добавить расход к документу, отличному от кредит-ноты',
            'cant_resend_due_status' => 'Текущее состояние SDI не позволяет повторно отправить документ',
            'empty_xml' => 'XML не найден',
            'cancellation_no_show_conflict' => 'Можно указать только один тип: no-show или отмена',
            'cant_delete_credit_note' => 'Невозможно удалить кредит-ноту',
            'add_to_invoices_already_registered' => 'Невозможно добавить платежи к уже зарегистрированным счетам или кредитным нотам',
            'edit_invoices_already_registered' => 'Невозможно редактировать уже зарегистрированные счета',
            'delete_registered_invoice' => 'Невозможно удалить зарегистрированный счет',
            'impossible_delete_until_moves' => 'Невозможно удалить счет, сначала перенесите расходы на другой счет',
            'not_exist' => 'Счет не существует',
            'vat_payment_impossible_for_receipt' => 'Невозможно установить другой НДС для налоговой квитанции',
            'unrestorable_bill' => 'Счет не подлежит восстановлению',
            'impossible_discount_for_discounted_bills' => 'Невозможно применить скидку к счету с уже примененной скидкой',
            'refundable_bill_in_invoice' => 'Невозможно добавить ссылку на возврат для счета, который не является кредитной нотой',
            'impossible_manual_charge_updating' => 'Невозможно изменить данный платеж',
            'impossible_follows_invoice_updating' => 'Невозможно изменить счет, который является продолжением другого документа',
            'impossible_associate_invoice_as_advance' => 'Невозможно присоединить обычный счет как аванс',
            'advances_over_allowed' => 'Сумма аванса превышает разрешенную',
            'fp_advances_with_different_department' => 'Выбранные авансовые счета должны иметь одинаковый налоговый департамент',
            'advances_no_have_department' => 'Департамент для аванса должен присутствовать в счете по окончанию',
            'advances_total_major' => 'Сумма аванса не может быть больше, чем сумма всех платежей по тому же департаменту счета',
            'invoice_totally_refunded' => 'Счет полностью возвращен, невозможно продолжить',
            'advance_with_different_customer' => 'Аванс не может быть связан с другим клиентом',
            'advance_totally_assigned' => 'Аванс полностью использован, невозможно вернуть',
            'deposit_in_general_invoice' => 'Невозможно использовать депозит в общем счете',
            'bill_overrated' => 'Сумма платежа превышает общую сумму счета',
            'invoice_overrated' => 'Сумма платежа превышает общую сумму счета',
            'property_not_attached' => 'Структура не прикреплена',
            'funds_params_unsuitable' => 'Параметры не совместимы с фондом',
            'registered_advance_invoice' => 'Авансовый счет уже зарегистрирован, удалите связанные счета',
            'registered_sdi invoice' => 'Авансовый счет отправлен в SDI, не может быть удален',
            'move_between_different_types' => 'Невозможно перемещать расходы между счетами и кредитными нотами',
            'discount_over' => 'Скидка превышает допустимую сумму для счета',
            'archive_completed' => 'Архив уже завершен',
            'too_many_tasks' => 'Слишком много выполняемых задач',
            'archive_warning' => 'Некоторые файлы отсутствуют',
            'archive_complete' => 'Архив завершен',
            'invoice_registered' => 'Документ уже выписан, невозможно продолжить',
            'bill_tranfer_follows_invoice' => 'Невозможно передать расходы из счета, являющегося продолжением счета',
            'bill_generic_and_follows_invoice' => 'Невозможно добавить как обычные расходы и расходы, являющиеся продолжением счета',
            'different_vat_code_follows_invoice' => 'Обнаружен НДС с другим кодом в продолжении счета, невозможно продолжить',
            'receipt_with_follows_invoice' => 'Невозможно создать сводный счет из квитанции, являющейся продолжением счета',
            'type_not_invoice_summary' => 'Невозможно связать необлагаемый налогом документ с текущим типом документа',
            'archive_all_file_not_found' => 'Файл не найден',
            'impossible_apply_discount_row_on_discounted_invoice' => 'Невозможно применить скидку к строкам счета с уже примененной скидкой',
            'cant_delete_invoice_due_convention' => 'Невозможно удалить счет, так как он связан с соглашением',
            'discount_on_invoice_and_on_row' => 'Невозможно применить скидку и на строку, и на счет',
            'discount_on_summary_invoice' => 'Невозможно применить скидку к сводному счету',
            'cant_delete_invoice_due_linked_advances' => 'Невозможно удалить авансовый счет, связанный с другими счетами',
            'cant_delete_invoice_due_credit_notes' => 'Невозможно удалить документ, который уже был отменен',
            'cant_delete_invoice_due_module_fattelettronica' => 'Невозможно удалить счет, так как он уже был отправлен в SDI',
            'cant_restore_invoice_due_sdi_ns' => 'Невозможно восстановить счет, так как он был отклонен SDI',
            'cant_transfer_due_invoice_registered' => 'Невозможно переместить уже зарегистрированный счет',
            'cant_merge_credit_note' => 'Невозможно объединить кредитные ноты',
            'cant_merge_due_module_fattelettronica' => 'Невозможно объединить модули с отправкой через SDI',
            'cant_transfer_without_holder' => 'Невозможно передать счет без владельца',
            'empty_row_document' => 'Добавьте хотя бы одну строку в документ',
            'cant_delete_receipt' => 'Невозможно удалить налоговую квитанцию',
            'addon_unrelated' => 'Невозможно добавить дополнительную услугу к этому счету',
            'impossible_add_row' => 'Невозможно добавить строку в неоплаченный или несуществующий документ',
            'uncharged_rows_found_on_restore' => 'Невозможно восстановить счет: обнаружены неоплаченные строки',
            'cant_create_temporary_due_missing_layout' => 'Невозможно создать документ без подходящего макета счета',
            'move_bill_over_discount' => 'Невозможно передать расходы, так как оставшаяся сумма меньше нуля',
            'cant_decrement_price_invoiced_bill' => 'Невозможно уменьшить цену уже оплаченного счета',
            'printer_id_not_associated' => 'Идентификатор налоговой принтера не прикреплен к счету',
            'cant_move_reservation_due_advance_invoice' => 'Существует аванс. Для перемещения бронирования необходимо создать окончательную счет-фактуру или кредитную ноту',
            'cant_move_reservation_due_deposit' => 'Есть депозиты. Для перемещения бронирования их нужно удалить или вернуть',
            'cant_move_reservation_due_payments' => 'Есть платежи. Для перемещения бронирования их нужно удалить или вернуть',
            'cant_update_invoice_balance' => 'Невозможно обновить баланс счета',
            'cant_update_invoice_balance_layout' => 'Невозможно изменить макет счета, так как он не совместим с текущей налоговой ставкой',
            'cant_register_invoice_balance_price' => 'Общая сумма счета должна совпадать с суммой платежа',
            'cant_choose_payment_deposit_different_property' => 'Невозможно использовать депозит для счета другой структуры',
            'cant_choose_payment_advance_different_property' => 'Невозможно использовать аванс для счета другой структуры',
            'cant_create_invoice_layout_without_vat_code_without_properties_enabled' => 'Невозможно создать профиль счета без НДС для структур, не включающих систему налоговой отчетности',
            'unable_to_register_not_all_inclusive_tax_document_addons' => 'Существуют расходы, не разрешенные для включения в документ с налогом',
            'tax_bills_rows_joined_with_other_type_bills_on_all_tax_inclusive_document' => 'Обнаружены ошибки объединения расходов разных типов',
            'all_tax_inclusive_layout_on_fiscal_printer' => 'Невозможно использовать профиль без НДС на налоговом принтере',
            'all_inclusive_tax_document_for_advance' => 'Невозможно создать документ для аванса с налогообложением "включены все налоги"',
            'advances_on_all_inclusive_tax_doument' => 'Невозможно использовать авансы для документов с полным налогообложением',
            'credit_note_on_all_inclusive_tax_document' => 'Невозможно создать кредит-ноту для документов с полным налогообложением',
            'missing_department_override' => 'Отсутствует подразделение для счета',
            'missing_department' => 'Отсутствует подразделение для выбранного НДС',
            'advance_bill_not_found' => 'Счет аванса не найден',
            'totals_bills_not_equals' => 'Сумма строк не совпадает с общей суммой счета',
            'multiple_invoices_bill_rows_override' => 'Невозможно создать изменение для строк разных документов',
            'cant_create_override_for_registered_invoice' => 'Невозможно создать или изменить счет, который уже зарегистрирован или не существует',
            'cant_edit_print_settings_for_registered' => 'Невозможно изменить настройки печати для зарегистрированного документа',
            'not_found' => 'Документ не найден',
            'no_attachments' => 'Нет вложений для этого документа',
            'error_attachments' => 'Ошибка при загрузке вложений',
            'advance_with_all_inclusive_tax_document' => 'Невозможно создать авансовый счет с полным налогообложением',
            'empty_email' => 'Введите адрес электронной почты',
            'empty_email_pdf' => 'PDF документ недоступен',
            'advance_partially_used' => 'Невозможно создать кредит-ноту для частично использованного аванса',
            'different_vat_payment_on_advance' => 'Невозможно связать аванс с разными НДС',
            'cant_delete_credit_note_due_to_sdi_or_fp' => 'Невозможно удалить кредит-ноту, так как она была отправлена в SDI или использована с налоговой принтером',
            'cant_delete_credit_note_between' => 'Невозможно удалить кредит-ноту между несколькими документами',
            'destination_deleted' => 'Получатель больше не существует в системе',
            'vat_code_not_valid' => 'Неверный НДС код',
            'tax_code_not_valid' => 'Неверный налоговый код',
            'empty_codes' => 'Неверный налоговый или НДС код',
            'row_exceed_total_price' => 'Строка превышает общую сумму',
            'row_exceed_qty' => 'Строка превышает количество',
            'cant_register_invoice_as_follows_invoice' => 'Невозможно создать счет в режиме "следующий счет"',
            'cant_register_rejected_invoice_as_receipt' => 'Невозможно зарегистрировать отклоненный документ как квитанцию',
            'cant_turn_to_paid_follows_invoice' => 'Невозможно пометить как "оплачено" квитанцию в режиме "следующий счет"',
            'reversal_on_receipt_follows_invoice_joined' => 'Невозможно создать кредит-ноту для квитанции, которая является продолжением счета',
            'receipt_channel_must_activated' => 'Для настройки виртуального принтера необходимо активировать модуль "Интерфейс третьих систем"',
            'partial_cannot_exceed_total' => 'Частичный возврат не может превышать общую сумму',
            'partial_cannot_exceed_percentage' => 'Процент возврата не может превышать общую сумму',
            'credit_note_partial_on_advance' => 'Невозможно создать частичную кредит-ноту для авансового счета',
            'credit_note_partial_on_fp_send' => 'Невозможно создать частичную кредит-ноту для документа, отправленного на налоговый принтер',
            'credit_note_partial_on_follows_invoice' => 'Невозможно создать частичную кредит-ноту для продолжения счета',
            'row_to_refund_not_found' => 'Строка для возврата не найдена',
            'partial_only_credit_note' => 'Частичные возвраты возможны только для кредитных нот',
            'partial_credit_note_total_payment_exceed_source_payment' => 'Общая сумма возврата превышает исходный платеж',
            'payment_not_belonging_to_invoice_source' => 'Выбранный платеж не связан с исходным документом',
            'payment_not_found' => 'Выбранный платеж не найден',
            'partial_credit_note_row_payment_exceed_source_payment' => 'Общий платеж превышает исходный платеж',
            'city_tax_bills_partial_refund' => 'Невозможно выполнить частичный возврат для налоговых документов по налогам на проживание',
            'credit_note_paid_major_than_total' => 'Общая сумма платежей по документу превышает общую сумму',
            'discount_over_permitted' => 'Примененная скидка превышает максимально допустимую сумму без учета налогов',
        ],
        'errors_xml' => [
            'error_additional_charges_are_required_to_issue_the_receipt' => 'Разность между балансом и авансами (:totalPayments €) меньше необходимого значения (:subtractPayment €) для закрытия документа, поскольку каждая позиция должна стоить не менее 0,01 €. Увеличьте списание на :amountRequired € или сгруппируйте списания по категориям или услугам для получения меньшего количества позиций.',
            'error_total_cannot_be_less_than_one_cent' => 'Итоговая сумма документа должна превышать сумму авансов (не менее 0,01 €)',
            'payment_not_valid' => 'Неверный способ оплаты',
            'tax_system' => 'Неверная налоговая система отправителя. Настройте налоговую систему в профиле счета',
            'cap' => 'Неверный CAP для отправителя',
            'destination_code' => 'Неверный код получателя',
            'destination_code_pa' => 'Неверный код получателя для PA',
            'destination_code_pr' => 'Неверный код получателя для частного лица',
            'destination_cf' => 'Неверный код налогоплательщика получателя',
            'destination_cap' => 'Неверный CAP получателя',
            'address' => 'Адрес для выставления счета не заполнен',
            'empty_row_description' => 'Введите описание для всех строк документа',
            'department_fp' => 'Отдел с налоговой ставкой не найден',
            'payment_error' => 'Ошибка в деталях платежа',
            'payment_error_amount' => 'Общая сумма документа меньше общей суммы указанных платежей',
            'payment_error_code' => 'Неверный код платежа: ',
            'nature' => 'Природа не указана при ставке НДС равной нулю',
            'reverse_charge' => 'Невозможно применить механизм разделения платежей и обратный налоговый платеж одновременно',
            'error_sdi' => 'Ошибка отправки в SDI. Проверьте введенные значения.',
            'document_no_xml' => 'Тип документа не поддерживает XML',
            'not_found' => 'XML не найден',
            'error_send_invoice' => 'Ошибка отправки поставщику',
            'limit_document_id' => 'Номер документа :id_document недействителен, так как превышает допустимый лимит в 20 символов',
            'error_import_invoice' => 'Импорт отклонен',
            'xsd_validation_skip' => 'Ошибка валидации xsd. Валидация пропущена',
            'xsd_validation_failed' => 'Введенное значение (:value) элемента :node неверно',
            'error_limit_number_invoice' => 'Невозможно отправить файл. Документы исчерпаны. Свяжитесь с поддержкой',
            'error_account_inactive' => 'Аккаунт не активен у поставщика счета. Свяжитесь с поддержкой',
            'payment_error_vat_quote' => 'НДС ставки различаются между общей суммой и авансом',
            'error_content_document' => 'Неверное содержимое документа, свяжитесь с поддержкой',
            'error_create_document' => 'Ошибка при создании XML документа, свяжитесь с поддержкой.',
            'error_xml_format_received' => 'Неверный формат XML ответа.',
            'error_empty_response' => 'Пустой XML ответ.',
            'error_zip_archive_creation' => 'Ошибка при создании архива zip.',
            'error_empty_document' => 'Пустой XML документ, свяжитесь с поддержкой.',
            'voucher_code_not_valid' => 'Код ваучера недействителен.',
            'custom' => [
                'limit_message_content' => 'Содержимое сообщения превышает ограничение в 42 символа.',
            ],
            'rch' => [
                'limit_message_content' => 'Содержимое сообщения превышает ограничение в 25 символов.',
            ]
        ],
        'warnings' => [
            'document_not_found' => 'Документ с ID :invoice_id не найден',
            'city_tax_charged_for_guest' => 'Налог на пребывание был выставлен гостю, хотите продолжить?',
            'vat_code_already_joined' => 'Профиль уже связан с выставленными счетами или платежами, невозможно изменить НДС или данные владельца счета',
            'all_inclusive_tax_document_with_vat_code' => 'Документ с включенным НДС несовместим с выставлением счета через НДС',
            'cant_restore_bill_invoiced' => 'Счет уже выставлен, восстановление невозможно',
            'cant_restore_bill_stay_not_involved' => 'Этот платеж относится к датам, не включенным в пребывание, хотите удалить его?',
            'cant_restore_bill_not_related' => 'Невозможно восстановить этот платеж, так как ресурс больше не существует',
            'cant_update_bill_day_price' => 'Невозможно изменить цену за день :date, потому что общая сумма платежа меньше разницы в цене',
            'cant_update_bill_day_price_due_convention' => 'Плательщик за день :date не соответствует разделению счета, пожалуйста, измените сумму прямо в разделе расходов',
            'cant_delete_bill_stay' => 'Невозможно удалить расход за пребывание',
            'cant_delete_due_to_joined_documents' => 'Невозможно удалить расход, связанный с выставленными документами',
            'number_used' => 'Номер счета уже использован',
            'number_no_sequential' => 'Используемый номер должен быть в пределах от даты предыдущего счета до даты следующего счета',
            'transferred_bills_present' => 'На счете присутствуют расходы, переданные из бронирования. Следующая операция окончательно удалит или обнулит их.',
            'layout_numbers_existing' => 'Существуют активные прогрессивные нумерации для этого НДС или налогового номера. Хотите заменить их на нумерации, установленные в этом новом профиле счета? Рекомендуем проверить номер последних выставленных документов для этого НДС или налогового номера.',
            'additional_info_block_only_for_invoice' => 'Невозможно вставить дополнительные информационные блоки для этого типа документа',
            'detach_not_collected_document' => 'При изменении типа документа все не взысканные документы будут удалены. Хотите продолжить?',
            'cant_restore_general_bill' => 'Не удалось восстановить списание средств со сквозного счета. Пожалуйста, выполните перевод вручную.',
        ],
        'pdf' => [
            'accommodations' => 'Пребывание',
            'addons' => 'Дополнения',
            'advances' => 'Авансы',
            'taxes' => 'Налоги',
            'deposits' => 'Депозиты',
            'credit_note_reversal' => 'Аннулирование квитанций',
            'advance_with_number_complete' => 'Авансовый счет № :number_complete',
            'payment' => 'Платеж',
            'taxation_list' => 'Резюме НДС',
            'taxable_amount' => 'Облагаемая сумма',
            'tax_amount' => 'Налоги',
            'total' => 'Итого',
            'total_taxes' => 'Общий налог',
            'total_taxable' => 'Общая облагаемая сумма',
            'total_taxation' => 'Общий НДС',
            'total_amount' => 'Общая сумма',
            'total_paid' => 'Оплачено',
            'total_to_pay' => 'К оплате',
            'document_heading' => 'Документ № :identifier от :date',
            'document_advance_heading' => 'Бронирование #:identifier - Аванс',
            'document_heading_no_date' => 'Документ № :identifier',
            'document_num' => 'Документ №',
            // DEPRECATED:
            'document_date' => 'от',
            // DEPRECATED:
            'payable' => 'Не фискальный документ',
            'proforma' => 'Проформа',
            'additional_information' => 'Дополнительная информация',
            'additional_information_contract' => 'Контракт',
            'additional_information_purchase_order' => 'Заказ на покупку',
            'additional_information_agreement' => 'Соглашение',
            'additional_information_receiving' => 'Получение',
            'additional_information_joined_invoices' => 'Связанные счета',
            'additional_information_progress_status' => 'Статус прогресса',
            'additional_information_document_id' => 'ID документа',
            'additional_information_line_number_referral' => 'Номер строки',
            'additional_information_num_item' => 'ID строки',
            'additional_information_date' => 'Дата',
            'additional_information_agreement_deal_code' => 'Код сделки',
            'additional_information_cup' => 'Код CUP',
            'additional_information_cig' => 'Код CIG',
            'additional_information_step_reference' => 'Ссылка на этап',
            'invoice' => 'Счет-фактура',
            'unregistered_invoice' => 'Счет',
            'receipt' => 'Квитанция',
            'credit_note' => 'Кредитная заметка',
            'proforma' => 'Проформа',
            'auto_invoice' => 'Автофактура',
            'reverse_auto_invoice' => 'Аннулирование автофактуры',
            'debit_note' => 'Дебетовая записка',
            'destination' => 'Получатель',
            'causal' => 'Причина',
            'extra_notes' => 'Заметки',
            'attachments' => 'Вложения',
            'sdi_send_date' => 'Дата отправки SDI',
            'rounding' => 'Округление',
            'vat_payment' => [
                'D' => 'НДС с отсроченным платежом',
                'I' => 'НДС с немедленным платежом',
            ],
            'payment_method' => 'Способ оплаты',
            'iban' => 'IBAN',
            'institution' => 'Учреждение',
            'credit_institution' => 'Кредитное учреждение',
            'amount_virtual_stamp' => 'Сумма гербового сбора',
            'discount' => 'Скидка',
            'discount_amount' => 'Скидка или наценка',
            'receipts' => 'Список квитанций',
            'reversal' => 'Список аннулированных квитанций',
            'receipts_expired' => 'Список квитанций со статусом "истекло"',
            'receipts_unpaid' => 'Список квитанций со статусом "к оплате"',
            'receipts_suspended' => 'Список квитанций со статусом "приостановлено"',
            'receipts_paid' => 'Список квитанций со статусом "оплачено"',
            'payments' => 'Платежи',
            'payment_date' => 'Дата платежа',
            'payment_label' => 'Плательщик',
            'payment_method' => 'Метод',
            'amount_available' => 'Доступная сумма',
            'amount_used' => 'Использованная сумма',
            'deposit' => 'Депозит',
            'copy_text' => 'Копия вежливости без налогового значения согласно ст. 21 ДПР 633/72. Оригинал был отправлен в SDI (Систему обмена) и доступен в вашем личном кабинете Агентства доходов.',
        ],
        'wording' => [
            'virtual_stamp_causal_more' => 'Гербовый сбор, уплаченный виртуально согласно статье 6 DM 17/06/2014',
            'all_inclusive_tax_document_exemption' => 'Освобождение - Статья 3 Декрета № 23 от 14/03/2011',
            'standard_advance' => 'Бронирование #:reference_number - Аванс',
            'manual_fp_register' => 'как уже фискализированный документ',
            'follows_invoice' => 'следует за счетом',
            'default' => 'стандарт',
            'force_change' => 'принудительное изменение начислений'
        ],
        'art17' => 'Операция подлежит разделению платежей с НДС, не собранным продавцом согласно ст. 17-ter ДПР 633/1972.',
        'art6' => 'Операция, подлежащая отсрочке НДС согласно ст. 6, п. 5 ДПР 633/1972.',
        'invoice_module' => [
            'invalid_vat_code' => 'Неверный НДС код',
            'invalid_invoice_channel' => 'Выберите действующий канал',
            'error_get_data' => 'Ошибка получения данных аккаунта',
            'vat_code_exist' => 'Модуль с этим НДС кодом уже существует',
            'error_fiscal_printer_linked' => 'Есть выставленные фискальные квитанции, связанные с принтером. Хотите удалить?',
            'customer' => 'Клиент',
            'subcontracting' => 'Субподряд'
        ],
        'invoice_import' => [
            'import_success' => 'Файлы успешно импортированы',
            'import_skip' => 'Файлы проигнорированы (неверный НДС получателя или файл уже импортирован)',
            'import_error' => 'Ошибка импорта, неверный xml файл',
        ],
        'no_show' => [
            'invoice_label' => 'No Show',
            'invoice_cancellation' => 'Отмена',
            'no_vat_quote_defined' => 'Структура не имеет НДС ставки типа :type',
        ],
        'cancellation' => [
            'invoice_label' => 'Штраф за отмену',
        ],
        'lottery_code' => 'Код лотереи: :lottery_code',
        'log' => [
            'title' => 'Выставление счетов',
            'advance' => 'Счет-фактура :invoice_number от :invoice_date с профилем выставления счетов :invoice_layout (:invoice_business_name - :invoice_vat_code) и выставлен на :invoice_customer (Итого :invoice_total)',
            'refunded_advance' => ':amount документа :number от :date снова стала доступной.',
            'partial_credit_note' => 'Документ :number_complete возместил документ :invoice_source_number на сумму :credit_note_total: :bill_logs',
        ],
        'types' => [
            'reversal' => 'Квитанция аннулирования',
            'credit_note' => 'Кредитная заметка',
            'receipt' => 'Квитанция',
            'invoice' => 'Счет-фактура',
            'proforma' => 'Проформенный счет',
            'auto_invoice' => 'Автофактура',
            'debit_note' => 'Дебетовая заметка',
            'reverse_auto_invoice' => 'Аннулирование автофактуры',
            'unregistered_invoice' => 'Счет',
        ],
        'open_charges' => 'Открытые счета',
        'operational_headquarter' => 'Оперативный штаб',
        'advances' => 'Авансы',
        'log_module' => [
            'invoice_module_updated' => 'Модуль счета обновлен',
            'invoice_module_created' => 'Модуль счета создан',
            'invoice_module_deleted' => 'Модуль счета удален',
        ]
    ],

    'invoice_received' => [
        'document_types' => [
            'TD27' => 'Счет-фактура для собственного потребления или бесплатной передачи без компенсации',
            'TD26' => 'Передача амортизируемых активов и для внутренних переводов (согласно ст. 36 Д.П.Р. № 633/1972)',
            'TD25' => 'Отсроченный счет-фактура согласно ст. 21, п. 4, лит. а)',
            'TD24' => 'Отсроченный счет-фактура согласно ст. 21, п. 4, лит. а)',
            'TD23' => 'Изъятие товаров из НДС-склада с уплатой НДС',
            'TD22' => 'Изъятие товаров из НДС-склада',
            'TD21' => 'Самоинвойсинг при превышении лимита',
            'TD20' => 'Самоинвойсинг для урегулирования и корректировки счетов (ст. 6, п. 8, Д.Л.г. № 471/1997 или ст. 46, п. 5, Д.Л. № 331/1993)',
            'TD19' => 'Интеграция/самоинвойсинг для покупки товаров (ст. 17, п. 2, Д.П.Р. № 633/1972)',
            'TD18' => 'Интеграция для покупки товаров внутри сообщества',
            'TD17' => 'Интеграция/самоинвойсинг для покупки услуг из-за рубежа',
            'TD16' => 'Интеграция счета-фактуры при внутреннем реверсивном начислении',
            'TD06' => 'Гонорар',
            'TD05' => 'Дебетовая записка',
            'TD04' => 'Кредитная записка',
            'TD03' => 'Аванс/Предоплата за гонорар',
            'TD02' => 'Аванс/Предоплата по счету-фактуре',
            'TD01' => 'Счет-фактура',
            'RT06' => 'Другой социальный взнос',
            'RT05' => 'Взнос ENPAM',
            'RT04' => 'Взнос ENASARCO',
            'RT03' => 'Взнос INPS',
            'RT02' => 'Удержание с юридических лиц',
            'RT01' => 'Удержание с физических лиц',
        ],
        'statuses' => [
            'cancelled' => 'Отменено',
            'partially_paid' => 'Частично оплачено',
            'paid' => 'Оплачено',
            'unpaid' => 'Не оплачено',
        ],
        'export_fields' => [
            'amount_to_be_paid' => 'Итого к оплате',
            'paid' => 'Оплачено',
            'status' => 'Статус',
            'discount_amount' => 'Скидка',
            'total_document' => 'Общая сумма',
            'total_taxes' => 'НДС',
            'total_taxable' => 'Налогооблагаемая база',
            'sender_vat_code' => 'ИНН Отправителя',
            'sender_name' => 'Отправитель',
            'document_name' => 'Документ',
            'received_date' => 'Дата получения',
            'document_date' => 'Дата документа',
        ],
        'title' => 'Полученные счета-фактуры',
    ],

    'logger' => [
        'field_updated' => 'Обновлено :section [:field] с :old_value на :new_value',
        'titles' => [
            'queue_update' => 'Обновление очереди',
            'bulk_update' => 'Массовое обновление',
            'new_reservation' => 'Новый заказ',
            'update_reservation_status' => 'Изменение статуса бронирования',
            'cancel_accommodation' => 'Отмена забронированного номера',
            'move_accommodation' => 'Перемещение забронированного номера',
            'update_accommodation' => 'Обновление забронированного номера',
            'update_accommodation_arrival' => 'Обновление даты прибытия',
            'update_accommodation_departure' => 'Обновление даты выезда',
            'add_accommodation' => 'Добавление номера в бронирование',
            'reservation_status' => 'Обновлен статус бронирования',
            'cancel_reservation' => 'Бронирование отменено',
            'delete_reservation' => 'Бронирование удалено',
            'cancel_reservation_no_new' => 'Отмена бронирования без нового статуса',
            'clone_rates' => 'Клонирование с :channel_source на :channel_destination',
            'clone_rates_bulk' => 'Массовое обновление через клон',
            'payment_transaction' => 'Транзакция оплаты',
            'update_accommodation_listing_price' => 'Обновление цены на номер в :channel_destination',
            'accommodations_overview' => 'Ежедневный обзор',
            'reset_min_stay' => 'Сброс минимального пребывания',
            'tableau_closure_create' => 'Создание закрытия Tableau',
            'tableau_closure_delete' => 'Удаление закрытия Tableau',
            'attach_channel' => 'Подключен канал :channel_name',
            'detach_channel' => 'Отключен канал :channel_name',
            'read_channel' => 'Чтение данных канала :channel_name',
            'increase_quantity' => 'Увеличено количество номеров',
            'decrease_quantity' => 'Уменьшено количество номеров',
            'insert_rule' => 'Добавление нового правила',
            'update_rule' => 'Изменение правила',
            'delete_rule' => 'Удаление правила',
            'cutoff' => 'Cutoff',
            'insert_cutoff' => 'Добавлено правило CutOff',
            'modify_cutoff' => 'Изменено правило CutOff',
            'delete_cutoff' => 'Удалено правило CutOff',
            'bulk_treatments_update' => 'Массовое обновление процедур',
            'treatments_overview' => 'Ежедневный обзор процедур',
            'rateplan_update' => 'Обновление тарифного плана',
            'OTA-API' => 'Партнер API',
            'update_channel' => 'Изменение канала происхождения',
            'keep_accommodation' => 'Блокировка перемещения номера',
            'keep_accommodation_label' => 'Значение изменено для номера :accommodations',
            'channel_not_connected' => 'Канал не подключен',
            'city_tax_report_exclusion' => 'Исключение налога на проживание',
            'city_tax_report_exclusion_label' => 'Значение изменено для номера :accommodations',
            'update_from_past_years' => 'Копирование тарифов с предыдущих лет',
            'accommodations_mapping' => 'Картирование номеров',
            'no_association' => 'Нет ассоциации',
        ],
        'messages' => [
            'accommodation_mapping' => 'От :origin до :destination',
        ],
        'warnings' => [
            'missing_dates_updates' => 'Не удалось синхронизировать данные для следующих периодов: ',
        ],
    ],

    'mail_channels_errors' => [
        'ses' => [
            'missing_required_fields_for_verfication' => 'Отсутствуют обязательные поля для проверки канала отправки',
            'existing_ses_identity' => 'Существующий адрес отправителя электронной почты',
            'configuration_set' => [
                'AlreadyExistsException' => 'Набор конфигурации уже существует',
                'NotFoundException' => 'Набор конфигурации не найден',
                'TooManyRequestsException' => 'Достигнут лимит запросов для создания набора конфигурации',
                'LimitExceededException' => 'Достигнут лимит экземпляров для запрашиваемого набора конфигурации',
                'BadRequestException' => 'Недействительный набор конфигурации',
                'ConcurrentModificationException' => 'Набор конфигурации был изменен другой инстанцией',
            ],
            'send_bulk_email' => [
                'TooManyRequestsException' => 'Достигнут лимит запросов для отправки электронной почты',
                'LimitExceededException' => 'Достигнут лимит экземпляров для отправки электронной почты',
                'AccountSuspendedException' => 'Электронная почта не может быть отправлена, поскольку возможность отправки писем на аккаунте была permanently ограничена',
                'SendingPausedException' => 'Электронная почта не может быть отправлена, поскольку возможность отправки писем на аккаунте в данный момент приостановлена',
                'MessageRejected' => 'Электронная почта не может быть отправлена, поскольку она содержит недопустимый контент',
                'MailFromDomainNotVerifiedException' => 'Электронная почта не может быть отправлена, поскольку домен отправки не подтвержден',
                'NotFoundException' => 'Ресурс для отправки электронной почты не найден',
                'BadRequestException' => 'Неверный ввод для отправки электронной почты',
            ],
            'configuration_set_event_destination' => [
                'AlreadyExistsException' => 'Событие назначения уже существует',
                'NotFoundException' => 'Событие назначения не найдено',
                'TooManyRequestsException' => 'Достигнут лимит запросов для создания события назначения',
                'LimitExceededException' => 'Достигнут лимит экземпляров для запрашиваемого события назначения',
                'BadRequestException' => 'Недействительное событие назначения',
            ],
            'configuration_set_attributes' => [
                'NotFoundException' => 'Невозможно установить атрибуты конфигурации, поскольку набор не найден',
                'TooManyRequestsException' => 'Достигнут лимит запросов для установки атрибутов конфигурации',
                'BadRequestException' => 'Неверные атрибуты конфигурации',
            ],
        ],
    ],

    'mail_channels' => [
        'fields' => [
            'host' => 'Хост',
            'port' => 'Порт',
            'username' => 'Имя пользователя',
            'password' => 'Пароль',
            'email_from' => 'Отправитель письма',
            'secure' => 'TLS\SSL',
            'domain_email' => 'Email отправителя',
        ],
        'choices' => [
            'ssl' => 'SSL',
            'tls' => 'TLS',
        ],
        'errors' => [
            'missing_required_fields_for_verfication' => 'Отсутствуют обязательные поля для проверки канала отправки',
            'existing_ses_identity' => 'Существующий адрес отправителя электронной почты',
        ],
        'channels_name' => [
            1 => 'SMTP',
            2 => 'Beddy - Почтовый сервис',
        ],
    ],

    'meals' => [
        'breakfasts' => 'Завтраки',
        'lunches' => 'Ужины',
        'dinners' => 'Ужины',
        'note' => 'Примечания',
    ],

    'messages' => [
        'download_attachments' => 'Скачать вложения',
    ],

    'newsletters_conditions' => [
        'errors' => [
            'validation_error' => 'Тип переданного значения для функции \':feature\' должен быть типа \':type\'',
            'duplicate_condition_error' => 'Условие \':criteriaName\' уже связано с отправочным списком',
            'limit_values_error' => 'Количество параметров, переданных для функции \':feature\', не совпадает с максимальным значением \':limitValues\'',
            'condition_not_found' => 'Условие не найдено в списке',
            'option_relation_error' => 'Выбранный параметр с id \':option\' отсутствует для функции \':feature\'',
            'unsuitable_condition_for_sending_list_category' => 'Критерий \':criteriaName\' несовместим с типом списка рассылки.',
        ],
    ],

    'newsletters_criteria' => [
        'field_translate' => [
            'country' => 'Страна',
            'city' => 'Город',
            'county' => 'Область',
            'state' => 'Регион',
            'check_phone_number' => 'Необходимо ли, чтобы гости указали свой номер телефона?',
            'check_newsletter_consent' => 'Должны ли пользователи дать согласие на получение новостных рассылок?',
            'check_newsletter_unsubscribe' => 'Пользователи, отписавшиеся от новостных рассылок?',
            'language' => '',
            'check_reservation_with_children' => 'Должны ли гости забронировать номер с детьми?',
            'addon' => '',
            'last_reservation_date' => '',
            'birthdays_date' => '',
            'reservation_period_date' => '',
            'reservation_stay_period_date' => '',
            'guests_in_house' => 'Вы хотите выбрать всех гостей, находящихся в доме?',
            'accommodation' => '',
            'channel' => '',
            'reservation_tag' => '',
            'category_addon' => '',
        ],
        'criteria_translate' => [
            'place' => 'Место проживания',
            'company_place' => 'Сайт',
            'phone_number' => 'Телефон',
            'newsletter_consent' => 'Согласие на получение новостных рассылок',
            'newsletter_unsubscribed' => 'Отписавшиеся от новостных рассылок',
            'language' => 'Язык',
            'reservation_with_children' => 'Бронирования с детьми',
            'reservation_with_extra_services' => 'Бронирование с дополнительными услугами',
            'last_reservation_year' => 'Год последнего бронирования',
            'birthdays' => 'Дни рождения',
            'reservation_period' => 'Период бронирования',
            'reservation_stay_period' => 'Период проживания',
            'customers_at_home' => 'Гости в доме',
            'type_of_room_booked' => 'Тип забронированного номера',
            'booking_portal' => 'Портал для бронирования',
            'reservation_tag' => 'Метка',
            'addon_category' => 'Категория дополнительных услуг',
        ],
        'field_translate_error' => [
            'country' => 'Страна',
            'city' => 'Город',
            'county' => 'Область',
            'state' => 'Регион',
            'check_phone_number' => 'Согласие на номер телефона',
            'check_newsletter_consent' => 'Согласие на рассылку новостей',
            'language' => 'Язык',
            'check_reservation_with_children' => 'Бронирования с детьми',
            'addon' => 'Дополнительные услуги',
            'last_reservation_date' => 'Год последнего бронирования',
            'birthdays_date' => 'Дата рождения',
            'reservation_period_date' => 'Период бронирования',
            'check_actual_reservations' => 'Гости в доме',
            'accommodation' => 'Тип забронированного номера',
            'channel' => 'Портал для бронирования',
            'reservation_tag' => 'Метка',
        ],
    ],

    'newsletters' => [
        'import' => [
            'validations' => [
                'email_not_valid' => 'Поле email не содержит действительный адрес электронной почты',
                'email_required' => 'Поле email является обязательным',
            ],
        ],
        'errors' => [
            'newsletter_task_in_error' => 'Общая ошибка отправки. Дублируйте кампанию и повторите отправку через несколько минут.',
            'newsletter_without_contacts' => 'В выбранных списках рассылки не найдено контактов, измените условия добавления контактов или выберите другие списки.',
            'impossible_delete_attempted_newsletter' => 'Невозможно удалить рассылку, так как уже были произведены отправки',
            'cant_update_sent_newsletter' => 'Невозможно изменить выбранную рассылку, так как она уже была отправлена. Вы можете только дублировать её и архивировать.',
            'newsletter_in_processing' => 'Невозможно изменить статус выбранной рассылки, так как она в обработке.',
            'contact_already_exist' => 'Невозможно добавить контакт, так как он уже присутствует в списке рассылки.',
            'contact_already_exclude' => 'Невозможно добавить контакт, так как он уже был исключен из списка рассылки.',
            'sending_list_contact_not_valid' => 'Следующие параметры контакта недействительны: ',
            'missing_newsletter_contact' => 'Запрашиваемый контакт отсутствует или не имеет установленного адреса электронной почты.',
            'elaborated_newsletter' => 'Невозможно изменить или удалить выбранную рассылку, так как она в обработке или была отправлена.',
            'missing_newsletter' => 'Выбранная рассылка отсутствует.',
            'missing_default_locale' => 'HTML-шаблон на языке по умолчанию отсутствует среди отправленных шаблонов.',
            'missing_default_configuration' => 'Для создания рассылки требуется активная конфигурация по умолчанию, проверьте и попробуйте снова.',
            'configuration_not_expired' => 'Невозможно перепроверить конфигурацию, если она не истекла или не ожидает подтверждения.',
            'configuration_not_found' => 'Выбранная конфигурация отсутствует.',
            'configuration_not_active' => 'Отправитель еще не был подтвержден.',
        ],
        'warnings' => [
            'cant_delete_sending_list' => 'Невозможно удалить выбранный список рассылки, так как он связан со следующими рассылками: :newslettersTitles',
            'cant_delete_configuration_with_newsletters' => 'Невозможно удалить конфигурацию, так как она связана со следующими неотправленными или запланированными рассылками: ',
            'cant_delete_configuration' => 'В данный момент невозможно удалить конфигурацию из-за технических проблем. Попробуйте позже.',
            'cant_delete_blocked_configuration' => 'Невозможно удалить заблокированную конфигурацию.',
            'cant_delete_pending_configuration' => 'Для удаления этой конфигурации, ожидающей подтверждения, необходимо дождаться истечения срока запроса (24 часа после его отправки).',
            'existing_configuration' => 'Существует конфигурация с такими же параметрами.',
            'uneditable_options' => 'Канал отправки не позволяет редактировать поля. Для их изменения удалите и создайте новую конфигурацию.',
            'uneditable_channels' => 'Канал отправки конфигурации нельзя изменить.',
            'cant_active' => 'Конфигурация была сохранена, но не может быть активирована по следующим причинам: :errors',
        ],
        'unsubscribe_from_newsletter' => 'Отписаться от рассылки',
    ],

    'odigeo' => [
        'exceptions' => [
            'configuration_missing' => 'Отсутствуют необходимые параметры конфигурации для канала :channelName в запросе',
            'configuration_not_valid' => 'Следующие параметры недействительны: :params',
            'invalid_age_range' => 'Диапазон возраста для :field недействителен. Убедитесь, что возрастные группы правильные и в правильном порядке.',
        ],
    ],

    'pa_friuli_venezia_giulia' => [
        'accommodation_name' => 'Проживание',
        'accommodation_tableau_name' => 'Комната',
        'check_in' => 'Регистрация заезда',
        'check_out' => 'Регистрация выезда',
        'nights' => 'Ночи',
        'surname_and_name' => 'Фамилия и имя',
        'date_of_birth' => 'Дата рождения',
        'citizenship' => 'Гражданство',
        'residence' => 'Место жительства',
    ],

    'payment_method' => [
        'fields' => [
            'model_name' => 'Метод оплаты',
        ],
        'paypal' => [
            'cannot_activate_paypal' => 'Не удается активировать PayPal, проверьте правильность Client ID и Secret.',
        ],
        'nexi' => [
            'cannot_activate_nexi' => 'Не удается активировать Nexi, проверьте правильность Alias и MAC ключа.',
        ],
    ],

    'payments' => [
        'default_payment_email_body' => '<p>Уважаемый :name :surname,</p><p>В приложении вы найдете документ, относящийся к вашему платежу</p>',
        'default_payment_email_subject' => 'Уведомление о платеже',
        'cannot_complete_payment_due_to_gateway' => 'Шлюз платежа не смог успешно завершить операцию',
        'payment_order_cannot_be_completed_due_to_wrong_status' => 'Статус платежа уже завершен',
        'payment_order_is_not_a_pre_authorization' => 'Этот платеж не является предварительной авторизацией',
        'cannot_complete_payment_gateway_requires_action' => 'Запрос был успешно отправлен. Вы получите уведомление, когда платеж будет завершен.',
        'payment' => 'платеж',
        'refund_payment' => 'Возврат платежа от :customer_name :customer_surname от :payment_date',
        'checkinonline_created_order_citytax' => 'Оплата городского налога через Онлайн-регистрацию',
        'pre_authorization_text' => 'Предварительная авторизация',
        'email_payment_request' => [
            'subject' => 'Запрос на оплату от :propertyName',
            'message' => '<p>Уважаемый <strong>:name :surname</strong>,</p><p>Для вашего бронирования номер <strong>#:reference_number</strong> был запрашиваем следующий платеж.</p>',
            'message_without_reservation' => '<p>Уважаемый <strong>:name :surname</strong>, был запрашиваем следующий платеж.</p>',
            'confirm_payment' => 'Оплатить сейчас :amount',
        ],
        'email_pre_authorization_request' => [
            'subject' => 'Запрос на предварительную авторизацию от :propertyName',
            'message' => '<p>Уважаемый <strong>:name :surname</strong></p><p>Для вашего бронирования номер <strong>#:reference_number</strong> была выполнена следующая предварительная авторизация.</p>',
            'message_without_reservation' => '<p>Уважаемый <strong>:name :surname</strong>, была выполнена следующая предварительная авторизация.</p>',
        ],
        'pre_authorization' => [
            'subject' => 'Предварительная авторизация от :propertyName',
            'message' => '<p>Уважаемый <strong>:name :surname</strong>,</p><p>Для вашего бронирования номер <strong>#:reference_number</strong> была запрашиваем следующая предварительная авторизация.</p>',
        ],
        'direct_charge' => [
            'subject' => 'Прямое списание от :propertyName',
            'message' => '<p>Уважаемый <strong>:name :surname</strong></p><p>Для вашего бронирования номер <strong>#:reference_number</strong> было выполнено следующее списание.</p>',
        ],
        'direct_charge_failed' => [
            'subject' => 'Прямое списание от :propertyName не удалось',
            'message' => '<p>Уважаемый <strong>:name :surname</strong></p><p>Мы информируем вас, что сегодня мы пытались произвести списание по бронированию <strong>#:reference_number</strong>. Однако нам не удалось произвести это списание.</p>',
        ],
        'payment_order' => [
            'default_whatsapp_text' => 'Уважаемый :name :surname, для вашего бронирования номер :reference_number был отправлен запрос на :type, нажмите здесь :link',
        ],
        'customer_confirmed_payment_order_notification' => [
            'subject' => 'Получен платеж в размере :amount от :customerName :customerSurname - :propertyName',
            'message' => 'Сообщаем вам, что :customerName :customerSurname произвел платеж в размере :amount за бронирование # :referenceNumber (:arrivalDate - :departureDate) - :propertyName',
            'click_here_to_view' => 'Чтобы просмотреть все детали бронирования, нажмите здесь',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'subject' => 'Клиент завершил платеж',
            'message' => 'Сообщаем вам, что :customerName :customerSurname произвел платеж в размере :amount - :propertyName',
        ],
        'pre_authorization_is_expiring' => [
            'subject' => 'Ваша предварительная авторизация истекает',
            'message' => 'Сообщаем вам, что :customerName :customerSurname еще не подтвердил предварительную авторизацию, которая истекает завтра на сумму :amount для бронирования # :referenceNumber (:arrivalDate - :departureDate) - :propertyName',
            'message_without_reservation' => 'Сообщаем вам, что :customerName :customerSurname еще не подтвердил предварительную авторизацию, которая истекает завтра на сумму :amount - :propertyName',
        ],
        'timetable' => [
            'title' => 'Запланированные платежи',
            'export_fields' => [
                'scheduled_date' => 'Дата платежа',
                'booker' => 'Бронирующий',
                'reservation_total_price' => 'Общая стоимость бронирования',
                'amount' => 'Запланированный платеж',
                'reservation_arrival_date' => 'Дата заезда',
                'reservation_departure_date' => 'Дата выезда',
                'property' => 'Структура',
                'sca_accepted' => 'Статус SCA',
            ],
            'sca_accepted' => 'Принято',
            'sca_not_accepted' => 'Не принято',
            'change_status_date_past' => 'Невозможно запланировать дату платежа в прошлом.',
            'no_credit_card_found' => 'Не найдена кредитная карта в бронировании',
            'required_action_3d' => 'Платеж не удался, требуется аутентификация 3D Secure',
            'required_action_requested_payment' => 'Запрос на оплату отправлен :send_date - срок :expire_date',
            'request_payment_wait_customer_expired' => 'Запрос на оплату истек',
            'timetable_pause_expired' => 'Запланированный платеж в паузе истек',
            'force_payment_due_date' => 'Платеж может быть принудительно выполнен только если дата платежа совпадает с сегодняшней датой',
            'reservation_cancelled' => 'Бронирование отменено',
            'property_cancelled' => 'Структура приостановлена, истекла или отменена',
            'module_deactivated' => 'Модуль Запланированные платежи был деактивирован или истек',
            'charge_status_manual_change' => 'Платеж изменен с :current_charge_status на :new_charge_status',
            'manual_payment_bound' => 'Ручной платеж добавлен',
            'stripe_not_active' => 'Метод оплаты Stripe не активирован',
            'invoice_default_causal' => 'Списано с платежа :payment_method_name от :date для бронирования :reservation_reference',
            'delete_propery_has_payments' => 'Структура имеет активные запланированные платежи. При продолжении все запланированные платежи будут приостановлены. Операция необратима',
            'amount_over_to_pay' => 'Платеж превышает общую сумму, подлежащую оплате по бронированию',
            'change_tax_payment_amount' => 'Сумма налога на пребывание изменена с :old_amount на :new_amount',
            'manual_payment_cancelled' => 'Отменен вручную добавленный платеж',
            'payment_refunded_created' => 'Выполнен возврат :currency_symbol :amount',
            'payment_refunded_modified' => 'Изменен возврат с :currency_symbol :old_amount на :currency_symbol :new_amount',
            'reservation_reconfirmed' => 'Бронирование подтверждено',
            'reservation_optionable' => 'Бронирование в опции',
            'reservation_pending' => 'Бронирование ожидает подтверждения',
            'payment_succeded' => 'Платеж выполнен',
            'charge_reminder_email_sent' => 'Отправлено напоминание о платеже',
            'charge_reminder' => [
                'subject' => ':propertyName - Напоминание о платеже',
                'message' => 'Уважаемый :booker_name :booker_surname, 
            <br /><br />
            В дату :date_today, ожидается списание :amount :currency_symbol, согласно условиям оплаты. 
            <br /><br />  
            <strong><span style="color: #8f743f;">Бронирование номер #:reference_number с :arrival_date по :departure_date.</strong>',
            ],
        ],
        'errors' => [
            'conditions_with_conflicts' => 'Переданные условия имеют одинаковые дни списания ночей или общая сумма процентов списания превышает 100% стоимости',
            'payment_timetable_already_processed' => 'Платеж по расписанию уже обработан или в ожидании',
            'payment_timetable_already_bound' => 'Платеж по расписанию уже привязан к платежу',
            'payment_timetable_attach_email_invoice_error' => 'Не удалось прикрепить запрашиваемый клиентом счет к платежу из-за следующей ошибки: :error_description',
            'missing_policy' => 'Политика платежа не найдена для бронирования',
            'impossible_change_payment_method_id' => 'Невозможно изменить способ оплаты для зарегистрированных платежей',

        ],
        'warnings' => [
            'no_restrictions_and_period_policy' => 'Политика платежа не имеет ограничений и/или периодов применения, что может вызвать конфликт с другими существующими',
            'no_restrictions_and_period_others' => 'Политика :name не имеет ограничений или периодов применения и может вызвать конфликт с текущей политикой',
            'overlapping_period_for_restriction' => 'Политика :name имеет хотя бы один период, перекрывающийся с ограничением, что может вызвать конфликт',
            'existing_restriction' => 'Политика :name имеет хотя бы одно ограничение, которое может вызвать конфликт с текущей политикой',
        ],
        'fields' => [
            'payment_agreement_id' => 'идентификатор соглашения о платеже'
        ],
    ],

    'policy' => [
        'errors' => [
            'no_show_option_not_compatible' => 'Опции no_show несовместимы',
            'deposit_option_not_compatible' => 'Опции депозита несовместимы',
            'choose_deposit_pay' => 'Необходимо выбрать, когда произвести списание',
            'condition_not_compatible' => 'Условия отмены несовместимы',
            'duplicate_penalty' => 'Дублирующиеся штрафы в условиях отмены',
            'no_show_condition_not_applicable' => 'Вы не можете применить эти условия к no_show',
            'deposit_condition_not_applicable' => 'Вы не можете применить эти условия к депозиту',
            'duplicate_penalty_deposit' => 'Дублирующиеся штрафы в разделе депозита',
            'no_condition_to_deposit' => 'Не применены условия к депозиту',
            'policy_to_rateplan' => 'Политика связана с хотя бы одним тарифным планом',
            'delete_policy_default' => 'Вы не можете удалить стандартные политики',
            'last_policy' => 'Невозможно удалить последнюю политику структуры',
            'policy_not_allowed_in_period' => 'Вы не можете перезаписать период с теми же условиями тарифа.',
            'policy_period_overlapping' => 'Периоды для политик пересекаются.',
            'check_priority_custom' => 'Есть приоритеты для политики, проверьте их правильность.',
            'check_priority_and_period' => 'Есть приоритеты или периоды для политики.',
        ],
        'names' => [
            'standard' => 'Бесплатная отмена',
            'not_ref' => 'Не возвращается',
            'default_ota_name' => 'См. OTA',
            'default_ota_description' => 'Политика не отправлена каналом',
            'hour_title_policy' => ' до :hour дня прибытия.',
            'nights' => 'ночь|ночи',
            'days' => 'день|дни',
        ],
        'transform_to_date' => [
            'date_limit' => '<p>Вы можете отменить бесплатно до 23:59 :date_limit.</p>',
            'date_limit_percentage' => '<p>Если вы отмените до :date_limit, с вас будет удержано :penalty_value% от общей стоимости.</p>',
            'date_limit_nights' => '<p>Если вы отмените до :date_limit, с вас будет удержана стоимость :penalty_value ночей.</p>',
            'date_limit_amount' => '<p>Если вы отмените до :date_limit, с вас будет удержана сумма :penalty_value :currency.</p>',
            'date_over_percentage' => '<p>Если вы отмените после :date_limit, с вас будет удержано :penalty_value% от общей стоимости.</p>',
            'date_over_nights' => '<p>Если вы отмените после :date_limit, с вас будет удержана стоимость :penalty_value ночей.</p>',
            'date_over_amount' => '<p>Если вы отмените после :date_limit, с вас будет удержана сумма :penalty_value :currency.</p>',
            'date_over_percentage_hour' => '<p>Если вы отмените после :hour_limit :date_limit, с вас будет удержано :penalty_value% от общей стоимости.</p>',
            'date_over_nights_hour' => '<p>Если вы отмените после :hour_limit :date_limit, с вас будет удержана стоимость :penalty_value ночей.</p>',
            'date_over_amount_hour' => '<p>Если вы отмените после :hour_limit :date_limit, с вас будет удержана сумма :penalty_value :currency.</p>',
            'date_now_percentage' => '<p>Если вы отмените сейчас, с вас будет удержано :penalty_value% от общей стоимости.</p>',
            'date_now_nights' => '<p>Если вы отмените сейчас, с вас будет удержана стоимость :penalty_value ночей.</p>',
            'date_now_amount' => '<p>Если вы отмените сейчас, с вас будет удержана сумма :penalty_value :currency.</p>',
            'date_now_noshow_percentage' => '<p>В случае неявки с вас будет удержано :penalty_value% от общей стоимости.</p>',
            'date_now_noshow_nights' => '<p>В случае неявки с вас будет удержана стоимость :penalty_value ночей.</p>',
            'date_now_noshow_amount' => '<p>В случае неявки с вас будет удержана сумма :penalty_value :currency.</p>',
        ],
        'transform_to_date_notref' => [
            'date_now_percentage' => '<p>Если вы отмените в любое время после бронирования, с вас будет удержано :penalty_value% от общей стоимости.</p>',
            'date_now_nights' => '<p>Если вы отмените в любое время после бронирования, с вас будет удержана стоимость :penalty_value ночей.</p>',
            'date_now_amount' => '<p>Если вы отмените в любое время после бронирования, с вас будет удержана сумма :penalty_value :currency.</p>',
            'date_limit_percentage' => '<p>Если вы отмените до :hour_limit :date_limit, с вас будет удержано :penalty_value% от общей стоимости.</p>',
            'date_limit_nights' => '<p>Если вы отмените до :hour_limit :date_limit, с вас будет удержана стоимость :penalty_value ночей.</p>',
            'date_limit_amount' => '<p>Если вы отмените до :hour_limit :date_limit, с вас будет удержана сумма :penalty_value :currency.</p>',
            'date_now_deposit_percentage' => '<p>С вас будет удержано :penalty_value% от общей стоимости в момент бронирования.</p>',
            'date_now_deposit_nights' => '<p>С вас будет удержана стоимость :penalty_value ночей в момент бронирования.</p>',
            'date_now_deposit_amount' => '<p>С вас будет удержана сумма :penalty_value :currency в момент бронирования.</p>',
            'date_now_noshow_percentage' => '<p>В случае неявки с вас будет удержано :penalty_value% от общей стоимости.</p>',
            'date_now_noshow_nights' => '<p>В случае неявки с вас будет удержана стоимость :penalty_value ночей.</p>',
            'date_now_noshow_amount' => '<p>В случае неявки с вас будет удержана сумма :penalty_value :currency.</p>',
        ],
    ],

    'property_report' => [
        'property' => [
            'label' => 'Структура',
            'description' => 'Эта опция позволяет экспортировать данные структуры',
        ],
        'children_ranges' => [
            'label' => 'Возрастные группы детей',
            'description' => 'Эта опция позволяет экспортировать возрастные группы для детей',
        ],
        'accommodations' => [
            'label' => 'Проживание',
            'description' => 'Эта опция позволяет экспортировать информацию о номерах с соответствующими деталями',
        ],
        'treatments' => [
            'label' => 'Услуги',
            'description' => 'Эта опция позволяет экспортировать данные о предоставляемых услугах',
        ],
        'policies' => [
            'label' => 'Политики отмены',
            'description' => 'Эта опция позволяет экспортировать условия отмены',
            'addons_to_deposit' => [
                'included' => 'Дополнительные услуги включены',
                'not_included' => 'Дополнительные услуги не включены в расчет',
            ],
        ],
        'rate_plans' => [
            'label' => 'Тарифные планы',
            'description' => 'Эта опция позволяет экспортировать тарифные планы',
        ],
        'invoice_layouts' => [
            'label' => 'Профили выставления счетов',
            'description' => 'Эта опция позволяет экспортировать профили для выставления счетов',
        ],
        'city_tax' => [
            'label' => 'Городской налог',
            'description' => 'Эта опция позволяет экспортировать настройки городского налога',
            'active' => 'Активно',
            'not_active' => 'Неактивно',
        ],
        'payments_method' => [
            'label' => 'Методы оплаты',
            'description' => 'Эта опция позволяет экспортировать настройки методов оплаты',
            'day' => '{0,1} день|[2,*] дней',
        ],
    ],

    'property' => [
        'errors' => [
            'already_attached' => 'Прикрепление уже существует',
            'property_has_another_master' => 'У структуры уже есть главный пользователь. Для продолжения удалите связь с этим пользователем',
            'letti_extra_exception_delete' => 'Невозможно удалить эту дополнительную кровать, так как сначала необходимо удалить кровать с номером :lettimax, а не изменить номер :lettimin',
            'letti_extra_exception_missing' => 'Некоторые элементы отсутствуют',
            'override_periods_policy' => 'Перекрытые периоды',
            'place_not_found' => 'Место не найдено',
            'not_group_owner' => 'Вы не являетесь владельцем этой группы',
            'group_is_default' => 'Невозможно удалить группу по умолчанию',
            'already_in' => 'Структура уже в группе, невозможно продолжить',
            'already_all_in' => 'Структура уже есть в одной из ваших групп, невозможно продолжить',
            'not_in_group' => 'Структура не в группе',
            'existing_extra_bed_setting' => 'Настройка дополнительной кровати уже существует',
            'missing_extra_bed_setting' => 'Отсутствует настройка дополнительной кровати для этой',
            'overcoming_extra_bed' => 'Дополнительная кровать в избытке по отношению к существующей настройке комнат',
            'role_conflict' => 'Роль уже существует',
            'cant_detach_default_group' => 'Невозможно отсоединить структуру от группы по умолчанию',
            'groups_have_properties' => 'Невозможно удалить эту группу, так как в ней есть структуры',
            'uneditable_expense_category' => 'Категория расходов не поддается изменению',
            'expenses_pending' => 'Категория расходов не может быть удалена из-за связанных расходов',
            'missing_vat_quotes' => 'Внимание! Выбранная страна не имеет настроенных ставок НДС. Настройте их перед продолжением',
            'cutoff_rules_exist' => 'Правило cutoff уже существует.',
            'missing_lat_lon' => 'Не установлены координаты (LAT или LON) для этой структуры',
            'undetachable_layout' => 'Невозможно отсоединить этот профиль, если у вас нет хотя бы одного другого профиля',
            'customer_not_belonging_to_property_group' => 'Клиент :customer_id не принадлежит группе структур или не существует',
            'update_expiration_bulk' => 'Ошибка при обновлении сроков',
            'update_cancellation_bulk' => 'Ошибка при обновлении состояния отмены',
            'update_activation_bulk' => 'Ошибка при обновлении состояния активации/деактивации',
            'unauthorized_access' => 'У вас нет прав для доступа к этому ресурсу.',
            'unauthorized_insolvent_status' => 'Ваш аккаунт был заблокирован из-за неоплаты. Пожалуйста, свяжитесь с "zucchettihospitality.gestione.crediti@zucchetti.it", чтобы урегулировать вашу бухгалтерскую ситуацию.'
        ],
        'warnings' => [
            'request_confirm_change_discount_type' => 'Изменение типа скидки приведет к удалению всех пользовательских настроек. Продолжить?',
            'request_confirm_delete_extra_bed' => 'Удаление этой дополнительной кровати приведет к удалению последующих дополнительных кроватей. Продолжить?',
            'invalid_facility' => 'Неподходящая услуга',
            'disabled_update' => 'Канал :channel_name не активирован для отправки данных',
            'nothing_to_update' => 'Нет данных для отправки на :channel',
            'missing_invoice_layout_without_vat_code_with_all_inclusive_tax_enabled' => 'Внимание! Активированная структура не имеет подходящего профиля для выставления счетов для применения "cedolare secca"',
            'properties_has_not_istat_module' => 'Структура :property_name не имеет активированного модуля Istat',
            'update_overcome_days' => 'Следующие даты не были обновлены, так как они превышают максимальный лимит дней: :dates',
            'download_overcome_days' => 'Данные для следующих дат не были загружены, так как они превышают максимальный лимит дней: :dates',
            'missing_property_xml_id' => 'Внимание! Не был указан property_xml_id в настройках канала :channel_name',
        ],
        'city_tax' => [
            'main_report_title' => 'Общий отчет по налогу на проживание',
            'recap_city_tax_totals' => 'Общий итог по налогу на проживание',
            'exemptions' => 'Освобождения',
            'limit_nights' => 'Лимит ночей',
            'total_guests' => 'Общее количество гостей',
            'totals' => 'Итого',
            'total_taxed_guests' => 'Гости с налогообложением',
            'total_exempted_guests' => 'Гости, освобожденные от налога',
            'exemption_details' => 'Детали освобождений',
            'taxed_details' => 'Детали налогообложения',
            'taxed_details_ranges' => 'От :min до :max лет',
            'exemptions_over' => 'Освобождено сверх лимита',
            'guests_over' => 'Гости сверх лимита',
            'guests' => 'Гости',
            'city_tax_amount' => 'Общий налог на проживание',
            'all_properties' => 'Все структуры',
            'from_to_age_ranges' => 'От :min_age до :max_age лет',
            'taxed_nights' => 'Ночлеги гостей с налогообложением',
        ],
        'commissions' => [
            'period_exists' => 'Период уже существует',
            'invalid_period' => 'Неверный период',
            'season_too_long' => 'Слишком длинный сезонный период',
        ],
        'list' => 'Список структур',
        'export_fields' => [
            'id' => 'ID',
            'name' => 'Название',
            'group' => 'Группа',
            'address' => 'Адрес',
            'city' => 'Город',
            'state' => 'Область',
            'county' => 'Район',
            'country' => 'Страна',
            'zip_code' => 'Почтовый индекс',
            'type' => 'Тип',
            'email' => 'Электронная почта',
            'telephone' => 'Телефон',
            'reference_name' => 'Имя контактного лица',
            'reference_surname' => 'Фамилия контактного лица',
            'reference' => 'Контактное лицо',
            'modules' => 'Модули',
            'activated_date' => 'Дата активации',
            'expire_date' => 'Дата окончания',
            'status' => 'Статус',
            'user_first_name' => 'Имя владельца',
            'user_last_name' => 'Фамилия владельца',
            'user' => 'Владелец',
            'user_email' => 'Электронная почта владельца',
            'resellers' => 'Перепродавцы',
            'business_name' => 'Юридическое название',
            'vat_number' => 'Номер НДС',
            'fiscal_code' => 'Фискальный код',
            'properties_modules' => 'Модули структур',
            'accommodations' => 'Номера',
            'quantity' => 'Количество',
            'contacts' => 'Контакты',
        ],
        'initials_name' => [
            'booking-engine' => 'BE',
            'channel-manager' => 'CM',
            'rate-checker' => 'RC',
            'brand-protection' => 'BP',
            'google-ads' => 'GA',
            'google-commission' => 'GC',
            'tripadvisor-istant-booking' => 'TIB',
            'trivago-fast-connect' => 'TFC',
            'booking-engine-quotes' => 'BEQ',
            'guests-reporting' => 'GR',
            'pms' => 'PMS',
            'newsletter' => 'CRM',
            'automatic-payments' => 'AP',
        ],
        'clone' => [
            'cloning-job-scheduled' => 'Клонирование будет выполнено в ближайшее время, проверьте через несколько минут.',
        ],
        'not_found' => 'Следующие ID не существуют: ',
        'log'  => [
            'property_module_enabled' => 'Модуль объекта включен',
            'property_module_disabled' => 'Модуль объекта отключен',
            'beddy_channel_disabled' => 'Канал Beddy отключен',
            'beddy_channel_enabled' => 'Канал Beddy включен',
            'property_disactivated' => 'Объект деактивирован',
            'property_activated' => 'Объект активирован',
            'property_cancelled' => 'Отмена зарегистрирована для объекта',
            'property_cancellation_reversed' => 'Отмена аннулирования зарегистрирована для объекта',
            'property_update_expiration_date' => 'Срок действия контракта объекта обновлен',
        ],
        'treatment' => [
            'log' => [
                'attach' => 'К лечению :treatment_name были привязаны объекты :property_names с доплатой :supplement_price и изменением цены :share_price. :children_detail :apply_past',
                'children_detail' => ' Для возрастной группы :age_range установлена доплата :supplement_price и изменение цены :share_price.',
                'apply_past' => ' Конфигурация была распространена на бронирования, сделанные в период с :from по :to',
                'detach' => 'Лечение :treatment_name было отвязано от объекта :property_name',
                'update' => 'Лечение :treatment_name было обновлено с доплатой :supplement_price и изменением цены :share_price. :children_detail :children_delete :detail_delete',
                'detail_delete' => 'Изменение цены было сброшено по сравнению с предыдущим, поэтому все ранее связанные детали были удалены',
            ],
        ],
    ],

    'push_notifications' => [
        'multiple_sessions' => [
            'title' => 'Предупреждение безопасности: несколько устройств подключены к вашей учетной записи',
            'message' => 'Обнаружены подключения с нескольких устройств к вашей учетной записи. Пожалуйста, проверьте активные сессии.',
        ],
        'reservation_new' => [
            'title' => 'Новая бронь от :channel_name (:name_surname).',
            'message' => ':name_surname забронировал(а) жилье :accommodation_name в :property_name с :arrival_date по :departure_date.',
        ],
        'reservation_modified' => [
            'title' => 'Изменение бронирования от :name :surname через :channel_name.',
            'message' => 'Бронирование :name :surname было изменено с :arrival_date по :departure_date для жилья :accommodation_name в :property_name.',
        ],
        'reservation_cancelled' => [
            'title' => 'Отмена бронирования от :name :surname через :channel_name.',
            'message' => 'Бронирование :name :surname с :arrival_date по :departure_date в :property_name было отменено.',
        ],
        'reservation_banktransfer_cancelled' => [
            'title' => 'Отмена бронирования от :name :surname через :channel_name из-за неудачной оплаты',
            'message' => 'Бронирование :name :surname с :arrival_date по :departure_date в :property_name было автоматически отменено.',
        ],
        'invoice_rejected' => [
            'title' => 'Счет :number_complete от :name :surname отклонен SDI.',
            'message' => 'Счет :number_complete от :name :surname был отклонен по следующей причине: :rejected_reason.',
        ],
        'invoice_received' => [
            'title' => 'Получен счет от :sender_name.',
            'message' => 'Получен счет номер :document_number от :document_date от :sender_name.',
        ],
        'checkin_online_complete' => [
            'title' => 'Онлайн-регистрация завершена (:name :surname).',
            'message' => 'Клиент :name :surname прошел онлайн-регистрацию для бронирования с :arrival_date по :departure_date для жилья :accommodation_name в :property_name.',
        ],
        'reservation_quote_expired' => [
            'title' => 'Срок действия предложения истек :name :surname.',
            'message' => 'Срок действия предложения для :name :surname, созданного :created_date, истек.',
        ],
        'housekeeper_maintainer' => [
            'title' => 'Новый запрос на техническое обслуживание для жилья :accommodation_name',
            'message' => 'Добавлен новый запрос на обслуживание для жилья :tableau_label. :title - :description',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'title' => 'Изменение статуса уборки для жилья :cleanable_name - :accommodation_name',
            'message' => ':user_name изменил статус уборки на :clean_status для жилья :cleanable_name (:accommodation_name) в :property_name на дату :reference_date.',
        ],
        'reservation_option_expired' => [
            'title' => 'Истек срок опции для бронирования :name :surname',
            'message' => 'Истекла опция для бронирования :name :surname с :arrival_date по :departure_date для жилья :accommodation_name в :property_name.',
        ],
        'order_payment_release' => [
            'subject' => 'Предавторизация снята (:name :surname).',
            'body' => 'Предавторизация оплаты для бронирования :name :surname с :arrival_date по :departure_date в :property_name была снята.',
        ],
        'sca_authorized' => [
            'title' => 'Модуль SCA подтвержден клиентом :name :surname.',
            'message' => 'Клиент :name :surname подтвердил модуль SCA на дату :accepted_date с IP-адреса :ip_address.',
        ],
        'customer_confirmed_payment_order_notification' => [
            'title' => 'Новый платеж получен от :name :surname.',
            'message' => 'Клиент :name :surname произвел платеж :amount за бронирование с :arrival_date по :departure_date в :property_name.',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'title' => 'Новый платеж получен от :name :surname.',
            'message' => 'Клиент :name :surname произвел платеж :amount.',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => 'Нет доступных мест для жилья :accommodation_name в :property_name.',
            'body' => 'Доступность для :accommodation_name на следующие даты закончилась: :days.',
        ],
        'reservation_queue_complete' => [
            'subject' => 'Бронирование :name :surname обработано.',
            'body' => 'Бронирование клиента :name :surname было успешно обработано.',
        ],
        'guests_reporting' => [
            'subject' => 'Отправка отчетов по гостям - :alloggiatiweb_group_label',
            'success' => '1 отчет отправлен успешно|:number отчетов отправлено успешно',
            'error' => '1 отчет не отправлен|:number отчетов не отправлены :errorMessage',
        ],
        'quote_request' => [
            'subject' => 'Новый запрос на предложение',
            'message' => ':customer_name :customer_surname только что отправил запрос на предложение для вашей структуры.',
        ],
        'treatment_price_update' => [
            'subject' => 'Обновлены цены на услуги - :property_name',
            'message' => 'Перерасчет с обновленными значениями с :start_date по :end_date для услуги :treatment_name завершен.',
        ],
        'queue_past_reservations_task_record_summary' => [
            'subject' => 'Резюме задачи обработки прошлых бронирований - :property_name (:property_id) канал :channel_name (:channel_id)',
            'message' => 'Обработано :reservations_elaborated из :reservations_total бронирований. Требуют действия :reservations_require_action бронирований.',
        ],
        'queue_past_reservations_task_error' => [
            'subject' => 'Ошибка задачи обработки прошлых бронирований - :property_name (:property_id) канал :channel_name (:channel_id)',
            'message' => 'Произошла ошибка при обработке очереди прошлых бронирований. Сообщение об ошибке :error_description.',
        ],
        'reservation_message_received' => [
            'title' => 'Новое сообщение от :senderName (#:reference)',
        ],
        'conversation_message_send_failed' => [
            'title' => 'Ошибка отправки сообщения',
            'message' => 'Сообщение, отправленное :recipientName, не было доставлено.',
        ],
        'urmet_sclak_error_generate_key' => [
            'title' => 'Ошибка создания ключей для бронирования :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Произошла ошибка на Sclak при генерации ключей для номеров: :errors. Повторите попытку вручную, если проблема сохранится, обратитесь в службу поддержки Urmet.',
        ],
        'nuki_error_generate_key' => [
            'title' => 'Ошибка создания PIN для бронирования :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Произошла ошибка на Nuki при генерации PIN для номеров: :errors. Повторите попытку вручную, если проблема сохранится, обратитесь в службу поддержки Nuki.',
        ],
        'urmet_sclak_error_sending_sms' => [
            'title' => 'Ошибка отправки SMS с ключами для бронирования :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Не удалось отправить SMS с ключами Sclak из-за ошибки. Рекомендуем обратиться в службу поддержки Urmet.',
        ],
        'single_property_export_completed' => [
            'title' => 'Экспорт :exportProviderName завершен',
            'message' => 'Файл :fileName готов для загрузки.',
        ],
        'single_property_export_not_completed' => [
            'title' => 'Экспорт :exportProviderName не удался',
            'message' => 'Экспорт, выполненный :date в :time, не удался.',
        ],
        'multi_property_export_completed' => [
            'title' => 'Экспорт :exportProviderName завершен',
            'message' => 'Файл :fileName готов для загрузки.',
        ],
        'multi_property_export_not_completed' => [
            'title' => 'Экспорт :exportProviderName не удался',
            'message' => 'Экспорт, выполненный :date в :time, не удался.',
        ],
        'newsletter_sent' => [
            'title' => 'Подтверждение отправки рассылки',
            'message' => 'Рассылка :newsletterName была успешно отправлена.',
        ],
        'newsletter_not_sent' => [
            'title' => 'Ошибка отправки рассылки',
            'message' => 'Не удалось отправить рассылку ":newsletterName" из-за следующих ошибок: :errorMessage.',
        ],
        'newsletter_exceeded_sent_limit' => [
            'title' => 'Превышен лимит отправок',
            'message' => 'Рассылка :newsletterName не была отправлена, так как превышен месячный лимит отправки писем.',
        ],
        'remote_door_key_service_reservation_resumed' => [
            'title' => 'Изменения в бронированиях, требуется генерировать новые ключи',
            'message' => 'Необходимо создать новый ключ для бронирования <b>:booker_name :booker_surname- :reference_number</b> в структуре <b>:property_name</b>',
        ],
        'remote_door_key_service_reservation_moved' => [
            'title' => 'Одно или несколько мест были перемещены. Необходимо создать новый ключ.',
            'message' => 'Одно или несколько мест для бронирования <b>:booker_name :booker_surname- :reference_number</b> в структуре <b>:property_name</b> были перемещены. Необходимо создать новый ключ.',
        ],
        'send_city_tax_report' => [
            'title' => 'Подтверждение отправки отчета по налогу на проживание',
            'message' => 'Отправка отчета по налогу на проживание для канала :channelName прошла успешно.',
        ],
        'send_city_tax_report_not_completed' => [
            'title' => 'Ошибка отправки отчета по налогу на проживание',
            'message' => 'Отправка отчета по налогу на проживание для канала :channelName не удалась.',
        ],
        'export_city_tax_report' => [
            'title' => 'Экспорт отчета по налогу на проживание для канала :channelName готов',
            'message' => 'Нажмите на уведомление, чтобы перейти на страницу истории экспорта.',
        ],
        'export_city_tax_report_not_completed' => [
            'title' => 'Не удалось завершить экспорт отчета по налогу на проживание для канала :channelName',
            'message' => 'Генерация отчета :reportId не удалась.',
        ],
        'guest_atrtributes_missing_in_city_tax_report' => [
            'title' => 'Ошибка отправки/экспорта отчета по налогу на проживание',
        ],
        'empty_city_tax_report' => [
            'title' => 'Ошибка отправки/экспорта отчета по налогу на проживание для канала :channelName',
            'message' => 'Отчет по налогу на проживание не был обработан, так как для выбранного периода не были извлечены данные по гостям для канала.',
        ],
        'accommodation_deleted' => [
            'title' => 'Необходимое действие',
            'message' => 'Количество доступных единиц жилья :accommodationName в структуре :propertyName уменьшилось. Чтобы избежать овербукинга, необходимо сбросить доступность.',
            'title' => 'Необходимое действие',
            'message' => 'Количество доступных единиц жилья :accommodationName в структуре :propertyName уменьшилось. Чтобы избежать овербукинга, необходимо сбросить доступность.',
        ],
        'payment_timetable_stripe_not_active' => [
            'title' => 'Неудачная автоматическая оплата - Stripe не активирован',
            'message' => 'Не удалось выполнить автоматическое списание по данному платежу, так как активный аккаунт Stripe не найден для проведения операции.',
        ],
        'payment_timetable_charge_failed' => [
            'title' => 'Неудачная автоматическая оплата',
            'message' => 'Не удалось провести автоматическое списание по данному платежу по следующей причине: :error_description.',
        ],
        'payment_timetable_no_credit_card' => [
            'title' => 'Неудачная автоматическая оплата - Карта не найдена',
            'message' => 'Не удалось провести автоматическое списание, так как не была указана карта для оплаты.',
        ],
        'payment_timetable_exceeded' => [
            'title' => 'Неудачная автоматическая оплата - Превышение суммы бронирования',
            'message' => 'Не удалось провести автоматическое списание, так как сумма оплаты превышает невыплаченную часть бронирования.',
        ],
    ],

    'quote_request' => [
        'email' => [
            'subject' => 'Запрос на предложение для :property_name - :customer_name :customer_surname (:arrival_date - :departure_date)',
            'quote_request_confermation' => 'Уважаемые <b>:property_name</b>,<br></br>
            <b>:customer_name :customer_surname</b> только что отправил запрос на предложение для вашей структуры.',
            'summary_request' => 'Резюме запроса:',
            'stay' => 'Пребывание',
            'name_surname' => 'Имя и фамилия',
            'telephone' => 'Телефон',
            'email' => 'Электронная почта',
            'from' => 'Заезд',
            'to' => 'Выезд',
            'alternative_dates' => 'Готов к альтернативным датам',
            'alternative_beds' => 'Готов к другим местам для сна',
            'yes' => 'Да',
            'no' => 'Нет',
            'accommodation' => 'Жилье',
            'accommodations' => 'Жилье',
            'night' => 'Ночь',
            'nights' => 'Ночи',
            'adults' => 'Взрослые',
            'children' => 'Дети',
            'eta_children' => 'Возраст детей',
            'button' => 'Нажмите здесь, чтобы просмотреть запрос',
        ],
        'email_customer' => [
            'subject' => 'Спасибо за ваш запрос :customer_name!',
            'message' => 'Спасибо, <b>:customer_name</b>,<br></br>Ваш запрос на предложение был успешно отправлен, мы свяжемся с вами в ближайшее время.',
        ],
    ],
    'rateplans' => [
        'errors' => [
            'max_day_update' => 'Невозможно удалить этот тариф, так как есть подключенные каналы.',
            'insert_periods_plan' => 'Невозможно вставить периоды в тарифный план.',
            'uneditable_rateplan' => 'Исходный тарифный план не может быть изменен.',
            'source_not_found' => 'На номере отсутствует исходная цена.',
            'detach_accommodations_channels' => 'Невозможно удалить этот тариф, так как есть подключенные каналы.',
            'multi_property_not_permitted' => 'Невозможно создать или изменить тарифы для нескольких объектов одновременно.',
            'rules_present_cannot_update' => 'Невозможно применить запрошенное изменение, так как с этим тарифным планом связаны активные правила.',
        ],
        'warnings' => [
            'missing_set_rules' => 'Не удалось установить правила для некоторых исходных каналов на существующие тарифные планы на целевых каналах.',
        ],
        'conflicts' => [
            'unsuitable_conditions' => 'Значения для условия :condition_from несовместимы с введенными значениями для условия :condition_to.',
            'conditions_not_formatted' => 'Условия неправильно отформатированы, отсутствует id.',
        ],
        'export_fields' => [
            'name' => 'Имя',
            'policy' => 'Политика возврата',
            'periods' => 'Периоды и дни действия',
            'accommodations' => 'Жилье',
        ],
    ],
    'rates' => [
        'errors' => [
            'max_day_update' => 'Невозможно обновить период более чем на год.',
            'no_rooms_to_clone' => 'Невозможно клонировать комнаты.',
            'no_rooms_to_clone_source' => 'Одна или несколько комнат/тарифов отсутствуют на исходном канале.',
            'no_rooms_to_clone_destination' => 'Одна или несколько комнат/тарифов отсутствуют на целевом канале.',
            'same_channel_to_clone' => 'Невозможно клонировать канал на себя.',
            'no_date_valid' => 'Нет даты для обновления.',
            'max_availability_exceeded' => 'Значение доступности, которое вы ввели, превышает максимально допустимое для данного размещения. Значение было изменено на максимально разрешенное.',
            'anti_overbooking_bloccante' => 'Внимание: значение доступности, которое вы пытаетесь ввести, превышает количество продаваемых номеров. Это может привести к овербукингу.',
            'channel_update_error' => 'Обновление на портал не удалось, обратитесь к разделу <b>Журнал обновлений</b> для получения дополнительной информации.',
            'period_over_limit' => 'Период с :dateFrom по :dateTo превышает максимально допустимый предел.',
        ],
        'warnings' => [
            'past_period' => 'Выбранный период уже прошел.',
            'past_today_adjustment' => 'Дата начала была изменена на сегодняшнюю дату.',
            'period_adjustment_limit' => 'Конечная дата была скорректирована до максимально допустимого предела. (:dateTo)',
            'channel_not_connected' => 'Структура не подключена к каналу :channel_name.',
            'anti_overbooking' => 'Внимание: значение доступности, которое вы пытаетесь ввести, превышает количество продаваемых номеров. Это может привести к овербукингу.',
            'missing_association' => 'Комната не ассоциирована с каналом :channel_name.',
            'identical_update' => 'Идентичное обновление все еще в процессе, попробуйте позже.',
            'rate_copy_not_found' => 'Нет данных для копирования на прошедший период. Обновление проигнорировано.',
        ],
    ],

    'receipt_modules' => [
        'errors' => [
            'already_migrated' => 'Этот фискальный принтер уже был мигрирован на новое управление отделами.',
        ],
        'log' => [
            'receipt_module_updated' => 'Фискальный принтер обновлен.',
            'receipt_module_created' => 'Фискальный принтер создан.',
            'receipt_module_deleted' => 'Фискальный принтер удален.',
            'receipt_module_department_deleted' => 'Отдел фискального принтера удален.',
            'receipt_module_department_created' => 'Отдел фискального принтера создан.',
            'receipt_module_department_updated' => 'Отдел фискального принтера обновлен.',
        ],
        'validation' => [
            'ateco_slot_code' => [
                'wrong_format' => 'Неверный формат кода Ateco.',
                'wrong_slot' => 'Неподдерживаемое значение слота. (0 - 3).',
            ],
        ],
    ],

    'receipt_channels' => [
        'log' => [
            'receipt_channel_created' => 'Электронный чек создан',
            'receipt_channel_deleted' => 'Электронный чек удалён',
        ]
    ],

    'reservation_accommodation_room_day' => [
        'fields' => [
            'model_name' => 'день',
            'price' => 'ежедневная цена',
            'adults_number' => 'количество взрослых',
            'children_number' => 'количество детей',
        ],
    ],

    'reservation_addon' => [
        'fields' => [
            'related_id' => 'связанный идентификатор',
            'related_type' => 'связанный тип'
        ],
    ],

    'reservation_accommodation' => [
        'fields' => [
            'price_total' => 'общая цена номера',
            'smoking' => 'курящие',
            'accommodation_bed_type_combination_id' => 'Комбинированный идентификатор типа кровати для размещения'
        ],
    ],

    'reservation_cc' => [
        'fields' => [
            'holder' => 'владелец кредитной карты',
            'number' => 'номер кредитной карты',
            'expire_date' => 'срок действия кредитной карты',
            'cvc' => 'код CVC',
            'credit_card' => 'кредитная карта',
            'current_balance' => 'текущий баланс',
            'type_id' => 'тип идентификатора',
            'activation_date' => 'дата активации',
            'vcc_expiration_date' => 'дата истечения vcc',
            'is_virtual_card' => 'Это виртуальная карта'
        ],
    ],

    'reservation_invoice' => [
        'export_fields' => [
            'reference_number' => 'ID бронирования',
            'reservation_id' => 'ID бронирования',
            'accommodations' => 'Размещение',
            'room' => 'Номер',
            'period' => 'Период',
            'pax' => 'Гости',
            'type' => 'Тип',
            'customer' => 'Владелец',
            'payment_agreement' => 'Кредит',
            'paid' => 'Оплачено',
            'to_pay' => 'К оплате',
            'accountholder' => 'Владелец счета',
            'total' => 'Итого',
            'stay' => 'Проживание',
            'guests' => 'Гости',
            'credit' => 'Кредит',
            'note' => 'Примечания',
            'notes' => 'Примечания',
            'status' => 'Статус',
            'booker' => 'Бронирование',
            'property_name' => 'Объект',
            'open_charges' => 'Открытые счета',
        ],
        'errors' => [
            'invoice_opened_for_customer' => 'У клиента есть открытые счета для этого бронирования, завершите их, прежде чем создавать новые.',
            'credit_note_on_opened' => 'Невозможно создать кредитную заметку для незарегистрированных счетов.',
            'associate_in_to_credit_note' => 'Невозможно связать поступление с кредитной заметкой.',
            'associate_out_to_invoice' => 'Невозможно связать исходящий платеж с фактурой.',
            'cant_update_due_invoice_no_show' => 'Невозможно изменить бронирование, так как существуют счета за no-show или отмену.',
            'keep_same_customer_on_credit_note' => 'Невозможно изменить получателя кредитной заметки, связанной с выданной фактурой.',
            'impossibile_move_through_reservations' => 'Невозможно переместить списание с открытых счетов этого бронирования на закрытые счета или кредитные заметки.',
            'cant_refund_pending_sdi_invoice' => 'Невозможно создать кредитную заметку для счетов, ожидающих подтверждения от SDI.',
            'associate_payments_to_follows_invoice' => 'Невозможно связать платежи с квитанцией, отмеченной как "следует за фактурой".',
        ],
    ],

    'reservation_note' => [
        'fields' => [
            'reservation_internal' => 'внутренние заметки по бронированию',
            'reservation_customer' => 'заметки клиента',
            'accommodation_customer' => 'запросы клиента',
            'accommodation_checkin' => 'заметки по регистрации в номер',
            'accommodation_checkout' => 'заметки по выезду из номера',
            'accommodation_housekeeper' => 'Примечания горничной'
        ],
        'deposit' => [
            'wording' => 'Оставлена сумма :amount с использованием метода оплаты :payment_method от клиента :customer',
            'card_info' => 'Зарегистрированы данные карты типа :card_type с номером :card_number, кодом :card_code и сроком действия :expire_date',
        ],
    ],

    'reservation_payment' => [
        'move_errors' => [
            'reservation_payment_is_not_payment' => 'Платеж, произведенный :date на имя :accountholder, является возвратом',
            'reservation_payment_rows_with_bills' => 'Платеж, произведенный :date на имя :accountholder, имеет связанные с ним счета',
            'reservation_payment_is_invoiced' => 'Платеж, произведенный :date на имя :accountholder, уже присутствует в выписанных документах',
            'reservation_payment_with_different_invoice_layout' => 'Платеж, произведенный :date на имя :accountholder, имеет профиль выставления счета, который отсутствует в целевой структуре',
        ],
        'pre_check_errors' => [
            'reservation_payment_is_not_payment' => 'Платеж является возвратом',
            'reservation_payment_rows_with_bills' => 'Платеж имеет связанные с ним счета',
            'reservation_payment_is_invoiced' => 'Платеж уже присутствует в выписанных документах',
        ],
    ],

    'reservation_quote' => [
        'export_fields' => [
            'reference_number' => 'Номер',
            'created_at' => 'Создано',
            'customer_full_name' => 'Клиент',
            'expire_date' => 'Срок действия',
            'status' => 'Статус',
            'expire_date_availability' => 'Срок действия опции',
            'email_read_at' => 'Прочитано',
            'property' => 'Структура',
            'option' => 'Предложение',
            'accommodations' => 'Номера',
            'stay' => 'Проживание',
            'guests' => 'Гости',
            'treatment' => 'Услуга',
            'total' => 'Итого',
            'customer_telephone' => 'Telefono',
            'customer_email' => 'Indirizzo e-mail',
        ],
        'status' => [
            'active' => 'Активен',
            'revoked' => 'Отказан',
            'accepted' => 'Принят',
            'expired' => 'Истек',
            'draft' => 'Черновик',
        ],
        'adults' => '{1} 1 Взрослый|[2,*] :count Взрослых',
        'children' => '{1} 1 Ребенок|[2,*] :count Ребенка',
        'errors' => [
            'no_email_found' => 'Не указаны адреса электронной почты для отправки предложения. Укажите хотя бы один адрес.',
            'email_already_feedback_cannot_update' => 'Невозможно изменить предложение, так как клиент уже его просмотрел или оставил отзыв',
            'no_customer_specified' => 'Предложение не связано с пользователем.',
            'quote_not_active' => 'Предложение не активно.',
            'quote_option_empty' => 'Предложение не содержит номеров, невозможно подтвердить',
            'quote_option_no_availability' => 'Номера, которые вы пытаетесь забронировать, больше не доступны',
            'upload_attachment' => 'Ошибка загрузки файла',
            'other_modified' => 'Это предложение больше не доступно, так как оно было изменено другим пользователем',
            'no_valid_property' => 'Невозможно добавить номер другой структуры в это предложение',
        ],
    ],

    'reservation' => [
        'reservation' => 'Бронирование',
        'notes' => [
            'accommodation_internal' => 'Внутренние примечания по номеру',
            'accommodation_checkout' => 'Примечания по выезду из номера',
            'accommodation_checkin' => 'Примечания по заселению в номер',
            'accommodation_bill' => 'Примечания по оплате номера',
            'accommodation_housekeeper' => 'Примечания горничной',
            'accommodation_customer' => 'Примечания для клиента',
        ],
        'details' => [
            'inserted' => 'Стоимость услуги :title составляет :amount :currency',
        ],
        'export_fields' => [
            'id' => 'ID',
            'booked_at' => 'Дата/время бронирования',
            'modified_at' => 'Дата/время последнего изменения',
            'channel_name' => 'Канал',
            'channel' => 'Канал',
            'booker' => 'Бронирующий',
            'booker_full_name' => 'Полное имя бронирующего',
            'group_label' => 'Группа',
            'accommodations' => 'Номера',
            'rateplans' => 'Тарифные планы',
            'original_accommodations' => 'Изначальные номера',
            'property' => 'Объект',
            'stay' => 'Проживание',
            'period' => 'Период',
            'tag' => 'Метка',
            'arrival_date' => 'Дата заезда',
            'departure_date' => 'Дата выезда',
            'number_nights' => 'Количество ночей',
            'total_price' => 'Общая стоимость',
            'property_name' => 'Название объекта',
            'reservation_id' => 'ID бронирования',
            'room' => 'Номер',
            'total' => 'Итого',
            'total_to_pay' => 'Общая сумма к оплате',
            'status' => 'Статус',
            'note_customer' => 'Примечания клиента',
            'internal_note' => 'Внутренние примечания',
            'group' => 'Группа',
            'reference_number' => 'Номер ссылки',
            'commission_amount' => 'Сумма комиссии',
            'treatments' => 'Услуги',
            'booker_telephone' => 'Телефон бронирующего',
            'booker_email' => 'Email бронирующего',
            'company' => 'Компания',
            'currency' => 'Валюта',
            'nic' => 'ИНН',
            'extra' => 'Дополнительные услуги',
            'city_tax' => 'Городской налог',
            'advance' => 'Предоплата',
            'guests' => 'Гости',
            'xml_reservation_id' => 'ID бронирования канала',
            'user' => 'Пользователь',
            'reservation_from_id' => 'Источник бронирования',
            'reservation_reason_id' => 'Причина бронирования',
            'escalate_report_to_booking' => 'Передать жалобу в Booking.com?',
            'allow_guest_to_book_again' => 'Разрешить гостю бронировать снова?'
        ],
        'activity' => [
            'new' => [
                'message' => 'Новое бронирование от :channel_name',
                'message_sclak_generated_key' => 'Создан ключ для Sclak для номера: :accommodation_name (:tableau_label)',
                'message_nuki_generated_key' => 'Создан PIN для Nuki для номера: :accommodation_name (:tableau_label)',
                'message_sclak_sms_sent' => 'SMS с кодами Sclak отправлено на номер :telephone_number',
                'message_sclak_deleted_key' => 'Удален ключ Sclak для номера: :accommodation_name (:tableau_label)',
                'message_nuki_deleted_key' => 'Удален PIN для номера: :accommodation_name (:tableau_label)',
                'invoice_printig_session' => 'Impression fiscale lancée sur l’imprimante :printer_name (ID : :printer_id) pour le reçu avec l’ID : :invoice_id',
                'added_payment' => 'Добавлен платеж на сумму :amount :currency (ID: :payment_id) с методом :payment_method',
                'added_refund' => 'Выдан возврат на сумму :amount :currency (ID: :payment_id) с методом :payment_method',
            ],
            'update' => [
                'message' => 'Поле :field_translate изменено с :old_value на :new_value',
                'message_novalue' => 'Поле :field_translate изменено',
                'message_newvalue' => 'Введено :field_translate :new_value',
                'message_deletevalue' => 'Удалено :field_translate :old_value',
                'message_forobject' => 'Поле :field_translate изменено с :old_value на :new_value для объекта типа :model_type :model_name',
                'message_split_accommodation' => 'Забронированный номер :accommodation_source (ссылка tableau: :tableau_label_source) (с :original_arrival_date по :original_departure_date) был разделен с :split_arrival_date по :split_departure_date и перемещен в номер :accommodation_destination (ссылка tableau: :tableau_label_destination)',
                'message_move_accommodation' => 'Забронированный номер :accommodation_source (ссылка tableau: :tableau_label_source, Rateplan: :rateplan_name_source , Услуга: :treatment_name_source, Цена: :price_source) был перемещен в номер :accommodation_destination (ссылка tableau: :tableau_label_destination, Rateplan: :rateplan_name_destination , Услуга: :treatment_name_destination , Цена: :price_destination)',
                'message_resend_email_customer' => 'Email бронирования снова отправлена бронирующему, адрес :new_value',
                'message_resend_email_company' => 'Email бронирования снова отправлена компании, адрес :new_value',
                'message_resend_email_property' => 'Email бронирования снова отправлена объекту, адрес :new_value',
                'message_resend_email_additional' => 'Email бронирования снова отправлена на дополнительный адрес :new_value',
                'message_restored_sdi_rejected_invoice' => 'Документ :invoice_number от :invoice_date был восстановлен с присоединенными следующими уведомлениями: :sdi_notify',
                'message_sdi_rejected_invoice' => 'Документ :invoice_number от :invoice_date отклонен с профилем выставления счетов :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'message_sdi_rejected_invoice_with_advances' => 'Документ :invoice_number от :invoice_date отклонен с профилем выставления счетов :invoice_layout (:invoice_business_name - :invoice_vat_code) с присоединенными авансами: :advances',
                'message_sdi_rejected_invoice_as_receipt' => 'Документ :invoice_number от :invoice_date был выдан как квитанция с профилем выставления счетов :invoice_layout (:invoice_business_name - :invoice_vat_code) и зарегистрирован на имя :invoice_customer (Сумма :invoice_total), с присоединенными уведомлениями: :sdi_notify',
                'message_registered_invoice' => 'Документ :document_type :invoice_number :follows_invoice от :invoice_date был зарегистрирован с профилем выставления счетов :invoice_layout (:invoice_business_name - :invoice_vat_code) и зарегистрирован на имя :invoice_customer (Сумма :invoice_total) :manual_fp_register',
                'message_restored_invoice' => 'Документ :document_type :invoice_number от :invoice_date был аннулирован с профилем выставления счетов :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'calculate_city_tax' => 'Городской налог был рассчитан для следующих гостей: :guests',
                'no_guests_calculate_city_tax' => 'Городской налог был рассчитан, но не было подходящих гостей для расчета',
                'add_extra' => 'Добавлены дополнительные расходы: :extra',
                'delete_bill' => 'Удалены расходы: :extra',
                'transferred_bills' => 'Переведено :transfer_label расходов: :bills_label',
                'transferred_bills_qty' => 'Переведено количество :transfer_label расходов: :bills_label',
                'transferred_bills_to_charges' => 'Переведено на счет :invoice_label (:invoice_id) стоимость: :transfer_label расходов: :bills_label',
                'transferred_bills_to_accommodation' => 'Переведено на номер :accommodation_label (:accommodation_id) - Бронирование :reference_number стоимость: :transfer_label расходов: :bills_label',
                'transferred_bills_to_accommodation_multi_customer' => 'Переведено на номер :accommodation_label (:accommodation_id) - Бронирование :reference_number для клиентов: :customers стоимость: :transfer_label расходов: :bills_label',
                'transferred_bills_qty_to_charges' => 'Переведено количество :transfer_label расходов: :bills_label на счет :invoice_label (:invoice_id)',
                'transferred_bills_qty_to_accommodation' => 'Переведено количество :transfer_label расходов: :bills_label на номер :accommodation_label (:accommodation_id) - Бронирование :reference_number',
                'transferred_bills_qty_to_accommodation_multi_customer' => 'Переведено количество :transfer_label расходов: :bills_label на номер :accommodation_label (:accommodation_id) - Бронирование :reference_number для клиентов: :customers',
                'transferred_bills_to_accommodation_reservation_destination' => 'Переведено с счета :invoice_origin (#:invoice_origin_id) следующие расходы: :bills_label',
                'restored_bills' => 'Восстановлены расходы: :bills_label',
                'message_deleted_credit_note' => 'Документ :document_type :invoice_number от :invoice_date был удален с профилем выставления счетов :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'edit_payment' => 'Изменен платеж (ID: :payment_id) с методом :payment_method. Сумма :amount :currency',
                'message_edit_guest' => 'Изменен гость :guest_name',
                'transferred_payment_to_reservation' => 'Переведен платеж (#:paymentId) от :accountholder в Бронирование :reservationOrigin на Бронирование :reservationDestination',
                'restored_payment_to_reservation' => 'Восстановлен платеж (#:paymentId) от :accountholder в Бронирование :reservationOrigin',
                'guest_checkin_checkout' => 'Изменены даты заезда или выезда для следующих гостей:guests',
                'model_price_original' => 'Поле :field_translate было изменено с :old_value на :new_value. Клиент выбрал сохранить текущую цену.',
                'model_price_moved' => 'Поле :field_translate было изменено с :old_value на :new_value. Клиент выбрал новую цену.',
            ],
            'delete' => [
                'delete_payment' => 'Удален платеж на сумму :amount :currency (ID: :payment_id) с методом :payment_method',
            ],
            'view' => [
                'credit_card_fail' => 'Попытка считывания кредитной карты. (:ip_address)',
                'credit_card_success' => 'Данные кредитной карты были отображены. (:ip_address)',
            ],
            'internal_note' => 'Внутренняя примечания: :note',
            'bill_note' => 'Примечания по счету: :note',
            'catering_note' => 'Примечания по питанию: :note',
            'customer_note' => 'Запросы клиента: :note',
            'nuki' => [
                'create' => 'Устройство Nuki (:device_id): код двери создан для комнаты :tableau_label',
                'update' => 'Устройство Nuki (:device_id): разрешения кода изменены для комнаты :tableau_label',
                'delete' => 'Устройство Nuki (:device_id): код двери удалён для комнаты :tableau_label',
            ],

        ],
        'wording' => [
            'advance_invoice' => 'Проживание с :date_from по :date_to',
            'customer' => 'Клиент: ',
            'advance_count' => 'Аванс №: ',
            'partial' => 'Частичный',
            'total' => 'Общий',
            'credit_note' => 'Возврат :type №:number от :invoice_date',
            'accommodation_bill_label' => 'Проживание',
            'city_tax_label' => ':cost за ночь с :min_age до :max_age лет на максимум :limit_days дней',
            'city_tax_label_no_limit' => ':cost за ночь с :min_age до :max_age лет без ограничения по дням',
        ],
        'fields' => [
            'model_name' => 'бронирование',
            'arrival_date' => 'Дата заезда',
            'departure_date' => 'Дата выезда',
            'total_price' => 'Окончательная стоимость',
            'total_adults' => 'Количество взрослых',
            'overbooking' => 'Овербуккинг',
            'label_name' => 'Группа клиентов',
            'reason' => 'Причина поездки',
            'total_children' => 'Количество детей',
            'split_reservation' => 'Разделение бронирования',
            'sclak_deleted_key' => 'Удалённый ключ на Sclak',
            'sclak_generated_key' => 'Создан ключ на Sclak',
            'sclak_sms_sent' => 'SMS с кодами Sclak отправлено на номер :telephone_number',
            'move_accommodation' => 'Перемещение номера',
            'accommodation_bill' => 'Примечания по счёту',
            'status' => 'Статус',
            'keep_availability' => 'Не восстанавливать',
            'expiration_date' => 'Дата истечения',
            'availability_option' => 'Опция доступности',
            'resend_email' => 'Повторная отправка email',
            'commission_amount' => 'Сумма комиссии',
            'reservation_reason_id' => 'идентификатор причины бронирования',
            'reservation_from_id' => 'происхождение',
            'reservation_bill' => 'счет за бронирование',
            'reservation_checkin' => 'регистрация бронирования',
            'reservation_checkout' => 'проверка бронирования',
            'partner_download' => 'загрузка партнеров',
            'commissionable_amount' => 'комиссионная сумма',
            'is_group' => 'Группа ли это',
            'commission_discount_type_id' => 'Идентификатор типа скидки комиссии',
            'commission_discount_value' => 'Значение скидки комиссии',
            'added_credit_card_data' => 'Добавлены данные кредитной карты',
        ],
        'payment_status' => [
            'paid' => 'Оплачено',
            'to_be_invoiced' => 'Подлежит выставлению счета',
            'to_pay' => 'К оплате',
            'suspended' => 'Приостановлено',
        ],
        'policy' => [
            'none' => 'Без штрафа',
        ],
        'errors' => [
            'property_deleted' => 'Невозможно отменить бронирование, свяжитесь с объектом',
            'missing_main_room_guest' => 'Основной гость не настроен для всех номеров',
            'accommodation_not_found' => 'Номер был удалён',
            'different_accommodation_checkout_date' => 'Номера в бронировании имеют разные даты выезда',
            'different_accommodation_checkin_date' => 'Номера в бронировании имеют разные даты заезда',
            'transfer_on_same_customer_bill' => 'Невозможно разделить на того же плательщика',
            'no_guests_loaded' => 'Нет гостей, указанных для номера',
            'not_mapped_accommodation' => 'Номер неправильно сопоставлен',
            'not_switch_virtual' => 'Невозможно переместить бронирование в виртуальный номер другого объекта',
            'last_accommodation' => 'Невозможно удалить последний оставшийся номер',
            'not_tableau' => 'Номер Tableau не относится к размещению',
            'impossible_change' => 'Невозможно выполнить это изменение статуса',
            'missing_roomreservation_id' => 'Не найден номер для переданного roomreservation',
            'missing_order' => 'Заказ не найден',
            'existing_bills_invoiced' => 'Существуют выставленные счета и квитанции, связанные с бронированием. Невозможно продолжить',
            'uneditable_field' => 'Поле нельзя редактировать',
            'no_gateway_response' => 'Ошибка соединения с платёжным шлюзом',
            'reservation_unpaid' => 'Транзакция не завершена',
            'missing_balance' => 'Недостаточно средств для завершения оплаты',
            'uneditable_fields_invoice' => 'Следующие поля не могут быть изменены: ',
            'not_editable_total_due_paid' => 'Указанная цена меньше общего оплаченного',
            'not_editable_total_due_invoice' => 'Указанная цена меньше общей суммы по выставленному счёту',
            'accommodation_room_guest_exists' => 'Указанный гость уже присутствует в эти даты',
            'no_payment_amount_enough' => 'Доступный баланс (:amount_available) недостаточен для покрытия суммы (:request_amount)',
            'payment_amoun_minor_of_amount_used' => 'Указанная сумма (:request_amount) меньше использованной суммы (:amount_used_global)',
            'cannot_delete_deposit_invoice' => 'Невозможно удалить платёж, так как он уже использован в выставленном счёте',
            'accommodation_invoiced' => 'Номер уже был выставлен в счёте, его нельзя удалить',
            'resend_email_empty_address' => 'Не указан email для этого клиента',
            'householder_in_agreement' => 'Глава семьи участвует в разделении счётов, измените настройку перед продолжением',
            'missing_company' => 'Отсутствует информация о компании для бронирования',
            'accommodation_bill_charged' => 'Счёт за номер уже выставлен. Невозможно продолжить',
            'all_billed' => 'Все расходы уже были учтены или перенесены. Невозможно пересоздать',
            'impossible_move_nature_bill' => 'Невозможно переместить расходы с типом: ',
            'billed_accommodation' => 'Non è possibile cambiare le date di prenotazione perché sono stati emessi documenti fiscali.
            Inserisci una nuova prenotazione o aggiungi una camera a questa prenotazione con le nuove date.',
            'deposit_as_refund' => 'Депозит не может быть настроен как возврат',
            'refund_in_invoice' => 'Невозможно связать возврат с выставленными счетами или квитанциями',
            'different_vat_codes' => 'Невозможно связать платежи или квитанции, относящиеся к разным профилям налогообложения',
            'property_not_attached' => 'Невозможно связать платежи с объектами, не связанными с бронированием',
            'too_many_payments' => 'Общая сумма платежей превышает сумму, подлежащую оплате или возврату',
            'bill_and_expense' => 'Невозможно связать платёж с расходами и с другими расходами',
            'expense_minimum_payment' => 'Для расходов должен быть хотя бы один платёж, невозможно продолжить',
            'amount_exceed_refunds' => 'Платёж превышает допустимую сумму, учитывая возвраты',
            'missing_reservation' => 'Бронирование недействительно',
            'already_cancelled' => 'Бронирование уже отменено',
            'impossible_decrement_shared_bill' => 'Невозможно уменьшить количество разделённых расходов',
            'pax_fields_in_not_paxable_bill' => 'Невозможно указать гостей для расходов, не основанных на обслуживании гостей',
            'company_email_address_is_empty' => 'Не указан email для этой компании',
            'checkinonline_dati_mancanti' => 'Данные не были отправлены правильно.',
            'checkinonline_reservation_not_found' => 'Бронирование не найдено.',
            'checkinonline_reservation_is_cancelled' => 'Бронирование отменено.',
            'checkinonline_reservation_is_not_confirmed' => 'Бронирование не подтверждено',
            'checkinonline_reservation_arrival_date_past' => 'Дата заезда прошла.',
            'checkinonline_reservation_departure_date_over' => 'Бронирование уже завершено.',
            'checkinonline_city_tax_cannot_pay' => 'Нет городского налога для оплаты.',
            'deposit_as_deposit' => 'Этот платёж уже является депозитом, невозможно продолжить',
            'deposit_as_advance' => 'Невозможно выставить авансовый счёт на депозит',
            'document_on_funds' => 'Невозможно создать документ на средства фонда',
            'document_on_used_payment' => 'Невозможно создать документ на оплату, использованную для погашения других документов',
            'not_whole' => 'Невозможно создать документ для платежа, который связан с другим платежом',
            'document_on_refunded' => 'Невозможно создать документ на возврат',
            'document_on_payments_out' => 'Невозможно создать документ для исходящих платежей',
            'channel_checkin_missing_info' => 'Отсутствуют данные о состоянии запроса',
            'channel_checkin_missing_status_already_present' => 'Статус заезда уже обработан',
            'no_bills_on_customer' => 'Нет счётов для этого клиента',
            'discount_over_invoiced_value' => 'Разница в цене для применения превышает сумму, подлежащую выставлению',
            'no_show_requested_total_major_bills_to_invoice' => 'Сумма по запросу no show превышает сумму, подлежащую выставлению',
            'checkin_major_checkout' => 'Дата заезда позднее или совпадает с датой выезда для номера :accommodation_name, невозможно продолжить',
            'checkout_major_checkin' => 'Дата выезда позднее или совпадает с датой заезда для номера :accommodation_name, невозможно продолжить',
            'missing_addon' => 'Отсутствуют данные для дополнительного сервиса, невозможно продолжить',
            'missing_customer_on_split_bills_same_reservation' => 'Невозможно разделить расходы в одном бронировании без указания плательщика',
            'have_door_service_active' => 'Невозможно добавить ключ для двери, так как активирован внешний сервис :external_service_name',
            'conflict_system_custom_email_template' => 'Указано несколько шаблонов для отправки, укажите только один.',
            'guest_already_present_in_same_dates' => 'Невозможно продолжить: гость уже присутствует в эти даты',
            'can_not_move_reservation_payments' => 'Невозможно перенести платежи по следующим ошибкам: :errors',
            'can_not_modify_ota_checkin_checkout' => 'Невозможно изменить даты бронирования, полученные через канал.',
            'unsuitable_dates_for_guests' => 'Даты пребывания несовместимы для гостей: :guests',
            'unsuitable_dates_for_guests_one_day' => 'Несколько дат пребывания для гостей: :guests для одной ночи, удалите одно из пребываний перед продолжением',
        ],
        'warnings' => [
            'not_mapped_addons' => 'Желаемая услуга не ассоциирована с номером: ',
            'bill_splitted' => 'Расходы, распределённые по нескольким счётам, не могут быть изменены: ',
            'bill_children' => 'Частичный расход, полученный, не может быть изменён: ',
            'all_bills_closed' => 'Все счета закрыты для этого бронирования',
            'deposit_cut' => 'Сделан возврат на платёж по расходу: ',
            'not_existing_bill' => 'Расход не существует',
            'exceeding_num_adults' => 'Количество взрослых превышает максимально установленное для номера',
            'exceeding_num_children' => 'Количество детей превышает максимально установленное для номера',
            'existing_payments_pending' => 'Есть ожидающие платежи по расходам номера, хотите продолжить?',
            'existing_invoices_joined' => 'Есть документы, связанные с расходом :bill_name, невозможно переместить в другие номера или внешние счета',
            'customer_invoiced' => 'Есть выставленные счета для клиента :customer, их нельзя отменить',
            'is_previous' => 'Бронирование, предшествующее подключению канала',
            'bill_cant_split' => 'Расход невозможно разделить в этой категории',
            'bill_charged' => 'Один или несколько расходов были выставлены в счёт, изменение невозможно.',
            'bill_qty_incoerence' => 'Количество не соответствует числу гостей, связанным с расходом',
            'no_guests' => 'Нет гостей в этом бронировании',
            'move_other_property_notify' => 'Выберите объект, от которого будут отправлены уведомления',
            'bill_deposit_not_allowed' => 'Платёж нельзя связать с этим типом расхода',
            'bill_discount_unsuitable_to_row' => 'Перерасчёт скидки несовместим с частью расхода, выставленного в счёт',
            'bill_rows_discount_deleting' => 'Перемещение вызвало сброс скидки, связанной с исходным расходом, находящимся на открытом счёте',
            'existing_bills_night' => 'Дополнительные услуги ночей, не включённых в проживание, будут удалены',
            'bills_not_found' => 'Платежи не найдены',
            'change_status_in_progress' => 'Бронирование уже меняет свой статус.',
            'reservation_accommodation_door_key_code_reservation_resumed' => 'Необходимо создать новый ключ, старый был отключён после изменения статуса бронирования.',
            'reservation_accommodation_door_key_code_exist' => 'Есть коды для открытия дверей. Пожалуйста, выполните их повторную генерацию или отмену вручную.',
            'reservation_accommodation_door_key_code_exist_moved_accommodation' => 'Один или несколько номеров были перемещены. Необходимо создать новый ключ.',
            'reservation_accommodation_door_key_code_delete' => 'Произошла ошибка при удалении ключей. Попробуйте снова вручную',
            'reservation_accommodation_door_key_code_generate' => 'Произошла ошибка при генерации ключей. Попробуйте снова вручную',
            'existing_transferred_bills' => 'Есть расходы, перенесённые из других номеров, их необходимо восстановить или перераспределить перед продолжением',
            'bill_has_payment' => 'Есть платежи, связанные с расходом :bill_name, невозможно перенести в другие номера или внешние документы',
        ],
        'channels' => [
            'no_report_invalid_cc' => 'Отчёт по недействительной кредитной карте не требуется для этого канала',
            'no_report_noshow' => 'Отчёт о неявке не требуется для этого канала',
            'no_report_cancellation_due_invalid' => 'Отчёт об отмене не требуется для этого канала',
            'payment_to_ota' => 'Платёж был произведён через портал :channel_name',
            'no_previous' => 'Канал не поддерживает загрузку бронирований, сделанных ранее',
            'email' => [
                'without_room_title' => 'Новое бронирование без номера от :channel_name (ID: :reference_number) - Объект: :property_name',
                'without_rate_title' => 'Новое бронирование без тарифа от :channel_name (ID: :reference_number) - Объект: :property_name',
            ],
        ],
        'bills' => [
            'reservation_bill_id_not_found' => 'ID :reservation_bill_id не принадлежит указанному бронированию',
            'reservation_bill_id_already_override' => 'ID :reservation_bill_id уже был перезаписан',
            'reservation_bill_id_no_updates' => 'Все элементы уже относятся к перезаписанным или не принадлежат указанному бронированию',
            'delete_bill_accounted' => 'Невозможно удалить, так как один или несколько элементов уже учтены',
            'delete_sheet_bill_emitted' => 'Невозможно удалить счёт, так как для него уже выставлен счёт',
            'different_vat_quotes_in_merge' => 'Невозможно перезаписать расходы с разной НДС',
            'cant_editable_due_moved' => 'Расход перемещён: доступна только модификация скидки',
        ],
        'invoice' => [
            'invoice_already_registered' => 'Счёт уже был выставлен',
            'no_invoice_layout' => 'Нет доступной схемы выставления счёта. Невозможно продолжить',
            'no_an_invoice' => 'Это не счёт',
            'no_company_id' => 'Не указана компания для выставления счёта',
            'unsuitable_payments' => 'Связанные платежи не совместимы с налоговым профилем счёта',
            'too_many_advances' => 'Сумма авансов превышает общую сумму расходов',
            'advances_in_advance' => 'Невозможно включить авансы в авансовый счёт',
            'payments_major_total_invoice' => 'Общая сумма платежей превышает общую сумму счёта',
        ],
        'pdf' => [
            'reservation' => [
                'filters' => [
                    'in_house' => 'В процессе',
                    'arrival_date' => 'Прибытие',
                    'departure_date' => 'Отбытие',
                ],
                'booker' => [
                    'origin' => 'Канал бронирования',
                    'name' => 'Имя гостя',
                    'telephone' => 'Тел.',
                    'email' => 'Электронная почта',
                    'pec' => 'PEC',
                    'language' => 'Язык',
                    'reference_number' => 'Номер бронирования',
                    'booked_at' => 'Дата бронирования',
                    'commissionable_amount' => 'Сумма, подлежащая комиссионному вознаграждению',
                    'commission_amount' => 'Комиссия',
                    'other_infos' => 'Дополнительная информация о госте',
                    'notes' => [
                        'note_internal' => 'Внутренние заметки',
                        'note_customer' => 'Заметки клиента',
                        'note_bill' => 'Заметки по оплате',
                        'note_checkin' => 'Заметки по заезду',
                        'note_checkout' => 'Заметки по выезду',
                    ],
                ],
                'accommodation' => [
                    'from_date' => 'Прибытие',
                    'to_date' => 'Отбытие',
                    'duration' => 'Продолжительность пребывания',
                    'duration_text' => '{1} :length ночь|[2,*] :length ночей',
                    'total_guests' => 'Общее количество гостей',
                    'guests_adults_text' => ':quantity взрослых',
                    'guests_children_text' => ':quantity детей',
                    'total_accommodations' => 'Общее количество номеров',
                ],
                'reservation' => [
                    'name' => 'Имя гостя',
                    'total_guests' => 'Количество гостей',
                    'guests_adults_text' => ':quantity взрослых',
                    'guests_children_text' => ':quantity детей',
                    'max_capacity' => 'Максимальная вместимость',
                    'capacity_text' => ':quantity гостей',
                    'meals' => 'Питание',
                    'meals_breakfast_included' => 'Завтрак включен в стоимость номера',
                    'table' => [
                        'date' => 'Дата',
                        'price' => 'Цена',
                        'price_per_day' => 'Цена за ночь',
                        'non_refundable_rate' => 'Без возврата',
                        'subtotal' => 'Промежуточный итог',
                        'city_tax' => 'Городской налог',
                        'city_tax_detail' => 'Сумма на человека за ночь',
                        'total_accommodation_price' => 'Общая стоимость проживания',
                        'vat_included' => 'Цена включает :amount НДС',
                        'vat_not_included' => 'Цена без НДС',
                    ],
                ],
                'statuses' => [
                    'cancelled' => 'Отменено',
                    'optionable' => 'Опционально',
                    'hidden' => 'Скрыто',
                    'pending' => 'Ожидает оплаты',
                    'confirmed' => 'Подтверждено',
                ],
                'totals' => [
                    'statuses' => [
                        'Cancelled' => 'Отменено',
                        'Optionable' => 'Опционально',
                        'Hidden' => 'Скрыто',
                        'Pending' => 'Ожидает оплаты',
                        'Confirmed' => 'Подтверждено',
                        'Expired' => 'Истекло',
                    ],
                    'status' => 'Статус бронирования',
                    'total_amount' => 'Общая сумма',
                    'paid_deposit' => 'Оплаченный депозит',
                    'total_paid' => 'Оплачено',
                    'total_to_be_paid' => 'К оплате',
                ],
                'payments' => [
                    'table' => [
                        'date' => 'Дата записи',
                        'method' => 'Способ оплаты',
                        'amount' => 'Сумма',
                        'notes' => 'Заметки',
                    ],
                ],
            ],
            'bills' => [
                'accommodations' => 'Проживание',
                'accommodation' => 'Номер',
                'total' => 'Итого',
                'date' => 'Дата',
                'room' => 'Комната',
                'treatment' => 'Питание',
                'amount_per_night' => 'Стоимость за ночь',
                'addons_categories' => 'Дополнительные услуги',
                'addon_category' => 'Тип услуги',
                'addon_name' => 'Услуга',
                'addon_price_type' => 'Тип тарифа',
                'amount' => 'Сумма',
                'taxes' => 'Налоги',
                'tax_name' => 'Тип налога',
                'accommodations_title' => 'Детали проживания',
                'addons_categories_title' => 'Детали дополнительных услуг',
                'taxes_title' => 'Детали налогов',
            ],
            'guests' => [
                'guests_list' => 'Список зарегистрированных гостей для бронирования',
                'reservation_of_date' => 'от',
                'duration_text' => ':length ночей',
                'from' => 'С',
                'to' => 'По',
                'table' => [
                    'type' => 'Тип',
                    'name' => 'Имя',
                    'surname' => 'Фамилия',
                    'birthday_date' => 'Дата рождения',
                    'gender' => 'Пол',
                    'birth_place' => 'Место рождения',
                    'checked_in' => 'Зарегистрирован',
                    'none' => 'Нет зарегистрированных гостей',
                ],
            ],
            'payment' => [
                'payments_short_title' => 'Детали платежей',
                'payments_title' => 'Платежи и документы',
                'report_title' => 'Платежный отчёт',
                'deposit_title' => 'Подтверждение депозита',
                'refund_title' => 'Возврат',
                'issuer' => 'Плательщик',
                'registration_date' => 'Дата регистрации платежа',
                'payment' => 'Платёж',
                'payment_date' => 'Дата платежа',
                'method' => 'Метод оплаты',
                'amount' => 'Сумма',
                'pos' => 'POS',
                'deposit_number' => 'Номер депозита',
                'payments_received' => 'Полученные платежи',
                'notes' => 'Заметки',
                'deposit' => 'Депозит',
                'to_pay' => 'К оплате',
                'excess_payment' => 'Сумма излишка',
                'invoiced' => 'Сумма по счёту',
                'to_be_invoiced' => 'Сумма для выставления счета',
                'total_to_be_invoiced' => 'Общая сумма для выставления счета',
                'document_type' => 'Тип документа',
                'document_number' => 'Номер документа',
                'document_date' => 'Дата выдачи',
                'invoice_issuer' => 'Выдавший счет',
                'invoice_paid' => 'Оплачено',
                'invoice_to_pay' => 'К оплате',
            ],
            'fees' => [
                'fees_title' => 'Сборы',
                'document_type' => 'Тип',
                'total' => 'Итого',
                '22' => 'НДС 22%',
                '10' => 'НДС 10%',
                'customer' => 'Клиент или компания',
            ],
            'deposits' => [
                'deposits_title' => 'Депозиты и авансы',
                'export_fields' => [
                    'property' => 'Объект',
                    'number' => 'Номер',
                    'date' => 'Дата',
                    'total' => 'Итого',
                    'amount_available' => 'Доступная сумма',
                    'used' => 'Использовано',
                    'reservation_id' => 'ID бронирования',
                    'pos' => 'POS',
                    'type_payment' => 'Тип платежа',
                    'type_reservation' => 'Тип бронирования',
                    'description' => 'Описание',
                    'user_pay' => 'Плательщик',
                    'reservation' => 'Бронирования',
                    'payment_method' => 'Метод оплаты',
                    'stay' => 'Пребывание',
                    'departure_date' => 'Дата отъезда',
                ],
            ],
        ],
        'of_date' => 'от :date',
        'arrival_date' => 'Прибытие',
        'departure_date' => 'Отбытие',
        'nights' => 'Ночи',
        'accommodations' => 'Номера',
        'policy_description' => 'Резюме условий',
        'policy_deposit_description' => 'Резюме платежа',
        'payments_timetable' => [
            'title' => 'Условия оплаты',
            'subtitle' => 'Ниже указаны даты, когда будут произведены начисления за пребывание',
            'statuses' => [
                'scheduled' => 'Запланировано',
                'processed' => 'Обработано',
                'failed' => 'Неудачно',
                'paused' => 'Приостановлено',
                'cancelled' => 'Отменено',
                'wait_customer' => 'Ожидается клиент',
                'partial_processed' => 'Частично обработано',
            ],
            'city_tax' => [
                'checkin_online' => 'Городской налог в размере :amount не включен и будет автоматически начислен после завершения онлайн-регистрации. В случае, если онлайн-регистрация не будет завершена, налог будет начислен непосредственно в отеле.',
                'checkout' => 'Сумма :amount является приблизительной оценкой и может изменяться при наличии льгот или изменении количества гостей или ночей пребывания.'
            ]
        ],
        'log' => [
            'city_tax_log_title' => 'Городской налог',
            'extra_log_title' => 'Дополнительные услуги',
            'bill_title' => 'Начисления',
            'notes' => 'Раздел заметок',
            'guest' => 'Гость',
            'payment' => 'Платеж',
        ],
        'errors_reason' => [
            'update_system' => 'Вы не можете изменить системную причину',
            'delete_system' => 'Вы не можете удалить системную причину',
            'not_exist' => 'Причина не найдена',
        ],
        'customer_profile_deleted' => 'Профиль этого гостя был удалён и не может быть изменён. Хотите его восстановить, чтобы продолжить редактирование?',
    ],

    'rhino' => [
        'exceptions' => [
            'request_not_valid' => 'Отсутствуют обязательные поля',
            'method_not_found' => 'Запрашиваемый метод не существует',
        ],
        'vat_code_already_exists' => 'Этот ИНН уже существует в системе. Убедитесь, что вы вводите уникальный ИНН, который еще не был зарегистрирован.',
    ],

    'roles' => [
        'property' => [
            // TODO:
            'master' => 'Руководство',
            'operator' => 'Оператор',
            'housekeeper' => 'Горничная',
        ],
        'errors' => [
            'access_denied_property' => 'Неправильная роль: у пользователя нет прав директора для доступа к структуре.'
        ]
    ],

    'sca' => [
        'pdf' => [
            'filename' => 'Авторизация для кредитных карт',
            'card_holder' => 'Имя владельца карты',
            'card_type' => 'Тип карты',
            'card_number' => 'Номер карты',
            'card_expiration' => 'Дата окончания срока действия',
            'card_cvc' => 'CVC',
            'parts' => [
                'p1' => 'Авторизация для кредитных карт',
                'p2' => 'Внимание – Поля, отмеченные звездочкой, обязательны для заполнения',
                'p3' => 'Пожалуйста, предоставьте все необходимые данные для подтверждения вашего бронирования.',
                'p4' => 'Отправьте заполненную форму и все необходимые документы на адрес: <span class="link">:email</span>',
                'p5' => 'Информация о владельце карты:',
                'p6' => 'Подтверждаю, что предоставленная информация является точной и достоверной.',
                'p7' => 'Настоящим я авторизую списание суммы с указанной кредитной/дебетовой карты',
                'p8' => '<span class="bold">Для невозвратных тарифов</span> указанная кредитная карта будет немедленно списана на указанную сумму.',
                'p9' => '<span class="bold">Для гибких тарифов</span> указанная кредитная карта может быть проверена на валидность с предварительным авторизационным списанием, как указано в политике.',
                'p10' => 'Подпись владельца карты',
                'p11' => 'Номер бронирования',
                'p12' => 'Дата прибытия',
                'p13' => 'Вместе с этим документом необходимо отправить копию кредитной/дебетовой карты (обе стороны) и копию паспорта/удостоверения личности владельца. Пожалуйста, отправьте все документы на адрес: <span class="link">:email</span>',
                'p14' => 'Если документы не будут получены, бронирование будет считаться недействительным и отменено. Все предоставленные данные будут конфиденциальными и использованы исключительно для указанных целей.',
                'p15' => ':name – :address, :zip_code – :city_name <span class="link">:email</span> - <span class="link">:website</span>',
            ],
        ],
        'email' => [
            'subject' => ':property - Запрос на авторизацию',
            'subject_accepted' => 'Авторизация SCA/3DS была подтверждена',
            'subject_reservation' => ':name :surname, подтвердите ваше бронирование',
            'dear_customer_reservation' => 'Уважаемый(ая) :name :surname, <br /> для гарантии вашего бронирования, просьба авторизовать использование вашей кредитной карты согласно условиям бронирования и отмены.<br><br>Спасибо за сотрудничество.',
            'dear_customer_payment' => 'Уважаемый(ая) :name :surname, <br /> для гарантии вашего бронирования, просьба авторизовать использование вашей кредитной карты согласно условиям бронирования и отмены.<br><br>Спасибо за сотрудничество.',
            'your_reservation_for' => 'Ваше бронирование на имя :name',
            'you_payment_for' => 'Ваш платеж для :name',
            'we_are_waiting_for_you_on_date' => 'Мы ждем вас :date',
            'reservation_summary' => 'Резюме бронирования',
            'payment_summary' => 'Резюме платежа',
            'reservation_total' => 'Итог по бронированию',
            'payment_total' => 'Итог по платежу',
            'authorize_card_use' => 'Авторизовать использование карты',
            'payment_click_here_link' => 'Нажмите здесь для подтверждения платежа',
            'non_beddy_payment_click_here_link' => 'Для подтверждения бронирования перейдите по следующей ссылке: :link',
            'non_beddy_reservation_click_here_link' => 'Для подтверждения платежа перейдите по следующей ссылке: :link',
            'date' => 'Дата',
            'reservation_confirmation' => 'Подтверждение бронирования номер :referenceNumber',
            'payment_confirmation' => 'Подтверждение платежа',
            'sca_reservation_accepted' => 'Сообщаем вам, что ваш запрос на подтверждение формы SCA/PSD2 для бронирования #:referenceNumber был принят клиентом.',
            'sca_payment_accepted' => 'Сообщаем вам, что ваш запрос на подтверждение формы SCA/PSD2 для бронирования #:referenceNumber был принят клиентом.',
        ],
        'confirmation_request_expired' => 'Запрос истек',
        'whatsapp' => [
            'message' => 'Уважаемый(ая) :name :surname, для подтверждения бронирования # :referenceNumber (:arrivalDate - :departureDate) нам необходимо ваше разрешение на использование кредитной карты. Нажмите здесь :link',
        ],
    ],

    'social_archive' => [
        'export_fields' => [
            'property_name' => 'Структура',
            'unlock_email' => 'Email',
            'unlock_date' => 'Дата регистрации',
        ],
    ],

    'statistics' => [
        'partitioning_translations' => [
            'yearly' => 'до года|до :value лет',
            'monthly' => 'до месяца|до :value месяцев',
            'daily' => 'до дня|до :value дней',
        ],
        'warnings' => [
            'limit_truncation' => 'Запрашиваемый период слишком велик. Интервал поиска был ограничен :partitioning_translation.',
            'previous_offset_available_only_with_daily_partitioning' => 'Тип сравнения доступен только при ежедневной визуализации. Период будет сравнен с предыдущим годом',
        ],
        'exceptions' => [
            'invalid_split' => 'Операция недоступна',
            'not_available' => 'Функция временно недоступна',
            'cannot_create_groupable' => 'Неверные параметры для группировки',
            'invalid_date_range' => 'Неверные даты',
        ],
        'legend' => [
            'no_model' => 'Не указано',
            'deleted_rateplans' => 'Удаленные тарифы',
            'no_treatment' => 'Лечение не указано',
            'charges' => 'Ручные дополнительные сборы',
            'no_label' => 'Без имени',
            'stay' => 'Проживание',
            'tax' => 'Налоги',
            'ob' => 'Овербукинг',
            'virtual_stamp' => 'Виртуальная печать',
            'city_tax' => 'Городской налог',
            'no_show' => 'Неявка',
            'cancellation' => 'Отмена за пределами срока',
            'no_show_stay' => 'Проживание при неявке',
            'cancellation_stay' => 'Проживание при отмене за пределами срока',
            'no_show_extra' => 'Дополнительная услуга при неявке',
            'cancellation_extra' => 'Дополнительная услуга при отмене за пределами срока',
            'penalty' => 'Штрафы',
            'general_invoices' => 'Проходные счета',
            'manual' => 'Ручные сборы',
            'payment' => 'Авансы',
            'beddy_channel_labels' => [
                'quote' => 'Beddy (Котировки)',
                'website' => 'Beddy (Веб-сайт)',
                'manual' => 'Beddy (PMS)',
                'general' => 'Beddy (Проходные счета)',
                'google-hotel' => 'Google Hotel',
                'trivago-fast-connect' => 'Trivago',
                'trivago-express-booking' => 'Trivago Express Booking',
                'bookingbooster' => 'Booking Booster',
            ],
        ],
        'label' => 'Дата',
        'label_date' => 'Дата ссылки',
        'label_channel' => 'Канал сегментации',
        'label_accommodation' => 'Сегмент комнаты',
        'label_room' => 'Номер сегмента таблицы',
        'label_booker_category' => 'Сегмент категории клиента',
        'label_rateplan' => 'Сегмент тарифного плана',
        'label_reservation_from' => 'Сегмент источника бронирования',
        'label_nationality' => 'Сегмент национальности',
        'label_property' => 'Сегмент структуры',
        'label_dealer_company' => 'Сегмент компании',
        'label_dealer_agency' => 'Сегмент агентства',
        'label_dealer_tour_operator' => 'Сегмент туроператора',
        'label_production_type' => 'Сегмент отдела',
        'production_over_time' => 'Продажа по периоду',
        'revenue' => 'Продажа',
        'production' => 'Производство по периоду',
        'available_nights' => 'Доступные ночи',
        'unsold_nights' => 'Не проданные ночи',
        'penalty_nights' => 'Ночи с штрафом',
        'arrivals' => 'Прибытия',
        'departures' => 'Отправления',
        'average_stay_length' => 'Средняя продолжительность пребывания',
        'average_guest_earning' => 'Средний доход с гостя',
        'sold_nights' => 'Проданные ночи',
        'occupation_percentage' => 'Заполняемость',
        'total_price' => 'Продажа',
        'adr' => 'ADR',
        'revpar' => 'Revpar',
        'counted_reservations' => 'Общее количество бронирований',
        'confirmed_reservations' => 'Подтвержденные бронирования',
        'cancelled_reservations' => 'Отмененные бронирования',
        'cancellation_ratio' => 'Коэффициент отмены',
        'counted_average_booking_window' => 'Средний срок бронирования',
        'confirmed_average_booking_window' => 'Дни до бронирования',
        'cancelled_average_booking_window' => 'Дни до отмены',
        'rooms_checkin' => 'Комнаты на заезде',
        'rooms_checkout' => 'Комнаты на выезде',
        'label_department' => 'Отдел',
        'label_service' => 'Услуга',
        'gross_amount' => 'Валовая сумма',
        'share_percent' => 'Доля (%)',
        'taxes' => 'НДС',
        'net_amount' => 'Чистая сумма (без НДС)',
        'quantity' => 'Количество',
        'net_revenue' => 'Чистый доход',
        'commissions_amount' => 'Комиссия',
        'in_stay_rooms' => 'Комнаты в пребывании',
        'presence_rooms' => 'Присутствующие комнаты',
        'in_stay_guests' => 'Гости в пребывании',
        'presence_guests' => 'Присутствующие гости',
        'absolute_guests' => 'Гости',
        'gross_amount_without_commissions' => 'Валовая сумма без комиссий',
        'net_amount_without_commissions' => 'Чистая сумма без комиссий и НДС',
        'gt_revenue' => [
            'rooms' => [
                'date' => 'DATE',
                'hotel_capacity' => 'HOTEL_CAPACITY',
                'rooms_sold' => 'ROOMS_SOLD',
                'rooms_ooo' => 'ROOMS_OOO',
                'rooms_revenue' => 'ROOMS_REVENUE',
            ],
            'segments' => [
                'date' => 'DATE',
                'cam_business' => 'CAM_BUSINESS',
                'rev_business' => 'REV_BUSINESS',
                'cam_tour_operator' => 'CAM_TOUR_OPERATOR',
                'rev_tour_operator' => 'REV_TOUR_OPERATOR',
                'cam_ota' => 'CAM_OTA',
                'rev_ota' => 'REV_OTA',
                'cam_beddy' => 'CAM_BEDDY',
                'rev_beddy' => 'REV_BEDDY',
                'cam_diretta' => 'CAM_DIRETTA',
                'rev_diretta' => 'REV_DIRETTA',
            ],
        ],
    ],

    'stripe' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Неизвестная общая ошибка.',
                'next_steps' => 'Свяжитесь с технической поддержкой.',
            ],
            'approve_with_id' => [
                'description' => 'Платеж не может быть авторизован.',
                'next_steps' => 'Платеж следует повторить. Если он не может быть обработан, клиенту нужно связаться с эмитентом карты.',
            ],
            'customer_max_payment_methods' => [
                'description' => 'У клиента уже привязано максимальное количество способов оплаты.',
                'next_steps' => 'Отвяжите некоторые способы оплаты от этого клиента или используйте другого клиента.',
            ],
            'call_issuer' => [
                'description' => 'Карта была отклонена по неизвестной причине.',
                'next_steps' => 'Клиенту необходимо обратиться в банк-эмитент карты для получения дополнительной информации.',
            ],
            'card_not_supported' => [
                'description' => 'Карта не поддерживает этот тип покупки.',
                'next_steps' => 'Клиенту следует попробовать другой способ оплаты.',
            ],
            'card_velocity_exceeded' => [
                'description' => 'Клиент превысил лимит расходов на карте.',
                'next_steps' => 'Клиент должен подождать некоторое время перед повторной попыткой или использовать другую карту.',
            ],
            'currency_not_supported' => [
                'description' => 'Карта не поддерживает указанную валюту.',
                'next_steps' => 'Клиенту нужно использовать карту, которая поддерживает эту валюту.',
            ],
            'do_not_honor' => [
                'description' => 'Карта была отклонена.',
                'next_steps' => 'Клиент должен связаться с эмитентом карты для получения дополнительной информации.',
            ],
            'do_not_try_again' => [
                'description' => 'Карта была отклонена.',
                'next_steps' => 'Не повторяйте попытку платежа. Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'duplicate_transaction' => [
                'description' => 'Недавняя транзакция с такими же данными и суммой уже была отправлена.',
                'next_steps' => 'Клиент должен подождать и попробовать позже.',
            ],
            'expired_card' => [
                'description' => 'Карта истекла.',
                'next_steps' => 'Клиенту нужно использовать другую карту.',
            ],
            'fraudulent' => [
                'description' => 'Транзакция отклонена как подозрительная (мошенничество).',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'generic_decline' => [
                'description' => 'Карта была отклонена.',
                'next_steps' => 'Клиент должен связаться с эмитентом карты для получения дополнительной информации.',
            ],
            'incorrect_number' => [
                'description' => 'Введенный номер карты неверен.',
                'next_steps' => 'Клиент должен проверить номер карты или использовать другую карту.',
            ],
            'incorrect_cvc' => [
                'description' => 'Код безопасности карты (CVC) неверен.',
                'next_steps' => 'Клиент должен проверить CVC или использовать другую карту.',
            ],
            'incorrect_pin' => [
                'description' => 'Введенный PIN-код неверен.',
                'next_steps' => 'Клиент должен ввести правильный PIN-код.',
            ],
            'incorrect_zip' => [
                'description' => 'Почтовый индекс неверен.',
                'next_steps' => 'Клиент должен проверить свой почтовый индекс.',
            ],
            'insufficient_funds' => [
                'description' => 'На карте недостаточно средств.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'invalid_account' => [
                'description' => 'Карта или счет не существуют.',
                'next_steps' => 'Клиенту нужно проверить данные карты или использовать другой метод оплаты.',
            ],
            'invalid_amount' => [
                'description' => 'Сумма платежа неверна.',
                'next_steps' => 'Проверьте сумму и повторите попытку.',
            ],
            'invalid_cvc' => [
                'description' => 'Код безопасности карты (CVC) неверен.',
                'next_steps' => 'Клиент должен проверить CVC или использовать другую карту.',
            ],
            'invalid_expiry_year' => [
                'description' => 'Год истечения срока карты неверен.',
                'next_steps' => 'Клиент должен проверить дату истечения срока или использовать другую карту.',
            ],
            'invalid_number' => [
                'description' => 'Номер карты неверен.',
                'next_steps' => 'Клиент должен проверить номер карты или использовать другую карту.',
            ],
            'issuer_not_available' => [
                'description' => 'Эмитент карты недоступен.',
                'next_steps' => 'Клиенту следует попробовать позже.',
            ],
            'lost_card' => [
                'description' => 'Карта была утеряна.',
                'next_steps' => 'Клиенту нужно использовать альтернативный метод оплаты.',
            ],
            'merchant_blacklist' => [
                'description' => 'Платеж отклонен из-за правил продавца.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'new_account_information_available' => [
                'description' => 'Доступна новая информация об аккаунте карты.',
                'next_steps' => 'Клиент должен проверить обновленные данные с банком.',
            ],
            'no_action_taken' => [
                'description' => 'Эмитент карты не принял никаких действий.',
                'next_steps' => 'Клиенту следует связаться с эмитентом карты для получения дополнительной информации.',
            ],
            'not_permitted' => [
                'description' => 'Платеж не разрешен.',
                'next_steps' => 'Клиент должен связаться с эмитентом карты для получения дополнительной информации.',
            ],
            'offline_pin_required' => [
                'description' => 'Необходим офлайн PIN-код.',
                'next_steps' => 'Клиент должен ввести правильный PIN-код.',
            ],
            'online_or_offline_pin_required' => [
                'description' => 'Необходим онлайн или офлайн PIN-код.',
                'next_steps' => 'Клиент должен ввести правильный PIN-код.',
            ],
            'pickup_card' => [
                'description' => 'Карта должна быть изъята.',
                'next_steps' => 'Клиенту следует обратиться в банк-эмитент для получения дополнительной информации.',
            ],
            'pin_try_exceeded' => [
                'description' => 'Клиент превысил максимальное количество попыток ввода неверного PIN-кода.',
                'next_steps' => 'Клиент должен связаться с эмитентом карты для разблокировки PIN-кода или использовать альтернативный метод оплаты.',
            ],
            'processing_error' => [
                'description' => 'Произошла ошибка обработки.',
                'next_steps' => 'Клиенту следует попробовать позже.',
            ],
            'reenter_transaction' => [
                'description' => 'Платеж должен быть введен снова.',
                'next_steps' => 'Продавцу следует заново ввести платеж.',
            ],
            'restricted_card' => [
                'description' => 'Карта не может быть использована для этого платежа.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'revocation_of_all_authorizations' => [
                'description' => 'Карта была отклонена.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'revocation_of_authorization' => [
                'description' => 'Карта была отклонена.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'security_violation' => [
                'description' => 'Карта была отклонена из-за нарушения безопасности.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'service_not_allowed' => [
                'description' => 'Услуга не разрешена.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'stolen_card' => [
                'description' => 'Карта была украдена.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'stop_payment_order' => [
                'description' => 'Платеж был заблокирован клиентом.',
                'next_steps' => 'Клиенту следует использовать альтернативный метод оплаты.',
            ],
            'testmode_charges_only' => [
                'description' => 'Ваш аккаунт не был активирован и может выполнять только тестовые списания.',
                'next_steps' => 'Активируйте свой аккаунт в панели управления, чтобы начать обработку реальных списаний.',
            ],
            'testmode_decline' => [
                'description' => 'Использована тестовая карта Stripe.',
                'next_steps' => 'Используйте реальную карту для оплаты.',
            ],
            'transaction_not_allowed' => [
                'description' => 'Транзакция не разрешена.',
                'next_steps' => 'Клиенту следует обратиться в эмитент карты для получения дополнительной информации.',
            ],
            'try_again_later' => [
                'description' => 'Эмитент карты не одобрил запрос.',
                'next_steps' => 'Клиенту следует попробовать позже.',
            ],
        ],
    ],

    'tableau' => [
        'errors' => [
            'roomNotFound' => 'Комната не найдена или не существует',
            'tableauNumberNotFound' => 'Номер комнаты неверен.',
            'closureConflict' => 'Невозможно наложить периоды закрытия',
            'lockedRoom' => 'Комната заблокирована или находится в запасе, изменение невозможно',
            'lockedAccommodation' => 'Тип комнаты заблокирован, изменение невозможно',
            'reservation_accommodation_not_fund' => 'Забронированная комната не найдена',
            'accommodation_destination_not_found' => 'Комната назначения не найдена',
            'accommodation_destination_treatment_not_found' => 'Лечение не активировано для выбранной комнаты',
            'accommodation_destination_rateplan_not_found' => 'Выбранный тариф не активен для выбранной комнаты',
            'reservation_locked' => 'Эта бронь заблокирована, изменения невозможны.',
            'exists_reservation_destination' => 'В комнате назначения уже есть бронь, продолжить невозможно!',
            'split_checkin_minor' => 'Указанная дата заезда меньше даты заезда бронирования',
            'split_checkout_major' => 'Указанная дата выезда больше даты выезда бронирования',
            'split_incompatible_rates' => 'Комната назначения несовместима, так как тарифы не совпадают с тарифами исходной комнаты',
            'exists_tableau_closure' => 'В комнате назначения есть закрытие, удалите его перед продолжением',
            'exists_reservation_closure' => 'В выбранный период есть бронирования, невозможно закрыть номер',
            'reservation_not_found' => 'Бронирование не найдено',
            'reservation_accommodation_keep_activated' => 'Номер не может быть перемещен. Для продолжения снимите блокировку в деталях бронирования.',
            'reservation_moved_or_cancelled' => 'Бронирование было перемещено или отменено.',
            'reservation_is_moving' => 'Внимание, операция изменения бронирования уже выполняется. Обновите Tableau и попробуйте снова через несколько минут',
            'closure_just_creating' => 'Закрытие еще активно для этой комнаты, попробуйте позже',
            'closure_just_removing' => 'Удаление закрытия еще активно для этой комнаты, попробуйте позже',
        ],
        'warnings' => [
            'tableauNumberWillBeChanged' => 'Внимание, комната будет перемещена в номер :newTableauNumber',
        ],
    ],

    'technical_notices' => [
        'email' => [
            'failed_log_job_title' => 'Не удалось отправить SendLogJob',
        ],
        'errors' => [
            'channel_unsupported' => 'Канал не поддерживается',
            'property_not_found' => 'Структура не найдена',
        ],
    ],

    'templates_snippets_categories' => [
        'reservation_data' => 'Данные бронирования',
        'property_data' => 'Данные объекта',
        'automatism' => 'Автоматизация',
        'reservations_accommodation_datails' => 'Детали забронированных размещений',
        'reservation_personal_data' => 'Личные данные бронирующего',
        'payments_data' => 'Данные о платежах',
        'cancellation_policy_data' => 'Данные о политике отмены',
        'estimate_data' => 'Данные предварительного расчета',
        'tax_document_data' => 'Данные налоговых документов',
        'payments_timetable' => 'Запланированные платежи',
    ],


    'users' => [
        'new' => [
            'title' => 'Новый пользователь :username',
            'message' => 'Новый пользователь был создан пользователем :self_username',
        ],
        'update' => [
            'title' => 'Пользователь :username изменен',
            'message' => 'Пользователь :username успешно изменен',
            'missing_email_verification_code' => 'Попытка изменения требует подтверждения, мы отправили уведомление на ваш текущий адрес электронной почты.',
        ],
        'delete' => [
            'title' => 'Пользователь :username удален',
            'message' => 'Пользователь :username успешно удален',
            'error_delete_1' => 'Невозможно удалить свой собственный аккаунт.',
        ],
        'errors' => [
            'emailnotfound' => 'Неверный адрес электронной почты',
            'passwordIncorrect' => 'Текущий пароль неверен',
            'reminderNotValid' => 'Неверный или просроченный код',
            'propertyAttached' => 'Пользователь уже связан с данной структурой',
            'propertyDetached' => 'Пользователь не связан с данной структурой',
            'permissionNotFound' => 'Одно из разрешений отсутствует для этого пользователя',
            'tokenNotGenerated' => 'Ошибка при генерации токена',
            'username_exists' => 'Имя пользователя уже занято',
            'email_exists' => 'Адрес электронной почты уже используется',
            'user_not_allowed' => 'Пользователь, который выполнил вход, не имеет прав на создание новых пользователей',
            'cannot_detach_all_auth_verification_methods' => 'Невозможно отключить все методы проверки, хотя бы один из них должен быть активен.',
            'no_active_properties' => 'С вашим аккаунтом не связано ни одного активного объекта. Пожалуйста, свяжитесь со службой поддержки Beddy для получения помощи.'
        ],
    ],

    'vat_quote' => [
        'related_model' => [
            'accommodation' => 'Проживание',
            'addon' => 'Дополнительная услуга',
            'city_tax' => 'Городской налог',
            'manual_charge' => 'Ручной сбор',
            'expense_category' => 'Категория расходов',
            'reservation_payment' => 'Счета и квитанции о депозите',
            'place_tax' => 'Гербовый сбор',
            'reservation_no_show' => 'No Show',
            'reservation_cancellation' => 'Отмена после срока',
        ],
        'log_module' => [
            'vat_quote_created' => 'Ставка НДС создана',
            'vat_quote_updated' => 'Ставка НДС обновлена',
            'vat_quote_deleted' => 'Ставка НДС удалена',
            'vat_quote_default_created' => 'Ставка НДС по умолчанию создана',
            'vat_quote_default_updated' => 'Ставка НДС по умолчанию обновлена',
            'vat_quote_default_deleted' => 'Ставка НДС по умолчанию удалена',
            'property_vat_quote_added' => 'Добавлена ставка НДС',
            'property_vat_quote_replaced' => 'Ставка НДС заменена',
        ],
        'errors' => [
            'vat_quote_associated' => 'Ставка НДС установлена как стандарт для некоторых объектов, невозможно продолжить',
            'insufficient_default_number' => 'Невозможно удалить следующую ставку НДС, так как после удаления не останется ставок НДС по умолчанию для следующих полей: ',
            'invalid_place_id' => 'Параметр Страна не имеет допустимого значения.'
        ]
    ],

    'venice_exemption' => [
        'errors' => [
            'CDAError' => 'Выбранные даты не предусмотрены муниципалитетом Венеции.',
        ],
    ],

    'vrbo' => [
        'checkpoints' => [
            'IsActiveByOwner' => 'Проверьте, активирован ли листинг на Vrbo',
            'IsListingNotArchived' => 'Объект на Vrbo архивирован. Свяжитесь с поддержкой Vrbo',
            'IsActiveByCsr' => 'Поддержка Vrbo деактивировала объект. Свяжитесь с поддержкой Vrbo',
            'HasImages' => 'Отсутствуют изображения (минимум 6)',
            'HasValidatedAddress' => 'Адрес невалиден',
            'HasGeoCode' => 'Неверные или отсутствующие GPS-координаты',
            'HasPropertyAddress' => 'Неверный адрес',
            'HasBathroom' => 'Отсутствуют данные о количестве ванных комнат',
            'HasMaxOccupancy' => 'Отсутствуют данные о максимальной вместимости',
            'HasPropertyDescription' => 'Отсутствует описание',
            'HasPropertyHeadline' => 'Отсутствует заголовок описания',
            'HasPropertyName' => 'Отсутствует название объекта',
            'HasPropertyType' => 'Отсутствует тип объекта',
            'HasRates' => 'Отсутствуют тарифы/доступность',
            'HasRegistrationNumber' => 'Отсутствует номер регистрации',
        ],
    ],

    'webcontroller' => [
        'downloader' => [
            'title_waiting' => 'Подождите...',
            'message_waiting' => 'Запрашиваемая вами операция выполняется... Спасибо за терпение',
            'title_started' => 'Загрузка началась',
            'message_started' => 'Загрузка началась. После завершения загрузки вы можете закрыть это окно',
            'title_error' => 'Ошибка!',
            'message_error' => 'Произошла ошибка при обработке запроса.<br> Пожалуйста, свяжитесь с нами.',
        ],
        'metasearch' => [
            'title_error' => 'Ошибка!',
            'message_error' => 'Произошла ошибка при обработке запроса.',
        ],
    ],

    'welcome_automatic_email' => [
        'email' => [
            'preview_text' => 'Полезная информация для начала работы',
            'subject' => 'Добро пожаловать в Beddy - Начнем настройку!',
            'greetings_text' => 'На сегодня все, еще раз благодарим вас за выбор наших услуг.<br><br>Команда Beddy',
            'training_pms_text_button' => 'ВИДЕО ТРЕНИНГ PMS',
            'training_pms_channel_button' => 'ВИДЕО ТРЕНИНГ CHANNEL MANAGER',
            'model_welcome' => [
                'subject' => 'Добро пожаловать в Beddy - П первые шаги и важная информация',
                'preview_text' => 'Все, что нужно знать',
                'body_1' => 'Добро пожаловать в Beddy,  
                <br><br>
                благодарим за выбор нашего сервиса и приглашаем <b>внимательно следовать инструкциям, которые вы получите в следующих сообщениях</b>, мы рекомендуем добавить адреса support@beddy.io и info@beddy.io в вашу адресную книгу, чтобы избежать попадания наших писем в спам. 
                <br><br>
                Вот инструкции для популярных почтовых провайдеров: 
                <br><br>
                <a href="https://support.google.com/contacts/answer/1069522">Как добавить контакт в Gmail</a>
                <br><br>
                <a href="https://support.microsoft.com/it-it/office/aggiungere-un-contatto-e1dc4548-3bd6-4644-aecd-47b5728f7b0d#ID0EAABAAA=Newer_versions">Как добавить контакт в Outlook</a>',
                'greetings_text' => 'Еще раз благодарим за выбор наших услуг.<br><br>Команда Beddy',
            ],
            'model_A' =>  [
                'body_1' => 'Здравствуйте, :userMasterName,
                <br><br>
                Ниже приведены следующие шаги для настройки вашей учетной записи Beddy.
                <br><br>
                &nbsp;&nbsp;<b>01. Первые шаги – Общая настройка</b>
                <br><br>
                Мы свяжемся с вами в ближайшее время для настройки вашей учетной записи.
                <br><br>
                Начальная настройка очень важна и подготавливает последующие шаги.
                <br><br>
                Рекомендуем <b>заполнить прилагаемую Excel-форму</b> до встречи с нашим оператором, чтобы сократить время настройки.
                <br><br>
                Файл содержит несколько листов, которые необходимо заполнить полностью.<br>
                После завершения отправьте файл на <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                Все поля формы обязательны; отсутствие информации может задержать настройку учетной записи.
                <br><br>
                Если у вас несколько объектов, скопируйте файл Excel и заполните его для каждого объекта.
                <br><br>
                После завершения настройки вы получите данные для входа.',
                'body_2' => '&nbsp;&nbsp;<b>02. Обучение - Тренинг по PMS</b>
                <br><br>
                После завершения настройки мы свяжемся с вами для назначения <b>тренинга</b> по функционалу PMS.
                <br><br>
                Тренинг длится <b>90 минут</b> и в нем могут участвовать сотрудники.
                <br><br>
                Пока вы ждете тренинга, рекомендуем ознакомиться с функционалом программного обеспечения через онлайн-обучение.',
                'body_3' => '&nbsp;&nbsp;<b>03. Подключение каналов - Настройка Channel Manager</b>
                <br><br>
                После завершения тренинга по PMS будет назначена новая встреча для подключения каналов. 
                Обратите внимание, что после активации Channel Manager использование старых систем или extranet порталов будет невозможно.',
                'body_4' => '&nbsp;&nbsp;<b>04. Обучение - Тренинг по Channel Manager</b>
                <br><br>
                После завершения подключения вам будет предложено пройти тренинг по функциям Channel Manager, который состоится в тот же день в 12:30.
                <br><br>
                Тренинг длится <b>30 минут</b> и в нем могут участвовать сотрудники.
                <br><br>
                Пока вы ждете тренинга, рекомендуем ознакомиться с функционалом программного обеспечения через онлайн-обучение.',
            ],
            'errors' => [
                'fail_to_send' => 'Не удалось отправить письмо на адрес :email_address',
            ],
            'model_D' => [
                'body_1' => 'Здравствуйте, :userMasterName,
                <br><br>
                Ниже приведены следующие шаги для настройки вашей учетной записи Beddy. Пожалуйста, внимательно прочитайте это сообщение и предоставьте необходимые данные для ускорения процесса.
                <br><br>
                &nbsp;&nbsp;<b>01. Первые шаги – Общая настройка</b>
                <br><br>
                Мы свяжемся с вами в ближайшее время для настройки вашей учетной записи.
                <br><br>
                Перед встречей с оператором, пожалуйста:
                <br><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>заполните прилагаемую Excel-форму</b><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>запросите сопоставление объектов и тарифов</b> у вашего внешнего поставщика услуг, подключаемого к Beddy<br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>отправьте форму и сопоставление</b> на <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
                Эти данные <b>очень важны</b> для ускорения настройки.
                <br><br>
                Все поля формы обязательны; отсутствие информации может задержать настройку учетной записи.
                <br><br>
                Если у вас несколько объектов, заполните форму и запрос сопоставления для каждого объекта.
                <br><br>
                После завершения настройки вы получите данные для входа.',
                'body_2' => '&nbsp;&nbsp;<b>02. Обучение - Тренинг по PMS</b>
                <br><br>
                После завершения настройки мы свяжемся с вами для назначения группового тренинга по функционалу PMS.
                <br><br>
                Тренинг длится <b>90 минут</b> и в нем могут участвовать сотрудники.
                <br><br>
                Пока вы ждете тренинга, рекомендуем ознакомиться с функционалом программного обеспечения через онлайн-обучение.',
                'body_3' => '&nbsp;&nbsp;<b>03. Обучение - Channel Manager, интегрированный в Beddy</b>
                <br><br>
                После завершения процедуры подключения вам будет предложено пройти групповое обучение по использованию PMS для обновления тарифов, доступности и ограничений через внешний Channel Manager.
                <br><br>
                Сессии проводятся в понедельник в 15:00 и среду/пятницу в 11:30.
                <br><br>
                Тренинг длится 60 минут, сотрудники также могут участвовать.
                <br><br>
                Если Channel Manager интегрирован в режим "только загрузка бронирований", тренинг является необязательным, но рекомендуется при управлении тарифами через PMS.',
                'body_4' => '&nbsp;&nbsp;<b>04. Подключение Channel Manager, интегрированного в Beddy</b>
                <br><br>
                После завершения тренинга PMS будет назначена новая встреча для подключения внешнего Channel Manager к Beddy.',
            ],
            'model_C' => [
                'body_1' => 'Здравствуйте, :userMasterName,
                <br><br>
                Ниже приведены следующие шаги для настройки вашей учетной записи Beddy.
                <br><br>
                &nbsp;&nbsp;<b>01. Первые шаги – Общая настройка</b>
                <br><br>
                Мы свяжемся с вами в ближайшее время для настройки вашей учетной записи.
                <br><br>
                Начальная настройка очень важна и подготавливает последующие шаги.
                <br><br>
                Рекомендуем <b>заполнить прилагаемую Excel-форму</b> до встречи с нашим оператором, чтобы сократить время настройки.
                <br><br>
                Файл содержит несколько листов, которые необходимо заполнить полностью.<br>
                После завершения отправьте файл на <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                Все поля формы обязательны; отсутствие информации может задержать настройку учетной записи.
                <br><br>
                Если у вас несколько объектов, скопируйте файл Excel и заполните его для каждого объекта.
                <br><br>
                После завершения настройки вы получите данные для входа.',
                'body_2' => '&nbsp;&nbsp;<b>02. Обучение - Channel Manager</b>
                <br><br>
                После завершения настройки мы свяжемся с вами для назначения <b>тренинга</b> по функционалу Channel Manager.
                <br><br>
                Тренинг длится <b>60 минут</b> и в нем могут участвовать сотрудники.
                <br><br>
                Пока вы ждете тренинга, рекомендуем ознакомиться с функционалом программного обеспечения через онлайн-обучение.',
                'body_3' => '&nbsp;&nbsp;<b>03. Подключение каналов - Настройка Channel Manager</b>
                <br><br>
                После завершения тренинга будет назначена новая встреча для подключения каналов. 
                Обратите внимание, что после активации Channel Manager использование старых систем или extranet порталов будет невозможно.',
            ],
            'model_B' => [
                'body_1' => 'Здравствуйте, :userMasterName,
                <br><br>
                Ниже приведены следующие шаги для настройки вашей учетной записи Beddy.
                <br><br>
                &nbsp;&nbsp;<b>01. Первые шаги – Общая настройка</b>
                <br><br>
                Мы свяжемся с вами в ближайшее время для настройки вашей учетной записи.
                <br><br>
                Начальная настройка очень важна и подготавливает последующие шаги.
                <br><br>
                Рекомендуем <b>заполнить прилагаемую Excel-форму</b> до встречи с нашим оператором, чтобы сократить время настройки.
                <br><br>
                Файл содержит несколько листов, которые необходимо заполнить полностью.<br>
                После завершения отправьте файл на <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                Все поля формы обязательны; отсутствие информации может задержать настройку учетной записи.
                <br><br>
                Если у вас несколько объектов, скопируйте файл Excel и заполните его для каждого объекта.
                <br><br>
                После завершения настройки вы получите данные для входа.',
                'body_2' => '&nbsp;&nbsp;<b>02. Обучение - Тренинг по PMS</b>
                <br><br>
                После завершения настройки мы свяжемся с вами для назначения <b>тренинга</b> по функционалу PMS.
                <br><br>
                Тренинг длится <b>90 минут</b> и в нем могут участвовать сотрудники.
                <br><br>
                Пока вы ждете тренинга, рекомендуем ознакомиться с функционалом программного обеспечения через онлайн-обучение.',
                'body_3' => '&nbsp;&nbsp;<b>03. Тренинг - Управление тарифами и доступностью</b>
                <br><br>
                После завершения настройки вам будет предложено пройти тренинг по функциям Channel Manager, который состоится в 12:30 в тот же день.
                <br><br>
                Даже если Channel Manager отсутствует в лицензии, участие в тренинге обязательно, так как ввод тарифов и доступности на PMS выполняется теми же операциями.
                <br><br>
                Тренинг длится <b>30 минут</b> и в нем могут участвовать сотрудники.',
            ],
        ],
        'errors' => [
            'fail_to_send' => 'Не удалось отправить письмо на адрес :email_address',
        ],
    ],
    'zdatalake' => [
        'Group' => 'Группа',
        'Single' => 'Один человек',
        'Family' => 'Семья',
        'Couple' => 'Пара',
    ],
    'booking_booster_configuration' => [
        'errors' => [
            'configuration_not_found' => 'Конфигурация не найдена',
        ],
    ],
    'booking_booster' => [
        'errors' => [
            'auth_token' => 'Не удалось получить токен аутентификации Booking Booster для этой ошибки: :error',
            'available_budget' => 'Не удалось получить доступный бюджет для этой ошибки: :error',
            'campaigns_statistics' => 'Не удалось получить статистику кампаний для этой ошибки: :error',
            'ads_statistics' => 'Не удалось получить статистику объявлений из-за этой ошибки: :error',
            'ads_details' => 'Не удалось получить детали объявлений из-за этой ошибки: :error',
            'property_targets' => 'Невозможно получить цели объектов для этой ошибки: :error',
            'client_error' => 'Неверные учетные данные или нет разрешения на доступ к запрашиваемым ресурсам. Подробности: :error',
            'server_error' => 'Мы испытываем технические трудности. Пожалуйста, попробуйте позже. Подробности: :error',
            'connection_error' => 'Не удается подключиться к Booking Booster. Пожалуйста, попробуйте позже. Подробности: :error'
        ],
        'warnings' => [
            'property_not_mapped' => 'Следующие объекты не отображены и могут не корректно отображаться в статистике кампаний: :propertyNames'
        ]
    ],
    'zpay' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Неизвестная общая ошибка.',
                'next_steps' => 'Свяжитесь с технической поддержкой.',
            ],
            'validation_failed' => [
                'description' => 'Авторизация карты не удалась',
                'next_steps' => 'Клиент должен использовать другую карту.',
            ],
            'canceled' => [
                'description' => 'Запрос был отменен',
                'next_steps' => 'Клиент должен отправить новый запрос.',
            ],
            'failed' => [
                'description' => 'Запрос не выполнен',
                'next_steps' => 'Клиент должен отправить новый запрос.',
            ],
            'waiting_for_payment' => [
                'description' => 'Запрос ожидает оплаты',
                'next_steps' => 'Клиент должен подтвердить оплату.',
            ],
            'requires_capture' => [
                'description' => 'Запрос ожидает подтверждения',
                'next_steps' => 'Клиент должен авторизовать операцию.',
            ],
            'refunded' => [
                'description' => 'Платеж возвращен',
                'next_steps' => 'Платеж был успешно возвращен.',
            ],
            'partially_refunded' => [
                'description' => 'Платеж частично возвращен',
                'next_steps' => 'Платеж был частично возвращен.',
            ],
            'processing' => [
                'description' => 'Платеж обрабатывается',
                'next_steps' => 'Ожидайте результат операции.',
            ],
        ],
    ]
];
