<?php
$suffix = ' per l\'ospite :customer_name, alloggio :tableau_number - :accommodation_name';
$roomReservationSuffix = ' in der Unterkunft :accommodation_name - Buchung :reservation_booker - :reservation_reference_number';
$reservationSuffix = ' unter den Gästen, die in der Buchung gesendet werden sollen: :reservation_booker - :reservation_reference_number';
$customerReservationSuffix = ' :customer_name - :reservation_reference_number';
$customerEmptyDataSuffix = 'für den Gast :customer_name der Buchung :reservation_reference_number';

return [

    'accommodations' => [
        'errors' => [
            'attachExist' => 'Tarifplan existiert bereits',
            'detachNotExist' => 'Tarifplan für das Zimmer nicht vorhanden.',
            'detachStandardRateplan' => 'Sie können den Standardtarifplan nicht löschen',
            'guestsCnfigurationBase' => 'Sie können keine Rabatte auf den Basissatz an',
            'virtualRidondanceConflict' => 'Sie können diesen Raum nicht verbinden. Ein Link existiert bereits.',
            'parentTreeExist' => 'Die Hauptkammer ist bereits zugeordnet oder Sie können nicht die Mutter Kammer Quote überschreiten. ',
            'quantityZero' => 'Sie können den zuletzt verfügbaren Raum nicht löschen',
            'quantityNotValid' => 'Sie senden eine Menge, die kleiner oder gleich der bereits vorhandenen ist',
            'quantitySum' => 'Die Menge an ',
            'quantitySuperior' => 'Es ist nicht möglich, die Quote der Mutter Raum zu überschreiten',
            'quantityWithReservation' => 'Es gibt Reservierungen, Sie können diese Zimmernummer nicht löschen',
            'numberNotAvail' => 'Zimmernummern nicht verfügbar',
            'guestsConfigurationBase' => 'Es ist nicht möglich, einen Rabatt auf die Grundkonfiguration anzuwenden',
            'tooManyAdults' => 'Anzahl der Erwachsenen über dem Grenzwert',
            'tooManyChildren' => 'Anzahl der Kinder über die Grenze',
            'stillConnected' => 'Kammer noch mit einem oder mehreren Portalen verbunden',
            'stillVirtual' => 'Kammer immer noch mit einer anderen verbunden',
            'stillReserved' => 'Es gibt Reservierungen für dieses Zimmer',
            'notVirtualToSum' => 'Die Anleihen dieses Raumes sind nicht genug',
            'notVirtualQty' => 'Das Kammerkontingent muss 1 sein',
            'notVirtualChildQty' => 'Das Kontingent des verbundenen Raums muss 1 sein',
            'notVirtualSum' => 'Dies ist kein Summenraum',
            'isVirtual' => 'Virtueller Raum, Betrieb nicht erlaubt',
            'isNotVirtual' => 'Kein virtueller Raum, Betrieb nicht erlaubt',
            'ruleToBundle' => 'Sie können die Paketregeln nicht ändern',
            'noRateplanExist' => 'Mit dieser Unterkunft ist kein Tarif verbunden',
            'ruleIsLocked' => 'Sie können keine Regel für "All Linked"-Zimmer ändern.',
            'duplicateLabel' => 'Dieser Name kann nicht verwendet werden, da er bereits von verwendet wird',
        ],
        'warnings' => [
            'request_confirm_delete_tableau_number' => 'Es sind verbundene Zimmer vorhanden, fortfahren?',
            'accommodation_tableau_not_found' => 'Tableau-ID :tableau_number_id nicht mit dem Zimmer mit ID :accommodation_id verknüpft oder nicht gefunden',
            'accommodation_beds_types_combination_not_found' => 'Kombination mit ID :acc_bed_type_combination_id im Zimmer mit ID :accommodation_id nicht gefunden',
            'confimation_delete_father_and_childs_combinations' => "Sie sind dabei, eine übergeordnete Ausstattungsvariante (ID: :combination_id) zu löschen. Durch fortfahren werden auch alle zugehörigen untergeordneten Ausstattungsvarianten automatisch gelöscht. Möchten Sie fortfahren?",
            'invalid_facility' => 'Nicht kompatible Einrichtung',
        ],
        'channel' => [
            'single_use_exists' => 'Das Zimmer :accommodation_name - :acommodation_ratename ist bereits verknüpft oder wurde bereits erstellt',
            'single_use_dont_exists' => 'Kanalzimmer mit ID :accommodation_channel_id wurde nicht gefunden',
            'email' => [
                'new_title' => 'Neue Zimmer für den Kanal :channel_name hinzugefügt - Unterkunft: :property_name - ID Unterkunft: :property_id',
                'deleted_title' => 'Zimmer für den Kanal :channel_name gelöscht - Unterkunft: :property_name - ID Unterkunft: :property_id',
                'attached_title' => 'Nicht verknüpfte Zimmer für die Unterkunft festgestellt: :property_name - ID Unterkunft: :property_id',
                'conflict_rule' => 'Regelkonflikt für den Kanal :channel_name - Unterkunft: :property_name - ID Unterkunft: :property_id',
            ],
        ],
        'fields' => [
            'model_name' => 'Zimmer',
            'checkin' => 'Check-in',
            'checkout' => 'Check-out',
            'checkin_hour' => 'Check-in-Zeit',
            'checkout_hour' => 'Check-out-Zeit',
            'checkin_arrival_preference' => 'Check-in-Präferenz',
        ],
    ],

    'account_renewal' => [
        'email' => [
            'subject' => 'Automatische Erneuerung der Beddy-Strukturen - :monthAndYear',
        ],
    ],

    'addon' => [
        'price_type' => [
            'xunit' => 'Pro Einheit', // 1
            'xpax' => 'Pro Person pro Nacht', // 2
            'xweekxpax' => 'Pro Person wöchentlich', // 3
            'xbookxpax' => 'Einmalig pro Person', // 4
            'xnight' => 'Pro Nacht', // 5
            'xweek' => 'Wöchentlich', // 6
            'xbook' => 'Einmalig', // 7
        ],
        'warnings' => [
            'not_available' => 'Für den ausgewählten Zeitraum nicht verfügbar',
            'min_stay_violated' => 'Der Mindestaufenthalt beträgt :min_stay',
            'max_stay_violated' => 'Der maximale Aufenthalt beträgt :max_stay',
            'release_violated' => 'Die maximale Vorlaufzeit beträgt :release',
            'rateplan_excluded' => 'Rateplan :rateplan für den zusätzlichen Service am Tag :date ausgeschlossen',
            'treatment_excluded' => 'Behandlung :treatment für den zusätzlichen Service am Tag :date ausgeschlossen',
            'weekdays_excluded' => 'Ein oder mehrere Wochentage ausgeschlossen',
        ],
        'errors' => [
            'not_in_stay' => 'Ausgewählte Daten liegen außerhalb des Aufenthaltszeitraums des Zimmers',
            'not_found' => 'Zusatzleistung nicht mit dem gewünschten Zimmer verknüpft',
            'billed_addon' => 'Zusatzleistung kann nicht storniert werden, da sie mit offenen Konten verbunden ist',
        ],
        'logger' => [
            'added' => ':label für :accommodation_name mit Preis :price (:date) #:id',
        ],
    ],

    'admin' => [
        'errors' => [
            'not_demo' => 'Die Struktur muss vom Typ DEMO sein',
            'no_accommodations' => 'Die Struktur hat keine Unterkünfte',
            'no_rateplans' => 'Die Struktur hat keine Tarifpläne',
            'channelmanager_module_needed' => 'Das Channel-Manager-Modul ist nicht aktiviert',
            'channel_beddy_only' => 'Die Unterkunft muss ausschließlich den derzeit aktiven Beddy-Kanal haben',
        ],
    ],

    'api_partners' => [
        'contacts_types' => [
            'manager_email' => 'E-Mail des Managers',
            'technical_manager_email' => 'E-Mail des technischen Managers',
            'customer_service_email' => 'E-Mail des Kundenservice',
            'commercial_requests_email' => 'E-Mail für kommerzielle Anfragen',
        ],
        'errors' => [
            'cannot_delete_has_users' => 'Der Partner kann nicht gelöscht werden, da ihm Benutzer zugeordnet sind',
            'action_not_allowed' => 'Sie sind nicht berechtigt, auf den Dienst :service zuzugreifen.',
            'max_days' => 'Das maximale Intervall beträgt :days Tage.',
            'date_filters' => 'Du kannst pro Anfrage nur einen Typ von Datumsfilter verwenden, nicht mehrere gleichzeitig.',
            'cannot_delete_guest_city_tax' => 'Gast :guestId für die Buchung :reservationId kann nicht gelöscht werden, da die Kurtaxe bereits in Rechnung gestellt wurde.',
            'too_many_reservation_ids' => 'Es können nicht mehr als :max reservationIds pro Anfrage übergeben werden. Du hast derzeit :count übergeben.',
            'reservations_not_found' => 'Die folgenden Reservierungen wurden nicht gefunden oder du hast keinen Zugriff: :ids',
            'customer_id_or_customer_required' => 'Sie müssen mindestens eines von customerId oder customer angeben.',
            'customer_id_and_customer_conflict' => 'Sie können nicht gleichzeitig customerId und customer angeben. Bitte wählen Sie eines.'
        ],
        'services' => [
            'ping' => 'Ping',
            'get_infos' => 'Informationen abrufen',
            'hotel_rateplan' => 'Tarifplan',
            'push_availabilities' => 'Verfügbarkeiten eingeben',
            'push_rates' => 'Preise eingeben',
            'reservations_lookup' => 'Buchungen suchen',
            'reservations_acknowledge' => 'Empfangsbestätigung für Buchungen',
            'hotel_res_modify_notif' => 'Benachrichtigung über Buchungsänderungen',
            'reservation_send_message' => 'Nachrichten senden',
            'reservation_message_status' => 'Nachrichtenstatus überprüfen',
            'modify_reservation' => 'Buchungen bearbeiten',
            'media' => 'Anhänge',
            'modify_media' => 'Anhänge bearbeiten',
            'delete_media' => 'Anhänge löschen',
            'invoices' => 'Rechnungen',
            'credit_card' => 'Kreditkarte',
            'all_guests' => 'Alle Gäste',
            'get_invoices' => 'Rechnungen abrufen',
            'generic_bol' => 'Allgemeines über die Buchungsmaschine',
            'hotel_quote_request' => 'Anfrage für Angebote',
            'revenue_data' => 'Daten zu Belegung und Einnahmen abrufen'
        ],
    ],
    'api_partner_detail' => [
        'fields' => [
            'country_id' => 'Länderbezeichner',
            'city_id' => 'Stadtbezeichner',
            'state_id' => 'Bundesstaatbezeichner',
            'county_id' => 'Landkreisbezeichner',
        ]
    ],
    'auth_verification_methods' => [
        'your_pin' => 'Ihre Zugangspin für Beddy',
        'email_authentication' => [
            'get_connection_info_message' => 'Wir haben Ihnen gerade per E-Mail den PIN-Code gesendet, um die Authentifizierung abzuschließen.',
            'pin_invalid' => 'Der eingegebene PIN-Code ist ungültig.',
        ],
        'google_authentication' => [
            'get_connection_info_message' => 'Überprüfen Sie Ihren Google Authenticator, um den PIN-Code zur Authentifizierung zu erhalten.',
            'pin_invalid' => 'Der eingegebene PIN-Code ist ungültig.',
        ],
        'error_pin_invalid' => 'Fehler. Bitte überprüfen Sie, ob die eingegebene PIN korrekt ist',
    ],

    'availability' => [
        'errors' => [
            'not_found' => 'Verfügbarkeit für dieses Zimmer nicht gefunden',
        ],
    ],

    'bills' => [
        'ordination_of_date' => 'Bestellung vom :date',
        'vat_title' => 'USt.-ID',
        'accommodation' => 'Unterkunft',
        'total' => 'Gesamt',
        'service' => 'Dienstleistung',
        'quantity_abbreviated' => 'Menge',
        'amount' => 'Betrag',
        'sign' => 'Unterschrift',
        'account_balance_by_date' => 'Kontostand nach Datum',
        'account_balance_by_buyer' => 'Kontostand nach Zahler',
        'account_balance_by_guest' => 'Kontostand nach Gast',
        'account_balance_by_accommodation' => 'Kontostand nach Unterkunft',
        'account_balance' => 'Kontostand',
        'payer' => 'Zahler',
        'quantity' => 'MENGE',
        'date' => 'Datum',
        'notes' => 'Notizen',
        'scloby' => [
            'ordination_name' => 'Tilby-Verkauf',
            'ordination_from_sale' => 'Bestellung aus Tilby-Verkauf erstellt',
            'confirmation_mode' => 'Bestätigungsmodus',
            'confirmation_by_phone' => 'Telefonnummer',
            'confirmation_by_signature' => 'Unterschrift',
        ],
        'log' => [
            'refunds' => 'Die Belastung :bill_label (:bill_common_id) wurde mit :refunded erstattet',
        ],
    ],

    'booking_onboard' => [
        'no_contract_found' => 'Kein Vertrag für diese Unterkunft gefunden',
    ],

    'bookingengine' => [
        'addons_type' => [
            'xweek' => 'Pro Woche',
            'xnight' => 'Pro Nacht',
            'xpax' => 'Pro Person und Nacht',
            'xunit' => 'Pro Stück',
            'xbook' => 'Pro Buchung',
            'xbookxpax' => 'Pro Person einmalig',
            'xweekxpax' => 'Pro Person und Woche',
        ],
        'errors' => [
            'min_expense_coupon' => 'Der Gutschein kann nicht für den Wert der aktuellen Reservierung verwendet werden',
            'min_stay_coupon' => 'Der Gutschein kann nicht für die Anzahl der Nächte der aktuellen Reservierung verwendet werden',
            'max_stay_coupon' => 'Der Gutschein kann nicht für die maximale Anzahl von Übernachtungen der aktuellen Buchung verwendet werden',
            'invalid_days_coupon' => 'Der Gutschein kann nicht für Wochentage der aktuellen Buchung verwendet werden',
            'invalid_conditions_coupon' => 'Der Gutschein kann nicht für die Ausschlussbedingungen der aktuellen Reservierung verwendet werden',
            'invalid_periods_coupon' => 'Der Gutschein kann nicht für die aktuellen Reservierungsdaten verwendet werden',
            'invalid_coupon' => 'Ungültiger oder nicht vorhandener Gutschein',
            'already_coupon' => 'Sie können keine anderen Gutscheine verwenden',
            'availability_ended' => 'Die ausgewählten Zimmer sind nicht mehr verfügbar',
            'cart_empty_accommodation' => 'Es sind keine Zimmer im Warenkorb',
            'date_past_quote_expire' => 'Das Zimmer kann nicht in den Kostenvoranschlag aufgenommen werden, da das Abreisedatum vor dem Ablaufdatum des Kostenvoranschlags liegt',
            'process_cart_date_past' => 'Fortfahren unmöglich, weil das Abreisedatum eines Zimmers vor dem heutigen Datum liegt',
            'change_expire_date_quote_past' => 'Das Ablaufdatum des Kostenvoranschlags liegt vor dem Abreisedatum eines oder mehrerer Zimmer',
            'quote_expired' => 'Der Kostenvoranschlag ist abgelaufen',
            'quote_accepted' => 'Der Kostenvoranschlag wurde bereits angenommen',
            'quote_not_active' => 'Der Kostenvoranschlag ist nicht aktiv',
            'quote_just_confirmed' => 'Der Kostenvoranschlag wurde bereits bestätigt, sein Status kann nicht mehr verändert werden',
            'payment_not_valid' => 'Ungültige Zahlungsart',
            'module_quote_not_active' => 'Das Kostenvoranschlag-Formular ist für diese Einrichtung nicht aktiv',
            'quote_option_no_availability' => 'Für diese Option gibt es keine Verfügbarkeit mehr',
            'addon_excluded_from_coupon' => 'Das Extra ":addon_name" kann nicht hinzugefügt werden, weil es von dem verwendeten Gutschein ausgeschlossen ist',
            // Sezione sblocco offerte
            'unlock_wrong_accommodation' => 'Das Zimmer ist nicht korrekt.',
            'unlock_wrong_accommodation_to_property' => 'Das Zimmer gehört nicht zu der Einrichtung.',
            'unlock_rateplan_not_unlockable' => 'Das Angebot kann nicht freigeschaltet werden.',
            // estimate addon
            'estimate_addon_failure' => 'Die Suchangaben sind nicht korrekt',
            // errori generali in step intermedi
            'step_not_complete' => 'Einige Schritte sind unvollständig',
            'property_different' => 'Sie haben Zimmer von verschiedenen Einrichtungen ausgewählt',
            'data_sent_not_correct' => 'Die gesendeten Daten sind nicht korrekt',
            'no_dns_found' => 'Keine DNS zugeordnet zu :subdomain',
            'no_payment_method_available' => 'Keine Zahlungsmethode eingerichtet',
            'session_expired' => 'Sitzung abgelaufen',
            'booking_in_progress' => 'Reservierung ist bereits in Bearbeitung',
            'quote_option_no_availability_linked' => 'Unterkunft nicht verfügbar und andere Unterkünfte angeschlossen, überprüfen Sie das Tableau nach der Bestätigung des Zitats.',
            'quote_option_no_availability_accommodation' => 'Einige Unterkünfte sind nicht verfügbar, das Tableau überprüfen, wenn das Zitat bestätigt.',
            // alternative search
            'search_not_found' => 'Suche nicht gefunden',
            'failed_to_create_reservation' => 'Beim Erstellen der Reservierung ist ein Fehler aufgetreten',
            'invalid_stay_coupon' => 'Coupon nicht gültig für den ausgewählten Aufenthaltszeitraum',
            'create_quote_order_already_exist' => 'Angebotsauftrag bereits in Bearbeitung (Cache vorhanden) - Referenz :reference',
            'create_order_already_exist' => 'Reihenfolge bereits in der Verarbeitung (Cache vorhanden) - SID :sid',
        ],
        'persuasive_sentences' => [
            'prepayment' => 'Vorauszahlung',
            'hotel_payment' => 'Zahlung im Hotel. Sie zahlen jetzt nichts',
            'free_cancellation_until' => 'Kostenlose Stornierung bis zum :date_limit',
            'cancellation_term' => 'Reservierungsbedingungen',
            'cheapest_rate' => 'Dies ist der günstigste Preis',
        ],
        'payment_method_description' => [
            'transfer' => 'kein hinterlegter Text',
            'transfer_deposit' => 'Es muss eine Vorauszahlung geleistet werden in Höhe von :deposit, dieser Betrag wird zurückerstattet, wenn dies in den Stornierungsbestimmungen dieses Tarifs vorgesehen ist. Sie erhalten die Details zur Durchführung der Überweisung per E-Mail. ',
            'cc_a_garanzia' => 'Keine zusätzlichen Kosten! Die Kreditkarte dient nur zur Sicherung der Reservierung. Sie müssen keine Anzahlung leisten. Sie zahlen die Gesamtkosten der Reservierung direkt während Ihres Aufenthalts in :property_name.',
            'cc_pos' => 'Keine zusätzlichen Kosten! Die Kreditkarte dient nur zur Sicherung der Reservierung. Sie müssen keine Anzahlung leisten. Sie zahlen die Gesamtkosten der Reservierung direkt während Ihres Aufenthalts in :property_name.',
            'cc_pos_deposit' => 'Es muss eine Vorauszahlung geleistet werden in Höhe von :deposit, dieser Betrag wird zurückerstattet, wenn dies in den Stornierungsbestimmungen dieses Tarifs vorgesehen ist.',
            'cc_stripe_deposit' => 'Die Zahlung erfolgt über das Stripe-Zahlungsgateway. Es ist eine Anzahlung in Höhe von :deposit, wird dieser Betrag zurückerstattet, wenn sie von den Bedingungen der Stornierung dieser Rate erforderlich.',
            'availability_request' => 'Für den ausgewählten Zeitraum ist nur die Option Buchungsanfrage aktiv. Basierend auf den ausgewählten Parametern wird die Anfrage so schnell wie möglich bearbeitet und empfangen.',
            'cc_paypal_deposit' => 'Die Zahlung erfolgt über das Paypal-Zahlungsgateway. Es gibt eine Vorauszahlung von :deposit, dieser Betrag wird zurückerstattet, wenn dies gemäß den Stornierungsbedingungen dieses Tarifs erforderlich ist.',
            'cc_paypal_deposit_with_commission' => 'Die Zahlung erfolgt über das Paypal-Zahlungsgateway. Es gibt eine Vorauszahlung von :deposit + :commission, dieser Betrag wird zurückerstattet, wenn dies gemäß den Stornierungsbedingungen dieses Tarifs erforderlich ist.',
            'nexi_deposit' => 'Die Zahlung erfolgt über das Nexi-Zahlungsgateway. Eine Vorauszahlung von :deposit ist vorgesehen, dieser Betrag wird zurückerstattet, wenn dies in den Stornierungsbedingungen dieses Tarifs vorgesehen ist.',
            'zpay_deposit' => 'Die Zahlung erfolgt über das ZPay-Zahlungsgateway. Eine Vorauszahlung von :deposit ist erforderlich, die erstattungsfähig ist, sofern dies in den Stornierungsbedingungen dieses Tarifs vorgesehen ist. <a href="https://www.zpay.it/privacy" target="_blank">Datenschutzerklärung</a> von ZPay.',
        ],
        'automatic_payment_method_description' => [
            'transfer' => 'kein Einzahlungstext',
            'transfer_deposit' => 'Sie erhalten die Details zur Überweisung per E-Mail.',
            'cc_a_garanzia' => 'Keine Vorauszahlung erforderlich. Sie zahlen gemäß den in den Zahlungsbedingungen angegebenen Fristen.',
            'cc_pos' => 'Keine zusätzlichen Kosten! Die Kreditkarte wird nur zur Sicherung der Reservierung verwendet. Sie müssen keine Anzahlung leisten. Sie zahlen den gesamten Buchungsbetrag direkt bei :property_name während Ihres Aufenthalts.',
            'cc_pos_deposit' => 'Eine Vorauszahlung von :deposit ist erforderlich, dieser Betrag wird erstattet, wenn dies von den Stornierungsbedingungen dieser Rate vorgesehen ist.',
            'cc_stripe_deposit' => 'Die Zahlung erfolgt über das Stripe-Zahlungsgateway.',
            'nexi_deposit' => 'Die Zahlung erfolgt über das Nexi-Zahlungsgateway. <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Nexi Datenschutzerklärung</a>.',
            'zpay_deposit' => 'Die Zahlung erfolgt über das ZPay-Zahlungsgateway. Eine Vorauszahlung von :deposit ist erforderlich, die erstattungsfähig ist, sofern dies in den Stornierungsbedingungen dieses Tarifs vorgesehen ist. <a href="https://www.zpay.it/privacy" target="_blank">Datenschutzerklärung</a> von ZPay.',
            'cc_paypal_deposit' => 'Die Zahlung erfolgt über das Paypal-Zahlungsgateway.',
            'availability_request' => 'Diese Anfrage stellt keine tatsächliche Reservierung dar, Sie können jedoch Verfügbarkeitsinformationen anfordern, indem Sie das folgende Formular ausfüllen. Die Reservierungsanfrage wird so schnell wie möglich bestätigt.',
            'cc_paypal_deposit_with_commission' => 'Die Zahlung erfolgt über das Paypal-Zahlungsgateway.',
        ],
        'validators' => [
            'errors' => [
                'credit_card_expire_date' => 'Ungültiges Ablaufdatum der Kreditkarte.',
                'credit_card_number' => 'Ungültige Kreditkartennummer.',
                'credit_card_holder' => 'Ungültiger Karteninhaber.',
                'credit_card_type_id' => 'Kreditkartentyp wird nicht unterstützt.',
                'email' => 'Ungültige E-Mail-Adresse des Gastes.',
                'surname' => 'Ungültiger Nachname des Gastes.',
                'name' => 'Ungültiger Vorname des Gastes.',
            ],
        ],
    ],

    'cash_desk_closure' => [
        'title' => 'Kassenabschluss',
        'invoice' => 'Rechnung',
        'invoices' => 'Rechnungen',
        'receipt' => 'Quittung',
        'receipt_follows_invoice' => 'Quittung folgt Rechnung',
        'receipts' => 'Quittungen',
        'type' => 'Typ',
        'status' => 'Bezahlt',
        'deposit' => 'Anzahlung',
        'recipient_business_name' => 'Empfänger',
        'taxable' => 'Steuerpflichtig',
        'vat_quote' => 'MwSt.',
        'total' => 'Gesamt',
        'payments' => 'Zahlungen',
        'totals' => 'GESAMTSUMMEN',
        'cash_type' => 'Art der Zahlung',
        'reversal_receipt' => 'Stornierung Quittung',
        'reversal_receipts' => 'Stornierungen Quittungen',
        'to_give' => 'Geben',
        'to_have' => 'Haben',
        'balance' => 'Saldo',
        'documents' => 'Dokumente',
        'deposits' => 'Anzahlungen',
        'cash_desk_closure' => 'Offene Posten',
        'credit_note' => 'Gutschrift',
        'invoice_received' => 'Empfangene Rechnung',
        'credit_notes' => 'Gutschriften',
        'suspended' => 'Ausgesetzt',
        'follows_invoice' => 'Folgt Rechnung',
        'receipts_follows_invoice' => 'Quittung folgt Rechnung',
        'suspend' => 'Ausgesetzt',
        'empty_documents' => 'Keine Dokumente zum Anzeigen verfügbar',
        'sheets_name' => [
            'cash_desk' => 'Kasse',
            'cahs_desk_summary' => 'Kassenübersicht',
        ],
        'export_fields' => [
            'date' => 'Eintragsdatum',
            'status' => 'Bezahlt',
            'document_type' => 'Dokumenttyp',
            'document_number' => 'Dokumentnummer',
            'customer' => 'Empfänger',
            'taxable' => 'Steuerpflichtig',
            'total_tax' => 'MwSt.',
            'total_to_pay' => 'Gesamt',
            'payment_type' => 'Art der Zahlung',
            'to_have' => 'Haben',
            'to_give' => 'Geben',
            'balance' => 'Saldo',
            'deposit_document_number' => 'Dokumentnummer Anzahlung',
            'deposit_payment_type' => 'Zahlungsart Anzahlung',
        ],
    ],

    'cash' => [
        'cash_title' => 'Kassensituation',
        'cash_totals_title' => 'Summen',
        'total' => 'Gesamt',
        'cash_desk' => 'Kasse',
        'export_fields' => [
            'registration_date' => 'Eintragsdatum',
            'accountholder' => 'Kontoinhaber',
            'document' => 'Dokument',
            'document_date' => 'Dokumentdatum',
            'date' => 'Datum',
            'in-out' => 'Einnahmen-Ausgaben',
            'cash_in' => 'Einnahmen (Einzahlungen)',
            'cash_out' => 'Ausgaben (Zahlungen)',
            'payment_method' => 'Zahlungsmethode',
            'note' => 'Notizen',
            'type_payment' => 'Zahlungstyp',
            'stay' => 'Aufenthalt',
            'extra' => 'Extras',
            'city_tax' => 'Kurtaxe',
            'pos' => 'POS',
            'property' => 'Einrichtung',
            'amount' => 'Betrag',
            'mode' => 'Modus',
            'type' => 'Typ',
            'category' => 'Ausgabenkategorien',
            'notes' => 'Notizen',
            'movement_amount' => 'Bewegungen',
            'customer_or_company' => 'Kunde oder Firma',
            'label' => 'Etikett',
        ],
        'document_types' => [
            'invoice' => 'Rechnung',
            'receipt' => 'Quittung',
            'credit_note' => 'Gutschrift',
        ],
        'payment_types' => [
            'deposit' => 'Anzahlung',
            'part_payment' => 'Teilzahlung',
        ],
        'total_yesterday' => 'Gestern Gesamt',
        'total_today' => 'Heute Gesamt',
        'all_properties' => 'Alle Einrichtungen',
        'sub_year' => 'Jahresgesamt',
        'sub_month' => 'Monatsgesamt',
        'sub_day' => 'Tagesgesamt',
        'ins' => 'Einnahmen (Einzahlungen)',
        'outs' => 'Ausgaben (Zahlungen)',
        'cash_fund' => 'Kassenbestand',
        'cash_in' => 'Einnahmen',
        'cash_out' => 'Ausgaben',
        'cash_balance' => 'Saldo',
        'to_cash_in' => 'Zu kassieren',
        'wrap_up' => 'Zusammenfassung nach Zahlungsmethode',
        'summary' => 'Zusammenfassung',
        'in_out' => [
            'in' => 'Einnahme',
            'out' => 'Ausgabe',
        ],
        'totals' => [
            'method' => 'Methode',
            'ins' => 'Einnahmen',
            'outs' => 'Ausgaben',
            'diff' => 'Saldo',
        ],
    ],

    'channel' => [
        '1' => [
            'promotions' => [
                'mobile_rate' => [
                    'all' => 'App und Mobile Browser',
                    'app' => 'App',
                ],
                'geo_rate' => [
                    'algeria_pos' => 'Algerien',
                    'argentina_pos' => 'Argentinien',
                    'australia_pos' => 'Australien',
                    'belarus_pos' => 'Weißrussland',
                    'brazil_pos' => 'Brasilien',
                    'canada_pos' => 'Kanada',
                    'chile_pos' => 'Chile',
                    'colombia_pos' => 'Kolumbien',
                    'eu_pos' => 'Europa',
                    'hong_kong_pos' => 'Hongkong',
                    'india_pos' => 'Indien',
                    'indonesia_pos' => 'Indonesien',
                    'iran_pos' => 'Iran',
                    'israel_pos' => 'Israel',
                    'japan_pos' => 'Japan',
                    'kazakhstan_pos' => 'Kasachstan',
                    'kuwait_pos' => 'Kuwait',
                    'malaysia_pos' => 'Malaysia',
                    'mexico_pos' => 'Mexiko',
                    'new_zealand_pos' => 'Neuseeland',
                    'oman_pos' => 'Oman',
                    'pakistan_pos' => 'Pakistan',
                    'peru_pos' => 'Peru',
                    'philippines_pos' => 'Philippinen',
                    'qatar_pos' => 'Katar',
                    'russia_pos' => 'Russland',
                    'saudi_arabia_pos' => 'Saudi-Arabien',
                    'singapore_pos' => 'Singapur',
                    'south_africa_pos' => 'Südafrika',
                    'south_korea_pos' => 'Südkorea',
                    'switzerland_pos' => 'Schweiz',
                    'taiwan_pos' => 'Taiwan',
                    'thailand_pos' => 'Thailand',
                    'trinidad_&_tobago_pos' => 'Trinidad und Tobago',
                    'turkey_pos' => 'Türkei',
                    'ukraine_pos' => 'Ukraine',
                    'united_arab_emirates_pos' => 'Vereinigte Arabische Emirate',
                    'united_states_pos' => 'USA',
                    'vietnam_pos' => 'Vietnam',
                ],
            ],
            'json_request' => [
                'errors' => [
                    'INVALID_ARGUMENT' => 'Ein oder mehrere Daten sind ungültig. (:message)',
                    'MISSING_ARGUMENT' => 'Ein oder mehrere Daten fehlen. (:message)',
                    'OPERATION_NOT_ALLOWED' => 'Operation nicht erlaubt. (:message)',
                    'FORBIDDEN' => 'Operation verboten. (:message)',
                ],
            ],
        ],
        '11' => [
            'availability_model' => 'Verfügbarkeitsmodell für Zimmertyp "Private":',
            'per_room' => 'Pro Zimmer (avail*beds)',
            'per_person' => 'Pro Bett',
        ],
        '14' => [
            'availability_value_greater' => 'Sie haben einen Verfügbarkeitswert eingegeben, der größer ist als der akzeptierte.',
        ],
        '39' => [
            'period_not_valid' => 'Rate :rate gültig vom :valid_from bis :valid_to. Aktualisierung ignoriert.',
        ],
        '53' => [
            'warning_update_category' => 'Fehler beim Aktualisieren der Zimmerkategorie :rate_xml. Regeln nicht in Beddy gesetzt.',
            'empty_response_update' => 'Fehler beim Aktualisieren: Leere Antwort.',
        ],
        '68' => [
            'used_voucher' => 'VERWENDETER GUTSCHEIN',
            'amount_voucher' => 'Gutscheinbetrag',
            'used_amount' => 'Verwendeter Betrag',
            'virtual_rate_option' => 'Verwaltung von abgeleiteten Preisen',
            'virtual_rate_option_off' => 'Nicht verwalten (nur lesbar herunterladen)',
            'virtual_rate_option_on' => 'Aktivieren der Verwaltung abgeleiteter Preise (Preis nicht bearbeitbar)',
            'manage_type' => 'Verbindungstyp',
            'manage_type_complete' => 'Komplette Verwaltung',
            'manage_type_reservation' => 'Nur Reservierungsverwaltung',
            'manage_type_avail_reservation' => 'Verwaltung von Verfügbarkeiten und Reservierungen',
            'message_only_reservation' => 'Aktualisierungen ignoriert (nur Reservierungsverwaltung verbunden)',
            'message_avail_reservation' => 'Preis- und Einschränkungsaktualisierungen ignoriert (Verwaltung von Verfügbarkeiten und Reservierungen verbunden)',
            'deposit_requested' => 'Anzahlung angefordert',
            'deposit_payed' => 'Anzahlung bezahlt',
            'payed_via' => 'Bezahlt mit',
        ],
        '69' => [
            'manage_type' => 'Verbindungstyp',
            'manage_type_complete' => 'Komplette Verwaltung',
            'manage_type_reservation' => 'Nur Reservierungsverwaltung',
            'manage_type_avail_reservation' => 'Verwaltung von Verfügbarkeiten und Reservierungen',
            'manage_type_avail_restriction_reservation' => 'Verwaltung von Verfügbarkeiten, Einschränkungen und Reservierungen',
            'message_only_reservation' => 'Aktualisierungen ignoriert (nur Reservierungsverwaltung verbunden)',
            'message_avail_reservation' => 'Preis- und Einschränkungsaktualisierungen ignoriert (Verwaltung von Verfügbarkeiten und Reservierungen verbunden)',
            'message_avail_restriction_reservation' => 'Preisaktualisierungen ignoriert (Verwaltung von Verfügbarkeiten, Einschränkungen und Reservierungen verbunden)',
        ],
        '72' => [
            'manage_type' => 'Verbindungstyp',
            'manage_type_complete' => 'Komplette Verwaltung',
            'manage_type_reservation' => 'Nur Reservierungsverwaltung',
            'manage_type_avail_reservation' => 'Verwaltung von Verfügbarkeiten und Reservierungen',
            'manage_type_avail_restriction_reservation' => 'Verwaltung von Verfügbarkeiten, Einschränkungen und Reservierungen',
            'message_only_reservation' => 'Aktualisierungen ignoriert (nur Reservierungsverwaltung verbunden)',
            'message_avail_reservation' => 'Preis- und Einschränkungsaktualisierungen ignoriert (Verwaltung von Verfügbarkeiten und Reservierungen verbunden)',
            'message_avail_restriction_reservation' => 'Preisaktualisierungen ignoriert (Verwaltung von Verfügbarkeiten, Einschränkungen und Reservierungen verbunden)',
        ],
        '73' => [
            'pricing_model' => 'Preismodell',
            'per_room' => 'Pro Zimmer/Tarif',
            'per_person' => 'Pro Person',
            'manage_type' => 'Verbindungstyp',
            'manage_type_complete' => 'Komplette Verwaltung',
            'manage_type_reservation' => 'Nur Reservierungsverwaltung',
            'manage_type_avail_reservation' => 'Verwaltung von Verfügbarkeiten und Reservierungen',
            'manage_type_avail_restriction_reservation' => 'Verwaltung von Verfügbarkeiten, Einschränkungen und Reservierungen',
            'manage_type_avail_avail_price_reservation' => 'Verwaltung von Verfügbarkeiten, Preisen und Reservierungen',
            'message_only_reservation' => 'Aktualisierungen ignoriert (nur Reservierungsverwaltung verbunden)',
            'message_avail_reservation' => 'Preis- und Einschränkungsaktualisierungen ignoriert (Verwaltung von Verfügbarkeiten und Reservierungen verbunden)',
            'message_avail_restriction_reservation' => 'Preisaktualisierungen ignoriert (Verwaltung von Verfügbarkeiten, Einschränkungen und Reservierungen verbunden)',
            'manage_avail_price_reservation' => 'Einschränkungsaktualisierungen ignoriert (Verwaltung von Verfügbarkeiten, Preisen und Reservierungen verbunden)',
            'payment_info' => 'Zahlungsinformationen',
            'payment_amount' => 'Bezahlter Betrag',
            'payment_extra_info' => 'Details',
            'payment_transaction' => 'Transaktionscode',
            'payment_full' => 'Vollständige Vorauszahlung für den gesamten Buchungsbetrag',
            'payment_partial' => 'Teilweise Vorauszahlung erfolgt',
            'payment_none' => 'Keine Vorauszahlung',
            'payment_channel_collect' => 'Gast hat über den Kanal bezahlt',
            'payment_hotel_collect' => 'Gast muss im Hotel bezahlen (ganz oder teilweise)',
            'payment_gateway' => 'Gast hat über das Zahlungsgateway bezahlt',
            'service_inclusive' => 'Im Preis inbegriffen',
        ],
        '93' => [
            'reservation_status' => 'Reservierungsstatus',
            'booked' => 'Gebucht, wartet auf Bestätigung der Unterkunft',
            'waiting_payment' => 'Warten auf Anzahlung',
            'payment_in_progress' => 'Zahlung wird bearbeitet und geprüft',
            'confirmed' => 'Bestätigt',
            'canceled' => 'Storniert',
            'waiting_credit_card_guarantee' => 'Warten auf Kreditkarte zur Garantie',
            'deposit' => 'Anzahlung',
            'payed' => 'Bezahlt',
            'not_payed' => 'Nicht bezahlt',
            'payment_mothod' => 'Zahlungsmethode',
            'option_property_xml_id' => 'Einrichtungs-ID (wie in Beddy)',
            'option_email' => 'E-Mail',
            'option_apikey' => 'API-Schlüssel',
        ],
        '95' => [
            'unknown_rate' => 'Unbekannter PMS-Tarif. Empfangene Zimmer- und Tarif-ID vom Kanal: ',
        ],
        'option_general' => [
            'property_xml_id' => 'XML-ID der Einrichtung',
            'username' => 'Benutzername',
            'password' => 'Passwort',
        ],
        'general' => [
            'get_channel_rate_empty' => 'Keine Daten vom Portal heruntergeladen',
            'no_data_to_update' => 'Keine Daten zum Senden.',
            'no_valid_period' => 'Der aktualisierte Zeitraum ist ungültig. Aktualisierung ignoriert.',
            'no_valid_response' => 'Ungültige Antwort vom Kanal erhalten (:error_message)',
            'only_min_stay_update' => 'Einrichtung ist nur für die Aktualisierung von Min Stay konfiguriert.',
            'period_not_valid' => 'Rate :rate gültig vom :valid_from bis :valid_to. Aktualisierung ignoriert.',
            'no_valid_response_update' => 'Ungültige Antwort vom Kanal erhalten.',
            'discount' => 'Rabatt',
            'unknown' => 'unbekannt',
            'deposit_payed' => 'Anzahlung bezahlt',
            'to_payed' => 'Zu zahlen',
            'payment_type' => 'Typ',
            'ota_commission' => 'OTA-Provisionen',
            'ota_due' => 'OTA fällig',
            'arrival_time' => 'Ankunftszeit',
            'cancellable_until' => 'Stornierbar bis',
        ],
        'queue_update' => [
            'already_updated' => 'Update bereits gesendet durch Operation-Code: :operation_code',
            'max_retry' => 'Maximale Anzahl von Versuchen für Kanalaktualisierung ausgeführt: :channel_name - Zeitraum von: :date_from bis: :date_to. Letzte Nachricht: :message',
            'queue_update_max_retry_strategy_mail' => 'Maximale Wiederholungsanzahl Kanal :channel_name - Einrichtung: :property_name',
            'queue_update_exception_mail' => 'Ausnahme Kanal :channel_name - Einrichtung: :property_name',
        ],
        'errors' => [
            'content_api_update_errors_mail_connectivity' => 'CONTENT-API Aktualisierungsfehler :channel_name - Einrichtung: :property_name',
            'property_is_related' => 'Die Einrichtung ist keine Mutter und ist bereits mit einer anderen Einrichtung verknüpft',
            'accommodation_channel_not_found' => 'Zimmer mit XML-ID :accommodation_xml_id nicht gefunden',
            'unsupported_min_dvance_res' => 'Dieser Kanal erlaubt es nicht, einen Mindestwert für die Vorausbuchung festzulegen.'
        ],
        'queue_past_reservations' => [
            'queue_task_exists' => 'Einrichtung #:property_id ist bereits in der Warteschlange',
        ],
    ],

    'checkinonline' => [
        'policy' => [
            'privacy_policy_vers' => 'vers. 1.1 vom 4.4.2019',
            'privacy_policy_twelfth_item' => ' 12. Datum des Zeitpunkt und des Inkrafttretens  ',
            'privacy_policy_title_tenth_item' => 'Rechte des Betroffenen',
            'privacy_policy_title_sixth_item' => 'Art der Bereitstellung von Daten und Verweigerung der Bereitstellung',
            'privacy_policy_title_seventh_item' => 'Datenkommunikation',
            'privacy_policy_title_fourth_item' => 'Zweck der Verarbeitung',
            'privacy_policy_title_footer' => 'Für das Lesen der Informationen',
            'privacy_policy_title_first_item' => 'Der Datencontroller',
            'privacy_policy_title_fifth_item' => 'Verarbeitungsmethoden',
            'privacy_policy_title_consent' => 'Einwilligungserklärungen auf die Behandlung',
            'privacy_policy_title' => 'Kunden Privatsphäre und Datenschutz',
            'privacy_policy_third_item' => '3. Wie werden personenbezogene Daten erhoben?',
            'privacy_policy_text_twelfth_item' => ' Diese Informationen gelten auch für Stellen, die vor dem 25.05.2018 eröffnet wurden.',
            'privacy_policy_text_third_item' => 'Personenbezogene Daten werden direkt von der interessierten Partei an den für die Datenverarbeitung Verantwortlichen weitergegeben oder über andere Themen gesammelt, wie z:',
            'privacy_policy_text_tenth_item_part_9' => 'Unbeschadet anderer administrativer oder gerichtlicher Beschwerden können Sie, wenn Sie der Ansicht sind, dass die Sie betreffende Verarbeitung gegen diese Verordnung verstößt, eine Beschwerde bei der Aufsichtsbehörde einreichen und allgemein alle Rechte ausüben, die von der aktuellen anerkannt werden gesetzliche Bestimmungen.',
            'privacy_policy_text_tenth_item_part_8' => 'Nicht zu einer Entscheidung ausschließlich auf eine automatisierte Verarbeitung Basis unterworfen werden, die Rechtswirkungen, die Sie beeinflussen oder dass erheblich beeinträchtigt Ihre Person in ähnlicher Weise. Wie in Absatz 7 dargelegt, verwendet der Datenverantwortliche keine automatisierten Entscheidungsprozesse.',
            'privacy_policy_text_tenth_item_part_7' => 'Widersprechen Sie jederzeit aus Gründen, die mit Ihrer besonderen Situation zusammenhängen, der Verarbeitung personenbezogener Daten auf der Grundlage des berechtigten Interesses des Eigentümers oder Ihrer Zustimmung, einschließlich der Profilerstellung, es sei denn, der für die Datenverarbeitung Verantwortliche weist nach, dass zwingende berechtigte Gründe vorliegen, mit dem Verfahren fortzufahren Verarbeitung, die Vorrang vor Ihren Rechten hat.',
            'privacy_policy_text_tenth_item_part_6' => 'Wenn die Verarbeitung auf Zustimmung oder auf einem Vertrag beruht und automatisiert erfolgt, haben Sie das Recht, die personenbezogenen Daten, die Sie dem für die Datenverarbeitung Verantwortlichen zur Verfügung gestellt haben, in einem strukturierten Format zu erhalten, das üblicherweise von einem automatischen Gerät verwendet und gelesen wird Sie haben das Recht, sie an einen anderen für die Datenverarbeitung Verantwortlichen zu übertragen oder direkt vom Eigentümer übertragen zu lassen, sofern dies technisch machbar ist.',
            'privacy_policy_text_tenth_item_part_5' => 'Erhalten Sie nach Möglichkeit die Einschränkung der Verarbeitung Ihrer personenbezogenen Daten oder widerrufen Sie die zuvor erteilte Einwilligung. Der Widerruf der Einwilligung hat keinen Einfluss auf die Rechtmäßigkeit der zuvor durchgeführten Behandlungen.',
            'privacy_policy_text_tenth_item_part_4' => 'Fordern Sie vom für die Datenverarbeitung Verantwortlichen die unverzügliche Löschung personenbezogener Daten an, und der für die Verarbeitung Verantwortliche ist verpflichtet, Ihre personenbezogenen Daten unverzüglich zu stornieren, es sei denn, es liegen Gründe vor, die die Ausübung des vorgenannten Rechts verhindern.',
            'privacy_policy_text_tenth_item_part_3' => 'Fordern Sie vom für die Datenverarbeitung Verantwortlichen unverzüglich die Korrektur ungenauer personenbezogener Daten an, die Sie betreffen. Unter Berücksichtigung der Zwecke der Verarbeitung hat sie auch das Recht, die Integration unvollständiger personenbezogener Daten zu erhalten, auch durch Abgabe einer zusätzlichen Erklärung.',
            'privacy_policy_text_tenth_item_part_2' => 'Lassen Sie sich vom für die Datenverarbeitung Verantwortlichen bestätigen, ob personenbezogene Daten, die Sie betreffen, verarbeitet werden oder nicht, und erhalten Sie in diesem Fall Zugang zu personenbezogenen Daten und bestimmten Informationen, die speziell in Art. 4 angegeben sind. 15 der DSGVO.',
            'privacy_policy_text_tenth_item' => '  Mit einer bestimmten schriftlichen Mitteilung von Pec oder einem eingeschriebenen Brief mit Rückschein an die Adresse des Datenverantwortlichen haben Sie:',
            'privacy_policy_text_sixth_item_span' => 'In Bezug auf die Zwecke der Verarbeitung, für die Ihre Zustimmung erforderlich ist, hat die Ablehnung keine Auswirkungen auf die übernommenen Verpflichtungen.',
            'privacy_policy_text_sixth_item' => 'Wenn die Bereitstellung personenbezogener Daten für die Ausführung eines Vertrags oder die Erfüllung einer gesetzlichen Verpflichtung von Bedeutung ist, ist die Verarbeitung von wesentlicher Bedeutung, und im Falle der Verweigerung der Verarbeitung der betroffenen Person dieser Informationen kann der für die Verarbeitung Verantwortliche die Daten nicht erfüllen Aktivitäten gemäß Absatz 4 und im Allgemeinen können die übernommenen Verpflichtungen nicht erfüllen. ',
            'privacy_policy_text_seventh_item_span' => ' Kategorien von Empfängern könnten daher lediglich als Hinweis sein: ',
            'privacy_policy_text_seventh_item_part_2' => ' Die Daten zur Verfügung gestellt und gesammelt von dem Data Controller unterliegen nicht die Offenlegung oder Profilierung.',
            'privacy_policy_text_seventh_item' => ' Personenbezogene Daten können von anderen Personen in ihrer Eigenschaft als autorisierte, verantwortliche oder unabhängige für die Verarbeitung Verantwortliche übertragen und verarbeitet werden, um vorvertraglichen, vertraglichen, rechtlichen Verpflichtungen nachzukommen oder aus berechtigten Gründen. ',
            'privacy_policy_text_second_item_part_2_span' => 'Besondere Daten werden auch wie verarbeitet werden:',
            'privacy_policy_text_second_item_part_2' => 'und alle anderen Daten, die zur Erreichung der in Absatz 4 genannten Zwecke erforderlich sind. ',
            'privacy_policy_text_second_item' => 'Der Data Controller sammelt und Ihre persönlichen Daten verarbeiten, oder alle Informationen, die Sie identifizieren können, und das ist direkt oder indirekt zuzurechnen Sie, wie rein andeutungsweise:',
            'privacy_policy_text_nineth_item_part_2' => ' Außer in jedem Fall längere Aufbewahrungsfristen, sofern dies in bestimmten Branchenvorschriften vorgesehen ist. Im Streitfall werden personenbezogene Daten bis zu der in den Rechtsvorschriften zum Schutz der mit dem Vertragsverhältnis verbundenen Rechte vorgesehenen Verjährungsfrist aufbewahrt.',
            'privacy_policy_text_nineth_item' => ' Personenbezogene Daten werden für die Zeit gespeichert, die für die Durchführung der Aktivitäten im Zusammenhang mit den in diesen Informationen genannten Zwecken unbedingt erforderlich ist. In diesem Fall betragen die Lagerzeiten:',
            'privacy_policy_text_fourth_item_part_2' => ' Die Daten werden gemäß den Bestimmungen des Gesetzes in strikter Übereinstimmung verarbeitet werden, nach den Grundsätzen der Rechtmäßigkeit und Korrektheit und in Übereinstimmung mit dem Recht auf Vertraulichkeit. Die Daten werden verarbeitet auf der Grundlage von:',
            'privacy_policy_text_fourth_item' => ' Die vom für die Datenverarbeitung Verantwortlichen erhobenen personenbezogenen Daten werden zu folgenden Zwecken verarbeitet:',
            'privacy_policy_text_first_item' => 'Der Datencontroller lautet :businessName con sede a :businessCity in :businessAddress, :businessCap, Partita IVA :businessVat.',
            'privacy_policy_text_fifth_item' => 'Die Verarbeitung erfolgt in automatisierter und manueller Form gemäß den Bestimmungen der Kunst. 32 der DSGVO 2016/679 und insbesondere:',
            'privacy_policy_text_eleventh_item' => ' Im Falle einer Anfrage von Ihnen nach Informationen zu Ihren Daten wird der für die Verarbeitung Verantwortliche so schnell wie möglich antworten - es sei denn, dies ist unmöglich oder mit unverhältnismäßigem Aufwand verbunden - und in jedem Fall spätestens 30 Tage nach der Anfrage. Jede Unmöglichkeit oder Verzögerung des Eigentümers bei der Erfüllung der Anforderungen wird motiviert',
            'privacy_policy_text_eighth_item' => ' Personenbezogene Daten können in Bezug auf die Europäische Union oder eine internationale Organisation an Länder der Europäischen Union oder an Drittländer übermittelt werden, wenn diese Erfüllung erforderlich ist, um den Zweck der in Absatz 4 genannten Aktivitäten zu erreichen und die Erfüllung der Anforderungen zu gewährleisten eingegangene Verpflichtungen. Ab diesem Datum sind die Länder, in die Ihre Daten übertragen werden:',
            'privacy_policy_tenth_item' => ' 10. Wie kann ich eingreifen, um die Verarbeitung meiner Daten durch den Datenverantwortlichen einzuschränken, zu verhindern oder abzulehnen?',
            'privacy_policy_sub8' => 'Recht, eine Beschwerde bei der Aufsichtsbehörde einzureichen (Artikel 77 GDPR)',
            'privacy_policy_sub7' => 'Recht, dass Ihre Daten nicht zu einem automatisierten Entscheidungsprozess einschließlich Profilierung unterworfen werden (Artikel 22, GDPR)',
            'privacy_policy_sub6' => 'Widerspruchsrecht (Artikel 21 GDPR)',
            'privacy_policy_sub5' => 'Recht auf Datenübertragbarkeit (Artikel 20 GDPR)',
            'privacy_policy_sub4' => 'Recht auf Einschränkung der Verarbeitung (Artikel 18 GDPR)',
            'privacy_policy_sub3' => 'Widerrufsrecht (Artikel 17 GDPR)',
            'privacy_policy_sub2' => 'Recht auf Berichtigung (Artikel 16 GDPR)',
            'privacy_policy_sub1' => 'Recht auf Zugang zu Daten (Artikel 15 GDPR)',
            'privacy_policy_sixth_item' => ' 6. Warum sollte ich meine Daten dem Eigentümer geben? Kann ich einer Ablehnung widersprechen?',
            'privacy_policy_sign' => 'Signatur:',
            'privacy_policy_seventh_item' => ' 7. Wer wird bewusst meine Daten sein?',
            'privacy_policy_second_paragraph' => 'Wir bitten Sie daher, die darin enthaltenen Informationen zur Kenntnis zu nehmen und Ihre Zustimmung zur Verarbeitung durch Unterzeichnung dieser Informationen auszudrücken.',
            'privacy_policy_second_item' => '2. Welche personenbezogenen Daten werden vom Datenverantwortlichen verarbeitet?',
            'privacy_policy_not_authorize' => 'Ich autorisiere nicht',
            'privacy_policy_nineth_item' => ' 9. Wie lange werden meine Daten aufbewahrt?',
            'privacy_policy_name_surname' => 'Name und Nachname',
            'privacy_policy_location' => ': Business City, dort',
            'privacy_policy_list_third_item_3' => 'Organe, Verbände, Organisationen, Firmen oder Einzelpersonen, dass Ereignisse oder Aufenthalte in der Struktur organisieren; ',
            'privacy_policy_list_third_item_2' => 'Traditionelle Reisebüros;',
            'privacy_policy_list_third_item_1' => 'OTA (Online Travel Agency) wie zum Beispiel Booking.com, Venere.com, Worldhotels.com, Trivago.com, Expedia.com usw',
            'privacy_policy_list_seventh_item_9' => 'Servicefirma für die Instandhaltung der Hotelinfrastruktur',
            'privacy_policy_list_seventh_item_8' => 'Wirtschaftsprüfungsgesellschaft;',
            'privacy_policy_list_seventh_item_7' => 'Versicherungsgesellschaften;',
            'privacy_policy_list_seventh_item_6' => 'Banken',
            'privacy_policy_list_seventh_item_5' => 'Rechtsberater; ',
            'privacy_policy_list_seventh_item_4' => 'Buchhaltungsberater;',
            'privacy_policy_list_seventh_item_3' => 'Systemadministratoren; ',
            'privacy_policy_list_seventh_item_2' => 'Datenprozessoren; ',
            'privacy_policy_list_seventh_item_13' => 'Polizeikräfte.',
            'privacy_policy_list_seventh_item_12' => 'Öffentliche Behörde;',
            'privacy_policy_list_seventh_item_11' => 'Organe, Verbände, Organisationen, Firmen oder Einzelpersonen, dass Ereignisse oder Aufenthalte in der Struktur organisieren; ',
            'privacy_policy_list_seventh_item_10' => 'Zulieferunternehmen für Internet- und E-Mail-Dienste; ',
            'privacy_policy_list_seventh_item_1' => 'Ernannten;',
            'privacy_policy_list_second_item_extra' => 'Daten in Bezug auf die gesundheitlichen Bedingungen.',
            'privacy_policy_list_second_item_9' => 'Videoüberwachungsbilder;',
            'privacy_policy_list_second_item_8' => 'Kredit- und / oder Bankkartendaten;',
            'privacy_policy_list_second_item_7' => 'Kaufhistorie;',
            'privacy_policy_list_second_item_6' => 'Unterschrift;',
            'privacy_policy_list_second_item_5' => 'Ausweisdokumente;',
            'privacy_policy_list_second_item_4' => 'Persönliche Vorlieben;',
            'privacy_policy_list_second_item_3' => 'Daten zum Aufenthalt;',
            'privacy_policy_list_second_item_2' => 'Besondere Informationen;',
            'privacy_policy_list_second_item_12' => 'Zugriff auf Daten und Nutzung von IKT-Ressourcen',
            'privacy_policy_list_second_item_11' => 'Daten in Bezug auf Telefonanrufe;',
            'privacy_policy_list_second_item_10' => 'Daten in Bezug auf die elektronischen Geräte, die zur Verbindung mit dem Netzwerk der Struktur verwendet werden;',
            'privacy_policy_list_second_item_1' => 'Persönliche Identifikationsdaten;',
            'privacy_policy_list_nineth_item_6' => '1 Jahr für den Zugriff auf Daten und die Nutzung von IKT-Ressourcen.',
            'privacy_policy_list_nineth_item_5' => '90 Tage nach dem Auschecken für Daten zum Telefonverkehr;',
            'privacy_policy_list_nineth_item_4' => 'Maximal 5 Tage für Videoüberwachungsbilder;',
            'privacy_policy_list_nineth_item_3' => 'Maximal 3 Jahre ab dem letzten Check-out für personenbezogene Daten, Angaben zum Aufenthalt, persönliche Vorlieben, Ausweisdokumente, handschriftliche Unterschrift sowie Kaufhistorie und Marketingdaten (Punkte 2.1 bis 2.7), sofern nicht anders angegeben. ',
            'privacy_policy_list_nineth_item_2' => 'Maximal 3 Monate ab dem Check-out-Datum für Kreditkartendaten;  ',
            'privacy_policy_list_nineth_item_1' => '10 Jahre (gemäß den gesetzlichen Verpflichtungen - Art. 2220 des Bürgerlichen Gesetzbuches);',
            'privacy_policy_list_fourth_item_9' => ' Interne Sicherheit;',
            'privacy_policy_list_fourth_item_8' => 'Schutz der körperlichen Gesundheit der Menschen;',
            'privacy_policy_list_fourth_item_7' => 'Promotion, Marketing und Werbung;',
            'privacy_policy_list_fourth_item_6' => 'Öffentlichkeitsarbeit',
            'privacy_policy_list_fourth_item_5' => 'Kundendienst;',
            'privacy_policy_list_fourth_item_4_part_2' => 'Berechtigtes Interesse des Datenverantwortlichen. ',
            'privacy_policy_list_fourth_item_4' => 'Litigation Management;',
            'privacy_policy_list_fourth_item_3_part_2' => 'Gesetzliche Verpflichtungen;',
            'privacy_policy_list_fourth_item_3' => 'Verwaltung;',
            'privacy_policy_list_fourth_item_2_part_2' => 'Vorvertragliche und vertragliche Verpflichtungen; ',
            'privacy_policy_list_fourth_item_2' => 'Vertragsunterzeichnung und -verwaltung; ',
            'privacy_policy_list_fourth_item_1_part_2' => 'Zustimmungsmanifestation; ',
            'privacy_policy_list_fourth_item_12' => 'Aktivieren Sie die Nutzung und gewährleisten Sie die Sicherheit der IKT-Infrastruktur.',
            'privacy_policy_list_fourth_item_11' => 'Schutz der Integrität von Unternehmenseigentum und -vermögen;',
            'privacy_policy_list_fourth_item_10' => 'Schutz und Gewährleistung der Sicherheit von Personen;',
            'privacy_policy_list_fourth_item_1' => 'Kundenmanagement;',
            'privacy_policy_list_fifth_item_3' => 'Durch die Verwendung von Dokumenten auf Papier mit der Bereitstellung geeigneter Sorgerechtsmaßnahmen, die die Kenntnis nicht autorisierter Personen ausschließen.',
            'privacy_policy_list_fifth_item_2' => ' Durch den Einsatz von elektronischen oder automatisierten Tools, die die Speicherung, Verwaltung und Übertragung von Daten, aber immer so konfiguriert, um zu garantieren ein Höchstmaß an Vertraulichkeit und den notwendigen Schutz zu ermöglichen.',
            'privacy_policy_list_fifth_item_1' => 'Durch Vorgänge, die das Sammeln, Registrieren, Organisieren, Speichern, Konsultieren, Verarbeiten, Ändern, Auswählen, Extrahieren, Verwenden, Kommunizieren, Löschen und Zerstören von Daten ermöglichen.',
            'privacy_policy_list_eighth_item_4' => 'Schweiz;',
            'privacy_policy_list_eighth_item_5' => 'USA',
            'privacy_policy_list_eighth_item_3' => 'Irland; ',
            'privacy_policy_list_eighth_item_2' => 'Großbritannien; ',
            'privacy_policy_list_eighth_item_1' => 'Andere EU-Länder als Italien; ',
            'privacy_policy_fourth_item_part_2' => 'Rechtsgrundlage der Verarbeitung',
            'privacy_policy_fourth_item' => '4. Warum meine Daten sammeln?',
            'privacy_policy_first_paragraph' => 'Gemäß der Kunst. 13 und 14 der EU-Verordnung Nr. 2016/679 (im Folgenden „DSGVO“) in Bezug auf den Schutz personenbezogener Daten und deren freien Verkehr ist der: businessName in seiner Eigenschaft als Datenverantwortlicher für personenbezogene Daten verpflichtet, Ihnen alle Informationen zu den Zwecken und Methoden von bereitzustellen Verarbeitung Ihrer personenbezogenen Daten, Angabe der Personen, an die Ihre Daten weitergegeben werden dürfen, und aller Rechte, die das Gesetz in Bezug auf die Verwaltung personenbezogener Daten durch den Eigentümer anerkennt.',
            'privacy_policy_first_item' => '1. Wer bestimmt die Zwecke und Methoden der Verarbeitung?',
            'privacy_policy_fifth_item' => '5. Wie werden die erhobenen Daten verarbeitet?',
            'privacy_policy_eleventh_item' => '  11. Wie spät ist es, eine Antwort vom Datenverantwortlichen zu erhalten? ',
            'privacy_policy_eighth_item' => ' 8. Könnten meine Daten ins Ausland übertragen werden?',
            'privacy_policy_authorize' => 'Ich autorisiere',
            'privacy_policy_auth_3' => 'Der Datenverantwortliche sendet Werbemitteilungen an meine Adressen.',
            'privacy_policy_auth_2' => ' Der Data Controller die Daten in Bezug auf meinen Aufenthalt, für den ausschließlichen Zweck, so dass der Empfang von Nachrichten und Anrufen an mich gerichtet zu kommunizieren.',
            'privacy_policy_auth_1' => 'Der Datencontroller für die Verarbeitung bestimmter Daten gemäß Art. 9 EU-Verordnung 679/2016, um die Lage sein, ein optimales Maß an Gastfreundschaft und für den Schutz der eigenen körperlichen Gesundheit zu genießen;',
            'privacy_policy_accept' => 'Der unten genannte Unterzeichnete erklärt, vollständige Informationen gemäß Artikel 13 und 14 der EU-Verordnung 2016/679 erhalten zu haben und deren Inhalt gut verstanden zu haben.',
        ],
    ],

    'city_tax_channel' => [
        'default' => [
            'accommodations_mapping' => 'Zimmerzuordnung',
            'scheduled_send' => 'Möchten Sie das automatische Versenden der Berichte aktivieren?',
            'scheduled_send_info' => 'Das System sendet automatisch alle Gäste mit Check-out-Datum des Vortages. Zum Beispiel werden am 25. Juni die Gäste mit Check-out vom 24. Juni gesendet.',
            'which_guests_to_send' => 'Automatisch senden:',
            'only_invoiced' => 'Nur Gäste mit berechneter Steuer',
            'all_guest_with_city_tax_calculated' => 'Alle Gäste mit berechneter Steuer',
        ],
        'pay_tourist' => [
            'structure_id' => 'PayTourist-ID der Struktur',
            'software_id' => 'Autorisierte Partner-Software-ID, von PayTourist bereitgestellt',
            'get_extra_specifications' => 'Zimmerarten abrufen',
            'token' => 'API-Zugriffstoken, von PayTourist bereitgestellt',
            'period' => 'Zeitraum für den Tourismussteuerbericht',
        ],
        'tourist_tax' => [
            'period' => 'Zeitraum für den Tourismussteuerbericht',
            'city_tax_channel_group_id' => 'Konfigurationsgruppe für die Übertragung/den Export des Tourismussteuerberichts',
        ],
        'exceptions' => [
            'city_tax_channel_configuration_not_valid' => 'Die folgenden Parameter für die Zuordnung einer Struktur zu einem Kanal für die Tourismussteuer sind ungültig: ',
            'channel_configuration_not_valid' => 'Die folgenden Parameter, die vom Kanal :channelName angefordert werden, sind ungültig: :params',
            'channel_credential_not_valid' => 'Die Anmeldeinformationen für den Kanal :channelName sind ungültig',
            'channel_configuration_must_have_one_property' => 'Der Kanal :channelName erfordert maximal eine Struktur',
            'channel_params_not_valid' => 'Die folgenden Parameter, die vom Kanal :channelName angefordert werden, um den Bericht zu erstellen, sind ungültig: :params',
            'channel_configuration_missing' => 'Die vom Kanal :channelName angeforderten Konfigurationsparameter fehlen in der Anfrage',
            'channel_params_missing' => 'Die vom Kanal :channelName angeforderten Parameter für die Berichtserstellung fehlen in der Anfrage',
            'city_tax_exemption_not_mapped' => 'Ausnahme :exemptionName nicht vorgesehen für den Gast :guestName :guestSurname der Buchung :reservationId - :booker',
            'city_tax_channel_place_not_found' => 'Die Gemeinde :placeName ist derzeit nicht für den ausgewählten Kanal verfügbar',
            'city_tax_channel_group_not_found' => 'Die ausgewählte Gruppe existiert nicht',
            'file_not_valid' => 'Die exportierte Datei konnte nicht in der Cloud für den Kanal :channelName gespeichert werden',
            'networking_error' => 'Anfragefehler beim Senden des Berichts für die Buchung :reservationId für den Kanal :channelName aufgrund des folgenden Fehlers: :error',
            'channel_unreachable' => 'Der Kanal :channelName ist momentan nicht erreichbar aufgrund folgender Fehler: :errors',
            'date_range_out_of_boundaries' => 'Der maximale Berichtszeitraum für den Kanal :channelName beträgt :days Tage ab dem Startdatum',
            'date_from_not_valid' => 'Das früheste Startdatum für die Berichterstellung für den Kanal :channelName liegt maximal :days Tage vor dem Übertragungsdatum',
            'guest_attributes_missing' => 'Der Bericht der Tourismussteuer für den Kanal :channelName konnte aufgrund fehlender Daten für die Gäste nicht gesendet werden: :guests',
            'empty_report' => 'Im angeforderten Tourismussteuerbericht wurden keine Gäste gefunden',
            'endpoint_not_mapped' => 'Der Endpunkt für die Gemeinde :place für den Kanal :channelName ist nicht vorhanden. Bitte kontaktieren Sie den technischen Support',
        ],
    ],

    'city_tax_configuration' => [
        'errors' => [
            'restriction_fields_not_valid' => 'Die übergebenen Felder gehören nicht zur angegebenen Tourismussteuer-Beschränkung',
            'option_fields_not_valid' => 'Die übergebenen Felder gehören nicht zur angegebenen Tourismussteuer-Option',
            'field_not_valid' => 'Das Feld :fieldNotValid entspricht nicht der Validierung :condition :validation',
            'configuration_override_already_exist' => 'Es existiert bereits eine Tourismussteuer-Konfiguration, die die ausgewählten Daten umfasst',
        ],
        'exceptions' => [
            'city_tax_configuration_not_valid' => 'Die folgenden Parameter für die Erstellung einer Tourismussteuer-Konfiguration sind ungültig: ',
            'field_not_valid' => 'Das Feld :fieldName ist nicht in den vorgesehenen Feldern der Konfiguration enthalten',
            'field_is_required' => 'Das Feld :fieldName ist erforderlich',
        ],
    ],

    'city_tax_option_field' => [
        'option_field' => [
            'nationality' => [
                'country_id' => [
                    'name' => 'Nationalität',
                    'description' => 'Nationalität des Gastes',
                ],
            ],
            'reservation_from' => [
                'reservation_from_id' => [
                    'name' => 'Herkunft',
                    'description' => 'Herkunft der Reservierung.',
                ],
            ],
            'reservation_reason' => [
                'reservation_reason_id' => [
                    'name' => 'Grund',
                    'description' => 'Grund der Reservierung.',
                ],
            ],
            'group_leader' => [
                'active' => [
                    'name' => 'Aktiv',
                    'description' => 'Ausschluss aktivieren.',
                ],
            ],
            'residence_country' => [
                'country_id' => [
                    'name' => 'Wohnsitzland',
                    'description' => 'Wohnsitzland des Gastes.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Befreiung',
                    'description' => 'Befreiung',
                ],
            ],
            'residence_state' => [
                'state_id' => [
                    'name' => 'Bundesland des Wohnsitzes',
                    'description' => 'Bundesland des Wohnsitzes des Gastes.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Befreiung',
                    'description' => 'Befreiung',
                ],
            ],
            'residence_county' => [
                'county_id' => [
                    'name' => 'Kreis des Wohnsitzes',
                    'description' => 'Kreis des Wohnsitzes des Gastes.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Befreiung',
                    'description' => 'Befreiung',
                ],
            ],
            'residence_city' => [
                'city_id' => [
                    'name' => 'Stadt des Wohnsitzes',
                    'description' => 'Stadt des Wohnsitzes des Gastes.',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Befreiung',
                    'description' => 'Befreiung',
                ],
            ],
            'accommodation_tableau_number' => [
                'accommodation_tableau_number_id' => [
                    'name' => 'Unterkunft',
                    'description' => 'Unterkunft',
                ],
            ],
            'accommodation' => [
                'accommodation_id' => [
                    'name' => 'Unterkunftstyp',
                    'description' => 'Unterkunftstyp',
                ],
            ],
        ],
    ],

    'city_tax_option' => [
        'option' => [
            'nationality' => [
                'name' => 'Nationalität',
                'description' => 'Nationalität des Gastes',
            ],
            'reservation_from' => [
                'name' => 'Herkunft',
                'description' => 'Herkunft der Buchung.',
            ],
            'reservation_reason' => [
                'name' => 'Grund',
                'description' => 'Grund der Buchung.',
            ],
            'group_leader' => [
                'name' => 'Gruppenleiter',
                'description' => 'Gruppenleiter unter den Gästen.',
            ],
            'residence_country' => [
                'name' => 'Wohnsitzland',
                'description' => 'Wohnsitzland des Gastes.',
            ],
            'residence_state' => [
                'name' => 'Wohnsitzregion',
                'description' => 'Wohnsitzregion des Gastes.',
            ],
            'residence_county' => [
                'name' => 'Wohnsitzprovinz',
                'description' => 'Wohnsitzprovinz des Gastes.',
            ],
            'residence_city' => [
                'name' => 'Wohnsitzstadt',
                'description' => 'Wohnsitzstadt des Gastes.',
            ],
            'accommodation_tableau_number' => [
                'name' => 'Unterkunft',
                'description' => 'Unterkunft.',
            ],
            'accommodation' => [
                'name' => 'Unterkunftstyp',
                'description' => 'Art der Unterkunft.',
            ],
        ],
    ],

    'city_tax_restriction_field' => [
        'restriction_field' => [
            'age_range' => [
                'min_age' => [
                    'name' => 'Mindestalter',
                    'description' => 'Mindestalter der Altersgruppe',
                ],
                'max_age' => [
                    'name' => 'Höchstalter',
                    'description' => 'Höchstalter der Altersgruppe',
                ],
                'amount_price' => [
                    'name' => 'Fester Betrag',
                    'description' => 'Betrag der Tourismussteuer',
                ],
                'percentage_price' => [
                    'name' => 'Prozentsatz',
                    'description' => 'Berechnungsprozentsatz für den Betrag',
                ],
                'city_tax_exemption_id' => [
                    'name' => 'Befreiung',
                    'description' => 'Befreiung',
                ],
                'price_type' => [
                    'name' => 'Preistyp',
                    'description' => 'Art des Preises',
                ],
            ],
            'percentage_range' => [
                'min_amount' => [
                    'name' => 'Mindestbetrag',
                    'description' => 'Minimaler Wert der prozentualen Berechnung',
                ],
                'max_amount' => [
                    'name' => 'Höchstbetrag',
                    'description' => 'Maximaler Wert der prozentualen Berechnung',
                ],
            ],
            'validity_period' => [
                'date_from' => [
                    'name' => 'Startdatum',
                    'description' => 'Beginn des Gültigkeitszeitraums',
                ],
                'date_to' => [
                    'name' => 'Enddatum',
                    'description' => 'Ende des Gültigkeitszeitraums',
                ],
                'flag_year' => [
                    'name' => 'Saison',
                    'description' => 'Jährlich gültiger Zeitraum',
                ],
            ],
            'price_range_night' => [
                'min_price' => [
                    'name' => 'Mindestpreis',
                    'description' => 'Mindestpreis für die Berechnung',
                ],
                'max_price' => [
                    'name' => 'Höchstpreis',
                    'description' => 'Höchstpreis für die Berechnung',
                ],
            ],
            'limit_days' => [
                'days' => [
                    'name' => 'Anwendbare Nächte',
                    'description' => 'Maximale anwendbare Nächte',
                ],
            ],
            'month_max_nights' => [
                'max_days' => [
                    'name' => 'Anwendbare Nächte',
                    'description' => 'Wenn ein Gast dieses Limit im Kalendermonat überschreitet (auch bei verschiedenen oder nicht aufeinanderfolgenden Buchungen), wird die Steuer nicht mehr berechnet',
                ],
            ],
            'year_max_nights' => [
                'max_days' => [
                    'name' => 'Anwendbare Nächte',
                    'description' => 'Wenn ein Gast dieses Limit im Kalenderjahr überschreitet (auch bei verschiedenen oder nicht aufeinanderfolgenden Buchungen), wird die Steuer nicht mehr berechnet',
                ],
            ],
            'reservation_max' => [
                'max' => [
                    'name' => 'Maximale Anzahl',
                    'description' => 'Jährliches Limit für die Anzahl der Buchungen, die für einen bestimmten Gast anwendbar sind',
                ],
            ],
            'limit_nights' => [
                'min_nights' => [
                    'name' => 'Minimale Nächte',
                    'description' => 'Minimale Anzahl an Nächten der Buchung.',
                ],
                'max_nights' => [
                    'name' => 'Maximale Nächte',
                    'description' => 'Maximale Anzahl an Nächten der Buchung.',
                ],
            ],
            'range_nights' => [
                'night_from' => [
                    'name' => 'Von der Nacht',
                    'description' => 'Anfangsnacht der Berechnung.',
                ],
                'night_to' => [
                    'name' => 'Bis zur Nacht',
                    'description' => 'Endnacht der Berechnung.',
                ],
                'amount_price' => [
                    'name' => 'Fester Betrag',
                    'description' => 'Betrag der Tourismussteuer',
                ],
                'percentage_price' => [
                    'name' => 'Prozentsatz',
                    'description' => 'Berechnungsprozentsatz für den Betrag',
                ],
                'price_type' => [
                    'name' => 'Preistyp',
                    'description' => 'Art des Preises',
                    'amount_name' => 'Betrag',
                    'percentage_name' => 'Prozentsatz',
                ],
            ],
            'adult_quote_range' => [
                'min_amount' => [
                    'name' => 'Mindestbetrag',
                    'description' => 'Wählen Sie den Mindestbetrag für den Erwachsenenanteil, basierend auf dem Nachtpreis ohne MwSt.',
                ],
                'max_amount' => [
                    'name' => 'Höchstbetrag',
                    'description' => 'Wählen Sie den Höchstbetrag für den Erwachsenenanteil, basierend auf dem Nachtpreis ohne MwSt.',
                ],
                'amount_price' => [
                    'name' => 'Fester Betrag',
                    'description' => 'Betrag der Tourismussteuer',
                ],
                'percentage_price' => [
                    'name' => 'Prozentsatz',
                    'description' => 'Berechnungsprozentsatz für den Betrag',
                ],
                'price_type' => [
                    'name' => 'Preistyp',
                    'description' => 'Art des Preises',
                    'amount_name' => 'Betrag',
                    'percentage_name' => 'Prozentsatz',
                ],
            ],
            'price_type_name' => [
                'amount_name' => '€',
                'percentage_name' => '%',
            ],
        ],
    ],

    'city_tax_restriction' => [
        'restriction' => [
            'age_range' => [
                'name' => 'Altersgruppe',
                'description' => 'Altersgruppe für die Anwendung der Steuer.',
            ],
            'percentage_range' => [
                'name' => 'Betragsgrenzen bei prozentualen Berechnungen',
                'description' => 'Minimale und maximale Betragsgrenzen für die prozentuale Berechnung.',
            ],
            'validity_period' => [
                'name' => 'Gültigkeitszeitraum',
                'description' => 'Zeitraum für die Anwendbarkeit der Steuer.',
            ],
            'price_range_night' => [
                'name' => 'Preisspanne der täglichen Unterkunftskosten',
                'description' => 'Minimaler und maximaler Preis, den eine Übernachtung haben muss, um in die Steuerberechnung einbezogen zu werden.',
            ],
            'limit_days' => [
                'name' => 'Maximale anwendbare Nächte',
                'description' => 'Begrenzung der anwendbaren Nächte.',
            ],
            'month_max_nights' => [
                'name' => 'Monatliches Limit für anwendbare Nächte pro Gast',
                'description' => 'Maximale Anzahl an Nächten, die pro Monat für einen Gast anwendbar sind.',
            ],
            'year_max_nights' => [
                'name' => 'Jährliches Limit für anwendbare Nächte pro Gast',
                'description' => 'Maximale Anzahl an Nächten, die pro Jahr für einen Gast anwendbar sind.',
            ],
            'reservation_max' => [
                'name' => 'Maximale Anzahl an Buchungen pro Jahr für einen bestimmten Gast',
                'description' => 'Maximale Anzahl an Buchungen in einem Jahr pro Gast.',
            ],
            'limit_nights' => [
                'name' => 'Begrenzung der anwendbaren Nächte innerhalb einer Buchung',
                'description' => 'Minimale und maximale Anzahl an Nächten einer Buchung, um die Steuer anzuwenden.',
            ],
            'range_nights' => [
                'name' => 'Berechnung überschreiben basierend auf den Nächten der Buchung',
                'description' => 'Nummer der Start- und Endnacht für die Buchung.',
            ],
            'adult_quote_range' => [
                'name' => 'Preis pro Gästequote der Übernachtung',
                'description' => 'Wählen Sie den Gästequotenbereich und den entsprechenden Preis.',
            ],
        ],
    ],

    'city_tax' => [
        'city_tax_extra_text' => 'Die Höhe der Steuer ist eine Schätzung und kann sich je nach den Bedingungen der zum Zeitpunkt des Aufenthalts geltenden Vorschriften ändern.',
        'errors' => [
            'no_city_tax_configuration' => 'Kurtaxe nicht konfiguriert.',
        ],
        'warnings' => [
            'no_guests_for_accommodation' => 'Für die Unterkunft :unterkunft_name gibt es keine Gäste, daher ist es notwendig, die Kurtaxe zu berechnen.',
            'no_tax_for_accommodation' => 'Auf die Unterkunft :accommodation_name ist keine der derzeitigen Steuerkonfigurationen anwendbar.',
        ],
        'price_type' => [
            'amount_percentage' => 'Betrag und Prozentsatz',
            'percentage' => 'Prozentsatz',
            'amount' => 'Betrag',
        ],
        'tax_type' => [
            'xroomextraxnightxpax' => [
                'description' => 'Die Steuer wird für jeden Gast bei allen Übernachtungen als Prozentsatz des Unterkunftspreises + Extra berechnet (Unterkunftspreis + Extra geteilt durch die Anzahl der Gäste).',
                'name' => 'Prozentualer Betrag für Unterkunft + Extras pro Person und Nacht',
            ],
            'xbook' => [
                'description' => 'Die Gebühr wird unabhängig von der Anzahl der Übernachtungen und Gäste mit dem gewählten Festbetrag berechnet.',
                'name' => 'Einmaliger fester Betrag',
            ],
            'xtotalroomxnightxpax' => [
                'description' => 'Die Steuer wird für jeden Gast für alle Übernachtungen als Prozentsatz des Gesamtpreises (Unterkunft + Extras) berechnet.',
                'name' => 'Prozentualer Anteil am Gesamtpreis (Unterkunft + Extras) pro Person und Nacht',
            ],
            'xroomxtotalnightxpax' => [
                'description' => 'Die Steuer wird für jeden Gast auf alle Übernachtungen als Prozentsatz des Unterkunftspreises berechnet',
                'name' => 'Prozentualer Anteil am Unterkunftspreis pro Person und Nacht',
            ],
            'xroomxnightxpax' => [
                'description' => 'Die Steuer wird für jeden Gast bei allen Übernachtungen als Prozentsatz des Unterkunftspreises (Unterkunftspreis geteilt durch die Anzahl der Gäste) berechnet.',
                'name' => 'Prozentualer Anteil am Unterkunftspreis pro Person und Nacht',
            ],
            'xroomxnight' => [
                'description' => 'Die Steuer wird als Prozentsatz des Unterkunftspreises für jede Übernachtung berechnet, wobei die Anzahl der Gäste nicht berücksichtigt wird.',
                'name' => 'Prozentualer Anteil am Übernachtungspreis pro Nacht',
            ],
            'xnight' => [
                'description' => 'Die Steuer wird für jede Übernachtung entsprechend dem gewählten Betrag berechnet, ohne Berücksichtigung der Anzahl der Gäste.',
                'name' => 'Betrag pro Nacht',
            ],
            'xnightxpax' => [
                'description' => 'Die Steuer wird für jeden Gast für alle Übernachtungen entsprechend den gewählten Beträgen berechnet.',
                'name' => 'Betrag pro Person und Nacht',
            ],
            'xpax' => [
                'description' => 'Die Gebühr wird für jeden Gast nach den gewählten Beträgen berechnet, wobei die Anzahl der Übernachtungen nicht berücksichtigt wird.',
                'name' => 'Betrag pro Person',
            ],
        ],
    ],

    'cloners' => [
        'treatments' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Behandlungen der Quellstruktur in die Zielstruktur zu klonen. Wenn diese Option ausgewählt wird, werden die Behandlungen der Quellstruktur gelöscht.',
        ],
        'accommodations' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Zimmer der Quellstruktur zu klonen. Wenn sie zusammen mit den Tarifplänen ausgewählt wird, werden die Verknüpfungen so erstellt, dass sie die Quellstruktur widerspiegeln.',
        ],
        'priceLists' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Preislisten der Quellstruktur zu klonen.',
        ],
        'ratePlans' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Tarifpläne der Quellstruktur zu klonen.',
        ],
        'rates' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Tarife der Quellstruktur zu klonen.',
        ],
        'modules' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Module der Quellstruktur zu klonen.',
        ],
        'customers' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Kunden der Quellstruktur zu klonen.',
        ],
        'companies' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Firmen der Quellstruktur zu klonen.',
        ],
        'invoiceLayouts' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Rechnungsprofile der Quellstruktur zu klonen.',
        ],
        'addons' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die zusätzlichen Dienstleistungen der Quellstruktur zu klonen.',
        ],
        'availabilities' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Verfügbarkeiten der Quellstruktur zu klonen.',
        ],
        'childrenRanges' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Kinderbereiche der Quellstruktur zu klonen.',
        ],
        'roles' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Rollen der Quellstruktur zu klonen.',
        ],
        'paymentMethods' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Zahlungsmethoden der Quellstruktur zu klonen.',
        ],
        'rules' => [
            'description' => 'Diese Option ermöglicht es Ihnen, alle Regeln der Quellstruktur zu klonen.',
        ],
        'emailTemplates' => [
            'description' => 'Diese Option ermöglicht es Ihnen, alle E-Mail-Vorlagen der Quellstruktur zu klonen.',
        ],
        'events' => [
            'description' => 'Diese Option ermöglicht es Ihnen, alle Ereignisse der Quellstruktur zu klonen.',
        ],
        'policies' => [
            'description' => 'Diese Option ermöglicht es Ihnen, alle Stornierungsbedingungen der Quellstruktur zu klonen.',
        ],
        'cityTaxes' => [
            'description' => 'Diese Option ermöglicht es Ihnen, die Registerkarte: Konfigurationen der Tourismussteuer zu klonen.',
        ],
    ],

    'common' => [
        'datetime' => [
            'default' => '%d/%m/%Y %H:%M',
            'extended_phrasal_date' => '%A, %e %B %Y',
            // "Freitag, 7. Juni 2019"
            'extended_phrasal_date_short' => '%a, %e %b %Y',
            // "Fr, 7. Jun 2019"
            'extended_phrasal_date_with_time' => '%A, %e %B %Y - %H:%M',
            // "Freitag, 7. Juni 2019 - 18:03"
            'extended_phrasal_date_short_with_time' => '%a, %e %b %Y - %H:%M',
            // "Fr, 7. Jun 2019 - 18:03"
            'phrasal_date' => '%e %B %Y',
            // "7. Juni 2019"
            'phrasal_date_short' => '%e %b %Y',
            // "7. Jun 2019"
            'date' => '%d/%m/%Y',
            // "07/06/2019" für den 7. Juni 2019
            'for_range' => '%d %b',
            // "04 Apr" - für Datumsbereiche wie: "04 Apr - 07 Apr"
            'time' => '%H:%M',
            // 24-Stunden-Format; z.B.: "00:00" oder "18:03"
            'year' => 'Jahr',
            'month' => 'Monat',
            'day' => 'Tag',
            'time' => 'Zeit',
            'dates_interval' => 'Datumsbereich',
            'from_day' => 'Von',
            'to_day' => 'Bis',
            'days' => 'Tage',
            'months' => [
                1 => 'Januar',
                2 => 'Februar',
                3 => 'März',
                4 => 'April',
                5 => 'Mai',
                6 => 'Juni',
                7 => 'Juli',
                8 => 'August',
                9 => 'September',
                10 => 'Oktober',
                11 => 'November',
                12 => 'Dezember',
            ],
            'months_short' => [
                1 => 'Jan',
                2 => 'Feb',
                3 => 'Mär',
                4 => 'Apr',
                5 => 'Mai',
                6 => 'Jun',
                7 => 'Jul',
                8 => 'Aug',
                9 => 'Sep',
                10 => 'Okt',
                11 => 'Nov',
                12 => 'Dez',
            ],
            'days_of_week' => [
                'None' => 'Sonntag',
                'None' => 'Montag',
                'None' => 'Dienstag',
                'None' => 'Mittwoch',
                'None' => 'Donnerstag',
                'None' => 'Freitag',
                'None' => 'Samstag',
            ],
            'days_of_week_short' => [
                'None' => 'So',
                'None' => 'Mo',
                'None' => 'Di',
                'None' => 'Mi',
                'None' => 'Do',
                'None' => 'Fr',
                'None' => 'Sa',
            ],
            'days_of_week_initials' => [
                'None' => 'S',
                'None' => 'M',
                'None' => 'D',
                'None' => 'M',
                'None' => 'D',
                'None' => 'F',
                'None' => 'S',
            ],
        ],
        'currency' => [
            'display' => ':prefix :symbol :amount',
            'format' => '%.2n',
        ],
        'gender' => [
            'male' => 'Mann',
            'female' => 'Frau',
        ],
        'bool' => [
            'yes_no' => [
                1 => 'Ja',
                0 => 'Nein',
            ],
            'true_false' => [
                1 => 'Wahr',
                0 => 'Falsch',
            ],
        ],
        'exports' => [
            'customers_generic' => 'Kundenübersicht',
            'companies_generic' => 'Firmenübersicht',
            'reservations_generic' => 'Buchungsübersicht',
            'reservations_invoices_opened_generic' => 'Offene Konten Übersicht',
            'reservations_invoices_generic' => 'Rechnungsübersicht',
            'social_archive_generic' => 'Kundenliste mit freischaltbaren Angeboten',
            'reservations_quotes_all_generic' => 'Angebotsübersicht',
            'reservations_quotes_active_generic' => 'Aktive Angebote',
            'reservations_quotes_revoked_generic' => 'Abgelehnte Angebote',
            'reservations_quotes_accepted_generic' => 'Akzeptierte Angebote',
            'reservations_quotes_expired_generic' => 'Abgelaufene Angebote',
            'reservations_quotes_draft_generic' => 'Entwurfsangebote',
            'rateplans_generic' => 'Übersicht der Tarifpläne, Angebote und Pakete',
            'rateplans_plans_generic' => 'Tarifpläne Übersicht',
            'rateplans_offers_generic' => 'Angebotsübersicht',
            'rateplans_bundles_generic' => 'Paketübersicht',
            'coupons_generic' => 'Gutscheinübersicht',
            'reservations_list' => 'Buchungsliste',
            'housekeeper' => 'Hausdame_:date',
            'total_entries' => 'Gesamteinträge: :value',
            'meals' => 'Mahlzeiten',
            'meals_plan' => 'Mahlzeitenplan',
            'city_tax' => 'Tourismussteuer',
            'reservations_guests_presences' => 'Anwesende Gäste',
            'deposits' => 'Anzahlungen und Kautionen'
        ],
        'number_of_nights' => 'Anzahl der Nächte',
        'user_full_name' => 'Mitarbeiter',
        'print_date' => 'Druckdatum',
        'total' => 'Gesamt',
        'totals' => 'Summen',
        'quantity' => 'Menge',
        'category' => 'Kategorie',
        'qty' => 'Stk.',
        'discount' => 'Rabatt',
        'description' => 'Beschreibung',
        'wrap_up' => 'Zusammenfassung',
        'amount' => 'Betrag',
        'vat' => 'MwSt.',
        'nic' => 'Steuer-ID',
        'reservation' => 'Buchung',
        'nights' => '{1} 1 Nacht|[2,*] :count Nächte',
        'accommodation' => '{1} 1 Unterkunft|[2,*] :count Unterkünfte',
        'vat_code' => 'USt.-ID',
        'unmapped_addons' => 'Zusatzleistungen vom Portal',
        'details' => 'Details',
        'stripe_statement_descriptor' => 'Buchungsnummer: :reservationNumber - :email',
        'date' => 'Datum',
        'available_soon' => 'Diese Funktion wird bald verfügbar sein',
        'payments' => 'Zahlungen',
        'buyer' => 'Zahler',
        'payment_method' => 'Zahlungsmethode',
        'yes' => 'Ja',
        'no' => 'Nein',
        'checkin_hour' => 'Check-in um',
        'checkout_hour' => 'Check-out um',
    ],

    'company' => [
        'errors' => [
            'vat_code_not_valid' => 'Die eingegebene USt.-ID ist ungültig.',
            'tax_code_not_valid' => 'Die eingegebene Steuer-ID ist ungültig.',
        ],
        'warnings' => [
            'existing_company' => 'Die Firma :company_name mit der eingegebenen USt.-ID existiert bereits.',
        ],
        'export_fields' => [
            'name' => 'Name',
            'address' => 'Adresse',
            'vat_code' => 'USt.-ID',
            'zip_code' => 'PLZ',
            'email' => 'E-Mail',
            'telephone' => 'Telefon',
            'state' => 'Bundesland',
            'county' => 'Bezirk',
            'country' => 'Land',
            'city' => 'Stadt',
            'tax_code' => 'Steuer-ID',
            'nick_name' => 'Spitzname',
        ],
        'import' => [
            'validations' => [
                'vat_code_unique' => 'Es gibt bereits ein Unternehmen mit derselben USt.-ID.',
                'vat_code_required' => 'Das Feld USt.-ID ist erforderlich.',
                'name_required' => 'Das Feld Firmenname ist erforderlich.',
                'nick_name_required' => 'Das Feld Spitzname ist erforderlich.',
                'email' => 'Das Feld E-Mail enthält keine gültige E-Mail-Adresse.',
                'pec' => 'Das Feld PEC enthält keine gültige E-Mail-Adresse.',
            ],
        ],
        'fields' => [
            'company_id' => 'Unternehmenskennzeichen'
        ],
    ],

    'content_api' => [
        'bank_transfer' => 'Akzeptiert Banküberweisung',
        'bank_transfer_note' => 'Hinweise zur Banküberweisung (MAX 500 Zeichen)',
        'checkin_hour' => 'Check-in-Zeit',
        'checkout_hour' => 'Check-out-Zeit',
        'children_allowed' => 'Kinder erlaubt',
        'pets_allowed' => 'Haustiere erlaubt',
        'smoking_allowed' => 'Raucher erlaubt',
        'max_adults_number' => 'Maximale Anzahl Erwachsene',
        'max_guests_number' => 'Maximale Anzahl Erwachsene',
        'minimum_age' => 'Mindestalter',
        'percent_payment_at_booking' => '% Zahlung zum Zeitpunkt der Buchung',
        'remaining_payment_type' => 'Restzahlung',
        'remaining_payment_type_at_checkin_label' => 'Zahlung beim Check-in',
        'remaining_payment_type_at_checkin_description' => 'Der Abschluss der Zahlung wird beim Check-in angefordert',
        'remaining_payment_type_before_checkin_label' => 'Zahlung X Tage vor Check-in',
        'remaining_payment_type_before_checkin_description' => 'Der Zahlungsabschluss ist X Tage vor dem Check-in erforderlich',
        'remaining_payment_type_before_checkin_day' => 'Anzahl der Tage vor dem Check-in',
        'rental_document_upload' => 'Mietdokument hochladen',
        'advertise_name' => 'Name des Werbetreibenden',
        'merchant_name' => 'Name des Händlers',
        'managment_applies_guest_value' => 'Kosten für Gästemanagement',
        'managment_applies_guest_type' => 'Art der Kosten für Gästemanagement',
        'managment_applies_pets_value' => 'Kosten für Haustiermanagement',
        'managment_applies_value' => 'Verwaltungskosten',
        'management_energy_value' => 'Energiekostenmanagement',
        'management_energy_type' => 'Art der Energiekosten',
        'managment_applies_pets_type' => 'Art der Kosten für Haustiermanagement',
        'x_night' => 'Pro Nacht',
        'x_stay' => 'Pro Aufenthalt',
    ],

    'coupons' => [
        'refundable' => [
            '0' => 'Nicht erstattungsfähig',
            '1' => 'Erstattungsfähig',
        ],
        'export_fields' => [
            'code' => 'Code',
            'quantity' => 'Menge',
            'discount' => 'Rabatt',
            'date_from' => 'Von',
            'date_to' => 'Bis',
            'type' => 'Typ',
            'min_expense' => 'Mindestaufwand',
            'min_stay' => 'Min. Aufenthalt',
            'max_stay' => 'Max. Aufenthalt',
            'valid_days' => 'Gültigkeitstage',
        ],
    ],

    'credit_card_type' => [
        'fields' => [
            'model_name' => 'Kreditkarte',
        ],
    ],

    'customer' => [
        'errors' => [
            'reservationExists' => 'Es gibt verknüpfte Reservierungen oder Angebote.',
            'guestExist' => 'Es gibt verknüpfte Gäste.',
            'documentExists' => 'Ein Dokument desselben Typs ist bereits im Archiv vorhanden.',
            'privacyCheckExists' => 'Die Datenschutzbestimmungen wurden bereits vom Kunden akzeptiert.',
            'customerNotFound' => 'Kunde nicht gefunden.',
            'guestExists' => 'Kunde ist als Gast in aktiven Reservierungen konfiguriert.',
            'tax_code_not_valid' => 'Die eingegebene Steuer-ID ist ungültig.',
            'birthday_date_major_than_now' => 'Das Geburtsdatum darf nicht nach dem heutigen Datum liegen',
        ],
        'fields' => [
            'birthday_date' => 'Geburtsdatum des Gastes',
            'sex' => 'Geschlecht des Gastes',
            'address' => 'Adresse des Gastes',
            'zip_code' => 'PLZ des Gastes',
            'email' => 'E-Mail des Gastes',
            'telephone' => 'Telefonnummer des Gastes',
            'name' => 'Name des Gastes',
            'surname' => 'Nachname des Gastes',
            'model_name' => 'Gast',
            'language_id' => 'Sprache'
        ],
        'export_fields' => [
            'name' => 'Name',
            'surname' => 'Nachname',
            'birthday_date' => 'Geburtsdatum',
            'sex' => 'Geschlecht',
            'note' => 'Notizen',
            'city' => 'Stadt',
            'county' => 'Bezirk',
            'state' => 'Bundesland',
            'country' => 'Land',
            'address' => 'Adresse',
            'zip_code' => 'PLZ',
            'email' => 'E-Mail',
            'telephone' => 'Telefon',
            'fax' => 'Fax',
            'facebook' => 'Facebook',
            'linkedin' => 'LinkedIn',
            'twitter' => 'Twitter',
            'web_address' => 'Webseite',
            'birth_city_name' => 'Geburtsstadt',
            'birth_state_name' => 'Geburtsland',
            'birth_state' => 'Geburtsbundesland',
            'residence_city' => 'Wohnsitz - Stadt',
            'residence_county' => 'Wohnsitz - Bezirk',
            'residence_state' => 'Wohnsitz - Bundesland',
            'residence_country' => 'Wohnsitz - Land',
            'residence_address' => 'Wohnsitz - Adresse',
            'residence_zip_code' => 'Wohnsitz - PLZ',
            'billing_city' => 'Rechnungsstellung - Stadt',
            'billing_county' => 'Rechnungsstellung - Bezirk',
            'billing_state' => 'Rechnungsstellung - Bundesland',
            'billing_country' => 'Rechnungsstellung - Land',
            'billing_address' => 'Rechnungsstellung - Adresse',
            'billing_zip_code' => 'Rechnungsstellung - PLZ',
            'promotion_check' => 'Newsletter',
            'privacy_check' => 'DSGVO',
            'reservations_count' => 'Reservierungen',
            'type' => 'Typ',
            'newsletter' => 'Newsletter',
            'GDPR' => 'DSGVO',
        ],
        'import' => [
            'validations' => [
                'nic_unique' => 'Ein Kunde mit derselben Steuer-ID existiert bereits.',
                'name_required' => 'Das Feld Name ist erforderlich.',
                'sex' => 'Das Feld Geschlecht ist ungültig. Zulässige Werte: nicht definiert, männlich, weiblich.',
                'surname_required' => 'Das Feld Nachname ist erforderlich.',
                'email' => 'Das Feld E-Mail enthält keine gültige E-Mail-Adresse.',
                'birthday_date_date_format' => 'Das Feld Geburtsdatum ist nicht korrekt formatiert.',
                'document_type' => 'Der Dokumenttyp existiert nicht.',
                'birth_country_not_valid' => 'Das Feld Geburtsland ist ungültig.',
                'birth_city_not_valid' => 'Das Feld Geburtsstadt ist ungültig.',
                'citizenship_country_not_valid' => 'Das Feld Staatsangehörigkeit ist ungültig.',
                'residence_country_not_valid' => 'Das Feld Wohnsitzland ist ungültig.',
                'residence_city_not_valid' => 'Das Feld Wohnsitzstadt ist ungültig.',
                'nationality_country_not_valid' => 'Das Feld Nationalität ist ungültig.',
                'language' => 'Das Feld Sprache ist ungültig. Verwenden Sie das ISO-Format in Kleinbuchstaben (z.B.: it, en).',
            ],
            'alredy-in-progress' => 'Der Import ist noch im Gange. Bitte warten Sie, bis er abgeschlossen ist, und versuchen Sie es erneut.',
        ],
    ],

    'daily_closure' => [
        'daily_title' => 'Täglicher Abschluss',
        'department' => 'Abteilung',
        'production' => 'Produktion',
        'total' => 'Gesamt',
        'property' => 'Einrichtung',
        'receipt' => 'Quittung',
        'name' => 'Name',
        'invoice' => 'Rechnung',
        'amount' => 'Saldo',
        'guests' => 'Gäste',
        'accommodation' => 'Zimmer',
        'empty_documents' => 'Keine ausgestellten oder empfangenen Dokumente im ausgewählten Zeitraum',
        'empty_payments' => 'Keine ausgestellten oder empfangenen Zahlungen im ausgewählten Zeitraum',
        'export_fields' => [
            'production_department' => 'Produktion nach Abteilung',
            'production_treatments' => 'Produktion nach Behandlung',
            'production_accommodations' => 'Produktion nach Unterkunft',
            'occupancy' => 'Belegung',
            'documents' => 'Dokumente vom :date_from|Dokumente vom :date_from bis :date_to',
            'payments' => 'Zahlungen vom :date_from|Zahlungen vom :date_from bis :date_to',
            'summary' => 'Kassenübersicht (:date_from)|Kassenübersicht (:date_from - :date_to)',
            'accommodations_sold' => 'Verkaufte Zimmer',
            'sold_nights' => 'Verkaufte Nächte',
            'unsold_nights' => 'Unverkaufte Nächte',
            'penalty_nights' => 'Nächte mit Strafe',
            'accommodations_available' => 'Verfügbare Zimmer',
            'date' => 'Datum',
            'income' => 'Einnahmen',
            'outcome' => 'Ausgaben',
            'occupancy' => 'Belegung',
            'payment_method' => 'Zahlungsmethode',
            'type' => 'Art',
            'reversal_receipt' => 'Quittungskorrektur',
            'number' => 'Nummer',
            'in' => 'Eingänge',
            'out' => 'Ausgänge',
            'intestatary' => 'Inhaber',
            'name' => 'Name',
            'modality' => 'Modalität',
            'note' => 'Notizen',
            'taxable' => 'Steuerpflichtig',
            'vat_quote' => 'MwSt.',
            'treatment' => 'Behandlung',
            'average_revenue' => 'Durchschnittlicher Gästerlös',
            'adr' => 'ADR',
            'revpar' => 'RevPAR',
            'reservations' => 'Reservierungen',
            'no_show' => 'No-Show',
            'confirmed' => 'Bestätigt',
            'cancelled' => 'Storniert',
            'optionable' => 'Optionen',
            'expired' => 'Abgelaufen',
            'unknown' => 'Unbekannt',
            'checkin' => 'Ankünfte',
            'checkout' => 'Abreisen',
            'in_house' => 'Verweildauer',
            'attendance' => 'Anwesenheiten',
            'absolute_guests' => 'Absolute Gäste',
        ],
    ],

    'daily_summary' => [
        'daily_summary' => 'Tägliche Zusammenfassung',
        'accommodation' => 'Zimmer',
        'accommodation_type' => 'Zimmertyp',
        'name_and_surname' => 'Vor- und Nachname',
        'stay' => 'Aufenthalt',
        'guests' => 'Gäste',
        'treatment' => 'Verpflegung',
        'channel' => 'Kanal',
        'payment_details' => 'Zahlungsdetails',
        'notes' => 'Notizen',
        'adults' => 'Erwachsene',
        'children' => 'Kinder',
        'total' => 'Gesamt',
        'arrivals' => 'Ankünfte',
        'departures' => 'Abreisen',
        'in_home' => 'Verweildauer',
        'nights' => 'Nächte',
        'paid' => 'Bezahlt',
        'to_pay' => 'Zu zahlen',
        'no_reservations_found' => 'Keine Reservierungen für dieses Datum vorhanden',
        'daily_summary_of_date' => 'Tägliche Zusammenfassung vom :date',
    ],

    'deposits' => [
        'export_fields' => [
            'property' => 'Einrichtung',
            'number' => 'Nummer',
            'deposit_number' => 'Nummer',
            'document_number' => 'Dokumentnummer',
            'date' => 'Datum',
            'registration_date' => 'Datum',
            'type' => 'Typ',
            'amount' => 'Betrag',
            'amount_available' => 'Verfügbarer Betrag',
            'amount_used' => 'Verwendet',
            'reservation_number' => 'Reservierungs-ID',
            'pos' => 'POS',
            'description' => 'Beschreibung',
            'buyer' => 'Zahler',
            'reservation_id' => 'Reservierungs-ID',
            'used_amount' => 'Verwendet',
            'user_pay' => 'Zahler',
            'reservation' => 'Reservierung',
            'payment_method' => 'Zahlungsmethode',
            'arrival_date' => 'Anreisedatum',
            'departure_date' => 'Abreisedatum',
            'deposit' => 'Anzahlung',
            'part_payment' => 'Teilzahlung',
            'stay' => 'Aufenthalt',
        ],
    ],

    'email_suppression_list' => [
        'reason_types' => [
            'BOUNCE' => 'Unzustellbar',
            'COMPLAINT' => 'Als SPAM gemeldet',
        ],
        'errors' => [
            'NotFoundException' => 'E-Mail nicht gefunden',
            'BadRequestException' => 'Ungültige Anfrageparameter',
            'TooManyRequestsException' => 'Zu viele Anfragen gestellt',
            'TooManyRequestException' => 'Zu viele Anfragen gestellt',
        ],
    ],

    'emails' => [
        'multiple_sessions' => [
            'subject' => 'Sicherheitswarnung: Mehrere Geräte mit Ihrem Konto verbunden',
            'body' => "Hallo :user_first_name,<br />wir haben Verbindungen von mehreren Geräten zu Ihrem Konto festgestellt. Wir empfehlen, Ihre derzeit aktiven Sitzungen zu überprüfen:",
            'summary_reset' => 'Wenn Sie diese Geräte nicht erkennen, <a href=":recoveryPasswordLink" target="_blank">empfehlen wir, sofort Ihr Passwort zu ändern</a>, um Ihr Konto zu schützen.',
            'device' => 'Gerät',
            'place' => 'Ort',
            'date_hour' => 'Datum und Uhrzeit',
            'unknown' => 'Unbekannt',
            'logout' => 'Sie können sich auch <a href=":logoutAllDevice" target="_blank">von allen Geräten abmelden</a> über Profil > Sicherheit & Zugriff.',
        ],
        'general' => [
            'link_preview' => 'Klicken Sie hier für die druckbare Version',
            'additionals_informations' => 'Zusätzliche Informationen',
            'automatic_email_message' => 'Diese E-Mail wird automatisch gesendet, bitte antworten Sie nicht auf diese Adresse.',
            'message' => 'Nachricht',
        ],
        'reservation_confirmed' => [
            'subject' => 'Reservierung Nummer #:reference_number',
            'reservation_confirm' => 'Ihre Reservierung',
            'reply' => 'Antworten',
            'tax' => 'Steuern',
            'reservation_number' => 'Nummer',
            'thanks' => 'Vielen Dank',
            'view_quote' => 'Klicken Sie hier, um den Kostenvoranschlag zu sehen',
            'show_detail' => '<a href=":showDetailsReservation">Klicken Sie hier, um die Reservierung anzusehen</a>',
            'confirm_reservation_with_bank_transfer_suggestion' => 'Um die Reservierung abzuschließen, empfehlen wir, die Zahlung so schnell wie möglich abzuschließen.',
            'your_reservation' => 'Ihre Reservierung für',
            'is_confirmed' => 'ist bestätigt',
            'ti_aspettiamo_il' => 'Wir erwarten Sie am',
            'city_tax' => 'Tourismussteuer',
            'reservation_summary' => 'Reservierungsübersicht',
            'nights' => 'Nacht|Nächte',
            'accommodations' => 'Unterkunft|Unterkünfte',
            'adults' => 'Erwachsener|Erwachsene',
            'childrens' => 'Kind|Kinder',
            'reservation_confirmed_with_stripe' => 'Die Reservierung wurde mit dem Stripe-Zahlungsgateway bestätigt.',
            'total_reservation' => 'Gesamtkosten der Reservierung',
            'price_payed' => 'Bezahlter Betrag',
            'price_to_pay' => 'Zu zahlender Betrag',
            'payment_method' => 'Zahlungsmethode',
            'other_request' => 'Spezifikationen und weitere Anfragen',
            'banktransfer_informations' => 'Bankverbindung',
            'printable_link' => 'Klicken Sie hier für die druckbare Version',
            'other_operations' => 'Weitere Operationen',
            'checkin' => 'Online-Check-In durchführen',
            'modify_reservation' => 'Reservierung ändern',
            'cancel_reservation' => 'Reservierung stornieren',
            'additional_informations' => 'Zusätzliche Informationen',
            'contability_informations' => 'Nach Erhalt der Zahlung von <b>:price_deposit</b> werden wir die Reservierung bestätigen. Um den Vorgang zu beschleunigen, senden Sie uns bitte eine Kopie der Überweisung mit der CRO-Nummer.',
            'checkin_online_pin' => 'Ihr Code für den <a style="color: #8f743f; text-decoration: underline !important;" target="_blank" href=":link">Online-Check-In</a> ist',
            'pin' => 'Pin',
        ],
        'reservation_request_avail' => [
            'subject' => 'Verfügbarkeitsanfrage für :property_name (:arrival_date - :departure_date)',
            'reservation_confirm' => 'Verfügbarkeitsanfrage',
            'reply' => 'Antworten',
            'tax' => 'Steuern',
            'reservation_number' => 'Nummer',
            'thanks' => 'Vielen Dank',
            'view_quote' => 'Klicken Sie hier, um den Kostenvoranschlag zu sehen',
            'show_detail' => 'Klicken Sie hier, um die Reservierung anzusehen',
            'show_detail_avail' => 'Klicken Sie hier, um die Verfügbarkeitsanfrage anzusehen',
            'your_request_avail' => 'Ihre Verfügbarkeitsanfrage für',
            'is_confirmed' => 'wurde gesendet',
            'invalid_reservation' => 'Bitte beachten Sie, dass diese Anfrage keinen Reservierungswert hat, bis sie bestätigt wird.',
            'invalid_reservation_property' => 'Diese Anfrage hat keinen Reservierungswert. Der Kunde wartet auf Ihre Bestätigung.',
            'receive_news' => 'Sie werden so schnell wie möglich von uns hören.',
            'city_tax' => 'Tourismussteuer',
            'reservation_summary' => 'Anfrageübersicht',
            'nights' => 'Nacht|Nächte',
            'accommodations' => 'Unterkunft|Unterkünfte',
            'adults' => 'Erwachsener|Erwachsene',
            'childrens' => 'Kind|Kinder',
            'total_reservation' => 'Gesamtkosten der Reservierung',
            'price_payed' => 'Bezahlter Betrag',
            'price_to_pay' => 'Zu zahlender Betrag',
            'payment_method' => 'Zahlungsmethode',
            'other_request' => 'Spezifikationen und weitere Anfragen',
            'printable_link' => 'Klicken Sie hier für die druckbare Version',
            'other_operations' => 'Weitere Operationen',
            'additional_informations' => 'Zusätzliche Informationen',
        ],
        'reservation_cancelled_from_user' => [
            'subject' => 'Reservierung storniert (#:reference_number)',
            'body_1' => 'Hallo,<br>Diese automatische E-Mail bestätigt die Stornierung der Reservierung Nr. <b>:reference_number</b>, die am <b>:booked_at</b> vorgenommen wurde.',
            'body_2' => '<b>Reservierungsübersicht</b><br>
                 <b>:name :surname</b> (vom <b>:arrival_date</b> bis <b>:departure_date</b>)<br>
                 <b>Zimmer:</b> :reservation_accommodations<br>
                 <b>Gäste: </b> :total_guests<br>
                 <b>Gesamtbetrag: </b> :currency :total_price',
            'body_policy_no_penalty' => 'Laut den <b>Stornierungsbedingungen</b> fallen keine Strafen an.',
            'body_policy_penalty' => 'Laut den <b>Stornierungsbedingungen</b> fällt eine Strafe von :currency :penalty_value an.',
            'body_3' => 'Für weitere Informationen kontaktieren Sie uns bitte.',
        ],
        'property_reservation_new' => [
            'subject' => 'Neue Reservierung von :channel_name - :property_name (#:reference_number)',
        ],
        'property_reservation_modified' => [
            'subject' => 'Reservierungsänderung von :channel_name (#:reference_number)',
        ],
        'invoice_rejected' => [
            'subject' => 'Rechnung :number_complete vom :invoice_date vom SDI abgelehnt',
            'body' => 'Die Rechnung Nr. <b>:number_complete</b> wurde vom SDI aus folgendem Grund abgelehnt: <b>:rejected_reason</b>',
        ],
        'invoice_received' => [
            'subject' => 'Rechnung :document_number vom :document_date von :sender_name erhalten',
            'body' => 'Die Rechnung Nr. <b>:document_number</b> vom <b>:document_date</b> wurde von <b>:sender_name</b> erhalten.',
        ],
        'document_default_email' => [
            'body' => 'Sehr geehrter Kunde,<br>Nachfolgend finden Sie die Informationen zur :document_type :document_number vom :document_date.<br>Im Anhang finden Sie eine Kopie des Dokuments.<br><br>Mit freundlichen Grüßen,<br>:sender_name',
        ],
        'suspend_email_reminder' => [
            'subject' => '{{% invoice.type %}} Nr. {{% invoice.number_complete %}}',
            'body' => 'Sehr geehrter Kunde,<br>uns liegt vor, dass die {{% invoice.type %}} {{% invoice.number_complete %}} vom {{% invoice.invoice_date %}} über {{% invoice.total %}} noch nicht beglichen wurde.<br><br>Wir bitten Sie daher, Ihre offenen Rechnungen schnellstmöglich zu begleichen.<br>Im Anhang finden Sie eine Kopie des Dokuments.<br><br>Falls Sie die Zahlung bereits vorgenommen haben, ignorieren Sie bitte diese Nachricht.<br><br>Mit freundlichen Grüßen,<br>{{% reservation.property_name %}}',
        ],
        'property_reservation_cancelled' => [
            'subject' => 'Reservierung storniert von :channel_name (#:reference_number)',
            'body_1' => 'Die Reservierung <b>:xml_reservation_id</b> im Namen von <b>:name :surname</b> (vom <b>:arrival_date</b> bis <b>:departure_date</b>) bezüglich der Zimmer der Einrichtung <b>:property_name</b> wurde auf dem Kanal <b>:channel_name</b> storniert:<br>:accommodations_lists',
            'body_2' => 'Um alle Details der Reservierung anzuzeigen, <a href="https://app.beddy.io/reservation/:reservation_id">klicken Sie hier</a>',
        ],
        'property_reservation_banktransfer_cancelled' => [
            'subject' => 'Reservierung storniert von :channel_name (#:reference_number) wegen Nichtzahlung',
            'body_1' => 'Eine Reservierung wurde automatisch wegen Nichtzahlung per Überweisung storniert.<br /><br />
                <u>Nachfolgend die Details zur Stornierung:</u><br /><br />
                Einrichtung: <b>:property_name</b><br />
                Herkunftsportal: :channel_name<br />
                Reservierungs-ID/Referenz: :xml_reservation_id<br />
                Kunde: <b>:name :surname</b><br />
                Aufenthaltszeitraum: vom <b>:arrival_date</b> bis <b>:departure_date</b><br />
                Betroffene Zimmer: <br>:accommodations_lists<br />',
            'body_2' => 'Um alle Details der Reservierung anzuzeigen, <a href="https://app.beddy.io/reservation/:reservation_id">klicken Sie hier</a>',
        ],
        'past_connect_reservation_cancelled' => [
            'subject' => 'Hinweis: Stornierung einer Reservierung, die in Beddy nicht vorhanden ist. Bitte Verfügbarkeit prüfen',
            'body' => 'Eine Reservierung, die nicht in Beddy vorhanden ist, wurde storniert. <strong>Eine manuelle Überprüfung ist erforderlich</strong>, da die Verfügbarkeit der betroffenen Unterkünfte möglicherweise nicht aktualisiert ist.
                <br>
                Eine Reservierung kann aus zwei Gründen fehlen:
                <br>
                1. Die Reservierung wurde vor der Verbindung mit dem Channel Manager vorgenommen: Nicht alle Portale erlauben den Download dieser Reservierungen (oder der Download ist zeitlich begrenzt).
                <br>
                2. Der Kunde hat die Reservierung sofort storniert. In solchen Fällen kann es vorkommen, dass das Portal uns die Stornierung sendet, ohne die zugehörige Reservierung gesendet zu haben, sodass Beddy keinen Bezug hat.
                <br>
                <br>
                <strong>Nachfolgend die Details der Stornierung:</strong>
                <br>
                Herkunftsportal: :channel_name
                <br>
                Reservierungs-ID: :xml_reservation_id
                <br>
                Datum der Buchung: :booked_at
                <br>
                Kunde: :customer_name :customer_surname
                <br>
                <br>
                <strong>Was ist zu tun:</strong>
                <br>
                - Überprüfen Sie im Extranet des Portals die Existenz der Reservierung und die zugehörige Stornierung.
                <br>
                - Überprüfen Sie die Verfügbarkeiten in Beddy und im Extranet des Portals. Falls erforderlich, aktualisieren Sie diese im Channel Manager.
                <br><br>
                Mit freundlichen Grüßen',
        ],
        'property_activation' => [
            'subject' => 'Account :product_name - :property_name',
            'footer' => 'Für weitere Informationen steht Ihnen unser Kundenservice von Montag bis Freitag von 10:00 bis 14:00 Uhr und von 15:30 bis 18:00 Uhr zur Verfügung.
                 Vielen Dank, dass Sie sich für :product_name entschieden haben. Wir möchten die Gelegenheit nutzen, Ihnen
                 <br><br>
                 Mit freundlichen Grüßen',
        ],
        'users' => [
            'changedPassword' => [
                'subject' => 'Beddy - Ihr Passwort wurde geändert',
                'summary' => 'Sehr geehrte/r <b>:firstname</b>,<br>wir informieren Sie, dass das Passwort Ihres <b>Beddy</b>-Kontos erfolgreich geändert wurde.',
                'errors' => [
                    'unexpectedNotice' => 'Wenn Sie diese Änderung nicht selbst vorgenommen haben, wenden Sie sich bitte an den Administrator der Unterkunft und/oder an unseren Support.<br><br>
                Mit freundlichen Grüßen,<br>
                Ihr Beddy-Team',
                ],
            ],
            'attachment' => [
                'subject' => 'Sie wurden einer neuen Einrichtung auf Beddy zugewiesen',
                'summary' => 'Sehr geehrte/r <b>:firstname</b>,<br>Ihr Beddy-Konto wurde mit einer neuen Einrichtung verknüpft.<br><br>Hier sind die Zugangsdaten:',
                'property' => 'Einrichtung',
                'roleAssigned' => 'Zugewiesene Rolle',
                'loginDetails' => [
                    'login' => 'Sie können jederzeit über app.beddy.io mit denselben Zugangsdaten auf diese Einrichtung zugreifen.',
                    'helpContactInfo' => 'Bei Bedarf können Sie Kontakt aufnehmen mit:',
                    'master' => 'dem Administrator der Einrichtung: :masterEmail',
                    'support' => 'Beddy-Support: <a href="mailto: :supportEmail">:supportEmail</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'Wenn Sie diese Mitteilung nicht erwartet haben oder glauben, dass dies ein Fehler ist, schließen Sie die Aktivierung bitte nicht ab und kontaktieren Sie den Administrator der Einrichtung und/oder unseren Support.',
                ],
            ],
            'activation' => [
                'subject' => 'Sie wurden zu Beddy eingeladen – Aktivieren Sie Ihren Zugang',
                'summary' => 'Sehr geehrte/r <b>:firstname</b>,<br> ein Beddy-Konto wurde für Sie erstellt.<br><br> Ihre Daten lauten:',
                'username' => 'Benutzername',
                'email' => 'E-Mail',
                'toDo' => 'Um <b>Ihr Konto zu aktivieren</b>, müssen Sie ein <b>Passwort</b> festlegen.',
                'button' => '<a href=":creationPasswordLink">Passwort erstellen</a>',
                'expiration' => 'Der Aktivierungslink ist 5 Tage lang gültig.',
                'contacts' => [
                    'helpContactInfo' => 'Bei Bedarf können Sie Kontakt aufnehmen mit:',
                    'master' => 'dem Administrator der Unterkunft: ',
                    'support' => 'Beddy-Support: <a href=\"mailto:support@beddy.io\">support@beddy.io</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'Wenn Sie diese Nachricht nicht erwartet haben oder glauben, dass sie irrtümlich gesendet wurde, schließen Sie die Aktivierung bitte nicht ab und kontaktieren Sie den Administrator der Unterkunft und/oder unseren Support.',
                    'uncompletedRegistration' => 'Registrierung nicht abgeschlossen: Das Konto ist noch nicht aktiv. Überprüfen Sie die E-Mail, die wir Ihnen gesendet haben, und legen Sie ein Passwort fest, um es zu aktivieren.',
                ]
            ],
            'passwordreset' => [
                'subject' => 'Passwort-Reset-Verfahren für :product_name-Konto',
                'body' => 'Hallo <b>:first_name!</b>
        <br/>
        Sie erhalten diese E-Mail, weil Sie eine Änderung des Passworts für Ihr :product_name-Konto angefordert haben.
        <br><br>
        Um das Passwort zu ändern, klicken Sie bitte innerhalb von 30 Minuten auf <a href=":link_reset">diesen Link</a>.
        <br>
        Wenn Sie die Passwortänderung nicht angefordert haben oder nicht fortfahren möchten, ignorieren Sie diese E-Mail.
        <br>
        Mit freundlichen Grüßen.',
            ],
            'password_expiration_notify' => [
                'subject' => 'Benachrichtigung über das Ablaufdatum des Beddy-Konto-Passworts',
                'body' => 'Sehr geehrte/r <b>:name :surname</b>,
                <br/>
                Wir informieren Sie darüber, dass das Passwort für Ihr Beddy-Konto in <b>:days Tagen</b> abläuft. Bitte aktualisieren Sie es so bald wie möglich in der <a href=":profile" target="_blank">Profil</a>-Sektion.
                <br><br>
                Falls Sie Ihr aktuelles Passwort vergessen haben, können Sie es zurücksetzen, indem Sie auf <i><a href=":resetPassword" target="_blank">Probleme beim Anmelden?</a></i> auf der <a href=":login" target="_blank">Login-Seite</a> klicken.
                <br>
                <br>
                Mit freundlichen Grüßen,<br>
                Das Beddy-Team',
            ],
        ],
        'bank_transfer_reminder' => [
            'subject' => 'Reservierung Nr. :reference_number - Überweisungserinnerung',
            'body' => 'Sehr geehrte/r :booker_name :booker_surname,<br>
        bezüglich Ihrer Reservierung :reference_number vom :booked_at möchten wir Sie daran erinnern, dass die Bestätigung der Reservierung von der Zahlung von :price abhängt.
        <br><br>
        Nachfolgend finden Sie die Bankverbindung für die Überweisung:<br>
        <i>:bank_text</i>
        <br><br>
        Sollte die Zahlung in den nächsten Tagen nicht eingehen, wird die Reservierung automatisch storniert.
        <br><br>
        Falls die Zahlung bereits erfolgt ist, ignorieren Sie bitte diese Nachricht.<br>
        Für weitere Informationen stehen wir Ihnen gerne zur Verfügung.<br>',
            'footer' => 'Mit freundlichen Grüßen,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'bank_transfer_cancelled' => [
            'subject' => 'Reservierung storniert Nr. :reference_number',
            'body' => 'Sehr geehrte/r :booker_name :booker_surname,<br>
        da wir keine Rückmeldung erhalten haben, teilen wir Ihnen mit, dass die Reservierung :reference_number vom :booked_at storniert wurde.
        <br><br>
        Für weitere Informationen stehen wir Ihnen gerne zur Verfügung.<br>',
            'footer' => 'Mit freundlichen Grüßen,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'cutoff_errors' => [
            'subject' => 'Fehler beim Senden des Cutoffs - :property_name',
            'body_1' => 'Für die Einrichtung <b>:property_name</b> sind folgende Fehler aufgetreten:<br><br>',
            'footer' => 'Mit freundlichen Grüßen.',
        ],
        'deactivate_properties' => [
            'first_notice' => [
                'subject' => 'Erneuerung des Beddy-Kontos',
                'body_1' => 'Sehr geehrter Kunde,
                    <br><br>
                    wir freuen uns, Ihnen die Erneuerung Ihres Beddy-Kontos und aller zugehörigen Dienste zu bestätigen.
                    <br><br>',
                'body_2' => 'In den nächsten Tagen erhalten Sie über den SDI-Kanal die Rechnung für die Nutzung der Software Beddy (vom :date_from bis :date_to). Bitte senden Sie uns eine Kopie der Zahlungsbestätigung, um die Zuordnung zu erleichtern.
                    <br><br>
                    Ihre Daten:',
                'body_3' => 'Für weitere Informationen steht Ihnen unser Kundenservice von Montag bis Freitag von 10:00 bis 14:00 Uhr und von 15:30 bis 18:00 Uhr gerne zur Verfügung.',
                'footer' => 'Vielen Dank, dass Sie sich für Beddy entschieden haben. Wir möchten die Gelegenheit nutzen, Ihnen
                    <br><br>
                    Mit freundlichen Grüßen,',
            ],
            'second_notice' => [
                'subject' => 'Erneuerung des Beddy-Kontos',
                'body_1' => 'Sehr geehrter Kunde,
                    <br><br>
                    wir freuen uns, Ihnen erneut die Erneuerung Ihres Beddy-Kontos und aller zugehörigen Dienste zu bestätigen.
                    <br><br>
                    In Kürze erhalten Sie über den SDI-Kanal die Rechnung für die Nutzung der Software Beddy (vom :date_from bis :date_to).
                    <br><br>
                    Ihre Daten:',
                'body_2' => 'Für weitere Informationen steht Ihnen unser Kundenservice von Montag bis Freitag von 10:00 bis 14:00 Uhr und von 15:30 bis 18:00 Uhr gerne zur Verfügung.
                    <br><br>
                    Vielen Dank, dass Sie sich für Beddy entschieden haben. Wir möchten die Gelegenheit nutzen, Ihnen
                    <br><br>
                    Mit freundlichen Grüßen,',
            ],
        ],
        'reservation_quote_expire' => [
            'subject' => 'Ihr Angebot ist abgelaufen',
            'body_1' => 'Sehr geehrte/r :customer_name :customer_surname,
                <br>wir bedauern, Ihnen mitteilen zu müssen, dass das von Ihnen am :creation_date angeforderte Angebot abgelaufen ist.',
            'body_2' => '<br><br>Für weitere Informationen stehen wir Ihnen gerne zur Verfügung.',
            'footer' => '<br><br>Mit freundlichen Grüßen,
                <br>:property_name
                <br>:property_telephone
                <br>:property_email',
        ],
        'reservation_quote_expire_property' => [
            'subject' => 'Ihr Angebot ist abgelaufen',
            'body_1' => 'Das Angebot für den Kunden :customer_name :customer_surname, das Sie am :creation_date erstellt haben, ist abgelaufen.',
            'footer' => '<br><br>Mit freundlichen Grüßen.',
        ],
        'housekeeper_maintainer' => [
            'subject' => 'Neue Wartungsmeldung für die Unterkunft :accommodation_name',
            'body' => 'Für die Unterkunft <b>:accommodation_name</b> (<b>:tableau_label</b>) wurde eine neue Wartungsmeldung eingereicht. Hier sind alle Details: <br><br><b>Titel:</b> :title <br><br><b>Beschreibung:</b> :description',
        ],
        'payments_timetable' => [
            'stripe_not_active' => [
                'subject' => 'Automatische Zahlungsabbuchung fehlgeschlagen (ID: :payment_timetable_id - :scheduled_date) - Stripe nicht aktiv',
                'body' => 'Die automatische Abbuchung der Zahlung (ID: :payment_timetable_id vom :scheduled_date - Reservierung :reservation_reference_number auf den Namen von :booker_name :booker_surname) konnte nicht durchgeführt werden, da kein aktives Stripe-Konto verfügbar ist.',
            ],
            'no_credit_card' => [
                'subject' => 'Automatische Zahlungsabbuchung fehlgeschlagen (ID: :payment_timetable_id - :scheduled_date) - Keine Kreditkarte vorhanden',
                'body' => 'Die automatische Abbuchung der Zahlung (ID: :payment_timetable_id vom :scheduled_date - Reservierung :reservation_reference_number auf den Namen von :booker_name :booker_surname) konnte nicht durchgeführt werden, da keine Kreditkarte hinterlegt ist.',
            ],
            'charge_failed' => [
                'subject' => 'Automatische Zahlungsabbuchung fehlgeschlagen (ID: :payment_timetable_id - :scheduled_date)',
                'body' => 'Die automatische Abbuchung der Zahlung (ID: :payment_timetable_id vom :scheduled_date - Reservierung :reservation_reference_number auf den Namen von :booker_name :booker_surname) konnte aus folgendem Grund nicht durchgeführt werden: :error_description',
            ],
            'payment_exceeded' => [
                'subject' => 'Automatische Zahlungsabbuchung fehlgeschlagen (ID: :payment_timetable_id - :scheduled_date) - Zahlung übersteigt Reservierungstotal',
                'body' => 'Die automatische Abbuchung der Zahlung (ID: :payment_timetable_id vom :scheduled_date - Reservierung :reservation_reference_number auf den Namen von :booker_name :booker_surname) konnte nicht durchgeführt werden, da die Zahlung das Gesamtreservierungsvolumen überschreitet.',
            ],
            'payment_require_action' => [
                'subject' => 'Automatische Zahlung fehlgeschlagen (ID: :payment_timetable_id - :scheduled_date) - 3D Secure erforderlich',
                'body' => 'Die automatische Abbuchung ist wegen einer 3D-Secure-Anforderung fehlgeschlagen (ID: :payment_timetable_id, am :scheduled_date - Buchung :reservation_reference_number auf den Namen von :booker_name :booker_surname).',
            ],
            'payment_require_action_send_request' => [
                'subject' => 'Automatische Zahlung fehlgeschlagen (ID: :payment_timetable_id - :scheduled_date) - Zahlung ausstehend zur Bestätigung',
                'body' => "Die automatische Abbuchung ist wegen einer 3D-Secure-Anforderung fehlgeschlagen (ID: :payment_timetable_id, am :scheduled_date - Buchung :reservation_reference_number auf den Namen von :booker_name :booker_surname).\nEine Zahlungsanfrage wurde per E-Mail an den Kunden gesendet.",
            ],
        ],
        'reservation_quote_expire_days_before' => [
            'subject' => 'Ihr Angebot läuft bald ab',
            'body_1' => 'Sehr geehrte/r :customer_name :customer_surname,
                <br>wir möchten Sie darauf hinweisen, dass das <a href=":quote_link">Angebot</a>, das Sie angefordert haben, am :expire_date abläuft.',
            'body_2' => '<br><br>Für weitere Informationen stehen wir Ihnen gerne zur Verfügung.',
            'footer' => '<br><br>Mit freundlichen Grüßen,
                <br>:property_name
                <br>:property_telephone
                <br>:property_email',
        ],
        'email_auth_verification' => [
            'body' => 'Sehr geehrte/r :name :surname, <br/><br/> hier ist der von Ihnen angeforderte PIN, um den Zugang zu Ihrem Beddy-Konto zu bestätigen: <strong>:pin</strong> <br/><br/> Ihr PIN läuft um :expire_time ab.',
        ],
        'user_update_email_verification_code' => [
            'body' => 'Sehr geehrte/r :name :surname, <br/><br/> um die Änderung Ihres Beddy-Kontos abzuschließen, geben Sie bitte diesen PIN ein: <strong>:pin</strong>',
            'warning' => 'Wenn Sie keine Änderung angefordert haben, empfehlen wir Ihnen, <a href=":recoveryPasswordLink" target="_blank">umgehend Ihr Passwort zu ändern</a>, um Ihr Konto zu schützen.<br/><br/>
                 Außerdem können Sie sich über das Menü <a href=":logoutAllDevice" target="_blank">Profil > Sicherheit und Zugriff</a> von allen Geräten abmelden.',
        ],
        'user_update_email_confirmed' => [
            'subject' => 'Ihre E-Mail-Adresse wurde aktualisiert',
            'body' => 'Sehr geehrte/r :name :surname, <br/><br/> die E-Mail-Adresse, die mit Ihrem Beddy-Konto verknüpft ist, wurde erfolgreich aktualisiert. <br/><br/>Ab sofort erhalten Sie Nachrichten an diese Adresse.',
        ],
        'checkin_online_complete' => [
            'subject' => 'Online-Check-in abgeschlossen - :reference_number',
            'body_1' => 'Sehr geehrte/r <b>:property_name</b>, <br/><br /> <b>:main_guest_name :main_guest_surname</b> hat soeben den Online-Check-in für die folgende Buchung abgeschlossen:<br/>',
            'reservation_number' => 'Buchung #:reference_number',
            'view_guests' => 'Gastdaten überprüfen',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'subject' => 'Reinigungsstatus geändert für Unterkunft :cleanable_name - :accommodation_name',
            'body' => ':user_name hat den Reinigungsstatus auf <b>:clean_status</b> am Tag <b>:reference_date</b> für die Unterkunft <b>:cleanable_name</b> (:accommodation_name) in der Einrichtung :property_name gesetzt.',
        ],
        'reservation_option_expired' => [
            'subject' => 'Optionale Buchung abgelaufen (#:reference_number)',
            'body' => 'Die Buchung mit der Nummer <b>:reference_number</b> auf den Namen <b>:booker_name :booker_surname</b> mit Anreisedatum <b>:arrival_date</b> und Abreisedatum <b>:departure_date</b> ist abgelaufen.',
        ],
        'order_payment_release' => [
            'subject' => 'Zahlungsvorautorisierung freigegeben (#:reference_number)',
            'body' => 'Die Zahlungsvorautorisierung für die Buchung mit der Nummer <b>:reference_number</b> (vom <b>:arrival_date</b> bis <b>:departure_date</b>) auf den Namen <b>:customer_name :customer_surname</b> wurde freigegeben.',
        ],
        'sca_authorized' => [
            'subject' => 'SCA genehmigt (#:reference_number)',
            'body' => 'Die SCA für die Buchung mit der Nummer <b>:reference_number</b> auf den Namen <b>:booker_name :booker_surname</b> (vom: <b>:arrival_date</b> bis <b>:departure_date</b>) wurde am <b>:accepted_date</b> genehmigt. Die SCA wurde von der IP-Adresse <b>:ip_address</b> autorisiert.',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => 'Keine Verfügbarkeit mehr für die Unterkunft :accommodation_name - Einrichtung: (:property_name)',
            'body' => 'Am <b>:date_now</b> ist die Verfügbarkeit für die Unterkunft: <b>:accommodation_name - (:property_name)</b> an den folgenden Tagen erschöpft: <b>:days</b>',
        ],
        'guests_reporting' => [
            'error_levels' => [
                'reservation' => 'Reservierung :reservationId - :booker',
                'accommodation' => 'Unterkunft :accommodationType - :accommodationTableauNumber',
                'guest' => 'Gast :guest',
            ],
            'alloggiatiweb' => [
                'mail' => [
                    'subject' => 'Bericht Gästeregistrierungen - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'summary' => 'Nachfolgend finden Sie den Bericht über die Gästeregistrierungen vom :alloggiatiweb_send_date der Versandgruppe :alloggiatiweb_group_label:',
                    'success' => [
                        'body' => ':number von :alloggiatiweb_guest_total gesendet.|:number von :alloggiatiweb_guest_total gesendet.',
                    ],
                    'error_internal' => [
                        'body' => ':number von :alloggiatiweb_guest_total nicht gesendet aufgrund der folgenden Fehler:<br/>:errors|:number von :alloggiatiweb_guest_total nicht gesendet aufgrund der folgenden Fehler:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Es war nicht möglich, die Gästeregistrierungen aufgrund der folgenden vom Portal gemeldeten Fehler zu senden:<br/>:errors',
                    ],
                    'fix_error' => 'Die Fehler müssen behoben und die Gästeregistrierungen unter <a href=":link">Dokumente > Gästeregistrierungen</a> erneut gesendet werden.',
                ],
                'push' => [
                    'subject' => 'Gästeregistrierungen - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'success' => [
                        'body' => ':number von :alloggiatiweb_guest_total gesendet.|:number von :alloggiatiweb_guest_total gesendet.',
                    ],
                    'error_internal' => [
                        'body' => ':number von :alloggiatiweb_guest_total wurde nicht gesendet.
        Fehlende Daten ausfüllen oder Fehler korrigieren und den Versand manuell erneut durchführen.|:number von :alloggiatiweb_guest_total wurden nicht gesendet.
        Fehlende Daten ausfüllen oder Fehler korrigieren und den Versand manuell erneut durchführen.',
                    ],
                    'error_external' => [
                        'body' => 'Es war nicht möglich, die Gästeregistrierungen aufgrund der folgenden vom Portal gemeldeten Fehler zu senden:
     :errors
        Fehler korrigieren und den Versand manuell erneut durchführen.',
                    ],
                ],
                'warning' => [
                    'subject' => 'Fehler bei Gästeregistrierungen - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'error_internal' => [
                        'body' => ':number von :alloggiatiweb_guest_total wurde nicht gesendet aufgrund der folgenden Fehler:<br/>:errors|:number von :alloggiatiweb_guest_total wurden nicht gesendet aufgrund der folgenden Fehler:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Es war nicht möglich, die Gästeregistrierungen aufgrund der folgenden vom Portal gemeldeten Fehler zu senden:
        :errors
        Fehler korrigieren und den Versand manuell erneut durchführen.',
                    ],
                    'fix_error' => 'Die Fehler müssen behoben und die Gästeregistrierungen unter <a href=":link">Dokumente > Gästeregistrierungen</a> erneut gesendet werden.',
                ],
            ],
            'istat' => [
                'mail' => [
                    'subject' => 'Bericht ISTAT-Registrierungen - :istat_send_date - :istat_group_label',
                    'summary' => 'Nachfolgend finden Sie den Bericht über die ISTAT-Registrierungen vom :istat_send_date der Versandgruppe :istat_group_label:',
                    'success' => [
                        'body' => ':number von :istat_guest_total gesendet.|:number von :istat_guest_total gesendet.',
                    ],
                    'error_internal' => [
                        'body' => ':number von :istat_guest_total nicht gesendet aufgrund der folgenden Fehler:<br/>:errors|:number von :istat_guest_total nicht gesendet aufgrund der folgenden Fehler:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'Es war nicht möglich, die ISTAT-Registrierungen aufgrund der folgenden Fehler zu senden:<br/>:errors',
                    ],
                    'fix_error' => 'Die Fehler müssen behoben und die ISTAT-Registrierungen unter <a href=":link">Dokumente > Gästeregistrierungen</a> erneut gesendet werden.',
                ],
                'push' => [
                    'subject' => 'ISTAT-Registrierungen :istat_send_date - :istat_group_label',
                    'success' => [
                        'body' => ':number von :istat_guest_total gesendet.|:number von :istat_guest_total gesendet.',
                    ],
                    'error_internal' => [
                        'body' => ':number von :istat_guest_total wurde nicht gesendet.
        Fehlende Daten ausfüllen oder Fehler korrigieren und den Versand manuell erneut durchführen.|:number von :istat_guest_total wurden nicht gesendet.
        Fehlende Daten ausfüllen oder Fehler korrigieren und den Versand manuell erneut durchführen.',
                    ],
                    'error_external' => [
                        'body' => 'Es war nicht möglich, die ISTAT-Registrierungen aufgrund der folgenden Fehler zu senden:
        :errors
        Fehler korrigieren und den Versand manuell erneut durchführen.',
                    ],
                ],
            ],
        ],
        'treatment_price_update' => [
            'subject' => 'Behandlungspreisberechnung (:treatment_name) - :property_name',
            'body' => 'Die Berechnung vom :start_date bis :end_date wurde erfolgreich abgeschlossen.',
        ],
        'reservation_message_received' => [
            'subject' => 'Neue Nachricht von :senderName (#:reference)',
            'title' => ':senderName hat Ihnen eine Nachricht geschickt!',
            'sender_wrote' => 'Der Gast schrieb:',
            'go_to_conversation' => 'Zur Konversation gehen',
        ],
        'external_services' => [
            'UrmetSclak' => [
                'error_generate_key_subject' => 'Fehler bei der Erstellung von Schlüsseln für die Buchung :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'Ein Fehler ist bei Sclak bei der Erstellung der Zimmerschlüssel aufgetreten. <br> :errors <br> Bitte versuchen Sie es manuell erneut. Sollte das Problem bestehen bleiben, kontaktieren Sie den Urmet-Support.',
                'error_seding_sms_subject' => 'Fehler beim Senden der SMS-Schlüssel für die Buchung :booker_name :booker_surname (#ID: :reference_number)',
                'error_seding_sms_body' => 'Die Sclak-SMS konnte aufgrund eines Fehlers nicht gesendet werden. <br> Bitte kontaktieren Sie den Urmet-Support.',
            ],
            'nuki' => [
                'error_generate_key_subject' => 'Fehler bei der Erstellung des PINs für die Buchung :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'Ein Fehler ist bei Nuki bei der Erstellung des PINs für die Zimmer aufgetreten. <br> :errors <br> Bitte versuchen Sie es manuell erneut. Sollte das Problem bestehen bleiben, kontaktieren Sie den Nuki-Support.',
                'unauthorized_opening' => 'Unbefugtes Öffnen'
            ],
            'warning' => [
                'subject' => 'Fehler bei der Erstellung von Schlüsseln für die Buchung :booker_name :booker_surname (#ID: :reference_number)',
                'body' => 'Ein Fehler ist bei Sclak bei der Erstellung der Zimmerschlüssel aufgetreten. <br> :errors <br> Bitte versuchen Sie es manuell erneut. Sollte das Problem bestehen bleiben, kontaktieren Sie den Urmet-Support.',
            ],
            'remote_door_key_service' => [
                'reservation_resumed' => [
                    'title' => 'Änderungen bei Buchungen - Neue Schlüssel erforderlich',
                    'body' => 'Es ist erforderlich, einen neuen Schlüssel für die Buchung von <b>:booker_name :booker_surname - :reference_number</b> in der Unterkunft <b>:property_name</b> zu erstellen. Der vorherige Schlüssel wurde aufgrund des geänderten Buchungsstatus deaktiviert.',
                ],
                'reservation_moved' => [
                    'title' => 'Eine oder mehrere Unterkünfte wurden verschoben. Ein neuer Schlüssel ist erforderlich.',
                    'body' => 'Eine oder mehrere Unterkünfte der Buchung von <b>:booker_name :booker_surname - :reference_number</b> in der Unterkunft <b>:property_name</b> wurden verschoben. Es ist erforderlich, einen neuen Schlüssel zu erstellen.',
                ],
            ],
        ],
        'conversation_message_send_failed' => [
            'subject' => 'Nachricht konnte nicht gesendet werden',
            'title' => 'Die Nachricht an :recipientName wurde nicht zugestellt. Bitte versuchen Sie es erneut.',
            'go_to_conversation' => 'Zur Konversation gehen',
        ],
        'newsletters' => [
            'newsletter_sent_subject' => 'Newsletter-Versandbestätigung',
            'newsletter_sent_content' => 'Die Kampagne ":newsletterName" wurde an :sentContacts Empfänger von insgesamt :totalContacts ausgewählten Kontakten versendet.',
            'newsletter_not_sent_subject' => 'Fehler beim Versenden der Newsletter',
            'newsletter_exceeded_sent_limit_subject' => 'Monatliches Versandlimit überschritten',
            'newsletter_exceeded_sent_limit_content' => 'Die Newsletter :newsletterName konnte nicht gesendet werden, da das monatliche Versandlimit überschritten wurde.',
            'newsletter_not_sent_content' => 'Die Kampagne “:newsletterName” konnte aufgrund folgender Fehler nicht gesendet werden: :errorMessage',
        ],
        'city_taxes_reports' => [
            'send_city_tax_report' => [
                'subject' => 'Bestätigung des Versands des Kurtaxenberichts',
                'content' => 'Der Versand des Kurtaxenberichts für den Kanal :channelName wurde erfolgreich abgeschlossen.',
            ],
            'send_city_tax_report_not_completed' => [
                'subject' => 'Fehler beim Versand des Kurtaxenberichts',
                'content' => 'Der Versand des Kurtaxenberichts für den Kanal :channelName war nicht erfolgreich.',
            ],
            'export_city_tax_report' => [
                'subject' => 'Der Export des Kurtaxenberichts für den Kanal :channelName ist bereit',
                'content' => 'Klicken Sie auf den folgenden Link, um zur Historie der Kurtaxenberichte weitergeleitet zu werden: <a href=":link">Historie der Kurtaxenberichte</a>.',
            ],
            'export_city_tax_report_not_completed' => [
                'subject' => 'Export der Kurtaxenberichte für den Kanal :channelName konnte nicht abgeschlossen werden',
                'content' => 'Die Erstellung des Berichts :reportId war nicht erfolgreich.',
            ],
            'guest_atrtributes_missing' => [
                'subject' => 'Fehler beim Versand/Export der Kurtaxenberichte',
            ],
            'empty_report' => [
                'subject' => 'Der Versand/Export der Kurtaxenberichte für den Kanal :channelName konnte nicht abgeschlossen werden',
                'content' => 'Der Kurtaxenbericht wurde nicht erstellt, da für den ausgewählten Zeitraum keine Gäste gefunden wurden, die dem Kanal gemeldet werden müssen.',
            ],
        ],
        'accommodation_deleted' => [
            'subject' => '[Aktion erforderlich] - Verfügbarkeit muss aktualisiert werden',
        ],
        'max_email_attachments_size_exceeded' => 'Die Größe der angehängten Dateien überschreitet das zulässige Maximum von 8 MB.',
        'check_pci_expiration' => [
            'expiring_certification' => [
                'subject' => 'Beddy - Wichtig: Hinweis zur PCI-Zertifikatsablauf',
                'content' => 'Sehr geehrter Partner :apiPartnerName,<br><br>
                    Das von Ihnen bereitgestellte PCI-Zertifikat läuft in 30 Tagen ab.<br>
                    Bitte senden Sie uns das aktualisierte Zertifikat an <a href="mailto:support@beddy.io">support@beddy.io</a> vor Ablauf der Frist.<br>
                    Nach Ablauf der Frist wird der Zugriff auf Zahlungsdaten gesperrt.<br><br>
                    Das Beddy-Team',
            ],
            'certification_expired' => [
                'subject' => 'PCI-Zertifikat abgelaufen',
                'content' => 'Sehr geehrter Partner :apiPartnerName,<br>
                    Das von Ihnen bereitgestellte PCI-Zertifikat ist abgelaufen.<br>
                    Der Zugriff auf Zahlungsdaten wurde daher gesperrt.<br>
                    Bitte senden Sie uns das aktualisierte Zertifikat an <a href="mailto:support@beddy.io">support@beddy.io</a>, um den Service wiederherzustellen.<br><br>
                    Das Beddy-Team',
            ],
        ],
        'api_partner_disabled' => [
            'subject' => 'Beddy - Wichtig: Hinweis zur Deaktivierung des API-Kontos',
            'body' => 'Sehr geehrter Partner :apiPartnerName,<br>
        Ihr Konto wurde aufgrund zu vieler Anfragen deaktiviert.<br>
        Nach Überprüfung Ihrer Systeme bitten wir Sie, uns unter <a href="mailto:support@beddy.io">support@beddy.io</a> zu kontaktieren, um das Konto wiederherzustellen.<br><br>
        Das Beddy-Team',
        ],
        'api_partner_disabled_test' => [
            'subject' => 'Beddy - Wichtig: Hinweis auf mögliche Deaktivierung des API-Kontos',
            'body' => 'Der Partner :apiPartnerName,<br>
       wäre aufgrund zu vieler Anfragen an den Dienst deaktiviert worden: :errorMessage.<br>',
        ],
        'property_first_login' => [
            'subject' => 'Beddy - Zugriff von einem neuen Gerät',
            'summary' => 'Hallo :user_first_name,<br> ein Zugriff auf Ihr Beddy-Konto von einem neuen Gerät wurde festgestellt.',
            'summary_reset' => 'Wenn Sie dieses Gerät nicht kennen, empfehlen wir Ihnen, <a href=":recoveryPasswordLink" target="_blank">sofort Ihr Passwort zu ändern</a>, um Ihr Konto zu schützen.',
            'device' => 'Gerät',
            'place' => 'Ort',
            'date_hour' => 'Datum und Uhrzeit',
            'unknown' => 'Unbekannt',
            'logout' => 'Die Zugriffsbenachrichtigung ist eine neue Funktion von Beddy. Sie wird auch beim ersten Zugriff auf Geräte gesendet, die in der Vergangenheit verwendet wurden. Überprüfen Sie die verbundenen Geräte im Menü <a href=":logoutAllDevice" target="_blank"> Profil > Sicherheit und Zugriff</a>. Wenn diese übereinstimmen, können Sie diese E-Mail ignorieren.',
        ],
        'channel_update_exclusion' => [
            'subject' => 'Das Portal hat die Beschränkungen für Updates der Unterkunft geändert',
            'summary' => 'Beteiligtes Portal',
            'oldvalue' => 'Alter Wert',
            'newvalue' => 'Neuer Wert',
            'modified_value' => 'Geänderter Wert',
            'deleted_value' => 'Gelöschter Wert',
            'more_info' => 'Diese E-Mail wurde nach der Ausführung des Cron-Jobs zum Herunterladen neuer Zimmer gesendet',
            'they_have_been' => 'wurden',
            'the_following_restrictions' => ' die folgenden Beschränkungen:',
            'edited' => 'bearbeitet',
            'new' => 'hinzugefügt',
            'removed' => 'entfernt',
            'price' => 'Preis',
            'availability' => 'Verfügbarkeit',
            'room_barred' => 'Schließung',
            'min_stay' => 'Mindestaufenthalt',
            'max_stay' => 'Maximalaufenthalt',
            'close_to_arrival' => 'Schließung bei Ankunft',
            'close_to_departure' => 'Schließung bei Abreise',
            'date_from' => 'Startdatum',
            'date_to' => 'Enddatum',
            'type_change' => 'Änderungstyp',
            '1' => 'aktiviert',
            '0' => 'deaktiviert',
            'field_involved' => 'Beteiligtes Feld',
            'rate' => 'Für den Tarif ',
            'property' => 'Unterkunft',
            'subject_short' => 'Änderungen der Beschränkungen für: '
        ],
        'credit_card_view_blocked' => [
            'subject' => 'Beddy – Limit für Kreditkartenansichten überschritten.',
            'body' => 'Sehr geehrter Kunde,<br>wir möchten Sie darüber informieren, dass die mit der Buchung <b>#:reference_number</b> oder einem der zugehörigen Zahlungen verknüpfte Kreditkarte die maximale Anzahl an erlaubten Ansichten erreicht hat. Der Zugriff auf diese Karte wurde daher <b>vorübergehend gesperrt</b>.
    <br><br>Wenn Sie das Ansichts-Limit erhöhen oder weitere Informationen erhalten möchten, wenden Sie sich bitte an unseren Support unter <a href="mailto:support@beddy.io">support@beddy.io</a><br><br>
    Ihr Beddy-Team<br><br>',
        ],
        'credit_card_view_notify' => [
            'subject' => 'Beddy - Benachrichtigung über Zugriff auf Kreditkartendaten - Reservierung Nr.:reservation_reference',
            'body' => 'Sehr geehrter Kunde,<br>Die Kreditkartendaten zur Reservierung Nr.<b>:reservation_reference</b> aus dem Kanal <b>:channel_name</b> wurden eingesehen.
    <br><br>
    Ereignisdetails:
    <ul>
      <li>Operator: <b>:user_first_name :user_last_name</b> (<b>:user_email</b>)</li>
      <li>Datum und Uhrzeit: <b>:event_date</b> <b>:event_hour</b></li>
      <li>IP: <b>:ip_address</b></li>
    </ul>
    Diese Benachrichtigung wird als Sicherheits- und Nachverfolgungsmaßnahme für Zugriffe auf sensible Daten generiert.<br><br>
    Das Beddy-Team<br><br>',
        ],
        'user_created_notify' => [
            'subject' => 'Beddy - Neuer Benutzer für die Unterkunft :property_name erstellt',
            'bodySection1' => 'Sehr geehrter Kunde,<br>ein neuer Benutzer <b>:user_first_name :user_last_name (:user_email)</b> wurde soeben für die Unterkunft <b>:property_name</b> erstellt.
        <br><br>
        Ereignisdetails:
        <ul>
          <li>Operator: <b>:author_first_name :author_last_name</b> (<b>:author_email</b>)</li>
          <li>Datum und Uhrzeit: <b>:event_date</b> <b>:event_hour</b></li>
          <li>IP: <b>:ip_address</b></li>
        </ul>
        Falls Sie diesen Vorgang nicht erkennen, können Sie den neuen Benutzer deaktivieren.',
            'buttonText' => 'Benutzer deaktivieren',
            'bodySection2' => 'Diese Benachrichtigung wird als Sicherheitsmaßnahme und zur Nachverfolgung des Zugriffs auf sensible Daten erstellt.<br><br>
        Ihr Beddy-Team<br><br>'
        ],

    ],

    'export' => [
        'providers' => [
            'customers' => 'Kunden',
            'companies' => 'Unternehmen',
            'reservations' => 'Reservierungen',
            'social_archive' => 'Freischaltbare Kundenangebote',
            'reservation_quotes' => 'Kostenvoranschläge',
            'cash_desk' => 'Kasse',
            'fees' => 'Gebühren',
            'cash_desk_closure' => 'Kassenschluss',
            'production_stats' => 'Produktionsstatistiken',
            'sales_stats' => 'Verkaufsstatistiken',
            'invoices' => 'Steuerdokumente',
            'invoices_received' => 'Empfangene Steuerdokumente',
            'payments_timetable' => 'Zahlungsplan',
            'properties' => 'Strukturen',
            'deposits' => 'Anzahlungen und Kautionen',
            'reservations_guests_presences' => 'Anwesende Gäste'
        ],
        'translations' => [
            'export_format' => 'Exportformat',
        ],
        'errors' => [
            'service_not_active' => 'Der angeforderte Exportdienst ist für die ausgewählten Unterkünfte nicht aktiv.',
            'method_not_found' => 'Die Methode :methodName ist in der Klasse :className nicht implementiert.',
            'export_provider_not_found' => 'Export-Provider nicht gefunden',
        ],
        'warnings' => [
            'service_not_active' => 'Der angeforderte Exportdienst ist für die Unterkunft :propertyName nicht aktiv.',
            'export_inserted' => 'Export erfolgreich eingereicht. Nach Abschluss des Prozesses erhalten Sie eine Benachrichtigung.',
        ],
    ],

    'external_services' => [
        'urmet_sclak' => [
            'one_time' => 'Gültigkeitsdauer des Schlüssels',
            'confirm_required' => 'Der Manager muss jeden Zugang über die Sclak-App autorisieren',
            'app_enabled' => 'App-Nutzung aktivieren (wenn NEIN, wird nur die Nutzung des Nummernfelds aktiviert)',
            'generate_keypad_pin' => 'PIN-Code generieren, der für die Türöffnung mit dem Nummernfeld gesendet wird (nur wählen, wenn die Struktur Nummernfelder zur Verfügung hat)',
            'push_notify_enabled' => 'Erhalten Sie eine Push-Benachrichtigung auf Ihrem Smartphone, wenn Ihr Gast Zugang erhält',
            'security_level' => 'Der Gast muss mit dem Internet verbunden sein',
            'instant_key' => 'Optionale Gästeregistrierung',
            'purchase_type' => 'Wer bezahlt den Schlüssel?',
            'send_sms' => 'Schlüssel automatisch per SMS von Sclak an den Kunden senden',
            'sms_text_main' => "Hallo, hier sind die Anweisungen, um die Zugangsschlüssel zur Unterkunft zu erhalten.\n- INSTALLIEREN SIE DIE Sclak-APP: http://app.sclak.com/download",
            'sms_text_app_code' => "\n - SCHLÜSSEL AKTIVIEREN: https://key.sclak.com/a/:app_key_code",
            'sms_text_pin_code' => "\n - Der PIN-Code für das Nummernfeld lautet: :pin_code",
            'all_booking_duration' => 'Für die gesamte Aufenthaltsdauer',
            'only_one' => 'Nur einmal',
            'property' => 'Die Unterkunft',
            'guest' => 'Der Gast',
            'door_app_code' => 'App-Aktivierungscode',
            'door_link_code' => 'App-Aktivierungslink',
            'app_activation_code' => 'App-Aktivierungscode :accommodation_name (:accommodation_label): :key_code',
            'app_activation_code_log' => ':key_code',
            'door_key_code' => 'Türcode',
            'checkin_hour' => 'Check-in-Zeit (der Schlüssel ist erst ab der gewählten Check-in-Zeit gültig)',
            'checkout_hour' => 'Check-out-Zeit (der Schlüssel ist bis zur gewählten Check-out-Zeit gültig)',
            'room_not_mapped' => 'Zimmer :accommodation_name - :tableau_number ist nicht mit Sclak verbunden',
        ],
        'nuki' => [
            'property' => 'Die Unterkunft',
            'guest' => 'Der Gast',
            'door_key_code' => 'Türcode',
            'checkin_hour' => 'Check-in-Zeit (der Schlüssel ist erst ab der gewählten Check-in-Zeit gültig)',
            'checkout_hour' => 'Check-out-Zeit (der Schlüssel ist bis zur gewählten Check-out-Zeit gültig)',
            'room_not_mapped' => 'Zimmer :accommodation_name - :tableau_number ist nicht mit Nuki verbunden',
            'code' => 'Tür-PIN :accommodation_name (:accommodation_label): :key_code',
            'email_address_not_found' => 'E-Mail-Adresse fehlt. Bitte fügen Sie eine E-Mail-Adresse in die Buchung ein, um die Einladung zur Nutzung von Nuki zu senden.',
            'generate_keypad_pin' => 'PIN-Code generieren, der für die Türöffnung mit dem Nummernfeld gesendet wird (nur wählen, wenn die Struktur Nummernfelder zur Verfügung hat)',
            'sent_with_app' => 'Über die Nuki-App gesendet',
            'authorization_not_found' => 'Sie versuchen, einen nicht vorhandenen Code zu ändern, generieren Sie einen neuen Türcode',
            'multi_port_management' => 'Erlaube die Generierung derselben PIN zum Öffnen mehrerer Türen (z. B. Eingangstor und Zimmer); du kannst später festlegen, welche Türen verknüpft werden',
            'device_not_configured' => 'Kein Nuki-Gerät gefunden oder für das Öffnen per Link konfiguriert'
        ],
        'errors' => [
            'service_not_active' => 'Externer Dienst ist nicht aktiv',
            'scheduler_not_supported' => 'Der externe Dienst :external_service_name unterstützt keine automatische Planung',
        ],
        'warnings' => [
            'manual_code_detected' => 'Es wurden manuell eingegebene Zimmercodes erkannt. Diese können nicht mit Remote-Geräten verknüpft werden, und müssen daher manuell gelöscht werden.',
        ],
        'key_door_services' => [
            'key_door_related' => 'Dieser Code öffnet auch die folgenden Geräte: :devices_name',
        ],
        'gt_revenue' => [
            'spreadsheet_type' => 'Exportkriterium für den Revenue',
            'spreadsheet_type_segments' => 'Segmente',
            'spreadsheet_type_rooms' => 'Zimmer',
            'date_from' => 'Startdatum des Exports',
            'date_to' => 'Enddatum des Exports',
            'period' => 'Exportzeitraum',
        ],
        'pa_friuli' => [
            'year_type' => 'Wählen Sie das Jahr zum Exportieren aus',
            'year_type_previous' => 'Vorjahr (:year)',
            'year_type_current' => 'Aktuelles Jahr (:year)',
        ],
    ],

    'invoice_received' => [
        'document_types' => [
            'TD27' => 'Rechnung für Eigenverbrauch oder kostenlose Lieferungen ohne Rückerstattung',
            'TD26' => 'Übertragung von Anlagegütern und internen Transfers (gemäß Art. 36 D.P.R. Nr. 633/1972)',
            'TD25' => 'Differenzierte Rechnung gemäß Art. 21, Absatz 4, dritter Satz, Buchst. b)',
            'TD24' => 'Differenzierte Rechnung gemäß Art. 21, Absatz 4, Buchst. a)',
            'TD23' => 'Entnahme von Waren aus einem Mehrwertsteuerlager mit Zahlung der Mehrwertsteuer',
            'TD22' => 'Entnahme von Waren aus einem Mehrwertsteuerlager',
            'TD21' => 'Selbstfakturierung wegen Überschreitung des Kontingents',
            'TD20' => 'Selbstfakturierung zur Berichtigung und Ergänzung von Rechnungen (Art. 6, Absatz 8, D.Lgs. Nr. 471/1997 oder Art. 46, Absatz 5, D.L. Nr. 331/1993)',
            'TD19' => 'Integration/Selbstfakturierung für den Kauf von Waren gemäß Art. 17, Absatz 2, D.P.R. Nr. 633/1972',
            'TD18' => 'Integration für den Kauf von innergemeinschaftlichen Waren',
            'TD17' => 'Integration/Selbstfakturierung für den Kauf von Dienstleistungen aus dem Ausland',
            'TD16' => 'Integration für die Rechnung bei innerstaatlichem Reverse-Charge-Verfahren',
            'TD06' => 'Honorarrechnung',
            'TD05' => 'Lastschriftnote',
            'TD04' => 'Gutschriftnote',
            'TD03' => 'Vorauszahlung auf Honorar',
            'TD02' => 'Vorauszahlung auf Rechnung',
            'TD01' => 'Rechnung',
            'RT06' => 'Sonstiger Sozialversicherungsbeitrag',
            'RT05' => 'ENPAM-Beitrag',
            'RT04' => 'ENASARCO-Beitrag',
            'RT03' => 'INPS-Beitrag',
            'RT02' => 'Quellensteuer für juristische Personen',
            'RT01' => 'Quellensteuer für natürliche Personen',
        ],
        'statuses' => [
            'cancelled' => 'Storniert',
            'partially_paid' => 'Teilweise bezahlt',
            'paid' => 'Bezahlt',
            'unpaid' => 'Unbezahlt',
        ],
        'export_fields' => [
            'amount_to_be_paid' => 'Zu zahlender Gesamtbetrag',
            'paid' => 'Bezahlt',
            'status' => 'Status',
            'discount_amount' => 'Rabatt',
            'total_document' => 'Gesamtbetrag',
            'total_taxes' => 'MwSt.',
            'total_taxable' => 'Steuerpflichtig',
            'sender_vat_code' => 'USt-IdNr. Absender',
            'sender_name' => 'Absender',
            'document_name' => 'Dokument',
            'received_date' => 'Eingangsdatum',
            'document_date' => 'Dokumentdatum',
        ],
        'title' => 'Erhaltene Rechnungen',
    ],

    'fees' => [
        'deferred' => 'Aufgeschobene Mehrwertsteuerzahlung',
        'payment_split' => 'Geteilte Zahlung',
        'immediate' => 'Sofortige Mehrwertsteuerzahlung',
        'export_fields' => [
            'date' => 'Datum',
            'document_type' => 'Dokumenttyp',
            'document_number' => 'Dokumentnummer',
            'total_taxable' => 'Gesamte Steuerbasis',
            'total_taxation' => 'Gesamte Mehrwertsteuer',
            'total_documents' => 'Gesamtdokument',
            'customer_name' => 'Kundenname',
            'customer_type' => 'Kundentyp',
            'documents' => 'Dokumente',
            'total_nets' => 'Gesamte Steuerbasis',
            'total_taxes' => 'Gesamte Mehrwertsteuer',
            'documents_total' => 'Gesamtdokumente',
        ],
        'net' => 'Netto',
        'tax' => 'MwSt',
        'sheets_name' => [
            'rows' => 'Belege',
            'summary' => 'Zusammenfassung',
        ],
    ],

    'fiscal_printer' => [
        'not_collected' => 'Nicht eingezogen',
        'electronic' => 'Kreditkarte',
        'not_collected_follows_invoice' => 'Nicht eingezogen, Rechnung folgt',
    ],

    'gdpr' => [
        'privacy' => [
            'title' => '',
            'header' => '<p><strong>PRIVACY POLICY</strong></p>
            <p><strong>on the processing of personal data</strong></p>
            <p>Arts. 12 et seq of Regulation (EU) 2016/679 (GDPR)</p>
            <p>&nbsp;</p>
            <p><strong>FOREWORD </strong></p>
            <p>In compliance with the provisions of EU Regulation 2016/679 (hereinafter referred to as GDPR) we hereby provide information regarding the processing of personal data provided by the data subject, relating to the relationships with the Company. The information is provided pursuant to art. 13 GDPR.</p>
            <p>&nbsp;</p>
            <ol>
            <li><strong>IDENTITY AND CONTACT DETAILS</strong></li>
            </ol>
            <p>The Data Controller :property_name - :property_address (hereinafter the Company).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>
            <p>&nbsp;</p>
            <p>&nbsp;</p>',
            'default_body' => '<p>&nbsp;</p>
            <ol start="2">
            <li><strong>CONTACT DETAILS OF THE DATA PROTECTION OFFICER (DPO)</strong></li>
            </ol>
            <p>The Data Protection Officer is ________________, tel. ______________, e-mail: ______________.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="3">
            <li><strong>PURPOSE OF PROCESSING, LEGAL BASIS AND DATA STORAGE PERIOD</strong></li>
            </ol>
            <table width="680">
            <tbody>
            <tr>
            <td width="191">
            <p><strong><em>Purpose</em></strong></p>
            </td>
            <td width="135">
            <p><strong><em>Types of data that can be processed:</em></strong></p>
            </td>
            <td width="149">
            <p><strong><em>Legal basis</em></strong></p>
            </td>
            <td width="206">
            <p><strong><em>Storage period</em></strong></p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>a)&nbsp;&nbsp; </strong><strong><u>Service Delivery</u></strong></p>
            <p>Registration of the customer and then subsequently fulfilling legal obligations.</p>
            </td>
            <td width="135">
            <p>First Name, Last Name, Phone Number, Additional Requests, Address, ZIP Code, Province, Country, State and E-mail, Payment Information</p>
            </td>
            <td width="149">
            <p>Performance of a contract to which you are a party or pre-contractual measures taken at the request of the data subject;</p>
            <p>Fulfilment of legal obligations.</p>
            <p><em>&nbsp;</em></p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>The retention time is changeable as it is dictated by the difference between the time the reservation is made and the time the guest actually arrives at the facility.</p>
            <p>Encrypted payment information is retained up to 15days after the departure of the client\'s guest.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>b)&nbsp;&nbsp; </strong><strong><u>Request for quotation</u></strong></p>
            <p>Request for quotation with subsequent contact from the Data Controller</p>
            </td>
            <td width="135">
            <p>First name, last name, email and phone number</p>
            </td>
            <td width="149">
            <p>Pre-contractual measures taken at the request of the data subject</p>
            <p>&nbsp;</p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time it takes to process the request</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>c)&nbsp;&nbsp; </strong><strong><u>Newsletter</u></strong></p>
            <p>Sending newsletters, by automated means of contacting</p>
            </td>
            <td width="135">
            <p>Personal and contact data</p>
            </td>
            <td width="149">
            <p>Consent (required by contract or specific request);</p>
            <p>(optional and revocable at any time)</p>
            <p><em>Art. 6 co. 1 lett. a) GDPR.</em></p>
            </td>
            <td width="206">
            <p>Until consent for that purpose is withdrawn and/or five years have elapsed since the \'expression of consent.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>d)&nbsp; </strong>If necessary, to <strong>ascertain, exercise or defend the rights</strong> of the Joint Data Controllers in judicial proceedings</p>
            </td>
            <td width="135">
            <p>Personal data and contact details; data necessary for the execution of the contractual relationship.</p>
            </td>
            <td width="149">
            <p>Legitimate interest (judicial protection).</p>
            <p><em>Art. 6, paragraph 1 letter f) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time necessary to exercise rights in court.</p>
            </td>
            </tr>
            </tbody>
            </table>
            <p><strong>&nbsp;</strong></p>
            <ol start="4">
            <li><strong>OBLIGATORY NATURE OF PROVISION OF DATA</strong></li>
            </ol>
            <p>The data subject must provide necessary data for carrying out the contractual relationship to the Company, as well as the data necessary to fulfil the obligations provided for by laws, regulations, community standards, and by provisions of Authorities legitimated by law and by supervisory and control bodies (referred to in purposes a) and f) above).</p>
            <p>Data that are not essential for the performance of the contractual relationship are qualified and considered supplementary and their provision by the data subject, if requested, is optional and subject to consent. Consent provided may be withdrawn by the data subject at any time. Such withdrawal shall in no way affect the lawfulness of processing based on the consents given prior to withdrawal of consent.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong>PROCESSING METHODS</strong></li>
            </ol>
            <p>Personal data will be recorded, processed and stored in the Company&rsquo; archive, paper and electronic, in compliance with the appropriate technical and organizational measures referred to in Art. 32 of the GDPR. The processing of the data subject personal data may consist of any operation or set of operations described in Art. 4, paragraph 1, point 2 of the GDPR.</p>
            <p>Personal data will be processed using suitable tools and procedures that guarantee security and confidentiality. Such processing may be carried out directly and/or via delegated third parties, both manually using hard-copy support and electronically using IT equipment and other instruments. In order to manage properly the relationship and fulfilment of legal obligations, personal data may be entered in the internal documentation of the Company and, if necessary, in the documents and registers required by law.</p>
            <p>Your data may be processed by the employees of the departments of the Company assigned to the pursuit of the above-mentioned purposes. These employees have been expressly authorized to process the data and have received adequate operating instructions pursuant to and for the purposes of Art. 29 GDPR.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="6">
            <li><strong>CATEGORIES OF RECIPIENTS OF PERSONAL DATA</strong></li>
            </ol>
            <p>Personal data under purpose (a) are only disclosed to possible legal offices where required by law.</p>
            <p>Payment data is transmitted to payment service providers for completion of the transaction.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="7">
            <li><strong>DATA TRANSFER TO COUNTRIES OUTSIDE THE EU</strong></li>
            </ol>
            <p>The data provided by the data subject will only be processed countries within the European Union. If the personal data of the data subjects are processed in a country outside of the EU, the data subject&rsquo;s rights under EU legislation will be guaranteed and the data subject will be notified on a timely basis.</p>
            <p>&nbsp;</p>
            <ol start="8">
            <li><strong>RIGHTS OF THE DATA SUBJECT </strong></li>
            </ol>
            <p>Pursuant to Articles 15 et seq of the GDPR, the data subject may exercise the following rights:</p>
            <ol>
            <li>access: to obtain confirmation of whether or not the personal data of the data subject are being processed and the right to access them; requests that are manifestly unfounded, excessive or repetitive cannot be answered;</li>
            <li>rectification: to correct/obtain the correction of personal data if incorrect or outdated and to complete data if incomplete;</li>
            <li>erasure/to be forgotten in some cases, to obtain the erasure of the personal data provided; this is not an absolute right, as the Company may have legitimate or legal reasons to store them;</li>
            <li>limitation: the data will be stored, but cannot be processed further, in the cases foreseen by the regulation;</li>
            <li>portability: to move, copy or transfer data from the Company&rsquo; databases to third parties. This applies only to data provided by the data subject for the performance of a contract or for which express consent has been given and the processing is carried out by automated means;</li>
            <li>objection to direct marketing;</li>
            <li>withdraw of the consent at any time if processing is based on consent.</li>
            </ol>
            <p>Pursuant to Art. 2-<em>undicies</em> of Legislative Decree 196/2003, the exercise of data subjects rights may be delayed, restricted or excluded, following justification provided without delay, unless this might compromise the purpose of the restriction, for as long as and to the extent that this constitutes a necessary and proportionate measure, taking into account the fundamental rights and legitimate interests of the data subject, in order to safeguard the interests referred to in paragraph 1, letters a) (protected interests with regard to money laundering), e) (for the conduct of defensive investigations or the exercise of a right in court) and f) (for the confidentiality of the identity of the employee who reports offenses he becomes aware of on his duties). In such cases, data subjects&rsquo; rights may also be exercised through the Personal Data Protection Authority in the manner referred to in Article 160 of said Decree. In such case, the Personal Data Protection Authority will inform the data subject that it has carried out all the necessary checks or that it has carried out a review, as well as of the data subject right to take legal action.</p>
            <p>&nbsp;</p>
            <p>It should also be noted that - before processing the requests - the Company may ascertain the identity of the data subject, in order to evaluate the legitimacy of the same.</p>
            <p>&nbsp;</p>
            <p>To exercise these rights, the data subject may contact the Data Controller at the addresses indicated in section 1 of this document. The Company will respond within 30 days of receiving the data subject formal request.</p>
            <p>If the abovementioned rights concerning data subject personal data are infringed, the latest may complain to the competent authority.</p>
            <p>&nbsp;</p>
            <p><strong>&nbsp;</strong></p>
            <p><strong>THE DATA</strong></p>
            <p><strong>CONTROLLER</strong></p>',
        ],
        'cookie' => [
            'title' => '',
            'header' => '<p><strong>Cookie Policy of :property_name</strong></p>
            <ol>
            <li><strong>Data Controller</strong></li>
            </ol>
            <p>The Data Controller is :property_name - :property_address (hereinafter the Company or the Owner).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>',
            'default_body' => '<p>Since the use of third-party Trackers through this Website cannot be fully controlled by the Owner, any specific references to third-party Trackers are to be considered indicative. In order to obtain complete information, Users are kindly requested to consult the privacy policies of the respective third-party services listed in this document.</p>
            <p>Given the objective complexity surrounding tracking technologies, Users are encouraged to contact the Owner should they wish to receive any further information on the use of such technologies by this Website.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="2">
            <li><strong>Foreword </strong></li>
            </ol>
            <p>This document informs Users about the technologies that help this Website to achieve the purposes described below. Such technologies allow the Owner to access and store information (for example by using a Cookie) or use resources (for example by running a script) on a User&rsquo;s device as they interact with this Website.</p>
            <p>For simplicity, all such technologies are defined as "Trackers" within this document &ndash; unless there is a reason to differentiate.</p>
            <p>For example, while Cookies can be used on both web and mobile browsers, it would be inaccurate to talk about Cookies in the context of mobile apps as they are a browser-based Tracker. For this reason, within this document, the term Cookies is only used where it is specifically meant to indicate that particular type of Tracker.</p>
            <p>Some of the purposes for which Trackers are used may also require the User\'s consent. Whenever consent is given, it can be freely withdrawn at any time following the instructions provided in this document.</p>
            <p>This Website uses Trackers managed directly by the Owner (so-called &ldquo;first-party&rdquo; Trackers) and Trackers that enable services provided by a third-party (so-called &ldquo;third-party&rdquo; Trackers). Unless otherwise specified within this document, third-party providers may access the Trackers managed by them.</p>
            <p>The validity and expiration periods of Cookies and other similar Trackers may vary depending on the lifetime set by the Owner or the relevant provider. Some of them expire upon termination of the User&rsquo;s browsing session.</p>
            <p>In addition to what&rsquo;s specified in the descriptions within each of the categories below, Users may find more precise and updated information regarding lifetime specification as well as any other relevant information &ndash; such as the presence of other Trackers - in the linked privacy policies of the respective third-party providers or by contacting the Owner.</p>
            <p>&nbsp;</p>
            <ol start="3">
            <li><strong> Activities strictly necessary for the operation of this Website and delivery of the Service</strong></li>
            </ol>
            <p>This Website uses so-called &ldquo;technical&rdquo; Cookies and other similar Trackers to carry out activities that are strictly necessary for the operation or delivery of the Service.</p>
            <p><strong>3.1 Third-party Trackers</strong></p>
            <p><strong>3.1.1 Tag Management</strong></p>
            <p>This type of service helps the Owner to manage the tags or scripts needed on this Website in a centralized fashion.</p>
            <p>This results in the Users\' Data flowing through these services, potentially resulting in the retention of this Data.</p>
            <p><strong>3.1.1.1 Google Tag Manager (Google Ireland Limited)</strong></p>
            <p>Google Tag Manager is a tag management service provided by Google Ireland Limited.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Irlanda &ndash; <a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p><strong>3.1.2 Handling payments</strong></p>
            <p>Se non diversamente specificato, questo Sito Web elabora i pagamenti con carta di credito tramite fornitori esterni di servizi di pagamento. In generale, e salvo diversa indicazione, gli Utenti sono pregati di fornire i dettagli di pagamento e le informazioni personali direttamente a tali fornitori di servizi di pagamento.</p>
            <p>Questo Sito Web non &egrave; coinvolto nella raccolta e nell\'elaborazione di tali informazioni: ricever&agrave; invece solo una notifica da parte del fornitore di servizi di pagamento in questione circa l\'avvenuto pagamento.</p>
            <p>Unless otherwise specified, this Website processes payments by credit card via external payment service providers. In general and unless where otherwise stated, Users are requested to provide their payment details and personal information directly to such payment service providers.</p>
            <p>This Website isn\'t involved in the collection and processing of such information: instead, it will only receive a notification by the relevant payment service provider as to whether payment has been successfully completed.</p>
            <p><strong>3.1.2.1 Stripe (Stripe Technology Europe Ltd)</strong></p>
            <p>Stripe is a payment service provided by Stripe Technology Europe, Limited.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://stripe.com/ie/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__stripe_mid: 1 year</li>
            <li>__stripe_sid: 30 minutes</li>
            <li>m: 2 years</li>
            </ul>
            <p><strong>3.1.2.2 PayPal (Paypal)</strong></p>
            <p>PayPal is a payment service provided by PayPal Inc., which allows Users to make online payments.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: See the PayPal privacy policy &ndash;&nbsp;<a href="https://www.paypal.com/webapps/mpp/ua/privacy-full">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__paypal_storage__: indefinite</li>
            <li>akavpau_ppsd: duration of the session</li>
            <li>enforce_policy: duration of the session</li>
            <li>l7_az: duration of the session</li>
            <li>nsid: duration of the session</li>
            <li>ts: duration of the session</li>
            <li>tsrce: duration of the session</li>
            <li>x-cdn: duration of the session</li>
            <li>x-pp-s: duration of the session</li>
            </ul>
            <p>&nbsp;</p>
            <ol start="4">
            <li><strong> Other activities involving the use of Trackers</strong></li>
            </ol>
            <p><strong>4.1 Measurement</strong></p>
            <p>This Website uses Trackers to measure traffic and analyze User behavior with the goal of improving the Service.</p>
            <p><strong>4.1.1 Analytics</strong></p>
            <p>The services contained in this section enable the Owner to monitor and analyze web traffic and can be used to keep track of User behavior.</p>
            <p><strong>4.1.1.1 Google Analytics 4 (Google Ireland Limited)</strong></p>
            <p>Google Analytics 4 is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.<br /> In Google Analytics 4, IP addresses are used at collection time and then discarded before Data is logged in any data center or server. Users can learn more by consulting&nbsp;<a href="https://support.google.com/analytics/answer/12017362?hl=en&amp;ref_topic=2919631">Google&rsquo;s official documentation</a>.</p>
            <p>Personal Data processed: browser information, city, device information, latitude (of city), longitude (of city), number of Users, session statistics, Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_ga: 2 years</li>
            <li>_ga_*: 2 years</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.2 Google Analytics (Google Ireland Limited)</strong></p>
            <p>Google Analytics is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>AMP_TOKEN: 1 hour</li>
            <li>_ga: 2 years</li>
            <li>_gac*: 3 months</li>
            <li>_gat: 1 minute</li>
            <li>_gid: 1 day</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Facebook Ads conversion tracking (Facebook pixel) (Meta Platforms Ireland Limited)</strong></p>
            <p>Facebook Ads conversion tracking (Meta pixel) is an analytics service provided by Meta Platforms Ireland Limited that connects data from the Meta Audience Network with actions performed on this Website. The Meta pixel tracks conversions that can be attributed to ads on Facebook, Instagram and Meta Audience Network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://www.facebook.com/about/privacy/">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_fbp: 3 months</li>
            <li>fr: 3 months</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Google Ads conversion tracking (Google Ireland Limited)</strong></p>
            <p>Google Ads conversion tracking is an analytics service provided by Google Ireland Limited that connects data from the Google Ads advertising network with actions performed on this Website.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>IDE: 2 years</li>
            <li>test_cookie: 15 minutes</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.2 Marketing</strong></p>
            <p><strong>4.1.2.1. Userguest</strong></p>
            <p>This service allows the user to be shown personalized ads on this website, based on previous visits to this website.</p>
            <p>It does not collect personal data.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong> How to manage preferences and provide or withdraw consent</strong></li>
            </ol>
            <p>There are various ways to manage Tracker related preferences and to provide and withdraw consent, where relevant:</p>
            <p>Users can manage preferences related to Trackers from directly within their own device settings, for example, by preventing the use or storage of Trackers.</p>
            <p>Additionally, whenever the use of Trackers is based on consent, Users can provide or withdraw such consent by setting their preferences within the cookie notice or by updating such preferences accordingly via the relevant consent-preferences widget, if available.</p>
            <p>It is also possible, via relevant browser or device features, to delete previously stored Trackers, including those used to remember the User&rsquo;s initial consent.</p>
            <p>Other Trackers in the browser&rsquo;s local memory may be cleared by deleting the browsing history.</p>
            <p>With regard to any third-party Trackers, Users can manage their preferences and withdraw their consent via the related opt-out link (where provided), by using the means indicated in the third party\'s privacy policy, or by contacting the third party.</p>
            <p><strong>5.1 Locating Tracker Settings</strong></p>
            <p>Users can, for example, find information about how to manage Cookies in the most commonly used browsers at the following addresses:</p>
            <ul>
            <li><a href="https://support.google.com/chrome/answer/95647?hl=en&amp;p=cpn_cookies">Google Chrome</a></li>
            <li><a href="https://support.mozilla.org/en-US/kb/enable-and-disable-cookies-website-preferences">Mozilla Firefox</a></li>
            <li><a href="https://support.apple.com/guide/safari/manage-cookies-and-website-data-sfri11471/">Apple Safari</a></li>
            <li><a href="http://windows.microsoft.com/en-us/windows-vista/block-or-allow-cookies">Microsoft Internet Explorer</a></li>
            <li><a href="https://support.microsoft.com/en-us/help/4027947">Microsoft Edge</a></li>
            <li><a href="https://support.brave.com/hc/en-us/articles/360022806212-How-do-I-use-Shields-while-browsing">Brave</a></li>
            <li><a href="https://help.opera.com/en/latest/web-preferences/#cookies">Opera</a></li>
            </ul>
            <p>Users may also manage certain categories of Trackers used on mobile apps by opting out through relevant device settings such as the device advertising settings for mobile devices, or tracking settings in general (Users may open the device settings and look for the relevant setting).</p>
            <p><strong>5.2 </strong><strong>Consequences of denying consent</strong></p>
            <p>Users are free to decide whether or not to grant consent. However, please note that Trackers help this Website to provide a better experience and advanced functionalities to Users (in line with the purposes outlined in this document). Therefore, in the absence of the User\'s consent, the Owner may be unable to provide related features.</p>
            <ol start="6">
            <li><strong> Definitions and legal references</strong></li>
            </ol>
            <p><strong>Personal Data (or Data)</strong></p>
            <p>Any information that directly, indirectly, or in connection with other information &mdash; including a personal identification number &mdash; allows for the identification or identifiability of a natural person.</p>
            <p><strong>Usage Data</strong></p>
            <p>Information collected automatically through this Website (or third-party services employed in this Website), which can include: the IP addresses or domain names of the computers utilized by the Users who use this Website, the URI addresses (Uniform Resource Identifier), the time of the request, the method utilized to submit the request to the server, the size of the file received in response, the numerical code indicating the status of the server\'s answer (successful outcome, error, etc.), the country of origin, the features of the browser and the operating system utilized by the User, the various time details per visit (e.g., the time spent on each page within the Application) and the details about the path followed within the Application with special reference to the sequence of pages visited, and other parameters about the device operating system and/or the User\'s IT environment.</p>
            <p><strong>User</strong></p>
            <p>The individual using this Website who, unless otherwise specified, coincides with the Data Subject.</p>
            <p><strong>Data Subject</strong></p>
            <p>The natural person to whom the Personal Data refers.</p>
            <p><strong>Data Processor (or Data Supervisor)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which processes Personal Data on behalf of the Controller, as described in this privacy policy.</p>
            <p><strong>Data Controller (or Owner)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which, alone or jointly with others, determines the purposes and means of the processing of Personal Data, including the security measures concerning the operation and use of this Website. The Data Controller, unless otherwise specified, is the Owner of this Website.</p>
            <p><strong>This Website (or this Application)</strong></p>
            <p>The means by which the Personal Data of the User is collected and processed.</p>
            <p><strong>Service</strong></p>
            <p>The service provided by this Website as described in the relative terms (if available) and on this site/application.</p>
            <p><strong>European Union (or EU)</strong></p>
            <p>Unless otherwise specified, all references made within this document to the European Union include all current member states to the European Union and the European Economic Area.</p>
            <p><strong>Cookie</strong></p>
            <p>Cookies are Trackers consisting of small sets of data stored in the User\'s browser.</p>
            <p><strong>Tracker</strong></p>
            <p>Tracker indicates any technology - e.g Cookies, unique identifiers, web beacons, embedded scripts, e-tags and fingerprinting - that enables the tracking of Users, for example by accessing or storing information on the User&rsquo;s device.</p>
            <p><strong>Legal information</strong></p>
            <p>This privacy statement has been prepared based on provisions of multiple legislations, including Art. 13/14 of Regulation (EU) 2016/679 (General Data Protection Regulation).</p>
            <p>This policy relates solely to this Website, if not stated otherwise within this document.</p>
            <p>&nbsp;</p>',
        ],
    ],

    'general' => [
        'accommodation_not_found' => 'Zimmer nicht gefunden',
        'channel_unsupported_function' => 'Dieser Kanal unterstützt diese Funktion nicht',
        'rateplan_not_found' => 'Tarifplan nicht gefunden',
        'accommodations' => 'Zimmer',
        'unknown' => 'Unbekannt',
        'unauthorized' => 'Nicht autorisiert',
        'expired_password' => 'Ihr Passwort ist abgelaufen. Bitte aktualisieren Sie es, um fortzufahren.',
        'not_found' => 'Nicht gefunden',
        'not_found_or_not_authorized' => 'Ressource nicht gefunden oder Autorisierung verweigert',
        'no_relationship_found' => 'Keine Beziehung gefunden',
        'existing_periods' => 'Überlappende Werte vorhanden',
        'existing_condition' => 'Bedingung bereits vorhanden',
        'missing_accommodation_rateplan' => 'Tarifplan mit Zimmer verknüpft fehlt',
        'missing_accommodation_channel_source' => 'Quellkanal-Zimmer fehlt',
        'missing_accommodation_channel_destination' => 'Zielkanal-Zimmer fehlt',
        'missing_accommodation_channel' => 'Kanalzimmer fehlt',
        'missing_treatment_or_rateplan' => 'Behandlung oder Tarifplan für dieses Zimmer fehlt',
        'same_source_destination' => 'Quelle und Ziel sind identisch',
        'impossible_delete_addon_category' => 'Zusatzkategorie kann nicht gelöscht werden, wenn noch verknüpft',
        'impossible_delete_system_addon_category' => 'System-Zusatzkategorie kann nicht geändert oder gelöscht werden',
        'property_xml_already_connected' => 'Property XML bereits mit einer anderen Unterkunft verbunden',
        'city_tax' => 'Kurtaxe',
        'taxs' => 'Steuern',
        'virtual_stamp' => 'Virtueller Stempel',
        'default_group' => 'Standardgruppe',
        'existing_mail' => 'Vorhandene E-Mail',
        'unique_mail' => 'Einzigartige E-Mail',
        'existing_username' => 'Vorhandener Benutzername',
        'unique_username' => 'Einzigartiger Benutzername',
        'resource_conflict' => 'Konflikt in der ausgewählten Ressource',
        'special_requests' => 'Sonderwünsche',
        'name' => 'Name',
        'surname' => 'Nachname',
        'and' => 'und',
        'arrival' => 'Ankunft',
        'clean_fees' => 'Reinigungsgebühren',
        'departure' => 'Abreise',
        'adults' => 'Erwachsene',
        'adult' => 'Erwachsener',
        'children' => 'Kinder',
        'child' => 'Kind',
        'eta' => 'Alter',
        'male' => 'Männlich',
        'female' => 'Weiblich',
        'customer' => 'Kunde',
        'company' => 'Firma',
        'telephone' => 'Telefon',
        'email' => 'E-Mail',
        'nationality' => 'Nationalität',
        'too_many_login_attemps' => 'Zu viele fehlgeschlagene Versuche. Sie können es in :minute_unthrottle Minuten erneut versuchen',
        'country' => 'Land',
        'coupon' => 'Gutschein',
        'from' => 'Von',
        'to' => 'Bis',
        'nights' => 'Nächte',
        'payment_status' => 'Zahlungsstatus',
        'total' => 'Gesamt',
        'reservation' => 'Reservierung',
        'quote' => 'Angebot',
        'di' => 'von',
        'stay' => 'Aufenthalt',
        'extra' => 'Extra',
        'tax' => 'Steuer',
        'payment' => 'Zahlungen',
        'del' => 'von',
        'channel' => 'Kanal',
        'lodging' => 'Unterkunft',
        'treatment' => 'Behandlung',
        'accommodations_reserved' => 'Reservierte Unterkünfte',
        'option_status_export' => 'Status-Export',
        'option_revenue' => 'Umsatzdaten',
        'option_time' => 'Exportzeiten',
        'guest_card_service_not_connected' => 'Dienst nicht mit Unterkunft verbunden oder falscher Typ',
        'guest_card_guests_number_error' => 'Unzureichende Anzahl an Gästen',
        'guest_card_date_from_error' => 'Änderungen nicht zulässig. Das Anfangsdatum liegt in der Vergangenheit.',
        'imp' => 'Netto',
        'iva' => 'MwSt',
        'type' => 'Typ',
        'documents' => 'Dokumente',
        'generic_payment' => 'Allgemeine Zahlung',
        'accommodation' => 'Zimmer',
        'accommodation_name' => 'Unterkunft',
        'accommodation_total' => 'Gesamte Unterkunft',
        'error' => 'Fehler',
        'status' => 'Status',
        'language' => 'Sprache',
        'guests' => 'Gäste',
        'guest' => 'Gast',
        'paid' => 'Bezahlt',
        'to_pay' => 'Zu zahlen',
        'suspended' => 'Ausgesetzt',
        'to_be_invoiced' => 'Zu fakturieren',
        'note' => 'Notizen',
        'note_internal' => 'Interne Reservierungsnotizen',
        'note_internal_accommodation' => 'Interne Unterkunftsnotizen',
        'note_customer' => 'Kundenanfragen',
        'note_checkin' => 'Check-in Notizen',
        'note_checkout' => 'Check-out Notizen',
        'note_housekeeper' => 'Notizen für die Reinigungskraft',
        'note_catering' => 'Essensnotizen',
        'note_bill' => 'Abrechnungsnotizen',
        'bill_charged' => 'In Rechnung gestellte Belastung',
        'total_documents' => 'Gesamtdokumente',
        'checkin_online' => 'Online-Check-in',
        'cancellation' => 'Stornierung',
        'no_show' => 'Nicht erscheinen',
        'referral_id' => '#:referral_id:',
        'missing_param' => 'Fehlender Parameter :param',
        'properties' => 'Unterkünfte',
        'amount' => 'Betrag',
        'reservation_total' => 'Gesamtreservierung',
        'total_paid' => 'Gesamtbetrag bezahlt',
        'total_to_pay' => 'Gesamtbetrag zu zahlen',
        'general_error' => 'Allgemeiner Fehler',
        'module_not_active' => 'Das Modul :moduleName ist für die folgenden Unterkünfte nicht aktiv: ',
        'reservation_summary' => 'Reservierungsübersicht',
        'department_not_faund' => 'Abteilung nicht gefunden',
        'department_exist' => 'Eine Abteilung, die mit dem Steuerdrucker verknüpft ist, kann nicht gelöscht werden',
        'upload_virus_found' => 'Die hochgeladene Datei ist beschädigt oder schädlich',
        'upload_antivirus_service' => 'Datei-Upload fehlgeschlagen, bitte versuchen Sie es später erneut oder kontaktieren Sie den Support',
        'document' => '{1} Dokument|[2,*] Dokumente',
        'reservation_to_queue_from_cart' => 'Wir bearbeiten die Reservierung, eine Benachrichtigung informiert Sie nach Abschluss.',
        'active' => 'Aktiv',
        'expired' => 'Abgelaufen',
        'export' => 'Export',
        'send_data' => 'Daten senden',
        'missing_credentials' => 'Fehlender Benutzername oder Passwort',
        'yes' => 'Ja',
        'no' => 'Nein',
        'door_key_codes' => 'Türcode',
        'external_door_link' => 'Link zum Öffnen der Außentür',
        'accommodation_door_key_codes' => 'Zugangscode der Unterkunft :accommodationTableauLabel',
        'city_tax_report' => [
            'errors' => [
                'filter_not_available' => 'Filter nicht verfügbar',
                'filter_format' => 'Filterformat nicht akzeptiert',
                'filter_number_arguments_exceeded' => 'Anzahl der Filterargumente überschritten',
            ],
        ],
        'fields' => [
            'field_update' => 'das Feld :field von :oldValue zu :newValue',
            'guest_type_id' => 'Gasttyp',
            'city_tax_exemption_id' => 'Befreiung von der Kurtaxe',
            'main_guest' => 'Hauptgast',
            'arrival_date' => 'Ankunftsdatum',
            'departure_date' => 'Abreisedatum',
            'roomreservation_id' => 'Zimmer',
            'checkin' => 'Check-in',
            'checkout' => 'Check-out',
            'enabled' => 'Aktiviert',
            'disabled' => 'Deaktiviert',
            'undefined' => 'Nicht definiert',
            'deleting' => 'Gelöscht:',
            'update_guest' => 'Für Gast :name :surname (:id) wurden folgende Felder aktualisiert: :fields',
            'delete_guest' => 'Gast :name :surname (:id) :invoiced_city_tax',
            'invoiced_city_tax' => 'mit in Rechnung gestellter Kurtaxe',
            'arrival_lunch' => 'Ankunft zum Mittagessen',
            'arrival_dinner' => 'Ankunft zum Abendessen',
            'arrival_not_set' => 'Keine Präferenz',
        ],
        'conversation_messages' => [
            'placeholder_photo' => 'Foto',
            'participant_alredy_exists' => 'Teilnehmer ist bereits mit der Konversation verknüpft',
        ],
        'exceptions' => [
            'impossible_invoke_method' => 'Diese Methode kann nicht aufgerufen werden',
            'batch_job_not_found' => 'Job nicht gefunden',
            'temporary_disabled_action_move_guest' => 'Die folgende Aktion ist derzeit deaktiviert: Bitte entfernen Sie den Gast und erstellen Sie ihn im vorgesehenen Zimmer neu',
            'method_not_implemented' => 'Die Methode :methodName des Treibers :driverName ist nicht implementiert',
            'export_not_valid' => 'Die folgenden Parameter für den Export sind ungültig: ',
            'gt_revenue_not_valid' => 'Die folgenden Parameter für den GT Revenue-Export sind ungültig: ',
            'impossible_to_set_message_read_status' => 'Es ist nicht möglich, den Lesestatus der Nachricht zu ändern',
            'you_cannot_receive_message_without_reservation_type' => 'Sie können keine Nachrichten ohne Reservierungstyp empfangen',
            'you_cannot_send_message_that_contains_phone_number' => 'Sie können keine Nachricht senden, die Telefonnummern enthält',
            'you_cannot_send_message_that_contains_url' => 'Sie können keine Nachricht senden, die URLs enthält',
            'you_cannot_send_message_that_contains_email_addresses' => 'Sie können keine Nachricht senden, die E-Mail-Adressen enthält',
            'uploaded_too_many_images' => 'Sie können nur ein Bild pro Nachricht senden',
            'attachments_not_permitted_for_channel' => 'Für diesen Kommunikationskanal sind Anhänge nicht erlaubt',
            'some_uploaded_files_are_unsupported' => 'Einige hochgeladene Dateien werden nicht unterstützt',
            'message_alredy_exists' => 'Nachricht ist bereits vorhanden',
            'newsletter_condition_not_valid' => 'Die folgenden Felder der Versandlistenbedingung sind ungültig: ',
            'newsletter_default_mail_not_valid' => 'Die folgenden Felder der Standard-E-Mail sind ungültig: ',
            'newsletter_not_valid' => 'Die folgenden Felder des Newsletters sind ungültig: ',
            'newsletter_config_not_valid' => 'Die folgenden Konfigurationsfelder sind ungültig: ',
            'message_not_valid' => 'Die folgenden Felder sind ungültig: ',
            'impossible_to_delete_this_message' => 'Diese Nachricht kann nicht gelöscht werden',
            'impossible_to_resend_not_failed_message' => 'Es ist nicht möglich, eine nicht fehlgeschlagene Nachricht erneut zu senden',
            'recipient_has_not_configured_email_address' => 'Der Empfänger hat keine E-Mail-Adresse konfiguriert',
            'ota_channel_message_not_supported' => 'Der angegebene Kanal unterstützt die Nachrichtenversandfunktion nicht',
            'impossible_to_get_conversation_references' => 'Es ist nicht möglich, die Konversationsinformationen abzurufen',
        ],
    ],

    'guest_presence' => [
        'summary' => 'Gästepräsenz Zusammenfassung',
        'daily_summary_of_date' => 'Tägliche Zusammenfassung für :date',
        'accommodation' => 'Unterkunft',
        'accommodation_type' => 'Unterkunftstyp',
        'name_and_surname' => 'Name und Nachname',
        'age' => 'Alter',
        'sex' => 'Geschlecht',
        'stay' => 'Aufenthalt',
        'stay_status' => 'Status',
        'plan' => 'Stockwerk',
        'property' => 'Eigentum',
        'no_records' => 'Keine Daten zum Anzeigen',
        'date' => 'Datum',
        'export_title' => 'Gästepräsenz',
    ],

    'guest_reporting' => [
        'errors' => [
            'unable_to_delete_movements' => 'Die Bewegungen konnten aufgrund des folgenden Fehlers nicht gelöscht werden: :error',
            'unable_to_send_movements' => 'Die Bewegungen konnten aufgrund des folgenden Fehlers nicht gesendet werden: :error',
            'unable_to_check_movements_type' => 'Der Bewegungstyp konnte aufgrund des folgenden Fehlers nicht überprüft werden: :error',
            'movements_type_not_valid' => 'Der Bewegungstyp der Unterkunft ist für dieses Portal ungültig',
            'cannot_delete_movements' => 'Bewegungen können nicht gelöscht werden, da das Übermittlungsdatum nicht mit dem zuletzt vom Portal registrierten Übermittlungsdatum übereinstimmt',
            'generic_already_reported' => 'Element bereits exportiert',
            'reservation_already_reported' => 'Reservierung :identifier bereits exportiert',
            'reservation_accommodation_already_reported' => 'Unterkunft :identifier bereits exportiert',
            'reservation_accommodation_guest_already_reported' => 'Gast :identifier bereits exportiert',
            'reservation_accommodation_guest_not_sent' => 'Gast nicht gesendet',
            'reservation_accommodation_guest_can_not_delete' => 'Gast kann nicht gelöscht werden, da er bereits Teil eines monatlichen Abschlusses ist',
            'reservation_accommodation_guest_missing' => 'Gast nicht gefunden',
            'place_code_missing' => 'Ortscode fehlt. Bitte wenden Sie sich an den technischen Support.',
            'cannot_be_single_guest' => 'Ungültiger Gasttyp: Kann kein Einzelgast sein.',
            'customer_has_incomplete_birth_place' => 'Unvollständiger oder fehlender Geburtsort.',
            'customer_has_incomplete_document_data' => 'Unvollständige oder fehlende Dokumentdaten.',
            'customer_has_incomplete_residence' => 'Fehlender Geburts- oder Wohnortcode. Bitte Support kontaktieren.',
            'customer_has_invalid_gender' => 'Geschlecht nicht angegeben.',
            'customer_has_invalid_type' => 'Ungültiger Gasttyp.',
            'customer_has_no_birth_date' => 'Fehlendes Geburtsdatum.',
            'customer_birth_date_in_future' => 'Das Geburtsdatum darf nicht in der Zukunft liegen.',
            'customer_has_no_name' => 'Name fehlt.',
            'customer_has_no_surname' => 'Nachname fehlt.',
            'customer_has_no_nationality_or_has_null_code' => 'Staatsbürgerschaft fehlt.',
            'customer_has_no_residence_city_country_place' => 'Fehlende Wohnstadt- und Ländercodes. Bitte Support kontaktieren.',
            'guest_validation_failed' => 'Das Sizilianische Tourismus-Observatorium konnte den Gast :name nicht validieren.',
            'sync_failed' => 'Versuch, Daten an eine manuell auf dem Portal "Sizilianisches Tourismus-Observatorium" gelöschte Buchung zu senden. Deaktivieren Sie die stornierte Buchung oder versuchen Sie es erneut.',
            'uncaught_forbidden' => 'Falsche Anmeldedaten oder Strukturcode. Bitte überprüfen Sie die Daten.',
            'wrong_username_password_wskey' => 'Falscher Benutzername, Passwort oder WsKey',
            'generic_error' => 'Das Portal hat nicht korrekt geantwortet. Bitte versuchen Sie es später erneut.',
            'missing_istat_code' => 'ISTAT-Code für den Ort :placeName nicht gefunden. Bitte Support kontaktieren.',
            'istat_exemption_not_valid' => 'Befreiung von ABIT nicht vorgesehen.',
            'invalid_length_of_stay' => 'Ungültige Aufenthaltsdauer',
            'guest_has_no_customer_data' => 'Bitte füllen Sie alle erforderlichen Felder aus.',
            'some_customer_has_not_present' => 'Daten von :customer_number Gast fehlen|Daten von :customer_number Gästen fehlen',
            'customer_has_not_present' => 'Keine Gäste in der Reservierung registriert.',
            'customer_has_no_data' => 'Bitte füllen Sie alle erforderlichen Felder aus.',
            'customer_has_no_residence_place' => 'Wohnsitzland-Code fehlt, bitte kontaktieren Sie den Support.',
            'customer_has_no_birth_place' => 'Geburtsort fehlt oder ist unvollständig.',
            'customer_has_no_birth_city_country_place' => 'Geburtsstadt- und Ländercodes fehlen, bitte kontaktieren Sie den Support.',
            'istat_the_portal_not_responding' => 'Das Portal hat nicht korrekt geantwortet. Bitte versuchen Sie es später erneut.',
            'sicilia_web_service_outcome_empty_response' => 'Das Portal hat nicht korrekt geantwortet. Bitte versuchen Sie es später erneut.',
            'alloggiatiweb_error_owner_hotel' => 'Wohnungscodes können mit diesem Konto nicht verwendet werden. Deaktivieren Sie die Konfiguration unter Konfiguration > Alloggiati Web.',
            'alloggiatiweb_error_owner_apartment' => 'Wohnungscodes sind für dieses Konto erforderlich. Aktivieren Sie die Konfiguration unter Konfiguration > Alloggiati Web.',
            'generic_error_send' => 'Das Portal hat nicht korrekt geantwortet. Bitte versuchen Sie es später erneut.',
            'empty_italian_residence_county_abbreviation' => 'Provinzcode des Wohnsitzes nicht gefunden. Bitte kontaktieren Sie den technischen Support.',
            'empty_italian_residence_city_code' => 'Gemeindecode des Wohnsitzes nicht gefunden. Bitte kontaktieren Sie den technischen Support.',
            'empty_italian_birth_county_abbreviation' => 'Provinzcode des Geburtsortes nicht gefunden. Bitte kontaktieren Sie den technischen Support.',
            'empty_italian_birth_city_code' => 'Gemeindecode des Geburtsortes nicht gefunden. Bitte kontaktieren Sie den technischen Support.',
            'unexpected_send_date' => 'Das erwartete Sendedatum ist :date. Bitte ändern Sie das Sendedatum.',
            'unexpected_date' => 'Das erwartete Exportdatum ist :date. Bitte ändern Sie das Exportdatum.',
            'no_tableau_number' => 'Kein Unterkunftseintrag für das Datum: :date',
            'unmapped_tableau_number' => 'Unmapped Unterkunftseintrag. Bitte überprüfen Sie die Konfiguration der Alloggiati-Webgruppe.',
            'rooms_number_overflow' => 'Die Anzahl der belegten Unterkünfte übersteigt die maximal auf dem Portal konfigurierten Unterkünfte. Bitte überprüfen Sie die Informationen unter Konfiguration > ISTAT.',
            'no_istat_module_configured' => 'ISTAT-Gruppe nicht konfiguriert.',
            'no_exportable_guests' => 'Keine Karten zum Exportieren verfügbar.',
            'room_has_no_family_members' => 'Es ist ein Familienoberhaupt ohne Familienmitglieder vorhanden.',
            'room_has_many_leaders' => 'Es kann nur ein Familienoberhaupt pro Unterkunft geben.',
            'room_has_no_family_leader' => 'Ungültiges Familienmitglied (muss ein Mitglied sein)',
            'invalid_family_member_in_group' => 'Ungültiges Familienmitglied (muss ein Mitglied sein)',
            'invalid_family_leader_in_group' => 'Ungültiges Familienoberhaupt (Gruppenführer vorhanden)',
            'invalid_group_member_in_family' => 'Ungültiges Gruppenmitglied (muss ein Familienmitglied sein)',
            'invalid_group_leader_in_family' => 'Ungültiger Gruppenführer (Familienoberhaupt vorhanden)',
            'multiple_group_leaders' => 'Es kann nur einen Gruppenführer pro Reservierung geben.',
            'multiple_family_leaders' => 'Es kann nur ein Familienoberhaupt pro Unterkunft geben.',
            'group_member_alone' => 'Bitte einen Gruppenführer angeben.',
            'group_leader_alone' => 'Es ist ein Gruppenführer ohne Mitglieder vorhanden.',
            'family_member_alone' => 'Bitte ein Familienoberhaupt angeben.',
            'family_leader_alone' => 'Es ist ein Familienoberhaupt ohne Familienmitglieder vorhanden.',
            'customer_has_no_leader' => 'Es fehlt ein Gruppenführer oder ein Familienoberhaupt.',
            'must_be_single_guest' => 'Falscher Gasttyp: Bitte Einzelgast angeben.',
            'invalid_released_size' => 'Ungültige Länge des Ausstellungsorts. Maximal 9 Zeichen erlaubt.',
            'invalid_document_number_size' => 'Ungültige Länge der Dokumentnummer. Maximal 20 Zeichen erlaubt.',
            'invalid_name_size' => 'Ungültige Namenslänge. Maximal 30 Zeichen erlaubt.',
            'invalid_surname_size' => 'Ungültige Nachnamenslänge. Maximal 50 Zeichen erlaubt.',
            'invalid_value_size' => 'Ungültige Feldlänge.',
        ],
        'success' => [
            'upload_recordset_completed' => 'Datensatz erfolgreich hochgeladen.',
        ],
        'webservice' => [
            'service_unavailable' => 'Dienst nicht verfügbar oder nicht korrekt konfiguriert.',
        ],
        'fields' => [
            'date_to_send' => 'Sendedatum',
            'date_to_export' => 'Exportdatum',
            'current_date' => 'Aktuelles Datum',
            'last_sent_day' => 'Zuletzt exportiertes Datum',
            'reference_date' => 'Referenzdatum für die Suche',
            'hotel_code' => 'Hotelcode',
            'property_list' => 'Unterkunftsliste',
            'get_property_code' => 'Unterkunftscode abrufen',
            'username' => 'Benutzername',
            'password' => 'Passwort',
            'ricestat' => [
                // Benutzerdefinierte Übersetzungen für Ricestat
                'username' => 'Ricestat-Benutzername',
            ],
            'sicilia' => [
                // Benutzerdefinierte Übersetzungen für Sizilianisches Tourismus-Observatorium
                'username' => 'Benutzer-ID Tourismus-Observatorium',
                'hotel_code' => 'Hotelcode bei der Registrierung (falls abweichend vom Benutzernamen)',
            ],
            'sired' => [
                // Benutzerdefinierte Übersetzungen für Sired
                'declared_available_rooms' => 'Gesamtzahl der potenziell verfügbaren Einheiten zum Verkauf (laut Portal)',
                'declared_available_beds' => 'Anzahl verfügbarer Betten (laut Portal)',
            ],
            'turismo5' => [
                // Benutzerdefinierte Übersetzungen für Turismo5
                'hotel_code' => 'Strukturcode oder Regionencode',
                'declared_available_rooms' => 'Gesamtzahl der potenziell verfügbaren Einheiten zum Verkauf (laut Portal)',
                'declared_available_beds' => 'Anzahl verfügbarer Betten (laut Portal)',
                'endpoint' => 'Area geografica',
            ],
            'c59' => [
                // Benutzerdefinierte Übersetzungen für C59
                'c59_progression' => 'Fortschritt zum Referenzdatum',
                'c59_year' => 'Referenzjahr des Fortschritts',
            ],
            'trento' => [
                // Benutzerdefinierte Übersetzungen für Trento
                'declared_available_rooms' => 'Anzahl verfügbarer Zimmer',
            ],
            'astat' => [
                // Benutzerdefinierte Übersetzungen für Astat
                'accommodationId' => 'Hotelcode oder Unterkunfts-ID',
                'prepare_local_tax' => 'Touristensteuer vorbereiten',
                'close_month' => 'Monat schließen',
                'token' => 'Token',
                'last_month_closed' => 'Zuletzt geschlossener Monat',
                'property_closed_date_range' => 'Schließungszeitraum der Unterkunft',
            ],
            'sinfonia' => [
                'cusr' => 'Strukturidentifikator',
                'api_key' => 'API-Schlüssel des Verwaltungssystems'
            ],

            'webtur' => [
                'cir' => 'Regionale Identifikationsnummer der Unterkunft (CIR)',
                'cin' => 'Nationale Kennung der Unterkunft (CIN)',
                'declared_available_rooms' => 'Anzahl der verfügbaren Zimmer',
            ],

            'option_scheduled_label' => 'Automatischen ISTAT-Berichtversand aktivieren?',
            'option_scheduled_description' => 'Das System sendet Berichte automatisch ab dem aktuellen Datum',
            'option_scheduled_send_every_hour_label' => 'Geben Sie die Häufigkeit des ISTAT-Berichtversands an',
            'show_city_tax' => 'Mostra la tassa di soggiorno',
            'guest_id_description' => 'Id dell\'ospite da cancellare',
            'guest_id' => 'Id dell\'ospite',
            'delete_movements_flag' => 'Bestätigung der Löschung der Bewegungen',
            'delete_movements_flag_description' => 'Flag, der angibt, ob die Bewegungen gelöscht werden sollen',
            'delete_movements_not_confirmed' => 'Sind Sie sicher, dass Sie die Bewegungen ab diesem Datum löschen möchten? Dieser Vorgang ist unwiderruflich.',
            'declared_available_beds' => 'Anzahl der tatsächlich verfügbaren Betten für den Verkauf',
            'declared_available_rooms' => 'Anzahl der tatsächlich verfügbaren Unterkünfte für den Verkauf',
            'do_not_update_current_day_description' => 'Beim Versand an das ISTAT wird das Datum des aktuellen Tages nicht aktualisiert',
            'do_not_update_current_day_label' => 'Aktuellen Tag nicht aktualisieren',
            'operation_code_description' => 'Kennzeichnet den Versandvorgang',
            'operation_code_label' => 'Vorgangscode',
            'is_auto_description' => 'Automatischer/manueller Versand',
            'is_auto' => 'Art des Versands',
            'use_progression' => 'Zu verwendende fortlaufende Nummer',
        ],
    ],

    'guest' => [
        'alloggiatiweb' => [
            'no_guests_txt' => 'Keine registrierten Gäste vorhanden',
            'property_no_module_configured' => 'Die Unterkunft hat das Alloggiatiweb-Modul nicht konfiguriert',
            'wrong_size_file' => 'Falsche Dateigröße, bitte kontaktieren Sie den Support',
            'wrong_arrival_date' => 'Falsches Ankunftsdatum',
            'general_error' => 'Falsche Anmeldedaten oder ungültiges Zertifikat',
            'error_txt_file' => 'Fehler bei der Erstellung der Gäste-Anmeldedatei',
            'post_upload_error' => 'Ungültige Datei. Überprüfen Sie den Dateityp',
            'invalid_certificate' => 'Ungültiges Zertifikat',
            'certificate_and_password_required' => 'Zertifikat und Passwort sind erforderlich',
        ],
        'logger' => [
            'city_tax_log' => ':name :surname, :age Jahre alt (:first_date - :last_date für :accommodation_name) Gesamt: :total_city_tax',
            'naming' => 'Gast :name :surname: ',
            'checkin_date' => 'Check-in: :arrival_date => :checkin_date',
            'checkout_date' => 'Check-out: :departure_date => :checkout_date',
        ],
        'errors' => [
            'different_property_on_move' => 'Die Unterkunft des Zielzimmers gehört nicht zu Ihrer Gruppe von Unterkünften',
            'family_master_already_in_room' => 'Vorgang nicht möglich, da bereits ein Familienoberhaupt im Zielzimmer vorhanden ist',
            'checkin_checkout_not_suitable' => 'Check-in- oder Check-out-Daten der Gäste sind nicht mit dem Zielzimmer kompatibel',
            'not_found' => 'Gast nicht gefunden',
            'city_tax_already_sent_to_channel' => 'Gast bereits an verbundene Touristensteuerportale übermittelt, Vorgang nicht möglich',
            'change_accommodation_with_invoiced_tax' => 'Änderung des Zimmertyps bei einem Gast mit fakturierter Touristensteuer nicht möglich',
        ],
        'guest_cards' => [
            'empty_error' => 'Falsche Anmeldedaten oder Unterkunft nicht aktiviert.',
            'uknown_error' => 'Unbekannter Fehler des externen Dienstes',
            'venice_tax_exemption_type' => 'Befreiung vom Zugangsbeitrag der Stadt Venedig',
            'guest_required' => 'Es muss ein Gast angegeben werden, dem die Karte zugeordnet wird',
            'customer_fields_are_required' => 'Die folgenden Felder des Gastes sind erforderlich: :fields',
            'customer_required_fields' => [
                'name' => 'Vorname',
                'surname' => 'Nachname',
                'nic' => 'Steuerkennzeichen',
                'birthday_date' => 'Geburtsdatum',
                'birth_country.translations.0.name' => 'Geburtsort',
                'detail.email' => 'E-Mail',
                'detail.telephone' => 'Telefon',
                'detail.country.translations.0.name' => 'Wohnsitz',
            ],
        ],
    ],

    'housekeeper' => [
        'main_title' => 'Hausdame',
        'clean_status' => 'Status',
        'name' => 'Hausdame',
        'label' => 'Nummer',
        'accommodation' => 'Unterkunft',
        'bed_type_requested' => 'Betten erforderlich',
        'bed_type_last' => 'Vorbereitung der Betten aus der vorherigen Buchung',
        'bed_type_next' => 'Bettvorbereitung für die nächste Buchung erforderlich',
        'guests' => 'Kunden',
        'bed_type' => 'Bettart',
        'next_abbrevation' => 'Nächste',
        'prev_abbrevation' => 'Vorherige',
        'guests_checkin' => 'Ankommend',
        'guests_in_home' => 'Bleibend',
        'guests_checkout' => 'Abreisend',
        'next_change_sheet' => 'Bettwäschewechsel',
        'day' => 'Tag',
        'days' => 'Tage',
        'today' => 'Heute',
        'notes' => 'Notizen',
        'housekeeper_notes' => 'Notizen der Hausdame',
        'room_clean' => 'sauber',
        'room_dirty' => 'schmutzig',
        'children' => 'Kinder :count',
        'adults' => 'Erwachsene :count',
        'reservations' => 'Reservierungen',
        'requested' => 'Angefragt',
        'today' => 'Heute',
        'tomorrow' => 'Morgen',
        'maintenance' => 'Wartung',
        'export_fields' => [
            'cleaning' => 'Reinigung',
            'accommodation' => 'Unterkunft',
            'housekeeper' => 'Hausdame',
            'status' => 'Status',
            'staging' => 'Vorbereitung',
            'sheet' => 'Bettwäsche',
            'linen' => 'Wäsche',
            'details' => 'Details',
            'created_at' => 'Datum',
            'user' => 'Benutzer',
            'scenario_title' => 'Szenario',
            'column1' => 'Datum/Ressource',
            'column2' => 'Planung',
            'column3' => 'Uhrzeit',
            'scenario' => 'Planung',
            'housekeeper_collaborator' => 'In Zusammenarbeit mit',
        ],
        'print' => [
            'number_of_accommodations' => ':number Unterkünfte',
            'number_of_checkin' => 'Ankünfte: :checkin_done von :checkin_total',
            'number_of_checkout' => 'Abreisen: :checkout_done von :checkout_total',
            'number_of_inhome' => 'Bleibend: :number_in_home',
            'change_sheet' => 'Bettwäschewechsel',
            'change_linen' => 'Wäschewechsel',
            'note_housekeeper' => 'Notizen für die Hausdame',
            'pending_manteiner' => ':number ausstehende Wartungsmeldungen',
            'status_checkin' => 'Ankommend',
            'status_checkout' => 'Abreisend',
            'status_in_home' => 'Bleibend',
            'status_label_adult' => ':adults Erwachsene',
            'status_label_children' => ':children_number Kinder',
            'passed_nights' => 'Nacht :passed_nights von :total_nights',
        ],
        'bed_type_current' => 'Angeforderte Vorbereitung',
    ],

    'import' => [
        'customer' => [
            'job_name' => 'Kunden',
            'warnings' => ['required_field' => 'pflichtfeld'],
            'tooltips' => [
                'skip_on_missing' => 'Datensätze in der hochgeladenen Datei, die keinen Wert für dieses Feld enthalten, werden beim Import ignoriert.',

                'sex_value' => '<br /> Akzeptierte Werte für jedes Geschlecht: <br /> 
        - Mann: male, maschio, uomo, m, man, maschile, u  <br />
        - Frau: female, femmina, donna, f, woman, femminile, d  <br />
        - Nicht angegeben: not_defined, non definito, non specificato, na, n/a, leere Zelle  <br />
        Das System unterscheidet nicht zwischen Groß- und Kleinschreibung und akzeptiert z. B. sowohl “mann”, “MANN” als auch “Mann”.',

                'birth_country_required' => 'Um eine korrekte Zuordnung der Geburtsstadt zu ermöglichen, muss auch dieses Feld zugeordnet werden. Das System akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes: 3166-1 (3 Ziffern), 3166-1 alpha-2 (2 Buchstaben), 3166-1 alpha-3 (3 Buchstaben).',

                'birth_country' => 'Wenn nur das Feld Geburtsland (ohne zugehörige Stadt) zugeordnet ist, wird die Hauptstadt des gewählten Landes automatisch als Geburtsstadt im Kundenprofil eingetragen. Das System akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes, unabhängig von Groß- und Kleinschreibung.',

                'birth_city' => 'Um eine korrekte Zuordnung der Stadt zu ermöglichen, muss auch das folgende Feld Geburtsland zugeordnet werden. Das System akzeptiert Städtenamen in jeder Sprache.',

                'citizenship_country' => 'Akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes: 3166-1 (3 Ziffern), alpha-2 (2 Buchstaben), alpha-3 (3 Buchstaben), unabhängig von Groß- oder Kleinschreibung.',

                'language' => 'Das System unterstützt folgende Sprachen von Beddy: Italienisch, Englisch, Französisch, Deutsch, Spanisch, Russisch, Japanisch. Andere Sprachen werden als Englisch gesetzt.  
        Akzeptierte Werte (unabhängig von Groß- oder Kleinschreibung):  
        - ISO 639-1 (2 Buchstaben), z. B. "de"  
        - ISO 639-2 (3 Buchstaben), z. B. "deu"  
        - Vollständiger Name der Sprache auf Italienisch oder in der Übersetzung auf Englisch, Französisch, Deutsch oder Spanisch, z. B. italiano, italian, italien, deutsch, italiano  
        Wenn keine Werte vorhanden sind oder keine Zuordnung gewählt wurde, wird die Amtssprache des Wohnsitzlandes verwendet, falls vorhanden, andernfalls die Standardsprache.',

                'residence_city' => 'Um eine korrekte Zuordnung der Stadt zu ermöglichen, muss auch das folgende Feld Wohnsitzland zugeordnet werden. Das System akzeptiert Städtenamen in jeder Sprache.',

                'residence_country_required' => 'Um eine korrekte Zuordnung der Wohnsitzstadt zu ermöglichen, muss auch dieses Feld zugeordnet werden. Das System akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes: 3166-1 (3 Ziffern), alpha-2 (2 Buchstaben), alpha-3 (3 Buchstaben).',

                'residence_country' => 'Wenn nur das Feld Wohnsitzland (ohne zugehörige Stadt) zugeordnet ist, wird die Hauptstadt des gewählten Landes automatisch als Geburtsstadt im Kundenprofil eingetragen. Das System akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes, unabhängig von Groß- oder Kleinschreibung.',

                'residence_address' => ' Nur die Adresse ohne Stadt, PLZ oder Land zuordnen.',

                'email' => ' Geben Sie die E-Mail-Adresse ein, nicht die eventuelle PEC, die ein eigenes Feld hat.',

                'document_type' => 'Akzeptiert alle von Alloggiati Web unterstützten Dokumenttypen, unabhängig von Groß- oder Kleinschreibung. Für die gängigsten Dokumente – Personalausweis, elektronischer Ausweis, Führerschein und Reisepass – akzeptiert das System auch gängige Abkürzungen wie CI, CIE, ID, PASS.',

                'released_country_required' => 'Um eine korrekte Zuordnung der Ausstellungsstadt zu ermöglichen, muss auch dieses Feld zugeordnet werden. Das System akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes.',

                'released_country' => 'Wenn nur das Feld Ausstellungsland (ohne zugehörige Stadt) zugeordnet ist, wird die Hauptstadt des gewählten Landes automatisch als Geburtsstadt im Kundenprofil eingetragen. Das System akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes, unabhängig von Groß- oder Kleinschreibung.',

                'released_city' => 'Um eine korrekte Zuordnung der Stadt zu ermöglichen, muss auch das folgende Feld Ausstellungsland zugeordnet werden. Das System akzeptiert Städtenamen in jeder Sprache.',

                'invoicing_country_required' => 'Um eine korrekte Zuordnung der Rechnungsstadt zu ermöglichen, muss auch dieses Feld zugeordnet werden. Das System akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes.',

                'invoicing_country' => 'Wenn nur das Feld Rechnungsland (ohne zugehörige Stadt) zugeordnet ist, wird die Hauptstadt des gewählten Landes automatisch als Geburtsstadt im Kundenprofil eingetragen. Das System akzeptiert Ländernamen in jeder Sprache sowie alle ISO-Codes, unabhängig von Groß- oder Kleinschreibung.',

                'invoicing_city' => 'Um eine korrekte Zuordnung der Stadt zu ermöglichen, muss auch das folgende Feld Rechnungsland zugeordnet werden. Das System akzeptiert Städtenamen in jeder Sprache.',
            ],

            'columns' => [
                'name' => 'Name',
                'surname' => 'Nachname',
                'sex' => 'Geschlecht',
                'birthday_date' => 'Geburtsdatum',
                'nic' => 'Steuernummer',
                'email' => 'E-Mail-Adresse',
                'pec' => 'PEC-Adresse',
                'telephone' => 'Telefon',
                'language' => 'Sprache',
                'birth_country' => 'Geburtsland',
                'birth_city' => 'Geburtsstadt',
                'nationality_country' => 'Nationalität (z.B. Italien)',
                'citizenship_country' => 'Staatsbürgerschaft',
                'residence_country' => 'Wohnsitzland',
                'residence_city' => 'Wohnsitzstadt',
                'residence_address' => 'Wohnsitzadresse',
                'residence_zip_code' => 'PLZ Wohnsitz',
                'invoicing_country' => 'Rechnungsland',
                'invoicing_city' => 'Rechnungsstadt',
                'invoicing_address' => 'Rechnungsadresse',
                'invoicing_zip_code' => 'PLZ Rechnungsadresse',
                'sdi_code' => 'SDI-Code',
                'facebook' => 'Facebook-URL',
                'linkedin' => 'LinkedIn-URL',
                'twitter' => 'Twitter-URL',
                'skype' => 'Skype',
                'note' => 'Notizen',
                'lottery_code' => 'Lotterie-Code',
                'document_type' => 'Dokumenttyp-ID',
                'document_number' => 'Dokumentnummer',
                'expiration_date' => 'Ablaufdatum des Dokuments',
                'released_country' => 'Ausstellungsland des Dokuments',
                'released_city' => 'Ausstellungsstadt des Dokuments',
                'release_county' => 'Ausstellungsprovinz des Dokuments',
                'release_state' => 'Ausstellungsregion des Dokuments',
                'lang_values' => ['tedesco', 'german', 'allemand', 'deutsch', 'alemán', 'deu',],
                'sex_values' => [
                    'male' => [
                        'männlich',
                        'mann',
                        'm',
                    ],
                    'female' => [
                        'weiblich',
                        'frau',
                        'f',
                    ],
                    'not_defined' => [
                        'nicht definiert',
                        'nicht angegeben',
                    ],
                ]
            ],
        ],
        'company' => [
            'job_name' => 'Unternehmen',
            'columns' => [
                'name' => 'Firmenname',
                'vat_code' => 'USt-IdNr.',
                'nic' => 'Steuernummer',
                'nick_name' => 'Spitzname',
                'email' => 'E-Mail',
                'pec' => 'PEC',
                'telephone' => 'Telefon',
                'country' => 'Land',
                'city' => 'Stadt',
                'address' => 'Adresse',
                'zip_code' => 'PLZ',
                'invoicing_country' => 'Rechnungsland',
                'invoicing_city' => 'Rechnungsstadt',
                'invoicing_address' => 'Rechnungsadresse',
                'invoicing_zip_code' => 'PLZ Rechnungsadresse',
                'sdi_code' => 'SDI-Code',
                'facebook' => 'Facebook',
                'linkedin' => 'LinkedIn',
                'twitter' => 'Twitter',
                'skype' => 'Skype',
                'note' => 'Notizen',
            ],
        ],
        'booking_onboard_photo_property' => [
            'job_name' => 'Importiere Unterkunftsfotos von Booking',
        ],
        'common' => [
            'personal_informations' => 'Persönliche Informationen',
            'contacts' => 'Kontakte',
            'residential_details' => 'Wohnsitzdetails',
            'invoice_address' => 'Rechnungsdetails',
            'documents' => 'Dokumente',
            'email' => 'E-Mail',
            'other' => 'Sonstiges',
        ],
        'sending_list_contacts' => [
            'job_name' => 'Kontaktliste',
            'columns' => [
                'label' => 'Etikett',
                'email' => 'E-Mail-Adresse',
                'locale' => 'Sprache',
            ],
        ],
        'errors' => [
            'request_params_not_valid' => 'Die folgenden Anforderungsparameter sind ungültig: ',
        ],
    ],

    'invoice_layouts' => [
        'errors' => [
            'delete' => [
                'one_or_more_receipt_modules_attached' => 'Es sind eine oder mehrere Registrierkassen mit diesem Rechnungsmodul verknüpft. Um dieses Rechnungsprofil zu löschen, müssen die Registrierkassen entfernt oder einem neuen Rechnungsprofil zugeordnet werden.',
            ],
        ],
    ],

    'invoice' => [
        'export_fields' => [
            'payment_date' => 'Zahlungsdatum',
            'number' => 'Rechnungsnummer',
            'business_name' => 'Firmenname',
            'total_price' => 'Gesamtbetrag',
            'vat' => 'MwSt.',
            'taxable' => 'Steuerpflichtig',
            'invoice_date' => 'Belegdatum',
            'recipient_vat_code' => 'USt.-IdNr.',
            'number_complete' => 'Nummer',
            'recipient_business_name' => 'Empfängername',
            'total_with_discount' => 'Steuerpflichtig',
            'total_tax' => 'Gesamt MwSt.',
            'total' => 'Gesamt',
            'status_sdi' => 'SDI',
            'expire_date' => 'Fälligkeitsdatum',
            'status' => 'Status',
            'payment_term' => 'Zahlungsfrist',
            'customer_name' => 'Kunde',
            'payment' => 'Zahlung',
            'date' => 'Datum',
            'accountholder' => 'Kontoinhaber',
            'notes' => 'Notizen',
            'paid' => 'Bezahlt',
            'to_pay' => 'Zu zahlen',
            'property' => 'Eigenschaft',
            'payment_status' => 'Zahlungsstatus',
            'data' => 'Daten',
            'currency' => 'Währung',
            'total_document' => 'Gesamtdokument',
        ],
        'statuses' => [
            'paid' => 'Bezahlt',
            'suspended' => 'Ausgesetzt',
            'cancelled' => 'Storniert',
        ],
        'sdi_statuses' => [
            '0' => 'Nicht gesendet',
            '1' => 'Ausstehend',
            '2' => 'Abgelehnt',
            '3' => 'Abgeschlossen',
        ],
        'pdf_export' => [
            'description' => 'Beschreibung',
            'quantity' => 'Menge',
            'amount' => 'Betrag',
            'vat' => 'MwSt.',
            'vat_abbr' => 'USt.',
            'total' => 'Gesamt',
            'invoice_label' => 'Rechnung',
            'of_date' => 'vom',
            'taxable' => 'Steuerpflichtig',
            'deposit' => 'Anzahlung',
            'deposit_document_reference' => 'Belegreferenz',
            'aomount_not_taxable' => 'Betrag nicht steuerpflichtig',
        ],
        'invoices_opened' => [
            'invoices_opened_title' => 'Offene Zahlungen',
            'export_fields' => [
                'expire_date' => 'Fälligkeitsdatum',
                'accountholder' => 'Kontoinhaber',
                'document_number' => 'Belegnummer',
                'date' => 'Datum',
                'type' => 'Typ',
                'paid' => 'Bezahlt',
                'to_pay' => 'Zu zahlen',
                'total' => 'Gesamt',
                'note' => 'Notizen',
                'property' => 'Eigenschaft',
            ],
        ],
        'errors' => [
            'advance_not_suitable' => 'Anzahlung nicht kompatibel mit der Dokumentart',
            'credit_note_on_follows_invoice_paid' => 'Gutschrift auf vollständig bezahlte "Folgt Rechnung"-Dokumente nicht möglich',
            'credit_note_on_follows_invoice_linked' => 'Gutschrift auf "Folgt Rechnung"-Dokumente, die mit einem Konto verknüpft sind, nicht möglich',
            'restore_on_follows_invoice_linked' => 'Konto eines "Folgt Rechnung"-Dokuments, das mit einem anderen Konto verknüpft ist, kann nicht wieder geöffnet werden',
            'cant_restore_opened_invoice' => 'Nicht fiskalisiertes Konto kann nicht wieder geöffnet werden',
            'module_sdi_not_active' => 'Das elektronische Rechnungsmodul ist nicht aktiv',
            'refund_major_than_total_credit_note' => 'Erstattung der Gutschrift übersteigt den Gesamtbetrag, Vorgang nicht möglich',
            'expense_on_invoice' => 'Spesen können nur mit Gutschriften verknüpft werden',
            'cant_resend_due_status' => 'Aktueller SDI-Status erlaubt keine erneute Übermittlung',
            'empty_xml' => 'Kein XML gefunden',
            'cancellation_no_show_conflict' => 'Es kann nur eine Option angegeben werden: No-Show oder Stornierung',
            'cant_delete_credit_note' => 'Gutschrift kann nicht gelöscht werden',
            'add_to_invoices_already_registered' => 'Buchungen zu registrierten Rechnungen oder Gutschriften können nicht hinzugefügt werden',
            'edit_invoices_already_registered' => 'Registrierte Rechnungen können nicht bearbeitet werden',
            'delete_registered_invoice' => 'Registrierte Rechnung kann nicht gelöscht werden',
            'impossible_delete_until_moves' => 'Konto kann nicht gelöscht werden, bevor Buchungen auf andere Konten verschoben werden',
            'not_exist' => 'Rechnung existiert nicht',
            'vat_payment_impossible_for_receipt' => 'Es ist nicht möglich, eine andere MwSt.-Fälligkeit als "sofort" für Quittungen einzustellen',
            'unrestorable_bill' => 'Buchung kann nicht wiederhergestellt werden',
            'impossible_discount_for_discounted_bills' => 'Rabatt kann nicht auf bereits rabattierte Buchungen angewendet werden',
            'refundable_bill_in_invoice' => 'Rückerstattung außerhalb einer Gutschrift nicht möglich',
            'impossible_manual_charge_updating' => 'Diese Buchung kann nicht geändert werden',
            'impossible_follows_invoice_updating' => 'Änderungen an Buchungen, die mit einem "Folgt Rechnung"-Dokument verknüpft sind, sind nicht möglich',
            'impossible_associate_invoice_as_advance' => 'Eine reguläre Rechnung kann nicht als Anzahlung verknüpft werden',
            'advances_over_allowed' => 'Anzahlungswert überschreitet den zulässigen Wert',
            'fp_advances_with_different_department' => 'Die ausgewählten Anzahlungsbelege müssen denselben MwSt.-Satz haben',
            'advances_no_have_department' => 'Die Abteilung der Anzahlung muss in den Buchungen des Abschlussbelegs enthalten sein',
            'advances_total_major' => 'Anzahlungsbetrag darf nicht höher sein als die Summe der Buchungen mit derselben Abteilung im Abschlussbeleg',
            'invoice_totally_refunded' => 'Rechnung vollständig erstattet, Vorgang nicht möglich',
            'advance_with_different_customer' => 'Anzahlungsrechnung nicht zuweisbar aufgrund unterschiedlicher Empfänger',
            'advance_totally_assigned' => 'Vollständig zugewiesene Anzahlungsrechnung kann nicht erstattet werden',
            'deposit_in_general_invoice' => 'Anzahlung kann nicht auf ein durchlaufendes Konto angewendet werden',
            'bill_overrated' => 'Zahlungsbetrag übersteigt den Gesamtbetrag der verknüpften Buchung',
            'invoice_overrated' => 'Zahlungsbetrag übersteigt den Gesamtbetrag der verknüpften Rechnung',
            'property_not_attached' => 'Immobilie nicht verknüpft',
            'funds_params_unsuitable' => 'Parameter sind nicht mit der Kasse kompatibel',
            'registered_advance_invoice' => 'Registrierte Anzahlungsrechnung. Bitte verknüpfte Rechnungen löschen',
            'registered_sdi_invoice' => 'Anzahlungsrechnung an SDI gesendet, kann nicht gelöscht werden',
            'move_between_different_types' => 'Buchungen können nicht zwischen Rechnungen und Gutschriften verschoben werden',
            'discount_over' => 'Rabatt übersteigt den Gesamtbetrag der rabattfähigen Buchungen',
            'archive_completed' => 'Archiv bereits abgeschlossen',
            'too_many_tasks' => 'Zu viele laufende Aufgaben',
            'archive_warning' => 'Einige Dateien fehlen',
            'archive_complete' => 'Abgeschlossen',
            'invoice_registered' => 'Dokument bereits ausgestellt, Vorgang nicht möglich',
            'bill_tranfer_follows_invoice' => 'Buchungen aus "Folgt Rechnung"-Quittungen können nicht verschoben werden',
            'bill_generic_and_follows_invoice' => 'Generische Zeilen und Zeilen aus "Folgt Rechnung"-Quittungen können nicht gleichzeitig hinzugefügt werden',
            'different_vat_code_follows_invoice' => 'Quittung mit unterschiedlicher USt.-IdNr. als die Rechnung erkannt, Vorgang nicht möglich',
            'receipt_with_follows_invoice' => 'Zusammenfassungsrechnung kann nicht als Quittung registriert werden',
            'type_not_invoice_summary' => 'Unbezahlte Dokumente können nicht mit der aktuellen Dokumentart verknüpft werden',
            'archive_all_file_not_found' => 'Keine Datei gefunden',
            'impossible_apply_discount_row_on_discounted_invoice' => 'Rabatt kann nicht auf Buchungen angewendet werden, wenn die Rechnung bereits rabattiert ist',
            'cant_delete_invoice_due_convention' => 'Rechnung kann nicht gelöscht werden, da sie mit einem Vertrag verknüpft ist',
            'discount_on_invoice_and_on_row' => 'Rechnung kann nicht mit Rabatt registriert werden, wenn rabattierte Buchungen vorhanden sind',
            'discount_on_summary_invoice' => 'Rabatt kann nicht auf eine Zusammenfassungsrechnung angewendet werden',
            'cant_delete_invoice_due_linked_advances' => 'Eine Anzahlungsrechnung, die als Saldo anderer Rechnungen verwendet wird, kann nicht gelöscht werden',
            'cant_delete_invoice_due_credit_notes' => 'Ein Dokument, das bereits mit einer Gutschrift erstattet wurde, kann nicht gelöscht werden',
            'cant_delete_invoice_due_module_fattelettronica' => 'Rechnung kann nicht gelöscht werden, da sie bereits registriert und/oder an SDI gesendet wurde',
            'cant_restore_invoice_due_sdi_ns' => 'Konto kann nicht wieder geöffnet werden. Rechnung wurde von SDI abgelehnt und kann mit derselben Nummer und demselben Datum erneut gesendet werden.',
            'cant_transfer_due_invoice_registered' => 'Registrierte Rechnung kann nicht verschoben werden',
            'cant_merge_credit_note' => 'Gutschriften können nicht zusammengeführt werden',
            'cant_merge_due_module_fattelettronica' => 'Zusammenführung von Rechnungen, die an SDI gesendet wurden, nicht möglich',
            'cant_transfer_without_holder' => 'Verschieben in ein Konto ohne Inhaber nicht möglich',
            'empty_row_document' => 'Fügen Sie mindestens eine Zeile im Dokument hinzu',
            'cant_delete_receipt' => 'Quittung kann nicht gelöscht werden',
            'addon_unrelated' => 'Zusatzleistung kann nicht mit diesem Konto verknüpft werden',
            'impossible_add_row' => 'Zeile kann nicht zu einem fakturierten oder nicht vorhandenen Dokument hinzugefügt werden',
            'uncharged_rows_found_on_restore' => 'Rechnung kann nicht wiederhergestellt werden: Verknüpfte Buchungen befinden sich in einem offenen Konto mit Überschreibung, stellen Sie die Originalwerte wieder her, bevor Sie fortfahren',
            'cant_create_temporary_due_missing_layout' => 'Dokument kann nicht erstellt werden, da kein Rechnungslayout vorhanden ist',
            'cant_create_temporary_due_missing_layout' => 'Unable to create the document because no billing layout is present',
            'move_bill_over_discount' => 'Cannot transfer the charge because the remaining value would be less than zero. The maximum transferable is: :max_threshold',
            'cant_decrement_price_invoiced_bill' => 'Cannot decrease the price of an already invoiced charge',
            'printer_id_not_associated' => 'Fiscal printer ID not associated with the billing profile',
            'cant_move_reservation_due_advance_invoice' => 'Advance invoices are present. To move the reservation, a balance invoice or credit note must be issued.',
            'cant_move_reservation_due_deposit' => 'Deposits are present. To move the reservation, they must be removed or refunded.',
            'cant_move_reservation_due_payments' => 'Payments are present. To move the reservation, they must be removed or refunded.',
            'cant_update_invoice_balance' => 'Unable to modify data related to a balance invoice',
            'cant_update_invoice_balance_layout' => 'Unable to modify the layout if it is incompatible with the current VAT layout',
            'cant_register_invoice_balance_price' => 'The total of the invoice must match the total payment',
            'cant_choose_payment_deposit_different_property' => 'Cannot use deposit number :deposit_number on this document because it belongs to another property',
            'cant_choose_payment_advance_different_property' => 'Cannot use advance invoice number :number_complete because it belongs to another property',
            'cant_create_invoice_layout_without_vat_code_without_properties_enabled' => 'Cannot create a billing profile without a VAT number for properties not enabled for flat-rate tax',
            'unable_to_register_not_all_inclusive_tax_document_addons' => 'There are charges not enabled for flat-rate tax; please modify them in the configuration or combine them with enabled charges in the account',
            'tax_bills_rows_joined_with_other_type_bills_on_all_tax_inclusive_document' => 'There are tax-type charges combined with charges of other types; restore the situation by excluding taxes from other account items before proceeding',
            'all_tax_inclusive_layout_on_fiscal_printer' => 'Cannot associate a billing profile without a VAT number to a fiscal printer',
            'all_inclusive_tax_document_for_advance' => 'Cannot issue an advance document with flat-rate tax settings',
            'advances_on_all_inclusive_tax_doument' => 'Cannot settle flat-rate tax documents with advance invoices',
            'credit_note_on_all_inclusive_tax_document' => 'Cannot issue a credit note for flat-rate tax; proceed with cancellation',
            'missing_department_override' => 'Fiscal printer department missing for charge :name',
            'missing_department' => 'Fiscal printer department missing for VAT rate :vat_quote % of type',
            'advance_bill_not_found' => 'Advance charge not found',
            'totals_bills_not_equals' => 'The total of the rows does not match the document total',
            'multiple_invoices_bill_rows_override' => 'Cannot create an override for rows of different documents',
            'cant_create_override_for_registered_invoice' => 'Cannot create, modify, or delete an override for a registered or non-existent document',
            'cant_edit_print_settings_for_registered' => 'Cannot modify print options for a registered or non-existent document',
            'not_found' => 'Document not found',
            'no_attachments' => 'No attachments for this document',
            'error_attachments' => 'An error occurred while downloading the attachments',
            'advance_with_all_inclusive_tax_document' => 'Cannot issue an advance invoice under flat-rate tax regime',
            'empty_email' => 'Please enter an email address',
            'empty_email_pdf' => 'PDF document not available',
            'advance_partially_used' => 'Cannot issue a credit note on a partially used advance invoice',
            'different_vat_payment_on_advance' => 'Cannot associate advance invoices with different VAT payment terms',
            'cant_delete_credit_note_due_to_sdi_or_fp' => 'Cannot delete credit notes sent to SDI or reversals issued with fiscal printers',
            'cant_delete_credit_note_between' => 'Cannot delete a credit note or reversal for charges belonging to multiple invoiced documents',
            'destination_deleted' => 'The recipient belongs to a profile no longer present in the system.',
            'vat_code_not_valid' => 'The VAT number entered is not valid',
            'tax_code_not_valid' => 'The tax code entered is not valid',
            'empty_codes' => 'Invalid tax code or VAT number',
            'row_exceed_total_price' => 'The row to be refunded exceeds the original total',
            'row_exceed_qty' => 'The row to be refunded exceeds the original quantity',
            'cant_register_invoice_as_follows_invoice' => 'Cannot issue an invoice in "follows invoice" mode',
            'cant_register_rejected_invoice_as_receipt' => 'Cannot issue a rejected document as a receipt; it is necessary to correct the reported discrepancies and resend it within 5 days',
            'cant_turn_to_paid_follows_invoice' => 'Cannot mark as "paid" a receipt in "follows invoice" mode',
            'reversal_on_receipt_follows_invoice_joined' => 'Cannot issue a credit note for a receipt follows invoice associated with a summary invoice',
            'receipt_channel_must_activated' => 'To configure the virtual printer, the <em>Third-party system interface</em> module must be activated. <br /> Contact your Zucchetti consultant to add the module to your Beddy license.',
            'partial_cannot_exceed_total' => 'The amount cannot exceed the total of the document to be refunded',
            'partial_cannot_exceed_percentage' => 'The percentage cannot exceed the total of the document to be refunded',
            'credit_note_partial_on_advance' => 'Cannot proceed with a partial credit note for an advance document',
            'credit_note_partial_on_fp_send' => 'Cannot proceed with a partial reversal for a document linked to a fiscal printer',
            'credit_note_partial_on_follows_invoice' => 'Cannot proceed with a partial reversal for a "follows invoice" document',
            'row_to_refund_not_found' => 'Row to be refunded not found',
            'partial_only_credit_note' => 'Partials cannot be calculated for a credit note',
            'partial_credit_note_total_payment_exceed_source_payment' => 'The total payments exceed the total of the document',
            'payment_not_belonging_to_invoice_source' => 'The selected payment does not belong to the source document',
            'payment_not_found' => 'The selected payment does not exist',
            'partial_credit_note_row_payment_exceed_source_payment' => 'The total of the selected payment exceeds the total of the original payment',
            'city_tax_bills_partial_refund' => 'Cannot proceed with partial refund of charges of city tax type',
            'registered_sdi invoice' => 'Fattura d\'acconto inviata allo sdi, non cancellabile',
            'credit_note_paid_major_than_total' => 'Die Gesamtsumme der Zahlungen des Dokuments übersteigt den Gesamtbetrag',
            'discount_over_permitted' => 'Der gewährte Rabatt übersteigt den maximal zulässigen Gesamtbetrag ohne Steuern',
        ],
        'errors_xml' => [
            'error_additional_charges_are_required_to_issue_the_receipt' => 'Die Differenz zwischen Saldo und Anzahlungen (:totalPayments €) ist geringer als der erforderliche Wert (:subtractPayment €) zum Abschließen des Dokuments, da jeder Posten mindestens 0,01 € wert sein muss. Erhöhen Sie eine Belastung um :amountRequired € oder gruppieren Sie die Belastungen nach Kategorie oder Service, um eine geringere Anzahl von Posten zu erhalten.',
            'error_total_cannot_be_less_than_one_cent' => 'Der Gesamtbetrag des Dokuments muss höher sein als die Summe der Anzahlungen (mindestens 0,01 €)',
            'payment_not_valid' => 'Invalid payment method',
            'tax_system' => 'Invalid issuer tax regime. Configure the tax regime in the billing profile',
            'cap' => 'Invalid issuer ZIP code',
            'destination_code' => 'Invalid recipient code',
            'destination_code_pa' => 'Invalid recipient code for Public Administration',
            'destination_code_pr' => 'Invalid recipient code for private individuals',
            'destination_cf' => 'Invalid recipient tax code',
            'destination_cap' => 'Invalid recipient ZIP code',
            'address' => 'Billing address not provided',
            'empty_row_description' => 'Provide a description for all rows in the document',
            'department_fp' => 'Department with missing VAT rate',
            'payment_error' => 'Payment detail error',
            'payment_error_amount' => 'The document total is less than the total payments provided',
            'payment_error_code' => 'Invalid payment code: ',
            'nature' => 'Nature is not defined, given a zero VAT rate',
            'reverse_charge' => 'You cannot apply split payment and reverse charge simultaneously.',
            'error_sdi' => 'SDI submission error. Check the entered values.',
            'document_no_xml' => 'Document type not enabled for XML',
            'not_found' => 'XML not found',
            'error_send_invoice' => 'Provider submission error',
            'limit_document_id' => 'Document number :id_document is invalid as it exceeds the allowed limit of 20 characters',
            'error_import_invoice' => 'Import rejected',
            'xsd_validation_skip' => 'XSD validation issue. Validation skipped',
            'xsd_validation_failed' => 'The value (:value) of the element :node is invalid',
            'error_limit_number_invoice' => 'Cannot send the file. Document limit reached. Contact support',
            'error_account_inactive' => 'The account is not active with the billing provider. Contact support',
            'payment_error_vat_quote' => 'Different VAT rates between the total amount and the advance payment',
            'error_content_document' => 'Document content is incorrect, contact support',
            'error_create_document' => 'Error creating XML document, contact support.',
            'error_xml_format_received' => 'Invalid response XML format.',
            'error_empty_response' => 'Empty response XML.',
            'error_zip_archive_creation' => 'Error creating ZIP file.',
            'error_empty_document' => 'Empty XML document, contact support.',
            'voucher_code_not_valid' => 'Der Gutscheincode ist ungültig.',
            'custom' => [
                'limit_message_content' => 'Der Nachrichteninhalt überschreitet das Limit von 42 Zeichen.',
            ],
            'rch' => [
                'limit_message_content' => 'Der Nachrichteninhalt überschreitet das Limit von 25 Zeichen.',
            ]
        ],
        'warnings' => [
            'document_not_found' => 'No document found with ID :invoice_id',
            'city_tax_charged_for_guest' => 'Charge invoiced for the guest, do you want to proceed?',
            'vat_code_already_joined' => 'The profile is linked to invoices or payments, VAT number or header data cannot be modified',
            'all_inclusive_tax_document_with_vat_code' => 'Flat-rate tax document incompatible with issuance via VAT number',
            'cant_restore_bill_invoiced' => 'The charge is invoiced, it cannot be restored',
            'cant_restore_bill_stay_not_involved' => 'The charge relates to dates not present in the stay, do you want to delete it?',
            'cant_restore_bill_not_related' => 'Cannot restore this charge because the resource is no longer present',
            'cant_update_bill_day_price' => 'Cannot update the price for the date :date because the total amount to be invoiced for the charge is less than the price difference',
            'cant_update_bill_day_price_due_convention' => 'The payer for the charge on :date does not reflect the account split; adjust the amount directly in the charges section',
            'cant_delete_bill_stay' => 'Cannot delete a stay-type charge',
            'cant_delete_due_to_joined_documents' => 'Cannot delete a charge present in issued documents',
            'number_used' => 'The invoice number has already been used',
            'number_no_sequential' => 'The number used must have a date between the previous invoice date and the next invoice date',
            'transferred_bills_present' => 'The account contains charges transferred from a reservation; this operation will either delete or zero them',
            'layout_numbers_existing' => 'Active sequential numbering exists for this VAT number or Tax Code, do you want to replace it with the numbering set in this new billing profile? It is recommended to check the numbering of the last documents issued by this VAT number or Tax Code.',
            'additional_info_block_only_for_invoice' => 'Cannot add additional information blocks for this type of document',
            'detach_not_collected_document' => 'Changing the document type will remove associated uncollected documents. Do you want to proceed?',
            'cant_restore_general_bill' => 'Die Abbuchung vom Durchlaufkonto konnte nicht wiederhergestellt werden. Bitte fahren Sie mit der Überweisung manuell fort',
        ],
        'pdf' => [
            'accommodations' => 'Aufenthalt',
            'addons' => 'Extras',
            'advances' => 'Vorauszahlungen',
            'taxes' => 'Steuern',
            'deposits' => 'Kautionen',
            'credit_note_reversal' => 'Stornierung von Quittungen',
            'advance_with_number_complete' => 'Anzahl der Vorauszahlungsrechnung: :number_complete',
            'payment' => 'Zahlung',
            'taxation_list' => 'MwSt.-Zusammenfassung',
            'taxable_amount' => 'Steuerpflichtiger Betrag',
            'tax_amount' => 'Steuern',
            'total' => 'Gesamt',
            'total_taxes' => 'Gesamtsteuern',
            'total_taxable' => 'Gesamt steuerpflichtig',
            'total_taxation' => 'Gesamt MwSt.',
            'total_amount' => 'Gesamtbetrag',
            'total_paid' => 'Bezahlt',
            'total_to_pay' => 'Zu zahlen',
            'document_heading' => 'Dokument Nr. :identifier vom :date',
            'document_advance_heading' => 'Reservierung #:identifier - Vorauszahlung',
            'document_heading_no_date' => 'Dokument Nr. :identifier',
            'document_num' => 'Dokument Nr.',
            // VERALTET:
            'document_date' => 'vom',
            // VERALTET:
            'payable' => 'Nicht steuerpflichtiges Dokument',
            'proforma' => 'Proforma-Rechnung',
            'additional_information' => 'Zusätzliche Informationen',
            'additional_information_contract' => 'Vertrag',
            'additional_information_purchase_order' => 'Kaufauftrag',
            'additional_information_agreement' => 'Vereinbarung',
            'additional_information_receiving' => 'Empfang',
            'additional_information_joined_invoices' => 'Verknüpfte Rechnungen',
            'additional_information_progress_status' => 'Fortschrittsstatus',
            'additional_information_document_id' => 'Dokument-ID',
            'additional_information_line_number_referral' => 'Zeilennummer',
            'additional_information_num_item' => 'Zeilen-ID',
            'additional_information_date' => 'Datum',
            'additional_information_agreement_deal_code' => 'Auftragsnummer',
            'additional_information_cup' => 'CUP-Code',
            'additional_information_cig' => 'CIG-Code',
            'additional_information_step_reference' => 'Phasenreferenz',
            'invoice' => 'Rechnung',
            'unregistered_invoice' => 'Konto',
            'receipt' => 'Quittung',
            'credit_note' => 'Gutschrift',
            'proforma' => 'Proforma',
            'auto_invoice' => 'Selbstfakturierung',
            'reverse_auto_invoice' => 'Stornierung der Selbstfakturierung',
            'debit_note' => 'Lastschrift',
            'destination' => 'Empfänger',
            'causal' => 'Grund',
            'extra_notes' => 'Notizen',
            'attachments' => 'Anhänge',
            'sdi_send_date' => 'SDI-Sendedatum',
            'rounding' => 'Rundung',
            'vat_payment' => [
                'D' => 'MwSt. aufgeschobene Fälligkeit',
                'I' => 'MwSt. sofort fällig',
            ],
            'payment_method' => 'Zahlungsmethode',
            'iban' => 'IBAN',
            'institution' => 'Institut',
            'credit_institution' => 'Kreditinstitut',
            'amount_virtual_stamp' => 'Stempelbetrag',
            'discount' => 'Rabatt',
            'discount_amount' => 'Rabatt oder Zuschlag',
            'receipts' => 'Quittungsliste',
            'reversal' => 'Stornierungsliste',
            'receipts_expired' => 'Liste der Quittungen mit Status "abgelaufen"',
            'receipts_unpaid' => 'Liste der Quittungen mit Status "unbezahlt"',
            'receipts_suspended' => 'Liste der Quittungen mit Status "ausgesetzt"',
            'receipts_paid' => 'Liste der Quittungen mit Status "bezahlt"',
            'payments' => 'Zahlungen',
            // Früher "Weitere Zahlungen"
            'payment_date' => 'Zahlungsdatum',
            'payment_label' => 'Zahlender',
            'payment_method' => 'Methode',
            'amount_available' => 'Verfügbarer Betrag',
            'amount_used' => 'Betrag',
            'deposit' => 'Kaution',
            'copy_text' => 'Höfliche Kopie ohne steuerliche Gültigkeit gemäß Artikel 21 des Präsidialerlasses 633/72. Das Original wurde an das SDI (Interchange-System) übermittelt und ist in Ihrem geschützten Bereich der Steuerbehörde verfügbar.',
        ],
        'wording' => [
            'virtual_stamp_causal_more' => 'Stempelsteuer virtuell bezahlt gemäß Artikel 6 des Ministerialerlasses vom 17.06.2014',
            'all_inclusive_tax_document_exemption' => 'Befreiung - Artikel 3 des Gesetzeserlasses Nr. 23 vom 14.03.2011',
            'standard_advance' => 'Reservierung #:reference_number - Vorauszahlung',
            'manual_fp_register' => 'als vorfiskalisiertes Dokument',
            'follows_invoice' => 'folgt Rechnung',
            'default' => 'Standard',
            'force_change' => 'Änderung der Gebühren erzwingen'
        ],
        'art17' => 'Operation unterliegt dem Split-Payment, wobei die MwSt. vom Verkäufer nicht vereinnahmt wird gemäß Artikel 17-ter des Präsidialerlasses 633/1972.',
        'art6' => 'Operation unterliegt der MwSt.-Aufschiebung gemäß Artikel 6, Absatz 5 des Präsidialerlasses 633/1972.',
        'invoice_module' => [
            'invalid_vat_code' => 'Ungültige MwSt.-Nummer',
            'invalid_invoice_channel' => 'Wählen Sie einen gültigen Kanal',
            'error_get_data' => 'Fehler beim Abrufen der Kontoinformationen',
            'vat_code_exist' => 'Ein Modul mit dieser MwSt.-Nummer existiert bereits',
            'error_fiscal_printer_linked' => 'Es gibt ausgestellte steuerliche Quittungen, die mit dem Drucker verknüpft sind. Möchten Sie diese löschen?',
            'customer' => 'Kunde',
            'subcontracting' => 'Untervergabe'
        ],
        'invoice_import' => [
            'import_success' => 'Dateien erfolgreich importiert',
            'import_skip' => 'Dateien übersprungen (ungültige Empfänger-MwSt.-Nummer oder bereits importierte Datei)',
            'import_error' => 'Importfehler, ungültige XML-Datei',
        ],
        'no_show' => [
            'invoice_label' => 'No Show',
            'invoice_cancellation' => 'Stornierung',
            'no_vat_quote_defined' => 'Für die Struktur ist kein MwSt.-Satz des Typs :type definiert',
        ],
        'cancellation' => [
            'invoice_label' => 'Stornogebühr',
        ],
        'lottery_code' => 'Lotteriecode: :lottery_code',
        'log' => [
            'title' => 'Rechnungsstellung',
            'advance' => 'Rechnung :invoice_number vom :invoice_date mit Rechnungsprofil :invoice_layout (:invoice_business_name - :invoice_vat_code) und ausgestellt auf :invoice_customer (Gesamt: :invoice_total)',
            'refunded_advance' => 'Der :amount des :number vom :date wurde wieder zur Verfügung gestellt',
            'partial_credit_note' => 'Das Dokument :number_complete hat das Dokument :invoice_source_number mit :credit_note_total erstattet: :bill_logs',
        ],
        'types' => [
            'reversal' => 'Stornierungsbeleg',
            'credit_note' => 'Gutschrift',
            'receipt' => 'Quittung',
            'invoice' => 'Rechnung',
            'proforma' => 'Proforma',
            'auto_invoice' => 'Selbstfakturierung',
            'debit_note' => 'Lastschrift',
            'reverse_auto_invoice' => 'Stornierung der Selbstfakturierung',
            'unregistered_invoice' => 'Konto',
        ],
        'open_charges' => 'Offene Konten',
        'operational_headquarter' => 'Betriebsstätte',
        'advances' => 'Vorauszahlungen',
        'log_module' => [
            'invoice_module_updated' => 'Rechnungsmodul aktualisiert',
            'invoice_module_created' => 'Rechnungsmodul erstellt',
            'invoice_module_deleted' => 'Rechnungsmodul gelöscht',
        ]
    ],

    'invoice_received' => [
        'document_types' => [
            'TD27' => 'Rechnung für Eigenverbrauch oder kostenlose Lieferungen ohne Rückerstattung',
            'TD26' => 'Übertragung von Anlagegütern und internen Transfers (gemäß Art. 36 D.P.R. Nr. 633/1972)',
            'TD25' => 'Differenzierte Rechnung gemäß Art. 21, Absatz 4, dritter Satz, Buchst. b)',
            'TD24' => 'Differenzierte Rechnung gemäß Art. 21, Absatz 4, Buchst. a)',
            'TD23' => 'Entnahme von Waren aus einem Mehrwertsteuerlager mit Zahlung der Mehrwertsteuer',
            'TD22' => 'Entnahme von Waren aus einem Mehrwertsteuerlager',
            'TD21' => 'Selbstfakturierung wegen Überschreitung des Kontingents',
            'TD20' => 'Selbstfakturierung zur Berichtigung und Ergänzung von Rechnungen (Art. 6, Absatz 8, D.Lgs. Nr. 471/1997 oder Art. 46, Absatz 5, D.L. Nr. 331/1993)',
            'TD19' => 'Integration/Selbstfakturierung für den Kauf von Waren gemäß Art. 17, Absatz 2, D.P.R. Nr. 633/1972',
            'TD18' => 'Integration für den Kauf von innergemeinschaftlichen Waren',
            'TD17' => 'Integration/Selbstfakturierung für den Kauf von Dienstleistungen aus dem Ausland',
            'TD16' => 'Integration für die Rechnung bei innerstaatlichem Reverse-Charge-Verfahren',
            'TD06' => 'Honorarrechnung',
            'TD05' => 'Lastschriftnote',
            'TD04' => 'Gutschriftnote',
            'TD03' => 'Vorauszahlung auf Honorar',
            'TD02' => 'Vorauszahlung auf Rechnung',
            'TD01' => 'Rechnung',
            'RT06' => 'Sonstiger Sozialversicherungsbeitrag',
            'RT05' => 'ENPAM-Beitrag',
            'RT04' => 'ENASARCO-Beitrag',
            'RT03' => 'INPS-Beitrag',
            'RT02' => 'Quellensteuer für juristische Personen',
            'RT01' => 'Quellensteuer für natürliche Personen',
        ],
        'statuses' => [
            'cancelled' => 'Storniert',
            'partially_paid' => 'Teilweise bezahlt',
            'paid' => 'Bezahlt',
            'unpaid' => 'Unbezahlt',
        ],
        'export_fields' => [
            'amount_to_be_paid' => 'Zu zahlender Gesamtbetrag',
            'paid' => 'Bezahlt',
            'status' => 'Status',
            'discount_amount' => 'Rabatt',
            'total_document' => 'Gesamtbetrag',
            'total_taxes' => 'MwSt.',
            'total_taxable' => 'Steuerpflichtig',
            'sender_vat_code' => 'USt-IdNr. Absender',
            'sender_name' => 'Absender',
            'document_name' => 'Dokument',
            'received_date' => 'Eingangsdatum',
            'document_date' => 'Dokumentdatum',
        ],
        'title' => 'Erhaltene Rechnungen',
    ],

    'logger' => [
        'field_updated' => 'Aktualisiert :section [:field] von :old_value auf :new_value',
        'titles' => [
            'queue_update' => 'Warteschlangenaktualisierung',
            'bulk_update' => 'Massenaktualisierung',
            'new_reservation' => 'Neue Buchung',
            'update_reservation_status' => 'Buchungsstatus geändert',
            'cancel_accommodation' => 'Reserviertes Zimmer storniert',
            'move_accommodation' => 'Reserviertes Zimmer verschoben',
            'update_accommodation' => 'Reserviertes Zimmer aktualisiert',
            'update_accommodation_arrival' => 'Anreisedatum aktualisiert',
            'update_accommodation_departure' => 'Abreisedatum aktualisiert',
            'add_accommodation' => 'Zimmer zur Buchung hinzugefügt',
            'reservation_status' => 'Buchungsstatus aktualisiert',
            'cancel_reservation' => 'Buchung storniert',
            'delete_reservation' => 'Buchung gelöscht',
            'cancel_reservation_no_new' => 'Stornierte Buchung ohne neuen Status',
            'clone_rates' => 'Klonen von :channel_source zu :channel_destination',
            'clone_rates_bulk' => 'Massenaktualisierung durch Klonen',
            'payment_transaction' => 'Zahlungstransaktion',
            'update_accommodation_listing_price' => 'Listenpreis des Zimmers auf :channel_destination aktualisiert',
            'accommodations_overview' => 'Tagesübersicht',
            'reset_min_stay' => 'Mindestaufenthalt zurückgesetzt',
            'tableau_closure_create' => 'Tableau-Schließungen erstellt',
            'tableau_closure_delete' => 'Tableau-Schließungen gelöscht',
            'attach_channel' => 'Kanal :channel_name verbunden',
            'detach_channel' => 'Kanal :channel_name getrennt',
            'read_channel' => 'Kanaldaten gelesen :channel_name',
            'increase_quantity' => 'Zimmeranzahl erhöht',
            'decrease_quantity' => 'Zimmeranzahl verringert',
            'insert_rule' => 'Neue Regel hinzugefügt',
            'update_rule' => 'Regel bearbeitet',
            'delete_rule' => 'Regel gelöscht',
            'cutoff' => 'Cutoff',
            'insert_cutoff' => 'Cutoff-Regel hinzugefügt',
            'modify_cutoff' => 'Cutoff-Regel bearbeitet',
            'delete_cutoff' => 'Cutoff-Regel gelöscht',
            'bulk_treatments_update' => 'Massenaktualisierung der Behandlungen',
            'treatments_overview' => 'Tagesübersicht Behandlungen',
            'rateplan_update' => 'Tarifplan aktualisiert',
            'OTA-API' => 'Partner-API',
            'update_channel' => 'Herkunftskanal geändert',
            'keep_accommodation' => 'Bewegung der Unterkunft blockiert',
            'keep_accommodation_label' => 'Der Wert wurde für die Unterkunft :accommodations geändert',
            'channel_not_connected' => 'Kanal nicht verbunden',
            'city_tax_report_exclusion' => 'Ausschluss der Kurtaxe',
            'city_tax_report_exclusion_label' => 'Der Wert wurde für die Unterkunft :accommodations geändert',
            'update_from_past_years' => 'Tarife aus Vorjahren kopiert',
            'accommodations_mapping' => 'Zimmerzuordnung',
            'no_association' => 'Keine Zuordnung',
        ],
        'messages' => [
            'accommodation_mapping' => 'Von :origin nach :destination',
        ],
        'warnings' => [
            'missing_dates_updates' => 'Daten konnten für die folgenden Zeiträume nicht synchronisiert werden: ',
        ],
    ],

    'mail_channels_errors' => [
        'ses' => [
            'missing_required_fields_for_verfication' => 'Erforderliche Felder zur Überprüfung des Versandkanals fehlen',
            'existing_ses_identity' => 'Vorhandene Absender-E-Mail',
            'configuration_set' => [
                'AlreadyExistsException' => 'Konfigurationssatz bereits vorhanden',
                'NotFoundException' => 'Konfigurationssatz nicht gefunden',
                'TooManyRequestsException' => 'Maximale Anfragelimit für die Erstellung eines Konfigurationssatzes erreicht',
                'LimitExceededException' => 'Instanzlimit für den angeforderten Konfigurationssatz erreicht',
                'BadRequestException' => 'Ungültiger Konfigurationssatz',
                'ConcurrentModificationException' => 'Konfigurationssatz wurde von einer anderen Instanz geändert',
            ],
            'send_bulk_email' => [
                'TooManyRequestsException' => 'Maximale Anfragelimit für das Senden von E-Mails erreicht',
                'LimitExceededException' => 'Instanzlimit für das Senden von E-Mails erreicht',
                'AccountSuspendedException' => 'E-Mail kann nicht gesendet werden, da die Versandkapazität des Kontos dauerhaft eingeschränkt wurde',
                'SendingPausedException' => 'E-Mail kann nicht gesendet werden, da die Versandkapazität des Kontos derzeit ausgesetzt ist',
                'MessageRejected' => 'E-Mail kann nicht gesendet werden, da sie ungültige Inhalte enthält',
                'MailFromDomainNotVerifiedException' => 'E-Mail kann nicht gesendet werden, da die Absenderdomain nicht verifiziert ist',
                'NotFoundException' => 'Ressource für das Senden von E-Mails nicht gefunden',
                'BadRequestException' => 'Ungültige Eingabe für das Senden der E-Mail',
            ],
            'configuration_set_event_destination' => [
                'AlreadyExistsException' => 'Zielereignis bereits vorhanden',
                'NotFoundException' => 'Zielereignis nicht gefunden',
                'TooManyRequestsException' => 'Maximale Anfragelimit für die Erstellung eines Zielereignisses erreicht',
                'LimitExceededException' => 'Instanzlimit für das angeforderte Zielereignis erreicht',
                'BadRequestException' => 'Ungültiges Zielereignis',
            ],
            'configuration_set_attributes' => [
                'NotFoundException' => 'Attribute der Konfiguration können nicht gesetzt werden, da die Konfiguration nicht gefunden wurde',
                'TooManyRequestsException' => 'Maximale Anfragelimit für das Setzen der Konfigurationsattribute erreicht',
                'BadRequestException' => 'Ungültige Konfigurationsattribute',
            ],
        ],
    ],

    'mail_channels' => [
        'fields' => [
            'host' => 'Host',
            'port' => 'Port',
            'username' => 'Benutzername',
            'password' => 'Passwort',
            'email_from' => 'Absender-E-Mail',
            'secure' => 'TLS\SSL',
            'domain_email' => 'Absenderdomain-E-Mail',
        ],
        'choices' => [
            'ssl' => 'SSL',
            'tls' => 'TLS',
        ],
        'errors' => [
            'missing_required_fields_for_verfication' => 'Erforderliche Felder zur Überprüfung des Versandkanals fehlen',
            'existing_ses_identity' => 'Vorhandene Absender-E-Mail',
        ],
        'channels_name' => [
            1 => 'SMTP',
            2 => 'Beddy - Postdienst',
        ],
    ],

    'meals' => [
        'breakfasts' => 'Frühstücke',
        'lunches' => 'Mittagessen',
        'dinners' => 'Abendessen',
        'note' => 'Notizen',
    ],

    'messages' => [
        'download_attachments' => 'Anhänge herunterladen',
    ],

    'newsletters_conditions' => [
        'errors' => [
            'validation_error' => 'Der übergebene Werttyp für die Funktion \':feature\' muss vom Typ \':type\' sein',
            'duplicate_condition_error' => 'Das Kriterium \':criteriaName\' ist bereits mit der Versandliste verknüpft',
            'limit_values_error' => 'Die Anzahl der übergebenen Parameter für die Funktion \':feature\' stimmt nicht mit dem maximal zulässigen Wert \':limitValues\' überein',
            'condition_not_found' => 'Keine Bedingung mit der Liste verknüpft gefunden',
            'option_relation_error' => 'Die ausgewählte Option mit der ID \':option\' ist für die Funktion \':feature\' nicht verfügbar',
            'unsuitable_condition_for_sending_list_category' => 'Das Kriterium \':criteriaName\' ist nicht mit dem Mailinglistentyp kompatibel',

        ],
    ],

    'newsletters_criteria' => [
        'field_translate' => [
            'country' => 'Land',
            'city' => 'Stadt',
            'county' => 'Bezirk',
            'state' => 'Region',
            'check_phone_number' => 'Müssen die Gäste ihre Telefonnummer angegeben haben?',
            'check_newsletter_consent' => 'Müssen die Nutzer der Newsletter-Zustimmung zugestimmt haben?',
            'check_newsletter_unsubscribe' => 'Benutzer, die sich von der Newsletter abgemeldet haben?',
            'language' => 'Sprache',
            'check_reservation_with_children' => 'Müssen die Gäste eine Buchung mit Kindern vorgenommen haben?',
            'addon' => 'Zusatzleistungen',
            'last_reservation_date' => 'Datum der letzten Buchung',
            'birthdays_date' => 'Geburtstagsdatum',
            'reservation_period_date' => 'Reservierungszeitraum',
            'reservation_stay_period_date' => 'Aufenthaltszeitraum',
            'guests_in_house' => 'Möchten Sie alle im Haus befindlichen Gäste auswählen?',
            'accommodation' => 'Unterkunftstyp',
            'channel' => 'Buchungskanal',
            'reservation_tag' => 'Tag',
            'category_addon' => 'Zusatzkategorie',
        ],
        'criteria_translate' => [
            'place' => 'Wohnort',
            'company_place' => 'Website',
            'phone_number' => 'Telefonnummer',
            'newsletter_consent' => 'Newsletter-Zustimmung',
            'newsletter_unsubscribed' => 'Von der Newsletter abgemeldet',
            'language' => 'Sprache',
            'reservation_with_children' => 'Reservierungen mit Kindern',
            'reservation_with_extra_services' => 'Mit einer bestimmten Zusatzleistung gebucht',
            'last_reservation_year' => 'Jahr der letzten Reservierung',
            'birthdays' => 'Geburtstage',
            'reservation_period' => 'Reservierungszeitraum',
            'reservation_stay_period' => 'Aufenthaltszeitraum',
            'customers_at_home' => 'Gäste im Haus',
            'type_of_room_booked' => 'Gebuchter Zimmertyp',
            'booking_portal' => 'Buchungsportal',
            'reservation_tag' => 'Tag',
            'addon_category' => 'Zusatzleistungskategorie',
        ],
        'field_translate_error' => [
            'country' => 'Land',
            'city' => 'Stadt',
            'county' => 'Bezirk',
            'state' => 'Region',
            'check_phone_number' => 'Telefonnummer erforderlich',
            'check_newsletter_consent' => 'Newsletter-Zustimmung erforderlich',
            'language' => 'Sprache',
            'check_reservation_with_children' => 'Reservierungen mit Kindern',
            'addon' => 'Zusatzleistungen',
            'last_reservation_date' => 'Jahr der letzten Reservierung',
            'birthdays_date' => 'Geburtstagsdatum',
            'reservation_period_date' => 'Reservierungszeitraum',
            'check_actual_reservations' => 'Aktuelle Gäste im Haus',
            'accommodation' => 'Gebuchter Zimmertyp',
            'channel' => 'Buchungskanal',
            'reservation_tag' => 'Tag',
        ],
    ],

    'newsletters' => [
        'unsubscribe_from_newsletter' => 'Von der Newsletter abmelden',
        'warnings' => [
            'cant_active' => 'Die Konfiguration wurde gespeichert, kann jedoch aus folgenden Gründen nicht aktiviert werden: :errors',
            'uneditable_channels' => 'Der Versandkanal einer Konfiguration kann nicht bearbeitet werden',
            'uneditable_options' => 'Der Versandkanal erlaubt keine Feldänderungen. Zum Ändern löschen und eine neue Konfiguration erstellen',
            'existing_configuration' => 'Es gibt bereits eine Konfiguration mit denselben Parametern',
            'cant_delete_pending_configuration' => 'Um diese ausstehende Konfiguration zu löschen, müssen Sie das Ende der Anfrage abwarten (24 Stunden nach der Anfrage)',
            'cant_delete_blocked_configuration' => 'Eine blockierte Konfiguration kann nicht gelöscht werden',
            'cant_delete_configuration' => 'Aufgrund technischer Probleme kann die Konfiguration momentan nicht gelöscht werden. Bitte versuchen Sie es später erneut',
            'cant_delete_configuration_with_newsletters' => 'Die Konfiguration kann nicht gelöscht werden, da sie mit folgenden noch nicht gesendeten oder geplanten Newslettern verknüpft ist: ',
            'cant_delete_sending_list' => 'Die ausgewählte Versandliste kann nicht gelöscht werden, da sie mit folgenden Newslettern verknüpft ist: :newslettersTitles',
        ],
        'errors' => [
            'configuration_not_active' => 'Der Absender wurde noch nicht verifiziert',
            'configuration_not_found' => 'Die ausgewählte Konfiguration ist nicht vorhanden',
            'configuration_not_expired' => 'Die Konfiguration kann nicht erneut überprüft werden, wenn sie nicht abgelaufen oder in der Bestätigung wartend ist',
            'missing_default_configuration' => 'Zum Erstellen des Newsletters ist eine aktive Standardkonfiguration erforderlich. Bitte überprüfen und erneut versuchen',
            'missing_default_locale' => 'Das HTML-Template in der Standardsprache ist nicht unter den gesendeten Templates vorhanden',
            'missing_newsletter' => 'Der ausgewählte Newsletter ist nicht vorhanden',
            'elaborated_newsletter' => 'Der ausgewählte Newsletter kann nicht geändert oder gelöscht werden, da er in Bearbeitung ist oder bereits gesendet wurde',
            'missing_newsletter_contact' => 'Der angeforderte Kontakt ist nicht vorhanden oder hat keine eingestellte E-Mail-Adresse',
            'sending_list_contact_not_valid' => 'Die folgenden Kontaktparameter sind ungültig: ',
            'contact_already_exclude' => 'Der Kontakt kann nicht hinzugefügt werden, da er bereits von der Versandliste ausgeschlossen wurde',
            'contact_already_exist' => 'Der Kontakt kann nicht hinzugefügt werden, da er bereits in der Versandliste vorhanden ist',
            'newsletter_in_processing' => 'Der Status des ausgewählten Newsletters kann nicht geändert werden, da er in Bearbeitung ist',
            'cant_update_sent_newsletter' => 'Der ausgewählte Newsletter kann nicht geändert werden, da er gesendet wurde. Er kann nur dupliziert und archiviert werden',
            'impossible_delete_attempted_newsletter' => 'Ein Newsletter mit bereits durchgeführten Sendungen kann nicht gelöscht werden',
            'newsletter_without_contacts' => 'Es wurden keine Kontakte in den ausgewählten Versandlisten gefunden. Ändern Sie die Bedingungen für die Kontaktaufnahme oder wählen Sie andere Listen aus.',
            'newsletter_task_in_error' => 'Allgemeiner Versandfehler. Duplizieren Sie die Kampagne und versuchen Sie den Versand in ein paar Minuten erneut.',
        ],
        'import' => [
            'validations' => [
                'email_required' => 'Das E-Mail-Feld ist erforderlich',
                'email_not_valid' => 'Das E-Mail-Feld enthält keine gültige E-Mail-Adresse',
            ],
        ],
    ],

    'odigeo' => [
        'exceptions' => [
            'configuration_missing' => 'Die für den Kanal :channelName erforderlichen Konfigurationsparameter sind in der Anfrage nicht vorhanden.',
            'configuration_not_valid' => 'Die folgenden Parameter sind ungültig: :params',
            'invalid_age_range' => 'Der Altersbereich für :field ist ungültig. Stellen Sie sicher, dass die Altersgruppen korrekt und in der richtigen Reihenfolge angegeben sind.',
        ],
    ],

    'pa_friuli_venezia_giulia' => [
        'accommodation_name' => 'Tipologia',
        'accommodation_tableau_name' => 'Unterkunft / Zimmer',
        'check_in' => 'Einchecken',
        'check_out' => 'Auschecken',
        'nights' => 'Nächte',
        'surname_and_name' => 'Nachname und Vorname',
        'date_of_birth' => 'Geburtsdatum',
        'citizenship' => 'Staatsangehörigkeit',
        'residence' => 'Wohnsitz',
    ],

    'payment_method' => [
        'fields' => [
            'model_name' => 'Zahlungsmethode',
        ],
        'paypal' => [
            'cannot_activate_paypal' => 'PayPal kann nicht aktiviert werden. Überprüfen Sie, ob die Felder Client-ID und Secret korrekt sind.',
        ],
        'nexi' => [
            'cannot_activate_nexi' => 'Nexi kann nicht aktiviert werden. Überprüfen Sie, ob die Felder Alias und MAC-Schlüssel korrekt sind.',
        ],
    ],

    'payments' => [
        'default_payment_email_body' => '<p>Sehr geehrte/r :name :surname,</p><p>im Anhang finden Sie das Dokument zu Ihrer Zahlung.</p>',
        'default_payment_email_subject' => 'Zahlungsbenachrichtigung',
        'cannot_complete_payment_due_to_gateway' => 'Das Zahlungsgateway konnte die Transaktion nicht erfolgreich abschließen.',
        'payment_order_cannot_be_completed_due_to_wrong_status' => 'Der Zahlungsstatus ist bereits abgeschlossen.',
        'payment_order_is_not_a_pre_authorization' => 'Diese Zahlung ist keine Vorautorisierung.',
        'cannot_complete_payment_gateway_requires_action' => 'Die Anfrage wurde erfolgreich gesendet. Sie erhalten eine Benachrichtigung, sobald die Zahlung erfolgt ist.',
        'payment' => 'Zahlung',
        'refund_payment' => 'Rückerstattung für die Zahlung von :customer_name :customer_surname am :payment_date',
        'checkinonline_created_order_citytax' => 'Bezahlung der Kurtaxe über den Online-Check-in',
        'pre_authorization_text' => 'Vorautorisierung',
        'email_payment_request' => [
            'subject' => 'Zahlungsanforderung von :propertyName',
            'message' => '<p>Sehr geehrte/r <strong>:name :surname</strong>,</p><p>für Ihre Reservierung mit der Nummer <strong>#:reference_number</strong> wurde die folgende Belastung angefordert.</p>',
            'message_without_reservation' => '<p>Sehr geehrte/r <strong>:name :surname</strong>, die folgende Belastung wurde angefordert.</p>',
            'confirm_payment' => 'Jetzt zahlen :amount',
        ],
        'email_pre_authorization_request' => [
            'subject' => 'Vorautorisierungsanforderung von :propertyName',
            'message' => '<p>Sehr geehrte/r <strong>:name :surname</strong></p><p>für Ihre Reservierung mit der Nummer <strong>#:reference_number</strong> wurde die folgende Vorautorisierung vorgenommen.</p>',
            'message_without_reservation' => '<p>Sehr geehrte/r <strong>:name :surname</strong>, die folgende Vorautorisierung wurde vorgenommen.</p>',
        ],
        'pre_authorization' => [
            'subject' => 'Vorautorisierung von :propertyName',
            'message' => '<p>Sehr geehrte/r <strong>:name :surname</strong>,</p><p>für Ihre Reservierung mit der Nummer <strong>#:reference_number</strong> wurde die folgende Vorautorisierung angefordert.</p>',
        ],
        'direct_charge' => [
            'subject' => 'Direktbelastung von :propertyName',
            'message' => '<p>Sehr geehrte/r <strong>:name :surname</strong></p><p>für Ihre Reservierung mit der Nummer <strong>#:reference_number</strong> wurde die folgende Belastung vorgenommen.</p>',
        ],
        'direct_charge_failed' => [
            'subject' => 'Direktbelastung von :propertyName fehlgeschlagen',
            'message' => '<p>Sehr geehrte/r <strong>:name :surname</strong></p><p>wir informieren Sie, dass wir heute versucht haben, die Belastung für die Reservierung <strong>#:reference_number</strong> vorzunehmen. Leider war dies nicht erfolgreich.</p>',
        ],
        'payment_order' => [
            'default_whatsapp_text' => 'Sehr geehrte/r :name :surname, für Ihre Reservierung mit der Nummer :reference_number wurde Ihnen eine Zahlungsanforderung für :type gesendet. Klicken Sie hier: :link',
        ],
        'customer_confirmed_payment_order_notification' => [
            'subject' => 'Zahlung von :amount von :customerName :customerSurname - :propertyName erhalten',
            'message' => 'Wir informieren Sie, dass :customerName :customerSurname die Zahlung von :amount für die Reservierung #:referenceNumber (:arrivalDate - :departureDate) - :propertyName geleistet hat.',
            'click_here_to_view' => 'Klicken Sie hier, um alle Reservierungsdetails anzuzeigen.',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'subject' => 'Der Kunde hat die Zahlung abgeschlossen',
            'message' => 'Wir informieren Sie, dass :customerName :customerSurname die Zahlung von :amount - :propertyName geleistet hat.',
        ],
        'pre_authorization_is_expiring' => [
            'subject' => 'Ihre Vorautorisierung läuft bald ab',
            'message' => 'Wir informieren Sie, dass :customerName :customerSurname die Vorautorisierung von :amount für die Reservierung #:referenceNumber (:arrivalDate - :departureDate) - :propertyName, die morgen abläuft, noch nicht autorisiert hat.',
            'message_without_reservation' => 'Wir informieren Sie, dass :customerName :customerSurname die Vorautorisierung von :amount - :propertyName, die morgen abläuft, noch nicht autorisiert hat.',
        ],
        'timetable' => [
            'title' => 'Geplante Zahlungen',
            'export_fields' => [
                'scheduled_date' => 'Zahlungsdatum',
                'booker' => 'Bucher',
                'reservation_total_price' => 'Gesamtsumme der Reservierung',
                'amount' => 'Geplante Zahlung',
                'reservation_arrival_date' => 'Ankunftsdatum',
                'reservation_departure_date' => 'Abreisedatum',
                'property' => 'Unterkunft',
                'sca_accepted' => 'SCA-Status',
            ],
            'sca_accepted' => 'Akzeptiert',
            'sca_not_accepted' => 'Nicht akzeptiert',
            'change_status_date_past' => 'Ein Zahlungsdatum in der Vergangenheit kann nicht geplant werden.',
            'no_credit_card_found' => 'Keine Kreditkarte in der Reservierung hinterlegt.',
            'required_action_3d' => 'Belastung fehlgeschlagen, 3D Secure-Authentifizierung erforderlich.',
            'required_action_requested_payment' => 'Zahlungsanforderung am :send_date gesendet - Ablaufdatum :expire_date.',
            'request_payment_wait_customer_expired' => 'Zahlungsanforderung abgelaufen.',
            'timetable_pause_expired' => 'Geplante Zahlungspause abgelaufen.',
            'force_payment_due_date' => 'Die Zahlung kann nur erzwungen werden, wenn das Zahlungsdatum dem heutigen Datum entspricht.',
            'reservation_cancelled' => 'Reservierung storniert.',
            'property_cancelled' => 'Unterkunft ausgesetzt, abgelaufen oder storniert.',
            'module_deactivated' => 'Das Modul Geplante Zahlungen wurde deaktiviert oder ist abgelaufen.',
            'charge_status_manual_change' => 'Zahlung geändert von :current_charge_status zu :new_charge_status.',
            'manual_payment_bound' => 'Manuelle Zahlung hinzugefügt.',
            'stripe_not_active' => 'Die Zahlungsmethode Stripe ist nicht aktiv.',
            'invoice_default_causal' => 'Zahlungsbelastung :payment_method_name am :date für die Reservierung :reservation_reference.',
            'delete_propery_has_payments' => 'Die Unterkunft hat aktive geplante Zahlungen. Durch das Fortfahren werden alle geplanten Zahlungen pausiert. Dieser Vorgang ist nicht umkehrbar.',
            'amount_over_to_pay' => 'Die Zahlung übersteigt den Gesamtbetrag der Reservierung.',
            'change_tax_payment_amount' => 'Zahlung der Kurtaxe geändert von :old_amount zu :new_amount.',
            'manual_payment_cancelled' => 'Manuelle Zahlung zuvor storniert.',
            'payment_refunded_created' => 'Rückerstattung von :currency_symbol :amount vorgenommen.',
            'payment_refunded_modified' => 'Rückerstattung geändert von :currency_symbol :old_amount zu :currency_symbol :new_amount.',
            'reservation_reconfirmed' => 'Reservierung erneut bestätigt.',
            'reservation_optionable' => 'Reservierung in Option.',
            'reservation_pending' => 'Reservierung in Wartestellung.',
            'payment_succeded' => 'Zahlung erfolgreich.',
            'charge_reminder_email_sent' => 'Erinnerungs-E-Mail zur Belastung gesendet.',
            'charge_reminder' => [
                'subject' => ':propertyName - Belastungserinnerung',
                'message' => 'Sehr geehrte/r :booker_name :booker_surname, 
            <br /><br />
            Am :date_today ist eine Belastung von :amount :currency_symbol gemäß den Zahlungsbedingungen vorgesehen. 
            <br /><br />  
            <strong><span style="color: #8f743f;">Reservierungsnummer #:reference_number vom :arrival_date bis :departure_date.</strong>',
            ],
        ],
        'errors' => [
            'conditions_with_conflicts' => 'Die übermittelten Bedingungen haben gleiche Belastungstage oder die Gesamtsumme der Belastungsprozentsätze übersteigt 100% des Betrags.',
            'payment_timetable_already_processed' => 'Die geplante Zahlung wurde bereits verarbeitet oder steht aus.',
            'payment_timetable_already_bound' => 'Die geplante Zahlung hat bereits eine Zahlung generiert.',
            'payment_timetable_attach_email_invoice_error' => 'Die angeforderte Rechnung konnte aufgrund des folgenden Fehlers nicht angehängt werden: :error_description.',
            'missing_policy' => 'Zahlungsrichtlinie für die Reservierung nicht gefunden.',
            'impossible_change_payment_method_id' => 'Die Zahlungsmethode für registrierte Zahlungen kann nicht geändert werden',
        ],
        'warnings' => [
            'no_restrictions_and_period_policy' => 'Die Zahlungsrichtlinie hat keine Einschränkungen und/oder Anwendungszeiträume und könnte mit anderen bestehenden Richtlinien in Konflikt geraten.',
            'no_restrictions_and_period_others' => 'Die Richtlinie :name hat keine Einschränkungen oder Anwendungszeiträume und könnte mit der aktuellen Richtlinie in Konflikt geraten.',
            'overlapping_period_for_restriction' => 'Die Richtlinie :name hat mindestens einen überlappenden Zeitraum mit einer gemeinsamen Einschränkung und könnte Konflikte verursachen.',
            'existing_restriction' => 'Die Richtlinie :name hat mindestens eine gemeinsame Einschränkung mit der aktuellen Richtlinie und könnte Konflikte verursachen.',
        ],
        'fields' => [
            'payment_agreement_id' => 'Zahlungsvereinbarungskennzeichen'
        ],
    ],

    'policy' => [
        'errors' => [
            'no_show_option_not_compatible' => 'No-Show-Optionen nicht kompatibel',
            'deposit_option_not_compatible' => 'Anzahlungsoptionen nicht kompatibel',
            'choose_deposit_pay' => 'Sie müssen angeben, wann die Belastung erfolgen soll',
            'condition_not_compatible' => 'Stornierungsbedingungen nicht kompatibel',
            'duplicate_penalty' => 'Doppelte Strafgebühren in den Stornierungsbedingungen',
            'no_show_condition_not_applicable' => 'Diese Bedingungen können nicht auf No-Show angewendet werden',
            'deposit_condition_not_applicable' => 'Diese Bedingungen können nicht auf die Anzahlung angewendet werden',
            'duplicate_penalty_deposit' => 'Doppelte Strafgebühren im Abschnitt Anzahlung',
            'no_condition_to_deposit' => 'Keine Bedingung für die Anzahlung angewendet',
            'policy_to_rateplan' => 'Richtlinie mit mindestens einem Tarifplan verknüpft',
            'delete_policy_default' => 'Standardrichtlinien können nicht gelöscht werden',
            'last_policy' => 'Die letzte Richtlinie der Unterkunft kann nicht gelöscht werden',
            'policy_not_allowed_in_period' => 'Ein Zeitraum kann nicht mit derselben Richtlinie wie der Tarifplan überschrieben werden.',
            'policy_period_overlapping' => 'Die Zeiträume für die Richtlinien überschneiden sich.',
            'check_priority_custom' => 'Prioritäten für die Richtlinie sind vorhanden. Bitte überprüfen.',
            'check_priority_and_period' => 'Prioritäten oder Zeiträume für die Richtlinie sind vorhanden.',
        ],
        'names' => [
            'standard' => 'Kostenlose Stornierung',
            'not_ref' => 'Nicht erstattungsfähig',
            'default_ota_name' => 'Siehe OTA',
            'default_ota_description' => 'Richtlinie nicht vom Kanal übermittelt',
            'hour_title_policy' => ' bis :hour Uhr am Anreisetag.',
            'nights' => 'Nacht|Nächte',
            'days' => 'Tag|Tage',
        ],
        'transform_to_date' => [
            'date_limit' => '<p>Sie können bis 23:59 Uhr am :date_limit kostenlos stornieren.</p>',
            'date_limit_percentage' => '<p>Wenn Sie bis :date_limit stornieren, wird Ihnen :penalty_value% des Gesamtkosten in Rechnung gestellt.</p>',
            'date_limit_nights' => '<p>Wenn Sie bis :date_limit stornieren, werden Ihnen die Kosten für :penalty_value Nächte berechnet.</p>',
            'date_limit_amount' => '<p>Wenn Sie bis :date_limit stornieren, wird Ihnen ein Betrag von :penalty_value :currency berechnet.</p>',
            'date_over_percentage' => '<p>Wenn Sie nach :date_limit stornieren, wird Ihnen :penalty_value% des Gesamtkosten in Rechnung gestellt.</p>',
            'date_over_nights' => '<p>Wenn Sie nach :date_limit stornieren, werden Ihnen die Kosten für :penalty_value Nächte berechnet.</p>',
            'date_over_amount' => '<p>Wenn Sie nach :date_limit stornieren, wird Ihnen ein Betrag von :penalty_value :currency berechnet.</p>',
            'date_over_percentage_hour' => '<p>Wenn Sie nach :hour_limit Uhr am :date_limit stornieren, wird Ihnen :penalty_value% des Gesamtkosten in Rechnung gestellt.</p>',
            'date_over_nights_hour' => '<p>Wenn Sie nach :hour_limit Uhr am :date_limit stornieren, werden Ihnen die Kosten für :penalty_value Nächte berechnet.</p>',
            'date_over_amount_hour' => '<p>Wenn Sie nach :hour_limit Uhr am :date_limit stornieren, wird Ihnen ein Betrag von :penalty_value :currency berechnet.</p>',
            'date_now_percentage' => '<p>Wenn Sie jetzt stornieren, wird Ihnen :penalty_value% des Gesamtkosten in Rechnung gestellt.</p>',
            'date_now_nights' => '<p>Wenn Sie jetzt stornieren, werden Ihnen die Kosten für :penalty_value Nächte berechnet.</p>',
            'date_now_amount' => '<p>Wenn Sie jetzt stornieren, wird Ihnen ein Betrag von :penalty_value :currency berechnet.</p>',
            'date_now_noshow_percentage' => '<p>Bei Nichterscheinen wird Ihnen :penalty_value% des Gesamtkosten in Rechnung gestellt.</p>',
            'date_now_noshow_nights' => '<p>Bei Nichterscheinen werden Ihnen die Kosten für :penalty_value Nächte berechnet.</p>',
            'date_now_noshow_amount' => '<p>Bei Nichterscheinen wird Ihnen ein Betrag von :penalty_value :currency berechnet.</p>',
        ],
        'transform_to_date_notref' => [
            'date_now_percentage' => '<p>Wenn Sie jederzeit nach der Buchung stornieren, wird Ihnen :penalty_value% des Gesamtkosten in Rechnung gestellt.</p>',
            'date_now_nights' => '<p>Wenn Sie jederzeit nach der Buchung stornieren, werden Ihnen die Kosten für :penalty_value Nächte berechnet.</p>',
            'date_now_amount' => '<p>Wenn Sie jederzeit nach der Buchung stornieren, wird Ihnen ein Betrag von :penalty_value :currency berechnet.</p>',
            'date_limit_percentage' => '<p>Wenn Sie bis :hour_limit Uhr am :date_limit stornieren, wird Ihnen :penalty_value% des Gesamtkosten in Rechnung gestellt.</p>',
            'date_limit_nights' => '<p>Wenn Sie bis :hour_limit Uhr am :date_limit stornieren, werden Ihnen die Kosten für :penalty_value Nächte berechnet.</p>',
            'date_limit_amount' => '<p>Wenn Sie bis :hour_limit Uhr am :date_limit stornieren, wird Ihnen ein Betrag von :penalty_value :currency berechnet.</p>',
            'date_now_deposit_percentage' => '<p>:penalty_value% der Gesamtkosten werden zum Zeitpunkt der Buchung berechnet.</p>',
            'date_now_deposit_nights' => '<p>Die Kosten für :penalty_value Nächte werden zum Zeitpunkt der Buchung berechnet.</p>',
            'date_now_deposit_amount' => '<p>Ein Betrag von :penalty_value :currency wird zum Zeitpunkt der Buchung berechnet.</p>',
            'date_now_noshow_percentage' => '<p>Bei Nichterscheinen wird Ihnen :penalty_value% des Gesamtkosten in Rechnung gestellt.</p>',
            'date_now_noshow_nights' => '<p>Bei Nichterscheinen werden Ihnen die Kosten für :penalty_value Nächte berechnet.</p>',
            'date_now_noshow_amount' => '<p>Bei Nichterscheinen wird Ihnen ein Betrag von :penalty_value :currency berechnet.</p>',
        ],
    ],

    'property_report' => [
        'property' => [
            'label' => 'Unterkunft',
            'description' => 'Diese Option ermöglicht es Ihnen, die Daten der Unterkunft zu exportieren',
        ],
        'children_ranges' => [
            'label' => 'Kinderaltersgruppen',
            'description' => 'Diese Option ermöglicht es Ihnen, die Altersgruppen der Kinder zu exportieren',
        ],
        'accommodations' => [
            'label' => 'Unterkünfte',
            'description' => 'Diese Option ermöglicht es Ihnen, die Unterkünfte mit den entsprechenden Details zu exportieren',
        ],
        'treatments' => [
            'label' => 'Behandlungen',
            'description' => 'Diese Option ermöglicht es Ihnen, die Behandlungen zu exportieren',
        ],
        'policies' => [
            'label' => 'Stornierungsrichtlinien',
            'description' => 'Diese Option ermöglicht es Ihnen, die Stornierungsbedingungen zu exportieren',
            'addons_to_deposit' => [
                'included' => 'Zusatzleistungen inklusive',
                'not_included' => 'Zusatzleistungen nicht im Berechnungsumfang enthalten',
            ],
        ],
        'rate_plans' => [
            'label' => 'Tarifpläne',
            'description' => 'Diese Option ermöglicht es Ihnen, die Tarifpläne zu exportieren',
        ],
        'invoice_layouts' => [
            'label' => 'Rechnungsprofile',
            'description' => 'Diese Option ermöglicht es Ihnen, die Rechnungsprofile zu exportieren',
        ],
        'city_tax' => [
            'label' => 'Kurtaxe',
            'description' => 'Diese Option ermöglicht es Ihnen, die Konfiguration der Kurtaxe zu exportieren',
            'active' => 'Aktiv',
            'not_active' => 'Nicht aktiv',
        ],
        'payments_method' => [
            'label' => 'Zahlungsmethoden',
            'description' => 'Diese Option ermöglicht es Ihnen, die Konfiguration der Zahlungsmethoden zu exportieren',
            'day' => '{0,1} Tag|[2,*] Tage',
        ],
    ],

    'property' => [
        'errors' => [
            'already_attached' => 'Anhang bereits vorhanden',
            'property_has_another_master' => 'Die Unterkunft hat bereits einen Hauptbenutzer. Um fortzufahren, entfernen Sie die bestehende Zuordnung zwischen diesem und der Unterkunft',
            'letti_extra_exception_delete' => 'Dieses Zusatzbett kann nicht gelöscht werden, da zuerst die Nummer :lettimax entfernt werden muss. Sie haben jedoch die Nummer :lettimin geändert.',
            'letti_extra_exception_missing' => 'Einige Elemente fehlen',
            'override_periods_policy' => 'Überlappende Zeiträume',
            'place_not_found' => 'Ort nicht gefunden',
            'not_group_owner' => 'Sie sind nicht der Eigentümer dieser Gruppe',
            'group_is_default' => 'Die Standardgruppe kann nicht entfernt werden',
            'already_in' => 'Unterkunft ist bereits in der Gruppe vorhanden, Aktion nicht möglich',
            'already_all_in' => 'Unterkunft ist bereits in einer Ihrer Gruppen vorhanden, Aktion nicht möglich',
            'not_in_group' => 'Unterkunft ist in keiner Gruppe enthalten',
            'existing_extra_bed_setting' => 'Vorhandene Zusatzbetteinstellung',
            'missing_extra_bed_setting' => 'Fehlende Zusatzbetteinstellung für diese Konfiguration',
            'overcoming_extra_bed' => 'Zusatzbett übersteigt die bestehende Zimmerkonfiguration',
            'role_conflict' => 'Die Rolle existiert bereits',
            'cant_detach_default_group' => 'Die Unterkunft kann nicht von der Standardgruppe getrennt werden',
            'groups_have_properties' => 'Diese Gruppe kann nicht gelöscht werden, da Unterkünfte vorhanden sind',
            'uneditable_expense_category' => 'Ausgabenkategorie kann nicht bearbeitet werden',
            'expenses_pending' => 'Ausgabenkategorie kann nicht gelöscht werden, da damit verbundene Ausgaben vorhanden sind',
            'missing_vat_quotes' => 'Achtung! Das ausgewählte Land hat keine festgelegten Mehrwertsteuersätze. Bitte konfigurieren Sie diese, bevor Sie fortfahren.',
            'cutoff_rules_exist' => 'Cutoff-Regel bereits vorhanden.',
            'missing_lat_lon' => 'Es wurden keine Koordinaten (LAT oder LON) für diese Unterkunft festgelegt',
            'undetachable_layout' => 'Dieses Profil kann nicht getrennt werden, wenn kein weiteres Profil damit verbunden ist',
            'customer_not_belonging_to_property_group' => 'Der Kunde :customer_id gehört nicht zur Unterkunftsgruppe oder existiert nicht',
            'update_expiration_bulk' => 'Fehler beim Aktualisieren der Ablaufdaten',
            'update_cancellation_bulk' => 'Fehler beim Aktualisieren des Stornierungsstatus',
            'update_activation_bulk' => 'Fehler beim Aktualisieren des Aktivierungs-/Deaktivierungsstatus',
            'unauthorized_access' => 'Sie sind nicht berechtigt, auf diese Ressource zuzugreifen.',
            'unauthorized_insolvent_status' => 'Sein Konto wurde aufgrund eines Zahlungsausfalls gesperrt. Daher bitten wir Sie, an "zucchettihospitality.gestione.crediti@zucchetti.it" zu schreiben, um Ihre Buchhaltungssituation zu klären.'
        ],
        'warnings' => [
            'request_confirm_change_discount_type' => 'Das Ändern des Rabatttyps führt zur Löschung aller benutzerdefinierten Konfigurationen. Fortfahren?',
            'request_confirm_delete_extra_bed' => 'Das Löschen dieses Zusatzbettes führt zur Entfernung höherer Zusatzbetten. Fortfahren?',
            'invalid_facility' => 'Nicht kompatible Einrichtung',
            'disabled_update' => 'Der Kanal :channel_name ist nicht zur Übermittlung von Daten aktiviert',
            'nothing_to_update' => 'Keine Daten zum Senden an :channel',
            'missing_invoice_layout_without_vat_code_with_all_inclusive_tax_enabled' => 'Achtung! Die aktivierte Unterkunft hat kein Rechnungsprofil, das für die Ausstellung der Pauschalsteuer geeignet ist',
            'properties_has_not_istat_module' => 'Die Unterkunft :property_name hat das ISTAT-Modul nicht aktiviert',
            'update_overcome_days' => 'Die folgenden Daten wurden nicht aktualisiert, da sie die maximal zulässigen Tage überschreiten: :dates',
            'download_overcome_days' => 'Für die folgenden Daten wurden keine Daten heruntergeladen, da sie die maximal zulässigen Tage überschreiten: :dates',
            'missing_property_xml_id' => 'Achtung! Die property_xml_id wurde in den Einstellungen des Kanals :channel_name nicht angegeben',
        ],
        'city_tax' => [
            'main_report_title' => 'Zusammenfassung der Kurtaxe',
            'recap_city_tax_totals' => 'Gesamtübersicht der Kurtaxe',
            'exemptions' => 'Befreiungen',
            'limit_nights' => 'Nächtelimit',
            'total_guests' => 'Gesamte Gäste',
            'totals' => 'Gesamtbeträge',
            'total_taxed_guests' => 'Besteuerte Gäste',
            'total_exempted_guests' => 'Befreite Gäste',
            'exemption_details' => 'Details zu Befreiungen',
            'taxed_details' => 'Details zu besteuerten Gästen',
            'taxed_details_ranges' => 'Von :min bis :max Jahren',
            'exemptions_over' => 'Befreite über das Limit hinaus',
            'guests_over' => 'Zahlende über das Limit hinaus',
            'guests' => 'Gäste',
            'city_tax_amount' => 'Gesamtkurtaxe',
            'all_properties' => 'Alle Unterkünfte',
            'from_to_age_ranges' => 'Von :min_age bis :max_age Jahren',
            'taxed_nights' => 'Nächte von besteuerten Gästen',
        ],
        'commissions' => [
            'period_exists' => 'Zeitraum bereits vorhanden',
            'invalid_period' => 'Ungültiger Zeitraum',
            'season_too_long' => 'Saisonintervall ist zu lang',
        ],
        'list' => 'Unterkunftsliste',
        'export_fields' => [
            'id' => 'ID',
            'name' => 'Name',
            'group' => 'Gruppe',
            'address' => 'Adresse',
            'city' => 'Stadt',
            'state' => 'Bundesland',
            'county' => 'Bezirk',
            'country' => 'Land',
            'zip_code' => 'Postleitzahl',
            'type' => 'Typ',
            'email' => 'E-Mail',
            'telephone' => 'Telefon',
            'reference_name' => 'Ansprechpartner Vorname',
            'reference_surname' => 'Ansprechpartner Nachname',
            'reference' => 'Ansprechpartner',
            'modules' => 'Module',
            'activated_date' => 'Aktivierungsdatum',
            'expire_date' => 'Ablaufdatum',
            'status' => 'Status',
            'user_first_name' => 'Eigentümer Vorname',
            'user_last_name' => 'Eigentümer Nachname',
            'user' => 'Eigentümer',
            'user_email' => 'Eigentümer E-Mail',
            'resellers' => 'Wiederverkäufer',
            'business_name' => 'Geschäftsname',
            'vat_number' => 'Umsatzsteuer-ID',
            'fiscal_code' => 'Steuer-ID',
            'properties_modules' => 'Unterkunftsmodule',
            'accommodations' => 'Unterkünfte',
            'quantity' => 'Menge',
            'contacts' => 'Kontakte',
        ],
        'initials_name' => [
            'booking-engine' => 'BE',
            'channel-manager' => 'CM',
            'rate-checker' => 'RC',
            'brand-protection' => 'BP',
            'google-ads' => 'GA',
            'google-commission' => 'GC',
            'tripadvisor-istant-booking' => 'TIB',
            'trivago-fast-connect' => 'TFC',
            'booking-engine-quotes' => 'BEQ',
            'guests-reporting' => 'GR',
            'pms' => 'PMS',
            'newsletter' => 'CRM',
            'automatic-payments' => 'AP',
        ],
        'clone' => [
            'cloning-job-scheduled' => 'Die Klonung wird in Kürze durchgeführt. Bitte prüfen Sie in ein paar Minuten.',
        ],
        'not_found' => 'Die folgenden IDs existieren nicht: ',
        'log'  => [
            'property_module_enabled' => 'Modul der Immobilie aktiviert',
            'property_module_disabled' => 'Modul der Immobilie deaktiviert',
            'beddy_channel_disabled' => 'Beddy-Kanal deaktiviert',
            'beddy_channel_enabled' => 'Beddy-Kanal aktiviert',
            'property_disactivated' => 'Immobilie deaktiviert',
            'property_activated' => 'Immobilie aktiviert',
            'property_cancelled' => 'Stornierung für die Immobilie registriert',
            'property_cancellation_reversed' => 'Stornierungsrücknahme für die Immobilie registriert',
            'property_update_expiration_date' => 'Vertragsablauf der Immobilie aktualisiert',
        ],
        'treatment' => [
            'log' => [
                'attach' => 'Die Behandlung :treatment_name wurde den Unterkünften :property_names mit einem Preisaufschlag von :supplement_price und einer Preisänderung von :share_price zugewiesen. :children_detail :apply_past',
                'children_detail' => ' Für die Altersgruppe :age_range wurde ein Aufpreis von :supplement_price und eine Preisänderung von :share_price festgelegt.',
                'apply_past' => ' Die Konfiguration wurde auf Buchungen angewendet, die zwischen dem :from und dem :to vorgenommen wurden.',
                'detach' => 'Die Behandlung :treatment_name wurde von der Unterkunft :property_name entfernt.',
                'update' => 'Die Behandlung :treatment_name wurde geändert mit einem Aufpreis von :supplement_price und einer Preisänderung von :share_price. :children_detail :children_delete :detail_delete',
                'detail_delete' => 'Die Preisänderung wurde auf null gesetzt, daher wurden alle zuvor zugewiesenen Details gelöscht.',
            ],
        ],


    ],

    'push_notifications' => [
        'multiple_sessions' => [
            'title' => 'Sicherheitswarnung: Mehrere Geräte mit Ihrem Konto verbunden',
            'message' => 'Verbindungen von mehreren Geräten zu Ihrem Konto wurden festgestellt. Bitte überprüfen Sie Ihre derzeit aktiven Sitzungen.',
        ],
        'reservation_new' => [
            'title' => 'Neue Buchung von :channel_name (:name_surname).',
            'message' => ':name_surname hat die Unterkunft :accommodation_name der Einrichtung :property_name vom :arrival_date bis :departure_date gebucht.',
        ],
        'reservation_modified' => [
            'title' => 'Buchungsänderung von :name :surname über :channel_name.',
            'message' => 'Die Buchung von :name :surname vom :arrival_date bis :departure_date für die Unterkunft :accommodation_name der Einrichtung :property_name wurde geändert.',
        ],
        'reservation_cancelled' => [
            'title' => 'Buchung von :name :surname über :channel_name storniert.',
            'message' => 'Die Buchung von :name :surname vom :arrival_date bis :departure_date der Einrichtung :property_name wurde storniert.',
        ],
        'reservation_banktransfer_cancelled' => [
            'title' => 'Buchung von :name :surname über :channel_name wegen Nichtzahlung storniert.',
            'message' => 'Die Buchung von :name :surname vom :arrival_date bis :departure_date der Einrichtung :property_name wurde automatisch storniert.',
        ],
        'invoice_rejected' => [
            'title' => 'Rechnung :number_complete von :name :surname wurde vom SDI abgelehnt.',
            'message' => 'Die Rechnung :number_complete von :name :surname wurde mit folgender Begründung abgelehnt: :rejected_reason.',
        ],
        'invoice_received' => [
            'title' => 'Rechnung von :sender_name erhalten.',
            'message' => 'Die Rechnung Nummer :document_number vom :document_date von :sender_name wurde empfangen.',
        ],
        'checkin_online_complete' => [
            'title' => 'Online-Check-in abgeschlossen (:name :surname).',
            'message' => 'Der Kunde :name :surname hat den Online-Check-in für die Buchung vom :arrival_date bis :departure_date der Unterkunft :accommodation_name der Einrichtung :property_name abgeschlossen.',
        ],
        'reservation_quote_expired' => [
            'title' => 'Angebot abgelaufen :name :surname.',
            'message' => 'Das Angebot von :name :surname, erstellt am :created_date, ist abgelaufen.',
        ],
        'housekeeper_maintainer' => [
            'title' => 'Neue Wartungsmeldung für die Unterkunft :accommodation_name.',
            'message' => 'Eine neue Wartungsmeldung für die Unterkunft :tableau_label wurde hinzugefügt. :title - :description.',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'title' => 'Änderung des Reinigungsstatus für die Unterkunft :cleanable_name - :accommodation_name.',
            'message' => ':user_name hat den Reinigungsstatus auf :clean_status am :reference_date für die Unterkunft :cleanable_name (:accommodation_name) der Einrichtung :property_name geändert.',
        ],
        'reservation_option_expired' => [
            'title' => 'Optionale Buchung abgelaufen (:name :surname).',
            'message' => 'Die Option für die Buchung von :name :surname vom :arrival_date bis :departure_date für die Unterkunft :accommodation_name der Einrichtung :property_name ist abgelaufen.',
        ],
        'order_payment_release' => [
            'subject' => 'Zahlungsvorautorisierung freigegeben (:name :surname).',
            'body' => 'Die Zahlungsvorautorisierung für die Buchung von :name :surname vom :arrival_date bis :departure_date der Einrichtung :property_name wurde freigegeben.',
        ],
        'sca_authorized' => [
            'title' => 'SCA-Modul von :name :surname bestätigt.',
            'message' => 'Der Kunde :name :surname hat das SCA-Modul am :accepted_date von der IP-Adresse :ip_address bestätigt.',
        ],
        'customer_confirmed_payment_order_notification' => [
            'title' => 'Neue Zahlung von :name :surname erhalten.',
            'message' => 'Der Kunde :name :surname hat eine Zahlung von :amount für die Buchung vom :arrival_date bis :departure_date der Einrichtung :property_name vorgenommen.',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'title' => 'Neue Zahlung von :name :surname erhalten.',
            'message' => 'Der Kunde :name :surname hat eine Zahlung von :amount vorgenommen.',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => 'Keine Verfügbarkeit mehr für die Unterkunft :accommodation_name der Einrichtung :property_name.',
            'body' => 'Die Verfügbarkeit für :accommodation_name an den folgenden Daten ist erschöpft: :days.',
        ],
        'reservation_queue_complete' => [
            'subject' => 'Buchung :name :surname bearbeitet.',
            'body' => 'Die Buchung für den Kunden :name :surname wurde erfolgreich bearbeitet.',
        ],
        'guests_reporting' => [
            'subject' => 'Versand von Gästemeldescheinen - :alloggiatiweb_group_label.',
            'success' => '1 Meldeschein erfolgreich gesendet|:number Meldescheine erfolgreich gesendet.',
            'error' => '1 Meldeschein nicht gesendet|:number Meldescheine nicht gesendet :errorMessage.',
        ],
        'quote_request' => [
            'subject' => 'Neue Angebotsanfrage.',
            'message' => ':customer_name :customer_surname hat soeben eine Angebotsanfrage für Ihre Einrichtung gestellt.',
        ],
        'treatment_price_update' => [
            'subject' => 'Behandlungsstatistiken aktualisiert - :property_name.',
            'message' => 'Die Neuberechnung mit aktualisierten Werten vom :start_date bis :end_date für die Behandlung :treatment_name wurde abgeschlossen.',
        ],
        'queue_past_reservations_task_record_summary' => [
            'subject' => 'Zusammenfassung der Aufgabe für vergangene Buchungen - :property_name (:property_id) Kanal :channel_name (:channel_id).',
            'message' => ':reservations_elaborated vergangene Buchungen von insgesamt :reservations_total wurden bearbeitet. :reservations_require_action Buchungen erfordern Maßnahmen Ihrerseits.',
        ],
        'queue_past_reservations_task_error' => [
            'subject' => 'Fehler bei der Aufgabe für vergangene Buchungen - :property_name (:property_id) Kanal :channel_name (:channel_id).',
            'message' => 'Während der Bearbeitung der Warteschlange vergangener Buchungen ist ein Fehler aufgetreten. Fehlermeldung: :error_description.',
        ],
        'reservation_message_received' => [
            'title' => 'Neue Nachricht von :senderName (#:reference).',
        ],
        'conversation_message_send_failed' => [
            'title' => 'Nachricht konnte nicht gesendet werden.',
            'message' => 'Die Nachricht an :recipientName wurde nicht zugestellt.',
        ],
        'urmet_sclak_error_generate_key' => [
            'title' => 'Fehler bei der Schlüsselerstellung für die Buchung :booker_name :booker_surname (#ID: :reference_number).',
            'message' => 'Bei Sclak ist ein Fehler bei der Erstellung der Zimmerschlüssel aufgetreten: :errors. Versuchen Sie es manuell erneut, und wenden Sie sich bei weiteren Problemen an den Urmet-Support.',
        ],
        'nuki_error_generate_key' => [
            'title' => 'Fehler bei der PIN-Erstellung für die Buchung :booker_name :booker_surname (#ID: :reference_number).',
            'message' => 'Bei Nuki ist ein Fehler bei der Erstellung der Zimmer-PIN aufgetreten: :errors. Versuchen Sie es manuell erneut, und wenden Sie sich bei weiteren Problemen an den Nuki-Support.',
        ],
        'urmet_sclak_error_sending_sms' => [
            'title' => 'Fehler beim Senden der SMS für die Schlüssel der Buchung :booker_name :booker_surname (#ID: :reference_number).',
            'message' => 'Die Sclak-SMS konnte aufgrund eines Fehlers nicht gesendet werden. Wir empfehlen, sich an den Urmet-Support zu wenden.',
        ],
        'single_property_export_completed' => [
            'title' => 'Export :exportProviderName abgeschlossen.',
            'message' => 'Die Datei :fileName ist bereit zum Herunterladen.',
        ],
        'single_property_export_not_completed' => [
            'title' => 'Export :exportProviderName fehlgeschlagen.',
            'message' => 'Der Export, der am :date um :time durchgeführt wurde, war nicht erfolgreich.',
        ],
        'multi_property_export_completed' => [
            'title' => 'Export :exportProviderName abgeschlossen.',
            'message' => 'Die Datei :fileName ist bereit zum Herunterladen.',
        ],
        'multi_property_export_not_completed' => [
            'title' => 'Export :exportProviderName fehlgeschlagen.',
            'message' => 'Der Export, der am :date um :time durchgeführt wurde, war nicht erfolgreich.',
        ],
        'newsletter_sent' => [
            'title' => 'Bestätigung des Newsletter-Versands.',
            'message' => 'Der Newsletter :newsletterName wurde erfolgreich gesendet.',
        ],
        'newsletter_not_sent' => [
            'title' => 'Fehler beim Senden des Newsletters.',
            'message' => 'Der Newsletter „:newsletterName“ konnte aufgrund folgender Fehler nicht gesendet werden: :errorMessage.',
        ],
        'newsletter_exceeded_sent_limit' => [
            'title' => 'Monatliches Sendelimit überschritten.',
            'message' => 'Der Newsletter :newsletterName wurde nicht gesendet, da das monatliche Sendelimit für E-Mails überschritten wurde.',
        ],
        'remote_door_key_service_reservation_resumed' => [
            'title' => 'Änderungen an Buchungen, neue Schlüssel generieren.',
            'message' => 'Für die Buchung von <b>:booker_name :booker_surname - :reference_number</b> in der Einrichtung <b>:property_name</b> muss ein neuer Schlüssel generiert werden.',
        ],
        'remote_door_key_service_reservation_moved' => [
            'title' => 'Eine oder mehrere Unterkünfte wurden verschoben. Ein neuer Schlüssel muss generiert werden.',
            'message' => 'Eine oder mehrere Unterkünfte der Buchung von <b>:booker_name :booker_surname - :reference_number</b> in der Einrichtung <b>:property_name</b> wurden verschoben. Ein neuer Schlüssel muss generiert werden.',
        ],
        'send_city_tax_report' => [
            'title' => 'Bestätigung des Versands des Aufenthaltssteuerberichts.',
            'message' => 'Der Versand des Berichts zur Aufenthaltssteuer für den Kanal :channelName wurde erfolgreich durchgeführt.',
        ],
        'send_city_tax_report_not_completed' => [
            'title' => 'Fehler beim Versenden des Aufenthaltssteuerberichts.',
            'message' => 'Der Bericht zur Aufenthaltssteuer für den Kanal :channelName konnte nicht gesendet werden.',
        ],
        'export_city_tax_report' => [
            'title' => 'Der Export des Berichts zur Aufenthaltssteuer für den Kanal :channelName ist bereit.',
            'message' => 'Klicken Sie auf die Benachrichtigung, um zur Exporthistorie weitergeleitet zu werden.',
        ],
        'export_city_tax_report_not_completed' => [
            'title' => 'Der Export des Berichts zur Aufenthaltssteuer für den Kanal :channelName konnte nicht abgeschlossen werden.',
            'message' => 'Die Generierung des Berichts :reportId war nicht erfolgreich.',
        ],
        'guest_attributes_missing_in_city_tax_report' => [
            'title' => 'Fehler beim Versand/Export des Aufenthaltssteuerberichts.',
        ],
        'empty_city_tax_report' => [
            'title' => 'Fehler beim Versand/Export des Berichts zur Aufenthaltssteuer für den Kanal :channelName.',
            'message' => 'Der Bericht zur Aufenthaltssteuer konnte nicht erstellt werden, da im ausgewählten Zeitraum keine Gäste für den Kanal erfasst wurden.',
        ],
        'accommodation_deleted' => [
            'title' => 'Aktion erforderlich.',
            'message' => 'Die Anzahl der verfügbaren Einheiten für die Unterkunft :accommodationName in der Einrichtung :propertyName wurde reduziert. Um Überbuchungen zu vermeiden, müssen die Verfügbarkeiten zurückgesetzt werden.',
        ],
        'payment_timetable_stripe_not_active' => [
            'title' => 'Automatische Zahlung fehlgeschlagen - Stripe nicht aktiv.',
            'message' => 'Die automatische Zahlung konnte nicht durchgeführt werden, da kein aktives Stripe-Konto vorhanden ist.',
        ],
        'payment_timetable_charge_failed' => [
            'title' => 'Automatische Zahlung fehlgeschlagen.',
            'message' => 'Die automatische Zahlung konnte nicht durchgeführt werden. Grund: :error_description.',
        ],
        'payment_timetable_no_credit_card' => [
            'title' => 'Automatische Zahlung fehlgeschlagen - Keine Kreditkarte vorhanden.',
            'message' => 'Die automatische Zahlung konnte nicht durchgeführt werden, da keine Kreditkarte hinterlegt ist.',
        ],
        'payment_timetable_exceeded' => [
            'title' => 'Automatische Zahlung fehlgeschlagen - Betrag übersteigt den Buchungstotal.',
            'message' => 'Die automatische Zahlung konnte nicht durchgeführt werden, da der Betrag den ausstehenden Teil der Buchung übersteigt.',
        ],
        'guest_atrtributes_missing_in_city_tax_report' => [
            'title' => 'Errore invio/esportazione report tasse di soggiorno',
        ],
        'payment_timetable_require_action' => [
            'subject' => 'Automatische Zahlung fehlgeschlagen - 3D Secure erforderlich',
            'message' => 'Die automatische Abbuchung ist wegen einer 3D-Secure-Anforderung fehlgeschlagen (ID: :payment_timetable_id, am :scheduled_date - Buchung :reservation_reference_number auf den Namen von :booker_name :booker_surname).',
        ],
        'payment_timetable_require_action_send_request' => [
            'subject' => 'Automatische Zahlung fehlgeschlagen - Anfrage an den Kunden gesendet',
            'message' => "Die automatische Abbuchung ist wegen einer 3D-Secure-Anforderung fehlgeschlagen (ID: :payment_timetable_id, am :scheduled_date - Buchung :reservation_reference_number auf den Namen von :booker_name :booker_surname).\nEine Zahlungsanfrage wurde per E-Mail an den Kunden gesendet.",
        ],
    ],

    'quote_request' => [
        'email' => [
            'subject' => 'Angebotsanfrage für :property_name - :customer_name :customer_surname (:arrival_date - :departure_date)',
            'quote_request_confermation' => 'Sehr geehrte/r <b>:property_name</b>,<br></br>
            <b>:customer_name :customer_surname</b> hat soeben eine Angebotsanfrage für Ihre Einrichtung gestellt.',
            'summary_request' => 'Zusammenfassung der Anfrage:',
            'stay' => 'Aufenthalt',
            'name_surname' => 'Vorname und Nachname',
            'telephone' => 'Telefon',
            'email' => 'E-Mail',
            'from' => 'Ankunft',
            'to' => 'Abreise',
            'alternative_dates' => 'Verfügbar an alternativen Daten',
            'alternative_beds' => 'Verfügbar an anderen Bettoptionen',
            'yes' => 'Ja',
            'no' => 'Nein',
            'accommodation' => 'Unterkunft',
            'accommodations' => 'Unterkünfte',
            'night' => 'Nacht',
            'nights' => 'Nächte',
            'adults' => 'Erwachsene',
            'children' => 'Kinder',
            'eta_children' => 'Kinderalter',
            'button' => 'Klicken Sie hier, um die Anfrage anzuzeigen',
        ],
        'email_customer' => [
            'subject' => 'Danke für Ihre Anfrage, :customer_name!',
            'message' => 'Danke <b>:customer_name</b>,<br></br>Ihre Angebotsanfrage wurde erfolgreich gesendet. Wir werden Sie so schnell wie möglich kontaktieren.',
        ],
    ],

    'rateplans' => [
        'errors' => [
            'max_day_update' => 'Dieser Tarif kann nicht gelöscht werden, da verbundene Kanäle vorhanden sind.',
            'insert_periods_plan' => 'Zeiträume können nicht in einen Tarifplan eingefügt werden.',
            'uneditable_rateplan' => 'Der Quell-Tarifplan ist nicht bearbeitbar.',
            'source_not_found' => 'Auf dem Zimmer ist kein Quell-Tarif vorhanden.',
            'detach_accommodations_channels' => 'Dieser Tarif kann nicht gelöscht werden, da verbundene Kanäle vorhanden sind.',
            'multi_property_not_permitted' => 'Es ist nicht erlaubt, Tarife für mehr als eine Einrichtung gleichzeitig zu erstellen oder zu ändern.',
            'rules_present_cannot_update' => 'Die angeforderte Änderung kann nicht durchgeführt werden, da diesem Tarifplan aktive Regeln zugeordnet sind.',
        ],
        'warnings' => [
            'missing_set_rules' => 'Einige Quellkanäle konnten die Regeln für bestehende Tarifpläne auf Zielkanäle nicht festlegen.',
        ],
        'conflicts' => [
            'unsuitable_conditions' => 'Die Werte für die Bedingung :condition_from sind nicht kompatibel mit denen für die Bedingung :condition_to.',
            'conditions_not_formatted' => 'Bedingungen sind nicht korrekt formatiert, ID fehlt.',
        ],
        'export_fields' => [
            'name' => 'Name',
            'policy' => 'Rückerstattungsrichtlinien',
            'periods' => 'Zeiträume und Gültigkeitstage',
            'accommodations' => 'Unterkünfte',
        ],
    ],

    'rates' => [
        'errors' => [
            'max_day_update' => 'Es ist nicht möglich, einen Zeitraum von mehr als einem Jahr zu aktualisieren.',
            'no_rooms_to_clone' => 'Es können keine Zimmer geklont werden.',
            'no_rooms_to_clone_source' => 'Eins oder mehrere Zimmer/Tarife sind im Quellkanal nicht vorhanden.',
            'no_rooms_to_clone_destination' => 'Eins oder mehrere Zimmer/Tarife sind im Zielkanal nicht vorhanden.',
            'same_channel_to_clone' => 'Es ist nicht möglich, einen Kanal auf sich selbst zu klonen.',
            'no_date_valid' => 'Kein Datum zum Aktualisieren.',
            'max_availability_exceeded' => 'Der eingegebene Verfügbarkeitswert überschreitet den zulässigen Wert laut der Konfiguration der Unterkunft. Der Wert wurde auf den maximal zulässigen Wert angepasst.',
            'anti_overbooking_bloccante' => 'Achtung: Der Verfügbarkeitswert, den Sie eintragen möchten, überschreitet die Anzahl der verkaufbaren Zimmer. Es besteht das Risiko von Überbuchungen.',
            'channel_update_error' => 'Die Aktualisierung des Portals war nicht erfolgreich. Konsultieren Sie die <b>Update-Protokolle</b> für weitere Informationen.',
            'period_over_limit' => 'Der Zeitraum von :dateFrom bis :dateTo überschreitet das maximal zulässige Limit.',
        ],
        'warnings' => [
            'past_period' => 'Der ausgewählte Zeitraum liegt in der Vergangenheit.',
            'past_today_adjustment' => 'Das Startdatum wurde auf das heutige Datum angepasst.',
            'period_adjustment_limit' => 'Das Enddatum wurde an das maximal zulässige Limit angepasst. (:dateTo)',
            'channel_not_connected' => 'Die Unterkunft ist nicht mit dem Kanal :channel_name verbunden.',
            'anti_overbooking' => 'Achtung: Der Verfügbarkeitswert, den Sie eintragen möchten, überschreitet die Anzahl der verkaufbaren Zimmer. Es besteht das Risiko von Überbuchungen.',
            'missing_association' => 'Das Zimmer ist nicht mit dem Kanal :channel_name verbunden.',
            'identical_update' => 'Ein identisches Update ist noch im Gange, bitte versuchen Sie es später noch einmal.',
            'rate_copy_not_found' => 'Es gibt keine Daten, die für den vergangenen Zeitraum kopiert werden können. Aktualisierung ignoriert.',
        ],
    ],

    'receipt_modules' => [
        'errors' => [
            'already_migrated' => 'Dieser Fiskaldrucker wurde bereits auf die neue Abteilungsverwaltung migriert.',
        ],
        'log' => [
            'receipt_module_updated' => 'Fiskaldrucker aktualisiert.',
            'receipt_module_created' => 'Fiskaldrucker erstellt.',
            'receipt_module_deleted' => 'Fiskaldrucker gelöscht.',
            'receipt_module_department_deleted' => 'Abteilung des Fiskaldruckers gelöscht.',
            'receipt_module_department_created' => 'Abteilung des Fiskaldruckers erstellt.',
            'receipt_module_department_updated' => 'Abteilung des Fiskaldruckers aktualisiert.',
        ],
        'validation' => [
            'ateco_slot_code' => [
                'wrong_format' => 'Falsches Format des Ateco-Codes.',
                'wrong_slot' => 'Slot-Wert nicht unterstützt. (0 - 3).',
            ],
        ],
    ],

    'receipt_channels' => [
        'log' => [
            'receipt_channel_created' => 'Elektronischer Beleg erstellt',
            'receipt_channel_deleted' => 'Elektronischer Beleg gelöscht',
        ]
    ],

    'reservation_accommodation_room_day' => [
        'fields' => [
            'model_name' => 'Tag',
            'price' => 'Tagespreis',
            'adults_number' => 'Anzahl der Erwachsenen',
            'children_number' => 'Anzahl der Kinder',
        ],
    ],

    'reservation_addon' => [
        'fields' => [
            'related_id' => 'verknüpfter identifikator',
            'related_type' => 'verknüpfter typ'
        ],
    ],

    'reservation_accommodation' => [
        'fields' => [
            'price_total' => 'Gesamtpreis des Zimmers',
            'smoking' => 'Raucher',
            'accommodation_bed_type_combination_id' => 'Kennung der Bettenkombination für die Unterkunft'
        ],
    ],

    'reservation_cc' => [
        'fields' => [
            'holder' => 'Karteninhaber',
            'number' => 'Kreditkartennummer',
            'expire_date' => 'Ablaufdatum der Kreditkarte',
            'cvc' => 'CVC-Code',
            'credit_card' => 'Kreditkarte',
            'current_balance' => 'aktueller Saldo',
            'type_id' => 'Bezeichnertyp',
            'activation_date' => 'Aktivierungsdatum',
            'vcc_expiration_date' => 'vcc ablaufdatum',
            'is_virtual_card' => 'ist virtuelle karte'
        ],
    ],

    'reservation_invoice' => [
        'export_fields' => [
            'reference_number' => 'Reservierungs-ID',
            'reservation_id' => 'Reservierungs-ID',
            'accommodations' => 'Unterkünfte',
            'room' => 'Zimmernummer',
            'period' => 'Aufenthalt',
            'pax' => 'Gäste',
            'type' => 'Typ',
            'customer' => 'Kunde',
            'payment_agreement' => 'Kredit',
            'paid' => 'Bezahlt',
            'to_pay' => 'Zu zahlen',
            'accountholder' => 'Kontoinhaber',
            'total' => 'Gesamtbetrag',
            'stay' => 'Aufenthalt',
            'guests' => 'Gäste',
            'credit' => 'Kredit',
            'note' => 'Notiz',
            'notes' => 'Notizen',
            'status' => 'Status',
            'booker' => 'Buchender',
            'property_name' => 'Unterkunft',
            'open_charges' => 'Offene Rechnungen',
        ],
        'errors' => [
            'invoice_opened_for_customer' => 'Der Kunde hat offene Rechnungen für diese Reservierung, schließen Sie die Rechnungen, bevor Sie neue eröffnen.',
            'credit_note_on_opened' => 'Es ist nicht möglich, eine Gutschrift für nicht erstellte Rechnungen auszustellen.',
            'associate_in_to_credit_note' => 'Es ist nicht möglich, eine Zahlung mit einer Gutschrift zu verbinden.',
            'associate_out_to_invoice' => 'Es ist nicht möglich, eine Ausgangszahlung mit einer Rechnung zu verbinden.',
            'cant_update_due_invoice_no_show' => 'Es ist nicht möglich, die Reservierung zu ändern, da es No-Show- oder Stornorechnungen gibt.',
            'keep_same_customer_on_credit_note' => 'Es ist nicht möglich, den Empfänger einer Gutschrift zu ändern, die mit einer ausgestellten Rechnung verbunden ist.',
            'impossibile_move_through_reservations' => 'Es ist nicht möglich, eine Belastung auf eine geschlossene Rechnung oder Gutschrift außerhalb der offenen Konten der Reservierung zu verschieben.',
            'cant_refund_pending_sdi_invoice' => 'Es ist nicht möglich, eine Gutschrift für Rechnungen auszustellen, die noch auf die Validierung durch SDI warten.',
            'associate_payments_to_follows_invoice' => 'Es ist nicht möglich, Zahlungen mit einer Rechnung zu verbinden, die als „folgt Rechnung“ markiert ist.',
        ],
    ],

    'reservation_note' => [
        'fields' => [
            'reservation_internal' => 'Internen Reservierungsnotizen',
            'reservation_customer' => 'Kundennotizen',
            'accommodation_customer' => 'Kundenanforderungen',
            'accommodation_checkin' => 'Check-in Notizen für Zimmer',
            'accommodation_checkout' => 'Check-out Notizen für Zimmer',
            'accommodation_housekeeper' => 'Hauswirtschaftsnotizen'
        ],
        'deposit' => [
            'wording' => 'Eine Zahlung von :amount wurde vom Kunden :customer mit der Zahlungsmethode :payment_method hinterlegt.',
            'card_info' => 'Die Kartendaten wurden für den Kartentyp :card_type mit der Nummer :card_number, dem Code :card_code und dem Ablaufdatum :expire_date registriert.',
        ],
    ],

    'reservation_payment' => [
        'move_errors' => [
            'reservation_payment_is_not_payment' => 'Die Zahlung vom :date unter dem Namen :accountholder ist eine Rückerstattung',
            'reservation_payment_rows_with_bills' => 'Die Zahlung vom :date unter dem Namen :accountholder hat zugeordnete Belastungen',
            'reservation_payment_is_invoiced' => 'Die Zahlung vom :date unter dem Namen :accountholder ist in bereits ausgestellten Dokumenten enthalten',
            'reservation_payment_with_different_invoice_layout' => 'Die Zahlung vom :date unter dem Namen :accountholder hat ein Rechnungsprofil, das in der Zielstruktur nicht vorhanden ist',
        ],
        'pre_check_errors' => [
            'reservation_payment_is_not_payment' => 'Die Zahlung ist eine Rückerstattung',
            'reservation_payment_rows_with_bills' => 'Die Zahlung hat zugeordnete Belastungen',
            'reservation_payment_is_invoiced' => 'Die Zahlung ist in bereits ausgestellten Dokumenten enthalten',
        ],
    ],

    'reservation_quote' => [
        'export_fields' => [
            'reference_number' => 'Nummer',
            'created_at' => 'Erstellt',
            'customer_full_name' => 'Kunde',
            'expire_date' => 'Ablaufdatum',
            'status' => 'Status',
            'expire_date_availability' => 'Verfügbarkeitsablauf',
            'email_read_at' => 'Gelesen am',
            'property' => 'Unterkunft',
            'option' => 'Option',
            'accommodations' => 'Unterkünfte',
            'stay' => 'Aufenthalt',
            'guests' => 'Gäste',
            'treatment' => 'Behandlung',
            'total' => 'Gesamt',
            'customer_email' => 'E-Mail-Adresse',
            'customer_telephone' => 'Telefon',
        ],
        'status' => [
            'active' => 'Aktiv',
            'revoked' => 'Abgelehnt',
            'accepted' => 'Akzeptiert',
            'expired' => 'Abgelaufen',
            'draft' => 'Entwurf',
        ],
        'adults' => '{1} 1 Erwachsener|[2,*] :count Erwachsene',
        'children' => '{1} 1 Kind|[2,*] :count Kinder',
        'errors' => [
            'no_email_found' => 'Es wurden keine E-Mail-Adressen angegeben, an die das Angebot gesendet werden soll. Bitte geben Sie mindestens eine Adresse an.',
            'email_already_feedback_cannot_update' => 'Das Angebot kann nicht geändert werden, da der Kunde es bereits angesehen hat oder Feedback gegeben hat.',
            'no_customer_specified' => 'Das Angebot ist keinem Benutzer zugeordnet.',
            'quote_not_active' => 'Das Angebot ist nicht aktiv.',
            'quote_option_empty' => 'Die Angebotsoption enthält keine Zimmer, daher kann es nicht bestätigt werden.',
            'quote_option_no_availability' => 'Die Unterkünfte, die Sie buchen möchten, sind nicht mehr verfügbar.',
            'upload_attachment' => 'Fehler beim Hochladen der Datei',
            'other_modified' => 'Dieses Angebot ist nicht mehr verfügbar, da es von einem anderen Benutzer geändert wurde.',
            'no_valid_property' => 'Sie können keine Unterkunft aus einer anderen Struktur in dieser Option einfügen.',
        ],
    ],

    'reservation' => [
        'reservation' => 'Reservierung',
        'notes' => [
            'accommodation_internal' => 'Interne Notizen Unterkunft',
            'accommodation_checkout' => 'Notizen Check-out Zimmer',
            'accommodation_checkin' => 'Notizen Check-in Zimmer',
            'accommodation_bill' => 'Notizen Abrechnung Zimmer',
            'accommodation_housekeeper' => 'Notizen Zimmermädchen',
            'accommodation_customer' => 'Notizen Gast Zimmer',
        ],
        'details' => [
            'inserted' => 'Die Kosten des Service :title betragen :amount :currency',
        ],
        'export_fields' => [
            'id' => 'ID',
            'booked_at' => 'Buchungsdatum/Uhrzeit',
            'modified_at' => 'Letzte Änderung Datum/Uhrzeit',
            'channel_name' => 'Kanal',
            'channel' => 'Kanal',
            'booker' => 'Bucher',
            'booker_full_name' => 'Bucher Name',
            'group_label' => 'Gruppe',
            'accommodations' => 'Unterkünfte',
            'rateplans' => 'Preismodelle',
            'original_accommodations' => 'Originalunterkünfte',
            'property' => 'Unterkunft',
            'stay' => 'Aufenthalt',
            'period' => 'Zeitraum',
            'tag' => 'Etikett',
            'arrival_date' => 'Ankunftsdatum',
            'departure_date' => 'Abreisedatum',
            'number_nights' => 'Anzahl Nächte',
            'total_price' => 'Gesamtpreis',
            'property_name' => 'Unterkunft Name',
            'reservation_id' => 'Reservierungs-ID',
            'room' => 'Zimmer',
            'total' => 'Gesamt',
            'total_to_pay' => 'Gesamt zu zahlen',
            'status' => 'Status',
            'note_customer' => 'Kundennotizen',
            'internal_note' => 'Interne Notizen',
            'group' => 'Gruppe',
            'reference_number' => 'Referenznummer',
            'commission_amount' => 'Provisionsbetrag',
            'treatments' => 'Behandlungen',
            'booker_telephone' => 'Bucher Telefon',
            'booker_email' => 'Bucher E-Mail',
            'company' => 'Firma',
            'currency' => 'Währung',
            'nic' => 'Steuernummer',
            'extra' => 'Zusatz',
            'city_tax' => 'Kurtaxe',
            'advance' => 'Anzahlung',
            'guests' => 'Gäste',
            'xml_reservation_id' => 'Kanalreservierungs-ID',
            'user' => 'Benutzer',
            'reservation_from_id' => 'Herkunft',
            'reservation_reason_id' => 'Grund der Buchung',
            'escalate_report_to_booking' => 'Meldung an Booking.com weiterleiten?',
            'allow_guest_to_book_again' => 'Gast erneut buchen lassen?'
        ],
        'activity' => [
            'new' => [
                'message' => 'Neue Buchung von :channel_name',
                'message_sclak_generated_key' => 'Schlüssel für Sclak generiert für das Zimmer: :accommodation_name (:tableau_label)',
                'message_nuki_generated_key' => 'PIN für Nuki generiert für das Zimmer: :accommodation_name (:tableau_label)',
                'message_sclak_sms_sent' => 'SMS mit den Sclak-Codes an die Nummer :telephone_number gesendet',
                'message_sclak_deleted_key' => 'Schlüssel auf Sclak gelöscht für das Zimmer: :accommodation_name (:tableau_label)',
                'message_nuki_deleted_key' => 'PIN für das Zimmer gelöscht: :accommodation_name (:tableau_label)',
                'invoice_printig_session' => 'Fiskaldruck auf dem Drucker :printer_name (ID: :printer_id) für die Quittung mit der ID: :invoice_id gestartet',
                'added_payment' => 'Zahlung von :amount :currency (ID: :payment_id) mit der Methode :payment_method hinzugefügt',
                'added_refund' => 'Rückerstattung von :amount :currency (ID: :payment_id) mit der Methode :payment_method emittiert',
            ],
            'update' => [
                'message' => 'Das Feld :field_translate wurde von :old_value zu :new_value geändert',
                'message_novalue' => 'Das Feld :field_translate wurde geändert',
                'message_newvalue' => 'Eintrag :field_translate :new_value',
                'message_deletevalue' => 'Löschung von :field_translate :old_value',
                'message_forobject' => 'Das Feld :field_translate wurde von :old_value zu :new_value für :model_type :model_name geändert',
                'message_split_accommodation' => 'Das gebuchte Zimmer :accommodation_source (Tableau-Verweis: :tableau_label_source) (vom :original_arrival_date bis :original_departure_date) wurde geteilt vom :split_arrival_date bis :split_departure_date und in das Zimmer :accommodation_destination (Tableau-Verweis: :tableau_label_destination) verschoben',
                'message_move_accommodation' => 'Das gebuchte Zimmer :accommodation_source (Tableau-Verweis: :tableau_label_source, Rateplan: :rateplan_name_source , Behandlung: :treatment_name_source, Preis: :price_source) wurde in das Zimmer :accommodation_destination (Tableau-Verweis: :tableau_label_destination, Rateplan: :rateplan_name_destination , Behandlung: :treatment_name_destination , Preis: :price_destination) verschoben',
                'message_resend_email_customer' => 'Buchungs-E-Mail erneut an den Bucher gesendet, Adresse :new_value',
                'message_resend_email_company' => 'Buchungs-E-Mail erneut an die Firma gesendet, Adresse :new_value',
                'message_resend_email_property' => 'Buchungs-E-Mail erneut an die Unterkunft gesendet, Adresse :new_value',
                'message_resend_email_additional' => 'Buchungs-E-Mail erneut an die zusätzliche Adresse :new_value gesendet',
                'message_restored_sdi_rejected_invoice' => 'Das Dokument :invoice_number vom :invoice_date wurde wiederhergestellt, mit den folgenden Benachrichtigungen: :sdi_notify',
                'message_sdi_rejected_invoice' => 'Das Dokument :invoice_number vom :invoice_date wurde abgelehnt, ausgestellt mit dem Rechnungsprofil :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'message_sdi_rejected_invoice_with_advances' => 'Das Dokument :invoice_number vom :invoice_date wurde abgelehnt, ausgestellt mit dem Rechnungsprofil :invoice_layout (:invoice_business_name - :invoice_vat_code) mit den folgenden Anzahlungen: :advances',
                'message_sdi_rejected_invoice_as_receipt' => 'Das abgelehnte Dokument :invoice_number vom :invoice_date wurde als Quittung ausgestellt, mit dem Rechnungsprofil :invoice_layout (:invoice_business_name - :invoice_vat_code) und zugeordnet zu :invoice_customer (Gesamt :invoice_total), mit den folgenden Benachrichtigungen: :sdi_notify',
                'message_registered_invoice' => 'Die :document_type :invoice_number :follows_invoice vom :invoice_date wurde registriert, ausgestellt mit dem Rechnungsprofil :invoice_layout (:invoice_business_name - :invoice_vat_code) und zugeordnet zu :invoice_customer (Gesamt :invoice_total) :manual_fp_register',
                'message_restored_invoice' => 'Die :document_type :invoice_number vom :invoice_date wurde annulliert, ausgestellt mit dem Rechnungsprofil :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'calculate_city_tax' => 'Die Kurtaxe wurde für die folgenden Gäste berechnet: :guests',
                'no_guests_calculate_city_tax' => 'Die Kurtaxe wurde berechnet, aber es sind keine Gäste vorhanden, die für die Berechnung berechtigt sind',
                'add_extra' => 'Zusatzgebühren wurden hinzugefügt: :extra',
                'delete_bill' => 'Die Zusatzgebühren wurden gelöscht: :extra',
                'transferred_bills' => 'Die :transfer_label der Zusatzgebühren wurde übertragen: :bills_label',
                'transferred_bills_qty' => 'Die Menge :transfer_label der Zusatzgebühren wurde übertragen: :bills_label',
                'transferred_bills_to_charges' => 'Der Wert :transfer_label der Zusatzgebühren wurde auf das laufende Konto :invoice_label (:invoice_id) übertragen',
                'transferred_bills_to_accommodation' => 'Der Wert :transfer_label der Zusatzgebühren wurde auf das Zimmer :accommodation_label (:accommodation_id) übertragen - Buchung :reference_number',
                'transferred_bills_to_accommodation_multi_customer' => 'Der Wert :transfer_label der Zusatzgebühren wurde auf das Zimmer :accommodation_label (:accommodation_id) - Buchung :reference_number auf die Kunden :customers übertragen',
                'transferred_bills_qty_to_charges' => 'Die Menge :transfer_label der Zusatzgebühren wurde auf das laufende Konto :invoice_label (:invoice_id) übertragen',
                'transferred_bills_qty_to_accommodation' => 'Die Menge :transfer_label der Zusatzgebühren wurde auf das Zimmer :accommodation_label (:accommodation_id) - Buchung :reference_number übertragen',
                'transferred_bills_qty_to_accommodation_multi_customer' => 'Die Menge :transfer_label der Zusatzgebühren wurde auf das Zimmer :accommodation_label (:accommodation_id) - Buchung :reference_number auf die Kunden :customers übertragen',
                'transferred_bills_to_accommodation_reservation_destination' => 'Die Zusatzgebühren wurden vom laufenden Konto :invoice_origin (#:invoice_origin_id) übertragen: :bills_label',
                'restored_bills' => 'Die Zusatzgebühren wurden wiederhergestellt: :bills_label',
                'message_deleted_credit_note' => 'Das Dokument :document_type :invoice_number vom :invoice_date wurde gelöscht, ausgestellt mit dem Rechnungsprofil :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'edit_payment' => 'Die Zahlung (ID: :payment_id) mit der Methode :payment_method wurde geändert. Gesamtbetrag :amount :currency',
                'message_edit_guest' => 'Der Gast :guest_name wurde geändert',
                'transferred_payment_to_reservation' => 'Die Zahlung (#:paymentId) vom :date unter dem Namen :accountholder wurde von der Buchung :reservationOrigin auf die Buchung :reservationDestination übertragen',
                'restored_payment_to_reservation' => 'Die Zahlung (#:paymentId) vom :date unter dem Namen :accountholder wurde von der Buchung :reservationOrigin wiederhergestellt',
                'guest_checkin_checkout' => 'Die Ankunfts- oder Abreisedaten wurden geändert aufgrund einer Änderung des Aufenthaltsdatums im Zimmer für die folgenden Gäste: :guests',
                'model_price_original' => 'Das Feld :field_translate wurde von :old_value auf :new_value geändert. Der Kunde hat sich entschieden, den aktuellen Preis beizubehalten.',
                'model_price_moved' => 'Das Feld :field_translate wurde von :old_value auf :new_value geändert. Der Kunde hat sich für den neuen Preis entschieden.',
            ],
            'customer_note' => 'Kundenwünsche: :note',
            'catering_note' => 'Verpflegungsnotiz: :note',
            'bill_note' => 'Hinweise zur Rechnungserstellung: :note',
            'internal_note' => 'Interne Notiz: :note',
            'view' => [
                'credit_card_success' => 'Kreditkartendaten wurden angezeigt. (:ip_address)',
                'credit_card_fail' => 'Es wurde ein Versuch unternommen, Kreditkartendaten abzurufen. (:ip_address)',
            ],
            'delete' => [
                'delete_payment' => 'Es wurde eine Zahlung von :amount :currency (ID: :payment_id) mit der Methode :payment_method entfernt.',
            ],
            'nuki' => [
                'create' => 'Nuki-Gerät (:device_id): Türcode für Zimmer :tableau_label erstellt',
                'update' => 'Nuki-Gerät (:device_id): Codeberechtigungen für Zimmer :tableau_label geändert',
                'delete' => 'Nuki-Gerät (:device_id): Türcode für Zimmer :tableau_label gelöscht',
            ],

        ],
        'policy' => [
            'none' => 'Keine Strafe',
        ],
        'payment_status' => [
            'suspended' => 'Ausgesetzt',
            'to_pay' => 'Zu zahlen',
            'to_be_invoiced' => 'Zu fakturieren',
            'paid' => 'Bezahlt',
        ],
        'fields' => [
            'commission_amount' => 'Provisionsbetrag',
            'reservation_reason_id' => 'Kennung des Reservierungsgrundes',
            'resend_email' => 'E-Mail erneut senden',
            'availability_option' => 'Verfügbarkeitsoption',
            'expiration_date' => 'Ablaufdatum',
            'keep_availability' => 'Nicht wiederherstellen',
            'status' => 'Status',
            'accommodation_bill' => 'Rechnungsnotizen',
            'move_accommodation' => 'Zimmerwechsel',
            'sclak_sms_sent' => 'Slack-Code-SMS gesendet',
            'sclak_generated_key' => 'Schlüssel auf Sclak generiert',
            'sclak_deleted_key' => 'Schlüssel auf Sclak gelöscht',
            'split_reservation' => 'Reservierung aufteilen',
            'total_children' => 'Anzahl der Kinder',
            'reason' => 'Reisegrund',
            'label_name' => 'Kundengruppe',
            'overbooking' => 'Überbuchung',
            'total_adults' => 'Anzahl der Erwachsenen',
            'total_price' => 'Endpreis',
            'departure_date' => 'Abreisedatum',
            'arrival_date' => 'Anreisedatum',
            'model_name' => 'Reservierung',
            'reservation_from_id' => 'Herkunft',
            'reservation_bill' => 'Reservierungsrechnung',
            'reservation_checkin' => 'Reservierungsabfrage',
            'reservation_checkout' => 'Reservierungs-Kasse',
            'partner_download' => 'Partner-Download',
            'commissionable_amount' => 'provisionsfähiger Betrag',
            'is_group' => 'ist Gruppe',
            'commission_discount_type_id' => 'provisionsrabatt typ id',
            'commission_discount_value' => 'provisionsrabattwert',
            'added_credit_card_data' => 'kreditkartendaten hinzugefügt',
        ],
        'wording' => [
            'city_tax_label_no_limit' => ':cost pro Nacht von :min_age bis :max_age Jahren ohne Tageslimit',
            'city_tax_label' => ':cost pro Nacht von :min_age bis :max_age Jahren für maximal :limit_days Tage',
            'accommodation_bill_label' => 'Aufenthalt',
            'credit_note' => 'Stornierung :mode von :type Nr. :number vom :invoice_date',
            'total' => 'Gesamt',
            'partial' => 'Teilweise',
            'advance_count' => 'Anzahlung Nr: ',
            'customer' => 'Kunde: ',
            'advance_invoice' => 'Aufenthalt vom :date_from bis :date_to',
        ],
        'errors' => [
            'property_deleted' => 'Reservierung kann nicht storniert werden, bitte kontaktieren Sie die Unterkunft',
            'missing_main_room_guest' => 'Hauptgast ist für alle Zimmer nicht konfiguriert',
            'accommodation_not_found' => 'Die Unterkunft wurde gelöscht',
            'different_accommodation_checkout_date' => 'Die Zimmer der Reservierung haben unterschiedliche Checkout-Daten',
            'different_accommodation_checkin_date' => 'Die Zimmer der Reservierung haben unterschiedliche Checkin-Daten',
            'transfer_on_same_customer_bill' => 'Auf denselben Zahler kann nicht aufgeteilt werden',
            'no_guests_loaded' => 'Kein Gast für das Zimmer gefunden',
            'not_mapped_accommodation' => 'Das Zimmer ist nicht korrekt zugeordnet',
            'not_switch_virtual' => 'Sie können die Reservierung nicht auf ein virtuelles Zimmer einer anderen Unterkunft verschieben',
            'last_accommodation' => 'Das letzte verbleibende Zimmer kann nicht gelöscht werden',
            'not_tableau' => 'Tableau-Zimmer gehört nicht zur Unterkunft',
            'impossible_change' => 'Dieser Statuswechsel kann nicht durchgeführt werden',
            'missing_roomreservation_id' => 'Kein Zimmer für die angegebene Zimmerreservierung gefunden',
            'missing_order' => 'Bestellung nicht gefunden',
            'existing_bills_invoiced' => 'Es gibt Rechnungen und Quittungen zu dieser Reservierung. Vorgang kann nicht fortgesetzt werden',
            'uneditable_field' => 'Feld kann nicht bearbeitet werden',
            'no_gateway_response' => 'Verbindungsfehler mit dem Zahlungs-Gateway',
            'reservation_unpaid' => 'Die Transaktion war nicht erfolgreich',
            'missing_balance' => 'Ausstehender Betrag nicht bezahlt',
            'uneditable_fields_invoice' => 'Folgende Felder können nicht bearbeitet werden: ',
            'not_editable_total_due_paid' => 'Eingegebener Preis ist geringer als der bereits bezahlte Gesamtbetrag',
            'not_editable_total_due_invoice' => 'Eingegebener Preis ist geringer als der bereits fakturierte Gesamtbetrag',
            'accommodation_room_guest_exists' => 'Der angegebene Gast existiert bereits für die angegebenen Daten',
            'no_payment_amount_enough' => 'Das verfügbare Guthaben (:amount_available) reicht nicht aus, um den Betrag (:request_amount) zu decken',
            'payment_amoun_minor_of_amount_used' => 'Der angegebene Betrag (:request_amount) ist geringer als der bereits verwendete Betrag (:amount_used_global)',
            'cannot_delete_deposit_invoice' => 'Eine Zahlung kann nicht gelöscht werden, da sie bereits in einer ausgestellten Rechnung verwendet wurde',
            'accommodation_invoiced' => 'Das Zimmer wurde bereits fakturiert und kann nicht gelöscht werden',
            'resend_email_empty_address' => 'Für diesen Kunden wurde keine E-Mail-Adresse angegeben',
            'householder_in_agreement' => 'Der Haushaltsvorstand ist in der Rechnungsaufteilung enthalten, bitte ändern Sie die Personalisierung vor dem Fortfahren',
            'missing_company' => 'Unternehmensbezug für die Reservierung fehlt',
            'accommodation_bill_charged' => 'Zimmerabrechnung wurde fakturiert. Vorgang kann nicht fortgesetzt werden',
            'all_billed' => 'Alle Belastungen sind bereits abgerechnet oder verschoben. Vorgang kann nicht erneut durchgeführt werden',
            'impossible_move_nature_bill' => 'Verschiebung der Abrechnungsart auf einen durchlaufenden Rechnungsposten nicht möglich: ',
            'billed_accommodation' => 'Reservierungsdaten können nicht geändert werden, da steuerliche Dokumente ausgestellt wurden. Bitte erstellen Sie eine neue Reservierung oder fügen Sie ein Zimmer mit den neuen Daten hinzu.',
            'deposit_as_refund' => 'Eine Anzahlung kann nicht als Rückerstattung konfiguriert werden',
            'refund_in_invoice' => 'Eine Rückerstattung kann nicht mit Rechnungen oder Quittungen verbunden werden',
            'different_vat_codes' => 'Zahlungen oder Quittungen können nicht an Rechnungsprofile mit unterschiedlichen Steuernummern als das Dokument angehängt werden',
            'property_not_attached' => 'Zahlungen können nicht an nicht beteiligte Unterkünfte zugeordnet werden',
            'too_many_payments' => 'Der Betrag der Zahlungen übersteigt die Ausgaben oder den zu erstattenden Betrag',
            'bill_and_expense' => 'Zahlung kann nicht mit einer Belastung und einer Ausgabe gleichzeitig verbunden werden',
            'expense_minimum_payment' => 'Die Ausgabe muss mindestens eine Zahlung haben, Vorgang kann nicht fortgesetzt werden',
            'amount_exceed_refunds' => 'Der zuzuordnende Betrag übersteigt den nutzbaren Teil unter Berücksichtigung der Rückerstattungen',
            'missing_reservation' => 'Ungültige Reservierung.',
            'already_cancelled' => 'Die Reservierung ist bereits storniert.',
            'impossible_decrement_shared_bill' => 'Menge einer geteilten Abrechnung kann nicht verringert werden',
            'pax_fields_in_not_paxable_bill' => 'Gastreferenzen können nicht für Abrechnungen eingegeben werden, die nicht auf Zusatzleistungen basieren',
            'company_email_address_is_empty' => 'Für dieses Unternehmen wurde keine E-Mail-Adresse angegeben',
            'checkinonline_dati_mancanti' => 'Daten wurden nicht korrekt übermittelt.',
            'checkinonline_reservation_not_found' => 'Reservierung nicht gefunden.',
            'checkinonline_reservation_is_cancelled' => 'Die Reservierung wurde storniert.',
            'checkinonline_reservation_is_not_confirmed' => 'Die Reservierung ist nicht bestätigt',
            'checkinonline_reservation_arrival_date_past' => 'Das Anreisedatum liegt vor dem heutigen Datum.',
            'checkinonline_reservation_departure_date_over' => 'Die Reservierung ist bereits abgeschlossen.',
            'checkinonline_city_tax_cannot_pay' => 'Keine Kurtaxe zu zahlen.',
            'deposit_as_deposit' => 'Die Zahlung ist bereits eine Anzahlung, Vorgang nicht möglich',
            'deposit_as_advance' => 'Dokument über eine Vorauszahlung auf Anzahlung nicht möglich',
            'document_on_funds' => 'Dokument über einen Fondbetrag kann nicht erstellt werden',
            'document_on_used_payment' => 'Dokument über eine Zahlung, die bereits zur Begleichung anderer Dokumente verwendet wurde, kann nicht erstellt werden',
            'not_whole' => 'Dokument über eine verknüpfte Zahlung kann nicht erstellt werden',
            'document_on_refunded' => 'Dokument über eine rückerstattete Zahlung kann nicht erstellt werden',
            'document_on_payments_out' => 'Dokument über ausgehende Zahlungen kann nicht erstellt werden',
            'channel_checkin_missing_info' => 'Keine Informationen über den Status der Anfrage',
            'channel_checkin_missing_status_already_present' => 'Check-in-Status wurde bereits bearbeitet',
            'no_bills_on_customer' => 'Keine Belastungen für den Verantwortlichen der Kontenaufteilung vorhanden',
            'discount_over_invoiced_value' => 'Anzuwendende Preisänderung übersteigt den zu fakturierenden Betrag',
            'no_show_requested_total_major_bills_to_invoice' => 'Angeforderte No-Show-Gesamtmenge übersteigt den zu fakturierenden Betrag',
            'checkin_major_checkout' => 'Check-in-Datum ist später oder gleich dem Check-out-Datum für das Zimmer :accommodation_name, Vorgang kann nicht fortgesetzt werden',
            'checkout_major_checkin' => 'Check-out-Datum ist früher oder gleich dem Check-in-Datum für das Zimmer :accommodation_name, Vorgang kann nicht fortgesetzt werden',
            'missing_addon' => 'Zusatzdienstleistung mit fehlenden Feldern, Vorgang kann nicht fortgesetzt werden',
            'missing_customer_on_split_bills_same_reservation' => 'Aufteilungen der Belastungen in derselben Reservierung ohne Angabe spezifischer Zahler nicht möglich',
            'have_door_service_active' => 'Manuelles Hinzufügen eines Schlüssels für die Türöffnung nicht möglich, da der externe Dienst :external_service_name aktiv ist',
            'conflict_system_custom_email_template' => 'Mehr als eine zu sendende Vorlage angegeben, bitte nur eine angeben.',
            'guest_already_present_in_same_dates' => 'Vorgang nicht möglich: Gast ist bereits für dieselben Daten eingetragen',
            'can_not_move_reservation_payments' => 'Zahlungen können aufgrund der folgenden Fehler nicht übertragen werden: :errors',
            'can_not_modify_ota_checkin_checkout' => 'Reservierungsdaten von einem Kanal können nicht geändert werden.',
            'unsuitable_dates_for_guests' => 'Ungeeignete Aufenthaltsdaten für Gäste: :guests',
            'unsuitable_dates_for_guests_one_day' => 'Mehrere Aufenthaltsdaten für Gäste: :guests für nur eine Übernachtung, bitte entfernen Sie einen der Aufenthalte, bevor Sie fortfahren',
        ],
        'warnings' => [
            'not_mapped_addons' => 'Der gewünschte Service ist dem Zimmer nicht zugeordnet: ',
            'bill_splitted' => 'Auf mehrere Konten verteilte Abrechnung kann nicht bearbeitet werden: ',
            'bill_children' => 'Teilabrechnung kann nicht bearbeitet werden: ',
            'all_bills_closed' => 'Alle Konten für diese Reservierung sind geschlossen',
            'deposit_cut' => 'Ein Betrag wurde von der Zahlung der Abrechnung abgezogen: ',
            'not_existing_bill' => 'Abrechnung existiert nicht',
            'exceeding_num_adults' => 'Anzahl der Erwachsenen überschreitet das für das Zimmer festgelegte Maximum',
            'exceeding_num_children' => 'Anzahl der Kinder überschreitet das für das Zimmer festgelegte Maximum',
            'existing_payments_pending' => 'Es gibt ausstehende Zahlungen für Zimmerabrechnungen. Möchten Sie trotzdem fortfahren?',
            'existing_invoices_joined' => 'Es gibt Dokumente, die mit der Abrechnung :bill_name verknüpft sind. Übertragung auf Unterkünfte anderer Reservierungen oder durchlaufende Konten nicht möglich',
            'customer_invoiced' => 'Für den Kunden :customer wurden Rechnungen ausgestellt, Löschen nicht möglich',
            'is_previous' => 'Reservierung liegt vor der Verbindung mit dem Channel',
            'bill_cant_split' => 'Abrechnung kann nicht in dieser Kategorie aufgeteilt werden',
            'bill_charged' => 'Eine oder mehrere Abrechnungen sind fakturiert, Änderungen nicht möglich.',
            'bill_qty_incoerence' => 'Menge stimmt nicht mit der Anzahl der mit der Abrechnung verbundenen Gäste überein',
            'no_guests' => 'Keine Gäste in dieser Reservierung vorhanden',
            'move_other_property_notify' => 'Wählen Sie eine Unterkunft aus, von der aus Benachrichtigungen gesendet werden sollen',
            'bill_deposit_not_allowed' => 'Zahlung kann nicht mit dieser Art von Abrechnung verknüpft werden',
            'bill_discount_unsuitable_to_row' => 'Der neu berechnete Rabatt ist mit dem fakturierten Teil der Abrechnung nicht kompatibel',
            'bill_rows_discount_deleting' => 'Die Übertragung hat den Rabatt der ursprünglichen Abrechnung im offenen Konto zurückgesetzt',
            'existing_bills_night' => 'Zusatzleistungen für Nächte, die nicht im Aufenthalt enthalten sind, werden entfernt',
            'bills_not_found' => 'Gebühren nicht gefunden',
            'change_status_in_progress' => 'Die Reservierung führt bereits einen Statuswechsel durch.',
            'reservation_accommodation_door_key_code_reservation_resumed' => 'Ein neuer Schlüssel muss generiert werden, da der vorherige durch den Statuswechsel der Reservierung deaktiviert wurde.',
            'reservation_accommodation_door_key_code_exist' => 'Es sind Türöffnungscodes vorhanden. Generieren oder widerrufen Sie diese manuell.',
            'reservation_accommodation_door_key_code_exist_moved_accommodation' => 'Ein oder mehrere Unterkünfte wurden verschoben. Es muss ein neuer Schlüssel generiert werden.',
            'reservation_accommodation_door_key_code_delete' => 'Fehler beim Löschen der Schlüssel. Bitte versuchen Sie es manuell erneut.',
            'reservation_accommodation_door_key_code_generate' => 'Fehler bei der Generierung der Schlüssel. Bitte versuchen Sie es manuell erneut.',
            'existing_transferred_bills' => 'Es gibt Abrechnungen aus anderen Zimmern. Sie müssen wiederhergestellt oder neu zugeordnet werden, bevor Sie fortfahren.',
            'bill_has_payment' => 'Es gibt Zahlungen, die mit der Abrechnung :bill_name verknüpft sind. Übertragung auf externe Zimmer oder Dokumente nicht möglich.',
        ],
        'channels' => [
            'no_report_invalid_cc' => 'Bericht über ungültige Kreditkarte für diesen Kanal nicht erforderlich',
            'no_report_noshow' => 'Bericht über No-Show für diesen Kanal nicht erforderlich',
            'no_report_cancellation_due_invalid' => 'Bericht über Stornierungen für diesen Kanal nicht erforderlich',
            'payment_to_ota' => 'Zahlung an das Portal :channel_name erfolgt',
            'no_previous' => 'Der Kanal unterstützt keine älteren Reservierungen',
            'email' => [
                'without_room_title' => 'Neue Reservierung ohne Zimmer von :channel_name (ID: :reference_number) - Unterkunft: :property_name',
                'without_rate_title' => 'Neue Reservierung ohne Tarif von :channel_name (ID: :reference_number) - Unterkunft: :property_name',
            ],
        ],
        'bills' => [
            'reservation_bill_id_not_found' => 'Die ID :reservation_bill_id gehört nicht zur angegebenen Reservierung',
            'reservation_bill_id_already_override' => 'Die ID :reservation_bill_id wurde bereits überschrieben',
            'reservation_bill_id_no_updates' => 'Alle Elemente gehören bereits zu einer Überschreibung oder nicht zur angegebenen Reservierung',
            'delete_bill_accounted' => 'Löschen nicht möglich, da eines oder mehrere Elemente bereits verbucht wurden',
            'delete_sheet_bill_emitted' => 'Löschen des Kontos nicht möglich, da bereits eine Rechnung ausgestellt wurde',
            'different_vat_quotes_in_merge' => 'Zusammenführung von Abrechnungen mit unterschiedlicher Mehrwertsteuer nicht möglich',
            'cant_editable_due_moved' => 'Abrechnung verschoben: Nur Änderung des Rabatts möglich',
        ],
        'invoice' => [
            'invoice_already_registered' => 'Die Rechnung wurde bereits ausgestellt',
            'no_invoice_layout' => 'Kein Rechnungs-Layout vorhanden. Vorgang kann nicht fortgesetzt werden',
            'no_an_invoice' => 'Dies ist keine Rechnung',
            'no_company_id' => 'Es wurde kein Unternehmen für die Rechnung angegeben',
            'unsuitable_payments' => 'Die zugeordneten Zahlungen sind nicht mit der MwSt.-Nummer des Kontos kompatibel',
            'too_many_advances' => 'Der Wert der geleisteten Vorauszahlungen übersteigt die Gesamtabrechnungen',
            'advances_in_advance' => 'Vorauszahlungen können nicht in einer Vorauszahlungsrechnung enthalten sein',
            'payments_major_total_invoice' => 'Die Gesamtsumme der Zahlungen übersteigt die Rechnungssumme',
        ],
        'pdf' => [
            'reservation' => [
                'filters' => [
                    'in_house' => 'Im Haus',
                    'arrival_date' => 'Anreise',
                    'departure_date' => 'Abreise',
                ],
                'booker' => [
                    'origin' => 'Referenzkanal',
                    'name' => 'Gastname',
                    'telephone' => 'Telefon',
                    'email' => 'E-Mail',
                    'pec' => 'PEC',
                    'language' => 'Sprache',
                    'reference_number' => 'Reservierungsnummer',
                    'booked_at' => 'Reservierungsdatum',
                    'commissionable_amount' => 'Betrag provisionspflichtig',
                    'commission_amount' => 'Provision',
                    'other_infos' => 'Wichtige Informationen zu diesem Gast',
                    'notes' => [
                        'note_internal' => 'Interne Notizen',
                        'note_customer' => 'Notizen des Kunden',
                        'note_bill' => 'Zahlungsnotizen',
                        'note_checkin' => 'Check-in-Notizen',
                        'note_checkout' => 'Check-out-Notizen',
                    ],
                ],
                'accommodation' => [
                    'from_date' => 'Anreise',
                    'to_date' => 'Abreise',
                    'duration' => 'Aufenthaltsdauer',
                    'duration_text' => '{1} :length Nacht|[2,*] :length Nächte',
                    'total_guests' => 'Gesamtanzahl Gäste',
                    'guests_adults_text' => ':quantity Erwachsene',
                    'guests_children_text' => ':quantity Kinder',
                    'total_accommodations' => 'Gesamtanzahl Zimmer',
                ],
                'reservation' => [
                    'name' => 'Gastname',
                    'total_guests' => 'Anzahl der Gäste',
                    'guests_adults_text' => ':quantity Erwachsene',
                    'guests_children_text' => ':quantity Kinder',
                    'max_capacity' => 'Maximale Belegung',
                    'capacity_text' => ':quantity Gäste',
                    'meals' => 'Mahlzeiten',
                    'meals_breakfast_included' => 'Frühstück ist im Zimmerpreis inbegriffen',
                    'table' => [
                        'date' => 'Datum',
                        'price' => 'Preis',
                        'price_per_day' => 'Preis pro Nacht',
                        'non_refundable_rate' => 'Nicht erstattbarer Tarif',
                        'subtotal' => 'Zwischensumme',
                        'city_tax' => 'Kurtaxe',
                        'city_tax_detail' => 'Betrag pro Person und Nacht',
                        'total_accommodation_price' => 'Gesamtunterkunftspreis',
                        'vat_included' => 'Der Tarif beinhaltet :amount MwSt.',
                        'vat_not_included' => 'Tarif exklusive MwSt.',
                    ],
                ],
                'statuses' => [
                    'cancelled' => 'Storniert',
                    'optionable' => 'Optionierbar',
                    'hidden' => 'Versteckt',
                    'pending' => 'Zahlung ausstehend',
                    'confirmed' => 'Bestätigt',
                ],
                'totals' => [
                    'statuses' => [
                        'Cancelled' => 'Storniert',
                        'Optionable' => 'Optionierbar',
                        'Hidden' => 'Versteckt',
                        'Pending' => 'Zahlung ausstehend',
                        'Confirmed' => 'Bestätigt',
                        'Expired' => 'Abgelaufen',
                    ],
                    'status' => 'Reservierungsstatus',
                    'total_amount' => 'Gesamtbetrag',
                    'paid_deposit' => 'Anzahlung bezahlt',
                    'total_paid' => 'Bezahlt',
                    'total_to_be_paid' => 'Ausstehender Betrag',
                ],
                'payments' => [
                    'table' => [
                        'date' => 'Registrierungsdatum',
                        'method' => 'Zahlungsmethode',
                        'amount' => 'Betrag',
                        'notes' => 'Notizen',
                    ],
                ],
            ],
            'bills' => [
                'accommodations' => 'Unterkünfte',
                'accommodation' => 'Unterkunft',
                'total' => 'Gesamt',
                'date' => 'Datum',
                'room' => 'Zimmer',
                'treatment' => 'Verpflegung',
                'amount_per_night' => 'Betrag pro Nacht',
                'addons_categories' => 'Zusatzleistungen',
                'addon_category' => 'Kategorie',
                'addon_name' => 'Leistung',
                'addon_price_type' => 'Tariftyp',
                'amount' => 'Betrag',
                'taxes' => 'Steuern',
                'tax_name' => 'Steuerart',
                'accommodations_title' => 'Unterkunftsdetails',
                'addons_categories_title' => 'Details zu Zusatzleistungen',
                'taxes_title' => 'Steuerdetails',
            ],
            'guests' => [
                'guests_list' => 'Liste der für die Reservierung registrierten Gäste',
                'reservation_of_date' => 'vom',
                'duration_text' => ':length Nächte',
                'from' => 'Von',
                'to' => 'Bis',
                'table' => [
                    'type' => 'Typ',
                    'name' => 'Name',
                    'surname' => 'Nachname',
                    'birthday_date' => 'Geburtsdatum',
                    'gender' => 'Geschlecht',
                    'birth_place' => 'Geburtsort',
                    'checked_in' => 'Check-in erfolgt',
                    'none' => 'Keine registrierten Gäste',
                ],
            ],
            'payment' => [
                'payments_short_title' => 'Zahlungsdetails',
                'payments_title' => 'Zahlungen und Dokumente',
                'report_title' => 'Zahlungsbeleg',
                'deposit_title' => 'Anzahlung',
                'refund_title' => 'Rückerstattungsbeleg',
                'issuer' => 'Zahlungsempfänger',
                'registration_date' => 'Zahlungsregistrierungsdatum',
                'payment' => 'Zahlung',
                'payment_date' => 'Zahlungsdatum',
                'method' => 'Zahlungsmethode',
                'amount' => 'Betrag',
                'pos' => 'POS',
                'deposit_number' => 'Anzahlungenummer',
                'payments_received' => 'Erhaltene Zahlungen',
                'notes' => 'Notizen',
                'deposit' => 'Anzahlung',
                'to_pay' => 'Zu zahlender Betrag',
                'excess_payment' => 'Überzahlter Gesamtbetrag',
                'invoiced' => 'Bereits fakturiert',
                'to_be_invoiced' => 'Zu fakturierender Betrag',
                'total_to_be_invoiced' => 'Gesamter zu fakturierender Betrag',
                'document_type' => 'Dokumenttyp',
                'document_number' => 'Nummer',
                'document_date' => 'Ausstellungsdatum',
                'invoice_issuer' => 'Rechnungsempfänger',
                'invoice_paid' => 'Bezahlt',
                'invoice_to_pay' => 'Zu zahlen',
            ],
            'fees' => [
                'fees_title' => 'Gebühren',
                'document_type' => 'Typ',
                'total' => 'Gesamt',
                '22' => 'MwSt. 22%',
                '10' => 'MwSt. 10%',
                'customer' => 'Kunde oder Unternehmen',
            ],
            'deposits' => [
                'deposits_title' => 'Anzahlungen und Kautionen',
                'export_fields' => [
                    'property' => 'Unterkunft',
                    'number' => 'Nummer',
                    'date' => 'Datum',
                    'total' => 'Gesamt',
                    'amount_available' => 'Verfügbarer Betrag',
                    'used' => 'Verwendet',
                    'reservation_id' => 'Reservierungs-ID',
                    'pos' => 'POS',
                    'type_payment' => 'Zahlungstyp',
                    'type_reservation' => 'Reservierungstyp',
                    'description' => 'Beschreibung',
                    'user_pay' => 'Zahler',
                    'reservation' => 'Reservierungen',
                    'payment_method' => 'Zahlungsmethode',
                    'stay' => 'Aufenthalt',
                    'departure_date' => 'Abreisedatum',
                ],
            ],
        ],
        'of_date' => 'vom :date',
        'arrival_date' => 'Anreise',
        'departure_date' => 'Abreise',
        'nights' => 'Nächte',
        'accommodations' => 'Zimmer',
        'policy_description' => 'Zusammenfassung der Bedingungen',
        'policy_deposit_description' => 'Zahlungszusammenfassung',
        'payments_timetable' => [
            'title' => 'Zahlungsbedingungen',
            'subtitle' => 'Nachfolgend die Daten, an denen die Belastungen für den Aufenthalt erfolgen',
            'statuses' => [
                'scheduled' => 'Geplant',
                'processed' => 'Bearbeitet',
                'failed' => 'Fehlgeschlagen',
                'paused' => 'Pausiert',
                'cancelled' => 'Storniert',
                'wait_customer' => 'Wartet auf den Kunden',
                'partial_processed' => 'Teilweise verarbeitet',
            ],
            'city_tax' => [
                'checkin_online' => 'Die Kurtaxe von :amount ist nicht inbegriffen und wird automatisch nach Abschluss des Online-Check-ins berechnet. Falls der Online-Check-in nicht abgeschlossen wird, erfolgt die Berechnung direkt in der Unterkunft.',
                'checkout' => 'Der Betrag von :amount ist eine Schätzung und kann sich bei Befreiungen oder Änderungen der Anzahl der Gäste oder Übernachtungen ändern.'
            ],
        ],
        'log' => [
            'city_tax_log_title' => 'Kurtaxe',
            'extra_log_title' => 'Zusatzleistungen',
            'bill_title' => 'Abrechnungen',
            'notes' => 'Notizen Abschnitt',
            'guest' => 'Gast',
            'payment' => 'Zahlung',
        ],
        'errors_reason' => [
            'update_system' => 'Sie können einen Systemgrund nicht bearbeiten',
            'delete_system' => 'Sie können einen Systemgrund nicht löschen',
            'not_exist' => 'Grund nicht gefunden',
        ],
        'customer_profile_deleted' => 'Das Profil dieses Gastes wurde gelöscht und kann nicht bearbeitet werden. Möchten Sie es reaktivieren, um die Änderung fortzusetzen?',
    ],

    'rhino' => [
        'exceptions' => [
            'request_not_valid' => 'Fehlende Felder',
            'method_not_found' => 'Die aufgerufene Methode existiert nicht',
        ],
        'vat_code_already_exists' => 'Diese Umsatzsteuer-Identifikationsnummer ist bereits im System vorhanden. Stellen Sie sicher, dass Sie eine eindeutige Umsatzsteuer-Identifikationsnummer eingeben, die noch nicht registriert wurde.',
    ],

    'roles' => [
        'property' => [
            // TODO:
            'master' => 'Direktion',
            'operator' => 'Betriebsleiter',
            'housekeeper' => 'Zimmermädchen',
        ],
        'errors' => [
            'access_denied_property' => 'Falsche Rolle: Der Benutzer hat keine Direktorenrechte, um auf die Struktur zuzugreifen.'
        ]
    ],

    'sca' => [
        'pdf' => [
            'filename' => 'Genehmigung für Kreditkarten',
            'card_holder' => 'Karteninhaber',
            'card_type' => 'Kartentyp',
            'card_number' => 'Kartennummer',
            'card_expiration' => 'Ablaufdatum',
            'card_cvc' => 'CVC',
            'parts' => [
                'p1' => 'Genehmigung für Kreditkarten',
                'p2' => 'Achtung – Die mit einem Sternchen gekennzeichneten Felder sind obligatorisch',
                'p3' => 'Bitte geben Sie alle Informationen an, um Ihre Buchung zu bestätigen.',
                'p4' => 'Senden Sie das ausgefüllte Formular zusammen mit allen erforderlichen Dokumenten an: <span class="link">:email</span>',
                'p5' => 'Karteninhaberinformationen:',
                'p6' => 'Es wird bestätigt, dass die angegebenen Informationen korrekt und wahr sind.',
                'p7' => 'Hiermit autorisiere ich die Belastung des angegebenen Betrags auf der folgenden Kredit-/Debitkarte.',
                'p8' => '<span class="bold">Für nicht erstattungsfähige Tarife</span> wird die aufgeführte Kreditkarte sofort mit dem angeforderten Betrag belastet.',
                'p9' => '<span class="bold">Für flexible Tarife</span> kann die angegebene Kreditkarte einer Gültigkeitsprüfung unterzogen werden, bevor eine Vorautorisierung des Betrags gemäß den Richtlinien vorgenommen wird.',
                'p10' => 'Unterschrift des Karteninhabers',
                'p11' => 'Buchungsnummer',
                'p12' => 'Anreisedatum',
                'p13' => 'Zusammen mit diesem Dokument ist die Vorder- und Rückseite der verwendeten Kredit-/Debitkarte sowie eine Kopie des Ausweises/Reisepasses des Karteninhabers erforderlich. Bitte stellen Sie sicher, dass die angeforderten Dokumente sofort an: <span class="link">:email</span> gesendet werden.',
                'p14' => 'Wenn wir die angeforderten Dokumente nicht erhalten, wird die Buchung als ungültig betrachtet und daher storniert. Alle Informationen werden vertraulich behandelt und nur für die oben genannten Zwecke verwendet.',
                'p15' => ':name – :address, :zip_code – :city_name <span class="link">:email</span> - <span class="link">:website</span>',
            ],
        ],
        'email' => [
            'subject' => ':property - Anforderungsbestätigung',
            'subject_accepted' => 'SCA/3DS Genehmigung wurde bestätigt',
            'subject_reservation' => ':name :surname, bestätigen Sie Ihre Buchung',
            'dear_customer_reservation' => 'Sehr geehrter :name :surname, <br /> Um Ihre Buchung zu garantieren, bitten wir Sie, die Nutzung Ihrer Kreditkarte gemäß den Buchungs- und Stornierungsbedingungen zu genehmigen.<br><br>Vielen Dank für Ihre Kooperation.',
            'dear_customer_payment' => 'Sehr geehrter :name :surname, <br /> Um Ihre Buchung zu garantieren, bitten wir Sie, die Nutzung Ihrer Kreditkarte gemäß den Buchungs- und Stornierungsbedingungen zu genehmigen.<br><br>Vielen Dank für Ihre Kooperation.',
            'your_reservation_for' => 'Ihre Buchung für :name',
            'you_payment_for' => 'Ihre Zahlung für :name',
            'we_are_waiting_for_you_on_date' => 'Wir erwarten Sie am :date',
            'reservation_summary' => 'Buchungszusammenfassung',
            'payment_summary' => 'Zahlungszusammenfassung',
            'reservation_total' => 'Buchungsbetrag',
            'payment_total' => 'Zahlungsbetrag',
            'authorize_card_use' => 'Genehmigung der Kartennutzung',
            'payment_click_here_link' => 'Klicken Sie hier, um die Zahlung zu bestätigen',
            'non_beddy_payment_click_here_link' => 'Um die Buchung zu bestätigen, gehen Sie zu folgendem Link: :link',
            'non_beddy_reservation_click_here_link' => 'Um die Zahlung zu bestätigen, gehen Sie zu folgendem Link: :link',
            'date' => 'Datum',
            'reservation_confirmation' => 'Buchungsbestätigung Nummer :referenceNumber',
            'payment_confirmation' => 'Zahlungsbestätigung',
            'sca_reservation_accepted' => 'Wir informieren Sie, dass Ihre Anfrage zur Bestätigung des SCA/PSD2-Moduls für die Buchung #:referenceNumber vom Kunden akzeptiert wurde.',
            'sca_payment_accepted' => 'Wir informieren Sie, dass Ihre Anfrage zur Bestätigung des SCA/PSD2-Moduls für die Buchung #:referenceNumber vom Kunden akzeptiert wurde.',
        ],
        'confirmation_request_expired' => 'Anforderung bereits abgelaufen',
        'whatsapp' => [
            'message' => 'Sehr geehrter :name :surname, um die Buchung # :referenceNumber (:arrivalDate - :departureDate) zu bestätigen, benötigen wir Ihre Genehmigung zur Nutzung der Kreditkarte. Klicken Sie hier :link',
        ],
    ],

    'social_archive' => [
        'export_fields' => [
            'property_name' => 'Unterkunft',
            'unlock_email' => 'E-Mail',
            'unlock_date' => 'Anmeldedatum',
        ],
    ],

    'statistics' => [
        'partitioning_translations' => [
            'yearly' => 'vor einem Jahr|vor :value Jahren',
            'monthly' => 'vor einem Monat|vor :value Monaten',
            'daily' => 'vor einem Tag|vor :value Tagen',
        ],
        'warnings' => [
            'limit_truncation' => 'Die angeforderte Ansicht für einen zu weiten Zeitraum wurde begrenzt. Der Suchbereich wurde auf :partitioning_translation eingeschränkt.',
            'previous_offset_available_only_with_daily_partitioning' => 'Der Vergleichstyp ist nur bei täglicher Ansicht verfügbar. Der gewählte Zeitraum wird mit dem Vorjahr verglichen.',
        ],
        'exceptions' => [
            'invalid_split' => 'Vorgang nicht verfügbar',
            'not_available' => 'Funktion derzeit nicht verfügbar',
            'cannot_create_groupable' => 'Ungültige Parameter für die Gruppierung',
            'invalid_date_range' => 'Ungültige Datumsangaben',
        ],
        'legend' => [
            'no_model' => 'Nicht angegeben',
            'deleted_rateplans' => 'Gelöschte Tarife',
            'no_treatment' => 'Nicht angegebenes Behandlungspaket',
            'charges' => 'Manuelle Extras',
            'no_label' => 'Kein Name',
            'stay' => 'Aufenthalte',
            'tax' => 'Steuern',
            'ob' => 'Overbooking',
            'virtual_stamp' => 'Virtueller Stempel',
            'city_tax' => 'City Tax',
            'no_show' => 'No Show',
            'cancellation' => 'Stornierung nach Frist',
            'no_show_stay' => 'Stay in No Show',
            'cancellation_stay' => 'Stay in Cancellation after Terms',
            'no_show_extra' => 'Extra Service in No Show',
            'cancellation_extra' => 'Extra Service in Cancellation after Terms',
            'penalty' => 'Strafgebühren',
            'general_invoices' => 'Offene Rechnungen',
            'manual' => 'Manuelle Gebühren',
            'payment' => 'Anzahlungen',
            'beddy_channel_labels' => [
                'quote' => 'Beddy (Angebote)',
                'website' => 'Beddy (Webseite)',
                'manual' => 'Beddy (PMS)',
                'general' => 'Beddy (Offene Rechnungen)',
                'google-hotel' => 'Google Hotel',
                'trivago-fast-connect' => 'Trivago',
                'trivago-express-booking' => 'Trivago Express Booking',
                'bookingbooster' => 'Booking Booster',
            ],
        ],
        'label' => 'Datum',
        'label_date' => 'Referenzdatum',
        'label_channel' => 'Kanalsegment',
        'label_accommodation' => 'Zimmertyp',
        'label_room' => 'Raumnummer',
        'label_booker_category' => 'Kundengruppe',
        'label_rateplan' => 'Tarifplan',
        'label_reservation_from' => 'Buchungsquelle',
        'label_nationality' => 'Nationalität',
        'label_property' => 'Unterkunft',
        'label_dealer_company' => 'Agenturunternehmen',
        'label_dealer_agency' => 'Agentur',
        'label_dealer_tour_operator' => 'Reiseveranstalter',
        'label_production_type' => 'Abteilungssegment',
        'production_over_time' => 'Verkäufe über Zeitraum',
        'revenue' => 'Umsatz',
        'production' => 'Produktion über Zeitraum',
        'available_nights' => 'Verfügbare Nächte',
        'unsold_nights' => 'Nicht verkaufte Nächte',
        'penalty_nights' => 'Penalnächte',
        'arrivals' => 'Ankünfte',
        'departures' => 'Abreisen',
        'average_stay_length' => 'Durchschnittliche Aufenthaltsdauer',
        'average_guest_earning' => 'Durchschnittlicher Gastumsatz',
        'sold_nights' => 'Verkaufte Nächte',
        'occupation_percentage' => 'Belegungsrate',
        'total_price' => 'Gesamtverkauf',
        'adr' => 'ADR',
        'revpar' => 'RevPar',
        'counted_reservations' => 'Gesamtbuchungen',
        'confirmed_reservations' => 'Bestätigte Buchungen',
        'cancelled_reservations' => 'Stornierte Buchungen',
        'cancellation_ratio' => 'Stornierungsrate',
        'counted_average_booking_window' => 'Durchschnittliches Buchungsfenster (gesamt)',
        'confirmed_average_booking_window' => 'Durchschnittliches Buchungsfenster (bestätigt)',
        'cancelled_average_booking_window' => 'Durchschnittliches Stornierungsfenster',
        'rooms_checkin' => 'Zimmer bei Ankunft',
        'rooms_checkout' => 'Zimmer bei Abreise',
        'label_department' => 'Abteilung',
        'label_service' => 'Service',
        'gross_amount' => 'Bruttobetrag',
        'share_percent' => 'Prozentanteil',
        'taxes' => 'Steuern',
        'net_amount' => 'Nettobetrag ohne Steuern',
        'quantity' => 'Menge',
        'net_revenue' => 'Nettoumsatz',
        'commissions_amount' => 'Kommission',
        'in_stay_rooms' => 'Zimmer belegt',
        'presence_rooms' => 'Zimmer vorhanden',
        'in_stay_guests' => 'Anwesende Gäste',
        'presence_guests' => 'Präsente Gäste',
        'absolute_guests' => 'Gesamtzahl Gäste',
        'gross_amount_without_commissions' => 'Bruttobetrag ohne Kommissionen',
        'net_amount_without_commissions' => 'Netto ohne Kommissionen und Steuern',
        'gt_revenue' => [
            'rooms' => [
                'date' => 'DATUM',
                'hotel_capacity' => 'HOTEL_KAPAZITÄT',
                'rooms_sold' => 'VERKAUFTE_ZIMMER',
                'rooms_ooo' => 'NICHT_VERFÜGBAR',
                'rooms_revenue' => 'UMSATZ_ZIMMER',
            ],
            'segments' => [
                'date' => 'DATUM',
                'cam_business' => 'KAM_BUSINESS',
                'rev_business' => 'REV_BUSINESS',
                'cam_tour_operator' => 'KAM_TOUR_OPERATOR',
                'rev_tour_operator' => 'REV_TOUR_OPERATOR',
                'cam_ota' => 'KAM_OTA',
                'rev_ota' => 'REV_OTA',
                'cam_beddy' => 'KAM_BEDDY',
                'rev_beddy' => 'REV_BEDDY',
                'cam_diretta' => 'KAM_DIRETTA',
                'rev_diretta' => 'REV_DIRETTA',
            ],
        ],
    ],

    'stripe' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Unbekannter allgemeiner Fehler.',
                'next_steps' => 'Kontaktieren Sie den technischen Support.',
            ],
            'approve_with_id' => [
                'description' => 'Die Zahlung kann nicht genehmigt werden.',
                'next_steps' => 'Die Zahlung sollte erneut versucht werden. Wenn sie weiterhin nicht verarbeitet werden kann, sollte der Kunde den Kartenaussteller kontaktieren.',
            ],
            'customer_max_payment_methods' => [
                'description' => 'Der Kunde hat bereits die maximale Anzahl an Zahlungsmethoden verknüpft.',
                'next_steps' => 'Trennen Sie einige Zahlungsmethoden vom Kunden oder verwenden Sie einen anderen Kunden.',
            ],
            'call_issuer' => [
                'description' => 'Die Karte wurde aus unbekannten Gründen abgelehnt.',
                'next_steps' => 'Der Kunde sollte den Kartenaussteller für weitere Informationen kontaktieren.',
            ],
            'card_not_supported' => [
                'description' => 'Die Karte unterstützt diesen Kauf nicht.',
                'next_steps' => 'Der Kunde sollte eine andere Zahlungsmethode verwenden.',
            ],
            'card_velocity_exceeded' => [
                'description' => 'Der Kunde hat das Ausgabelimit auf der Karte überschritten.',
                'next_steps' => 'Der Kunde sollte eine Weile warten, bevor er es erneut versucht, oder eine andere Karte verwenden.',
            ],
            'currency_not_supported' => [
                'description' => 'Die Karte unterstützt die angegebene Währung nicht.',
                'next_steps' => 'Der Kunde sollte eine Karte verwenden, die diese Währung unterstützt.',
            ],
            'do_not_honor' => [
                'description' => 'Die Karte wurde abgelehnt.',
                'next_steps' => 'Der Kunde sollte den Kartenaussteller für weitere Informationen kontaktieren.',
            ],
            'do_not_try_again' => [
                'description' => 'Die Karte wurde abgelehnt.',
                'next_steps' => 'Versuchen Sie die Zahlung nicht erneut. Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'duplicate_transaction' => [
                'description' => 'Eine Transaktion mit demselben Betrag und denselben Daten wurde kürzlich gesendet.',
                'next_steps' => 'Der Kunde sollte warten und es später erneut versuchen.',
            ],
            'expired_card' => [
                'description' => 'Die Karte ist abgelaufen.',
                'next_steps' => 'Der Kunde sollte eine andere Karte verwenden.',
            ],
            'fraudulent' => [
                'description' => 'Die Transaktion wurde abgelehnt, weil sie verdächtigt wurde, betrügerisch zu sein.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'generic_decline' => [
                'description' => 'Die Karte wurde abgelehnt.',
                'next_steps' => 'Der Kunde sollte den Kartenaussteller für weitere Informationen kontaktieren.',
            ],
            'incorrect_number' => [
                'description' => 'Die eingegebene Kartennummer ist nicht korrekt.',
                'next_steps' => 'Der Kunde sollte die Kartennummer überprüfen oder eine andere Karte verwenden.',
            ],
            'incorrect_cvc' => [
                'description' => 'Der Sicherheitscode der Karte (CVC) ist nicht korrekt.',
                'next_steps' => 'Der Kunde sollte den CVC überprüfen oder eine andere Karte verwenden.',
            ],
            'incorrect_pin' => [
                'description' => 'Die eingegebene PIN ist nicht korrekt.',
                'next_steps' => 'Der Kunde sollte die richtige PIN eingeben.',
            ],
            'incorrect_zip' => [
                'description' => 'Die Postleitzahl ist nicht korrekt.',
                'next_steps' => 'Der Kunde sollte seine Postleitzahl überprüfen.',
            ],
            'insufficient_funds' => [
                'description' => 'Die Karte hat nicht genügend Guthaben.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'invalid_account' => [
                'description' => 'Die Karte oder das Konto existiert nicht.',
                'next_steps' => 'Der Kunde sollte die Karteninformationen überprüfen oder eine andere Zahlungsmethode verwenden.',
            ],
            'invalid_amount' => [
                'description' => 'Der Zahlungsbetrag ist ungültig.',
                'next_steps' => 'Überprüfen Sie den Betrag und versuchen Sie es erneut.',
            ],
            'invalid_cvc' => [
                'description' => 'Der Sicherheitscode der Karte (CVC) ist ungültig.',
                'next_steps' => 'Der Kunde sollte den CVC überprüfen oder eine andere Karte verwenden.',
            ],
            'invalid_expiry_year' => [
                'description' => 'Das Ablaufjahr der Karte ist ungültig.',
                'next_steps' => 'Der Kunde sollte das Ablaufdatum überprüfen oder eine andere Karte verwenden.',
            ],
            'invalid_number' => [
                'description' => 'Die Kartennummer ist ungültig.',
                'next_steps' => 'Der Kunde sollte die Kartennummer überprüfen oder eine andere Karte verwenden.',
            ],
            'issuer_not_available' => [
                'description' => 'Der Kartenaussteller ist nicht verfügbar.',
                'next_steps' => 'Der Kunde sollte es später erneut versuchen.',
            ],
            'lost_card' => [
                'description' => 'Die Karte wurde als verloren gemeldet.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'merchant_blacklist' => [
                'description' => 'Die Zahlung wurde aufgrund der Händlerregeln abgelehnt.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'new_account_information_available' => [
                'description' => 'Es gibt neue Informationen zum Kartenkonto.',
                'next_steps' => 'Der Kunde sollte die aktualisierten Informationen mit seiner Bank überprüfen.',
            ],
            'no_action_taken' => [
                'description' => 'Der Kartenaussteller hat keine Aktion ergriffen.',
                'next_steps' => 'Der Kunde sollte den Kartenaussteller für weitere Informationen kontaktieren.',
            ],
            'not_permitted' => [
                'description' => 'Die Zahlung ist nicht erlaubt.',
                'next_steps' => 'Der Kunde sollte den Kartenaussteller für weitere Informationen kontaktieren.',
            ],
            'offline_pin_required' => [
                'description' => 'Ein Offline-PIN wird benötigt.',
                'next_steps' => 'Der Kunde sollte die richtige PIN eingeben.',
            ],
            'online_or_offline_pin_required' => [
                'description' => 'Ein Online- oder Offline-PIN wird benötigt.',
                'next_steps' => 'Der Kunde sollte die richtige PIN eingeben.',
            ],
            'pickup_card' => [
                'description' => 'Die Karte muss eingezogen werden.',
                'next_steps' => 'Der Kunde sollte den Kartenaussteller für weitere Informationen kontaktieren.',
            ],
            'pin_try_exceeded' => [
                'description' => 'Der Kunde hat die maximale Anzahl an fehlgeschlagenen PIN-Versuchen überschritten.',
                'next_steps' => 'Der Kunde sollte den Kartenaussteller kontaktieren, um die PIN zu entsperren oder eine alternative Zahlungsmethode verwenden.',
            ],
            'processing_error' => [
                'description' => 'Es ist ein Verarbeitungsfehler aufgetreten.',
                'next_steps' => 'Der Kunde sollte es später erneut versuchen.',
            ],
            'reenter_transaction' => [
                'description' => 'Die Zahlung muss erneut eingegeben werden.',
                'next_steps' => 'Der Händler muss die Zahlung erneut eingeben.',
            ],
            'restricted_card' => [
                'description' => 'Die Karte kann für diese Zahlung nicht verwendet werden.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'revocation_of_all_authorizations' => [
                'description' => 'Die Karte wurde abgelehnt.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'revocation_of_authorization' => [
                'description' => 'Die Karte wurde abgelehnt.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'security_violation' => [
                'description' => 'Die Karte wurde aufgrund einer Sicherheitsverletzung abgelehnt.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'service_not_allowed' => [
                'description' => 'Der Service ist nicht erlaubt.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'stolen_card' => [
                'description' => 'Die Karte wurde als gestohlen gemeldet.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'stop_payment_order' => [
                'description' => 'Die Zahlung wurde vom Kunden gestoppt.',
                'next_steps' => 'Der Kunde sollte eine alternative Zahlungsmethode verwenden.',
            ],
            'testmode_charges_only' => [
                'description' => 'Ihr Konto wurde nicht aktiviert und kann nur Testabbuchungen durchführen.',
                'next_steps' => 'Aktivieren Sie Ihr Konto im Dashboard, um echte Abbuchungen zu verarbeiten.',
            ],
            'testmode_decline' => [
                'description' => 'Eine Stripe-Testkarte wurde verwendet.',
                'next_steps' => 'Verwenden Sie eine echte Zahlungsmethode.',
            ],
            'transaction_not_allowed' => [
                'description' => 'Die Transaktion ist nicht erlaubt.',
                'next_steps' => 'Der Kunde sollte den Kartenaussteller für weitere Informationen kontaktieren.',
            ],
            'try_again_later' => [
                'description' => 'Der Kartenaussteller hat die Anfrage nicht genehmigt.',
                'next_steps' => 'Der Kunde sollte es später erneut versuchen.',
            ],
        ],
    ],

    'tableau' => [
        'errors' => [
            'roomNotFound' => 'Zimmer nicht gefunden oder existiert nicht',
            'tableauNumberNotFound' => 'Zimmernummer ist nicht korrekt.',
            'closureConflict' => 'Sie können keine Schließungszeiträume überschneiden.',
            'lockedRoom' => 'Das Zimmer ist gesperrt oder im Übergangszimmer, Änderungen sind nicht möglich.',
            'lockedAccommodation' => 'Der Zimmertyp ist gesperrt und nicht änderbar.',
            'reservation_accommodation_not_fund' => 'Das gebuchte Zimmer wurde nicht gefunden.',
            'accommodation_destination_not_found' => 'Das Zielzimmer wurde nicht gefunden.',
            'accommodation_destination_treatment_not_found' => 'Die Behandlung ist für das gewählte Zimmer nicht aktiv.',
            'accommodation_destination_rateplan_not_found' => 'Der ausgewählte Tarif ist für das gewählte Zimmer nicht aktiv.',
            'reservation_locked' => 'Diese Buchung hat einen Sperrstatus, Änderungen sind nicht möglich.',
            'exists_reservation_destination' => 'Im Zielzimmer ist bereits eine Buchung vorhanden, Fortfahren ist nicht möglich!',
            'split_checkin_minor' => 'Das angegebene Check-in-Datum ist früher als das Check-in-Datum der Buchung.',
            'split_checkout_major' => 'Das angegebene Check-out-Datum ist später als das Check-out-Datum der Buchung.',
            'split_incompatible_rates' => 'Das Zielzimmer ist inkompatibel, da es nicht denselben Tarif wie das Quellzimmer hat.',
            'exists_tableau_closure' => 'Im Zielzimmer gibt es eine Schließung, entfernen Sie die Tableau-Schließung, bevor Sie fortfahren.',
            'exists_reservation_closure' => 'Im ausgewählten Zeitraum sind Buchungen vorhanden, das Zimmer kann nicht geschlossen werden.',
            'reservation_not_found' => 'Buchung nicht gefunden.',
            'reservation_accommodation_keep_activated' => 'Das Zimmer kann nicht verschoben werden. Entfernen Sie die Sperre aus den Buchungsdetails, um fortzufahren.',
            'reservation_moved_or_cancelled' => 'Die Buchung wurde verschoben oder storniert.',
            'reservation_is_moving' => 'Achtung, es läuft bereits eine Änderung der Buchung. Aktualisieren Sie das Tableau und versuchen Sie es später noch einmal.',
            'closure_just_creating' => 'Es wird noch eine Schließung für dieses Zimmer durchgeführt, bitte später noch einmal versuchen.',
            'closure_just_removing' => 'Die Entfernung der Schließung für dieses Zimmer ist noch in Bearbeitung, bitte später noch einmal versuchen.',
        ],
        'warnings' => [
            'tableauNumberWillBeChanged' => 'Achtung, das Zimmer wird auf die Nummer :newTableauNumber verschoben.',
        ],
    ],

    'technical_notices' => [
        'email' => [
            'failed_log_job_title' => 'Fehler beim Senden des SendLogJobs',
        ],
        'errors' => [
            'channel_unsupported' => 'Kanal nicht unterstützt',
            'property_not_found' => 'Unterkunft nicht gefunden',
        ],
    ],

    'templates_snippets_categories' => [
        'reservation_data' => 'Reservierungsdaten',
        'property_data' => 'Immobiliendaten',
        'automatism' => 'Automatismen',
        'reservations_accommodation_datails' => 'Details der gebuchten Unterkünfte',
        'reservation_personal_data' => 'Persönliche Daten des Buchenden',
        'payments_data' => 'Zahlungsdaten',
        'cancellation_policy_data' => 'Daten zur Stornierungsrichtlinie',
        'estimate_data' => 'Kostenvoranschlagsdaten',
        'tax_document_data' => 'Steuerdokumentdaten',
        'payments_timetable' => 'Geplante Zahlungen',
    ],

    'users' => [
        'new' => [
            'title' => 'Neuer Benutzer :username',
            'message' => 'Ein neuer Benutzer wurde von :self_username erstellt',
        ],
        'update' => [
            'title' => 'Benutzer :username geändert',
            'message' => 'Benutzer :username wurde erfolgreich geändert',
            'missing_email_verification_code' => 'Die Änderung, die Sie vornehmen möchten, erfordert eine Bestätigung. Wir haben eine Benachrichtigung an Ihre aktuelle E-Mail-Adresse gesendet.',
        ],
        'delete' => [
            'title' => 'Benutzer :username gelöscht',
            'message' => 'Benutzer :username wurde erfolgreich gelöscht',
            'error_delete_1' => 'Sie können Ihr eigenes Konto nicht löschen.',
        ],
        'errors' => [
            'emailnotfound' => 'Ungültige E-Mail',
            'passwordIncorrect' => 'Das aktuelle Passwort ist ungültig',
            'reminderNotValid' => 'Ungültiger oder abgelaufener Code',
            'propertyAttached' => 'Der Benutzer und die Unterkunft sind bereits verbunden',
            'propertyDetached' => 'Der Benutzer und die Unterkunft sind nicht miteinander verbunden',
            'permissionNotFound' => 'Einer der Berechtigungen fehlt für diesen Benutzer',
            'tokenNotGenerated' => 'Fehler bei der Generierung des Tokens',
            'username_exists' => 'Der Benutzername wird bereits verwendet',
            'email_exists' => 'Die E-Mail-Adresse wird bereits verwendet',
            'user_not_allowed' => 'Der eingeloggte Benutzer ist nicht berechtigt, neue Benutzer zu erstellen',
            'cannot_detach_all_auth_verification_methods' => 'Es ist nicht möglich, alle Verifizierungsmethoden zu trennen, mindestens eine muss aktiv sein.',
            'no_active_properties' => 'Es sind keine aktiven Unterkünfte mit deinem Konto verknüpft. Bitte wende dich an den Beddy-Support, um Unterstützung zu erhalten.'
        ],
    ],

    'vat_quote' => [
        'related_model' => [
            'accommodation' => 'Unterkunft',
            'addon' => 'Zusatzdienst',
            'city_tax' => 'Stadtsteuer',
            'manual_charge' => 'Manuell eingegebene Gebühr',
            'expense_category' => 'Ausgabenkategorie',
            'reservation_payment' => 'Rechnungen und Anzahlungsbelege',
            'place_tax' => 'Stempelsteuer',
            'reservation_no_show' => 'No Show',
            'reservation_cancellation' => 'Stornierung nach Frist',
        ],
        'log_module' => [
            'vat_quote_created' => 'Mehrwertsteuersatz erstellt',
            'vat_quote_updated' => 'Mehrwertsteuersatz aktualisiert',
            'vat_quote_deleted' => 'Mehrwertsteuersatz gelöscht',
            'vat_quote_default_created' => 'Standard-Mehrwertsteuersatz erstellt',
            'vat_quote_default_updated' => 'Standard-Mehrwertsteuersatz aktualisiert',
            'vat_quote_default_deleted' => 'Standard-Mehrwertsteuersatz gelöscht',
            'property_vat_quote_added' => 'Mehrwertsteuersatz hinzugefügt',
            'property_vat_quote_replaced' => 'Mehrwertsteuersatz ersetzt',
        ],
        'errors' => [
            'vat_quote_associated' => 'MwSt.-Satz ist als Standard für einige Strukturen festgelegt, Fortfahren nicht möglich',
            'insufficient_default_number' => 'Löschen des folgenden Mehrwertsteuersatzes nicht möglich, da keine Standard-Mehrwertsteuersätze mehr für die folgenden Felder vorhanden wären: ',
            'invalid_place_id' => 'Der Parameter Land hat keinen gültigen Wert.'
        ]
    ],

    'venice_exemption' => [
        'errors' => [
            'CDAError' => 'Die ausgewählten Daten sind vom Gemeindeverwaltung von Venedig nicht vorgesehen.',
        ],
    ],

    'vrbo' => [
        'checkpoints' => [
            'IsActiveByOwner' => 'Überprüfen Sie, ob die Verteilung auf Vrbo aktiv ist',
            'IsListingNotArchived' => 'Die Unterkunft ist auf Vrbo archiviert. Kontaktieren Sie den Vrbo-Support',
            'IsActiveByCsr' => 'Der Vrbo-Support hat die Unterkunft deaktiviert. Kontaktieren Sie den Vrbo-Support',
            'HasImages' => 'Es fehlen Bilder (mindestens 6)',
            'HasValidatedAddress' => 'Ungültige Adresse',
            'HasGeoCode' => 'Ungültige oder fehlende GPS-Koordinaten',
            'HasPropertyAddress' => 'Ungültige Adresse',
            'HasBathroom' => 'Es fehlen die Badezimmerangaben',
            'HasMaxOccupancy' => 'Es fehlen Informationen zur Belegung',
            'HasPropertyDescription' => 'Es fehlt die Beschreibung',
            'HasPropertyHeadline' => 'Es fehlt die Beschreibung',
            'HasPropertyName' => 'Es fehlt der Name',
            'HasPropertyType' => 'Es fehlt der Unterkunftstyp',
            'HasRates' => 'Es fehlen Preise/Verfügbarkeiten',
            'HasRegistrationNumber' => 'Es fehlt die Registrierungsnummer',
        ],
    ],

    'webcontroller' => [
        'downloader' => [
            'title_waiting' => 'Bitte warten...',
            'message_waiting' => 'Die angeforderte Operation wird durchgeführt... Vielen Dank für Ihre Geduld',
            'title_started' => 'Download gestartet',
            'message_started' => 'Der Download wurde gestartet. Sobald der Download abgeschlossen ist, können Sie dieses Fenster schließen',
            'title_error' => 'Fehler!',
            'message_error' => 'Ein Fehler ist bei der Bearbeitung der Anfrage aufgetreten.<br> Bitte kontaktieren Sie uns.',
        ],
        'metasearch' => [
            'title_error' => 'Fehler!',
            'message_error' => 'Ein Fehler ist bei der Bearbeitung der Anfrage aufgetreten.',
        ],
    ],

    'welcome_automatic_email' => [
        'email' => [
            'preview_text' => 'Nützliche Informationen, um betriebsbereit zu sein',
            'subject' => 'Willkommen bei Beddy - Lassen Sie uns mit der Konfiguration beginnen!',
            'greetings_text' => 'Das war’s für heute, wir bedanken uns nochmals, dass Sie sich für unsere Dienstleistungen entschieden haben.<br><br>Das Team von Beddy',
            'training_pms_text_button' => 'PMS VIDEO TRAINING',
            'training_pms_channel_button' => 'CHANNEL MANAGER VIDEO TRAINING',
            'model_welcome' => [
                'subject' => 'Willkommen bei Beddy - Erste Schritte und wichtige Informationen',
                'preview_text' => 'Alles, was Sie wissen müssen',
                'body_1' => 'Willkommen bei Beddy,  
                <br><br>
                Vielen Dank, dass Sie unseren Service gewählt haben. Bitte <b>folgen Sie aufmerksam den Anweisungen, die Sie in den nächsten Mitteilungen erhalten</b>. Wir empfehlen Ihnen, die E-Mail-Adressen support@beddy.io und info@beddy.io in das Adressbuch Ihres E-Mail-Anbieters aufzunehmen, damit unsere E-Mails nicht im Spam-Ordner landen. 
                <br><br>
                Hier sind die Anleitungen für die gängigsten Anbieter: 
                <br><br>
                <a href="https://support.google.com/contacts/answer/1069522">Fügen Sie einen Kontakt in Gmail hinzu</a>
                <br><br>
                <a href="https://support.microsoft.com/it-it/office/aggiungere-un-contatto-e1dc4548-3bd6-4644-aecd-47b5728f7b0d#ID0EAABAAA=Newer_versions">Fügen Sie einen Kontakt in Outlook hinzu</a>',
                'greetings_text' => 'Wir bedanken uns nochmals, dass Sie sich für unsere Dienstleistungen entschieden haben.<br><br>Das Team von Beddy',
            ],
            'model_A' => [
                'body_1' => 'Hallo :userMasterName,
                <br><br>
                Nachfolgend finden Sie die nächsten Schritte, um Ihr Beddy-Konto einzurichten.  
                <br><br>
                &nbsp;&nbsp;<b>01. Erste Schritte - Allgemeine Konfiguration</b>
                <br><br>
                Wir werden Sie in Kürze kontaktieren, um Ihr Beddy-Konto einzurichten.
                <br><br>
                Die Erstkonfiguration ist sehr wichtig und bereitet die folgenden Schritte vor.
                <br><br>
                Wir empfehlen Ihnen, das <b>angehängte Excel-Formular auszufüllen</b>, bevor Sie einen Termin mit unserem Operator vereinbaren, um die Konfigurationszeit zu verkürzen.
                <br><br>
                Die Datei enthält mehrere Tabellenblätter, die alle ausgefüllt werden müssen.<br>
                Nach Abschluss senden Sie bitte die Datei an <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                Alle Felder im beigefügten Formular sind erforderlich; fehlende Informationen können die Einrichtung Ihres Beddy-Kontos verzögern.
                <br><br>
                Wenn Sie ein Multi-Struktur-Konto verwalten, müssen Sie die Excel-Datei kopieren und für jede Struktur ausfüllen.
                <br><br>
                Am Ende der Konfiguration erhalten Sie Ihre Zugangsdaten.',
                'body_2' => '&nbsp;&nbsp;<b>02. Schulung - PMS Training</b>
                <br><br>
                Nach Abschluss der Konfiguration werden wir Sie kontaktieren, um einen Termin für die <b>Schulung</b> zu den PMS-Funktionen zu vereinbaren.
                <br><br>
                Die Schulung dauert <b>90 Minuten</b> und auch Mitarbeiter können teilnehmen.
                <br><br>
                Während Sie auf die Schulung warten, empfehlen wir Ihnen, sich mit den Funktionen der Software durch das Online-Training vertraut zu machen.',
                'body_3' => '&nbsp;&nbsp;<b>03. Verbindung der Channels - Channel Manager Konfiguration</b>
                <br><br>
                Nach Abschluss des PMS-Trainings wird ein neues Treffen zur Verbindung der Channels geplant. Bitte beachten Sie, dass nach der Aktivierung des Channel Managers keine Nutzung der OTAs-Extranets oder des alten Channel Managers mehr möglich ist.',
                'body_4' => '&nbsp;&nbsp;<b>04. Schulung - Channel Manager Training</b>
                <br><br>
                Nach Abschluss der Verbindung wird Ihnen ein Training angeboten, um die Funktionen des Channel Managers zu erlernen, das am gleichen Tag um 12:30 Uhr stattfindet.
                <br><br>
                Das Training dauert <b>30 Minuten</b> und auch Mitarbeiter können teilnehmen.
                <br><br>
                Während Sie auf das Training warten, empfehlen wir Ihnen, sich mit den Funktionen der Software durch das Online-Training vertraut zu machen.',

            ],
            'model_B' => [
                'body_1' => 'Hallo :userMasterName,
                <br><br>
                Nachfolgend finden Sie die nächsten Schritte, um Ihr Beddy-Konto einzurichten.
                <br><br>
                &nbsp;&nbsp;<b>01. Erste Schritte - Allgemeine Konfiguration</b>
                <br><br>
                Wir werden Sie in Kürze kontaktieren, um Ihr Beddy-Konto einzurichten.
                <br><br>
                Die Erstkonfiguration ist sehr wichtig und bereitet die folgenden Schritte vor.
                <br><br>
                Wir empfehlen Ihnen, das <b>angehängte Excel-Formular auszufüllen</b>, bevor Sie einen Termin mit unserem Operator vereinbaren, um die Konfigurationszeit zu verkürzen.
                <br><br>
                Die Datei enthält mehrere Tabellenblätter, die alle ausgefüllt werden müssen.<br>
                Nach Abschluss senden Sie bitte die Datei an <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                Alle Felder im Formular sind erforderlich; fehlende Informationen können die Einrichtung verzögern.
                <br><br>
                Wenn Sie ein Multi-Struktur-Konto verwalten, kopieren Sie bitte die Excel-Datei und füllen sie für jede Struktur aus.',
                'body_2' => '&nbsp;&nbsp;<b>02. Schulung - PMS Training</b>
                <br><br>
                Nach Abschluss der Konfiguration werden wir Sie kontaktieren, um einen Termin für die Schulung zu den PMS-Funktionen zu vereinbaren.
                <br><br>
                Die Schulung dauert <b>90 Minuten</b> und auch Mitarbeiter können teilnehmen.
                <br><br>
                Während Sie auf die Schulung warten, empfehlen wir Ihnen, sich mit den Funktionen der Software durch das Online-Training vertraut zu machen.',
                'body_3' => '&nbsp;&nbsp;<b>03. Schulung - Tarife & Verfügbarkeitsmanagement</b>
                <br><br>
                Nach Abschluss der PMS-Schulung werden wir Sie kontaktieren, um an der Schulung zu den Funktionen des Channel Managers teilzunehmen. Diese findet am gleichen Tag um 12:30 Uhr statt. Falls nicht verfügbar, vereinbaren wir einen neuen Termin.
                <br><br>
                Die Schulung dauert <b>30 Minuten</b> und auch Mitarbeiter können teilnehmen.
                <br><br>
                Während Sie auf die Schulung warten, empfehlen wir Ihnen, sich mit den Funktionen der Software durch das Online-Training vertraut zu machen.',
            ],
            'model_C' => [
                'body_1' => 'Hallo :userMasterName,
                <br><br>
                Nachfolgend finden Sie die nächsten Schritte, um Ihr Beddy-Konto einzurichten.
                <br><br>
                &nbsp;&nbsp;<b>01. Erste Schritte - Allgemeine Konfiguration</b>
                <br><br>
                Wir werden Sie in Kürze kontaktieren, um Ihr Konto einzurichten.
                <br><br>
                Die Erstkonfiguration ist sehr wichtig und bereitet die folgenden Schritte vor.
                <br><br>
                Wir empfehlen Ihnen, das <b>angehängte Excel-Formular auszufüllen</b>, bevor Sie einen Termin mit unserem Operator vereinbaren, um die Konfigurationszeit zu verkürzen.
                <br><br>
                Die Datei enthält mehrere Tabellenblätter, die alle ausgefüllt werden müssen.<br>
                Nach Abschluss senden Sie bitte die Datei an <a href="mailto:support@beddy.io">support@beddy.io</a>.
                <br><br>
                Alle Felder im Formular sind erforderlich; fehlende Informationen können die Einrichtung verzögern.',
                'body_2' => '&nbsp;&nbsp;<b>02. Schulung - Channel Manager Training</b>
                <br><br>
                Nach Abschluss der Konfiguration werden wir Sie kontaktieren, um an der Schulung zu den Funktionen des Channel Managers teilzunehmen. Die Schulungen finden am Montag um 15:00 Uhr sowie Mittwoch und Freitag um 11:30 Uhr statt.
                <br><br>
                Die Schulung dauert <b>60 Minuten</b> und auch Mitarbeiter können teilnehmen.
                <br><br>
                Während Sie auf die Schulung warten, empfehlen wir Ihnen, sich mit den Funktionen der Software durch das Online-Training vertraut zu machen.',
                'body_3' => '&nbsp;&nbsp;<b>03. Verbindung der Portale - Channel Manager Konfiguration</b>
                <br><br>
                Nach Abschluss der Schulung wird ein weiterer Termin zur Verbindung der Portale geplant. Bitte beachten Sie, dass nach Aktivierung des Channel Managers die Nutzung der Portalextranets oder des alten Channel Managers nicht mehr möglich ist.',
            ],
            'model_D' => [
                'body_1' => 'Hallo :userMasterName,
                <br><br>
                Nachfolgend finden Sie die nächsten Schritte, um Ihr Beddy-Konto einzurichten. Bitte <b>lesen Sie diese Mitteilung sorgfältig</b> und geben Sie uns die notwendigen Daten, um die Einrichtung zu beschleunigen.
                <br><br>
                &nbsp;&nbsp;<b>01. Erste Schritte - Allgemeine Konfiguration</b>
                <br><br>
                Wir werden Sie bald kontaktieren, um Ihr Konto einzurichten.
                <br><br>
                Vor dem Termin mit unserem Operator bitten wir Sie:
                <br><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>das Excel-Formular auszufüllen</b><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>die Belegung der Unterkünfte und Preispläne</b> bei Ihrem externen Dienstleister zu erfragen, der an Beddy angeschlossen wird<br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>Formular und Belegung</b> an <a href="mailto:support@beddy.io">support@beddy.io</a> zu senden<br><br>
                Diese Informationen sind <b>sehr wichtig</b>, um die Einrichtung zu beschleunigen.
                <br><br>
                Alle Felder im Formular sind erforderlich; fehlende Informationen können die Einrichtung verzögern.
                <br><br>
                Wenn Sie ein Multi-Struktur-Konto verwalten, füllen Sie das Formular für jede Struktur aus und fordern Sie die Belegung separat an.
                <br><br>
                Am Ende der Einrichtung erhalten Sie Ihre Zugangsdaten.',
                'body_2' => '&nbsp;&nbsp;<b>02. Schulung - PMS Training</b>
                <br><br>
                Nach Abschluss der Konfiguration werden wir Sie kontaktieren, um einen Termin für die Schulung zu den PMS-Funktionen zu vereinbaren. Die Schulungen finden am Dienstag um 15:00 Uhr und am Donnerstag um 10:00 Uhr statt.
                <br><br>
                Die Schulung dauert <b>90 Minuten</b> und auch Mitarbeiter können teilnehmen.
                <br><br>
                Während Sie auf die Schulung warten, empfehlen wir Ihnen, sich mit den Funktionen der Software durch das Online-Training vertraut zu machen.',
                'body_3' => '&nbsp;&nbsp;<b>03. Schulung - Channel Manager Training integriert in Beddy</b>
                <br><br>
                Am Ende des Verbindungsvorgangs wird ein Training angeboten, wie man PMS verwendet, um Preise, Verfügbarkeiten und Einschränkungen über den externen Channel Manager zu aktualisieren.
                <br><br>
                Die Schulungen finden Montag um 15:00 Uhr sowie Mittwoch und Freitag um 11:30 Uhr statt.
                <br><br>
                Die Schulung dauert 60 Minuten und auch Mitarbeiter können teilnehmen.
                <br><br>
                Wenn der Channel Manager im Modus "nur Reservierungsdownload" integriert ist, ist die Schulung optional, wird aber empfohlen, um Preise im PMS zu verwalten oder Angebote über Beddy zu erstellen.',
                'body_4' => '&nbsp;&nbsp;<b>04. Verbindung des in Beddy integrierten Channel Managers</b>
                <br><br>
                Nach Abschluss der PMS-Schulung wird ein neuer Termin zur Verbindung des externen Channel Managers mit Beddy geplant.',
            ],
            'errors' => [
                'fail_to_send' => 'Die angeforderte E-Mail konnte nicht an die Adresse :email_address gesendet werden',
            ],
        ],
        'errors' => [
            'fail_to_send' => 'Impossibile inviare la mail richiesta all\'indirizzo :email_address',
        ],
    ],

    'zdatalake' => [
        'Couple' => 'Couple',
        'Family' => 'Family',
        'Single' => 'Single',
        'Group' => 'Group',
    ],
    'booking_booster_configuration' => [
        'errors' => [
            'configuration_not_found' => 'Konfiguration nicht gefunden'
        ],
    ],
    'booking_booster' => [
        'errors' => [
            'auth_token' => 'Authentifizierungstoken von Booking Booster für diesen Fehler konnte nicht abgerufen werden: :error',
            'available_budget' => 'Verfügbares Budget für diesen Fehler konnte nicht abgerufen werden: :error',
            'campaigns_statistics' => 'Kampagnenstatistiken für diesen Fehler konnten nicht abgerufen werden: :error',
            'ads_statistics' => 'Die Anzeigenstatistiken konnten aufgrund dieses Fehlers nicht abgerufen werden: :error',
            'ads_details' => 'Die Anzeigendetails konnten aufgrund dieses Fehlers nicht abgerufen werden: :error',
            'property_targets' => 'Es ist nicht möglich, die Ziele der Immobilien für diesen Fehler abzurufen: :error',
            'client_error' => 'Falsche Anmeldeinformationen oder keine Berechtigung zum Zugriff auf die angeforderten Ressourcen. Details: :error',
            'server_error' => 'Wir haben technische Schwierigkeiten. Bitte versuchen Sie es später erneut. Details: :error',
            'connection_error' => 'Verbindung zu Booking Booster konnte nicht hergestellt werden. Bitte versuchen Sie es später erneut. Details: :error'
        ],
        'warnings' => [
            'property_not_mapped' => 'Die folgenden Objekte sind nicht zugeordnet und werden möglicherweise nicht korrekt in den Kampagnenstatistiken angezeigt: :propertyNames'
        ]
    ],
    'zpay' => [
        'declined_codes' => [
            'default' => [
                'description' => 'Unbekannter allgemeiner Fehler.',
                'next_steps' => 'Wenden Sie sich an den technischen Support.',
            ],
            'validation_failed' => [
                'description' => 'Kartenautorisierung fehlgeschlagen',
                'next_steps' => 'Der Kunde muss eine neue Karte verwenden.',
            ],
            'canceled' => [
                'description' => 'Die Anfrage wurde storniert',
                'next_steps' => 'Der Kunde muss eine neue Anfrage stellen.',
            ],
            'failed' => [
                'description' => 'Anfrage fehlgeschlagen',
                'next_steps' => 'Der Kunde muss eine neue Anfrage stellen.',
            ],
            'waiting_for_payment' => [
                'description' => 'Anfrage wartet auf Zahlung',
                'next_steps' => 'Der Kunde muss die Zahlung bestätigen.',
            ],
            'requires_capture' => [
                'description' => 'Anfrage wartet auf Bestätigung',
                'next_steps' => 'Der Kunde muss den Vorgang autorisieren.',
            ],
            'refunded' => [
                'description' => 'Zahlung erstattet',
                'next_steps' => 'Die Zahlung wurde erfolgreich erstattet.',
            ],
            'partially_refunded' => [
                'description' => 'Zahlung teilweise erstattet',
                'next_steps' => 'Die Zahlung wurde teilweise erstattet.',
            ],
            'processing' => [
                'description' => 'Die Zahlung wird verarbeitet',
                'next_steps' => 'Bitte warten Sie auf das Ergebnis des Vorgangs.',
            ],
        ],
    ]
];
