<?php
$suffix = ' per l\'ospite :customer_name, alloggio :tableau_number - :accommodation_name';
$roomReservationSuffix = ' 宿泊施設 :accommodation_name - 予約者 :reservation_booker - :reservation_reference_number';
$reservationSuffix = ' 予約で送信されるゲストの中に: :reservation_booker - :reservation_reference_number';
$customerReservationSuffix = ' :customer_name - :reservation_reference_number';
$customerEmptyDataSuffix = '予約 :reservation_reference_number のゲスト :customer_name のために';
return [
    'accommodations' => [
        'errors' => [
            'attachExist' => '既存の料金プラン',
            'detachNotExist' => 'この宿泊施設には料金プランがありません',
            'detachStandardRateplan' => '標準料金プランを削除することはできません',
            'guestsCnfigurationBase' => '基本料金には割引を適用できません',
            'virtualRidondanceConflict' => 'この宿泊施設を接続できません。すでに接続が設定されています',
            'parentTreeExist' => '親の部屋はすでに接続されているか、超過していることはできません',
            'quantityZero' => '最後の部屋を削除することはできません',
            'quantityNotValid' => '既存の数量と同じかそれ以下の数量を送信しています',
            'quantitySum' => '数量が一致しません',
            'quantitySuperior' => 'メインルームの人数を超えることはできません',
            'quantityWithReservation' => '既存の予約があるため、この部屋の数量は削除できません',
            'numberNotAvail' => '部屋番号が利用できません',
            'guestsConfigurationBase' => '基本設定には割引を適用できません',
            'tooManyAdults' => '大人の人数が制限を超えています',
            'tooManyChildren' => '子供の人数が制限を超えています',
            'stillConnected' => '部屋はまだ1つ以上のポータルに接続されています',
            'stillVirtual' => '部屋はまだ他の部屋に接続されています',
            'stillReserved' => 'この部屋には既存の予約があります',
            'notVirtualToSum' => 'この部屋の接続が不十分です',
            'notVirtualQty' => '部屋の割り当ては1でなければなりません',
            'notVirtualChildQty' => '接続された部屋の割り当ては1でなければなりません',
            'notVirtualSum' => 'これは合計部屋ではありません',
            'isVirtual' => '仮想部屋、操作は許可されていません',
            'isNotVirtual' => '仮想部屋ではないため、操作は許可されていません',
            'ruleToBundle' => '進行中のパッケージ料金ルールは削除できません',
            'noRateplanExist' => '施設に料金プランがありません',
            'ruleIsLocked' => 'リンクされた部屋のルールは変更できません',
            'duplicateLabel' => 'この名前はすでに:accommodationNameで使用されています',
        ],
        'warnings' => [
            'request_confirm_delete_tableau_number' => '接続された部屋があります、続けますか？',
            'accommodation_tableau_not_found' => 'テーブルID :tableau_number_id はこの部屋ID :accommodation_id に関連付けられていないか、見つかりませんでした',
            'accommodation_beds_types_combination_not_found' => 'ID :acc_bed_type_combination_id の組み合わせは部屋ID :accommodation_id に見つかりませんでした',
            'confimation_delete_father_and_childs_combinations' => "親設定の組み合わせ（ID: :combination_id）を削除しようとしています。進むと、すべての子設定の組み合わせも自動的に削除されます。続行してよろしいですか？",
            'invalid_facility' => '施設が互換性がありません',
        ],
        'channel' => [
            'single_use_exists' => '部屋 :accommodation_name - :acommodation_ratename はすでに関連付けられているか、作成されています',
            'single_use_dont_exists' => '部屋チャネルID :accommodation_channel_id は見つかりませんでした',
            'email' => [
                'new_title' => '新しい部屋がチャネル :channel_name に追加されました - 施設 :property_name - ID 施設 :property_id',
                'deleted_title' => '部屋がチャネル :channel_name から削除されました - 施設 :property_name - ID 施設 :property_id',
                'attached_title' => '未接続の部屋が施設 :property_name に見つかりました - ID 施設 :property_id',
                'conflict_rule' => 'ルールの衝突がチャネル :channel_name にあります - 施設 :property_name - ID 施設 :property_id',
            ],
        ],
        'fields' => [
            'model_name' => '部屋',
            'checkin' => 'チェックイン',
            'checkout' => 'チェックアウト',
            'checkin_hour' => 'チェックイン時間',
            'checkout_hour' => 'チェックアウト時間',
            'checkin_arrival_preference' => 'チェックインの優先順位',
        ],
    ],
    'account_renewal' => [
        'email' => [
            'subject' => 'Beddy施設自動更新 - :monthAndYear',
        ],
    ],
    'addon' => [
        'price_type' => [
            'xunit' => '単位ごと',
            // 1
            'xpax' => '1泊1名あたり',
            // 2
            'xweekxpax' => '1週間あたり1名',
            // 3
            'xbookxpax' => '1回のみ1名',
            // 4
            'xnight' => '1泊ごと',
            // 5
            'xweek' => '週ごと',
            // 6
            // 7
            'xbook' => '1回のみ',
        ],
        'warnings' => [
            'not_available' => '選択した期間は利用できません',
            'min_stay_violated' => '最低宿泊日数は :min_stay です',
            'max_stay_violated' => '最大宿泊日数は :max_stay です',
            'release_violated' => '最大リリース日数は :release です',
            'rateplan_excluded' => '料金プラン :rateplan は :date のエクストラサービスでは除外されています',
            'treatment_excluded' => 'トリートメント :treatment は :date のエクストラサービスでは除外されています',
            'weekdays_excluded' => '1つ以上の曜日が除外されています',
        ],
        'errors' => [
            'not_in_stay' => '選択した日付は部屋の宿泊期間外です',
            'not_found' => 'リクエストされた部屋にエクストラサービスが関連付けられていません',
            'billed_addon' => 'エクストラサービスは未払いの料金に関連しているため、キャンセルできません',
        ],
        'logger' => [
            'added' => ':label が :accommodation_name に価格 :price で追加されました (:date) #:id',
        ],
    ],
    'admin' => [
        'errors' => [
            'not_demo' => '施設はDEMOタイプでなければなりません',
            'no_accommodations' => '施設には宿泊施設がありません',
            'no_rateplans' => '施設には料金プランがありません',
            'channelmanager_module_needed' => 'Channel Manager モジュールがアクティブではありません',
            'channel_beddy_only' => '施設には現在Beddyチャネルのみがアクティブでなければなりません',
        ],
    ],
    'api_partners' => [
        'contacts_types' => [
            'manager_email' => '責任者のメールアドレス',
            'technical_manager_email' => '技術責任者のメールアドレス',
            'customer_service_email' => 'カスタマーサービスのメールアドレス',
            'commercial_requests_email' => '商業リクエスト用メールアドレス',
        ],
        'errors' => [
            'cannot_delete_has_users' => 'ユーザーが関連付けられているため、パートナーを削除できません',
            'action_not_allowed' => 'サービス :service を利用する権限がありません。',
            'max_days' => ':days日が最大の間隔です。',
            'date_filters' => '1つのリクエストにつき、使用できる日付フィルターは1種類のみで、同時に複数は使用できません。',
            'cannot_delete_guest_city_tax' => '予約 :reservationId のゲスト :guestId を削除できません。市税はすでに請求されています。',
            'too_many_reservation_ids' => '1回のリクエストで渡せるreservationIdは最大:max件までです。現在:count件渡されています。',
            'reservations_not_found' => '次の予約が見つからないか、アクセス権がありません: :ids',
            'customer_id_or_customer_required' => 'customerId または customer のいずれかを必ず指定してください。',
            'customer_id_and_customer_conflict' => 'customerId と customer を同時に指定することはできません。どちらか一方を選択してください。'
        ],
        'services' => [
            'ping' => 'Ping',
            'get_infos' => '情報取得',
            'hotel_rateplan' => '料金プラン',
            'push_availabilities' => '空室情報の更新',
            'push_rates' => '料金の更新',
            'reservations_lookup' => '予約の検索',
            'reservations_acknowledge' => '予約確認の受付',
            'hotel_res_modify_notif' => '予約変更通知',
            'reservation_send_message' => 'メッセージ送信',
            'reservation_message_status' => 'メッセージのステータス確認',
            'modify_reservation' => '予約の変更',
            'media' => '添付ファイル',
            'modify_media' => '添付ファイルの変更',
            'delete_media' => '添付ファイルの削除',
            'invoices' => '請求書',
            'credit_card' => 'クレジットカード',
            'all_guests' => '全てのゲスト',
            'get_invoices' => '請求書の取得',
            'generic_bol' => '予約エンジンに関する一般的な情報',
            'hotel_quote_request' => '見積もりリクエスト',
            'revenue_data' => '稼働率と収益に関するデータを取得する'
        ],
    ],
    'api_partner_detail' => [
        'fields' => [
            'country_id' => '国識別子',
            'city_id' => '都市識別子',
            'state_id' => '州識別子',
            'county_id' => '郡識別子',
        ]
    ],
    'auth_verification_methods' => [
        'your_pin' => 'BeddyのPINコード',
        'error_pin_invalid' => 'エラー。入力したPINコードが正しいか確認してください',
        'email_authentication' => [
            'get_connection_info_message' => '認証を完了するためのPINコードをメールでお送りしました。',
            'pin_invalid' => '入力したPINコードは無効です',
        ],
        'google_authentication' => [
            'get_connection_info_message' => 'Google Authenticatorを確認して、認証を完了するためのPINコードを取得してください。',
            'pin_invalid' => '入力したPINコードは無効です',
        ],
    ],
    'availability' => [
        'errors' => [
            'not_found' => 'この部屋の空室情報は見つかりませんでした',
        ],
    ],
    'bills' => [
        'ordination_of_date' => ':dateの注文',
        'vat_title' => '消費税番号',
        'accommodation' => '宿泊施設',
        'total' => '合計',
        'service' => 'サービス',
        'quantity_abbreviated' => '数量',
        'amount' => '金額',
        'sign' => '署名',
        'account_balance_by_date' => '日付別の取引明細',
        'account_balance_by_buyer' => '購入者別の取引明細',
        'account_balance_by_guest' => 'ゲスト別の取引明細',
        'account_balance_by_accommodation' => '宿泊施設別の取引明細',
        'account_balance' => '取引明細',
        'payer' => '支払者',
        'quantity' => '数量',
        'date' => '日付',
        'notes' => 'メモ',
        'scloby' => [
            'ordination_name' => 'Tilby販売',
            'ordination_from_sale' => 'Tilby販売から作成された注文',
            'confirmation_mode' => '確認方法',
            'confirmation_by_phone' => '電話番号',
            'confirmation_by_signature' => '署名',
        ],
        'log' => [
            'refunds' => ':bill_label (:bill_common_id)の請求額が:refunded分返金されました',
        ],
    ],
    'booking_onboard' => [
        'no_contract_found' => 'この施設に契約が見つかりません',
    ],
    'bookingengine' => [
        'addons_type' => [
            'xweek' => '週ごと',
            'xnight' => '1泊ごと',
            'xpax' => '1名1泊あたり',
            'xunit' => '単位ごと',
            'xbook' => '1予約あたり',
            'xbookxpax' => '1名一回限り',
            'xweekxpax' => '1名1週間あたり',
        ],
        'errors' => [
            'min_expense_coupon' => '現在の予約にはこのクーポンは適用できません',
            'min_stay_coupon' => '現在の予約の宿泊日数にはこのクーポンは適用できません',
            'max_stay_coupon' => '現在の予約の最大宿泊日数にはこのクーポンは適用できません',
            'invalid_days_coupon' => '現在の予約の曜日にはこのクーポンは適用できません',
            'invalid_stay_coupon' => '選択した宿泊期間にはこのクーポンは適用できません',
            'invalid_conditions_coupon' => '現在の予約の除外条件にはこのクーポンは適用できません',
            'invalid_periods_coupon' => '現在の予約の日程にはこのクーポンは適用できません',
            'invalid_coupon' => '無効なクーポンまたは存在しないクーポンです',
            'already_coupon' => '他のクーポンを適用することはできません',
            'availability_ended' => '選択した部屋の空室情報は終了しました',
            'cart_empty_accommodation' => 'カートに部屋がありません',
            'date_past_quote_expire' => '出発日が見積もりの期限を過ぎているため、部屋を見積もりに追加できません',
            'process_cart_date_past' => '出発日が今日以前の部屋があるため、手続きを進めることができません',
            'change_expire_date_quote_past' => '見積もりの期限が一部の部屋の出発日より前になっています',
            'quote_expired' => '見積もりは期限切れです',
            'quote_accepted' => '見積もりはすでに承認されています',
            'quote_not_active' => '見積もりは有効ではありません',
            'quote_just_confirmed' => '見積もりはすでに確認されているため、状態を変更できません',
            'payment_not_valid' => '無効な支払い方法です',
            'module_quote_not_active' => '見積もりモジュールがこの施設で有効ではありません',
            'quote_option_no_availability' => 'このオプションには空室がありません',
            'quote_option_no_availability_accommodation' => '一部の宿泊施設が利用できません。見積もりの確認時に確認してください。',
            'quote_option_no_availability_linked' => '宿泊施設が利用できません。他の宿泊施設とリンクされています。見積もりの確認時に確認してください。',
            'addon_excluded_from_coupon' => 'クーポンで除外されているため、アドオン ":addon_name" を追加できません',
            'unlock_wrong_accommodation' => '不正な部屋です。',
            'unlock_wrong_accommodation_to_property' => '施設に属していない部屋です。',
            'unlock_rateplan_not_unlockable' => 'オファーは解除できません。',
            'estimate_addon_failure' => '検索データが正しくありません',
            'step_not_complete' => '一部のステップが完了していません',
            'property_different' => '異なる施設の部屋が選択されています',
            'data_sent_not_correct' => '送信されたデータが正しくありません',
            'no_dns_found' => ':subdomainに関連付けられたDNSがありません',
            'no_payment_method_available' => '設定された支払い方法がありません',
            'session_expired' => 'セッションが期限切れです',
            'booking_in_progress' => '予約処理中です',
            'search_not_found' => '検索結果が見つかりません',
            'failed_to_create_reservation' => '予約作成中にエラーが発生しました',
            'create_order_already_exist' => '注文はすでに処理中です（キャッシュが存在します）- SID :sid',
            'create_quote_order_already_exist' => '見積もり注文はすでに処理中です（キャッシュが存在します）- 参照 :reference',
        ],
        'persuasive_sentences' => [
            'prepayment' => '前払い',
            'hotel_payment' => '施設で支払う。今は支払いません',
            'free_cancellation_until' => ':date_limitまで無料キャンセル',
            'cancellation_term' => '予約の規約と条件',
            'cheapest_rate' => 'これが最もお得な料金です',
        ],
        'payment_method_description' => [
            'transfer' => 'デポジットなしのテキスト',
            'transfer_deposit' => ':depositの前払いが必要であり、この金額はキャンセルポリシーに基づき返金されます。振込情報はメールでお送りします。',
            'cc_a_garanzia' => '追加費用なし！クレジットカードは予約の保証のためだけに使用されます。前払いは必要ありません。予約中に施設 :property_name で宿泊料金を支払います。',
            'cc_pos' => '追加費用なし！クレジットカードは予約の保証のためだけに使用されます。前払いは必要ありません。予約中に施設 :property_name で宿泊料金を支払います。',
            'cc_pos_deposit' => ':depositの前払いが必要であり、この金額はキャンセルポリシーに基づき返金されます。',
            'cc_stripe_deposit' => '支払いはStripe決済ゲートウェイを通じて行われます。 :depositの前払いが必要であり、この金額はキャンセルポリシーに基づき返金されます。',
            'nexi_deposit' => '支払いはNexi決済ゲートウェイを通じて行われます。 :depositの前払いが必要であり、この金額はキャンセルポリシーに基づき返金されます。 <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Nexiのプライバシーポリシー</a>',
            'zpay_deposit' => 'お支払いは ZPay の決済ゲートウェイを通じて行われます。:deposit の前払いが必要で、この金額は本料金のキャンセルポリシーで定められている場合に返金されます。<a href="https://www.zpay.it/privacy" target="_blank">ZPay プライバシーポリシー</a>。',
            'cc_paypal_deposit' => '支払いはPayPal決済ゲートウェイを通じて行われます。 :depositの前払いが必要であり、この金額はキャンセルポリシーに基づき返金されます。',
            'availability_request' => '高季節のため、現在のリクエストは正式な予約として無効ですが、以下のフォームを記入して空室情報をリクエストすることができます。予約リクエストはできるだけ早く確認されます。',
            'cc_paypal_deposit_with_commission' => '支払いはPayPal決済ゲートウェイを通じて行われます。 :deposit + :commissionの手数料の前払いが必要であり、この金額はキャンセルポリシーに基づき返金されます。',
        ],
        'automatic_payment_method_description' => [
            'transfer' => 'デポジットなしのテキスト',
            'transfer_deposit' => '振込情報はメールでお送りします。',
            'cc_a_garanzia' => 'クレジットカードは予約の保証のために使用されます。現在は料金の請求はありません。支払い方法に記載された通りに支払います。',
            'cc_pos' => 'クレジットカードは予約の保証のために使用されます。現在は料金の請求はありません。支払い方法に記載された通りに支払います。',
            'cc_pos_deposit' => ':depositの前払いが必要であり、この金額はキャンセルポリシーに基づき返金されます。',
            'cc_stripe_deposit' => '支払いはStripe決済ゲートウェイを通じて行われます。',
            'nexi_deposit' => '支払いはNexi決済ゲートウェイを通じて行われます。 <a href="https://www.nexi.it/it/privacy/xpay" target="_blank">Nexiのプライバシーポリシー</a>',
            'zpay_deposit' => 'お支払いは ZPay の決済ゲートウェイを通じて行われます。:deposit の前払いが必要で、この金額は本料金のキャンセルポリシーで定められている場合に返金されます。<a href="https://www.zpay.it/privacy" target="_blank">ZPay プライバシーポリシー</a>。',
            'cc_paypal_deposit' => '支払いはPayPal決済ゲートウェイを通じて行われます。',
            'availability_request' => 'このリクエストは実際の予約としては無効ですが、空室情報のリクエストをこのフォームで行うことができます。予約リクエストはできるだけ早く確認されます。',
            'cc_paypal_deposit_with_commission' => '支払いはPayPal決済ゲートウェイを通じて行われます。',
        ],
        'validators' => [
            'errors' => [
                'name' => 'ゲストの名前が無効です。',
                'surname' => 'ゲストの姓が無効です。',
                'email' => 'ゲストのメールアドレスが無効です。',
                'credit_card_type_id' => 'サポートされていないクレジットカードです。',
                'credit_card_holder' => 'クレジットカードの名義人が無効です。',
                'credit_card_number' => 'クレジットカード番号が無効です。',
                'credit_card_expire_date' => 'クレジットカードの有効期限が無効です。',
            ],
        ],
    ],
    'cash_desk_closure' => [
        'title' => 'キャッシュデスクの閉鎖',
        'invoice' => '請求書',
        'invoices' => '請求書',
        'receipt' => '領収書',
        'receipt_follows_invoice' => '領収書は請求書に続きます',
        'receipts' => '領収書',
        'type' => 'タイプ',
        'status' => '支払い済み',
        'deposit' => 'デポジット',
        'recipient_business_name' => '受取人',
        'taxable' => '課税対象',
        'vat_quote' => 'VAT',
        'total' => '合計',
        'payments' => '支払い',
        'totals' => '総合計',
        'cash_type' => '収入タイプ',
        'reversal_receipt' => '領収書の取り消し',
        'reversal_receipts' => '領収書の取り消し',
        'to_give' => '支払うべき金額',
        'to_have' => '受け取るべき金額',
        'balance' => '残高',
        'documents' => '書類',
        'deposits' => 'デポジット',
        'cash_desk_closure' => '保留中',
        'credit_note' => 'クレジットノート',
        'invoice_received' => '請求書受領',
        'credit_notes' => 'クレジットノート',
        'suspended' => '保留中',
        'follows_invoice' => '請求書に続く',
        'receipts_follows_invoice' => '領収書は請求書に続きます',
        'suspend' => '保留',
        'empty_documents' => '表示する書類はありません',
        'sheets_name' => [
            'cash_desk' => 'キャッシュデスク',
            'cahs_desk_summary' => 'キャッシュデスクの概要',
        ],
        'export_fields' => [
            'date' => '入力日',
            'status' => '支払い済み',
            'document_type' => '書類タイプ',
            'document_number' => '書類番号',
            'customer' => '受取人',
            'taxable' => '課税対象',
            'total_tax' => 'VAT',
            'total_to_pay' => '合計',
            'payment_type' => '収入タイプ',
            'to_have' => '受け取るべき金額',
            'to_give' => '支払うべき金額',
            'balance' => '残高',
            'deposit_document_number' => 'デポジット書類番号',
            'deposit_payment_type' => 'デポジット収入タイプ',
        ],
    ],
    'cash' => [
        'cash_title' => 'キャッシュの状況',
        'cash_totals_title' => '合計',
        'total' => '合計',
        'cash_desk' => 'キャッシュデスク',
        'export_fields' => [
            'registration_date' => '入力日',
            'accountholder' => '口座名義人',
            'document' => '書類',
            'document_date' => '書類日付',
            'date' => '日付',
            'in-out' => '入出金',
            'cash_in' => '収入（入金）',
            'cash_out' => '支出（支払い）',
            'payment_method' => '支払い方法',
            'note' => 'ノート',
            'type_payment' => '支払いタイプ',
            'stay' => '宿泊',
            'extra' => '追加料金',
            'city_tax' => '宿泊税',
            'pos' => 'POS',
            'property' => '施設',
            'amount' => '金額',
            'mode' => 'モード',
            'type' => 'タイプ',
            'category' => '支出カテゴリ',
            'notes' => 'ノート',
            'movement_amount' => '動き',
            'customer_or_company' => '顧客または会社',
            'label' => 'ラベル',
        ],
        'document_types' => [
            'invoice' => '請求書',
            'receipt' => '領収書',
            'credit_note' => 'クレジットノート',
        ],
        'payment_types' => [
            'deposit' => 'デポジット',
            'part_payment' => '一部支払い',
        ],
        'total_yesterday' => '昨日の合計',
        'total_today' => '今日の合計',
        'all_properties' => 'すべての施設',
        'sub_year' => '年間合計',
        'sub_month' => '月間合計',
        'sub_day' => '日別合計',
        'ins' => '収入（入金）',
        'outs' => '支出（支払い）',
        'cash_fund' => 'キャッシュファンド',
        'cash_in' => '収入',
        'cash_out' => '支出',
        'cash_balance' => '残高',
        'to_cash_in' => '未収',
        'wrap_up' => '支払い方法別のまとめ',
        'summary' => 'サマリー',
        'in_out' => [
            'in' => '収入',
            'out' => '支出',
        ],
        'totals' => [
            'method' => '方法',
            'ins' => '収入',
            'outs' => '支出',
            'diff' => '差額',
        ],
    ],
    'channel' => [
        '1' => [
            'promotions' => [
                'mobile_rate' => [
                    // チャンネルIDを示します
                    'all' => 'モバイルアプリとブラウザ',
                    'app' => 'アプリ',
                ],
                'geo_rate' => [
                    'algeria_pos' => 'アルジェリア',
                    'argentina_pos' => 'アルゼンチン',
                    'australia_pos' => 'オーストラリア',
                    'belarus_pos' => 'ベラルーシ',
                    'brazil_pos' => 'ブラジル',
                    'canada_pos' => 'カナダ',
                    'chile_pos' => 'チリ',
                    'colombia_pos' => 'コロンビア',
                    'eu_pos' => 'ヨーロッパ',
                    'hong_kong_pos' => '香港',
                    'india_pos' => 'インド',
                    'indonesia_pos' => 'インドネシア',
                    'iran_pos' => 'イラン',
                    'israel_pos' => 'イスラエル',
                    'japan_pos' => '日本',
                    'kazakhstan_pos' => 'カザフスタン',
                    'kuwait_pos' => 'クウェート',
                    'malaysia_pos' => 'マレーシア',
                    'mexico_pos' => 'メキシコ',
                    'new_zealand_pos' => 'ニュージーランド',
                    'oman_pos' => 'オマーン',
                    'pakistan_pos' => 'パキスタン',
                    'peru_pos' => 'ペルー',
                    'philippines_pos' => 'フィリピン',
                    'qatar_pos' => 'カタール',
                    'russia_pos' => 'ロシア',
                    'saudi_arabia_pos' => 'サウジアラビア',
                    'singapore_pos' => 'シンガポール',
                    'south_africa_pos' => '南アフリカ',
                    'south_korea_pos' => '韓国',
                    'switzerland_pos' => 'スイス',
                    'taiwan_pos' => '台湾',
                    'thailand_pos' => 'タイ',
                    'trinidad_&_tobago_pos' => 'トリニダード・トバゴ',
                    'turkey_pos' => 'トルコ',
                    'ukraine_pos' => 'ウクライナ',
                    'united_arab_emirates_pos' => 'アラブ首長国連邦',
                    'united_states_pos' => 'アメリカ合衆国',
                    'vietnam_pos' => 'ベトナム',
                ],
            ],
            'json_request' => [
                'errors' => [
                    'INVALID_ARGUMENT' => '一つ以上のデータが無効です (:message)',
                    'MISSING_ARGUMENT' => '一つ以上のデータが欠けています (:message)',
                    'OPERATION_NOT_ALLOWED' => '操作は許可されていません (:message)',
                    'FORBIDDEN' => '操作が禁止されています (:message)',
                ],
            ],
        ],
        '11' => [
            'availability_model' => '部屋タイプ "Private" の在庫管理:',
            'per_room' => '部屋ごと（avail*beds）',
            'per_person' => 'ベッドごと',
        ],
        '14' => [
            'availability_value_greater' => '入力された在庫数は許容範囲を超えています。',
        ],
        '39' => [
            'period_not_valid' => ':rate レートは :valid_from から :valid_to まで有効です。更新は無視されました。',
        ],
        '53' => [
            'warning_update_category' => ':rate_xml カテゴリ更新エラー。Beddyで設定されていないルール。',
            'empty_response_update' => '空の更新レスポンスエラー。',
        ],
        '68' => [
            'used_voucher' => '使用済みのバウチャー',
            'amount_voucher' => 'バウチャー金額',
            'used_amount' => '使用金額',
            'virtual_rate_option' => '派生レート管理',
            'virtual_rate_option_off' => '管理しない（読み取り専用ダウンロード）',
            'virtual_rate_option_on' => '派生レート管理を有効にする（価格は管理できません）',
            'manage_type' => '接続タイプ',
            'manage_type_complete' => '完全な管理',
            'manage_type_reservation' => '予約のみ管理',
            'manage_type_avail_reservation' => '予約と在庫の管理',
            'message_only_reservation' => '更新は無視されました（予約のみ管理）',
            'message_avail_reservation' => '価格と制限の更新は無視されました（予約と在庫の管理）',
            'deposit_requested' => 'デポジットが要求されました',
            'deposit_payed' => 'デポジットが支払われました',
            'payed_via' => '支払い方法',
        ],
        '69' => [
            'manage_type' => '接続タイプ',
            'manage_type_complete' => '完全な管理',
            'manage_type_reservation' => '予約のみ管理',
            'manage_type_avail_reservation' => '予約と在庫の管理',
            'manage_type_avail_restriction_reservation' => '予約、在庫、制限の管理',
            'message_only_reservation' => '更新は無視されました（予約のみ管理）',
            'message_avail_reservation' => '価格と制限の更新は無視されました（予約と在庫の管理）',
            'message_avail_restriction_reservation' => '価格の更新は無視されました（予約、在庫、制限の管理）',
        ],
        '72' => [
            'manage_type' => '接続タイプ',
            'manage_type_complete' => '完全な管理',
            'manage_type_reservation' => '予約のみ管理',
            'manage_type_avail_reservation' => '予約と在庫の管理',
            'manage_type_avail_restriction_reservation' => '予約、在庫、制限の管理',
            'message_only_reservation' => '更新は無視されました（予約のみ管理）',
            'message_avail_reservation' => '価格と制限の更新は無視されました（予約と在庫の管理）',
            'message_avail_restriction_reservation' => '価格の更新は無視されました（予約、在庫、制限の管理）',
        ],
        '73' => [
            'pricing_model' => '料金モデル',
            'per_room' => '部屋ごと/レート',
            'per_person' => '1人ごと',
            'manage_type' => '接続タイプ',
            'manage_type_complete' => '完全な管理',
            'manage_type_reservation' => '予約のみ管理',
            'manage_type_avail_reservation' => '予約と在庫の管理',
            'manage_type_avail_restriction_reservation' => '予約、在庫、制限の管理',
            'manage_type_avail_avail_price_reservation' => '予約、在庫、価格の管理',
            'message_only_reservation' => '更新は無視されました（予約のみ管理）',
            'message_avail_reservation' => '価格と制限の更新は無視されました（予約と在庫の管理）',
            'message_avail_restriction_reservation' => '価格の更新は無視されました（予約、在庫、制限の管理）',
            'manage_avail_price_reservation' => '制限の更新は無視されました（予約、在庫、価格の管理）',
            'payment_info' => '支払い情報',
            'payment_amount' => '支払金額',
            'payment_extra_info' => '詳細',
            'payment_transaction' => '取引コード',
            'payment_full' => '予約金全額が前払い済み',
            'payment_partial' => '前払い一部済み',
            'payment_none' => '前払いなし',
            'payment_channel_collect' => 'ゲストがチャンネルで支払い済み',
            'payment_hotel_collect' => 'ゲストがホテルで支払う必要あり（全額または一部）',
            'payment_gateway' => 'ゲストが銀行のゲートウェイで支払い済み',
            'service_inclusive' => '料金に含まれています',
        ],
        '93' => [
            'reservation_status' => '予約ステータス',
            'booked' => '予約済み、施設の確認待ち',
            'waiting_payment' => 'デポジット支払い待ち',
            'payment_in_progress' => '支払い処理中および確認中',
            'confirmed' => '確認済み',
            'canceled' => 'キャンセル済み',
            'waiting_credit_card_guarantee' => 'クレジットカード保証待ち',
            'deposit' => 'デポジット',
            'payed' => '支払い済み',
            'not_payed' => '未払い',
            'payment_mothod' => '支払い方法',
            'option_property_xml_id' => '施設ID（Beddyと同じ）',
            'option_email' => 'メール',
            'option_apikey' => 'APIキー',
        ],
        '95' => [
            'unknown_rate' => '不明なPMSレート。チャンネルから受け取った部屋IDと料金: ',
        ],
        'option_general' => [
            // チャンネルの一般的なオプション翻訳
            'property_xml_id' => '施設のXML ID',
            'username' => 'ユーザー名',
            'password' => 'パスワード',
        ],
        'general' => [
            'get_channel_rate_empty' => 'ポータルからデータがダウンロードされていません',
            'no_data_to_update' => '送信するデータはありません。',
            'no_valid_period' => '更新された期間は無効です。更新は無視されました。',
            'no_valid_response' => '受け取ったチャンネルのレスポンスは無効です (:error_message)',
            'only_min_stay_update' => '施設は最小宿泊日数のみ更新するように設定されています。',
            'period_not_valid' => ':rate レートは :valid_from から :valid_to まで有効です。更新は無視されました。',
            'no_valid_response_update' => '受け取ったチャンネルのレスポンスは無効です。',
            'discount' => '割引',
            'unknown' => '不明',
            'deposit_payed' => 'デポジット支払い済み',
            'to_payed' => '支払うべき金額',
            'payment_type' => '支払いタイプ',
            'ota_commission' => 'OTA手数料',
            'ota_due' => 'OTAに支払うべき金額',
            'arrival_time' => '到着時刻',
            'cancellable_until' => 'キャンセル可能期限',
        ],
        'queue_update' => [
            'already_updated' => '更新はoperation code: :operation_codeから送信されました',
            'max_retry' => 'チャンネル更新の最大再試行回数：:channel_name - 期間 :date_from から :date_to まで。最後のメッセージ :message',
            'queue_update_max_retry_strategy_mail' => 'チャンネル再送信の最大回数：:channel_name - 施設：:property_name',
            'queue_update_exception_mail' => 'チャンネルエラー：:channel_name - 施設：:property_name',
        ],
        'errors' => [
            'content_api_update_errors_mail_connectivity' => 'CONTENT-API更新エラー：:channel_name - 施設：:property_name',
            'property_is_related' => '施設は親施設ではなく、すでに他の施設に関連しています',
            'accommodation_channel_not_found' => '部屋ID :accommodation_xml_id はチャンネルで見つかりませんでした',
            'unsupported_min_dvance_res' => 'このチャンネルでは、最小予約前期間の設定はできません。'
        ],
        'queue_past_reservations' => [
            'queue_task_exists' => '施設 #:property_id はすでに処理待ちのタスクに登録されています',
        ],
    ],
    'checkinonline' => [
        'policy' => [
            'privacy_policy_accept' => '署名した者は、EU規則2016/679第13条および14条に基づき、完全な情報を受け取り、その内容を十分に理解したことを宣言します。',
            'privacy_policy_auth_1' => 'データ処理の責任者は、EU規則679/2016第9条に基づき、最適なホスピタリティを提供し、身体的健康の保護のために、特別なデータを処理します。',
            'privacy_policy_auth_2' => 'データ処理者は、私の滞在に関連するデータを、私宛のメッセージや電話を受け取るために使用することに同意します。',
            'privacy_policy_auth_3' => 'データ処理者は、私の連絡先にプロモーションメッセージを送信することに同意します。',
            'privacy_policy_authorize' => '同意します',
            'privacy_policy_eighth_item' => '8. 私のデータは国外に転送される可能性がありますか？',
            'privacy_policy_eleventh_item' => '11. データ処理者からの回答を受け取るまでの期間はどのくらいですか？',
            'privacy_policy_fifth_item' => '5. 収集されたデータはどのように処理されますか？',
            'privacy_policy_first_item' => '1. 誰がデータ処理の目的と方法を決定しますか？',
            'privacy_policy_first_paragraph' => 'EU規則2016/679（以下「GDPR」）第13条および14条に基づき、個人データの保護と自由な移動に関する規定に従い、:businessNameは個人データの処理者として、データ処理の目的と方法に関するすべての情報、データが伝達される可能性のある受領者、そして法律が認める権利を提供する義務を負っています。',
            'privacy_policy_fourth_item' => '4. なぜ私のデータを収集するのですか？',
            'privacy_policy_fourth_item_part_2' => 'データ処理の法的根拠',
            'privacy_policy_list_eighth_item_1' => 'イタリア以外のEU諸国;',
            'privacy_policy_list_eighth_item_2' => 'イギリス;',
            'privacy_policy_list_eighth_item_3' => 'アイルランド;',
            'privacy_policy_list_eighth_item_4' => 'スイス;',
            'privacy_policy_list_eighth_item_5' => 'アメリカ合衆国',
            'privacy_policy_list_fifth_item_1' => 'データの収集、記録、整理、保管、閲覧、処理、修正、選択、抽出、使用、通信、削除、破棄などの操作を通じて。',
            'privacy_policy_list_fifth_item_2' => 'データを保存、管理、伝送するために自動化された電子的な手段を使用し、常に最大の機密性と必要な保護を確保するように設定されています。',
            'privacy_policy_list_fifth_item_3' => '許可されていない者による知識を防ぐための適切な管理措置を講じた文書を紙媒体で使用することによって。',
            'privacy_policy_list_fourth_item_1' => '顧客管理;',
            'privacy_policy_list_fourth_item_10' => '人々の安全と健康を保護する;',
            'privacy_policy_list_fourth_item_11' => '財産と企業資産の保護;',
            'privacy_policy_list_fourth_item_12' => 'ICTインフラの使用と安全性を確保する。',
            'privacy_policy_list_fourth_item_1_part_2' => '同意の表明;',
            'privacy_policy_list_fourth_item_2' => '契約の締結と管理;',
            'privacy_policy_list_fourth_item_2_part_2' => '契約前および契約上の義務;',
            'privacy_policy_list_fourth_item_3' => '行政管理;',
            'privacy_policy_list_fourth_item_3_part_2' => '法的義務;',
            'privacy_policy_list_fourth_item_4' => '紛争の管理;',
            'privacy_policy_list_fourth_item_4_part_2' => '処理者の正当な利益。',
            'privacy_policy_list_fourth_item_5' => 'カスタマーケア;',
            'privacy_policy_list_fourth_item_6' => '広報',
            'privacy_policy_list_fourth_item_7' => 'プロモーション、マーケティング、広告;',
            'privacy_policy_list_fourth_item_8' => '人々の身体的健康の保護;',
            'privacy_policy_list_fourth_item_9' => '内部セキュリティ;',
            'privacy_policy_list_nineth_item_1' => '10年（民法上の義務に基づく - 民法第2220条）;',
            'privacy_policy_list_nineth_item_2' => '最大3ヶ月（チェックアウト後）クレジットカードデータ;',
            'privacy_policy_list_nineth_item_3' => '最大3年（最終チェックアウトから）個人データ、滞在データ、個人の好み、身分証明書、手書き署名、購入履歴、マーケティングデータ（2.1から2.7項目まで）。',
            'privacy_policy_list_nineth_item_4' => '最大5日間の監視カメラ映像;',
            'privacy_policy_list_nineth_item_5' => 'チェックアウト後90日間の電話通信データ;',
            'privacy_policy_list_nineth_item_6' => 'ICTリソースのアクセスおよび使用データは1年間保存。',
            'privacy_policy_list_second_item_1' => '個人識別データ;',
            'privacy_policy_list_second_item_2' => '特別データ;',
            'privacy_policy_list_second_item_3' => '滞在データ;',
            'privacy_policy_list_second_item_4' => '個人の好み;',
            'privacy_policy_list_second_item_5' => '身分証明書;',
            'privacy_policy_list_second_item_6' => '手書き署名;',
            'privacy_policy_list_second_item_7' => '購入履歴;',
            'privacy_policy_list_second_item_8' => 'クレジットカードおよび/または銀行情報;',
            'privacy_policy_list_second_item_9' => '監視カメラの映像;',
            'privacy_policy_list_second_item_10' => '施設のネットワークに接続するために使用された電子機器のデータ;',
            'privacy_policy_list_second_item_11' => '電話データ;',
            'privacy_policy_list_second_item_12' => 'ICTリソースへのアクセスおよび使用データ',
            'privacy_policy_list_second_item_extra' => '健康状態に関するデータ。',
            'privacy_policy_list_seventh_item_1' => '担当者;',
            'privacy_policy_list_seventh_item_2' => 'データ処理責任者;',
            'privacy_policy_list_seventh_item_3' => 'システム管理者;',
            'privacy_policy_list_seventh_item_4' => '会計コンサルタント;',
            'privacy_policy_list_seventh_item_5' => '法的コンサルタント;',
            'privacy_policy_list_seventh_item_6' => '銀行',
            'privacy_policy_list_seventh_item_7' => '保険会社;',
            'privacy_policy_list_seventh_item_8' => '監査会社;',
            'privacy_policy_list_seventh_item_9' => 'ホテルインフラのメンテナンスサービス会社',
            'privacy_policy_list_seventh_item_10' => 'インターネットサービスおよび電子メールの提供会社;',
            'privacy_policy_list_seventh_item_11' => '施設でのイベントや滞在を開催する機関、団体、企業、または個人;',
            'privacy_policy_list_seventh_item_12' => '公共機関;',
            'privacy_policy_list_seventh_item_13' => '警察。',
            'privacy_policy_list_third_item_1' => 'OTA（オンライン旅行代理店）、例：Booking.com、Venere.com、Worldhotels.com、Trivago.com、Expedia.com など',
            'privacy_policy_list_third_item_2' => '従来の旅行代理店;',
            'privacy_policy_list_third_item_3' => '施設でイベントや滞在を開催する機関、団体、企業、または個人;',
            'privacy_policy_location' => ':businessCity、ここ',
            'privacy_policy_name_surname' => '氏名',
            'privacy_policy_nineth_item' => '9. 私のデータはどれくらいの期間保持されますか？',
            'privacy_policy_not_authorize' => '同意しません',
            'privacy_policy_second_item' => '2. データ処理者が取り扱う個人データはどのようなものですか？',
            'privacy_policy_second_item' => '2. データ処理者が取り扱う個人データはどのようなものですか？',
            'privacy_policy_second_paragraph' => 'したがって、記載されている情報をご確認いただき、同意書に署名することによってデータ処理に同意してください。',
            'privacy_policy_seventh_item' => '7. 誰が私のデータを知ることができますか？',
            'privacy_policy_sign' => '署名:',
            'privacy_policy_sixth_item' => '6. なぜ私のデータを提供する必要があるのですか？拒否することはできますか？',
            'privacy_policy_sub1' => 'データへのアクセス権（第15条、GDPR）',
            'privacy_policy_sub2' => '訂正権（第16条、GDPR）',
            'privacy_policy_sub3' => '削除権（第17条、GDPR）',
            'privacy_policy_sub4' => '処理制限の権利（第18条、GDPR）',
            'privacy_policy_sub5' => 'データの移行権（第20条、GDPR）',
            'privacy_policy_sub6' => '反対権（第21条、GDPR）',
            'privacy_policy_sub7' => '自動化された意思決定プロセスを受けない権利（第22条、GDPR）',
            'privacy_policy_sub8' => '監督機関への苦情申し立ての権利（第77条、GDPR）',
            'privacy_policy_tenth_item' => '10. 私のデータ処理に対して制限を加える方法や反対する方法はありますか？',
            'privacy_policy_text_eighth_item' => '個人データは、目的を達成するためにEU加盟国またはEU外の国々または国際機関に転送される場合があります。現在データが転送される国は以下の通りです：',
            'privacy_policy_text_eleventh_item' => '私のデータに関する情報を要求する場合、データ処理者は可能な限り速やかに対応し、最大でも要求から30日以内に返信します。対応が遅れる場合、理由が説明されます。',
            'privacy_policy_text_first_item' => 'データ処理者は、:businessNameで、:businessCityに位置し、:businessAddress、:businessCap、VAT番号: :businessVat。',
            'privacy_policy_text_second_item' => 'データ処理者は、直接または第三者を通じて、個人を特定できる情報を収集および処理します。',
            'privacy_policy_text_second_item_part_2' => 'その他、目的達成に必要なデータも収集されます。',
            'privacy_policy_text_second_item_part_2_span' => '特別なデータも処理されます。',
            'privacy_policy_text_third_item' => '個人データは、データ主体から直接、または他の事業者を通じて提供される場合があります。',
            'privacy_policy_text_fourth_item' => '収集された個人データは、以下の目的で処理されます。',
            'privacy_policy_text_fourth_item_part_2' => 'データ処理は、合法的で誠実な方法で、プライバシー保護を確実にするように行われます。',
            'privacy_policy_text_fifth_item' => 'データ処理は、GDPR第32条に従い、手動および自動化された方法で行われます。',
            'privacy_policy_text_sixth_item' => '契約の履行または法的義務の履行のためにデータが必要な場合、処理は必須であり、拒否するとサービスの提供ができなくなります。',
            'privacy_policy_text_sixth_item_span' => 'データ処理に対する同意を拒否しても、既に行われた処理の合法性には影響しません。',
            'privacy_policy_text_seventh_item' => 'データは、他の処理者に転送されることがあります。',
            'privacy_policy_text_seventh_item_part_2' => 'データは公開されることはなく、プロフィール作成にも使用されません。',
            'privacy_policy_text_seventh_item_span' => '受け取る可能性のあるカテゴリは以下の通りです：',
            'privacy_policy_text_nineth_item' => 'データは、目的を達成するために必要な期間にわたって保存されます。具体的には、以下の期間が適用されます。',
            'privacy_policy_text_nineth_item_part_2' => '法的義務に基づき、より長い保存期間が設定される場合があります。',
            'privacy_policy_text_tenth_item' => '必要に応じて、手紙やPecを通じて書面で通知することにより、データ処理者に問い合わせることができます。',
            'privacy_policy_text_tenth_item_part_2' => 'データ処理者にアクセス権を求め、個人データおよび関連情報を取得できます。',
            'privacy_policy_text_tenth_item_part_3' => '不正確な個人データを訂正できます。',
            'privacy_policy_text_tenth_item_part_4' => 'データの削除を要求することができます。',
            'privacy_policy_text_tenth_item_part_5' => 'データ処理を制限するか、同意を撤回することができます。',
            'privacy_policy_text_tenth_item_part_6' => '自動化された処理の結果、他者にデータを転送することができます。',
            'privacy_policy_text_tenth_item_part_7' => 'データ処理に反対することができます。',
            'privacy_policy_text_tenth_item_part_8' => '自動化された意思決定に基づく処理を受けない権利があります。',
            'privacy_policy_text_twelfth_item' => 'この通知は、2018年5月25日以前に開設されたアカウントにも適用されます。',
            'privacy_policy_third_item' => '3. 個人データはどのように収集されますか？',
            'privacy_policy_title' => '顧客のプライバシーポリシー',
            'privacy_policy_title_first_item' => 'データ処理者',
            'privacy_policy_title_fourth_item' => 'データ処理の目的',
            'privacy_policy_title_fifth_item' => 'データ処理方法',
            'privacy_policy_title_sixth_item' => 'データ提供の性質と拒否の可否',
            'privacy_policy_title_seventh_item' => 'データの共有',
            'privacy_policy_title_tenth_item' => 'データ主体の権利',
            'privacy_policy_twelfth_item' => '12. 有効期限と発効',
            'privacy_policy_title_consent' => 'データ処理同意声明',
            'privacy_policy_title_footer' => 'プライバシーポリシー確認',
            'privacy_policy_vers' => 'バージョン1.1 2019年4月4日',
            'privacy_policy_text_tenth_item_part_9' => '他の行政または司法的救済を問わず、処理が本規則に違反していると判断した場合は、監督機関に苦情を申し立てることができ、また、一般的には、現行法規に基づいて認められたすべての権利を行使することができます。',
        ],
    ],
    'city_tax_channel' => [
        'default' => [
            'accommodations_mapping' => '部屋のマッピング',
            'scheduled_send' => 'レポートの自動送信を有効にしますか？',
            'scheduled_send_info' => 'システムは前日チェックアウトしたすべてのゲストを自動的に送信します。例えば、6月25日に6月24日にチェックアウトしたゲストを送信します。',
            'which_guests_to_send' => '自動送信するゲスト:',
            'only_invoiced' => '請求書に記載されたゲストのみ',
            'all_guest_with_city_tax_calculated' => '税金が計算されたすべてのゲスト',
        ],
        'pay_tourist' => [
            'structure_id' => '施設のPayTourist ID',
            'software_id' => 'PayTouristから発行されたパートナーソフトウェアID',
            'get_extra_specifications' => '部屋の種類を取得',
            'token' => 'PayTouristから提供されたAPIアクセス用のトークン',
            'period' => '宿泊税レポートを作成する期間',
        ],
        'tourist_tax' => [
            'period' => '宿泊税レポートを作成する期間',
            'city_tax_channel_group_id' => '宿泊税レポート送信/エクスポート設定グループ',
        ],
        'exceptions' => [
            'city_tax_channel_configuration_not_valid' => '施設と宿泊税送信チャンネルの関連付けのための次のパラメータは無効です: ',
            'channel_configuration_not_valid' => 'チャンネル :channelName に必要な次のパラメータは無効です: :params',
            'channel_credential_not_valid' => 'チャンネル :channelName の認証情報は無効です',
            'channel_configuration_must_have_one_property' => 'チャンネル :channelName は1つの施設のみ必要です',
            'channel_params_not_valid' => 'チャンネル :channelName がレポートを作成するために必要とする次のパラメータは無効です: :params',
            'channel_configuration_missing' => 'チャンネル :channelName に必要な設定パラメータがリクエストに含まれていません',
            'channel_params_missing' => 'チャンネル :channelName がレポートを作成するために必要とするパラメータがリクエストに含まれていません',
            'city_tax_exemption_not_mapped' => '免税 :exemptionName は予約 :reservationId - :booker のゲスト :guestName :guestSurname に適用されていません',
            'city_tax_channel_place_not_found' => '選択したチャンネルに対して、場所 :placeName はまだ利用できません',
            'city_tax_channel_group_not_found' => '選択したグループは存在しません',
            'file_not_valid' => 'チャンネル :channelName のクラウドへのエクスポートファイルの保存ができません',
            'networking_error' => '予約 :reservationId の送信に関して、チャンネル :channelName で次のエラーが発生しました: :error',
            'channel_unreachable' => '現在、チャンネル :channelName にアクセスできません。次のエラーが発生しています: :errors',
            'date_range_out_of_boundaries' => 'チャンネル :channelName のレポートの最大期間は開始日から :days 日です',
            'date_from_not_valid' => 'チャンネル :channelName のレポート生成開始日は送信日から最大 :days 日前までです',
            'guest_attributes_missing' => 'ゲストのデータが欠けているため、チャンネル :channelName で宿泊税レポートを送信できません: :guests',
            'empty_report' => '要求された宿泊税レポートにはゲストが含まれていません',
            'endpoint_not_mapped' => 'チャンネル :channelName 用の場所 :place のエンドポイントが存在しません。サポートチームにお問い合わせください',
        ],
    ],
    'city_tax_configuration' => [
        'errors' => [
            'restriction_fields_not_valid' => '渡されたフィールドは、過去の宿泊税制限に関連していません',
            'option_fields_not_valid' => '渡されたフィールドは、過去の宿泊税オプションに関連していません',
            'field_not_valid' => '渡されたフィールド :fieldNotValid は、次の条件 :condition :validation を満たしていません',
            'configuration_override_already_exist' => '選択された日付に対して既存の宿泊税設定があります',
        ],
        'exceptions' => [
            'city_tax_configuration_not_valid' => '宿泊税設定作成のための次のパラメータは無効です: ',
            'field_not_valid' => 'フィールド :fieldName は設定で予期されるフィールドに含まれていません',
            'field_is_required' => 'フィールド :fieldName は必須です',
        ],
    ],
    'city_tax_option_field' => [
        'option_field' => [
            'nationality' => [
                'country_id' => [
                    'name' => '国籍',
                    'description' => 'ゲストの国籍',
                ],
            ],
            'reservation_from' => [
                'reservation_from_id' => [
                    'name' => '出発地',
                    'description' => '予約の出発地。',
                ],
            ],
            'reservation_reason' => [
                'reservation_reason_id' => [
                    'name' => '予約理由',
                    'description' => '予約の理由。',
                ],
            ],
            'group_leader' => [
                'active' => [
                    'name' => '有効',
                    'description' => '除外を有効にする。',
                ],
            ],
            'residence_country' => [
                'country_id' => [
                    'name' => '居住国',
                    'description' => 'ゲストの居住国。',
                ],
                'city_tax_exemption_id' => [
                    'name' => '免税',
                    'description' => '免税',
                ],
            ],
            'residence_state' => [
                'state_id' => [
                    'name' => '居住州',
                    'description' => 'ゲストの居住州。',
                ],
                'city_tax_exemption_id' => [
                    'name' => '免税',
                    'description' => '免税',
                ],
            ],
            'residence_county' => [
                'county_id' => [
                    'name' => '居住郡',
                    'description' => 'ゲストの居住郡。',
                ],
                'city_tax_exemption_id' => [
                    'name' => '免税',
                    'description' => '免税',
                ],
            ],
            'residence_city' => [
                'city_id' => [
                    'name' => '居住都市',
                    'description' => 'ゲストの居住都市。',
                ],
                'city_tax_exemption_id' => [
                    'name' => '免税',
                    'description' => '免税',
                ],
            ],
            'accommodation_tableau_number' => [
                'accommodation_tableau_number_id' => [
                    'name' => '宿泊施設',
                    'description' => '宿泊施設',
                ],
            ],
            'accommodation' => [
                'accommodation_id' => [
                    'name' => '宿泊施設の種類',
                    'description' => '宿泊施設の種類',
                ],
            ],
        ],
    ],
    'city_tax_option' => [
        'option' => [
            'nationality' => [
                'name' => '国籍',
                'description' => 'ゲストの国籍',
            ],
            'reservation_from' => [
                'name' => '出発地',
                'description' => '予約の出発地。',
            ],
            'reservation_reason' => [
                'name' => '予約理由',
                'description' => '予約の理由。',
            ],
            'group_leader' => [
                'name' => 'グループリーダー',
                'description' => 'ゲスト間のグループリーダー。',
            ],
            'residence_country' => [
                'name' => '居住国',
                'description' => 'ゲストの居住国。',
            ],
            'residence_state' => [
                'name' => '居住州',
                'description' => 'ゲストの居住州。',
            ],
            'residence_county' => [
                'name' => '居住郡',
                'description' => 'ゲストの居住郡。',
            ],
            'residence_city' => [
                'name' => '居住都市',
                'description' => 'ゲストの居住都市。',
            ],
            'accommodation_tableau_number' => [
                'name' => '宿泊施設',
                'description' => '宿泊施設。',
            ],
            'accommodation' => [
                'name' => '宿泊施設の種類',
                'description' => '宿泊施設の種類。',
            ],
        ],
    ],
    'city_tax_restriction_field' => [
        'restriction_field' => [
            'age_range' => [
                'min_age' => [
                    'name' => '最小年齢',
                    'description' => '年齢帯の最小値',
                ],
                'max_age' => [
                    'name' => '最大年齢',
                    'description' => '年齢帯の最大値',
                ],
                'amount_price' => [
                    'name' => '固定金額',
                    'description' => '宿泊税の金額',
                ],
                'percentage_price' => [
                    'name' => '金額の割合',
                    'description' => '金額計算の割合',
                ],
                'city_tax_exemption_id' => [
                    'name' => '免税',
                    'description' => '免税',
                ],
                'price_type' => [
                    'name' => '価格タイプ',
                    'description' => '価格の種類',
                ],
            ],
            'percentage_range' => [
                'min_amount' => [
                    'name' => '最小金額',
                    'description' => 'パーセンテージ計算の最小値',
                ],
                'max_amount' => [
                    'name' => '最大金額',
                    'description' => 'パーセンテージ計算の最大値',
                ],
            ],
            'validity_period' => [
                'date_from' => [
                    'name' => '開始日',
                    'description' => '有効期間の開始日',
                ],
                'date_to' => [
                    'name' => '終了日',
                    'description' => '有効期間の終了日',
                ],
                'flag_year' => [
                    'name' => '季節性',
                    'description' => '毎年有効な期間',
                ],
            ],
            'price_range_night' => [
                'min_price' => [
                    'name' => '最小価格',
                    'description' => '計算に有効な最小価格',
                ],
                'max_price' => [
                    'name' => '最大価格',
                    'description' => '計算に有効な最大価格',
                ],
            ],
            'limit_days' => [
                'days' => [
                    'name' => '適用可能な夜数',
                    'description' => '適用可能な最大夜数',
                ],
            ],
            'month_max_nights' => [
                'max_days' => [
                    'name' => '月間適用夜数',
                    'description' => '特定のゲストに対して、月間の最大適用夜数（異なる予約や連続していない予約も含む）を超えた場合、税金は計算されません',
                ],
            ],
            'year_max_nights' => [
                'max_days' => [
                    'name' => '年間適用夜数',
                    'description' => '特定のゲストに対して、年間の最大適用夜数（異なる予約や連続していない予約も含む）を超えた場合、税金は計算されません',
                ],
            ],
            'reservation_max' => [
                'max' => [
                    'name' => '最大予約数',
                    'description' => '特定のゲストに対して年間適用可能な最大予約数',
                ],
            ],
            'limit_nights' => [
                'min_nights' => [
                    'name' => '最小泊数',
                    'description' => '予約の最小泊数',
                ],
                'max_nights' => [
                    'name' => '最大泊数',
                    'description' => '予約の最大泊数',
                ],
            ],
            'range_nights' => [
                'night_from' => [
                    'name' => '開始夜',
                    'description' => 'カウントの開始夜',
                ],
                'night_to' => [
                    'name' => '終了夜',
                    'description' => 'カウントの終了夜',
                ],
                'amount_price' => [
                    'name' => '固定金額',
                    'description' => '宿泊税の金額',
                ],
                'percentage_price' => [
                    'name' => '金額の割合',
                    'description' => '金額計算の割合',
                ],
                'price_type' => [
                    'name' => '価格タイプ',
                    'description' => '価格の種類',
                    'amount_name' => '金額',
                    'percentage_name' => '割合',
                ],
            ],
            'adult_quote_range' => [
                'min_amount' => [
                    'name' => '最小金額',
                    'description' => '宿泊料金（税抜）の成人料金の最小金額を選択',
                ],
                'max_amount' => [
                    'name' => '最大金額',
                    'description' => '宿泊料金（税抜）の成人料金の最大金額を選択',
                ],
                'amount_price' => [
                    'name' => '固定金額',
                    'description' => '宿泊税の金額',
                ],
                'percentage_price' => [
                    'name' => '金額の割合',
                    'description' => '金額計算の割合',
                ],
                'price_type' => [
                    'name' => '価格タイプ',
                    'description' => '価格の種類',
                    'amount_name' => '金額',
                    'percentage_name' => '割合',
                ],
            ],
            'price_type_name' => [
                'amount_name' => '€',
                'percentage_name' => '%',
            ],
        ],
    ],
    'city_tax_restriction' => [
        'restriction' => [
            'age_range' => [
                'name' => '年齢帯',
                'description' => '税金適用の年齢帯',
            ],
            'percentage_range' => [
                'name' => 'パーセンテージ計算における金額の範囲',
                'description' => 'パーセンテージ計算における最小金額と最大金額の範囲',
            ],
            'validity_period' => [
                'name' => '有効期間',
                'description' => '税金の適用期間',
            ],
            'price_range_night' => [
                'name' => '宿泊施設の1泊の価格範囲',
                'description' => '税金計算に考慮される1泊あたりの最小価格と最大価格',
            ],
            'limit_days' => [
                'name' => '最大適用泊数',
                'description' => '適用する最大泊数',
            ],
            'month_max_nights' => [
                'name' => '特定のゲストに対する月間の最大適用泊数',
                'description' => 'ゲストに対して月に適用される最大泊数',
            ],
            'year_max_nights' => [
                'name' => '特定のゲストに対する年間の最大適用泊数',
                'description' => 'ゲストに対して年間に適用される最大泊数',
            ],
            'reservation_max' => [
                'name' => '年間に対する最大予約数',
                'description' => 'ゲストに対する年間の最大予約数',
            ],
            'limit_nights' => [
                'name' => '予約内での適用泊数の制限',
                'description' => '予約における最小泊数と最大泊数',
            ],
            'range_nights' => [
                'name' => '予約泊数に基づく計算の上書き',
                'description' => '予約の開始夜と終了夜',
            ],
            'adult_quote_range' => [
                'name' => '宿泊客料金の価格範囲',
                'description' => '宿泊客料金の範囲と関連する価格を選択',
            ],
        ],
    ],
    'city_tax' => [
        'tax_type' => [
            'xpax' => [
                'name' => '1人当たりの金額',
                'description' => '宿泊日数を考慮せず、選択された金額でゲストごとに税金が計算されます。',
            ],
            'xnightxpax' => [
                'name' => '1泊1人当たりの金額',
                'description' => '選択された金額に基づいて、宿泊日ごとにゲストごとに税金が計算されます。',
            ],
            'xnight' => [
                'name' => '1泊当たりの金額',
                'description' => 'ゲスト数を考慮せず、1泊ごとに選択された金額で税金が計算されます。',
            ],
            'xroomxnight' => [
                'name' => '宿泊料金に基づく1泊当たりのパーセンテージ',
                'description' => 'ゲスト数を考慮せず、1泊ごとの宿泊料金のパーセンテージとして税金が計算されます。',
            ],
            'xroomxnightxpax' => [
                'name' => '1泊1人当たり宿泊料金に基づくパーセンテージ',
                'description' => 'ゲストごとに、宿泊料金の割合としてすべての宿泊日について税金が計算されます。',
            ],
            'xroomxtotalnightxpax' => [
                'name' => '1泊1人当たり宿泊料金に基づくパーセンテージ',
                'description' => 'ゲストごとにすべての宿泊日について宿泊料金のパーセンテージとして税金が計算されます。',
            ],
            'xtotalroomxnightxpax' => [
                'name' => '1泊1人当たりの総料金（宿泊+追加料金）に基づくパーセンテージ',
                'description' => 'すべての宿泊日について、ゲストごとに総料金のパーセンテージとして税金が計算されます。',
            ],
            'xbook' => [
                'name' => '一括固定金額',
                'description' => '宿泊日数やゲスト数に関係なく、選択された固定金額で税金が計算されます。',
            ],
            'xroomextraxnightxpax' => [
                'name' => '1泊1人当たりの宿泊料金+追加料金に基づくパーセンテージ',
                'description' => 'すべての宿泊日について、宿泊料金+追加料金をゲスト数で割った割合として税金が計算されます。',
            ],
        ],
        'price_type' => [
            'amount' => '金額',
            'percentage' => 'パーセンテージ',
            'amount_percentage' => '金額とパーセンテージ',
        ],
        'warnings' => [
            'no_tax_for_accommodation' => '宿泊施設 :accommodation_name には、設定されている宿泊税のいずれも適用されません。',
            'no_guests_for_accommodation' => '宿泊施設 :accommodation_name には、宿泊税を計算する必要があるゲストがいません。',
        ],
        'errors' => [
            'no_city_tax_configuration' => '宿泊税が設定されていません。',
        ],
        'city_tax_extra_text' => '税額は概算であり、宿泊時の適用法令に基づき変更される可能性があります。',
    ],
    'cloners' => [
        'treatments' => [
            'description' => 'このオプションを選択すると、元の施設の処理を宛先にクローンできます。このオプションを選択すると、元の施設の処理が削除されます。',
        ],
        'accommodations' => [
            'description' => 'このオプションを選択すると、元の施設の部屋をクローンできます。料金プランと一緒に選択した場合、元の施設を反映するようにリンクが作成されます。',
        ],
        'priceLists' => [
            'description' => 'このオプションを選択すると、元の施設の価格リストをクローンできます。',
        ],
        'ratePlans' => [
            'description' => 'このオプションを選択すると、元の施設の料金プランをクローンできます。',
        ],
        'rates' => [
            'description' => 'このオプションを選択すると、元の施設の料金をクローンできます。',
        ],
        'modules' => [
            'description' => 'このオプションを選択すると、元の施設のモジュールをクローンできます。',
        ],
        'customers' => [
            'description' => 'このオプションを選択すると、元の施設の顧客をクローンできます。',
        ],
        'companies' => [
            'description' => 'このオプションを選択すると、元の施設の企業をクローンできます。',
        ],
        'invoiceLayouts' => [
            'description' => 'このオプションを選択すると、元の施設の請求レイアウトをクローンできます。',
        ],
        'addons' => [
            'description' => 'このオプションを選択すると、元の施設の追加サービスをクローンできます。',
        ],
        'availabilities' => [
            'description' => 'このオプションを選択すると、元の施設の空室状況をクローンできます。',
        ],
        'childrenRanges' => [
            'description' => 'このオプションを選択すると、元の施設の子供料金範囲をクローンできます。',
        ],
        'roles' => [
            'description' => 'このオプションを選択すると、元の施設の役割をクローンできます。',
        ],
        'paymentMethods' => [
            'description' => 'このオプションを選択すると、元の施設の支払い方法をクローンできます。',
        ],
        'rules' => [
            'description' => 'このオプションを選択すると、元の施設のすべてのルールをクローンできます。',
        ],
        'emailTemplates' => [
            'description' => 'このオプションを選択すると、元の施設のすべてのメールテンプレートをクローンできます。',
        ],
        'events' => [
            'description' => 'このオプションを選択すると、元の施設のすべてのイベントをクローンできます。',
        ],
        'policies' => [
            'description' => 'このオプションを選択すると、元の施設のすべてのキャンセルポリシーをクローンできます。',
        ],
        'cityTaxes' => [
            'description' => 'このオプションを選択すると、「宿泊税設定」タブをクローンできます。',
        ],
    ],
    'common' => [
        'datetime' => [
            'default' => '%d/%m/%Y %H:%M',
            'extended_phrasal_date' => '%A, %e %B %Y',
            // "金曜日, 6月7日 2019"
            'extended_phrasal_date_short' => '%a, %e %b %Y',
            // "金, 6月7日 2019"
            'extended_phrasal_date_with_time' => '%A, %e %B %Y - %H:%M',
            // "金曜日, 6月7日 2019 - 18:03"
            'extended_phrasal_date_short_with_time' => '%a, %e %b %Y - %H:%M',
            // "金, 6月7日 2019 - 18:03"
            'phrasal_date' => '%e %B %Y',
            // " 6月7日 2019"
            'phrasal_date_short' => '%e %b %Y',
            // " 6月7日 2019"
            'date' => '%d/%m/%Y',
            // "07/06/2019" (2019年6月7日)
            'for_range' => '%d %b',
            // "4月4日" - 日付範囲の例: "4月4日 - 4月7日"
            'time' => '%H:%M',
            // 24時間形式の時間; 例: "00:00" または "18:03"
            'year' => '年',
            'month' => '月',
            'day' => '日',
            'time' => '時間',
            'dates_interval' => '日付範囲',
            'from_day' => 'から',
            'to_day' => 'まで',
            'days' => '日数',
            'months' => [
                1 => '1月',
                2 => '2月',
                3 => '3月',
                4 => '4月',
                5 => '5月',
                6 => '6月',
                7 => '7月',
                8 => '8月',
                9 => '9月',
                10 => '10月',
                11 => '11月',
                12 => '12月',
            ],
            'months_short' => [
                1 => '1月',
                2 => '2月',
                3 => '3月',
                4 => '4月',
                5 => '5月',
                6 => '6月',
                7 => '7月',
                8 => '8月',
                9 => '9月',
                10 => '10月',
                11 => '11月',
                12 => '12月',
            ],
            'days_of_week' => [
                'None' => '日曜日',
                'None' => '月曜日',
                'None' => '火曜日',
                'None' => '水曜日',
                'None' => '木曜日',
                'None' => '金曜日',
                'None' => '土曜日',
            ],
            'days_of_week_short' => [
                'None' => '日',
                'None' => '月',
                'None' => '火',
                'None' => '水',
                'None' => '木',
                'None' => '金',
                'None' => '土',
            ],
            'days_of_week_initials' => [
                'None' => '日',
                'None' => '月',
                'None' => '火',
                'None' => '水',
                'None' => '木',
                'None' => '金',
                'None' => '土',
            ],
        ],
        'currency' => [
            'display' => ':prefix :symbol :amount',
            'format' => '%.2n',
        ],
        'gender' => [
            'male' => '男性',
            'female' => '女性',
        ],
        'bool' => [
            'yes_no' => [
                1 => 'はい',
                0 => 'いいえ',
            ],
            'true_false' => [
                1 => '真',
                0 => '偽',
            ],
        ],
        'exports' => [
            'customers_generic' => '顧客リスト',
            'companies_generic' => '企業リスト',
            'reservations_generic' => '予約リスト',
            'reservations_invoices_opened_generic' => '未決済リスト',
            'reservations_invoices_generic' => '請求書リスト',
            'social_archive_generic' => '提供解除可能な顧客リスト',
            // "active", "revoked", "accepted", "expired", "draft"
            'reservations_quotes_all_generic' => '見積もり一覧',
            'reservations_quotes_active_generic' => '有効な見積もり一覧',
            'reservations_quotes_revoked_generic' => '拒否された見積もり一覧',
            'reservations_quotes_accepted_generic' => '承認された見積もり一覧',
            'reservations_quotes_expired_generic' => '期限切れ見積もり一覧',
            'reservations_quotes_draft_generic' => '下書き状態の見積もり一覧',
            'rateplans_generic' => '料金プラン、オファー、パッケージ一覧',
            'rateplans_plans_generic' => '料金プラン一覧',
            'rateplans_offers_generic' => 'オファー一覧',
            'rateplans_bundles_generic' => 'パッケージ一覧',
            'coupons_generic' => 'クーポン一覧',
            'reservations_list' => '予約リスト',
            'housekeeper' => '清掃スタッフ_:date',
            'total_entries' => '合計行数: :value',
            'meals' => '食事',
            'meals_plan' => '食事プラン',
            'city_tax' => '宿泊税',
            'reservations_guests_presences' => '滞在中のゲスト',
            'deposits' => '前払い金と保証金'
        ],
        'number_of_nights' => '宿泊日数',
        'user_full_name' => '担当者',
        'print_date' => '印刷日',
        'total' => '合計',
        'totals' => '合計額',
        'quantity' => '数量',
        'category' => 'カテゴリ',
        'qty' => '数量',
        'discount' => '割引',
        'description' => '説明',
        'wrap_up' => '要約',
        'amount' => '金額',
        'vat' => '消費税',
        'nic' => '税番号',
        'reservation' => '予約',
        'nights' => '{1} 1泊|[2,*] :count泊',
        'accommodation' => '{1} 1宿泊施設|[2,*] :count宿泊施設',
        'vat_code' => '消費税コード',
        'unmapped_addons' => 'ポータル追加サービス',
        'details' => '詳細',
        'stripe_statement_descriptor' => '予約番号: :reservationNumber - :email',
        'date' => '日付',
        'available_soon' => 'この機能は近日中に利用可能になります',
        'payments' => '支払い',
        'buyer' => '支払者',
        'payment_method' => '方法',
        'yes' => 'はい',
        'no' => 'いいえ',
        'checkin_hour' => 'チェックイン時刻',
        'checkout_hour' => 'チェックアウト時刻',
    ],
    'company' => [
        'errors' => [
            'vat_code_not_valid' => '入力された消費税番号は無効です',
            'tax_code_not_valid' => '入力された税番号は無効です',
        ],
        'warnings' => [
            'existing_company' => '入力された消費税番号に関連付けられた会社 :company_name はすでに存在します',
        ],
        'export_fields' => [
            'name' => '名前',
            'address' => '住所',
            'vat_code' => '消費税番号',
            'zip_code' => '郵便番号',
            'email' => 'メール',
            'telephone' => '電話',
            'state' => '州',
            'county' => '郡',
            'country' => '国',
            'city' => '市町村',
            'tax_code' => '税番号',
            'nick_name' => 'ニックネーム',
        ],
        'import' => [
            'validations' => [
                'vat_code_unique' => '同じ消費税番号の会社がすでに存在します',
                'vat_code_required' => '消費税番号フィールドは必須です',
                'name_required' => '会社名フィールドは必須です',
                'nick_name_required' => 'ニックネームフィールドは必須です',
                'email' => 'メールフィールドは有効なメールアドレスを含んでいません',
                'pec' => 'PECフィールドは有効なメールアドレスを含んでいません',
            ],
        ],
        'fields' => [
            'company_id' => '会社識別子'
        ],
    ],
    'content_api' => [
        'bank_transfer' => '銀行振込を受け入れる',
        'bank_transfer_note' => '銀行振込の支払いに関するメモ (最大500文字)',
        'checkin_hour' => 'チェックイン時間',
        'checkout_hour' => 'チェックアウト時間',
        'children_allowed' => '子供の宿泊可',
        'pets_allowed' => 'ペットの宿泊可',
        'smoking_allowed' => '喫煙可',
        'max_adults_number' => '最大大人人数',
        'max_guests_number' => '最大ゲスト人数',
        'minimum_age' => '最低年齢',
        'percent_payment_at_booking' => '予約時の支払い率 (%)',
        'remaining_payment_type' => '残額支払い方法',
        'remaining_payment_type_at_checkin_label' => 'チェックイン時の支払い',
        'remaining_payment_type_at_checkin_description' => 'チェックイン時に残額の支払いが求められます',
        'remaining_payment_type_before_checkin_label' => 'チェックイン前X日間の支払い',
        'remaining_payment_type_before_checkin_description' => 'チェックイン前X日間に残額の支払いが求められます',
        'remaining_payment_type_before_checkin_day' => 'チェックイン前の日数',
        'rental_document_upload' => '賃貸書類のアップロード',
        'advertise_name' => '広告主の名前',
        'merchant_name' => '販売者の名前',
        'managment_applies_guest_value' => 'ゲスト管理費用',
        'managment_applies_guest_type' => 'ゲスト管理費用の種類',
        'managment_applies_pets_value' => 'ペット管理費用',
        'managment_applies_value' => '管理費用',
        'management_energy_value' => 'エネルギー管理費用',
        'management_energy_type' => 'エネルギー管理費用の種類',
        'managment_applies_pets_type' => 'ペット管理費用の種類',
        'x_night' => '1泊ごと',
        'x_stay' => '滞在ごと',
    ],
    'coupons' => [
        'refundable' => [
            '0' => '返金不可',
            '1' => '返金可能',
        ],
        'export_fields' => [
            'code' => 'コード',
            'quantity' => '数量',
            'discount' => '割引',
            'date_from' => '開始日',
            'date_to' => '終了日',
            'type' => '種類',
            'min_expense' => '最低支出額',
            'min_stay' => '最短滞在期間',
            'max_stay' => '最長滞在期間',
            'valid_days' => '有効日',
        ],
    ],
    'credit_card_type' => [
        'fields' => [
            'model_name' => 'クレジットカード',
        ],
    ],
    'customer' => [
        'errors' => [
            'reservationExists' => '関連する予約または見積もりが存在します。',
            'guestExist' => '関連するゲストが存在します。',
            'documentExists' => '同じ種類の書類が既に保存されています。',
            'privacyCheckExists' => 'プライバシーはすでに顧客によって承認されています。',
            'customerNotFound' => '顧客が見つかりません',
            'guestExists' => '顧客はアクティブな予約のゲストとして設定されています。',
            'tax_code_not_valid' => '入力された税コードが無効です。',
            "birthday_date_major_than_now" => "生年月日は今日より後にはできません",
        ],
        'fields' => [
            'birthday_date' => 'ゲストの生年月日',
            'sex' => 'ゲストの性別',
            'address' => 'ゲストの住所',
            'zip_code' => 'ゲストの郵便番号',
            'email' => 'ゲストのメールアドレス',
            'telephone' => 'ゲストの電話番号',
            'name' => 'ゲストの名前',
            'surname' => 'ゲストの苗字',
            'model_name' => 'ゲスト',
            'language_id' => '言語'
        ],
        'export_fields' => [
            'name' => '名前',
            'surname' => '苗字',
            'birthday_date' => '生年月日',
            'sex' => '性別',
            'note' => 'メモ',
            'city' => '市町村',
            'county' => '郡',
            'state' => '州',
            'country' => '国',
            'address' => '住所',
            'zip_code' => '郵便番号',
            'email' => 'メールアドレス',
            'telephone' => '電話番号',
            'fax' => 'ファックス',
            'facebook' => 'Facebook',
            'linkedin' => 'LinkedIn',
            'twitter' => 'Twitter',
            'web_address' => 'ウェブサイト',
            'birth_city_name' => '出生地',
            'birth_state_name' => '出生州',
            'birth_state' => '出生州',
            'residence_city' => '居住地 - 市町村',
            'residence_county' => '居住地 - 郡',
            'residence_state' => '居住地 - 州',
            'residence_country' => '居住地 - 国',
            'residence_address' => '居住地 - 住所',
            'residence_zip_code' => '居住地 - 郵便番号',
            'billing_city' => '請求先 - 市町村',
            'billing_county' => '請求先 - 郡',
            'billing_state' => '請求先 - 州',
            'billing_country' => '請求先 - 国',
            'billing_address' => '請求先 - 住所',
            'billing_zip_code' => '請求先 - 郵便番号',
            'promotion_check' => 'ニュースレター',
            'privacy_check' => 'GDPR',
            'reservations_count' => '予約数',
            'type' => '種類',
            'newsletter' => 'ニュースレター',
            'GDPR' => 'GDPR',
        ],
        'import' => [
            'validations' => [
                'nic_unique' => '同じ税コードの顧客がすでに存在します。',
                'name_required' => '名前フィールドは必須です。',
                'sex' => '性別フィールドは無効です。有効な値は未定義、男性、女性です。',
                'surname_required' => '苗字フィールドは必須です。',
                'email' => 'メールフィールドに有効なメールアドレスが含まれていません。',
                'birthday_date_date_format' => '生年月日フィールドの形式が正しくありません。',
                'document_type' => '指定された書類タイプは存在しません。',
                'birth_country_not_valid' => '出生国フィールドが無効です。',
                'birth_city_not_valid' => '出生市フィールドが無効です。',
                'citizenship_country_not_valid' => '国籍フィールドが無効です。',
                'residence_country_not_valid' => '居住国フィールドが無効です。',
                'residence_city_not_valid' => '居住市フィールドが無効です。',
                'nationality_country_not_valid' => '国籍フィールドが無効です。',
                'language' => '言語フィールドが無効です。ISO形式の小文字を入力してください（例：it、en）。',
            ],
            'alredy-in-progress' => 'インポートはまだ進行中です。完了するのを待ってから再試行してください。',
        ],
    ],
    'daily_closure' => [
        'daily_title' => '日次締め',
        'department' => '部門',
        'production' => '生産',
        'total' => '合計',
        'property' => '施設',
        'receipt' => '領収書',
        'name' => '名前',
        'invoice' => '請求書',
        'amount' => '残高',
        'guests' => 'ゲスト',
        'accommodation' => '部屋',
        'empty_documents' => '選択した期間に発行または受領された書類はありません。',
        'empty_payments' => '選択した期間に発行または受領された支払いはありません。',
        'export_fields' => [
            'production_department' => '部門別生産',
            'production_treatments' => 'トリートメント別生産',
            'production_accommodations' => '宿泊施設別生産',
            'occupancy' => '占有率',
            'documents' => ':date_from の書類|:date_from から :date_to の書類',
            'payments' => ':date_from の支払い|:date_from から :date_to の支払い',
            'summary' => 'キャッシュ要約 (:date_from)|キャッシュ要約 (:date_from - :date_to)',
            'accommodations_sold' => '販売済み部屋数',
            'sold_nights' => '販売済み宿泊数',
            'unsold_nights' => '未販売宿泊数',
            'penalty_nights' => 'ペナルティ宿泊数',
            'accommodations_available' => '利用可能な部屋数',
            'date' => '日付',
            'income' => '収入',
            'outcome' => '支出',
            'occupancy' => '占有率',
            'payment_method' => '支払い方法',
            'type' => '種類',
            'reversal_receipt' => '領収書の取消',
            'number' => '番号',
            'in' => '収入',
            'out' => '支出',
            'intestatary' => '名義人',
            'name' => '名前',
            'modality' => '方法',
            'note' => 'メモ',
            'taxable' => '課税対象',
            'vat_quote' => '付加価値税',
            'treatment' => 'トリートメント',
            'average_revenue' => 'ゲスト平均収益',
            'adr' => 'ADR',
            'revpar' => 'RevPAR',
            'reservations' => '予約',
            'no_show' => 'ノーショー',
            'confirmed' => '確認済み',
            'cancelled' => 'キャンセル済み',
            'optionable' => 'オプション',
            'expired' => '期限切れ',
            'unknown' => '不明',
            'checkin' => 'チェックイン',
            'checkout' => 'チェックアウト',
            'in_house' => '滞在中',
            'attendance' => '出席',
            'absolute_guests' => '総ゲスト数',
        ],
    ],
    'daily_summary' => [
        'daily_summary' => '日次サマリー',
        'accommodation' => '部屋',
        'accommodation_type' => '部屋タイプ',
        'name_and_surname' => '名前と苗字',
        'stay' => '滞在',
        'guests' => 'ゲスト',
        'treatment' => 'トリートメント',
        'channel' => 'チャネル',
        'payment_details' => '支払い詳細',
        'notes' => 'メモ',
        'adults' => '大人',
        'children' => '子供',
        'total' => '合計',
        'arrivals' => '到着',
        'departures' => '出発',
        'in_home' => '滞在中',
        'nights' => '宿泊数',
        'paid' => '支払い済み',
        'to_pay' => '未払い',
        'no_reservations_found' => 'この日の予約はありません。',
        'daily_summary_of_date' => ':date の日次サマリー',
    ],
    'deposits' => [
        'export_fields' => [
            'property' => '施設',
            'number' => '番号',
            'deposit_number' => 'デポジット番号',
            'document_number' => 'ドキュメント番号',
            'date' => '日付',
            'registration_date' => '登録日',
            'type' => 'タイプ',
            'amount' => '金額',
            'amount_available' => '利用可能な金額',
            'amount_used' => '使用済み金額',
            'reservation_number' => '予約ID',
            'pos' => 'POS',
            'description' => '説明',
            'buyer' => '支払者',
            'reservation_id' => '予約ID',
            'used_amount' => '使用済み金額',
            'user_pay' => '支払者',
            'reservation' => '予約',
            'payment_method' => '支払い方法',
            'arrival_date' => '到着日',
            'departure_date' => '出発日',
            'deposit' => 'デポジット',
            'part_payment' => '一部支払い',
            'stay' => '滞在',
        ],
    ],
    'email_suppression_list' => [
        'reason_types' => [
            'BOUNCE' => '送信失敗',
            'COMPLAINT' => 'スパムとして報告',
        ],
        'errors' => [
            'NotFoundException' => 'メールが見つかりません',
            'BadRequestException' => 'リクエストパラメーターが無効です',
            'TooManyRequestsException' => 'リクエストが多すぎます',
            'TooManyRequestException' => 'リクエストが多すぎます',
        ],
    ],
    'emails' => [
        'multiple_sessions' => [
            'subject' => 'セキュリティ警告: 複数のデバイスがアカウントに接続されています',
            'body' => ":user_first_name さん、こんにちは。<br />アカウントに複数のデバイスから接続が検出されました。現在のアクティブセッションを確認することをおすすめします:",
            'summary_reset' => 'これらのデバイスを認識しない場合は、<a href=":recoveryPasswordLink" target="_blank">直ちにパスワードを変更する</a>ことをおすすめします。アカウントを保護するためです。',
            'device' => 'デバイス',
            'place' => '場所',
            'date_hour' => '日時',
            'unknown' => '不明',
            'logout' => 'また、プロフィール > セキュリティとアクセスから、<a href=":logoutAllDevice" target="_blank">すべてのデバイスからログアウト</a>することも可能です。',
        ],
        'general' => [
            'link_preview' => '印刷用バージョンを見るにはここをクリックしてください',
            'additionals_informations' => '追加情報',
            'automatic_email_message' => 'このメールは自動送信されています。このアドレスには返信しないでください。',
            'message' => 'メッセージ',
        ],
        'reservation_confirmed' => [
            'subject' => '予約番号 #:reference_number',
            'reservation_confirm' => 'あなたの予約',
            'reply' => '返信',
            'tax' => '税金',
            'reservation_number' => '番号',
            'thanks' => 'ありがとうございます',
            'view_quote' => '見積もりを見るにはここをクリックしてください',
            'show_detail' => '<a href=":showDetailsReservation">予約を見るにはここをクリック</a>',
            'confirm_reservation_with_bank_transfer_suggestion' => '予約を完了するために、できるだけ早く支払いを行ってください。',
            'your_reservation' => 'あなたの予約',
            'is_confirmed' => 'が確認されました。',
            'ti_aspettiamo_il' => 'お待ちしております。',
            'city_tax' => '宿泊税',
            'reservation_summary' => '予約の概要',
            'nights' => '泊|泊数',
            'accommodations' => '宿泊施設|宿泊施設数',
            'adults' => '大人|大人',
            'childrens' => '子供|子供たち',
            'reservation_confirmed_with_stripe' => 'Stripe支払いゲートウェイを使用して予約が確認されました。',
            'total_reservation' => '予約合計',
            'price_payed' => '支払い済み金額',
            'price_to_pay' => '未払い金額',
            'payment_method' => '支払い方法',
            'other_request' => 'その他のリクエスト',
            'banktransfer_informations' => '銀行口座情報',
            'printable_link' => '印刷用バージョンを見るにはここをクリック',
            'other_operations' => 'その他の操作',
            'checkin' => 'オンラインチェックインを行う',
            'modify_reservation' => '予約を変更する',
            'cancel_reservation' => '予約をキャンセルする',
            'additional_informations' => '追加情報',
            'contability_informations' => '金額 <b>:price_deposit</b> の入金確認後、予約が確定されます。手続きの迅速化のため、CRO番号を添えて支払いコピーをお送りください。',
            'checkin_online_pin' => 'オンラインチェックインを行うためのコードは <a style="color: #8f743f; text-decoration: underline !important;" target="_blank" href=":link">こちら</a> です。',
            'pin' => 'PIN',
        ],
        'reservation_request_avail' => [
            'subject' => ':property_name の空室リクエスト (:arrival_date - :departure_date)',
            'reservation_confirm' => '空室リクエスト',
            'reply' => '返信',
            'tax' => '税金',
            'reservation_number' => '番号',
            'thanks' => 'ありがとうございます',
            'view_quote' => '見積もりを見るにはここをクリックしてください',
            'show_detail' => '予約を見るにはここをクリック',
            'show_detail_avail' => '空室リクエストを見るにはここをクリック',
            'your_request_avail' => 'あなたの空室リクエスト',
            'is_confirmed' => 'が送信されました。',
            'invalid_reservation' => 'このリクエストは、確認されるまで予約として有効ではありません。',
            'invalid_reservation_property' => 'このリクエストは予約として有効ではありません。お客様は確認を待っています。',
            'receive_news' => 'できるだけ早く回答いたします。',
            'city_tax' => '宿泊税',
            'reservation_summary' => 'リクエストの概要',
            'nights' => '泊|泊数',
            'accommodations' => '宿泊施設|宿泊施設数',
            'adults' => '大人|大人',
            'childrens' => '子供|子供たち',
            'total_reservation' => '予約合計',
            'price_payed' => '支払い済み金額',
            'price_to_pay' => '未払い金額',
            'payment_method' => '支払い方法',
            'other_request' => 'その他のリクエスト',
            'printable_link' => '印刷用バージョンを見るにはここをクリック',
            'other_operations' => 'その他の操作',
            'additional_informations' => '追加情報',
        ],
        'reservation_cancelled_from_user' => [
            'subject' => '予約がキャンセルされました (#:reference_number)',
            'body_1' => 'こんにちは、<br>この自動メールは、<b>:booked_at</b> に行われた予約番号<b>:reference_number</b>のキャンセルを確認するものです。',
            'body_2' => '<b>予約の概要</b><br>
                 <b>:name :surname</b> (到着日 <b>:arrival_date</b> ～ 出発日 <b>:departure_date</b>)<br>
                 <b>部屋:</b> :reservation_accommodations<br>
                 <b>ゲスト:</b> :total_guests<br>
                 <b>合計:</b> :currency :total_price',
            'body_policy_no_penalty' => '<b>キャンセルポリシー</b>によれば、ペナルティは発生しません。',
            'body_policy_penalty' => '<b>キャンセルポリシー</b>によれば、:currency :penalty_value のペナルティが発生します。',
            'body_3' => 'その他の情報が必要な場合はお気軽にお問い合わせください。',
        ],
        'property_reservation_new' => [
            'subject' => ':channel_name - :property_name からの新規予約 (#:reference_number)',
        ],
        'property_reservation_modified' => [
            'subject' => ':channel_name からの予約変更 (#:reference_number)',
        ],
        'invoice_rejected' => [
            'subject' => ':invoice_date の請求書 :number_complete がSDIにより拒否されました',
            'body' => '請求書番号 <b>:number_complete</b> は以下の理由でSDIにより拒否されました: <b>:rejected_reason</b>',
        ],
        'invoice_received' => [
            'subject' => ':document_date の請求書 :document_number を :sender_name から受信しました',
            'body' => '<b>:document_number</b> 番の請求書が <b>:document_date</b> に <b>:sender_name</b> から受信されました。',
        ],
        'document_default_email' => [
            'body' => 'お客様、<br>以下に :document_type :document_number の :document_date に関する情報を記載しています。<br>添付ファイルにドキュメントのコピーがあります。<br><br>この機会を利用してご挨拶申し上げます。<br>敬具,<br>:sender_name',
        ],
        'suspend_email_reminder' => [
            'subject' => '{{% invoice.type %}} 番号 {{% invoice.number_complete %}}',
            'body' => 'お客様、<br>{{% invoice.type %}} {{% invoice.number_complete %}} が {{% invoice.invoice_date %}} の時点で {{% invoice.total %}} の支払いが未処理であることが確認されました。<br><br>速やかに会計状況を正規化してください。<br>添付ファイルにドキュメントのコピーがあります。<br><br>すでにお支払い済みの場合、このメッセージを無視してください。<br><br>この機会を利用してご挨拶申し上げます。<br>敬具,<br>{{% reservation.property_name %}}',
        ],
        'property_reservation_cancelled' => [
            'subject' => ':channel_name からの予約キャンセル (#:reference_number)',
            'body_1' => '<b>:channel_name</b> チャンネルで予約番号 <b>:xml_reservation_id</b> がキャンセルされました。顧客: <b>:name :surname</b> (チェックイン日 <b>:arrival_date</b> ～ チェックアウト日 <b>:departure_date</b>)、施設 <b>:property_name</b> に関する部屋:<br>:accommodations_lists',
            'body_2' => '予約の詳細を見るには <a href="https://app.beddy.io/reservation/:reservation_id">ここをクリック</a>',
        ],
        'property_reservation_banktransfer_cancelled' => [
            'subject' => ':channel_name からの予約キャンセル (#:reference_number) 未払いによるキャンセル',
            'body_1' => '銀行振込の未払いにより予約が自動的にキャンセルされました。<br /><br />
                <u>キャンセルの詳細:</u><br /><br />
                施設: <b>:property_name</b><br />
                出所ポータル: :channel_name<br />
                予約ID/参照番号: :xml_reservation_id<br />
                顧客: <b>:name :surname</b><br />
                滞在期間: チェックイン <b>:arrival_date</b> ～ チェックアウト <b>:departure_date</b><br />
                関連する部屋: <br>:accommodations_lists<br />',
            'body_2' => '予約の詳細を見るには <a href="https://app.beddy.io/reservation/:reservation_id">ここをクリック</a>',
        ],
        'past_connect_reservation_cancelled' => [
            'subject' => '警告: 予約がキャンセルされましたが、Beddyに登録されていません。空室状況を確認してください。',
            'body' => 'Beddyに登録されていない予約がキャンセルされました。<strong>手動で確認が必要です</strong>。関連する宿泊施設の空室状況が更新されていない可能性があります。
                <br>
                予約が登録されていない理由は以下の2つです:
                <br>
                1. 予約がChannel Managerに接続する以前のものである場合: すべてのポータルが予約のインポートを許可しているわけではありません（一部は期間が制限されています）。
                <br>
                2. 顧客が予約をすぐにキャンセルした場合: この場合、ポータルはキャンセル情報を送信しますが、予約情報を送信しないことがあります。そのため、Beddyは参照を持っていません。
                <br>
                <br>
                <strong>キャンセルの詳細:</strong>
                <br>
                出所ポータル: :channel_name
                <br>
                予約ID: :xml_reservation_id
                <br>
                実施日: :booked_at
                <br>
                顧客: :customer_name :customer_surname
                <br>
                <br>
                <strong>手順:</strong>
                <br>
                - ポータルのエクストラネットで予約とキャンセルを確認します。
                <br>
                - Beddyとポータルのエクストラネットで空室状況を確認し、必要に応じてChannel Managerで更新します。
                <br><br>
                敬具',
        ],
        'property_activation' => [
            'subject' => 'アカウント :product_name - :property_name',
            'footer' => 'ご質問がございましたら、月曜から金曜の10:00～14:00および15:30～18:00の間にカスタマーサービスまでご連絡ください。
        :product_name をお選びいただき、ありがとうございます。よろしくお願いいたします。
        <br><br>
        敬具',
        ],
        'users' => [
            'changedPassword' => [
                'subject' => 'Beddy - パスワードが変更されました',
                'summary' => '<b>:firstname</b>様、<br>お客様の<b>Beddy</b>アカウントのパスワードが正常に変更されたことをお知らせいたします。',
                'errors' => [
                    'unexpectedNotice' => 'この変更に心当たりがない場合は、施設の管理者または弊社サポートチームまでご連絡ください。<br><br>
                敬具,<br>
                Beddyチーム',
                ],
            ],
            'attachment' => [
                'subject' => 'Beddyの新しい施設に関連付けられました',
                'summary' => '<b>:firstname</b>様、<br>あなたのBeddyアカウントは新しい施設に関連付けられました。<br><br>アクセスの詳細はこちら：',
                'property' => '施設',
                'roleAssigned' => '割り当てられた役割',
                'loginDetails' => [
                    'login' => '同じ資格情報で、いつでもapp.beddy.ioからこの施設にアクセスできます。',
                    'helpContactInfo' => '必要に応じて、次にお問い合わせください：',
                    'master' => '施設の管理者: :masterEmail',
                    'support' => 'Beddyサポート: <a href="mailto: :supportEmail">:supportEmail</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'この連絡を予期していない場合、または誤りだと思われる場合は、アクティベーションを完了せず、施設管理者またはサポートにご連絡ください。',
                ],
            ],
            'activation' => [
                'subject' => 'Beddy への招待 – アカウントを有効化してください',
                'summary' => '親愛なる <b>:firstname</b> 様、<br> あなたのために Beddy アカウントが作成されました。<br><br> 以下が詳細です：',
                'username' => 'ユーザー名',
                'email' => 'メールアドレス',
                'toDo' => '<b>アカウントを有効化する</b>には、<b>パスワード</b>を設定してください。',
                'button' => '<a href=":creationPasswordLink">パスワードを作成</a>',
                'expiration' => '有効化リンクは 5 日間有効です。',
                'contacts' => [
                    'helpContactInfo' => 'ご不明な点がある場合は、以下にご連絡ください：',
                    'master' => '施設管理者：',
                    'support' => 'Beddy サポート：<a href=\"mailto:support@beddy.io\">support@beddy.io</a>',
                ],
                'errors' => [
                    'activationUnexpectedNotice' => 'このメールに心当たりがない場合や誤送信と思われる場合は、アカウントを有効化せず、施設管理者または Beddy サポートまでご連絡ください。',
                    'uncompletedRegistration' => '登録が完了していません：アカウントはまだ有効化されていません。送信されたメールを確認し、パスワードを設定して有効化してください。',
                ]
            ],
            'passwordreset' => [
                'subject' => ':product_name アカウントのパスワードリセット手順',
                'body' => 'こんにちは <b>:first_name</b>！<br/>
         あなたの :product_name アカウントのパスワードをリセットするリクエストを受け取りました。<br><br>
         パスワードを変更するには、<a href=":link_reset">こちらをクリック</a>してください（30分以内）。<br>
         もしあなたがリクエストを行っていない場合、または変更したくない場合、このメールを無視してください。<br>
         敬具。',
            ],
            'password_expiration_notify' => [
                'subject' => 'Beddyアカウントのパスワード有効期限通知',
                'body' => '親愛なる <b>:name :surname</b> 様、
                <br/>
                あなたのBeddyアカウントのパスワードは<b>:days日</b>で有効期限が切れます。できるだけ早く<a href=":profile" target="_blank">プロフィール</a>セクションから更新してください。
                <br><br>
                現在のパスワードを忘れた場合は、<i><a href=":resetPassword" target="_blank">ログインできませんか？</a></i> をクリックして、<a href=":login" target="_blank">ログインページ</a>からリセットを行ってください。
                <br>
                <br>
                敬具,<br>
                Beddyチーム',
            ],
        ],
        'bank_transfer_reminder' => [
            'subject' => '予約番号 :reference_number - 銀行振込リマインダー',
            'body' => 'お客様 :booker_name :booker_surname 様、<br>
        予約番号 :reference_number (:booked_at) に関連して、予約を確定するために :price の支払いをお待ちしております。<br><br>
        以下はお支払いのための銀行口座情報です:<br>
        <i>:bank_text</i>
        <br><br>
        数日以内にお支払いの確認が取れない場合、予約は自動的にキャンセルされます。<br><br>
        すでにお支払い済みの場合、この通知を無視してください。<br>
        詳細については、遠慮なくお問い合わせください。<br>',
            'footer' => '敬具,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'bank_transfer_cancelled' => [
            'subject' => '予約キャンセル番号 :reference_number',
            'body' => 'お客様 :booker_name :booker_surname 様、<br>
        お支払いの確認が取れなかったため、予約番号 :reference_number (:booked_at) はキャンセルされました。<br><br>
        詳細については、遠慮なくお問い合わせください。<br>',
            'footer' => '敬具,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'cutoff_errors' => [
            'subject' => 'カットオフ送信エラー - :property_name',
            'body_1' => '<b>:property_name</b> 施設に関して、以下のエラーが発生しました:<br><br>',
            'footer' => '敬具。',
        ],
        'deactivate_properties' => [
            'first_notice' => [
                'subject' => 'Beddy アカウント更新',
                'body_1' => 'お客様、<br><br>Beddyアカウントおよび関連サービスの更新を確認しました。<br><br>',
                'body_2' => '今後数日以内に、SDI経由でBeddyソフトウェアの使用に関する請求書 (期間: :date_from ～ :date_to) をお送りします。支払いの確認を迅速に行うため、支払い済みの証拠を送付してください。<br><br>以下はお客様のデータです:',
                'body_3' => 'ご質問がございましたら、月曜から金曜の10:00～14:00および15:30～18:00の間にカスタマーサービスまでご連絡ください。',
                'footer' => 'Beddyをお選びいただきありがとうございます。よろしくお願いいたします。<br><br>敬具。',
            ],
            'second_notice' => [
                'subject' => 'Beddy アカウント更新',
                'body_1' => 'お客様、<br><br>Beddyアカウントおよび関連サービスの更新を再確認しました。<br><br>SDI経由でBeddyソフトウェアの使用に関する請求書 (期間: :date_from ～ :date_to) をまもなくお送りします。<br><br>以下はお客様のデータです:',
                'body_2' => 'ご質問がございましたら、月曜から金曜の10:00～14:00および15:30～18:00の間にカスタマーサービスまでご連絡ください。<br><br>Beddyをお選びいただきありがとうございます。よろしくお願いいたします。<br><br>敬具。',
            ],
        ],
        'reservation_quote_expire' => [
            'subject' => 'お見積もりが期限切れとなりました',
            'body_1' => 'お客様 :customer_name :customer_surname,<br>お客様が :creation_date にリクエストした見積もりが期限切れとなりました。',
            'body_2' => '<br><br>詳細については、遠慮なくお問い合わせください。',
            'footer' => '<br><br>敬具,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'reservation_quote_expire_property' => [
            'subject' => 'お見積もりが期限切れとなりました',
            'body_1' => 'お客様 :customer_name :customer_surname 向けに :creation_date に作成された見積もりが期限切れとなりました。',
            'footer' => '<br><br>敬具。',
        ],
        'housekeeper_maintainer' => [
            'subject' => '新しいメンテナンス通知: :accommodation_name',
            'body' => '宿泊施設 <b>:accommodation_name</b> (<b>:tableau_label</b>) に関する新しいメンテナンス報告が登録されました。以下は詳細情報です： <br><br><b>タイトル:</b> :title <br><br><b>説明:</b> :description',
        ],
        'payments_timetable' => [
            'stripe_not_active' => [
                'subject' => '自動支払い失敗 (ID: :payment_timetable_id - :scheduled_date) - Stripeがアクティブではありません',
                'body' => '自動支払い (ID: :payment_timetable_id - :scheduled_date - 予約番号 :reservation_reference_number, 顧客 :booker_name :booker_surname) のデビット処理が失敗しました。Stripeアカウントがアクティブではないためです。',
            ],
            'no_credit_card' => [
                'subject' => '自動支払い失敗 (ID: :payment_timetable_id - :scheduled_date) - クレジットカードが登録されていません',
                'body' => '自動支払い (ID: :payment_timetable_id - :scheduled_date - 予約番号 :reservation_reference_number, 顧客 :booker_name :booker_surname) のデビット処理が失敗しました。クレジットカードが登録されていないためです。',
            ],
            'charge_failed' => [
                'subject' => '自動支払い失敗 (ID: :payment_timetable_id - :scheduled_date)',
                'body' => '自動支払い (ID: :payment_timetable_id - :scheduled_date - 予約番号 :reservation_reference_number, 顧客 :booker_name :booker_surname) のデビット処理が以下の理由で失敗しました: :error_description',
            ],
            'payment_exceeded' => [
                'subject' => '自動支払い失敗 (ID: :payment_timetable_id - :scheduled_date) - 予約総額を超える支払い',
                'body' => '自動支払い (ID: :payment_timetable_id - :scheduled_date - 予約番号 :reservation_reference_number, 顧客 :booker_name :booker_surname) のデビット処理が失敗しました。支払い金額が予約の総額を超えているためです。',
            ],
            'payment_require_action' => [
                'subject' => '自動支払いの引き落としに失敗しました (ID: :payment_timetable_id - :scheduled_date) - 3Dセキュアが必要です',
                'body' => '自動引き落としは3Dセキュア要求のため失敗しました (ID: :payment_timetable_id, :scheduled_date - 予約 :reservation_reference_number 名義 :booker_name :booker_surname).',
            ],
            'payment_require_action_send_request' => [
                'subject' => '自動支払いの引き落としに失敗しました (ID: :payment_timetable_id - :scheduled_date) - 支払い確認待ち',
                'body' => "自動引き落としは3Dセキュア要求のため失敗しました (ID: :payment_timetable_id, :scheduled_date - 予約 :reservation_reference_number 名義 :booker_name :booker_surname).\n顧客へ支払いリクエストをメールで送信しました。",
            ],
        ],
        'reservation_quote_expire_days_before' => [
            'subject' => 'お見積もりの期限が近づいています',
            'body_1' => 'お客様 :customer_name :customer_surname,<br>以下の <a href=":quote_link">見積もり</a> が :expire_date に期限切れとなります。',
            'body_2' => '<br><br>詳細については、遠慮なくお問い合わせください。',
            'footer' => '<br><br>敬具,<br>:property_name<br>:property_telephone<br>:property_email',
        ],
        'email_auth_verification' => [
            'body' => 'お客様 :name :surname 様,<br/><br/>以下はBeddyアカウントへのアクセスを確認するためにリクエストされたPINです: <strong>:pin</strong><br/><br/>PINの有効期限は :expire_time までです。',
        ],
        'user_update_email_verification_code' => [
            'body' => 'お客様 :name :surname 様,<br/><br/>Beddyアカウントの変更リクエストを完了するには、このPINを入力してください: <strong>:pin</strong>',
            'warning' => 'もし変更をリクエストしていない場合は、<a href=":recoveryPasswordLink" target="_blank">すぐにパスワードを変更</a>し、アカウントを保護してください。<br/><br/>
            また、<a href=":logoutAllDevice" target="_blank">プロファイル > 保護とアクセス</a> メニューからすべてのデバイスからログアウトすることも可能です。',
        ],
        'user_update_email_confirmed' => [
            'subject' => 'メールアドレスが更新されました',
            'body' => 'お客様 :name :surname 様,<br/><br/>Beddyアカウントに関連付けられたメールアドレスが正しく更新されました。<br/><br/>今後、このアドレスに通知が送信されます。',
        ],
        'checkin_online_complete' => [
            'subject' => 'オンラインチェックイン完了 - :reference_number',
            'body_1' => 'お客様 <b>:property_name</b>, <br/><br /> <b>:main_guest_name :main_guest_surname</b> が以下の予約に対してオンラインチェックインを完了しました:<br/>',
            'reservation_number' => '予約番号 #:reference_number',
            'view_guests' => 'ゲスト情報を確認',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'subject' => '宿泊施設の清掃状態が変更されました :cleanable_name - :accommodation_name',
            'body' => ':user_name が <b>:cleanable_name</b> (:accommodation_name) に対する清掃状態を <b>:clean_status</b> に設定しました (日付: <b>:reference_date</b>)。施設: :property_name。',
        ],
        'reservation_option_expired' => [
            'subject' => 'オプション予約の期限切れ (#:reference_number)',
            'body' => '予約番号 <b>:reference_number</b> (顧客: <b>:booker_name :booker_surname</b>, 到着日: <b>:arrival_date</b>, 出発日: <b>:departure_date</b>) のオプションが期限切れになりました。',
        ],
        'order_payment_release' => [
            'subject' => '支払いの事前承認が解除されました (#:reference_number)',
            'body' => '予約番号 <b>:reference_number</b> (到着日: <b>:arrival_date</b>, 出発日: <b>:departure_date</b>) に関する支払いの事前承認が解除されました (顧客: <b>:customer_name :customer_surname</b>)。',
        ],
        'sca_authorized' => [
            'subject' => 'SCA承認済み (#:reference_number)',
            'body' => '予約番号 <b>:reference_number</b> (顧客: <b>:booker_name :booker_surname</b>, 到着日: <b>:arrival_date</b>, 出発日: <b>:departure_date</b>) に関するSCAが <b>:accepted_date</b> に承認されました。承認元のIPアドレス: <b>:ip_address</b>',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => '宿泊施設の在庫切れ :accommodation_name - 施設: (:property_name)',
            'body' => '<b>:date_now</b> 時点で、宿泊施設 <b>:accommodation_name - (:property_name)</b> の在庫が以下の日付で切れました: <b>:days</b>',
        ],
        'guests_reporting' => [
            'error_levels' => [
                'reservation' => '予約 :reservationId - :booker',
                'accommodation' => '宿泊施設 :accommodationType - :accommodationTableauNumber',
                'guest' => 'ゲスト :guest',
            ],
            'alloggiatiweb' => [
                'mail' => [
                    'subject' => '宿泊レポート - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'summary' => '以下は、グループ :alloggiatiweb_group_label に対する宿泊レポート :alloggiatiweb_send_date の概要です:',
                    'success' => [
                        'body' => ':number / :alloggiatiweb_guest_total が送信されました。|:number / :alloggiatiweb_guest_total が送信されました。',
                    ],
                    'error_internal' => [
                        'body' => ':number / :alloggiatiweb_guest_total が以下のエラーで送信できませんでした:<br/>:errors|:number / :alloggiatiweb_guest_total が以下のエラーで送信できませんでした:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'ポータルから報告された以下のエラーにより、宿泊データを送信できませんでした:<br/>:errors',
                    ],
                    'fix_error' => 'エラーを修正し、<a href=":link">ドキュメント > ISTATおよび宿泊データ</a>から再送信してください。',
                ],
                'push' => [
                    'subject' => '宿泊データ - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'success' => [
                        'body' => ':number / :alloggiatiweb_guest_total が送信されました。|:number / :alloggiatiweb_guest_total が送信されました。',
                    ],
                    'error_internal' => [
                        'body' => ':number / :alloggiatiweb_guest_total が送信できませんでした。
            不足しているデータを入力するか、エラーを修正して再試行してください。|:number / :alloggiatiweb_guest_total が送信できませんでした。
            不足しているデータを入力するか、エラーを修正して再試行してください。',
                    ],
                    'error_external' => [
                        'body' => 'ポータルから報告された以下のエラーにより、宿泊データを送信できませんでした:
            :errors
            エラーを修正し、再送信してください。',
                    ],
                ],
                'warning' => [
                    'subject' => '宿泊データエラー - :alloggiatiweb_send_date - :alloggiatiweb_group_label',
                    'error_internal' => [
                        'body' => ':number / :alloggiatiweb_guest_total が以下のエラーで送信できませんでした:<br/>:errors|:number / :alloggiatiweb_guest_total が以下のエラーで送信できませんでした:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => 'ポータルから報告された以下のエラーにより、宿泊データを送信できませんでした:
            :errors
            エラーを修正し、再送信してください。',
                    ],
                    'fix_error' => 'エラーを修正し、<a href=":link">ドキュメント > ISTATおよび宿泊データ</a>から再送信してください。',
                ],
            ],
            'istat' => [
                'mail' => [
                    'subject' => 'ISTATレポート - :istat_send_date - :istat_group_label',
                    'summary' => '以下は、グループ :istat_group_label に対するISTATレポート :istat_send_date の概要です:',
                    'success' => [
                        'body' => ':number / :istat_guest_total が送信されました。|:number / :istat_guest_total が送信されました。',
                    ],
                    'error_internal' => [
                        'body' => ':number / :istat_guest_total が以下のエラーで送信できませんでした:<br/>:errors|:number / :istat_guest_total が以下のエラーで送信できませんでした:<br/>:errors',
                    ],
                    'error_external' => [
                        'body' => '以下のエラーにより、ISTATデータを送信できませんでした:<br/>:errors',
                    ],
                    'fix_error' => 'エラーを修正し、<a href=":link">ドキュメント > ISTATおよび宿泊データ</a>から再送信してください。',
                ],
                'push' => [
                    'subject' => 'ISTATデータ - :istat_send_date - :istat_group_label',
                    'success' => [
                        'body' => ':number / :istat_guest_total が送信されました。|:number / :istat_guest_total が送信されました。',
                    ],
                    'error_internal' => [
                        'body' => ':number / :istat_guest_total が送信できませんでした。
                        不足しているデータを入力するか、エラーを修正して再試行してください。|:number / :istat_guest_total が送信できませんでした。
                        不足しているデータを入力するか、エラーを修正して再試行してください。',
                    ],
                    'error_external' => [
                        'body' => '以下のエラーにより、ISTATデータを送信できませんでした:
                    :errors
                    エラーを修正し、再送信してください。',
                    ],
                ],
            ],
        ],
        'treatment_price_update' => [
            'subject' => 'トリートメント料金計算 (:treatment_name) - :property_name',
            'body' => ':start_date から :end_date までの計算が正常に完了しました。',
        ],
        'reservation_message_received' => [
            'subject' => ':senderName からの新しいメッセージ (#:reference)',
            'title' => ':senderName からメッセージが届きました！',
            'sender_wrote' => 'ゲストが書きました:',
            'go_to_conversation' => '会話に進む',
        ],
        'external_services' => [
            'UrmetSclak' => [
                'error_generate_key_subject' => '鍵生成エラー - 予約 :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'Sclakで部屋の鍵生成中にエラーが発生しました。<br> :errors <br> 手動で再試行してください。問題が解決しない場合はUrmetサポートに連絡してください。',
                'error_seding_sms_subject' => 'SMS送信エラー - 鍵 :booker_name :booker_surname (#ID: :reference_number)',
                'error_seding_sms_body' => 'SclakのSMS送信中にエラーが発生しました。<br> Urmetサポートに連絡することをお勧めします。',
            ],
            'nuki' => [
                'error_generate_key_subject' => 'PIN生成エラー - 予約 :booker_name :booker_surname (#ID: :reference_number)',
                'error_generate_key_body' => 'Nukiで部屋のPIN生成中にエラーが発生しました。<br> :errors <br> 手動で再試行してください。問題が解決しない場合はNukiサポートに連絡してください。',
                'unauthorized_opening' => '許可されていない開錠'
            ],
            'warning' => [
                'subject' => '鍵生成エラー - 予約 :booker_name :booker_surname (#ID: :reference_number)',
                'body' => 'Sclakで部屋の鍵生成中にエラーが発生しました。<br> :errors <br> 手動で再試行してください。問題が解決しない場合はUrmetサポートに連絡してください。',
            ],
            'remote_door_key_service' => [
                'reservation_resumed' => [
                    'title' => '予約変更が発生しました。新しい鍵を生成してください。',
                    'body' => '施設 <b>:property_name</b> にある予約 <b>:booker_name :booker_surname - :reference_number</b> 用の新しい鍵を生成する必要があります。以前の鍵は予約状態の変更により無効になりました。',
                ],
                'reservation_moved' => [
                    'title' => '1つ以上の宿泊施設が移動されました。新しい鍵の生成が必要です。',
                    'body' => '施設 <b>:property_name</b> にある予約 <b>:booker_name :booker_surname - :reference_number</b> 用の宿泊施設が移動されました。新しい鍵を生成する必要があります。',
                ],
            ],
        ],
        'conversation_message_send_failed' => [
            'subject' => 'メッセージ送信失敗',
            'title' => ':recipientName 宛てのメッセージが配信されませんでした。もう一度送信を試みてください。',
            'go_to_conversation' => '会話に進む',
        ],
        'newsletters' => [
            'newsletter_sent_subject' => 'ニュースレター送信確認',
            'newsletter_sent_content' => 'キャンペーン ":newsletterName" が、選択された :totalContacts 件中 :sentContacts 件の連絡先に送信されました。',
            'newsletter_not_sent_subject' => 'ニュースレター送信エラー',
            'newsletter_exceeded_sent_limit_subject' => '月間送信制限を超過しました',
            'newsletter_exceeded_sent_limit_content' => 'ニュースレター ":newsletterName" は、月間送信制限を超過したため送信されませんでした。',
            'newsletter_not_sent_content' => 'キャンペーン “:newsletterName” を送信できませんでした。以下のエラーが原因です: :errorMessage',
        ],
        'city_taxes_reports' => [
            'send_city_tax_report' => [
                'subject' => '宿泊税レポート送信確認',
                'content' => '送信チャネル :channelName 用の宿泊税レポートの送信が正常に完了しました。',
            ],
            'send_city_tax_report_not_completed' => [
                'subject' => '宿泊税レポート送信エラー',
                'content' => '送信チャネル :channelName 用の宿泊税レポート送信に失敗しました。',
            ],
            'export_city_tax_report' => [
                'subject' => '宿泊税レポートのエクスポートが完了しました - チャネル: :channelName',
                'content' => '以下のリンクをクリックして宿泊税レポート履歴にアクセスしてください: <a href=":link">宿泊税レポート履歴</a>。',
            ],
            'export_city_tax_report_not_completed' => [
                'subject' => '宿泊税レポートのエクスポートに失敗しました - チャネル: :channelName',
                'content' => 'レポート :reportId の生成に失敗しました。',
            ],
            'guest_atrtributes_missing' => [
                'subject' => '宿泊税レポート送信/エクスポートエラー',
            ],
            'empty_report' => [
                'subject' => '宿泊税レポート送信/エクスポートに失敗しました - チャネル: :channelName',
                'content' => '選択された期間において送信可能なゲストがいなかったため、宿泊税レポートは生成されませんでした。',
            ],
        ],
        'accommodation_deleted' => [
            'subject' => '[対応が必要です] - 空室状況の更新が必要です',
            'body' => '施設 :propertyName の宿泊施設 :accommodationName のユニット数が減少しました。オーバーブッキングを回避するため、<a href=":bulkUpdateLink">料金と空室状況 > 一括更新</a> メニューから空室状況のリセットを行ってください。<br>詳細は <a href=":guideLink">ガイド</a> を参照するか、<a href="https://www.youtube.com/watch?v=uhCBdsjuUmQ&t=107s">トレーニング動画</a> をご覧ください。',
        ],
        'max_email_attachments_size_exceeded' => '添付ファイルのサイズが最大許容値である8MBを超えています。',
        'check_pci_expiration' => [
            'expiring_certification' => [
                'subject' => 'Beddy - 重要: PCI認証期限切れ通知',
                'content' => '親愛なるパートナー :apiPartnerName,<br><br>提供いただいたPCI認証が30日後に期限切れとなります。<br>更新された認証を <a href="mailto:support@beddy.io">support@beddy.io</a> まで期限内に送付してください。<br>期限が過ぎると、支払いデータへのアクセスが取り消されます。<br><br>Beddyチーム',
            ],
            'certification_expired' => [
                'subject' => 'PCI認証が期限切れです',
                'content' => '親愛なるパートナー :apiPartnerName,<br>提供いただいたPCI認証が期限切れとなりました。<br>これに伴い、支払いデータへのアクセスが取り消されました。<br>サービスを復元するには、更新された認証を <a href="mailto:support@beddy.io">support@beddy.io</a> まで送付してください。<br><br>Beddyチーム',
            ],
        ],
        'api_partner_disabled' => [
            'subject' => 'Beddy - 重要: APIアカウント無効化通知',
            'body' => '親愛なるパートナー :apiPartnerName,<br>
            お客様のアカウントは、過剰なリクエストを受けたため無効化されました。<br>
            システムを確認後、アカウントを復元するために <a href="mailto:support@beddy.io">support@beddy.io</a> までご連絡ください。<br><br>
            Beddyチーム',
        ],
        'api_partner_disabled_test' => [
            'subject' => 'Beddy - 重要: APIアカウント無効化の可能性通知',
            'body' => 'パートナー :apiPartnerName,<br>
            サービスに対する過剰なリクエストのため、無効化される可能性があります: :errorMessage.<br>',
        ],
        'property_first_login' => [
            'subject' => 'Beddy - 新しいデバイスからのアクセス',
            'summary' => 'こんにちは :user_first_name,<br>お客様のBeddyアカウントに新しいデバイスからのアクセスが検出されました。',
            'summary_reset' => 'このデバイスに心当たりがない場合、<a href=":recoveryPasswordLink" target="_blank">すぐにパスワードを変更</a>してアカウントを保護してください。',
            'device' => 'デバイス',
            'place' => '場所',
            'date_hour' => '日付と時刻',
            'unknown' => '不明',
            'logout' => 'アクセス通知はBeddyの新機能です。過去に使用したデバイスでも初回アクセス時に通知されます。<a href=":logoutAllDevice" target="_blank"> プロフィール > 保護とアクセス</a>メニューで接続デバイスを確認してください。一致する場合、このメールを無視して構いません。',
        ],
        'channel_update_exclusion' => [
            'subject' => 'ポータルが施設の更新に関する制限を変更しました',
            'summary' => '関連するポータル',
            'oldvalue' => '古い値',
            'newvalue' => '新しい値',
            'modified_value' => '変更された値',
            'deleted_value' => '削除された値',
            'more_info' => 'このメールは、新しい部屋をダウンロードするためのcron実行後に送信されました',
            'they_have_been' => '以下が',
            'the_following_restrictions' => '次の制限：',
            'edited' => '変更されました',
            'new' => '追加されました',
            'removed' => '削除されました',
            'price' => '価格',
            'availability' => '利用可能状況',
            'room_barred' => '閉鎖',
            'min_stay' => '最低宿泊日数',
            'max_stay' => '最大宿泊日数',
            'close_to_arrival' => '到着時の閉鎖',
            'close_to_departure' => '出発時の閉鎖',
            'date_from' => '開始日',
            'date_to' => '終了日',
            'type_change' => '変更の種類',
            '1' => '有効化',
            '0' => '無効化',
            'field_involved' => '関連フィールド',
            'rate' => '料金プラン ',
            'property' => '施設',
            'subject_short' => '制限変更：'
        ],
        'credit_card_view_blocked' => [
            'subject' => 'Beddy - クレジットカードの閲覧上限を超えました。',
            'body' => 'お客様各位<br>ご予約番号 <b>#:reference_number</b> に関連付けられたクレジットカード、またはそれに関連するお支払いのいずれかのカードが、許可された最大閲覧回数に達しました。そのため、このカードへのアクセスは<b>一時的にブロックされています</b>。
    <br><br>閲覧回数の上限を引き上げたい場合や詳細について知りたい場合は、<a href="mailto:support@beddy.io">support@beddy.io</a> までお問い合わせください。<br><br>
    Beddyチームより<br><br>',
        ],
        'credit_card_view_notify' => [
            'subject' => 'Beddy - クレジットカードデータ閲覧通知 - 予約番号 #:reservation_reference',
            'body' => 'お客様へ,<br>チャンネル <b>:channel_name</b> からの予約番号 <b>:reservation_reference</b> に関連するクレジットカードデータが閲覧されました。
    <br><br>
    イベントの詳細:
    <ul>
      <li>オペレーター: <b>:user_first_name :user_last_name</b> (<b>:user_email</b>)</li>
      <li>日時: <b>:event_date</b> <b>:event_hour</b></li>
      <li>IP: <b>:ip_address</b></li>
    </ul>
    この通知は、機密データへのアクセスに関するセキュリティおよび追跡の措置として生成されています。<br><br>
    Beddy チーム<br><br>',
        ],
        'user_created_notify' => [
            'subject' => 'Beddy - 施設 :property_name に新しいユーザーが作成されました',
            'bodySection1' => 'お客様<br>新しいユーザー <b>:user_first_name :user_last_name (:user_email)</b> が施設 <b>:property_name</b> に作成されました。
        <br><br>
        イベントの詳細:
        <ul>
          <li>オペレーター: <b>:author_first_name :author_last_name</b> (<b>:author_email</b>)</li>
          <li>日時: <b>:event_date</b> <b>:event_hour</b></li>
          <li>IP: <b>:ip_address</b></li>
        </ul>
        この操作に心当たりがない場合、新しいユーザーを無効にできます。',
            'buttonText' => 'ユーザーを無効化',
            'bodySection2' => 'この通知は、セキュリティ対策および機密データへのアクセス追跡のために生成されています。<br><br>
        Beddy チーム<br><br>'
        ],

    ],
    'export' => [
        'providers' => [
            'customers' => '顧客',
            'companies' => '企業',
            'reservations' => '予約',
            'social_archive' => 'アンロック可能なオファー顧客',
            'reservation_quotes' => '見積もり',
            'cash_desk' => 'レジ',
            'fees' => '手数料',
            'cash_desk_closure' => 'レジ締め',
            'production_stats' => '生産統計',
            'sales_stats' => '販売統計',
            'invoices' => '請求書',
            'invoices_received' => '受領請求書',
            'payments_timetable' => '支払いスケジュール',
            'properties' => '構造',
            'deposits' => '前払い金および保証金',
            'reservations_guests_presences' => '滞在中のゲスト',
        ],
        'translations' => [
            'export_format' => 'エクスポート形式',
        ],
        'errors' => [
            'service_not_active' => '選択された施設では、リクエストされたエクスポートサービスは有効ではありません。',
            'method_not_found' => 'クラス :className にメソッド :methodName が実装されていません。',
            'export_provider_not_found' => 'エクスポートプロバイダーが見つかりません。',
        ],
        'warnings' => [
            'service_not_active' => '施設 :propertyName では、リクエストされたエクスポートサービスは有効ではありません。',
            'export_inserted' => 'エクスポートが正常に登録されました。処理が完了すると通知が届きます。',
        ],
    ],
    'external_services' => [
        'urmet_sclak' => [
            'one_time' => 'キーの有効期限',
            'confirm_required' => '管理者がSclakアプリで各アクセスを承認する必要があります。',
            'app_enabled' => 'アプリの使用を有効化 (いいえの場合は、数値キーパッドのみ有効化されます)',
            'generate_keypad_pin' => '数値キーパッドでのアクセス用PINを生成 (施設にキーパッドがある場合のみ選択してください)',
            'push_notify_enabled' => 'ゲストがアクセスするたびにスマートフォンにプッシュ通知を受け取ります。',
            'security_level' => 'ゲストはインターネットに接続している必要があります。',
            'instant_key' => 'ゲスト登録はオプションです。',
            'purchase_type' => 'キーの支払い者は誰ですか？',
            'send_sms' => 'Sclakから自動SMSで顧客にキーを送信',
            'sms_text_main' => 'こんにちは、以下は施設へのアクセスキーを取得するための手順です。
            - Sclakアプリをインストールしてください: http://app.sclak.com/download',
            'sms_text_app_code' => '
            - キーを有効化: https://key.sclak.com/a/:app_key_code',
            'sms_text_pin_code' => '
             - キーパッドのPINコードは: :pin_code\'',
            'all_booking_duration' => '滞在期間中有効',
            'only_one' => '1回のみ',
            'property' => '施設',
            'guest' => 'ゲスト',
            'door_app_code' => 'アプリ有効化コード',
            'door_link_code' => 'アプリ有効化リンク',
            'app_activation_code' => 'アプリ有効化コード :accommodation_name (:accommodation_label): :key_code',
            'app_activation_code_log' => ':key_code',
            'door_key_code' => 'ドアコード',
            'checkin_hour' => 'チェックイン時刻 (選択したチェックイン時刻から鍵が有効になります)',
            'checkout_hour' => 'チェックアウト時刻 (選択したチェックアウト時刻まで鍵が有効です)',
            'room_not_mapped' => '部屋 :accommodation_name - :tableau_number はSclakに関連付けられていません。',
        ],
        'nuki' => [
            'property' => '施設',
            'guest' => 'ゲスト',
            'door_key_code' => 'ドアコード',
            'checkin_hour' => 'チェックイン時刻 (選択したチェックイン時刻から鍵が有効になります)',
            'checkout_hour' => 'チェックアウト時刻 (選択したチェックアウト時刻まで鍵が有効です)',
            'room_not_mapped' => '部屋 :accommodation_name - :tableau_number はNukiに関連付けられていません。',
            'code' => '部屋PINコード :accommodation_name (:accommodation_label): :key_code',
            'email_address_not_found' => 'メールアドレスが存在しません。予約にメールアドレスを入力し、Nukiへの招待を送信してください。',
            'generate_keypad_pin' => '数値キーパッドでのアクセス用PINを生成 (施設にキーパッドがある場合のみ選択してください)',
            'sent_with_app' => 'Nukiアプリ経由で送信されました。',
            'authorization_not_found' => '存在しないコードを変更しようとしています。新しいドアコードを生成してください',
            'multi_port_management' => '同じPINコードで複数のドアを開けられるようにする（例：玄関ゲートと部屋）。後でどのドアを接続するかを設定できます',
            'device_not_configured' => 'リンク経由で開けるためのNukiデバイスが見つからないか設定されていません'
        ],
        'errors' => [
            'service_not_active' => '外部サービスがアクティブではありません。',
            'scheduler_not_supported' => '外部サービス :external_service_name は自動スケジューリング機能をサポートしていません。',
        ],
        'warnings' => [
            'manual_code_detected' => '手動で入力された部屋コードが検出されました。手動コードをリモートデバイスに関連付けることはできません。手動で削除してください。',
        ],
        'key_door_services' => [
            'key_door_related' => 'このコードは以下のデバイスも開きます: :devices_name',
        ],
        'gt_revenue' => [
            'spreadsheet_type' => '収益エクスポート基準',
            'spreadsheet_type_segments' => 'セグメント',
            'spreadsheet_type_rooms' => '部屋',
            'date_from' => 'エクスポートの開始日',
            'date_to' => 'エクスポートの終了日',
            'period' => 'エクスポート期間',
        ],
        'pa_friuli' => [
            'year_type' => 'エクスポートする年を選択してください',
            'year_type_previous' => '前年 (:year)',
            'year_type_current' => '今年 (:year)',
        ],

    ],
    'fees' => [
        'deferred' => '繰延納付の消費税',
        'payment_split' => '支払い分割',
        'immediate' => '即時納付の消費税',
        'export_fields' => [
            'date' => '日付',
            'document_type' => '書類タイプ',
            'document_number' => '書類番号',
            'total_taxable' => '課税対象合計',
            'total_taxation' => '消費税合計',
            'total_documents' => '書類合計',
            'customer_name' => '顧客名',
            'customer_type' => '顧客タイプ',
            'documents' => '書類',
            'total_nets' => '課税対象合計',
            'total_taxes' => '消費税合計',
            'documents_total' => '書類合計',
        ],
        'net' => '課税対象',
        'tax' => '消費税',
        'sheets_name' => [
            'rows' => '対応項目',
            'summary' => '概要',
        ],
    ],
    'fiscal_printer' => [
        'not_collected' => '未収',
        'electronic' => 'クレジットカード',
        'not_collected_follows_invoice' => '未収 - 請求書追記',
    ],
    'gdpr' => [
        'privacy' => [
            'title' => '',
            'header' => '<p><strong>PRIVACY POLICY</strong></p>
            <p><strong>on the processing of personal data</strong></p>
            <p>Arts. 12 et seq of Regulation (EU) 2016/679 (GDPR)</p>
            <p>&nbsp;</p>
            <p><strong>FOREWORD </strong></p>
            <p>In compliance with the provisions of EU Regulation 2016/679 (hereinafter referred to as GDPR) we hereby provide information regarding the processing of personal data provided by the data subject, relating to the relationships with the Company. The information is provided pursuant to art. 13 GDPR.</p>
            <p>&nbsp;</p>
            <ol>
            <li><strong>IDENTITY AND CONTACT DETAILS</strong></li>
            </ol>
            <p>The Data Controller :property_name - :property_address (hereinafter the Company).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>
            <p>&nbsp;</p>
            <p>&nbsp;</p>',
            'default_body' => '<p>&nbsp;</p>
            <ol start="2">
            <li><strong>CONTACT DETAILS OF THE DATA PROTECTION OFFICER (DPO)</strong></li>
            </ol>
            <p>The Data Protection Officer is ________________, tel. ______________, e-mail: ______________.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="3">
            <li><strong>PURPOSE OF PROCESSING, LEGAL BASIS AND DATA STORAGE PERIOD</strong></li>
            </ol>
            <table width="680">
            <tbody>
            <tr>
            <td width="191">
            <p><strong><em>Purpose</em></strong></p>
            </td>
            <td width="135">
            <p><strong><em>Types of data that can be processed:</em></strong></p>
            </td>
            <td width="149">
            <p><strong><em>Legal basis</em></strong></p>
            </td>
            <td width="206">
            <p><strong><em>Storage period</em></strong></p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>a)&nbsp;&nbsp; </strong><strong><u>Service Delivery</u></strong></p>
            <p>Registration of the customer and then subsequently fulfilling legal obligations.</p>
            </td>
            <td width="135">
            <p>First Name, Last Name, Phone Number, Additional Requests, Address, ZIP Code, Province, Country, State and E-mail, Payment Information</p>
            </td>
            <td width="149">
            <p>Performance of a contract to which you are a party or pre-contractual measures taken at the request of the data subject;</p>
            <p>Fulfilment of legal obligations.</p>
            <p><em>&nbsp;</em></p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>The retention time is changeable as it is dictated by the difference between the time the reservation is made and the time the guest actually arrives at the facility.</p>
            <p>Encrypted payment information is retained up to 15days after the departure of the client\'s guest.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>b)&nbsp;&nbsp; </strong><strong><u>Request for quotation</u></strong></p>
            <p>Request for quotation with subsequent contact from the Data Controller</p>
            </td>
            <td width="135">
            <p>First name, last name, email and phone number</p>
            </td>
            <td width="149">
            <p>Pre-contractual measures taken at the request of the data subject</p>
            <p>&nbsp;</p>
            <p><em>art. 6 co. 1 lett. b) e c) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time it takes to process the request</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>c)&nbsp;&nbsp; </strong><strong><u>Newsletter</u></strong></p>
            <p>Sending newsletters, by automated means of contacting</p>
            </td>
            <td width="135">
            <p>Personal and contact data</p>
            </td>
            <td width="149">
            <p>Consent (required by contract or specific request);</p>
            <p>(optional and revocable at any time)</p>
            <p><em>Art. 6 co. 1 lett. a) GDPR.</em></p>
            </td>
            <td width="206">
            <p>Until consent for that purpose is withdrawn and/or five years have elapsed since the \'expression of consent.</p>
            </td>
            </tr>
            <tr>
            <td width="191">
            <p><strong>d)&nbsp; </strong>If necessary, to <strong>ascertain, exercise or defend the rights</strong> of the Joint Data Controllers in judicial proceedings</p>
            </td>
            <td width="135">
            <p>Personal data and contact details; data necessary for the execution of the contractual relationship.</p>
            </td>
            <td width="149">
            <p>Legitimate interest (judicial protection).</p>
            <p><em>Art. 6, paragraph 1 letter f) GDPR.</em></p>
            </td>
            <td width="206">
            <p>For the time necessary to exercise rights in court.</p>
            </td>
            </tr>
            </tbody>
            </table>
            <p><strong>&nbsp;</strong></p>
            <ol start="4">
            <li><strong>OBLIGATORY NATURE OF PROVISION OF DATA</strong></li>
            </ol>
            <p>The data subject must provide necessary data for carrying out the contractual relationship to the Company, as well as the data necessary to fulfil the obligations provided for by laws, regulations, community standards, and by provisions of Authorities legitimated by law and by supervisory and control bodies (referred to in purposes a) and f) above).</p>
            <p>Data that are not essential for the performance of the contractual relationship are qualified and considered supplementary and their provision by the data subject, if requested, is optional and subject to consent. Consent provided may be withdrawn by the data subject at any time. Such withdrawal shall in no way affect the lawfulness of processing based on the consents given prior to withdrawal of consent.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong>PROCESSING METHODS</strong></li>
            </ol>
            <p>Personal data will be recorded, processed and stored in the Company&rsquo; archive, paper and electronic, in compliance with the appropriate technical and organizational measures referred to in Art. 32 of the GDPR. The processing of the data subject personal data may consist of any operation or set of operations described in Art. 4, paragraph 1, point 2 of the GDPR.</p>
            <p>Personal data will be processed using suitable tools and procedures that guarantee security and confidentiality. Such processing may be carried out directly and/or via delegated third parties, both manually using hard-copy support and electronically using IT equipment and other instruments. In order to manage properly the relationship and fulfilment of legal obligations, personal data may be entered in the internal documentation of the Company and, if necessary, in the documents and registers required by law.</p>
            <p>Your data may be processed by the employees of the departments of the Company assigned to the pursuit of the above-mentioned purposes. These employees have been expressly authorized to process the data and have received adequate operating instructions pursuant to and for the purposes of Art. 29 GDPR.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="6">
            <li><strong>CATEGORIES OF RECIPIENTS OF PERSONAL DATA</strong></li>
            </ol>
            <p>Personal data under purpose (a) are only disclosed to possible legal offices where required by law.</p>
            <p>Payment data is transmitted to payment service providers for completion of the transaction.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="7">
            <li><strong>DATA TRANSFER TO COUNTRIES OUTSIDE THE EU</strong></li>
            </ol>
            <p>The data provided by the data subject will only be processed countries within the European Union. If the personal data of the data subjects are processed in a country outside of the EU, the data subject&rsquo;s rights under EU legislation will be guaranteed and the data subject will be notified on a timely basis.</p>
            <p>&nbsp;</p>
            <ol start="8">
            <li><strong>RIGHTS OF THE DATA SUBJECT </strong></li>
            </ol>
            <p>Pursuant to Articles 15 et seq of the GDPR, the data subject may exercise the following rights:</p>
            <ol>
            <li>access: to obtain confirmation of whether or not the personal data of the data subject are being processed and the right to access them; requests that are manifestly unfounded, excessive or repetitive cannot be answered;</li>
            <li>rectification: to correct/obtain the correction of personal data if incorrect or outdated and to complete data if incomplete;</li>
            <li>erasure/to be forgotten in some cases, to obtain the erasure of the personal data provided; this is not an absolute right, as the Company may have legitimate or legal reasons to store them;</li>
            <li>limitation: the data will be stored, but cannot be processed further, in the cases foreseen by the regulation;</li>
            <li>portability: to move, copy or transfer data from the Company&rsquo; databases to third parties. This applies only to data provided by the data subject for the performance of a contract or for which express consent has been given and the processing is carried out by automated means;</li>
            <li>objection to direct marketing;</li>
            <li>withdraw of the consent at any time if processing is based on consent.</li>
            </ol>
            <p>Pursuant to Art. 2-<em>undicies</em> of Legislative Decree 196/2003, the exercise of data subjects rights may be delayed, restricted or excluded, following justification provided without delay, unless this might compromise the purpose of the restriction, for as long as and to the extent that this constitutes a necessary and proportionate measure, taking into account the fundamental rights and legitimate interests of the data subject, in order to safeguard the interests referred to in paragraph 1, letters a) (protected interests with regard to money laundering), e) (for the conduct of defensive investigations or the exercise of a right in court) and f) (for the confidentiality of the identity of the employee who reports offenses he becomes aware of on his duties). In such cases, data subjects&rsquo; rights may also be exercised through the Personal Data Protection Authority in the manner referred to in Article 160 of said Decree. In such case, the Personal Data Protection Authority will inform the data subject that it has carried out all the necessary checks or that it has carried out a review, as well as of the data subject right to take legal action.</p>
            <p>&nbsp;</p>
            <p>It should also be noted that - before processing the requests - the Company may ascertain the identity of the data subject, in order to evaluate the legitimacy of the same.</p>
            <p>&nbsp;</p>
            <p>To exercise these rights, the data subject may contact the Data Controller at the addresses indicated in section 1 of this document. The Company will respond within 30 days of receiving the data subject formal request.</p>
            <p>If the abovementioned rights concerning data subject personal data are infringed, the latest may complain to the competent authority.</p>
            <p>&nbsp;</p>
            <p><strong>&nbsp;</strong></p>
            <p><strong>THE DATA</strong></p>
            <p><strong>CONTROLLER</strong></p>',
        ],
        'cookie' => [
            'title' => '',
            'header' => '<p><strong>Cookie Policy of :property_name</strong></p>
            <ol>
            <li><strong>Data Controller</strong></li>
            </ol>
            <p>The Data Controller is :property_name - :property_address (hereinafter the Company or the Owner).</p>
            <p>The Company can be contacted at the following addresses: tel: :property_telephone; e-mail: :property_email</p>',
            'default_body' => '<p>Since the use of third-party Trackers through this Website cannot be fully controlled by the Owner, any specific references to third-party Trackers are to be considered indicative. In order to obtain complete information, Users are kindly requested to consult the privacy policies of the respective third-party services listed in this document.</p>
            <p>Given the objective complexity surrounding tracking technologies, Users are encouraged to contact the Owner should they wish to receive any further information on the use of such technologies by this Website.</p>
            <p><strong>&nbsp;</strong></p>
            <ol start="2">
            <li><strong>Foreword </strong></li>
            </ol>
            <p>This document informs Users about the technologies that help this Website to achieve the purposes described below. Such technologies allow the Owner to access and store information (for example by using a Cookie) or use resources (for example by running a script) on a User&rsquo;s device as they interact with this Website.</p>
            <p>For simplicity, all such technologies are defined as "Trackers" within this document &ndash; unless there is a reason to differentiate.</p>
            <p>For example, while Cookies can be used on both web and mobile browsers, it would be inaccurate to talk about Cookies in the context of mobile apps as they are a browser-based Tracker. For this reason, within this document, the term Cookies is only used where it is specifically meant to indicate that particular type of Tracker.</p>
            <p>Some of the purposes for which Trackers are used may also require the User\'s consent. Whenever consent is given, it can be freely withdrawn at any time following the instructions provided in this document.</p>
            <p>This Website uses Trackers managed directly by the Owner (so-called &ldquo;first-party&rdquo; Trackers) and Trackers that enable services provided by a third-party (so-called &ldquo;third-party&rdquo; Trackers). Unless otherwise specified within this document, third-party providers may access the Trackers managed by them.</p>
            <p>The validity and expiration periods of Cookies and other similar Trackers may vary depending on the lifetime set by the Owner or the relevant provider. Some of them expire upon termination of the User&rsquo;s browsing session.</p>
            <p>In addition to what&rsquo;s specified in the descriptions within each of the categories below, Users may find more precise and updated information regarding lifetime specification as well as any other relevant information &ndash; such as the presence of other Trackers - in the linked privacy policies of the respective third-party providers or by contacting the Owner.</p>
            <p>&nbsp;</p>
            <ol start="3">
            <li><strong> Activities strictly necessary for the operation of this Website and delivery of the Service</strong></li>
            </ol>
            <p>This Website uses so-called &ldquo;technical&rdquo; Cookies and other similar Trackers to carry out activities that are strictly necessary for the operation or delivery of the Service.</p>
            <p><strong>3.1 Third-party Trackers</strong></p>
            <p><strong>3.1.1 Tag Management</strong></p>
            <p>This type of service helps the Owner to manage the tags or scripts needed on this Website in a centralized fashion.</p>
            <p>This results in the Users\' Data flowing through these services, potentially resulting in the retention of this Data.</p>
            <p><strong>3.1.1.1 Google Tag Manager (Google Ireland Limited)</strong></p>
            <p>Google Tag Manager is a tag management service provided by Google Ireland Limited.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Irlanda &ndash; <a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p><strong>3.1.2 Handling payments</strong></p>
            <p>Se non diversamente specificato, questo Sito Web elabora i pagamenti con carta di credito tramite fornitori esterni di servizi di pagamento. In generale, e salvo diversa indicazione, gli Utenti sono pregati di fornire i dettagli di pagamento e le informazioni personali direttamente a tali fornitori di servizi di pagamento.</p>
            <p>Questo Sito Web non &egrave; coinvolto nella raccolta e nell\'elaborazione di tali informazioni: ricever&agrave; invece solo una notifica da parte del fornitore di servizi di pagamento in questione circa l\'avvenuto pagamento.</p>
            <p>Unless otherwise specified, this Website processes payments by credit card via external payment service providers. In general and unless where otherwise stated, Users are requested to provide their payment details and personal information directly to such payment service providers.</p>
            <p>This Website isn\'t involved in the collection and processing of such information: instead, it will only receive a notification by the relevant payment service provider as to whether payment has been successfully completed.</p>
            <p><strong>3.1.2.1 Stripe (Stripe Technology Europe Ltd)</strong></p>
            <p>Stripe is a payment service provided by Stripe Technology Europe, Limited.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://stripe.com/ie/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__stripe_mid: 1 year</li>
            <li>__stripe_sid: 30 minutes</li>
            <li>m: 2 years</li>
            </ul>
            <p><strong>3.1.2.2 PayPal (Paypal)</strong></p>
            <p>PayPal is a payment service provided by PayPal Inc., which allows Users to make online payments.</p>
            <p>Personal Data processed: Trackers and various types of Data as specified in the privacy policy of the service.</p>
            <p>Place of processing: See the PayPal privacy policy &ndash;&nbsp;<a href="https://www.paypal.com/webapps/mpp/ua/privacy-full">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>__paypal_storage__: indefinite</li>
            <li>akavpau_ppsd: duration of the session</li>
            <li>enforce_policy: duration of the session</li>
            <li>l7_az: duration of the session</li>
            <li>nsid: duration of the session</li>
            <li>ts: duration of the session</li>
            <li>tsrce: duration of the session</li>
            <li>x-cdn: duration of the session</li>
            <li>x-pp-s: duration of the session</li>
            </ul>
            <p>&nbsp;</p>
            <ol start="4">
            <li><strong> Other activities involving the use of Trackers</strong></li>
            </ol>
            <p><strong>4.1 Measurement</strong></p>
            <p>This Website uses Trackers to measure traffic and analyze User behavior with the goal of improving the Service.</p>
            <p><strong>4.1.1 Analytics</strong></p>
            <p>The services contained in this section enable the Owner to monitor and analyze web traffic and can be used to keep track of User behavior.</p>
            <p><strong>4.1.1.1 Google Analytics 4 (Google Ireland Limited)</strong></p>
            <p>Google Analytics 4 is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.<br /> In Google Analytics 4, IP addresses are used at collection time and then discarded before Data is logged in any data center or server. Users can learn more by consulting&nbsp;<a href="https://support.google.com/analytics/answer/12017362?hl=en&amp;ref_topic=2919631">Google&rsquo;s official documentation</a>.</p>
            <p>Personal Data processed: browser information, city, device information, latitude (of city), longitude (of city), number of Users, session statistics, Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_ga: 2 years</li>
            <li>_ga_*: 2 years</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.2 Google Analytics (Google Ireland Limited)</strong></p>
            <p>Google Analytics is a web analysis service provided by Google Ireland Limited (&ldquo;Google&rdquo;). Google utilizes the Data collected to track and examine the use of this Website, to prepare reports on its activities and share them with other Google services.<br /> Google may use the Data collected to contextualize and personalize the ads of its own advertising network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>&nbsp;&ndash;&nbsp;<a href="https://tools.google.com/dlpage/gaoptout?hl=en">Opt Out</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>AMP_TOKEN: 1 hour</li>
            <li>_ga: 2 years</li>
            <li>_gac*: 3 months</li>
            <li>_gat: 1 minute</li>
            <li>_gid: 1 day</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Facebook Ads conversion tracking (Facebook pixel) (Meta Platforms Ireland Limited)</strong></p>
            <p>Facebook Ads conversion tracking (Meta pixel) is an analytics service provided by Meta Platforms Ireland Limited that connects data from the Meta Audience Network with actions performed on this Website. The Meta pixel tracks conversions that can be attributed to ads on Facebook, Instagram and Meta Audience Network.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://www.facebook.com/about/privacy/">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>_fbp: 3 months</li>
            <li>fr: 3 months</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.1.3 Google Ads conversion tracking (Google Ireland Limited)</strong></p>
            <p>Google Ads conversion tracking is an analytics service provided by Google Ireland Limited that connects data from the Google Ads advertising network with actions performed on this Website.</p>
            <p>Personal Data processed: Trackers and Usage Data.</p>
            <p>Place of processing: Ireland &ndash;&nbsp;<a href="https://policies.google.com/privacy">Privacy Policy</a>.</p>
            <p>Storage duration:</p>
            <ul>
            <li>IDE: 2 years</li>
            <li>test_cookie: 15 minutes</li>
            </ul>
            <p>&nbsp;</p>
            <p><strong>4.1.2 Marketing</strong></p>
            <p><strong>4.1.2.1. Userguest</strong></p>
            <p>This service allows the user to be shown personalized ads on this website, based on previous visits to this website.</p>
            <p>It does not collect personal data.</p>
            <p>&nbsp;</p>
            <ol start="5">
            <li><strong> How to manage preferences and provide or withdraw consent</strong></li>
            </ol>
            <p>There are various ways to manage Tracker related preferences and to provide and withdraw consent, where relevant:</p>
            <p>Users can manage preferences related to Trackers from directly within their own device settings, for example, by preventing the use or storage of Trackers.</p>
            <p>Additionally, whenever the use of Trackers is based on consent, Users can provide or withdraw such consent by setting their preferences within the cookie notice or by updating such preferences accordingly via the relevant consent-preferences widget, if available.</p>
            <p>It is also possible, via relevant browser or device features, to delete previously stored Trackers, including those used to remember the User&rsquo;s initial consent.</p>
            <p>Other Trackers in the browser&rsquo;s local memory may be cleared by deleting the browsing history.</p>
            <p>With regard to any third-party Trackers, Users can manage their preferences and withdraw their consent via the related opt-out link (where provided), by using the means indicated in the third party\'s privacy policy, or by contacting the third party.</p>
            <p><strong>5.1 Locating Tracker Settings</strong></p>
            <p>Users can, for example, find information about how to manage Cookies in the most commonly used browsers at the following addresses:</p>
            <ul>
            <li><a href="https://support.google.com/chrome/answer/95647?hl=en&amp;p=cpn_cookies">Google Chrome</a></li>
            <li><a href="https://support.mozilla.org/en-US/kb/enable-and-disable-cookies-website-preferences">Mozilla Firefox</a></li>
            <li><a href="https://support.apple.com/guide/safari/manage-cookies-and-website-data-sfri11471/">Apple Safari</a></li>
            <li><a href="http://windows.microsoft.com/en-us/windows-vista/block-or-allow-cookies">Microsoft Internet Explorer</a></li>
            <li><a href="https://support.microsoft.com/en-us/help/4027947">Microsoft Edge</a></li>
            <li><a href="https://support.brave.com/hc/en-us/articles/360022806212-How-do-I-use-Shields-while-browsing">Brave</a></li>
            <li><a href="https://help.opera.com/en/latest/web-preferences/#cookies">Opera</a></li>
            </ul>
            <p>Users may also manage certain categories of Trackers used on mobile apps by opting out through relevant device settings such as the device advertising settings for mobile devices, or tracking settings in general (Users may open the device settings and look for the relevant setting).</p>
            <p><strong>5.2 </strong><strong>Consequences of denying consent</strong></p>
            <p>Users are free to decide whether or not to grant consent. However, please note that Trackers help this Website to provide a better experience and advanced functionalities to Users (in line with the purposes outlined in this document). Therefore, in the absence of the User\'s consent, the Owner may be unable to provide related features.</p>
            <ol start="6">
            <li><strong> Definitions and legal references</strong></li>
            </ol>
            <p><strong>Personal Data (or Data)</strong></p>
            <p>Any information that directly, indirectly, or in connection with other information &mdash; including a personal identification number &mdash; allows for the identification or identifiability of a natural person.</p>
            <p><strong>Usage Data</strong></p>
            <p>Information collected automatically through this Website (or third-party services employed in this Website), which can include: the IP addresses or domain names of the computers utilized by the Users who use this Website, the URI addresses (Uniform Resource Identifier), the time of the request, the method utilized to submit the request to the server, the size of the file received in response, the numerical code indicating the status of the server\'s answer (successful outcome, error, etc.), the country of origin, the features of the browser and the operating system utilized by the User, the various time details per visit (e.g., the time spent on each page within the Application) and the details about the path followed within the Application with special reference to the sequence of pages visited, and other parameters about the device operating system and/or the User\'s IT environment.</p>
            <p><strong>User</strong></p>
            <p>The individual using this Website who, unless otherwise specified, coincides with the Data Subject.</p>
            <p><strong>Data Subject</strong></p>
            <p>The natural person to whom the Personal Data refers.</p>
            <p><strong>Data Processor (or Data Supervisor)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which processes Personal Data on behalf of the Controller, as described in this privacy policy.</p>
            <p><strong>Data Controller (or Owner)</strong></p>
            <p>The natural or legal person, public authority, agency or other body which, alone or jointly with others, determines the purposes and means of the processing of Personal Data, including the security measures concerning the operation and use of this Website. The Data Controller, unless otherwise specified, is the Owner of this Website.</p>
            <p><strong>This Website (or this Application)</strong></p>
            <p>The means by which the Personal Data of the User is collected and processed.</p>
            <p><strong>Service</strong></p>
            <p>The service provided by this Website as described in the relative terms (if available) and on this site/application.</p>
            <p><strong>European Union (or EU)</strong></p>
            <p>Unless otherwise specified, all references made within this document to the European Union include all current member states to the European Union and the European Economic Area.</p>
            <p><strong>Cookie</strong></p>
            <p>Cookies are Trackers consisting of small sets of data stored in the User\'s browser.</p>
            <p><strong>Tracker</strong></p>
            <p>Tracker indicates any technology - e.g Cookies, unique identifiers, web beacons, embedded scripts, e-tags and fingerprinting - that enables the tracking of Users, for example by accessing or storing information on the User&rsquo;s device.</p>
            <p><strong>Legal information</strong></p>
            <p>This privacy statement has been prepared based on provisions of multiple legislations, including Art. 13/14 of Regulation (EU) 2016/679 (General Data Protection Regulation).</p>
            <p>This policy relates solely to this Website, if not stated otherwise within this document.</p>
            <p>&nbsp;</p>',
        ],
    ],
    'general' => [
        'accommodation_not_found' => '部屋が見つかりません',
        'channel_unsupported_function' => 'このチャンネルはこの機能をサポートしていません',
        'rateplan_not_found' => '料金プランが見つかりません',
        'accommodations' => '部屋',
        'unknown' => '不明',
        'unauthorized' => '許可されていません',
        'expired_password' => 'あなたのパスワードの有効期限が切れました。続行するには更新してください。',
        'not_found' => '見つかりません',
        'not_found_or_not_authorized' => 'リソースが見つからないか、アクセスが拒否されました',
        'no_relationship_found' => '関連性が見つかりません',
        'existing_periods' => '重複している期間があります',
        'existing_condition' => '既存の条件です',
        'missing_accommodation_rateplan' => '部屋に関連付けられた料金プランがありません',
        'missing_accommodation_channel_source' => '部屋のソースチャンネルがありません',
        'missing_accommodation_channel_destination' => '部屋の目的地チャンネルがありません',
        'missing_accommodation_channel' => '部屋のチャンネルがありません',
        'missing_treatment_or_rateplan' => 'この部屋にはトリートメントまたは料金プランがありません',
        'same_source_destination' => '送信元と宛先が同じです',
        'impossible_delete_addon_category' => '関連付けられている場合、追加サービスカテゴリを削除できません',
        'impossible_delete_system_addon_category' => 'システムの追加サービスカテゴリを変更または削除できません',
        'property_xml_already_connected' => 'PropertyXmlはすでに他の施設に接続されています',
        'city_tax' => '宿泊税',
        'taxs' => '税金',
        'virtual_stamp' => 'バーチャルスタンプ',
        'default_group' => 'デフォルトグループ',
        'existing_mail' => '既存のメールアドレス',
        'unique_mail' => '一意のメールアドレス',
        'existing_username' => '既存のユーザー名',
        'unique_username' => '一意のユーザー名',
        'resource_conflict' => '選択したリソースの競合',
        'special_requests' => '特別リクエスト',
        'name' => '名前',
        'surname' => '姓',
        'and' => 'と',
        'arrival' => '到着',
        'clean_fees' => '清掃費',
        'departure' => '出発',
        'adults' => '大人',
        'adult' => '大人',
        'children' => '子供',
        'child' => '子供',
        'eta' => '年齢',
        'male' => '男性',
        'female' => '女性',
        'customer' => '顧客',
        'company' => '会社',
        'telephone' => '電話番号',
        'email' => 'Eメール',
        'nationality' => '国籍',
        'too_many_login_attemps' => 'ログイン試行回数が多すぎます。:minute_unthrottle 分後に再試行してください',
        'country' => '国',
        'coupon' => 'クーポン',
        'from' => 'から',
        'to' => 'まで',
        'nights' => '泊数',
        'payment_status' => '支払い状況',
        'total' => '合計',
        'reservation' => '予約',
        'quote' => '見積もり',
        'di' => 'の',
        'stay' => '滞在',
        'extra' => '追加',
        'tax' => '税金',
        'payment' => '支払い',
        'del' => 'の',
        'channel' => 'チャンネル',
        'lodging' => '宿泊',
        'treatment' => 'プラン',
        'accommodations_reserved' => '予約済みの部屋',
        'option_status_export' => 'ステータスエクスポート',
        'option_revenue' => '収益データ',
        'option_time' => 'エクスポート時間',
        'guest_card_service_not_connected' => '施設に関連付けられていない、または無効なタイプのサービス',
        'guest_card_guests_number_error' => 'ゲストの数が不足しています',
        'guest_card_date_from_error' => '変更は許可されていません。有効開始日が今日より前です。',
        'imp' => '重要',
        'iva' => '消費税',
        'type' => 'タイプ',
        'documents' => '書類',
        'generic_payment' => '一般的な支払い',
        'accommodation' => '部屋',
        'accommodation_name' => '宿泊施設',
        'accommodation_total' => '宿泊総額',
        'error' => 'エラー',
        'status' => 'ステータス',
        'language' => '言語',
        'guests' => 'ゲスト',
        'guest' => 'ゲスト',
        'paid' => '支払済み',
        'to_pay' => '支払う必要があります',
        'suspended' => '保留中',
        'to_be_invoiced' => '請求される必要があります',
        'note' => 'ノート',
        'note_internal' => '予約メモ',
        'note_internal_accommodation' => '宿泊施設の内部メモ',
        'note_customer' => '顧客からのリクエスト',
        'note_checkin' => 'チェックイン用メモ',
        'note_checkout' => 'チェックアウト用メモ',
        'note_housekeeper' => 'ハウスキーピングメモ',
        'note_catering' => '食事メモ',
        'note_bill' => '請求書発行用メモ',
        'bill_charged' => '請求済み',
        'total_documents' => '合計文書',
        'checkin_online' => 'オンラインチェックイン',
        'cancellation' => 'キャンセル',
        'no_show' => 'ノーショー',
        'referral_id' => '#:referral_id:',
        'missing_param' => 'パラメータ :param が不足しています',
        'properties' => '施設',
        'amount' => '金額',
        'reservation_total' => '予約合計',
        'total_paid' => '支払総額',
        'total_to_pay' => '支払うべき合計',
        'general_error' => '一般エラー',
        'module_not_active' => 'モジュール :moduleName は次の施設でアクティブではありません: ',
        'reservation_summary' => '予約概要',
        'department_not_faund' => '部門が見つかりません',
        'department_exist' => '既に税務プリンタに関連付けられている部門を削除することはできません',
        'upload_virus_found' => 'アップロードされたファイルは破損または悪意があると判断されました',
        'upload_antivirus_service' => 'ファイルをアップロードできませんでした。後で再試行するか、サービスに連絡してください',
        'document' => '{1} ドキュメント|[2,*] ドキュメント',
        'reservation_to_queue_from_cart' => '予約を処理中です。操作が完了すると通知されます。',
        'active' => 'アクティブ',
        'expired' => '期限切れ',
        'export' => 'エクスポート',
        'send_data' => 'データを送信',
        'missing_credentials' => 'ユーザー名またはパスワードがありません',
        'yes' => 'はい',
        'no' => 'いいえ',
        'door_key_codes' => 'ドアキーコード',
        'external_door_link' => '外部ドアを開けるリンク',
        'accommodation_door_key_codes' => '宿泊施設の開錠コード :accommodationTableauLabel',
        'city_tax_report' => [
            'errors' => [
                'filter_not_available' => 'フィルターは利用できません',
                'filter_format' => '受け入れられないフィルタ形式',
                'filter_number_arguments_exceeded' => 'フィルタの引数数が許容範囲を超えています',
            ],
        ],
        'fields' => [
            'field_update' => ':field を :oldValue から :newValue に変更しました',
            'guest_type_id' => 'ゲストタイプ',
            'city_tax_exemption_id' => '宿泊税免除',
            'main_guest' => 'メインゲスト',
            'arrival_date' => '到着日',
            'departure_date' => '出発日',
            'roomreservation_id' => '部屋',
            'checkin' => 'チェックイン',
            'checkout' => 'チェックアウト',
            'enabled' => '有効',
            'disabled' => '無効',
            'undefined' => '未定義',
            'deleting' => '削除された項目:',
            'update_guest' => 'ゲスト :name :surname (:id) の情報を更新しました: :fields',
            'delete_guest' => 'ゲスト :name :surname (:id) :invoiced_city_tax',
            'invoiced_city_tax' => '宿泊税が請求されました',
            'arrival_lunch' => '昼食に到着',
            'arrival_dinner' => '夕食に到着',
            'arrival_not_set' => '希望なし',
        ],
        'exceptions' => [
            'impossible_to_get_conversation_references' => '会話情報を取得することができません',
            'ota_channel_message_not_supported' => '指定されたチャンネルはメッセージ送信機能をサポートしていません',
            'recipient_has_not_configured_email_address' => '受信者がメールアドレスを設定していません',
            'impossible_to_resend_not_failed_message' => '失敗していないメッセージを再送信することはできません',
            'impossible_to_delete_this_message' => 'このメッセージを削除することはできません',
            'message_not_valid' => '次のフィールドが無効です: ',
            'newsletter_config_not_valid' => '次の設定フィールドが無効です: ',
            'newsletter_not_valid' => '次のニュースレターフィールドが無効です: ',
            'newsletter_default_mail_not_valid' => '次のデフォルトメールフィールドが無効です: ',
            'newsletter_condition_not_valid' => '配信リスト条件の次のフィールドが無効です: ',
            'message_alredy_exists' => 'メッセージは既に存在します',
            'some_uploaded_files_are_unsupported' => 'アップロードされたファイルの中にサポートされていないものがあります',
            'attachments_not_permitted_for_channel' => 'この通信チャンネルでは添付ファイルの送信が許可されていません',
            'uploaded_too_many_images' => '1メッセージにつき1枚の画像しか送信できません',
            'you_cannot_send_message_that_contains_email_addresses' => 'メールアドレスを含むメッセージを送信することはできません',
            'you_cannot_send_message_that_contains_url' => 'URLを含むメッセージを送信することはできません',
            'you_cannot_send_message_that_contains_phone_number' => '電話番号を含むメッセージを送信することはできません',
            'you_cannot_receive_message_without_reservation_type' => '予約なしでメッセージを受信することはできません',
            'impossible_to_set_message_read_status' => 'メッセージの既読状態を変更することはできません',
            'gt_revenue_not_valid' => 'GT Revenueエクスポート用の次のパラメータが無効です: ',
            'export_not_valid' => 'エクスポート生成用の次のパラメータが無効です: ',
            'method_not_implemented' => 'ドライバー :driverName のメソッド :methodName は実装されていません',
            'temporary_disabled_action_move_guest' => '次のアクションは現在無効です: ゲストを削除し、指定された部屋で再作成してください',
            'batch_job_not_found' => 'ジョブが見つかりません',
            'impossible_invoke_method' => 'このメソッドを呼び出すことはできません',
        ],
        'conversation_messages' => [
            'participant_alredy_exists' => 'この会話に既に参加者が関連付けられています',
            'placeholder_photo' => '写真',
        ],
    ],
    'guest_presence' => [
        'summary' => 'ゲスト滞在概要',
        'daily_summary_of_date' => ':date の日次サマリー',
        'accommodation' => '宿泊施設',
        'accommodation_type' => '宿泊タイプ',
        'name_and_surname' => '氏名',
        'age' => '年齢',
        'sex' => '性別',
        'stay' => '滞在',
        'stay_status' => 'ステータス',
        'plan' => '階',
        'property' => '施設',
        'no_records' => '表示するデータがありません',
        'date' => '日付',
        'export_title' => 'ゲスト滞在記録',
    ],

    'guest_reporting' => [
        'errors' => [
            'unable_to_delete_movements' => '次のエラーにより、移動データを削除できませんでした: :error',
            'unable_to_send_movements' => '次のエラーにより、移動データを送信できませんでした: :error',
            'unable_to_check_movements_type' => '次のエラーにより、移動タイプを確認できませんでした: :error',
            'movements_type_not_valid' => 'このポータルでは施設の移動タイプが無効です',
            'cannot_delete_movements' => '送信日がポータルに記録されている最新の送信日と一致しないため、移動を削除できません',
            // トグル
            'generic_already_reported' => 'この項目は既にエクスポートされています',
            'reservation_already_reported' => '予約 :identifier は既にエクスポートされています',
            'reservation_accommodation_already_reported' => '宿泊施設 :identifier は既にエクスポートされています',
            'reservation_accommodation_guest_already_reported' => 'ゲスト :identifier は既にエクスポートされています',
            'reservation_accommodation_guest_not_sent' => 'ゲストが送信されていません',
            'reservation_accommodation_guest_can_not_delete' => 'ゲストはすでに月次締めに含まれているため削除できません',
            'reservation_accommodation_guest_missing' => 'ゲストが見つかりません',
            // ゲストごとのエラーの概要
            'place_code_missing' => '場所コードが存在しません。サポートに連絡してください。',
            'cannot_be_single_guest' => 'ゲストタイプが無効です: シングルゲストにすることはできません。',
            'customer_has_incomplete_birth_place' => '出生地が不足しているか不完全です。',
            'customer_has_incomplete_document_data' => '書類のデータが不足しているか不完全です。',
            'customer_has_incomplete_residence' => '出生地または居住地コードが不足しています。サポートに連絡してください。',
            'customer_has_invalid_gender' => '性別が指定されていません。',
            'customer_has_invalid_type' => '無効なゲストタイプです。',
            'customer_has_no_birth_date' => '生年月日がありません。',
            'customer_birth_date_in_future' => '生年月日は今日以降であってはなりません。',
            'customer_has_no_birth_city_country_place' => '出生地と国コードが不足しています。サポートに連絡してください。',
            'customer_has_no_birth_place' => '出生地が不足しているか不完全です。',
            'customer_has_no_name' => '名前がありません。',
            'customer_has_no_nationality_or_has_null_code' => '国籍が不足しています。',
            'customer_has_no_residence_city_country_place' => '居住地と国コードが不足しています。サポートに連絡してください。',
            'customer_has_no_residence_place' => '居住地国コードが不足しています。サポートに連絡してください。',
            'customer_has_no_surname' => '姓がありません。',
            'customer_has_no_data' => '必須項目をすべて入力してください。',
            'customer_has_not_present' => '予約にゲストが登録されていません。',
            'some_customer_has_not_present' => ':customer_number 人のゲストデータが不足しています|:customer_number 人のゲストデータが不足しています',
            'guest_has_no_customer_data' => '必須項目をすべて入力してください。',
            'invalid_length_of_stay' => '滞在期間が無効です',
            'invalid_row_size' => '宿泊データ行の長さが無効です。サポートに連絡してください。',
            'invalid_value_size' => 'フィールドの長さが無効です。',
            'invalid_surname_size' => '姓の長さが無効です。最大50文字まで許可されます。',
            'invalid_name_size' => '名前の長さが無効です。最大30文字まで許可されます。',
            'invalid_document_number_size' => '書類番号の長さが無効です。最大20文字まで許可されます。',
            'invalid_released_size' => '書類発行場所の長さが無効です。最大9文字まで許可されます。',
            'must_be_single_guest' => 'ゲストタイプが無効です: シングルゲストを入力してください。',
            // グループごとのエラーの概要
            'customer_has_no_leader' => 'グループリーダーまたは家族のリーダーがいません。',
            'family_leader_alone' => '家族のリーダーが家族メンバーなしで存在します。',
            'family_member_alone' => '家族のリーダーを追加してください。',
            'group_leader_alone' => 'グループリーダーがメンバーなしで存在します。',
            'group_member_alone' => 'グループリーダーを追加してください。',
            'multiple_family_leaders' => '1つの宿泊施設につき1人の家族リーダーしか許可されません。',
            'multiple_group_leaders' => '1つの予約につき1人のグループリーダーしか許可されません。',
            'invalid_group_leader_in_family' => '無効なグループリーダー（家族リーダーが存在します）。',
            'invalid_group_member_in_family' => '無効なグループメンバー（家族メンバーである必要があります）。',
            'invalid_family_leader_in_group' => '無効な家族リーダー（グループリーダーが存在します）。',
            'invalid_family_member_in_group' => '無効な家族メンバー（グループメンバーである必要があります）。',
            'room_has_no_family_leader' => '家族リーダーを追加してください。',
            'room_has_many_leaders' => '1つの宿泊施設につき1人の家族リーダーしか許可されません。',
            'room_has_no_family_members' => '家族リーダーが家族メンバーなしで存在します。',
            // その他のエラー
            'no_exportable_guests' => 'エクスポート可能なデータがありません。',
            'no_istat_module_configured' => 'Istatグループが構成されていません。',
            'rooms_number_overflow' => '占有されている宿泊施設の数がポータルで構成された最大数を超えています。設定 > Istatで情報を確認してください。',
            'unmapped_tableau_number' => 'マッピングされていない宿泊施設。宿泊施設グループ設定を確認してください。',
            'no_tableau_number' => '指定された日に関連付けられた宿泊施設がありません: :date',
            'unexpected_date' => '予期されるエクスポート日は :date です。エクスポート日を変更してください。',
            'unexpected_send_date' => '予期される送信日は :date です。送信日を変更してください。',
            'empty_italian_birth_city_code' => '出生地コードが見つかりません。サポートに連絡してください。',
            'empty_italian_birth_county_abbreviation' => '出生県コードが見つかりません。サポートに連絡してください。',
            'empty_italian_residence_city_code' => '居住市コードが見つかりません。サポートに連絡してください。',
            'empty_italian_residence_county_abbreviation' => '居住県コードが見つかりません。サポートに連絡してください。',
            // シチリア専用エラー（ゲストのみ）
            'guest_validation_failed' => 'シチリア観光局はゲスト :name を検証できません。',
            // 滞在が送信されましたが、誰かが手動で削除した場合のみ発生
            'sync_failed' => '\n観光ポータルで手動で削除された予約への出席または変更を送信しようとしています。削除された予約の送信を無効にするか、再試行してください。',
            // Turismo 5/シチリア固有エラー
            'uncaught_forbidden' => '資格情報または施設コードが無効です。データの正確性を確認してください。',
            // AlloggiatiWebの特定エラー
            'wrong_username_password_wskey' => 'ユーザー名、パスワード、またはWsKeyが無効です',
            'generic_error' => 'ポータルが正しく応答しませんでした。後でもう一度試してください。',
            'generic_error_send' => 'ポータルが正しく応答しませんでした。後でもう一度試してください。',
            'missing_istat_code' => '場所 :placeName のIstatコードが見つかりません。サポートに連絡してください。',
            'alloggiatiweb_error_owner_apartment' => 'このアカウントにはアパートコードを使用する必要があります。設定 > Alloggiati Webで設定を有効にしてください。',
            'alloggiatiweb_error_owner_hotel' => 'このアカウントではアパートコードを使用できません。設定 > Alloggiati Webで設定を無効にしてください。',
            'sicilia_web_service_outcome_empty_response' => 'ポータルが正しく応答しませんでした。後でもう一度試してください。',
            'istat_the_portal_not_responding' => 'ポータルが正しく応答しませんでした。後でもう一度試してください。',
            'istat_exemption_not_valid' => 'ABITによる免除は認められていません。',
        ],
        'success' => [
            'upload_recordset_completed' => '記録セットのアップロードが正常に完了しました。',
        ],
        'webservice' => [
            'service_unavailable' => 'サービスが利用できないか、正しく構成されていません。',
        ],
        'fields' => [
            'date_to_send' => '送信日',
            'date_to_export' => 'エクスポート日',
            'current_date' => '現在の日付',
            'last_sent_day' => '最後にエクスポートした日付',
            'use_progression' => '使用する進行状況',
            'is_auto' => '送信タイプ',
            'is_auto_description' => '自動送信/手動送信',
            'reference_date' => '検索の基準日',
            'operation_code_label' => '操作コード',
            'operation_code_description' => '送信操作を識別します',
            'do_not_update_current_day_label' => '現在の日付を更新しない',
            'do_not_update_current_day_description' => 'Istatを送信した場合、現在の日付が進められません',
            'hotel_code' => '施設コード',
            'property_list' => '施設一覧',
            'get_property_code' => '施設コードを取得する',
            'username' => 'ユーザー名',
            'password' => 'パスワード',
            'declared_available_rooms' => '実際に販売可能な宿泊施設の数',
            'declared_available_beds' => '実際に販売可能なベッド数',
            'guest_id' => 'ゲストID',
            'guest_id_description' => '削除するゲストのID',
            'delete_movements_flag' => '動き削除の確認',
            'delete_movements_flag_description' => '動きを削除するかどうかを示すフラグ',
            'delete_movements_not_confirmed' => 'この日付以降の動きを削除してもよろしいですか？この操作は取り消せません。',
            'ricestat' => [
                // Ricestat専用の翻訳
                'username' => 'Ricestatユーザー名',
            ],
            'sicilia' => [
                // シチリア観光局専用の翻訳
                'username' => '観光局のユーザーID',
                'hotel_code' => '登録時に発行されたホテルコード（ユーザー名と異なる場合）',
            ],
            'sired' => [
                // Sired専用の翻訳
                'declared_available_rooms' => '販売可能な宿泊施設の合計（ポータルで申告された数）',
                'declared_available_beds' => '販売可能なベッド数（ポータルで申告された数）',
            ],
            'turismo5' => [
                // Turismo 5専用の翻訳
                'hotel_code' => '施設コードまたは地域コード',
                'declared_available_rooms' => '販売可能な宿泊施設の合計（ポータルで申告された数）',
                'declared_available_beds' => '販売可能なベッド数（ポータルで申告された数）',
                'endpoint' => '地理的エリア',
            ],
            'c59' => [
                // C59専用の翻訳
                'c59_progression' => '基準日までの進行状況',
                'c59_year' => '進行状況の基準年',
            ],
            'trento' => [
                // トレント専用の翻訳
                'declared_available_rooms' => '利用可能な部屋数',
            ],
            'astat' => [
                // Astat専用の翻訳
                'accommodationId' => 'ホテルコードまたは宿泊施設ID',
                'prepare_local_tax' => '宿泊税を準備する',
                'close_month' => '月を閉じる',
                'token' => 'トークン',
                'last_month_closed' => '最後に閉じた月',
                'property_closed_date_range' => '施設の休業期間',
            ],
            'sinfonia' => [
                'cusr' => '施設識別子',
                'api_key' => '管理システムのAPIキー'
            ],
            'webtur' => [
                'cir' => '地域施設識別コード（CIR）',
                'cin' => '宿泊施設の国内識別コード (CIN)',
                'declared_available_rooms' => '利用可能な部屋数',
            ],
            'option_scheduled_label' => 'Istatレポートの自動送信を有効にしますか？',
            'option_scheduled_description' => 'システムは設定された現在の日付から自動的にレポートを送信します',
            'option_scheduled_send_every_hour_label' => 'Istatレポートの送信頻度を指定してください',
            'show_city_tax' => '宿泊税を表示する',
        ],
    ],
    'guest' => [
        'alloggiatiweb' => [
            'no_guests_txt' => '登録されたゲストがいません',
            'property_no_module_configured' => '施設にはAlloggiatiwebモジュールが設定されていません',
            'wrong_size_file' => 'ファイルサイズが不正です。サポートに連絡してください',
            'wrong_arrival_date' => '到着日が不正です',
            'general_error' => '資格情報が無効、または証明書が無効です',
            'error_txt_file' => 'Alloggiatiレポートファイルの作成中にエラーが発生しました',
            'post_upload_error' => '無効なファイルです。ファイルタイプを確認してください',
            'invalid_certificate' => '証明書ファイルが無効です',
            'certificate_and_password_required' => '証明書とパスワードが必要です',
        ],
        'logger' => [
            'city_tax_log' => ':name :surname, 年齢 :age 歳 (:first_date - :last_date 宿泊施設: :accommodation_name) 合計: :total_city_tax',
            'naming' => 'ゲスト :name :surname: ',
            'checkin_date' => 'チェックイン: :arrival_date => :checkin_date',
            'checkout_date' => 'チェックアウト: :departure_date => :checkout_date',
        ],
        'errors' => [
            'different_property_on_move' => '指定された部屋の施設は、あなたの施設グループに含まれていません',
            'family_master_already_in_room' => '続行できません。対象の部屋にすでに家族リーダーが存在します',
            'checkin_checkout_not_suitable' => 'ゲストのチェックインまたはチェックアウト日が、対象の部屋と互換性がありません',
            'not_found' => 'ゲストが見つかりません',
            'city_tax_already_sent_to_channel' => 'ゲストは既に関連する宿泊税ポータルに送信されています。続行できません',
            'change_accommodation_with_invoiced_tax' => '宿泊税が請求されたゲストの部屋タイプを変更することはできません',
        ],
        'guest_cards' => [
            'empty_error' => '資格情報が無効、または施設が有効化されていません。',
            'uknown_error' => '外部サービスの不明なエラー',
            'venice_tax_exemption_type' => 'ベネチア市アクセス税免除タイプ',
            'guest_required' => 'ゲストカードを関連付けるゲストを指定する必要があります',
            'customer_fields_are_required' => '次のゲストフィールドは必須です: :fields',
            'customer_required_fields' => [
                'name' => '名前',
                'surname' => '姓',
                'nic' => '税番号',
                'birthday_date' => '生年月日',
                'birth_country.translations.0.name' => '出生地',
                'detail.email' => 'メール',
                'detail.telephone' => '電話番号',
                'detail.country.translations.0.name' => '居住地',
            ],
        ],
    ],
    'housekeeper' => [
        'main_title' => 'ハウスキーパー',
        'clean_status' => '状態',
        'name' => 'ハウスキーパー',
        'label' => '番号',
        'accommodation' => '宿泊施設',
        'bed_type' => '配置',
        'bed_type_requested' => 'リクエストされた配置',
        'bed_type_last' => '前回の配置',
        'bed_type_next' => '次の配置',
        'next_abbrevation' => '次',
        'prev_abbrevation' => '前',
        'guests' => 'ゲスト',
        'reservations' => '予約',
        'guests_checkin' => '到着予定',
        'guests_in_home' => '滞在中',
        'guests_checkout' => '出発予定',
        'next_change_sheet' => 'シーツ交換',
        'day' => '日',
        'days' => '日々',
        'today' => '今日',
        'notes' => 'メモ',
        'housekeeper_notes' => 'ハウスキーパーメモ',
        'room_clean' => '清掃済み',
        'room_dirty' => '未清掃',
        'adults' => '大人: :count',
        'children' => '子供: :count',
        'requested' => 'リクエスト済み',
        'today' => '今日',
        'tomorrow' => '明日',
        'maintenance' => 'メンテナンス',
        'export_fields' => [
            'cleaning' => '清掃',
            'accommodation' => '宿泊施設',
            'housekeeper' => 'ハウスキーパー',
            'status' => '状態',
            'staging' => '配置',
            'sheet' => 'シーツ',
            'linen' => 'リネン',
            'details' => '詳細',
            'created_at' => '日付',
            'user' => 'ユーザー',
            'scenario_title' => 'シナリオ',
            'column1' => '日付/リソース',
            'column2' => '計画',
            'column3' => '時間',
            'scenario' => '計画',
            'housekeeper_collaborator' => '共同作業者',
        ],
        'print' => [
            'number_of_accommodations' => ':number 宿泊施設',
            'number_of_checkin' => '到着: :checkin_done / :checkin_total',
            'number_of_checkout' => '出発: :checkout_done / :checkout_total',
            'number_of_inhome' => '滞在中 :number_in_home',
            'change_sheet' => 'シーツ交換',
            'change_linen' => 'リネン交換',
            'note_housekeeper' => 'ハウスキーパーへのメモ',
            'pending_manteiner' => ':number 件の解決待ちレポート',
            'status_checkin' => '到着予定',
            'status_checkout' => '出発予定',
            'status_in_home' => '滞在中',
            'status_label_adult' => ':adults 大人',
            'status_label_children' => ':children_number 子供',
            'passed_nights' => '宿泊日 :passed_nights / :total_nights',
        ],
        'bed_type_current' => '要求された準備',
    ],
    'import' => [
        'customer' => [
            'job_name' => '顧客',
            'warnings' => ['required_field' => '必須フィールド'],
            'tooltips' => [
                'skip_on_missing' => 'アップロードされたファイル内でこの項目に値が含まれていないレコードは、インポート時に無視されます。',

                'sex_value' => '<br />各性別に受け入れられる値：  
        <br />- 男性：male、maschio、uomo、m、man、maschile、u  
        <br />- 女性：female、femmina、donna、f、woman、femminile、d  
        <br />- 未指定：not_defined、non definito、non specificato、na、n/a、空白セル  
        <br />大文字小文字の区別はなく、「uomo」「UOMO」「Uomo」などすべて同じように扱われます。',

                'birth_country_required' => '出生地の都市の正確なマッチングのためには、このフィールドのマッピングも必須です。国名はあらゆる言語で入力可能で、すべての ISO コード（3166-1 の3桁、alpha-2、alpha-3）も受け付けます。',

                'birth_country' => '出生国のみ（都市なし）をマッピングした場合、選択された国の首都が顧客情報の出生都市として自動的に入力されます。国名はあらゆる言語で、すべての ISO コードを大文字小文字の区別なく受け付けます。',

                'birth_city' => '都市名を正しくマッチングするには、次のフィールド「出生国」もマッピングする必要があります。都市名は任意の言語で入力可能です。',

                'citizenship_country' => '国名はあらゆる言語で、すべての ISO コード（3166-1 の3桁、alpha-2、alpha-3）を大文字小文字の区別なく受け付けます。',

                'language' => 'システムが対応している言語：イタリア語、英語、フランス語、ドイツ語、スペイン語、ロシア語、日本語。その他の言語は英語として処理されます。  
        受け入れ可能な形式（大文字小文字を問わず）：  
        - ISO 639-1（2文字）、例：ja  
        - ISO 639-2（3文字）、例：jpn  
        - 言語名（イタリア語・英語・フランス語・ドイツ語・スペイン語で記載されたもの）、例：giapponese、japanese、japonais、japanisch、japonés  
        ファイル内に値が存在しない、またはマッピングされていない場合、居住国の公用語が使用され、ない場合はデフォルト言語が使用されます。',

                'residence_city' => '都市名を正しくマッチングするには、次のフィールド「居住国」もマッピングする必要があります。都市名は任意の言語で入力可能です。',

                'residence_country_required' => '居住都市を正確にマッチングするためには、このフィールドのマッピングが必須です。国名はあらゆる言語で、すべての ISO コード（3166-1 の3桁、alpha-2、alpha-3）を受け付けます。',

                'residence_country' => '居住国のみ（都市なし）をマッピングした場合、選択された国の首都が顧客情報の出生都市として自動的に入力されます。国名はあらゆる言語で、すべての ISO コードを大文字小文字の区別なく受け付けます。',

                'residence_address' => '都市、郵便番号、国を含まず、住所のみをマッピングしてください。',

                'email' => 'メールアドレスを入力してください。PEC（認証メール）は専用フィールドがあります。',

                'document_type' => 'Alloggiati Web ポータルがサポートするすべての文書種別を大文字小文字を問わず受け入れます。特に一般的な文書（身分証明書、電子身分証、運転免許証、パスポート）は、CI、CIE、ID、PASS などの略称も受け付けます。',

                'released_country_required' => '発行都市の正確なマッチングには、このフィールドのマッピングが必須です。国名はあらゆる言語で、すべての ISO コードを受け付けます。',

                'released_country' => '発行国のみ（都市なし）をマッピングした場合、選択された国の首都が顧客情報の出生都市として自動的に入力されます。国名はあらゆる言語で、すべての ISO コードを大文字小文字の区別なく受け付けます。',

                'released_city' => '都市名を正しくマッチングするには、次のフィールド「文書発行国」もマッピングする必要があります。都市名は任意の言語で入力可能です。',

                'invoicing_country_required' => '請求先都市を正しくマッチングするためには、このフィールドのマッピングが必須です。国名はあらゆる言語で、すべての ISO コードを受け付けます。',

                'invoicing_country' => '請求国のみ（都市なし）をマッピングした場合、選択された国の首都が顧客情報の出生都市として自動的に入力されます。国名はあらゆる言語で、すべての ISO コードを大文字小文字の区別なく受け付けます。',

                'invoicing_city' => '都市名を正しくマッチングするには、次のフィールド「請求国」もマッピングする必要があります。都市名は任意の言語で入力可能です。',
            ],

            'columns' => [
                'name' => '名前',
                'surname' => '苗字',
                'sex' => '性別',
                'birthday_date' => '生年月日',
                'nic' => '税番号',
                'email' => 'メールアドレス',
                'pec' => 'PECアドレス',
                'telephone' => '電話番号',
                'language' => '言語',
                'birth_country' => '出生国',
                'birth_city' => '出生都市',
                'nationality_country' => '国籍 (例: 日本)',
                'citizenship_country' => '市民権国',
                'residence_country' => '居住国',
                'residence_city' => '居住都市',
                'residence_address' => '居住住所',
                'residence_zip_code' => '居住郵便番号',
                'invoicing_country' => '請求国',
                'invoicing_city' => '請求都市',
                'invoicing_address' => '請求住所',
                'invoicing_zip_code' => '請求郵便番号',
                'sdi_code' => 'SDIコード',
                'facebook' => 'Facebook URL',
                'linkedin' => 'LinkedIn URL',
                'twitter' => 'Twitter URL',
                'skype' => 'Skype',
                'note' => 'メモ',
                'lottery_code' => '宝くじコード',
                'document_type' => 'ID ドキュメントタイプ',
                'document_number' => 'ドキュメント番号',
                'expiration_date' => 'ドキュメント有効期限',
                'released_country' => 'ドキュメント発行国',
                'released_city' => 'ドキュメント発行都市',
                'release_county' => 'ドキュメント発行県',
                'release_state' => 'ドキュメント発行州',
                'lang_values' => ['giapponese', 'japanese', 'japonais', 'japanisch', 'japonés', '日本語', 'jpn',],
                'sex_values' => [
                    'male' => [
                        '男',
                    ],
                    'female' => [
                        '女性',
                    ],
                    'not_defined' => [
                        '指定されていない',
                        '定義されていません',
                    ],
                ]
            ],
        ],
        'company' => [
            'job_name' => '企業',
            'columns' => [
                'name' => '会社名',
                'vat_code' => 'VATコード',
                'nic' => '税番号',
                'nick_name' => 'ニックネーム',
                'email' => 'メール',
                'pec' => 'PEC',
                'telephone' => '電話番号',
                'country' => '国',
                'city' => '都市',
                'address' => '住所',
                'zip_code' => '郵便番号',
                'invoicing_country' => '請求国',
                'invoicing_city' => '請求都市',
                'invoicing_address' => '請求住所',
                'invoicing_zip_code' => '請求郵便番号',
                'sdi_code' => 'SDIコード',
                'facebook' => 'Facebook',
                'linkedin' => 'LinkedIn',
                'twitter' => 'Twitter',
                'skype' => 'Skype',
                'note' => 'メモ',
            ],
        ],
        'booking_onboard_photo_property' => [
            'job_name' => 'Bookingからの施設写真インポート',
        ],
        'common' => [
            'personal_informations' => '個人情報',
            'contacts' => '連絡先',
            'residential_details' => '居住詳細',
            'invoice_address' => '請求先住所詳細',
            'documents' => 'ドキュメント',
            'email' => 'メール',
            'other' => 'その他',
        ],
        'sending_list_contacts' => [
            'job_name' => '連絡先リスト',
            'columns' => [
                'label' => 'ラベル',
                'email' => 'メールアドレス',
                'locale' => '言語',
            ],
        ],
        'errors' => [
            'request_params_not_valid' => 'リクエストパラメータが無効です: ',
        ],
    ],
    'invoice_layouts' => [
        'errors' => [
            'delete' => [
                'one_or_more_receipt_modules_attached' => 'この請求モジュールに関連付けられた1つ以上の財務プリンタがあります。この請求プロファイルを削除するには、財務プリンタを削除するか、新しいプロファイルに関連付けてください。',
            ],
        ],
    ],
    'invoice_received' => [
        'title' => '受領請求書',
        'export_fields' => [
            'document_date' => '書類の日付',
            'received_date' => '受領日',
            'document_name' => '書類名',
            'sender_name' => '送信者',
            'sender_vat_code' => '送信者のVATコード',
            'total_taxable' => '課税対象合計',
            'total_taxes' => '消費税',
            'total_document' => '合計',
            'discount_amount' => '割引額',
            'status' => '状態',
            'paid' => '支払済み',
            'amount_to_be_paid' => '支払額合計',
        ],
        'statuses' => [
            'unpaid' => '未払い',
            'paid' => '支払済み',
            'partially_paid' => '一部支払済み',
            'cancelled' => 'キャンセル済み',
        ],
        'document_types' => [
            'RT01' => '個人源泉徴収',
            'RT02' => '法人源泉徴収',
            'RT03' => 'INPS拠出金',
            'RT04' => 'ENASARCO拠出金',
            'RT05' => 'ENPAM拠出金',
            'RT06' => 'その他の社会保障拠出金',
            'TD01' => '請求書',
            'TD02' => '請求書の前払い/前金',
            'TD03' => '料金の前払い/前金',
            'TD04' => '貸方票',
            'TD05' => '借方票',
            'TD06' => '料金',
            'TD16' => '国内リバースチャージ請求書統合',
            'TD17' => '国外サービス購入用統合/自動請求書',
            'TD18' => 'EU域内物品購入用統合',
            'TD19' => 'D.P.R. n. 633/1972第17条2項に基づく物品購入用統合/自動請求書',
            'TD20' => '請求書正規化および統合用自動請求書',
            'TD21' => '制限超過用自動請求書',
            'TD22' => '税金倉庫からの物品引き出し',
            'TD23' => '税金倉庫からの物品引き出し (VAT支払い)',
            'TD24' => '遅延請求書 (第21条4項a)',
            'TD25' => '遅延請求書 (第21条4項b)',
            'TD26' => '減価償却資産および内部移転の販売',
            'TD27' => '自己消費または無償譲渡用請求書',
        ],
    ],
    'invoice' => [
        'export_fields' => [
            'payment_date' => '支払日',
            'number' => '請求書番号',
            'business_name' => '会社名',
            'total_price' => '合計',
            'vat' => '消費税',
            'taxable' => '課税対象',
            'invoice_date' => '書類の日付',
            'recipient_vat_code' => '受信者のVATコード',
            'number_complete' => '番号',
            'recipient_business_name' => '受信者名',
            'total_with_discount' => '課税対象額',
            'total_tax' => '消費税合計',
            'total' => '合計',
            'status_sdi' => 'SDI',
            'expire_date' => '期限',
            'status' => '状態',
            'payment_term' => '支払期限',
            'customer_name' => '顧客名',
            'payment' => '支払い',
            'date' => '日付',
            'accountholder' => '口座名義人',
            'notes' => 'メモ',
            'paid' => '支払済み',
            'to_pay' => '支払額',
            'property' => '施設',
            'payment_status' => '支払い状態',
            'data' => 'データ',
            'currency' => '通貨',
            'total_document' => '書類合計',
        ],
        'statuses' => [
            'paid' => '支払済み',
            'suspended' => '保留中',
            'cancelled' => 'キャンセル済み',
        ],
        'sdi_statuses' => [
            '0' => '未送信',
            '1' => '処理中',
            '2' => '拒否',
            '3' => '完了',
        ],
        'pdf_export' => [
            'description' => '説明',
            'quantity' => '数量',
            'amount' => '金額',
            'vat' => '消費税',
            'vat_abbr' => 'VAT',
            'total' => '合計',
            'invoice_label' => '請求書',
            'of_date' => '日付',
            'taxable' => '課税対象',
            'deposit' => 'デポジット',
            'deposit_document_reference' => '書類参照',
            'aomount_not_taxable' => '課税対象外金額',
        ],
        'invoices_opened' => [
            'invoices_opened_title' => '未決済支払い',
            'export_fields' => [
                'expire_date' => '期限',
                'accountholder' => '口座名義人',
                'document_number' => '書類番号',
                'date' => '日付',
                'type' => 'タイプ',
                'paid' => '支払済み',
                'to_pay' => '支払額',
                'total' => '合計',
                'note' => 'メモ',
                'property' => '施設',
            ],
        ],
        'errors' => [
            'advance_not_suitable' => '前払金の添付ファイルは、書類タイプに適していません。',
            'credit_note_on_follows_invoice_paid' => '支払済みの請求書に関連する控除には対応できません。',
            'credit_note_on_follows_invoice_linked' => '他の勘定に関連付けられた請求書に対する控除には対応できません。',
            'restore_on_follows_invoice_linked' => '他の勘定に関連付けられた請求書の勘定を再開することはできません。',
            'cant_restore_opened_invoice' => '未完了の勘定を再開することはできません。',
            'module_sdi_not_active' => '電子請求書モジュールが有効ではありません。',
            'refund_major_than_total_credit_note' => '控除額が合計を超えています。続行できません。',
            'expense_on_invoice' => '控除以外の書類に費用を関連付けることはできません。',
            'cant_resend_due_status' => '現在のSDIステータスでは再送できません。',
            'empty_xml' => 'XMLが見つかりません。',
            'cancellation_no_show_conflict' => 'キャンセルまたはノーショーのいずれかのみを指定できます。',
            'cant_delete_credit_note' => '控除を削除できません。',
            'add_to_invoices_already_registered' => '登録済みの請求書または控除に追加することはできません。',
            'edit_invoices_already_registered' => '登録済みの請求書を編集することはできません。',
            'delete_registered_invoice' => '登録済みの請求書を削除することはできません。',
            'impossible_delete_until_moves' => '勘定を削除するには、請求書を他の勘定に移動する必要があります。',
            'not_exist' => '請求書が存在しません。',
            'vat_payment_impossible_for_receipt' => '領収書に即時VAT以外のオプションを設定することはできません。',
            'unrestorable_bill' => 'この請求書を復元することはできません。',
            'impossible_discount_for_discounted_bills' => '割引済みの請求書に対してさらに割引を適用することはできません。',
            'refundable_bill_in_invoice' => '控除以外の請求書に返金参照を追加することはできません。',
            'impossible_manual_charge_updating' => 'この請求書を更新することはできません。',
            'impossible_follows_invoice_updating' => '請求書に関連付けられた請求書の変更はできません。',
            'impossible_associate_invoice_as_advance' => '通常の請求書を前払い請求書として関連付けることはできません。',
            'advances_over_allowed' => '前払い請求書の金額が許可された上限を超えています。',
            'fp_advances_with_different_department' => '選択した前払い領収書は同じVAT率である必要があります。',
            'advances_no_have_department' => '前払いに使用された部門は、残高請求書の項目の1つとして存在する必要があります。',
            'advances_total_major' => '前払いの金額は、関連する部門の請求書項目の合計を超えることはできません。',
            'invoice_totally_refunded' => '請求書は全額返金済みで、続行できません。',
            'advance_with_different_customer' => '異なる受信者のため、前払い請求書を関連付けることはできません。',
            'advance_totally_assigned' => '完全に割り当てられた前払い請求書を返金することはできません。',
            'deposit_in_general_invoice' => '一時勘定に前金を割り当てることはできません。',
            'bill_overrated' => '支払い額が関連する請求額を超えています。',
            'invoice_overrated' => '支払い額が関連する請求書の合計を超えています。',
            'property_not_attached' => 'プロパティが関連付けられていません。',
            'funds_params_unsuitable' => '基金のパラメータが適合しません。',
            'registered_advance_invoice' => '登録済みの前払い請求書があり、削除前に関連する請求書を削除してください。',
            'registered_sdi invoice' => 'SDIに送信済みの前払い請求書は削除できません。',
            'move_between_different_types' => '請求書と控除の間で項目を移動することはできません。',
            'discount_over' => '適用された割引が請求書項目の合計を超えています。',
            'archive_completed' => 'アーカイブが既に完了しています。',
            'too_many_tasks' => '実行中のタスクが多すぎます。',
            'archive_warning' => '一部のファイルが不足しています。',
            'archive_complete' => '完了',
            'invoice_registered' => '請求書が既に発行されており、続行できません。',
            'bill_tranfer_follows_invoice' => '請求書に関連付けられた請求書項目を移動することはできません。',
            'bill_generic_and_follows_invoice' => '汎用項目と請求書項目を同時に追加することはできません。',
            'different_vat_code_follows_invoice' => '請求書のVATコードが異なります。続行できません。',
            'receipt_with_follows_invoice' => '領収書として登録された請求書を発行することはできません。',
            'type_not_invoice_summary' => '未収書類をこの書類に関連付けることはできません。',
            'archive_all_file_not_found' => 'ファイルが見つかりません。',
            'impossible_apply_discount_row_on_discounted_invoice' => '割引された請求書に項目割引を適用することはできません。',
            'cant_delete_invoice_due_convention' => '契約に関連付けられた請求書は削除できません。',
            'discount_on_invoice_and_on_row' => '割引済みの請求書にさらに割引を適用することはできません。',
            'discount_on_summary_invoice' => '請求書の概要に割引を適用することはできません。',
            'cant_delete_invoice_due_linked_advances' => '他の請求書のバランスを埋めるために使用された前払い請求書を削除することはできません。',
            'cant_delete_invoice_due_credit_notes' => '控除された書類は削除できません。',
            'cant_delete_invoice_due_module_fattelettronica' => '既に登録されている請求書は削除できません。',
            'cant_restore_invoice_due_sdi_ns' => 'SDIに拒否された請求書の勘定を再開することはできません。',
            'cant_transfer_due_invoice_registered' => '登録済みの請求書を移動することはできません。',
            'cant_merge_credit_note' => '控除を統合することはできません。',
            'cant_merge_due_module_fattelettronica' => 'SDIに送信された請求書を統合することはできません。',
            'cant_transfer_without_holder' => '受取人のいない勘定に移動することはできません。',
            'empty_row_document' => '書類には少なくとも1行を追加してください。',
            'cant_delete_receipt' => '領収書を削除することはできません。',
            'addon_unrelated' => 'この勘定に追加サービスを関連付けることはできません。',
            'impossible_add_row' => '既に発行された、または存在しない書類に行を追加することはできません。',
            'uncharged_rows_found_on_restore' => '請求書を復元できません。関連項目は他の勘定に関連付けられています。',
            'cant_create_temporary_due_missing_layout' => '請求書テンプレートが見つからないため、書類を作成できません。',
            'move_bill_over_discount' => '請求書を移動できません。移動可能な最大額は: :max_thresholdです。',
            'cant_decrement_price_invoiced_bill' => '既に発行された請求書の金額を減少させることはできません。',
            'printer_id_not_associated' => '請求書テンプレートに関連付けられたプリンタがありません。',
            'cant_move_reservation_due_advance_invoice' => '前払い請求書があるため、予約を移動できません。請求書のバランスを設定するか、控除を適用してください。',
            'cant_move_reservation_due_deposit' => '保証金があるため、予約を移動できません。保証金を削除または返金してください。',
            'cant_move_reservation_due_payments' => '支払いがあるため、予約を移動できません。支払いを削除または返金してください。',
            'cant_update_invoice_balance' => '残高請求書のデータを更新できません。',
            'cant_update_invoice_balance_layout' => '現在のVATコードと互換性がないため、テンプレートを変更できません。',
            'cant_register_invoice_balance_price' => '請求書の合計は支払いの合計と一致している必要があります。',
            'cant_choose_payment_deposit_different_property' => '保証金番号 :deposit_number をこの書類に使用できません。異なるプロパティに属しています。',
            'cant_choose_payment_advance_different_property' => '前払い請求書番号 :number_complete をこの書類に使用できません。異なるプロパティに属しています。',
            'cant_create_invoice_layout_without_vat_code_without_properties_enabled' => 'VATコードがないプロファイルを、税免除が有効でないプロパティに作成することはできません。',
            'unable_to_register_not_all_inclusive_tax_document_addons' => '税免除に適していない追加料金があります。設定で変更するか、他の料金と統合してください。',
            'tax_bills_rows_joined_with_other_type_bills_on_all_tax_inclusive_document' => '税金タイプの項目が他のタイプと混在しています。分離して再試行してください。',
            'all_tax_inclusive_layout_on_fiscal_printer' => 'VATコードのないテンプレートを税プリンタに関連付けることはできません。',
            'all_inclusive_tax_document_for_advance' => '税免除の設定では前払い書類を作成できません。',
            'advances_on_all_inclusive_tax_doument' => '税免除ドキュメントの残高に前払い請求書を使用することはできません。',
            'credit_note_on_all_inclusive_tax_document' => '税免除の設定で控除を発行することはできません。キャンセルで対応してください。',
            'missing_department_override' => '請求書の項目 :name に関連付けられた部門が不足しています。',
            'missing_department' => '部門が不足しています (VAT率 :vat_quote %、タイプ :type)',
            'advance_bill_not_found' => '前払い請求書が見つかりません。',
            'totals_bills_not_equals' => '請求書の合計が行の合計と一致していません。',
            'multiple_invoices_bill_rows_override' => '異なる請求書に属する項目の上書きはできません。',
            'cant_create_override_for_registered_invoice' => '登録済みの請求書や存在しない書類の上書きを作成、変更、または削除することはできません。',
            'cant_edit_print_settings_for_registered' => '登録済みの書類や存在しない書類の印刷設定を変更することはできません。',
            'not_found' => '書類が見つかりません。',
            'no_attachments' => 'この書類には添付ファイルがありません。',
            'error_attachments' => '添付ファイルのダウンロード中にエラーが発生しました。',
            'advance_with_all_inclusive_tax_document' => '税免除の設定では前払い請求書を発行できません。',
            'empty_email' => 'メールアドレスを入力してください。',
            'empty_email_pdf' => 'PDFドキュメントが利用できません。',
            'advance_partially_used' => '一部使用された前払い請求書に控除を発行することはできません。',
            'different_vat_payment_on_advance' => '異なるVAT適用条件を持つ前払い請求書を関連付けることはできません。',
            'cant_delete_credit_note_due_to_sdi_or_fp' => 'SDIに送信済み、またはプリンタで発行された控除は削除できません。',
            'cant_delete_credit_note_between' => '複数の請求書に関連する控除は削除できません。',
            'destination_deleted' => '受信者がシステム内に存在しません。',
            'vat_code_not_valid' => '入力されたVATコードは無効です。',
            'tax_code_not_valid' => '入力された税コードは無効です。',
            'empty_codes' => '税コードまたはVATコードが無効です。',
            'row_exceed_total_price' => '返金する項目が元の合計を超えています。',
            'row_exceed_qty' => '返金する項目数が元の数量を超えています。',
            'cant_register_invoice_as_follows_invoice' => '「請求書に従う」モードで請求書を登録することはできません。',
            'cant_register_rejected_invoice_as_receipt' => '拒否された請求書を領収書として発行できません。',
            'cant_turn_to_paid_follows_invoice' => '「請求書に従う」モードで支払済みに設定することはできません。',
            'reversal_on_receipt_follows_invoice_joined' => '請求書に関連付けられた領収書に控除を発行することはできません。',
            'receipt_channel_must_activated' => '仮想プリンタを設定するには、外部システムモジュールを有効にする必要があります。',
            'partial_cannot_exceed_total' => '部分的な金額が請求書の合計を超えることはできません。',
            'partial_cannot_exceed_percentage' => '部分的な割合が合計を超えることはできません。',
            'credit_note_partial_on_advance' => '前払い請求書には部分的な控除を適用できません。',
            'credit_note_partial_on_fp_send' => 'プリンタで発行された書類には部分的な控除を適用できません。',
            'credit_note_partial_on_follows_invoice' => '「請求書に従う」モードの請求書には部分的な控除を適用できません。',
            'row_to_refund_not_found' => '返金する項目が見つかりません。',
            'partial_only_credit_note' => '控除に部分的な金額を適用することはできません。',
            'partial_credit_note_total_payment_exceed_source_payment' => '控除の合計支払いが元の支払い合計を超えています。',
            'payment_not_belonging_to_invoice_source' => '選択された支払いは元の書類に属していません。',
            'payment_not_found' => '選択された支払いが見つかりません。',
            'partial_credit_note_row_payment_exceed_source_payment' => '控除の行支払いが元の支払い合計を超えています。',
            'city_tax_bills_partial_refund' => '市税タイプの請求書には部分的な返金を適用できません。',
            'credit_note_paid_major_than_total' => 'ドキュメントの支払い合計が総額を超えています',
            'discount_over_permitted' => '適用された割引は、税金を除いた最大許容合計額を超えています',
        ],
        'errors_xml' => [
            'error_additional_charges_are_required_to_issue_the_receipt' => '残高と前払金の差額（:totalPayments €）が文書を閉じるのに必要な値（:subtractPayment €）を下回っています。各項目は最低0.01 €の価値が必要です。:amountRequired €の請求を追加するか、カテゴリまたはサービス別に請求をグループ化して項目数を減らしてください。',
            'error_total_cannot_be_less_than_one_cent' => '書類の合計金額は前払金の合計より高くなければなりません（最低 0.01 €）',
            'payment_not_valid' => '無効な支払い方法です。',
            'tax_system' => '発行者の税制度が無効です。請求書プロファイルで税制度を設定してください。',
            'cap' => '発行者の郵便番号が無効です。',
            'destination_code' => '宛先コードが無効です。',
            'destination_code_pa' => '公共機関向けの宛先コードが無効です。',
            'destination_code_pr' => '個人向けの宛先コードが無効です。',
            'destination_cf' => '宛先の税コードが無効です。',
            'destination_cap' => '宛先の郵便番号が無効です。',
            'address' => '請求書の住所が未記入です。',
            'empty_row_description' => 'すべての文書行の説明を入力してください。',
            'department_fp' => '該当する税率の部門が存在しません。',
            'payment_error' => '支払い詳細エラー。',
            'payment_error_amount' => '文書の総額が指定された支払いの合計を下回っています。',
            'payment_error_code' => '無効な支払いコード: ',
            'nature' => 'ゼロ税率の設定に対して性質が指定されていません。',
            'reverse_charge' => '分割払いとリバースチャージを同時に適用することはできません。',
            'error_sdi' => 'SDI送信エラー。入力値を確認してください。',
            'document_no_xml' => 'この文書タイプはXMLとして有効ではありません。',
            'not_found' => 'XMLが見つかりません。',
            'error_send_invoice' => 'プロバイダー送信エラー。',
            'limit_document_id' => '文書番号 :id_document が無効です。許可される20文字の制限を超えています。',
            'error_import_invoice' => 'インポート拒否。',
            'xsd_validation_skip' => 'XSD検証問題。検証がスキップされました。',
            'xsd_validation_failed' => '要素 :node の入力値 (:value) が無効です。',
            'error_limit_number_invoice' => 'ファイルを送信できません。ドキュメントが使い果たされています。サポートに連絡してください。',
            'error_account_inactive' => 'プロバイダーの請求書アカウントが無効です。サポートに連絡してください。',
            'payment_error_vat_quote' => '合計額と前払いの間で税率が異なります。',
            'error_content_document' => '文書の内容が正しくありません。サポートに連絡してください。',
            'error_create_document' => 'XML文書の作成エラー。サポートに連絡してください。',
            'error_xml_format_received' => '受信したXMLの形式が無効です。',
            'error_empty_response' => '受信したXMLが空です。',
            'error_zip_archive_creation' => 'ZIPファイルの作成エラー。',
            'error_empty_document' => 'XML文書が空です。サポートに連絡してください。',
            'voucher_code_not_valid' => 'バウチャーコードが無効です。',
            'custom' => [
                'limit_message_content' => 'メッセージ内容が42文字の制限を超えています。',
            ],
            'rch' => [
                'limit_message_content' => 'メッセージ内容が25文字の制限を超えています。',
            ],
        ],
        'warnings' => [
            'document_not_found' => 'ID :invoice_id のドキュメントが見つかりません。',
            'city_tax_charged_for_guest' => 'ゲストに課金されています。続行しますか？',
            'vat_code_already_joined' => 'プロファイルはすでに請求書または支払いに関連付けられています。VAT番号またはヘッダー情報を変更できません。',
            'all_inclusive_tax_document_with_vat_code' => '包括税ドキュメントはVAT番号での発行と互換性がありません。',
            'cant_restore_bill_invoiced' => '課金が請求済みのため復元できません。',
            'cant_restore_bill_stay_not_involved' => '課金が宿泊に関連する日付ではありません。削除しますか？',
            'cant_restore_bill_not_related' => 'この課金を復元できません。リソースが存在しなくなっています。',
            'cant_update_bill_day_price' => '日付 :date の価格を変更できません。課金者の請求総額が価格差を下回っています。',
            'cant_update_bill_day_price_due_convention' => ':date の課金に関連する支払い者がアカウント分割と一致しません。料金の変更は課金セクションで直接行ってください。',
            'cant_delete_bill_stay' => '宿泊タイプの課金を削除できません。',
            'cant_delete_due_to_joined_documents' => '発行済みドキュメントに存在する課金を削除できません。',
            'number_used' => 'この請求書番号はすでに使用されています。',
            'number_no_sequential' => '使用された番号の日付は、前の請求書日付と次の請求書日付の間である必要があります。',
            'transferred_bills_present' => '予約から転送された課金がアカウントに存在します。この操作により、それらが完全に削除またはリセットされます。',
            'layout_numbers_existing' => 'このVAT番号または税コードには既存の連続番号があります。新しい請求プロファイルに設定された番号に置き換えますか？最近発行されたドキュメント番号を確認することをお勧めします。',
            'additional_info_block_only_for_invoice' => 'この文書タイプには追加情報ブロックを挿入できません。',
            'detach_not_collected_document' => 'ドキュメントタイプを変更すると、関連付けられていないドキュメントが削除されます。続行しますか？',
            'cant_restore_general_bill' => 'パススルー口座からの引き落としを復元できません。手動で振替を続行してください。',
        ],
        'pdf' => [
            'accommodations' => '宿泊',
            'addons' => '追加',
            'advances' => '前金',
            'taxes' => '税金',
            'deposits' => 'デポジット',
            'credit_note_reversal' => '受領取消',
            'advance_with_number_complete' => '前金請求書番号 :number_complete',
            'payment' => '支払い',
            'taxation_list' => '税額一覧',
            'taxable_amount' => '課税対象額',
            'tax_amount' => '税額',
            'total' => '合計',
            'total_taxes' => '税金合計',
            'total_taxable' => '課税合計',
            'total_taxation' => '税額合計',
            'total_amount' => '総合計',
            'total_paid' => '支払い済み',
            'total_to_pay' => '未払い額',
            'document_heading' => 'ドキュメント番号 :identifier 日付 :date',
            'document_advance_heading' => '予約番号 #:identifier - 前金',
            'document_heading_no_date' => 'ドキュメント番号 :identifier',
            'document_num' => 'ドキュメント番号',
            'document_date' => '日付',
            'payable' => '非課税文書',
            'proforma' => '仮請求書',
            'additional_information' => '追加情報',
            'additional_information_contract' => '契約',
            'additional_information_purchase_order' => '購入注文',
            'additional_information_agreement' => '契約条件',
            'additional_information_receiving' => '受領',
            'additional_information_joined_invoices' => '関連請求書',
            'additional_information_progress_status' => '進捗状況',
            'additional_information_document_id' => '文書ID',
            'additional_information_line_number_referral' => '行番号',
            'additional_information_num_item' => 'アイテムID',
            'additional_information_date' => '日付',
            'additional_information_agreement_deal_code' => '取引コード',
            'additional_information_cup' => 'CUPコード',
            'additional_information_cig' => 'CIGコード',
            'additional_information_step_reference' => 'ステップ参照',
            'invoice' => '請求書',
            'unregistered_invoice' => '口座',
            'receipt' => '領収書',
            'credit_note' => 'クレジットノート',
            'proforma' => 'プロフォーマ',
            'auto_invoice' => '自己請求書',
            'reverse_auto_invoice' => '自己請求書取消',
            'debit_note' => '借方メモ',
            'destination' => '宛先',
            'causal' => '理由',
            'extra_notes' => '備考',
            'attachments' => '添付ファイル',
            'sdi_send_date' => 'SDI送信日',
            'rounding' => '四捨五入',
            'vat_payment' => [
                'D' => '遅延税支払い',
                'I' => '即時税支払い',
            ],
            'payment_method' => '支払い方法',
            'iban' => 'IBAN',
            'institution' => '機関',
            'credit_institution' => '金融機関',
            'amount_virtual_stamp' => 'バーチャルスタンプ金額',
            'discount' => '割引',
            'discount_amount' => '割引額または増額',
            'receipts' => '領収書一覧',
            'reversal' => '領収書取消一覧',
            'receipts_expired' => '「期限切れ」状態の領収書一覧',
            'receipts_unpaid' => '「未払い」状態の領収書一覧',
            'receipts_suspended' => '「保留中」状態の領収書一覧',
            'receipts_paid' => '「支払い済み」状態の領収書一覧',
            'payments' => '支払い',
            'payment_date' => '支払い日',
            'payment_label' => '支払い者',
            'payment_method' => '方法',
            'amount_available' => '利用可能金額',
            'amount_used' => '使用額',
            'deposit' => 'デポジット',
            'copy_text' => '法的効力のない控えコピーです。正本はSDI（交換システム）に送信され、税務当局の専用エリアで確認できます。',
        ],
        'wording' => [
            'virtual_stamp_causal_more' => '2014年6月17日法令第6条に基づき、バーチャル方式でスタンプ税を納付済み',
            'all_inclusive_tax_document_exemption' => '免税 - 2011年3月14日法令第23号第3条',
            'standard_advance' => '予約番号 #:reference_number - 前金',
            'manual_fp_register' => '既に課税済みの文書として',
            'follows_invoice' => '請求書に準ずる',
            'default' => '標準',
            'force_change' => '料金変更を強制する'
        ],
        'art17' => '元請負人が受け取らない税分割操作（DPR 633/1972第17条の3）。',
        'art6' => '遅延課税適用（DPR 633/1972第6条第5項）。',
        'invoice_module' => [
            'invalid_vat_code' => '無効なVAT番号',
            'invalid_invoice_channel' => '有効なチャネルを選択してください。',
            'error_get_data' => 'アカウント情報取得エラー',
            'vat_code_exist' => 'このVAT番号を持つモジュールが既に存在します。',
            'error_fiscal_printer_linked' => '発行済みの領収書がプリンターに関連付けられています。削除しますか？',
            'customer' => '顧客 (こきゃく)',
            'subcontracting' => '下請け (したうけ)'
        ],
        'invoice_import' => [
            'import_success' => 'ファイルが正常にインポートされました',
            'import_skip' => 'スキップされたファイル（宛先のVAT番号が無効または既にインポート済みのファイル）',
            'import_error' => 'インポートエラー、不正なXMLファイル',
        ],
        'no_show' => [
            'invoice_label' => 'ノーショー',
            'invoice_cancellation' => 'キャンセル',
            'no_vat_quote_defined' => '施設には:type のVAT率が定義されていません',
        ],
        'cancellation' => [
            'invoice_label' => 'キャンセル料金',
        ],
        'lottery_code' => '宝くじコード: :lottery_code',
        'log' => [
            'title' => '請求書処理',
            'advance' => '請求書 :invoice_number (:invoice_date) は請求プロファイル :invoice_layout (:invoice_business_name - :invoice_vat_code) を使用し、宛先 :invoice_customer に合計 :invoice_total で作成されました。',
            'refunded_advance' => ':date の :number ドキュメントの :amount が再び利用可能になりました',
            'partial_credit_note' => ':credit_note_number ドキュメントは、:refund_mode で :credit_note_total: :bill_logs ドキュメントを返金しました。 :advance_logs',
        ],
        'types' => [
            'reversal' => '取消領収書',
            'credit_note' => 'クレジットノート',
            'receipt' => '領収書',
            'invoice' => '請求書',
            'proforma' => 'プロフォーマ',
            'auto_invoice' => '自己請求書',
            'debit_note' => 'デビットノート',
            'reverse_auto_invoice' => '自己請求書取消',
            'unregistered_invoice' => '口座',
        ],
        'open_charges' => '未清算の請求',
        'operational_headquarter' => '運用拠点',
        'advances' => '前金',
        'log_module' => [
            'invoice_module_updated' => '請求モジュール が更新されました',
            'invoice_module_created' => '請求モジュール が作成されました',
            'invoice_module_deleted' => '請求モジュール が削除されました',
        ]
    ],
    'logger' => [
        'field_updated' => ':section [:field] が :old_value から :new_value に更新されました',
        'titles' => [
            'queue_update' => 'キューの更新',
            'bulk_update' => '一括更新',
            'new_reservation' => '新しい予約',
            'update_reservation_status' => '予約ステータスの変更',
            'cancel_accommodation' => '予約した部屋をキャンセル',
            'move_accommodation' => '予約した部屋を移動',
            'update_accommodation' => '予約した部屋を更新',
            'update_accommodation_arrival' => '到着日を更新',
            'update_accommodation_departure' => '出発日を更新',
            'add_accommodation' => '予約に部屋を追加',
            'reservation_status' => '予約ステータスを更新',
            'cancel_reservation' => '予約をキャンセル',
            'delete_reservation' => '予約を削除',
            'cancel_reservation_no_new' => '新しいステータスなしで予約をキャンセル',
            'clone_rates' => ':channel_source から :channel_destination へのクローン作成',
            'clone_rates_bulk' => '一括更新からのクローン',
            'payment_transaction' => '支払い取引',
            'update_accommodation_listing_price' => '宿泊料金を :channel_destination に更新',
            'accommodations_overview' => '日次概要',
            'reset_min_stay' => '最小滞在日数をリセット',
            'tableau_closure_create' => 'Tableau の閉鎖を作成',
            'tableau_closure_delete' => 'Tableau の閉鎖を削除',
            'attach_channel' => ':channel_name チャンネルを接続',
            'detach_channel' => ':channel_name チャンネルを切断',
            'read_channel' => ':channel_name チャンネルのデータを読み取り',
            'increase_quantity' => '部屋数を増加',
            'decrease_quantity' => '部屋数を減少',
            'insert_rule' => '新しいルールを追加',
            'update_rule' => 'ルールを変更',
            'delete_rule' => 'ルールを削除',
            'cutoff' => 'カットオフ',
            'insert_cutoff' => 'カットオフルールを追加',
            'modify_cutoff' => 'カットオフルールを変更',
            'delete_cutoff' => 'カットオフルールを削除',
            'bulk_treatments_update' => 'トリートメントの一括更新',
            'treatments_overview' => '日次トリートメント概要',
            'rateplan_update' => '料金プランを更新',
            'OTA-API' => 'パートナーAPI',
            'update_channel' => '発信元チャンネルを変更',
            'keep_accommodation' => '宿泊施設の移動をブロック',
            'keep_accommodation_label' => '宿泊施設 :accommodations の値が変更されました',
            'channel_not_connected' => 'チャンネルが接続されていません',
            'city_tax_report_exclusion' => '宿泊税レポートからの除外',
            'city_tax_report_exclusion_label' => '宿泊施設 :accommodations の値が変更されました',
            'update_from_past_years' => '過去の料金をコピー',
            'accommodations_mapping' => '部屋のマッピング',
            'no_association' => '関連付けなし',
        ],
        'messages' => [
            'accommodation_mapping' => ':origin から :destination へ',
        ],
        'warnings' => [
            'missing_dates_updates' => '次の期間のデータを同期できませんでした: ',
        ],
    ],
    'mail_channels_errors' => [
        'ses' => [
            'missing_required_fields_for_verfication' => '送信チャンネルの検証に必要なフィールドが不足しています',
            'existing_ses_identity' => '既存の送信元メール',
            'configuration_set' => [
                'AlreadyExistsException' => '設定セットは既に存在します',
                'NotFoundException' => '設定セットが見つかりません',
                'TooManyRequestsException' => '設定セットの作成要求が多すぎます',
                'LimitExceededException' => '設定セットのインスタンス数が制限を超えました',
                'BadRequestException' => '無効な設定セット',
                'ConcurrentModificationException' => '別のインスタンスが設定セットを変更しました',
            ],
            'send_bulk_email' => [
                'TooManyRequestsException' => 'メール送信要求が多すぎます',
                'LimitExceededException' => 'メール送信のインスタンス数が制限を超えました',
                'AccountSuspendedException' => 'メールを送信できません。アカウントの送信能力が制限されています',
                'SendingPausedException' => 'メールを送信できません。アカウントの送信能力が一時停止されています',
                'MessageRejected' => 'メールを送信できません。不適切な内容が含まれています',
                'MailFromDomainNotVerifiedException' => '送信ドメインが確認されていないため、メールを送信できません',
                'NotFoundException' => 'メール送信リソースが見つかりません',
                'BadRequestException' => '無効なメール送信入力',
            ],
            'configuration_set_event_destination' => [
                'AlreadyExistsException' => 'イベント宛先が既に存在します',
                'NotFoundException' => 'イベント宛先が見つかりません',
                'TooManyRequestsException' => 'イベント宛先作成の要求が多すぎます',
                'LimitExceededException' => 'イベント宛先のインスタンス数が制限を超えました',
                'BadRequestException' => '無効なイベント宛先',
            ],
            'configuration_set_attributes' => [
                'NotFoundException' => '設定属性を設定できません。設定が見つかりません',
                'TooManyRequestsException' => '設定属性の設定要求が多すぎます',
                'BadRequestException' => '無効な設定属性',
            ],
        ],
    ],
    'mail_channels' => [
        'fields' => [
            'host' => 'ホスト',
            'port' => 'ポート',
            'username' => 'ユーザー名',
            'password' => 'パスワード',
            'email_from' => '送信元メール',
            'secure' => 'TLS\SSL',
            'domain_email' => '送信ドメインメール',
        ],
        'choices' => [
            'ssl' => 'SSL',
            'tls' => 'TLS',
        ],
        'errors' => [
            'missing_required_fields_for_verfication' => '送信チャンネルの検証に必要なフィールドが不足しています',
            'existing_ses_identity' => '既存の送信元メール',
        ],
        'channels_name' => [
            1 => 'SMTP',
            2 => 'Beddy - メールサービス',
        ],
    ],
    'meals' => [
        'breakfasts' => '朝食',
        'lunches' => '昼食',
        'dinners' => '夕食',
        'note' => '備考',
    ],
    'messages' => [
        'download_attachments' => '添付ファイルをダウンロード',
    ],
    'newsletters_conditions' => [
        'errors' => [
            'validation_error' => '機能 \':feature\' に渡された値の型は、\':type\' である必要があります。',
            'duplicate_condition_error' => '基準 \':criteriaName\' は既に送信リストに関連付けられています。',
            'limit_values_error' => '機能 \':feature\' に渡されたパラメーターの数が、設定された最大値 \':limitValues\' と一致しません。',
            'condition_not_found' => '送信リストに関連付けられた条件が見つかりませんでした。',
            'option_relation_error' => '選択されたオプション ID \':option\' は機能 \':feature\' の中に存在しません。',
            'unsuitable_condition_for_sending_list_category' => '\':criteriaName\' 基準はメーリング リスト タイプと互換性がありません',

        ],
    ],
    'newsletters_criteria' => [
        'field_translate' => [
            'country' => '国',
            'city' => '都市',
            'county' => '県',
            'state' => '州',
            'check_phone_number' => 'ゲストは電話番号を登録する必要がありますか？',
            'check_newsletter_consent' => 'ユーザーがニュースレターの受信に同意している必要がありますか？',
            'check_newsletter_unsubscribe' => 'ニュースレターの購読を解除したユーザー？',
            'language' => '言語',
            'check_reservation_with_children' => '子供連れの予約が必要ですか？',
            'addon' => '追加サービス',
            'last_reservation_date' => '最終予約日',
            'birthdays_date' => '誕生日',
            'reservation_period_date' => '予約期間',
            'reservation_stay_period_date' => '滞在期間',
            'guests_in_house' => '滞在中のすべてのゲストを選択しますか？',
            'accommodation' => '宿泊施設',
            'channel' => '予約チャネル',
            'reservation_tag' => '予約タグ',
            'category_addon' => '追加サービスカテゴリ',
        ],
        'criteria_translate' => [
            'place' => '居住地',
            'company_place' => 'サイト',
            'phone_number' => '電話番号',
            'newsletter_consent' => 'ニュースレター同意',
            'newsletter_unsubscribed' => 'ニュースレター購読解除済み',
            'language' => '言語',
            'reservation_with_children' => '子供連れの予約',
            'reservation_with_extra_services' => '特定の追加サービス付き予約',
            'last_reservation_year' => '最終予約年',
            'birthdays' => '誕生日',
            'reservation_period' => '予約期間',
            'reservation_stay_period' => '滞在期間',
            'customers_at_home' => '滞在中の顧客',
            'type_of_room_booked' => '予約された部屋の種類',
            'booking_portal' => '予約ポータル',
            'reservation_tag' => 'タグ',
            'addon_category' => '追加サービスカテゴリ',
        ],
        'field_translate_error' => [
            'country' => '国',
            'city' => '都市',
            'county' => '県',
            'state' => '州',
            'check_phone_number' => '電話番号の同意',
            'check_newsletter_consent' => 'ニュースレターの同意',
            'language' => '言語',
            'check_reservation_with_children' => '子供連れの予約',
            'addon' => '追加サービス',
            'last_reservation_date' => '最終予約年',
            'birthdays_date' => '誕生日の日付',
            'reservation_period_date' => '予約期間',
            'check_actual_reservations' => '現在滞在中のゲスト',
            'accommodation' => '予約された部屋の種類',
            'channel' => '予約ポータル',
            'reservation_tag' => 'タグ',
        ],
    ],
    'newsletters' => [
        'unsubscribe_from_newsletter' => 'ニュースレターの購読を解除',
        'warnings' => [
            'cant_active' => '設定は保存されましたが、以下の理由により有効化できません: :errors',
            'uneditable_channels' => '送信チャネルの設定は変更できません',
            'uneditable_options' => '送信チャネルではフィールドの変更が許可されていません。変更するには、設定を削除して新しい設定を作成してください。',
            'existing_configuration' => '同じパラメーターを持つ設定が既に存在します',
            'cant_delete_pending_configuration' => 'この保留中の設定を削除するには、リクエストから24時間後まで待つ必要があります',
            'cant_delete_blocked_configuration' => 'ブロックされた設定を削除することはできません',
            'cant_delete_configuration' => '技術的な問題のため、現在設定を削除できません。後でもう一度お試しください。',
            'cant_delete_configuration_with_newsletters' => '次のニュースレターに関連付けられているため、設定を削除できません: ',
            'cant_delete_sending_list' => '選択された送信リストを削除できません。このリストは次のニュースレターに関連付けられています: :newslettersTitles',
        ],
        'errors' => [
            'configuration_not_active' => '送信者がまだ確認されていません',
            'configuration_not_found' => '選択された設定が存在しません',
            'configuration_not_expired' => '設定が期限切れまたは保留中でない場合、再確認はできません',
            'missing_default_configuration' => 'ニュースレターを作成するには、有効なデフォルト設定が必要です。確認して再試行してください。',
            'missing_default_locale' => 'デフォルトの言語のHTMLテンプレートが送信されたテンプレートの中にありません',
            'missing_newsletter' => '選択されたニュースレターが存在しません',
            'elaborated_newsletter' => '選択されたニュースレターを編集または削除することはできません。すでに処理中または送信されています。',
            'missing_newsletter_contact' => '要求された連絡先が存在しないか、メールアドレスが設定されていません。',
            'sending_list_contact_not_valid' => '連絡先の次のパラメーターが無効です: ',
            'contact_already_exclude' => 'リストに既に除外されているため、連絡先を追加できません',
            'contact_already_exist' => 'リストに既に存在しているため、連絡先を追加できません',
            'newsletter_in_processing' => '選択されたニュースレターのステータスを変更することはできません。すでに処理中です。',
            'cant_update_sent_newsletter' => '選択されたニュースレターはすでに送信されているため、変更できません。複製してアーカイブのみ可能です。',
            'impossible_delete_attempted_newsletter' => '送信がすでに実施されているニュースレターを削除することはできません',
            'newsletter_without_contacts' => '選択された送信リストには連絡先が見つかりませんでした。条件を変更するか、他のリストを選択してください。',
            'newsletter_task_in_error' => '一般的な送信エラーです。キャンペーンを複製して、数分後に再試行してください。',
        ],
        'import' => [
            'validations' => [
                'email_required' => 'メールフィールドが必要です',
                'email_not_valid' => 'メールフィールドに有効なメールアドレスが含まれていません',
            ],
        ],
    ],
    'odigeo' => [
        'exceptions' => [
            'configuration_missing' => 'チャネル :channelName に必要な設定パラメーターがリクエストに含まれていません',
            'configuration_not_valid' => '次のパラメーターが無効です: :params',
            'invalid_age_range' => ':field の年齢範囲が無効です。年齢範囲が正しく、順序通りであることを確認してください。',
        ],
    ],
    'pa_friuli_venezia_giulia' => [
        'accommodation_name' => '宿泊',
        'accommodation_tableau_name' => '部屋',
        'check_in' => 'チェックイン',
        'check_out' => 'チェックアウト',
        'nights' => '泊数',
        'surname_and_name' => '姓と名',
        'date_of_birth' => '生年月日',
        'citizenship' => '国籍',
        'residence' => '居住地',
    ],
    'payment_method' => [
        'fields' => [
            'model_name' => '支払い方法',
        ],
        'paypal' => [
            'cannot_activate_paypal' => 'PayPalを有効化できません。Client IDとSecretが正しいか確認してください。',
        ],
        'nexi' => [
            'cannot_activate_nexi' => 'Nexiを有効化できません。AliasとMACキーが正しいか確認してください。',
        ],
    ],
    'payments' => [
        'default_payment_email_body' => '<p>親愛なる :name :surname 様</p><p>添付されたドキュメントをご確認ください。</p>',
        'default_payment_email_subject' => '支払い通知',
        'cannot_complete_payment_due_to_gateway' => '支払いゲートウェイが操作を完了できませんでした',
        'payment_order_cannot_be_completed_due_to_wrong_status' => '支払いの状態が既に完了済みです',
        'payment_order_is_not_a_pre_authorization' => 'この支払いは事前承認ではありません',
        'cannot_complete_payment_gateway_requires_action' => 'リクエストは正常に送信されました。支払いが完了すると通知が送られます。',
        'payment' => '支払い',
        'refund_payment' => ':payment_dateの:customer_name :customer_surname様の支払い返金',
        'checkinonline_created_order_citytax' => 'オンラインチェックインによる宿泊税の支払い',
        'pre_authorization_text' => '事前承認',
        'email_payment_request' => [
            'subject' => ':propertyName からの支払い要求',
            'message' => '<p>親愛なる <strong>:name :surname</strong> 様、</p><p>予約番号 <strong>#:reference_number</strong> に以下の料金が要求されました。</p>',
            'message_without_reservation' => '<p>親愛なる <strong>:name :surname</strong> 様、以下の料金が要求されました。</p>',
            'confirm_payment' => '今すぐ支払う :amount',
        ],
        'email_pre_authorization_request' => [
            'subject' => ':propertyName からの事前承認要求',
            'message' => '<p>親愛なる <strong>:name :surname</strong> 様、</p><p>予約番号 <strong>#:reference_number</strong> に以下の事前承認が実行されました。</p>',
            'message_without_reservation' => '<p>親愛なる <strong>:name :surname</strong> 様、以下の事前承認が実行されました。</p>',
        ],
        'pre_authorization' => [
            'subject' => ':propertyName からの事前承認',
            'message' => '<p>親愛なる <strong>:name :surname</strong> 様、</p><p>予約番号 <strong>#:reference_number</strong> に以下の事前承認が要求されました。</p>',
        ],
        'direct_charge' => [
            'subject' => ':propertyName からの直接請求',
            'message' => '<p>親愛なる <strong>:name :surname</strong> 様、</p><p>予約番号 <strong>#:reference_number</strong> に以下の料金が請求されました。</p>',
        ],
        'direct_charge_failed' => [
            'subject' => ':propertyName からの直接請求失敗',
            'message' => '<p>親愛なる <strong>:name :surname</strong> 様、</p><p>本日、予約番号 <strong>#:reference_number</strong> に関連する請求を試みましたが、以下の請求を実行できませんでした。</p>',
        ],
        'payment_order' => [
            'default_whatsapp_text' => '親愛なる :name :surname 様、予約番号 :reference_number に関して、:type が要求されました。こちらをクリックしてください: :link',
        ],
        'customer_confirmed_payment_order_notification' => [
            'subject' => ':propertyName からの :amount の支払い受領',
            'message' => ':customerName :customerSurname 様が予約 #:referenceNumber (:arrivalDate - :departureDate) - :propertyName のために :amount の支払いを行いました。',
            'click_here_to_view' => '予約の詳細を見るにはこちらをクリックしてください。',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'subject' => '顧客が支払いを完了しました',
            'message' => ':customerName :customerSurname 様が :amount - :propertyName の支払いを完了しました。',
        ],
        'pre_authorization_is_expiring' => [
            'subject' => '事前承認が期限切れになります',
            'message' => ':customerName :customerSurname 様が、明日が期限の事前承認 :amount を予約 #:referenceNumber (:arrivalDate - :departureDate) - :propertyName のためにまだ承認していません。',
            'message_without_reservation' => ':customerName :customerSurname 様が、明日が期限の事前承認 :amount - :propertyName をまだ承認していません。',
        ],
        'timetable' => [
            'title' => '予定された支払い',
            'export_fields' => [
                'scheduled_date' => '支払い日',
                'booker' => '予約者',
                'reservation_total_price' => '予約合計金額',
                'amount' => '予定された支払い',
                'reservation_arrival_date' => '到着日',
                'reservation_departure_date' => '出発日',
                'property' => '施設',
                'sca_accepted' => 'SCA状態',
            ],
            'sca_accepted' => '承認済み',
            'sca_not_accepted' => '未承認',
            'change_status_date_past' => '過去の日付に支払いを予定することはできません。',
            'no_credit_card_found' => '予約にはクレジットカードが設定されていません。',
            'required_action_3d' => '支払いに失敗しました。3Dセキュア認証が要求されました。',
            'required_action_requested_payment' => '支払いリクエストが :send_date に送信され、:expire_date に期限切れとなります。',
            'request_payment_wait_customer_expired' => '支払いリクエストの期限が切れました。',
            'timetable_pause_expired' => '期限切れとなった一時停止中の予定された支払い。',
            'force_payment_due_date' => '支払いは、支払い予定日が本日である場合にのみ強制できます。',
            'reservation_cancelled' => '予約がキャンセルされました。',
            'property_cancelled' => '施設が中止、期限切れ、またはキャンセルされました。',
            'module_deactivated' => '予定された支払いモジュールが無効化または期限切れです。',
            'charge_status_manual_change' => '支払い状態が :current_charge_status から :new_charge_status に変更されました。',
            'manual_payment_bound' => '手動支払いが追加されました。',
            'stripe_not_active' => 'Stripe支払い方法がアクティブではありません。',
            'invoice_default_causal' => ':reservation_reference の予約に関連する :date の :payment_method_name 支払いの請求。',
            'delete_propery_has_payments' => '施設にアクティブな予定支払いがあります。この操作はすべての予定支払いを一時停止します。この操作は取り消せません。',
            'amount_over_to_pay' => '支払いは予約の未払い額を超えています。',
            'change_tax_payment_amount' => '宿泊税の支払いが :old_amount から :new_amount に変更されました。',
            'manual_payment_cancelled' => '以前に関連付けられていた手動支払いがキャンセルされました。',
            'payment_refunded_created' => ':currency_symbol :amount の返金が行われました。',
            'payment_refunded_modified' => ':currency_symbol :old_amount から :currency_symbol :new_amount に返金が変更されました。',
            'reservation_reconfirmed' => '予約が再確認されました。',
            'reservation_optionable' => 'オプション可能な予約。',
            'reservation_pending' => '予約の確認待ち。',
            'payment_succeded' => '支払いが成功しました。',
            'charge_reminder_email_sent' => '支払いリマインダーのメールが送信されました。',
            'charge_reminder' => [
                'subject' => ':propertyName - 支払いリマインダー',
                'message' => '親愛なる :booker_name :booker_surname 様、<br /><br />:date_today に、:amount :currency_symbol の支払いが予定されています。<br /><br /><strong><span style="color: #8f743f;">予約番号 #:reference_number :arrival_date から :departure_date まで。</span></strong>',
            ],
        ],
        'errors' => [
            'conditions_with_conflicts' => '入力された条件には重複があるか、合計請求額の割合が100％を超えています。',
            'payment_timetable_already_processed' => '予定された支払いはすでに処理されたか、保留中です。',
            'payment_timetable_already_bound' => '予定された支払いはすでに生成されています。',
            'payment_timetable_attach_email_invoice_error' => '顧客から要求された請求書を添付できませんでした。次のエラーが発生しました: :error_description',
            'missing_policy' => '予約に対する支払いポリシーが見つかりません。',
            'impossible_change_payment_method_id' => '登録済みの支払い方法を変更できません',

        ],
        'warnings' => [
            'no_restrictions_and_period_policy' => '支払いポリシーには制限や適用期間がなく、他のポリシーと競合する可能性があります。',
            'no_restrictions_and_period_others' => 'ポリシー :name には制限または適用期間がなく、現在管理しているポリシーと競合する可能性があります。',
            'overlapping_period_for_restriction' => 'ポリシー :name は、現在管理しているポリシーと少なくとも1つの期間で重複があり、競合が発生する可能性があります。',
            'existing_restriction' => 'ポリシー :name は、現在管理しているポリシーと少なくとも1つの制限を共有しており、競合する可能性があります。',
        ],
        'fields' => [
            'payment_agreement_id' => '支払い契約の識別子'
        ],
    ],
    'policy' => [
        'errors' => [
            'no_show_option_not_compatible' => 'No-showオプションが互換性がありません',
            'deposit_option_not_compatible' => 'デポジットオプションが互換性がありません',
            'choose_deposit_pay' => '請求するタイミングを選択してください',
            'condition_not_compatible' => 'キャンセル条件が互換性がありません',
            'duplicate_penalty' => 'キャンセル条件に重複したペナルティがあります',
            'no_show_condition_not_applicable' => 'この条件をno-showに適用できません',
            'deposit_condition_not_applicable' => 'この条件をデポジットに適用できません',
            'duplicate_penalty_deposit' => 'デポジットセクションに重複したペナルティがあります',
            'no_condition_to_deposit' => 'デポジットに適用される条件がありません',
            'policy_to_rateplan' => 'ポリシーが少なくとも1つの料金プランに接続されています',
            'delete_policy_default' => 'デフォルトのポリシーを削除することはできません',
            'last_policy' => '施設の最後のポリシーを削除することはできません',
            'policy_not_allowed_in_period' => '料金プランと同じポリシーで期間を上書きすることはできません',
            'policy_period_overlapping' => 'ポリシーの期間が重複しています',
            'check_priority_custom' => 'ポリシーの優先順位が存在します。正確性を確認してください',
            'check_priority_and_period' => 'ポリシーに優先順位または期間が存在します',
        ],
        'names' => [
            'standard' => '無料キャンセル',
            'not_ref' => '返金不可',
            'default_ota_name' => 'OTAに表示',
            'default_ota_description' => 'チャンネルから送信されていないポリシー',
            'hour_title_policy' => ' 到着日の:hourまで',
            'nights' => '泊|泊',
            'days' => '日|日',
        ],
        'transform_to_date' => [
            'date_limit' => '<p>:date_limit まで無料でキャンセルできます。</p>',
            'date_limit_percentage' => '<p>:date_limit までにキャンセルした場合、合計費用の :penalty_value% が請求されます。</p>',
            'date_limit_nights' => '<p>:date_limit までにキャンセルした場合、:penalty_value 泊分の料金が請求されます。</p>',
            'date_limit_amount' => '<p>:date_limit までにキャンセルした場合、:penalty_value :currency が請求されます。</p>',
            'date_over_percentage' => '<p>:date_limit 以降にキャンセルした場合、合計費用の :penalty_value% が請求されます。</p>',
            'date_over_nights' => '<p>:date_limit 以降にキャンセルした場合、:penalty_value 泊分の料金が請求されます。</p>',
            'date_over_amount' => '<p>:date_limit 以降にキャンセルした場合、:penalty_value :currency が請求されます。</p>',
            'date_over_percentage_hour' => '<p>:date_limit の:hour_limit以降にキャンセルした場合、合計費用の :penalty_value% が請求されます。</p>',
            'date_over_nights_hour' => '<p>:date_limit の:hour_limit以降にキャンセルした場合、:penalty_value 泊分の料金が請求されます。</p>',
            'date_over_amount_hour' => '<p>:date_limit の:hour_limit以降にキャンセルした場合、:penalty_value :currency が請求されます。</p>',
            'date_now_percentage' => '<p>現在キャンセルした場合、合計費用の :penalty_value% が請求されます。</p>',
            'date_now_nights' => '<p>現在キャンセルした場合、:penalty_value 泊分の料金が請求されます。</p>',
            'date_now_amount' => '<p>現在キャンセルした場合、:penalty_value :currency が請求されます。</p>',
            'date_now_noshow_percentage' => '<p>No-showの場合、合計費用の :penalty_value% が請求されます。</p>',
            'date_now_noshow_nights' => '<p>No-showの場合、:penalty_value 泊分の料金が請求されます。</p>',
            'date_now_noshow_amount' => '<p>No-showの場合、:penalty_value :currency が請求されます。</p>',
        ],
        'transform_to_date_notref' => [
            'date_now_percentage' => '<p>予約後、いつでもキャンセルした場合、合計費用の :penalty_value% が請求されます。</p>',
            'date_now_nights' => '<p>予約後、いつでもキャンセルした場合、:penalty_value 泊分の料金が請求されます。</p>',
            'date_now_amount' => '<p>予約後、いつでもキャンセルした場合、:penalty_value :currency が請求されます。</p>',
            'date_limit_percentage' => '<p>:date_limit の:hour_limit までにキャンセルした場合、合計費用の :penalty_value% が請求されます。</p>',
            'date_limit_nights' => '<p>:date_limit の:hour_limit までにキャンセルした場合、:penalty_value 泊分の料金が請求されます。</p>',
            'date_limit_amount' => '<p>:date_limit の:hour_limit までにキャンセルした場合、:penalty_value :currency が請求されます。</p>',
            'date_now_deposit_percentage' => '<p>予約時に合計費用の :penalty_value% が請求されます。</p>',
            'date_now_deposit_nights' => '<p>予約時に :penalty_value 泊分の料金が請求されます。</p>',
            'date_now_deposit_amount' => '<p>予約時に :penalty_value :currency が請求されます。</p>',
            'date_now_noshow_percentage' => '<p>No-showの場合、合計費用の :penalty_value% が請求されます。</p>',
            'date_now_noshow_nights' => '<p>No-showの場合、:penalty_value 泊分の料金が請求されます。</p>',
            'date_now_noshow_amount' => '<p>No-showの場合、:penalty_value :currency が請求されます。</p>',
        ],
    ],
    'property_report' => [
        'property' => [
            'label' => '施設',
            'description' => '施設データをエクスポートするオプションです',
        ],
        'children_ranges' => [
            'label' => '子供の年齢範囲',
            'description' => '子供の年齢範囲をエクスポートするオプションです',
        ],
        'accommodations' => [
            'label' => '宿泊施設',
            'description' => '宿泊施設とその詳細をエクスポートするオプションです',
        ],
        'treatments' => [
            'label' => '食事プラン',
            'description' => '食事プランをエクスポートするオプションです',
        ],
        'policies' => [
            'label' => 'キャンセルポリシー',
            'description' => 'キャンセル条件をエクスポートするオプションです',
            'addons_to_deposit' => [
                'included' => '追加サービスを含む',
                'not_included' => '計算に含まれていない追加サービス',
            ],
        ],
        'rate_plans' => [
            'label' => '料金プラン',
            'description' => '料金プランをエクスポートするオプションです',
        ],
        'invoice_layouts' => [
            'label' => '請求書レイアウト',
            'description' => '請求書レイアウトをエクスポートするオプションです',
        ],
        'city_tax' => [
            'label' => '宿泊税',
            'description' => '宿泊税の設定をエクスポートするオプションです',
            'active' => '有効',
            'not_active' => '無効',
        ],
        'payments_method' => [
            'label' => '支払い方法',
            'description' => '支払い方法の設定をエクスポートするオプションです',
            'day' => '{0,1} 日|[2,*] 日',
        ],
    ],
    'property' => [
        'errors' => [
            'already_attached' => 'すでにアタッチされています',
            'property_has_another_master' => 'この施設にはすでにマスターユーザーがいます。この操作を続行するには、現在のユーザーを施設から削除してください',
            'letti_extra_exception_delete' => 'このエクストラベッドを削除することはできません。最初に番号 :lettimax を削除し、現在の番号 :lettimin を変更する必要があります',
            'letti_extra_exception_missing' => 'いくつかの要素が欠落しています',
            'override_periods_policy' => '期間が重複しています',
            'place_not_found' => '場所が見つかりません',
            'not_group_owner' => 'このグループの所有者ではありません',
            'group_is_default' => 'デフォルトグループは削除できません',
            'already_in' => '施設はすでにグループに存在します。続行できません',
            'already_all_in' => '施設はあなたのいずれかのグループにすでに存在します。続行できません',
            'not_in_group' => '施設はグループに存在しません',
            'existing_extra_bed_setting' => '既存のエクストラベッド設定があります',
            'missing_extra_bed_setting' => 'エクストラベッド設定が不足しています',
            'overcoming_extra_bed' => 'エクストラベッドが現在の部屋設定を超えています',
            'role_conflict' => 'この役割はすでに存在します',
            'cant_detach_default_group' => 'デフォルトグループから施設を削除することはできません',
            'groups_have_properties' => '施設が存在するため、このグループを削除することはできません',
            'uneditable_expense_category' => '費用カテゴリは編集できません',
            'expenses_pending' => '関連する費用があるため、この費用カテゴリは削除できません',
            'missing_vat_quotes' => '注意！選択した国にはVAT税率が設定されていません。続行する前に設定してください',
            'cutoff_rules_exist' => 'カットオフルールがすでに存在します',
            'missing_lat_lon' => 'この施設に関連する緯度(LAT)または経度(LON)が設定されていません',
            'undetachable_layout' => '別のプロファイルが少なくとも1つ関連付けられていない限り、このプロファイルを削除することはできません',
            'customer_not_belonging_to_property_group' => '顧客 :customer_id は施設グループに属していないか、存在しません',
            'update_expiration_bulk' => '期限更新エラー',
            'update_cancellation_bulk' => 'キャンセルステータス更新エラー',
            'update_activation_bulk' => '有効/無効状態の更新エラー',
            'unauthorized_access' => 'このリソースにアクセスする権限がありません。',
            'unauthorized_insolvent_status' => 'お支払いの滞納により、アカウントがブロックされました。そのため、会計状況を調整するために「zucchettihospitality.gestione.crediti@zucchetti.it」までご連絡ください。'
        ],
        'warnings' => [
            'request_confirm_change_discount_type' => '割引タイプの変更はすべてのカスタム設定を削除します。続行しますか？',
            'request_confirm_delete_extra_bed' => 'このエクストラベッドを削除すると、より上位のエクストラベッドも削除されます。続行しますか？',
            'invalid_facility' => '施設が互換性がありません',
            'disabled_update' => ':channel_name チャネルではデータの送信が有効になっていません',
            'nothing_to_update' => ':channel への送信データがありません',
            'missing_invoice_layout_without_vat_code_with_all_inclusive_tax_enabled' => '注意！有効な施設には全包括税を発行する適切な請求書レイアウトがありません',
            'properties_has_not_istat_module' => '施設 :property_name にISTATモジュールが有効ではありません',
            'update_overcome_days' => '以下の日付は、最大日数を超えているため更新されませんでした: :dates',
            'download_overcome_days' => '以下の日付については最大日数を超えているためデータがダウンロードされませんでした: :dates',
            'missing_property_xml_id' => '注意！チャネル :channel_name の設定にproperty_xml_idが入力されていません',
        ],
        'city_tax' => [
            'main_report_title' => '宿泊税の概要',
            'recap_city_tax_totals' => '宿泊税合計の概要',
            'exemptions' => '免除',
            'limit_nights' => '宿泊の制限',
            'total_guests' => '総宿泊者数',
            'totals' => '合計',
            'total_taxed_guests' => '課税対象の宿泊者数',
            'total_exempted_guests' => '免除された宿泊者数',
            'exemption_details' => '免除の詳細',
            'taxed_details' => '課税対象の詳細',
            'taxed_details_ranges' => ':min ～ :max 歳',
            'exemptions_over' => '制限を超える免除',
            'guests_over' => '制限を超える宿泊者',
            'guests' => '宿泊者',
            'city_tax_amount' => '宿泊税合計',
            'all_properties' => 'すべての施設',
            'from_to_age_ranges' => ':min_age ～ :max_age 歳',
            'taxed_nights' => '課税対象宿泊者の宿泊日数',
        ],
        'commissions' => [
            'period_exists' => '期間がすでに存在します',
            'invalid_period' => '無効な期間です',
            'season_too_long' => 'シーズン期間が長すぎます',
        ],
        'list' => '施設リスト',
        'export_fields' => [
            'id' => 'ID',
            'name' => '名前',
            'group' => 'グループ',
            'address' => '住所',
            'city' => '都市',
            'state' => '州',
            'county' => '郡',
            'country' => '国',
            'zip_code' => '郵便番号',
            'type' => 'タイプ',
            'email' => 'メール',
            'telephone' => '電話番号',
            'reference_name' => '担当者の名前',
            'reference_surname' => '担当者の姓',
            'reference' => '担当者',
            'modules' => 'モジュール',
            'activated_date' => 'アクティベーション日',
            'expire_date' => '有効期限日',
            'status' => 'ステータス',
            'user_first_name' => 'オーナーの名前',
            'user_last_name' => 'オーナーの姓',
            'user' => 'オーナー',
            'user_email' => 'オーナーのメール',
            'resellers' => '販売業者',
            'business_name' => '事業名',
            'vat_number' => 'VAT番号',
            'fiscal_code' => '税コード',
            'properties_modules' => '施設モジュール',
            'accommodations' => '宿泊施設',
            'quantity' => '数量',
            'contacts' => '連絡先',
        ],
        'initials_name' => [
            'booking-engine' => 'BE',
            'channel-manager' => 'CM',
            'rate-checker' => 'RC',
            'brand-protection' => 'BP',
            'google-ads' => 'GA',
            'google-commission' => 'GC',
            'tripadvisor-istant-booking' => 'TIB',
            'trivago-fast-connect' => 'TFC',
            'booking-engine-quotes' => 'BEQ',
            'guests-reporting' => 'GR',
            'pms' => 'PMS',
            'newsletter' => 'CRM',
            'automatic-payments' => 'AP',
        ],
        'clone' => [
            'cloning-job-scheduled' => 'クローン作成が間もなく実行されます。数分後に確認してください。',
        ],
        'not_found' => '以下のIDは存在しません: ',
        'log'  => [
            'property_module_enabled' => '物件モジュール が有効化されました',
            'property_module_disabled' => '物件モジュール が無効化されました',
            'beddy_channel_disabled' => 'Beddy チャンネルが無効化されました',
            'beddy_channel_enabled' => 'Beddy チャンネルが有効化されました',
            'property_disactivated' => '物件が無効化されました',
            'property_activated' => '物件が有効化されました',
            'property_cancelled' => '物件のキャンセルが登録されました',
            'property_cancellation_reversed' => '物件のキャンセルが取り消されました',
            'property_update_expiration_date' => '物件の契約期限が更新されました',
        ],
        'treatment' => [
            'log' => [
                'attach' => '治療 :treatment_name が施設 :property_names に関連付けられ、追加料金 :supplement_price および価格変更 :share_price が設定されました。:children_detail :apply_past',
                'children_detail' => ' 年齢範囲 :age_range に対して、追加料金 :supplement_price と価格変更 :share_price が設定されました。',
                'apply_past' => ' 設定は :from から :to の間に行われた予約に反映されました。',
                'detach' => '治療 :treatment_name は施設 :property_name から解除されました。',
                'update' => '治療 :treatment_name は、追加料金 :supplement_price および価格変更 :share_price に更新されました。:children_detail :children_delete :detail_delete',
                'detail_delete' => '以前の価格変更がリセットされたため、以前に関連付けられていたすべての詳細が削除されました。',
            ],
        ],


    ],
    'push_notifications' => [
        'multiple_sessions' => [
            'title' => 'セキュリティ警告: 複数のデバイスがアカウントに接続されています',
            'message' => 'アカウントに複数のデバイスから接続が検出されました。現在のアクティブセッションを確認してください。',
        ],
        'reservation_new' => [
            'title' => ':channel_name (:name_surname) からの新しい予約。',
            'message' => ':name_surname が :property_name の宿泊施設 :accommodation_name を :arrival_date から :departure_date まで予約しました。',
        ],
        'reservation_modified' => [
            'title' => ':channel_name からの :name :surname の予約変更。',
            'message' => ':property_name の宿泊施設 :accommodation_name の予約が :name :surname によって :arrival_date から :departure_date まで変更されました。',
        ],
        'reservation_cancelled' => [
            'title' => ':channel_name からの :name :surname の予約キャンセル。',
            'message' => ':property_name の :name :surname の予約が :arrival_date から :departure_date までキャンセルされました。',
        ],
        'reservation_banktransfer_cancelled' => [
            'title' => ':channel_name による :name :surname の未払いのため予約キャンセル',
            'message' => ':property_name の :name :surname の予約が :arrival_date から :departure_date まで自動的にキャンセルされました。',
        ],
        'invoice_rejected' => [
            'title' => ':name :surname の請求書 :number_complete がSDIによって拒否されました。',
            'message' => ':name :surname の請求書 :number_complete が次の理由で拒否されました: :rejected_reason。',
        ],
        'invoice_received' => [
            'title' => ':sender_name から請求書を受け取りました。',
            'message' => ':sender_name から :document_date に請求書番号 :document_number を受け取りました。',
        ],
        'checkin_online_complete' => [
            'title' => 'オンラインチェックイン完了 (:name :surname)。',
            'message' => ':property_name の宿泊施設 :accommodation_name の予約 (:arrival_date から :departure_date まで) に対して :name :surname がオンラインチェックインを完了しました。',
        ],
        'reservation_quote_expired' => [
            'title' => ':name :surname の見積もりが期限切れ。',
            'message' => ':created_date に作成された :name :surname の見積もりが期限切れになりました。',
        ],
        'housekeeper_maintainer' => [
            'title' => '宿泊施設 :accommodation_name に対する新しいメンテナンス報告',
            'message' => ':tableau_label 宿泊施設の新しいメンテナンス報告が登録されました。:title - :description',
        ],
        'housekeeper_tableau_number_clean_status_change_email' => [
            'title' => ':cleanable_name - :accommodation_name の清掃状態の変更',
            'message' => ':user_name が :cleanable_name (:accommodation_name) 宿泊施設の清掃状態を :reference_date の日に :clean_status に設定しました。',
        ],
        'reservation_option_expired' => [
            'title' => 'オプション予約の期限切れ (:name :surname)',
            'message' => ':property_name の宿泊施設 :accommodation_name の予約オプション (:arrival_date から :departure_date まで) が期限切れになりました。',
        ],
        'order_payment_release' => [
            'subject' => '事前承認が解除されました (:name :surname)。',
            'body' => ':property_name の :name :surname の予約 (:arrival_date から :departure_date まで) の支払い事前承認が解除されました。',
        ],
        'sca_authorized' => [
            'title' => ':name :surname によってSCAフォームが確認されました。',
            'message' => ':name :surname は、:accepted_date に IP アドレス :ip_address への SCA フォームを確認しました。',
        ],
        'customer_confirmed_payment_order_notification' => [
            'title' => ':name :surname からの新しい支払いを受け取りました。',
            'message' => ':name :surname が :property_name の予約 (:arrival_date から :departure_date まで) に対して :amount の支払いを行いました。',
        ],
        'customer_confirmed_payment_order_notification_without_reservation' => [
            'title' => ':name :surname からの新しい支払いを受け取りました。',
            'message' => ':name :surname が :amount の支払いを行いました。',
        ],
        'reservation_accommodation_zero_avails' => [
            'subject' => ':property_name の宿泊施設 :accommodation_name の空室がなくなりました。',
            'body' => ':accommodation_name の空室が以下の日付でなくなりました: :days',
        ],
        'reservation_queue_complete' => [
            'subject' => '予約 :name :surname が処理されました。',
            'body' => ':name :surname の予約が正常に処理されました。',
        ],
        'guests_reporting' => [
            'subject' => 'Alloggiatiレポートの送信 - :alloggiatiweb_group_label',
            'success' => '1つのレポートが正常に送信されました|:number のレポートが正常に送信されました',
            'error' => '1つのレポートが送信されませんでした|:number のレポートが送信されませんでした :errorMessage',
        ],
        'quote_request' => [
            'subject' => '新しい見積リクエスト',
            'message' => ':customer_name :customer_surname があなたの施設の見積リクエストを送信しました。',
        ],
        'treatment_price_update' => [
            'subject' => '統計処理が更新されました - :property_name',
            'message' => ':treatment_name の処理について、:start_date から :end_date までの最新値で再計算が完了しました。',
        ],
        'queue_past_reservations_task_record_summary' => [
            'subject' => '過去の予約処理タスクの概要 - :property_name (:property_id) チャンネル :channel_name (:channel_id)',
            'message' => '合計 :reservations_total 件の予約のうち、過去の予約 :reservations_elaborated 件が処理されました。:reservations_require_action 件の予約が対応を必要としています。',
        ],
        'queue_past_reservations_task_error' => [
            'subject' => '過去の予約処理タスクのエラー - :property_name (:property_id) チャンネル :channel_name (:channel_id)',
            'message' => '過去の予約キュー処理中にエラーが発生しました。エラーメッセージ: :error_description',
        ],
        'reservation_message_received' => [
            'title' => ':senderName (#:reference) からの新しいメッセージ',
        ],
        'conversation_message_send_failed' => [
            'title' => 'メッセージ送信失敗',
            'message' => ':recipientName に送信されたメッセージは配信されませんでした。',
        ],
        'urmet_sclak_error_generate_key' => [
            'title' => '予約キー作成エラー :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Sclakで部屋のキー作成中にエラーが発生しました: :errors 。手動で再試行してください。問題が解決しない場合はUrmetサポートに連絡してください。',
        ],
        'nuki_error_generate_key' => [
            'title' => '予約PIN作成エラー :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'Nukiで部屋のPIN作成中にエラーが発生しました: :errors 。手動で再試行してください。問題が解決しない場合はNukiサポートに連絡してください。',
        ],
        'urmet_sclak_error_sending_sms' => [
            'title' => '予約キーSMS送信エラー :booker_name :booker_surname (#ID: :reference_number)',
            'message' => 'SclakのSMSを送信できませんでした。エラーが発生しました。<br> Urmetサポートに連絡することをお勧めします。',
        ],
        'single_property_export_completed' => [
            'title' => ':exportProviderName エクスポート完了',
            'message' => 'ファイル :fileName はダウンロードの準備ができています。',
        ],
        'single_property_export_not_completed' => [
            'title' => ':exportProviderName エクスポート失敗',
            'message' => ':date の :time に行われたエクスポートが失敗しました。',
        ],
        'multi_property_export_completed' => [
            'title' => ':exportProviderName エクスポート完了',
            'message' => 'ファイル :fileName はダウンロードの準備ができています。',
        ],
        'multi_property_export_not_completed' => [
            'title' => ':exportProviderName エクスポート失敗',
            'message' => ':date の :time に行われたエクスポートが失敗しました。',
        ],
        'newsletter_sent' => [
            'title' => 'ニュースレター送信確認',
            'message' => 'ニュースレター :newsletterName は正常に送信されました。',
        ],
        'newsletter_not_sent' => [
            'title' => 'ニュースレター送信エラー',
            'message' => 'キャンペーン “:newsletterName” を送信できませんでした。以下のエラーが発生しました: :errorMessage',
        ],
        'newsletter_exceeded_sent_limit' => [
            'title' => '月間送信上限を超過',
            'message' => 'ニュースレター :newsletterName は送信されませんでした。月間送信上限を超過したためです。',
        ],
        'remote_door_key_service_reservation_resumed' => [
            'title' => '予約変更、新しいキーを生成してください',
            'message' => '施設 <b>:property_name</b> の予約 <b>:booker_name :booker_surname - :reference_number</b> のために新しいキーを生成する必要があります。',
        ],
        'remote_door_key_service_reservation_moved' => [
            'title' => '1つ以上の宿泊施設が移動されました。新しいキーを生成する必要があります。',
            'message' => '施設 <b>:property_name</b> の予約 <b>:booker_name :booker_surname - :reference_number</b> の1つ以上の宿泊施設が移動されました。新しいキーを生成する必要があります。',
        ],
        'send_city_tax_report' => [
            'title' => '宿泊税レポート送信確認',
            'message' => ':channelName チャンネルの宿泊税レポートの送信が正常に完了しました。',
        ],
        'send_city_tax_report_not_completed' => [
            'title' => '宿泊税レポート送信エラー',
            'message' => ':channelName チャンネルの宿泊税レポートの送信に失敗しました。',
        ],
        'export_city_tax_report' => [
            'title' => ':channelName チャンネルの宿泊税レポートエクスポートが準備できました。',
            'message' => '通知をクリックすると、エクスポート履歴ページにリダイレクトされます。',
        ],
        'export_city_tax_report_not_completed' => [
            'title' => ':channelName チャンネルの宿泊税レポートエクスポートを完了できませんでした。',
            'message' => 'レポート :reportId の生成が失敗しました。',
        ],
        'guest_atrtributes_missing_in_city_tax_report' => [
            'title' => '宿泊税レポート送信/エクスポートエラー',
        ],
        'empty_city_tax_report' => [
            'title' => ':channelName チャンネルの宿泊税レポート送信/エクスポートエラー',
            'message' => '選択された期間内に送信可能なゲストが存在しなかったため、宿泊税レポートは処理されませんでした。',
        ],
        'accommodation_deleted' => [
            'title' => 'アクションが必要です',
            'message' => '施設 :propertyName の宿泊施設 :accommodationName の利用可能ユニット数が減少しました。オーバーブッキングを防ぐために在庫をリセットしてください。',
        ],
        'payment_timetable_stripe_not_active' => [
            'title' => '自動支払いの課金失敗 - Stripeがアクティブではありません',
            'message' => '自動支払いに関連する課金を行うことができませんでした。アクティブなStripeアカウントが存在しません。',
        ],
        'payment_timetable_charge_failed' => [
            'title' => '自動支払いの課金失敗',
            'message' => '自動支払いに関連する課金を行うことができませんでした。理由: :error_description',
        ],
        'payment_timetable_no_credit_card' => [
            'title' => '自動支払いの課金失敗 - クレジットカードがありません',
            'message' => '自動支払いに関連する課金を行うことができませんでした。利用可能なクレジットカードがありません。',
        ],
        'payment_timetable_exceeded' => [
            'title' => '自動支払いの課金失敗 - 予約合計を超える支払い',
            'message' => '自動支払いに関連する課金を行うことができませんでした。未払い部分を超えています。',
        ],
        'payment_timetable_require_action' => [
            'subject' => '自動支払いの引き落としに失敗しました - 3Dセキュアが必要です',
            'message' => '自動引き落としは3Dセキュア要求のため失敗しました (ID: :payment_timetable_id, :scheduled_date - 予約 :reservation_reference_number 名義 :booker_name :booker_surname).',
        ],
        'payment_timetable_require_action_send_request' => [
            'subject' => '自動支払いの引き落としに失敗しました - 顧客へリクエストを送信しました',
            'message' => "自動引き落としは3Dセキュア要求のため失敗しました (ID: :payment_timetable_id, :scheduled_date - 予約 :reservation_reference_number 名義 :booker_name :booker_surname).\n顧客へ支払いリクエストをメールで送信しました。",
        ],
    ],
    'quote_request' => [
        'email' => [
            'subject' => ':property_name に関する見積もり依頼 - :customer_name :customer_surname (:arrival_date - :departure_date)',
            'quote_request_confermation' => '拝啓 <b>:property_name</b>,<br></br>
            <b>:customer_name :customer_surname</b> があなたの施設に見積もり依頼を行いました。',
            'summary_request' => 'リクエストの概要:',
            'stay' => '滞在',
            'name_surname' => '氏名',
            'telephone' => '電話番号',
            'email' => 'メールアドレス',
            'from' => '到着日',
            'to' => '出発日',
            'alternative_dates' => '代替日程に対応可能',
            'alternative_beds' => '異なるベッド数に対応可能',
            'yes' => 'はい',
            'no' => 'いいえ',
            'accommodation' => '宿泊施設',
            'accommodations' => '宿泊施設',
            'night' => '泊',
            'nights' => '泊数',
            'adults' => '大人',
            'children' => '子供',
            'eta_children' => '子供の年齢',
            'button' => 'リクエストを確認するにはここをクリック',
        ],
        'email_customer' => [
            'subject' => 'ご依頼ありがとうございます, :customer_name 様!',
            'message' => 'ありがとうございます <b>:customer_name</b>,<br></br>見積もりリクエストが正常に送信されました。できるだけ早くご連絡いたします。',
        ],
    ],
    'rateplans' => [
        'errors' => [
            'max_day_update' => '接続されたチャネルがあるため、この料金プランを削除することはできません。',
            'insert_periods_plan' => '料金プランに期間を挿入することはできません。',
            'uneditable_rateplan' => '変更不可能な元の料金プランです。',
            'source_not_found' => '宿泊施設には元の料金プランが存在しません。',
            'detach_accommodations_channels' => '接続されたチャネルがあるため、この料金プランを削除することはできません。',
            'multi_property_not_permitted' => '複数の施設に対して一度に料金プランを作成または編集することはできません。',
            'rules_present_cannot_update' => 'この料金プランには有効なルールが関連付けられているため、要求された変更を適用できません。',
        ],
        'warnings' => [
            'missing_set_rules' => '一部の元のチャネルに対して、料金プラン上でルールを設定できませんでした。',
        ],
        'conflicts' => [
            'unsuitable_conditions' => ':condition_from の条件の値は、:condition_to に入力された条件と互換性がありません。',
            'conditions_not_formatted' => '条件が正しくフォーマットされていません。IDが欠落しています。',
        ],
        'export_fields' => [
            'name' => '名前',
            'policy' => '払い戻しポリシー',
            'periods' => '有効期間と日数',
            'accommodations' => '宿泊施設',
        ],
    ],
    'rates' => [
        'errors' => [
            'max_day_update' => '総期間が1年を超える更新はできません。',
            'no_rooms_to_clone' => 'クローン化可能な部屋がありません。',
            'no_rooms_to_clone_source' => '1つ以上の部屋/料金プランが元のチャネルに存在しません。',
            'no_rooms_to_clone_destination' => '1つ以上の部屋/料金プランが宛先チャネルに存在しません。',
            'same_channel_to_clone' => '同じチャネルに対してクローンを作成することはできません。',
            'no_date_valid' => '更新する日付がありません。',
            'max_availability_exceeded' => '入力された利用可能数が宿泊施設の設定で許可されている値を超えています。値は許可された最大値に調整されました。',
            'anti_overbooking_bloccante' => '注意: 入力しようとしている利用可能数が販売可能な部屋数を超えています。オーバーブッキングのリスクがあります。',
            'channel_update_error' => 'ポータルへの更新に失敗しました。詳細は<b>更新ログ</b>セクションを確認してください。',
            'period_over_limit' => '期間 :dateFrom から :dateTo までが許容最大限を超えています。',
        ],
        'warnings' => [
            'past_period' => '選択された期間は過去のものです。',
            'past_today_adjustment' => '開始日が今日の日付に調整されました。',
            'period_adjustment_limit' => '終了日が許容最大限に調整されました。（:dateTo）',
            'channel_not_connected' => '施設は :channel_name チャネルに接続されていません。',
            'anti_overbooking' => '注意: 入力しようとしている利用可能数が販売可能な部屋数を超えています。オーバーブッキングのリスクがあります。',
            'missing_association' => '部屋が :channel_name チャネルに関連付けられていません。',
            'identical_update' => '同一の更新がまだ進行中です。後でもう一度お試しください。',
            'rate_copy_not_found' => '過去の期間にコピーするデータがありません。更新は無視されました。',
        ],
    ],
    'receipt_modules' => [
        'errors' => [
            'already_migrated' => 'このレシートプリンターは既に新しい部門管理に移行されています。',
        ],
        'log' => [
            'receipt_module_updated' => 'レシートプリンターが更新されました。',
            'receipt_module_created' => 'レシートプリンターが作成されました。',
            'receipt_module_deleted' => 'レシートプリンターが削除されました。',
            'receipt_module_department_deleted' => 'レシートプリンタ部門が削除されました。',
            'receipt_module_department_created' => 'レシートプリンタ部門が作成されました。',
            'receipt_module_department_updated' => 'レシートプリンタ部門が更新されました。',
        ],
        'validation' => [
            'ateco_slot_code' => [
                'wrong_format' => 'ATECOコードの形式が無効です。',
                'wrong_slot' => 'スロット値がサポートされていません。(0 - 3)。',
            ],
        ],
    ],
    'receipt_channels' => [
        'log' => [
            'receipt_channel_created' => '電子レシートが作成されました',
            'receipt_channel_deleted' => '電子レシートが削除されました',
        ]
    ],
    'reservation_accommodation_room_day' => [
        'fields' => [
            'model_name' => '日',
            'price' => '日別料金',
            'adults_number' => '大人の人数',
            'children_number' => '子供の人数',
        ],
    ],
    'reservation_addon' => [
        'fields' => [
            'related_id' => '関連識別子',
            'related_type' => '関連タイプ'
        ],
    ],
    'reservation_accommodation' => [
        'fields' => [
            'price_total' => '合計宿泊料金',
            'smoking' => '喫煙可',
            'accommodation_bed_type_combination_id' => '宿泊施設のベッドタイプの組み合わせ識別子'
        ],
    ],
    'reservation_cc' => [
        'fields' => [
            'holder' => 'クレジットカードの所有者',
            'number' => 'クレジットカード番号',
            'expire_date' => 'クレジットカード有効期限',
            'cvc' => 'CVCコード',
            'credit_card' => 'クレジットカード',
            'current_balance' => '現在の残高',
            'type_id' => '識別子タイプ',
            'activation_date' => 'アクティベーション日',
            'vcc_expiration_date' => 'vcc有効期限',
            'is_virtual_card' => 'バーチャルカードです'
        ],
    ],
    'reservation_invoice' => [
        'export_fields' => [
            'reference_number' => '予約ID',
            'reservation_id' => '予約ID',
            'accommodations' => '宿泊施設',
            'room' => '部屋番号',
            'period' => '宿泊期間',
            'pax' => 'ゲスト数',
            'type' => 'タイプ',
            'customer' => '名義人',
            'payment_agreement' => 'クレジット',
            'paid' => '支払済み',
            'to_pay' => '未払い額',
            'accountholder' => '名義人',
            'total' => '合計',
            'stay' => '宿泊',
            'guests' => 'ゲスト',
            'credit' => 'クレジット',
            'note' => '備考',
            'notes' => '備考',
            'status' => 'ステータス',
            'booker' => '予約者',
            'property_name' => '施設名',
            'open_charges' => '未清算の請求',
        ],
        'errors' => [
            'invoice_opened_for_customer' => 'この予約に関連するお客様の未清算の請求があります。新しい請求を開く前に、既存の請求を確定してください。',
            'credit_note_on_opened' => '未登録の請求書に対してクレジットノートを発行することはできません。',
            'associate_in_to_credit_note' => 'クレジットノートに収入を関連付けることはできません。',
            'associate_out_to_invoice' => '請求書に出金を関連付けることはできません。',
            'cant_update_due_invoice_no_show' => 'ノーショーまたはキャンセル請求書があるため、予約を変更することはできません。',
            'keep_same_customer_on_credit_note' => '発行済み請求書に関連付けられたクレジットノートの受取人を変更することはできません。',
            'impossibile_move_through_reservations' => 'この予約の未清算の請求以外に請求を移動することはできません。また、清算済みの請求書またはクレジットノートへの移動もできません。',
            'cant_refund_pending_sdi_invoice' => 'SDIでの検証待ちの請求書に対してクレジットノートを発行することはできません。',
            'associate_payments_to_follows_invoice' => '「請求書に続く」としてマークされた受領書に支払いを関連付けることはできません。',
        ],
    ],
    'reservation_note' => [
        'fields' => [
            'reservation_internal' => '予約に関するメモ',
            'reservation_customer' => '顧客メモ',
            'accommodation_customer' => '顧客からのリクエスト',
            'accommodation_checkin' => '部屋のチェックインに関するメモ',
            'accommodation_checkout' => '部屋のチェックアウトに関するメモ',
            'accommodation_housekeeper' => 'ハウスキーパーメモ'
        ],
        'deposit' => [
            'wording' => ':customer 様より :payment_method にて :amount の預かり金を受領',
            'card_info' => ':card_type カードの情報を登録しました（番号: :card_number、コード: :card_code、有効期限: :expire_date）',
        ],
    ],
    'reservation_payment' => [
        'move_errors' => [
            'reservation_payment_is_not_payment' => ':date に :accountholder 様から行われた支払いは払い戻しです',
            'reservation_payment_rows_with_bills' => ':date に :accountholder 様から行われた支払いには請求が関連付けられています',
            'reservation_payment_is_invoiced' => ':date に :accountholder 様から行われた支払いは既に発行済みの文書に含まれています',
            'reservation_payment_with_different_invoice_layout' => ':date に :accountholder 様から行われた支払いは、移動先施設に存在しない請求レイアウトを持っています',
        ],
        'pre_check_errors' => [
            'reservation_payment_is_not_payment' => '支払いは払い戻しです',
            'reservation_payment_rows_with_bills' => '支払いには請求が関連付けられています',
            'reservation_payment_is_invoiced' => '支払いは既に発行済みの文書に含まれています',
        ],
    ],
    'reservation_quote' => [
        'export_fields' => [
            'reference_number' => '番号',
            'created_at' => '作成日',
            'customer_full_name' => '顧客',
            'expire_date' => '有効期限',
            'status' => 'ステータス',
            'expire_date_availability' => 'オプションの有効期限',
            'email_read_at' => '閲覧日',
            'property' => '施設',
            'option' => '提案',
            'accommodations' => '宿泊施設',
            'stay' => '宿泊期間',
            'guests' => 'ゲスト',
            'treatment' => 'プラン',
            'total' => '合計',
            'customer_email' => 'メールアドレス',
            'customer_telephone' => '電話',
        ],
        'status' => [
            'active' => '有効',
            'revoked' => '却下',
            'accepted' => '承認済み',
            'expired' => '期限切れ',
            'draft' => '下書き',
        ],
        'adults' => '{1} 1 名の大人|[2,*] :count 名の大人',
        'children' => '{1} 1 名の子供|[2,*] :count 名の子供',
        'errors' => [
            'no_email_found' => '見積もりを送信するメールアドレスが指定されていません。少なくとも1つのアドレスを指定してください。',
            'email_already_feedback_cannot_update' => '顧客が既に見積もりを確認またはフィードバックを行ったため、変更することはできません。',
            'no_customer_specified' => '見積もりは顧客に関連付けられていません。',
            'quote_not_active' => '見積もりはアクティブではありません。',
            'quote_option_empty' => '見積もりのオプションに部屋が含まれていないため、確定できません。',
            'quote_option_no_availability' => '予約しようとしている宿泊施設は利用できなくなりました。',
            'upload_attachment' => 'ファイルのアップロードエラー',
            'other_modified' => 'この見積もりは他のユーザーによって変更されたため、利用できません。',
            'no_valid_property' => '異なる施設の宿泊施設をこのオプションに追加することはできません。',
        ],
    ],
    'reservation' => [
        'reservation' => '予約',
        'notes' => [
            'accommodation_internal' => '宿泊施設の内部メモ',
            'accommodation_checkout' => '部屋のチェックアウトメモ',
            'accommodation_checkin' => '部屋のチェックインメモ',
            'accommodation_bill' => '部屋の請求メモ',
            'accommodation_housekeeper' => '部屋の清掃スタッフメモ',
            'accommodation_customer' => '部屋のゲストメモ',
        ],
        'details' => [
            'inserted' => 'サービス :title の費用は :amount :currency です',
        ],
        'export_fields' => [
            'id' => 'ID',
            'booked_at' => '予約日時',
            'modified_at' => '最終変更日時',
            'channel_name' => 'チャネル',
            'channel' => 'チャネル',
            'booker' => '予約者',
            'booker_full_name' => '予約者',
            'group_label' => 'グループ',
            'accommodations' => '宿泊施設',
            'rateplans' => '料金プラン',
            'original_accommodations' => '元の宿泊施設',
            'property' => '施設',
            'stay' => '滞在期間',
            'period' => '期間',
            'tag' => 'タグ',
            'arrival_date' => '到着日',
            'departure_date' => '出発日',
            'number_nights' => '宿泊数',
            'total_price' => '合計金額',
            'property_name' => '施設名',
            'reservation_id' => '予約ID',
            'room' => '部屋',
            'total' => '合計',
            'total_to_pay' => '支払い予定額',
            'status' => 'ステータス',
            'note_customer' => '顧客メモ',
            'internal_note' => '内部メモ',
            'group' => 'グループ',
            'reference_number' => '参照番号',
            'commission_amount' => '手数料額',
            'treatments' => 'プラン',
            'booker_telephone' => '予約者電話番号',
            'booker_email' => '予約者メールアドレス',
            'company' => '会社',
            'currency' => '通貨',
            'nic' => '税コード',
            'extra' => '追加',
            'city_tax' => '宿泊税',
            'advance' => '前払金',
            'guests' => 'ゲスト',
            'xml_reservation_id' => 'チャネル予約ID',
            'user' => 'ユーザー',
            'reservation_from_id' => '予約元',
            'reservation_reason_id' => '予約理由',
            'escalate_report_to_booking' => 'Booking.comに報告を転送しますか？',
            'allow_guest_to_book_again' => 'ゲストの再予約を許可しますか？'
        ],
        'activity' => [
            'new' => [
                'message' => ':channel_name からの新しい予約',
                'message_sclak_generated_key' => '部屋: :accommodation_name (:tableau_label) 用にSclakキーが生成されました',
                'message_nuki_generated_key' => '部屋: :accommodation_name (:tableau_label) 用にNuki PINが生成されました',
                'message_sclak_sms_sent' => 'Sclakコードを含むSMSが番号 :telephone_number に送信されました',
                'message_sclak_deleted_key' => '部屋: :accommodation_name (:tableau_label) 用のSclakキーが削除されました',
                'message_nuki_deleted_key' => '部屋: :accommodation_name (:tableau_label) 用のNuki PINが削除されました',
                'invoice_printig_session' => '領収書ID :invoice_id に対して、プリンター :printer_name（ID: :printer_id）での財務印刷を開始しました',
                'added_payment' => ':amount :currency (ID: :payment_id) の支払いが :payment_method 方法で追加されました',
                'added_refund' => ':amount :currency (ID: :payment_id) の払い戻しが :payment_method 方法で発行されました',
            ],
            'update' => [
                'message' => ':field_translate フィールドが :old_value から :new_value に変更されました',
                'message_novalue' => ':field_translate フィールドが変更されました',
                'message_newvalue' => ':field_translate に :new_value を入力しました',
                'message_deletevalue' => ':field_translate から :old_value を削除しました',
                'message_forobject' => ':model_type :model_name の :field_translate フィールドが :old_value から :new_value に変更されました',
                'message_split_accommodation' => '予約された部屋 :accommodation_source (タブロー参照: :tableau_label_source) (:original_arrival_date から :original_departure_date まで) が :split_arrival_date から :split_departure_date に分割され、部屋 :accommodation_destination (タブロー参照: :tableau_label_destination) に移動されました',
                'message_move_accommodation' => '予約された部屋 :accommodation_source (タブロー参照: :tableau_label_source, 料金プラン: :rateplan_name_source , 処理: :treatment_name_source, 料金: :price_source) が部屋 :accommodation_destination (タブロー参照: :tableau_label_destination, 料金プラン: :rateplan_name_destination , 処理: :treatment_name_destination , 料金: :price_destination) に移動されました',
                'message_resend_email_customer' => '予約メールが再送信されました。宛先: :new_value',
                'message_resend_email_company' => '予約メールが企業に再送信されました。宛先: :new_value',
                'message_resend_email_property' => '予約メールが施設に再送信されました。宛先: :new_value',
                'message_resend_email_additional' => '予約メールが追加の宛先 :new_value に再送信されました',
                'message_restored_sdi_rejected_invoice' => '次の通知を伴って文書 :invoice_number (:invoice_date) が再開されました: :sdi_notify',
                'message_sdi_rejected_invoice' => '次の請求プロファイル :invoice_layout (:invoice_business_name - :invoice_vat_code) で発行された文書 :invoice_number (:invoice_date) が拒否されました',
                'message_sdi_rejected_invoice_with_advances' => '次の請求プロファイル :invoice_layout (:invoice_business_name - :invoice_vat_code) で発行された文書 :invoice_number (:invoice_date) が拒否され、以下の前払いが含まれます: :advances',
                'message_sdi_rejected_invoice_as_receipt' => '拒否された文書 :invoice_number (:invoice_date) が請求プロファイル :invoice_layout (:invoice_business_name - :invoice_vat_code) に基づいて領収書として発行され、以下の通知が添付されています: :sdi_notify',
                'message_registered_invoice' => '次の請求プロファイル :invoice_layout (:invoice_business_name - :invoice_vat_code) で文書 :invoice_number (:invoice_date) が登録されました。宛先: :invoice_customer (合計: :invoice_total) :manual_fp_register',
                'message_restored_invoice' => '次の請求プロファイル :invoice_layout (:invoice_business_name - :invoice_vat_code) で発行された :document_type 文書 :invoice_number (:invoice_date) がキャンセルされました',
                'calculate_city_tax' => '次のゲストに対して宿泊税が計算されました: :guests',
                'no_guests_calculate_city_tax' => '宿泊税が計算されましたが、計算対象となるゲストはいませんでした',
                'add_extra' => '以下の追加料金が加算されました: :extra',
                'delete_bill' => '以下の追加料金が削除されました: :extra',
                'transferred_bills' => ':bills_label の追加料金が :transfer_label として転送されました',
                'restored_bills' => '以下の追加料金が復元されました: :bills_label',
                'message_deleted_credit_note' => '次の請求プロファイル :invoice_layout (:invoice_business_name - :invoice_vat_code) で発行された :document_type 文書 :invoice_number (:invoice_date) が削除されました',
                'edit_payment' => '支払い (ID: :payment_id) が :payment_method 方法で変更されました。合計 :amount :currency',
                'message_edit_guest' => 'ゲスト :guest_name が変更されました',
                'transferred_payment_to_reservation' => '支払い (#:paymentId) が :date に :accountholder によって予約 :reservationOrigin から予約 :reservationDestination に転送されました',
                'guest_checkin_checkout' => '部屋の滞在日変更により、以下のゲストの到着日または出発日が変更されました: :guests',
                'transferred_bills_qty' => '料金: :bills_label の数量 :transfer_label が転送されました。',
                'transferred_bills_to_charges' => '料金: :bills_label の金額 :transfer_label がパススルーアカウント :invoice_label (:invoice_id) に転送されました。',
                'transferred_bills_to_accommodation' => '料金: :bills_label の金額 :transfer_label が部屋 :accommodation_label (:accommodation_id) - 予約番号 :reference_number に転送されました。',
                'transferred_bills_to_accommodation_multi_customer' => '料金: :bills_label の金額 :transfer_label が部屋 :accommodation_label (:accommodation_id) - 予約番号 :reference_number に転送され、以下の顧客に適用されました: :customers',
                'transferred_bills_qty_to_charges' => '料金: :bills_label の数量 :transfer_label がパススルーアカウント :invoice_label (:invoice_id) に転送されました。',
                'transferred_bills_qty_to_accommodation' => '料金: :bills_label の数量 :transfer_label が部屋 :accommodation_label (:accommodation_id) - 予約番号 :reference_number に転送されました。',
                'transferred_bills_qty_to_accommodation_multi_customer' => '料金: :bills_label の数量 :transfer_label が部屋 :accommodation_label (:accommodation_id) - 予約番号 :reference_number に転送され、以下の顧客に適用されました: :customers',
                'transferred_bills_to_accommodation_reservation_destination' => 'パススルーアカウント :invoice_origin (#:invoice_origin_id) から以下の料金が転送されました: :bills_label',
                'restored_bills' => '以下の料金が復元されました: :bills_label',
                'message_deleted_credit_note' => '以下の書類が削除されました: :document_type :invoice_number 日付 :invoice_date 発行プロファイル :invoice_layout (:invoice_business_name - :invoice_vat_code)',
                'edit_payment' => '以下の支払いが変更されました (ID: :payment_id): 方法 :payment_method, 合計 :amount :currency',
                'message_edit_guest' => '以下のゲストが変更されました: :guest_name',
                'transferred_payment_to_reservation' => '以下の支払い (#:paymentId) が転送されました: 日付 :date 名義 :accountholder 予約元 :reservationOrigin -> 予約先 :reservationDestination',
                'restored_payment_to_reservation' => '以下の支払い (#:paymentId) が復元されました: 日付 :date 名義 :accountholder 予約元 :reservationOrigin',
                'guest_checkin_checkout' => '部屋の滞在日変更に伴い、以下のゲストの到着または出発日が変更されました: :guests',
                'model_price_original' => 'フィールド :field_translate は、:old_value から :new_value に変更されました。顧客は現在の価格を維持することを選択しました。',
                'model_price_moved' => 'フィールド :field_translate は、:old_value から :new_value に変更されました。顧客は新しい価格を選択しました。',
            ],
            'delete' => [
                'delete_payment' => ':payment_method 方法で :amount :currency (ID: :payment_id) の支払いが削除されました',
            ],
            'view' => [
                'credit_card_fail' => 'クレジットカード情報の読み取りが試みられました。 (:ip_address)',
                'credit_card_success' => 'クレジットカード情報が閲覧されました。 (:ip_address)',
            ],
            'internal_note' => '内部メモ: :note',
            'bill_note' => '請求書発行メモ: :note',
            'catering_note' => '食事メモ: :note',
            'customer_note' => '顧客からのリクエスト: :note',
            'nuki' => [
                'create' => 'Nukiデバイス（:device_id）：部屋:tableau_labelのドアコードを作成しました',
                'update' => 'Nukiデバイス（:device_id）：部屋:tableau_labelのコード権限を変更しました',
                'delete' => 'Nukiデバイス（:device_id）：部屋:tableau_labelのドアコードを削除しました',
            ],

        ],
        'wording' => [
            'advance_invoice' => ':date_from から :date_to までの滞在',
            'customer' => '顧客: ',
            'advance_count' => '前金番号: ',
            'partial' => '部分的',
            'total' => '合計',
            'credit_note' => 'としてのクレジット :type 番号 :number (:invoice_date) を取り消し',
            'accommodation_bill_label' => '滞在',
            'city_tax_label' => ':min_age 歳から :max_age 歳まで、1泊あたり :cost 、最大 :limit_days 日間',
            'city_tax_label_no_limit' => ':min_age 歳から :max_age 歳まで、1泊あたり :cost 、日数制限なし',
        ],
        'fields' => [
            'model_name' => '予約',
            'arrival_date' => '到着日',
            'departure_date' => '出発日',
            'total_price' => '最終価格',
            'total_adults' => '大人人数',
            'overbooking' => 'オーバーブッキング',
            'label_name' => '顧客グループ',
            'reason' => '旅行の目的',
            'total_children' => '子供人数',
            'split_reservation' => '予約分割',
            'sclak_deleted_key' => 'Sclakキーが削除されました',
            'sclak_generated_key' => 'Sclakキーが生成されました',
            'sclak_sms_sent' => 'SlackコードのSMSが送信されました',
            'move_accommodation' => '部屋の移動',
            'accommodation_bill' => '請求メモ',
            'status' => 'ステータス',
            'keep_availability' => '利用可能を維持',
            'expiration_date' => '有効期限',
            'availability_option' => '空室オプション',
            'resend_email' => 'メールの再送',
            'commission_amount' => '手数料金額',
            'reservation_reason_id' => '予約理由識別子',
            'reservation_from_id' => '起源',
            'reservation_bill' => '予約請求書',
            'reservation_checkin' => '予約チェックイン',
            'reservation_checkout' => '予約チェックアウト',
            'partner_download' => 'パートナーダウンロード',
            'commissionable_amount' => '手数料額',
            'is_group' => 'グループかどうか',
            'commission_discount_type_id' => '手数料割引タイプID',
            'commission_discount_value' => '手数料割引額',
            'added_credit_card_data' => 'クレジットカード情報を追加しました',
        ],
        'payment_status' => [
            'paid' => '支払済み',
            'to_be_invoiced' => '請求予定',
            'to_pay' => '未払い',
            'suspended' => '保留中',
        ],
        'policy' => [
            'none' => 'ペナルティなし',
        ],
        'errors' => [
            'property_deleted' => '予約を削除できません。施設に連絡してください。',
            'missing_main_room_guest' => 'すべての部屋に主要なゲストが設定されていません。',
            'accommodation_not_found' => '宿泊施設が削除されました。',
            'different_accommodation_checkout_date' => '予約の部屋のチェックアウト日が異なります。',
            'different_accommodation_checkin_date' => '予約の部屋のチェックイン日が異なります。',
            'transfer_on_same_customer_bill' => '同じ支払い者に割り当てることはできません。',
            'no_guests_loaded' => '部屋に関連付けられたゲストがいません。',
            'not_mapped_accommodation' => '部屋が正しくマッピングされていません。',
            'not_switch_virtual' => '予約を別の施設の仮想部屋に移動することはできません。',
            'last_accommodation' => '最後に残った部屋を削除することはできません。',
            'not_tableau' => 'Tableauに属さない部屋です。',
            'impossible_change' => 'この状態遷移を実行することはできません。',
            'missing_roomreservation_id' => '指定された部屋予約IDが見つかりません。',
            'missing_order' => '注文が見つかりません。',
            'existing_bills_invoiced' => '予約に関連する請求書が既に発行されています。続行できません。',
            'uneditable_field' => '編集できないフィールドです。',
            'no_gateway_response' => '支払いゲートウェイとの接続エラー。',
            'reservation_unpaid' => '取引が失敗しました。',
            'missing_balance' => '残高が不足しています。',
            'uneditable_fields_invoice' => '次のフィールドは編集できません: ',
            'not_editable_total_due_paid' => '入力された価格が既に支払われた合計よりも少ないです。',
            'not_editable_total_due_invoice' => '入力された価格が請求書の合計よりも少ないです。',
            'accommodation_room_guest_exists' => '指定されたゲストは指定された期間内に既に存在します。',
            'no_payment_amount_enough' => '利用可能なクレジット (:amount_available) が必要な金額 (:request_amount) を満たしていません。',
            'payment_amoun_minor_of_amount_used' => '指定された金額 (:request_amount) は既に使用された金額 (:amount_used_global) よりも少ないです。',
            'cannot_delete_deposit_invoice' => '請求書に使用された支払いは削除できません。',
            'accommodation_invoiced' => '部屋は既に請求されています。削除できません。',
            'resend_email_empty_address' => 'この顧客にはメールアドレスが指定されていません。',
            'householder_in_agreement' => '世帯主は請求の分割に含まれています。続行する前にカスタマイズを変更してください。',
            'missing_company' => '予約の会社参照が欠けています。',
            'accommodation_bill_charged' => '部屋の請求が既に処理されています。続行できません。',
            'all_billed' => 'すべての請求が処理済みまたは移動されています。再生成できません。',
            'impossible_move_nature_bill' => '請求の性質を移動することはできません: ',
            'billed_accommodation' => 'Non è possibile cambiare le date di prenotazione perché sono stati emessi documenti fiscali.
            Inserisci una nuova prenotazione o aggiungi una camera a questa prenotazione con le nuove date.',
            'deposit_as_refund' => '保証金を返金として設定することはできません。',
            'refund_in_invoice' => '返金を請求書または領収書に関連付けることはできません。',
            'different_vat_codes' => '異なるVATコードを持つ請求書に支払いを関連付けることはできません。',
            'property_not_attached' => '予約に関連しない施設への支払いを関連付けることはできません。',
            'too_many_payments' => '支払いの金額が過剰です。',
            'bill_and_expense' => '支払いを請求と費用の両方に関連付けることはできません。',
            'expense_minimum_payment' => '費用には少なくとも1回の支払いが必要です。',
            'amount_exceed_refunds' => '関連付ける支払いは、払い戻し額を超えています。',
            'missing_reservation' => '予約が無効です。',
            'already_cancelled' => '予約は既にキャンセルされています。',
            'impossible_decrement_shared_bill' => '共有された請求の数量を減らすことはできません。',
            'pax_fields_in_not_paxable_bill' => 'ゲストを基にした追加サービス以外にゲストフィールドを設定できません。',
            'company_email_address_is_empty' => 'この会社にはメールアドレスが指定されていません。',
            'checkinonline_dati_mancanti' => 'データが正しく送信されていません。',
            'checkinonline_reservation_not_found' => '予約が見つかりません。',
            'checkinonline_reservation_is_cancelled' => '予約はキャンセルされています。',
            'checkinonline_reservation_is_not_confirmed' => '予約は確認されていません。',
            'checkinonline_reservation_arrival_date_past' => '到着日はすでに過ぎています。',
            'checkinonline_reservation_departure_date_over' => '予約はすでに終了しています。',
            'checkinonline_city_tax_cannot_pay' => '支払うべき宿泊税はありません。',
            'deposit_as_deposit' => '支払いはすでに保証金として登録されています。',
            'deposit_as_advance' => '保証金の上に前受金書類を発行することはできません。',
            'document_on_funds' => 'ファンドキャッシュ上で書類を発行することはできません。',
            'document_on_used_payment' => '既に他の請求書に充当された支払いに書類を発行することはできません。',
            'not_whole' => '関連付けられた支払いに書類を発行することはできません。',
            'document_on_refunded' => '払い戻された支払いに書類を発行することはできません。',
            'document_on_payments_out' => '支出の支払いに書類を発行することはできません。',
            'channel_checkin_missing_info' => 'リクエストのステータスに関する情報がありません。',
            'channel_checkin_missing_status_already_present' => 'チェックインのステータスは既に処理されています。',
            'no_bills_on_customer' => 'この顧客に関連する請求はありません。',
            'discount_over_invoiced_value' => '適用しようとしている割引額が請求額を超えています。',
            'no_show_requested_total_major_bills_to_invoice' => '請求される合計額を超えるNo-showリクエスト合計。',
            'checkin_major_checkout' => '部屋 :accommodation_name のチェックイン日がチェックアウト日を超えています。',
            'checkout_major_checkin' => '部屋 :accommodation_name のチェックアウト日がチェックイン日を超えています。',
            'missing_addon' => '追加サービスのフィールドが不足しています。',
            'missing_customer_on_split_bills_same_reservation' => '特定の支払者を指定しない限り、同じ予約で請求を分割することはできません。',
            'have_door_service_active' => ':external_service_name サービスが有効になっているため、手動でドアの鍵を追加することはできません。',
            'conflict_system_custom_email_template' => '送信するテンプレートが複数指定されています。一つだけを指定してください。',
            'guest_already_present_in_same_dates' => '指定された日付にすでに存在するゲストがいます。',
            'can_not_move_reservation_payments' => '次のエラーのため支払いを移動できません: :errors',
            'can_not_modify_ota_checkin_checkout' => 'チャネルからの予約のチェックインおよびチェックアウト日を変更することはできません。',
            'unsuitable_dates_for_guests' => 'ゲストの滞在日が不適切です: :guests',
            'unsuitable_dates_for_guests_one_day' => '複数の滞在日があります: :guests 1泊のみにするには、滞在の1つを削除してください',
        ],
        'warnings' => [
            'not_mapped_addons' => '希望するサービスが部屋に関連付けられていません: ',
            'bill_splitted' => '請求が複数のアカウントに分割されており、変更できません: ',
            'bill_children' => '派生した部分的な請求は変更できません: ',
            'all_bills_closed' => 'この予約に関するすべてのアカウントは閉じられています。',
            'deposit_cut' => '請求からの支払いに返金が行われました: ',
            'not_existing_bill' => '存在しない請求です。',
            'exceeding_num_adults' => '部屋の最大設定を超える大人の数です。',
            'exceeding_num_children' => '部屋の最大設定を超える子供の数です。',
            'existing_payments_pending' => '部屋に関連する未処理の支払いがあります。続行しますか？',
            'existing_invoices_joined' => '請求 :bill_name に関連付けられた書類が存在します。別の予約またはパススルーアカウントに転送できません。',
            'customer_invoiced' => '顧客 :customer に対して発行済みの請求書があります。削除できません。',
            'is_previous' => 'チャネルに接続される前の予約です。',
            'bill_cant_split' => 'このタイプでは請求を分割できません。',
            'bill_charged' => '1つ以上の請求が既に請求済みです。変更できません。',
            'bill_qty_incoerence' => '請求に関連付けられたゲストの数と一致しない数量です。',
            'no_guests' => 'この予約にはゲストが登録されていません。',
            'move_other_property_notify' => '通知を開始する施設を選択してください。',
            'bill_deposit_not_allowed' => '支払いはこの請求タイプに関連付けることはできません。',
            'bill_discount_unsuitable_to_row' => '再計算された割引は、請求された請求部分と互換性がありません。',
            'bill_rows_discount_deleting' => '転送により、開いているアカウントに存在する元の請求の割引がリセットされました。',
            'existing_bills_night' => '宿泊外の追加サービスは削除されます。',
            'bills_not_found' => '料金が見つかりません',
            'change_status_in_progress' => '予約は既にステータス変更中です。',
            'reservation_accommodation_door_key_code_reservation_resumed' => '新しい鍵を生成する必要があります。予約の状態変更により以前の鍵は無効になりました。',
            'reservation_accommodation_door_key_code_exist' => 'ドアの開錠コードが存在します。手動で再生成または取り消しを実行してください。',
            'reservation_accommodation_door_key_code_exist_moved_accommodation' => '1つ以上の宿泊施設が移動されました。新しい鍵を生成する必要があります。',
            'reservation_accommodation_door_key_code_delete' => '鍵の削除中にエラーが発生しました。手動で再試行してください。',
            'reservation_accommodation_door_key_code_generate' => '鍵の生成中にエラーが発生しました。手動で再試行してください。',
            'existing_transferred_bills' => '他の部屋から転送された請求があります。続行する前に復元または再割り当てしてください。',
            'bill_has_payment' => '請求 :bill_name に関連付けられた支払いが存在します。部屋や外部書類に転送できません。',
        ],
        'channels' => [
            'no_report_invalid_cc' => 'このチャネルでは無効なクレジットカードのレポートは要求されていません。',
            'no_report_noshow' => 'このチャネルではノーショーのレポートは要求されていません。',
            'no_report_cancellation_due_invalid' => 'このチャネルではキャンセルレポートは要求されていません。',
            'payment_to_ota' => ':channel_name への支払いが行われました。',
            'no_previous' => 'このチャネルは以前の予約をダウンロードできません。',
            'email' => [
                'without_room_title' => ':channel_name からの部屋なし新規予約 (ID: :reference_number) - 施設: :property_name',
                'without_rate_title' => ':channel_name からの料金なし新規予約 (ID: :reference_number) - 施設: :property_name',
            ],
        ],
        'bills' => [
            'reservation_bill_id_not_found' => '指定された予約には ID :reservation_bill_id が含まれていません。',
            'reservation_bill_id_already_override' => 'ID :reservation_bill_id はすでに上書きされています。',
            'reservation_bill_id_no_updates' => 'すべての要素は既に上書きされているか、指定された予約に属していません。',
            'delete_bill_accounted' => '1つ以上の要素がすでに計上されているため、削除できません。',
            'delete_sheet_bill_emitted' => '請求書がすでに発行されているため、アカウントを削除できません。',
            'different_vat_quotes_in_merge' => '異なる VAT を持つ請求項目を上書きすることはできません。',
            'cant_editable_due_moved' => '請求が移動されました: 割引の変更のみ許可されています。',
        ],
        'invoice' => [
            'invoice_already_registered' => '請求書はすでに発行されています。',
            'no_invoice_layout' => '請求書レイアウトがありません。続行できません。',
            'no_an_invoice' => 'これは請求書ではありません。',
            'no_company_id' => '請求先会社が指定されていません。',
            'unsuitable_payments' => '関連付けられた支払いは、アカウントにリンクされた VAT と互換性がありません。',
            'too_many_advances' => '支払われた前受金の金額が請求額の合計を超えています。',
            'advances_in_advance' => '前受金請求書に前受金を含めることはできません。',
            'payments_major_total_invoice' => '支払いの合計が請求書の合計を超えています。',
        ],
        'pdf' => [
            'reservation' => [
                'filters' => [
                    'in_house' => '滞在中',
                    'arrival_date' => '到着日',
                    'departure_date' => '出発日',
                ],
                'booker' => [
                    'origin' => '参照チャネル',
                    'name' => 'ゲスト名',
                    'telephone' => '電話番号',
                    'email' => 'Eメール',
                    'pec' => 'PEC',
                    'language' => '言語',
                    'reference_number' => '予約番号',
                    'booked_at' => '予約日',
                    'commissionable_amount' => '手数料対象金額',
                    'commission_amount' => '手数料',
                    'other_infos' => 'このゲストに関する重要情報',
                    'notes' => [
                        'note_internal' => '内部メモ',
                        'note_customer' => '顧客メモ',
                        'note_bill' => '支払いメモ',
                        'note_checkin' => 'チェックインメモ',
                        'note_checkout' => 'チェックアウトメモ',
                    ],
                ],
                'accommodation' => [
                    'from_date' => '到着日',
                    'to_date' => '出発日',
                    'duration' => '宿泊期間',
                    'duration_text' => '{1} :length 泊|[2,*] :length 泊',
                    'total_guests' => '合計ゲスト数',
                    'guests_adults_text' => ':quantity 大人',
                    'guests_children_text' => ':quantity 子供',
                    'total_accommodations' => '部屋の総数',
                ],
                'reservation' => [
                    'name' => 'ゲスト名',
                    'total_guests' => 'ゲスト数',
                    'guests_adults_text' => ':quantity 大人',
                    'guests_children_text' => ':quantity 子供',
                    'max_capacity' => '最大収容人数',
                    'capacity_text' => ':quantity ゲスト',
                    'meals' => '食事',
                    'meals_breakfast_included' => '朝食は部屋料金に含まれています',
                    'table' => [
                        'date' => '日付',
                        'price' => '価格',
                        'price_per_day' => '1泊あたりの価格',
                        'non_refundable_rate' => '返金不可料金',
                        'subtotal' => '小計',
                        'city_tax' => '宿泊税',
                        'city_tax_detail' => '1泊1人当たりの料金',
                        'total_accommodation_price' => '宿泊料金の合計',
                        'vat_included' => ':amount のVATが含まれています',
                        'vat_not_included' => 'VATを含まない料金',
                    ],
                ],
                'statuses' => [
                    'cancelled' => 'キャンセル済み',
                    'optionable' => '選択可能',
                    'hidden' => '非表示',
                    'pending' => '支払い待ち',
                    'confirmed' => '確認済み',
                ],
                'totals' => [
                    'statuses' => [
                        'Cancelled' => 'キャンセル',
                        'Optionable' => '選択可能',
                        'Hidden' => '非表示',
                        'Pending' => '支払い待ち',
                        'Confirmed' => '確認済み',
                        'Expired' => '期限切れ',
                    ],
                    'status' => '予約状況',
                    'total_amount' => '合計金額',
                    'paid_deposit' => '支払済みデポジット',
                    'total_paid' => '支払済み',
                    'total_to_be_paid' => '未払い合計',
                ],
                'payments' => [
                    'table' => [
                        'date' => '登録日',
                        'method' => '支払い方法',
                        'amount' => '金額',
                        'notes' => 'メモ',
                    ],
                ],
            ],
            'bills' => [
                'accommodations' => '宿泊施設',
                'accommodation' => '宿泊',
                'total' => '合計',
                'date' => '日付',
                'room' => '部屋',
                'treatment' => 'プラン',
                'amount_per_night' => '1泊あたりの料金',
                'addons_categories' => '追加サービス',
                'addon_category' => 'カテゴリ',
                'addon_name' => 'サービス',
                'addon_price_type' => '料金タイプ',
                'amount' => '金額',
                'taxes' => '税金',
                'tax_name' => '種類',
                'accommodations_title' => '宿泊施設詳細',
                'addons_categories_title' => '追加サービス詳細',
                'taxes_title' => '税金詳細',
            ],
            'guests' => [
                'guests_list' => '予約済みのゲストリスト',
                'reservation_of_date' => '日付',
                'duration_text' => ':length 泊',
                'from' => 'から',
                'to' => 'まで',
                'table' => [
                    'type' => 'タイプ',
                    'name' => '名',
                    'surname' => '姓',
                    'birthday_date' => '生年月日',
                    'gender' => '性別',
                    'birth_place' => '出生地',
                    'checked_in' => 'チェックイン済み',
                    'none' => '登録されたゲストはいません',
                ],
            ],
            'payment' => [
                'payments_short_title' => '支払い詳細',
                'payments_title' => '支払いと書類',
                'report_title' => '支払いノート',
                'deposit_title' => '保証金',
                'refund_title' => '返金ノート',
                'issuer' => '支払い名義人',
                'registration_date' => '支払い登録日',
                'payment' => '支払い',
                'payment_date' => '支払い日',
                'method' => '支払い方法',
                'amount' => '金額',
                'pos' => 'POS',
                'deposit_number' => '保証金番号',
                'payments_received' => '受領済み支払い',
                'notes' => 'メモ',
                'deposit' => '保証金',
                'to_pay' => '支払い予定金額',
                'excess_payment' => '超過金額合計',
                'invoiced' => '請求済み金額',
                'to_be_invoiced' => '請求予定金額',
                'total_to_be_invoiced' => '請求予定合計金額',
                'document_type' => '文書タイプ',
                'document_number' => '番号',
                'document_date' => '発行日',
                'invoice_issuer' => '請求書発行者',
                'invoice_paid' => '支払済み',
                'invoice_to_pay' => '未払い',
            ],
            'fees' => [
                'fees_title' => '手数料',
                'document_type' => 'タイプ',
                'total' => '合計',
                '22' => 'VAT 22%',
                '10' => 'VAT 10%',
                'customer' => '顧客または会社',
            ],
            'deposits' => [
                'deposits_title' => '前受金と保証金',
                'export_fields' => [
                    'property' => '施設',
                    'number' => '番号',
                    'date' => '日付',
                    'total' => '合計',
                    'amount_available' => '利用可能金額',
                    'used' => '使用済み',
                    'reservation_id' => '予約 ID',
                    'pos' => 'POS',
                    'type_payment' => '支払いタイプ',
                    'type_reservation' => '予約タイプ',
                    'description' => '説明',
                    'user_pay' => '支払い者',
                    'reservation' => '予約',
                    'payment_method' => '支払い方法',
                    'stay' => '宿泊',
                    'departure_date' => '出発日',
                ],
            ],
        ],
        'of_date' => ':date の',
        'arrival_date' => '到着日',
        'departure_date' => '出発日',
        'nights' => '泊',
        'accommodations' => '部屋',
        'policy_description' => '条件の概要',
        'policy_deposit_description' => '支払い概要',
        'payments_timetable' => [
            'title' => '支払い条件',
            'subtitle' => '以下に宿泊料金が請求される日程を示します',
            'statuses' => [
                'scheduled' => '予定済み',
                'processed' => '処理済み',
                'failed' => '失敗',
                'paused' => '一時停止',
                'cancelled' => 'キャンセル済み',
                'wait_customer' => '顧客の待機中',
                'partial_processed' => '部分的に処理された',
            ],
            'city_tax' => [
                'checkin_online' => '宿泊税 :amount は含まれておらず、オンラインチェックイン完了後に自動的に請求されます。オンラインチェックインが完了しない場合、施設で直接請求されます。',
                'checkout' => ':amount の金額は概算であり、免除や宿泊者数、宿泊日数の変更によって変動する可能性があります。'
            ],
        ],
        'log' => [
            'city_tax_log_title' => '宿泊税',
            'extra_log_title' => '追加サービス',
            'bill_title' => '請求書',
            'notes' => 'メモセクション',
            'guest' => 'ゲスト',
            'payment' => '支払い',
        ],
        'errors_reason' => [
            'update_system' => 'システムの理由を変更することはできません',
            'delete_system' => 'システムの理由を削除することはできません',
            'not_exist' => '理由が見つかりません',
        ],
        'customer_profile_deleted' => 'このゲストのプロフィールは削除されており、編集できません。変更を続けるには再有効化しますか？',
    ],
    'rhino' => [
        'exceptions' => [
            'request_not_valid' => '必要なフィールドが不足しています',
            'method_not_found' => '呼び出されたメソッドが存在しません',
        ],
        'vat_code_already_exists' => 'このVATコードはシステムに既に存在します。重複していないユニークなVATコードを入力してください。',
    ],
    'roles' => [
        'property' => [
            'master' => '管理者',
            'operator' => 'オペレーター',
            'housekeeper' => 'ハウスキーパー',
        ],
        'errors' => [
            'access_denied_property' => '誤った役割: ユーザーには、構造にアクセスするためのディレクター権限がありません。'
        ]
    ],
    'sca' => [
        'pdf' => [
            'filename' => 'クレジットカード承認書',
            'card_holder' => 'カード名義人',
            'card_type' => 'カード種類',
            'card_number' => 'カード番号',
            'card_expiration' => '有効期限',
            'card_cvc' => 'CVC',
            'parts' => [
                'p1' => 'クレジットカード承認書',
                'p2' => '注意 – アスタリスクが付いている項目は必須です',
                'p3' => '予約を確定するために必要な情報をご提供ください。',
                'p4' => '記入済みフォームを必要な書類とともに以下のアドレスに送信してください: <span class="link">:email</span>',
                'p5' => 'カード名義人の情報:',
                'p6' => '提供された情報が正確かつ真実であることを証明します。',
                'p7' => '以下のクレジット/デビットカードに記載の金額を課金することを承認します。',
                'p8' => '<span class="bold">返金不可料金</span>の場合、カードは即座に請求されます。',
                'p9' => '<span class="bold">柔軟料金</span>の場合、ポリシーに基づいて有効性確認のために事前承認が行われます。',
                'p10' => 'カード名義人の署名',
                'p11' => '予約番号',
                'p12' => '到着日',
                'p13' => 'この書類と共に、支払いに使用したクレジット/デビットカードの両面コピーおよびカード名義人の身分証明書/パスポートのコピーを送信してください。必要な書類を以下に即座に送信してください: <span class="link">:email</span>',
                'p14' => '必要な書類が届かない場合、予約は無効とみなされキャンセルされます。提供されたすべての情報は機密情報として扱われ、上記の目的にのみ使用されます。',
                'p15' => ':name – :address, :zip_code – :city_name <span class="link">:email</span> - <span class="link">:website</span>',
            ],
        ],
        'email' => [
            'subject' => ':property - 承認リクエスト',
            'subject_accepted' => 'SCA/3DS 承認が確認されました',
            'subject_reservation' => ':name :surname, あなたの予約を確認してください',
            'dear_customer_reservation' => '親愛なる :name :surname 様、<br /> 予約を保証するために、予約およびキャンセル条件に基づいてクレジットカードの利用を承認してください。<br><br>ご協力ありがとうございます。',
            'dear_customer_payment' => '親愛なる :name :surname 様、<br /> 予約を保証するために、予約およびキャンセル条件に基づいてクレジットカードの利用を承認してください。<br><br>ご協力ありがとうございます。',
            'your_reservation_for' => ':name に関するあなたの予約',
            'you_payment_for' => ':name に関するあなたの支払い',
            'we_are_waiting_for_you_on_date' => 'お待ちしております: :date',
            'reservation_summary' => '予約の概要',
            'payment_summary' => '支払いの概要',
            'reservation_total' => '予約合計',
            'payment_total' => '支払い合計',
            'authorize_card_use' => 'カード使用を承認する',
            'payment_click_here_link' => '支払いを確認するにはここをクリックしてください',
            'non_beddy_payment_click_here_link' => '予約を確認するには次のリンクにアクセスしてください: :link',
            'non_beddy_reservation_click_here_link' => '支払いを確認するには次のリンクにアクセスしてください: :link',
            'date' => '日付',
            'reservation_confirmation' => '予約確認番号 :referenceNumber',
            'payment_confirmation' => '支払い確認',
            'sca_reservation_accepted' => '予約 #:referenceNumber に関するSCA/PSD2フォームの確認リクエストが顧客により承認されました。',
            'sca_payment_accepted' => '予約 #:referenceNumber に関するSCA/PSD2フォームの確認リクエストが顧客により承認されました。',
        ],
        'confirmation_request_expired' => 'リクエストの有効期限が切れています',
        'whatsapp' => [
            'message' => '親愛なる :name :surname 様、予約 # :referenceNumber (:arrivalDate - :departureDate) を確認するために、クレジットカードの使用承認が必要です。次のリンクをクリックしてください: :link',
        ],
    ],
    'social_archive' => [
        'export_fields' => [
            'property_name' => '施設',
            'unlock_email' => 'メールアドレス',
            'unlock_date' => '登録日',
        ],
    ],
    'statistics' => [
        'partitioning_translations' => [
            'yearly' => '1年間|:value 年間',
            'monthly' => '1ヶ月間|:value ヶ月間',
            'daily' => '1日間|:value 日間',
        ],
        'warnings' => [
            'limit_truncation' => '指定された期間が広すぎます。検索範囲が制限されました: :partitioning_translation。',
            'previous_offset_available_only_with_daily_partitioning' => 'この比較タイプは日次表示でのみ利用可能です。選択した期間と前年同期が比較されます。',
        ],
        'exceptions' => [
            'invalid_split' => '利用できない操作です',
            'not_available' => '一時的に利用できない機能です',
            'cannot_create_groupable' => 'グループ化に必要なパラメータが無効です',
            'invalid_date_range' => '指定された日付範囲が無効です',
        ],
        'legend' => [
            'no_model' => '未指定',
            'deleted_rateplans' => '削除された料金プラン',
            'no_treatment' => '未指定のトリートメント',
            'charges' => '手動追加料金',
            'no_label' => '無名',
            'stay' => '宿泊',
            'tax' => '税金',
            'ob' => 'オーバーブッキング',
            'virtual_stamp' => '仮想スタンプ',
            'city_tax' => '宿泊税',
            'no_show' => 'ノーショー',
            'cancellation' => '期限超過のキャンセル',
            'no_show_stay' => 'ノーショー宿泊',
            'cancellation_stay' => '期限超過のキャンセル宿泊',
            'no_show_extra' => 'ノーショーでの追加サービス',
            'cancellation_extra' => '期限超過のキャンセル追加サービス',
            'penalty' => '罰則',
            'general_invoices' => '転送請求',
            'manual' => '手動請求',
            'payment' => '前払い',
            'beddy_channel_labels' => [
                'quote' => 'Beddy (見積もり)',
                'website' => 'Beddy (ウェブサイト)',
                'manual' => 'Beddy (PMS)',
                'general' => 'Beddy (転送請求)',
                'google-hotel' => 'Google Hotel',
                'trivago-fast-connect' => 'Trivago',
                'trivago-express-booking' => 'Trivago Express Booking',
                'bookingbooster' => 'Booking Booster',
            ],
        ],
        'label' => 'データ',
        'label_date' => '参照データ',
        'label_channel' => 'チャネルセグメント',
        'label_accommodation' => '部屋セグメント',
        'label_room' => 'タブローナンバーセグメント',
        'label_booker_category' => '顧客カテゴリセグメント',
        'label_rateplan' => '料金プランセグメント',
        'label_reservation_from' => '予約出所セグメント',
        'label_nationality' => '国籍セグメント',
        'label_property' => '施設セグメント',
        'label_dealer_company' => '企業セグメント',
        'label_dealer_agency' => '代理店セグメント',
        'label_dealer_tour_operator' => 'ツアーオペレーターセグメント',
        'label_production_type' => '部門セグメント',
        'production_over_time' => '期間別販売',
        'revenue' => '売上',
        'production' => '期間別生産',
        'available_nights' => '利用可能な宿泊数',
        'unsold_nights' => '未販売宿泊数',
        'penalty_nights' => '罰則宿泊数',
        'arrivals' => '到着数',
        'departures' => '出発数',
        'average_stay_length' => '平均滞在日数',
        'average_guest_earning' => '平均顧客収入',
        'sold_nights' => '販売済宿泊数',
        'occupation_percentage' => '占有率',
        'total_price' => '売上合計',
        'adr' => 'ADR (平均日額収入)',
        'revpar' => 'RevPAR (1室あたりの収益)',
        'counted_reservations' => '総予約数',
        'confirmed_reservations' => '確定予約数',
        'cancelled_reservations' => 'キャンセル予約数',
        'cancellation_ratio' => 'キャンセル率',
        'counted_average_booking_window' => '平均予約ウィンドウ',
        'confirmed_average_booking_window' => '予約確定の平均日数',
        'cancelled_average_booking_window' => 'キャンセルの平均日数',
        'rooms_checkin' => '到着予定部屋数',
        'rooms_checkout' => '出発予定部屋数',
        'label_department' => '部門',
        'label_service' => 'サービス',
        'gross_amount' => '総額',
        'share_percent' => 'シェア (%)',
        'taxes' => '税金',
        'net_amount' => '税抜き金額',
        'quantity' => '数量',
        'net_revenue' => '純収入',
        'commissions_amount' => '手数料',
        'in_stay_rooms' => '滞在中の部屋数',
        'presence_rooms' => '部屋の存在',
        'in_stay_guests' => '滞在中',
        'presence_guests' => '顧客の存在',
        'absolute_guests' => '顧客数',
        'gross_amount_without_commissions' => '手数料を除いた総額',
        'net_amount_without_commissions' => '手数料・税金を除いた金額',
        'gt_revenue' => [
            'rooms' => [
                'date' => '日付',
                'hotel_capacity' => 'ホテル収容能力',
                'rooms_sold' => '販売済み部屋数',
                'rooms_ooo' => '使用不可部屋数',
                'rooms_revenue' => '部屋売上',
            ],
            'segments' => [
                'date' => '日付',
                'cam_business' => 'ビジネス部屋',
                'rev_business' => 'ビジネス売上',
                'cam_tour_operator' => 'ツアーオペレーター部屋',
                'rev_tour_operator' => 'ツアーオペレーター売上',
                'cam_ota' => 'OTA部屋',
                'rev_ota' => 'OTA売上',
                'cam_beddy' => 'Beddy部屋',
                'rev_beddy' => 'Beddy売上',
                'cam_diretta' => '直接予約部屋',
                'rev_diretta' => '直接予約売上',
            ],
        ],
    ],
    'stripe' => [
        'declined_codes' => [
            'default' => [
                'description' => '不明な一般エラー。',
                'next_steps' => 'テクニカルサポートに連絡してください。',
            ],
            'approve_with_id' => [
                'description' => '支払いを承認できません。',
                'next_steps' => '再度試してください。それでも処理できない場合、顧客はカード発行会社に連絡する必要があります。',
            ],
            'customer_max_payment_methods' => [
                'description' => '顧客にはすでに最大数の支払い方法がリンクされています。',
                'next_steps' => 'この顧客からいくつかの支払い方法を削除するか、別の顧客で進めてください。',
            ],
            'call_issuer' => [
                'description' => 'カードが不明な理由で拒否されました。',
                'next_steps' => '顧客はカード発行会社に連絡し、詳細を確認してください。',
            ],
            'card_not_supported' => [
                'description' => 'このカードはこの種の購入をサポートしていません。',
                'next_steps' => '顧客は別の支払い方法を試してください。',
            ],
            'card_velocity_exceeded' => [
                'description' => '顧客がカードの支出限度を超えました。',
                'next_steps' => '一定の時間を待って再試行するか、別のカードを使用してください。',
            ],
            'currency_not_supported' => [
                'description' => 'このカードは指定された通貨をサポートしていません。',
                'next_steps' => '顧客はこの通貨をサポートする別のカードを使用してください。',
            ],
            'do_not_honor' => [
                'description' => 'カードが拒否されました。',
                'next_steps' => '顧客はカード発行会社に連絡し、詳細を確認してください。',
            ],
            'do_not_try_again' => [
                'description' => 'カードが拒否されました。',
                'next_steps' => '支払いを再試行しないでください。顧客は代替の支払い方法を使用する必要があります。',
            ],
            'duplicate_transaction' => [
                'description' => '同じ金額と詳細で最近送信されたトランザクションがあります。',
                'next_steps' => '顧客は時間を待ってから再試行してください。',
            ],
            'expired_card' => [
                'description' => 'カードが期限切れです。',
                'next_steps' => '顧客は別のカードを使用してください。',
            ],
            'fraudulent' => [
                'description' => 'トランザクションは詐欺の可能性があるため拒否されました。',
                'next_steps' => '顧客は代替の支払い方法を使用する必要があります。',
            ],
            'generic_decline' => [
                'description' => 'カードが拒否されました。',
                'next_steps' => '顧客はカード発行会社に連絡し、詳細を確認してください。',
            ],
            'incorrect_number' => [
                'description' => '入力されたカード番号が正しくありません。',
                'next_steps' => '顧客はカード番号を確認するか、別のカードを使用してください。',
            ],
            'incorrect_cvc' => [
                'description' => 'カードのセキュリティコード (CVC) が正しくありません。',
                'next_steps' => '顧客はCVCを確認するか、別のカードを使用してください。',
            ],
            'incorrect_pin' => [
                'description' => '入力されたPINが正しくありません。',
                'next_steps' => '顧客は正しいPINを入力してください。',
            ],
            'incorrect_zip' => [
                'description' => '郵便番号が正しくありません。',
                'next_steps' => '顧客は自分の郵便番号を確認してください。',
            ],
            'insufficient_funds' => [
                'description' => 'カードの残高が不足しています。',
                'next_steps' => '顧客は代替の支払い方法を使用する必要があります。',
            ],
            'invalid_account' => [
                'description' => 'カードまたはアカウントが存在しません。',
                'next_steps' => '顧客はカード情報を確認するか、別の支払い方法を使用してください。',
            ],
            'invalid_amount' => [
                'description' => '支払い金額が無効です。',
                'next_steps' => '金額を確認して再試行してください。',
            ],
            'invalid_cvc' => [
                'description' => 'カードのセキュリティコード (CVC) が無効です。',
                'next_steps' => '顧客はCVCを確認するか、別のカードを使用してください。',
            ],
            'invalid_expiry_year' => [
                'description' => 'カードの有効期限年が無効です。',
                'next_steps' => '顧客は有効期限を確認するか、別のカードを使用してください。',
            ],
            'invalid_number' => [
                'description' => 'カード番号が無効です。',
                'next_steps' => '顧客はカード番号を確認するか、別のカードを使用してください。',
            ],
            'issuer_not_available' => [
                'description' => 'カード発行会社が利用できません。',
                'next_steps' => '顧客は後で再試行してください。',
            ],
            'lost_card' => [
                'description' => 'カードが紛失として報告されました。',
                'next_steps' => '顧客は代替の支払い方法を使用する必要があります。',
            ],
            'merchant_blacklist' => [
                'description' => '商人のルールにより支払いが拒否されました。',
                'next_steps' => '顧客は代替の支払い方法を使用してください。',
            ],
            'new_account_information_available' => [
                'description' => 'カードアカウントの新しい情報が利用可能です。',
                'next_steps' => '顧客は銀行に最新情報を確認してください。',
            ],
            'no_action_taken' => [
                'description' => 'カード発行会社は何のアクションも実行しませんでした。',
                'next_steps' => '顧客はカード発行会社に連絡し、詳細を確認してください。',
            ],
            'not_permitted' => [
                'description' => '支払いは許可されていません。',
                'next_steps' => '顧客はカード発行会社に連絡し、詳細を確認してください。',
            ],
            'offline_pin_required' => [
                'description' => 'オフラインPINが必要です。',
                'next_steps' => '顧客は正しいPINを入力してください。',
            ],
            'online_or_offline_pin_required' => [
                'description' => 'オンラインまたはオフラインPINが必要です。',
                'next_steps' => '顧客は正しいPINを入力してください。',
            ],
            'pickup_card' => [
                'description' => 'カードを回収する必要があります。',
                'next_steps' => '顧客はカード発行会社に連絡し、詳細を確認してください。',
            ],
            'pin_try_exceeded' => [
                'description' => '顧客がPINの試行回数を超えました。',
                'next_steps' => '顧客はカード発行会社に連絡してPINを解除するか、別の支払い方法を使用してください。',
            ],
            'processing_error' => [
                'description' => '処理中にエラーが発生しました。',
                'next_steps' => '顧客は後で再試行してください。',
            ],
            'reenter_transaction' => [
                'description' => '支払いを再入力する必要があります。',
                'next_steps' => '商人は支払いを再入力してください。',
            ],
            'restricted_card' => [
                'description' => 'このカードは支払いに使用できません。',
                'next_steps' => '顧客は代替の支払い方法を使用してください。',
            ],
            'revocation_of_all_authorizations' => [
                'description' => 'カードが拒否されました。',
                'next_steps' => '顧客は代替の支払い方法を使用してください。',
            ],
            'revocation_of_authorization' => [
                'description' => 'カードが拒否されました。',
                'next_steps' => '顧客は代替の支払い方法を使用してください。',
            ],
            'security_violation' => [
                'description' => 'セキュリティ違反によりカードが拒否されました。',
                'next_steps' => '顧客は代替の支払い方法を使用してください。',
            ],
            'service_not_allowed' => [
                'description' => 'サービスが許可されていません。',
                'next_steps' => '顧客は代替の支払い方法を使用してください。',
            ],
            'stolen_card' => [
                'description' => 'カードが盗難として報告されました。',
                'next_steps' => '顧客は代替の支払い方法を使用してください。',
            ],
            'stop_payment_order' => [
                'description' => '支払いが顧客によって停止されました。',
                'next_steps' => '顧客は代替の支払い方法を使用してください。',
            ],
            'testmode_charges_only' => [
                'description' => 'あなたのアカウントは有効化されておらず、テスト課金のみが可能です。',
                'next_steps' => 'ダッシュボードでアカウントを有効化し、実際の課金処理を開始してください。',
            ],
            'testmode_decline' => [
                'description' => 'Stripeのテストカードが使用されました。',
                'next_steps' => '実際の支払いカードを使用してください。',
            ],
            'transaction_not_allowed' => [
                'description' => 'トランザクションは許可されていません。',
                'next_steps' => '顧客はカード発行会社に連絡し、詳細を確認してください。',
            ],
            'try_again_later' => [
                'description' => 'カード発行会社がリクエストを承認しませんでした。',
                'next_steps' => '顧客は後で再試行してください。',
            ],
        ],
    ],
    'tableau' => [
        'errors' => [
            'roomNotFound' => '部屋が見つからない、または存在しません。',
            'tableauNumberNotFound' => '部屋番号が正しくありません。',
            'closureConflict' => 'クローズ期間を重ねることはできません。',
            'lockedRoom' => '部屋がブロックされているか、サポートルームとして設定されており、変更できません。',
            'lockedAccommodation' => 'タイプの部屋がブロックされており変更できません。',
            'reservation_accommodation_not_fund' => '予約済みの部屋が見つかりませんでした。',
            'accommodation_destination_not_found' => '目的の部屋が見つかりませんでした。',
            'accommodation_destination_treatment_not_found' => '選択した部屋では指定されたサービスが利用できません。',
            'accommodation_destination_rateplan_not_found' => '選択した部屋では指定された料金プランが有効ではありません。',
            'reservation_locked' => 'この予約はロックされた状態であり、変更を加えることができません。',
            'exists_reservation_destination' => '目的の部屋には既に予約が存在するため、続行できません！',
            'split_checkin_minor' => '指定されたチェックイン日が予約のチェックイン日よりも早いです。',
            'split_checkout_major' => '指定されたチェックアウト日が予約のチェックアウト日よりも遅いです。',
            'split_incompatible_rates' => '目的の部屋は料金プランが異なるため互換性がありません。',
            'exists_tableau_closure' => '目的の部屋にクローズ期間があります。続行する前に、クローズを解除してください。',
            'exists_reservation_closure' => '選択された期間に予約が存在するため、部屋を閉鎖できません。',
            'reservation_not_found' => '予約が見つかりませんでした。',
            'reservation_accommodation_keep_activated' => '部屋を移動することはできません。続行するには、予約の詳細からブロックを解除してください。',
            'reservation_moved_or_cancelled' => '予約は移動またはキャンセルされました。',
            'reservation_is_moving' => '注意: 現在予約の変更操作が進行中です。テーブルを更新してから数秒後にもう一度試してください。',
            'closure_just_creating' => 'この部屋のクローズがまだ進行中です。後でもう一度お試しください。',
            'closure_just_removing' => 'この部屋のクローズ解除がまだ進行中です。後でもう一度お試しください。',
        ],
        'warnings' => [
            'tableauNumberWillBeChanged' => '注意: 部屋番号が :newTableauNumber に変更されます。',
        ],
    ],
    'technical_notices' => [
        'email' => [
            'failed_log_job_title' => 'SendLogJob の送信に失敗しました',
        ],
        'errors' => [
            'channel_unsupported' => 'サポートされていないチャネルです。',
            'property_not_found' => '施設が見つかりませんでした。',
        ],
    ],
    'templates_snippets_categories' => [
        'reservation_data' => '予約データ',
        'property_data' => '施設データ',
        'automatism' => '自動化',
        'reservations_accommodation_datails' => '予約した宿泊施設の詳細',
        'reservation_personal_data' => '予約者の個人情報',
        'payments_data' => '支払いデータ',
        'cancellation_policy_data' => 'キャンセルポリシーデータ',
        'estimate_data' => '見積データ',
        'tax_document_data' => '税務書類データ',
        'payments_timetable' => 'スケジュールされた支払い',
    ],

    'users' => [
        'new' => [
            'title' => '新規ユーザー :username',
            'message' => ':self_username によって新しいユーザーが作成されました。',
        ],
        'update' => [
            'title' => 'ユーザー :username 更新',
            'message' => 'ユーザー :username が正常に更新されました。',
            'missing_email_verification_code' => 'この操作には確認が必要です。現在のメールアドレスに通知を送信しました。',
        ],
        'delete' => [
            'title' => 'ユーザー :username 削除',
            'message' => 'ユーザー :username が正常に削除されました。',
            'error_delete_1' => '自分自身のアカウントを削除することはできません。',
        ],
        'errors' => [
            'emailnotfound' => '無効なメールアドレス',
            'passwordIncorrect' => '現在のパスワードが正しくありません',
            'reminderNotValid' => 'コードが無効または期限切れです',
            'propertyAttached' => 'このユーザーと施設はすでに関連付けられています。',
            'propertyDetached' => 'このユーザーと施設には関係がありません。',
            'permissionNotFound' => 'このユーザーに設定されている権限の一部が見つかりません。',
            'tokenNotGenerated' => 'トークンの生成中にエラーが発生しました。',
            'username_exists' => 'このユーザー名はすでに使用されています。',
            'email_exists' => 'このメールアドレスはすでに使用されています。',
            'user_not_allowed' => 'ログイン中のユーザーは新しいユーザーを作成する権限がありません。',
            'cannot_detach_all_auth_verification_methods' => 'すべての認証方法を切り離すことはできません。少なくとも1つはアクティブである必要があります。',
            'no_active_properties' => 'お客様のアカウントには有効な施設が登録されていません。サポートが必要な場合は、Beddyサポートまでご連絡ください。'
        ],
    ],
    'vat_quote' => [
        'related_model' => [
            'accommodation' => '宿泊施設',
            'addon' => '追加サービス',
            'city_tax' => '市税',
            'manual_charge' => '手動で追加された料金',
            'expense_category' => '費用カテゴリ',
            'reservation_payment' => '請求書と預り金領収書',
            'place_tax' => '印紙税',
            'reservation_no_show' => 'ノーショー',
            'reservation_cancellation' => '期限後のキャンセル',
        ],
        'log_module' => [
            'vat_quote_created' => '消費税率が作成されました',
            'vat_quote_updated' => '消費税率が更新されました',
            'vat_quote_deleted' => '消費税率が削除されました',
            'vat_quote_default_created' => 'デフォルトの消費税率が作成されました',
            'vat_quote_default_updated' => 'デフォルトの消費税率が更新されました',
            'vat_quote_default_deleted' => 'デフォルトの消費税率が削除されました',
            'property_vat_quote_added' => '消費税率が追加されました',
            'property_vat_quote_replaced' => '消費税率が置き換えられました',
        ],
        'errors' => [
            'vat_quote_associated' => 'いくつかの施設にデフォルトのVAT率が設定されています、処理できません',
            'insufficient_default_number' => '次の消費税率を削除できません。削除すると、以下のフィールドにデフォルトの消費税率がなくなります: ',
            'invalid_place_id' => '国のパラメータに有効な値がありません。'
        ]
    ],
    'venice_exemption' => [
        'errors' => [
            'CDAError' => '選択した日付はヴェネツィア市によって認められていません。',
        ],
    ],
    'vrbo' => [
        'checkpoints' => [
            'IsActiveByOwner' => 'Vrboへの配信がアクティブであることを確認してください',
            'IsListingNotArchived' => '物件がVrboでアーカイブされています。Vrboサポートに連絡してください',
            'IsActiveByCsr' => 'Vrboサポートによって物件が無効化されています。Vrboサポートに連絡してください',
            'HasImages' => '画像が不足しています（最低6枚必要）',
            'HasValidatedAddress' => '無効な住所',
            'HasGeoCode' => '無効または不足しているGPS座標',
            'HasPropertyAddress' => '無効な住所',
            'HasBathroom' => 'バスルームの情報が不足しています',
            'HasMaxOccupancy' => '占有情報が不足しています',
            'HasPropertyDescription' => '説明が不足しています',
            'HasPropertyHeadline' => '説明が不足しています',
            'HasPropertyName' => '物件名が不足しています',
            'HasPropertyType' => '施設の種類が不足しています',
            'HasRates' => '料金や空室状況が不足しています',
            'HasRegistrationNumber' => '登録番号が不足しています',
        ],
    ],
    'webcontroller' => [
        'downloader' => [
            'title_waiting' => 'お待ちください...',
            'message_waiting' => 'リクエストされた操作を処理中です... ご辛抱いただきありがとうございます',
            'title_started' => 'ダウンロード開始',
            'message_started' => 'ダウンロードが開始されました。完了したらこのウィンドウを閉じることができます',
            'title_error' => 'エラー！',
            'message_error' => 'リクエストの処理中にエラーが発生しました。<br> お問い合わせください。',
        ],
        'metasearch' => [
            'title_error' => 'エラー！',
            'message_error' => 'リクエストの処理中にエラーが発生しました。',
        ],
    ],
    'welcome_automatic_email' => [
        'email' => [
            'preview_text' => '運用を開始するための有用な情報',
            'subject' => 'Beddyへようこそ - 設定を始めましょう！',
            'greetings_text' => '本日は以上です。私たちのサービスをお選びいただきありがとうございます。<br><br>Beddyスタッフ一同',
            'training_pms_text_button' => 'PMS トレーニングビデオ',
            'training_pms_channel_button' => 'チャンネルマネージャートレーニングビデオ',
            'model_welcome' => [
                'subject' => 'Beddyへようこそ - 初めのステップと重要な情報',
                'preview_text' => '知っておくべきすべてのこと',
                'body_1' => 'Beddyへようこそ、  
            <br><br>
            サービスをご利用いただきありがとうございます。<b>今後の連絡内容に注意して従ってください</b>。そのため、support@beddy.io と info@beddy.io をメールプロバイダーの連絡先に追加し、メールが迷惑メールフォルダに振り分けられないようにしてください。
            <br><br>
            以下に一般的なメールプロバイダー用のガイドを記載します： 
            <br><br>
            <a href="https://support.google.com/contacts/answer/1069522">Gmailで連絡先を追加する方法</a>
            <br><br>
            <a href="https://support.microsoft.com/it-it/office/aggiungere-un-contatto-e1dc4548-3bd6-4644-aecd-47b5728f7b0d#ID0EAABAAA=Newer_versions">Outlookで連絡先を追加する方法</a>',
                'greetings_text' => '改めまして、私たちのサービスをお選びいただきありがとうございます。<br><br>Beddyスタッフ一同',
            ],
            'model_A' => [
                'body_1' => 'こんにちは、:userMasterName
                <br><br>
                Beddyアカウントを設定するための次のステップは以下の通りです。
                <br><br>
                &nbsp;&nbsp;<b>01. 初めのステップ – 一般設定</b>
                <br><br>
                まもなく担当者よりご連絡し、Beddyアカウントの設定を行います。
                <br><br>
                初期設定は非常に重要で、次のステップに備えるものです。
                <br><br>
                担当者との面談前に<b>添付のExcelフォームを記入</b>することをおすすめします。これにより、設定時間を短縮できます。
                <br><br>
                ファイルには複数のシートがあり、すべて記入する必要があります。<br>
                記入後、<a href="mailto:support@beddy.io">support@beddy.io</a>まで送信してください。
                <br><br>
                フォームのすべての項目が必須です。不足があるとアカウント設定が遅れる可能性があります。
                <br><br>
                複数施設を管理している場合は、Excelファイルをコピーして各施設ごとに記入してください。
                <br><br>
                設定完了後、アカウントへのアクセス情報が提供されます。',
                'body_2' => '&nbsp;&nbsp;<b>02. トレーニング - PMSトレーニング</b>
                <br><br>
                設定完了後、PMSの機能に関する<b>トレーニング</b>の予約についてご連絡します。
                <br><br>
                トレーニングは<b>90分</b>で、スタッフも参加可能です。
                <br><br>
                トレーニングを待つ間、オンライン研修でソフトウェアの機能を確認することをお勧めします。',
                'body_3' => '&nbsp;&nbsp;<b>03. チャネル接続 - Channel Managerの設定</b>
                <br><br>
                PMSトレーニング完了後、チャネル接続のための新しいミーティングが予定されます。
                Channel Managerを有効にした後は、旧チャネルマネージャーやOTAのエクストラネットの使用はできません。',
                'body_4' => '&nbsp;&nbsp;<b>04. トレーニング - Channel Managerトレーニング</b>
                <br><br>
                接続手順完了後、Channel Managerの機能に関するトレーニングが同日12:30に提供されます。
                <br><br>
                トレーニングは<b>30分</b>で、スタッフも参加可能です。
                <br><br>
                トレーニングを待つ間、オンライン研修でソフトウェアの機能を確認することをお勧めします。',
            ],
            'model_B' => [
                'body_1' => 'こんにちは、:userMasterName
                <br><br>
                Beddyアカウントを設定するための次のステップは以下の通りです。
                <br><br>
                &nbsp;&nbsp;<b>01. 初めのステップ – 一般設定</b>
                <br><br>
                まもなく担当者よりご連絡し、Beddyアカウントの設定を行います。
                <br><br>
                初期設定は非常に重要で、次のステップに備えるものです。
                <br><br>
                担当者との面談前に<b>添付のExcelフォームを記入</b>することをおすすめします。これにより、設定時間を短縮できます。
                <br><br>
                ファイルには複数のシートがあり、すべて記入する必要があります。<br>
                記入後、<a href="mailto:support@beddy.io">support@beddy.io</a>まで送信してください。
                <br><br>
                フォームのすべての項目が必須です。不足があるとアカウント設定が遅れる可能性があります。
                <br><br>
                複数施設を管理している場合は、Excelファイルをコピーして各施設ごとに記入してください。
                <br><br>
                設定完了後、アカウントへのアクセス情報が提供されます。',
                'body_2' => '&nbsp;&nbsp;<b>02. トレーニング - PMSトレーニング</b>
                <br><br>
                設定完了後、PMSの機能に関する<b>トレーニング</b>の予約についてご連絡します。
                <br><br>
                トレーニングは<b>90分</b>で、スタッフも参加可能です。
                <br><br>
                トレーニングを待つ間、オンライン研修でソフトウェアの機能を確認することをお勧めします。',
                'body_3' => '&nbsp;&nbsp;<b>03. トレーニング - レートと空室管理</b>
                <br><br>
                接続手順完了後、Channel Managerの機能に関するトレーニングが同日12:30に提供されます。
                <br><br>
                Channel Managerがライセンスにない場合でも、PMSでの料金・空室入力操作が同じため、トレーニングへの参加は必須です。
                <br><br>
                トレーニングは<b>30分</b>で、スタッフも参加可能です。',
            ],
            'model_C' =>  [
                'body_1' => 'こんにちは、:userMasterName
                <br><br>
                Beddyアカウントを設定するための次のステップは以下の通りです。
                <br><br>
                &nbsp;&nbsp;<b>01. 初めのステップ – 一般設定</b>
                <br><br>
                まもなく担当者よりご連絡し、Beddyアカウントの設定を行います。
                <br><br>
                初期設定は非常に重要で、次のステップに備えるものです。
                <br><br>
                担当者との面談前に<b>添付のExcelフォームを記入</b>することをおすすめします。これにより、設定時間を短縮できます。
                <br><br>
                ファイルには複数のシートがあり、すべて記入する必要があります。<br>
                記入後、<a href="mailto:support@beddy.io">support@beddy.io</a>まで送信してください。
                <br><br>
                フォームのすべての項目が必須です。不足があるとアカウント設定が遅れる可能性があります。
                <br><br>
                複数施設を管理している場合は、Excelファイルをコピーして各施設ごとに記入してください。
                <br><br>
                設定完了後、アカウントへのアクセス情報が提供されます。',
                'body_2' => '&nbsp;&nbsp;<b>02. トレーニング - Channel Managerトレーニング</b>
                <br><br>
                設定完了後、Channel Managerの機能に関する<b>トレーニング</b>の予約についてご連絡します。
                <br><br>
                トレーニングは<b>60分</b>で、スタッフも参加可能です。
                <br><br>
                トレーニングを待つ間、オンライン研修でソフトウェアの機能を確認することをお勧めします。',
                'body_3' => '&nbsp;&nbsp;<b>03. チャネル接続 - Channel Managerの設定</b>
                <br><br>
                トレーニング完了後、チャネル接続のための新しいミーティングが予定されます。
                Channel Managerを有効にした後は、旧チャネルマネージャーやOTAのエクストラネットの使用はできません。',
            ],
            'model_D' => [
                'body_1' => 'こんにちは、:userMasterName
                <br><br>
                以下はBeddyアカウントを設定するための次のステップです。この通知を注意深く読み、設定をスムーズに進めるために必要な情報を提供してください。
                <br><br>
                &nbsp;&nbsp;<b>01. 初めのステップ – 一般設定</b>
                <br><br>
                まもなく担当者よりご連絡し、Beddyアカウントの設定を行います。
                <br><br>
                担当者との面談前に以下を行ってください：
                <br><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- <b>添付のExcelフォームを記入する</b><br>
                &nbsp;&nbsp;&nbsp;&nbsp;- Beddyに接続する外部Channel Managerのオブジェクトおよび料金設定を確認する<br>
                &nbsp;&nbsp;&nbsp;&nbsp;- 記入したフォームおよび確認結果を<a href="mailto:support@beddy.io">support@beddy.io</a>に送信する<br><br>
                これらの情報は設定を迅速に進めるために<b>非常に重要です</b>。
                <br><br>
                フォームのすべての項目が必須です。情報が不足しているとアカウント設定が遅れる可能性があります。
                <br><br>
                複数施設を管理している場合は、各施設ごとにフォームと確認結果を用意してください。
                <br><br>
                設定完了後、アカウントへのアクセス情報が提供されます。',
                'body_2' => '&nbsp;&nbsp;<b>02. トレーニング - PMSトレーニング</b>
                <br><br>
                設定完了後、PMSの機能に関する<b>グループトレーニング</b>の予約についてご連絡します。
                <br><br>
                トレーニングは<b>90分</b>で、スタッフも参加可能です。
                <br><br>
                トレーニングを待つ間、オンライン研修でソフトウェアの機能を確認することをお勧めします。',
                'body_3' => '&nbsp;&nbsp;<b>03. トレーニング - Beddyに統合されたChannel Manager</b>
                <br><br>
                接続手順完了後、外部Channel Managerを使用して料金、空室、制限をPMSで更新する方法についてのトレーニングが提供されます。
                <br><br>
                セッションは月曜15:00、および水曜/金曜11:30に実施されます。
                <br><br>
                トレーニングは60分間で、スタッフも参加可能です。
                <br><br>
                Channel Managerが「予約のダウンロードのみ」モードで統合されている場合、トレーニングは任意ですが、PMSで料金を管理する場合は参加を推奨します。',
                'body_4' => '&nbsp;&nbsp;<b>04. Beddyに統合されたChannel Managerの接続</b>
                <br><br>
                PMSトレーニング完了後、外部Channel ManagerをBeddyに接続するための新しいミーティングが予定されます。',
            ],
        ],
        'errors' => [
            'fail_to_send' => '指定されたメールアドレス :email_address にメールを送信できませんでした。',
        ],
    ],
    'zdatalake' => [
        'Couple' => 'カップル',
        'Family' => '家族',
        'Single' => 'シングル',
        'Group' => 'グループ',
    ],
    'booking_booster_configuration' => [
        'errors' => [
            'configuration_not_found' => '構成が見つかりません',
        ],
    ],
    'booking_booster' => [
        'errors' => [
            'auth_token' => 'このエラーのためにBooking Boosterの認証トークンを取得できませんでした: :error',
            'available_budget' => 'このエラーのために利用可能な予算を取得できませんでした: :error',
            'campaigns_statistics' => 'このエラーのためにキャンペーン統計を取得できませんでした: :error',
            'ads_statistics' => 'このエラーのため、広告統計を取得できませんでした: :error',
            'ads_details' => 'このエラーのため、広告の詳細を取得できませんでした: :error',
            'property_targets' => 'このエラーに対して施設のターゲットを取得できません: :error',
            'client_error' => '資格情報が正しくないか、要求されたリソースにアクセスする権限がありません。詳細: :error',
            'server_error' => '技術的な問題が発生しています。後でもう一度お試しください。詳細: :error',
            'connection_error' => 'Booking Boosterに接続できません。後でもう一度お試しください。詳細: :error'
        ],
        'warnings' => [
            'property_not_mapped' => '以下の施設はマッピングされておらず、キャンペーン統計に正しく表示されない可能性があります: :propertyNames'
        ]
    ],
    'zpay' => [
        'declined_codes' => [
            'default' => [
                'description' => '不明な一般エラーです。',
                'next_steps' => 'テクニカルサポートに連絡してください。',
            ],
            'validation_failed' => [
                'description' => 'カード認証に失敗しました',
                'next_steps' => '顧客は新しいカードを使用する必要があります。',
            ],
            'canceled' => [
                'description' => 'リクエストはキャンセルされました',
                'next_steps' => '顧客は新しいリクエストを行う必要があります。',
            ],
            'failed' => [
                'description' => 'リクエストに失敗しました',
                'next_steps' => '顧客は新しいリクエストを行う必要があります。',
            ],
            'waiting_for_payment' => [
                'description' => '支払い待ちのリクエストです',
                'next_steps' => '顧客は支払いを確認する必要があります。',
            ],
            'requires_capture' => [
                'description' => 'リクエストは確認待ちです',
                'next_steps' => '顧客は操作を承認する必要があります。',
            ],
            'refunded' => [
                'description' => '支払いが返金されました',
                'next_steps' => '支払いは正常に返金されました。',
            ],
            'partially_refunded' => [
                'description' => '支払いが一部返金されました',
                'next_steps' => '支払いは一部返金されました。',
            ],
            'processing' => [
                'description' => '支払い処理中です',
                'next_steps' => '処理結果をお待ちください。',
            ],
        ],
    ]
];
